// Keyboard.inc
// The keyboard
// To reduce rendering time, the keys do not have labels, and are very simple shapes

#ifndef(included)
	#include "units.inc"
	#include "colors.inc"
	#include "textures.inc"
	#include "woods.inc"
	#include "RoboMacs.inc"
#end

#local _key = prism{
	linear_spline
	conic_sweep
	.9, 1
	4
	<-.375,-.375>*in,<-.375,.375>*in,<.375,.375>*in,<.375,-.375>*in
	scale <1,-10*.5*inch,1>
}
	
#local group4 = union{
	object{_key}
	object{_key translate -x*.75*in}
	object{_key translate -x*1.5*in}
	object{_key translate -x*2.25*in}
}

#local group3 = union{
	object{_key}
	object{_key translate -x*.75*in}
	object{_key translate -x*1.5*in}
}

#declare KeyTexture = texture{
	pigment{rgb <.8,.8,.8>}
	finish{
		ambient 0 //.05
		diffuse .8
		specular .2
		roughness .5
	}
}		

#declare KeyFrame = union{
	box{<-10,0,-3.5>*in,<10,1,3.5>*in}
	cylinder{<-10,.5,3.5>*in,<10,.5,3.5>*in,.5*in}
	pigment{rgb <.5,.5,.5>}
	finish{
		ambient 0
		diffuse .8
		specular .2
		roughness .5
	}
}

#declare FunctionRow = union{
	object{group3 translate x*-13.0*in}
	object{group4 translate x*-9.5*in}
	object{group4 translate x*-6*in}
	object{group4 translate x*-2.5*in}
	object{_key translate x*-1.125*in}
}

#declare NumberRow = union{
	#local counter = 0;
	#while(counter < 14)
		object{_key translate (-x)*(1.125+(counter*.75))*in}
		#local counter = counter + 1;
	#end
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.625,-.375>*in,<-.625,.375>*in,<.625,.375>*in,<.625,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*11.375*in
	}
}

#declare QWERow = union{
	#local counter = 0;
	#while(counter < 13)
		object{_key translate (-x)*(1.875+(counter*.75))*in}
		#local counter = counter + 1;
	#end
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.5625,-.375>*in,<-.5625,.375>*in,<.5625,.375>*in,<.5625,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*1.3125*in
	}
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.5625,-.375>*in,<-.5625,.375>*in,<.5625,.375>*in,<.5625,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*11.375*in
	}
}

#declare ASDRow = union{
	#local counter = 0;
	#while(counter < 11)
		object{_key translate (-x)*(2.375+(counter*.75))*in}
		#local counter = counter + 1;
	#end
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.625,-.375>*in,<-.625,.375>*in,<.625,.375>*in,<.625,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*1.375*in
	}
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.875,-.375>*in,<-.875,.375>*in,<.875,.375>*in,<.875,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*11*in
	}
}

#declare ZXCRow = union{
	#local counter = 0;
	#while(counter < 10)
		object{_key translate (-x)*(3.0000+(counter*.75))*in}
		#local counter = counter + 1;
	#end
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.9375,-.375>*in,<-.9375,.375>*in,<.9375,.375>*in,<.9375,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*1.6875*in
	}
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-1.125,-.375>*in,<-1.125,.375>*in,<1.125,.375>*in,<1.125,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*10.875*in
	}

}

#declare BottomRow = union{
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.5625,-.375>*in,<-.5625,.375>*in,<.5625,.375>*in,<.5625,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*11.375*in
	}
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.5625,-.375>*in,<-.5625,.375>*in,<.5625,.375>*in,<.5625,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*8.875*in
	}
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.5625,-.375>*in,<-.5625,.375>*in,<.5625,.375>*in,<.5625,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*3.75*in
	}
	prism{
		linear_spline
		conic_sweep
		.9, 1
		4
		<-.5625,-.375>*in,<-.5625,.375>*in,<.5625,.375>*in,<.5625,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*1.3125*in
	}
	prism{ //Space bar
		linear_spline
		conic_sweep
		.9, 1
		4
		<-2.125,-.375>*in,<-2.125,.375>*in,<2.125,.375>*in,<2.125,-.375>*in
		scale <1,-10*.5*inch,1>
		translate (-x)*6.3125*in
	}

}

#declare Keypad = union{
	object{group4 translate x*-16*in+z*-1*in}
	object{group3 translate x*-16*in+z*-.25*in}
	object{group3 translate x*-16*in+z*.5*in}
	object{group3 translate x*-16*in+z*1.25*in}
	object{_key   translate x*-17.5*in+z*2*in}
	object{_key   scale <2,1,1> translate x*-16.375*in+z*2*in}
	object{_key   scale <1,1,2> translate x*-18.25*in+z*.125*in}
	object{_key   scale <1,1,2> translate x*-18.25*in+z*1.625*in}
}

#declare Arrows = union{
	object{group3 translate x*-13.0*in+z*-1*in}
	object{group3 translate x*-13.0*in+z*-.25*in}
    object{_key   translate x*-13.75*in+z*1.25*in}
	object{group3 translate x*-13.0*in+z*2*in}
}

#declare KeyLights = union{
	sphere{<-6.375,1,-2.25>*in,(2/16)*in pigment{rgb <.2,1,.2>}	finish{ambient .9 diffuse 0 specular .2 metallic}}
	sphere{<-7.375,1,-2.25>*in,(2/16)*in pigment{rgb <.1,.5,.1>} finish{ambient 0 diffuse 0 specular .4 metallic}}
	sphere{<-8.375,1,-2.25>*in,(2/16)*in pigment{rgb <.1,.5,.1>} finish{ambient 0 diffuse 0 specular .4 metallic}}
	no_shadow
}

#declare Keyboard = union{
	object{KeyFrame}
	object{FunctionRow translate <10,5.9,-2.25>*in}
	object{NumberRow   translate <10,5.9,-1.00>*in}
	object{QWERow      translate <10,5.9,-0.25>*in}
	object{ASDRow      translate <10,5.9, 0.50>*in}
	object{ZXCRow      translate <10,5.9, 1.25>*in}
	object{BottomRow   translate <10,5.9, 2.00>*in}
	object{Keypad      translate <10,5.9, 0.00>*in}
	object{Arrows      translate <10,5.9, 0.00>*in}
	object{KeyLights}
	texture{KeyTexture}
}

#ifndef(included)
	camera{location <.5,2,1>*feet look_at 0}
	light_source{<1,2,2>*mile 1}
	object{Keyboard}
	plane{y, 0 texture{T_Wood14 scale feet}}
#end