// LeftArm.inc
//	The computer's left arm

#ifndef(included)
	#include "colors.inc"
	#include "textures.inc"
	#include "woods.inc"
	#include "metals.inc"
	#include "units.inc"
	#include "RoboText.inc"
	#include "RoboMacs.inc"
	#declare LeftArmBasePos = y*9.5*in;
	#declare StartMovingTime = 1
	#declare StopMovingTime = 1;
	#declare StartFoldingTime = 4;
	#declare MoveTime = StopMovingTime-StartMovingTime;
#end

#declare JointTexture = Gold1
#declare ArmTexture = texture{T_Chrome_4C finish{ambient 0}}

//Splines take care of moving the arms -- specify angles, heights, etc

#declare LeftArmBaseSpline = spline{
	//Positive number rotates up
	cubic_spline
	0, -155,
	StartMovingTime, -155,
	StartMovingTime+(MoveTime/4), -155,
	StartMovingTime+(3*MoveTime/4), -180,
	StartMovingTime+MoveTime-.001, -194,
	StartMovingTime+MoveTime, -184,
}
 
#declare LeftUpperArmSpline = spline{
	//Positive number rotates forward
	cubic_spline
	0,0,
	StartMovingTime,0,
	StartMovingTime+(MoveTime/4),-45
	StartMovingTime+(3*MoveTime/4), -135,
	StartMovingTime+MoveTime-.001,-155,
	StartMovingTime+MoveTime,-155,
	
	StartFoldingTime+(2*FoldTime/5), -155,
	StartFoldingTime+(2*FoldTime/5)+.001, -155,
	StartFoldingTime+FoldTime, -165, //Almost parallel to monitor
	
} 
 
#declare LeftUpperArmScaleSpline = spline{
	cubic_spline
	0, .9,
	StartMovingTime, .9,
	StartMovingTime+(MoveTime/4),.9,
	StartMovingTime+(MoveTime/2),.5,
	StartMovingTime+(3*MoveTime/4)-.001,.8
	StartMovingTime+(3*MoveTime/4),.75
}

#declare LeftUpperArmRotateSpline = spline{
	cubic_spline
	0, 180,
}

#declare LeftLowerArmSpline = spline{
	cubic_spline
	0,65,
}

#declare LeftWristXAngle = spline{
	cubic_spline
	0, 90,
}

#declare LeftWristYAngle = spline{
	cubic_spline
	0, 0,
}

#declare LeftWristBend = spline{
	cubic_spline
	0, -30,
}

//Resting locations for the fingers
#declare BaseLeftIndexPosition =  <11.5,2.5,-3.5625>*in;
#declare BaseLeftMiddlePosition = <11.5,2.5,-2.8125>*in;
#declare BaseLeftRingPosition =   <11.5,2.5,-2.0625>*in;
#declare BaseLeftLittlePosition = <11.5,2.5,-1.3125>*in;
#declare BaseLeftThumbPosition =  <13,  2.5,-4.5>*in;

//Splines for the fingers
//These positions are absolute fingertip positions
#declare LeftIndexSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftIndexPosition,
}
#declare LeftMiddleSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftMiddlePosition,
}
#declare LeftRingSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftRingPosition,
}
#declare LeftLittleSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftLittlePosition,
}
#declare LeftThumbSpline = spline{
	linear_spline
	StopMovingTime, BaseLeftThumbPosition,
}


#macro Theta()
	//Find rotation for wrist by finding minimum for a truly ugly equation
	#local __theta = <0,0,0>;
	__theta
#end

//The location of the left wrist theta pivot point
	// Wrist positioning
#declare LeftWristPivot = vrotate(vrotate(vrotate(vrotate(vrotate(<0,0,0>+x*.3*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*1.2*in,x*LeftWristXAngle(clock)),y*LeftWristYAngle(clock));
	// Arm positioning
#declare LeftWristPivot = vrotate(vrotate(vrotate(vrotate(LeftWristPivot+x*12*in,y*LeftLowerArmSpline(clock))+x*14*in*LeftUpperArmScaleSpline(clock),x*LeftUpperArmRotateSpline(clock)),y*LeftUpperArmSpline(clock))+z*1.1*in,z*LeftArmBaseSpline(clock))+LeftArmBasePos;
//The up direction of the pivot point
	// Wrist positioning
#declare LeftWristUp = vrotate(vrotate(vrotate(vrotate(vrotate(<0,1,0>+x*.3*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*1.2*in,x*LeftWristXAngle(clock)),y*LeftWristYAngle(clock));
	// Arm positioning
#declare LeftWristUp = vrotate(vrotate(vrotate(vrotate(LeftWristUp+x*12*in,y*LeftLowerArmSpline(clock))+x*14*in*LeftUpperArmScaleSpline(clock),x*LeftUpperArmRotateSpline(clock)),y*LeftUpperArmSpline(clock))+z*1.1*in,z*LeftArmBaseSpline(clock))+LeftArmBasePos;
//The location of the base for the fingers
	// Wrist positioning
#declare LeftWristFinger = vrotate(vrotate(vrotate(vrotate(vrotate(vrotate(<3*in,0,0>+x*.3*in, y*Theta()),z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*1.2*in,x*LeftWristXAngle(clock)),y*LeftWristYAngle(clock));
	// Arm positioning
#declare LeftWristFinger = vrotate(vrotate(vrotate(vrotate(LeftWristFinger+x*12*in,y*LeftLowerArmSpline(clock))+x*14*in*LeftUpperArmScaleSpline(clock),x*LeftUpperArmRotateSpline(clock)),y*LeftUpperArmSpline(clock))+z*1.1*in,z*LeftArmBaseSpline(clock))+LeftArmBasePos;

#declare LeftSpheres = union{
	sphere{LeftWristPivot, .75*in pigment{rgb <0,1,0>}}
	sphere{LeftWristUp, .75*in pigment{rgb <0,0,1>}}
	sphere{LeftWristFinger, .75*in pigment{rgb <1,0,0>}}
}

//#warning concat("LeftWristFinger = ", vstr(LeftWristFinger/in,2,2),"\n") 

//Helper macro for FindJoint -- returns the joint position given two fixed points and the lengths of the 
// segments between them, with a value to multiply LeftWristUp by
#macro FindJoint(Start, End, R1, R2, Sign)
	#local _d = vlength(Start-End); //Distance between spheres
	#local _r = sqrt(-(_d+R2+R1)*(_d-R2+R1)*(_d+R2-R1)*(_d-R2-R1))/(2*_d); //Radius of circle of intersection
	#local _q = ((_d*_d)+(R2*R2)-(R1*R1))/(2*_d);
	#local _v = vnormalize(End-Start) * _q; //The position along the line between End and Start where the two spheres intersect.  This is also the direction from End to Start
	#local _p = vcross(_v, (LeftWristUp-LeftWristPivot) * Sign); // Find the vector perpendicular to the line between Start and End and LeftWristUp
	vnormalize(vcross(_p,_v)) * _r - _v + End //Find the vector perpendicular to the previous vector and the line.
	// This is the absolute 3D space joint position
#end

// Creates a finger given a base point, a point for the tip, finger thickness, and finger length
#macro Finger(Start, End, Length, Thick)
	#warning "Start and End:\n"
	#warning concat( Vstr(Start/in,2,2),"\n")
	#warning concat( Vstr(End/in,2,2),"\n")
	#local _Length = vlength(Start-End);
	//Lengths of sections of finger
	#local _Top = Length/2;
	#local _Middle = Length/3;
	#local _Tip = Length/6;
	#warning concat(str(Length/in,4,4),", ",str(_Length/in,4,4),"\n")
	//Approximate _Joint2 position from distance between Start and End
	#local _J2Theta = acos(_Length/Length)/2;  //Angle formed by joint
	#local _J2Length = _Tip*cos(_J2Theta)+_Middle*cos(_J2Theta); //Combined length of finger tip
//	#warning concat(str(_J2Theta,2,2),"\n")

	#local _handAxis = LeftWristFinger - LeftWristPivot;
    //Handle special case of Start-End being parallel to LeftWristUp
    #if(vdot(vnormalize(LeftWristUp-LeftWristPivot),vnormalize(Start-End)) = 1)
    	#local __temp = LeftWristUp;
    	#declare LeftWristUp = LeftWristFinger;
    	#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, 1);
		#if((vdot((Start-_Joint1),_handAxis)/vlength(Start-_Joint1)) > 0 ) //If finger has "snapped through" and is pointing the wrong way, fix it
			#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, -1);
//			#warning "Special Case\n"
		#end
    	#declare LeftWristUp = __temp;
	#else
		//Compute _Joint1 position by finding intersection point of 2 spheres for which 
		// length in either the positive or negative LeftWristUp direction is a maximum
		#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, 1);
		#if((vdot((Start-_Joint1),_handAxis)/vlength(Start-_Joint1)) > 0 ) //If finger has "snapped through" and is pointing the wrong way, fix it
			#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, -1);
//			#warning "Inv1\n"
		#end
	//		#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, -1);
	//	#end
	#end
//	#warning concat( str(vdot(_Joint1, z),3,3),"\n")
//	#warning concat( vstr(_Joint1/in,2,2),"\n")

//	#warning concat( vstr(_handAxis/in,2,2),"\n")

//	#warning concat( "Vector ",str(abs(vdot((End-_Joint1),_handAxis)/vlength(End-_Joint1)),3,3),"\n")

	#if((vdot((End-_Joint1),_handAxis)/vlength(End-_Joint1)) < 0 ) //If fingertip position is closer to hand along axis of hand than joint1 is,
		#local _Joint2 = FindJoint(_Joint1,End,_Middle,_Tip,-1); //invert LeftWristUp for computing Joint2 position
//		#warning "Inverted\n"
	#else
		#local _Joint2 = FindJoint(_Joint1,End,_Middle,_Tip,1); //otherwise, calculate it normally
	#end
				
	//Build finger 
	union{
		//Finger
		cylinder{Start, _Joint1, Thick texture{ArmTexture}}
		cylinder{_Joint1, _Joint2, Thick texture{ArmTexture}}
		cylinder{_Joint2, End, Thick texture{ArmTexture}}
		sphere{End, Thick texture{ArmTexture}}
		//Joints
		sphere{Start, Thick*1.1 texture{JointTexture}}
		sphere{_Joint1, Thick*1.1 texture{JointTexture}}
		sphere{_Joint2, Thick*1.1 texture{JointTexture}}
	}		
#end


#declare LeftPalm = difference{
	union{
		box{<.9*in,-.35*in,-1.2*in>,<3*in,.35*in,1.2*in>}
		cylinder{<.9*in,-.35*in,0>,<.9*in,.35*in,0>,1.2*in}
		torus{1.2*in,.35*in translate <.9*in,0,0>}
		cylinder{<.9,0,1.2>*in,<3,0,1.2>*in,.35*in}
		cylinder{<.9,0,-1.2>*in,<3,0,-1.2>*in,.35*in}
	}
	box{<.8,.3,-1.6>*in,<-.7,-.3,1.6>*in}

	texture{ArmTexture}
	rotate y*Theta()
}

#declare LeftWrist = union{
	cylinder{<-.4*in,0,0>,<.4*in,0,0>,.4*in texture{JointTexture}} //Pivot in lower arm
	union{
		//Anchor for bend section
		box{<.4,-.4,-1>*in,<1.2,.4,1>*in}
		cylinder{<1.2,0,-1>*in,<1.2,0,-.6>*in,.4*in}
		cylinder{<1.2,0,1>*in,<1.2,0,.6>*in,.4*in}
		union{
			// First bend section
			cylinder{<0,0,-.8>*in,<1,0,-.8>*in,.2*in texture{ArmTexture}}
			cylinder{<0,0,.8>*in,<1,0,.8>*in,.2*in texture{ArmTexture}}
			cylinder{<1,0,-1>*in,<1,0,-.6>*in,.3*in}
			cylinder{<1,0,1>*in,<1,0,.6>*in,.3*in}
			union{
				// Second bend section
				cylinder{<0,0,-.8>*in,<1,0,-.8>*in,.2*in texture{ArmTexture}}
				cylinder{<0,0,.8>*in,<1,0,.8>*in,.2*in texture{ArmTexture}}
				union{
					//Lower anchor for bend section
					cylinder{<0,0,-1>*in,<0,0,-.6>*in,.3*in}
					cylinder{<0,0,1>*in,<0,0,.6>*in,.3*in}
					box{<0,-.3,-1>*in,<.6,.3,1>*in}
					object{LeftPalm translate x*.3*in}
					#if(1)
						//Include fingers
						sphere{<1.2,0,1.3>*in, .35*1.1*in texture{JointTexture}}
						#declare LeftWristUp = z;
						#declare LeftWristPivot = <0,0,0>;
						#local _J1 = FindJoint(<1.2,0,1.3>*in, <2.2,-3.2,1.6>*in,2*in,1.5*in,1);
						union{
						    sphere{_J1, .35*1.1*in texture{JointTexture}}
						    cylinder{<1.2,0,1.3>*in,_J1,.35*in texture{ArmTexture}}
						    cylinder{<2.2,-2.5,1.6>*in,_J1,.35*in texture{ArmTexture}}
						    sphere{<2.2,-2.5,1.6>*in, .35*in texture{ArmTexture}}
    						scale z*-1
						}
						
						#declare LeftWristUp = y;
						#declare LeftWristFinger = x*3.3*in;
						#declare LeftWristPivot = x*.3*in;
						
						union{
							object{Finger(<3.3*in,0,1.05*in>,<3.1,-1.75,1.05>*in,3*in,.35*in) } //Index Finger
							object{Finger(<3.3*in,0,.35*in>,<3.5,-1.75,.35>*in,3.4*in,.35*in) } //Middle finger
							object{Finger(<3.3*in,0,-.35*in>,<3.1,-1.75,-.35>*in,3*in,.35*in) } //Ring finger
							object{Finger(<3.3*in,0,-1.05*in>,<2.5,-1.75,-1.05>*in,2.4*in,.35*in) } //Little finger
							scale z*-1
						}
					#end
					// Sign
					union{
					    cylinder{z*1.75*in, z*-3*in, .4*in pigment{rgb 1}}
					    union{
					        box{<-1.5,-.4,-3>*in, <3.5,.4,-4.75>*in pigment{rgb 1}}
					        text{ttf "lucon.ttf" "Damn" .205, 0 scale 2*in scale x*-1 rotate x*-90  translate x*3.25*in+z*-3.25*in pigment{rgb <0,0,0>} finish{ambient 1}}
					        translate x*-2
					    }
					    rotate z*-23
					    translate y*-.6*in+x*3.1*in
					}

					rotate z*(LeftWristBend(clock)/3)
					translate x*1*in
				}
				rotate z*(LeftWristBend(clock)/3)
				translate x*1*in
			}
			rotate z*(LeftWristBend(clock)/3)
			translate x*1.2*in
		}
		texture{JointTexture}
		rotate x*LeftWristXAngle(clock)
	}
	rotate y*LeftWristYAngle(clock)
}

//Calculate the positions of the fingers
#declare LeftFingerBinormal = -1*vcross(vnormalize(LeftWristUp-LeftWristPivot),vnormalize(LeftWristFinger-LeftWristPivot));

#declare LeftIndexBase = LeftWristFinger + LeftFingerBinormal*1.05*in;
#declare LeftMiddleBase = LeftWristFinger + LeftFingerBinormal*.35*in;
#declare LeftRingBase = LeftWristFinger + LeftFingerBinormal*-.35*in;
#declare LeftLittleBase = LeftWristFinger + LeftFingerBinormal*-1.05*in;
#declare LeftThumbBase = LeftWristPivot + vnormalize(LeftWristFinger-LeftWristPivot)*1.2*in + LeftFingerBinormal*1.3*in;
//#warning concat(vstr(<0,0,0>+LeftIndexSpline(clock)/in,2,2), "\n") 

//sphere{LeftIndexBase, .75*in pigment{rgb <1,1,0>}}
#if(0)
	#declare LeftThumb = union{
		#local __temp = LeftWristUp;
		#declare LeftWristUp = LeftWristPivot + LeftFingerBinormal;
		sphere{LeftThumbBase, .35*1.1*in texture{JointTexture}}
	
//		#warning concat(vstr(LeftThumbBase/in,2,2),",",str(vlength(LeftThumbBase-LeftThumbSpline(clock))/in,2,2),"\n")
	
		#local _J1 = FindJoint(LeftThumbBase, <0,0,0>+LeftThumbSpline(clock),2*in,1.5*in,1);
		sphere{_J1, .35*1.1*in texture{JointTexture}}
		cylinder{LeftThumbBase,_J1,.35*in texture{ArmTexture}}
		cylinder{LeftThumbSpline(clock),_J1,.35*in texture{ArmTexture}}
		sphere{LeftThumbSpline(clock), .35*in texture{ArmTexture}}
		
		#declare LeftWristUp = __temp;
	}
	
	//Create the fingers in their final positions
	#declare LeftFingers = union{
		object{LeftThumb} //Thumb uses binormal rather than Up for up
	//	#warning concat(vstr(LeftIndexBase/in,2,2),",",vstr(LeftFingerBinormal/in,2,2),",",vstr(LeftWristFinger/in,2,2),"\n")
		object{Finger(LeftIndexBase,<0,0,0>+LeftIndexSpline(clock),3*in,.35*in) } //Index Finger
		object{Finger(LeftMiddleBase,<0,0,0>+LeftMiddleSpline(clock),3.4*in,.35*in) } //Middle finger
		object{Finger(LeftRingBase,<0,0,0>+LeftRingSpline(clock),3*in,.35*in) } //Ring finger
		object{Finger(LeftLittleBase,<0,0,0>+LeftLittleSpline(clock),2.6*in,.35*in) } //Little finger
	}
#end	

//Lower arm
#declare LeftLowerArm = union{
	cylinder{<0,-.75*in,0>,<12*in,-.75*in,0>,.25*in}
	cylinder{<0,.75*in,0>,<12*in,.75*in,0>,.25*in}
	
	cylinder{<12*in,1*in,0>,<12*in,-1*in,0>,.4*in texture{JointTexture}}
	
	object{LeftWrist translate x*12*in}
	
	texture{ArmTexture}
	rotate y*LeftLowerArmSpline(clock)
}

//Upper arm
#declare UpperLeftArm = union{
	cylinder{<0,.5*in,0>,<0,-.5*in,0>,1.2*in texture{JointTexture}}
	cylinder{<0,0,0>,<14*in,0,0>,.45*in scale x*LeftUpperArmScaleSpline(clock)}
	cylinder{<14*in*LeftUpperArmScaleSpline(clock).x,-1*in,0>,<14*in*LeftUpperArmScaleSpline(clock).x,1*in,0>,.6*in texture{JointTexture} rotate x*LeftUpperArmRotateSpline(clock)}
	object{LeftLowerArm rotate x*LeftUpperArmRotateSpline(clock) translate x*14*in*LeftUpperArmScaleSpline(clock)}
	
	texture{ArmTexture}
	rotate y*LeftUpperArmSpline(clock)
	translate z*1.1*in
}
//Shoulder pivot
#declare LeftArmBase = union{
	cylinder{<0,0,0>,<0,0,.5*in>,2*in}
	box{<1.4*in,.5*in,.5*in>,<-1.4*in,1*in,1.1*in>}
	cylinder{<0,.5*in,1.1*in>,<0,.8*in,1.1*in>,1.4*in}
	cylinder{<0,.8*in,1.1*in>,<0,1*in,1.1*in>,1.2*in}
	torus{1.2*in,.2*in translate <0,.8*in,1.1*in>}
	
	box{<1.4*in,-.5*in,.5*in>,<-1.4*in,-1*in,1.1*in>}
	cylinder{<0,-.5*in,1.1*in>,<0,-.8*in,1.1*in>,1.4*in}
	cylinder{<0,-.8*in,1.1*in>,<0,-1*in,1.1*in>,1.2*in}
	torus{1.2*in,.2*in translate <0,-.8*in,1.1*in>}

	object{UpperLeftArm}

	texture{JointTexture}
	rotate z*LeftArmBaseSpline(clock)
}

//Base
#declare LeftArm = union{
	object{LeftArmBase}
	#if(0)
		object{LeftFingers translate -1*LeftArmBasePos}
	#end
//	object{LeftSpheres translate -1*LeftArmBasePos}
}


#ifndef(included)
	#declare LeftWristPivot = vrotate(vrotate(vrotate(vrotate(<0,0,0>+x*.3*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*in,z*(LeftWristBend(clock)/3))+x*1.2*in,x*LeftWristXAngle(clock));
	#declare LeftWristPivot = vrotate(vrotate(vrotate(vrotate(LeftWristPivot+x*12*in,y*LeftLowerArmSpline(clock))+x*14*in*LeftUpperArmScaleSpline(clock),x*LeftUpperArmRotateSpline(clock)),y*LeftUpperArmSpline(clock))+z*1.1*in,z*LeftArmBaseSpline(clock))+LeftArmBasePos;
//	camera{location <2,2,2>*feet look_at y*.7*feet angle 50} //Normal view
//	camera{location 10*feet*y look_at 0 angle 40} //Top view
	camera{location 3*feet+LeftWristPivot look_at LeftWristPivot angle 10} //Follow hand
//	camera{location 10*feet*y look_at LeftWristPivot angle 10} //Top view following hand

	light_source{10*feet 1}
	object{LeftArm translate LeftArmBasePos}
	plane{y, 0 texture{T_Wood14 scale feet}}
#end