//resting
//by tek


//I apologise for the rather messy source! It will look slightly more tidy if you set pov's tab size to 2



//scene controls

#if ( image_width = image_height ) //i'm being very lazy, if it's drawing to a square render the height field...
	#declare HFControlRender = on;
#end
//#declare gboTestHandIntersection = on;

#declare gboFarWater	= on;
#declare gboNearWater	= on;
#declare gboIso				= on;
#declare gboNear			= on;
#declare gboMid				= on;
#declare gboFar				= on;
#declare gboTrees			= on;
#declare gboPlants		= on;


//includes

#include "rad_def.inc"
#include "functions.inc"
#include "transforms.inc"

#include "hand.inc"
#include "bottle.inc"

//global set up

global_settings {
	#ifndef (HFControlRender)
  	assumed_gamma 1
  #end
	max_trace_level 20 //the trees need a high trace level, unfortunately this means all the refracive/reflective things render really slow.
	radiosity {
		Rad_Settings(Radiosity_OutdoorLQ, on, on)
	}
	#ifdef (HFControlRender)
//		hf_gray_16 //worldmachine can't import this!!
	#end
}

#default { pigment { rgb 1 } finish { diffuse 1 ambient 0 } }


//v nice "2 halves" style image.
/*
#declare vBasePos = <1.5,-.5,10>;
#declare vBaseRot = 45*y;
*/


//"hillside" shot.
//note: symmetry diguised if seperation is high
#declare vBasePos = <1.2,-2,15>;
#declare vBaseRot = 45*y;
//FRIG
#declare vBasePos = vrotate( vBasePos, 10*x );

//"3 quarter" shot.
//note: symmetry diguised if seperation is high
/*
#declare vBasePos = <.8,-.5,15>;
#declare vBaseRot = 40*y;
*/

//flat shot
/*
#declare vBasePos = <.1,-.5,30>;
#declare vBaseRot = 0*y;
*/

/*
//flat shot (facing)
#declare vBasePos = <4,-.5,30>;
#declare vBaseRot = 170*y;
*/



//these don't affect the positions within the shot, just the actual size.
#declare fScaleNear = .04;//.025; //scaled so the glass holds around 330ml. Which is the size of a can of coke in the UK! :)
#declare fScaleFar = 2;	//water falls are about 4m tall.

#declare fNearX = vBasePos.x*fScaleNear - 3;
#declare fNearY = vBasePos.y*fScaleNear;
#declare fNearZ = (vBasePos.z)*fScaleNear+1;

#declare fFarX = (vBasePos.x+3)*fScaleFar;
#declare fFarY = vBasePos.y*fScaleFar;
#declare fFarZ = (vBasePos.z-3)*fScaleFar;


//some other bits and bobs.
#macro m_RiverPosition()
	translate -.5
	scale <150,20,150>/2
	rotate -20*y
	translate <-5,-6,55>
#end

#macro m_RiverPositionInv()
	translate -<-5,-6,55>
	rotate 20*y
	scale 2/<150,20,150>
	translate .5
#end




//textures

#declare pRock =
	pigment {
		//colour it to match the normal
		granite
		poly_wave .2
		scale 4
		turbulence .3
		octaves 2
		pigment_map {
			[0	rgb 0]
			[1	//rgb 1]
				spotted
				scale <.1,.3,.1>/4
				rotate <99,999,9999>
				colour_map {
					[0	rgb <.5,.53,.6>*.5]
					[1	rgb <.5,.53,.6>*.3]
				}
			]
		}
	}

#declare fRock =
	finish {
		//wet look
		specular 1 roughness .004
	}

#declare nRock =
	normal {
		granite 1
		poly_wave .5
		scale 4
		turbulence .3
		octaves 2
	}

#declare tRock =
	texture {
		pigment {
			pRock
		}
		finish {
			fRock
		}
	}

#declare tRockNorm =
	texture {
		pigment {
			pRock
		}
		finish {
			fRock
		}
		normal {
			nRock
		}
	}

#declare tMud =
	texture {
		spotted
		texture_map {
			[.2
				//mud
				pigment { rgb <.05,.025,.02> }
				finish {
					specular .8 roughness .005
				}
				normal {
					granite -1
					scale .1
				}
			]
			[1
				//plantmatter
				pigment {
					crackle
					solid
					scale .1
					poly_wave 1.4
					colour_map {
						//[0 rgb <.09,.07,.01>]
						[0 rgb <.1,.03,.004>]
						[1 rgb <.03,.15,.04>]
					}
				}
				finish {
					specular .8 roughness .005
				}
			]
		}
	}

#declare tWierdMetal =
	texture {
		pigment { rgb 1 }
		finish {
			specular 3 roughness .002
			diffuse .02
			irid { .5 thickness .5 turbulence 1 }//.5 }
			reflection { .1, .6 metallic falloff 2 exponent 2 }
		}
//		normal { bumps .2 scale <1,.3,1>*.005 /*warp { turbulence .3 }*/ rotate <3,50,70> }
		//normal { bumps .2 scale <1,.3,1>*.005 warp { turbulence 5 } rotate <3,50,70> }
		normal { spotted 3 scale .04 /*scale <1,.3,1>*.005*/ warp { turbulence 20 } rotate <3,50,70> }
	}


#declare fPlastic =
	finish {
		diffuse 1
		brilliance 2
		specular 1.5
		roughness .002 //very smooth plastic
		reflection { 0, .6 falloff 1.5 exponent 0.8 }
	}
	

#declare mDrinkInterior =
	interior {
		ior 1.33
	} //interior

#declare mDrink =
	material {
		texture {
			pigment { rgbt 1 }
			finish {
				reflection { 0, 1 fresnel exponent .5 }//.5 falloff 2 exponent .5 }
				conserve_energy
			}
		}
		interior {
			mDrinkInterior
		}
	}

#declare mDrinkPour =
	material {
		texture {
			pigment { rgbt 1 }
			finish {
				reflection { 0, 1 fresnel exponent .5 }//.5 falloff 2 exponent .5 }
				conserve_energy
			}
			normal {
				bumps .1 scale <1,1,.1>
			}
		}
		interior {
			mDrinkInterior
		}
	}


#declare mDrinkNoSurface =
	material {
		texture {
			pigment { rgbt 1 }
		}
		interior {
			mDrinkInterior
		}
	}


#declare mWaterFall =
	material {
		texture {
			pigment {
				//gradient y
				function {
					min( max( y, 0 ), 1 )
				}
				turbulence .3 //.4

				scale <.1,2,.01>

				poly_wave .3
				colour_map {
					[0 rgb 2] //higher than 1 to simulate refractions and reflections from tiny droplets. (i.e. "cause it looked right")
					[1 rgbt 1]
				}
			}
			finish {
				/*reflection { 0, 1 fresnel exponent .8 }//.5 falloff 2 exponent .5 }
				conserve_energy
				specular 1 roughness .003*/
				reflection { 0, 1 fresnel }
				conserve_energy
				specular 1 roughness .003
			}
			normal {
				bumps .1 scale <.3,.3,.03>
			}
		}
		interior {
			ior 1.33
			fade_colour rgb <.08,.1,.05>//<0,.1,.1>
			fade_power 2
			fade_distance .1
		}
	}


#declare mBigWater =
	material {
		texture {		
			pigment {
				rgbt 1 //z+y/2 transmit .96
			}
			finish {
				reflection { 0, 1 fresnel }//exponent .5 }//.5 falloff 2 exponent .5 }
				conserve_energy
				specular 1 roughness .003
			}
		} //texture
		interior {
			ior 1.33
			fade_colour rgb <.08,.1,.05>//<.3,.1,0>//<0,.1,.1>
			fade_power 2
			fade_distance .1
		}
	}


#declare mGlass =
	material {
		texture {
			pigment { rgbt 1 }
			finish {
				reflection { 0, 1 fresnel exponent .5 } conserve_energy
				//reflection .5//{ 0, .5 falloff 2 exponent .5 } conserve_energy
				specular 2 roughness .002
			}
		}
		interior {
			ior 1.5
		}
	}



#declare f_Curve =
	function (d,s) {
		1 / (1+d/(200*pow(s,-.2)))
	}

#declare f_DistCurve =
	function (x,y,z,s) {
		f_Curve(x*x+y*y+z*z,s)
	}

#declare f_Lerp =
	function (fA,fB,fI) {
		fA*fI + fB*(1-fI)
	}
	
#declare f_HeightControl =
		function {
			(
				f_Lerp(
				(
					f_DistCurve(x-fNearX,0,z-fNearZ,fScaleNear)
				  -f_DistCurve(x-fFarX,0,z-fFarZ,fScaleFar)
				),
				0.35, //value to have on the ridge
				1//(1 - 1/((x+30-z)*(x+30-z)/9 + 1))
				)
			)*.5 + .5
		}

#declare pHeightControl =
	pigment {
		function { f_HeightControl(x,y,z) }
		
		colour_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}

#declare pRiverShape =
	pigment {
		image_map {
			tga "rivershape.tga"
			once
			transmit all 0
		}
		rotate x*90
		m_RiverPosition()
	}

#declare f_RiverShape =
	function { pigment { pRiverShape } }

#declare fRiverEdgeThreshold = .87;//.92;


//objects

#declare vMidGroundScale = <300,1,300>;
#declare vMidGroundPos = <-150,0,-100>;

#ifndef (HFControlRender)

#declare oMidGround =
	#declare oHF =
		height_field {
			
	/*		#declare fMidGroundPosX = vMidGroundPos.x;
			#declare fMidGroundPosZ = vMidGroundPos.z;
			#declare fMidGroundScaleX = vMidGroundScale.x;
			#declare fMidGroundScaleZ = vMidGroundScale.z;
			
			function 512,512 {
				f_HeightControl( x*fMidGroundScaleX + fMidGroundPosX, 0, (1-y)*fMidGroundScaleZ + fMidGroundPosZ )
				+ f_noise3d( x*fMidGroundScaleX + fMidGroundPosX, 0, y*fMidGroundScaleZ + fMidGroundPosZ )*.05
			}*/
			tga "wmland.tga"
			smooth
			
			scale vMidGroundScale
			translate vMidGroundPos
		}
		
	union {
		object {
			oHF
			
			//correct the height to fit with what we want.
			#declare fHeightNear = vdot(y,trace( oHF, <fNearX,10000,fNearZ>, -y ));
			#declare fHeightFar = vdot(y,trace( oHF, <fFarX,10000,fFarZ>, -y ));
			#declare fHeightRange = abs(fHeightNear - fHeightFar);
			#declare fHeightMin = min(fHeightNear, fHeightFar);
			
	//		#declare fTargetHeightRange = abs((fNearY-.5) - (fFarY-2));
	//		#declare fTargetHeightMin = min(fNearY-.5, fFarY-2);
			#declare fTargetHeightRange = abs((fNearY-1) - (fFarY-1));
			#declare fTargetHeightMin = min(fNearY-1, fFarY-1);
	
			translate -y*fHeightMin
			scale y*fTargetHeightRange/fHeightRange + x+z
			translate y*fTargetHeightMin
		}
		height_field {
			tga "riverbank.tga"
			smooth
			bounded_by {
				box {
					y*.06, 1
				}
			}
			m_RiverPosition()
		}

		texture {
			gradient y
			scale 1000
			translate -500
			warp { turbulence .3 }
			texture_map {
				[(fFarY-.4+500)/1000 tRockNorm scale 1/1000] //under lake
				[(fFarY+.4+500)/1000
					slope { y, .5, 1 }
					scale 1/1000
					texture_map {
						[0	tRockNorm]
						[.4	tRockNorm]
						[.6	tMud]
					}
				]
			}
			//m_RiverPositionInv()
		}
	}

#declare oRiverSurface =
	intersection {
		height_field {
			function 256,256 {
				sin(-y*6*2*pi)*.3+sin(x*70*2*pi)*.05+sin(x*60*2*pi+y*8*2*pi)*.05
				+.4
			}

			scale <1,1/50,1>
		}
		height_field {
			tga "rivershape.tga"
			translate -fRiverEdgeThreshold*y
			scale <1,-100,1>
		}

		translate .65*y//.62*y
			
		no_reflection
		hollow on

		m_RiverPosition()

		material { mBigWater }
/*		texture {		
			function { f_RiverShape(x,y,z).red }
			texture_map {
				[fRiverEdgeThreshold
					pigment {
						rgb 1 transmit 1
					}
					finish {
						reflection 0
						specular 0
						phong 0
					}
				]
				[fRiverEdgeThreshold
					pigment {
						rgb z+y/2 transmit .96
					}
					finish {
						reflection { 0, .5 falloff 2 exponent .5 }
						conserve_energy
						specular 1 roughness .01
					}
				]
			} //texture_map
		} //texture*/
	} //height_field



#declare oBalcony =	
	#declare vBalconyDimHalf = <5,1.5,3>;
	union {
		//concrete ground
		intersection {
			height_field {
				function 800, 480 {
					pigment {
						bumps turbulence .7 scale .02/vBalconyDimHalf
					}
				}
				smooth
				translate <-.5,-1,-.5>
				scale <2,.015,2>
				translate y
			}
			box { -1, 1 }
			scale vBalconyDimHalf
			pigment { rgb .5 }
			normal { bumps -1 turbulence .7 scale .02 }
		}
		//fence
		#declare oFencePost =
			union {
				cylinder {
					y, -y, 1
					scale <.05,.5,.05>
					translate <0, vBalconyDimHalf.y + .4, 0>
					texture {
						pigment { rgb <.03,.08,.4> }
						finish {
							diffuse .7
							specular .8 roughness .02
							reflection { 0, 1 falloff 2.8 }//exponent .5 }
						}
						normal { bumps .15 scale .01 }
					}
				}
				union {
					sphere { 0, 1 }
					torus { .8, .2 translate -.7*y }
					scale .06
					translate <0, vBalconyDimHalf.y + .9, 0>

					texture { tWierdMetal }
				}
			}
		#declare oFenceWire =
			union {
				torus {
					.015,.005
					rotate -92*x
					translate -.93*x
				}
				torus {
					.015,.005
					rotate -87*x
					translate .93*x
				}
				cylinder {
					-.93*x, .93*x, .007
					pigment { rgb .5 }
					finish { specular .5 roughness .01 }
					normal {
/*						spiral1 3, 3
						poly_wave .5
						scale .03
						rotate 90*y*/
						average
						normal_map {
							[1
								spiral1 6, 3
								poly_wave .5
								scale .03
								rotate 90*y
							]
							[1
								spiral1 30, 1
								poly_wave .5
								scale .015
								rotate 90*y
							]
						}
					}
				}
			}
		#declare oFenceSeg =
			union {
				object { oFenceWire translate <0, vBalconyDimHalf.y + .4, 0> }
				object { oFenceWire scale <-1,1,1> translate <0, vBalconyDimHalf.y + .75, 0> }
			}

		#local fX = -vBalconyDimHalf.x;
		#local boPost = true;
		#local rsRot = seed(23);
		#while ( fX <= vBalconyDimHalf.x )
			
			#if ( boPost )
				object {
					oFencePost
					rotate rand(rsRot)*360*y
					translate <fX,0,vBalconyDimHalf.z-.1>
				}
			#else
				object {
					oFenceSeg
					translate <fX,0,vBalconyDimHalf.z-.1>
				}
			#end
			
			#local boPost = !boPost;
			
			#local fX = fX + 1;
		#end

		rotate 30*y
		translate <fNearX,fNearY-2.4,fNearZ-1.4>
	}


#if (gboTrees)
	#declare aTreeColours = array[4] {
		<.05,.3,.02>, <.15,.3,.02>, <.3,.2,.02>, <.3,.1,.02>
	}

	//scatter trees over the ground
	#declare oMidForest =
		#local rsRand = seed(2221);
		#local rsPos = seed(2424);
		union {
		
			#local nTex = 0;
			#while ( nTex < dimension_size( aTreeColours, 1 ) )
			
				mesh {
					#local vNorm = <0,0,0>;
					#local nTree = 0;
					#while (nTree <= 8000/dimension_size( aTreeColours, 1 ))
						
						#local vPos = <rand(rsPos),0,rand(rsPos)>;
						#local vPos = vPos*vMidGroundScale + vMidGroundPos;
						#local vPos = trace( oMidGround, vPos+10000*y, -y, vNorm );
			
						#local colTest = f_RiverShape(vPos.x,vPos.y,vPos.z);			
						#if ( vlength(vPos)-8 > rand(rsRand)*20	// don't block the view.
									& vPos.y > fFarY + .3
									& vNorm.y > .7
									& ( colTest.transmit = 1 | colTest.red < fRiverEdgeThreshold ) )
			
							#if ( mod(nTree,100) = 0 )
								#debug concat("nTree ", str(nTree + (nTex*8000/dimension_size( aTreeColours, 1 )),4,0), "\n")			
							#end
			
		
							triangle {
								<2*sqrt(3), 0, 0>*<4,5,4>/2 + vPos,
								<-2*sqrt(3), 0, 0>*<4,5,4>/2 + vPos,
								<0, 3, 0>*<4,5,4>/2 + vPos
								uv_vectors <2*sqrt(3), -1>, <-2*sqrt(3), -1>, <0, 2>
							}
							
						#end
					
						#local nTree = nTree + 1;
					#end
		
					hollow on
					
					uv_mapping
		
					texture {
						pigment {
							spherical
							scale 10
							warp { turbulence 4 lambda 4 }
							scale 1/10
/*							scale 3
							warp { turbulence 1 lambda 3 omega .8 }// octaves 3 }
							scale 1/3*/
							scale 2
							
							rotate <2,5,7>*nTex*200
				
							pigment_map {
//								[.4	rgb aTreeColours[ nTex ] transmit 1]
//								[.6	rgb aTreeColours[ nTex ] transmit 0]
								[.45
									spotted
									translate nTex*10
									scale .3
									colour_map {
										[0 rgb aTreeColours[ nTex ] transmit 1]
										[1 rgb aTreeColours[ mod(nTex+1, dimension_size( aTreeColours, 1 )) ] transmit 1]
									}
								]
								[.55
									spotted
									translate nTex*10
									scale .3
									colour_map {
										[0 rgb aTreeColours[ nTex ] transmit 0]
										[1 rgb aTreeColours[ mod(nTex+1, dimension_size( aTreeColours, 1 )) ] transmit 0]
									}
								]
							}
						} //pigment
						normal {
							spherical 20
							scale 10
							warp { turbulence 4 lambda 4 }
							scale 1/10
							scale 2
							
							rotate <2,5,7>*nTex*200
							
							slope_map {
								[0	<0,1>]
								[1	<1,0>]
							}
						}
					} //texture
				} //mesh

				#local nTex = nTex + 1;
			#end //while
			
		} //union
#end //	#if (gboTrees)


#if (gboPlants)
	#declare aPlantColours = array[4] {
		//<.05,.3,.05>, <.1,.3,.05>, <.3,.2,.05>, <.3,.1,.05>
		<.05,.3,.05>, <.1,.3,.05>, <.3,.2,.05>, <.05,.3,.1>
	}

	//scatter plants over the ground
	#declare oMidPlants =
		#local rsRand = seed(224);
		#local rsPos = seed(255);
		union {
		
			#local nTex = 0;
			#while ( nTex < dimension_size( aPlantColours, 1 ) )
			
				mesh {
					#local vNorm = <0,0,0>;
					#local nPlant = 0;
					#while (nPlant <= 6000/dimension_size( aPlantColours, 1 ))
						
						#local vPos = <pow(rand(rsPos),.7),0,pow(rand(rsPos),2)>;
						#local vPos = vrotate(vPos*<45,1,20>, -y*45);
						#local vPos = trace( oMidGround, vPos+10000*y, -y, vNorm );
			
						#local colTest = f_RiverShape(vPos.x,vPos.y,vPos.z);			
						#if ( vlength(vPos)-45 < rand(rsRand)*0	// less plants under trees.
									& vPos.y > fFarY// + .3
									& vNorm.y > .5
									& ( colTest.transmit = 1 | colTest.red < fRiverEdgeThreshold ) )
			
							#if ( mod(nPlant,100) = 0 )
								#debug concat("nPlant ", str(nPlant + (nTex*6000/dimension_size( aPlantColours, 1 )),4,0), "\n")			
							#end
			
		
							triangle {
								<2*sqrt(3), 0, 0>*.7*<.8,.5,.8>/2 + vPos,
								<-2*sqrt(3), 0, 0>*.7*<.8,.5,.8>/2 + vPos,
								<0, 3, 0>*.7*<.8,.5,.8>/2 + vPos
								uv_vectors <2*sqrt(3), -1>, <-2*sqrt(3), -1>, <0, 2>
							}
							
						#end
					
						#local nPlant = nPlant + 1;
					#end
		
					hollow on
					
					uv_mapping
		
					texture {
						pigment {
							spherical
							scale 5
							warp { turbulence 3*<1,.15,1> lambda 4 } //octaves 3 }
							scale 1/5
							scale 2
							
							rotate <2,5,7>*nTex*200
				
							pigment_map {
//								[.4	rgb aPlantColours[ nTex ] transmit 1]
//								[.6	rgb aPlantColours[ nTex ] transmit 0]
								[.4
									spotted
									translate nTex*10
									scale .3
									colour_map {
										[0 rgb aPlantColours[ nTex ] transmit 1]
										[1 rgb aPlantColours[ mod(nTex+1, dimension_size( aPlantColours, 1 )) ] transmit 1]
									}
								]
								[.6
									spotted
									translate nTex*10
									scale .3
									colour_map {
										[0 rgb aPlantColours[ nTex ] transmit 0]
										[1 rgb aPlantColours[ mod(nTex+1, dimension_size( aPlantColours, 1 )) ] transmit 0]
									}
								]
							}
						} //pigment
						normal {
							spherical 20
							scale 5
							warp { turbulence 3*<1,.15,1> lambda 4 } //octaves 3 }
							scale 1/5
							scale 2
							
							rotate <2,5,7>*nTex*200
							
							slope_map {
								[0	<0,1>]
								[1	<1,0>]
							}
						}
/*						pigment {
							spherical
							scale 10
							warp { turbulence 6 lambda 4 octaves 3 }
							scale 1/10
							scale 2
							
							rotate <2,5,7>*nTex*200
				
							colour_map {
								[.4	rgb aPlantColours[ nTex ] transmit 1]
								[.6	rgb aPlantColours[ nTex ] transmit 0]
							}
						} //pigment
						normal {
							spherical 30
							poly_wave .5
							scale 10
							warp { turbulence 4 lambda 4 }
							scale 1/10
							scale 2
							
							rotate <2,5,7>*nTex*200
						}*/
					} //texture
				} //mesh

				#local nTex = nTex + 1;
			#end //while
			
		} //union
#end

	

#declare oFarGround =
	height_field {
		tga "mountains.tga"
		smooth

		pigment {
			pigment_pattern {
				image_map {
					tga "mountainshape.tga"
				}
				rotate 90*x
			}
			pigment_map {
				[.3	rgb <.1,.4,.1>]
				[.5 rgb .3]
				[.7 rgb .3]
				[.8
					slope { y, .5, 1 }
					colour_map {
						[.5	rgb .3]
						[.6	rgb 1]
					}
				]
			}
		}

		translate -x
		rotate 45*y
		scale <10000,800,10000>
		translate <0,-500,500>
	}



//(note: layout of code is we start with background/lake objects and end with interior objects, with the symmetrical ones meeting in the middle)

#declare oRocks =
	isosurface {
		#local f_RockPert =
			function {
				pigment {
					granite
					poly_wave .5
					scale 4
					turbulence .3
					octaves 2
				}
			}
		function {
			f_sphere(x/.6,y/1.8,z/4,1)
			-f_RockPert(x,y,z).red*.4
		}
		max_gradient 2
		contained_by { sphere { 0, 5 } }

		hollow on
		
		texture { tRock }

		rotate 10*y
		translate <0,0,1.4>
	}


#declare oLake =
	isosurface {
		function {
			(cos(sqrt(x*x+y*y+z*z)*6)*.12
			-f_granite(x/8,y/8,z/8)*.2)/(sqrt(x*x+y*y+z*z)+1)
			+y
		}
		max_gradient 1
		contained_by { box { -<2,2,5>, <8,.5,5> } } //was disc rad 10.
		
		no_reflection
		
		translate 1*x //was x*3.6
		material { mBigWater } //TODO: replace this with the lake's material!
	}


#declare oLakeMist =
	sphere {
		0, 4
		
		scale <1.5,2,1> //there's a bug if this intersects with the refractive water, where pov thinks it's hit the outer edge of the refractive material.
		
		hollow on
		
		material {
			texture { pigment { rgbt 1 } }
			interior {
				media {
					scattering {
						5, rgb 1
						eccentricity 0
						extinction 1
					}
					
					density {
						spherical
						scale 3*.8
						turbulence .7
						lambda 4
						octaves 4
						cubic_wave
					}
				} // media
			} //interior
		} // material

		scale <.8,.6,.8>
		
		translate x
	}


#declare oLakeSplash =
	blob {
		#local rs = seed(2118);
		#local vA = <0,-9.81,0>; //gravity
		#local nDrop = 0;
		#while ( nDrop < 3000 )//10000 )//40000 )

			#local fOldToNewScale = .2;	//I changed the scale of the lake, but Ilike how the splash looked, so I want to scale it without breaking the laws of physics! i.e. gravity is still the same.
			#local fRootOldToNewScale = sqrt(fOldToNewScale);

			#local fAng = rand(rs)*2*pi;
			#local fAng = fAng + sin(fAng * 5)/8; //change distribution.
			#local vDir = <cos(fAng),0,sin(fAng)> * (1 + .1*(sin(fAng*4) + sin(fAng*5)));
			#local vPos = vDir*<1,1,2> * .3 * fScaleFar;
			#local fT = pow(rand(rs),2)*3 * fRootOldToNewScale;
			#local vPert = rand(rs)*2-1;//<rand(rs)*2-1,rand(rs)*2-1,rand(rs)*2-1>;
			#local vPert = vPert*vPert*vPert;
			#local vU = (vDir + y*2/* + vPert*.1*/) * fRootOldToNewScale * (vPert*.1 + 1) * 4;//int(pow(rand(rs),1/3)*3.999 + 1);

			//s = ut + 1/2at^2
			#local vS = vPos + vU * fT + vA*fT*fT/2;

			#if ( vS.y >= vPos.y )
				sphere {
					vS, .5*fOldToNewScale, 1 //.15*1.5*fOldToNewScale, 1.5
				}
			#end
			
		
			#local nDrop = nDrop + 1;
		#end
		
		scale 1/fScaleFar
		translate 1.2*x // + vBasePos) * fScaleFar
		
		no_shadow
		//no_reflection
		
		finish { reflection { 0/*, 1 falloff 2*/ } conserve_energy }
	}	

#macro m_Julia(nIter)
	intersection {
		julia_fractal {
			<-.7,.0,.21,.1> //<.1,.5,-.2,0>
		  slice <0,0,0,1>, 0
			quaternion //important
			sqr //important
		  max_iteration nIter
		  precision 400
		  
		  rotate 90*y
		  //rotate 90*z
		  scale <1.1,1.1,1.5>
		  
		  /*pigment {
		  	object {
		  		torus {
						1, .8/3
						rotate x*90
						//translate y*.2
					}
			  	rgb x, rgb x+y
		  	}
		  }*/
		}
		torus {
			1, .8/3
			rotate x*90
			scale <.9,1,1>
			//translate y*.2
		}
		scale <.55,1,1>*2.8
	}
#end
	
#declare oWaterFall =
	intersection {
		object { m_Julia(8) }
		box { <-.3,0,-2>, <2,2,2> scale <.55,1,1>*2.8 }
		scale <1,1,-1>
		
		hollow on
		no_reflection
		
		material { mWaterFall }
	}
	
#declare oDrinkPour =
	intersection {
		object { m_Julia(8) }
		box { <.2,0,-2>, <2,2,2> scale <.55,1,1>*2.8 }
		
		hollow on
		no_reflection

		material { mDrinkPour }
	}


#declare oDrinkSplash =
	blob {
		#local fAccuracy = .1; //modify blob accuracy.
	
		#local rs = seed(2118);
		#local vA = <0,-9.81,0>; //gravity
		#local nDrop = 0;
		#while ( nDrop < 2000 )

			#local fOldToNewScale = .2*fScaleNear/fScaleFar;
			#local fRootOldToNewScale = sqrt(fOldToNewScale);

			#local fAng = rand(rs)*2*pi;
			#local fAng = fAng + sin(fAng * 5)/8; //change distribution.
			#local vDir = <cos(fAng),0,sin(fAng)> * (1 + .2*(sin(fAng*2) + sin(fAng*3)));
			#local vPos = vDir * .4 * fScaleNear;
			#local fT = pow(rand(rs),2)*3 * fRootOldToNewScale;
			#local vPert = rand(rs)*2-1;//<rand(rs)*2-1,rand(rs)*2-1,rand(rs)*2-1>;
			#local vPert = vPert*vPert*vPert;
			#local vU = (vDir + y*3/* + vPert*.1*/) * fRootOldToNewScale * (vPert*.1 + 1) * 4;//int(pow(rand(rs),1/3)*3.999 + 1);

			//s = ut + 1/2at^2
			#local vS = vPos + vU * fT + vA*fT*fT/2;
			
			//mirror image of the lake splash
			#local vS = vS*<1,1,-1>;

			#if ( vS.y >= vPos.y )
				sphere {
					vS, .004, 0.3 // .001*1.5, 1.2 // *2, 2
					
					scale 1/fAccuracy
				}
			#end
			
		
			#local nDrop = nDrop + 1;
		#end

		scale fAccuracy

		scale 1/fScaleNear
		translate 1*x
		
		no_shadow
		//no_reflection
		
		hollow on
		
		material {
			texture {
				pigment { rgbt 1 }
				finish {
					reflection { 0, 2 falloff 2 exponent .5 }
					specular 1 roughness .01
				}
			}
			interior { ior 1.33 fade_colour rgb <0,.1,.1> fade_power 2 fade_distance .06 }
		}
		//material { mDrink }
	}	

#declare oDrinkWaves =
	isosurface {
		function {
			cos(sqrt(x*x+y*y+z*z)*6)*.12
			//-f_granite(x/8,y/8,z/8)
			+y
		}
		max_gradient 1
		contained_by { box { -<1.5,5,2>, <2.5,.2,2> } }
		
		translate 1*x
	}

#declare oDrink =
	intersection {
		cylinder {
			-y*.74*2, y*2*2, .99 //y*.8
			//pigment { rgb x+y/2 }
	
			material { mDrinkNoSurface }

			translate <1.5,-1.4,0>
		}
		object {
			oDrinkWaves
			material { mDrink }
		}
		//bubbles.
//		merge {
			#local nBubble = 0;
			#while ( nBubble < 700 )
				
				#local vPos = <rand(rs)*2*pi,pow(rand(rs),.3),pow(rand(rs),3)>; //adjust probabilities here.
				#local vPos = <cos(vPos.x),0,sin(vPos.x)>*pow(vPos.z,.5) + vPos.y*y;
				#local vPos = vPos*<.99,2.74*2,.99> - .74*2*y;
				
				#local vPos = vPos + <1.5,-1.4,0>;
				
				sphere {
					vPos, .01 + rand(rs)*.02
					inverse
					//material { mDrink }
					/*pigment { rgb 0 }
					finish { reflection { 2 exponent .5 } }*/
					pigment { rgbt 1 }
					finish {
						reflection { 0, 1.5 falloff 2 exponent .5 }
						specular 1 roughness .01
					}
				}
			
				#local nBubble = nBubble + 1;
			#end

			/*inverse
			
			material { mDrink }*/
//		}

		hollow on
		no_reflection
	}
	
#declare oGlass =
	difference {
		merge {
			cylinder { -y*.96, y*.96, 1.08 }
			torus { 1.04, .04 translate y*.96 }
			torus { 1.04, .04 translate -y*.96 }
			cylinder { -y*.92, -y, 1.04 }
		}
		merge {
			cylinder { -y*.75, y*2, 1 }
			torus { 0.96, .04 translate -y*.75 }
			cylinder { -y*.70, -y*.79, 0.96 }
		}
		
		hollow on
		//no_shadow
		//no_reflection
		
		scale (x+z)*1 + y*2
		translate <1.5,-1.4,0>
		
		material { mGlass }
	}
	
#declare oBottle =
	union {
		object {
			bottle
		
			//scale to match our old bottle.
			scale <1,-1,1>
			translate .14*y
			scale <25,25,25>
	
			material { mGlass }
		}
		//label
		object {
			bottle
			clipped_by {
				object { bottle scale .99 inverse } // leave only outer edge.
			}

			//scale to match our old bottle.
			scale <1,-1,1>
			translate .14*y
			scale <25,25,25>

			clipped_by {
				box { <-.5,-.5,0>, <.5,.5,3> scale <1,.9,1>*1.8 translate -3*y }
			}
	
			pigment {
				image_map {
					png "label.png"
					once
				}
				translate -.5
				scale <-1,.9,1>*1.8
				translate -3*y
			}
			
			translate .001*z
			
			rotate -60*y
		}
			
		hollow on
		no_reflection
		
		#ifndef (gboTestHandIntersection)
			rotate <0,0,-120>
			translate <.5,2.33,.1>
		#end
	}

#macro m_TestTrans()
	translate <0,5,0>
	rotate -90*x
	translate <0,-2,10>
#end

#declare oHand =
	object {
		hand

    //translate and size to our world
    translate -<0.0673 ,0.4135 ,-0.1503 >
    rotate -<0,-64.501,0> //yaw
    rotate -<70,0,0> //pitch
    rotate -<0,0,-42> //roll
    translate <.14,0,-.07>
    scale 7*<-1,1,1>

    //now, position relative to bottle.
    translate <0,-4,0>
    rotate 100*y

    //and move with bottle.
		#ifndef (gboTestHandIntersection)
			rotate <0,0,-120>
			translate <.5,2.33,.1>
		#end
	}

#declare oTable =
	merge {
		#local fX = 0;
		#while ( fX <= .7 )

			intersection {
				cylinder { -y, y, .7 }
				//box { -1/2, 1/2*<1,0,1> scale <(.7/5) - .03, .03*2, 5> translate fX*x }
				superellipsoid { <.2,.2> translate -y scale <.5,.5,.5> scale <(.7/5) - .03, .03, 5> translate fX*x }
				
				bounded_by { box { -1/2, 1/2*<1,0,1> scale <(.7/5) - .03, .03*2, 5> translate fX*x } }
			}

			#if ( fX > 0 )
				intersection {
					cylinder { -y, y, .7 }
					//box { -1/2, 1/2*<1,0,1> scale <(.7/5) - .03, .03*2, 5> translate -fX*x }
					superellipsoid { <.2,.2> translate -y scale <.5,.5,.5> scale <(.7/5) - .03, .03, 5> translate -fX*x }

					bounded_by { box { -1/2, 1/2*<1,0,1> scale <(.7/5) - .03, .03*2, 5> translate -fX*x } }
				}
			#end
				
			#local fX = fX + .7/5;
		#end
		intersection {
			cylinder { -.04*y, -.1*y, .63 }
			cylinder { y, -y, .55 inverse }
			bounded_by { box { -.1*y - .63*(x+z), -.04*y + .63*(x+z) } }
		}
		box {
			-1, 1
			scale <.03,.4,.03>
			translate <.6/1.4,-.4-.03,.6/1.4>
		}
		box {
			-1, 1
			scale <.03,.4,.03>
			translate <-.6/1.4,-.4-.03,.6/1.4>
		}
		box {
			-1, 1
			scale <.03,.4,.03>
			translate <.6/1.4,-.4-.03,-.6/1.4>
		}
		box {
			-1, 1
			scale <.03,.4,.03>
			translate <-.6/1.4,-.4-.03,-.6/1.4>
		}

		bounded_by { box { -2*y - .8*(x+z), .8*(x+z) } }

		translate <0,-3.401,0>*fScaleNear //touch bottom of glass
		
		texture {
			pigment { rgb <1,.9.8>*.8 }
			finish {
				fPlastic
			}
		}
	}


#declare oLogoHeight =
	intersection {
		height_field { png "locklogoheight.png" }
		box { -y, 1 }
		
		texture {
			gradient y
			texture_map {
				[.75
					pigment {
						image_map {
							png "locklogocol.png"
						}
						rotate x*90
					}
					finish {
						//glazed paint/plastic
						/*specular 1 roughness .003				
						diffuse .7
						ambient 0*/
						fPlastic
						diffuse .5
					}
				]
				[.75
					//gold
					pigment { rgb <1, .6, .1>*.1 }
					finish {
						specular .5 roughness .004 metallic .8
						reflection { .3 metallic .8 }
						diffuse .2
						ambient 0
					}
				]
			}
		}
	
		translate -.5
		scale <1,-.03,1>
	}


#declare oCopyrightText =
	text {
		ttf "ariblk.ttf"
		"www.evilsuperbrain.com"
		2,0
		translate -z
		scale <1,1,.1>
		/*pigment { rgb 0 }
		finish { specular 1 roughness .001 }*/
		pigment { rgb <1, .6, .1>*.1 }
		finish {
			specular .5 roughness .004 metallic .8
			reflection { .3 metallic .8 }
			diffuse .2
			ambient 0
		}
	}


#declare oWebText =
	text {
		ttf "ariblk.ttf"
		"(c) 2002 Tekno Frannansa"
		2,0
		translate -z
		scale <1,1,.1>
		/*pigment { rgb 0 }
		finish { specular 1 roughness .001 }*/
		pigment { rgb <1, .6, .1>*.1 }
		finish {
			specular .5 roughness .004 metallic .8
			reflection { .3 metallic .8 }
			diffuse .2
			ambient 0
		}
	}


#declare oLighter =
	//this is just on the table to reflect some of the scene :)
	union {
		intersection {
			superellipsoid { <.4,.4> scale <.025,.07,.007> }
			box { -1, 1 scale <.026,.04,.01> pigment { rgb .2 }	}
			object { oLogoHeight inverse rotate -90*x-1*y scale .017 translate <.01,-.03,-.0068> }
			object { oCopyrightText inverse rotate 90*z scale .005 translate <.0225,-.035,-.0065> }
			object { oWebText inverse rotate 90*z rotate -90*y scale .005 translate <.025-.0005,-.035,.001> }
		}
		intersection {
			superellipsoid { <.4,.4> scale <.025,.07,.007> }
			box { -1, 1 scale <.026,.04,.01> translate .08*y pigment { rgb .2 }	}
			translate -<-.025,.04,0> //hinge pos
			rotate z*0.6 //open veyr slightly
			translate <-.025,.04,0> //hinge pos
			translate .001*y //small gap to lid.
		}
		
		texture {
			finish {
				diffuse .3
				reflection .7
				specular 1 roughness .001
			}
			normal {
				//lightly brushed metal.
				dents .1
				scale <.001,.01,.01>
				rotate <45,45,45>
			}
		}

		rotate <90,140,0>
		translate .007*y
	}


//the scene
#ifndef ( gboTestHandIntersection )

union { //objects fixed to the water pour
	#if (gboIso)
		object { oRocks }
	#end
	#if (gboFarWater)
		object { oLake }
		object { oLakeSplash }
		object { oLakeMist }
		object { oWaterFall }
	#end
	rotate vBaseRot
	translate vBasePos
	scale fScaleFar
	
//	no_reflection //speed up trace.
}

union { //objects fixed to the drink pour
	#if (gboNearWater)
		object { oDrinkPour }
		object { oDrinkSplash }
		object { oDrink }
	#end
	#if (gboNear)
		object { oGlass }
		object { oBottle }
		object { oHand }
		object {
			oTable
	
			rotate 30*y
			translate <-0.97,0,-.6>*.7/1.2
	
			scale 1/fScaleNear
	
			//undo following transformations
			rotate -vBaseRot*<1,-1,1>
			rotate -180*y
		}
	#end
	rotate 180*y
	rotate vBaseRot*<1,-1,1>
	translate vBasePos*<-1,1,1>
	scale fScaleNear

//	no_reflection //speed up trace.
}

#if (gboNear)
	object {
		oLighter
		//translate z*.2
		translate <0,-3.401,0>*fScaleNear
		translate <-.24,vBasePos.y*fScaleNear,vBasePos.z*fScaleNear>
	}
	
	object { oBalcony }
	object { oTable rotate y*135 translate <-3.5,vBasePos.y*fScaleNear,1.5> }
	object { oTable rotate y*0 translate <1.5,vBasePos.y*fScaleNear,-2> }
#end //gboNear


#if (gboMid)
	//other objects
	object { oMidGround }
	//object { oNearPlants }
	//object { oGrass }
	#if (gboFarWater)
		object { oRiverSurface }
	#end
#end //gboMid

#if (gboTrees)
	object { oMidForest }
#end

#if (gboPlants)
	object { oMidPlants }
#end

/*
//texture test (looks cool!)
box {
	-3, 3
	
	translate vBasePos*fScaleFar+2*y+3*x
	
	texture { tRockNorm }
}
*/

#if (gboFar)
	object { oFarGround }
#end


#else //gboTestHandIntersection
light_group {
	intersection {
		object { oHand }
	//	clipped_by { 
			object { oBottle }// inverse }
	//	}
	/*	rotate 180*y
		rotate vBaseRot*<1,-1,1>
		translate vBasePos*<-1,1,1>
		scale fScaleNear*/
	
		m_TestTrans()
		
		pigment { rgb x }
	}
	light_source {
		(y-z)*1000,
		rgb x*2		
	}
	global_lights off
}

light_group {
	object {
		oHand
	
		m_TestTrans()
		scale 3
	}
	light_source {
		(y-z)*1000,
		rgb z
	}
	global_lights off
}

object {
	oBottle

	m_TestTrans()
	scale 9
	
	pigment { rgb 1 transmit .5 }
}
#end //gboTestHandIntersection


#else//HFControlRender

plane {
	y, -2000
	pigment { pHeightControl }
	finish { diffuse 0 ambient 1 reflection 0 specular 0 phong 0 }
}

#end //HFControlRender


/*blob {
	sphere { 6*z, 1*4, 1.15 } // *2, 2 // *4, 1.15
}*/

//cameras & environment
#ifndef (HFControlRender)

camera {
	#declare image_dim = sqrt(image_width*image_height); //kind of average dimension
	right			x*image_width/image_dim
	up				y*image_height/image_dim
	direction	z*1.2

	location 0 look_at <0,-30,100>
//	location x-z*2 look_at <0,-30,100>
//	location <50,1,10> look_at 20*z //very good view of the hill down to the lake.
//	direction z*10 location <1,1,-1>*2500 look_at 10*z
//	direction z*20 location <0,1,0>*1800 look_at 10*z
//	direction	z*2 location <4,4,-8> look_at 0 //table view

//blur might be a bad idea in this scene.
/*	aperture .0001
	focal_point (fScaleNear)*(vBasePos-2*z)
	blur_samples 20*/
}

//put some lens effects in using a sphere around the camera.
/*sphere {
	0, 1
	
	inverse
	hollow on

	pigment {
		rgb .1 transmit 1.4
	}
	finish {
		ambient 1
		reflection 0
		diffuse 0
	}
	
	scale .001
}*/

#else //HFControlRender
camera {
	orthographic
	right x*vMidGroundScale
	up z*vMidGroundScale
	direction -y
	location vMidGroundPos + vMidGroundScale/2 + 5000*y
}
#end //HFControlRender

light_source {
	<3,2,1>*10000
	rgb <1,.9,.8>
}


sky_sphere {
	pigment {
		#local fPow = .2;	
		function {
			(
				select( y, -pow(abs(y),fPow), pow(abs(y),fPow) )
			)/2 + .5
		}
		colour_map {
			//[0	rgb <1,2,3>/9]
			//[.5	rgb <3,2,1>/3]
			[.4	rgb .1]//<.1,.05,.03>]
			[.5	rgb <3,2,1>]
			[1	rgb <1,2,3>/3]
		}
	}
}

/*
difference {
	sphere { 0, 1200000 }
	sphere { 0, 1000000 }
	
	hollow on

	pigment { rgbt 1 }	
	interior {
		media {
			scattering {
				5, rgb <1,2,4>/4//<1,2,3>/3
				eccentricity .2
				extinction 1
			}

			density {
				function {
					.0003*exp( -(sqrt(x*x+y*y+z*z) - 1000000)/500 )
				}

				density_map {
					[0	rgb 0]
					[1	rgb 1]
				}
			}
		}
	}
	
	translate -1000000*y
}
*/

#debug "Parse Finished\n"
