//consider rendering this with Display_gamma=1.  Maybe the computer in moment.pov is an SGI...


#version 3.5;
#declare wallon = yes;
#declare expon = yes;
#declare goodExpLines = yes;
//remember to turn off and on area_light and smooth

#include "screen.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 14
}
//-f +UD +HTN -UR -SU

//#declare explSpot = <-.6,0,3.5>;
#declare explSpot = <.4,0,4.2>;

/*camera {
  location  <0.0, 5, -5.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}*/
Set_Camera_Location(<-1.0,5.5,-2.0> + <-1.0,0,0> + <0.5,0,0> + <0,0.4,-1.0> +1*z)
Set_Camera_Look_At(<-1.0,0,2> + <0.5,0,0> + <0,0,-1.0> + 1*z)
Set_Camera_Aspect(image_width,image_height)


light_source {
  <10,5,-10> 
  color rgb <1, 1, 1>*.75
  parallel
  area_light <.3,0,0> <0,.3,0> 5 5 circular orient adaptive 0
}


Screen_Object (
	text{ttf "arialbd.ttf" "PAUSED - Ctrl-P to continue", 0.0001, 0 scale .07 pigment{rgb <.05,.5,.05>}
	finish{ambient 1 diffuse 0}}
	, <.5,.2>, 0, true, 0.01
)

#declare margin = .02;
Screen_Object (
union{
	polygon{10, <0,0> <0,1> <1,1> <1,0> <0,0>
		<margin,margin> <margin,1-margin> <1-margin,1-margin> <1-margin,margin> <margin,margin> 
		pigment{rgbf <0,0.9,0,0.7>}finish{diffuse 0 ambient 1}
		}

	
	polygon{5 <.35,0> <.42,-0.11> <.58,-0.11> <.65,0> <.35,0>
		pigment{rgbft <0,0.9,0,0.7,0.0>}finish{diffuse 0 ambient 1}
	}
	
	cylinder{ <.43,-0.04> <.57,-0.04> .009 scale <1,1,.001> pigment{rgb <0,.4,0>} finish{diffuse 0 ambient .4}}
	//cylinder{ <-.07,-0.055> <.07,-0.055> .006 scale <1,1,.001> pigment{rgb <0,.4,0>} finish{diffuse 0 ambient .4}}
	cylinder{ <.43,-0.07> <.57,-0.07> .009 scale <1,1,.001> pigment{rgb <0,.4,0>} finish{diffuse 0 ambient .4}}
	
	disc{<-0.08,0.75,0>+<.2,-.2,0> <0,0,-1>, .025, 0 pigment{rgb <1,0,0>}finish{diffuse 0 ambient 1}}
	disc{<0.13,0.45,0>+<.2,-.2,0> <0,0,-1>, .025, 0 pigment{rgb <1,0,0>}finish{diffuse 0 ambient 1}}
	
	disc{<0.25,0.7,0>+<.2,-.2,0> <0,0,-1>, .025, 0 pigment{rgb <1,0,0>}finish{diffuse 0 ambient 1}}
	
	

	disc{<0.56,0.76,0.01>+<.2,-.2,0> <0,0,1>, .025, 0 pigment{rgb <0,1,0>}finish{diffuse 0 ambient 1}}
	disc{<0.54,0.68,0.01>+<.2,-.2,0> <0,0,1>, .025, 0 pigment{rgb <0,1,0>}finish{diffuse 0 ambient 1}}
	disc{<0.52,0.62,0.01>+<.2,-.2,0> <0,0,1>, .025, 0 pigment{rgb <0,1,0>}finish{diffuse 0 ambient 1}}
	
	disc{<0.44,0.87,0.01>+<.2,-.2,0> <0,0,1>, .025, 0 pigment{rgb <0,1,0>}finish{diffuse 0 ambient 1}}
	
	
	disc{<0.74,0.73,0.01>+<.2,-.2,0> <0,0,1>, .025, 0 pigment{rgb <0,1,0>}finish{diffuse 0 ambient 1}}
	disc{<0.76,0.67,0.01>+<.2,-.2,0> <0,0,1>, .025, 0 pigment{rgb <0,1,0>}finish{diffuse 0 ambient 1}}
	
	//<.20,0.95> <.65, 0.95> <.58, 0.4> <.27, 0.4> <.20, 0.95>
	
	scale <.2,.2,1>
}, /*<.95,1-(1.3333*.05)>*/ <1,1> ,0, true, 0.01)

Screen_Object (
	polygon{10,<0,0> <0,1> <1,1> <1,0> <0,0>
		<.10,0.95>+<.2,-.2,0> <.65, 0.95>+<.2,-.2,0> <.58, 0.55>+<.2,-.2,0>
		<.17, 0.55>+<.2,-.2,0> <.10, 0.95>+<.2,-.2,0>
		
		 scale <.2,.2,1>
		pigment{rgbft <0,0.9,0,0.4, 0.5>}finish{diffuse 0 ambient 1}
		//translate x*-.01
	}, <1,1>, 0, true, 0.001)

Screen_Object (
union{
	polygon{5 <-1,0> <-1, 0.02> <1,0.02> <1,0> <-1,0> pigment{rgbft <0,0.9,0,0.7,0.0>} finish{diffuse 0 ambient 1} }
	polygon{5 <-.15,0> <-.08,-0.11> <.08,-0.11> <.15,0> <-.15,0>
		pigment{rgbft <0,0.9,0,0.7,0.0>}  finish{diffuse 0 ambient 1}
	} 
	cylinder{ <-.07,-0.04> <.07,-0.04> .009 scale <1,1,.001> pigment{rgb <0,.4,0>} finish{diffuse 0 ambient .4}}
	//cylinder{ <-.07,-0.055> <.07,-0.055> .006 scale <1,1,.001> pigment{rgb <0,.4,0>} finish{diffuse 0 ambient .4}}
	cylinder{ <-.07,-0.07> <.07,-0.07> .009 scale <1,1,.001> pigment{rgb <0,.4,0>} finish{diffuse 0 ambient .4}}
	scale <.2,.2,1>
	
}, <.7,1>, 0, true, 0.01
)


Screen_Object (
union{
	polygon{5 <-1.25,0> <-1.25, 0.02> <1.25,0.02> <1.25,0> <-1.25,0> pigment{rgbft <0,0.9,0,0.7,0.0>} finish{diffuse 0 ambient 1} }
	polygon{5 <-.15,0> <-.08,-0.11> <.08,-0.11> <.15,0> <-.15,0>
		pigment{rgbft <0,0.9,0,0.7,0.0>} finish{diffuse 0 ambient 1}
	}
	cylinder{ <-.07,-0.04> <.07,-0.04> .009 scale <1,1,.001> pigment{rgb <0,.4,0>} finish{diffuse 0 ambient .4}}
	//cylinder{ <-.07,-0.055> <.07,-0.055> .006 scale <1,1,.001> pigment{rgb <0,.4,0>}finish{diffuse 0 ambient .4}}
	cylinder{ <-.07,-0.07> <.07,-0.07> .009 scale <1,1,.001> pigment{rgb <0,.4,0>}finish{diffuse 0 ambient .4}}
scale <.2,.2,1> 
}
, <.1,1>, 0, true, 0.01 )

/*Screen_Object (
	box{<-1,0,0> <1,.35,0> pigment{rgb <.2,.2,.2>} finish {ambient 1 diffuse 0}}
	, <0, 0>, 0, true, 0.01
	)*/
	#declare rd = .02;
/*Screen_Object (
union{
	sphere_sweep{ linear_spline
		5
		<image_width/image_height - rd,.35 - rd>, rd,
		<rd,.35 - rd>, rd,
		<rd,rd>, rd,
		<image_width/image_height - rd,rd>, rd,
		<image_width/image_height - rd,.35 - rd>, rd
		
		
		
	}
	box{<image_width/image_height - rd,.35 - rd, -rd> <rd,rd,0>}
	pigment{rgb <.7,.7,.7>}
}

	, <0,0>, 0 true, 0.01 )*/
Screen_Object(

polygon{10,
	<0.00,0.00>
	<0.05,-0.06>
	<0.02,-0.05>
	<0.01,-0.08>
	<0.00,0.00>
	
	<0.005,-0.015>
	<0.043,-0.054>
	<0.015,-0.045>
	<0.01,-0.07>
	<0.005,-0.015>
	pigment{bozo scale .03 pigment_map{[0 rgbf <0,0.8,0,.5>] [1 rgbf <.4,.7,.1,.5>]}
	}
}
, <.28,.5>, 0, true, 0.01)

#macro healthbar(selCirRad,ht,rm,rmy)

#local gG = pigment{ gradient y scale 0.1 pigment_map{
	[0.0 rgb <0,1,0>]
	[0.78 rgb <0.4,0.7,0>]
	[0.78 rgb <0,0,0>]
	[1.0 rgb <0,0,0>]
	}
}

#local yG = pigment{ gradient y scale 0.1 pigment_map{
	[0.0 rgb <1,1,0>]
	[0.78 rgb <0.5,0.5,0>]
	[0.78 rgb <0,0,0>]
	[1.0 rgb <0,0,0>]
	}
}

#local eG = pigment{ gradient y scale 0.1 pigment_map{
	[0.0 rgbf <1,1,1,1>]
	[0.78 rgbf <1,1,1,1>]
	[0.78 rgbf <0,0,0,0>]
	[1.0 rgbf <0,0,0,0>]
	}
}

union{
#local point = vrotate(<-selCirRad,0,0>,<0,-5,0>);

	polygon{ 4 <-.08,ht/2> <0,ht/2+.05> <0,ht/2-.05> <-.08,ht/2> pigment{rgbf <0,0.8,0,.2>} finish{diffuse 0 ambient 1}}
	
#local point = vrotate(<-selCirRad,0,0>,<0,-15,0>);
	cylinder{<0.04,0,0.04> <0.04,ht,0.04> 0.015 translate point pigment{rgbt <0,0,0,0.5>} finish{diffuse 0 ambient 0}}
	box{<-0.04,0,-0.04><0.04,rm,0.04> translate point pigment{gG} finish{diffuse 0 ambient 1}}

	box{<-0.04,rm+0.0001,-0.04><0.04,ht,0.04> translate point pigment{rgbf 1} finish{diffuse 0 ambient 1} interior_texture{pigment{eG} finish{diffuse 0 ambient 1}}}
	//cylinder{<0,0,0> <0,rm,0> 0.045 translate point pigment{gG} finish{diffuse 0 ambient 1}}
	//cylinder{<0,rm+0.001,0> <0,ht,0> 0.045 translate point pigment{rgbf 1} finish{diffuse 0 ambient 1} interior_texture{pigment{eG} finish{diffuse 0 ambient 1}}}
	
#local point = vrotate(<-selCirRad,0,0>,<0,-33,0>);
/*	cylinder{<0.04,0,0.04> <0.04,ht,0.04> 0.015 translate point pigment{rgbt <0,0,0,0.5>} finish{diffuse 0 ambient 0}}
	box{<-0.04,0,-0.04><0.04,rmy,0.04> translate point pigment{yG} finish{diffuse 0 ambient 1}}

	box{<-0.04,rmy+0.0001,-0.04><0.04,ht,0.04> translate point pigment{rgbf 1} finish{diffuse 0 ambient 1} interior_texture{pigment{eG} finish{diffuse 0 ambient 1}}}*/
	//cylinder{<0,0,0> <0,rmy,0> 0.045 translate point pigment{yG} finish{diffuse 0 ambient 1}}
	//cylinder{<0,rmy+0.001,0> <0,ht,0> 0.045 translate point pigment{rgbf 1} finish{diffuse 0 ambient 1} interior_texture{pigment{eG} finish{diffuse 0 ambient 1}}}
	
	union{
		cylinder{<0,0,0> <0,ht*.6,0> 0.02 pigment{rgbf <0,1,0,0.5>}}
		polygon{5 <0,ht*.6> <0.3,ht*.6> <0.3,ht*.6 - .3> <0, ht*.6 -.3> <0,ht*.6> 
			pigment{
				image_map{sys "cmd_attack.bmp" interpolate 2 
					#if(rm > 0)
						filter all .8 transmit all -.1
					#else
						filter all .8 transmit all .25
					#end
					} scale 0.3 translate <0,ht*.6 -.3,0>
			}
		}
		finish{diffuse 0 ambient 1}
		rotate <0,110,0>
		translate <-selCirRad,0,0>
		rotate <0,-43,0>
	}

	union{
		cylinder{<0,0,0> <0,ht,0> 0.02 pigment{rgbf <0,1,0,0.5>}}
		polygon{5 <0,ht> <0.3,ht> <0.3,ht - .3> <0, ht -.3> <0,ht> 
			pigment{
				image_map{sys "cmd_stop.bmp" interpolate 2 filter all .8 transmit all .25} scale 0.3 translate <0,ht -.3,0>
			}
		}
		finish{diffuse 0 ambient 1}
		rotate <0,110,0>
		translate <-selCirRad,0,0>
		rotate <0,-58,0>
	}
	
	union{
		cylinder{<0,0,0> <0,ht*.6,0> 0.02 pigment{rgbf <0,1,0,0.5>}}
		polygon{5 <0,ht*.6> <0.3,ht*.6> <0.3,ht*.6 - .3> <0, ht*.6 -.3> <0,ht*.6> 
			pigment{
				image_map{sys "cmd_move.bmp" interpolate 2 filter all .8 transmit all .25} scale 0.3 translate <0,ht*.6 -.3,0>
			}
		}
		finish{diffuse 0 ambient 1}
		
		rotate <0,110,0>
		translate <-selCirRad,0,0>
		rotate <0,-72,0>
	}
	
	union{
		cylinder{<0,0,0> <0,ht,0> 0.02 pigment{rgbf <0,1,0,0.5>}}
		polygon{5 <0,ht> <0.3,ht> <0.3,ht - .3> <0, ht -.3> <0,ht> 
			pigment{
				image_map{sys "cmd_patrol.bmp" interpolate 2 filter all .8 transmit all .25} scale 0.3 translate <0,ht -.3,0>
			}
		}
		finish{diffuse 0 ambient 1}
		rotate <0,110,0>
		translate <-selCirRad,0,0>
		rotate <0,-84,0>
	}
	
	no_reflection
	no_shadow
}

#end
/*
Screen_Object(

polygon{5,
	
	<0.005,-0.015>
	<0.043,-0.054>
	<0.015,-0.045>
	<0.01,-0.07>
	<0.005,-0.015>
	pigment{bozo scale .03 pigment_map{[0 rgbf <.5,1,.5,.5>] [1 rgbf <.75,.9,.65,.5>]}
	}
}
, <.28,.6>, 0, true, 0.01)
*/


//Screen_Plane (texture{pigment{image_map{png "screen.png"}}},0.01,<0,0>, <1,.25> )


#declare clouds = 
pigment{
	bozo scale <3,1,3>*.03
	//warp{turbulence .1}
	pigment_map{
		[0.65 gradient y scale <1,2,1> translate <0,1,0>
    color_map {
    	[0.5 rgb <0.0,0.1,0.4>]
  		[0.9 rgb <0.02,0.02,0.6>]
  		
    }]
    
		//[0.7 rgb .5]
	}
}


sky_sphere {
  pigment {clouds}
}

#declare s3walk = spline{
	quadratic_spline
	-1, <-0.5,0,1.9> + <1.5,0,1.0>   //0.7 0.6
	0, <0.2,0,2.5> + <1.5,0,1.0>//1.0 0.1
	1, <1.2,0,2.6> + <1.5,0,1.0>//0.9 0.0
	
	2, <2.1,0,2.3> + <1.5,0,1.0>//0.7, 0.4
	3, <2.8,0,2.1> + <1.5,0,1.0>//0.5, 0.7
	4, <3.3,0,1.5> + <1.5,0,1.0>//0.8, 0.3
	5, <4.0,0,1.2> + <1.5,0,1.0>//1.0, 0.0
	6, <4.8,0,1.2> + <1.5,0,1.0>
	7, <5.6,0,0.8> + <1.5,0,1.0>
}


#declare s4wander = array[20];


//#declare s4wander[1] = <1.75,0,2.3>;
//#declare s4wander[2] = <2.3,0,2.3>;
#declare s4wander[0] = <3.7,0,1.4>;
#declare s4wander[1] = <3.8,0,1.7>;
#declare s4wander[2] = <4.2,0,4.7>;
#declare s4wander[3] = <4.2,0,5.3>;
#declare s4wander[4] = <3.2,0,4.9>;
#declare s4wander[5] = <2.6,0,4.5>; //meet with frozen trooper
#declare s4wander[6] = <2.1,0,6.2>;
#declare s4wander[7] = <1.2,0,6.7>;
#declare s4wander[08] = <0.6,0,7.1>;
#declare s4wander[09] = <-0.5,0,7.6>;
#declare s4wander[10] = <-1.0,0,7.1>;
#declare s4wander[11] = <-2.0,0,6.7>;
#declare s4wander[12] = <-2.6,0,5.7>;
#declare s4wander[13] = <-1.5,0,4.7>;
#declare s4wander[14] = <-0.9,0,4.5>;
#declare s4wander[15] = <-0.5,0,4.45>; //14 = stopping point
#declare s4wander[16] = <-0.2,0,4.42>;
#declare s4wander[17] = <-1,-1,-1>;


//the explosion is at  <.4,0,4.2>
#declare s4walk = spline{
	cubic_spline
#declare loop = 0;
#declare dist = 0;
#while(loop < 17)
	dist, s4wander[loop]
	#declare dist = dist + vlength(s4wander[loop+1]-s4wander[loop]);
	#declare loop = loop + 1;
#end
}

#declare maxWalk = dist - 6.4;

/*#declare loop = 0;
#while(loop < 15)
	cylinder{s4wander[loop]-y, s4wander[loop]+y, .03 pigment{rgbf <1,0,0,1>} }
	#declare loop = loop + 1;
#end*/

#declare snowyPlane = height_field{png "hf_land.png" //"hf_land_lowres.png" 
	smooth
	translate <-.5,-1,-.5> scale <25,.75,25>} 

#declare R1 = seed(0);

#declare boot = cone{<0,-.1,0>, .04, <0,.1,0>, .12 scale <2,1,1>}

#declare boot = union{
	cone{<0,-.1,0>, 0.04, <0,.1,0>, .12}
	cone{<0,-.05,0>, 0.015, <0,.05,0>, .03 translate .06*z}
	cone{<0,-.05,0>, 0.015, <0,.05,0>, .03 translate <-.02,0,-.06>}
	cone{<0,-.05,0>, 0.012, <0,.05,0>, .025 translate <-.06,0,0>}
	bounded_by{cone{<0,-.1,0>, 0.07, <0,.1,0>, .16} }
	scale <2,1,1>
}


#declare snowFin = finish{specular 0 diffuse .9 ambient <.1,.1,.2>}

difference{
	union{
		object{snowyPlane}
		intersection{
			height_field{png "hf_snowdrift.png"}
			cylinder{<0,0,0> <0,1,0> 1}
			
			rotate <0,90,0> translate <0,0,1> scale <2.02,.75,1.52> //translate <-.01,0,-.01>
			rotate <0,120,0>
			translate <1.8,-.25,1.8>
		}
	}
	#declare dist = 2.6;  //footprints in the snow
	#while(dist < 4)
		//sphere{<0,0,0> .1 scale <2,1,1> translate <.6*loop,0,0> rotate <0,30,0> translate <0,0,2>}
		#declare footprint = vrotate(<dist,0,0>,<0,30,0>) + <0,0,2>;
		#declare footprint = trace(snowyPlane,footprint+<0,10,0>, <0,-1,0>);
		object{boot rotate <0,25 + 10*rand(R1),0> translate footprint normal{granite .5}
		pigment {rgb <.998,.998,.998>} finish{snowFin}}

		#declare footprint = vrotate(<dist +.3,0,.25>,<0,30,0>) + <0,0,2>;
		#declare footprint = trace(snowyPlane,footprint+<0,10,0>, <0,-1,0>);
		object{boot rotate <0,25 + 10*rand(R1),0> translate footprint normal{granite .5}
		pigment {rgb <.998,.998,.998>} finish{snowFin}}
		
		//sphere{<0,0,0> .1 scale <2,1,1> translate <.6*loop + .3,0,.25> rotate <0,30,0> translate <0,0,2>}
		
		//first footprint spots:  vrotate(<2.6,0,0>, <0,30,0>) + <0,0,0,2>
		//                        vrotate(<2.9,0,.25>, <0,30,0>) + <0,0,0,2>
		
		
		#declare dist = dist + .5 + .2*rand(R1);
	#end
	
	#declare dist = 2.5; 
	#while(dist < 4)      /* these footprints contain the first soldier*/
		//sphere{<0,0,0> .1 scale <2,1,1> translate <.6*loop,0,0> rotate <0,30,0> translate <0,0,2>}
		#declare footprint = vrotate(<dist,0,-.8>,<0,30,0>) + <0,0,2>;
		#declare footprint = trace(snowyPlane,footprint+<0,10,0>, <0,-1,0>);
		//#if(dist > 1.9)
			object{boot rotate <0,25 + 10*rand(R1),0> translate footprint normal{granite .5}
			pigment {rgb <.998,.998,.998>} finish{snowFin}}
		/*#else
			object{boot rotate <0,-45 + 90*rand(R1),0> translate footprint 
				translate .05*y translate -.25*z*rand(R1) normal{granite .5}
			pigment {rgb <.998,.998,.998>} finish{snowFin}}
		#end*/			
		
		//#if(dist > 1.9)
			#declare footprint = vrotate(<dist +.3,0,-1.05>,<0,30,0>) + <0,0,2>;
			#declare footprint = trace(snowyPlane,footprint+<0,10,0>, <0,-1,0>);
			object{boot rotate <0,25 + 10*rand(R1),0> translate footprint normal{granite .5}
			pigment {rgb <.998,.998,.998>} finish{snowFin}}
		//#end
		
		//sphere{<0,0,0> .1 scale <2,1,1> translate <.6*loop + .3,0,.25> rotate <0,30,0> translate <0,0,2>}
		/*#if(dist < 2)
			#declare dist = dist + .4*rand(R1);
		#else*/
			#declare dist = dist + .5 + .2*rand(R1);
		//#end
	#end
	
	#declare time = 0;
	#while (time < 5.5)
		#declare ang = atan2( (s3walk(time + .05).x - s3walk(time - .05).x ), .1);
		#declare footprint = trace(snowyPlane, s3walk(time) + y*10, <0,-1,0>);
		object{boot rotate <0,ang - 5 + 10*rand(R1),0> translate footprint normal{granite .5}
		pigment {rgb <.998,.998,.998>} finish{snowFin}}		

		/*#declare ang = atan2( (s3walk(time + .35).x - s3walk(time - .35).x ), .1);
		#declare footprint = trace(snowyPlane, s3walk(time+.3) + y*10, <0,-1,0>);
		object{boot rotate <0,ang - 5 +  10*rand(R1),0> translate footprint 
			translate <sin(ang)*-.25,0,cos(-ang)*-.25>
			//translate <0,0,-.25>
			normal{granite .5}
		pigment {rgb <.998,.998,.998>} finish{snowFin}}		*/
		
		#declare time = time + .75;
	#end
	
	#declare time = 0.3;
	#while (time < 5.5)
		#declare ang = degrees(atan2( (s3walk(time + .05).x - s3walk(time - .05).x ), .1));
		#declare footprint = trace(snowyPlane, s3walk(time) + y*10, <0,-1,0>);
		object{boot rotate <0,ang - 5 + 10*rand(R1),0> translate footprint normal{granite .5}
		pigment {rgb <.998,.998,.998>} finish{snowFin} translate <-.05,0,-.25>}		

		/*#declare ang = atan2( (s3walk(time + .35).x - s3walk(time - .35).x ), .1);
		#declare footprint = trace(snowyPlane, s3walk(time+.3) + y*10, <0,-1,0>);
		object{boot rotate <0,ang - 5 +  10*rand(R1),0> translate footprint 
			translate <sin(ang)*-.25,0,cos(-ang)*-.25>
			//translate <0,0,-.25>
			normal{granite .5}
		pigment {rgb <.998,.998,.998>} finish{snowFin}}		*/
		
		#declare time = time + .55;
	#end
	
//	#debug str(maxWalk,0,-1)
//	#debug "\n\n\n"
	#declare time = .6;
	#while(time < maxWalk)
//		#debug str(time,0,-1)
//		#debug "\n"
		#declare ang = degrees(atan2(s4walk(time-.01).y - s4walk(time + .01).y,s4walk(time-.01).x - s4walk(time + .01).x));
							
		#debug concat("angle is ", str(ang,0,-1),"\n")
		#declare footprint = trace(snowyPlane, s4walk(time) + y*10, <0,-1,0>);
		object{boot rotate <0, ang,0> translate footprint normal{granite .5}
			pigment {rgb <.998,.998,.998>} finish{snowFin} }	
		
		#declare ang = degrees(atan2(s4walk(time+.29).y - s4walk(time + .31).y,s4walk(time+.29).x - s4walk(time + .31).x));
		#declare footprint = trace(snowyPlane, s4walk(time + .3) + vrotate(<.25,0,0>,<0,ang+90,0>) + y*10,<0,-1,0>);
		object{boot rotate <0, ang, 0> translate footprint normal{granite .5}
			pigment {rgb <.998,.998,.998>} finish{snowFin}}
		#declare time = time + .6;
	#end
	
	#declare maxWalk = time - .6;	
	
	#declare dist = 0;  //footprints in the snow
	#while(dist < 4)
		//sphere{<0,0,0> .1 scale <2,1,1> translate <.6*loop,0,0> rotate <0,30,0> translate <0,0,2>}
		#declare footprint = vrotate(<dist,0,0>,<0,20,0>) + s4walk(0);
		#declare footprint = trace(snowyPlane,footprint+<0,10,0>, <0,-1,0>);
		object{boot rotate <0,25 + 10*rand(R1),0> translate footprint normal{granite .5}
		pigment {rgb <.998,.998,.998>} finish{snowFin}}

		#declare footprint = vrotate(<dist +.3,0,.25>,<0,20,0>) + s4walk(0);
		#declare footprint = trace(snowyPlane,footprint+<0,10,0>, <0,-1,0>);
		object{boot rotate <0,25 + 10*rand(R1),0> translate footprint normal{granite .5}
		pigment {rgb <.998,.998,.998>} finish{snowFin}}
		
		//sphere{<0,0,0> .1 scale <2,1,1> translate <.6*loop + .3,0,.25> rotate <0,30,0> translate <0,0,2>}
		
		//first footprint spots:  vrotate(<2.6,0,0>, <0,30,0>) + <0,0,0,2>
		//                        vrotate(<2.9,0,.25>, <0,30,0>) + <0,0,0,2>
		
		
		#declare dist = dist + .5 + .2*rand(R1);
	#end
	
	
	union{
		//sphere{<0,0,0> .5 scale <1,.15,1>}
		//lines coming from explosion
#if(!goodExpLines)	
		#declare loop = 0;
		#declare R1 = seed(0);
		#declare edpt = <-1,-1,-1>;
		
		#while(loop < 30)
			#declare rotAmt = <0,rand(R1)*360,0>;
			#declare edpt = trace(snowyPlane,vrotate(<rand(R1)*.5+2,10,0>,rotAmt), <0,-1,0>)+.02*y;
			cone{<0,0,0> rand(R1)*.005 +.005 edpt .07}
			sphere{<0,0,0> .07 scale <5,1,1> rotate rotAmt translate edpt}
			#declare loop = loop+1;
		#end
		translate explSpot
#else
		#declare loop = 0;
		#declare R1 = seed(1);
		#while(loop < 25)
			#declare dir = vrotate(<0,0,.25>,<0,rand(R1)*360,0>);

			#declare lastlast = <0,0,0>;
			#declare last = <0,0,0>;
			#declare total = dir;
			#declare maxLen = rand(R1)*1.5 + .75;
		
			union{
			
			#while(vlength(total) < maxLen )

				cone{trace(snowyPlane,lastlast+<0,10,0>+explSpot,<0,-1,0>),  .07* (1-(vlength(lastlast)/maxLen) )
					trace(snowyPlane,total+<0,10,0>+explSpot,<0,-1,0>),  .07* (1-(vlength(total)/maxLen) ) translate <0,0.010,0>}
				//sphere{<1,0,-1>, .3}
				#declare lastlast = last;
				#declare last = total;
				#declare total = total + dir;
			#end
			//	bounded_by{cylinder{<0,0,0>, total, .2} }
			}
			
			//#debug vstr(3,trace(snowyPlane,total+<0,10,0>,<0,-1,0>), ", ", 0,3)
			//#debug "\n"
			#declare loop = loop + 1;
		#end
		
#end		

			
		normal{granite .5}
		pigment {rgb <.998,.998,.998>} finish{snowFin}
	}
	
	
	
	 pigment {rgb <.998,.998,.998>}
	 normal{ average normal_map{[1 granite .3 scale .6] [1 granite .15 scale .2]}}
	 finish{snowFin}
 }

//#declare foot1 = vrotate(<2.5,0,-.8>,<0,30,0>) + <0,0,2>
#declare suitTex = texture{
	pigment{rgb <.9,.9,.9>}
	//normal{spiral1 .1 scale .1}
	finish{reflection .2 specular .2 roughness .7}
}

union{  //soldier
	sphere{<0,0,0> .08 scale <2,.75,.7> translate <2.5,0,-.82> texture{suitTex}}
	sphere{<0,0,0> .08 scale <2,.75,.7> rotate <0,0,20> translate <2.8,0,-1.07> texture{suitTex}}
	cylinder{<2.56,0,-.8> <2.45,.25,-.81> .07 texture{suitTex}}
	cylinder{<2.86,0,-1.05> <2.7,.25,-1.04> .07 texture{suitTex}}
	sphere{<2.45,.25,-.81> .08 texture{suitTex}}
	sphere{<2.7,.25,-1.04> .08 texture{suitTex}}
	cylinder{<2.45,.25,-.81> <2.65,.5,-.85> .07 texture{suitTex}}
	cylinder{<2.7,.25,-1.04> <2.65,.5,-1.00> .07 texture{suitTex}}
	sphere{<0,0,0> .075 scale <1.5,1.5,2> translate <2.65,.5,-.975> texture{suitTex}}
	cylinder{<0,0,0> <0,.32,0> .075 scale <1.5,1,2> translate <2.65,.5,-.975> texture{suitTex}}
	sphere{<0,0,0> .075 scale <1.5,1.5,2> translate <2.65,.82,-.975> texture{suitTex}}
	
	sphere{<2.65,.8,-.75> .065}
	sphere{<2.65,.8,-1.1> .065}
	cylinder{<2.65,.8,-1.1> <2.55,.7, -1.05> .055}
	cylinder{<2.65,.8,-.75> <2.55,.7, -.8> .055}
	sphere{<2.55,.7,-1.05> .065}
	sphere{<2.55,.7,-.8> .065}
	cylinder{<2.4,.7,-1.00> <2.55,.7, -1.05> .055}
	cylinder{<2.4,.7,-.95> <2.55,.7, -.8> .055}
	
	sphere{<2.65,.95,-.975> .15 texture{suitTex}}
	intersection{
		sphere{<2.65,.95,-.975> .16 }
		plane{y 0 inverse rotate <0,0,20> translate <2.65,.95,0>}
		plane{y 0 rotate <0,0,-20> translate <2.65,.95,0>}
		texture{suitTex}
		pigment{rgb 0}
		finish{reflection -.5 specular .2 diffuse 0}
	}
	texture{suitTex}
	rotate <0,30,0>
	translate <0,-.195,2>
}

torus{.5, .03 scale <1,1,1>  //selection circle
	pigment{ radial pigment_map{
		//[0 rgbf <0,1,0,1>]
		//[1 rgbf <.5,.6,0,1>]
		[0 rgb <0,1,0>]
		[1 rgb <.4,.7,0>]
		
		}frequency 15
	}
	translate <2.65, .05, -.975> 
	rotate <0,30,0> translate <0,-.095,2>
	finish{ambient 1 diffuse 0}
	no_shadow no_reflection
}
object{ healthbar(.5,.8,.62,.51) translate vrotate(<2.65, .05, -.975> ,<0,30,0>)+<0,-.095,2>}
//cylinder{ <2.65

union{  //gun of some form
	cylinder{<2.4,.75,-1.025> <1.8,.8,-1.025> .06 }
	difference{
		torus{.4, .02 scale <1,6,1> }
		plane{z, 0 rotate <0,-30,0>}
		plane{z, 0 inverse rotate <0,30,0>}
		translate <2.65,.75,-1.025>
	}
	
	pigment{rgb .7}
	rotate <0,30,0>
	translate <0,-.095,2>
}

#declare lowerPart =
sphere{ <0,0,0>, .5 scale <1.5, .7, 1> }

#declare lowerPartMoved =
sphere{ <0,0,0>, .5 scale <1.5, .7, 1> rotate <0,15,0> translate <-2.5, 1.2, 2.3>}
//object{lowerPartMoved pigment{rgbf <1,0,0,0>} }

/*cone{<1.8,.8,-1.025>, 0.25, <1.8,.8,-1.025>+<-4,0.33333,0>, 0.05
	rotate <0,30,0> translate <0,-.095,2>
	pigment{rgbf <1,0,0,.5>}
}*/


cylinder{vrotate(<1.8,.8,-1.025>,<0,30,0>)+<0,-.095,2>, trace(lowerPartMoved, vrotate(<1.8,.8,-1.025>,<0,30,0>)+<0,-.095,2>, vrotate(<-4,0.33333,0>,<0,30,0>) ), 0.05 //<-2.2,0.33333+.8,-1.025> 0.05 
	//#debug vstr(3,trace(lowerPartMoved, <1.8,.8,-1.025>, <-4,0.33333,0>), ", ", 0,3)
	hollow
	pigment{rgbf <0.5,0.7,0.7,1.0>}
	finish{ambient 1 diffuse 0}
	interior{
		media{
			emission <.1,.8,.8>	
			scattering{ 1 <.8,.2,.1>}
			density{cylindrical scale .5 rotate <0,0,90> translate <0,.8,-1.025> rotate <degrees(atan(1/-12)),0,0>
				color_map{
					[0.0 rgb 0]
					[0.1 rgb .1]
					[0.7 rgb 2.8]
					[1.0 rgb 3 ]
					
				}
				
			}
			density{rgb 2.5}
		}
	}
	//rotate <0,30,0> translate <0,-.095,2>
}


		//footprint spots:  vrotate(<2.6,0,0>, <0,30,0>) + <0,0,2>
		//                  vrotate(<2.9,0,.25>, <0,30,0>) + <0,0,2>
union{  //second soldier
	//(-.8 and -1.05) --> (0 and .25)
	sphere{<0,0,0> .08 scale <2,.75,1> translate <2.58,0,0> texture{suitTex}}
	sphere{<0,0,0> .08 scale <2,.75,1> rotate <-0.02,0,20> translate <2.9,0,.25> texture{suitTex}}
	//cylinder{<2.66,0,0> <2.55,.25,0.01> .07 texture{suitTex}}
	cylinder{<2.66,0,0> <2.66,.25,0.01> .07 texture{suitTex}}
	cylinder{<2.96,0,.25> <2.8,.25,0.24> .07 texture{suitTex}}
	sphere{<2.66,.25,0.01> .08 texture{suitTex}}
	sphere{<2.8,.25,0.24> .08 texture{suitTex}}
	cylinder{<2.66,.25,0.01> <2.75,.5,0.05> .07 texture{suitTex}}
	cylinder{<2.8,.25,0.24> <2.75,.5,0.20> .07 texture{suitTex}}
	sphere{<0,0,0> .075 scale <1.5,1.5,2> translate <2.75,.5,.125> texture{suitTex}}
	cylinder{<0,0,0> <0,.32,0> .075 scale <1.5,1,2> translate <2.75,.5,.125> texture{suitTex}}
	sphere{<0,0,0> .075 scale <1.5,1.5,2> translate <2.75,.82,.125> texture{suitTex}}
	
	sphere{<2.75,.8,-.05> .065}
	sphere{<2.75,.8,.30> .065}
	cylinder{<2.75,.8,.30> <2.65,.7, .30> .055}
	cylinder{<2.75,.8,-.05> <2.65,.7, .00> .055}
	sphere{<2.65,.7,.30> .065}
	sphere{<2.65,.7,.00> .065}
	cylinder{<2.5,.75,0.25> <2.65,.7, 0.30> .055}
	cylinder{<2.5,.75,0.10> <2.65,.7, 0.00> .055}
	
	sphere{<2.75,.95,.125> .15 texture{suitTex}}
	intersection{
		sphere{<2.75,.95,.125> .16 }
		plane{y 0 inverse rotate <0,0,20> translate <2.75,.95,0>}
		plane{y 0 rotate <0,0,-20> translate <2.75,.95,0>}
		texture{suitTex}
		pigment{rgb 0}
		finish{reflection -.5 specular .2 diffuse 0}
	}
	texture{suitTex}
	rotate <0,30,0>
	translate <0,-.15,2>
}

#declare powerSource = pigment{
	bozo warp{turbulence .5} scale .02 pigment_map{
		[0.5 rgb <1,0,0>]
		[0.5 rgb <.2,0,0>]
	}
}


#declare gunTrans = transform{
	//rotate <0,-30,0>
	//translate -<0,-.15,2>
	
	translate -<2.55,0.8,0.175>
	rotate <0,-15,0>
	translate <2.55,0.8,0.175>

	rotate <0,30,0>
	translate <0,-.15,2>
}

union{ //another sort of gun...
	difference{
		cylinder{<2.55,0.8,0.175> <2.1,0.95,0.175> .04 pigment{rgb <.2,.2,.2>}}
		cylinder{<2.5501,0.8,0.175> <2.9999,0.95,0.175> .03 pigment{rgb <.2,.2,.2>}}
	}
	difference{
		cylinder{<2.55,0.85,0.175> <2.1,1.00,0.175> .04 pigment{rgb <.2,.2,.2>}}
		cylinder{<2.5501,0.85,0.175> <2.9999,1.00,0.175> .03 pigment{rgb <.2,.2,.2>}}
	}
	
	cylinder{<2.45,0.875,0.175> <2.45,0.875,-0.05> .045 pigment{rgb <.2,.2,.2>}}
	
	cylinder{<2.51,0.8,0.12> <2.52,0.9,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	cylinder{<2.47,0.805,0.12> <2.48,0.91,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	
	cylinder{<2.38,0.91,0.12> <2.39,0.93,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	cylinder{<2.34,0.92,0.12> <2.35,0.94,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	cylinder{<2.3,0.93,0.12> <2.31,0.95,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	cylinder{<2.26,0.94,0.12> <2.27,0.96,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	//rotate <0,30,0>
	//translate <0,-.15,2>
	transform{gunTrans}
}
//2.55-2.1 = 0.45   0.80-0.95 = -0.15
#declare loop = 0;
#declare R1 = seed(1);
#while(loop < 10)
	#declare loc = <2.1, 0.95, 0.175> + (rand(R1)*.4 + loop*1.7 + .3)*<-0.45,0.15,0> + mod(loop,2)*<0,0.05,0>;
	union{
		cone{loc, 0, loc + <-0.45,0.15,0>*.3, .01   pigment{rgbt <1,1,1,.5>} finish{diffuse .4 ambient .7}}
		cone{loc + <-0.45,0.15,0>*.3, .01, loc + <-0.45,0.15,0>*.6, 0   pigment{rgb <1,1,1>} finish{diffuse .4 ambient .7}}
		
		
		
		//rotate <0,30,0>
		//translate <0,-.15,2>
		transform{gunTrans}
		no_shadow
	}
	#declare loop = loop + 1;
#end

torus{.5, .03 scale <1,1,1>  //selection circle
	pigment{ radial pigment_map{
		//[0 rgbf <0,1,0,1>]
		//[1 rgbf <.5,.6,0,1>]
		[0 rgb <0,1,0>]
		[1 rgb <.4,.7,0>]
		
		}frequency 15
	}
	finish{ambient 1 diffuse 0}
	
	translate <2.75, .05, .125> 
	rotate <0,30,0> translate <0,-.095,2>	
	no_shadow no_reflection
}

object{healthbar(.5,.8,.51,.35) translate vrotate(<2.75, .05, .125>, <0,30,0>)+<0,-.095,2>}



union{  //third soldier
	//let's put the feet at <0,0,0> and <.1,0,.3>
	sphere{<0,0,0> .08 scale <2,.75,1> rotate <-0.02,0,-20> translate <0,0,0> texture{suitTex}}
	sphere{<0,0,0> .08 scale <2,.75,1> rotate <-0.02,0,-30> translate <.1,0,.3> texture{suitTex}}
	//cylinder{<2.66,0,0> <2.55,.25,0.01> .07 texture{suitTex}}
	cylinder{<.10,-.05,0> <.36,.23,0.03> .07 texture{suitTex}}
	cylinder{<.2,-.05,.3> <.36,.23,0.27> .07 texture{suitTex}}
	sphere{<.36,.23,0.03> .08 texture{suitTex}}
	sphere{<.36,.23,0.27> .08 texture{suitTex}}
	cylinder{<.36,.23,0.03> <.47,.35,0.07> .07 texture{suitTex}}
	cylinder{<.36,.23,0.27> <.47,.35,0.23> .07 texture{suitTex}}
	sphere{<0,0,0> .075 scale <1.5,1.5,2> translate <.47,.35,.15> texture{suitTex}}
	cylinder{<0,0,0> <0,.32,0> .075 scale <1.5,1,2> rotate <0,0,-18>
		translate <.47,.35,.15> texture{suitTex}}
	#declare shld = <.47,.35,.15> + vrotate(y*.32,<0,0,-18>);
	sphere{<0,0,0> .075 scale <1.5,1.5,2> translate shld texture{suitTex}}
	
	sphere{shld + <0,-.02,-0.15> .065 texture{suitTex}}   //other's shld = <2.75,.82,.125>
	sphere{shld + <0,-.02,0.15> .065 texture{suitTex}}
	cylinder{shld + <0,-.02,-0.15>, shld + <-.15,-.1,-0.3> .055 texture{suitTex}}
	cylinder{shld + <0,-.02,0.15>, shld + <-.15,-.1,0.3> .055 texture{suitTex}}
	sphere{shld + <-.15,-.1,0.3> .065 texture{suitTex}}
	sphere{shld + <-.15,-.1,-0.3> .065 texture{suitTex}}
	cylinder{shld + <-.15,-.1,0.3>, shld + <-.3,-.13,0.46> .055 texture{suitTex}}
	cylinder{shld + <-.15,-.1,-0.3>, shld + <-.35,-.15,-0.37> .055 texture{suitTex}}
	
	sphere{<0,0,0> .055 scale <1,1,1> rotate <0,30,30> translate shld + <-.3,-.13,0.46> texture{suitTex}}
	sphere{<0,0,0> .055 scale <1,1,1> rotate <0,30,30> translate shld + <-.35,-.15,-0.37> texture{suitTex}}
	
	cylinder{shld + <-.3,-.13,0.46>, shld + <-.33,-.03,0.49>, .022 texture{suitTex}} //is this one too big??
	cylinder{shld + <-.35,-.15,-0.37>, shld + <-.4,-.05,-0.33>, .022 texture{suitTex}}
	
	cylinder{shld + <-.3,-.15,0.46>, shld + <-.4,-.156,0.41>, .018 texture{suitTex}}
	cylinder{shld + <-.35,-.17,-0.37>, shld + <-.45,-.176,-0.32>, .018 texture{suitTex}}

	cylinder{shld + <-.3,-.115,0.46>, shld + <-.42,-.118,0.42>, .018 texture{suitTex}}
	cylinder{shld + <-.35,-.135,-0.37>, shld + <-.47,-.138,-0.35>, .018 texture{suitTex}}

	
	cylinder{shld + <-.3,-.08,0.46>, shld + <-.43,-.08,0.46>, .018 texture{suitTex}}
	cylinder{shld + <-.35,-.10,-0.37>, shld + <-.48,-.10,-0.37>, .018 texture{suitTex}}
	
	sphere{shld + <.06,.13,0>, .15 texture{suitTex}}
	intersection{
		sphere{<0,0,0> .16 }
		plane{y 0 inverse rotate <0,0,20> }
		plane{y 0 rotate <0,0,-20> }
		
		rotate <0,0,-53>
		texture{suitTex}
		pigment{rgb 0}
		finish{reflection -.5 specular .2 diffuse 0}
		translate shld + <.03,.11,0>
	}
	//texture{suitTex}
	translate s3walk(0) + <.1,.14,0>
}


torus{.5, .03 scale <1,1,1>  //selection circle
	pigment{ radial pigment_map{
		//[0 rgbf <0,1,0,1>]
		//[1 rgbf <.5,.6,0,1>]
		[0 rgb <0,1,0>]
		[1 rgb <.4,.7,0>]
		
		}frequency 15
	}
	finish{ambient 1 diffuse 0}
	
	translate s3walk(0) + <.45,.00,0>
	no_shadow no_reflection
}

object{ healthbar(.5,.8,.0,.0) translate s3walk(0) + <.45,.00,0>}

union{ //same gun as that of the 2nd trooper
	difference{
		cylinder{<2.55,0.8,0.175> <2.1,0.95,0.175> .04 pigment{rgb <.2,.2,.2>}}
		cylinder{<2.5501,0.8,0.175> <2.9999,0.95,0.175> .03 pigment{rgb <.2,.2,.2>}}
	}
	difference{
		cylinder{<2.55,0.85,0.175> <2.1,1.00,0.175> .04 pigment{rgb <.2,.2,.2>}}
		cylinder{<2.5501,0.85,0.175> <2.9999,1.00,0.175> .03 pigment{rgb <.2,.2,.2>}}
	}
	
	cylinder{<2.45,0.875,0.175> <2.45,0.875,-0.05> .045 pigment{rgb <.2,.2,.2>}}
	
	cylinder{<2.51,0.8,0.12> <2.52,0.9,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	cylinder{<2.47,0.805,0.12> <2.48,0.91,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	
	cylinder{<2.38,0.91,0.12> <2.39,0.93,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	cylinder{<2.34,0.92,0.12> <2.35,0.94,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	cylinder{<2.3,0.93,0.12> <2.31,0.95,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	cylinder{<2.26,0.94,0.12> <2.27,0.96,0.12> .015 pigment{powerSource} finish{ambient 1 diffuse 0} }
	
	translate <-2.55,-0.95,-0.175>
	
	rotate <20,45,35>
	translate s3walk(0) + <.25,.7, .45>
}




union{  //fourth soldier
	sphere{<0,0,0> .08 scale <2,.75,1> translate <2.75,0,0> texture{suitTex}}
	sphere{<0,0,0> .08 scale <2,.75,1> rotate <-0.02,0,20> translate <2.75,0,.25> texture{suitTex}}
	//cylinder{<2.66,0,0> <2.55,.25,0.01> .07 texture{suitTex}}
	cylinder{<2.75,0,0> <2.75,.25,0.01> .07 texture{suitTex}}
	cylinder{<2.75,0,.25> <2.75,.25,0.24> .07 texture{suitTex}}
	sphere{<2.75,.25,0.01> .08 texture{suitTex}}
	sphere{<2.75,.25,0.24> .08 texture{suitTex}}
	cylinder{<2.75,.25,0.01> <2.75,.5,0.05> .07 texture{suitTex}}
	cylinder{<2.75,.25,0.24> <2.75,.5,0.20> .07 texture{suitTex}}
	sphere{<0,0,0> .075 scale <1.5,1.5,2> translate <2.75,.5,.125> texture{suitTex}}
	cylinder{<0,0,0> <0,.32,0> .075 scale <1.5,1,2> translate <2.75,.5,.125> texture{suitTex}}
	sphere{<0,0,0> .075 scale <1.5,1.5,2> translate <2.75,.82,.125> texture{suitTex}}
	
	sphere{<2.75,.8,-.05> .065}
	sphere{<2.75,.8,.30> .065}
	cylinder{<2.75,.8,.30> <2.75,.65, .4> .055}
	cylinder{<2.75,.8,-.05> <2.75,.65, -.15> .055}
	sphere{<2.75,.65,.4> .065}
	sphere{<2.75,.65,-.15> .065}
	cylinder{<2.75,.65,0.4> <2.75,.5, 0.30> .055}
	cylinder{<2.75,.65,-.15> <2.75,.5, -.05> .055}
	
	sphere{<2.75,.95,.125> .15 texture{suitTex}}
	intersection{
		sphere{<0,0,0> .16 }
		plane{y 0 inverse rotate <0,0,20> }
		plane{y 0 rotate <0,0,-20> }
		texture{suitTex}
		pigment{rgb 0}
		finish{reflection -.5 specular .2 diffuse 0}
		rotate <0,0,7>
		rotate <15,0,0>
		translate <2.75, .98, .125>
	}
	texture{suitTex}
	translate <-2.75,0,-.125>
	rotate <0,220,0>
	translate s4walk(maxWalk) + <0,-0.15,0>
	
}

torus{.5, .03 scale <1,1,1>  //selection circle
	pigment{ radial pigment_map{
		//[0 rgbf <0,1,0,1>]
		//[1 rgbf <.5,.6,0,1>]
		[0 rgb <0,1,0>]
		[1 rgb <.4,.7,0>]
		
		}frequency 15
	}
	finish{ambient 1 diffuse 0}
	
	translate s4walk(0)
	no_shadow no_reflection
}

object{ healthbar(.5,.8,.7,.55) translate s4walk(0)}

union{  //first type of gun
	cylinder{<2.4,.75,-1.025> <1.8,.8,-1.025> .06 }
	difference{
		torus{.4, .02 scale <1,6,1> }
		plane{z, 0 rotate <0,-30,0>}
		plane{z, 0 inverse rotate <0,30,0>}
		translate <2.65,.75,-1.025>
	}
	
	pigment{rgb .7}
	translate <-2.1,-.75,-1.025>
	rotate <10,-20,0>
	
	translate <-0.5,0,.2>
	
	translate s4walk(0)
}


#if(wallon)

#declare concreteBlock = //difference{
	box{<0,0,0> <.10,.10,.2> scale .925}
	//box{<.02,-.0001,.02> <.08,.1001,.08> scale .925} // <.015,.05,.015>
	//box{<.02,-.0001,.12> <.08,.1001,.18> scale .925}
	//scale .925
//}

#declare wallhf = 
	height_field{png "hf_wall.png" rotate <0,90,0> translate <0,0,1> scale <2.02,2,1.52> translate <-.01,0,-.01> }
	
#declare walls = 
intersection{
	union{
		union{
#declare xbrick = 0;
#declare ybrick = 0;
#while(ybrick < 2)
	#while(xbrick < 2)
		#if(inside(wallhf,<xbrick-0.20,ybrick,0.10>))
			object{concreteBlock rotate <0,90,0> translate <xbrick-0.30,ybrick,0.10>}
		#end
		#declare xbrick = xbrick+ 0.20;
	#end
	#declare xbrick = mod(xbrick + 0.10,0.2);
	#declare ybrick = ybrick + 0.10;
#end
		}
		union{
#declare zbrick = 0.10;
#declare ybrick = 0;
#while(ybrick < 2)
	#while(zbrick < 1.5)
		#if(inside(wallhf,<0,ybrick,zbrick-0.10>))
			object{concreteBlock rotate <0,0,0> translate <0,ybrick,zbrick - 0.10>}
		#end
		#declare zbrick = zbrick+ 0.20;
	#end
	#declare zbrick = mod(zbrick + 0.10,0.2);
	#declare ybrick = ybrick + 0.10;
#end
	/*		box{<0,-.5,0> <2,2,.1>}
		box{<0,-.5,0> <.1,2,1.5>}*/
		}
	}
	object{wallhf}
	
	//translate <2,0,2>

}


#declare unpainted = texture{
	pigment{granite scale .15 pigment_map{
			[0.0 rgb <.95,.95,.95> ]
			[1.0 rgb <1,1,1>]
		}
	}
	normal{granite .15 scale .15}
	finish{diffuse .7}
}
#declare painted = texture{
	pigment{ rgb <.6,.2,.2>}
	normal{ bozo .3 scale .2}
	finish{specular .4 reflection .1}
}

object{walls
		rotate <0,120,0>
	translate <1.8,-.2,1.8>
	texture{ unpainted }
}

//this was unioned to the main snow so it would take footprints
/*intersection{
	height_field{png "hf_snowdrift.png"}
	cylinder{<0,0,0> <0,1,0> 1}
	rotate <0,90,0> translate <0,0,1> scale <2.02,.5,1.52> translate <-.01,0,-.01>
	rotate <0,120,0>
	translate <1.8,-.25,1.8>
	
	pigment {rgb <.998,.998,.998>}
	normal{ average normal_map{[1 granite .3 scale .6] [1 granite .15 scale .2]}}
	finish{snowFin}
}*/

#declare none = texture{pigment{rgbf 1} finish{diffuse 0 ambient 0}}

intersection{ //peeling paint on the walls
	union{
		box{<.0926,0,.1> <2,2,.0927>}
		box{<.0926,0,.1> <.0927,2,1.5>}
	}
	height_field{png "hf_wall.png" rotate <0,90,0> translate <0,0,1> scale <2.02,2,1.52> translate <-.01,0,-.01> }
	
	texture{bozo scale <.3,.4,.3> turbulence <0,.25,0>
		texture_map{
			[0.0 none]
			[0.5 none]
			[0.51 painted]
			[1.0 painted]
		}
	}
	rotate <0,120,0>
	translate <1.8,-.2,1.8> - <0,.15,0> //hack-- I don't know why the paint was sticking out the top of the snow
}



#declare misses = 0;

blob {
#declare norm = <-1,-1,-1>;
#declare loop = 0;
#declare R1 = seed(1);
#while(loop < 1800)
	#declare start = <2*rand(R1),10,.1*rand(R1)>;
	#declare snowSpot = trace(walls,start,<0,-1,0>,norm);
	
	#declare loop = loop+1;
	#if(snowSpot.y = 0 | abs(norm.x) > .4)
		#declare misses = misses + 1;
	#else
		sphere{<0,0,0>, .05,.8 scale <1.6,1,1.6> translate snowSpot+.005*y}	
	#end
#end

	pigment {rgb <.998,.998,.998>}
	normal{ granite .15 scale .2}
	finish{snowFin}
	rotate <0,120,0>
	//bounded_by{box{<-.02,0,-.02> <6.02,2.02,.22>}}
	translate <1.8,-.2,1.8>
	
}

blob {
#declare loop = 0;
#declare R1 = seed(0);
#while(loop < 1800 * 1.5/2)
	#declare start = <.1*rand(R1),10,1.5*rand(R1)>;
	#declare snowSpot = trace(walls,start,<0,-1,0>,norm);
	
	#declare loop = loop+1;
	#if(snowSpot.y = 0 | abs(norm.z) > .4)
		#declare misses = misses + 1;
	#else
		sphere{<0,0,0>, .05,.8 scale <1.6,1,1.6> translate snowSpot+.005*y}
	#end
#end

	#debug "Snow misses: "
	#debug str(misses,0,-1)
	#debug "\n"

	pigment {rgb <.998,.998,.998>}
	normal{ granite .15 scale .2}
	finish{snowFin}
	//bounded_by{box{<-.02,0,-.02> <6.02,2.02,.22>}}
	rotate <0,120,0>
	translate <1.8,-.2,1.8>
	
}

#end //if(wallon)

#declare fullcolor = density{bozo scale <.7,1,.7> color_map{
	[0.3 rgb <1.0,1.0,0.4>]
	[0.7 rgb <1.0,0.5,0.5>]
	}
}
#declare halfcolor = density{bozo scale <.7,1,.7> color_map{
	[0.3 rgb <1.0,1.0,0.4>*.5]
	[0.7 rgb <1.0,0.5,0.5>*.5]
	}
}

#if(expon)
//plume of snow from an explosion
//maybe smoke?
cone{<0,-.3,0> .4 <0,2,0> .9 pigment{rgbf <1,1,1,1>}
	hollow
	interior{
		media{
			emission 1.2*0
			absorption 1.2*2
			density{cylindrical scale .7 turbulence .7
				color_map{
					[0 rgb 0]
					[0.6 rgb .5]
					[1 rgb 1.0]
				}
			}
			
			intervals 3            // number of intervals used for sampling [10]
  		samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
  		confidence 0.6         // statistic parameter higher->better quality [0.9]
  		variance 8.0/128       // statistic parameter lower->better quality [1.0/128]
  		ratio 0.9              // distribution between lit and unlit areas [0.9]

		}
	}
	rotate <0,0,-15>
	translate explSpot
}


sphere{<0,0,0> 1.7 pigment{rgbf 1}
	hollow
	interior{
		media{
			emission rgb <.8,.8,.8>*1.75
			absorption <.8,.8,.8>*1
			density{spherical scale 1.7 turbulence .15
				density_map{
					[0 rgb 0]
					[0.35 halfcolor]
					[0.5 fullcolor]
				}
			}
			intervals 3            // number of intervals used for sampling [10]
  		samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
  		confidence 0.6         // statistic parameter higher->better quality [0.9]
  		variance 8.0/128       // statistic parameter lower->better quality [1.0/128]
  		ratio 0.9              // distribution between lit and unlit areas [0.9]

		}
	}
	scale <1,.6,1>
	translate explSpot
}
light_source{
	explSpot
	color rgb <.6,.4,.2>
	fade_distance 3
	fade_power 3
	media_interaction off
	media_attenuation off
}

union{
#declare loop = 0;
#declare R1 = seed(0);
#while(loop < 40)
	sphere{<0,0,0>, rand(R1)*.1 
		pigment{granite scale .1 pigment_map{
			[0.3 rgb <1,1,1>]
			[0.6 rgb <.5,.5,.5>]
			}
		}
		
		/*pigment{rgbf <1,1,1,1>}
		hollow
		interior{
			media{
				emission .8
				absorption .3
				density{spherical scale .1 turbulence .1
					color_map{
						[0 rgb 0]
						[0.7 rgb .7]
						[1 rgb 1]
					}
				}
			
				intervals 2            // number of intervals used for sampling [10]
  			samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
  			confidence 0.5         // statistic parameter higher->better quality [0.9]
  			variance 8.0/128       // statistic parameter lower->better quality [1.0/128]
  			ratio 0.9              // distribution between lit and unlit areas [0.9]

			}
		}*/
		scale <.2,1,.2> translate <0,.4+rand(R1)*.8,0> rotate <40*rand(R1)+40,360*rand(R1),0>
		
	}
	#declare loop = loop + 1;
#end
	//bounded_by{ sphere{ <0,0,0> 1.3} }
	translate explSpot
}

#end //if(expon)

/*difference{
	sphere{<5,0,-3> 3}
	sphere{<5,0,-3> .28}
	
	//interior{ior .9}
	
	pigment{rgbf .3}
	finish{irid{ 1 thickness .1 turbulence .05}}
}
*/

/*blob{
	sphere{<0,0,0> 1, 1.5 scale <1.25,.8,1>}
	sphere{<0,0,0> .5, 1.7 translate <-.2,.4,0>}
	cylinder{<-.3,0,0> <-.8,0,0> .3, 1.7}
	//cylinder{<-.8,0,.5> <-3,0,.4> .6, 1.55}	
	//cylinder{<-.8,0,-.5> <-3,0,-.4> .6, 1.55}
		
	
	pigment{planar scale .05 translate <0,.1,0> pigment_map{
		[0.5 rgb <.7,.6,.2>]
		[0.5 rgb <.3,.2,.5>]
		}
	}
	finish{diffuse .4 specular .2 roughness .2}		
	//finish{diffuse .4 specular .7 metallic reflection .35}
	normal{granite .1 scale .2}
		
	translate <-2.5,1.7,1.7>
}*/


//lowerPart is declared above so the shot can hit it
//#declare lowerPart =
//sphere{ <0,0,0>, .4 scale <1.5, .7, 1> }

#declare upperPart = 
sphere{ <0,0,0>, .45 scale <1.4,1,1> translate <-.2,.12,0> }

#declare lobe =
superellipsoid{ <.5,1> scale <.9,.3,.4> }


#include "shapes.inc"

#declare wing =
Supercone(<0.8,-.3,-.3>, 0.8, .2, <0,0,1.3>, .1, .075)

#declare otherWing =
Supercone(<0.8,-.3,.3>, 0.8, .2, <0,0,-1.3>, .1, .075)


#debug "\nstarting faceting ship...\n"
#include "rand.inc"

#declare R1 = seed(1);
#declare norm = <-1,-1,-1>;
#declare point = <-1,-1,-1>;


#declare lowerFacets =
intersection{
	#declare loop = 0;
	
	#while(loop < 100)
		#declare start = VRand_On_Sphere(R1)*20;
		#declare point = trace(lowerPart,start,-start,norm);
		#declare point = point-(norm/1)*.015; //drop in about .015 units
		
		#if(norm.x != 0 | norm.y != 0 | norm.z != 0)
			plane{norm, 0  translate point}
		#end
		#declare loop = loop+1;
	#end
	//plane{x, 0 rotate <0,0,-25> translate x*(divis /*+ .1*/)}
}

#declare upperFacets =
intersection{
	#declare loop = 0;
	
	#while(loop < 100)
		#declare start = VRand_On_Sphere(R1)*20;
		#declare point = trace(upperPart,start,<-.2,.15,0> - start,norm);
		#declare point = point-(norm/1)*.015; //drop in about .015 units
		
		#if(norm.x != 0 | norm.y != 0 | norm.z != 0)
			plane{norm, 0  translate point}
		#end
		#declare loop = loop+1;
	#end
	//plane{x, 0 rotate <0,0,-25> translate x*(divis /*+ .1*/)}
}

#declare lobeFacets =
intersection{
	#declare loop = 0;
	
	#while(loop < 350)
		#declare start = VRand_On_Sphere(R1)*20;
		#declare point = trace(lobe,start,<0,0,0> - start,norm);
		#declare point = point-(norm/1)*.015; //drop in about .015 units
		
		#if(norm.x != 0 | norm.y != 0 | norm.z != 0)
			plane{norm, 0  translate point}
		#end
		#declare loop = loop+1;
	#end
}

#declare wingFacets =
intersection{
	#declare loop = 0;
	
	#while(loop < 120)
		#declare start = VRand_On_Sphere(R1)*20;
		#declare point = trace(wing,start,<0,0,.75> - start,norm);
		#declare point = point-(norm/1)*.015; //drop in about .015 units
		
		#if(norm.x != 0 | norm.y != 0 | norm.z != 0)
			plane{norm+ .2*vturbulence(1.0,0.75,2,norm*4) , 0  translate point}
		#end
		#declare loop = loop+1;
	#end
}

#declare otherWingFacets =
intersection{
	#declare loop = 0;
	
	#while(loop < 120)
		#declare start = VRand_On_Sphere(R1)*20;
		#declare point = trace(otherWing,start,<0,0,-.75> - start,norm);
		#declare point = point-(norm/1)*.015; //drop in about .015 units
		
		#if(norm.x != 0 | norm.y != 0 | norm.z != 0)
			plane{norm+ .2*vturbulence(1.0,0.75,2,norm*4) , 0  translate point}
		#end
		#declare loop = loop+1;
	#end
}


#debug "Ship faceting completed.\n"
union{
	object{lowerFacets bounded_by{ lowerPart }}
	difference{object{upperFacets}
		box{<-.2,.35,-.6> <.8,.45,.6>}
		 bounded_by{ upperPart }}
	object{lobeFacets bounded_by{box{-1,1 scale <1.7,.5,.3>}} translate <-.8,-.2,.3> }
	object{lobeFacets rotate <0,180,0> bounded_by{box{-1,1 scale <1.7,.5,.3>}} translate <-.8,-.2,-.3> }
	object{wingFacets /*bounded_by{box{<-.1,-.1,0> <1,.1,1.5>}}*/ rotate <180,0,0> scale <1,1,-1> translate <-1.3,-0.1,0> }
	object{wingFacets /*bounded_by{box{<-.1,-.1,0> <1,.1,1.5>}}*/ rotate <180,0,0> translate <-1.3,-0.1,0> }
	
	difference{
		cylinder{<-0.9,-0.1,-0.8> <0.1,-0.1,-0.8> .09}
		cone{<0.1001,-0.1,-0.8>, .07, <-0.5,-0.1,-0.8>, 0}
		normal{facets coords .05} finish{diffuse .2 specular .7 metallic reflection .25}
		pigment{rgb <.1,.1,.1>}
		}

	difference{
		cylinder{<-0.9,-0.1,0.8> <0.1,-0.1,0.8> .09}
		cone{<0.1001,-0.1,0.8>, .07, <-0.5,-0.1,0.8>, 0}
		normal{facets coords .05} finish{diffuse .2 specular .7 metallic reflection .25}
		pigment{rgb <.1,.1,.1>}
		}
	//box {-1,1 scale <3.5,.75,.5> translate <-1,-.2,.3> pigment{rgbf <1,0,0,1>} }
	
	
	pigment{planar scale .05 translate <0,.1,0> pigment_map{
		/*[0.5 rgb <.7,.6,.2>]
		[0.5 rgb <.3,.2,.5>]*/
		[0.5 rgb .2]
		//[0.5 rgb <.3,.7,.3>]
		}
	}
	finish{diffuse .2 specular .7 metallic reflection .4}
	//finish{diffuse .4 specular .2 roughness .2}		
	//finish{diffuse .4 specular .7 metallic reflection .35}
	normal{granite .02 scale .3}
	
	rotate <0,15,0>
		
	translate <-2.5,1.2,2.3>
}

#if(expon)
sphere{ <0,0,0> .07 scale <2,.5,.5> pigment{rgbf 1} hollow
	interior{
		media{
			emission rgb <.8,.8,.4>*32
			absorption .4
			density{bozo scale 0.10 translate <0.1,0,0> turbulence .4
				density_map{
					[0.4 rgb 0]
					[0.7 rgb <0.6,0.6,0.0>]
					[1.0 rgb <1.0, 0.3, 0.00>]
				}
			}
			
			intervals 7            // number of intervals used for sampling [10]
  		samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
  		confidence 0.8         // statistic parameter higher->better quality [0.9]
  		variance 2.0/128       // statistic parameter lower->better quality [1.0/128]
  		ratio 0.9              // distribution between lit and unlit areas [0.9]

		}
	}
	scale <3.5,1,1>
	translate <1, -0.1, -0.8>
	rotate <0,15,0>
		
	translate <-2.5,1.2,2.3>

}

sphere{ <0,0,0> .07 scale <2,.5,.5> pigment{rgbf 1} hollow
	interior{
		media{
			emission rgb <.8,.8,.4>*32
			absorption .4
			density{bozo scale 0.10 translate <0.1,0,0> turbulence .4
				density_map{
					[0.4 rgb 0]
					[0.7 rgb <0.6,0.6,0.0>]
					[1.0 rgb <1.0, 0.3, 0.00>]
				}
			}
			intervals 7            // number of intervals used for sampling [10]
  		samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
  		confidence 0.8         // statistic parameter higher->better quality [0.9]
  		variance 2.0/128       // statistic parameter lower->better quality [1.0/128]
  		ratio 0.9              // distribution between lit and unlit areas [0.9]

		}
	}
	scale <3.5,1,1>
	translate <1, -0.1, 0.8>
	rotate <0,15,0>
		
	translate <-2.5,1.2,2.3>

}

//shrapenel
#declare loop = 0;
#declare R1 = seed(1);
#while(loop < 27)
	#declare firstpoint = <rand(R1)*.5,rand(R1)*.5>;
	polygon{5, firstpoint, <rand(R1)*.5+.5,rand(R1)*.5>, <rand(R1)*.5+.5,rand(R1)*.5+.5>
		<rand(R1)*.5,rand(R1)*.5+.5>, firstpoint scale .15 rotate <rand(R1)*180,rand(R1)*360,0>
		translate <rand(R1)*.6-.3,rand(R1)*.55+.6,rand(R1)*.6-.3>
		rotate <90,110,0>
		
		pigment{rgb <.2,.2,.2>}
		
		finish{reflection .4 specular .7 metallic diffuse .2}
		//finish{ambient 1}
		
		rotate <0,15,0>	
		translate <-2.5,1.2,2.3>

	}
	#declare loop = loop + 1;
#end
			
#end //if(expon)

//window
object{upperPart scale .92 pigment{rgb <0,0,0>} finish{specular .4 reflection .1 ambient 0 diffuse 0}
	rotate <0,15,0>
	translate <-2.5,1.2,2.3>

}	
	
	
torus{.9, .03/1.3 scale <1.3,1,1.3>  //selection circle
	pigment{ radial pigment_map{
		//[0 rgbf <0,1,0,1>]
		//[1 rgbf <.5,.6,0,1>]
		[0 rgbt <1,0,0,0.25>]
		[1 rgbt <.7,.4,0,0.25>]
		
		}frequency 25
	}
	clipped_by{plane{ y,0 inverse}}
	translate <-.9,0,0>
	rotate <0,15,0>
	translate <-2.5, 0.5, 2.3> 
	
	finish{ambient 1 diffuse 0}
	no_shadow no_reflection
}

//<1.8,.8,-1.025> <-2.2,0.33333+.8,-1.025>


#declare shipExpNorm = <-1,-1,-1>;
#declare shipExpSpot = trace(lowerPartMoved, vrotate(<1.8,.8,-1.025>,<0,30,0>)+<0,-.095,2>, vrotate(<-4,0.33333,0>,<0,30,0>), shipExpNorm );
#if(expon)
sphere{<0,0,0>, 0.4
	pigment{rgbf 1}
	hollow
	interior{
		media{
			emission rgb <.8,.8,.8>*1.75*2
			absorption <.8,.8,.8>*3.5
			density{spherical scale 0.4 turbulence .1
				density_map{
					[0 rgb 0]
					[0.2 halfcolor]
					[0.6 fullcolor]
				}
			}
			intervals 2            // number of intervals used for sampling [10]
  		samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
  		confidence 0.6         // statistic parameter higher->better quality [0.9]
  		variance 8.0/128       // statistic parameter lower->better quality [1.0/128]
  		ratio 0.9              // distribution between lit and unlit areas [0.9]

		}
	}
	translate shipExpSpot
}





//#include "math.inc"

//#declare ringTurn = VRotationD(shipExpNorm * <0,1,1> ,<0,1,0>,x);

//#declare ringTurn = vrotate(ringTurn, VRotationD(shipExpNorm * <1,0,1>, <0,0,1>, y) );

/*
#declare ringTurn = <90,110,0>;

torus{.5, .04 translate 0*y rotate ringTurn translate shipExpSpot pigment{rgbf <.9,.8,.55,1>}
	finish{ambient .2}
}


torus{.7, .05 translate -0.1*y rotate ringTurn translate shipExpSpot pigment{rgbf <.9,.8,.65,1>}
	finish{ambient .2}
}

torus{.9, .06 translate -0.2*y rotate ringTurn translate shipExpSpot pigment{rgbf <.85,.8,.75,1>}
	finish{ambient .2}
}*/

#end //if(expon)

//Test render:
//-f +sc0.005871 +sr0.234987 +ec1.000000 +er0.762402