//=========================================
// macro MakeLeaf
//-----------------------------------------
// Creates a mesh of a curved leaf in the -z direction and that bends downward
// The leaf has a stalk in the z direction and is folded in two
// The leaf is not smoothed
// Note 1 : the final leaf is positionned at <0,0,0>
// Note 2 : in fact the leaf is built in the z direction and rotated y*180 later
//-----------------------------------------
/*
#declare lsize=0.3;  // leaf size
#declare seg=20;     // nb of leaf segments and stalk segments : increase to smooth
#declare ll=5;       // leaf length
#declare wl=0.6;     // leaf width 
#declare fl=0.2;     // depth of leaf fold
#declare lpow=1;     // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;     // leaf bending angle : the leaf bends forward until this angle
#declare apow=1;     // curve power, how slow the leaf bends
#declare ndents=0;   // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=5;   // number of lobes (individual leaves)
#declare alobes=160; // angle made by all the lobes
#declare qlobes=0.9; // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=5;       // stalk length (0=no stalk)
#declare ws=0.2;     // width of stalk
#declare as=30;      // stalk bending angle : the leaf bends backward
#declare dofile=false;          // true creates a file ; false otherwise
#declare ffname="gtleaf.inc";   // file name
*/
//-----------------------------------------
// Leaf examples
//-----------------------------------------
// 5-lobes leaf
// #declare Leaf=object{MakeLeaf(0.3,10,5,0.6,0.2,1,100,1,0,5,160,0.9,3,0.12,10,dofile,ffname)}
// Wide, heart-shaped leaf
// #declare Leaf=object{MakeLeaf(0.3,10,5,2,0.4,3,100,1,0,1,0,0,3,0.12,10,dofile,ffname)} 
// "Oak", dented leaf (ndents=8)
// #declare Leaf=object{MakeLeaf(0.3,40,5,1,0.1,1,100,1,8,1,0,0,3,0.12,10,dofile,ffname)}
// Trilobed, narrow, very dented leaf (ndents=20)
//#declare Leaf=object{MakeLeaf(0.3,40,5,0.3,0.1,1,100,1,20,3,140,0.6,3,0.12,10,dofile,ffname)} 
// Wide, star-shaped, leaf
//#declare Leaf=object{MakeLeaf(0.3,10,4,1,0.4,1,100,0.5,1,5,200,0.5,3,0.12,10,dofile,ffname)} 
// Narrow, long, leaf, very pointy (lpow=3)
//#declare Leaf=object{MakeLeaf(0.3,60,15,1,0.3,3,140,1,0,1,0,0,3,0.12,10,dofile,ffname)}
// Narrow, long, leaf, straight borders (lpow=0.3)
//#declare Leaf=object{MakeLeaf(0.3,60,15,1,0.3,0.3,100,1,0,1,0,0,3,0.12,10,dofile,ffname)}
// Twin short leaf
//#declare Leaf=object{MakeLeaf(0.3,40,5,0.7,0.5,1,100,1,0,2,80,0.6,3,0.1,10,dofile,ffname)} 
// 7 lobes leaf (conic when seen from the side)
//#declare Leaf=object{MakeLeaf(0.3,40,5,1,0.5,2,100,1,0,7,280,0.8,3,0.1,10,dofile,ffname)} 
// 7 lobes leaf (flat when seen from the side)
//#declare Leaf=object{MakeLeaf(0.3,40,5,1,0.5,2,100,1,0,7,280,0.8,10,0.1,-40,dofile,ffname)} 
//-----------------------------------------
#macro MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,ndents)
#debug "create leaf\n"
mesh{
//-----------------------------------------
// leaf
//-----------------------------------------
// leaf points
//-----------------------------------------
#local lseg=ll/seg;  // length of leaf segment
#local nI=3; #local nJ=seg+1;
#local nP=nI*nJ; #local P=array[nP] // array of leaf points
#local pl=<0,0,0>;   // start of leaf
#local j=0; 
#while (j<nJ)          
        #local tl=j/seg;
        #if (j>0) 
                #local pl=pl+lseg*vaxis_rotate(z,x,pow(tl,apow)*al);
         #end
                #local P[j*nI]=pl-x*wl*(pow(sin(tl*pi),lpow)*(2+(pow(sin(tl*pi*ndents),2))))/3;
                #local P[j*nI+1]=pl-y*fl*sin(tl*pi);
                #local P[j*nI+2]=pl+x*wl*(pow(sin(tl*pi),lpow)*(2+(pow(sin(tl*pi*ndents),2))))/3;
        #local j=j+1;        
#end   

//-----------------------------------------
// leaf triangles
//-----------------------------------------
#local q=0;
#while (q<(nI*(nJ-1)-1))
#local i=mod(q,nI);//#local j=(q-i)/nI;
#if (i < nI-1)        
                triangle{P[q],P[q+1],P[q+nI+1]} 
                triangle{P[q],P[q+nI],P[q+nI+1]}
#end
#local q=q+1;
#end        
scale lsize  // resizes the mesh
rotate y*180 // required so that the leaf points at -z
}
#debug "end of leaf creation\n"
#end
//-----------------------------------------
// end of MakeLeaf macro
//=========================================
