// Station include for PovRay 3.5
// 2003 by Ron Gow

#include "colors.inc" 
#include "glass.inc"
#include "woods.inc"

//  ***************  textures ******************** 
#local boardtex = 
    texture {  pigment{ P_WoodGrain18A color_map { M_Wood18A } rotate x*90}
        finish { ambient 0}  }
    texture {  pigment{ P_WoodGrain18B color_map { M_Wood18B } rotate x*91}
        finish { ambient 0 } }

#declare shaketex = texture { T_Wood17
    finish { ambient 0 diffuse .5 }
    rotate x*90
}

#local doortex = texture { T_Wood16
    finish { ambient 0 phong .05 phong_size 1}
}

#local knobtex = texture {
    pigment { rgb <.85,.60,.10> }
    finish { ambient 0 phong .5 phong_size 20 reflection .8 }
}


//  **********************************************

#local b_wdth = .1;
#local d_place = 2;
#local w_place = 3.6;

#local r=seed(69);

#local l_wall = union {
#local cnt = 0;
#while (cnt<25)
    box { <-.01,0,-b_wdth > <.01,1.5,b_wdth> 
        translate z*cnt*b_wdth*2.1
        texture { boardtex 
            scale <.5,2,.7+rand(r)> 
            translate -z*rand(r)
        }
        rotate <0,0,-.5+rand(r)*.5>
    }
    #local cnt=cnt+1;
#end
}    

#local s_wall = union {
#local cnt = 0;
#while (cnt<15)
    box { <-b_wdth,0,-.01 > <b_wdth,1.5,.01> 
        translate x*cnt*b_wdth*2.1
        texture { boardtex 
            scale <.7+rand(r),2,.5> 
            translate -x*rand(r)
        }
        rotate <-.5+rand(r)*.5,0,0>
    }
    #local cnt=cnt+1;
#end
}

#local f_wall = difference {
    object { l_wall }
    box { <-.025,-.01,-.3> <.025,1.3,.3> 
        translate z*d_place
    }
    box { <-.025,.65,-.45> <.025,1.3,.45> 
        translate z*w_place
    }
    box { <-.025,.65,-.3> <.025,1.3,.3> 
        translate z*(d_place-1.3)
    }
}

#local walls = union {
    object { f_wall }
    object { l_wall translate <3.05+b_wdth,0,0> }
    object { s_wall translate <b_wdth,0,-b_wdth>}
    object { s_wall translate <b_wdth,0,5.05+b_wdth> }
}

//  ***********

#local e_wall = intersection {
    object { s_wall }
    box { <-1,-1,-.1> <1,1,.1> 
        rotate z*45
        translate <1.5,0,0>
    }
} 

#local shake = intersection {
    box { <0,-.01,-.05> <1,.01,.05> }
    box { <0,-.02,-.05> <1,.02,.05> 
        rotate -z*3
        translate y*.017
    }
    
}

#local s_slab = union {
    #local rr=seed(42);
    #local rcnt=0;
    #while (rcnt<13)
        #local scnt=0;
        #while (scnt<60)
            object { shake
                scale 1.1-rand(rr)*.2 
                rotate <rand(rr),rand(rr),-(1.5+rand(rr)*1.5)> 
                translate <rcnt*.65,0,scnt*.11>
                texture { shaketex rotate z*90 scale rand(rr)*3} 
            }
            #local scnt=scnt+1;
        #end
        #local rcnt=rcnt+1;
    #end
}

#local roof = union { 
    object { s_slab
        scale .1 
        rotate z*45
        translate <-.62,0,0> 
    }
    object { s_slab
        scale .1
        rotate y*180 
        rotate -z*45
        translate <.62,0,.645> 
    }
}



//  ******************************************

#local w_frame = union {
    box { <-.1,-4.2,-.25>  <.1,4.3,.25>
        translate -x*4.1 
    }
    box { <-.1,-4.2,-.25>  <.1,4.3,.25>
        translate x*4.1 
    }
    box { <-4.2,-.1,-.25>  <4.2,.1,.25> 
        translate y*4.2
    }
    box { <-4.2,-.15,-.35>  <4.2,.1,.25> 
        rotate -x*20
        translate -y*4.2 
    }
    texture { boardtex }
}

#local c_piece = box { <-4,-.1,-.1>  <4,.1,.1> 
    texture { doortex } 
}

#local panes = union {
    #local cnt=1;
    #local s = seed(0);
    #while (cnt<8)
        box { <-2,-1,-.01>  <2,1,.01> 
            rotate <-.7+rand(s)*1.4,-.6+rand(s)*1.3> translate <-2,cnt,0> }
        box { <-2,-1,-.01>  <2,1,.01> 
            rotate <-.7+rand(s)*1.4,-.6+rand(s)*1.3> translate <2,cnt,0> }
        #local cnt=cnt+2;
    #end
    texture { 
        pigment { Col_Glass_Clear }
        finish { roughness .001 specular .015 reflection .35 phong .02 }
    }
}

#local panel = union {
    object {c_piece }
    object {c_piece translate y*2}
    object {c_piece translate y*4}
    object {c_piece translate y*6}
    object {c_piece translate y*8}
    object {c_piece rotate z*90 
        translate <-.2,4,0>
    }
    object {c_piece rotate z*90 
        translate <.2,4,0>
    }
    object {c_piece rotate z*90
        scale <1,1.025,1> 
        translate <-4,4,0>
    }
    object {c_piece rotate z*90
        scale <1,1.025,1> 
        translate <4,4,0>
    }
    object {panes}
} 

#local window = union {
    object { w_frame translate y*4 }
    object { panel }
    translate y*.2
}

#local d_frame = union {
    box { <-.1,-5,-.25>  <.1,5,.35>
        translate -x*3 
    }
    box { <-.1,-5,-.25>  <.1,5,.35>
        translate x*3
    }
    box { <-3,-.15,-.25>  <3,.15,.35> 
        translate y*5
    }
    translate y*5
    texture { boardtex }
}

#local d_knob = union {
    sphere { <0,0,-.2> .1 scale <1,1,.5> }
    cylinder { <0,0,-.15> <0,0,0> .035 }
    cylinder { <0,0,0> <0,0,.02> .125 }
    texture { knobtex }
}

#local door = union {
    box { <-2.9,0,-.07> <2.9,10,.07> 
        texture { doortex }
    }
    object { d_frame }
    object { d_knob scale 2.5 translate <2.2,4.75,-.06> }
}
//  **********************************************

#local awning = union {
    box { <-.55,-.02,-.15> <.55,.02,5.15> 
        rotate z*5
        translate y*1.47
    }
    cylinder { <-.45,0,0> <-.45,1.43,0> .03 }       
    cylinder { <-.45,0,1.25> <-.45,.6,1.25> .03 }
    cylinder { <-.45,0,2.50> <-.45,.6,2.50> .03 }
    cylinder { <-.45,0,3.75> <-.45,.6,3.75> .03 }
    cylinder { <-.45,0,5.0> <-.45,1.43,5.0> .03 }
    cylinder { <-.45,.6,0> <-.45,.6,5.0> .03 }
    texture { shaketex }
}

#local b_walk = union {
    #local cnt=0;
    #while (cnt<5)
        box { <-.55,-.01,0> <.55,0,.24>
            translate z*cnt
        }
        #local cnt=cnt+.25;
    #end
    texture { boardtex }
}



//  **********************************************

#local building = union {
    object { window  
        scale <.1,.08,.1> rotate y*90 
        translate <-.01,.65,w_place>
    }
    object { window  
        scale <.08,.08,.1> rotate y*90 
        translate <-.01,.65,d_place-1.3>
    }
    object { door scale <.1,.132,.1> rotate y*90 
        translate z*d_place 
    }
    object { walls  }
    box { <-.02,-.15,-b_wdth-.02> <3.07+b_wdth,0,5.07+b_wdth> 
        texture { boardtex rotate x*90 scale .2}
    }
    box { <-.02,1.5,-b_wdth-.02> <3.07+b_wdth,1.56,5.07+b_wdth> 
        texture { boardtex rotate x*90 scale .2}
    }
    object { e_wall scale <1.170,.75,1> translate <-.168,1.56,-.1> }
    object { e_wall scale <1.170,.75,1> translate <-.168,1.56,5.15> }
    object { roof scale <2.75,1.70,8.5> translate <1.57,1.56,-.25> }
    
    translate y*.15
}

#declare station = union {
    object { b_walk scale <.75,1,.75> translate <-.42,.05,-.1> }
    object { awning scale <.76,.78,.75> translate <-.48,0,-.1> }
    object { building scale .7 }
}