//  Telephone wires include for PovRay 3.5
//  2003 by Ron Gow 

#include "colors.inc"
#include "woods.inc"

#macro t_poles ( num_poles )

//  ***************  textures  *******************
#local pole_tex = texture { T_Wood32 rotate x*88 }

#local insulator_tex = texture {
    pigment { rgbt <.251,.725,.975, .5> }
    finish { reflection .1 phong .25 phong_size 5 }  
}

#local wire_tex = texture { 
    pigment { rgb <.150,.165,.175> }
    finish { ambient 0 specular .2 reflection .15 }
}

//  **************  make poles  ******************        
#local ts = seed(11242);
#local polehgt = 1;
#local polespc = 2;
#local connector_hgt = .85;
#local connector_wdt = .20;


#local t_pole = union{
    cylinder { <0,0,0> <0,polehgt,0> polehgt*.01 }
    cylinder { <-connector_wdt,connector_hgt,0> <connector_wdt,connector_hgt,0> .006 }
}

union {
    #local cnt = 0;
    #local last_tip = <connector_wdt-.05,connector_hgt+.01,-1>;
    #local last_tip2 = <connector_wdt-.14,connector_hgt+.01,-1>;
    #local last_tip3 = <connector_wdt-.32,connector_hgt+.01,-1>;
    #while (cnt < num_poles )
        #local tr = -5+rand(ts)*10;
        #local tip = vrotate(<connector_wdt-.05,connector_hgt+.01,0>, <0,0,tr>)+z*cnt;
        #local tip2 = vrotate(<connector_wdt-.14,connector_hgt+.01,0>, <0,0,tr>)+z*cnt;
        #local tip3 = vrotate(<connector_wdt-.32,connector_hgt+.01,0>, <0,0,tr>)+z*cnt; 
        
        object { t_pole rotate z*tr translate z*cnt texture { pole_tex scale .35}}
        object { sphere { tip, .006 }  texture { insulator_tex } }
        object { sphere { tip2, .006 } texture { insulator_tex } }
        object { sphere { tip3, .006 } texture { insulator_tex } }
        sphere_sweep {
            b_spline
            7
            last_tip-z*.002, .001,
            last_tip-z*.001, .001,
            last_tip, .002,
            (last_tip+tip)/2-y*(.06+rand(ts)*.025), .001,
            tip, .001,
            tip+z*.001, .001 
            tip+z*.002, .001
            texture { wire_tex }
        }
        
        sphere_sweep {
            b_spline
            7
            last_tip2-z*.002, .001,
            last_tip2-z*.001, .001,
            last_tip2, .001,
            (last_tip2+tip2)/2-y*(.06+rand(ts)*.025), .001,
            tip2, .001,
            tip2+z*.001, .001 
            tip2+z*.002, .001
            texture { wire_tex }
        }
        
        sphere_sweep {
            b_spline
            7
            last_tip3-z*.002, .001,
            last_tip3-z*.001, .001,
            last_tip3, .001,
            (last_tip3+tip3)/2-y*(.06+rand(ts)*.025), .001,
            tip3, .001,
            tip3+z*.001, .001 
            tip3+z*.002, .001
            texture { wire_tex }
        }
        
        #local last_tip = tip;
        #local last_tip2 = tip2;
        #local last_tip3 = tip3;
        #local cnt = cnt+polespc;
    #end
}
#end 
