/*
IRTC entry January - February 2003
20(C)03 Peter Hertel http://hertel.no/peter
*/

#declare Shave_Cup =
union{
    difference{//body
        sphere {0,4}
        sphere {y*0.5,3.5}
        box{<-5,1,-5>,5}
        box{-5,<5,-3,5>}
    translate y*3
    }
    torus{4-0.25,0.35 translate y*4}//upper ring
    difference{//handle
        torus{1.5,0.35 rotate z*90 translate <0,2,-4> rotate y*45}
        sphere {y*3,3.75}
    }
texture {T_Shave_Cup}
}

#declare Shave_Brush =
union{
    union{
        sphere {0,2}
        difference{
            cylinder {0,z*-3,2}
            torus{4,2.25 rotate x*90 translate z*-1.5}
        }
        torus{1.6,0.4 rotate x*90 translate z*-3}
    bounded_by {box{<-2.1,-2.1,-3.5>,2.1}}
    texture {T_Shave_Brush_Grip}
    translate z*3.00001
    }
    union{
        cone{0,1.4,z*-4,1.6}
        sphere {z*-4,1.6}
    texture {T_Shave_Brush}
    }
}

// whee, handcoded mesh :)
#declare Remington_Ad =
mesh{
    triangle{<0,1,0>,<1,1,0>,<1,0,1> uv_vectors <0,0>, <1,0>, <1,1>}
    triangle{<0,1,0>,<0,0,1>,<1,0,1> uv_vectors <0,0>, <0,1>, <1,1>}
    
    triangle{<1,1,0>,<2,1,0>,<2,0,1> uv_vectors <1,0>, <2,0>, <2,1>}
    triangle{<1,1,0>,<1,0,1>,<2,0,1> uv_vectors <1,0>, <1,1>, <2,1>}
    
    triangle{<0,0,1>,<1,0,1>,<1,0,2> uv_vectors <0,1>, <1,1>, <1,2>}
    triangle{<0,0,1>,<0,0,2>,<1,0,2> uv_vectors <0,1>, <0,2>, <1,2>}
    
    triangle{<1,0,1>,<2,0,1>,<2,0,2> uv_vectors <1,1>, <2,1>, <2,2>}
    triangle{<1,0,1>,<1,0,2>,<2,0,2> uv_vectors <1,1>, <1,2>, <2,2>}
    
    triangle{<0,0,2>,<1,0,2>,<1,2,3> uv_vectors <0,2>, <1,2>, <1,3>}
    triangle{<0,0,2>,<0,2,3>,<1,2,3> uv_vectors <0,2>, <0,3>, <1,3>}
    
    triangle{<1,0,2>,<2,0,2>,<2,2,3> uv_vectors <1,2>, <2,2>, <2,3>}
    triangle{<1,0,2>,<1,2,3>,<2,2,3> uv_vectors <1,2>, <1,3>, <2,3>}

    uv_mapping
    texture{T_Ad scale <2,3,1>}
scale <0.5,0.1,0.5>
}

#if(DO_ToiletPaper)#include "toiletpaper.inc"#end

#declare Cup_Toothbrush =
union{
    cylinder {  0  ,y*0.1,3.4}//bottom
    cylinder {y*0.1,y*9  ,3.5 open}//outer
    cylinder {y*0.1,y*9  ,3 open}//inner
    torus {3.25,0.25 translate y*9}//top ring
    torus {3.4,0.1 translate y*0.1}//bottom ring
texture {T_Cup_Toothbrush}
}

#local KLR = 2;
#local KLZ = 30;
#declare Klede_Henger =
    union{
        cylinder{x*-KLZ,x*KLZ,KLR}
        cylinder{x*-KLZ,<-KLZ,0,-11>,KLR}
        cylinder{ x*KLZ,< KLZ,0,-11>,KLR}
        cylinder{< KLZ,0,-9.5>,< KLZ,0,-11>,KLR*1.5}
        cylinder{<-KLZ,0,-9.5>,<-KLZ,0,-11>,KLR*1.5}
        sphere { x*KLZ,KLR}
        sphere {x*-KLZ,KLR}
    pigment {rgb 0.5}
    finish {F_Metal}
}

#local KS = 5;// karm_size
#local KT = 1;// karm_thickness
//karm
difference{
    box{<-80-KS,0,-wt-KT>,<KS,200+KS,KT>}
    box{<-80,5.001,-wt-KT*2>,<0,200,KT*2>}
    translate <xn.x+230,0,xn.z>
    texture{T_Door translate x*10}
    texture{pigment {rgb 1 filter 0.25}}
}

// Remington Lektronic Shaver
#include "golds.inc"

#macro Razor_Block(Razor_Block_Height1,Razor_Block_Height2,Razor_Block_Radius)
    box{<1.25,Razor_Block_Height1,-Razor_Block_Radius>,<4.75,Razor_Block_Height2,Razor_Block_Radius>}
    cylinder {<1.25,Razor_Block_Height1,0>,<1.25,Razor_Block_Height2,0>,Razor_Block_Radius}
    cylinder {<4.75,Razor_Block_Height1,0>,<4.75,Razor_Block_Height2,0>,Razor_Block_Radius}
#end

#declare Remington_Shaver =
union{
    union{// shaver
        Razor_Block(0,0.25,1)//bottom
        Razor_Block(0.25,4,1.25)//middle
        box{<1.25,0.25,-1.33>,<4.75,3.4,1.33>}
        Razor_Block(4,4.1,1.2)//top1
        Razor_Block(4.1,4.5,1.25)//top2
        difference{
            union{
                cylinder{y*-0.5,y*2,1 scale <1,1,1.25> rotate z*-15 translate <1.25,4.5,0>}
                cylinder{y*-0.5,y*2,1 scale <1,1,1.25> rotate z*15  translate <4.75,4.5,0>}
                box{<1.25,4.5,-1.25>,<4.75,6.5,1.25>}
            }
            box{<1,5.8,-1.26>,<5,7,1.26>}
        }
    
        union{
            box{<1.25,0,-1>,<4.75,0.25,1>}
            cylinder {<1,0.125,0>,<5,0.125,0>,0.125}
        texture {T_Gold_5E}
        normal {granite 0.5 scale <4,1,1>}
        translate y*6
        }
    pigment {image_map {jpeg "remington.jpg" interpolate 2} scale <6,6.5,1>}
    }

    union{// charger
        difference{
            union{Razor_Block(0,3  ,1.5 )}
            union{Razor_Block(2,3.1,1.25)}
        }
        difference{
            cylinder {<2,2,0>,<2,3.5,0>,1}
            box{<2.1,2.5,-0.5>,<2.5,3.6,0.5>}
        }
        cylinder {<4  ,2,-0.7>,<4  ,4  ,-0.7>,0.5}
        cylinder {<4  ,3,-0.7>,<4  ,4.5,-0.7>,0.25}
        cylinder {<3.7,2, 0.7>,<3.7,4  , 0.7>,0.25 pigment {rgb x*1}}
    texture{
        pigment {rgb 0.7}
        normal {granite 0.05 scale 2}
    }
    rotate y*-30 translate <5,0,-3>
    }
}

