// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// Persistence of Vision Ray Tracer Scene Description File
// File: anvil.inc
// Vers: 3.5
// Desc: anvil for blacksmithing tools
// Date: January 15th, 2003
// Auth: Steve Shoopak

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// ----------------------------------------------------------+
// Version: 1.0                                               
//                                                            
// History: 0.1 <Auth> 20030115 - File created.               
//          1.0 <Auth> 20030116 - Anvil finished.               
// ----------------------------------------------------------+

// | ------------------------------------------------------- |
// | IRTC Stills Topic: Old Technology                       |
// | ------------------------------------------------------- |
// | Details : Technology which is identifiably "old". Plow, |
// |           shadouf, chariot, aqueduct, square-rigger,    |
// |           printing press, Jacquard loom, cotton gin,    |
// |           telegraph key, vacuum tube radio or computer, |
// |           Sputnik. Modern technology in its formative   |
// |           stages.                                       |
// | ------------------------------------------------------- |
// | Stills Competition Ending : February 28th, 2003         |
// | ------------------------------------------------------- |

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// standard includes ----------------------------------------+

#include "colors.inc"
#include "textures.inc"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// base -----------------------------------------------------+

// base components

// :: base
#declare anvilBase = box { -1,1 }

// cutouts --------------------------------------------------+

// :: cutouts
#declare neckco = cylinder {
  z,-z,0.5
  scale <2.5,1.5,1.00001>
}

#declare sideco = box {
  -1,1
  translate y
  scale <1.0001,1,1>
}

#declare feetco = cylinder {
  y,-y,0.5
  scale <1.125,2,1>
}

#declare faceco = box { -1,1 }

#declare hardco = box {
  -1,1
  scale <0.1375,2,0.1375>
}

#declare pritco = cylinder {
  -y,y,1
  scale <0.09,2,0.09>
}

// :: cutout composite
#declare anvilCo = union {
  object { neckco translate <-1.75,0,0> }
  object { neckco translate < 1.75,0,0> }
  object { neckco translate <-1.75,0,0> rotate -y*90 }
  object { neckco translate <-1.75,0,0> rotate  y*90 }
  object { sideco translate -z*1.5 }
  object { sideco translate  z*1.5 }
  object { feetco translate -z*1 }
  object { feetco translate  z*1 }
  object { faceco translate <-1.625,1.875,0> }
  object { hardco translate  x*1.125 }
  object { pritco translate <1.5,0,-0.3125> }
}


// face -----------------------------------------------------+

#declare anvilFace = box { 
  -1,1
  scale <1,0.25,0.5>
  translate <0.75,0.75,0>
}

// horn -----------------------------------------------------+

#declare anvilHorn = cone {
  -x,0,x,1
  matrix // this bends the horn into the right shape
  <
    1,-0.25,0,
    0,0.5,0,
    0,0,0.475,
    -1.5,0.625,0
  >
}

// anvil ----------------------------------------------------+

// :: complete anvil composite
#declare anvilComp = merge {
  object { anvilHorn }
  difference {
    union {
      object { anvilBase }
      object { anvilFace }
    }
    object { anvilCo }
  }
}

// :: anvil with texture
#declare anvil = object {
  anvilComp
  texture {
    normal { granite 0.05 }
    pigment { color rgb <0.6, 0.6, 0.7> }
    finish { ambient 0.125 diffuse 0.825 specular 0.5 }
  }
  translate y
}