// Persistence of Vision Ray Tracer Scene Description File
// File: cassette.pov
// Vers: 3.5
// Desc: IRTC topic "Old Technology"
// Date: 2-23-03
// Auth: James Moore

#include "finish.inc"
#include "shapes.inc"
#include "metals.inc"
#include "rand.inc"
#include "cassette.inc"
#include "radio.inc"

#declare hqrad=yes;

global_settings {
	max_trace_level 10
	#if (hqrad=no)
		radiosity {		//test render rad settings
			count 35
			nearest_count 9
	    	distance_maximum 0.1
    		error_bound 0.4
    		minimum_reuse 0.01
	    	pretrace_start 0.08
    		pretrace_end   0.04
    		brightness 2
	    	normal on
    		media on
		}
	#else
		radiosity {
			count 100
			nearest_count 9
	    	distance_maximum 0.1
    		error_bound 0.4
    		minimum_reuse 0.01
	    	pretrace_start 0.08
    		pretrace_end   0.004
    		brightness 2
	    	normal on
    		media on
		}
	#end
	ambient_light 0.25
}

camera {
	up y
	right x*image_width/image_height
	location <0.25, 1.25, -3>
	look_at <-0.25, 0.4, 0>
}

#declare gnd=-4;	//y pos of floor

#declare carpet=
plane {y, gnd
	hollow
	pigment {
		bumps
		scale 0.1
		color_map {
			[0 blue 0.1]
			[0.1 blue 0.1]
			[0.1 rgb <0.5, 0.5, 0.75>]
			[1 rgb <0.5, 0.5, 0.75>]
		}
	}
	normal {bumps scale 0.1}
	finish {ambient 0.2}
}

#declare baseboard=
object {
	Round_Box_Union(<-10, -10, 2.95>, <10, gnd+0.3, 3.1>, 0.01)
	pigment {rgb 1}
	finish {Dull}
}

#declare walls=
union {
	box {<-10, gnd-0.02, -10>, <10, 6, 3>
		pigment {
			wrinkles scale 0.3
			color_map {
				[0 rgb <1, 1, 0.95>]
				[1 rgb <0.95, 0.95, 0.9>]
			}
		}
		finish {
			specular 0.2
			roughness 0.2
			ambient 0.2
		}
		normal {wrinkles 0.2 scale 0.3}
	}
	hollow
}

#declare t_wood=
texture {
	pigment {
		wood turbulence 0.1
		color_map {
			[0 rgb <0.75, 0.6, 0.3>*0.9]
			[0.5 rgb <0.75, 0.6, 0.3>]
			[0.95 rgb <0.75, 0.6, 0.3>*0.95]
			[1 rgb <0.75, 0.6, 0.3>*0.8]
		}
		scale <0.2, 0.1, 0.2>
		rotate y*85
		translate y*0.125
	}
	finish {specular 0.8 roughness 0.001}
	normal {dents scale <0.2, 0.005, 0.01> turbulence 0.2}
}

#declare t_dirt=
texture {
	pigment {
		wrinkles
		scale 0.2
		color_map {
			[0 rgb <0.7, 0.55, 0.2>*0.5]
			[1 rgb <0.7, 0.55, 0.2>*0.25]
		}
	}
	normal {wrinkles scale 0.2}
}

#declare t_table=
texture {
	wrinkles turbulence 0.1
	scale <0.1, 0.05, 0.05>
	texture_map {
		[0 t_wood scale <10, 20, 20>]
		[0.8 t_wood scale <10, 20, 20>]
		[0.95 t_dirt]
		[1 t_dirt]
	}
}
		
#declare table=
union {
	object {
		Round_Box_Union(<-3, -1, -1.3>, <3, 0, 2.2>, 0.1) scale <1, 0.2, 1>
		texture {t_table}
	}
	union {
		Round_Box_Merge(<-2.8, gnd, -1.1>, <-2.5, -0.2, -0.8>, 0.05)
		Round_Box_Merge(<2.8, gnd, -1.1>, <2.5, -0.2, -0.8>, 0.05)
		Round_Box_Merge(<-2.8, gnd, 2>, <-2.5, -0.2, 1.7>, 0.05)
		Round_Box_Merge(<2.8, gnd, 2>, <2.5, -0.2, 1.7>, 0.05)
		texture {t_table translate y*0.4}
	}
	union {
		box {<-2.5, -0.6, -1.05>, <2.5, -0.2, -0.85>}
		box {<-2.5, -0.6, 1.75>, <2.5, -0.2, 1.95>}
		box {<-2.75, -0.6, -0.8>, <-2.55, -0.2, 1.7>}
		box {<2.75, -0.6, -0.8>, <2.55, -0.2, 1.7>}
		texture {t_table rotate x*90 translate y*0.6}
	}
	union {
		Round_Box_Union(<-2.53, gnd*0.75, 1.75>, <2.53, gnd*0.75+0.2, 1.95>, 0.03)
		Round_Box_Union(<-2.75, gnd*0.75, -0.83>, <-2.55, gnd*0.75+0.2, 1.73>, 0.03)
		Round_Box_Union(<2.75, gnd*0.75, -0.83>, <2.55, gnd*0.75+0.2, 1.73>, 0.03)
		texture {t_table}
	}
}

#declare cstack=
union {
	object {cassette("caslabel3.png", yes) rotate <90, -15, 0> translate <0.8, 0.0276, -0.1>}
	object {cassette("caslabel1.png", yes) rotate x*90 translate <0.3, 0.0276, 0> rotate <0, 5, (90-atan2d(0.5, 0.0552))>}
	rotate y*-30
	translate <0.45, 0, -1.2>
}

#declare rdocas= object {radiocas_union rotate y*150 translate <0.5, 0.001, -0.1>}

#declare lamp=
union {
	#local trs1=5;
	#local trs2=-70;
	#local trn=-65;
	#local trl=-5;
	#local trs1=15;
	#local trs2=-70;
	#local trn=-50;
	#local trl=-5;
	difference {
		cylinder {<0, 0, 0>, <0, 0.15, 0>, 0.4}
		torus {0.4, 0.4 scale <1, 0.8, 1> translate y*0.38}
	}
	cylinder {<0, 0, 0>, <0, 0.25, 0>, 0.03}	
	union {
		union {
			cylinder {<-0.1, 0, 0>, <0.1, 0, 0>, 0.03}
			cylinder {<-0.08, 0, 0>, <-0.08, 1, 0>, 0.015}
			cylinder {<0.08, 0, 0>, <0.08, 1, 0>, 0.015}
			cylinder {<-0.1, 1, 0>, <0.1, 1, 0>, 0.03}
			transform {rotate x*trs1}
		}
		union {
			cylinder {<0, 0, 0>, <0, 1, 0>, 0.02}
			sphere {<0, 1, 0>, 0.02}
			difference {
				Round_Cone_Merge (<0, 1.1, -0.01>, 0.2, <0, 1.1, -0.21>, 0.4, 0.05)
				object {
					Round_Cone_Merge (<0, 1.1, -0.06>, 0.2, <0, 1.1, -0.26>, 0.4, 0.03)
					pigment {rgb 1}
					finish {
						metallic
						brilliance 10
						ambient 1.65
						specular 0.8
						roughness 0.01
						reflection 0.1
					}
				}
			}
			light_source {<0, 1.1, -0.125> color rgb <1, 1, 0.95>
				spotlight point_at <0, 1.1, -2> radius 55 falloff 60
				looks_like {
					sphere {0, 1 hollow
						pigment {rgbt 1}
						finish {ambient 0.5}
						interior {
							media {
								method 3
								samples 3, 3
								emission 4
								density {
									spherical
									density_map {
										[0 rgb 0]
										[0.5 rgb 0.25]
										[1 rgb 1]
									}
								}
							}
						}
						scale <0.2, 0.2, 0.05>
					}
				}
			}
			rotate y*trl
			transform {rotate x*trs2}
			translate vtransform (<0, 1, 0>, transform {rotate x*trs1})
		}
		rotate y*trn
		translate y*0.25
	}
	pigment {rgb 0.8}
	finish {
		metallic
		brilliance 6
		phong 0.3
		phong_size 100
		reflection {0.1, 0.7}
	}
	translate <-2.2, 0, 1.2>
}

#declare radio_cord=
sphere_sweep {
	b_spline
	12
	//transformation of radio & radcas_union to keep end of cord attached to radio
	vtransform (<1.05, 0.3, 0>, transform {translate z*1.1 rotate y*230 rotate y*150 translate <0.5, 0.001, -0.1>}), 0.01
	vtransform (<1.3, 0.3, 0>, transform {translate z*1.1 rotate y*230 rotate y*150 translate <0.5, 0.001, -0.1>}), 0.01
	vtransform (<1.35, 0.3, 0>, transform {translate z*1.1 rotate y*230 rotate y*150 translate <0.5, 0.001, -0.1>}), 0.01
	vtransform (<1.4, 0.02, 0.1>, transform {translate z*1.1 rotate y*230 rotate y*150 translate <0.5, 0.001, -0.1>}), 0.01
	<2.7, 0.02, 1.8>, 0.01
	<2.75, 0.02, 2.1>, 0.01
	<2.8, 0.015, 2.15>, 0.01
	<2.85, 0, 2.3>, 0.01
	<2.9, -1, 2.26>, 0.01
	<2.95, -2, 2.4>, 0.01
	<3, gnd-0.1, 2.2>, 0.01
	<5, gnd, 2.2>, 0.01
	pigment {rgb 0.1}
	finish {phong 0.3 phong_size 3 ambient 0.2}
}

#declare lamp_cord=
sphere_sweep {
	b_spline
	12
	//transformation of lamp to keep end of cord attached to lamp
	vtransform (<0, 0.02, 0>, transform {rotate y*60 translate <-2.2, 0, 1.4>}), 0.01
	vtransform (<0, 0.02, 0>, transform {rotate y*60 translate <-2.2, 0, 1.4>}), 0.01
	vtransform (<-0.4, 0.02, 0>, transform {rotate y*60 translate <-2.2, 0, 1.4>}), 0.01
	vtransform (<-0.5, 0.02, 0>, transform {rotate y*60 translate <-2.2, 0, 1.4>}), 0.01
	vtransform (<-0.3, 0.02, 0.6>, transform {translate <-2.2, 0, 1.4>}), 0.01
	<-2.95, 0.015, 2.1>, 0.01
	<-3.1, 0, 2>, 0.01
	<-3.06, -1, 2>, 0.01
	<-3, -2, 2>, 0.01
	<-3.2, gnd-0.1, 2>, 0.01
	<-5, gnd, 2>, 0.01
	<-10, gnd, 2>, 0.01
	pigment {rgb 0.1}
	finish {phong 0.3 phong_size 3 ambient 0.2}
}

#declare ruler=
box {<-0.875, 0, -0.075>, <0.875, 0.01, 0.075>
	pigment {
		image_pattern {png "ruler.png" interpolate 2}
		color_map {
			[0 rgb 0.1]
			[0.3 rgb 0.1]
			[0.3 rgb <0.25, 0.5, 0.7>]
			[1 rgb <0.25, 0.5, 0.7>]
		}
		rotate x*90
		translate <-0.5, 0, -0.5>
		scale <1.75, 1, 0.15>
	}
	finish {
    	specular 0.
    	roughness 0.4
    }
	rotate y*-25
	translate <-1.15, 0.087, -0.22>
}

#declare pencil=
union {
	//center of pencil
	difference {
		object {
			Round_Cone_Union(<0, 0, -0.35>, 0.002, <0, 0, 0.45>, 0.15, 0.001)
			pigment {
				cylindrical
				color_map {
					[0 rgb <0.7, 0.7, 0.35>]
					[0.994 rgb <0.7, 0.7, 0.35>]
					[0.994 rgb 0.25]
					[1 rgb 0.25]
				}
				rotate x*90
			}
		}
		//hex shape
		union {
			plane {y, 0.017 inverse rotate z*0}
			plane {y, 0.017 inverse rotate z*60}
			plane {y, 0.017 inverse rotate z*120}
			plane {y, 0.017 inverse rotate z*180}
			plane {y, 0.017 inverse rotate z*240}
			plane {y, 0.017 inverse rotate z*300}
			pigment {rgb <1, 1, 0>}
			finish {Shiny}
		}
		text {
			ttf "crystal.ttf" "The Pencil Company" 1, 0
			rotate <90, 90, 0>
			scale <0.018, 1, 0.018>
			translate <-0.005, 0.02, 0.35>
			pigment {rgb 0}
			finish {ambient 0 diffuse 0}
		}
	}
	//eraser
	cylinder {<0, 0, 0.43>, <0, 0, 0.48>, 0.02
		texture {T_Chrome_5E
			normal {gradient z sine_wave scale <0.02, 0.02, 0.008>}
		}
	}
	cylinder {<0, 0, 0.48>, <0, 0, 0.5>, 0.02 texture {T_Chrome_5E}}
	object {
		Round_Cylinder_Union(<0, 0, 0.499>, <0, 0, 0.53>, 0.02, 0.008)
		pigment {rgb <1, 0.5, 0.5>}
		finish {specular 0.1 roughness 0.5}
	}
	rotate z*-60
	rotate y*35
	translate <-0.6, 0.108, -0.37>
}

#declare pen=
union {
	union {
		Round_Cone_Union(<-0.15, 0, 0>, 0.025, <0.15, 0, 0>, 0.02, 0.01)
		difference {
			Round_Box_Merge (<-0.05, 0.02, -0.01>, <0.13, 0.035, 0.01>, 0.002)
			Round_Box_Merge (<-1, -1, -1>, <0.1, 0.03, 1>, 0.001)
			texture {T_Chrome_5E}
		}
		cylinder {<-0.04, 0.03, -0.01>, <-0.04, 0.03, 0.01>, 0.01
			clipped_by {plane {y, 0.03}}
			texture {T_Chrome_5E}
		}
		translate x*0.25
	}
	cylinder {<-0.15, 0, 0>, <0.2, 0, 0>, 0.021}
	object {
		Round_Cone_Union (<-0.25, 0, 0>, 0.003, <-0.15, 0, 0>, 0.021, 0.002)
		texture {
			gradient x
			texture_map {
				[0 pigment {rgb 0}]
				[0.01 pigment {rgb 0}]
				[0.01 pigment {rgb 1} finish {Shiny}]
				[0.025 pigment {rgb 1} finish {Shiny}]
				[0.025 pigment {rgb 0.05} finish {Dull}]
				[1 pigment {rgb 0.05} finish {Dull}]
			}
			translate x*-0.25
		}
	}
	pigment {rgb 0.05}
	finish {Dull}
	rotate x*-90
	scale <1.2, 1, 1>
	rotate y*-20
	translate <0.1, 0.0125, -0.95>
}

#macro col_pencil(col, len)
	union {
		cylinder {<0, 0, 0>, <0, len, 0>,  0.018}
		Round_Cone_Union (<0, len, 0>, 0.018, <0, len+0.07, 0>, 0.002, 0.001)
		texture {
			cylindrical
			texture_map {
				[0 col finish {Dull}]
				[0.05 col finish {Dull}]
				[0.05 pigment {rgb <0.8, 0.8, 0.5>}]
				[0.65 pigment {rgb <0.8, 0.8, 0.5>}]
				[0.65 col]
				[1 col]
			}
			scale 0.018
		}
	}
#end

#declare mx=12;
#declare col=array[mx];
#declare col[0]=pigment {blue 0.5};
#declare col[1]=pigment {green 0.3};
#declare col[2]=pigment {red 0.8};
#declare col[3]=pigment {rgb <1, 1, 0>};
#declare col[4]=pigment {rgb <1, 0.5, 0>};
#declare col[5]=pigment {rgb <1, 0, 1>};
#declare col[6]=pigment {rgb 0.5};
#declare col[7]=pigment {rgb 1};
#declare col[8]=pigment {rgb 0.05};
#declare col[9]=pigment {rgb <1, 0.75, 0.75>};
#declare col[10]=pigment {rgb <0.5, 1, 0.5>};
#declare col[11]=pigment {rgb <0.75, 0.75, 1>};

#declare cup=
union {
	#declare c=0;
	#declare sd=seed(1);
	#while (c<mx)
		object {
			col_pencil(col[c], RRand(0.55, 0.75, sd))
			#declare dist=RRand(0.05, 0.125, sd);
			translate <0, 0.05, dist>
			rotate x*(90-degrees(atan(0.45/(0.14-dist))))
			rotate y*(c*360/13)
		}
		#declare c=c+1;
	#end
	merge {
		difference {
			Round_Cylinder_Merge(<0, 0, 0>, <0, 0.6, 0>, 0.2, 0.05)
			Round_Cylinder_Merge(<0, 0.03, 0>, <0, 1, 0>, 0.18, 0.05)
			plane {y, 0.5 inverse}
		}
		torus {0.19, 0.01 translate y*0.5}
		torus {0.075, 0.025
			rotate x*90
			scale <1, 1.5, 2>
			translate <0.22, 0.275, 0>
			clipped_by {object {Round_Cylinder_Union(0, y*1, 0.16, 0.05) inverse}}
		}
		rotate y*135
		pigment {rgb <0, 0, 1>}
		finish {Phong_Glossy}
	}
	scale 0.95
	translate <-1.3, 0, 0.6>
}

#declare tablet=
union {
	#local rad1=0.05;
	#local rad2=0.005;
	#local sp=0.03;
	#local minx=-0.82;
	#local maxx=0.82;
	
	//paper
	difference {
		union {
		
			//pages
			box {<-0.8, -0.03, 0>, <0.8, 0.035, -1.2>
				pigment {rgb <1, 1, 0.85>}
				normal {gradient y scallop_wave scale <0.03, 0.01, 0.03>}
				finish {specular 0.1 roughness 0.8}
			}
			
			//cover
			box {<-0.81, -0.035, 0>, <0.81, -0.03, -1.21>
				pigment {red 0.25}
				finish {specular 0.1 roughness 0.7}
			}
			
			//top page
			bicubic_patch {
				type 1 flatness 0.001
				u_steps 4 v_steps 4
				<-0.8, 0, -0.6>, <-0.3, 0, -0.6>, <0.7, 0, -0.6>, <0.8, 0.05, -0.6>
				<-0.8, 0, -0.2>, <-0.3, 0, -0.2>, <0.3, 0, -0.2>, <0.8, 0, -0.5>
				<-0.8, 0, 0.2>, <-0.3, 0, 0.2>, <0.3, 0, 0.2>, <0.8, 0, 0.2>
				<-0.8, 0, 0.6>, <-0.3, 0, 0.6>, <0.3, 0, 0.6>, <0.8, 0, 0.6>
				pigment {
					image_map {png "paper.png" once}
					rotate x*90
					translate <-0.5, 0, -0.5>
					scale <1.6, 1, 1.2>
				}
				normal {crackle 0.25 scale 0.03 turbulence 0.4}
				finish {specular 0.1 roughness 0.8}
				translate <0, 0.04001, -0.6>
			}
		}
		
		//holes
		#local cx=minx;
		#while (cx<maxx)
			cylinder {<cx+0.5*sp-rad2*1.5, -1, -rad1>, <cx+0.5*sp-rad2*1.5, 1, -rad1>, rad2*3}
			#local cx=cx+sp*2;
		#end
		pigment {rgb <1, 1, 0.98>}
		normal {crackle 0.25 scale 0.03 turbulence 0.4}
		finish {specular 0.1 roughness 0.8}
	}
	
	//spiral ring
	#local ang=degrees(asin(0.5*sp/rad1));
	#local c=0;
	#local cx=minx;
	#while (cx<maxx)
		torus {rad1, rad2
			#if (odd(c))
				rotate z*(90+ang)
				clipped_by {plane {z, 0 inverse}}
			#else
				rotate z*(90-ang)
				clipped_by {plane {z, 0}}
			#end
			translate x*cx
			texture {T_Chrome_2C}
		}
		#local c=c+1;
		#local cx=cx+sp;
	#end
	
	translate y*(sqrt(pow(sp/2,2)+pow(rad1,2)))
	
	//transformations
	rotate y*-10
	translate <-1, 0, 0.2>
}

#declare frame=
union {
	sphere {<-1.5, -1.125, 0>, 0.05}
	sphere {<1.5, -1.125, 0>, 0.05}
	sphere {<-1.5, 1.125, 0>, 0.05}
	sphere {<1.5, 1.125, 0>, 0.05}
	cylinder {<-1.5, -1.125, 0>, <1.5, -1.125, 0>, 0.05}
	cylinder {<-1.5, 1.125, 0>, <1.5, 1.125, 0>, 0.05}
	cylinder {<-1.5, -1.125, 0>, <-1.5, 1.125, 0>, 0.05}
	cylinder {<1.5, -1.125, 0>, <1.5, 1.125, 0>, 0.05}
	scale <1, 1, 0.25>
	texture {t_wood}
}

#declare posters=
union {
	box {<-0.5, -0.5, -0.001>, <0.5, 0.5, 0.001>
		pigment {
			image_map {jpeg "stonehenge.jpg" interpolate 2 once}
			translate <-0.5, -0.5, 0>
		}
		finish {specular 0.5 roughness 0.15 ambient 1}
		scale <2, 1.5, 1>*1.5
		translate <1.8, 1.2, 3>
	}
	object {frame translate <1.8, 1.2, 3>}
	object {frame translate <-3, 1.2, 3>}
	box {<-0.5, -0.5, -0.001>, <0.5, 0.5, 0.001>
		pigment {
			image_map {jpeg "pyramids.jpg" interpolate 2 once}
			translate <-0.5, -0.5, 0>
		}
		finish {specular 0.5 roughness 0.15 ambient 0.1}
		scale <2, 1.5, 1>*1.5
		translate <-3, 1.2, 3>
	}
}

//object placements
object {carpet}
object {baseboard}
object {walls}
object {posters}
object {table}
object {lamp}
object {lamp_cord}
object {cup}
object {tablet}
object {ruler}
object {pencil}
object {pen}
object {cstack}
object {rdocas}
object {radio_cord}