// Persistence of Vision Ray Tracer Scene Description File
// File: radio.inc
// Vers: 3.5
// Desc: radio & loose tape definition - must include "cassette.inc" in main file first
// Date: 2/11/03
// Auth: James Moore


//white plastic texture 
#declare t_wplas1=
texture {
	pigment {rgb 0.9}
	finish {
		metallic
    	brilliance 2
    	diffuse 0.3
    	specular 0.8
    	roughness 0.05
    }
}

#declare t_wplas2=
texture {
	pigment {rgb 0.6}
	finish {
		metallic
    	brilliance 2
    	diffuse 0.3
    	specular 0.5
    	roughness 0.05
    }
}

#declare t_wplas=
texture {
	wrinkles
	scale 0.05
	texture_map {
		[0 t_wplas1]
		[0.7 t_wplas1]
		[0.95 t_wplas2]
		[1 t_wplas2]
	}
}
		

//texture of print on radio
#declare t_words=texture {pigment {rgb 0}}

//black plastic texture
#declare t_bplas=
texture {
	pigment {rgb 0.05}
	finish {
    	specular 0.5
    	roughness 0.15
    }
}

//speaker texture
#declare t_speaker1=
texture {
	pigment {rgb 0.01}
	finish {
		metallic
	    brilliance 2
    	diffuse 0.3
    	specular 0.8
	    roughness 0.12
	}
}

#declare t_speaker2=
texture {
	pigment {rgb 0.2}
	finish {
		metallic
	    brilliance 2
    	diffuse 0.3
    	specular 0.8
	    roughness 0.12
	}
}

#declare t_speaker=
texture {
	wrinkles
	scale 0.05
	texture_map {
		[0 t_speaker1]
		[0.7 t_speaker1]
		[0.95 t_speaker2]
		[1 t_speaker2]
	}
}

//invisible texture
#declare t_clear=texture {pigment {rgbt 1}}

//texture of clear cassette door
#declare t_cplas=
texture {
	pigment {rgbf <0.5, 0.5, 0.55, 0.85>}
	finish {
    	specular 0.8
    	roughness 0.05
    	reflection 0.15
    }
}

//interior of cassette door
#declare i_plas=interior {ior 1.5}

#declare t_brub=
texture {
	pigment {rgb 0.1}
	finish {phong 0.3 phong_size 3 ambient 0.2}
}

//radio
#declare radio=
union {
	//outer case
	difference {
		union {
			difference {
				object {Round_Box_Merge (<-1.2, 0, -0.25>, <1.2, 0.81, 0.25>, 0.05)}
				box {<-1.1, -1, -1>, <1.1, 1, 1> inverse}
				box {<-2, -1, -1>, <-0.499, 1, -0.175>}
				box {<2, -1, -1>, <0.499, 1, -0.175>}
				box {<-0.4, 0.8, -1>, <0.4, 1, 0>}
			}
			object {Round_Box_Merge (<1.2, 0, -1>, <0.45, 0.8, 1>, 0.05) scale <1, 1, 0.25>}
			object {Round_Box_Merge (<-1.2, 0, -1>, <-0.45, 0.8, 1>, 0.05) scale <1, 1, 0.25>}
		}
		merge {
			Round_Box_Merge (<-1.15, 0.05, -1>, <-0.5, 0.75, -0.2>, 0.025)
			Round_Box_Merge (<1.15, 0.05, -1>, <0.5, 0.75, -0.2>, 0.025)
			pigment {rgb 0.1}
		}
		box {<-0.34, 0.67, -1>, <0.34, 0.75, 0>}		//cutout for tuner label image pattern
		box {<-1.09, 0.8, 0.01>, <1.09, 1, 0.2>}		//cutout for top controls label image pattern
		box {<-0.3, 0.78, -0.2>, <0.3, 1, -0.01>}		//cutout for tape controls label image pattern
		box {<-1, 0.78, -0.16>, <-0.6, 1, -0.02>}		//cutout for brand name label
		box {<0.69, 0.75, -0.13>, <0.91, 1, -0.05>}		//cutout for tuner wheel - center <0.8, y, 0.09>
		box {<0.6, 0.75, -0.15>, <1, 0.805, -0.09>}		//cutout for tuner wheel
		box {<1.1375, 0.75, -0.02>, <1.1025, 1, 1>}		//cutout for handle
		box {<-1.1375, 0.75, -0.02>, <-1.1025, 1, 1>}	//cutout for handle
		Round_Box_Merge (<1.15, 0.2, -0.075>, <2, 0.45, 0.075>, 0.01)		//cutouts for power plug
		box {<1.14, 0.36, -0.07>, <2, 0.43, 0.07> pigment {red 1}}
		union {
			cylinder {<0, 0.02, 0>, <1, 0.02, 0>, 0.032}
			box {<0, -0.02, -0.032>, <1, 0.02, 0.032>}
			cylinder {<0, -0.02, 0>, <1, -0.02, 0>, 0.032}
			translate <1.05, 0.3, 0>
			texture {t_brub}
		}
		intersection {
			box {<-0.05, -0.35, -0.35>, <0.05, 0.35, 0.35>}
			box {<-0.0499, -0.35, -0.35>, <0.0499, 0.35, 0.35> rotate x*45}
			texture {t_bplas}
			scale <1, 1, 0.15>
			translate <-0.425, 0.4, -0.25>
		}
		intersection {
			box {<-0.05, -0.35, -0.35>, <0.05, 0.35, 0.35>}
			box {<-0.0499, -0.35, -0.35>, <0.0499, 0.35, 0.35> rotate x*45}
			texture {t_bplas}
			scale <1, 1, 0.15>
			translate <0.425, 0.4, -0.25>
		}
		box {<-0.35, 0.05, -1>, <0.35, 0.65, -0.245>}
		box {<-0.33, 0.14, -1>, <0.33, 0.58, -0.142> pigment {rgb 0.25} finish {Dull}}	//inside texture
		box {<-0.05, 0.1, -0.22>, <0.05, 0.2, 0>}
		texture {t_wplas}
	}
	
	//power plug
	union {
		cylinder {<0, 0.02, 0>, <0.2, 0.02, 0>, 0.03}
		box {<0, -0.02, -0.03>, <0.2, 0.02, 0.03>}
		cylinder {<0, -0.02, 0>, <0.2, -0.02, 0>, 0.03}
		sphere {<0.2, 0.02, 0>, 0.03}
		cylinder {<0.2, 0.02, 0>, <0.2, -0.02, 0>, 0.03}
		sphere {<0.2, -0.02, 0>, 0.03}
		sphere {<0.2, 0, 0>, 0.025}
		translate <1.05, 0.3, 0>
		texture {t_brub}
	}
	
	//prongs in ac plug
	cylinder {<1.05, 0.32, 0>, <1.14, 0.32, 0>, 0.005 texture {T_Chrome_4D}}
	cylinder {<1.05, 0.28, 0>, <1.14, 0.28, 0>, 0.005 texture {T_Chrome_4D}}
	
	//ac plug label
	box {<1.14, 0.36, -0.07>, <1.15, 0.43, 0.07>
		texture {
			image_pattern {png "aclabel.png" interpolate 2}
			texture_map {
				[0 t_words]
				[0.7 t_words]
				[0.7 t_wplas]
				[1 t_wplas]
			}
			rotate y*-90
			scale <1, 0.07, 0.14>
			translate <0, 0, -0.07>
		}
	}
	//brand name label
	box {<-1, 0.78, -0.16>, <-0.6, 0.81, -0.02>
		texture {
			image_pattern {png "brandname.png" interpolate 2}
			texture_map {
				[0 t_words]
				[0.7 t_words]
				[0.7 t_wplas]
				[1 t_wplas]
			}
			rotate x*90
			scale <0.4, 1, 0.14>
			translate <-1, 0, -0.16>
		}
	}
	
	//tape controls label
	difference {
		box {<-0.3, 0.78, -0.2>, <0.3, 0.8, -0.01>
			texture {
				image_pattern {png "tapelabels.png" interpolate 2}
				texture_map {
					[0 t_words]
					[0.7 t_words]
					[0.7 t_wplas]
					[1 t_wplas]
				}
				rotate x*90
				scale <0.6, 1, 0.19>
				translate <-0.3, 0, -0.15>
			}
		}
		box {<-0.275, 0.79, -0.055>, <0.275, 1, 0.055>
			pigment {rgb 0.05}
			translate <0, 0, -0.1>
		}
	}
	
	//eject button
	difference {
		Round_Box_Merge (<-0.045, 0.78, -0.05>, <0.045, 0.83, 0.05>, 0.01)
		intersection {
			box {<-1, 0.825, -1>, <1, 1, 1>}
			plane {-z, 0.0065}
			plane {-z, 0.0065 rotate y*120}
			plane {-z, 0.0065 rotate y*240}
			translate z*0.005
		}
		box {<-0.01, 0.825, -0.02>, <0.01, 1, -0.01>} 
		texture {t_bplas}
		translate <-0.225, 0, -0.1>
	}
	
	//stop button
	difference {
		Round_Box_Merge (<-0.045, 0.78, -0.05>, <0.045, 0.83, 0.05>, 0.01)
		box {<-0.016, 0.825, -0.016>, <0.016, 1, 0.016>}
		texture {t_bplas}
		translate <-0.1325, 0, -0.1>
	}
	
	//ffwd button
	difference {
		Round_Box_Merge (<-0.045, 0.78, -0.05>, <0.045, 0.83, 0.05>, 0.01)
		intersection {
			box {<-1, 0.825, -1>, <1, 1, 1>}
			plane {-z, 0.0065 rotate y*90}
			plane {-z, 0.0065 rotate y*210}
			plane {-z, 0.0065 rotate y*330}
			translate x*-0.011
		}
		intersection {
			box {<-1, 0.825, -1>, <1, 1, 1>}
			plane {-z, 0.0065 rotate y*90}
			plane {-z, 0.0065 rotate y*210}
			plane {-z, 0.0065 rotate y*330}
			translate x*0.011
		}
		texture {t_bplas}
		translate <-0.04, 0, -0.1>
	}
	
	//rew button
	difference {
		Round_Box_Merge (<-0.045, 0.78, -0.05>, <0.045, 0.83, 0.05>, 0.01)
		intersection {
			box {<-1, 0.825, -1>, <1, 1, 1>}
			plane {-z, 0.0065 rotate y*-90}
			plane {-z, 0.0065 rotate y*-210}
			plane {-z, 0.0065 rotate y*-330}
			translate x*-0.011
		}
		intersection {
			box {<-1, 0.825, -1>, <1, 1, 1>}
			plane {-z, 0.0065 rotate y*-90}
			plane {-z, 0.0065 rotate y*-210}
			plane {-z, 0.0065 rotate y*-330}
			translate x*0.011
		}
		texture {t_bplas}
		translate <0.055, 0, -0.1>
	}
	
	//play button
	difference {
		Round_Box_Merge (<-0.045, 0.78, -0.05>, <0.115, 0.83, 0.05>, 0.01)
		intersection {
			box {<-1, 0.825, -1>, <1, 1, 1>}
			plane {-z, 0.0075 rotate y*90}
			plane {-z, 0.0075 rotate y*210}
			plane {-z, 0.0075 rotate y*330}
		}
		cylinder {<0.07, 0, 0>, <0.07, 1, 0>, 0.023}
		texture {t_bplas}
		translate <0.15, 0, -0.1>
	}
	
	//record button
	difference {
		cylinder {<0, 0.78, 0>, <0, 0.83, 0>, 0.021}
		torus {0.01, 0.002 translate y*0.83}
		pigment {red 0.75} finish {Dull}
		translate <0.22, 0, -0.1>
	}
	
	//top controls
	difference {
		box {<-1.09, 0.8, 0.01>, <1.09, 0.81, 0.2>
			texture {
				image_pattern {png "toplabels.png" interpolate 2}
				texture_map {
					[0 t_words]
					[0.7 t_words]
					[0.7 t_wplas]
					[1 t_wplas]
				}
				rotate x*90
				scale <2.18, 1, 0.19>
				translate <-1.09, 0, 0.01>
			}
		}
		union {
			box {<-0.1, -0.009, -0.02>, <0.1, 1, 0.02> translate <-0.81, 0.81, 0.15>}		//tone slider cutout
			box {<-0.1, -0.009, -0.02>, <0.1, 1, 0.02> translate <-0.255, 0.81, 0.15>}		//volume slider cutout
			box {<-0.04, -0.009, -0.02>, <0.04, 1, 0.02> translate <0.29, 0.81, 0.15>}		//function slider cutout
			box {<-0.03, -0.009, -0.02>, <0.03, 1, 0.02> translate <0.815, 0.81, 0.15>}		//tuner slider cutout
			texture {t_bplas}
		}
	}
	union {
		box {<-0.02, -0.009, -0.015>, <0.02, 0.01, 0.015> translate <-0.79, 0.82, 0.15>}	//tone slider
		box {<-0.02, -0.009, -0.015>, <0.02, 0.01, 0.015> translate <-0.23, 0.82, 0.15>}	//volume slider
		box {<-0.02, -0.009, -0.015>, <0.02, 0.01, 0.015> translate <0.29, 0.82, 0.15>}		//function slider
		box {<-0.02, -0.009, -0.015>, <0.02, 0.01, 0.015> translate <0.825, 0.82, 0.15>}	//tuner slider
		texture {t_bplas}
	}
	
	//tuner
	difference {
		box {<-0.34, 0.67, -0.25>, <0.34, 0.75, 0>
			texture {
				image_pattern {png "radiotuner.png" interpolate 2 once}
				texture_map {
					[0 t_words]
					[0.7 t_words]
					[0.7 t_wplas]
					[1 t_wplas]
				}
				scale <0.68, 0.25, 1>
				translate <-0.34, 0.58, 0>
			}
		}
		sphere {<0, 0.71, -0.25>, 0.015}
		cylinder {<0, 0.71, -0.25>, <0.3, 0.71, -0.25>, 0.015}
		sphere {<0.3, 0.71, -0.25>, 0.015}
		texture {t_wplas}
	}
	box {<0.15, 0.67, -0.24>, <0.165, 0.75, -0.21> pigment {red 2} finish {Dull}}
	box {<-0.34, 0.65, -0.248>, <0.34, 0.75, -0.245>
		pigment {rgbf <0.9, 0.9, 0.9, 0.85>}
		finish {Shiny}
		interior {i_plas}
	}
	
	//tuner wheel- center <0.8, y, 0.09>
	cylinder {<0, 0, -0.025>, <0, 0, 0.025>, 0.18
		texture {
			t_bplas
			normal {
				cylindrical
				scale 0.18
				normal_map {
					[0 radial frequency 360/5]
					[0.025 radial frequency 360/5]
					[0.05 ripples 0.001]
					[1 ripples 0.001]
				}
				rotate x*90
			}
		}
		translate <0.8, 0.65, -0.09>
	}
			
	//speakers
	object {
		Round_Box_Merge (<-1.145, 0.055, -0.26>, <-0.505, 0.745, -0.2>, 0.025)
		texture {
			leopard
			rotate z*45 scale 0.004
			texture_map {
				[0 t_speaker]
				[0.25 t_speaker]
				[0.25 t_clear]
				[1 t_clear]
			}
		}
	}
	object {
		Round_Box_Merge (<1.145, 0.055, -0.26>, <0.505, 0.745, -0.2>, 0.025)
		texture {
			leopard
			rotate z*45
			scale 0.004
			texture_map {
				[0 t_speaker]
				[0.25 t_speaker]
				[0.25 t_clear]
				[1 t_clear]
			}
		}
	}
	merge {
		cylinder {<0.825, 0.4, -0.2>, <0.825, 0.4, 0>, 0.25}
		cylinder {<-0.825, 0.4, -0.2>, <-0.825, 0.4, 0>, 0.25}
		pigment {rgb 0.25}
	}
	
	//cassette door
	merge {
		difference {
			box {<-0.34, 0.06, -0.005>, <0.34, 0.64, 0.005>}
			box {<-0.25, 0.21, -1>, <0.25, 0.49, 1>}
		}
		box {<-0.25, 0.21, -0.005>, <0.25, 0.49, 0.005> texture {t_cplas} interior {i_plas}}
		box {<-0.25, 0.21, 0.005>, <-0.26, 0.49, 0.0525>}
		box {<0.25, 0.21, 0.005>, <0.26, 0.49, 0.0525>}
		difference {
			box {<-0.32, 0.12, 0.005>, <0.32, 0.35, 0.11>}
			box {<-0.31, 0.13, -1>, <0.31, 1, 0.1>}
			box {<-0.25, -1, -1>, <0.25, 1, 1>}
		}
		
		//test casette in door - remove for final render
		//object {cassette(label, yes) rotate z*180 translate <0, 0.35, 0.0575>}
		
		texture {t_wplas}
		rotate x*-20
		translate z*-0.25
	}
	
	//tape rollers & heads
	union {
		cylinder {<0, 0, -0.143>, <0, 0, -0.142>, 0.035}
		Round_Cylinder_Merge(<0, 0, -0.19>, <0, 0, -0.142>, 0.025, 0.005)
		cylinder {<0, 0, -0.2>, <0, 0, -0.142>, 0.0035 texture {T_Chrome_5D}}
		box {<-0.005, 0, -0.17>, <0.005, 0.032, -0.142> rotate z*0}
		box {<-0.005, 0, -0.17>, <0.005, 0.032, -0.142> rotate z*120}
		box {<-0.005, 0, -0.17>, <0.005, 0.032, -0.142> rotate z*240}
		translate <-0.12, 0.34, 0>
		pigment {rgb 0.01} finish {Shiny}
	}
	union {
		cylinder {<0, 0, -0.143>, <0, 0, -0.142>, 0.035}
		Round_Cylinder_Merge(<0, 0, -0.19>, <0, 0, -0.142>, 0.025, 0.005)
		cylinder {<0, 0, -0.2>, <0, 0, -0.142>, 0.0035 texture {T_Chrome_5D}}
		box {<-0.005, 0, -0.17>, <0.005, 0.032, -0.142> rotate z*0}
		box {<-0.005, 0, -0.17>, <0.005, 0.032, -0.142> rotate z*120}
		box {<-0.005, 0, -0.17>, <0.005, 0.032, -0.142> rotate z*240}
		translate <0.12, 0.34, 0>
		pigment {rgb 0.01} finish {Shiny}
	}
	cylinder {<-0.12, 0.53, -0.21>, <-0.12, 0.53, 0.142>, 0.004 texture {T_Chrome_5D}}
	cylinder {<0, 0, -0.18>, <0, 0, -0.142>, 0.025 scale <1.25, 1, 1> translate <-0.185, 0.59, 0> texture {T_Chrome_5D}}
	cylinder {<0, 0, -0.18>, <0, 0, -0.142>, 0.025 scale <1.5, 0.9, 1> translate <-0.15, 0.6, 0> texture {T_Chrome_5D}}
	cylinder {<-0.14, 0.6, -0.179>, <-0.14, 0.6, -0.142>, 0.03 pigment {rgb 0.01} finish {Dull}}
	intersection {
		cylinder {<0, 0.61, -1>, <0, 0.61, 1>, 0.05}
		box {<-0.02, 0.55, -0.179>, <0.02, 0.6, -0.147>}
		translate x*0.03
		texture {T_Chrome_5C}
	}
	intersection {
		cylinder {<0, 0.61, -1>, <0, 0.61, 1>, 0.05}
		box {<-0.02, 0.55, -0.179>, <0.02, 0.6, -0.147>}
		texture {T_Chrome_5C}
		translate x*-0.03
	}
	box {<0.1, 0.56, -0.179>, <0.11, 0.61, -0.147> pigment {rgb 1} finish {Dull}}
	box {<-0.03, 0, -0.005>, <0.03, 0.2, 0.005>
		rotate x*45
		translate <0, 0.1, -0.21>
		texture {T_Chrome_5D}
	}
	box {<-0.06, 0.31, -0.143>, <0.06, 0.38, -0.142> pigment {rgb <1, 0.5, 0>} finish {Shiny}}
	
	//antena
	sphere {<-0.8, 0.77, 0.25>, 0.02 texture {T_Chrome_5E}}
	cylinder {<-0.8, 0.77, 0.25>, <-0.8, 0.77, 0.23>, 0.02 texture {T_Chrome_5E}}
	difference {
		box {<0.29, 0.75, 0.23>, <0.31, 0.78, 0.26>}
		cylinder {<-1, 0.77, 0.25>, <1, 0.77, 0.25>, 0.0125}
		texture {t_wplas}
	}
	union {
		sphere {<0, 0, 0>, 0.012}
		cylinder {<0, 0, 0>, <1.2, 0, 0>, 0.012}
		cylinder {<0, 0, 0>, <1.4, 0, 0>, 0.01}
		cylinder {<0, 0, 0>, <1.6, 0, 0>, 0.008}
		cylinder {<1.59, 0, 0>, <1.62, 0, 0>, 0.012}
		rotate <0, -5, 20>
		translate <-0.8, 0.77, 0.25>
		texture {T_Chrome_5E}
	}
	
	//handle
	union {
		object {Round_Box_Merge (<-1.13, -0.03, -0.01>, <-1.11, 0.03, 0.4>, 0.005) texture {t_wplas}}
		object {Round_Box_Merge (<1.13, -0.03, -0.01>, <1.11, 0.03, 0.4>, 0.005) texture {t_wplas}}
		object {Round_Box_Merge (<-1.11, -0.03, 0.35>, <1.11, 0.03, 0.4>, 0.007) texture {t_bplas}}
		rotate x*0
		translate <0, 0.78, 0>
	}
	
	//transformations
}

//macro to draw loose tape from cassette to radio
#macro ribbon(sp, step, siz)
	#macro tangent(sp, vl)
		#local acc=0.0001;
		#local tang=sp(vl+acc)-sp(vl-acc)+sp(vl);
		tang
	#end

	#local c=0;
	mesh {
		#while (c<1)
			#local fwd=tangent(sp, c);
			#local f1=tangent(sp, c-step);
			#local f2=tangent(sp, c+step);
			#local clft=vdot(f1, f2);
			#local upc=vnormalize(vcross(fwd,clft));
			#local fwd=tangent(sp, c-step);
			#local f1=tangent(sp, c-step*2);
			#local f2=tangent(sp, c);
			#local plft=vdot(f1, f2);
			#local upp=vnormalize(vcross(fwd,plft));
			#local p1=sp(c-step)+upp*siz;
			#local p2=sp(c-step)-upp*siz;
			#local p3=sp(c)+upc*siz;
			#local p4=sp(c)-upc*siz;
			triangle {p1, p2, p3}
			triangle {p2, p3, p4}
			#declare c=c+step;
		#end
	}
#end

//spline for loose tape
#declare sp=
spline {
	#declare n=34;
	natural_spline	
	1/n, <0.02, 0, 0>			//inside tape
	2/n, <0.02, 0, 0>
	3/n, <0.03, 0, 0.05>
	4/n, <0.05, 0, 0.08>
	5/n, <0.12, 0, 0.12>
	6/n, <0.2, 0, 0.1>
	7/n, <0.24, 0, 0.05>
	8/n, <0.26, 0, 0>
	9/n, <0.27, 0, -0.1>
	10/n, <0.255, 0, -0.175>
	11/n, <0.235, 0, -0.1875>
	12/n, <0.2, 0, -0.19> 
	13/n, <0.03, 0, -0.192>
	14/n, <0.02, 0, -0.192>
	
	// n/n, <0, 0, -0.5>		//center of tape
	
	15/n, <-0.25, 0.2, -0.4>	//sag from tape
	16/n, <-0.4, 0.57, -0.45>	//sag from tape
	17/n, <-0.42, 0.57, -0.47>	//to cassette door
	18/n, <-0.5, 0.54, -0.57>	//sag
	19/n, <-0.6, 0.53, -0.65>	// to silver peg
								// add points here to jumble tape in player
	20/n, <-0.8, 0.53, -0.4>	//to tape head
	21/n, <-0.65, 0.55, -0.35>	//sag
	22/n, <-0.6, 0.57, -0.2>	//to cassette door
	23/n, <-0.5, 0.2, -0.2>		//sag to tape
	
	24/n, <-0.03, 0, -0.192>	//inside tape
	25/n, <-0.2, 0, -0.19>
	26/n, <-0.235, 0, -0.1875>
	27/n, <-0.255, 0, -0.175>
	28/n, <-0.26, 0, -0.1>
	29/n, <-0.25, 0, 0>
	30/n, <-0.2, 0, 0.075>
	31/n, <-0.12, 0, 0.1>
	32/n, <-0.05, 0, 0.05>
	33/n, <-0.045, 0, 0>
	34/n, <-0.04, 0, 0>
}

//use union of radio, cassette & loose tape to keep distances & angles between tape & player right
#declare radiocas_union=
union {
	object {radio translate z*1.1 rotate y*230}
	object {cassette("caslabel2.png", no) rotate x*90 translate y*0.0276}
	object {ribbon(sp, 0.001, 0.01)
		texture {
			pigment {rgb <0.2, 0.1, 0.05>}
			finish {F_MetalA}
		}
		translate y*0.0276
	}
}


