// Persistence of Vision Ray Tracer Scene Description File
// File: gramophone.pov
// Vers: 3.5
// Desc: CD being played on a Gramophone
// Date: 30/01/2003
// Auth: Courtney Miles


/* REFERENCES
	Blurred Reflection -
	http://www.students.tut.fi/~warp/povQandT/languageQandT.html#blurredreflection
	
	CD object -
	http://runevision.com/3d/include/include.asp
*/

#version 3.5;

global_settings {
	ambient_light 0
}

// Settings used by the CD include file
#declare cd_samples    = 9.0; // Samples per color cycle.
#declare cd_phong      = 1.0; // How visible the cd effect is (works like phong).
#declare cd_phong_size = 30; // How thick the cd effect is (works like phong_size).
#declare cd_dispertion = 1.5; // Color dipertion (or frequency of color cycles).
#declare cd_offset     = 2.0; // Offset of color cycles in color cycles.
#declare cd_cycles     = 5.0; // Number of color cycles.
#declare cd_scale      = 2.0; // Scale of cd texture.
#declare cd_colour 		 = 0.4;

#include "colors.inc"
#include "cd.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

#declare camera1 =
camera { 
	location  <30, 25, -40>
  right     x*image_width/image_height
  look_at   <10, 5, 0>
  translate -6*x
}

#declare camera2 =
camera {
  location  <-50, -10, -50>
  right     x*image_width/image_height
  look_at   <2, -10, 0>
}

#declare camera3 =
camera {
  location  <5, 10, -5>
  right     x*image_width/image_height
  look_at   <0, 0, 0>
}

camera { camera1 }

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb 3  // light's color
  area_light <-4, -4, 0>, <4, 4, 0>, 4, 4
  circular
  orient
  fade_distance 70
  fade_power 3
  translate <60, 80, 65>
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb 1  // light's color 
  area_light <0, -4, -4>, <0, 4, 4>, 8, 8
  circular
  orient
  fade_distance 200
  fade_power 3
  translate <200, 200, -200>
}

background { colour rgb 0}

// ----------------------------------------
//								MATERIALS
// ----------------------------------------
                                           
#declare cd_tray_tex =
texture
      {      
         pigment
         {
            color rgb <0.199966, 0.205126, 0.149007>
         }      
         finish
         {
            ambient 0.3
            diffuse 0.5
            phong 0.7
            phong_size 20.0
         }
      }

#declare cd_case_mat =
material { 
texture
      {      
         pigment
         {
            color rgbf <0.98, 0.98, 0.98, 0.9>
         }      
         finish
         {
            ambient 0.1
            diffuse 0.1
            phong 1.0
            phong_size 100.0
            specular 0.8
            roughness 0.0003
            reflection 0.1
         }
      }   
      interior
      {
         ior 1.3
      }
}

#declare brass_mat =
material  // Brass_Metal1_1_1
   {   
      texture
      {      
         pigment
         {
            color rgb <0.9, 0.9, 0.65>
         }      
         finish
         {
            ambient 0.1
            diffuse 0.05
            specular 0.55
            brilliance 6.0
            phong 0.75
            phong_size 80.0
            metallic 1.0
            reflection rgb <0.9, 0.9, 0.1>
         }
      }
   }

#declare horn_mat =
material  // Brass_Metal1_1_1
   {   
      texture
      {
      	pigment
         {
            color rgb <0.9, 0.9, 0.65>
         }      
         finish
         {
            ambient 0.1
            diffuse 0.05
            specular 0.55
            brilliance 6.0
            phong 0.75
            phong_size 80.0
            metallic 1.0
            reflection rgb <0.9, 0.9, 0.1>
         }      
	       normal
         {
            bozo , 0.5
            ramp_wave
            scale  5.0
         }      
      }
   }
   
#declare reproducer_mat =
material  // Silver3
   {   
      texture
      {      
         pigment
         {
            color rgb <0.93, 0.93, 0.93>
         }      
         finish {
         	metallic
         	ambient 0.025  
         	diffuse 0.05
         	brilliance 1.0
         	phong 1.0
         	phong_size 25.0 
         	reflection 1
         }
         normal {
						bump_map {
							png "sound_box.png"
						}
						translate <-0.5, -0.5, 0>
						rotate -90*y
						rotate 10*x
						scale 6
					}
      }
   }
   
#declare wood_tex = 
texture {
	pigment {
    wood
    turbulence 0.07
    octaves 3
    scale <0.15, .15, 1>
		colour_map {
	    [0.00 0.10 color rgb < 0.80, 0.232, 0.115 >
	               color rgb < 0.80, 0.232, 0.115 >]
	    [0.10 0.90 color rgb < 0.80, 0.232, 0.115 >
	               color rgb < 0.45, 0.115, 0.060 >]
	    [0.90 1.0  color rgb < 0.45, 0.115, 0.060 >
	               color rgb < 0.45, 0.115, 0.060 >]
		}
	}
	finish {
    specular 0.5
    roughness 0.0025
  }
  normal {
  	bump_map {
  		png "scratch_n_bumps.png"
  		bump_size 1
  	}
  	scale 5
  	rotate 90*x
  }
	scale 4
	rotate 7*x
}
texture {
	pigment {
    wood  
    turbulence <0.1, 0.35, 0.1>
    octaves 5
    lambda 3.25
    scale <0.25, .25, 1>
    rotate <5, 10, 5>
    translate -x*2
		colour_map {
	    [0.00 0.10 color rgbt < 0.70, 0.232, 0.115, 0.5 >
	               color rgbt < 0.70, 0.232, 0.115, 0.7 >]
	    [0.10 0.15 color rgbt < 0.70, 0.232, 0.115, 0.7 >
	               color rgbt < 0.35, 0.115, 0.060, 0.9 >]
	    [0.15 0.20 color rgbt < 0.70, 0.232, 0.115, 0.9 >
	               color rgbt < 0.35, 0.115, 0.060, 0.7 >]
	    [0.20 1.0  color rgbt < 0.35, 0.115, 0.060, 0.7 >
	               color rgbt < 0.35, 0.115, 0.060, 0.5 >]
		}
	}
	finish {
    specular 0.5
    roughness 0.0025
  }
	scale 4
	rotate 7*x
}
texture {
	pigment { colour rgbft <1, 0, 0, 0.6, 0.6>}
}


#declare BlurAmount = .2; // Amount of blurring
#declare BlurSamples = 80; // How many rays to shoot

#declare turn_table_mat =
material {   
	texture { 
		average texture_map { 
			#declare Ind = 0;
	    #declare S = seed(9586);
	    #while(Ind < BlurSamples)
	      [1 // The pigment of the object:
	        pigment { color rgb <0.06, 0.06, 0.04> }
	        // The surface finish:
					finish { 
						ambient 0.1
						diffuse 0.438833
						brilliance 3.157667
						phong 0.6043
						phong_size 13.906667
						specular 1
						roughness 0.05
						reflection {
							0.1
							//exponent 0.3
						}
	   			}
					// This is the actual trick:
					normal { 
						bumps BlurAmount
					 	translate <rand(S),rand(S),rand(S)>*10
					 	scale 1000
					}
	      ]
	      #declare Ind = Ind+1;
	    #end
	  }
	        
	  /* pigment
	   {
	      color rgb <0.06, 0.06, 0.04>
	   }      
	   finish
	   {
	      ambient 0.1
	      diffuse 0.438833
	      brilliance 3.157667
	      phong 0.6043
	      phong_size 13.906667
	      specular 1
	      roughness 0.05
	      reflection {
	      	0.075
	      	exponent 0.3
	      }
	   } */
	 }
}

#declare chrome_tex =
texture {
	pigment {
		color rgb <0.20, 0.20, 0.20>
	}
	finish {
    ambient 0.25
    brilliance 4
    diffuse 0.5
    metallic
    specular 0.80
    roughness 1/80
    reflection 0.5
	}
}

#declare handle_tex =
texture
   {   
      pigment
      {
         color rgb <0.7, 0.56, 0.37>
      }   
      finish
      {
         ambient 0.01
         diffuse 0.65
         brilliance 4
         specular 0.85
         roughness 0.01
         reflection {
         	0.3
         	//rgb <0.7, 0.56, 0.37>
         }
      }
      normal {
      	bump_map {
      		png "brushed_metal2.png"
      		bump_size 0.25
      		map_type 2
      		interpolate 4
      	}
      	rotate 90*z
      	scale 4
      }
   }
   texture
   {   
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft 0 ]
            [ 0.1     rgbft 0.5 ]
            [ 1.0     rgbft 1 ]
         }
      }   
      finish
      {
         ambient 0.01
      }
      scale 3
   }

#declare bracket_tex =
texture {
	pigment { color rgb <0.20, 0.20, 0.20> }
	finish {
    ambient 0.25
    brilliance 4
    diffuse 0.5
    metallic
    specular 0.80
    roughness 1/80
    reflection 0.5
}
}

#declare table_top_tex = 
texture
{      
   pigment
   {
      bozo
      color_map
      {
         [ 0.0     rgb <0.501961, 0.05, 0.05> ]
         [ 1.0     rgb <0.356863, 0.05, 0.05> ]
      }
   }      
   normal
   {
      agate , 0.5
      agate_turb 1.0
      bump_size 0.15
   }      
   finish
   {       
   		//ambient 0.1
      diffuse 0.3
      brilliance 0.1
      phong 0.1007
      phong_size 69.533333
      specular 0.1
      roughness 0.1
   }
   scale 0.75
}
                                           
// ----------------------------------------
//								WALLS
// ----------------------------------------

plane {
  z, 75
  //pigment { color rgb <0.7,0.5,0.3> }
  texture {
	  pigment {
	  	image_map { gif "wallpaper2.gif" }
	  }
	  normal {
	  	bump_map {
	  		png "wallpaper_bump2.png"
	  	}
	  	bump_size 10
	  	//translate 0.2111*y
	  } 
	  scale <1200, 600, 1>
  	scale <0.05, 0.05, 1>
	}
  hollow
}

plane {
  z, -600
  //pigment { color rgb <0.7,0.5,0.3> }
  texture {
	  pigment {
	  	image_map { gif "wallpaper2.gif" }
	  }
	  normal {
	  	bump_map {
	  		png "wallpaper_bump2.png"
	  	}
	  	bump_size 10
	  	//translate 0.2111*y
	  } 
	  scale <1200, 600, 1>
  	scale <0.05, 0.05, 1>
	}
  hollow
}

plane {
  z, -300
  //pigment { color rgb <0.7,0.5,0.3> }
  texture {
	  pigment {
	  	image_map { gif "wallpaper2.gif" }
	  }
	  normal {
	  	bump_map {
	  		png "wallpaper_bump2.png"
	  	}
	  	bump_size 10
	  	//translate 0.2111*y
	  } 
	  scale <1200, 600, 1>
  	scale <0.05, 0.05, 1>
	}
	rotate 90*y
  hollow
}

plane {
  z, 300
  //pigment { color rgb <0.7,0.5,0.3> }
  texture {
	  pigment {
	  	image_map { gif "wallpaper2.gif" }
	  }
	  normal {
	  	bump_map {
	  		png "wallpaper_bump2.png"
	  	}
	  	bump_size 10
	  	//translate 0.2111*y
	  } 
	  scale <1200, 600, 1>
  	scale <0.05, 0.05, 1>
	}
	rotate 90*y
  hollow
}

plane {
	y, 300
	pigment { White }
	hollow
}

// ----------------------------------------
//					OBJECTS USED IN SCENE
// ----------------------------------------

#declare reproducer =
union {
	// Reprpducteur
	union {
		cylinder {
			<0, 0, 0>, <-0.5, 0, 0>, 2.5
		}
		torus {
			2.5, 0.4
			rotate 90*z
		}
		cylinder {
			<0, 0, 0>, <0.5, 0, 0>, 3
		}
		difference {
			sphere {
				<0, 0, 0>, 2.55
				scale 0.5*x 
				material { brass_mat }
			}
			#declare Count = 0;
			#while (Count < 6)
				union {
					prism {
						linear_sweep
						linear_spline
						0, 1, 11, 
						<0, 0>, <-0.3, 0.6>, <-0.15, 0.6>, <-0.6, 1.3>, <-0.2, 1.3>,
						<-0.2, 1.45>, <0.2, 1.45>, <0.2, 1.3>, <0.6, 1.3>, <0.15, 0.6>,
						<0.3, 0.6>
					}
					cylinder {
						<0, 0, 0>, <0, 1, 0>, 0.2
						translate 1.45*z
					}
					rotate <90, 90, 0>
					scale 0.85
					translate <0.5, -0.75, 0>
					rotate (360/6)*Count*x
				}
				#declare Count = Count+1;
			#end
			cylinder {
				<0, 0, 0>, <2, 0, 0>, 0.2 
			}
			sphere {
				<0, 0, >, 2.55
				scale 0.475*x
			}
		}
	}
	
	difference {
		intersection {
			cylinder {
				<-0.15, 0, 0>, <0.65, 0, 0>, 3.15
			}
			prism {
				linear_sweep
				linear_spline
				-1, 1, 3,
				<0, 0>, <-10, 10>, <10, 10>
				rotate <0, 90, -90>
			}
		}
		cylinder {
			<-0.05, 0, 0>, <0.55, 0, 0>, 3.05
		}
		cylinder {
			<-1, 0, 0>, <1, 0, 0>, 2.5
		}
		//pigment { Red }
	}
	
	// Needle
	union {
		cylinder {
			<0, 0, 0>, <0, -0.7, 0>, 0.15
		}
		cylinder {
			<0, 0, 0>, <0, -0.15, 0>, 0.35
			translate -0.7*y
		}
		cone {
			<0, 0, 0>, 0.1, <0, -0.5, 0>, 0
			translate -0.85*y
		}
		translate <0.25, -3, 0>
	}
	rotate 10*x
	material { reproducer_mat }
	//pigment { Red } 
}

#declare tone_arm =
union {
	cylinder {
		<0, 0, 0>, <-1, 0, 0> 1.25
		translate -0.5*x
	}
	
	union {
		union {
			intersection {
				torus {
					3, 1.15
					translate <0, 0, 3>
				}
				box {
					<0, 0, 0>, <-4.15, 2.3, 4.15>
					translate <0, -1.15, -1.15>
				}
			}
			torus {
				1.15, 0.15
				rotate 90*x
				translate <-3, 0, 3>
			}
		}		
		union {
			cone {
				<0, 0, 10>, 1.75, <0, 0, 0>, 1.15
			}
			union {
				intersection {
					torus {
						2.75, 1.75
					}
					box {
						<0, -1.75, 0>, <4.5, 1.75, 4.5>
					}
					translate <-2.75, 0, 0>
				}
				intersection {
					torus {
						2.75, 1.75
					}
					box {
						<0, -1.75, -4.5>, <-4.5, 1.75, 4.5>
					}
					translate <-2.75, 0, 5.5>
				}
				translate 10*z
			}
			translate <-3, 0, 3>
		}
		translate -1.5*x
		material { brass_mat }	
	}
	rotate -10*x
	pigment { Blue }
}

#declare elbow =
union {
	sphere {
		<0, 0, 0>, 3.5
	}
	union {
		cylinder {
			<0, 0, 0>, <-4.75, 0, 0>, 1.95
		}
		cylinder {
			<0, 0, 0>, <-3.25, 0, 0>, 2.1
		}
		
	}
	union {
		cylinder {
			<0, 0, 0>, <3.75, 0, 0>, 1.95
		}
		cylinder {
			<0, 0, 0>, <3.25, 0, 0>, 2.1
		}
	}
	cylinder {
		<0, 0, 0>, <0, 4.5, 0>, 2.1
	}
	union {
		cylinder {
			<0, 0, 0>, <0, 4, 0>, 2.5
		}
		cylinder {
			<0, 0, 0>, <0, 0.25, 0>, 3
			translate 2.75*y
		}
		union { 
			union {
				difference {
					box {
						<0, 0, 0>, <0.25, 1.5, 1.5>
					}
					box {
						<-0.1, 0, 0>, <0.26, 1.5, 1.5>
						translate <0, 0.75, -0.75>
					}
				}
				cylinder {
					<0, 0, 0>, <0.25, 0, 0>, 0.75
					translate <0, 0.75, 0.75>
				}
				intersection {
					difference {
						sphere {
							<0, 0, 0>, 0.4
						}
						box {
							<0.27, -0.05, -0.5>, <0.5, 0.05, 0.5>
						}
					}
					cylinder {
						<0, 0, 0>, <0.5, 0, 0>, 0.75
 					}
					translate <0, 0.95, 0.55>
				}
				rotate -45*x
				translate 0.1*x
			}
			union {
				difference {
					box {
						<0, 0, 0>, <-0.25, 1.5, 1.5>
					}
					box {
						<0.1, 0, 0>, <-0.26, 1.5, 1.5>
						translate <0, 0.75, -0.75>
					}
				}
				cylinder {
					<0, 0, 0>, <-0.25, 0, 0>, 0.75
					translate <0, 0.75, 0.75>
				}
				rotate -45*x
				translate -0.1*x
			}
			translate <0, 0.3, -2.5>
		}
		difference {
			intersection {
				torus {
					6, 2.1
				}
				box {
					<0, -2.1, 0>, <10.1, 2.1, 10.1> 
				}
				
			}
			box {
				<0, -2.1, 0>, <-10.1, 2.1, 10.1>
				rotate 15*y 
			}
			rotate -90*x
			translate <-6, 4, 0>
			rotate -90*y	
		}	
		translate 3.25*y
	}
	rotate 10*x	
	translate 4.75*x
	translate <-7.25, 0, 21.25>
	rotate -10*x
	material { brass_mat }
}

#declare horn_petal =
union {
	#declare length = 50;
	#declare spout_r = 20;
	#declare small_r = 25;
	#declare large_r = 100;
	#declare petal_width = 15;
	#declare num_petals = 10;
	
	intersection {	
		union {
			difference {
				intersection {		
					cylinder {
						<0, 0, 0>, <0, 0, petal_width>, small_r
						open
						translate small_r*y
					}
					prism {
						linear_sweep
						linear_spline
						-1, petal_width+1, 3,
						<0, 0>, <small_r, 0>, <0, 40>
						rotate <90, 0, 90>
					} 
				}
				cylinder {
				<0, 0, 0>, <0, 0, petal_width>, small_r-0.025
				open
				translate small_r*y
				}
			}
			difference {
				intersection {
					cylinder {
						<0, 0, 0>, <0, 0, petal_width>, large_r
						open
						translate large_r*y
					}
					prism {
						linear_sweep
						linear_spline
						-1, petal_width+1, 3,
						<-0.1, 0>, <30, 0>, <0, large_r>
						rotate <-90, 180, 0>
					}
				}
				cylinder {
					<0, 0, 0>, <0, 0, petal_width>, large_r-0.025
					open
					translate large_r*y
				}
			}
			rotate 20*z
			translate <28.2, 7.95, -petal_width/2>
		}
		difference {
			union {
				box {
					<0, 0, 0>, <1, 1, 1>
					scale <60, 20, petal_width>
					translate -petal_width/2*z
				}
				cylinder {
					<0, 0, 0>, <60, 0, 0>, 10
					translate 15*y
				}
			}
			box {
				<0, 0, 0>, <1, 1, 1>
				scale <62, 25, petal_width>
				rotate 360/num_petals/2*x 
				translate -1*x
			}
			box {
				<0, 0, 0>, <1, 1, 1>
				scale <62, 25, petal_width>
				translate -petal_width*z
				rotate -360/num_petals/2*x 
				translate -1*x
			}
			
		}
	}
}

#declare horn =
union {
	#declare num_petals = 10;
	#declare Count = 0;
	#while (Count < num_petals)
		object { horn_petal rotate Count*(360/num_petals)*x}
		#declare Count = Count+1;
	#end
	torus {
		2.15, 0.15
		rotate 90*z
	}
	rotate 90*y
	translate <-2.5, 13.25, 15.25>
	rotate 15*x
	translate <0, 7.8, -1.3>
	material { horn_mat }	
}

#declare turn_table =
union {
	intersection {
		torus {
			13.65, 1.5
			translate 0.3*y
		}
		cylinder {
			<0, 0, 0>, <0, 0.6, 0>, 20
		}
	}
	union {
		cylinder {
			<0, 0.6, 0>, <0, 2, 0>, 0.35
		}
		sphere {
			<0, 0, 0>, 0.35
			translate 2*y
		}
		translate -0.25*y
	}
	cylinder {
		<0, 0.6, 0>, <0, 0.7, 0>, 15
		material { turn_table_mat }
		//pigment { White }
	}
	
	// Compact Disc
	object { 
		cd_object
		rotate 180*z
		scale 6
		translate 0.8*y
	}
	translate 0.8*y
	texture { chrome_tex }
}

#declare the_box =
union {
	// Top Board 
	union {
		box {
			<-19, 0, -19>, <19, -1.5, 19>
		}
		#declare Count = 0;
		#while (Count < 4) 
			intersection {
				union {
					cylinder {
						<0, 0, 0>, <1, 0, 0>, 0.3
					}
					cylinder {
						<0, 0, 0>, <1, 0, 0>, 1.5
						scale 0.8*y
						translate -1.2*y
					}
					translate <-0.5, -0.3, -19>
					scale 45*x
				}
				prism {
					0, -1.5, 3,
					<0, 0>, <-25, -25>, <25, -25>
				}
				rotate 90*Count*y
			}
			#declare Count = Count +1;
		#end
		texture { wood_tex }
	}
	
	// Second board down
	box {
		<-19, -1.5, -19>, <19, -3, 19>
		texture { wood_tex }
	}
	
	// Corners
	#declare Count = 0;
	#while ( Count < 4 )
		lathe { // RotSweep001
		  cubic_spline
		  24  // control points
		  <0.397114, -0.216028>,
		  <0.829742, -0.017176>,
		  <1.003292, 1.153503>,
		  <0.663722, 1.592708>,
		  <0.992501, 2.414111>,
		  <0.658775, 2.977201>,
		  <0.489352, 3.137145>,
		  <0.92532, 3.708059>,
		  <1.073746, 4.660086>,
		  <0.959214, 4.832774>,
		  <1.086574, 5.288141>,
		  <0.620326, 8.01978>,
		  <0.520906, 8.727731>,
		  <0.903802, 9.014011>,
		  <1.098851, 9.360583>,
		  <1.03143, 9.715333>,
		  <0.73925, 10.198862>,
		  <0.961162, 10.426478>,
		  <0.767242, 10.778972>,
		  <0.953324, 10.991326>,
		  <0.767874, 11.282579>,
		  <0.939832, 11.550127>,
		  <0.695642, 13.53003>,
		  <0.501598, 15.17499>
		  translate <-17.5, -15, -17.5>
		  texture { wood_tex rotate 90*x}
		  rotate 90*Count*y
		}
		#declare Count = Count + 1;
	#end
	
	// Sides of the box
	union {
		#declare Count = 0;
		#while ( Count < 4 )
			box {
				<-17.5, -3, -17.5>, <17.5, -15, -17>
				texture { 
					wood_tex 
					rotate <90, 0, 90>
					translate 10*y
				}
				rotate 90*Count*y
			}
			#declare Count = Count + 1 ;
		#end
		polygon {
			4, 
			<0, 0>, <1, 0>, <1, 1>, <0, 1>
			texture {
				pigment {
					image_map {
						jpeg "masters_voice.jpg"
					}
				}
				finish {
					ambient 0.1
					diffuse 0.3
					specular 0.1
				}
			}
			translate <-0.5, -0.5, 0>
			scale <642, 482, 1>
			scale 0.0125
			translate <0, -9, -17.5001> 
		}		
	}
	
	// Bottom Baord
	#declare Count = 0;
	#while ( Count < 4 )
		intersection {
			union {
				difference {
					box {
						<0, 0, 0>, <1, 1.2, 1>
					}
					cylinder {
						<-0.1, 0, 0>, <1.1, 0, 0>, 0.9
						translate 1.2*y
					}
				}
				cylinder {
					<0, 0, 0>, <1, 0, 0>, 0.3
				}
				cylinder {
					<0, 0, 0>, <1, 0, 0>, 0.3
					translate <0, 1.2, 1.2>
				}
				box {
					<0, 0, 0>, <1, -1.2, 2>
					translate  <0, 1.5, 1.2>
				}
				intersection {
					cylinder {
						<0, 0, 0>, <1, 0, 0>, 2.5
						translate <0, -2.5, -0.3>
						scale 0.7*y
					}
					box {
						<-0.1, 0, 0>, <1.1, 4, -4>
						translate <0, -2.5, -0.3>
						scale 0.7*y
					}
				}
				union {
					difference {
						box {
							<0, 0, 0>, <1, 1.2, 1>
						}
						cylinder {
							<-0.1, 0, 0>, <1.1, 0, 0>, 0.5
							translate 1.2*y
						}
						box {
							<-0.1, 0, 0>, <1.1, 1, 2>
							translate <0, 1, 0.25>
						}
					}
					cylinder {
						<0, 0, 0>, <1, 0, 0>, 0.3
						translate 0.4*y
					}
					union {
						cylinder {
							<0, 0, 0>, <1, 0, 0>, 0.3
						}
						box {
							<0, 0, 0>, <1, 0.3, 1>
						}
						box {
							<0, 0, 2>, <1, -0.5, -0.3>
						}
						translate <0, 0.1, -0.5>
					}
					translate <0, -2.0, -3.0>
				}
				scale 60*x
				translate <-30, -16, -20>
			}
			prism {
				-15, -20, 3,
				<0, 0>, <-28, -28>, <28, -28>
			}
			texture { wood_tex rotate 90*y}
			rotate 90*Count*y
		}
		#declare Count = Count+1;
	#end
	
	// feet
	union {
		box {
			<0, 0, 0>, <6, -1, 6>
			translate <-23.8, -18.25, -23.8>
		}
		box {
			<0, 0, 0>, <6, -1, -6>
			translate <-23.8, -18.25, 23.8>
		}
		box {
			<0, 0, 0>, <-6, -1, -6>
			translate <23.8, -18.25, 23.8>
		}
		box {
			<0, 0, 0>, <-6, -1, 6>
			translate <23.8, -18.25, -23.8>
		}
		texture { wood_tex rotate 90*y}
	}
	pigment { Cyan }
}

#declare crank =
union {
	cylinder {
		<0, 0, 0>, <4.5, 0, 0>, 0.5
	}
	intersection {
		torus {
			3, 0.5

		}
		box {
			<0, -0.5, 0>, <4, 0.5, -4>
		}
		translate <4.5, 0, 3>
	}
	cylinder {
		<7.5, 0, 3>, <7.5, 0, 9>, 0.5
	}
	
	cylinder {
		<7.5, 0, 9>, <7.5, 0, 11>, 0.7
	}
	
	cylinder {
		<7.5, 0, 10>, <8.5, 0, 10>, 0.5
	}
	
	lathe { // RotSweep001
	  cubic_spline
	  10  // control points
	  <0.008621, 0.016799>,
	  <0.068082, 0.008399>,
	  <1.330987, 0.307547>,
	  <1.984336, 1.624666>,
	  <1.680418, 2.90677>,
	  <1.020107, 4.141858>,
	  <0.734152, 5.725759>,
	  <1.351791, 7.337972>,
	  <0.237646, 7.551546>,
	  <0.113428, 7.852384>
	  rotate 90*z
	  translate <16, 0, 10>
	  texture { handle_tex }
  }
	rotate 60*x
	translate <19, -5, 0>
	texture { chrome_tex }
}

#declare back_bracket = 
union {
	prism {
		linear_sweep
		cubic_spline
		-0.3,0.3
		21  // control points
  <-0.837121, 13.116824>,
  <-2.838928, 8.105431>,
  <-7.139886, 6.12988>,
  <-7.060093, -2.395564>,
  <-4.548157, 0.787193>,
  <-0.429871, 4.534509>,
  <0.627891, 12.061323>,
  <3.232855, 18.98702>,
  <3.752183, 22.834685>,
  <2.888023, 25.595203>,
  <2.30599, 25.590252>,
  <2.867585, 23.392581>,
  <2.78632, 21.087895>,
  <2.006444, 19.025881>,
  <0.418679, 18.013822>,
  <-0.921305, 18.486571>,
  <-1.491292, 19.713649>,
  <-1.878551, 19.130747>,
  <-0.837121, 13.116824>,
  <-2.838928, 8.105431>,
  <-7.139886, 6.12988>
		rotate <-90, -90, 0>
		translate <9.5, -13.75, 22.4>
	}

	union {
		cylinder {
			<0, 0, 0>, <0, 0.8, 0>, 0.7
		}
		cylinder {
			<0, 0.8, 0>, <0, 1.5, 0>, 0.5
		}
		translate <9.5, 4.70, 21>
	}
	translate 0.5*y
	texture {	bracket_tex }
	//pigment { Red }
}

#declare table_top =
union {
	#declare edge_r = 2;
	sphere {
		<-45, 0, 35>, edge_r
	}
	sphere {
		<45, 0, 35>, edge_r
	}
	sphere {
		<45, 0, -35>, edge_r
	}
	sphere {
		<-45, 0, -35>, edge_r
	}
	
	cylinder {
		<-45, 0, 35>, <45, 0, 35>, edge_r
	}
	cylinder {
		<45, 0, 35>, <45, 0, -35>, edge_r
	}
	cylinder {
		<45, 0, -35>, <-45, 0, -35>, edge_r
	}
	cylinder {
		<-45, 0, -35>, <-45, 0, 35>, edge_r
	}
	
	box {
		<-45, 0, 35>, <45, edge_r, -35>
	}
	
	translate <0, -19.25-edge_r, -3>
	texture { table_top_tex }
	//pigment { Orange }
}

#declare cd_tray =
union {
	difference {
		box {
			<0, 0, 0>, <1, 1, 1>
			scale <14, 0.8, 11.8>
			translate 0.1*y
		}
		box {
			<0, 0, -1>, <1, 1, 1>
			scale <12.4, 1, 12>
			translate <0.3, 0.45, 0>
		}
		box {
			<0, 0, 0>, <1, 1, 1>
			scale <12.3999, 1, 11.5>
			translate <0.3001, 0.4, 0.15>
		}
		cone {
			<0, 0, 0>, 6.1, <0, 0.3001, 0>, 6.2
			translate <6.5, 0.2, 5.9>
		}
		box {
			<0, 0, -1>, <1, 1, 1>
			scale <4, 1, 15>
			translate <4.5, 0.2, 0>
		}
		box {
			<0, 0, -1>, <1, 1, 1>
			scale <2, 0.4, 15>
			translate 12.85*x
		}
		box {
			<0, 0, -1>, <1, 1, 1>
			scale <2, 0.7, 15>
			translate 13.8*x
		}
		box {
			<-1, 0.7, -1>, <1, 1, 1>
			scale <2, 1, 15>
		}
		cylinder {
			<-1, 0, 0>, <1, 0, 0>, 0.15
			translate <0, 0.7, 2.5>
		}
		cylinder {
			<-1, 0, 0>, <1, 0, 0>, 0.15
			translate <0, 0.7, 9.3>
		}
		cylinder {
			<0, -1, 0>, <0, 1, 0>, 1.499
			translate <6.5, 0, 5.9>
		}
	}
	union {
		#declare Count = 0;
		#while (Count < 15)
			cylinder {
				<0, 0, -0.1>, <0, 0, 11.9>, (1.2/2)/15
				translate (1.2/15)*Count*x
			}
			#declare Count = Count + 1;
		#end
		box {
			<0, 0, -0.1>, <1.2, -0.2, 11.9>
			translate -(1.2/2)/15*x
		}
		scale 0.5*y
		translate <12.8, 0.9, 0>
	}
	
	union {
		difference {
			union {
				cylinder {
					<0, 0, 0>, <0, 0.025, 0>, 1.5
				}
				cone {
					<0, 0, 0>, 1.45, <0, 0.15 0>, 1.25
				}
			}
			cylinder {
				<0, 0, 0>, <0, 0.3, 0>, 0.55
			}
			#declare Count = 0;
			#while (Count < 12 )
				union {
					torus {
						1.05, 0.075
					}
					cylinder {
						<0, -0.075, 0>, <0, 0.075, 0>, 1.05
					}
					rotate 90*z
					rotate 30*Count*y
				}
				#declare Count = Count + 1;
			#end
		}
		difference {
			union {
				cylinder { 
					<0, 0.15, 0>, <0, 0.3, 0>, 0.7
				}
				torus {
					0.625, 0.1
					translate 0.3*y
				}
				cylinder {
					<0, 0, 0>, <0, 0.1, 0>, 0.625
					translate 0.3*y
				}
			}
			cylinder {
				<0, 0, 0>, <0, 1, 0>, 0.45
			}
			cylinder {
				<0, 0, 0>, <0, 0.3, 0>, 0.55
			}
			#declare Count = 0;
			#while (Count < 12 )
				cylinder {
					<0, -0.05, 0>, <0, 0.05, 0>, 1.05
					rotate 90*z
					rotate 30*Count*y
				}
				#declare Count = Count + 1;
			#end
		}
		translate <6.5, 0.2, 5.9>
	}
	translate 0.08*y
	texture { cd_tray_tex }
	
}

#declare cd_case =
union {
	box {
		<0, 0, 0>, <1, 1, 1>
		scale <14.15, 0.2, 12.2>
	}
	difference {
		box {
			<0, 0, 0>, <1, 1, 1>
			scale <14.1, 0.8, 12>
		}
		box {
			<0, 0, 0>, <1, 1, 1>
			scale <13.9, 1, 11.8>
			translate <0.1, 0.1, 0.1>
		}
		box {
			<0, 0, -1>, <1, 1, 1>
			scale <12.4, 1, 15>
			translate <0.4, 0.55, 0>
		}
		box {
			<0, 0, -1>, <1, 1, 1>
			scale <4, 1, 15>
			translate <4.55, 0.35, 0>
		}
		cylinder {
			<0, 0, -1>, <0, 0, 15>, 0.1
			translate <1, 0.3, 0>
		}
		cylinder {
			<0, 0, -1>, <0, 0, 15>, 0.1
			translate <3.5, 0.3, 0>
		}
		cylinder {
			<0, 0, -1>, <0, 0, 15>, 0.1
			translate <12.5, 0.3, 0>
		}
		translate <0.05, 0, 0.1>
	}
	
	translate <-0.125, 0, -0.2>
	material { cd_case_mat }
}

#declare cd_lid =
union {
	difference {
		box {
			<0, 0, 0>, <1, 1, 1>
			scale <14.15, 0.8, 12.2>
		}
		box {
			<-1, 0, 0>, <1, 1, 1>
			scale <15, 1, 12>
			translate <0, 0.1, 0.1>
		}
		box {
			<-1, -1, 0>, <1, 1, 1>
			scale <1, 1, 12>
			translate <0.3, 0, 0.1>
		}
	}
	box {
		<0, 0, 0>, <1, 1, 1>
		scale <0.1, 0.2, 12>
		translate <1.4, 0.1, 0.1>
	}
	translate <13.1, 0, -0.2>
	material { cd_case_mat }
}

#declare jewel_case =
union {
	difference {
		union {
			object { cd_tray }
			object { cd_case }
		}
		cylinder {
			<0, 0, 0>, <0, 1, 0>, 0.5
			translate <2.5, 0.4, 0>
		}
		cylinder {
			<0, 0, 0>, <0, 1, 0>, 0.5
			translate <10.5, 0.4, 0>
		}
		cylinder {
			<0, 0, 0>, <0, 1, 0>, 0.5
			translate <2.5, 0.4, 11.8>
		}
		cylinder {
			<0, 0, 0>, <0, 1, 0>, 0.5
			translate <10.5, 0.4, 11.8>
		}
	}
	object { cd_lid }
	
	rotate 50*y
	translate <25, -19.20, 20>
}

#declare speed_lever =
union {
	union {
		union {
			cylinder {
				<0, 0, 0>, <0, 0.05, 0>, 0.75
			}
			sphere {
				<0, 0, 0>, 0.3
				translate -0.1*y
			}
		}
		union {
			cylinder {
				<0, 0, 0>, <0, 0.05, 0>, 0.75
			}
			sphere {
				<0, 0, 0>, 0.3
				translate -0.1*y
			}
			translate 3.5*x
		}
		box {
			<0, 0, 0.75>, <3.5, 0.05, -0.75>
		}
		translate -1.75*x
	}
	union {
		cylinder {
			<0, 0, 6>, <0, 0, -0.5>, 0.125
		}
		torus {
			0.3, 0.125
			translate -0.8*z
		}
		cylinder {
			<0, 0, -1.6>, <0, 0, -1.1>, 0.125
		}
		sphere {
			<0, 0, 0>, 0.125
			translate -1.6*z
		}		
		translate <-0.37, 0.3, 0>
	}
	translate -16.5*z
	rotate -45*y
	texture { chrome_tex }
	//pigment { Red }
}

#declare turn_table_brake =
union { 
	union {
		sphere {
			<0, 0, 0>, 0.4
		}
		cylinder {
			<0, 0, 0>, <1.2, 0, 0>, 0.4
		}
		cone {
			<1.2, 0, 0>, 0.4, <1.8, 0, 0>, 0.2
		}
		//scale 0.3*y
	}
	sphere {
		<1.8, 0, 0>, 0.2
	}
	cylinder {
		<1.8, 0, 0>, <3, -1, 0>, 0.2
	}
	sphere {
		<3, -1, 0>, 0.2
	}
	cylinder {
		<3, -1, 0>, <6, -1, 0>, 0.2
	}
	scale 0.5*y
	translate <-3, 1, 0>
	translate -15.5*x
	rotate -45*y        
	texture { chrome_tex }
	//pigment { Green }	
}

// ----------------------------------------
//					AND PUT IT ALL TOGETHER
// ----------------------------------------

union {
	object { reproducer } 
	object { tone_arm }
	object { elbow }
	object { horn }
	translate -4.75*x
	translate <7.25, 0, -21.25>
	rotate 18*y
	translate 4.75*x
	translate <-7.25, 0, 21.25>
	translate <12, 5.84, 0>
}

union {
	object { turn_table }
	object { speed_lever }
	object { turn_table_brake }
}
object { the_box }
object { crank }
object { back_bracket }

object { table_top }

object {jewel_case }