//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 9 materials and 237 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 03/01/2003    (01.03.2003)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.708,      -1.699,       0.443>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.28752,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      43.520
  look_at   <      0.229,      -0.277,       0.104>
}

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.0000
  translate  <-1.266454, 4.498096, 0.0>
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.0000
  translate  <0.859688, -0.008368, -0.600936>
}

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-5.09906, -7.33166, 4.770878>
}


//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "hi_wheel.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare afturbogi1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.039678, -0.477575, -0.498038>, <0.039678, -0.494212, -0.497723>, <0.042388, -0.494212, -0.497686>, <0.042388, -0.477575, -0.498001>, 
      <0.037574, -0.477436, -0.468313>, <0.037574, -0.495129, -0.467998>, <0.042046, -0.495129, -0.466778>, <0.042046, -0.477436, -0.467094>, 
      <0.034994, -0.477436, -0.452772>, <0.034994, -0.495368, -0.452456>, <0.040545, -0.495368, -0.450776>, <0.040545, -0.477436, -0.451091>, 
      <0.033039, -0.477436, -0.436673>, <0.033039, -0.495467, -0.436357>, <0.039058, -0.495467, -0.435030>, <0.039058, -0.477436, -0.435346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.042388, -0.477575, -0.498001>, <0.042388, -0.460938, -0.498317>, <0.039678, -0.460938, -0.498354>, <0.039678, -0.477575, -0.498038>, 
      <0.042046, -0.477436, -0.467094>, <0.042046, -0.459743, -0.467409>, <0.037574, -0.459743, -0.468629>, <0.037574, -0.477436, -0.468313>, 
      <0.040545, -0.477436, -0.451091>, <0.040545, -0.459504, -0.451407>, <0.034994, -0.459504, -0.453087>, <0.034994, -0.477436, -0.452772>, 
      <0.039058, -0.477436, -0.435346>, <0.039058, -0.459405, -0.435661>, <0.033039, -0.459405, -0.436988>, <0.033039, -0.477436, -0.436673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.033039, -0.477436, -0.436673>, <0.033039, -0.495467, -0.436357>, <0.039058, -0.495467, -0.435030>, <0.039058, -0.477436, -0.435346>, 
      <0.031084, -0.477436, -0.420573>, <0.031084, -0.495566, -0.420258>, <0.037571, -0.495566, -0.419285>, <0.037571, -0.477436, -0.419600>, 
      <0.028887, -0.477436, -0.405210>, <0.028887, -0.496360, -0.404895>, <0.035112, -0.496360, -0.402477>, <0.035112, -0.477436, -0.402793>, 
      <0.026466, -0.477436, -0.389869>, <0.026466, -0.496385, -0.389554>, <0.032957, -0.496385, -0.387563>, <0.032957, -0.477436, -0.387878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.039058, -0.477436, -0.435346>, <0.039058, -0.459405, -0.435661>, <0.033039, -0.459405, -0.436988>, <0.033039, -0.477436, -0.436673>, 
      <0.037571, -0.477436, -0.419600>, <0.037571, -0.459306, -0.419916>, <0.031084, -0.459306, -0.420889>, <0.031084, -0.477436, -0.420573>, 
      <0.035112, -0.477436, -0.402793>, <0.035112, -0.458512, -0.403108>, <0.028887, -0.458512, -0.405526>, <0.028887, -0.477436, -0.405210>, 
      <0.032957, -0.477436, -0.387878>, <0.032957, -0.458487, -0.388194>, <0.026466, -0.458487, -0.390185>, <0.026466, -0.477436, -0.389869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.026466, -0.477436, -0.389869>, <0.026466, -0.496385, -0.389554>, <0.032957, -0.496385, -0.387563>, <0.032957, -0.477436, -0.387878>, 
      <0.024045, -0.477436, -0.374528>, <0.024045, -0.496410, -0.374213>, <0.030803, -0.496410, -0.372648>, <0.030803, -0.477436, -0.372964>, 
      <0.016105, -0.477436, -0.337754>, <0.016079, -0.498053, -0.337724>, <0.024680, -0.498053, -0.326295>, <0.024629, -0.477436, -0.326300>, 
      <0.015232, -0.477436, -0.335342>, <0.015244, -0.498053, -0.335350>, <0.022406, -0.498053, -0.321787>, <0.022367, -0.477436, -0.321778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.032957, -0.477436, -0.387878>, <0.032957, -0.458487, -0.388194>, <0.026466, -0.458487, -0.390185>, <0.026466, -0.477436, -0.389869>, 
      <0.030803, -0.477436, -0.372964>, <0.030803, -0.458461, -0.373279>, <0.024045, -0.458461, -0.374844>, <0.024045, -0.477436, -0.374528>, 
      <0.024629, -0.477436, -0.326300>, <0.024577, -0.456819, -0.326304>, <0.016131, -0.456819, -0.337785>, <0.016105, -0.477436, -0.337754>, 
      <0.022367, -0.477436, -0.321778>, <0.022329, -0.456819, -0.321770>, <0.015219, -0.456819, -0.335333>, <0.015232, -0.477436, -0.335342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.015232, -0.477436, -0.335342>, <0.015244, -0.498053, -0.335350>, <0.022406, -0.498053, -0.321787>, <0.022367, -0.477436, -0.321778>, 
      <0.014358, -0.477436, -0.332929>, <0.014410, -0.498053, -0.332976>, <0.020132, -0.498053, -0.317278>, <0.020106, -0.477436, -0.317257>, 
      <0.009366, -0.477436, -0.329890>, <0.009418, -0.498053, -0.329833>, <0.012504, -0.498053, -0.312056>, <0.012504, -0.477436, -0.312112>, 
      <0.000006, -0.477436, -0.330659>, <0.000006, -0.498053, -0.330706>, <0.000026, -0.498053, -0.312024>, <0.000052, -0.477436, -0.312080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.022367, -0.477436, -0.321778>, <0.022329, -0.456819, -0.321770>, <0.015219, -0.456819, -0.335333>, <0.015232, -0.477436, -0.335342>, 
      <0.020106, -0.477436, -0.317257>, <0.020080, -0.456819, -0.317236>, <0.014306, -0.456819, -0.332882>, <0.014358, -0.477436, -0.332929>, 
      <0.012504, -0.477436, -0.312112>, <0.012504, -0.456819, -0.312169>, <0.009314, -0.456819, -0.329946>, <0.009366, -0.477436, -0.329890>, 
      <0.000052, -0.477436, -0.312080>, <0.000078, -0.456819, -0.312137>, <0.000006, -0.456819, -0.330612>, <0.000006, -0.477436, -0.330659>
    }
  }
  material {
    bronslitur
  }
  rotate -90.0*z
  translate  <0.955, 0.0, 0.006696>
}
#declare RndDisc012 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    krom
  }
  scale <0.015, 0.015, 0.006>
  rotate -90.0*x
  translate  <0.5, -0.044, -0.515>
}
#declare Sphere002 = object {
  sphere { // Sphere002
    <0,0,0>,1
    material {
      krom
    }
    scale 0.008
    translate  <0.5, -0.05, -0.515>
  }
}
#declare smateinn = object {
  cylinder { // smateinn
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.002, 0.002, 0.135>
    rotate <15.511921, -90.0, 0.0>
    translate  <0.467934, 0.032947, -0.515008>
  }
}


#declare frambogi1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.110481, 0.180191, -0.048091>, <0.110481, 0.157956, -0.048091>, <0.119421, 0.157956, -0.047970>, <0.119421, 0.180191, -0.047970>, 
      <0.103539, 0.181104, 0.025942>, <0.103539, 0.155510, 0.025942>, <0.118291, 0.155510, 0.029961>, <0.118291, 0.181104, 0.029961>, 
      <0.095027, 0.181104, 0.077153>, <0.095027, 0.154748, 0.077153>, <0.113340, 0.154748, 0.082690>, <0.113340, 0.181104, 0.082690>, 
      <0.088578, 0.181104, 0.130201>, <0.088578, 0.154433, 0.130201>, <0.108434, 0.154433, 0.134573>, <0.108434, 0.181104, 0.134573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.119421, 0.180191, -0.047970>, <0.119421, 0.202427, -0.047970>, <0.110481, 0.202427, -0.048091>, <0.110481, 0.180191, -0.048091>, 
      <0.118291, 0.181104, 0.029961>, <0.118291, 0.206698, 0.029961>, <0.103539, 0.206698, 0.025942>, <0.103539, 0.181104, 0.025942>, 
      <0.113340, 0.181104, 0.082690>, <0.113340, 0.207460, 0.082690>, <0.095027, 0.207460, 0.077153>, <0.095027, 0.181104, 0.077153>, 
      <0.108434, 0.181104, 0.134573>, <0.108434, 0.207775, 0.134573>, <0.088578, 0.207775, 0.130201>, <0.088578, 0.181104, 0.130201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.088578, 0.181104, 0.130201>, <0.088578, 0.154433, 0.130201>, <0.108434, 0.154433, 0.134573>, <0.108434, 0.181104, 0.134573>, 
      <0.082130, 0.181104, 0.183249>, <0.082130, 0.154119, 0.183249>, <0.103527, 0.154119, 0.186456>, <0.103527, 0.181104, 0.186456>, 
      <0.074882, 0.181104, 0.233871>, <0.074882, 0.151593, 0.233871>, <0.095416, 0.151593, 0.241837>, <0.095416, 0.181104, 0.241837>, 
      <0.066896, 0.181104, 0.284421>, <0.066896, 0.151512, 0.284421>, <0.088308, 0.151512, 0.290982>, <0.088308, 0.181104, 0.290982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.108434, 0.181104, 0.134573>, <0.108434, 0.207775, 0.134573>, <0.088578, 0.207775, 0.130201>, <0.088578, 0.181104, 0.130201>, 
      <0.103527, 0.181104, 0.186456>, <0.103527, 0.208089, 0.186456>, <0.082130, 0.208089, 0.183249>, <0.082130, 0.181104, 0.183249>, 
      <0.095416, 0.181104, 0.241837>, <0.095416, 0.210615, 0.241837>, <0.074882, 0.210615, 0.233871>, <0.074882, 0.181104, 0.233871>, 
      <0.088308, 0.181104, 0.290982>, <0.088308, 0.210696, 0.290982>, <0.066896, 0.210696, 0.284421>, <0.066896, 0.181104, 0.284421>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.066896, 0.181104, 0.284421>, <0.066896, 0.151512, 0.284421>, <0.088308, 0.151512, 0.290982>, <0.088308, 0.181104, 0.290982>, 
      <0.058909, 0.181104, 0.334971>, <0.058909, 0.151431, 0.334971>, <0.081201, 0.151431, 0.340127>, <0.081201, 0.181104, 0.340127>, 
      <0.032630, 0.181104, 0.483951>, <0.032630, 0.146204, 0.483951>, <0.061004, 0.146204, 0.492864>, <0.061004, 0.181104, 0.492864>, 
      <0.029876, 0.181104, 0.491773>, <0.029876, 0.146204, 0.491773>, <0.053502, 0.146204, 0.507720>, <0.053502, 0.181104, 0.507720>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.088308, 0.181104, 0.290982>, <0.088308, 0.210696, 0.290982>, <0.066896, 0.210696, 0.284421>, <0.066896, 0.181104, 0.284421>, 
      <0.081201, 0.181104, 0.340127>, <0.081201, 0.210777, 0.340127>, <0.058909, 0.210776, 0.334971>, <0.058909, 0.181104, 0.334971>, 
      <0.061004, 0.181104, 0.492864>, <0.061004, 0.216004, 0.492864>, <0.032630, 0.216004, 0.483951>, <0.032630, 0.181104, 0.483951>, 
      <0.053502, 0.181104, 0.507720>, <0.053502, 0.216004, 0.507720>, <0.029876, 0.216004, 0.491773>, <0.029876, 0.181104, 0.491773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.029876, 0.181104, 0.491773>, <0.029876, 0.146204, 0.491773>, <0.053502, 0.146204, 0.507720>, <0.053502, 0.181104, 0.507720>, 
      <0.027123, 0.181104, 0.499594>, <0.027123, 0.146204, 0.499594>, <0.046000, 0.146204, 0.522576>, <0.046000, 0.181104, 0.522576>, 
      <0.014378, 0.181104, 0.511657>, <0.014378, 0.146204, 0.511657>, <0.024045, 0.146204, 0.539784>, <0.024045, 0.181104, 0.539784>, 
      <-0.000060, 0.181104, 0.509079>, <-0.000060, 0.146204, 0.509079>, <0.000005, 0.146204, 0.538820>, <0.000005, 0.181104, 0.538820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0020 u_steps 5 v_steps 5,
      <0.053502, 0.181104, 0.507720>, <0.053502, 0.216004, 0.507720>, <0.029876, 0.216004, 0.491773>, <0.029876, 0.181104, 0.491773>, 
      <0.046000, 0.181104, 0.522576>, <0.046000, 0.216004, 0.522576>, <0.027123, 0.216004, 0.499594>, <0.027123, 0.181104, 0.499594>, 
      <0.024045, 0.181104, 0.539784>, <0.024045, 0.216004, 0.539784>, <0.014378, 0.216004, 0.511657>, <0.014378, 0.181104, 0.511657>, 
      <0.000005, 0.181104, 0.538820>, <0.000005, 0.216004, 0.538820>, <-0.000060, 0.216004, 0.509079>, <-0.000060, 0.181104, 0.509079>
    }
  }
  material {
    bronslitur
  }
  rotate -90.0*z
  translate  <-0.36081, 0.0, 0.006696>
}
// Include contains 'storhjolafesting1'
#include "hi_wheel.in1"

#declare storhjolafesting1 = object {
  storhjolafesting1_Raw
  scale <0.04, 0.04, 0.005>
  rotate -90.0*x
  translate  <-0.18, -0.118, -0.025>
}
#declare Cylndr002 = object {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.035, 0.035, 0.005>
    rotate -90.0*x
    translate  <-0.18, -0.118, -0.09>
  }
}
#declare Cylndr001 = object {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.06>
    rotate -90.0*x
    translate  <-0.18, -0.14, -0.09>
  }
}
#declare storteinn1 = object {
  cylinder { // storteinn1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.002, 0.002, 0.53>
    rotate <-10.735177, -90.0, 0.0>
    translate  <-0.225677, -0.097598, -0.09>
  }
}




//
// ********  OBJECTS  *******
//

union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.002329, 0.353185, 0.515461>, <-0.002320, 0.353022, 0.514916>, <-0.001532, 0.353751, 0.517790>, <-0.000531, 0.353728, 0.517780>, 
      <-0.026878, 0.351140, 0.514503>, <-0.026748, 0.350473, 0.512337>, <-0.015707, 0.353457, 0.523754>, <-0.001688, 0.353362, 0.523715>, 
      <-0.029465, 0.319191, 0.509945>, <-0.029316, 0.318503, 0.506510>, <-0.016583, 0.321580, 0.524614>, <-0.000415, 0.321483, 0.524552>, 
      <-0.031194, 0.303905, 0.515200>, <-0.031036, 0.303228, 0.511765>, <-0.017584, 0.306258, 0.529868>, <-0.000503, 0.306162, 0.529806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000531, 0.353728, 0.517780>, <0.000470, 0.353705, 0.517771>, <0.001319, 0.352938, 0.514880>, <0.001310, 0.353101, 0.515425>, 
      <-0.001688, 0.353362, 0.523715>, <0.012332, 0.353268, 0.523676>, <0.024231, 0.350130, 0.512194>, <0.024102, 0.350797, 0.514360>, 
      <-0.000415, 0.321483, 0.524552>, <0.015753, 0.321385, 0.524490>, <0.029476, 0.318148, 0.506284>, <0.029327, 0.318836, 0.509719>, 
      <-0.000503, 0.306162, 0.529806>, <0.016578, 0.306066, 0.529744>, <0.031076, 0.302879, 0.511538>, <0.030918, 0.303556, 0.514973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.001310, 0.353101, 0.515425>, <0.001301, 0.353264, 0.515971>, <0.000486, 0.353907, 0.518281>, <-0.000515, 0.353931, 0.518291>, 
      <0.024102, 0.350797, 0.514360>, <0.023973, 0.351463, 0.516526>, <0.012552, 0.354097, 0.525703>, <-0.001467, 0.354191, 0.525742>, 
      <0.029327, 0.318836, 0.509719>, <0.029178, 0.319524, 0.513154>, <0.016007, 0.322241, 0.527703>, <-0.000161, 0.322338, 0.527766>, 
      <0.030918, 0.303556, 0.514973>, <0.030761, 0.304233, 0.518408>, <0.016846, 0.306908, 0.532958>, <-0.000235, 0.307004, 0.533020>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000515, 0.353931, 0.518291>, <-0.001516, 0.353954, 0.518301>, <-0.002338, 0.353348, 0.516007>, <-0.002329, 0.353185, 0.515461>, 
      <-0.001467, 0.354191, 0.525742>, <-0.015487, 0.354286, 0.525781>, <-0.027007, 0.351807, 0.516669>, <-0.026878, 0.351140, 0.514503>, 
      <-0.000161, 0.322338, 0.527766>, <-0.016328, 0.322436, 0.527828>, <-0.029614, 0.319879, 0.513380>, <-0.029465, 0.319191, 0.509945>, 
      <-0.000235, 0.307004, 0.533020>, <-0.017315, 0.307100, 0.533082>, <-0.031351, 0.304582, 0.518634>, <-0.031194, 0.303905, 0.515200>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.031194, 0.303905, 0.515200>, <-0.031036, 0.303228, 0.511765>, <-0.017584, 0.306258, 0.529868>, <-0.000503, 0.306162, 0.529806>, 
      <-0.032923, 0.288619, 0.520454>, <-0.032757, 0.287952, 0.517019>, <-0.018585, 0.290936, 0.535123>, <-0.000591, 0.290841, 0.535060>, 
      <-0.032997, 0.272107, 0.528524>, <-0.032831, 0.271440, 0.525089>, <-0.018660, 0.274424, 0.543193>, <-0.000666, 0.274329, 0.543131>, 
      <-0.033072, 0.255796, 0.528549>, <-0.032906, 0.255129, 0.525114>, <-0.018735, 0.258113, 0.543217>, <-0.000741, 0.258018, 0.543155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000503, 0.306162, 0.529806>, <0.016578, 0.306066, 0.529744>, <0.031076, 0.302879, 0.511538>, <0.030918, 0.303556, 0.514973>, 
      <-0.000591, 0.290841, 0.535060>, <0.017403, 0.290747, 0.534998>, <0.032676, 0.287609, 0.516792>, <0.032510, 0.288275, 0.520227>, 
      <-0.000666, 0.274329, 0.543131>, <0.017328, 0.274235, 0.543068>, <0.032601, 0.271097, 0.524862>, <0.032435, 0.271763, 0.528297>, 
      <-0.000741, 0.258018, 0.543155>, <0.017253, 0.257924, 0.543093>, <0.032526, 0.254786, 0.524887>, <0.032360, 0.255453, 0.528322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.030918, 0.303556, 0.514973>, <0.030761, 0.304233, 0.518408>, <0.016846, 0.306908, 0.532958>, <-0.000235, 0.307004, 0.533020>, 
      <0.032510, 0.288275, 0.520227>, <0.032344, 0.288942, 0.523662>, <0.017686, 0.291576, 0.538212>, <-0.000308, 0.291670, 0.538274>, 
      <0.032435, 0.271763, 0.528297>, <0.032269, 0.272430, 0.531732>, <0.017611, 0.275064, 0.546282>, <-0.000383, 0.275158, 0.546344>, 
      <0.032360, 0.255453, 0.528322>, <0.032195, 0.256119, 0.531757>, <0.017536, 0.258753, 0.546307>, <-0.000458, 0.258847, 0.546369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000235, 0.307004, 0.533020>, <-0.017315, 0.307100, 0.533082>, <-0.031351, 0.304582, 0.518634>, <-0.031194, 0.303905, 0.515200>, 
      <-0.000308, 0.291670, 0.538274>, <-0.018302, 0.291765, 0.538337>, <-0.033088, 0.289286, 0.523889>, <-0.032923, 0.288619, 0.520454>, 
      <-0.000383, 0.275158, 0.546344>, <-0.018377, 0.275253, 0.546407>, <-0.033163, 0.272774, 0.531959>, <-0.032997, 0.272107, 0.528524>, 
      <-0.000458, 0.258847, 0.546369>, <-0.018452, 0.258942, 0.546431>, <-0.033238, 0.256463, 0.531983>, <-0.033072, 0.255796, 0.528549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.033072, 0.255796, 0.528549>, <-0.032906, 0.255129, 0.525114>, <-0.018735, 0.258113, 0.543217>, <-0.000741, 0.258018, 0.543155>, 
      <-0.033147, 0.239485, 0.528573>, <-0.032981, 0.238819, 0.525138>, <-0.018810, 0.241802, 0.543242>, <-0.000816, 0.241707, 0.543180>, 
      <-0.033222, 0.223376, 0.531414>, <-0.033056, 0.222709, 0.527979>, <-0.018884, 0.225692, 0.546082>, <-0.000890, 0.225598, 0.546020>, 
      <-0.019374, 0.208824, 0.536038>, <-0.019279, 0.208807, 0.533344>, <-0.011161, 0.208336, 0.547466>, <-0.000853, 0.208248, 0.547406>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000741, 0.258018, 0.543155>, <0.017253, 0.257924, 0.543093>, <0.032526, 0.254786, 0.524887>, <0.032360, 0.255453, 0.528322>, 
      <-0.000816, 0.241707, 0.543180>, <0.017178, 0.241613, 0.543117>, <0.032452, 0.238475, 0.524912>, <0.032286, 0.239142, 0.528346>, 
      <-0.000890, 0.225598, 0.546020>, <0.017103, 0.225503, 0.545958>, <0.032377, 0.222365, 0.527752>, <0.032211, 0.223032, 0.531187>, 
      <-0.000853, 0.208248, 0.547406>, <0.009455, 0.208160, 0.547345>, <0.018204, 0.208354, 0.533124>, <0.018109, 0.208438, 0.535818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.032360, 0.255453, 0.528322>, <0.032195, 0.256119, 0.531757>, <0.017536, 0.258753, 0.546307>, <-0.000458, 0.258847, 0.546369>, 
      <0.032286, 0.239142, 0.528346>, <0.032120, 0.239808, 0.531781>, <0.017461, 0.242442, 0.546331>, <-0.000533, 0.242536, 0.546393>, 
      <0.032211, 0.223032, 0.531187>, <0.032045, 0.223699, 0.534622>, <0.017386, 0.226332, 0.549172>, <-0.000608, 0.226427, 0.549234>, 
      <0.018109, 0.208438, 0.535818>, <0.018014, 0.208522, 0.538511>, <0.009617, 0.208394, 0.549895>, <-0.000691, 0.208482, 0.549955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000458, 0.258847, 0.546369>, <-0.018452, 0.258942, 0.546431>, <-0.033238, 0.256463, 0.531983>, <-0.033072, 0.255796, 0.528549>, 
      <-0.000533, 0.242536, 0.546393>, <-0.018527, 0.242631, 0.546456>, <-0.033313, 0.240152, 0.532008>, <-0.033147, 0.239485, 0.528573>, 
      <-0.000608, 0.226427, 0.549234>, <-0.018602, 0.226521, 0.549296>, <-0.033388, 0.224042, 0.534848>, <-0.033222, 0.223376, 0.531414>, 
      <-0.000691, 0.208482, 0.549955>, <-0.010998, 0.208570, 0.550016>, <-0.019469, 0.208842, 0.538732>, <-0.019374, 0.208824, 0.536038>
    }
  }
  material {
    bronslitur
  }
  rotate 90.0*z
  translate  <-0.003889, 0.0, -0.019778>
}


#declare bogi001 = difference {
  torus { // Torus017
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.01
    rotate <-90.0, -270.0, 0.0>
    translate  <-0.221606, 0.0, 0.667361>
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.01, 0.02>
    translate  <-0.224306, 0.0, 0.647405>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.01, 0.02>
    rotate -33.461109*y
    translate  <-0.239032, 0.0, 0.685211>
  }
}
#declare bogi002 = difference {
  torus { // Torus018
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.01
    rotate <-90.0, -270.0, 0.0>
    translate  <-0.203905, 0.0, 0.690683>
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.01, 0.02>
    rotate -56.336594*y
    translate  <-0.184498, 0.0, 0.67295>
  }
}
#declare bogi003 = difference {
  torus { // Torus019
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.01
    rotate <-90.0, -270.0, 0.0>
    translate  <-0.222058, 0.0, 0.549921>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.01, 0.02>
    translate  <-0.225949, 0.0, 0.569989>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.01, 0.02>
    rotate <0.0, 60.0, -0.0>
    translate  <-0.23949, 0.0, 0.540201>
  }
}
#declare bogi004 = difference {
  torus { // Torus020
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.01
    rotate <-90.0, -270.0, 0.0>
    translate  <-0.20713, 0.0, 0.524302>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.01, 0.02>
    translate  <-0.212507, 0.0, 0.504385>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.01, 0.02>
    rotate -29.16497*y
    translate  <-0.187054, 0.0, 0.5513>
  }
}
union { // skeidarbremsa
  object { bogi001 }
  object { bogi002 }
  cylinder { // bremsustong
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.005, 0.005, 0.12>
    translate  <-0.207, 0.0, 0.55>
  }
  object { bogi003 }
  object { bogi004 }
  cylinder { // bremsustong1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.005, 0.005, 0.01>
    translate  <-0.222089, 0.0, 0.514371>
  }
}


plane { // Plane001
  z,0
  material {
    Mountains1
  }
  translate  <0.0, -0.057794, -0.693528>
}


#declare adalbogi = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.008100, 0.168325, 0.610592>, <0.008100, 0.168806, 0.541563>, <-0.008100, 0.168789, 0.541549>, <-0.008100, 0.168353, 0.610585>, 
      <0.015496, 0.128519, 0.611101>, <0.015496, 0.138014, 0.538980>, <-0.015496, 0.137981, 0.538998>, <-0.015496, 0.128549, 0.611100>, 
      <0.015496, 0.102093, 0.598618>, <0.015496, 0.123928, 0.548136>, <-0.015496, 0.123928, 0.548136>, <-0.015496, 0.102068, 0.598570>, 
      <0.015496, 0.090454, 0.581465>, <0.015496, 0.109787, 0.543356>, <-0.015496, 0.109770, 0.543339>, <-0.015496, 0.090431, 0.581425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.008100, 0.168353, 0.610585>, <-0.008100, 0.167916, 0.679621>, <0.008100, 0.167844, 0.679621>, <0.008100, 0.168325, 0.610592>, 
      <-0.015496, 0.128549, 0.611100>, <-0.015496, 0.119117, 0.683201>, <0.015496, 0.119024, 0.683222>, <0.015496, 0.128519, 0.611101>, 
      <-0.015496, 0.102068, 0.598570>, <-0.015496, 0.080208, 0.649005>, <0.015496, 0.080257, 0.649100>, <0.015496, 0.102093, 0.598618>, 
      <-0.015496, 0.090431, 0.581425>, <-0.015496, 0.071091, 0.619512>, <0.015496, 0.071120, 0.619575>, <0.015496, 0.090454, 0.581465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.015496, 0.090454, 0.581465>, <0.015496, 0.109787, 0.543356>, <-0.015496, 0.109770, 0.543339>, <-0.015496, 0.090431, 0.581425>, 
      <0.015496, 0.078815, 0.564313>, <0.015496, 0.095647, 0.538576>, <-0.015496, 0.095612, 0.538541>, <-0.015496, 0.078793, 0.564280>, 
      <0.015496, 0.051573, 0.538198>, <0.015496, 0.077078, 0.504424>, <-0.015496, 0.077078, 0.504424>, <-0.015496, 0.051573, 0.538198>, 
      <0.015496, 0.012488, 0.529306>, <0.015496, 0.027946, 0.499594>, <-0.015496, 0.027946, 0.499594>, <-0.015496, 0.012576, 0.529393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.015496, 0.090431, 0.581425>, <-0.015496, 0.071091, 0.619512>, <0.015496, 0.071120, 0.619575>, <0.015496, 0.090454, 0.581465>, 
      <-0.015496, 0.078793, 0.564280>, <-0.015496, 0.061974, 0.590019>, <0.015496, 0.061983, 0.590049>, <0.015496, 0.078815, 0.564313>, 
      <-0.015496, 0.051573, 0.538198>, <-0.015496, 0.026069, 0.571973>, <0.015496, 0.026069, 0.571973>, <0.015496, 0.051573, 0.538198>, 
      <-0.015496, 0.012576, 0.529393>, <-0.015496, -0.002795, 0.559192>, <0.015496, -0.002970, 0.559018>, <0.015496, 0.012488, 0.529306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.015496, 0.012488, 0.529306>, <0.015496, 0.027946, 0.499594>, <-0.015496, 0.027946, 0.499594>, <-0.015496, 0.012576, 0.529393>, 
      <0.015496, -0.026597, 0.520413>, <0.015496, -0.021185, 0.494763>, <-0.015496, -0.021185, 0.494763>, <-0.015496, -0.026422, 0.520587>, 
      <0.015496, -0.190265, 0.446209>, <0.015496, -0.177113, 0.423885>, <-0.015496, -0.176091, 0.423088>, <-0.015496, -0.189709, 0.445795>, 
      <0.015496, -0.227681, 0.420846>, <0.015496, -0.212484, 0.398431>, <-0.015496, -0.212431, 0.398033>, <-0.015496, -0.227563, 0.420628>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.015496, 0.012576, 0.529393>, <-0.015496, -0.002795, 0.559192>, <0.015496, -0.002970, 0.559018>, <0.015496, 0.012488, 0.529306>, 
      <-0.015496, -0.026422, 0.520587>, <-0.015496, -0.031659, 0.546411>, <0.015496, -0.032010, 0.546062>, <0.015496, -0.026597, 0.520413>, 
      <-0.015496, -0.189709, 0.445795>, <-0.015496, -0.203326, 0.468502>, <0.015496, -0.203417, 0.468534>, <0.015496, -0.190265, 0.446209>, 
      <-0.015496, -0.227563, 0.420628>, <-0.015496, -0.242696, 0.443224>, <0.015496, -0.242879, 0.443261>, <0.015496, -0.227681, 0.420846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.015496, -0.227681, 0.420846>, <0.015496, -0.212484, 0.398431>, <-0.015496, -0.212431, 0.398033>, <-0.015496, -0.227563, 0.420628>, 
      <0.015496, -0.265098, 0.395483>, <0.015496, -0.247855, 0.372977>, <-0.015496, -0.248771, 0.372977>, <-0.015496, -0.265418, 0.395461>, 
      <0.015496, -0.357869, 0.308800>, <0.015496, -0.337954, 0.291892>, <-0.015496, -0.337954, 0.291892>, <-0.015496, -0.358019, 0.308642>, 
      <0.015496, -0.396716, 0.247582>, <0.015496, -0.375614, 0.234287>, <-0.015496, -0.375901, 0.234431>, <-0.015496, -0.396935, 0.247575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.015496, -0.227563, 0.420628>, <-0.015496, -0.242696, 0.443224>, <0.015496, -0.242879, 0.443261>, <0.015496, -0.227681, 0.420846>, 
      <-0.015496, -0.265418, 0.395461>, <-0.015496, -0.282065, 0.417946>, <0.015496, -0.282341, 0.417989>, <0.015496, -0.265098, 0.395483>, 
      <-0.015496, -0.358019, 0.308642>, <-0.015496, -0.378083, 0.325391>, <0.015496, -0.377783, 0.325708>, <0.015496, -0.357869, 0.308800>, 
      <-0.015496, -0.396935, 0.247575>, <-0.015496, -0.417968, 0.260719>, <0.015496, -0.417818, 0.260878>, <0.015496, -0.396716, 0.247582>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.015496, -0.396716, 0.247582>, <0.015496, -0.375614, 0.234287>, <-0.015496, -0.375901, 0.234431>, <-0.015496, -0.396935, 0.247575>, 
      <0.015496, -0.435564, 0.186365>, <0.015496, -0.413274, 0.176682>, <-0.015496, -0.413848, 0.176969>, <-0.015496, -0.435851, 0.186508>, 
      <0.015496, -0.465476, 0.092409>, <0.015496, -0.441977, 0.086109>, <-0.015496, -0.441977, 0.086109>, <-0.015496, -0.465466, 0.092408>, 
      <0.015496, -0.475022, 0.039966>, <0.015496, -0.451074, 0.036144>, <-0.015496, -0.450322, 0.036144>, <-0.015496, -0.474641, 0.039966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.015496, -0.396935, 0.247575>, <-0.015496, -0.417968, 0.260719>, <0.015496, -0.417818, 0.260878>, <0.015496, -0.396716, 0.247582>, 
      <-0.015496, -0.435851, 0.186508>, <-0.015496, -0.457854, 0.196047>, <0.015496, -0.457854, 0.196047>, <0.015496, -0.435564, 0.186365>, 
      <-0.015496, -0.465466, 0.092408>, <-0.015496, -0.488955, 0.098707>, <0.015496, -0.488974, 0.098709>, <0.015496, -0.465476, 0.092409>, 
      <-0.015496, -0.474641, 0.039966>, <-0.015496, -0.498959, 0.043788>, <0.015496, -0.498969, 0.043789>, <0.015496, -0.475022, 0.039966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.015496, -0.475022, 0.039966>, <0.015496, -0.451074, 0.036144>, <-0.015496, -0.450322, 0.036144>, <-0.015496, -0.474641, 0.039966>, 
      <0.015496, -0.484568, -0.012476>, <0.015496, -0.460171, -0.013821>, <-0.015496, -0.458666, -0.013821>, <-0.015496, -0.483815, -0.012476>, 
      <0.015496, -0.477416, -0.314086>, <0.015496, -0.458820, -0.314086>, <-0.015496, -0.458820, -0.314086>, <-0.015496, -0.477416, -0.314086>, 
      <0.015496, -0.477456, -0.316417>, <0.015496, -0.458860, -0.316417>, <-0.015496, -0.458860, -0.316417>, <-0.015496, -0.477456, -0.316417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.015496, -0.474641, 0.039966>, <-0.015496, -0.498959, 0.043788>, <0.015496, -0.498969, 0.043789>, <0.015496, -0.475022, 0.039966>, 
      <-0.015496, -0.483815, -0.012476>, <-0.015496, -0.508964, -0.011131>, <0.015496, -0.508964, -0.011131>, <0.015496, -0.484568, -0.012476>, 
      <-0.015496, -0.477416, -0.314086>, <-0.015496, -0.496012, -0.314086>, <0.015496, -0.496012, -0.314086>, <0.015496, -0.477416, -0.314086>, 
      <-0.015496, -0.477456, -0.316417>, <-0.015496, -0.496051, -0.316417>, <0.015496, -0.496051, -0.316417>, <0.015496, -0.477456, -0.316417>
    }
  }
  material {
    bronslitur
  }
  rotate 90.0*z
}
//
// Include file contains 'afturoxull'
//
#include "hi_wheel.in2"
#declare afturoxull = object {
  afturoxull_Raw
  material {
    krom
  }
  scale 0.05
  rotate -90.0*x
  translate  <0.5, 0.0, -0.515>
}
#declare TransSweep005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.318017, 0.160122>,
  <-0.099394, -0.001221>,
  <0.00298, 0.098846>,
  <-0.140538, 0.199512>,
  <-0.140879, 0.298991>,
  <-0.322295, 0.297811>,
  <-0.318017, 0.160122>
  rotate -x*90
  material {
    krom
  }
  scale <0.1, 0.1, 0.0015>
  rotate <-92.699997, -180.0, -180.0>
  translate  <0.5, -0.041, -0.514872>
}
#declare TransSweep006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.318017, 0.160122>,
  <-0.099394, -0.001221>,
  <0.00298, 0.098846>,
  <-0.140538, 0.199512>,
  <-0.140879, 0.298991>,
  <-0.322295, 0.297811>,
  <-0.318017, 0.160122>
  rotate -x*90
  material {
    krom
  }
  scale <0.1, 0.1, 0.0015>
  rotate <-87.300003, -180.0, -180.0>
  translate  <0.5, 0.042, -0.514872>
}
#declare afturoxulshluti = union {
  cylinder { // afturpinni1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.008, 0.008, 0.1>
    rotate -90.0*x
    translate  <0.5, -0.05, -0.515>
  }
  object { afturoxull }
  object { RndDisc012 }
  object { TransSweep005 }
  object { Sphere002 }
  object { // Sphere003 -> Sphere002
    Sphere002
    translate  <0.0, 0.1, 0.0>
  }
  object { // RndDisc013 -> RndDisc012
    RndDisc012
    rotate -0.0*x
    translate  <0.0, 0.082, 0.0>
  }
  object { TransSweep006 }
}
#declare smateinar1 = union {
  object { smateinn }
  object { // smateinn1 -> smateinn
    smateinn
    rotate <0.0, 30.0, 0.0>
    translate  <0.324116, -0.0, 0.181188>
  }
  object { // smateinn2 -> smateinn
    smateinn
    rotate <0.0, 60.0, 0.0>
    translate  <0.695661, -0.0, 0.17572>
  }
  object { // smateinn3 -> smateinn
    smateinn
    rotate <-0.0, 90.0, -0.0>
    translate  <1.014987, 0.0, -0.014717>
  }
  object { // smateinn4 -> smateinn
    smateinn
    rotate <180.0, 60.0, 180.0>
    translate  <1.196136, -0.0, -0.339465>
  }
  object { // smateinn5 -> smateinn
    smateinn
    rotate <180.0, 30.0, 180.0>
    translate  <1.19053, -0.0, -0.710871>
  }
  object { // smateinn6 -> smateinn
    smateinn
    rotate <180.0, -0.0, 180.0>
    translate  <0.999851, -0.0, -1.030194>
  }
  object { // smateinn7 -> smateinn
    smateinn
    rotate <-180.0, -30.0, 180.0>
    translate  <0.675557, -0.0, -1.211025>
  }
  object { // smateinn8 -> smateinn
    smateinn
    rotate <-180.0, -60.0, 180.0>
    translate  <0.304012, -0.0, -1.205558>
  }
  object { // smateinn9 -> smateinn
    smateinn
    rotate <0.0, -90.0, -0.0>
    translate  <-0.014953, 0.0, -1.013707>
  }
  object { // smateinn10 -> smateinn
    smateinn
    rotate <-0.0, -60.0, 0.0>
    translate  <-0.196181, -0.0, -0.690728>
  }
  object { // smateinn11 -> smateinn
    smateinn
    rotate <-0.0, -30.0, 0.0>
    translate  <-0.190713, -0.0, -0.319184>
  }
}
#declare smateinar2 = union {
  cylinder { // smateinn12
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.002, 0.002, 0.135>
    rotate <15.511921, -90.0, 0.0>
    translate  <0.467934, 0.032947, -0.515008>
  }
  object { // smateinn13 -> smateinn
    smateinn
    rotate <0.0, 30.0, 0.0>
    translate  <0.324116, -0.0, 0.181188>
  }
  object { // smateinn14 -> smateinn
    smateinn
    rotate <0.0, 60.0, 0.0>
    translate  <0.695661, -0.0, 0.17572>
  }
  object { // smateinn15 -> smateinn
    smateinn
    rotate <-0.0, 90.0, -0.0>
    translate  <1.014987, 0.0, -0.014717>
  }
  object { // smateinn16 -> smateinn
    smateinn
    rotate <180.0, 60.0, 180.0>
    translate  <1.196136, -0.0, -0.339465>
  }
  object { // smateinn17 -> smateinn
    smateinn
    rotate <180.0, 30.0, 180.0>
    translate  <1.19053, -0.0, -0.710871>
  }
  object { // smateinn18 -> smateinn
    smateinn
    rotate <180.0, -0.0, 180.0>
    translate  <0.999851, -0.0, -1.030194>
  }
  object { // smateinn19 -> smateinn
    smateinn
    rotate <-180.0, -30.0, 180.0>
    translate  <0.675557, -0.0, -1.211025>
  }
  object { // smateinn20 -> smateinn
    smateinn
    rotate <-180.0, -60.0, 180.0>
    translate  <0.304012, -0.0, -1.205558>
  }
  object { // smateinn21 -> smateinn
    smateinn
    rotate <0.0, -90.0, -0.0>
    translate  <-0.014953, 0.0, -1.013707>
  }
  object { // smateinn22 -> smateinn
    smateinn
    rotate <-0.0, -60.0, 0.0>
    translate  <-0.196181, -0.0, -0.690728>
  }
  object { // smateinn23 -> smateinn
    smateinn
    rotate <-0.0, -30.0, 0.0>
    translate  <-0.190713, -0.0, -0.319184>
  }
  rotate <0.0, -15.0, 180.0>
  translate  <1.116897, -0.001, -0.146862>
}
#declare sxE6ti = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000004, -0.290065, 0.540014>, <-0.000006, -0.290064, 0.540014>, <-0.000000, -0.290067, 0.540016>, <-0.000001, -0.290067, 0.540016>, 
      <-0.065512, -0.296027, 0.544615>, <-0.058868, -0.296081, 0.542439>, <-0.047371, -0.296029, 0.547033>, <0.000000, -0.296029, 0.545715>, 
      <-0.092772, -0.237533, 0.514624>, <-0.086128, -0.237785, 0.530651>, <-0.047371, -0.239457, 0.558685>, <0.000000, -0.239457, 0.558685>, 
      <-0.101999, -0.215229, 0.507588>, <-0.095355, -0.215333, 0.524723>, <-0.056597, -0.216151, 0.558119>, <-0.000395, -0.215624, 0.558119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000001, -0.290067, 0.540016>, <-0.000001, -0.290067, 0.540016>, <-0.000002, -0.290067, 0.540016>, <-0.000001, -0.290066, 0.540015>, 
      <0.000000, -0.296029, 0.545715>, <0.047371, -0.296029, 0.544398>, <0.065216, -0.296455, 0.542439>, <0.072493, -0.296400, 0.544299>, 
      <0.000000, -0.239457, 0.558685>, <0.047371, -0.239457, 0.558685>, <0.086128, -0.237785, 0.530651>, <0.093404, -0.237533, 0.514308>, 
      <-0.000395, -0.215624, 0.558119>, <0.055807, -0.215097, 0.558119>, <0.094564, -0.214279, 0.524723>, <0.101840, -0.214174, 0.507271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000001, -0.290066, 0.540015>, <-0.000000, -0.290066, 0.540014>, <-0.000001, -0.290066, 0.540015>, <-0.000002, -0.290067, 0.540016>, 
      <0.072493, -0.296400, 0.544299>, <0.079769, -0.296346, 0.546158>, <0.046105, -0.296112, 0.546926>, <-0.001265, -0.296112, 0.546926>, 
      <0.093404, -0.237533, 0.514308>, <0.100680, -0.237282, 0.497964>, <0.046105, -0.216334, 0.504178>, <-0.001265, -0.216334, 0.504178>, 
      <0.101840, -0.214174, 0.507271>, <0.109117, -0.214070, 0.489819>, <0.054541, -0.203350, 0.496734>, <-0.001661, -0.203877, 0.496734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000002, -0.290067, 0.540016>, <-0.000003, -0.290067, 0.540016>, <-0.000003, -0.290065, 0.540013>, <-0.000004, -0.290065, 0.540014>, 
      <-0.001265, -0.296112, 0.546926>, <-0.048636, -0.296112, 0.546926>, <-0.072155, -0.295973, 0.546790>, <-0.065512, -0.296027, 0.544615>, 
      <-0.001265, -0.216334, 0.504178>, <-0.048636, -0.216334, 0.504178>, <-0.099415, -0.237282, 0.498597>, <-0.092772, -0.237533, 0.514624>, 
      <-0.001661, -0.203877, 0.496734>, <-0.057863, -0.204404, 0.496734>, <-0.108642, -0.215125, 0.490452>, <-0.101999, -0.215229, 0.507588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.101999, -0.215229, 0.507588>, <-0.095355, -0.215333, 0.524723>, <-0.056597, -0.216151, 0.558119>, <-0.000395, -0.215624, 0.558119>, 
      <-0.111225, -0.192925, 0.500551>, <-0.104582, -0.192882, 0.518795>, <-0.065824, -0.192846, 0.557553>, <-0.000791, -0.191792, 0.557553>, 
      <-0.074813, -0.098089, 0.486735>, <-0.068170, -0.098929, 0.519706>, <-0.047371, -0.098146, 0.573780>, <0.000000, -0.098146, 0.573780>, 
      <-0.053212, -0.054286, 0.532167>, <-0.046568, -0.054662, 0.553076>, <-0.027816, -0.054592, 0.590333>, <0.000778, -0.054592, 0.590333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000395, -0.215624, 0.558119>, <0.055807, -0.215097, 0.558119>, <0.094564, -0.214279, 0.524723>, <0.101840, -0.214174, 0.507271>, 
      <-0.000791, -0.191792, 0.557553>, <0.064243, -0.190737, 0.557553>, <0.103000, -0.190773, 0.518795>, <0.110276, -0.190816, 0.500235>, 
      <0.000000, -0.098146, 0.573780>, <0.047371, -0.098146, 0.573780>, <0.065925, -0.098181, 0.519706>, <0.073201, -0.097340, 0.486419>, 
      <0.000778, -0.054592, 0.590333>, <0.029373, -0.054592, 0.590333>, <0.045182, -0.054288, 0.553076>, <0.052458, -0.053912, 0.531850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.101840, -0.214174, 0.507271>, <0.109117, -0.214070, 0.489819>, <0.054541, -0.203350, 0.496734>, <-0.001661, -0.203877, 0.496734>, 
      <0.110276, -0.190816, 0.500235>, <0.117553, -0.190859, 0.481675>, <0.062977, -0.190365, 0.489289>, <-0.002056, -0.191420, 0.489289>, 
      <0.073201, -0.097340, 0.486419>, <0.080477, -0.096500, 0.453131>, <0.046105, -0.098303, 0.561598>, <-0.001265, -0.098303, 0.561598>, 
      <0.052458, -0.053912, 0.531850>, <0.059735, -0.053535, 0.510625>, <0.028107, -0.054749, 0.576286>, <-0.000487, -0.054749, 0.576286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.001661, -0.203877, 0.496734>, <-0.057863, -0.204404, 0.496734>, <-0.108642, -0.215125, 0.490452>, <-0.101999, -0.215229, 0.507588>, 
      <-0.002056, -0.191420, 0.489289>, <-0.067090, -0.192474, 0.489289>, <-0.117869, -0.192968, 0.482307>, <-0.111225, -0.192925, 0.500551>, 
      <-0.001265, -0.098303, 0.561598>, <-0.048636, -0.098303, 0.561598>, <-0.081457, -0.097248, 0.453764>, <-0.074813, -0.098089, 0.486735>, 
      <-0.000487, -0.054749, 0.576286>, <-0.029081, -0.054749, 0.576286>, <-0.059855, -0.053909, 0.511258>, <-0.053212, -0.054286, 0.532167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.053212, -0.054286, 0.532167>, <-0.046568, -0.054662, 0.553076>, <-0.027816, -0.054592, 0.590333>, <0.000778, -0.054592, 0.590333>, 
      <-0.031610, -0.010483, 0.577598>, <-0.024967, -0.010395, 0.586445>, <-0.008261, -0.011038, 0.606886>, <0.001557, -0.011038, 0.606886>, 
      <-0.020471, 0.073198, 0.600450>, <-0.012261, 0.072956, 0.609250>, <-0.008168, 0.073049, 0.649704>, <0.000632, 0.073279, 0.649704>, 
      <-0.000209, 0.067127, 0.600199>, <-0.000024, 0.067193, 0.600251>, <-0.000038, 0.067140, 0.600182>, <-0.000007, 0.067140, 0.600190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.000778, -0.054592, 0.590333>, <0.029373, -0.054592, 0.590333>, <0.045182, -0.054288, 0.553076>, <0.052458, -0.053912, 0.531850>, 
      <0.001557, -0.011038, 0.606886>, <0.011375, -0.011038, 0.606886>, <0.024440, -0.010395, 0.586445>, <0.031716, -0.010483, 0.577282>, 
      <0.000632, 0.073279, 0.649704>, <0.009431, 0.073509, 0.649704>, <0.013393, 0.073931, 0.609250>, <0.020669, 0.073859, 0.600133>, 
      <-0.000007, 0.067140, 0.600190>, <0.000024, 0.067140, 0.600197>, <0.000009, 0.067167, 0.600251>, <-0.000044, 0.067108, 0.600205>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <0.052458, -0.053912, 0.531850>, <0.059735, -0.053535, 0.510625>, <0.028107, -0.054749, 0.576286>, <-0.000487, -0.054749, 0.576286>, 
      <0.031716, -0.010483, 0.577282>, <0.038992, -0.010571, 0.568119>, <0.010110, -0.011195, 0.590973>, <0.000291, -0.011195, 0.590973>, 
      <0.020669, 0.073859, 0.600133>, <0.027945, 0.073787, 0.591016>, <0.008166, 0.073841, 0.638988>, <-0.000634, 0.073611, 0.638988>, 
      <-0.000044, 0.067108, 0.600205>, <-0.000098, 0.067050, 0.600160>, <-0.000024, 0.067211, 0.600209>, <-0.000089, 0.067185, 0.600194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 5 v_steps 5,
      <-0.000487, -0.054749, 0.576286>, <-0.029081, -0.054749, 0.576286>, <-0.059855, -0.053909, 0.511258>, <-0.053212, -0.054286, 0.532167>, 
      <0.000291, -0.011195, 0.590973>, <-0.009527, -0.011195, 0.590973>, <-0.038254, -0.010571, 0.568752>, <-0.031610, -0.010483, 0.577598>, 
      <-0.000634, 0.073611, 0.638988>, <-0.009433, 0.073381, 0.638988>, <-0.028681, 0.073439, 0.591649>, <-0.020471, 0.073198, 0.600450>, 
      <-0.000089, 0.067185, 0.600194>, <-0.000154, 0.067159, 0.600178>, <-0.000393, 0.067060, 0.600147>, <-0.000209, 0.067127, 0.600199>
    }
  }
  material {
    ledur
  }
  rotate 90.0*z
}
#declare lodrettstong2 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    bronslitur
  }
  scale <0.02, 0.02, 0.11>
  translate  <-0.18, 0.0, 0.559>
}
#declare CSG006 = intersection {
  torus { // Torus005
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.005
    rotate -90.0*x
    translate  <-0.12, -0.018, 0.59>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.01, 0.02>
    translate  <-0.13, -0.018, 0.59>
  }
}
#declare CSG007 = intersection {
  torus { // Torus006
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.005
    rotate -90.0*x
    translate  <-0.12, -0.018, 0.59>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.01, 0.02>
    translate  <-0.13, -0.018, 0.59>
  }
  translate  0.036*y
}
#declare CSG008 = intersection {
  torus { // Torus007
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.005
    translate  <-0.06, -0.0105, 0.5975>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.02, 0.01>
    translate  <-0.05, -0.01, 0.6>
  }
}
#declare CSG009 = intersection {
  torus { // Torus008
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.005
    translate  <-0.06, -0.0105, 0.5975>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.02, 0.01>
    translate  <-0.05, -0.01, 0.6>
  }
  translate  0.021*y
}
#declare framfjodur = union {
  object { CSG006 }
  object { CSG007 }
  cylinder { // fjadrapinni1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.005, 0.005, 0.05>
    rotate -90.0*x
    translate  <-0.12, -0.025, 0.59>
  }
  cylinder { // fjodurf1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.0025, 0.0025, 0.06>
    rotate -90.0*y
    translate  <-0.06, -0.018, 0.5975>
  }
  object { CSG008 }
  cylinder { // fjodurf2
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.0025, 0.0025, 0.06>
    rotate -90.0*y
    translate  <-0.06, 0.018, 0.5975>
  }
  object { CSG009 }
}
#declare CSG010 = difference {
  torus { // Torus009
    1.875, 0.125  rotate -x*90
    material {
      krom
    }
    scale 0.025
    rotate -90.0*x
    translate  <0.371202, -0.018, 0.404997>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.03, 0.05>
    rotate -15.0*y
    translate  <0.348138, -0.018, 0.374061>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.03, 0.05>
    rotate 15.0*y
    translate  <0.344141, -0.018, 0.424034>
  }
  translate  <-0.005137, 0.0, 0.000211>
}
#declare CSG011 = difference {
  torus { // Torus010
    1.875, 0.125  rotate -x*90
    material {
      krom
    }
    scale 0.025
    rotate -90.0*x
    translate  <0.335887, -0.018, 0.507712>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.03, 0.055>
    rotate 15.0*y
    translate  <0.366093, -0.018, 0.501672>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.03, 0.055>
    rotate 60.0*y
    translate  <0.322126, -0.018, 0.534435>
  }
  translate  <-0.028331, 0.0, 0.010041>
}
#declare tengi1 = difference {
  torus { // Torus012
    1.45, 0.55  rotate -x*90
    material {
      krom
    }
    scale 0.0056
    rotate -90.0*x
    translate  <-0.12, -0.018, 0.59>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.01, 0.02>
    translate  <-0.130042, -0.018, 0.589935>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.01, 0.02>
    rotate <-0.0, -90.0, 0.0>
    translate  <-0.121095, -0.018, 0.599946>
  }
  rotate <-90.0, -120.0, -0.0>
  translate  <0.202712, -0.599926, 0.641665>
}
#declare fjadrasett1 = union {
  cylinder { // fjodurf3
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.06>
    rotate <-0.0, -105.0, -0.0>
    translate  <0.377949, -0.018, 0.359984>
  }
  cylinder { // fjodurf4
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.09>
    rotate <-0.0, -75.0, -0.0>
    translate  <0.383132, -0.018, 0.44905>
  }
  cylinder { // fjodurf5
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.04>
    rotate <0.0, -30.0, -0.0>
    translate  <0.267161, -0.018, 0.494135>
  }
  object { CSG010 }
  object { CSG011 }
  object { tengi1 }
  cylinder { // fjodurf6
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.04>
    rotate <90.0, -145.0, -180.0>
    translate  <0.243108, -0.009919, 0.535823>
  }
  rotate 25.0*x
  translate  <0.0, 0.144, 0.04>
}
#declare CSG012 = intersection {
  torus { // Torus011
    1.45, 0.55  rotate -x*90
    material {
      krom
    }
    scale 0.0056
    rotate -90.0*x
    translate  <-0.12, -0.018, 0.59>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.01, 0.02>
    rotate -15.0*y
    translate  <-0.130196, -0.018, 0.589935>
  }
  translate  <0.441973, 0.0, -0.253119>
}
#declare CSG013 = intersection {
  torus { // Torus013
    1.45, 0.55  rotate -x*90
    material {
      krom
    }
    scale 0.0056
    rotate -90.0*x
    translate  <-0.12, -0.018, 0.59>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.01, 0.02>
    rotate -15.0*y
    translate  <-0.130196, -0.018, 0.589935>
  }
  translate  <0.441973, 0.036, -0.253119>
}
#declare pinnasett1 = union {
  cylinder { // fjadrapinni2
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.005, 0.005, 0.05>
    rotate -90.0*x
    translate  <0.322, -0.025, 0.337>
  }
  object { CSG012 }
  object { CSG013 }
}
#declare CSG014 = difference {
  torus { // Torus014
    1.875, 0.125  rotate -x*90
    material {
      krom
    }
    scale 0.025
    rotate -90.0*x
    translate  <0.371202, -0.018, 0.404997>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.03, 0.05>
    rotate -15.0*y
    translate  <0.348138, -0.018, 0.374061>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.03, 0.05>
    rotate 15.0*y
    translate  <0.344141, -0.018, 0.424034>
  }
  translate  <-0.005137, 0.0, 0.000211>
}
#declare CSG015 = difference {
  torus { // Torus015
    1.875, 0.125  rotate -x*90
    material {
      krom
    }
    scale 0.025
    rotate -90.0*x
    translate  <0.335887, -0.018, 0.507712>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.03, 0.055>
    rotate 15.0*y
    translate  <0.366093, -0.018, 0.501672>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.03, 0.03, 0.055>
    rotate 60.0*y
    translate  <0.322126, -0.018, 0.534435>
  }
  translate  <-0.028331, 0.0, 0.010041>
}
#declare fjadrasett2 = union {
  cylinder { // fjodurf7
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.06>
    rotate <-0.0, -105.0, -0.0>
    translate  <0.377949, -0.018, 0.359984>
  }
  cylinder { // fjodurf8
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.09>
    rotate <-0.0, -75.0, -0.0>
    translate  <0.383132, -0.018, 0.44905>
  }
  cylinder { // fjodurf9
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.04>
    rotate <0.0, -30.0, -0.0>
    translate  <0.267017, -0.018, 0.494135>
  }
  object { CSG014 }
  object { CSG015 }
  translate  <0.0, 0.2, 0.1>
}
#declare tengi2 = difference {
  torus { // Torus016
    1.45, 0.55  rotate -x*90
    material {
      krom
    }
    scale 0.0056
    rotate -90.0*x
    translate  <-0.12, -0.018, 0.59>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.01, 0.02>
    translate  <-0.130042, -0.018, 0.589935>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.01, 0.02>
    rotate <-0.0, -90.0, 0.0>
    translate  <-0.121095, -0.018, 0.599946>
  }
  rotate <90.0, -120.0, 0.0>
  translate  <0.171459, 0.76382, 0.723559>
}
#declare fjadrasett3 = union {
  object { fjadrasett2 }
  cylinder { // fjodurf10
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.04>
    rotate <90.0, -145.0, -180.0>
    translate  <0.242984, 0.133865, 0.635695>
  }
  object { tengi2 }
  rotate -25.0*x
  translate  <-0.000314, -0.334684, 0.018302>
}
union { // afturhluti
  object { afturbogi1 }
  torus { // smadekk1
    1.975, 0.1  rotate -x*90
    material {
      dekkjagummi
    }
    scale <0.085, 0.085, 0.15>
    rotate -90.0*x
    translate  <0.5, 0.0, -0.515>
  }
  torus { // smagjord1
    1.975, 0.1  rotate -x*90
    material {
      krom
    }
    scale <0.08, 0.08, 0.1>
    rotate -90.0*x
    translate  <0.5, 0.0, -0.515>
  }
  object { // afturbogi2 -> afturbogi1
    afturbogi1
    rotate -180.0*z
    translate  0.955*x
  }
  object { adalbogi }
  object { afturoxulshluti }
  object { smateinar1 }
  object { smateinar2 }
  object { sxE6ti }
  object { lodrettstong2 }
  object { framfjodur }
  object { fjadrasett1 }
  object { pinnasett1 }
  object { fjadrasett3 }
  cylinder { // millitengi1
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.07>
    rotate <-90.0, 0.0, -0.0>
    translate  <0.40744, -0.035, 0.380475>
  }
}


//
// Include file contains 'framoxull'
//
#include "hi_wheel.in3"
#declare framoxull = object {
  framoxull_Raw
  scale 0.1
  rotate -90.0*x
  translate  <-0.18, 0.0, -0.09>
}
#declare framoxulsheild = union {
  object { storhjolafesting1 }
  object { Cylndr002 }
  object { Cylndr001 }
  object { framoxull }
  object { // Cylndr003 -> Cylndr001
    Cylndr001
    rotate <-0.0, -0.0, -0.0>
    translate  0.22*y
  }
  object { // Cylndr004 -> Cylndr002
    Cylndr002
    translate  0.23*y
  }
  object { // storhjolafesting2 -> storhjolafesting1
    storhjolafesting1
    rotate <0.0, -0.0, -0.0>
    translate  0.23*y
  }
  material {
    krom
  }
}
#declare framteinar1 = union {
  object { storteinn1 }
  object { // storteinn2 -> storteinn1
    storteinn1
    rotate <0.0, 10.0, 0.0>
    translate  <0.012959, 0.0, -0.03271>
  }
  object { // storteinn3 -> storteinn1
    storteinn1
    rotate <0.0, 20.0, 0.0>
    translate  <0.01993, 0.0, -0.067119>
  }
  object { // storteinn4 -> storteinn1
    storteinn1
    rotate <0.0, 30.0, 0.0>
    translate  <0.021144, 0.0, -0.10216>
  }
  object { // storteinn5 -> storteinn1
    storteinn1
    rotate <0.0, 40.0, 0.0>
    translate  <0.015841, 0.0, -0.136651>
  }
  object { // storteinn6 -> storteinn1
    storteinn1
    rotate <0.0, 50.0, 0.0>
    translate  <0.004836, 0.0, -0.169854>
  }
  object { // storteinn7 -> storteinn1
    storteinn1
    rotate <0.0, 60.0, 0.0>
    translate  <-0.011953, 0.0, -0.200976>
  }
  object { // storteinn8 -> storteinn1
    storteinn1
    rotate <0.0, 70.0, 0.0>
    translate  <-0.033808, 0.0, -0.228363>
  }
  object { // storteinn9 -> storteinn1
    storteinn1
    rotate <0.0, 80.0, 0.0>
    translate  <-0.060103, 0.0, -0.251553>
  }
  object { // storteinn10 -> storteinn1
    storteinn1
    rotate <-0.0, 90.0, 0.0>
    translate  <-0.090022, 0.0, -0.270069>
  }
  object { // storteinn11 -> storteinn1
    storteinn1
    rotate <-180.0, 80.0, 180.0>
    translate  <-0.122615, 0.0, -0.282934>
  }
  object { // storteinn12 -> storteinn1
    storteinn1
    rotate <-180.0, 70.0, 180.0>
    translate  <-0.157002, 0.0, -0.289901>
  }
  object { // storteinn13 -> storteinn1
    storteinn1
    rotate <-180.0, 60.0, 180.0>
    translate  <-0.192212, 0.0, -0.291004>
  }
  object { // storteinn14 -> storteinn1
    storteinn1
    rotate <-180.0, 50.0, 180.0>
    translate  <-0.226814, 0.0, -0.285848>
  }
  object { // storteinn15 -> storteinn1
    storteinn1
    rotate <-180.0, 40.0, 180.0>
    translate  <-0.260283, 0.0, -0.274683>
  }
  object { // storteinn16 -> storteinn1
    storteinn1
    rotate <-180.0, 30.0, 180.0>
    translate  <-0.290984, 0.0, -0.258028>
  }
  object { // storteinn17 -> storteinn1
    storteinn1
    rotate <-180.0, 20.0, 180.0>
    translate  <-0.3185, 0.0, -0.236238>
  }
  object { // storteinn18 -> storteinn1
    storteinn1
    rotate <-180.0, 10.0, 180.0>
    translate  <-0.341787, 0.0, -0.209995>
  }
  object { // storteinn19 -> storteinn1
    storteinn1
    rotate <-180.0, -0.0, 180.0>
    translate  <-0.360228, 0.0, -0.179974>
  }
  object { // storteinn20 -> storteinn1
    storteinn1
    rotate <-180.0, -10.0, 180.0>
    translate  <-0.373093, 0.0, -0.147325>
  }
  object { // storteinn21 -> storteinn1
    storteinn1
    rotate <-180.0, -20.0, 180.0>
    translate  <-0.379844, 0.0, -0.112971>
  }
  object { // storteinn22 -> storteinn1
    storteinn1
    rotate <-180.0, -30.0, 180.0>
    translate  <-0.381015, 0.0, -0.077834>
  }
  object { // storteinn23 -> storteinn1
    storteinn1
    rotate <-180.0, -40.0, 180.0>
    translate  <-0.375798, 0.0, -0.043103>
  }
  object { // storteinn24 -> storteinn1
    storteinn1
    rotate <-180.0, -50.0, 180.0>
    translate  <-0.364755, 0.0, -0.009984>
  }
  object { // storteinn25 -> storteinn1
    storteinn1
    rotate <-180.0, -60.0, 180.0>
    translate  <-0.348055, 0.0, 0.02103>
  }
  object { // storteinn26 -> storteinn1
    storteinn1
    rotate <-180.0, -70.0, 180.0>
    translate  <-0.326155, 0.0, 0.048402>
  }
  object { // storteinn27 -> storteinn1
    storteinn1
    rotate <-180.0, -80.0, 180.0>
    translate  <-0.299915, 0.0, 0.071594>
  }
  object { // storteinn28 -> storteinn1
    storteinn1
    rotate <0.0, -90.0, 0.0>
    translate  <-0.270019, 0.0, 0.089984>
  }
  object { // storteinn29 -> storteinn1
    storteinn1
    rotate <0.0, -80.0, 0.0>
    translate  <-0.23737, 0.0, 0.103014>
  }
  object { // storteinn30 -> storteinn1
    storteinn1
    rotate <0.0, -70.0, 0.0>
    translate  <-0.20299, 0.0, 0.109844>
  }
  object { // storteinn31 -> storteinn1
    storteinn1
    rotate <0.0, -60.0, 0.0>
    translate  <-0.167899, 0.0, 0.111027>
  }
  object { // storteinn32 -> storteinn1
    storteinn1
    rotate <0.0, -50.0, 0.0>
    translate  <-0.133251, 0.0, 0.10576>
  }
  object { // storteinn33 -> storteinn1
    storteinn1
    rotate <0.0, -40.0, 0.0>
    translate  <-0.099869, 0.0, 0.094732>
  }
  object { // storteinn34 -> storteinn1
    storteinn1
    rotate <0.0, -30.0, 0.0>
    translate  <-0.069008, 0.0, 0.07807>
  }
  object { // storteinn35 -> storteinn1
    storteinn1
    rotate <0.0, -20.0, 0.0>
    translate  <-0.041617, 0.0, 0.056193>
  }
  object { // storteinn36 -> storteinn1
    storteinn1
    rotate <0.0, -10.0, 0.0>
    translate  <-0.018243, 0.0, 0.029831>
  }
}
#declare framteinar2 = union {
  cylinder { // storteinn37
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.002, 0.002, 0.53>
    rotate <-10.735177, -90.0, 0.0>
    translate  <-0.225677, -0.097598, -0.09>
  }
  object { // storteinn38 -> storteinn1
    storteinn1
    rotate <0.0, 10.0, 0.0>
    translate  <0.012959, 0.0, -0.03271>
  }
  object { // storteinn39 -> storteinn1
    storteinn1
    rotate <0.0, 20.0, 0.0>
    translate  <0.01993, 0.0, -0.067119>
  }
  object { // storteinn40 -> storteinn1
    storteinn1
    rotate <0.0, 30.0, 0.0>
    translate  <0.021144, 0.0, -0.10216>
  }
  object { // storteinn41 -> storteinn1
    storteinn1
    rotate <0.0, 40.0, 0.0>
    translate  <0.015841, 0.0, -0.136651>
  }
  object { // storteinn42 -> storteinn1
    storteinn1
    rotate <0.0, 50.0, 0.0>
    translate  <0.004836, 0.0, -0.169854>
  }
  object { // storteinn43 -> storteinn1
    storteinn1
    rotate <0.0, 60.0, 0.0>
    translate  <-0.011953, 0.0, -0.200976>
  }
  object { // storteinn44 -> storteinn1
    storteinn1
    rotate <0.0, 70.0, 0.0>
    translate  <-0.033808, 0.0, -0.228363>
  }
  object { // storteinn45 -> storteinn1
    storteinn1
    rotate <0.0, 80.0, 0.0>
    translate  <-0.060103, 0.0, -0.251553>
  }
  object { // storteinn46 -> storteinn1
    storteinn1
    rotate <-0.0, 90.0, 0.0>
    translate  <-0.090022, 0.0, -0.270069>
  }
  object { // storteinn47 -> storteinn1
    storteinn1
    rotate <-180.0, 80.0, 180.0>
    translate  <-0.122615, 0.0, -0.282934>
  }
  object { // storteinn48 -> storteinn1
    storteinn1
    rotate <-180.0, 70.0, 180.0>
    translate  <-0.157002, 0.0, -0.289901>
  }
  object { // storteinn49 -> storteinn1
    storteinn1
    rotate <-180.0, 60.0, 180.0>
    translate  <-0.192212, 0.0, -0.291004>
  }
  object { // storteinn50 -> storteinn1
    storteinn1
    rotate <-180.0, 50.0, 180.0>
    translate  <-0.226814, 0.0, -0.285848>
  }
  object { // storteinn51 -> storteinn1
    storteinn1
    rotate <-180.0, 40.0, 180.0>
    translate  <-0.260283, 0.0, -0.274683>
  }
  object { // storteinn52 -> storteinn1
    storteinn1
    rotate <-180.0, 30.0, 180.0>
    translate  <-0.290984, 0.0, -0.258028>
  }
  object { // storteinn53 -> storteinn1
    storteinn1
    rotate <-180.0, 20.0, 180.0>
    translate  <-0.3185, 0.0, -0.236238>
  }
  object { // storteinn54 -> storteinn1
    storteinn1
    rotate <-180.0, 10.0, 180.0>
    translate  <-0.341787, 0.0, -0.209995>
  }
  object { // storteinn55 -> storteinn1
    storteinn1
    rotate <-180.0, -0.0, 180.0>
    translate  <-0.360228, 0.0, -0.179974>
  }
  object { // storteinn56 -> storteinn1
    storteinn1
    rotate <-180.0, -10.0, 180.0>
    translate  <-0.373093, 0.0, -0.147325>
  }
  object { // storteinn57 -> storteinn1
    storteinn1
    rotate <-180.0, -20.0, 180.0>
    translate  <-0.379844, 0.0, -0.112971>
  }
  object { // storteinn58 -> storteinn1
    storteinn1
    rotate <-180.0, -30.0, 180.0>
    translate  <-0.381015, 0.0, -0.077834>
  }
  object { // storteinn59 -> storteinn1
    storteinn1
    rotate <-180.0, -40.0, 180.0>
    translate  <-0.375798, 0.0, -0.043103>
  }
  object { // storteinn60 -> storteinn1
    storteinn1
    rotate <-180.0, -50.0, 180.0>
    translate  <-0.364755, 0.0, -0.009984>
  }
  object { // storteinn61 -> storteinn1
    storteinn1
    rotate <-180.0, -60.0, 180.0>
    translate  <-0.348055, 0.0, 0.02103>
  }
  object { // storteinn62 -> storteinn1
    storteinn1
    rotate <-180.0, -70.0, 180.0>
    translate  <-0.326155, 0.0, 0.048402>
  }
  object { // storteinn63 -> storteinn1
    storteinn1
    rotate <-180.0, -80.0, 180.0>
    translate  <-0.299915, 0.0, 0.071594>
  }
  object { // storteinn64 -> storteinn1
    storteinn1
    rotate <0.0, -90.0, 0.0>
    translate  <-0.270019, 0.0, 0.089984>
  }
  object { // storteinn65 -> storteinn1
    storteinn1
    rotate <0.0, -80.0, 0.0>
    translate  <-0.23737, 0.0, 0.103014>
  }
  object { // storteinn66 -> storteinn1
    storteinn1
    rotate <0.0, -70.0, 0.0>
    translate  <-0.20299, 0.0, 0.109844>
  }
  object { // storteinn67 -> storteinn1
    storteinn1
    rotate <0.0, -60.0, 0.0>
    translate  <-0.167899, 0.0, 0.111027>
  }
  object { // storteinn68 -> storteinn1
    storteinn1
    rotate <0.0, -50.0, 0.0>
    translate  <-0.133251, 0.0, 0.10576>
  }
  object { // storteinn69 -> storteinn1
    storteinn1
    rotate <0.0, -40.0, 0.0>
    translate  <-0.099869, 0.0, 0.094732>
  }
  object { // storteinn70 -> storteinn1
    storteinn1
    rotate <0.0, -30.0, 0.0>
    translate  <-0.069008, 0.0, 0.07807>
  }
  object { // storteinn71 -> storteinn1
    storteinn1
    rotate <0.0, -20.0, 0.0>
    translate  <-0.041617, 0.0, 0.056193>
  }
  object { // storteinn72 -> storteinn1
    storteinn1
    rotate <0.0, -10.0, 0.0>
    translate  <-0.018243, 0.0, 0.029831>
  }
  rotate <0.0, -5.0, -180.0>
  translate  <-0.351, 0.0, 0.015>
}
#declare framhjol = union {
  object { frambogi1 }
  object { // frambogi2 -> frambogi1
    frambogi1
    rotate -180.0*z
    translate  -0.36*x
  }
  torus { // stortdekk
    1.95, 0.05  rotate -x*90
    material {
      dekkjagummi
    }
    scale <0.3, 0.3, 0.5>
    rotate -90.0*x
    translate  <-0.18, 0.0, -0.09>
  }
  torus { // storgjord
    1.95, 0.05  rotate -x*90
    material {
      krom
    }
    scale <0.295, 0.295, 0.39>
    rotate -90.0*x
    translate  <-0.18, 0.0, -0.09>
  }
  cylinder { // lodrettstong
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.015, 0.015, 0.175>
    translate  <-0.18, 0.0, 0.53>
  }
  object { framoxulsheild }
  object { framteinar1 }
  object { framteinar2 }
}
#declare RndDisc001 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    krom
  }
  scale 0.03
  rotate -90.0*x
  translate  <-0.18, -0.16, -0.09>
}
#declare RndDisc002 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    krom
  }
  scale <0.015, 0.015, 0.02>
  rotate -90.0*x
  translate  <0.065, -0.155, -0.09>
}
#declare pedalaarmur1 = union {
  object { RndDisc001 }
  cone { // Cone001
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      krom
    }
    scale <0.012, 0.012, 0.2>
    rotate -90.0*y
    translate  <0.05, -0.145, -0.09>
  }
  object { RndDisc002 }
}
#declare TransSweep001 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.0, 0.33>,
  <-0.35, 0.15>,
  <-0.6, 0.0>,
  <-0.35, -0.15>,
  <0.0, -0.33>,
  <0.35, -0.15>,
  <0.6, 0.0>,
  <0.35, 0.15>,
  <0.0, 0.33>,
  <-0.35, 0.15>,
  <-0.6, 0.0>
  rotate -x*90
  material {
    krom
  }
  scale <0.05, 0.05, 0.002>
  rotate -90.0*x
  translate  <0.065, -0.285, -0.09>
}
#declare RndDisc003 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    krom
  }
  scale <0.015, 0.015, 0.005>
  rotate -90.0*x
  translate  <0.065, -0.288, -0.09>
}
#declare TransSweep002 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.0, 0.33>,
  <-0.35, 0.15>,
  <-0.6, 0.0>,
  <-0.35, -0.15>,
  <0.0, -0.33>,
  <0.35, -0.15>,
  <0.6, 0.0>,
  <0.35, 0.15>,
  <0.0, 0.33>,
  <-0.35, 0.15>,
  <-0.6, 0.0>
  rotate -x*90
  material {
    krom
  }
  scale <0.05, 0.05, 0.002>
  rotate -90.0*x
  translate  <0.065, -0.17, -0.09>
}
#declare RndDisc004 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    krom
  }
  scale <0.015, 0.015, 0.005>
  rotate -90.0*x
  translate  <0.065, -0.17, -0.09>
}
#declare RndCube001 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
  material {
    dekkjagummi
  }
  scale <0.022, 0.11, 0.022>
  translate  <0.087, -0.226, -0.09>
}
#declare RndCube002 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
  material {
    dekkjagummi
  }
  scale <0.022, 0.11, 0.022>
  translate  <0.043, -0.226, -0.09>
}
#declare pedalastykki1 = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.007, 0.007, 0.15>
    rotate -90.0*x
    translate  <0.065, -0.29, -0.09>
  }
  object { TransSweep001 }
  object { RndDisc003 }
  object { TransSweep002 }
  object { RndDisc004 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.13>
    rotate -90.0*x
    translate  <0.087, -0.29, -0.09>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.13>
    rotate -90.0*x
    translate  <0.043, -0.29, -0.09>
  }
  object { RndCube001 }
  object { RndCube002 }
  rotate -29.612181*y
  translate  <-0.036199, 0.0, -0.043966>
}
#declare pedaliogarmur1 = union {
  object { pedalaarmur1 }
  object { pedalastykki1 }
  rotate 40.0*y
  translate  <0.015541, 0.0, -0.136889>
}
#declare RndDisc005 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    krom
  }
  scale 0.03
  rotate -90.0*x
  translate  <-0.18, -0.16, -0.09>
}
#declare RndDisc006 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    krom
  }
  scale <0.015, 0.015, 0.02>
  rotate -90.0*x
  translate  <0.065, -0.155, -0.09>
}
#declare pedalaarmur2 = union {
  object { RndDisc005 }
  cone { // Cone002
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      krom
    }
    scale <0.012, 0.012, 0.2>
    rotate -90.0*y
    translate  <0.05, -0.145, -0.09>
  }
  object { RndDisc006 }
}
#declare TransSweep003 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.0, 0.33>,
  <-0.35, 0.15>,
  <-0.6, 0.0>,
  <-0.35, -0.15>,
  <0.0, -0.33>,
  <0.35, -0.15>,
  <0.6, 0.0>,
  <0.35, 0.15>,
  <0.0, 0.33>,
  <-0.35, 0.15>,
  <-0.6, 0.0>
  rotate -x*90
  material {
    krom
  }
  scale <0.05, 0.05, 0.002>
  rotate -90.0*x
  translate  <0.065, -0.285, -0.09>
}
#declare RndDisc007 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    krom
  }
  scale <0.015, 0.015, 0.005>
  rotate -90.0*x
  translate  <0.065, -0.288, -0.09>
}
#declare TransSweep004 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.0, 0.33>,
  <-0.35, 0.15>,
  <-0.6, 0.0>,
  <-0.35, -0.15>,
  <0.0, -0.33>,
  <0.35, -0.15>,
  <0.6, 0.0>,
  <0.35, 0.15>,
  <0.0, 0.33>,
  <-0.35, 0.15>,
  <-0.6, 0.0>
  rotate -x*90
  material {
    krom
  }
  scale <0.05, 0.05, 0.002>
  rotate -90.0*x
  translate  <0.065, -0.17, -0.09>
}
#declare RndDisc008 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    krom
  }
  scale <0.015, 0.015, 0.005>
  rotate -90.0*x
  translate  <0.065, -0.17, -0.09>
}
#declare RndCube003 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
  material {
    dekkjagummi
  }
  scale <0.022, 0.11, 0.022>
  translate  <0.087, -0.226, -0.09>
}
#declare RndCube004 = merge {
  sphere { <0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, 0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, 0.3000>, 0.2000 }
  sphere { <0.3000, 0.3000, -0.3000>, 0.2000 }
  sphere { <0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, -0.3000, -0.3000>, 0.2000 }
  sphere { <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, -0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, -0.3000, -0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, -0.3000, -0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, 0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, 0.3000>, <0.3000, -0.3000, 0.3000>, 0.2000 }
  cylinder { <0.3000, 0.3000, -0.3000>, <0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, -0.3000>, <-0.3000, -0.3000, -0.3000>, 0.2000 }
  cylinder { <-0.3000, 0.3000, 0.3000>, <-0.3000, -0.3000, 0.3000>, 0.2000 }
  box { <-0.3000, -0.3000, -0.5000> <0.3000, 0.3000, 0.5000> }
  box { <-0.3000, -0.5000, -0.3000> <0.3000, 0.5000, 0.3000> }
  box { <-0.5000, -0.3000, -0.3000> <0.5000, 0.3000, 0.3000> }
  material {
    dekkjagummi
  }
  scale <0.022, 0.11, 0.022>
  translate  <0.043, -0.226, -0.09>
}
#declare pedalastykki2 = union {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.007, 0.007, 0.15>
    rotate -90.0*x
    translate  <0.065, -0.29, -0.09>
  }
  object { TransSweep003 }
  object { RndDisc007 }
  object { TransSweep004 }
  object { RndDisc008 }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.13>
    rotate -90.0*x
    translate  <0.087, -0.29, -0.09>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.003, 0.003, 0.13>
    rotate -90.0*x
    translate  <0.043, -0.29, -0.09>
  }
  object { RndCube003 }
  object { RndCube004 }
}
#declare pedaliogarmur2 = union {
  object { pedalaarmur2 }
  object { pedalastykki2 }
  rotate <0.0, -40.0, -180.0>
  translate  <-0.260336, 0.0, 0.094844>
}
#declare CSG001 = intersection {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.018, 0.018, 0.02>
    translate  <-0.18, 0.0, 0.68>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale 0.05
    translate  <-0.13, 0.0, 0.68>
  }
}
#declare RndDisc010 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.8000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.9020, -0.9020, 0.7980>, <0.9020, 0.9020, 1.0020> } } }
  torus { 0.8000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.8020, -0.8020, -0.0020>, <0.8020, 0.8020, 0.1020> } } }
  material {
    krom
  }
  scale <0.012, 0.012, 0.003>
  rotate -90.0*x
  translate  <-0.204, -0.018, 0.690732>
}
#declare RndDisc011 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7000, 0.7000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.8000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.9020, -0.9020, 0.7980>, <0.9020, 0.9020, 1.0020> } } }
  torus { 0.8000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.8020, -0.8020, -0.0020>, <0.8020, 0.8020, 0.1020> } } }
  material {
    krom
  }
  scale <0.012, 0.012, 0.003>
  rotate -90.0*x
  translate  <-0.204, 0.018, 0.690732>
}
#declare RndDisc009 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  material {
    krom
  }
  scale <0.02, 0.02, 0.015>
  translate  <-0.18, 0.0, 0.543>
}
#declare styriseining = union {
  object { CSG001 }
  object { RndDisc010 }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.0015, 0.01>
    translate  <-0.19, -0.016495, 0.69>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.01, 0.0015, 0.01>
    translate  <-0.19, 0.0165, 0.69>
  }
  object { RndDisc011 }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      krom
    }
    scale 0.012
    translate  <-0.179996, 0.0, 0.702>
  }
  object { RndDisc009 }
}
#declare CSG002 = difference {
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.016
    translate  <-0.228, -0.1, 0.691>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.05, 0.02, 0.02>
    translate  <-0.23, -0.08, 0.69>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.05, 0.02, 0.02>
    rotate -45.0*z
    translate  <-0.24214, -0.113701, 0.69>
  }
}
#declare CSG003 = difference {
  torus { // Torus002
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.016
    translate  <-0.228, -0.1, 0.691>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.05, 0.02, 0.02>
    translate  <-0.23, -0.08, 0.69>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.05, 0.02, 0.02>
    rotate -45.0*z
    translate  <-0.24214, -0.113701, 0.69>
  }
  rotate -180.0*z
  translate  <-0.435747, -0.247533, 0.0>
}
#declare styrid1 = union {
  object { CSG002 }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.008, 0.008, 0.02>
    rotate <-90.0, 0.0, -45.0>
    translate  <-0.224967, -0.130874, 0.691>
  }
  object { CSG003 }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.008, 0.008, 0.02>
    rotate -90.0*x
    translate  <-0.231704, -0.167499, 0.691>
  }
}
#declare CSG004 = difference {
  torus { // Torus003
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.016
    translate  <-0.228, -0.1, 0.691>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.05, 0.02, 0.02>
    translate  <-0.23, -0.08, 0.69>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.05, 0.02, 0.02>
    rotate -45.0*z
    translate  <-0.24214, -0.113701, 0.69>
  }
}
#declare CSG005 = difference {
  torus { // Torus004
    1.5, 0.5  rotate -x*90
    material {
      krom
    }
    scale 0.016
    translate  <-0.228, -0.1, 0.691>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.05, 0.02, 0.02>
    translate  <-0.23, -0.08, 0.69>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    material {
      krom
    }
    scale <0.05, 0.02, 0.02>
    rotate -45.0*z
    translate  <-0.24214, -0.113701, 0.69>
  }
  rotate -180.0*z
  translate  <-0.435747, -0.247533, 0.0>
}
#declare styrid2 = union {
  object { CSG004 }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.008, 0.008, 0.02>
    rotate <-90.0, 0.0, -45.0>
    translate  <-0.224967, -0.130874, 0.691>
  }
  object { CSG005 }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.008, 0.008, 0.02>
    rotate -90.0*x
    translate  <-0.231704, -0.167499, 0.691>
  }
  rotate -180.0*x
  translate  1.382*z
}
//
// Include file contains 'handfang1'
//
#include "hi_wheel.in4"
#declare handfang1 = object {
  handfang1_Raw
  material {
    holduvidur
  }
  scale 0.01
  rotate -90.0*x
  translate  <-0.2317, -0.17, 0.691>
}
//
// Include file contains 'handfang2'
//
#include "hi_wheel.in5"
#declare handfang2 = object {
  handfang2_Raw
  material {
    holduvidur
  }
  scale 0.01
  rotate <-90.0, 0.0, -180.0>
  translate  <-0.2317, 0.17, 0.691>
}
#declare styriuppi = union {
  object { styrid1 }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      krom
    }
    scale <0.008, 0.008, 0.2>
    rotate -90.0*x
    translate  <-0.204, -0.1, 0.691>
  }
  object { styrid2 }
  object { handfang1 }
  object { handfang2 }
  rotate -30.0*y
  translate  <0.318, 0.0, 0.1945>
}
union { // framhluti
  object { framhjol }
  object { pedaliogarmur1 }
  object { pedaliogarmur2 }
  object { styriseining }
  object { styriuppi }
}






sphere { // himinhvolf
  <0,0,0>,1
  material {
    Tropics_Cloud_Sky
  }
  scale 30.0
}


box { // undirlag
  <-1, -1, -1>, <1, 1, 1>
  material {
    gras
  }
  translate  <0.0, -0.053296, -25.0>
}




