// Persistence of Vision Ray Tracer Scene Description File
// File: casa.pov - The Mill House -
// Vers: 3.5
// Desc: Jan-Feb 2003 IRTC Entry - Topic "Old Technologies"
// Date: Start - 11Ene03
// Auth: J. F. Tuduri

#version 3.5;

#include "colors.inc"
#include "shapes.inc"
#include "transforms.inc"

#include "techo.pov"

#local CalidadTecho=1;
#local Bend=1;
#local SD=seed(871);


//parametros para makewall
#declare typeWall=2;            // 1=box ; 2=ellipsoid
#declare pEllipsoid=0.1;
#declare eMortar=.025;           // mortar thickness
#declare eWall=-.95;             // mortar depth
#declare xBrickMin=.1;             // min brick size
#declare xBrickMax=.25;             // max brick size
#declare yBrickMin=.01;             // min brick height
#declare yBrickMax=.04;             // max brick height
#declare seedWall=777;              // seed wall
#declare srd1=0.8;                  // randomness amount for brick position (0=no random)
#declare srd2=0.25;                  // randomness amount for brick rotation (0=no random)
#declare srdcol=0;                // randomness amount for color (0=no random)
#declare patternWall=1;             // y color gradient for wall texture
#declare pigWall=rgb<0.6,0.5,0.4>*1.2;    // wall main color
#declare txtMortar=texture{pigment{rgb<0.89,0.9,0.95>*.8}normal {granite scale .1}} // mortar texture
                     
global_settings {
  assumed_gamma 1.0
}      
           /*           
// ----------------------------------------
#declare camera_location = <-15, 2, -15>;  //<-15, 2, -15.0>;

camera {
  
  direction 1.5*z//1.5
  right     x*image_width/image_height
  location  camera_location look_at   <1.0,3.0, 2.0>
  //location  <-4.0, 4, 4.0>look_at   <-0.0, 1.5,  2.0>
  //location  <-8, 5, 1> look_at   <4.0,1.0, 2.0>
  //location  <-10, 1, -2.0> look_at   <-4,2.0, 4.0> 
  //location  <-5, 5, -3.0> look_at   <2.0,7.0, 6.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}                                  
              */            
// ----------------------------------------
#declare TexCasaMad1=texture{pigment{wood rotate <0,90,0> turbulence .1 scale <.5,.1,.5>*.3
                                     color_map{
                                               [0 rgb <1,1,.9>]
                                               [1 rgb <.5,.5,.45>*1.3]}
                                     quick_color Grey}
                            }
#declare TexCasaPintura=texture{pigment{
                                        bozo scale <.25,.05,.25>*1.2 turbulence .1
                                        color_map{[0 rgb .99]
                                                  [.5 rgb .99]
                                                  [.7 rgbt 1]
                                                  [1 rgbt 1]}
                                        quick_color Grey}
                                 normal{bozo -.5 scale .1 turbulence .1}
                                 finish {phong 1 phong_size 100}
                               }   
#declare TexGrad=texture{pigment{gradient y scale .2 frequency 1 turbulence .1
                                 color_map {//[0 rgbt 1]
                                            //[0 rgbf <.46,.46,.4,1>]
                                            [.0 rgbt 1]
                                            [.6 rgbft <.56,.56,.5,1,.5>]
                                            //[.7 rgbt 1]
                                            [1 rgbft <.46,.46,.4,1,.3>]
                                            }
                                 quick_color Grey
                                 }
                         }
#declare TexSucioGrad=texture{pigment{
                                        gradient y scale 10
                                        color_map{[0 rgbt <.1,.1,0,.2>]
                                                  [.2 rgbt 1]
                                                  [1 rgbt 1]
                                                  }
                                      }
                             }                           
#declare TexVentana=texture{
                         pigment {wood
                                  color_map{
                                            [0 rgb<.85,.75,.65>*1.15] //*.6
                                            [1 rgb<.75,.65,.55>*1.15]
                                            }
                                   scale <.1,.07,.6>*.75
                                   turbulence .2
                                  }
                         normal{wood .2 scale <.1,.07,.6>*.75 turbulence .2}
                         }
                 texture{pigment{bozo scale <.05,.05,1>*.6 turbulence .4
                                 color_map{[0 rgbf <.96,.85,.7,.8>] //<.8,.6,.3,.8>]
                                           [.7 rgbf <.96,.85,.7,1>]//<.8,.6,.3,1>]
                                           [.75 rgbt 1]                                
                                           [1 rgbt 1]}
                                        quick_color Grey}
                                 normal{bozo -.5 scale <.05,.05,1>*.6 turbulence .4}
                                 finish {phong 1 phong_size 100}
                               }
                               
#declare TexTechoMad1=texture{pigment{wood rotate <0,90,0> turbulence .2 scale <1,.1,.1>*.3
                                     color_map{
                                               [0 rgb <.9,.85,.63>*.5]
                                               [.3 rgb <.5,.45,.23>*.5]
                                               [1 rgb <.45,.3,.23>*.5]}
                                     quick_color Grey} 
                              normal {wood rotate <0,90,0> turbulence .2 scale <.7,.1,.1>*.3}
                            }
#declare TexVidrio=texture{pigment {rgbt 1} finish {reflection .3}}
                   texture{pigment {cylindrical rotate z*90 turbulence .2
                                    scale .5
                                    color_map{[0 rgbt <0,0,0,.8>]
                                              //[.3 rgb <0,0,0>]
                                              [.4 rgbt 1]  
                                              [1 rgbt 1]
                                              }
                                    }
                          }                                                                                                               
//plane{y,-.5 pigment {Brown}}   
                     
             
//CASA

//techo            
       
#local Techo1=union{                         
                box{<-.5,7.1,3.9>,<9.5,6.9,4.1> texture{TexTechoMad1}}

                box{<-.05,0,-.05>,<.05,-5,.05> texture {TexTechoMad1 rotate <90,0,90>} rotate x*60 translate <-.4,7,4>}
                box{<-.05,0,-.05>,<.05,-5,.05> texture {TexTechoMad1 rotate <90,0,90>} rotate x*60 translate <9.4,7,4>}
                
                box{<-.05,0,-.05>,<.05,-5,.05> texture {TexTechoMad1 rotate <90,0,90>} rotate x*-60 translate <-.4,7,4>}
                box{<-.05,0,-.05>,<.05,-5,.05> texture {TexTechoMad1 rotate <90,0,90>} rotate x*-60 translate <9.4,7,4>}
                #local i=.3;
                #while (i<9)
                        box{<-.05,0,-.05>,<.05,-5,.05> texture {TexTechoMad1 rotate <90,0,90>} rotate x*60 translate <i,7,4>}
                        #local i=i+9/12;
                #end


                object{techo(30,10,5,.4,.3,CalidadTecho) rotate y*270 translate <9.5,7.08,4>}
                object{techo(30,10,5,.4,.3,CalidadTecho) rotate y*90 translate <-0.5,7.08,4>}
                }//fin TECHO1

#if (Bend)                
// BEND OPTIONS
   #declare object_axis1 = <-.5, 7.1, 4>;
   #declare object_axis2 = <8.5,7.1,4>;
   #declare bend_angle = 2;
   #declare bend_direction=y;
   #declare bend_smoothness = 20;
   #declare bend_start=.45;
   #declare bend_finish=.55;

   #declare bend_object=object{Techo1}
   object{#include "bend\bend.inc" translate y*-.05}
#else
   object{Techo1}
#end                    
                    
//Piedras

#declare xWall=9;             // wall length in x
#declare yWall=1;              // wall height in y
#include "wall\makewall.pov"
object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
       scale <1,1,1> translate <.1,-1,.95>}

#declare xWall=2;             // wall length in x
#declare yWall=1;              // wall height in y
#include "wall\makewall.pov"
object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
       rotate y*90 scale <1,1,1> translate <.95,-1,2.05>}
       
intersection{
        difference{
                box{<0,0,0>,<9,7,8>}
                box{<.1,.1,.1>,<8.9,6.9,7.9>}
                box{<-.2,.01,-.64>,<.2,1.1,.64> translate <0,4.8,4>}
                pigment {Grey}
                }
        plane{z,0 inverse rotate x*60 translate <0,7,4> pigment {Brown}}
        plane{z,0 rotate x*-60 translate <0,7,4> pigment {Brown}}
        }


//Paredes

union{
#local i=0;
#while (i<4.6)
intersection{
             box{<0,0,0>,<9,.2,-.1>}
             plane{z,0 inverse rotate x*20 translate <0,.15,-.01>}
             texture{TexCasaMad1 translate <60*rand(SD),60*rand(SD),0>}
             texture{TexCasaPintura translate <60*rand(SD),60*rand(SD),0>}
             texture{TexGrad}
             Rotate_Around_Trans(<rand(SD)*.25-.125,rand(SD)*.25-.125,rand(SD)*.25-.125>,<0,.1,0>)//(<rand(SD)*.5-.25,rand(SD)*.5-.25,rand(SD)*.5-.25>,<4.5,.1,0>)
             translate y*i
             texture{TexSucioGrad}
             }
#local i=i+.16;
#end
}


#local i=0;
#while (i<7)
      difference{               
       intersection{    
             intersection{
                box{<0,0,-.1>,<-.1,.2,8>}
                plane{-x,0 rotate z*-20 translate <-.01,.15,0>} 
                plane{z,0 inverse rotate x*20 translate <0,.15,-.01>}
                texture{TexCasaMad1 rotate y*90 translate <60*rand(SD),60*rand(SD),0>}
                texture{TexCasaPintura rotate y*90 translate <60*rand(SD),60*rand(SD),0>}
                texture{TexGrad rotate y*90}
                Rotate_Around_Trans(<rand(SD)*.25-.125,rand(SD)*.25-.125,rand(SD)*.25-.125>,<0,.1,0>)//(<rand(SD)*.5-.25,rand(SD)*.5-.25,rand(SD)*.5-.25>,<0,.1,3.95>)
                translate y*i 
                texture{TexSucioGrad}
                }          
             plane{z,0 inverse rotate x*60 translate <0,7,4>}
             plane{z,0 rotate x*-60 translate <0,7,4>}
                          }
       box{<-.2,.01,-.64>,<.1,1.09,.64> translate <0,4.8,4>}
       
       cutaway_textures
        }
#local i=i+.16;
#end
box{<.3,-.5,-1>,<.31,1.5,1> pigment {Black} finish{ambient 1} translate <0,4.8,4>}        
          
//Ventana
union{
      object{Round_Box_Union(<0,0,-.65>,<-.1,.1,.65>,.01)texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50>}} //marco
      object{Round_Box_Union(<0,1.09,-.65>,<-.1,1.2,.65>,.01)texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50>}}
      object{Round_Box_Union(<0,.09,-.6>,<-.1,1.11,-.5>,.01)texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate x*92}}
      object{Round_Box_Union(<0,.09,.6>,<-.1,1.11,.5>,.01)texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate x*93}}
      
      union{
        union{
        Round_Box_Union(<-.01,-.98,-.49>,<.03,0,-.44>,.007)
        Round_Box_Union(<-.01,-.98,.49>,<.03,0,.44>,.007)
        Round_Box_Union(<-.01,-.98,-.025>,<.03,0,.025>,.007)
        texture{TexVentana  translate <0,rand(SD)*50,rand(SD)*50> rotate x*91}}
        Round_Box_Union(<-.01,-.98,-.49>,<.03,-.93,.49>,.007)
        Round_Box_Union(<-.01,-.05,-.49>,<.03,0,.49>,.007)
        Round_Box_Union(<-.01,-.45,-.49>,<.03,-.5,.49>,.007)
        //vidrio
        box{<0,.01,.48>,<.02,-.97,-.48>
                texture{TexVidrio scale 1.45 translate <0,-.48,0>}
              }
        texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50>}
        rotate z*-20 translate y*1.09}
  //traba 
  object{Round_Box_Union(<-.01,0,-.02>,<.01,.38,.02>,.005) texture{TexCasaMad1 rotate z*90}rotate z*60}
  translate <.025,4.8,4>
  }
 

  
                        
                     
                     
//Parte Chica  ***************************************************************
                   
#declare xWall=5;             // wall length in x
#declare yWall=1;              // wall height in y
#include "wall\makewall.pov"
object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
       scale <1,1,1> translate <-5,-1,1.95>}
        
intersection{
        difference{
                box{<0,0,0>,<5,4.3,6>}
                box{<.1,.1,.1>,<4.9,4.2,5.9>}
                box{<.8,.81,.2>,<1.7,2,-.2> translate y*.1}
                box{<.8,.81,.2>,<1.7,2,-.2> translate <2.4,.1,0>}
                box{<.2,.81,.8>,<-.2,2,1.7> translate y*.1}
                }
        plane{z,0 inverse rotate x*60 translate <0,4.3,3> pigment {Brown}}
        plane{z,0 rotate x*-60 translate <0,4.3,3> pigment {Brown}}
        pigment{Grey}
        translate <-5,0,1>}                
      #include "puerta.inc"
      object{puerta rotate y*90 translate <4.85,0,1.5> translate <-5,0,1.7>} 

//Techo
                     
#declare Techo2=union{
                        box{<-.5,4.2,2.9>,<5.5,4.4,3.1> texture {TexTechoMad1}translate <-5,0,1>}

                        box{<-.05,0,-.05>,<.05,-3.8,.05> texture {TexTechoMad1 rotate <90,0,90>}rotate x*60 translate <-5.3,4.3,4>}
                        box{<-.05,0,-.05>,<.05,-3.8,.05> texture {TexTechoMad1 rotate <90,0,90>}rotate x*-60 translate <-5.3,4.3,4>}
                        #local i=.3;
                        #while (i<5)
                                box{<-.05,0,-.05>,<.05,-3.8,.05> texture {TexTechoMad1 rotate <90,0,90>} rotate x*60 translate <i-5,4.3,4>}
                        #local i=i+5/5;
                        #end

                        object{techo(30,5.4,3.8,.4,.3,CalidadTecho) rotate y*270 translate <0.0,4.38,4>}
                        object{techo(30,5.4,3.8,.4,.3,CalidadTecho) rotate y*90 translate <-5.4,4.38,4>}
                        }//Fin Techo2  
        
#if (Bend)                        
// BEND OPTIONS
   #declare object_axis1 = <-5.5, 4.2, 4>;
   #declare object_axis2 = <.5,4.2,4>;
   #declare bend_angle = 3;
   #declare bend_direction=y;
   #declare bend_smoothness = 20;
   #declare bend_start=.3;
   #declare bend_finish=.7;
   
   object{#declare bend_object=object{Techo2} #include "bend\bend.inc"}
#else
   object{Techo2}
#end                        
                  
//PAredes
      
#local i=0;     
#while (i<2.5)
difference{
        intersection{
                     box{<0,0,0>,<5,.2,-.1>}

             plane{z,0 inverse rotate x*20 translate <0,.15,-.01>}
             texture{TexCasaMad1 translate <60*rand(SD),60*rand(SD),0>}
             texture{TexCasaPintura translate <60*rand(SD),60*rand(SD),0>}
             texture{TexGrad}
             Rotate_Around_Trans(<rand(SD)*.5-.25,rand(SD)*.5-.25,rand(SD)*.5-.25>,<2.5,.1,0>)
             translate <-5,i,1>
             texture{TexSucioGrad}
             }  
        box{<.8,.81,.2>,<1.8,2,-.2> translate <-5,.1,1>}
        box{<.8,.81,.2>,<1.8,2,-.2> translate <-2.6,.1,1>}
        cutaway_textures
        }
#local i=i+.16;
#end
          
//ventanas
//VENTANA 1
//marco
object{Round_Box_Union(<.75,.8,.1>,<1.75,.85,-.15>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate y*90} translate <-5,.1,1>}
object{Round_Box_Union(<.75,1.97,.1>,<1.75,2.03,-.1>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate y*90} translate <-5,.1,1>}       

difference{
        object{Round_Box_Union(<1.67,.84,.1>,<1.72,1.98,-.1>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate <90,90,0>}}
                box{<1.66,.85,-.015>,<1.69,1.97,-.035>}
                box{<1.66,.85,.015>,<1.69,1.97,.035>}
                translate <-5,.1,1> cutaway_textures
                }
difference{
        object{Round_Box_Union(<.78,.84,.1>,<.83,1.98,-.1>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate <90,90,0>}}
                box{<.77,.85,-.015>,<.8,1.97,-.035>}
                box{<.77,.85,.015>,<.8,1.97,.035>}  
                translate <-5,.1,1>cutaway_textures
                }
//parte baja
union{
        union{
                box{<.83,.85+.54,0>,<1.67,.85+.58,-.05>}//h
                box{<.83,.85,0>,<1.67,.89,-.05>}//h
                box{<.87,.85+.25,-.01>,<1.63,.85+.29,-.04>}
                texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate y*90}
                }
        union{
                box{<.83,.89,0>,<.87,.85+.54,-.05>}//v
                box{<1.63,.89,0>,<1.67,.85+.54,-.05>}//v
                box{<.83+.4,.89,-.01>,<.83+.44,.85+.54,-.04>}
                texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate <90,90,0>}
                }
        //vidrio
        box{<.83,.87,-.02>,<1.67,.85+.56,-.03>
                texture{TexVidrio rotate y*90 translate <1.25,1.14,5>}
              }
        translate <-5,.1,1> translate y*0
        }
//parte alta
union{
        union{
                box{<.83,.85+.54,0>,<1.67,.85+.58,.05>}
                box{<.83,1.93,0>,<1.67,1.97,.05>} 
                box{<.87,.85+.56+.25,.01>,<1.63,.85+.56+.29,.04>}
                texture{TexVentana  translate <0,rand(SD)*50,rand(SD)*50>rotate y*90}
                }
        union{
                box{<.83,.85+.58,0>,<.87,1.93,.05>}
                box{<1.63,.85+.58,0>,<1.67,1.93,.05>}
                box{<.83+.4,.85+.56,.01>,<.83+.44,1.93,.04>}
                texture{TexVentana  translate <0,rand(SD)*50,rand(SD)*50>rotate <90,90,0>}  
                }      
        //vidrio
        box{<.83,.85+.56,.02>,<1.67,1.95,.03> 
                texture{TexVidrio rotate y*90 translate <1.25,1.14+.54,20>}
                }
        translate <-5,.1,1> translate y*0
        }

//VENTANA 2
//marco
object{Round_Box_Union(<.75,.8,.1>,<1.75,.85,-.15>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate y*90} translate <-2.6,.1,1>}
object{Round_Box_Union(<.75,1.97,.1>,<1.75,2.03,-.1>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate y*90} translate <-2.6,.1,1>}       

difference{
        object{Round_Box_Union(<1.67,.84,.1>,<1.72,1.98,-.1>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate <90,90,0>}}
                box{<1.66,.85,-.015>,<1.69,1.97,-.035>}
                box{<1.66,.85,.015>,<1.69,1.97,.035>}
                translate <-2.6,.1,1> cutaway_textures
                }
difference{
        object{Round_Box_Union(<.78,.84,.1>,<.83,1.98,-.1>,.01)  texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate <90,90,0>}}
                box{<.77,.85,-.015>,<.8,1.97,-.035>}
                box{<.77,.85,.015>,<.8,1.97,.035>}  
                translate <-2.6,.1,1>cutaway_textures
                }
//parte baja
union{
        union{
                box{<.83,.85+.54,0>,<1.67,.85+.58,-.05>}//h
                box{<.83,.85,0>,<1.67,.89,-.05>}//h
                box{<.87,.85+.25,-.01>,<1.63,.85+.29,-.04>}
                texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate y*90}
                }
        union{
                box{<.83,.89,0>,<.87,.85+.54,-.05>}//v
                box{<1.63,.89,0>,<1.67,.85+.54,-.05>}//v
                box{<.83+.4,.89,-.01>,<.83+.44,.85+.54,-.04>}
                texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate <90,90,0>}
                }
        //vidrio
        box{<.83,.87,-.02>,<1.67,.85+.56,-.03>
                texture{TexVidrio rotate y*90 translate <1.25,1.14,8>}
                      }
        translate <-2.6,.1,1> translate y*0
        }
//parte alta
union{
        union{
                box{<.83,.85+.54,0>,<1.67,.85+.58,.05>}
                box{<.83,1.93,0>,<1.67,1.97,.05>} 
                box{<.87,.85+.56+.25,.01>,<1.63,.85+.56+.29,.04>}
                texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate y*90}
                }
        union{
                box{<.83,.85+.58,0>,<.87,1.93,.05>}
                box{<1.63,.85+.58,0>,<1.67,1.93,.05>}
                box{<.83+.4,.85+.56,.01>,<.83+.44,1.93,.04>} 
                texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate <90,90,0>}  
                }      
        //vidrio
        box{<.83,.85+.56,.02>,<1.67,1.95,.03>
                texture{TexVidrio rotate y*90 translate <1.25,1.14+.54,42>}
                }
        translate <-2.6,.1,1> translate y*0
        }

               
#local i=0;
#while (i<4.3)
       difference{
        intersection{    
             intersection{
                box{<0,0,-.1>,<-.1,.2,6>}
                plane{-x,0 rotate z*-20 translate <-.01,.15,0>}
                plane{z,0 inverse rotate x*20 translate <0,.15,-.01>}
                texture{TexCasaMad1 rotate y*90 translate <60*rand(SD),60*rand(SD),0>}
                texture{TexCasaPintura rotate y*90 translate <60*rand(SD),60*rand(SD),0>}
                texture{TexGrad rotate y*90}
                Rotate_Around_Trans(<rand(SD)*.5-.25,rand(SD)*.5-.25,rand(SD)*.5-.25>,<0,.1,2.95>)
                translate <-5,i,1>
                texture{TexSucioGrad}
                }          
             plane{z,0 inverse rotate x*60 translate <-5,4.3,4>}
             plane{z,0 rotate x*-60 translate <-5,4.3,4>}
             //pigment {Grey}
             }
       box{<.1,.81,.81>,<-.2,2,1.7> translate <-5,.1,1>}
       cutaway_textures}
#local i=i+.16;
#end 


//marco
object{Round_Box_Union(<.1,.8,.75>,<-.15,.85,1.75>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50>} translate <-5,.1,1>}
object{Round_Box_Union(<.1,1.97,.75>,<-.1,2.03,1.75>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50>} translate <-5,.1,1>}       

difference{
        object{Round_Box_Union(<.1,.84,1.67>,<-.1,1.98,1.72>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate x*90}}
                box{<-.015,.85,1.66>,<-.035,1.97,1.69>}
                box{<.015,.85,1.66>,<.035,1.97,1.69>}
                translate <-5,.1,1> cutaway_textures
                }
difference{
        object{Round_Box_Union(<.1,.84,.78>,<-.1,1.98,.83>,.01) texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate x*90}}
                box{<-.015,.85,.77>,<-.035,1.97,.8>}
                box{<.015,.85,.77>,<.035,1.97,.8>}  
                translate <-5,.1,1>cutaway_textures
                }
//parte baja
union{
        union{
                box{<0,.85+.54,.83>,<-.05,.85+.58,1.67>}//h
                box{<0,.85,.83>,<-.05,.89,1.67>}//h
                box{<-.01,.85+.25,.87>,<-.04,.85+.29,1.63>}
                texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50>}
                }
        union{
                box{<0,.89,.83>,<-.05,.85+.54,.87>}//v
                box{<0,.89,1.63>,<-.05,.85+.54,1.67>}//v
                box{<-.01,.89,.83+.4>,<-.04,.85+.54,.83+.44>}
                texture{TexVentana translate <0,rand(SD)*50,rand(SD)*50> rotate x*90}
                }
        //vidrio
        box{<-.02,.87,.83>,<-.03,.85+.56,1.67>
        texture{TexVidrio translate <14,1.14,1.25>}
              }
        translate <-5,.1,1> translate y*0
        }
//parte alta
union{
        union{
                box{<0,.85+.54,.83>,<.05,.85+.58,1.67>}
                box{<0,1.93,.83>,<.05,1.97,1.67>} 
                box{<.01,.85+.56+.25,.87>,<.04,.85+.56+.29,1.63>}
                texture{TexVentana  translate <0,rand(SD)*50,rand(SD)*50>}
                }
        union{
                box{<0,.85+.58,.83>,<.05,1.93,.87>}
                box{<0,.85+.58,1.63>,<.05,1.93,1.67>}
                box{<.01,.85+.56,.83+.4>,<.04,1.93,.83+.44>}
                texture{TexVentana  translate <0,rand(SD)*50,rand(SD)*50>rotate x*90}  
                }      
        //vidrio
        box{<.02,.85+.56,.83>,<.03,1.95,1.67>
                texture{TexVidrio translate <5,1.14+.54,1.25>}
                }
        translate <-5,.1,1> translate y*0
        }

#include "cobertizo.pov"        
