// Persistence of Vision Ray Tracer Scene Description File
// File: cascada.pov - Waterfall -
// Vers: 3.5
// Desc: Jan-Feb 2003 IRTC Entry - Topic "Old Technologies" (a Water Mill)
// Date: Start - 11Ene03
// Auth: J. F. Tuduri
//
              /*
#version 3.5;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0 max_trace_level 60
}

// ----------------------------------------
camera {
  
  direction 1.5*z
  right     x*image_width/image_height
  //location  <-1.0, 2, -5.0> look_at   <0.0, 1.7,  -1.0>
  location  <-5.0, 4, -2.0> look_at   <1.0, 3.84,  .5>
  //location  <-5.0, 2, -4.0> look_at   <0.0, 2.0,  0.0>
}


light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}
    
// ----------------------------------------

plane {
  y, 0
  pigment { color rgb <0.7,0.5,0.3> }
} 
       
box{<1,1,0>,<4,1.1,.5> pigment {Red}}  */
           /*
#local Yo=1.1;
#local Xo=1;
#local Vyo=0;
#local Vxo=-1.2;
#local Yf=0;
#local Radio=.01;
#local Var=12;

#local StepZ=.008;
#local Zi=0;
#local Zf=.5;

#local SD=seed(3342);
#local g=9.8;

#local Step=.005;
#local To=0;
#local Tf=.5;
 
#local T=To; */
/*#local Yo=3.84;
#local Xo=1;
#local Vyo=0;
#local Vxo=-1.2;
#local Yf=3;
#local Radio=.2;
#local Var=12;

#local StepZ=.01;
#local Zi=-.4;
#local Zf=.4;

#local To=0;
#local Tf=.5;
#local Step=.005;  
      */
#macro AguaCae(Yo,Xo,Vyo,Vxo,Radio,To,Tf,Step,Zi,Zf,StepZ,Var)
#local T=To;
#local SD=seed(3342);
#local g=9.8;
union{
#while(T<Tf)
      #local X=Xo+Vxo*T;
      #local Y=Yo+Vyo*T-.5*g*(T*T);
      
      
      #local Z=Zi;
      #while(Z<Zf)
        sphere{<0,0,0>,Radio 
                texture{pigment{marble turbulence .3 rotate z*90 scale .005
                                color_map {
                                           [0 rgb <.8,.8,1>]
                                           [.6 rgb <.8,.8,1>*1.4]
                                           [1 rgb <1,1,1>*2]
                                           }
                                 }
                        finish {phong .7 phong_size 50 reflection .7}
                        } 
                #if (Vyo-g*T!=0) scale <(Vyo-g*T)*1.5,1,1> #end
                #if (Vxo=0) rotate z*90 
                #else rotate z*degrees(atan((Vyo-g*T)/Vxo)) 
                #end
                translate <X+rand(SD)*Var*Radio,Y+rand(SD)*Var*Radio,Z+rand(SD)*Var*Radio>
                }
        #local Z=Z+StepZ;
      #end
      #declare T=T+Step;
#end  
      }
#end//end macro      

