// Persistence of Vision Ray Tracer Scene Description File
// File: cerco.pov - Fence -
// Vers: 3.5
// Desc: Jan-Feb 2003 IRTC Entry - Topic "Old Technologies" (a Water Mill)
// Date: Start - 11Ene03
// Auth: J. F. Tuduri
//

#version 3.5;

#include "colors.inc"
              /*
global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <-2, 1.6, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, .5,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, 0
  pigment { color rgb <0.7,0.5,0.3> }
}      */
            
#local Tex_Cerco1=texture{pigment {wood
                                   rotate y*90
                                   turbulence .2
                                   scale <.7,.06,.1>
                                   color_map{
                                             [0 rgb <.8,.7,.5>]
                                             [.3 rgb <.85,.65,.5>]
                                             [.6 rgb <.2,.15,.15>]
                                             [1 rgb <.88,.7,.45>]
                                             }
                                   }
                           normal {wood .1 rotate y*90 turbulence .2 scale <.7,.06,.1>}
                          }
  
#declare Cerco=union{
#local SD2=seed(455);
cylinder{<0,0,0>,<0,1.2,0>,.08 rotate z*(rand(SD2)*10-5)translate x*-2 texture{Tex_Cerco1}}
cylinder{<0,0,0>,<0,1.2,0>,.08 rotate z*(rand(SD2)*10-5) texture{Tex_Cerco1 rotate z*90}}
cylinder{<0,0,0>,<0,1.2,0>,.08 rotate z*(rand(SD2)*10-5)translate x*2 texture{Tex_Cerco1 rotate z*90}}
cylinder{<0,0,0>,<0,1.2,0>,.08 rotate z*(rand(SD2)*10-5)translate x*4 texture{Tex_Cerco1 rotate z*90}}

box{<-1,-.1,-.08>,<1,.1,-.1> rotate x*(rand(SD2)*30-15) translate <-1,1,0> texture{Tex_Cerco1}}
box{<-1,-.1,-.08>,<1,.1,-.1> rotate x*(rand(SD2)*30-15) translate <-1,.6,0> texture{Tex_Cerco1}}
box{<-1,-.1,-.08>,<1,.1,-.1> rotate x*(rand(SD2)*30-15) translate <-1,.25,0> texture{Tex_Cerco1}}

box{<-1,-.1,-.08>,<1,.1,-.1> rotate x*(rand(SD2)*30-15) translate <1,1,0> texture{Tex_Cerco1}}
box{<-1,-.1,-.08>,<1,.1,-.1> rotate x*(rand(SD2)*30-15) translate <1,.6,0> texture{Tex_Cerco1}}
box{<-1,-.1,-.08>,<1,.1,-.1> rotate x*(rand(SD2)*30-15) translate <1,.25,0> texture{Tex_Cerco1}}

box{<-1,-.1,-.08>,<1,.1,-.1> rotate x*(rand(SD2)*30-15) translate <3,1,0> texture{Tex_Cerco1}}
box{<-1,-.1,-.08>,<1,.1,-.1> rotate x*(rand(SD2)*30-15) translate <3,.6,0> texture{Tex_Cerco1}}
box{<-1,-.1,-.08>,<1,.1,-.1> rotate x*(rand(SD2)*30-15) translate <3,.25,0> texture{Tex_Cerco1}}

} 

//object{Cerco}