// Persistence of Vision Ray Tracer Scene Description File
// File: techo.pov - macro for the roof
// Vers: 3.5
// Desc: Jan-Feb 2003 IRTC Entry - Topic "Old Technologies" (a Water Mill)
// Date: Start - 11Ene03
// Auth: J. F. Tuduri
//
     
#version 3.5;

#include "colors.inc"


// ----------------------------------------
                    
// *********************** Macro de techo *************************                         
#macro techo (angulo,ancho,hipot,ancpieza,larpieza,cal)
 
 #local SD2=seed(356);
 #if(cal=0)
      box{<0,-.04,0>,<-hipot,.001,ancho> rotate z*angulo pigment{Orange}}
 #else
 
 #declare ColorBase=<.4,.1,0.07>*1.5;
 #declare VarR=.15;
 #declare VarG=.03;
 #declare VarB=0;
 #declare radang=radians(angulo);
       union{box{<0,-.04,0>,<-hipot,0,ancho> rotate z*angulo 
             texture{pigment {wood turbulence .1 scale <.1,.1,.9>*.15  rotate y*90
                                      color_map{
                                               [0 rgb <.9,.75,.43>] //
                                               [.3 rgb <.5,.35,.13>]//
                                               [1 rgb <.45,.2,.13>]}
                                      translate <rand(SD2)*100,rand(SD2)*100,rand(SD2)*100>}
                     normal {wood turbulence .1 scale <.1,.1,.5*.15> rotate y*90}
                             } 
            }//box
 /*cylinder {<0,0,0>,<-hipot,0,0>,.01 pigment {Green} rotate z*(angulo)}
 cylinder {<0,0,ancho>,<-hipot,0,ancho>,.013 pigment {Green} rotate z*(angulo)}
 cylinder {<0,0,0>,<0,0,ancho>,.01 pigment {Green}}
 cylinder {<0,0,0>,<0,0,ancho>,.01 pigment {Green} translate <-cos(radang)*hipot,-sin(radang)*hipot,0>}*/
 
 #local X=0;
 #while(X<(cos(radang)*hipot))
        #local Z=-(rand(SD2)*.25)*ancpieza;
        #local lar=larpieza*(rand(SD2)*.6+.7);
        
        #if(X+lar*cos(radang)>(cos(radang)*hipot))
                #local lar=(cos(radang)*hipot)-X+(rand(SD2)*.025)*larpieza;
        #end
        
        #while(Z<ancho)
                #local anc=ancpieza*(rand(SD2)*.7+.6);
                #if(Z+anc>ancho)
                        #local anc=ancho-Z+(rand(SD2)*.25)*ancpieza;
                #end
                 box{<0,0,0>,<-lar-rand(SD2)*.5*larpieza,.001,anc>
                     texture{pigment {wood turbulence .1 scale <.1,.1,.5>*.15  rotate y*90
                                      color_map{
                                               [0 rgb <.9,.75,.43>] //
                                               [.3 rgb <.5,.35,.13>]//
                                               [1 rgb <.45,.2,.13>]}//
                                      translate <rand(SD2)*100,rand(SD2)*100,rand(SD2)*100>}
                                      normal {wood turbulence .1 scale <.1,.1,.5*.15> rotate y*90}
                             rotate y*(rand(SD2)*2-1)
                             }// 
                     texture{pigment{gradient z scale anc
                                     color_map{[0 rgbt 1]
                                               [.25 rgbt <.5,.5,.5,.9>]
                                               [.5 rgbt <.4,.4,.4,.7>]
                                               [.75 rgbt <.5,.5,.5,.9>]
                                               [1 rgbt 1]}
                                    }
                            }// 
                     rotate <rand(SD2)*3-1.5,rand(SD2)*3-1.5,angulo-rand(SD2)*3.5> 
                     translate <-X,-tan(radang)*X,Z>
                    }  //box
                #local Z=Z+anc;
        #end
        #local X=X+lar*cos(radang);
 
 #end
 }
  #end 
#end//fin macro techo
