#include "units.inc"
#include "colors.inc"
#include "materials.inc" 
#include "rand.inc"  

//+h900 +w2000 +a0.3 +j
//+h675 +w1500
//+h450 +w1000
//+h338 +w750 
//+h225 +w500 
#local calculate_trees = true;
#local draw_trees = true; 
#local N = 40; //number of trees    //around 30?  //50 is not a problem in terms of mem or trace time.
#local draw_leaves = true; 
#local draw_fish = true;
#local draw_butterfly = false; 
#declare full_iso_rocks = true; 
#local draw_fog = false;
#local Fname = "tree_pos.inc"  
#declare RS = seed(3);
//#####################################################################
// perspective (default) camera
camera {
  location  <0.0, 2.0*m, 0>
  look_at   <0.0, 0.0,  100*m>
  right     x*image_width/image_height
} 
//#####################################################################
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 40, -20>*m  
  shadowless
} 
//#####################################################################
//sky (temporary) 
/*
background{SummerSky}
#include "skies.inc"
sky_sphere{S_Cloud5 } 
      */
//plane{z,100*m pigment{checker pigment{Black},pigment{White} scale 10*m }}    
sphere{<0,0,0> 150*m pigment{image_map{sys "ter_sky" map_type 1 interpolate 2 once} rotate 100*y rotate 1*x} hollow scale <1.5,1.5,1>} 


//#####################################################################
//water plane
plane{
    y, 0 
	material {Water_CH}
	//pigment{Yellow}
} 
plane {y,0 translate -1*m*y pigment {Bronze} } 

//##################################################################### 
//height field for "island" in distance
#local fn = function{pattern{granite scale <2,1,1>}}
height_field{
    function 200,200 {fn(x,y,0)}
    //smooth 
    translate <-0.5,-0.5,0>
    
    scale <250,15,10>*m 
    translate 100*m*z  
    pigment{
        agate 
        pigment_map{
            [0 DarkGreen] 
            [1 MidnightBlue]             
        } 
        scale <1/100,1,1>
        turbulence 0.25 
    }
    //translate -2.5*m*y
}
//##################################################################### 
#if(calculate_trees)
    //#include "trees.inc" 
    #include "tree_extents.inc"
    
    #local Min_Tree_Height = 10*m;
    #local Max_Tree_Height = 20*m; 
    
    #local Min_Tree_Dev = 1*m;
    #local Max_Tree_Dev = 5*m;
    
    #local Max_X = 125*m; 
      
    #fopen FILE Fname write
    #local i=0;
    #while(i<N)
        //select which tree
            #local Choose = rand(RS);
            #if(Choose > 0.0 & Choose <= 1/5) #local String = "Tree1"; #local MIN = T6_MIN; #local MAX = T6_MAX; #end
            #if(Choose > 1/5 & Choose <= 2/5) #local String = "Tree2"; #local MIN = T6_MIN; #local MAX = T6_MAX; #end 
            #if(Choose > 2/5 & Choose <= 3/5) #local String = "Tree3"; #local MIN = T7_MIN; #local MAX = T7_MAX; #end
            #if(Choose > 3/5 & Choose <= 3/5) #local String = "Tree6"; #local MIN = T7_MIN; #local MAX = T7_MAX; #end
            #if(Choose > 4/5 & Choose <= 5/5) #local String = "Tree7"; #local MIN = T7_MIN; #local MAX = T7_MAX; #end 
        //select location of tree on x-axis   
        #local X = (2*Max_X/N)*i - (rand(RS)*(Max_Tree_Dev-Min_Tree_Dev) + Min_Tree_Dev) - Max_X; 
        //select height of tree
        #local Height = rand(RS)*(Max_Tree_Height-Min_Tree_Height) + Min_Tree_Height;   
        //place tree 
        #write(FILE, "object{",String," scale ",Height/(MAX.y-MIN.y)," rotate ",rand(RS)*360*y,"translate ",-1/4*Height,"*y translate 110*m*z translate ",X/m,"*m*x} //",Choose,"\n") 
        #local i=i+1;
    #end  
    #fclose FILE 
#end //if(calc_trees)

#if(draw_trees)
    #if(N>0) #include "trees.inc" #end
    #include Fname  
#end

//#####################################################################
#if(draw_fog)
    fog{
        fog_type 2
        distance 75*m
        fog_offset 10*m
        fog_alt 2
        colour Silver//MidnightBlue
        turbulence 0.25
    } 
#end      
//#####################################################################
#include "rock_macro.inc"
#local i=0;
#local N=8;//8
#while(i<N) 
    #local obj = ROCK() 
    //#local obj = sphere{<0,0,0> 1.6 material{Rock_Mat} } //spheres for testing
    object{obj 
        scale 1/1.6 
        texture{Rock_Mat rotate rand(RS)*360 scale <1,0.5,1>*5}
        texture{Gunk_Mat}
        scale <50*cm+SRand(RS)*10*cm,2*m+SRand(RS)*25*cm,50*cm+SRand(RS)*10*cm> 
        translate 5*m*z
        rotate -9*y   //rotates to give nice view of stone circle
        rotate 360/N*i*y 
        translate 10*m*z
        translate -2.5*m*x 
     }
    #local i=i+1;
#end  
//#####################################################################
//leaves n stuff on surface of water
#if(draw_leaves)
    #local N = 500;
    #local Max_Angle = 45;    
    #local Max_Z = 25*m;
    #local Leaf_Obj = sphere{<0,0,0> 1*cm scale <2*cm,5*mm,3*cm> pigment{DarkBrown}}
    
    #local i=0;
    #while(i<N)
        object{Leaf_Obj rotate rand(RS)*360*y translate rand(RS)*Max_Z*z rotate SRand(RS)*Max_Angle*y }
        #local i=i+1;
    #end
#end//endif    
//##################################################################### 
#if(draw_butterfly)
    #include "butterfly/buterfly.pov"
    object{butterfly translate <1.75*m,1.25*m,6.6*m>}
#end    

//#####################################################################
#if(draw_fish)
    #include "brown_trout/browntrout0.pov"
    object{Fish rotate 45*y translate -10*cm*y translate 5*m*z} 
    object{Fish rotate -45*y translate -10*cm*y translate 5.5*m*z translate 25*cm*x}
#end