

#declare TYRE_TEX = texture{
 pigment{
  bozo
  color_map{
   [0   Black]
   [0.2 Gray30]
   [0.4 Gray20]
   [0.6 Gray30]
   [0.9 Gray20]
  }
  turbulence 0.7
  scale 0.09
 }
 finish{
  ambient 0.1
  diffuse 0.6
  roughness 0.6
  specular 0.1
  crand 0.1
 }
 normal{ wood 1 scale 0.001}
}

// *********************************************************************************
// ****************** EXHAUST ******************************************************
// *********************************************************************************

#declare EXHAUST = object{
 union{
  cone{<0,5.7,0>, 0.225, <0,7.0,0>, 0.2}
  cone{<0,5.7,0>, 0.225, <0,5.4,0>, 0.4}
  cylinder {<0,5.4,0>,<0,5.3,0>,0.4}
  cone {<0,5.3,0>,0.35,<0,4.8,0>,0.2}
  cylinder {<0,4.8,0>,<0,4.7,0>,0.2}
  cylinder {<0,4.7,0>,<0,3.5,0>,0.175}
  cylinder {<0,3.8,0>,<0,3.5,0>,0.185}
  cylinder {<0,3.7,0>,<0,3.6,0>,0.19 }
  sphere_sweep {
   cubic_spline
   5,
    <0,4.0,0>,0.17,
    <0,3.5,0>,0.17,
    <0,3.0,0.1>,0.17,
    <-0.4,2.6,0.4>,0.35,
    <-1.4,2.6,0.4>,0.35
  }
  superellipsoid { <0.2, 0.2> scale <0.2,0.5,0.4> translate <-0.6,2.5,0.4> }
 }
} 

// *********************************************************************************
// ****************** BIG WHEEL ****************************************************
// *********************************************************************************

#declare BIG_WHEEL = object{
 union{
  union{
   difference {
    cylinder{<0,0,0,>,<0.3,0.0>,0.75}
    cylinder{<0.4,0,0>,<0.2,0,0>,0.075 translate <0,0.4,0> rotate <30,0,0>}
    cylinder{<0.4,0,0>,<0.2,0,0>,0.075 translate <0,0.4,0> rotate <150,0,0>}
    cylinder{<0.4,0,0>,<0.2,0,0>,0.075 translate <0,0.4,0> rotate <270,0,0>}
   }
   cylinder{<0,0,0>,<0.2,0,0>,0.85}
   torus{0.75,0.1 rotate <0,0,90> translate <0.2,0,0>}
   difference {
    cylinder{<0.4,0,0>,<0.3,0,0>,0.6}
    cylinder{<0.45,0.0>,<0.25,0,0>,0.55}
   }
   cylinder{<-0.1,0,0>,<0,0,0>,1.05}
   difference{
    cylinder{<0,0,0>,<0.1,0,0>,1.05}
    cylinder{<0.2,0,0>,<-0.1,0,0>,0.95}
   }
   torus {1.05,0.1 rotate <0,0,90> translate <0.2,0,0>}
   difference{
    cylinder{<0.3,0,0>,<0.4,0,0>,1.15}
    cylinder{<0.2,0,0>,<0.5,0,0>,1.05}
   }
   difference{
    cylinder{<0.4,0,0>,<0.45,0,0>,1.2}
    cylinder{<0.35,0,0>,<0.5,0,0>,1.15}
   }
  } 
// ---------------- wheel itself ---------------------------------------------------  
  union{ 
   torus{1.7,0.5 scale <1,0.3,1> rotate <0,0,90> translate <0.4,0,0> }
   difference{
    cylinder{<0.4,0,0>,<-0.6,0,0>,2.2 }
    cylinder{<0.5,0,0>,<-0.7,0,0>,1.15}
   }
   difference{
    cylinder{<0.65,0,0>,<0,0,0>,1.7}
    cylinder{<0.7,0,0>,<-0.1,0,0>,1.55}
   }
   torus{1.7,0.5 scale <1,0.3,1> rotate <0,0,90> translate <-0.6,0,0> }
   intersection{
    union{
     #declare i = 0;
     #while (i<20)
      box{<0.3+sqrt(2)*0.3,0,-0.05>,<0.3-sqrt(2)*0.3,0.5,0.1> 
       rotate y*45
       translate <0,1.8,0> 
       rotate <18*i,0,0>
      }
      box{<-0.5+sqrt(2)*0.3,0,-0.05>,<-0.5-sqrt(2)*0.3,0.5,0.1> 
       rotate -y*45
       translate <0,1.8,0> 
       rotate <18*i+12,0,0>
      }
     #declare i=i+1;
    #end 
    }
    torus{1.3,1.1 rotate <0,0,90> translate -0.1*x }
   }
   texture {TYRE_TEX}
  }
 }
} 

// *********************************************************************************
// ****************** SMALL_WHEEL **************************************************
// *********************************************************************************

#declare SMALL_WHEEL = object{
 union{
//----------------------------------------- wheel 
  difference{
   cylinder{<0,0,0>,<-0.4,0,0>,0.95}
   cylinder{<0.1,0,0>,<-0.5,0,0>,0.7}
   torus{0.8,0.05 rotate z*90}
  }
  difference{
   #declare a = atan2(2,1);
   #declare b = atan2(1,2);
   #declare c = (a-b)/2;
   #declare R = (0.1/cos(c));
   #declare d = R * sin(c);
   #declare DeltaX = R*sin(b+c);
   #declare DeltaY = R*cos(b+c);
   union{
    torus {0.6-DeltaX, 0.1 rotate z*90}
    cone {<-0.1,0,0>,0.7,<0.1-d/sin(a),0,0>,0.6 }
    cone {<0.1+d*sin(b),0,0>,0.6,<0.2,0,0>,0.4 }
    torus {0.3,0.05 rotate z*90 translate <0.2,0,0>}
    cylinder {<0.2,0,0>,<0.25,0,0>,0.3}
   }
   cone {<-0.2,0,0>,0.7,<0.0,0,0>,0.6}
   cone {<0,0,0>,0.6,<0.1,0,0>,0.4}
   difference{
    cylinder {<0.5,0,0>,<-0.5,0,0>,0.1}
    torus {0.1,0.05 rotate z*90 translate <0.2,0,0>}
   } 
   cylinder {<0.5,0.7,0>,<-0.5,0.7,0>,0.2}
   cylinder {<0.5,0.7,0>,<-0.5,0.7,0>,0.2 rotate x*90}
   cylinder {<0.5,0.7,0>,<-0.5,0.7,0>,0.2 rotate x*180}
   cylinder {<0.5,0.7,0>,<-0.5,0.7,0>,0.2 rotate x*270}
  }
  cylinder{<-0.2,0,0>,<-0.8,0,0>,0.15}
 // ------------------------------------------- tyre
  union{
   torus {1.2,0.3 rotate z*90 scale <0.2,1,1> texture{TYRE_TEX}}
   torus {1.2,0.3 rotate z*90 scale <0.2,1,1> translate <-0.4,0,0>texture{TYRE_TEX}}
   difference{
    cylinder {<-0.4,0,0>,<0,0,0>,1.5}
    cylinder {<-0.5,0,0>,<0.1,0,0>,0.9}
    texture{TYRE_TEX}
   }
  }
 }
}

// *********************************************************************************
// ****************** GEAR BOX *************************************************
// *********************************************************************************
                                   
#declare GEAR_BOX = object{
 union{
  cylinder {<0,0,0>,<-3,0,0>,0.9}
  cylinder {<-0.1,0,0>,<-2.9,0,0>,1.0}
  torus{0.9,0.1 rotate z*90 translate <-0.1,0,0>}
  torus{0.9,0.1 rotate z*90 translate <-2.9,0,0>}
  cone {<0,0,0>,0.375,<0.15,0,0>,0.15}
  difference{
   cylinder {<-0.3,0,0>,<0,0,0>,1.0 scale <1,0.9,2.25>}
   cylinder {<-0.4,0,0>,<0.1,0,0>,1.0 scale <1,0.6,1.85>}
   box {<-0.4,-1.5,0>,<0.1,1.5,-2.3> }
   translate <-2.4,0,0>
   rotate x*-30
  }
/*  difference{
   cylinder {<-0.1,0,0>,<0,0,0>,1.0 scale <1,1,2.35>}
   cylinder {<-0.4,0,0>,<0.1,0,0>,1.0 scale <1,,1.85>}
   box {<-0.4,-1.5,0>,<0.1,1.5,-2.5> }
   translate <-2.2,0,0>
   rotate x*-30
  }*/
  cylinder {<-0.3,0,0>,<0,0,0>,0.25 translate <-2.4,0,2> rotate x*-30}                           
//  cylinder {<-0.3,0,0>,<0,0,0>,0.35 translate <-2.2,0,2.05> rotate x*-30}                           
  difference{
   cylinder {<0.1,0,0>,<-3.1,0,0>,0.9}
   cylinder {<0.2,0,0>,<-3.2,0,0>,0.75}
  }
 }
}                     

// *********************************************************************************
// ****************** ENGINE BLOCK *************************************************
// *********************************************************************************
                                   
#declare COOLER = object{
 union{
  difference{
   union{
    difference{
     union{
      #declare i = 0;
      #while (i < 40)
       box{ <0,0,0>,<-0.4,0.025,0.3> rotate x*30 translate <0,-0.3+0.05*i,0> }
       #declare i = i+1;
      #end
     }  
     box {0,<-0.4,1.5,0.3>}
    }
    difference{
     union{
      #declare i = 0;
      #while (i < 40)
       box{ <0,0,0>,<-0.4,0.025,0.3> rotate -x*30 translate <0,-0.3+0.05*i,0>}
       #declare i = i+1;
      #end
     }  
     box {0,<-0.4,1.5,0.3>}
    }
   }
   box{<0.4,0.2,-0.3>,<-0.8,-0.5,0.6>}
   box{<0.4,1.5,-0.3>,<-0.8,2,0.6>}
  }
  sphere {0,0.1 scale <1.5,1,1.5> translate <-0.15,1.5,0.125>}
  sphere {0,0.1 scale <1.5,1,1.5> translate <-0.15,0.1,0.125>}
  box{<0.0,1.45,-0.05>,<-0.5*cos(radians(30)),1.5,0.3>}
  box{<0.0,0.15,-0.05>,<-0.5*cos(radians(30)),0.2,0.3>}
 } 
}

#declare ENGINE_BLOCK = object{
 union{
  difference{
   union{
// ------------------------------------------------------------- Korpus 
    box {<0,0,0>,<1.3,1.7,4.4>}
    cylinder {<0,0,0>,<0,0,4.4>,1 scale <0.65,0.1,1> translate <0.65,1.7,0> }
    intersection{
     union{
      torus {0.9,0.1} 
      cylinder {<0,-0.1,0>,<0,0.1,0>,0.9}
      rotate x*90 scale <0.65,0.1,1> translate <0.65,1.7,4.4>
     }
     union{
      box {<0.1,1.7,4.4>,<1.2,2,4.6>}
      cylinder {<0.1,1.7,4.4>,<0.1,2,4.4>,0.1}
      cylinder {<1.2,1.7,4.4>,<1.2,2,4.4>,0.1}
     }
    } 
    box {<0.1,0,4.4>,<1.2,1.7,4.5>}
    cylinder {<0.1,0,4.4>,<0.1,1.7,4.4>,0.1}
    cylinder {<1.2,0,4.4>,<1.2,1.7,4.4>,0.1}
 // ------------------------------------------------------------- top vents
    union{
     cylinder {<0.65,1.7,4.35>,<0.65,1.8,4.35>,0.15}
     sphere {<0.65,0,4.35>,0.15 scale <1,0.5,1> translate y*1.8}
    } 
    union{
     cylinder {<0.45,1.7,2.25>,<0.45,1.8,2.25>,0.15}
     sphere {<0.45,0,2.25>,0.15 scale <1,0.5,1> translate y*1.8}
    } 
    union{
     cylinder {<0.85,1.7,2.25>,<0.85,1.8,2.25>,0.15}
      sphere {<0.85,0,2.25>,0.15 scale <1,0.5,1> translate y*1.8}
    } 
   }
   superellipsoid { <0.1, 0.1> scale <1,1,0.65> translate <0.65,0.6,3.75> }
  }
  superellipsoid { <0.1,0.1> scale <0.5,0.5,2.1> translate <0.65,-0.5,2.2> }
  box{<0.6,0,2.2>,<0.7,1.7,4.2>}
 }  
}

// *********************************************************************************
// ****************** FRONT AXLE ***************************************************
// *********************************************************************************
                                   
#declare FRONT_AXLE = object{
 union{
  box{<-1.15,0,0>,<1.15,0.3,0.3>}
  cylinder{<0,0.3,0>,<0,0.3,0.3>,0.3}
  cylinder{<-1.5,0.45,0.15>,<-1.5,-0.15,0.15>,0.05}
  cylinder{<1.5,0.45,0.15>,<1.5,-0.15,0.15>,0.05}
  difference{
   box{<-1.6,0.45,0>,<1.6,-0.15,0.3>}
   box{<-1.4,0.5,-0.1>,<1.4,-0.2,0.4>}
   box{<-1.7,0.35,-0.1>,<1.7,-0.05,0.4>}
  }
  difference{
   cylinder{<-1.4,0.15,0.3>,<-1.4,0.15,0>,0.3}
   cylinder{<-1.4,0.15,0.4>,<-1.4,0.15,-0.1>,0.2} 
   box{<-1.4,-0.2,-0.1>,<-1.8,0.5,0.4>}
  }
  difference{
   cylinder{<1.4,0.15,0.3>,<1.4,0.15,0>,0.3} 
   cylinder{<1.4,0.15,0.4>,<1.4,0.15,-0.1>,0.2} 
   box{<1.4,-0.2,-0.1>,<1.8,0.5,0.4>}
  }
 }
}

// *********************************************************************************
// ****************** BACK COVER ***************************************************
// *********************************************************************************
                                   
#declare BACK_COVER = object{
 difference{
  union{
   cylinder{<0,0,0>,<5.6,0,0>,2.6}
   torus{2.6,0.1 rotate z*90 translate <0.2,0,0>}
   torus{2.6,0.1 rotate z*90 translate <1.2,0,0>}
   torus{2.6,0.1 rotate z*90 translate <5.4,0,0>}
   torus{2.6,0.1 rotate z*90 translate <4.4,0,0>}
  }
  cylinder{<-0.1,0,0>,<1.3,0,0>,2.5}
  cylinder{<4.3,0,0>,<5.7,0,0>,2.5}
  cylinder{<1.4,0,0>,<4.2,0,0>,3}
  box {<-0.1,-2.7,-2.7>,<5.7,0.5,2.7> rotate x*-30}
  box {<-0.1,-2.7,-2.7>,<5.7,0,2.7>}
 }
}                                

// *********************************************************************************
// ****************** DRIVER SEAT **************************************************
// *********************************************************************************
                                   
#declare DRIVER_SEAT = object{
// intersection{
  difference{
   prism{
    linear_sweep
    linear_spline
    0,
    2,
    7,
    <0,0>,<2.6,0>,<2.6,3.5>,<2,3.8>,<0.6,3.8>,<0,3.5>,<0,0>
   }
   cylinder {<2.2,0.1,3.2>,<2.2,2.1,3.2>,0.3 }  
   cylinder {<0.4,0.1,3.2>,<0.4,2.1,3.2>,0.3 }
   cylinder {<-0.1,2.6,3.8>,<2.7,2.6,3.8>,0.8}  
   union{
    box {<0.4,0.1,-0.1>,<2.2,2.5,3.5> }
    box {<0.1,0.1,-0.1>,<2.5,2.5,3.2> }
   }
  } 
} 

// *********************************************************************************
// ****************** VENT *********************************************************
// *********************************************************************************
                                   
#declare VENT = object{
 union{
  cylinder {<0,0,0>,<0,2.4,0>,0.15}
  difference{
   sphere {<0,2.05,0>,0.4}
   cylinder {<0,2.3,0>,<0,1,0>,0.5}
  }
  intersection{
   union{
    prism{
     linear_sweep
     linear_spline
     -0.8,
      0,
      5,
      <-0.2,-0.3>, <-0.2,0.3>, <0,0.2>, <0,-0.2>, <-0.2,-0.3>
    }
    cylinder{<0,-0.8,0>,<0,0,0>,0.2 }
   }
   cylinder{<-0.6,0,-0.5>,<-0.6,0,0.5>,0.8}
  }
  superellipsoid{<0.1,0.1> scale <0.25,0.4,0.4> translate <-0.45,-0.35,0>}  
 }
}          

// *********************************************************************************
// ****************** DRIVER WHEEL *************************************************
// *********************************************************************************
                                   
 
#declare DRIVER_WHEEL = object{
 union{
  torus{0.6,0.07}
  cylinder{-0.6*x,0.6*x,0.05}
  cylinder{-0.6*z,0.6*z,0.05}
  sphere{0,0.2 scale <1,0.5,1>}
  cylinder{0,-2*y,0.1}
 }
}

