#include "kolors.inc"
#include "functions.inc"
#include "lanz.inc"

global_settings{
  max_trace_level 200
}  

// ***************************************************************
// ************** CAMERA SETTINGS ********************************
// ***************************************************************

camera {
 location <-15,1.5,-4>
 look_at <2,0.5,-3>
}

// ***************************************************************
// ************** BACKGROUND *************************************
// ***************************************************************

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

/*
#declare layers = 0; 

#while (layers < 10)
 sphere {0,10000-layers*100
 pigment{
  bozo
  color_map{
   [0.4 rgbt 1]
   [0.5 rgbt 0.95]
   [1 White*2]
  }
  turbulence .8
  scale 800
 } 
 scale <3.2,1,3.2>}
 #declare layers = layers + 1;
#end
*/

// ***************************************************************
// ************** LIGHT SOURCE ***********************************
// ***************************************************************

light_source {<-3000,300,300> 2*White shadowless}


// ***************************************************************
// ************** TEXTURES ***************************************
// ***************************************************************

#declare rust = texture{
 pigment{
  bumps
  color_map {
	[0.000000 color rgbt <0.113636, 0.113636, 0.113636, 0.000000>]
	[0.221580 color rgbt <0.378787, 0.212437, 0.110480, 0.000000>]
	[0.346912 color rgbt <0.643939, 0.311237, 0.107323, 0.000000>]
	[0.346912 color rgbt <0.643939, 0.311237, 0.107323, 0.000000>]
//	[0.449416 color rgbt <0.757575, 0.565619, 0.463661, 0.000000>]
//	[0.538564 color rgbt <0.871212, 0.820000, 0.820000, 0.000000>]
//	[0.538564 color rgbt <0.871212, 0.820000, 0.820000, 0.000000>]
//	[0.617696 color rgbt <0.605606, 0.474046, 0.463645, 0.000000>]
//	[0.652755 color rgbt <0.340000, 0.128091, 0.107291, 0.000000>]
	[0.652755 color rgbt <0.340000, 0.128091, 0.107291, 0.000000>]
	[0.747913 color rgbt <0.670000, 0.325040, 0.163645, 0.000000>]
	[0.777963 color rgbt <1.000000, 0.521990, 0.220000, 0.000000>]
	[0.777963 color rgbt <1.000000, 0.521990, 0.220000, 0.000000>]
	[0.854667 color rgbt <0.602272, 0.321683, 0.133005, 0.000000>]
	[1.000000 color rgbt <0.204545, 0.121376, 0.046011, 0.000000>]
  }
  turbulence 1.5
 }
 normal{ bumps 1 scale 0.001}
 finish {
  ambient 0.05
  diffuse 0.6
  specular 0.05
  roughness 0.01
 }
 scale 2  
}

// ---------------------------------------------------------------
#declare DarkG = texture {
 bumps
 texture_map{
  [0.4 
    pigment{
      bumps scale <0.1,1,0.1>
      color_map {
        [0.01 DarkGreen1]
        [0.5 DarkGreen]
      }
    } 
    finish{
      ambient 0.2
      diffuse 0.3
      specular 0.9
      roughness 0.1
      reflection 0.01
    }]
  [0.8 rust]    
 }
} 

// *************************************************************
// ****************** OBJECTS **********************************
// *************************************************************

// ------------------------------------- Traktor ---------------
#declare TRAKTOR = object{
 union{
  object {COOLER texture{rust} translate <0.65,0,-0.825>}
  object {COOLER texture{rust} translate <0.65,0,-0.525>}
  object {COOLER texture{rust} translate <0.65,0,-0.225>}
  object {COOLER texture{rust} translate <0.65,0,0.075>}
  object {COOLER texture{rust} translate <-0.25,0,-0.825>}
  object {COOLER texture{rust} translate <-0.25,0,-0.525>}
  object {COOLER texture{rust} translate <-0.25,0,-0.225>}
  object {COOLER texture{rust} translate <-0.25,0,0.075>}
  object {
    ENGINE_BLOCK 
    texture{DarkG translate <0.3,0.6,100>}
    translate <-0.65,0,-4> 
  }
  object {
    GEAR_BOX 
    texture{DarkG translate <0.3,0.6,0.0>}
    translate <1.5,0,-2>
  }
  object {
    EXHAUST 
    texture{rust translate <0.3,3,10>}  
    rotate y*180 
    translate <-0.95,-3,0.25>
  }
  object {
    FRONT_AXLE 
    texture{rust translate <3,0.6,10>} 
    translate <0,-1.5,0.3>
  }
  object {
    SMALL_WHEEL 
    texture{rust translate <0.3,0.6,-4>} 
    translate <2.15,-1.35,0.45> 
  } 
  object {
    SMALL_WHEEL 
    texture{rust translate <0.3,0.6,2>} 
    rotate y*180 
    translate <-2.15,-1.35,0.45> 
  } 
  object {
    BIG_WHEEL 
    texture{rust translate <0.3,0.6,10>}  
    translate <2.4,-0.5,-6.1> 
  } 
  object {
    BIG_WHEEL 
    texture{rust translate <3,6,10>}  
    matrix<-1,0,0,0,1,0,0,0,1,0,0,0> 
    translate <-2.4,-0.5,-6.1> 
  }
  object {
    BACK_COVER 
    texture {DarkG translate <0.3,2,10>} 
    translate <-2.8,-0.5,-6.1>
  }  
  object {
    DRIVER_SEAT 
    texture{DarkG translate <0.3,0.6,10>} 
    translate <-1.25,-0.3,-7.75>
  }        
  object {
    VENT 
    texture{rust translate <0.3,0.6,10>} 
    rotate y*180 
    translate <-1,1.4,-3.25> 
  }
  object {
    DRIVER_WHEEL
    texture{rust translate <0.3,6,10>} 
    rotate x*-45 
    translate <0,1.8,-5.25> 
  }
 }
}

/*
object {TRAKTOR rotate y*0 
rotate x*10
rotate z*25
rotate y*-20 
translate <-4,0,1>}

                
// ------------------------------------- WATER ---------------
isosurface {
	function { y+f_noise3d(x, 0, z) }
	threshold 0
	accuracy 0.00001
	contained_by {box{-80,80}}
	max_gradient 2
	open
	texture {
		pigment {color MidnightBlue1}
		finish {
		  diffuse 0.1 
		  ambient 0.1 
		  specular 0.2 
		  reflection <0.6,0.6,0.65>
		}
	}
	scale <0.5,0.05,0.5>
	
}                
                
// ------------------------------------- WEEDS ---------------
                
#declare AS = seed(345);
#declare h = 0;
#declare g = 0;
 #while (h<100)
  #while (g<1000)
   #declare w_type = rand(AS);
   #if (w_type < 0.98)
    triangle {<-0.025,0,0>,<0.025,0,0>,<0,4+rand(AS),0>
     pigment{DarkGreen + 
       <rand(AS)*0.1, rand(AS)*0.1, rand(AS)*0.1>}
     rotate <rand(AS)*5,rand(AS)*180,rand(AS)*5>
     translate <0.1*h+rand(AS)*0.05,-0.1+rand(AS)*0.05,-0.1*g+rand(AS)*0.35+8>
    }
   #else
    #declare P1 = <0,rand(AS)+3,0>;
    #declare P2 = P1+<0,rand(AS)+1,0>;
    union{
     cylinder{0,P1,0.01}
     cylinder{P1,P2,0.006}
     cylinder{P1+(P2-P1)*0.6,P1+(P2-P1)*0.8,0.06 pigment{DarkBrown}}
     sphere{P1+(P2-P1)*0.6,0.06 pigment{DarkBrown}}
     sphere{P1+(P2-P1)*0.8,0.06 pigment{DarkBrown}}
     pigment{Tan4 + 
       <rand(AS)*0.1, rand(AS)*0.1, rand(AS)*0.1>}
     rotate <rand(AS)*5,rand(AS)*180,rand(AS)*5>
     translate <0.1*h+rand(AS)*0.05,-0.1+rand(AS)*0.05,-0.1*g+rand(AS)*0.05+8>
    }
    #end 
   #declare g = g + 1;
  #end
  #declare g = 0;
  #declare h = h + 1;
 #end   
     
// ------------------------------------ TREE ----------------

#include "TESTTREE.inc"
#include "TOMTREE.inc"
object
{
	TREE
	rotate y*90
	scale 10
	translate <2,0,5>
}

*/
// ------------------------------ birds -----------------------

#declare Bird = object{
 union{
  cone {<0,0,0>,0.1,<0,0,0.3>,0 scale <1,0.5,1.5> }
  sphere {<0,0,0>,0.1 scale <1,0.5,1.5> }
  #declare h = 0;
  #while (h<12)
   triangle {
    <0,0,-0.1>,<0,0,0.15>,<0.4,0,0.05>
    rotate z*(5*h-30) 
    pigment{rgbt <0,0,0,0.8>}
   }
/*   triangle {
    <0,0,-0.1>,<0,0,0.1>,<-0.2,0,0.>
    rotate z*(10*h-100) 
    pigment{rgbt 0.1}
   }*/
   #declare h = h + 1;
  #end
 }
} 

object{
 Bird
 pigment{rgbt 0.5*<0.6470, 0.1640, 0.1640, 0.5>} 
 translate <-8,2,-3>
}   