/*

This scene was created by Txemi Jendrix on 24/2/2003 for the IRTC
Free for personal use. In other case contact me.
website: www.txemijendrix.com
email: tji@txemijendrix.com

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  charset ascii
}

background { color <1.000,1.000,1.000> }

camera {  //  Camera 
  location  <      8.428,      20.000,       2.299>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.53571,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      26.667
  look_at   <      2.377,       0.103,      -2.133>
}


//
// *******  L I G H T S *******
//

light_source {   // Arealight luz poleas
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.6000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  fade_distance  6.0
  fade_power 2.0
  media_interaction off
  photons {
  }
  translate  <7.15849, 8.34221, 4.87408>
}


light_source {   // luz_habitacion
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.714, 0.514>*0.7000
  fade_distance  6.0
  fade_power 2.0
  media_interaction off
  photons {
  }
  translate  <2.993786, -17.660331, 0.0>
}

light_source {   // luz_principal
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.886, 0.714>*1.7500
  fade_distance  50.0
  fade_power 2.0
  photons {
  }
  translate  <-50.0, -5.003016, 20.0>
}

light_source {   // luz_angel
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.5000
  shadowless
  fade_distance  3.0
  fade_power 2.0
  media_interaction off
  photons {
  }
  translate  <-10.0, -8.0, 1.0>
}

light_source {   // luz_puerta
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.5000
  shadowless
  fade_distance  3.0
  fade_power 2.0
  media_interaction off
  photons {
  }
  translate  <-1.5, -8.0, 1.0>
}

light_source {   // luz_proa
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.6000
  shadowless
  fade_distance  3.0
  fade_power 2.0
  media_interaction off
  photons {
  }
  translate  <3.010102, 5.154665, 1.006105>
}

light_source {   // luz_timon
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.6000
  fade_distance  2.0
  fade_power 2.0
  media_interaction off
  photons {
  }
  translate  <-4.712506, 4.023145, 1.006105>
}


//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "leonardoirtc.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare apoyo01 = union {
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.05, 1.75>
    rotate 9.062362*x
    translate  <2.641868, 2.308258, -2.976214>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.3, 0.4, 0.05>
    translate  <2.641868, 2.564444, -4.52>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    material {
      acero_txt
    }
    photons {
      collect off
    }
    scale <0.25, 0.025, 0.05>
    translate  <2.644644, 2.615223, -4.447837>
  }
  photons {
    collect off
  }
  translate  <-0.22803, -0.009121, 0.0>
}
#declare apoyo04 = union {
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.05, 1.875>
    rotate 9.062362*x
    translate  <2.641868, 2.308258, -2.976214>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.3, 0.4, 0.05>
    translate  <2.641868, 2.564444, -4.52>
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    material {
      acero_txt
    }
    photons {
      collect off
    }
    scale <0.25, 0.025, 0.05>
    translate  <2.644644, 2.615223, -4.447837>
  }
  photons {
    collect off
  }
  rotate 7.004606*z
  translate  <-7.06681, -0.856487, 0.0>
}
#declare apoyo03 = union {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.05, 1.77>
    rotate 9.062362*x
    translate  <2.641868, 2.308258, -2.976214>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.3, 0.4, 0.05>
    translate  <2.641868, 2.564444, -4.52>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    material {
      acero_txt
    }
    photons {
      collect off
    }
    scale <0.25, 0.025, 0.05>
    translate  <2.644644, 2.615223, -4.447837>
  }
  photons {
    collect off
  }
  rotate 6.039395*z
  translate  <-4.811782, -0.484004, 0.0>
}
#declare apoyo02 = union {
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.05, 1.84>
    rotate 9.062362*x
    translate  <2.641868, 2.308258, -2.976214>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.3, 0.4, 0.05>
    translate  <2.641868, 2.564444, -4.52>
  }
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    material {
      acero_txt
    }
    photons {
      collect off
    }
    scale <0.25, 0.025, 0.05>
    translate  <2.644644, 2.615223, -4.447837>
  }
  photons {
    collect off
  }
  rotate -23.683386*z
  translate  <1.826969, 0.539813, 0.0>
}
#declare apoyos1 = union {
  object { apoyo01 }
  object { apoyo04 }
  object { apoyo03 }
  object { apoyo02 }
  material {
    T_Wood33_1
    scale <0.5, 1.0, 1.0>
  }
  photons {
    collect off
  }
}


#declare CSG058 = union {
  sphere { // Sphere045
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.04
    translate  <0.107645, -12.277406, -3.982592>
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.04, 0.04, 3.5>
    translate  <0.107937, -12.277446, -3.982552>
  }
  sphere { // Sphere046
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.04
    translate  <0.107645, -12.277406, -0.482365>
  }
  photons {
    collect off
  }
}
#declare CSG061 = union {
  object { CSG058 }
  object { // CSG059 -> CSG058
    CSG058
    photons {
      collect off
    }
    translate  0.293392*x
  }
  object { // CSG060 -> CSG058
    CSG058
    photons {
      collect off
    }
    translate  0.143534*x
  }
  photons {
    collect off
  }
}
#declare CSG062 = difference {
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    translate  10.0*z
    photons {
      collect off
    }
    scale <0.25, 0.2, 2.25>
    translate  <0.261434, -12.486038, -24.796785>
  }
  object { CSG061 }
  photons {
    collect off
  }
}
#declare Cube146 = object {
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood33_2
    }
    photons {
      collect off
    }
    scale <0.2, 0.05, 2.4>
    translate  <2.29, -13.501089, -2.212615>
  }
}
#declare hojas = union {
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.0, 1.5>
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.0, -1.000629, -1.5>
  }
  material {
    hojas_txt
  }
  photons {
    collect off
  }
}
#declare CSG010 = union {
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.0, 1.5>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.0, -1.000629, -1.5>
  }
  photons {
    collect off
  }
  scale <1.2, 1.05, 1.05>
}
#declare CSG011 = union {
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.1, 1.7>
    translate  0.10039*y
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 3.4>
    translate  <0.0, -1.000629, -1.7>
  }
  photons {
    collect off
  }
}
#declare tapas = difference {
  object { CSG010 }
  object { CSG011 }
  material {
    tapas_txt
  }
  photons {
    collect off
  }
}
#declare libro = union {
  object { hojas }
  object { tapas }
  photons {
    collect off
  }
  scale -0.2
  rotate <-180.0, 0.0, -180.0>
  translate  <-1.350957, -22.114354, -2.518979>
}
#declare hojas1 = union {
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.0, 1.5>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.0, -1.000629, -1.5>
  }
  material {
    hojas_txt
  }
  photons {
    collect off
  }
}
#declare CSG012 = union {
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.0, 1.5>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.0, -1.000629, -1.5>
  }
  photons {
    collect off
  }
  scale <1.2, 1.05, 1.05>
}
#declare CSG013 = union {
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.1, 1.7>
    translate  0.10039*y
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 3.4>
    translate  <0.0, -1.000629, -1.7>
  }
  photons {
    collect off
  }
}
#declare tapas1 = difference {
  object { CSG012 }
  object { CSG013 }
  material {
    tapas_txt
  }
  photons {
    collect off
  }
}
#declare libro1 = union {
  object { hojas1 }
  object { tapas1 }
  photons {
    collect off
  }
  scale 0.2
  translate  <-1.468031, -22.081767, -2.518979>
}


#declare sueloHF01 = object { 
  height_field {
    tga "leo suelo hf copia.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Material1
  }
  photons {
    collect off
  }
  scale <7.75, 7.75, 0.1>
  translate  <-36.665825, -42.250078, -4.68462>
}
#declare ventana = union {
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.0, 2.0>
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.4>
    rotate -90.0*y
    translate  <0.195396, 0.0, 2.001147>
  }
  photons {
    collect off
  }
  rotate <0.0, 0.0, 0.0>
  translate  <-16.841795, -8.530711, 2.966293>
}
#declare Cube155 = object {
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.04, 0.02, 2.6>
    translate  <0.0, -5.186186, 0.773213>
  }
}
#declare Cube173 = object {
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.02, 1.1, 0.02>
    translate  <0.0, -6.185706, 3.375736>
  }
}
#declare rejas04 = union {
  object { Cube155 }
  object { // Cube156 -> Cube155
    Cube155
    photons {
      collect off
    }
    translate  -0.666*y
  }
  object { // Cube159 -> Cube155
    Cube155
    photons {
      collect off
    }
    translate  -1.4*y
  }
  object { // Cube160 -> Cube155
    Cube155
    photons {
      collect off
    }
    rotate 0.0*x
    translate  <0.0, -2.0, -0.0>
  }
  object { // Cube161 -> Cube173
    Cube173
    photons {
      collect off
    }
    rotate 0.0*x
    translate  <0.0, 0.0, -0.4>
  }
  object { // Cube163 -> Cube173
    Cube173
    photons {
      collect off
    }
    rotate 0.0*x
    translate  <0.0, 0.0, -1.2>
  }
  object { // Cube165 -> Cube173
    Cube173
    photons {
      collect off
    }
    rotate 0.0*x
    translate  <0.0, 0.0, -2.0>
  }
  object { // Cube167 -> Cube173
    Cube173
    photons {
      collect off
    }
    rotate 0.0*x
    translate  <0.0, 0.0, -2.8>
  }
  object { // Cube169 -> Cube173
    Cube173
    photons {
      collect off
    }
    rotate 0.0*x
    translate  <0.0, 0.0, -3.6>
  }
  object { // Cube171 -> Cube173
    Cube173
    photons {
      collect off
    }
    rotate 0.0*x
    translate  <0.0, 0.0, -4.4>
  }
  object { Cube173 }
  material {
    negro
  }
  photons {
    collect off
  }
  translate  <-17.148761, 3.60976, 2.743123>
}
#declare zocalo01 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <0.201591, 1.0>,
  <0.000803, 1.0>,
  <-0.044381, 0.989242>,
  <-0.075361, 0.972737>,
  <-0.093291, 0.943137>,
  <-0.098312, 0.899387>,
  <-0.098312, -1.0>,
  <0.201591, -1.0>,
  <0.201591, 1.0>
  rotate -x*90
  photons {
    collect off
  }
  scale <1.0, 1.0, 4.0>
  rotate <90.0, 0.0, -90.0>
  translate  <0.0, -12.401164, -3.553263>
}


#declare Cube041 = object {
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.03, 0.03, 0.55>
    rotate 31.675468*x
    translate  <0.0, 0.43, 0.16>
  }
}
#declare Cube044 = object {
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.13, 0.02, 0.04>
    translate  <0.0, -0.115916, 0.60541>
  }
}
#declare CSG008 = union {
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.6>
  }
  sphere { // Sphere027
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.01
  }
  sphere { // Sphere028
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.01
    translate  0.6*z
  }
  photons {
    collect off
  }
  rotate -90.0*x
  translate  <0.0, -0.3, 0.15687>
}
#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.205186, 0.052020, 0.423819>, <0.202910, 0.051495, 0.418886>, <0.199995, 0.055485, 0.414781>, <0.198770, 0.060803, 0.414781>, 
      <0.093889, 0.025507, 0.479064>, <0.091612, 0.024983, 0.474131>, <0.088165, 0.029237, 0.469120>, <0.086939, 0.034556, 0.469120>, 
      <-0.053036, -0.082637, 0.479255>, <-0.053936, -0.083105, 0.473892>, <-0.056828, -0.079235, 0.469666>, <-0.059348, -0.074394, 0.469666>, 
      <-0.163703, -0.140347, 0.503013>, <-0.164603, -0.140815, 0.497650>, <-0.167449, -0.137176, 0.493188>, <-0.169969, -0.132335, 0.493188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.376281, -0.011715, 0.234980>, <0.375400, -0.010890, 0.229657>, <0.377769, -0.006887, 0.225228>, <0.381497, -0.002901, 0.225228>, 
      <0.317799, 0.037713, 0.253589>, <0.316917, 0.038538, 0.248266>, <0.320281, 0.047810, 0.242761>, <0.324010, 0.051796, 0.242761>, 
      <0.274216, 0.068464, 0.389554>, <0.271940, 0.067939, 0.384622>, <0.271512, 0.072270, 0.380031>, <0.270287, 0.077589, 0.380031>, 
      <0.205186, 0.052020, 0.423819>, <0.202910, 0.051495, 0.418886>, <0.199995, 0.055485, 0.414781>, <0.198770, 0.060803, 0.414781>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.377721, -0.093803, 0.368918>, <0.374054, -0.094552, 0.364946>, <0.371911, -0.099626, 0.361641>, <0.373003, -0.104974, 0.361641>, 
      <0.410896, -0.089237, 0.335755>, <0.407228, -0.089986, 0.331783>, <0.408398, -0.092002, 0.326576>, <0.409491, -0.097350, 0.326576>, 
      <0.411259, -0.041277, 0.223850>, <0.410377, -0.040452, 0.218527>, <0.413971, -0.041332, 0.214186>, <0.417700, -0.037346, 0.214186>, 
      <0.376281, -0.011715, 0.234980>, <0.375400, -0.010890, 0.229657>, <0.377769, -0.006887, 0.225228>, <0.381497, -0.002901, 0.225228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.147730, -0.043173, 0.463452>, <0.146779, -0.042965, 0.458082>, <0.145014, -0.047228, 0.453613>, <0.143845, -0.052559, 0.453613>, 
      <0.220855, -0.059343, 0.449779>, <0.219904, -0.059135, 0.444408>, <0.217673, -0.063674, 0.440010>, <0.216503, -0.069006, 0.440010>, 
      <0.324134, -0.101179, 0.422487>, <0.320466, -0.101928, 0.418515>, <0.317918, -0.110908, 0.413528>, <0.319011, -0.116255, 0.413528>, 
      <0.377721, -0.093803, 0.368918>, <0.374054, -0.094552, 0.364946>, <0.371911, -0.099626, 0.361641>, <0.373003, -0.104974, 0.361641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.091281, 0.009906, 0.456618>, <-0.088624, 0.009540, 0.451864>, <-0.087034, 0.004735, 0.447908>, <-0.087779, -0.000671, 0.447908>, 
      <-0.029412, 0.004589, 0.495901>, <-0.026756, 0.004222, 0.491147>, <-0.026480, -0.003385, 0.484529>, <-0.027226, -0.008792, 0.484529>, 
      <0.077151, -0.027566, 0.476650>, <0.076200, -0.027358, 0.471280>, <0.076672, -0.031758, 0.466408>, <0.075503, -0.037089, 0.466408>, 
      <0.147730, -0.043173, 0.463452>, <0.146779, -0.042965, 0.458082>, <0.145014, -0.047228, 0.453613>, <0.143845, -0.052559, 0.453613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.238235, -0.010000, 0.218382>, <-0.243605, -0.010000, 0.217406>, <-0.248074, -0.005458, 0.216593>, <-0.248074, 0.000000, 0.216593>, 
      <-0.257267, -0.005146, 0.324889>, <-0.262637, -0.005146, 0.323912>, <-0.266295, -0.005622, 0.323667>, <-0.266295, -0.000164, 0.323667>, 
      <-0.162164, 0.015999, 0.411610>, <-0.159508, 0.015632, 0.406856>, <-0.158807, 0.014361, 0.404502>, <-0.159553, 0.008954, 0.404502>, 
      <-0.091281, 0.009906, 0.456618>, <-0.088624, 0.009540, 0.451864>, <-0.087034, 0.004735, 0.447908>, <-0.087779, -0.000671, 0.447908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013235, -0.010000, 0.019853>, <-0.013235, -0.010000, 0.014395>, <-0.013235, -0.005458, 0.009853>, <-0.013235, 0.000000, 0.009853>, 
      <-0.128997, -0.010000, 0.016637>, <-0.128997, -0.010000, 0.011179>, <-0.133946, -0.005458, 0.006770>, <-0.133946, 0.000000, 0.006770>, 
      <-0.217885, -0.015190, 0.104496>, <-0.223255, -0.015190, 0.103520>, <-0.227817, -0.005275, 0.097554>, <-0.227817, 0.000182, 0.097554>, 
      <-0.238235, -0.010000, 0.218382>, <-0.243605, -0.010000, 0.217406>, <-0.248074, -0.005458, 0.216593>, <-0.248074, 0.000000, 0.216593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238235, -0.010000, 0.231617>, <0.243540, -0.010000, 0.230331>, <0.247954, -0.005458, 0.229261>, <0.247954, 0.000000, 0.229261>, 
      <0.208802, -0.015609, 0.108326>, <0.214107, -0.015609, 0.107040>, <0.218425, -0.005217, 0.100967>, <0.218425, 0.000241, 0.100967>, 
      <0.113596, -0.010000, 0.023376>, <0.113596, -0.010000, 0.017918>, <0.118371, -0.005458, 0.013214>, <0.118371, 0.000000, 0.013214>, 
      <-0.013235, -0.010000, 0.019853>, <-0.013235, -0.010000, 0.014395>, <-0.013235, -0.005458, 0.009853>, <-0.013235, 0.000000, 0.009853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091032, 0.009869, 0.456618>, <0.088286, 0.009419, 0.451922>, <0.086734, 0.004563, 0.448015>, <0.087615, -0.000823, 0.448015>, 
      <0.159102, 0.017278, 0.413564>, <0.156356, 0.016828, 0.408869>, <0.155818, 0.015555, 0.406455>, <0.156699, 0.010169, 0.406455>, 
      <0.262373, -0.005400, 0.332727>, <0.267677, -0.005400, 0.331441>, <0.271433, -0.005650, 0.331270>, <0.271433, -0.000192, 0.331270>, 
      <0.238235, -0.010000, 0.231617>, <0.243540, -0.010000, 0.230331>, <0.247954, -0.005458, 0.229261>, <0.247954, 0.000000, 0.229261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.128312, -0.049896, 0.463452>, <-0.127799, -0.049760, 0.458020>, <-0.126201, -0.054034, 0.453500>, <-0.124795, -0.059308, 0.453500>, 
      <-0.062739, -0.032256, 0.470145>, <-0.062226, -0.032119, 0.464713>, <-0.062753, -0.036656, 0.460091>, <-0.061346, -0.041930, 0.460091>, 
      <0.033608, 0.003619, 0.492937>, <0.030862, 0.003169, 0.488242>, <0.030600, -0.004369, 0.481784>, <0.031481, -0.009755, 0.481784>, 
      <0.091032, 0.009869, 0.456618>, <0.088286, 0.009419, 0.451922>, <0.086734, 0.004563, 0.448015>, <0.087615, -0.000823, 0.448015>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.294132, -0.093750, 0.417305>, <-0.291391, -0.094229, 0.412609>, <-0.289892, -0.099102, 0.408702>, <-0.290832, -0.104479, 0.408702>, 
      <-0.249210, -0.099745, 0.445332>, <-0.246469, -0.100224, 0.440637>, <-0.244660, -0.106997, 0.435852>, <-0.245600, -0.112374, 0.435852>, 
      <-0.179520, -0.063673, 0.458226>, <-0.179007, -0.063536, 0.452794>, <-0.177392, -0.068055, 0.448182>, <-0.175986, -0.073329, 0.448182>, 
      <-0.128312, -0.049896, 0.463452>, <-0.127799, -0.049760, 0.458020>, <-0.126201, -0.054034, 0.453500>, <-0.124795, -0.059308, 0.453500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432458, -0.009310, 0.273689>, <-0.432366, -0.009147, 0.268234>, <-0.436250, -0.006786, 0.263695>, <-0.441008, -0.004113, 0.263695>, 
      <-0.466372, -0.064662, 0.271214>, <-0.466280, -0.064498, 0.265759>, <-0.469775, -0.067617, 0.261592>, <-0.474534, -0.064944, 0.261592>, 
      <-0.348896, -0.086442, 0.383136>, <-0.346155, -0.086921, 0.378440>, <-0.348816, -0.088817, 0.373333>, <-0.349756, -0.094193, 0.373333>, 
      <-0.294132, -0.093750, 0.417305>, <-0.291391, -0.094229, 0.412609>, <-0.289892, -0.099102, 0.408702>, <-0.290832, -0.104479, 0.408702>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.204860, 0.051950, 0.423819>, <-0.203022, 0.051591, 0.418692>, <-0.200621, 0.055750, 0.414426>, <-0.199573, 0.061106, 0.414426>, 
      <-0.281799, 0.067838, 0.394557>, <-0.279961, 0.067479, 0.389430>, <-0.281372, 0.071644, 0.384420>, <-0.280325, 0.077001, 0.384420>, 
      <-0.388690, 0.062122, 0.276882>, <-0.388599, 0.062285, 0.271428>, <-0.393986, 0.069899, 0.266346>, <-0.398745, 0.072572, 0.266346>, 
      <-0.432458, -0.009310, 0.273689>, <-0.432366, -0.009147, 0.268234>, <-0.436250, -0.006786, 0.263695>, <-0.441008, -0.004113, 0.263695>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.170510, -0.133825, 0.503013>, <0.171413, -0.134271, 0.497649>, <0.174177, -0.130570, 0.493185>, <0.176593, -0.125677, 0.493185>, 
      <0.057899, -0.078092, 0.479255>, <0.058803, -0.078539, 0.473891>, <0.061327, -0.074536, 0.469557>, <0.063743, -0.069642, 0.469557>, 
      <-0.087504, 0.027716, 0.468452>, <-0.085666, 0.027357, 0.463326>, <-0.082450, 0.032490, 0.458336>, <-0.081403, 0.037846, 0.458336>, 
      <-0.204860, 0.051950, 0.423819>, <-0.203022, 0.051591, 0.418692>, <-0.200621, 0.055750, 0.414426>, <-0.199573, 0.061106, 0.414426>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.198770, 0.060803, 0.414781>, <0.197544, 0.066122, 0.414781>, <0.198419, 0.070985, 0.418886>, <0.200696, 0.071509, 0.423819>, 
      <0.086939, 0.034556, 0.469120>, <0.085714, 0.039874, 0.469120>, <0.084656, 0.045621, 0.473058>, <0.086933, 0.046145, 0.477990>, 
      <-0.059348, -0.074394, 0.469666>, <-0.061867, -0.069552, 0.469666>, <-0.061747, -0.064840, 0.473892>, <-0.060847, -0.064372, 0.479255>, 
      <-0.169969, -0.132335, 0.493188>, <-0.172489, -0.127494, 0.493188>, <-0.173837, -0.123075, 0.497650>, <-0.172937, -0.122606, 0.503013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.381497, -0.002901, 0.225228>, <0.385226, 0.001085, 0.225228>, <0.389062, 0.003716, 0.229657>, <0.389944, 0.002891, 0.234980>, 
      <0.324010, 0.051796, 0.242761>, <0.327738, 0.055782, 0.242761>, <0.332396, 0.061596, 0.246842>, <0.333278, 0.060771, 0.252165>, 
      <0.270287, 0.077589, 0.380031>, <0.269061, 0.082908, 0.380031>, <0.271709, 0.087325, 0.383987>, <0.273986, 0.087850, 0.388919>, 
      <0.198770, 0.060803, 0.414781>, <0.197544, 0.066122, 0.414781>, <0.198419, 0.070985, 0.418886>, <0.200696, 0.071509, 0.423819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.373003, -0.104974, 0.361641>, <0.374096, -0.110321, 0.361641>, <0.378057, -0.114148, 0.364946>, <0.381725, -0.113398, 0.368918>, 
      <0.409491, -0.097350, 0.326576>, <0.410583, -0.102697, 0.326576>, <0.416403, -0.103943, 0.329405>, <0.420070, -0.103193, 0.333377>, 
      <0.417700, -0.037346, 0.214186>, <0.421428, -0.033360, 0.214186>, <0.425518, -0.033520, 0.218601>, <0.426399, -0.034345, 0.223924>, 
      <0.381497, -0.002901, 0.225228>, <0.385226, 0.001085, 0.225228>, <0.389062, 0.003716, 0.229657>, <0.389944, 0.002891, 0.234980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.143845, -0.052559, 0.453613>, <0.142676, -0.057890, 0.453613>, <0.142495, -0.062500, 0.458082>, <0.143446, -0.062709, 0.463452>, 
      <0.216503, -0.069006, 0.440010>, <0.215334, -0.074337, 0.440010>, <0.217883, -0.078900, 0.444185>, <0.218834, -0.079109, 0.449555>, 
      <0.319011, -0.116255, 0.413528>, <0.320103, -0.121603, 0.413528>, <0.321628, -0.129165, 0.417250>, <0.325295, -0.128416, 0.421222>, 
      <0.373003, -0.104974, 0.361641>, <0.374096, -0.110321, 0.361641>, <0.378057, -0.114148, 0.364946>, <0.381725, -0.113398, 0.368918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.087779, -0.000671, 0.447908>, <-0.088525, -0.006078, 0.447908>, <-0.091357, -0.010273, 0.451864>, <-0.094013, -0.009906, 0.456618>, 
      <-0.027226, -0.008792, 0.484529>, <-0.027972, -0.014199, 0.484529>, <-0.030698, -0.021828, 0.490812>, <-0.033355, -0.021462, 0.495565>, 
      <0.075503, -0.037089, 0.466408>, <0.074333, -0.042420, 0.466408>, <0.072286, -0.047227, 0.471024>, <0.073238, -0.047436, 0.476395>, 
      <0.143845, -0.052559, 0.453613>, <0.142676, -0.057890, 0.453613>, <0.142495, -0.062500, 0.458082>, <0.143446, -0.062709, 0.463452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248074, 0.000000, 0.216593>, <-0.248074, 0.005458, 0.216593>, <-0.243605, 0.010000, 0.217406>, <-0.238235, 0.010000, 0.218382>, 
      <-0.266295, -0.000164, 0.323667>, <-0.266295, 0.005294, 0.323667>, <-0.263182, 0.005176, 0.323256>, <-0.257812, 0.005176, 0.324233>, 
      <-0.159553, 0.008954, 0.404502>, <-0.160298, 0.003547, 0.404502>, <-0.160950, 0.002985, 0.407179>, <-0.163607, 0.003351, 0.411933>, 
      <-0.087779, -0.000671, 0.447908>, <-0.088525, -0.006078, 0.447908>, <-0.091357, -0.010273, 0.451864>, <-0.094013, -0.009906, 0.456618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013235, 0.000000, 0.009853>, <-0.013235, 0.005458, 0.009853>, <-0.013235, 0.010000, 0.014395>, <-0.013235, 0.010000, 0.019853>, 
      <-0.133946, 0.000000, 0.006770>, <-0.133946, 0.005458, 0.006770>, <-0.128997, 0.010000, 0.011179>, <-0.128997, 0.010000, 0.016637>, 
      <-0.227817, 0.000182, 0.097554>, <-0.227817, 0.005640, 0.097554>, <-0.222566, 0.015185, 0.103645>, <-0.217196, 0.015185, 0.104621>, 
      <-0.248074, 0.000000, 0.216593>, <-0.248074, 0.005458, 0.216593>, <-0.243605, 0.010000, 0.217406>, <-0.238235, 0.010000, 0.218382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.247954, 0.000000, 0.229261>, <0.247954, 0.005458, 0.229261>, <0.243540, 0.010000, 0.230331>, <0.238235, 0.010000, 0.231617>, 
      <0.218425, 0.000241, 0.100967>, <0.218425, 0.005699, 0.100967>, <0.213246, 0.015599, 0.107248>, <0.207942, 0.015599, 0.108534>, 
      <0.118371, 0.000000, 0.013214>, <0.118371, 0.005458, 0.013214>, <0.113596, 0.010000, 0.017918>, <0.113596, 0.010000, 0.023376>, 
      <-0.013235, 0.000000, 0.009853>, <-0.013235, 0.005458, 0.009853>, <-0.013235, 0.010000, 0.014395>, <-0.013235, 0.010000, 0.019853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.087615, -0.000823, 0.448015>, <0.088497, -0.006210, 0.448015>, <0.091516, -0.010318, 0.451922>, <0.094262, -0.009869, 0.456618>, 
      <0.156699, 0.010169, 0.406455>, <0.157580, 0.004782, 0.406455>, <0.158029, 0.004262, 0.409253>, <0.160776, 0.004712, 0.413949>, 
      <0.271433, -0.000192, 0.331270>, <0.271433, 0.005266, 0.331270>, <0.268222, 0.005438, 0.330615>, <0.262917, 0.005438, 0.331901>, 
      <0.247954, 0.000000, 0.229261>, <0.247954, 0.005458, 0.229261>, <0.243540, 0.010000, 0.230331>, <0.238235, 0.010000, 0.231617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124795, -0.059308, 0.453500>, <-0.123389, -0.064582, 0.453500>, <-0.122645, -0.069084, 0.458020>, <-0.123159, -0.069221, 0.463452>, 
      <-0.061346, -0.041930, 0.460091>, <-0.059940, -0.047203, 0.460091>, <-0.057553, -0.051877, 0.464551>, <-0.058067, -0.052014, 0.469983>, 
      <0.031481, -0.009755, 0.481784>, <0.032362, -0.015141, 0.481784>, <0.035525, -0.022592, 0.487840>, <0.038271, -0.022142, 0.492536>, 
      <0.087615, -0.000823, 0.448015>, <0.088497, -0.006210, 0.448015>, <0.091516, -0.010318, 0.451922>, <0.094262, -0.009869, 0.456618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.290832, -0.104479, 0.408702>, <-0.291772, -0.109855, 0.408702>, <-0.294835, -0.113930, 0.412609>, <-0.297576, -0.113451, 0.417305>, 
      <-0.245600, -0.112374, 0.435852>, <-0.246540, -0.117750, 0.435852>, <-0.247444, -0.124041, 0.440133>, <-0.250185, -0.123562, 0.444828>, 
      <-0.175986, -0.073329, 0.448182>, <-0.174580, -0.078603, 0.448182>, <-0.176271, -0.083260, 0.452640>, <-0.176785, -0.083397, 0.458072>, 
      <-0.124795, -0.059308, 0.453500>, <-0.123389, -0.064582, 0.453500>, <-0.122645, -0.069084, 0.458020>, <-0.123159, -0.069221, 0.463452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.441008, -0.004113, 0.263695>, <-0.445766, -0.001439, 0.263695>, <-0.449802, 0.000650, 0.268234>, <-0.449894, 0.000486, 0.273689>, 
      <-0.474534, -0.064944, 0.261592>, <-0.479292, -0.062270, 0.261592>, <-0.482866, -0.062711, 0.266003>, <-0.482957, -0.062874, 0.271458>, 
      <-0.349756, -0.094193, 0.373333>, <-0.350696, -0.099570, 0.373333>, <-0.355641, -0.100958, 0.377294>, <-0.358381, -0.100479, 0.381990>, 
      <-0.290832, -0.104479, 0.408702>, <-0.291772, -0.109855, 0.408702>, <-0.294835, -0.113930, 0.412609>, <-0.297576, -0.113451, 0.417305>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.199573, 0.061106, 0.414426>, <-0.198526, 0.066463, 0.414426>, <-0.199184, 0.071219, 0.418692>, <-0.201022, 0.071579, 0.423819>, 
      <-0.280325, 0.077001, 0.384420>, <-0.279278, 0.082357, 0.384420>, <-0.282278, 0.086587, 0.388410>, <-0.284116, 0.086946, 0.393537>, 
      <-0.398745, 0.072572, 0.266346>, <-0.403503, 0.075246, 0.266346>, <-0.408295, 0.080192, 0.271034>, <-0.408387, 0.080029, 0.276489>, 
      <-0.441008, -0.004113, 0.263695>, <-0.445766, -0.001439, 0.263695>, <-0.449802, 0.000650, 0.268234>, <-0.449894, 0.000486, 0.273689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.176593, -0.125677, 0.493185>, <0.179010, -0.120783, 0.493185>, <0.180270, -0.116339, 0.497649>, <0.179366, -0.115893, 0.503013>, 
      <0.063743, -0.069642, 0.469557>, <0.066160, -0.064748, 0.469557>, <0.066153, -0.060098, 0.473891>, <0.065249, -0.059651, 0.479255>, 
      <-0.081403, 0.037846, 0.458336>, <-0.080356, 0.043203, 0.458336>, <-0.079381, 0.049062, 0.462353>, <-0.081219, 0.049421, 0.467480>, 
      <-0.199573, 0.061106, 0.414426>, <-0.198526, 0.066463, 0.414426>, <-0.199184, 0.071219, 0.418692>, <-0.201022, 0.071579, 0.423819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.200696, 0.071509, 0.423819>, <0.202972, 0.072034, 0.428752>, <0.205887, 0.068044, 0.432856>, <0.207112, 0.062726, 0.432856>, 
      <0.086933, 0.046145, 0.477990>, <0.089209, 0.046670, 0.482923>, <0.092634, 0.042433, 0.487923>, <0.093860, 0.037114, 0.487923>, 
      <-0.060847, -0.064372, 0.479255>, <-0.059947, -0.063903, 0.484618>, <-0.057056, -0.067774, 0.488844>, <-0.054536, -0.072615, 0.488844>, 
      <-0.172937, -0.122606, 0.503013>, <-0.172037, -0.122138, 0.508376>, <-0.169191, -0.125777, 0.512839>, <-0.166671, -0.130618, 0.512839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.389944, 0.002891, 0.234980>, <0.390826, 0.002066, 0.240303>, <0.388457, -0.001937, 0.244732>, <0.384728, -0.005923, 0.244732>, 
      <0.333278, 0.060771, 0.252165>, <0.334159, 0.059947, 0.257488>, <0.330890, 0.051014, 0.262921>, <0.327162, 0.047028, 0.262921>, 
      <0.273986, 0.087850, 0.388919>, <0.276263, 0.088374, 0.393852>, <0.276657, 0.084048, 0.398446>, <0.277882, 0.078730, 0.398446>, 
      <0.200696, 0.071509, 0.423819>, <0.202972, 0.072034, 0.428752>, <0.205887, 0.068044, 0.432856>, <0.207112, 0.062726, 0.432856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.381725, -0.113398, 0.368918>, <0.385392, -0.112649, 0.372891>, <0.387535, -0.107575, 0.376196>, <0.386443, -0.102228, 0.376196>, 
      <0.420070, -0.103193, 0.333377>, <0.423738, -0.102444, 0.337349>, <0.422398, -0.100614, 0.342631>, <0.421305, -0.095267, 0.342631>, 
      <0.426399, -0.034345, 0.223924>, <0.427281, -0.035170, 0.229247>, <0.423506, -0.034176, 0.233658>, <0.419777, -0.038162, 0.233658>, 
      <0.389944, 0.002891, 0.234980>, <0.390826, 0.002066, 0.240303>, <0.388457, -0.001937, 0.244732>, <0.384728, -0.005923, 0.244732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.143446, -0.062709, 0.463452>, <0.144397, -0.062918, 0.468823>, <0.146162, -0.058655, 0.473292>, <0.147331, -0.053323, 0.473292>, 
      <0.218834, -0.079109, 0.449555>, <0.219785, -0.079317, 0.454925>, <0.222018, -0.074783, 0.459321>, <0.223187, -0.069452, 0.459321>, 
      <0.325295, -0.128416, 0.421222>, <0.328963, -0.127666, 0.425194>, <0.331347, -0.118794, 0.430293>, <0.330254, -0.113447, 0.430293>, 
      <0.381725, -0.113398, 0.368918>, <0.385392, -0.112649, 0.372891>, <0.387535, -0.107575, 0.376196>, <0.386443, -0.102228, 0.376196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094013, -0.009906, 0.456618>, <-0.096670, -0.009540, 0.461371>, <-0.098260, -0.004735, 0.465327>, <-0.097515, 0.000671, 0.465327>, 
      <-0.033355, -0.021462, 0.495565>, <-0.036011, -0.021095, 0.500319>, <-0.036274, -0.013532, 0.507086>, <-0.035528, -0.008126, 0.507086>, 
      <0.073238, -0.047436, 0.476395>, <0.074189, -0.047644, 0.481765>, <0.073717, -0.043251, 0.486634>, <0.074886, -0.037920, 0.486634>, 
      <0.143446, -0.062709, 0.463452>, <0.144397, -0.062918, 0.468823>, <0.146162, -0.058655, 0.473292>, <0.147331, -0.053323, 0.473292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.238235, 0.010000, 0.218382>, <-0.232865, 0.010000, 0.219359>, <-0.228397, 0.005458, 0.220171>, <-0.228397, 0.000000, 0.220171>, 
      <-0.257812, 0.005176, 0.324233>, <-0.252442, 0.005176, 0.325209>, <-0.248776, 0.005620, 0.325472>, <-0.248776, 0.000162, 0.325472>, 
      <-0.163607, 0.003351, 0.411933>, <-0.166264, 0.003717, 0.416687>, <-0.166931, 0.005010, 0.419065>, <-0.166186, 0.010417, 0.419065>, 
      <-0.094013, -0.009906, 0.456618>, <-0.096670, -0.009540, 0.461371>, <-0.098260, -0.004735, 0.465327>, <-0.097515, 0.000671, 0.465327>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013235, 0.010000, 0.019853>, <-0.013235, 0.010000, 0.025311>, <-0.013235, 0.005458, 0.029853>, <-0.013235, 0.000000, 0.029853>, 
      <-0.128997, 0.010000, 0.016637>, <-0.128997, 0.010000, 0.022095>, <-0.124047, 0.005458, 0.026505>, <-0.124047, 0.000000, 0.026505>, 
      <-0.217196, 0.015185, 0.104621>, <-0.211826, 0.015185, 0.105597>, <-0.207332, 0.005290, 0.111328>, <-0.207332, -0.000168, 0.111328>, 
      <-0.238235, 0.010000, 0.218382>, <-0.232865, 0.010000, 0.219359>, <-0.228397, 0.005458, 0.220171>, <-0.228397, 0.000000, 0.220171>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238235, 0.010000, 0.231617>, <0.232931, 0.010000, 0.232903>, <0.228517, 0.005458, 0.233973>, <0.228517, 0.000000, 0.233973>, 
      <0.207942, 0.015599, 0.108534>, <0.202638, 0.015599, 0.109820>, <0.198371, 0.005234, 0.115642>, <0.198371, -0.000224, 0.115642>, 
      <0.113596, 0.010000, 0.023376>, <0.113596, 0.010000, 0.028834>, <0.108820, 0.005458, 0.033540>, <0.108820, 0.000000, 0.033540>, 
      <-0.013235, 0.010000, 0.019853>, <-0.013235, 0.010000, 0.025311>, <-0.013235, 0.005458, 0.029853>, <-0.013235, 0.000000, 0.029853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.094262, -0.009869, 0.456618>, <0.097008, -0.009419, 0.461313>, <0.098560, -0.004563, 0.465220>, <0.097679, 0.000823, 0.465220>, 
      <0.160776, 0.004712, 0.413949>, <0.163522, 0.005161, 0.418644>, <0.164020, 0.006460, 0.421094>, <0.163138, 0.011846, 0.421094>, 
      <0.262917, 0.005438, 0.331901>, <0.257613, 0.005438, 0.333187>, <0.253832, 0.005646, 0.333341>, <0.253832, 0.000188, 0.333341>, 
      <0.238235, 0.010000, 0.231617>, <0.232931, 0.010000, 0.232903>, <0.228517, 0.005458, 0.233973>, <0.228517, 0.000000, 0.233973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.123159, -0.069221, 0.463452>, <-0.123672, -0.069358, 0.468884>, <-0.125269, -0.065083, 0.473405>, <-0.126675, -0.059810, 0.473405>, 
      <-0.058067, -0.052014, 0.469983>, <-0.058580, -0.052151, 0.475415>, <-0.058052, -0.047620, 0.480035>, <-0.059458, -0.042346, 0.480035>, 
      <0.038271, -0.022142, 0.492536>, <0.041018, -0.021693, 0.497231>, <0.041268, -0.014210, 0.503840>, <0.040386, -0.008824, 0.503840>, 
      <0.094262, -0.009869, 0.456618>, <0.097008, -0.009419, 0.461313>, <0.098560, -0.004563, 0.465220>, <0.097679, 0.000823, 0.465220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.297576, -0.113451, 0.417305>, <-0.300317, -0.112972, 0.422000>, <-0.301816, -0.108099, 0.425907>, <-0.300876, -0.102723, 0.425907>, 
      <-0.250185, -0.123562, 0.444828>, <-0.252926, -0.123083, 0.449524>, <-0.254662, -0.116356, 0.454338>, <-0.253722, -0.110979, 0.454338>, 
      <-0.176785, -0.083397, 0.458072>, <-0.177298, -0.083534, 0.463504>, <-0.178913, -0.079020, 0.468114>, <-0.180319, -0.073746, 0.468114>, 
      <-0.123159, -0.069221, 0.463452>, <-0.123672, -0.069358, 0.468884>, <-0.125269, -0.065083, 0.473405>, <-0.126675, -0.059810, 0.473405>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.449894, 0.000486, 0.273689>, <-0.449986, 0.000323, 0.279143>, <-0.446103, -0.002038, 0.283683>, <-0.441344, -0.004711, 0.283683>, 
      <-0.482957, -0.062874, 0.271458>, <-0.483049, -0.063037, 0.276913>, <-0.479268, -0.059955, 0.281121>, <-0.474509, -0.062628, 0.281121>, 
      <-0.358381, -0.100479, 0.381990>, <-0.361122, -0.100000, 0.386685>, <-0.358381, -0.098195, 0.391803>, <-0.357441, -0.092818, 0.391803>, 
      <-0.297576, -0.113451, 0.417305>, <-0.300317, -0.112972, 0.422000>, <-0.301816, -0.108099, 0.425907>, <-0.300876, -0.102723, 0.425907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.201022, 0.071579, 0.423819>, <-0.202860, 0.071938, 0.428945>, <-0.205261, 0.067779, 0.433212>, <-0.206308, 0.062423, 0.433212>, 
      <-0.284116, 0.086946, 0.393537>, <-0.285954, 0.087306, 0.398663>, <-0.284508, 0.083165, 0.403665>, <-0.285555, 0.077809, 0.403665>, 
      <-0.408387, 0.080029, 0.276489>, <-0.408478, 0.079866, 0.281944>, <-0.403417, 0.072506, 0.286980>, <-0.398658, 0.069832, 0.286980>, 
      <-0.449894, 0.000486, 0.273689>, <-0.449986, 0.000323, 0.279143>, <-0.446103, -0.002038, 0.283683>, <-0.441344, -0.004711, 0.283683>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.179366, -0.115893, 0.503013>, <0.178462, -0.115446, 0.508377>, <0.175699, -0.119148, 0.512841>, <0.173282, -0.124041, 0.512841>, 
      <0.065249, -0.059651, 0.479255>, <0.064346, -0.059205, 0.484619>, <0.061822, -0.063208, 0.488952>, <0.059405, -0.068102, 0.488952>, 
      <-0.081219, 0.049421, 0.467480>, <-0.083057, 0.049781, 0.472606>, <-0.086245, 0.044672, 0.477586>, <-0.087292, 0.039316, 0.477586>, 
      <-0.201022, 0.071579, 0.423819>, <-0.202860, 0.071938, 0.428945>, <-0.205261, 0.067779, 0.433212>, <-0.206308, 0.062423, 0.433212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.207112, 0.062726, 0.432856>, <0.208338, 0.057407, 0.432856>, <0.207463, 0.052544, 0.428752>, <0.205186, 0.052020, 0.423819>, 
      <0.093860, 0.037114, 0.487923>, <0.095086, 0.031796, 0.487923>, <0.096166, 0.026032, 0.483997>, <0.093889, 0.025507, 0.479064>, 
      <-0.054536, -0.072615, 0.488844>, <-0.052016, -0.077456, 0.488844>, <-0.052136, -0.082168, 0.484618>, <-0.053036, -0.082637, 0.479255>, 
      <-0.166671, -0.130618, 0.512839>, <-0.164151, -0.135460, 0.512839>, <-0.162803, -0.139878, 0.508376>, <-0.163703, -0.140347, 0.503013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.384728, -0.005923, 0.244732>, <0.380999, -0.009909, 0.244732>, <0.377163, -0.012540, 0.240303>, <0.376281, -0.011715, 0.234980>, 
      <0.327162, 0.047028, 0.262921>, <0.323433, 0.043042, 0.262921>, <0.318681, 0.036888, 0.258912>, <0.317799, 0.037713, 0.253589>, 
      <0.277882, 0.078730, 0.398446>, <0.279108, 0.073411, 0.398446>, <0.276493, 0.068988, 0.394487>, <0.274216, 0.068464, 0.389554>, 
      <0.207112, 0.062726, 0.432856>, <0.208338, 0.057407, 0.432856>, <0.207463, 0.052544, 0.428752>, <0.205186, 0.052020, 0.423819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.386443, -0.102228, 0.376196>, <0.385350, -0.096880, 0.376196>, <0.381389, -0.093054, 0.372891>, <0.377721, -0.093803, 0.368918>, 
      <0.421305, -0.095267, 0.342631>, <0.420212, -0.089919, 0.342631>, <0.414563, -0.088487, 0.339727>, <0.410896, -0.089237, 0.335755>, 
      <0.419777, -0.038162, 0.233658>, <0.416048, -0.042148, 0.233658>, <0.412140, -0.042102, 0.229173>, <0.411259, -0.041277, 0.223850>, 
      <0.384728, -0.005923, 0.244732>, <0.380999, -0.009909, 0.244732>, <0.377163, -0.012540, 0.240303>, <0.376281, -0.011715, 0.234980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.147331, -0.053323, 0.473292>, <0.148500, -0.047992, 0.473292>, <0.148682, -0.043382, 0.468823>, <0.147730, -0.043173, 0.463452>, 
      <0.223187, -0.069452, 0.459321>, <0.224356, -0.064121, 0.459321>, <0.221806, -0.059552, 0.455149>, <0.220855, -0.059343, 0.449779>, 
      <0.330254, -0.113447, 0.430293>, <0.329162, -0.108099, 0.430293>, <0.327802, -0.100430, 0.426459>, <0.324134, -0.101179, 0.422487>, 
      <0.386443, -0.102228, 0.376196>, <0.385350, -0.096880, 0.376196>, <0.381389, -0.093054, 0.372891>, <0.377721, -0.093803, 0.368918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.097515, 0.000671, 0.465327>, <-0.096769, 0.006078, 0.465327>, <-0.093937, 0.010273, 0.461371>, <-0.091281, 0.009906, 0.456618>, 
      <-0.035528, -0.008126, 0.507086>, <-0.034782, -0.002719, 0.507086>, <-0.032069, 0.004955, 0.500655>, <-0.029412, 0.004589, 0.495901>, 
      <0.074886, -0.037920, 0.486634>, <0.076055, -0.032589, 0.486634>, <0.078103, -0.027775, 0.482020>, <0.077151, -0.027566, 0.476650>, 
      <0.147331, -0.053323, 0.473292>, <0.148500, -0.047992, 0.473292>, <0.148682, -0.043382, 0.468823>, <0.147730, -0.043173, 0.463452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.228397, 0.000000, 0.220171>, <-0.228397, -0.005458, 0.220171>, <-0.232865, -0.010000, 0.219359>, <-0.238235, -0.010000, 0.218382>, 
      <-0.248776, 0.000162, 0.325472>, <-0.248776, -0.005296, 0.325472>, <-0.251897, -0.005146, 0.325865>, <-0.257267, -0.005146, 0.324889>, 
      <-0.166186, 0.010417, 0.419065>, <-0.165440, 0.015824, 0.419065>, <-0.164821, 0.016365, 0.416363>, <-0.162164, 0.015999, 0.411610>, 
      <-0.097515, 0.000671, 0.465327>, <-0.096769, 0.006078, 0.465327>, <-0.093937, 0.010273, 0.461371>, <-0.091281, 0.009906, 0.456618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013235, 0.000000, 0.029853>, <-0.013235, -0.005458, 0.029853>, <-0.013235, -0.010000, 0.025311>, <-0.013235, -0.010000, 0.019853>, 
      <-0.124047, 0.000000, 0.026505>, <-0.124047, -0.005458, 0.026505>, <-0.128997, -0.010000, 0.022095>, <-0.128997, -0.010000, 0.016637>, 
      <-0.207332, -0.000168, 0.111328>, <-0.207332, -0.005626, 0.111328>, <-0.212515, -0.015190, 0.105472>, <-0.217885, -0.015190, 0.104496>, 
      <-0.228397, 0.000000, 0.220171>, <-0.228397, -0.005458, 0.220171>, <-0.232865, -0.010000, 0.219359>, <-0.238235, -0.010000, 0.218382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.228517, 0.000000, 0.233973>, <0.228517, -0.005458, 0.233973>, <0.232931, -0.010000, 0.232903>, <0.238235, -0.010000, 0.231617>, 
      <0.198371, -0.000224, 0.115642>, <0.198371, -0.005682, 0.115642>, <0.203498, -0.015609, 0.109612>, <0.208802, -0.015609, 0.108326>, 
      <0.108820, 0.000000, 0.033540>, <0.108820, -0.005458, 0.033540>, <0.113596, -0.010000, 0.028834>, <0.113596, -0.010000, 0.023376>, 
      <-0.013235, 0.000000, 0.029853>, <-0.013235, -0.005458, 0.029853>, <-0.013235, -0.010000, 0.025311>, <-0.013235, -0.010000, 0.019853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.097679, 0.000823, 0.465220>, <0.096797, 0.006210, 0.465220>, <0.093779, 0.010318, 0.461313>, <0.091032, 0.009869, 0.456618>, 
      <0.163138, 0.011846, 0.421094>, <0.162257, 0.017232, 0.421094>, <0.161848, 0.017727, 0.418260>, <0.159102, 0.017278, 0.413564>, 
      <0.253832, 0.000188, 0.333341>, <0.253832, -0.005270, 0.333341>, <0.257068, -0.005400, 0.334012>, <0.262373, -0.005400, 0.332727>, 
      <0.228517, 0.000000, 0.233973>, <0.228517, -0.005458, 0.233973>, <0.232931, -0.010000, 0.232903>, <0.238235, -0.010000, 0.231617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.126675, -0.059810, 0.473405>, <-0.128082, -0.054536, 0.473405>, <-0.128825, -0.050033, 0.468884>, <-0.128312, -0.049896, 0.463452>, 
      <-0.059458, -0.042346, 0.480035>, <-0.060865, -0.037073, 0.480035>, <-0.063253, -0.032393, 0.475577>, <-0.062739, -0.032256, 0.470145>, 
      <0.040386, -0.008824, 0.503840>, <0.039505, -0.003438, 0.503840>, <0.036354, 0.004068, 0.497632>, <0.033608, 0.003619, 0.492937>, 
      <0.097679, 0.000823, 0.465220>, <0.096797, 0.006210, 0.465220>, <0.093779, 0.010318, 0.461313>, <0.091032, 0.009869, 0.456618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.300876, -0.102723, 0.425907>, <-0.299936, -0.097346, 0.425907>, <-0.296873, -0.093271, 0.422000>, <-0.294132, -0.093750, 0.417305>, 
      <-0.253722, -0.110979, 0.454338>, <-0.252782, -0.105603, 0.454338>, <-0.251951, -0.099265, 0.450028>, <-0.249210, -0.099745, 0.445332>, 
      <-0.180319, -0.073746, 0.468114>, <-0.181726, -0.068473, 0.468114>, <-0.180033, -0.063810, 0.463658>, <-0.179520, -0.063673, 0.458226>, 
      <-0.126675, -0.059810, 0.473405>, <-0.128082, -0.054536, 0.473405>, <-0.128825, -0.050033, 0.468884>, <-0.128312, -0.049896, 0.463452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.441344, -0.004711, 0.283683>, <-0.436586, -0.007385, 0.283683>, <-0.432550, -0.009474, 0.279143>, <-0.432458, -0.009310, 0.273689>, 
      <-0.474509, -0.062628, 0.281121>, <-0.469751, -0.065302, 0.281121>, <-0.466464, -0.064825, 0.276669>, <-0.466372, -0.064662, 0.271214>, 
      <-0.357441, -0.092818, 0.391803>, <-0.356501, -0.087442, 0.391803>, <-0.351637, -0.085963, 0.387831>, <-0.348896, -0.086442, 0.383136>, 
      <-0.300876, -0.102723, 0.425907>, <-0.299936, -0.097346, 0.425907>, <-0.296873, -0.093271, 0.422000>, <-0.294132, -0.093750, 0.417305>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.206308, 0.062423, 0.433212>, <-0.207356, 0.057066, 0.433212>, <-0.206698, 0.052310, 0.428945>, <-0.204860, 0.051950, 0.423819>, 
      <-0.285555, 0.077809, 0.403665>, <-0.286602, 0.072452, 0.403665>, <-0.283637, 0.068198, 0.399684>, <-0.281799, 0.067838, 0.394557>, 
      <-0.398658, 0.069832, 0.286980>, <-0.393900, 0.067159, 0.286980>, <-0.388782, 0.061959, 0.282337>, <-0.388690, 0.062122, 0.276882>, 
      <-0.441344, -0.004711, 0.283683>, <-0.436586, -0.007385, 0.283683>, <-0.432550, -0.009474, 0.279143>, <-0.432458, -0.009310, 0.273689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.173282, -0.124041, 0.512841>, <0.170865, -0.128935, 0.512841>, <0.169606, -0.133379, 0.508377>, <0.170510, -0.133825, 0.503013>, 
      <0.059405, -0.068102, 0.488952>, <0.056988, -0.072996, 0.488952>, <0.056995, -0.077646, 0.484619>, <0.057899, -0.078092, 0.479255>, 
      <-0.087292, 0.039316, 0.477586>, <-0.088339, 0.033959, 0.477586>, <-0.089342, 0.028075, 0.473579>, <-0.087504, 0.027716, 0.468452>, 
      <-0.206308, 0.062423, 0.433212>, <-0.207356, 0.057066, 0.433212>, <-0.206698, 0.052310, 0.428945>, <-0.204860, 0.051950, 0.423819>
    }
  }
  material {
    cuerdas_txt_1
  }
  photons {
    collect off
  }
}
#declare sPatchObj2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.040893, 0.650554, 0.168750>, <0.006672, 0.650554, 0.165243>, <0.082368, 0.650554, 0.106869>, <0.117657, 0.650554, 0.157061>, 
      <-0.041780, 0.964808, 0.170715>, <0.005785, 0.964808, 0.167209>, <0.085666, 0.964867, 0.108526>, <0.120954, 0.964867, 0.158719>, 
      <-0.045600, 1.383741, 0.179176>, <0.011478, 1.383741, 0.174968>, <0.092800, 1.383741, 0.105620>, <0.135147, 1.383741, 0.165851>, 
      <-0.047617, 1.697964, 0.183645>, <0.009461, 1.697964, 0.179437>, <0.100296, 1.697964, 0.109387>, <0.142643, 1.697964, 0.169618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.040893, -0.683576, 0.168750>, <0.006672, -0.683576, 0.165243>, <0.082368, -0.683576, 0.106869>, <0.117657, -0.683576, 0.157061>, 
      <-0.039355, -0.283345, 0.166844>, <0.008210, -0.283345, 0.163338>, <0.076652, -0.283380, 0.105498>, <0.111941, -0.283380, 0.155691>, 
      <-0.039763, 0.250324, 0.166247>, <0.007802, 0.250324, 0.162740>, <0.078169, 0.250342, 0.104759>, <0.113458, 0.250342, 0.154951>, 
      <-0.040893, 0.650554, 0.168750>, <0.006672, 0.650554, 0.165243>, <0.082368, 0.650554, 0.106869>, <0.117657, 0.650554, 0.157061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117657, 0.650554, 0.157061>, <0.161163, 0.650554, 0.218943>, <0.148193, 0.650554, 0.306188>, <0.086995, 0.650554, 0.350651>, 
      <0.120954, 0.964867, 0.158719>, <0.164461, 0.964867, 0.220600>, <0.150683, 0.965121, 0.312960>, <0.089485, 0.965121, 0.357423>, 
      <0.135147, 1.383741, 0.165851>, <0.187355, 1.383741, 0.240109>, <0.173630, 1.383741, 0.333188>, <0.100193, 1.383741, 0.386543>, 
      <0.142643, 1.697964, 0.169618>, <0.194851, 1.697964, 0.243876>, <0.179287, 1.697964, 0.348570>, <0.105849, 1.697964, 0.401925>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117657, -0.683576, 0.157061>, <0.161163, -0.683576, 0.218943>, <0.148193, -0.683576, 0.306188>, <0.086995, -0.683576, 0.350651>, 
      <0.111941, -0.283380, 0.155691>, <0.155448, -0.283380, 0.217572>, <0.143881, -0.283491, 0.295963>, <0.082683, -0.283491, 0.340426>, 
      <0.113458, 0.250342, 0.154951>, <0.156965, 0.250342, 0.216833>, <0.145025, 0.250420, 0.297573>, <0.083827, 0.250420, 0.342036>, 
      <0.117657, 0.650554, 0.157061>, <0.161163, 0.650554, 0.218943>, <0.148193, 0.650554, 0.306188>, <0.086995, 0.650554, 0.350651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.086995, 0.650554, 0.350651>, <0.025797, 0.650554, 0.395114>, <-0.065528, 0.650554, 0.383516>, <-0.106594, 0.650554, 0.319989>, 
      <0.089485, 0.965121, 0.357423>, <0.028288, 0.965121, 0.401886>, <-0.068151, 0.965057, 0.389478>, <-0.109217, 0.965057, 0.325951>, 
      <0.100193, 1.383741, 0.386543>, <0.026756, 1.383741, 0.439899>, <-0.071219, 1.383741, 0.427821>, <-0.120499, 1.383741, 0.351589>, 
      <0.105849, 1.697964, 0.401925>, <0.032412, 1.697964, 0.455281>, <-0.077178, 1.697964, 0.441364>, <-0.126458, 1.697964, 0.365132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.086995, -0.683576, 0.350651>, <0.025797, -0.683576, 0.395114>, <-0.065528, -0.683576, 0.383516>, <-0.106594, -0.683576, 0.319989>, 
      <0.082683, -0.283491, 0.340426>, <0.021486, -0.283491, 0.384889>, <-0.060985, -0.283460, 0.374693>, <-0.102051, -0.283460, 0.311166>, 
      <0.083827, 0.250420, 0.342036>, <0.022630, 0.250420, 0.386499>, <-0.062190, 0.250401, 0.375931>, <-0.103256, 0.250401, 0.312404>, 
      <0.086995, 0.650554, 0.350651>, <0.025797, 0.650554, 0.395114>, <-0.065528, 0.650554, 0.383516>, <-0.106594, 0.650554, 0.319989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.106594, 0.650554, 0.319989>, <-0.156214, 0.650554, 0.243230>, <-0.158937, 0.650554, 0.138265>, <-0.085299, 0.650554, 0.084122>, 
      <-0.109217, 0.965057, 0.325951>, <-0.158837, 0.965057, 0.249192>, <-0.160996, 0.964805, 0.137997>, <-0.087358, 0.964805, 0.083854>, 
      <-0.120499, 1.383741, 0.351589>, <-0.180042, 1.383741, 0.259478>, <-0.184588, 1.383741, 0.147672>, <-0.096223, 1.383741, 0.082700>, 
      <-0.126458, 1.697964, 0.365132>, <-0.186002, 1.697964, 0.273021>, <-0.189269, 1.697964, 0.147063>, <-0.100904, 1.697964, 0.082091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.106594, -0.683576, 0.319989>, <-0.156214, -0.683576, 0.243230>, <-0.158937, -0.683576, 0.138265>, <-0.085299, -0.683576, 0.084122>, 
      <-0.102051, -0.283460, 0.311166>, <-0.151671, -0.283460, 0.234407>, <-0.155367, -0.283358, 0.140232>, <-0.081729, -0.283358, 0.086088>, 
      <-0.103256, 0.250401, 0.312404>, <-0.152876, 0.250401, 0.235645>, <-0.156314, 0.250323, 0.138607>, <-0.082677, 0.250323, 0.084463>, 
      <-0.106594, 0.650554, 0.319989>, <-0.156214, 0.650554, 0.243230>, <-0.158937, 0.650554, 0.138265>, <-0.085299, 0.650554, 0.084122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.085299, 0.650554, 0.084122>, <0.001765, 0.650554, 0.020106>, <0.134533, 0.650554, 0.008716>, <0.194326, 0.650554, 0.098732>, 
      <-0.087358, 0.964805, 0.083854>, <-0.000295, 0.964805, 0.019838>, <0.139856, 0.964965, 0.008834>, <0.199649, 0.964965, 0.098850>, 
      <-0.096223, 1.383741, 0.082700>, <0.008254, 1.383741, 0.005882>, <0.150798, 1.383741, -0.008663>, <0.222550, 1.383741, 0.099356>, 
      <-0.100904, 1.697964, 0.082091>, <0.003573, 1.697964, 0.005273>, <0.162894, 1.697964, -0.008396>, <0.234646, 1.697964, 0.099623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.085299, -0.683576, 0.084122>, <0.001765, -0.683576, 0.020106>, <0.134533, -0.683576, 0.008716>, <0.194326, -0.683576, 0.098732>, 
      <-0.081729, -0.283358, 0.086088>, <0.005334, -0.283358, 0.022073>, <0.125311, -0.283445, 0.010014>, <0.185104, -0.283445, 0.100030>, 
      <-0.082677, 0.250323, 0.084463>, <0.004387, 0.250323, 0.020448>, <0.127758, 0.250372, 0.008566>, <0.187550, 0.250372, 0.098582>, 
      <-0.085299, 0.650554, 0.084122>, <0.001765, 0.650554, 0.020106>, <0.134533, 0.650554, 0.008716>, <0.194326, 0.650554, 0.098732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.194326, 0.650554, 0.098732>, <0.265265, 0.650554, 0.205530>, <0.241662, 0.650554, 0.345753>, <0.142357, 0.650554, 0.426849>, 
      <0.199649, 0.964965, 0.098850>, <0.270589, 0.964965, 0.205647>, <0.245619, 0.965390, 0.354546>, <0.146313, 0.965390, 0.435643>, 
      <0.222550, 1.383741, 0.099356>, <0.307677, 1.383741, 0.227513>, <0.282472, 1.383741, 0.376094>, <0.163305, 1.383741, 0.473410>, 
      <0.234646, 1.697964, 0.099623>, <0.319774, 1.697964, 0.227780>, <0.291450, 1.697964, 0.396049>, <0.172283, 1.697964, 0.493364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.194326, -0.683576, 0.098732>, <0.265265, -0.683576, 0.205530>, <0.241662, -0.683576, 0.345753>, <0.142357, -0.683576, 0.426849>, 
      <0.185104, -0.283445, 0.100030>, <0.256044, -0.283445, 0.206827>, <0.234821, -0.283630, 0.332048>, <0.135516, -0.283630, 0.413145>, 
      <0.187550, 0.250372, 0.098582>, <0.258490, 0.250372, 0.205380>, <0.236635, 0.250502, 0.334580>, <0.137330, 0.250502, 0.415676>, 
      <0.194326, 0.650554, 0.098732>, <0.265265, 0.650554, 0.205530>, <0.241662, 0.650554, 0.345753>, <0.142357, 0.650554, 0.426849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.142357, 0.650554, 0.426849>, <0.047057, 0.650554, 0.504675>, <-0.071550, 0.650554, 0.466668>, <-0.175372, 0.650554, 0.400639>, 
      <0.146313, 0.965390, 0.435643>, <0.051013, 0.965390, 0.513468>, <-0.075994, 0.965340, 0.474767>, <-0.179816, 0.965340, 0.408738>, 
      <0.163305, 1.383741, 0.473410>, <0.048945, 1.383741, 0.566800>, <-0.074319, 1.383741, 0.522765>, <-0.198906, 1.383741, 0.443530>, 
      <0.172283, 1.697964, 0.493364>, <0.057923, 1.697964, 0.586754>, <-0.084405, 1.697964, 0.541147>, <-0.208992, 1.697964, 0.461912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.142357, -0.683576, 0.426849>, <0.047057, -0.683576, 0.504675>, <-0.071550, -0.683576, 0.466668>, <-0.175372, -0.683576, 0.400639>, 
      <0.135516, -0.283630, 0.413145>, <0.040215, -0.283630, 0.490970>, <-0.063864, -0.283606, 0.454161>, <-0.167686, -0.283606, 0.388132>, 
      <0.137330, 0.250502, 0.415676>, <0.042030, 0.250502, 0.493502>, <-0.065902, 0.250487, 0.456376>, <-0.169725, 0.250487, 0.390346>, 
      <0.142357, 0.650554, 0.426849>, <0.047057, 0.650554, 0.504675>, <-0.071550, 0.650554, 0.466668>, <-0.175372, 0.650554, 0.400639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175372, 0.650554, 0.400639>, <-0.244983, 0.650554, 0.356368>, <-0.229874, 0.650554, 0.275243>, <-0.225561, 0.650554, 0.192860>, 
      <-0.179816, 0.965340, 0.408738>, <-0.249427, 0.965340, 0.364467>, <-0.235639, 0.965042, 0.277847>, <-0.231326, 0.965042, 0.195463>, 
      <-0.198906, 1.383741, 0.443530>, <-0.282439, 1.383741, 0.390404>, <-0.255549, 1.383741, 0.305655>, <-0.256121, 1.383741, 0.206661>, 
      <-0.208992, 1.697964, 0.461912>, <-0.292525, 1.697964, 0.408786>, <-0.268646, 1.697964, 0.311570>, <-0.269218, 1.697964, 0.212576>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175372, -0.683576, 0.400639>, <-0.244983, -0.683576, 0.356368>, <-0.229874, -0.683576, 0.275243>, <-0.225561, -0.683576, 0.192860>, 
      <-0.167686, -0.283606, 0.388132>, <-0.237297, -0.283606, 0.343861>, <-0.219890, -0.283473, 0.272235>, <-0.215577, -0.283473, 0.189852>, 
      <-0.169725, 0.250487, 0.390346>, <-0.239336, 0.250487, 0.346075>, <-0.222538, 0.250396, 0.271930>, <-0.218225, 0.250396, 0.189547>, 
      <-0.175372, 0.650554, 0.400639>, <-0.244983, 0.650554, 0.356368>, <-0.229874, 0.650554, 0.275243>, <-0.225561, 0.650554, 0.192860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225561, 0.650554, 0.192860>, <-0.222569, 0.650554, 0.135712>, <-0.177985, 0.650554, 0.100612>, <-0.157595, 0.650554, 0.061077>, 
      <-0.231326, 0.965042, 0.195463>, <-0.228334, 0.965042, 0.138316>, <-0.185105, 0.965218, 0.096604>, <-0.164715, 0.965218, 0.057069>, 
      <-0.256121, 1.383741, 0.206661>, <-0.256546, 1.383741, 0.133034>, <-0.212637, 1.383741, 0.094394>, <-0.195317, 1.383741, 0.039844>, 
      <-0.269218, 1.697964, 0.212576>, <-0.269643, 1.697964, 0.138949>, <-0.228803, 1.697964, 0.085294>, <-0.211483, 1.697964, 0.030744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225561, -0.683576, 0.192860>, <-0.222569, -0.683576, 0.135712>, <-0.177985, -0.683576, 0.100612>, <-0.157595, -0.683576, 0.061077>, 
      <-0.215577, -0.283473, 0.189852>, <-0.212585, -0.283473, 0.132705>, <-0.166790, -0.283560, 0.107929>, <-0.146400, -0.283560, 0.068394>, 
      <-0.218225, 0.250396, 0.189547>, <-0.215234, 0.250396, 0.132399>, <-0.168932, 0.250450, 0.105708>, <-0.148542, 0.250450, 0.066173>, 
      <-0.225561, 0.650554, 0.192860>, <-0.222569, 0.650554, 0.135712>, <-0.177985, 0.650554, 0.100612>, <-0.157595, 0.650554, 0.061077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117657, -0.683576, 0.157061>, <0.121911, -0.981419, 0.158082>, <0.140915, -1.378206, 0.162639>, <0.150883, -1.675904, 0.165030>, 
      <0.082368, -0.683576, 0.106869>, <0.086622, -0.981419, 0.107889>, <0.096241, -1.378206, 0.099098>, <0.106209, -1.675904, 0.101488>, 
      <0.006672, -0.683576, 0.165243>, <0.005528, -0.981299, 0.166661>, <0.013063, -1.378206, 0.172065>, <0.010381, -1.675904, 0.175388>, 
      <-0.040893, -0.683576, 0.168750>, <-0.042037, -0.981299, 0.170168>, <-0.047152, -1.378206, 0.176504>, <-0.049834, -1.675904, 0.179827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.086995, -0.683576, 0.350651>, <0.090209, -0.981788, 0.358272>, <0.104546, -1.378206, 0.392269>, <0.112067, -1.675904, 0.410106>, 
      <0.148193, -0.683576, 0.306188>, <0.151407, -0.981788, 0.313809>, <0.182019, -1.378206, 0.335981>, <0.189541, -1.675904, 0.353818>, 
      <0.161163, -0.683576, 0.218943>, <0.165417, -0.981419, 0.219963>, <0.195993, -1.378206, 0.240979>, <0.205961, -1.675904, 0.243369>, 
      <0.117657, -0.683576, 0.157061>, <0.121911, -0.981419, 0.158082>, <0.140915, -1.378206, 0.162639>, <0.150883, -1.675904, 0.165030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.106594, -0.683576, 0.319989>, <-0.109979, -0.981686, 0.326563>, <-0.125084, -1.378206, 0.355899>, <-0.133009, -1.675904, 0.371289>, 
      <-0.065528, -0.683576, 0.383516>, <-0.068913, -0.981686, 0.390090>, <-0.073096, -1.378206, 0.436322>, <-0.081020, -1.675904, 0.451712>, 
      <0.025797, -0.683576, 0.395114>, <0.029011, -0.981788, 0.402735>, <0.027072, -1.378206, 0.448557>, <0.034593, -1.675904, 0.466394>, 
      <0.086995, -0.683576, 0.350651>, <0.090209, -0.981788, 0.358272>, <0.104546, -1.378206, 0.392269>, <0.112067, -1.675904, 0.410106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.085299, -0.683576, 0.084122>, <-0.087955, -0.981344, 0.082659>, <-0.099825, -1.378206, 0.076120>, <-0.106050, -1.675904, 0.072691>, 
      <-0.158937, -0.683576, 0.138265>, <-0.161593, -0.981344, 0.136802>, <-0.193047, -1.378206, 0.144664>, <-0.199272, -1.675904, 0.141235>, 
      <-0.156214, -0.683576, 0.243230>, <-0.159599, -0.981686, 0.249804>, <-0.187901, -1.378206, 0.258726>, <-0.195825, -1.675904, 0.274116>, 
      <-0.106594, -0.683576, 0.319989>, <-0.109979, -0.981686, 0.326563>, <-0.125084, -1.378206, 0.355899>, <-0.133009, -1.675904, 0.371289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.194326, -0.683576, 0.098732>, <0.201195, -0.981637, 0.097766>, <0.231858, -1.378206, 0.093451>, <0.247943, -1.675904, 0.091188>, 
      <0.134533, -0.683576, 0.008716>, <0.141402, -0.981637, 0.007750>, <0.156162, -1.378206, -0.020505>, <0.172248, -1.675904, -0.022769>, 
      <0.001765, -0.683576, 0.020106>, <-0.000891, -0.981344, 0.018644>, <0.010394, -1.378206, -0.004920>, <0.004169, -1.675904, -0.008349>, 
      <-0.085299, -0.683576, 0.084122>, <-0.087955, -0.981344, 0.082659>, <-0.099825, -1.378206, 0.076120>, <-0.106050, -1.675904, 0.072691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.142357, -0.683576, 0.426849>, <0.147466, -0.982253, 0.437084>, <0.170214, -1.378206, 0.482654>, <0.182153, -1.675904, 0.506570>, 
      <0.241662, -0.683576, 0.345753>, <0.246772, -0.982253, 0.355988>, <0.295930, -1.378206, 0.379990>, <0.307869, -1.675904, 0.403906>, 
      <0.265265, -0.683576, 0.205530>, <0.272135, -0.981637, 0.204563>, <0.321665, -1.378206, 0.228652>, <0.337750, -1.675904, 0.226389>, 
      <0.194326, -0.683576, 0.098732>, <0.201195, -0.981637, 0.097766>, <0.231858, -1.378206, 0.093451>, <0.247943, -1.675904, 0.091188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175372, -0.683576, 0.400639>, <-0.181110, -0.982174, 0.409977>, <-0.206667, -1.378206, 0.451564>, <-0.220079, -1.675904, 0.473389>, 
      <-0.071550, -0.683576, 0.466668>, <-0.077288, -0.982174, 0.476006>, <-0.075232, -1.378206, 0.535154>, <-0.088645, -1.675904, 0.556979>, 
      <0.047057, -0.683576, 0.504675>, <0.052166, -0.982253, 0.514910>, <0.049568, -1.378206, 0.581177>, <0.061507, -1.675904, 0.605094>, 
      <0.142357, -0.683576, 0.426849>, <0.147466, -0.982253, 0.437084>, <0.170214, -1.378206, 0.482654>, <0.182153, -1.675904, 0.506570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225561, -0.683576, 0.192860>, <-0.233001, -0.981728, 0.195101>, <-0.266199, -1.378206, 0.205102>, <-0.283616, -1.675904, 0.210349>, 
      <-0.229874, -0.683576, 0.275243>, <-0.237314, -0.981728, 0.277484>, <-0.265596, -1.378206, 0.309537>, <-0.283012, -1.675904, 0.314784>, 
      <-0.244983, -0.683576, 0.356368>, <-0.250721, -0.982174, 0.365705>, <-0.294791, -1.378206, 0.395519>, <-0.308203, -1.675904, 0.417343>, 
      <-0.175372, -0.683576, 0.400639>, <-0.181110, -0.982174, 0.409977>, <-0.206667, -1.378206, 0.451564>, <-0.220079, -1.675904, 0.473389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.157595, -0.683576, 0.061077>, <-0.165948, -0.982021, 0.055618>, <-0.203174, -1.378206, 0.031289>, <-0.222707, -1.675904, 0.018523>, 
      <-0.177985, -0.683576, 0.100612>, <-0.186338, -0.982021, 0.095153>, <-0.221446, -1.378206, 0.088837>, <-0.240980, -1.675904, 0.076070>, 
      <-0.222569, -0.683576, 0.135712>, <-0.230009, -0.981728, 0.137954>, <-0.266648, -1.378206, 0.127428>, <-0.284065, -1.675904, 0.132675>, 
      <-0.225561, -0.683576, 0.192860>, <-0.233001, -0.981728, 0.195101>, <-0.266199, -1.378206, 0.205102>, <-0.283616, -1.675904, 0.210349>
    }
  }
  material {
    amarillo
  }
  photons {
    collect off
  }
}
#declare rollo1 = union {
  object { sPatchObj }
  object { sPatchObj2 }
  photons {
    collect off
  }
  scale 0.3
  rotate -28.975891*z
  translate  <2.267509, 9.422581, -2.836211>
}


#declare Cylndr113 = object {
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    material {
      carriles_txt
    }
    photons {
      collect off
    }
    scale <0.425, 0.425, 0.21>
    rotate 90.0*x
    translate  <-0.001665, 0.462124, 11.566681>
  }
}


#declare Sphere003 = object {
  sphere { // Sphere003
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.05, 0.01, 0.05>
    translate  <-0.206807, -0.092821, 1.444663>
  }
}
#declare Sphere015 = object {
  sphere { // Sphere015
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.005, 0.02, 0.02>
    translate  <0.064677, 0.074283, 0.999532>
  }
}
#declare casco_estribor = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.309380, 0.724586, 0.985265>, <0.435296, 0.722317, 0.986341>, <0.603849, 0.713848, 0.989199>, <0.727861, 0.692364, 0.993740>, 
      <0.310731, 0.729408, 0.992610>, <0.436647, 0.727138, 0.993686>, <0.607710, 0.718456, 0.996595>, <0.731723, 0.696972, 1.001136>, 
      <0.313656, 0.748973, 1.006613>, <0.442092, 0.746653, 1.007711>, <0.613597, 0.738333, 1.010431>, <0.740123, 0.716569, 1.014895>, 
      <0.313882, 0.740658, 1.009749>, <0.442319, 0.738338, 1.010846>, <0.614207, 0.729487, 1.013929>, <0.740733, 0.707724, 1.018393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312367, 0.670430, 0.496896>, <0.439561, 0.668386, 0.499038>, <0.610518, 0.665401, 0.506147>, <0.735075, 0.640612, 0.513760>, 
      <0.311856, 0.711415, 0.638494>, <0.439050, 0.709372, 0.640636>, <0.609309, 0.706487, 0.645037>, <0.733866, 0.681698, 0.652650>, 
      <0.310276, 0.708339, 0.838754>, <0.436193, 0.706070, 0.839831>, <0.606013, 0.698322, 0.845205>, <0.730025, 0.676839, 0.849746>, 
      <0.309380, 0.724586, 0.985265>, <0.435296, 0.722317, 0.986341>, <0.603849, 0.713848, 0.989199>, <0.727861, 0.692364, 0.993740>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312367, 0.484993, 0.157508>, <0.439623, 0.482173, 0.153925>, <0.610359, 0.471035, 0.155332>, <0.735075, 0.447197, 0.164958>, 
      <0.312367, 0.571581, 0.234734>, <0.439623, 0.568762, 0.231151>, <0.610359, 0.557293, 0.238253>, <0.735075, 0.533456, 0.247879>, 
      <0.312769, 0.638171, 0.385448>, <0.439963, 0.636128, 0.387590>, <0.611516, 0.631461, 0.391415>, <0.736074, 0.606672, 0.399027>, 
      <0.312367, 0.670430, 0.496896>, <0.439561, 0.668386, 0.499038>, <0.610518, 0.665401, 0.506147>, <0.735075, 0.640612, 0.513760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312367, 0.051831, -0.054818>, <0.439136, 0.051343, -0.058203>, <0.608261, 0.049537, -0.054818>, <0.735075, 0.049148, -0.054818>, 
      <0.312367, 0.172812, 0.024602>, <0.439136, 0.172324, 0.021216>, <0.608261, 0.159642, 0.025705>, <0.735075, 0.159252, 0.025705>, 
      <0.312367, 0.376988, 0.061181>, <0.439623, 0.374168, 0.057598>, <0.610359, 0.372696, 0.060798>, <0.735075, 0.348858, 0.070425>, 
      <0.312367, 0.484993, 0.157508>, <0.439623, 0.482173, 0.153925>, <0.610359, 0.471035, 0.155332>, <0.735075, 0.447197, 0.164958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312367, 0.035370, -0.137652>, <0.439180, 0.034948, -0.137652>, <0.608261, 0.033321, -0.137652>, <0.735075, 0.033417, -0.137652>, 
      <0.312367, 0.040308, -0.112802>, <0.439180, 0.039886, -0.112802>, <0.608261, 0.038041, -0.112802>, <0.735075, 0.038136, -0.112802>, 
      <0.312367, 0.030651, -0.068722>, <0.439136, 0.030162, -0.072107>, <0.608261, 0.029120, -0.069750>, <0.735075, 0.028731, -0.069750>, 
      <0.312367, 0.051831, -0.054818>, <0.439136, 0.051343, -0.058203>, <0.608261, 0.049537, -0.054818>, <0.735075, 0.049148, -0.054818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.735075, 0.587694, 1.035132>, <0.736772, 0.623703, 1.030110>, <0.743061, 0.673946, 1.031750>, <0.740733, 0.707724, 1.018393>, 
      <0.609862, 0.608882, 1.029828>, <0.611560, 0.644891, 1.024806>, <0.616535, 0.695710, 1.027286>, <0.614207, 0.729487, 1.013929>, 
      <0.439179, 0.606846, 1.029140>, <0.439634, 0.644528, 1.024093>, <0.443288, 0.702775, 1.024258>, <0.442319, 0.738338, 1.010846>, 
      <0.312367, 0.615055, 1.026572>, <0.312822, 0.652736, 1.021525>, <0.314852, 0.705095, 1.023160>, <0.313882, 0.740658, 1.009749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.266484, 0.053005, -0.028070>, <-0.093002, 0.052682, -0.039235>, <0.138589, 0.052500, -0.050177>, <0.312367, 0.051831, -0.054818>, 
      <-0.266484, 0.026604, -0.048257>, <-0.093002, 0.026281, -0.059422>, <0.138589, 0.031320, -0.064081>, <0.312367, 0.030651, -0.068722>, 
      <-0.266484, 0.041626, -0.104778>, <-0.092829, 0.041212, -0.104778>, <0.138712, 0.040886, -0.112802>, <0.312367, 0.040308, -0.112802>, 
      <-0.266484, 0.036749, -0.137652>, <-0.092829, 0.036336, -0.137652>, <0.138712, 0.035948, -0.137652>, <0.312367, 0.035370, -0.137652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.266484, 0.469387, 0.193159>, <-0.093517, 0.487029, 0.185190>, <0.138431, 0.488846, 0.162406>, <0.312367, 0.484993, 0.157508>, 
      <-0.266484, 0.362648, 0.100341>, <-0.093517, 0.380290, 0.092371>, <0.138431, 0.380841, 0.066079>, <0.312367, 0.376988, 0.061181>, 
      <-0.266484, 0.165372, 0.057850>, <-0.093002, 0.165048, 0.046685>, <0.138589, 0.173482, 0.029243>, <0.312367, 0.172812, 0.024602>, 
      <-0.266484, 0.053005, -0.028070>, <-0.093002, 0.052682, -0.039235>, <0.138589, 0.052500, -0.050177>, <0.312367, 0.051831, -0.054818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.266484, 0.656702, 0.496896>, <-0.093270, 0.669719, 0.496214>, <0.138710, 0.673219, 0.493972>, <0.312367, 0.670430, 0.496896>, 
      <-0.266846, 0.625559, 0.394471>, <-0.093632, 0.638576, 0.393790>, <0.139112, 0.640961, 0.382524>, <0.312769, 0.638171, 0.385448>, 
      <-0.266484, 0.550171, 0.263408>, <-0.093517, 0.567813, 0.255439>, <0.138431, 0.575435, 0.239632>, <0.312367, 0.571581, 0.234734>, 
      <-0.266484, 0.469387, 0.193159>, <-0.093517, 0.487029, 0.185190>, <0.138431, 0.488846, 0.162406>, <0.312367, 0.484993, 0.157508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.263682, 0.710233, 0.985265>, <-0.091882, 0.717679, 0.983358>, <0.137442, 0.727684, 0.983795>, <0.309380, 0.724586, 0.985265>, 
      <-0.264523, 0.694174, 0.838754>, <-0.092722, 0.701620, 0.836847>, <0.138338, 0.711437, 0.837285>, <0.310276, 0.708339, 0.838754>, 
      <-0.265985, 0.699579, 0.637911>, <-0.092771, 0.712596, 0.637230>, <0.138199, 0.714205, 0.635570>, <0.311856, 0.711415, 0.638494>, 
      <-0.266484, 0.656702, 0.496896>, <-0.093270, 0.669719, 0.496214>, <0.138710, 0.673219, 0.493972>, <0.312367, 0.670430, 0.496896>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.270641, 0.725996, 1.009749>, <-0.095406, 0.733655, 1.007957>, <0.138505, 0.743827, 1.008250>, <0.313882, 0.740658, 1.009749>, 
      <-0.270422, 0.734371, 1.006512>, <-0.095186, 0.742030, 1.004720>, <0.138278, 0.752142, 1.005114>, <0.313656, 0.748973, 1.006613>, 
      <-0.265770, 0.714962, 0.992610>, <-0.093969, 0.722408, 0.990703>, <0.138792, 0.732506, 0.991140>, <0.310731, 0.729408, 0.992610>, 
      <-0.263682, 0.710233, 0.985265>, <-0.091882, 0.717679, 0.983358>, <0.137442, 0.727684, 0.983795>, <0.309380, 0.724586, 0.985265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.266484, 0.603343, 1.026572>, <-0.092829, 0.606856, 1.026572>, <0.138712, 0.611541, 1.026572>, <0.312367, 0.615055, 1.026572>, 
      <-0.267731, 0.640139, 1.021525>, <-0.094076, 0.643652, 1.021525>, <0.139166, 0.649222, 1.021525>, <0.312822, 0.652736, 1.021525>, 
      <-0.271550, 0.691343, 1.023140>, <-0.096314, 0.699002, 1.021348>, <0.139475, 0.708264, 1.021661>, <0.314852, 0.705095, 1.023160>, 
      <-0.270641, 0.725996, 1.009749>, <-0.095406, 0.733655, 1.007957>, <0.138505, 0.743827, 1.008250>, <0.313882, 0.740658, 1.009749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998387, 0.054273, 0.029536>, <-0.779435, 0.054420, 0.005657>, <-0.486279, 0.053415, -0.013925>, <-0.266484, 0.053005, -0.028070>, 
      <-0.998387, 0.020806, -0.008217>, <-0.779435, 0.020953, -0.032096>, <-0.486279, 0.027014, -0.034112>, <-0.266484, 0.026604, -0.048257>, 
      <-0.998387, 0.041560, -0.087496>, <-0.778816, 0.041751, -0.087496>, <-0.486055, 0.041435, -0.104778>, <-0.266484, 0.041626, -0.104778>, 
      <-0.998387, 0.036111, -0.137652>, <-0.778816, 0.036303, -0.137652>, <-0.486055, 0.036558, -0.137652>, <-0.266484, 0.036749, -0.137652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998387, 0.351299, 0.217898>, <-0.782762, 0.404209, 0.202808>, <-0.487638, 0.446830, 0.203348>, <-0.266484, 0.469387, 0.193159>, 
      <-0.998387, 0.273368, 0.146763>, <-0.782762, 0.326279, 0.131673>, <-0.487638, 0.340091, 0.110530>, <-0.266484, 0.362648, 0.100341>, 
      <-0.998387, 0.124267, 0.108493>, <-0.779435, 0.124414, 0.084614>, <-0.486279, 0.165781, 0.071995>, <-0.266484, 0.165372, 0.057850>, 
      <-0.998387, 0.054273, 0.029536>, <-0.779435, 0.054420, 0.005657>, <-0.486279, 0.053415, -0.013925>, <-0.266484, 0.053005, -0.028070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998387, 0.571928, 0.502055>, <-0.779268, 0.600832, 0.498626>, <-0.486905, 0.640137, 0.497764>, <-0.266484, 0.656702, 0.496896>, 
      <-0.999682, 0.531370, 0.402048>, <-0.780562, 0.560275, 0.398618>, <-0.487267, 0.608994, 0.395339>, <-0.266846, 0.625559, 0.394471>, 
      <-0.998387, 0.431010, 0.290659>, <-0.782762, 0.483920, 0.275569>, <-0.487638, 0.527613, 0.273597>, <-0.266484, 0.550171, 0.263408>, 
      <-0.998387, 0.351299, 0.217898>, <-0.782762, 0.404209, 0.202808>, <-0.487638, 0.446830, 0.203348>, <-0.266484, 0.469387, 0.193159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.988266, 0.668341, 0.999668>, <-0.771994, 0.692854, 0.992324>, <-0.481246, 0.700803, 0.987680>, <-0.263682, 0.710233, 0.985265>, 
      <-0.991303, 0.639417, 0.850384>, <-0.775030, 0.663930, 0.843040>, <-0.482086, 0.684743, 0.841169>, <-0.264523, 0.694174, 0.838754>, 
      <-0.996563, 0.629081, 0.642986>, <-0.777443, 0.657986, 0.639557>, <-0.486406, 0.683014, 0.638779>, <-0.265985, 0.699579, 0.637911>, 
      <-0.998387, 0.571928, 0.502055>, <-0.779268, 0.600832, 0.498626>, <-0.486905, 0.640137, 0.497764>, <-0.266484, 0.656702, 0.496896>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.009717, 0.682809, 1.023281>, <-0.789251, 0.708995, 1.015898>, <-0.492556, 0.716297, 1.012017>, <-0.270641, 0.725996, 1.009749>, 
      <-1.008909, 0.692850, 1.020289>, <-0.788443, 0.719036, 1.012906>, <-0.492337, 0.724672, 1.008781>, <-0.270422, 0.734371, 1.006512>, 
      <-0.994702, 0.672681, 1.006752>, <-0.778429, 0.697195, 0.999408>, <-0.483334, 0.705532, 0.995025>, <-0.265770, 0.714962, 0.992610>, 
      <-0.988266, 0.668341, 0.999668>, <-0.771994, 0.692854, 0.992324>, <-0.481246, 0.700803, 0.987680>, <-0.263682, 0.710233, 0.985265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998387, 0.542544, 1.037148>, <-0.779473, 0.566596, 1.029920>, <-0.486055, 0.585103, 1.029745>, <-0.266484, 0.603343, 1.026572>, 
      <-1.001786, 0.584624, 1.032988>, <-0.782872, 0.608675, 1.025760>, <-0.487302, 0.621899, 1.024698>, <-0.267731, 0.640139, 1.021525>, 
      <-1.012978, 0.642274, 1.035358>, <-0.792512, 0.668461, 1.027975>, <-0.493464, 0.681644, 1.025409>, <-0.271550, 0.691343, 1.023140>, 
      <-1.009717, 0.682809, 1.023281>, <-0.789251, 0.708995, 1.015898>, <-0.492556, 0.716297, 1.012017>, <-0.270641, 0.725996, 1.009749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.838220, 0.051949, 0.143345>, <-1.586270, 0.052646, 0.109202>, <-1.251142, 0.054104, 0.057102>, <-0.998387, 0.054273, 0.029536>, 
      <-1.817415, 0.044678, 0.058540>, <-1.565465, 0.045375, 0.024397>, <-1.251142, 0.020636, 0.019349>, <-0.998387, 0.020806, -0.008217>, 
      <-1.793659, 0.039401, -0.055796>, <-1.560807, 0.040027, -0.054749>, <-1.231239, 0.040933, -0.088543>, <-0.998387, 0.041560, -0.087496>, 
      <-1.774562, 0.034023, -0.141143>, <-1.541709, 0.034649, -0.140096>, <-1.231239, 0.035485, -0.138699>, <-0.998387, 0.036111, -0.137652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.884354, 0.072394, 0.306381>, <-1.618564, 0.156065, 0.279836>, <-1.269607, 0.284747, 0.236879>, <-0.998387, 0.351299, 0.217898>, 
      <-1.873885, 0.036832, 0.271066>, <-1.608095, 0.120503, 0.244521>, <-1.269607, 0.206816, 0.165743>, <-0.998387, 0.273368, 0.146763>, 
      <-1.850377, 0.056198, 0.192899>, <-1.598427, 0.056895, 0.158756>, <-1.251142, 0.124098, 0.136059>, <-0.998387, 0.124267, 0.108493>, 
      <-1.838220, 0.051949, 0.143345>, <-1.586270, 0.052646, 0.109202>, <-1.251142, 0.054104, 0.057102>, <-0.998387, 0.054273, 0.029536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.950848, 0.434516, 0.523258>, <-1.665110, 0.475739, 0.516897>, <-1.284639, 0.534168, 0.506535>, <-0.998387, 0.571928, 0.502055>, 
      <-1.922078, 0.371600, 0.415337>, <-1.636340, 0.412824, 0.408976>, <-1.285934, 0.493611, 0.406528>, <-0.999682, 0.531370, 0.402048>, 
      <-1.910567, 0.161432, 0.394801>, <-1.644777, 0.245103, 0.368256>, <-1.269607, 0.364458, 0.309640>, <-0.998387, 0.431010, 0.290659>, 
      <-1.884354, 0.072394, 0.306381>, <-1.618564, 0.156065, 0.279836>, <-1.269607, 0.284747, 0.236879>, <-0.998387, 0.351299, 0.217898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.081792, 0.504160, 1.047003>, <-1.753734, 0.553415, 1.032803>, <-1.318005, 0.630967, 1.010865>, <-0.988266, 0.668341, 0.999668>, 
      <-2.042509, 0.483267, 0.889880>, <-1.714451, 0.532521, 0.875679>, <-1.321041, 0.602043, 0.861581>, <-0.991303, 0.639417, 0.850384>, 
      <-1.987498, 0.514663, 0.660737>, <-1.701759, 0.555887, 0.654377>, <-1.282815, 0.591322, 0.647466>, <-0.996563, 0.629081, 0.642986>, 
      <-1.950848, 0.434516, 0.523258>, <-1.665110, 0.475739, 0.516897>, <-1.284639, 0.534168, 0.506535>, <-0.998387, 0.571928, 0.502055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.080102, 0.511075, 1.070342>, <-1.758987, 0.562595, 1.056224>, <-1.332795, 0.644435, 1.034100>, <-1.009717, 0.682809, 1.023281>, 
      <-2.079584, 0.517870, 1.067670>, <-1.758468, 0.569390, 1.053552>, <-1.331987, 0.654476, 1.031108>, <-1.008909, 0.692850, 1.020289>, 
      <-2.081285, 0.506235, 1.054005>, <-1.753227, 0.555489, 1.039805>, <-1.324440, 0.635308, 1.017949>, <-0.994702, 0.672681, 1.006752>, 
      <-2.081792, 0.504160, 1.047003>, <-1.753734, 0.553415, 1.032803>, <-1.318005, 0.630967, 1.010865>, <-0.988266, 0.668341, 0.999668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.089510, 0.403053, 1.086765>, <-1.762173, 0.444900, 1.071880>, <-1.326571, 0.506488, 1.047984>, <-0.998387, 0.542544, 1.037148>, 
      <-2.086688, 0.435459, 1.081838>, <-1.759351, 0.477307, 1.066953>, <-1.329970, 0.548567, 1.043824>, <-1.001786, 0.584624, 1.032988>, 
      <-2.082434, 0.480534, 1.082353>, <-1.761318, 0.532054, 1.068234>, <-1.336056, 0.603900, 1.046177>, <-1.012978, 0.642274, 1.035358>, 
      <-2.080102, 0.511075, 1.070342>, <-1.758987, 0.562595, 1.056224>, <-1.332795, 0.644435, 1.034100>, <-1.009717, 0.682809, 1.023281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.205802, 0.038901, 1.104208>, <2.207470, 0.038805, 1.110573>, <2.222361, 0.042134, 1.115131>, <2.223932, 0.035828, 1.116167>, 
      <2.238878, 0.036887, 1.118187>, <2.240546, 0.036790, 1.124551>, <2.250732, 0.042064, 1.128759>, <2.252303, 0.035758, 1.129795>, 
      <2.280257, 0.036896, 1.142870>, <2.281122, 0.036898, 1.145815>, <2.286557, 0.035803, 1.150455>, <2.287203, 0.035676, 1.153453>, 
      <2.312166, 0.036036, 1.159439>, <2.313031, 0.036039, 1.162384>, <2.313673, 0.035738, 1.166434>, <2.314319, 0.035610, 1.169432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.201850, 0.042756, 1.112817>, <2.204088, 0.042352, 1.119157>, <2.218445, 0.042333, 1.123160>, <2.219980, 0.035844, 1.124117>, 
      <2.202790, 0.041389, 1.110236>, <2.205029, 0.040984, 1.116576>, <2.219423, 0.042327, 1.120683>, <2.220957, 0.035838, 1.121639>, 
      <2.202980, 0.039073, 1.103015>, <2.204648, 0.038977, 1.109380>, <2.219961, 0.042140, 1.113978>, <2.221531, 0.035834, 1.115014>, 
      <2.205802, 0.038901, 1.104208>, <2.207470, 0.038805, 1.110573>, <2.222361, 0.042134, 1.115131>, <2.223932, 0.035828, 1.116167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.200360, 0.046813, 1.119143>, <2.204071, 0.044773, 1.124885>, <2.216939, 0.042762, 1.129034>, <2.218490, 0.035860, 1.129959>, 
      <2.200890, 0.045493, 1.117338>, <2.204601, 0.043452, 1.123080>, <2.217487, 0.042757, 1.127310>, <2.219038, 0.035854, 1.128235>, 
      <2.201145, 0.043780, 1.114750>, <2.203384, 0.043376, 1.121090>, <2.217781, 0.042336, 1.124843>, <2.219316, 0.035848, 1.125799>, 
      <2.201850, 0.042756, 1.112817>, <2.204088, 0.042352, 1.119157>, <2.218445, 0.042333, 1.123160>, <2.219980, 0.035844, 1.124117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.198539, 0.051006, 1.124089>, <2.204277, 0.045995, 1.125483>, <2.215063, 0.043398, 1.133602>, <2.216669, 0.035878, 1.134527>, 
      <2.199085, 0.049748, 1.122605>, <2.204823, 0.044737, 1.123999>, <2.215609, 0.043392, 1.132232>, <2.217215, 0.035872, 1.133156>, 
      <2.199894, 0.047975, 1.120729>, <2.203605, 0.045934, 1.126472>, <2.216492, 0.042767, 1.130440>, <2.218043, 0.035864, 1.131365>, 
      <2.200360, 0.046813, 1.119143>, <2.204071, 0.044773, 1.124885>, <2.216939, 0.042762, 1.129034>, <2.218490, 0.035860, 1.129959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.027672, 0.047167, 0.367411>, <2.113150, 0.045729, 0.578151>, <2.148146, 0.042232, 0.884242>, <2.205802, 0.038901, 1.104208>, 
      <2.028385, 0.043676, 0.330960>, <2.113863, 0.042237, 0.541701>, <2.181222, 0.040217, 0.898221>, <2.238878, 0.036887, 1.118187>, 
      <2.038668, 0.038511, 0.283108>, <2.154272, 0.038476, 0.544011>, <2.199837, 0.036656, 0.869068>, <2.280257, 0.036896, 1.142870>, 
      <2.043380, 0.034802, 0.246978>, <2.158984, 0.034767, 0.507881>, <2.231746, 0.035796, 0.885637>, <2.312166, 0.036036, 1.159439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.036391, 0.069016, 0.604201>, <2.120049, 0.046146, 0.739428>, <2.148456, 0.052403, 0.961608>, <2.201850, 0.042756, 1.112817>, 
      <2.033210, 0.057647, 0.533797>, <2.116868, 0.034778, 0.669024>, <2.149396, 0.051036, 0.959027>, <2.202790, 0.041389, 1.110236>, 
      <2.026282, 0.053972, 0.438459>, <2.111760, 0.052533, 0.649200>, <2.145324, 0.042404, 0.883050>, <2.202980, 0.039073, 1.103015>, 
      <2.027672, 0.047167, 0.367411>, <2.113150, 0.045729, 0.578151>, <2.148146, 0.042232, 0.884242>, <2.205802, 0.038901, 1.104208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.050369, 0.128292, 0.869811>, <2.109916, 0.095163, 0.929593>, <2.153213, 0.072735, 1.046188>, <2.200360, 0.046813, 1.119143>, 
      <2.042133, 0.115478, 0.789492>, <2.101680, 0.082349, 0.849274>, <2.153743, 0.071414, 1.044383>, <2.200890, 0.045493, 1.117338>, 
      <2.040034, 0.082035, 0.684827>, <2.123692, 0.059165, 0.820054>, <2.147752, 0.053428, 0.963541>, <2.201145, 0.043780, 1.114750>, 
      <2.036391, 0.069016, 0.604201>, <2.120049, 0.046146, 0.739428>, <2.148456, 0.052403, 0.961608>, <2.201850, 0.042756, 1.112817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.087558, 0.148624, 1.103179>, <2.123923, 0.123351, 1.109839>, <2.165357, 0.079981, 1.116033>, <2.198539, 0.051006, 1.124089>, 
      <2.076401, 0.142524, 1.033169>, <2.112766, 0.117251, 1.039828>, <2.165904, 0.078724, 1.114549>, <2.199085, 0.049748, 1.122605>, 
      <2.057538, 0.139445, 0.939721>, <2.117085, 0.106317, 0.999502>, <2.152747, 0.073896, 1.047774>, <2.199894, 0.047975, 1.120729>, 
      <2.050369, 0.128292, 0.869811>, <2.109916, 0.095163, 0.929593>, <2.153213, 0.072735, 1.046188>, <2.200360, 0.046813, 1.119143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.755826, 0.046473, -0.005177>, <1.874103, 0.046212, 0.066624>, <1.975666, 0.048042, 0.239194>, <2.027672, 0.047167, 0.367411>, 
      <1.755826, 0.039480, -0.031737>, <1.874103, 0.039220, 0.040064>, <1.976379, 0.044551, 0.202743>, <2.028385, 0.043676, 0.330960>, 
      <1.755826, 0.039286, -0.068858>, <1.873964, 0.039064, -0.004971>, <1.984259, 0.038528, 0.160315>, <2.038668, 0.038511, 0.283108>, 
      <1.755826, 0.036206, -0.096150>, <1.873964, 0.035984, -0.032262>, <1.988972, 0.034819, 0.124185>, <2.043380, 0.034802, 0.246978>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.755826, 0.164684, 0.391853>, <1.849233, 0.135364, 0.440659>, <1.979425, 0.084588, 0.512120>, <2.036391, 0.069016, 0.604201>, 
      <1.755826, 0.122047, 0.275119>, <1.849233, 0.092727, 0.323925>, <1.976244, 0.073220, 0.441716>, <2.033210, 0.057647, 0.533797>, 
      <1.755826, 0.078113, 0.115004>, <1.874103, 0.077853, 0.186805>, <1.974276, 0.054847, 0.310242>, <2.026282, 0.053972, 0.438459>, 
      <1.755826, 0.046473, -0.005177>, <1.874103, 0.046212, 0.066624>, <1.975666, 0.048042, 0.239194>, <2.027672, 0.047167, 0.367411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.755826, 0.294127, 0.672859>, <1.854663, 0.247451, 0.715600>, <1.973273, 0.171184, 0.792412>, <2.050369, 0.128292, 0.869811>, 
      <1.755826, 0.267626, 0.583907>, <1.854663, 0.220950, 0.626648>, <1.965037, 0.158370, 0.712093>, <2.042133, 0.115478, 0.789492>, 
      <1.755826, 0.196528, 0.479035>, <1.849233, 0.167208, 0.527841>, <1.983068, 0.097607, 0.592746>, <2.040034, 0.082035, 0.684827>, 
      <1.755826, 0.164684, 0.391853>, <1.849233, 0.135364, 0.440659>, <1.979425, 0.084588, 0.512120>, <2.036391, 0.069016, 0.604201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.755826, 0.358685, 1.043015>, <1.861019, 0.303794, 1.054093>, <1.990789, 0.215877, 1.085458>, <2.087558, 0.148624, 1.103179>, 
      <1.755826, 0.339317, 0.931968>, <1.861019, 0.284427, 0.943046>, <1.979632, 0.209777, 1.015447>, <2.076401, 0.142524, 1.033169>, 
      <1.755826, 0.326313, 0.780890>, <1.854663, 0.279637, 0.823630>, <1.980442, 0.182337, 0.862321>, <2.057538, 0.139445, 0.939721>, 
      <1.755826, 0.294127, 0.672859>, <1.854663, 0.247451, 0.715600>, <1.973273, 0.171184, 0.792412>, <2.050369, 0.128292, 0.869811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.771487, 0.366479, 1.067207>, <1.877662, 0.309714, 1.078180>, <2.007838, 0.217935, 1.107795>, <2.109131, 0.154273, 1.125190>, 
      <1.766789, 0.364141, 1.059949>, <1.872963, 0.307376, 1.070922>, <2.001366, 0.216240, 1.101192>, <2.102659, 0.152579, 1.118587>, 
      <1.760524, 0.361023, 1.050272>, <1.865717, 0.306132, 1.061351>, <1.997261, 0.217572, 1.092061>, <2.094030, 0.150319, 1.109782>, 
      <1.755826, 0.358685, 1.043015>, <1.861019, 0.303794, 1.054093>, <1.990789, 0.215877, 1.085458>, <2.087558, 0.148624, 1.103179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.332139, 0.048700, -0.054818>, <1.459965, 0.048365, -0.048601>, <1.646429, 0.046714, -0.071588>, <1.755826, 0.046473, -0.005177>, 
      <1.332139, 0.034578, -0.075610>, <1.459965, 0.034243, -0.069393>, <1.646429, 0.039722, -0.098148>, <1.755826, 0.039480, -0.031737>, 
      <1.332139, 0.039907, -0.112802>, <1.459748, 0.040256, -0.107614>, <1.643487, 0.039497, -0.129610>, <1.755826, 0.039286, -0.068858>, 
      <1.332139, 0.036139, -0.137652>, <1.459748, 0.036488, -0.132464>, <1.643487, 0.036417, -0.156902>, <1.755826, 0.036206, -0.096150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.332139, 0.290078, 0.236221>, <1.464580, 0.253422, 0.265660>, <1.635824, 0.202352, 0.329150>, <1.755826, 0.164684, 0.391853>, 
      <1.332139, 0.226165, 0.142507>, <1.464580, 0.189509, 0.171947>, <1.635824, 0.159715, 0.212417>, <1.755826, 0.122047, 0.275119>, 
      <1.332139, 0.112434, 0.039017>, <1.459965, 0.112099, 0.045234>, <1.646429, 0.078354, 0.048593>, <1.755826, 0.078113, 0.115004>, 
      <1.332139, 0.048700, -0.054818>, <1.459965, 0.048365, -0.048601>, <1.646429, 0.046714, -0.071588>, <1.755826, 0.046473, -0.005177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.332139, 0.467478, 0.559224>, <1.464696, 0.422483, 0.579885>, <1.636661, 0.350403, 0.621328>, <1.755826, 0.294127, 0.672859>, 
      <1.333900, 0.432810, 0.454261>, <1.466456, 0.387815, 0.474922>, <1.636661, 0.323902, 0.532376>, <1.755826, 0.267626, 0.583907>, 
      <1.332139, 0.352368, 0.327556>, <1.464580, 0.315713, 0.356995>, <1.635824, 0.234196, 0.416333>, <1.755826, 0.196528, 0.479035>, 
      <1.332139, 0.290078, 0.236221>, <1.464580, 0.253422, 0.265660>, <1.635824, 0.202352, 0.329150>, <1.755826, 0.164684, 0.391853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.318954, 0.549688, 1.022235>, <1.454994, 0.505529, 1.028756>, <1.629442, 0.424633, 1.029705>, <1.755826, 0.358685, 1.043015>, 
      <1.322910, 0.525025, 0.883332>, <1.458950, 0.480866, 0.889853>, <1.629442, 0.405266, 0.918658>, <1.755826, 0.339317, 0.931968>, 
      <1.329891, 0.511734, 0.693218>, <1.462448, 0.466739, 0.713879>, <1.636661, 0.382589, 0.729359>, <1.755826, 0.326313, 0.780890>, 
      <1.332139, 0.467478, 0.559224>, <1.464696, 0.422483, 0.579885>, <1.636661, 0.350403, 0.621328>, <1.755826, 0.294127, 0.672859>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.343648, 0.563528, 1.046079>, <1.477798, 0.519116, 1.052432>, <1.647258, 0.432896, 1.054368>, <1.771487, 0.366479, 1.067207>, 
      <1.342408, 0.573615, 1.041606>, <1.476557, 0.529203, 1.047959>, <1.642560, 0.430558, 1.047110>, <1.766789, 0.364141, 1.059949>, 
      <1.326363, 0.553840, 1.029388>, <1.462403, 0.509682, 1.035909>, <1.634140, 0.426972, 1.036962>, <1.760524, 0.361023, 1.050272>, 
      <1.318954, 0.549688, 1.022235>, <1.454994, 0.505529, 1.028756>, <1.629442, 0.424633, 1.029705>, <1.755826, 0.358685, 1.043015>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.735075, 0.049148, -0.054818>, <0.914193, 0.048598, -0.054818>, <1.153232, 0.049169, -0.063518>, <1.332139, 0.048700, -0.054818>, 
      <0.735075, 0.028731, -0.069750>, <0.914193, 0.028181, -0.069750>, <1.153232, 0.035047, -0.084310>, <1.332139, 0.034578, -0.075610>, 
      <0.735075, 0.038136, -0.112802>, <0.914196, 0.038272, -0.112802>, <1.153167, 0.039418, -0.120079>, <1.332139, 0.039907, -0.112802>, 
      <0.735075, 0.033417, -0.137652>, <0.914196, 0.033552, -0.137652>, <1.153167, 0.035650, -0.144929>, <1.332139, 0.036139, -0.137652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.735075, 0.447197, 0.164958>, <0.917683, 0.412294, 0.179053>, <1.156434, 0.338707, 0.197164>, <1.332139, 0.290078, 0.236221>, 
      <0.735075, 0.348858, 0.070425>, <0.917683, 0.313956, 0.084520>, <1.156434, 0.274795, 0.103451>, <1.332139, 0.226165, 0.142507>, 
      <0.735075, 0.159252, 0.025705>, <0.914193, 0.158703, 0.025705>, <1.153232, 0.112903, 0.030317>, <1.332139, 0.112434, 0.039017>, 
      <0.735075, 0.049148, -0.054818>, <0.914193, 0.048598, -0.054818>, <1.153232, 0.049169, -0.063518>, <1.332139, 0.048700, -0.054818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.735075, 0.640612, 0.513760>, <0.918146, 0.604178, 0.524949>, <1.156964, 0.526939, 0.531921>, <1.332139, 0.467478, 0.559224>, 
      <0.736074, 0.606672, 0.399027>, <0.919144, 0.570238, 0.410217>, <1.158724, 0.492271, 0.426957>, <1.333900, 0.432810, 0.454261>, 
      <0.735075, 0.533456, 0.247879>, <0.917683, 0.498553, 0.261974>, <1.156434, 0.400998, 0.288499>, <1.332139, 0.352368, 0.327556>, 
      <0.735075, 0.447197, 0.164958>, <0.917683, 0.412294, 0.179053>, <1.156434, 0.338707, 0.197164>, <1.332139, 0.290078, 0.236221>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.727861, 0.692364, 0.993740>, <0.907685, 0.661212, 1.000325>, <1.145436, 0.606013, 1.013917>, <1.318954, 0.549688, 1.022235>, 
      <0.730025, 0.676839, 0.849746>, <0.909849, 0.645686, 0.856331>, <1.149391, 0.581350, 0.875014>, <1.322910, 0.525025, 0.883332>, 
      <0.733866, 0.681698, 0.652650>, <0.916937, 0.645264, 0.663839>, <1.154716, 0.571196, 0.665914>, <1.329891, 0.511734, 0.693218>, 
      <0.735075, 0.640612, 0.513760>, <0.918146, 0.604178, 0.524949>, <1.156964, 0.526939, 0.531921>, <1.332139, 0.467478, 0.559224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.740733, 0.707724, 1.018393>, <0.924089, 0.676185, 1.024862>, <1.167099, 0.621977, 1.037718>, <1.343648, 0.563528, 1.046079>, 
      <0.740123, 0.716569, 1.014895>, <0.923479, 0.685030, 1.021364>, <1.165858, 0.632064, 1.033245>, <1.342408, 0.573615, 1.041606>, 
      <0.731723, 0.696972, 1.001136>, <0.911546, 0.665820, 1.007721>, <1.152844, 0.610165, 1.021071>, <1.326363, 0.553840, 1.029388>, 
      <0.727861, 0.692364, 0.993740>, <0.907685, 0.661212, 1.000325>, <1.145436, 0.606013, 1.013917>, <1.318954, 0.549688, 1.022235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.735075, 0.587694, 1.035132>, <0.916961, 0.556915, 1.042837>, <1.153020, 0.486050, 1.059380>, <1.332139, 0.442489, 1.069773>, 
      <0.736772, 0.623703, 1.030110>, <0.918659, 0.592924, 1.037816>, <1.156473, 0.522362, 1.052272>, <1.335592, 0.478801, 1.062665>, 
      <0.743061, 0.673946, 1.031750>, <0.926417, 0.642407, 1.038219>, <1.171251, 0.588219, 1.052689>, <1.347800, 0.529770, 1.061050>, 
      <0.740733, 0.707724, 1.018393>, <0.924089, 0.676185, 1.024862>, <1.167099, 0.621977, 1.037718>, <1.343648, 0.563528, 1.046079>
    }
  }
  material {
    casco_txt
  }
  photons {
    collect off
  }
}
#declare Cube016 = object {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.065, 0.015, 0.005>
    rotate <0.111143, 3.316774, 8.256152>
    translate  <-0.958754, 0.518132, -2.826174>
  }
}
#declare Cube018 = object {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.065, 0.015, 0.005>
    rotate <1.466159, -2.911988, -28.889336>
    translate  <2.559257, 0.334001, -2.807981>
  }
}
#declare Cylndr035 = object {
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.04, 0.07>
    translate  <0.0, -0.602739, -0.035>
  }
}
#declare Cylndr051 = object {
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.5, 0.5, 0.05>
    translate  0.015*z
  }
}
#declare Cylndr053 = object {
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.15, 0.03>
    translate  0.01*z
  }
}
#declare tapaup = object {
  cylinder { // tapaup
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.15, 0.05>
    translate  0.115*z
  }
}
#declare Cylndr018 = object {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      acero_txt
    }
    photons {
      collect off
    }
    scale <0.0275, 0.03, 0.3>
    translate  <0.0, -0.15, -0.15>
  }
}
#declare Torus001 = object {
  torus { // Torus001
    0.05, 0.01  rotate -x*90
    photons {
      collect off
    }
    translate  0.12689*z
  }
}
#declare anillas = union {
  object { Torus001 }
  object { // Torus002 -> Torus001
    Torus001
    photons {
      collect off
    }
    translate  -0.7243*y
  }
  photons {
    collect off
  }
  scale <1.0, 1.0, 0.8>
  translate  0.025268*z
}
#declare dientes1 = union {
  object { Cylndr035 }
  object { // Cylndr036 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -5.625*z
    translate  -0.0*z
  }
  object { // Cylndr037 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -11.25*z
    translate  -0.0*z
  }
  object { // Cylndr038 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -16.875*z
    translate  -0.0*z
  }
  object { // Cylndr039 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -22.5*z
    translate  -0.0*z
  }
  object { // Cylndr040 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -28.125*z
    translate  -0.0*z
  }
  object { // Cylndr041 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -33.75*z
    translate  -0.0*z
  }
  object { // Cylndr042 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -39.375*z
    translate  -0.0*z
  }
  object { // Cylndr043 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -45.0*z
    translate  -0.0*z
  }
  object { // Cylndr044 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -50.625*z
    translate  -0.0*z
  }
  object { // Cylndr045 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -56.25*z
    translate  -0.0*z
  }
  object { // Cylndr046 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -61.875*z
    translate  -0.0*z
  }
  object { // Cylndr047 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -67.5*z
    translate  -0.0*z
  }
  object { // Cylndr048 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -73.125*z
    translate  -0.0*z
  }
  object { // Cylndr049 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -78.75*z
    translate  -0.0*z
  }
  object { // Cylndr050 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -84.375*z
    translate  -0.0*z
  }
  object { // Cylndr055 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -90.0*z
    translate  -0.0*z
  }
  object { // Cylndr056 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -95.625*z
    translate  -0.0*z
  }
  object { // Cylndr057 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -101.25*z
    translate  -0.0*z
  }
  object { // Cylndr058 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -106.875*z
    translate  -0.0*z
  }
  object { // Cylndr059 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -112.5*z
    translate  -0.0*z
  }
  object { // Cylndr060 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -118.125*z
    translate  -0.0*z
  }
  object { // Cylndr061 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -123.75*z
    translate  -0.0*z
  }
  object { // Cylndr062 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -129.375*z
    translate  -0.0*z
  }
  object { // Cylndr063 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -135.0*z
    translate  -0.0*z
  }
  object { // Cylndr064 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -140.625*z
    translate  -0.0*z
  }
  object { // Cylndr065 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -146.25*z
    translate  -0.0*z
  }
  object { // Cylndr066 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -151.875*z
    translate  -0.0*z
  }
  object { // Cylndr067 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -157.5*z
    translate  -0.0*z
  }
  object { // Cylndr068 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -163.125*z
    translate  -0.0*z
  }
  object { // Cylndr069 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -168.75*z
    translate  -0.0*z
  }
  object { // Cylndr070 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -174.375*z
    translate  -0.0*z
  }
  object { // Cylndr071 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate -180.0*z
    translate  -0.0*z
  }
  object { // Cylndr072 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 174.375*z
    translate  -0.0*z
  }
  object { // Cylndr073 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 168.75*z
    translate  -0.0*z
  }
  object { // Cylndr074 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 163.125*z
    translate  -0.0*z
  }
  object { // Cylndr075 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 157.5*z
    translate  -0.0*z
  }
  object { // Cylndr076 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 151.875*z
    translate  -0.0*z
  }
  object { // Cylndr077 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 146.25*z
    translate  -0.0*z
  }
  object { // Cylndr078 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 140.625*z
    translate  -0.0*z
  }
  object { // Cylndr079 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 135.0*z
    translate  -0.0*z
  }
  object { // Cylndr080 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 129.375*z
    translate  -0.0*z
  }
  object { // Cylndr081 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 123.75*z
    translate  -0.0*z
  }
  object { // Cylndr082 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 118.125*z
    translate  -0.0*z
  }
  object { // Cylndr083 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 112.5*z
    translate  -0.0*z
  }
  object { // Cylndr084 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 106.875*z
    translate  -0.0*z
  }
  object { // Cylndr085 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 101.25*z
    translate  -0.0*z
  }
  object { // Cylndr086 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 95.625*z
    translate  -0.0*z
  }
  object { // Cylndr087 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 90.0*z
    translate  -0.0*z
  }
  object { // Cylndr088 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 84.375*z
    translate  -0.0*z
  }
  object { // Cylndr089 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 78.75*z
    translate  -0.0*z
  }
  object { // Cylndr090 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 73.125*z
    translate  -0.0*z
  }
  object { // Cylndr091 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 67.5*z
    translate  -0.0*z
  }
  object { // Cylndr092 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 61.875*z
    translate  -0.0*z
  }
  object { // Cylndr093 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 56.25*z
    translate  -0.0*z
  }
  object { // Cylndr094 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 50.625*z
    translate  -0.0*z
  }
  object { // Cylndr095 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 45.0*z
    translate  -0.0*z
  }
  object { // Cylndr096 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 39.375*z
    translate  -0.0*z
  }
  object { // Cylndr097 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 33.75*z
    translate  -0.0*z
  }
  object { // Cylndr098 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 28.125*z
    translate  -0.0*z
  }
  object { // Cylndr099 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 22.5*z
    translate  -0.0*z
  }
  object { // Cylndr100 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 16.875*z
    translate  -0.0*z
  }
  object { // Cylndr101 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 11.25*z
    translate  -0.0*z
  }
  object { // Cylndr102 -> Cylndr035
    Cylndr035
    photons {
      collect off
    }
    rotate 5.625*z
    translate  -0.0*z
  }
  photons {
    collect off
  }
}
#declare base17 = difference {
  cylinder { // base1
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.6, 0.6, 0.05>
    translate  -0.025*z
  }
  object { dientes1 }
  photons {
    collect off
  }
}
#declare resta_gear1 = union {
  object { Cylndr051 }
  object { // Cylndr052 -> Cylndr051
    Cylndr051
    photons {
      collect off
    }
    scale -1.0
    rotate 180.0*z
  }
  material {
    acero_txt
  }
  photons {
    collect off
  }
}
#declare diferencia_base_17 = difference {
  object { base17 }
  object { resta_gear1 }
  photons {
    collect off
  }
}
#declare relieve_interno1 = union {
  object { Cylndr053 }
  object { // Cylndr054 -> Cylndr053
    Cylndr053
    photons {
      collect off
    }
    scale -1.0
    rotate 180.0*z
  }
  photons {
    collect off
  }
}
#declare gear16_A1 = union {
  object { diferencia_base_17 }
  object { relieve_interno1 }
  photons {
    collect off
  }
}
#declare Gear_64 = difference {
  object { gear16_A1 }
  cylinder { // resta_agujero1
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.3>
    translate  -0.15*z
  }
  material {
    azul
  }
  photons {
    collect off
  }
  translate  -0.010842*z
}
#declare base_gear12 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.15, 0.3>
    translate  -0.15*z
  }
  object { // Cylndr033 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate 30.0*z
  }
  object { // Cylndr032 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate 60.0*z
  }
  object { // Cylndr031 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate 90.0*z
  }
  object { // Cylndr030 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate 120.0*z
  }
  object { // Cylndr029 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate 150.0*z
  }
  object { // Cylndr028 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate -180.0*z
  }
  object { // Cylndr027 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate -150.0*z
  }
  object { // Cylndr026 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate -120.0*z
  }
  object { // Cylndr025 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate -90.0*z
  }
  object { // Cylndr024 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate -60.0*z
  }
  object { // Cylndr023 -> Cylndr018
    Cylndr018
    photons {
      collect off
    }
    rotate -30.0*z
  }
  object { Cylndr018 }
  photons {
    collect off
  }
}
#declare gear_12 = union {
  object { tapaup }
  object { // tapadown -> tapaup
    tapaup
    photons {
      collect off
    }
    scale -1.0
    rotate -0.0*z
  }
  object { base_gear12 }
  material {
    azul
  }
  photons {
    collect off
  }
  scale <1.0, 1.0, 0.4>
  rotate -15.0*z
  translate  <0.0, -0.724598, -0.004819>
}
#declare dif_sosten = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.025>
    rotate -45.0*z
    translate  <0.0, -1.085332, 0.101664>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.6, 0.4, 0.05>
    translate  <0.0, -1.319728, 0.10257>
  }
  photons {
    collect off
  }
  scale <1.0, 1.0, 2.0>
  translate  <0.0, 0.004361, -0.083265>
}
#declare anillas_all = union {
  object { anillas }
  object { // anillas1 -> anillas
    anillas
    photons {
      collect off
    }
    translate  -0.048671*z
  }
  object { // anillas2 -> anillas
    anillas
    photons {
      collect off
    }
    translate  -0.218601*z
  }
  object { // anillas3 -> anillas
    anillas
    photons {
      collect off
    }
    translate  -0.298537*z
  }
  photons {
    collect off
  }
  scale <1.0, 1.0, 2.0>
  translate  <0.0, 0.004361, -0.083265>
}
#declare CSG001 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.1, 0.4, 0.05>
    translate  <0.0, -0.3, 0.12>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.175, 0.175, 0.1>
    translate  <0.0, -0.718972, 0.07>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.4, 0.1, 0.3>
    translate  <0.0, -1.015339, -0.130469>
  }
  object { dif_sosten }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.5, 0.08>
    translate  <0.0, -0.413976, -0.346729>
  }
  object { anillas_all }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.4, 0.1, 0.5>
    rotate -45.0*x
    translate  <0.0, -1.344211, -0.271605>
  }
  material {
    T_Wood35
    scale <0.5, 4.0, 0.5>
    rotate -90.0*y
  }
  photons {
    collect off
  }
  scale <1.0, 1.0, 0.5>
  translate  <0.0, -0.004361, 0.041633>
}
#declare restas1 = union {
  cylinder { // resta_agujero2
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.35>
    translate  -0.2*z
  }
  cylinder { // resta_agujero3
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.35>
    translate  <0.0, -0.724292, -0.2>
  }
  material {
    marron
  }
  photons {
    collect off
  }
}
#declare base_sosten = difference {
  object { CSG001 }
  object { restas1 }
  photons {
    collect off
  }
}
#declare cil_topes = union {
  cylinder { // resta_agujero4
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.0475, 0.0475, 0.3>
    translate  -0.163019*z
  }
  cylinder { // resta_agujero5
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.0475, 0.0475, 0.3>
    translate  <0.0, -0.724292, -0.183715>
  }
  sphere { // Sphere001
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.0525, 0.0525, 0.01>
    translate  <0.0, -0.724381, -0.182115>
  }
  sphere { // Sphere002
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.0525, 0.0525, 0.01>
    translate  0.134939*z
  }
  material {
    negro
  }
  photons {
    collect off
  }
}
#declare sosten = union {
  object { base_sosten }
  object { cil_topes }
  photons {
    collect off
  }
}
#declare mecanismo = union {
  object { Gear_64 }
  object { gear_12 }
  object { sosten }
  photons {
    collect off
  }
  scale <1.0, 1.0, -1.0>
  rotate 90.0*x
  translate  0.15285*y
}
#declare Cylndr103 = object {
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.15, 0.03>
    translate  0.01*z
  }
}
#declare paleta = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.33333, 0.55, 0.015>
    translate  <-1.698491, 0.0, 0.03>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 0.33, 0.015>
    translate  <-1.419604, 0.0, 0.059939>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 0.55, 0.015>
    translate  <-1.973226, 0.0, 0.059939>
  }
  photons {
    collect off
  }
}
#declare paletas = union {
  object { paleta }
  object { // paleta1 -> paleta
    paleta
    photons {
      collect off
    }
    rotate <180.0, 0.0, 180.0>
  }
  material {
    paletas_txt
  }
  photons {
    collect off
  }
  scale <-0.055556, -0.111111, -1.0>
  rotate <-180.0, 0.0, -180.0>
  translate  <0.0, 0.157006, 0.024656>
}
#declare CSG002 = union {
  object { Cylndr103 }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.15, 0.03>
    translate  <0.0, 0.314, 0.01>
  }
  object { paletas }
  photons {
    collect off
  }
  scale <1.0, -1.0, 1.0>
}
#declare paleta_doble = difference {
  object { CSG002 }
  object { // Cylndr106 -> Cylndr103
    Cylndr103
    photons {
      collect off
    }
    scale <0.965, 0.965, 6.0>
    rotate 180.0*z
    translate  <0.0, -0.314, -0.124671>
  }
  object { // Cylndr104 -> Cylndr103
    Cylndr103
    photons {
      collect off
    }
    scale <0.965, 0.965, 6.0>
    rotate 180.0*z
    translate  -0.12467*z
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.166667, 0.133333, 0.1>
    translate  <0.0, -0.351185, 0.024656>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.166667, 0.133333, 0.1>
    translate  <0.0, 0.037626, 0.024656>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 0.1, 0.1>
    translate  <0.163038, -0.156894, 0.024656>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 0.1, 0.1>
    translate  <-0.162849, -0.15541, 0.024656>
  }
  material {
    aspa_txt
  }
  photons {
    collect off
  }
  scale <18.0, 9.0, 1.0>
  translate  <0.0, 1.413053, -0.024656>
}
#declare paletas_aspa = union {
  object { paleta_doble }
  object { // paleta_doble1 -> paleta doble
    paleta_doble
    photons {
      collect off
    }
    rotate -60.0*y
    translate  <-0.010415, -0.0, -0.020118>
  }
  object { // paleta_doble2 -> paleta doble
    paleta_doble
    photons {
      collect off
    }
    rotate <-180.0, -60.0, -180.0>
    translate  <0.011129, -0.0, -0.01823>
  }
  photons {
    collect off
  }
}
#declare aspa = union {
  superellipsoid { // SuperQ001
    <1.0, 0.1>
    material {
      T_Wood33
    }
    photons {
      collect off
    }
    scale 0.2
    rotate -90.0*x
  }
  cylinder { // cil_eje_aspa
    <0,0,1>, <0,0,0>, 1 
    material {
      negro
    }
    photons {
      collect off
    }
    scale <0.0475, 0.0475, 0.7>
    rotate 90.0*x
    translate  0.22*y
  }
  object { paletas_aspa }
  photons {
    collect off
  }
  translate  <0.0, 0.638513, -0.72429>
}
#declare rotor1 = union {
  object { mecanismo }
  object { aspa }
  photons {
    collect off
  }
  translate  2.044609*y
}
#declare codo = difference {
  torus { // Torus003
    1.5, 0.5  rotate -x*90
    photons {
      collect off
    }
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.2, 1.2, 0.7>
    translate  1.2*y
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.2, 2.2, 0.7>
    translate  1.2*x
  }
  photons {
    collect off
  }
  scale 0.095
  rotate -90.0*y
  translate  <0.0, 1.800986, 0.14221>
}
#declare codo1 = difference {
  torus { // Torus004
    1.5, 0.5  rotate -x*90
    photons {
      collect off
    }
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.2, 1.2, 0.7>
    translate  1.2*y
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.2, 2.2, 0.7>
    translate  1.2*x
  }
  photons {
    collect off
  }
  scale 0.095
  rotate <180.0, 90.0, 0.0>
  translate  <0.0, 1.516662, 0.491362>
}
#declare CSG003 = union {
  cylinder { // cil_eje_aspa1
    <0,0,1>, <0,0,0>, 1 
    material {
      negro
    }
    photons {
      collect off
    }
    scale <0.0475, 0.0475, 0.3>
    rotate 90.0*x
    translate  2.1*y
  }
  object { codo }
  cylinder { // cil_eje_aspa4
    <0,0,1>, <0,0,0>, 1 
    material {
      negro
    }
    photons {
      collect off
    }
    scale <0.0475, 0.0475, 0.35>
    translate  <0.0, 1.658754, 0.141397>
  }
  object { codo1 }
  cylinder { // cil_eje_aspa2
    <0,0,1>, <0,0,0>, 1 
    material {
      negro
    }
    photons {
      collect off
    }
    scale <0.0475, 0.0475, 0.05>
    rotate 90.0*x
    translate  <0.0, 1.517998, 0.633692>
  }
  photons {
    collect off
  }
}
#declare barra1 = union {
  object { CSG003 }
  object { // CSG004 -> CSG003
    CSG003
    photons {
      collect off
    }
    scale -1.0
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 1.96439, 0.0>
  }
  cylinder { // cil_eje_aspa5
    <0,0,1>, <0,0,0>, 1 
    material {
      negro
    }
    photons {
      collect off
    }
    scale <0.03, 0.03, 1.0>
    rotate 90.0*x
    translate  <0.0, 1.477964, 0.633692>
  }
  cylinder { // cil_eje_aspa6
    <0,0,1>, <0,0,0>, 1 
    material {
      paletas_txt
    }
    photons {
      collect off
    }
    scale <0.04, 0.04, 0.93>
    rotate 90.0*x
    translate  <0.0, 1.449429, 0.633692>
  }
  photons {
    collect off
  }
}


#declare lateral1 = object {
  box { // lateral1
    <-1, -1, -1>, <1, 1, 1>
    material {
      Yellow_Pine_2
    }
    photons {
      collect off
    }
    scale <16.0, 0.3, 1.0>
    translate  -4.0*y
  }
}
#declare peldanio1 = union {
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    material {
      Yellow_Pine_1_1
      scale <0.1, 1.0, 1.0>
    }
    photons {
      collect off
    }
    scale <0.25, 4.0, 0.95>
  }
  sphere { // Sphere023
    <0,0,0>,1
    material {
      negro_escalera_1
    }
    photons {
      collect off
    }
    scale <0.3, 0.1, 0.3>
    translate  <0.0, -4.3, 0.57>
  }
  sphere { // Sphere024
    <0,0,0>,1
    material {
      negro_escalera_1
    }
    photons {
      collect off
    }
    scale <0.3, 0.1, 0.3>
    translate  <0.0, -4.3, -0.57>
  }
  sphere { // Sphere025
    <0,0,0>,1
    material {
      negro_escalera_1
    }
    photons {
      collect off
    }
    scale <0.3, 0.1, 0.3>
    translate  <0.0, 4.3, 0.57>
  }
  sphere { // Sphere026
    <0,0,0>,1
    material {
      negro_escalera_1
    }
    photons {
      collect off
    }
    scale <0.3, 0.1, 0.3>
    translate  <0.0, 4.3, -0.57>
  }
  material {
    Yellow_Pine_2
  }
  photons {
    collect off
  }
  rotate 25.0*y
  translate  <-11.0, 0.0, 0.004429>
}
#declare bisagra = union {
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.3, 0.9, 0.05>
    translate  <-4.005933, -7.646662, 16.033033>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale 0.4
    rotate -90.0*y
    translate  <-3.798664, -6.643667, 16.168889>
  }
  photons {
    collect off
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare bisagras = union {
  object { bisagra }
  object { // bisagra1 -> bisagra
    bisagra
    photons {
      collect off
    }
    translate  7.975449*x
  }
  material {
    negro_escalera_1
  }
  photons {
    collect off
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, -0.0, -7.746981>
}
#declare escalera = union {
  object { lateral1 }
  object { // lateral2 -> lateral1
    lateral1
    photons {
      collect off
    }
    translate  8.0*y
  }
  object { peldanio1 }
  object { // peldanio2 -> peldanio1
    peldanio1
    photons {
      collect off
    }
    translate  4.5*x
  }
  object { // peldanio3 -> peldanio1
    peldanio1
    photons {
      collect off
    }
    translate  9.0*x
  }
  object { // peldanio4 -> peldanio1
    peldanio1
    photons {
      collect off
    }
    translate  13.5*x
  }
  object { // peldanio5 -> peldanio1
    peldanio1
    photons {
      collect off
    }
    translate  18.0*x
  }
  object { bisagras }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    material {
      negro_escalera_1
    }
    photons {
      collect off
    }
    scale <0.3, 0.3, 8.0>
    rotate <-90.0, 0.0, -180.0>
    translate  <-0.321157, 3.963931, -0.380125>
  }
  torus { // Torus005
    1.5, 0.45  rotate -x*90
    material {
      negro_escalera_1
    }
    photons {
      collect off
    }
    scale 0.3
    rotate <-90.0, 0.0, -180.0>
    translate  <-0.325339, -0.002077, -0.379886>
  }
  object { // peldanio6 -> peldanio1
    peldanio1
    photons {
      collect off
    }
    translate  22.5*x
  }
  photons {
    collect off
  }
  rotate <0.0, 65.0, -90.0>
  translate  -7.8318*y
}


#declare Cylndr164 = object {
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.1>
    rotate 90.0*x
    translate  <0.0, 0.05, 0.212535>
  }
}




//
// ********  OBJECTS  *******
//

#declare CSG007 = union {
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <5.5, 0.2, 0.3>
    rotate 0.0*y
    translate  <-3.945534, 0.0, 11.056795>
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    material {
      acero_txt
    }
    photons {
      collect off
    }
    scale <5.45, 0.31, 0.31>
    rotate -45.0*x
    translate  <-3.965102, 0.0, 11.053686>
  }
  photons {
    collect off
  }
}
#declare carril3 = difference {
  object { CSG007 }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    material {
      hierros_txt
    }
    photons {
      collect off
    }
    scale <5.6, 0.15, 0.2>
    translate  <-3.945534, 0.0, 11.319455>
  }
  material {
    acero_txt
  }
  photons {
    collect off
  }
  scale <0.9, 1.2, 1.0>
  translate  <4.338243, 0.0, -15.644454>
}
#declare carril_quilla = union {
  object { carril3 }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    material {
      acero_txt
    }
    photons {
      collect off
    }
    scale <5.0, 1.2, 0.02>
    translate  <0.825606, 0.0, -4.612244>
  }
  photons {
    collect off
  }
  translate  0.058594*z
}
union { // sosten_barca
  object { carril_quilla }
  object { apoyos1 }
  object { // apoyos2 -> apoyos1
    apoyos1
    photons {
      collect off
    }
    scale -1.0
    rotate <-180.0, 0.0, -180.0>
  }
  photons {
    collect off
  }
}


#declare leo_cuarto = difference {
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    translate  10.0*z
    material {
      blanco
    }
    photons {
      collect off
    }
    scale <4.0, 5.0, 3.0>
    translate  <0.543885, -17.54223, -31.6916>
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    translate  10.0*z
    material {
      blanco
    }
    photons {
      collect off
    }
    scale <3.9, 5.0, 2.9>
    translate  <0.543885, -17.433067, -30.709132>
  }
  material {
    blanco
  }
  photons {
    collect off
  }
}
#declare sPatchObj5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.144960, -0.441176, 0.066469>, <-3.144960, -0.441176, -0.085251>, <-3.144960, -0.441176, -0.287543>, <-3.144960, -0.441176, -0.439263>, 
      <-1.257984, -0.441176, 0.066469>, <-1.257984, -0.441176, -0.085251>, <-1.257984, -0.441176, -0.287543>, <-1.257984, -0.441176, -0.439263>, 
      <1.257984, -0.441176, 0.066469>, <1.257984, -0.441176, -0.085251>, <1.257984, -0.441176, -0.287543>, <1.257984, -0.441176, -0.439263>, 
      <3.144960, -0.441176, 0.066469>, <3.144960, -0.441176, -0.085251>, <3.144960, -0.441176, -0.287543>, <3.144960, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561255, -0.441176, 0.154704>, <-2.561255, -0.441176, -0.023486>, <-2.561255, -0.441176, -0.261073>, <-2.561255, -0.441176, -0.439263>, 
      <-2.736902, -0.441176, 0.132057>, <-2.736902, -0.441176, -0.046133>, <-2.736367, -0.441176, -0.261073>, <-2.736367, -0.441176, -0.439263>, 
      <-2.969849, -0.441176, 0.092939>, <-2.969849, -0.441176, -0.058780>, <-2.969849, -0.441176, -0.287543>, <-2.969849, -0.441176, -0.439263>, 
      <-3.144960, -0.441176, 0.066469>, <-3.144960, -0.441176, -0.085251>, <-3.144960, -0.441176, -0.287543>, <-3.144960, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.947359, -0.441176, 0.220881>, <-1.947359, -0.441176, 0.022838>, <-1.947359, -0.441176, -0.241220>, <-1.947359, -0.441176, -0.439263>, 
      <-2.131566, -0.441176, 0.201383>, <-2.131566, -0.441176, 0.003340>, <-2.131528, -0.441176, -0.241220>, <-2.131528, -0.441176, -0.439263>, 
      <-2.377540, -0.441176, 0.178391>, <-2.377540, -0.441176, 0.000201>, <-2.377087, -0.441176, -0.261073>, <-2.377087, -0.441176, -0.439263>, 
      <-2.561255, -0.441176, 0.154704>, <-2.561255, -0.441176, -0.023486>, <-2.561255, -0.441176, -0.261073>, <-2.561255, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.310819, -0.441176, 0.287057>, <-1.310819, -0.441176, 0.069161>, <-1.310819, -0.441176, -0.221367>, <-1.310819, -0.441176, -0.439263>, 
      <-1.502111, -0.441176, 0.270678>, <-1.502111, -0.441176, 0.052783>, <-1.501781, -0.441176, -0.221367>, <-1.501781, -0.441176, -0.439263>, 
      <-1.756435, -0.441176, 0.241089>, <-1.756435, -0.441176, 0.043046>, <-1.756397, -0.441176, -0.241220>, <-1.756397, -0.441176, -0.439263>, 
      <-1.947359, -0.441176, 0.220881>, <-1.947359, -0.441176, 0.022838>, <-1.947359, -0.441176, -0.241220>, <-1.947359, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.659184, -0.441176, 0.331174>, <-0.659184, -0.441176, 0.100043>, <-0.659184, -0.441176, -0.208132>, <-0.659184, -0.441176, -0.439263>, 
      <-0.854873, -0.441176, 0.321295>, <-0.854873, -0.441176, 0.090164>, <-0.854675, -0.441176, -0.208132>, <-0.854675, -0.441176, -0.439263>, 
      <-1.115596, -0.441176, 0.303772>, <-1.115596, -0.441176, 0.085876>, <-1.115329, -0.441176, -0.221367>, <-1.115329, -0.441176, -0.439263>, 
      <-1.310819, -0.441176, 0.287057>, <-1.310819, -0.441176, 0.069161>, <-1.310819, -0.441176, -0.221367>, <-1.310819, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.441176, 0.353233>, <0.000000, -0.441176, 0.115485>, <0.000000, -0.441176, -0.201514>, <0.000000, -0.441176, -0.439263>, 
      <-0.197866, -0.441176, 0.353233>, <-0.197866, -0.441176, 0.115485>, <-0.197755, -0.441176, -0.201514>, <-0.197755, -0.441176, -0.439263>, 
      <-0.461570, -0.441176, 0.341151>, <-0.461570, -0.441176, 0.110020>, <-0.461429, -0.441176, -0.208132>, <-0.461429, -0.441176, -0.439263>, 
      <-0.659184, -0.441176, 0.331174>, <-0.659184, -0.441176, 0.100043>, <-0.659184, -0.441176, -0.208132>, <-0.659184, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.659184, -0.441176, 0.331174>, <0.659184, -0.441176, 0.100043>, <0.659184, -0.441176, -0.208132>, <0.659184, -0.441176, -0.439263>, 
      <0.461570, -0.441176, 0.341151>, <0.461570, -0.441176, 0.110020>, <0.461429, -0.441176, -0.208132>, <0.461429, -0.441176, -0.439263>, 
      <0.197866, -0.441176, 0.353233>, <0.197866, -0.441176, 0.115485>, <0.197755, -0.441176, -0.201514>, <0.197755, -0.441176, -0.439263>, 
      <0.000000, -0.441176, 0.353233>, <0.000000, -0.441176, 0.115485>, <0.000000, -0.441176, -0.201514>, <0.000000, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.310819, -0.441176, 0.287057>, <1.310819, -0.441176, 0.069161>, <1.310819, -0.441176, -0.221367>, <1.310819, -0.441176, -0.439263>, 
      <1.115595, -0.441176, 0.303772>, <1.115595, -0.441176, 0.085876>, <1.115329, -0.441176, -0.221367>, <1.115329, -0.441176, -0.439263>, 
      <0.854873, -0.441176, 0.321295>, <0.854873, -0.441176, 0.090164>, <0.854674, -0.441176, -0.208132>, <0.854674, -0.441176, -0.439263>, 
      <0.659184, -0.441176, 0.331174>, <0.659184, -0.441176, 0.100043>, <0.659184, -0.441176, -0.208132>, <0.659184, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.947359, -0.441176, 0.220881>, <1.947359, -0.441176, 0.022838>, <1.947359, -0.441176, -0.241220>, <1.947359, -0.441176, -0.439263>, 
      <1.756435, -0.441176, 0.241089>, <1.756435, -0.441176, 0.043046>, <1.756397, -0.441176, -0.241220>, <1.756397, -0.441176, -0.439263>, 
      <1.502111, -0.441176, 0.270678>, <1.502111, -0.441176, 0.052783>, <1.501781, -0.441176, -0.221367>, <1.501781, -0.441176, -0.439263>, 
      <1.310819, -0.441176, 0.287057>, <1.310819, -0.441176, 0.069161>, <1.310819, -0.441176, -0.221367>, <1.310819, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.561256, -0.441176, 0.154704>, <2.561256, -0.441176, -0.023486>, <2.561256, -0.441176, -0.261073>, <2.561256, -0.441176, -0.439263>, 
      <2.377541, -0.441176, 0.178391>, <2.377541, -0.441176, 0.000201>, <2.377087, -0.441176, -0.261073>, <2.377087, -0.441176, -0.439263>, 
      <2.131566, -0.441176, 0.201383>, <2.131566, -0.441176, 0.003340>, <2.131528, -0.441176, -0.241220>, <2.131528, -0.441176, -0.439263>, 
      <1.947359, -0.441176, 0.220881>, <1.947359, -0.441176, 0.022838>, <1.947359, -0.441176, -0.241220>, <1.947359, -0.441176, -0.439263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.144960, -0.441176, 0.066469>, <3.144960, -0.441176, -0.085251>, <3.144960, -0.441176, -0.287543>, <3.144960, -0.441176, -0.439263>, 
      <2.969849, -0.441176, 0.092939>, <2.969849, -0.441176, -0.058780>, <2.969849, -0.441176, -0.287543>, <2.969849, -0.441176, -0.439263>, 
      <2.736902, -0.441176, 0.132057>, <2.736902, -0.441176, -0.046133>, <2.736367, -0.441176, -0.261073>, <2.736367, -0.441176, -0.439263>, 
      <2.561256, -0.441176, 0.154704>, <2.561256, -0.441176, -0.023486>, <2.561256, -0.441176, -0.261073>, <2.561256, -0.441176, -0.439263>
    }
  }
  material {
    cena_txt
    scale <3.109477, 1.0, 0.36>
    translate <0.000000, 0.000000, -0.050144>
  }
  photons {
    collect off
  }
}
#declare sPatchObj6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.465441, -0.396248>, <0.193878, -0.465441, -0.396248>, <0.452381, -0.465441, -0.396248>, <0.646258, -0.465441, -0.396248>, 
      <0.000000, -0.390282, -0.372738>, <0.193878, -0.390282, -0.372738>, <0.438666, -0.391431, -0.373098>, <0.632544, -0.391431, -0.373098>, 
      <0.000000, -0.281691, -0.396248>, <0.193878, -0.281691, -0.396248>, <0.452381, -0.281691, -0.396248>, <0.646258, -0.281691, -0.396248>, 
      <0.000000, -0.202941, -0.396248>, <0.193878, -0.202941, -0.396248>, <0.452381, -0.202941, -0.396248>, <0.646258, -0.202941, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.646258, -0.465441, -0.396248>, <0.837916, -0.465441, -0.396248>, <1.093460, -0.465441, -0.396248>, <1.285117, -0.465441, -0.396248>, 
      <0.632544, -0.391431, -0.373098>, <0.824201, -0.391431, -0.373098>, <1.067333, -0.394539, -0.374070>, <1.258990, -0.394539, -0.374070>, 
      <0.646258, -0.281691, -0.396248>, <0.837916, -0.281691, -0.396248>, <1.093460, -0.281691, -0.396248>, <1.285117, -0.281691, -0.396248>, 
      <0.646258, -0.202941, -0.396248>, <0.837916, -0.202941, -0.396248>, <1.093460, -0.202941, -0.396248>, <1.285117, -0.202941, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.285117, -0.465441, -0.396248>, <1.472335, -0.465441, -0.396248>, <1.721958, -0.465441, -0.396248>, <1.909176, -0.465441, -0.396248>, 
      <1.258990, -0.394539, -0.374070>, <1.446208, -0.394539, -0.374070>, <1.685491, -0.398826, -0.375411>, <1.872709, -0.398826, -0.375411>, 
      <1.285117, -0.281691, -0.396248>, <1.472335, -0.281691, -0.396248>, <1.721958, -0.281691, -0.396248>, <1.909176, -0.281691, -0.396248>, 
      <1.285117, -0.202941, -0.396248>, <1.472335, -0.202941, -0.396248>, <1.721958, -0.202941, -0.396248>, <1.909176, -0.202941, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909176, -0.465441, -0.396248>, <2.089734, -0.465441, -0.396248>, <2.330477, -0.465441, -0.396248>, <2.511035, -0.465441, -0.396248>, 
      <1.872709, -0.398826, -0.375411>, <2.053267, -0.398826, -0.375411>, <2.285877, -0.403497, -0.376872>, <2.466435, -0.403497, -0.376872>, 
      <1.909176, -0.281691, -0.396248>, <2.089734, -0.281691, -0.396248>, <2.330477, -0.281691, -0.396248>, <2.511035, -0.281691, -0.396248>, 
      <1.909176, -0.202941, -0.396248>, <2.089734, -0.202941, -0.396248>, <2.330477, -0.202941, -0.396248>, <2.511035, -0.202941, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.511035, -0.465441, -0.396248>, <2.682713, -0.465441, -0.396248>, <2.911617, -0.465441, -0.396248>, <3.083295, -0.465441, -0.396248>, 
      <2.466435, -0.403497, -0.376872>, <2.638113, -0.403497, -0.376872>, <2.860832, -0.407998, -0.378280>, <3.032510, -0.407998, -0.378280>, 
      <2.511035, -0.281691, -0.396248>, <2.682713, -0.281691, -0.396248>, <2.911617, -0.281691, -0.396248>, <3.083295, -0.281691, -0.396248>, 
      <2.511035, -0.202941, -0.396248>, <2.682713, -0.202941, -0.396248>, <2.911617, -0.202941, -0.396248>, <3.083295, -0.202941, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.646259, -0.465441, -0.396248>, <-0.452381, -0.465441, -0.396248>, <-0.193878, -0.465441, -0.396248>, <0.000000, -0.465441, -0.396248>, 
      <-0.632544, -0.391431, -0.373098>, <-0.438666, -0.391431, -0.373098>, <-0.193878, -0.390282, -0.372738>, <0.000000, -0.390282, -0.372738>, 
      <-0.646259, -0.281691, -0.396248>, <-0.452381, -0.281691, -0.396248>, <-0.193878, -0.281691, -0.396248>, <0.000000, -0.281691, -0.396248>, 
      <-0.646259, -0.202941, -0.396248>, <-0.452381, -0.202941, -0.396248>, <-0.193878, -0.202941, -0.396248>, <0.000000, -0.202941, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.285117, -0.465441, -0.396248>, <-1.093460, -0.465441, -0.396248>, <-0.837916, -0.465441, -0.396248>, <-0.646259, -0.465441, -0.396248>, 
      <-1.258990, -0.394539, -0.374070>, <-1.067333, -0.394539, -0.374070>, <-0.824202, -0.391431, -0.373098>, <-0.632544, -0.391431, -0.373098>, 
      <-1.285117, -0.281691, -0.396248>, <-1.093460, -0.281691, -0.396248>, <-0.837916, -0.281691, -0.396248>, <-0.646259, -0.281691, -0.396248>, 
      <-1.285117, -0.202941, -0.396248>, <-1.093460, -0.202941, -0.396248>, <-0.837916, -0.202941, -0.396248>, <-0.646259, -0.202941, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.909176, -0.465441, -0.396248>, <-1.721958, -0.465441, -0.396248>, <-1.472335, -0.465441, -0.396248>, <-1.285117, -0.465441, -0.396248>, 
      <-1.872709, -0.398826, -0.375411>, <-1.685491, -0.398826, -0.375411>, <-1.446208, -0.394539, -0.374070>, <-1.258990, -0.394539, -0.374070>, 
      <-1.909176, -0.281691, -0.396248>, <-1.721958, -0.281691, -0.396248>, <-1.472335, -0.281691, -0.396248>, <-1.285117, -0.281691, -0.396248>, 
      <-1.909176, -0.202941, -0.396248>, <-1.721958, -0.202941, -0.396248>, <-1.472335, -0.202941, -0.396248>, <-1.285117, -0.202941, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.511035, -0.465441, -0.396248>, <-2.330477, -0.465441, -0.396248>, <-2.089733, -0.465441, -0.396248>, <-1.909176, -0.465441, -0.396248>, 
      <-2.466435, -0.403497, -0.376872>, <-2.285877, -0.403497, -0.376872>, <-2.053266, -0.398826, -0.375411>, <-1.872709, -0.398826, -0.375411>, 
      <-2.511035, -0.281691, -0.396248>, <-2.330477, -0.281691, -0.396248>, <-2.089733, -0.281691, -0.396248>, <-1.909176, -0.281691, -0.396248>, 
      <-2.511035, -0.202941, -0.396248>, <-2.330477, -0.202941, -0.396248>, <-2.089733, -0.202941, -0.396248>, <-1.909176, -0.202941, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.909176, -0.465441, -0.396248>, <-1.932168, -0.507441, -0.409386>, <-2.017224, -0.493353, -0.457986>, <-2.052877, -0.465441, -0.478359>, 
      <-2.089733, -0.465441, -0.396248>, <-2.112726, -0.507441, -0.409386>, <-2.211372, -0.493353, -0.457986>, <-2.247025, -0.465441, -0.478359>, 
      <-2.330477, -0.465441, -0.396248>, <-2.365489, -0.514068, -0.411459>, <-2.456122, -0.495064, -0.456738>, <-2.505889, -0.465441, -0.478359>, 
      <-2.511035, -0.465441, -0.396248>, <-2.546046, -0.514068, -0.411459>, <-2.650270, -0.495064, -0.456738>, <-2.700037, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.285117, -0.465441, -0.396248>, <-1.297746, -0.499712, -0.406968>, <-1.360133, -0.490694, -0.459927>, <-1.381846, -0.465441, -0.478359>, 
      <-1.472335, -0.465441, -0.396248>, <-1.484963, -0.499712, -0.406968>, <-1.561443, -0.490694, -0.459927>, <-1.583156, -0.465441, -0.478359>, 
      <-1.721958, -0.465441, -0.396248>, <-1.744951, -0.507441, -0.409386>, <-1.815914, -0.493353, -0.457986>, <-1.851568, -0.465441, -0.478359>, 
      <-1.909176, -0.465441, -0.396248>, <-1.932168, -0.507441, -0.409386>, <-2.017224, -0.493353, -0.457986>, <-2.052877, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.646259, -0.465441, -0.396248>, <-0.651245, -0.492349, -0.404665>, <-0.685461, -0.487274, -0.462423>, <-0.694902, -0.465441, -0.478359>, 
      <-0.837916, -0.465441, -0.396248>, <-0.842902, -0.492349, -0.404665>, <-0.891545, -0.487274, -0.462423>, <-0.900985, -0.465441, -0.478359>, 
      <-1.093460, -0.465441, -0.396248>, <-1.106088, -0.499712, -0.406968>, <-1.154050, -0.490694, -0.459927>, <-1.175763, -0.465441, -0.478359>, 
      <-1.285117, -0.465441, -0.396248>, <-1.297746, -0.499712, -0.406968>, <-1.360133, -0.490694, -0.459927>, <-1.381846, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.465441, -0.396248>, <0.000000, -0.488951, -0.403602>, <0.000000, -0.485338, -0.463836>, <0.000000, -0.465441, -0.478359>, 
      <-0.193878, -0.465441, -0.396248>, <-0.193878, -0.488951, -0.403602>, <-0.208471, -0.485338, -0.463836>, <-0.208471, -0.465441, -0.478359>, 
      <-0.452381, -0.465441, -0.396248>, <-0.457367, -0.492349, -0.404665>, <-0.476991, -0.487274, -0.462423>, <-0.486431, -0.465441, -0.478359>, 
      <-0.646259, -0.465441, -0.396248>, <-0.651245, -0.492349, -0.404665>, <-0.685461, -0.487274, -0.462423>, <-0.694902, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.646258, -0.465441, -0.396248>, <0.651245, -0.492349, -0.404665>, <0.685461, -0.487274, -0.462423>, <0.694902, -0.465441, -0.478359>, 
      <0.452381, -0.465441, -0.396248>, <0.457367, -0.492349, -0.404665>, <0.476991, -0.487274, -0.462423>, <0.486431, -0.465441, -0.478359>, 
      <0.193878, -0.465441, -0.396248>, <0.193878, -0.488951, -0.403602>, <0.208471, -0.485338, -0.463836>, <0.208471, -0.465441, -0.478359>, 
      <0.000000, -0.465441, -0.396248>, <0.000000, -0.488951, -0.403602>, <0.000000, -0.485338, -0.463836>, <0.000000, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.285117, -0.465441, -0.396248>, <1.297746, -0.499712, -0.406968>, <1.360133, -0.490694, -0.459927>, <1.381846, -0.465441, -0.478359>, 
      <1.093460, -0.465441, -0.396248>, <1.106088, -0.499712, -0.406968>, <1.154050, -0.490694, -0.459927>, <1.175763, -0.465441, -0.478359>, 
      <0.837916, -0.465441, -0.396248>, <0.842902, -0.492349, -0.404665>, <0.891545, -0.487274, -0.462423>, <0.900985, -0.465441, -0.478359>, 
      <0.646258, -0.465441, -0.396248>, <0.651245, -0.492349, -0.404665>, <0.685461, -0.487274, -0.462423>, <0.694902, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.909176, -0.465441, -0.396248>, <1.932168, -0.507441, -0.409386>, <2.017224, -0.493353, -0.457986>, <2.052877, -0.465441, -0.478359>, 
      <1.721958, -0.465441, -0.396248>, <1.744951, -0.507441, -0.409386>, <1.815914, -0.493353, -0.457986>, <1.851568, -0.465441, -0.478359>, 
      <1.472335, -0.465441, -0.396248>, <1.484963, -0.499712, -0.406968>, <1.561443, -0.490694, -0.459927>, <1.583156, -0.465441, -0.478359>, 
      <1.285117, -0.465441, -0.396248>, <1.297746, -0.499712, -0.406968>, <1.360133, -0.490694, -0.459927>, <1.381846, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.511035, -0.465441, -0.396248>, <2.546047, -0.514068, -0.411459>, <2.650270, -0.495064, -0.456738>, <2.700037, -0.465441, -0.478359>, 
      <2.330477, -0.465441, -0.396248>, <2.365489, -0.514068, -0.411459>, <2.456122, -0.495064, -0.456738>, <2.505889, -0.465441, -0.478359>, 
      <2.089734, -0.465441, -0.396248>, <2.112726, -0.507441, -0.409386>, <2.211372, -0.493353, -0.457986>, <2.247025, -0.465441, -0.478359>, 
      <1.909176, -0.465441, -0.396248>, <1.932168, -0.507441, -0.409386>, <2.017224, -0.493353, -0.457986>, <2.052877, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.083295, -0.465441, -0.396248>, <3.130921, -0.519311, -0.413099>, <3.252047, -0.496137, -0.455954>, <3.315371, -0.465441, -0.478359>, 
      <2.911617, -0.465441, -0.396248>, <2.959243, -0.519311, -0.413099>, <3.067447, -0.496137, -0.455954>, <3.130771, -0.465441, -0.478359>, 
      <2.682713, -0.465441, -0.396248>, <2.717725, -0.514068, -0.411459>, <2.834870, -0.495064, -0.456738>, <2.884637, -0.465441, -0.478359>, 
      <2.511035, -0.465441, -0.396248>, <2.546047, -0.514068, -0.411459>, <2.650270, -0.495064, -0.456738>, <2.700037, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.083079, -0.465441, 0.153670>, <2.045542, -0.402596, 0.124634>, <2.083079, -0.281691, 0.153670>, <2.083079, -0.202941, 0.153670>, 
      <2.238459, -0.465441, 0.133824>, <2.200922, -0.402596, 0.104788>, <2.238459, -0.281691, 0.133824>, <2.238459, -0.202941, 0.133824>, 
      <2.444767, -0.465441, 0.101034>, <2.399501, -0.404716, 0.079470>, <2.444767, -0.281691, 0.101034>, <2.444767, -0.202941, 0.101034>, 
      <2.599674, -0.465441, 0.077782>, <2.554408, -0.404716, 0.056218>, <2.599674, -0.281691, 0.077782>, <2.599674, -0.202941, 0.077782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.599459, -0.465441, 0.205538>, <1.569937, -0.401071, 0.171092>, <1.599459, -0.281691, 0.205538>, <1.599459, -0.202941, 0.205538>, 
      <1.744869, -0.465441, 0.193373>, <1.715347, -0.401071, 0.158927>, <1.744869, -0.281691, 0.193373>, <1.744869, -0.202941, 0.193373>, 
      <1.938337, -0.465441, 0.172158>, <1.900800, -0.402596, 0.143122>, <1.938337, -0.281691, 0.172158>, <1.938337, -0.202941, 0.172158>, 
      <2.083079, -0.465441, 0.153670>, <2.045542, -0.402596, 0.124634>, <2.083079, -0.281691, 0.153670>, <2.083079, -0.202941, 0.153670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.078154, -0.465441, 0.237744>, <1.057813, -0.399645, 0.199550>, <1.078154, -0.281691, 0.237744>, <1.078154, -0.202941, 0.237744>, 
      <1.234446, -0.465441, 0.226588>, <1.214105, -0.399645, 0.188394>, <1.234446, -0.281691, 0.226588>, <1.234446, -0.202941, 0.226588>, 
      <1.443315, -0.465441, 0.218601>, <1.413793, -0.401071, 0.184155>, <1.443315, -0.281691, 0.218601>, <1.443315, -0.202941, 0.218601>, 
      <1.599459, -0.465441, 0.205538>, <1.569937, -0.401071, 0.171092>, <1.599459, -0.281691, 0.205538>, <1.599459, -0.202941, 0.205538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.521305, -0.465441, 0.282494>, <0.511484, -0.399736, 0.240210>, <0.521305, -0.281691, 0.282494>, <0.521305, -0.202941, 0.282494>, 
      <0.688728, -0.465441, 0.274951>, <0.678907, -0.399736, 0.232667>, <0.688728, -0.281691, 0.274951>, <0.688728, -0.202941, 0.274951>, 
      <0.910986, -0.465441, 0.249676>, <0.890645, -0.399645, 0.211482>, <0.910986, -0.281691, 0.249676>, <0.910986, -0.202941, 0.249676>, 
      <1.078154, -0.465441, 0.237744>, <1.057813, -0.399645, 0.199550>, <1.078154, -0.281691, 0.237744>, <1.078154, -0.202941, 0.237744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.465441, 0.286320>, <0.000000, -0.399381, 0.243451>, <0.000000, -0.281691, 0.286320>, <0.000000, -0.202941, 0.286320>, 
      <0.156396, -0.465441, 0.286320>, <0.156396, -0.399381, 0.243451>, <0.156396, -0.281691, 0.286320>, <0.156396, -0.202941, 0.286320>, 
      <0.365068, -0.465441, 0.289533>, <0.355246, -0.399736, 0.247249>, <0.365068, -0.281691, 0.289533>, <0.365068, -0.202941, 0.289533>, 
      <0.521305, -0.465441, 0.282494>, <0.511484, -0.399736, 0.240210>, <0.521305, -0.281691, 0.282494>, <0.521305, -0.202941, 0.282494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521305, -0.465441, 0.282494>, <-0.511484, -0.399736, 0.240210>, <-0.521305, -0.281691, 0.282494>, <-0.521305, -0.202941, 0.282494>, 
      <-0.365068, -0.465441, 0.289533>, <-0.355246, -0.399736, 0.247249>, <-0.365068, -0.281691, 0.289533>, <-0.365068, -0.202941, 0.289533>, 
      <-0.156396, -0.465441, 0.286320>, <-0.156396, -0.399381, 0.243451>, <-0.156396, -0.281691, 0.286320>, <-0.156396, -0.202941, 0.286320>, 
      <0.000000, -0.465441, 0.286320>, <0.000000, -0.399381, 0.243451>, <0.000000, -0.281691, 0.286320>, <0.000000, -0.202941, 0.286320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.078154, -0.465441, 0.237744>, <-1.057813, -0.399645, 0.199550>, <-1.078154, -0.281691, 0.237744>, <-1.078154, -0.202941, 0.237744>, 
      <-0.910986, -0.465441, 0.249676>, <-0.890645, -0.399645, 0.211482>, <-0.910986, -0.281691, 0.249676>, <-0.910986, -0.202941, 0.249676>, 
      <-0.688728, -0.465441, 0.274951>, <-0.678907, -0.399736, 0.232667>, <-0.688728, -0.281691, 0.274951>, <-0.688728, -0.202941, 0.274951>, 
      <-0.521305, -0.465441, 0.282494>, <-0.511484, -0.399736, 0.240210>, <-0.521305, -0.281691, 0.282494>, <-0.521305, -0.202941, 0.282494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.599459, -0.465441, 0.205538>, <-1.569937, -0.401071, 0.171092>, <-1.599459, -0.281691, 0.205538>, <-1.599459, -0.202941, 0.205538>, 
      <-1.443315, -0.465441, 0.218601>, <-1.413793, -0.401071, 0.184155>, <-1.443315, -0.281691, 0.218601>, <-1.443315, -0.202941, 0.218601>, 
      <-1.234446, -0.465441, 0.226588>, <-1.214105, -0.399645, 0.188394>, <-1.234446, -0.281691, 0.226588>, <-1.234446, -0.202941, 0.226588>, 
      <-1.078154, -0.465441, 0.237744>, <-1.057813, -0.399645, 0.199550>, <-1.078154, -0.281691, 0.237744>, <-1.078154, -0.202941, 0.237744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.083079, -0.465441, 0.153670>, <-2.045542, -0.402596, 0.124634>, <-2.083079, -0.281691, 0.153670>, <-2.083079, -0.202941, 0.153670>, 
      <-1.938337, -0.465441, 0.172158>, <-1.900800, -0.402596, 0.143122>, <-1.938337, -0.281691, 0.172158>, <-1.938337, -0.202941, 0.172158>, 
      <-1.744869, -0.465441, 0.193373>, <-1.715347, -0.401071, 0.158927>, <-1.744869, -0.281691, 0.193373>, <-1.744869, -0.202941, 0.193373>, 
      <-1.599459, -0.465441, 0.205538>, <-1.569937, -0.401071, 0.171092>, <-1.599459, -0.281691, 0.205538>, <-1.599459, -0.202941, 0.205538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.599674, -0.465441, 0.077782>, <-2.554408, -0.404716, 0.056218>, <-2.599674, -0.281691, 0.077782>, <-2.599674, -0.202941, 0.077782>, 
      <-2.444767, -0.465441, 0.101034>, <-2.399501, -0.404716, 0.079470>, <-2.444767, -0.281691, 0.101034>, <-2.444767, -0.202941, 0.101034>, 
      <-2.238459, -0.465441, 0.133824>, <-2.200922, -0.402596, 0.104788>, <-2.238459, -0.281691, 0.133824>, <-2.238459, -0.202941, 0.133824>, 
      <-2.083079, -0.465441, 0.153670>, <-2.045542, -0.402596, 0.124634>, <-2.083079, -0.281691, 0.153670>, <-2.083079, -0.202941, 0.153670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.083295, -0.465441, 0.003540>, <-3.032029, -0.407455, -0.010986>, <-3.083295, -0.281691, 0.003540>, <-3.083295, -0.202941, 0.003540>, 
      <-2.938208, -0.465441, 0.025813>, <-2.886943, -0.407455, 0.011287>, <-2.938208, -0.281691, 0.025813>, <-2.938208, -0.202941, 0.025813>, 
      <-2.744833, -0.465441, 0.055994>, <-2.699567, -0.404716, 0.034430>, <-2.744833, -0.281691, 0.055994>, <-2.744833, -0.202941, 0.055994>, 
      <-2.599674, -0.465441, 0.077782>, <-2.554408, -0.404716, 0.056218>, <-2.599674, -0.281691, 0.077782>, <-2.599674, -0.202941, 0.077782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.052877, -0.465441, -0.478359>, <-2.077112, -0.446468, -0.492206>, <-2.030478, -0.367057, -0.457429>, <-2.052877, -0.352941, -0.478359>, 
      <-2.247025, -0.465441, -0.478359>, <-2.271260, -0.446468, -0.492206>, <-2.224626, -0.367057, -0.457429>, <-2.247025, -0.352941, -0.478359>, 
      <-2.505889, -0.465441, -0.478359>, <-2.533059, -0.449269, -0.490162>, <-2.480261, -0.365221, -0.460152>, <-2.505889, -0.352941, -0.478359>, 
      <-2.700037, -0.465441, -0.478359>, <-2.727207, -0.449269, -0.490162>, <-2.674409, -0.365221, -0.460152>, <-2.700037, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.381846, -0.465441, -0.478359>, <-1.401098, -0.443050, -0.494701>, <-1.364541, -0.369143, -0.454337>, <-1.381846, -0.352941, -0.478359>, 
      <-1.583156, -0.465441, -0.478359>, <-1.602408, -0.443050, -0.494701>, <-1.565850, -0.369143, -0.454337>, <-1.583156, -0.352941, -0.478359>, 
      <-1.851568, -0.465441, -0.478359>, <-1.875803, -0.446468, -0.492206>, <-1.829168, -0.367057, -0.457429>, <-1.851568, -0.352941, -0.478359>, 
      <-2.052877, -0.465441, -0.478359>, <-2.077112, -0.446468, -0.492206>, <-2.030478, -0.367057, -0.457429>, <-2.052877, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.694902, -0.465441, -0.478359>, <-0.706030, -0.439704, -0.497143>, <-0.685193, -0.371015, -0.451561>, <-0.694902, -0.352941, -0.478359>, 
      <-0.900985, -0.465441, -0.478359>, <-0.912113, -0.439704, -0.497143>, <-0.891277, -0.371015, -0.451561>, <-0.900985, -0.352941, -0.478359>, 
      <-1.175763, -0.465441, -0.478359>, <-1.195015, -0.443050, -0.494701>, <-1.158457, -0.369143, -0.454337>, <-1.175763, -0.352941, -0.478359>, 
      <-1.381846, -0.465441, -0.478359>, <-1.401098, -0.443050, -0.494701>, <-1.364541, -0.369143, -0.454337>, <-1.381846, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.465441, -0.478359>, <0.000000, -0.438180, -0.498256>, <0.000000, -0.371813, -0.450378>, <0.000000, -0.352941, -0.478359>, 
      <-0.208471, -0.465441, -0.478359>, <-0.208471, -0.438180, -0.498256>, <-0.208471, -0.371813, -0.450378>, <-0.208471, -0.352941, -0.478359>, 
      <-0.486431, -0.465441, -0.478359>, <-0.497559, -0.439704, -0.497143>, <-0.476723, -0.371015, -0.451561>, <-0.486431, -0.352941, -0.478359>, 
      <-0.694902, -0.465441, -0.478359>, <-0.706030, -0.439704, -0.497143>, <-0.685193, -0.371015, -0.451561>, <-0.694902, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.694902, -0.465441, -0.478359>, <0.706030, -0.439704, -0.497143>, <0.685193, -0.371015, -0.451561>, <0.694902, -0.352941, -0.478359>, 
      <0.486431, -0.465441, -0.478359>, <0.497559, -0.439704, -0.497143>, <0.476723, -0.371015, -0.451561>, <0.486431, -0.352941, -0.478359>, 
      <0.208471, -0.465441, -0.478359>, <0.208471, -0.438180, -0.498256>, <0.208471, -0.371813, -0.450378>, <0.208471, -0.352941, -0.478359>, 
      <0.000000, -0.465441, -0.478359>, <0.000000, -0.438180, -0.498256>, <0.000000, -0.371813, -0.450378>, <0.000000, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.381846, -0.465441, -0.478359>, <1.401098, -0.443050, -0.494701>, <1.364541, -0.369143, -0.454337>, <1.381846, -0.352941, -0.478359>, 
      <1.175763, -0.465441, -0.478359>, <1.195015, -0.443050, -0.494701>, <1.158457, -0.369143, -0.454337>, <1.175763, -0.352941, -0.478359>, 
      <0.900985, -0.465441, -0.478359>, <0.912113, -0.439704, -0.497143>, <0.891277, -0.371015, -0.451561>, <0.900985, -0.352941, -0.478359>, 
      <0.694902, -0.465441, -0.478359>, <0.706030, -0.439704, -0.497143>, <0.685193, -0.371015, -0.451561>, <0.694902, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.052877, -0.465441, -0.478359>, <2.077112, -0.446468, -0.492206>, <2.030478, -0.367057, -0.457429>, <2.052877, -0.352941, -0.478359>, 
      <1.851568, -0.465441, -0.478359>, <1.875803, -0.446468, -0.492206>, <1.829168, -0.367057, -0.457429>, <1.851568, -0.352941, -0.478359>, 
      <1.583156, -0.465441, -0.478359>, <1.602408, -0.443050, -0.494701>, <1.565850, -0.369143, -0.454337>, <1.583156, -0.352941, -0.478359>, 
      <1.381846, -0.465441, -0.478359>, <1.401098, -0.443050, -0.494701>, <1.364541, -0.369143, -0.454337>, <1.381846, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.700037, -0.465441, -0.478359>, <2.727207, -0.449269, -0.490162>, <2.674410, -0.365221, -0.460152>, <2.700037, -0.352941, -0.478359>, 
      <2.505889, -0.465441, -0.478359>, <2.533059, -0.449269, -0.490162>, <2.480262, -0.365221, -0.460152>, <2.505889, -0.352941, -0.478359>, 
      <2.247025, -0.465441, -0.478359>, <2.271260, -0.446468, -0.492206>, <2.224626, -0.367057, -0.457429>, <2.247025, -0.352941, -0.478359>, 
      <2.052877, -0.465441, -0.478359>, <2.077112, -0.446468, -0.492206>, <2.030478, -0.367057, -0.457429>, <2.052877, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.315371, -0.465441, -0.478359>, <3.344309, -0.451413, -0.488597>, <3.287694, -0.363741, -0.462346>, <3.315371, -0.352941, -0.478359>, 
      <3.130771, -0.465441, -0.478359>, <3.159709, -0.451413, -0.488597>, <3.103094, -0.363741, -0.462346>, <3.130771, -0.352941, -0.478359>, 
      <2.884637, -0.465441, -0.478359>, <2.911807, -0.449269, -0.490162>, <2.859010, -0.365221, -0.460152>, <2.884637, -0.352941, -0.478359>, 
      <2.700037, -0.465441, -0.478359>, <2.727207, -0.449269, -0.490162>, <2.674410, -0.365221, -0.460152>, <2.700037, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.239870, -0.465441, 0.274954>, <2.198962, -0.494793, 0.243310>, <2.111425, -0.512898, 0.175597>, <2.083079, -0.465441, 0.153670>, 
      <2.407206, -0.465441, 0.247725>, <2.366298, -0.494793, 0.216081>, <2.266804, -0.512898, 0.155751>, <2.238459, -0.465441, 0.133824>, 
      <2.628829, -0.465441, 0.202840>, <2.576727, -0.495396, 0.178020>, <2.482143, -0.515581, 0.118839>, <2.444767, -0.465441, 0.101034>, 
      <2.795348, -0.465441, 0.170998>, <2.743246, -0.495396, 0.146178>, <2.637050, -0.515581, 0.095588>, <2.599674, -0.465441, 0.077782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.719848, -0.465441, 0.346005>, <1.688989, -0.494278, 0.310000>, <1.620265, -0.510806, 0.229814>, <1.599459, -0.465441, 0.205538>, 
      <1.876418, -0.465441, 0.329318>, <1.845559, -0.494278, 0.293312>, <1.765675, -0.510806, 0.217648>, <1.744869, -0.465441, 0.193373>, 
      <2.084458, -0.465441, 0.300243>, <2.043550, -0.494793, 0.268599>, <1.966683, -0.512898, 0.194085>, <1.938337, -0.465441, 0.172158>, 
      <2.239870, -0.465441, 0.274954>, <2.198962, -0.494793, 0.243310>, <2.111425, -0.512898, 0.175597>, <2.083079, -0.465441, 0.153670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.159305, -0.465441, 0.390123>, <1.138908, -0.493717, 0.351823>, <1.091532, -0.508713, 0.262863>, <1.078154, -0.465441, 0.237744>, 
      <1.327295, -0.465441, 0.374847>, <1.306898, -0.493717, 0.336547>, <1.247824, -0.508713, 0.251707>, <1.234446, -0.465441, 0.226588>, 
      <1.552115, -0.465441, 0.363883>, <1.521256, -0.494278, 0.327877>, <1.464120, -0.510806, 0.242877>, <1.443315, -0.465441, 0.218601>, 
      <1.719848, -0.465441, 0.346005>, <1.688989, -0.494278, 0.310000>, <1.620265, -0.510806, 0.229814>, <1.599459, -0.465441, 0.205538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.560543, -0.465441, 0.451425>, <0.550668, -0.493755, 0.408908>, <0.527794, -0.508851, 0.310430>, <0.521305, -0.465441, 0.282494>, 
      <0.740814, -0.465441, 0.441078>, <0.730939, -0.493755, 0.398560>, <0.695217, -0.508851, 0.302887>, <0.688728, -0.465441, 0.274951>, 
      <0.979480, -0.465441, 0.406475>, <0.959083, -0.493717, 0.368175>, <0.924364, -0.508713, 0.274795>, <0.910986, -0.465441, 0.249676>, 
      <1.159305, -0.465441, 0.390123>, <1.138908, -0.493717, 0.351823>, <1.091532, -0.508713, 0.262863>, <1.078154, -0.465441, 0.237744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.465441, 0.456665>, <0.000000, -0.493603, 0.414022>, <0.000000, -0.508309, 0.314138>, <0.000000, -0.465441, 0.286320>, 
      <0.168170, -0.465441, 0.456665>, <0.168170, -0.493603, 0.414022>, <0.156396, -0.508309, 0.314138>, <0.156396, -0.465441, 0.286320>, 
      <0.392649, -0.465441, 0.461062>, <0.382774, -0.493755, 0.418544>, <0.371557, -0.508851, 0.317470>, <0.365068, -0.465441, 0.289533>, 
      <0.560543, -0.465441, 0.451425>, <0.550668, -0.493755, 0.408908>, <0.527794, -0.508851, 0.310430>, <0.521305, -0.465441, 0.282494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560543, -0.465441, 0.451425>, <-0.550667, -0.493755, 0.408908>, <-0.527794, -0.508851, 0.310430>, <-0.521305, -0.465441, 0.282494>, 
      <-0.392649, -0.465441, 0.461062>, <-0.382774, -0.493755, 0.418544>, <-0.371557, -0.508851, 0.317470>, <-0.365068, -0.465441, 0.289533>, 
      <-0.168170, -0.465441, 0.456665>, <-0.168170, -0.493603, 0.414022>, <-0.156396, -0.508309, 0.314138>, <-0.156396, -0.465441, 0.286320>, 
      <0.000000, -0.465441, 0.456665>, <0.000000, -0.493603, 0.414022>, <0.000000, -0.508309, 0.314138>, <0.000000, -0.465441, 0.286320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.159305, -0.465441, 0.390123>, <-1.138908, -0.493717, 0.351823>, <-1.091531, -0.508713, 0.262863>, <-1.078154, -0.465441, 0.237744>, 
      <-0.979479, -0.465441, 0.406475>, <-0.959082, -0.493717, 0.368175>, <-0.924364, -0.508713, 0.274795>, <-0.910986, -0.465441, 0.249676>, 
      <-0.740814, -0.465441, 0.441078>, <-0.730938, -0.493755, 0.398560>, <-0.695217, -0.508851, 0.302887>, <-0.688728, -0.465441, 0.274951>, 
      <-0.560543, -0.465441, 0.451425>, <-0.550667, -0.493755, 0.408908>, <-0.527794, -0.508851, 0.310430>, <-0.521305, -0.465441, 0.282494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.719848, -0.465441, 0.346005>, <-1.688989, -0.494278, 0.310000>, <-1.620265, -0.510806, 0.229814>, <-1.599459, -0.465441, 0.205538>, 
      <-1.552115, -0.465441, 0.363883>, <-1.521256, -0.494278, 0.327877>, <-1.464120, -0.510806, 0.242877>, <-1.443315, -0.465441, 0.218601>, 
      <-1.327295, -0.465441, 0.374847>, <-1.306898, -0.493717, 0.336547>, <-1.247824, -0.508713, 0.251707>, <-1.234446, -0.465441, 0.226588>, 
      <-1.159305, -0.465441, 0.390123>, <-1.138908, -0.493717, 0.351823>, <-1.091531, -0.508713, 0.262863>, <-1.078154, -0.465441, 0.237744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.239870, -0.465441, 0.274954>, <-2.198962, -0.494793, 0.243310>, <-2.111425, -0.512898, 0.175597>, <-2.083079, -0.465441, 0.153670>, 
      <-2.084458, -0.465441, 0.300243>, <-2.043550, -0.494793, 0.268599>, <-1.966683, -0.512898, 0.194085>, <-1.938337, -0.465441, 0.172158>, 
      <-1.876418, -0.465441, 0.329318>, <-1.845559, -0.494278, 0.293312>, <-1.765675, -0.510806, 0.217648>, <-1.744869, -0.465441, 0.193373>, 
      <-1.719848, -0.465441, 0.346005>, <-1.688989, -0.494278, 0.310000>, <-1.620265, -0.510806, 0.229814>, <-1.599459, -0.465441, 0.205538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.795348, -0.465441, 0.170998>, <-2.743246, -0.495396, 0.146178>, <-2.637049, -0.515581, 0.095588>, <-2.599674, -0.465441, 0.077782>, 
      <-2.628829, -0.465441, 0.202840>, <-2.576727, -0.495396, 0.178020>, <-2.482143, -0.515581, 0.118839>, <-2.444767, -0.465441, 0.101034>, 
      <-2.407206, -0.465441, 0.247725>, <-2.366298, -0.494793, 0.216081>, <-2.266804, -0.512898, 0.155751>, <-2.238459, -0.465441, 0.133824>, 
      <-2.239870, -0.465441, 0.274954>, <-2.198962, -0.494793, 0.243310>, <-2.111425, -0.512898, 0.175597>, <-2.083079, -0.465441, 0.153670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.315371, -0.465441, 0.069296>, <-3.252273, -0.496028, 0.051418>, <-3.130403, -0.518725, 0.016888>, <-3.083295, -0.465441, 0.003540>, 
      <-3.159364, -0.465441, 0.099807>, <-3.096266, -0.496028, 0.081929>, <-2.985317, -0.518725, 0.039160>, <-2.938208, -0.465441, 0.025813>, 
      <-2.951482, -0.465441, 0.141142>, <-2.899379, -0.495396, 0.116322>, <-2.782209, -0.515581, 0.073799>, <-2.744833, -0.465441, 0.055994>, 
      <-2.795348, -0.465441, 0.170998>, <-2.743246, -0.495396, 0.146178>, <-2.637049, -0.515581, 0.095588>, <-2.599674, -0.465441, 0.077782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.052877, -0.352941, -0.478359>, <-2.101521, -0.322285, -0.523810>, <-2.182543, -0.357294, -0.590684>, <-2.231388, -0.352941, -0.645154>, 
      <-2.247025, -0.352941, -0.478359>, <-2.295669, -0.322285, -0.523810>, <-2.393573, -0.357294, -0.590684>, <-2.442419, -0.352941, -0.645154>, 
      <-2.505889, -0.352941, -0.478359>, <-2.571497, -0.321504, -0.524968>, <-2.657979, -0.357400, -0.589353>, <-2.723793, -0.352941, -0.645154>, 
      <-2.700037, -0.352941, -0.478359>, <-2.765645, -0.321504, -0.524968>, <-2.869009, -0.357400, -0.589353>, <-2.934823, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.381846, -0.352941, -0.478359>, <-1.413469, -0.323334, -0.522254>, <-1.470211, -0.357150, -0.592479>, <-1.502007, -0.352941, -0.645154>, 
      <-1.583156, -0.352941, -0.478359>, <-1.614778, -0.323334, -0.522254>, <-1.689026, -0.357150, -0.592479>, <-1.720821, -0.352941, -0.645154>, 
      <-1.851568, -0.352941, -0.478359>, <-1.900212, -0.322285, -0.523810>, <-1.963728, -0.357294, -0.590684>, <-2.012574, -0.352941, -0.645154>, 
      <-2.052877, -0.352941, -0.478359>, <-2.101521, -0.322285, -0.523810>, <-2.182543, -0.357294, -0.590684>, <-2.231388, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.694902, -0.352941, -0.478359>, <-0.710211, -0.324439, -0.520617>, <-0.739914, -0.356999, -0.594375>, <-0.755328, -0.352941, -0.645154>, 
      <-0.900985, -0.352941, -0.478359>, <-0.916294, -0.324439, -0.520617>, <-0.963918, -0.356999, -0.594375>, <-0.979332, -0.352941, -0.645154>, 
      <-1.175763, -0.352941, -0.478359>, <-1.207385, -0.323334, -0.522254>, <-1.246208, -0.357150, -0.592479>, <-1.278003, -0.352941, -0.645154>, 
      <-1.381846, -0.352941, -0.478359>, <-1.413469, -0.323334, -0.522254>, <-1.470211, -0.357150, -0.592479>, <-1.502007, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.352941, -0.478359>, <0.000000, -0.324960, -0.519843>, <0.000000, -0.356927, -0.595274>, <0.000000, -0.352941, -0.645154>, 
      <-0.208471, -0.352941, -0.478359>, <-0.208471, -0.324960, -0.519843>, <-0.226598, -0.356927, -0.595274>, <-0.226598, -0.352941, -0.645154>, 
      <-0.486431, -0.352941, -0.478359>, <-0.501740, -0.324439, -0.520617>, <-0.513316, -0.356999, -0.594375>, <-0.528730, -0.352941, -0.645154>, 
      <-0.694902, -0.352941, -0.478359>, <-0.710211, -0.324439, -0.520617>, <-0.739914, -0.356999, -0.594375>, <-0.755328, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.694902, -0.352941, -0.478359>, <0.710211, -0.324439, -0.520617>, <0.739914, -0.356999, -0.594375>, <0.755328, -0.352941, -0.645154>, 
      <0.486431, -0.352941, -0.478359>, <0.501740, -0.324439, -0.520617>, <0.513316, -0.356999, -0.594375>, <0.528729, -0.352941, -0.645154>, 
      <0.208471, -0.352941, -0.478359>, <0.208471, -0.324960, -0.519843>, <0.226598, -0.356927, -0.595274>, <0.226598, -0.352941, -0.645154>, 
      <0.000000, -0.352941, -0.478359>, <0.000000, -0.324960, -0.519843>, <0.000000, -0.356927, -0.595274>, <0.000000, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.381846, -0.352941, -0.478359>, <1.413469, -0.323334, -0.522254>, <1.470211, -0.357150, -0.592479>, <1.502007, -0.352941, -0.645154>, 
      <1.175763, -0.352941, -0.478359>, <1.207385, -0.323334, -0.522254>, <1.246208, -0.357150, -0.592479>, <1.278003, -0.352941, -0.645154>, 
      <0.900985, -0.352941, -0.478359>, <0.916294, -0.324439, -0.520617>, <0.963918, -0.356999, -0.594375>, <0.979332, -0.352941, -0.645154>, 
      <0.694902, -0.352941, -0.478359>, <0.710211, -0.324439, -0.520617>, <0.739914, -0.356999, -0.594375>, <0.755328, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.052877, -0.352941, -0.478359>, <2.101521, -0.322285, -0.523810>, <2.182543, -0.357294, -0.590684>, <2.231388, -0.352941, -0.645154>, 
      <1.851568, -0.352941, -0.478359>, <1.900212, -0.322285, -0.523810>, <1.963728, -0.357294, -0.590684>, <2.012574, -0.352941, -0.645154>, 
      <1.583156, -0.352941, -0.478359>, <1.614778, -0.323334, -0.522254>, <1.689026, -0.357150, -0.592479>, <1.720821, -0.352941, -0.645154>, 
      <1.381846, -0.352941, -0.478359>, <1.413469, -0.323334, -0.522254>, <1.470211, -0.357150, -0.592479>, <1.502007, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.700037, -0.352941, -0.478359>, <2.765646, -0.321504, -0.524968>, <2.869010, -0.357400, -0.589353>, <2.934823, -0.352941, -0.645154>, 
      <2.505889, -0.352941, -0.478359>, <2.571497, -0.321504, -0.524968>, <2.657979, -0.357400, -0.589353>, <2.723793, -0.352941, -0.645154>, 
      <2.247025, -0.352941, -0.478359>, <2.295669, -0.322285, -0.523810>, <2.393573, -0.357294, -0.590684>, <2.442419, -0.352941, -0.645154>, 
      <2.052877, -0.352941, -0.478359>, <2.101521, -0.322285, -0.523810>, <2.182543, -0.357294, -0.590684>, <2.231388, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.315371, -0.352941, -0.478359>, <3.397310, -0.320966, -0.525766>, <3.521525, -0.357473, -0.588437>, <3.603664, -0.352941, -0.645154>, 
      <3.130771, -0.352941, -0.478359>, <3.212711, -0.320966, -0.525766>, <3.320873, -0.357473, -0.588437>, <3.403012, -0.352941, -0.645154>, 
      <2.884637, -0.352941, -0.478359>, <2.950245, -0.321504, -0.524968>, <3.069662, -0.357400, -0.589353>, <3.135475, -0.352941, -0.645154>, 
      <2.700037, -0.352941, -0.478359>, <2.765646, -0.321504, -0.524968>, <2.869010, -0.357400, -0.589353>, <2.934823, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.239870, -0.352941, 0.274954>, <2.221393, -0.363613, 0.248806>, <2.263087, -0.448782, 0.292914>, <2.239870, -0.465441, 0.274954>, 
      <2.407206, -0.352941, 0.247725>, <2.388728, -0.363613, 0.221577>, <2.430423, -0.448782, 0.265684>, <2.407206, -0.465441, 0.247725>, 
      <2.628829, -0.352941, 0.202840>, <2.601875, -0.365416, 0.186812>, <2.655872, -0.449893, 0.215723>, <2.628829, -0.465441, 0.202840>, 
      <2.795348, -0.352941, 0.170998>, <2.768394, -0.365416, 0.154970>, <2.822392, -0.449893, 0.183881>, <2.795348, -0.465441, 0.170998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.719848, -0.352941, 0.346005>, <1.708116, -0.361766, 0.315616>, <1.738614, -0.447905, 0.367901>, <1.719848, -0.465441, 0.346005>, 
      <1.876418, -0.352941, 0.329318>, <1.864685, -0.361766, 0.298928>, <1.895183, -0.447905, 0.351213>, <1.876418, -0.465441, 0.329318>, 
      <2.084458, -0.352941, 0.300243>, <2.065981, -0.363613, 0.274095>, <2.107675, -0.448782, 0.318203>, <2.084458, -0.465441, 0.300243>, 
      <2.239870, -0.352941, 0.274954>, <2.221393, -0.363613, 0.248806>, <2.263087, -0.448782, 0.292914>, <2.239870, -0.465441, 0.274954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.159305, -0.352941, 0.390123>, <1.150233, -0.363065, 0.359232>, <1.172597, -0.447015, 0.415081>, <1.159305, -0.465441, 0.390123>, 
      <1.327295, -0.352941, 0.374847>, <1.318223, -0.363065, 0.343956>, <1.340586, -0.447015, 0.399805>, <1.327295, -0.465441, 0.374847>, 
      <1.552115, -0.352941, 0.363883>, <1.540383, -0.361766, 0.333493>, <1.570881, -0.447905, 0.385778>, <1.552115, -0.465441, 0.363883>, 
      <1.719848, -0.352941, 0.346005>, <1.708116, -0.361766, 0.315616>, <1.738614, -0.447905, 0.367901>, <1.719848, -0.465441, 0.346005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.560543, -0.352941, 0.451425>, <0.550110, -0.377020, 0.430202>, <0.566949, -0.447074, 0.479005>, <0.560543, -0.465441, 0.451425>, 
      <0.740814, -0.352941, 0.441078>, <0.730381, -0.377020, 0.419855>, <0.747220, -0.447074, 0.468658>, <0.740814, -0.465441, 0.441078>, 
      <0.979480, -0.352941, 0.406475>, <0.970407, -0.363065, 0.375584>, <0.992771, -0.447015, 0.431433>, <0.979480, -0.465441, 0.406475>, 
      <1.159305, -0.352941, 0.390123>, <1.150233, -0.363065, 0.359232>, <1.172597, -0.447015, 0.415081>, <1.159305, -0.465441, 0.390123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.352941, 0.456665>, <0.000000, -0.371395, 0.428408>, <0.000000, -0.446842, 0.484828>, <0.000000, -0.465441, 0.456665>, 
      <0.168170, -0.352941, 0.456665>, <0.168170, -0.371395, 0.428408>, <0.168170, -0.446842, 0.484828>, <0.168170, -0.465441, 0.456665>, 
      <0.392649, -0.352941, 0.461062>, <0.382217, -0.377020, 0.439839>, <0.399055, -0.447074, 0.488642>, <0.392649, -0.465441, 0.461062>, 
      <0.560543, -0.352941, 0.451425>, <0.550110, -0.377020, 0.430202>, <0.566949, -0.447074, 0.479005>, <0.560543, -0.465441, 0.451425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560543, -0.352941, 0.451425>, <-0.550110, -0.377020, 0.430202>, <-0.566949, -0.447074, 0.479005>, <-0.560543, -0.465441, 0.451425>, 
      <-0.392649, -0.352941, 0.461062>, <-0.382217, -0.377020, 0.439839>, <-0.399055, -0.447074, 0.488642>, <-0.392649, -0.465441, 0.461062>, 
      <-0.168170, -0.352941, 0.456665>, <-0.168170, -0.371395, 0.428408>, <-0.168170, -0.446842, 0.484828>, <-0.168170, -0.465441, 0.456665>, 
      <0.000000, -0.352941, 0.456665>, <0.000000, -0.371395, 0.428408>, <0.000000, -0.446842, 0.484828>, <0.000000, -0.465441, 0.456665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.159305, -0.352941, 0.390123>, <-1.150233, -0.363065, 0.359232>, <-1.172597, -0.447015, 0.415081>, <-1.159305, -0.465441, 0.390123>, 
      <-0.979479, -0.352941, 0.406475>, <-0.970407, -0.363065, 0.375584>, <-0.992771, -0.447015, 0.431433>, <-0.979479, -0.465441, 0.406475>, 
      <-0.740814, -0.352941, 0.441078>, <-0.730381, -0.377020, 0.419855>, <-0.747220, -0.447074, 0.468658>, <-0.740814, -0.465441, 0.441078>, 
      <-0.560543, -0.352941, 0.451425>, <-0.550110, -0.377020, 0.430202>, <-0.566949, -0.447074, 0.479005>, <-0.560543, -0.465441, 0.451425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.719848, -0.352941, 0.346005>, <-1.708116, -0.361766, 0.315616>, <-1.738614, -0.447905, 0.367901>, <-1.719848, -0.465441, 0.346005>, 
      <-1.552115, -0.352941, 0.363883>, <-1.540383, -0.361766, 0.333493>, <-1.570881, -0.447905, 0.385778>, <-1.552115, -0.465441, 0.363883>, 
      <-1.327295, -0.352941, 0.374847>, <-1.318223, -0.363065, 0.343956>, <-1.340586, -0.447015, 0.399805>, <-1.327295, -0.465441, 0.374847>, 
      <-1.159305, -0.352941, 0.390123>, <-1.150233, -0.363065, 0.359232>, <-1.172597, -0.447015, 0.415081>, <-1.159305, -0.465441, 0.390123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.239870, -0.352941, 0.274954>, <-2.221393, -0.363613, 0.248806>, <-2.263087, -0.448782, 0.292914>, <-2.239870, -0.465441, 0.274954>, 
      <-2.084458, -0.352941, 0.300243>, <-2.065981, -0.363613, 0.274095>, <-2.107675, -0.448782, 0.318203>, <-2.084458, -0.465441, 0.300243>, 
      <-1.876418, -0.352941, 0.329318>, <-1.864685, -0.361766, 0.298928>, <-1.895183, -0.447905, 0.351213>, <-1.876418, -0.465441, 0.329318>, 
      <-1.719848, -0.352941, 0.346005>, <-1.708116, -0.361766, 0.315616>, <-1.738614, -0.447905, 0.367901>, <-1.719848, -0.465441, 0.346005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.795348, -0.352941, 0.170998>, <-2.768394, -0.365416, 0.154970>, <-2.822392, -0.449893, 0.183881>, <-2.795348, -0.465441, 0.170998>, 
      <-2.628829, -0.352941, 0.202840>, <-2.601875, -0.365416, 0.186812>, <-2.655872, -0.449893, 0.215723>, <-2.628829, -0.465441, 0.202840>, 
      <-2.407206, -0.352941, 0.247725>, <-2.388728, -0.363613, 0.221577>, <-2.430423, -0.448782, 0.265684>, <-2.407206, -0.465441, 0.247725>, 
      <-2.239870, -0.352941, 0.274954>, <-2.221393, -0.363613, 0.248806>, <-2.263087, -0.448782, 0.292914>, <-2.239870, -0.465441, 0.274954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.315371, -0.352941, 0.069296>, <-3.287253, -0.363913, 0.054194>, <-3.344799, -0.451175, 0.077634>, <-3.315371, -0.465441, 0.069296>, 
      <-3.159364, -0.352941, 0.099807>, <-3.131246, -0.363913, 0.084705>, <-3.188792, -0.451175, 0.108145>, <-3.159364, -0.465441, 0.099807>, 
      <-2.951482, -0.352941, 0.141142>, <-2.924527, -0.365416, 0.125114>, <-2.978525, -0.449893, 0.154025>, <-2.951482, -0.465441, 0.141142>, 
      <-2.795348, -0.352941, 0.170998>, <-2.768394, -0.365416, 0.154970>, <-2.822392, -0.449893, 0.183881>, <-2.795348, -0.465441, 0.170998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.231388, -0.352941, -0.645154>, <-2.257595, -0.350605, -0.674378>, <-2.278882, -0.324109, -0.722177>, <-2.300400, -0.330882, -0.754385>, 
      <-2.442419, -0.352941, -0.645154>, <-2.468625, -0.350605, -0.674378>, <-2.496439, -0.324109, -0.722177>, <-2.517957, -0.330882, -0.754385>, 
      <-2.723793, -0.352941, -0.645154>, <-2.756636, -0.350715, -0.673001>, <-2.779921, -0.324154, -0.722392>, <-2.808033, -0.330882, -0.754385>, 
      <-2.934823, -0.352941, -0.645154>, <-2.967667, -0.350715, -0.673001>, <-2.997478, -0.324154, -0.722392>, <-3.025591, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.502007, -0.352941, -0.645154>, <-1.520680, -0.350469, -0.676090>, <-1.533871, -0.324060, -0.721943>, <-1.548461, -0.330882, -0.754385>, 
      <-1.720821, -0.352941, -0.645154>, <-1.739495, -0.350469, -0.676090>, <-1.759453, -0.324060, -0.721943>, <-1.774042, -0.330882, -0.754385>, 
      <-2.012574, -0.352941, -0.645154>, <-2.038780, -0.350605, -0.674378>, <-2.053300, -0.324109, -0.722177>, <-2.074818, -0.330882, -0.754385>, 
      <-2.231388, -0.352941, -0.645154>, <-2.257595, -0.350605, -0.674378>, <-2.278882, -0.324109, -0.722177>, <-2.300400, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755328, -0.352941, -0.645154>, <-0.765220, -0.350336, -0.677743>, <-0.771308, -0.324019, -0.721748>, <-0.778689, -0.330882, -0.754385>, 
      <-0.979332, -0.352941, -0.645154>, <-0.989224, -0.350336, -0.677743>, <-1.002239, -0.324019, -0.721748>, <-1.009620, -0.330882, -0.754385>, 
      <-1.278003, -0.352941, -0.645154>, <-1.296677, -0.350469, -0.676090>, <-1.302939, -0.324060, -0.721943>, <-1.317529, -0.330882, -0.754385>, 
      <-1.502007, -0.352941, -0.645154>, <-1.520680, -0.350469, -0.676090>, <-1.533871, -0.324060, -0.721943>, <-1.548461, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.352941, -0.645154>, <0.000000, -0.350278, -0.678478>, <0.000000, -0.324002, -0.721669>, <0.000000, -0.330882, -0.754385>, 
      <-0.226598, -0.352941, -0.645154>, <-0.226598, -0.350278, -0.678478>, <-0.233607, -0.324002, -0.721669>, <-0.233607, -0.330882, -0.754385>, 
      <-0.528730, -0.352941, -0.645154>, <-0.538622, -0.350336, -0.677743>, <-0.537701, -0.324019, -0.721748>, <-0.545082, -0.330882, -0.754385>, 
      <-0.755328, -0.352941, -0.645154>, <-0.765220, -0.350336, -0.677743>, <-0.771308, -0.324019, -0.721748>, <-0.778689, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.755328, -0.352941, -0.645154>, <0.765220, -0.350336, -0.677743>, <0.771308, -0.324019, -0.721748>, <0.778688, -0.330882, -0.754385>, 
      <0.528729, -0.352941, -0.645154>, <0.538622, -0.350336, -0.677743>, <0.537701, -0.324019, -0.721748>, <0.545082, -0.330882, -0.754385>, 
      <0.226598, -0.352941, -0.645154>, <0.226598, -0.350278, -0.678478>, <0.233606, -0.324002, -0.721669>, <0.233606, -0.330882, -0.754385>, 
      <0.000000, -0.352941, -0.645154>, <0.000000, -0.350278, -0.678478>, <0.000000, -0.324002, -0.721669>, <0.000000, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.502007, -0.352941, -0.645154>, <1.520680, -0.350469, -0.676090>, <1.533871, -0.324060, -0.721943>, <1.548461, -0.330882, -0.754385>, 
      <1.278003, -0.352941, -0.645154>, <1.296677, -0.350469, -0.676090>, <1.302939, -0.324060, -0.721943>, <1.317529, -0.330882, -0.754385>, 
      <0.979332, -0.352941, -0.645154>, <0.989224, -0.350336, -0.677743>, <1.002239, -0.324019, -0.721748>, <1.009620, -0.330882, -0.754385>, 
      <0.755328, -0.352941, -0.645154>, <0.765220, -0.350336, -0.677743>, <0.771308, -0.324019, -0.721748>, <0.778688, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.231388, -0.352941, -0.645154>, <2.257594, -0.350605, -0.674378>, <2.278882, -0.324109, -0.722177>, <2.300400, -0.330882, -0.754385>, 
      <2.012574, -0.352941, -0.645154>, <2.038780, -0.350605, -0.674378>, <2.053300, -0.324109, -0.722177>, <2.074818, -0.330882, -0.754385>, 
      <1.720821, -0.352941, -0.645154>, <1.739495, -0.350469, -0.676090>, <1.759453, -0.324060, -0.721943>, <1.774042, -0.330882, -0.754385>, 
      <1.502007, -0.352941, -0.645154>, <1.520680, -0.350469, -0.676090>, <1.533871, -0.324060, -0.721943>, <1.548461, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.934823, -0.352941, -0.645154>, <2.967667, -0.350715, -0.673001>, <2.997478, -0.324154, -0.722392>, <3.025591, -0.330882, -0.754385>, 
      <2.723793, -0.352941, -0.645154>, <2.756636, -0.350715, -0.673001>, <2.779921, -0.324154, -0.722392>, <2.808034, -0.330882, -0.754385>, 
      <2.442419, -0.352941, -0.645154>, <2.468625, -0.350605, -0.674378>, <2.496439, -0.324109, -0.722177>, <2.517957, -0.330882, -0.754385>, 
      <2.231388, -0.352941, -0.645154>, <2.257594, -0.350605, -0.674378>, <2.278882, -0.324109, -0.722177>, <2.300400, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.603664, -0.352941, -0.645154>, <3.642531, -0.350796, -0.671992>, <3.680788, -0.324191, -0.722568>, <3.715117, -0.330882, -0.754385>, 
      <3.403012, -0.352941, -0.645154>, <3.441879, -0.350796, -0.671992>, <3.473930, -0.324191, -0.722568>, <3.508259, -0.330882, -0.754385>, 
      <3.135475, -0.352941, -0.645154>, <3.168319, -0.350715, -0.673001>, <3.204336, -0.324154, -0.722392>, <3.232449, -0.330882, -0.754385>, 
      <2.934823, -0.352941, -0.645154>, <2.967667, -0.350715, -0.673001>, <2.997478, -0.324154, -0.722392>, <3.025591, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.434642, -0.352941, 0.550581>, <2.377473, -0.357610, 0.467146>, <2.295303, -0.320923, 0.353399>, <2.239870, -0.352941, 0.274954>, 
      <2.617676, -0.352941, 0.485159>, <2.560507, -0.357610, 0.401724>, <2.462639, -0.320923, 0.326170>, <2.407206, -0.352941, 0.247725>, 
      <2.851210, -0.352941, 0.367821>, <2.780107, -0.357594, 0.321768>, <2.696587, -0.321581, 0.243133>, <2.628829, -0.352941, 0.202840>, 
      <3.038422, -0.352941, 0.315543>, <2.967320, -0.357594, 0.269491>, <2.863106, -0.321581, 0.211291>, <2.795348, -0.352941, 0.170998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.869400, -0.352941, 0.733389>, <1.824826, -0.357682, 0.617158>, <1.763153, -0.320365, 0.458177>, <1.719848, -0.352941, 0.346005>, 
      <2.045500, -0.352941, 0.705980>, <2.000926, -0.357682, 0.589749>, <1.919722, -0.320365, 0.441489>, <1.876418, -0.352941, 0.329318>, 
      <2.266819, -0.352941, 0.610566>, <2.209651, -0.357610, 0.527131>, <2.139891, -0.320923, 0.378688>, <2.084458, -0.352941, 0.300243>, 
      <2.434642, -0.352941, 0.550581>, <2.377473, -0.357610, 0.467146>, <2.295303, -0.320923, 0.353399>, <2.239870, -0.352941, 0.274954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.260114, -0.352941, 0.733389>, <1.231061, -0.357526, 0.630169>, <1.188155, -0.320745, 0.488360>, <1.159305, -0.352941, 0.390123>, 
      <1.441006, -0.352941, 0.759631>, <1.411953, -0.357526, 0.656411>, <1.356145, -0.320745, 0.473084>, <1.327295, -0.352941, 0.374847>, 
      <1.688789, -0.352941, 0.761500>, <1.644215, -0.357682, 0.645269>, <1.595420, -0.320365, 0.476054>, <1.552115, -0.352941, 0.363883>, 
      <1.869400, -0.352941, 0.733389>, <1.824826, -0.357682, 0.617158>, <1.763153, -0.320365, 0.458177>, <1.719848, -0.352941, 0.346005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.609286, -0.352941, 0.550581>, <0.599503, -0.356134, 0.519073>, <0.570789, -0.329292, 0.472269>, <0.560543, -0.352941, 0.451425>, 
      <0.811397, -0.352941, 0.567336>, <0.801614, -0.356134, 0.535827>, <0.751060, -0.329292, 0.461921>, <0.740814, -0.352941, 0.441078>, 
      <1.059411, -0.352941, 0.704272>, <1.030358, -0.357526, 0.601052>, <1.008330, -0.320745, 0.504712>, <0.979480, -0.352941, 0.406475>, 
      <1.260114, -0.352941, 0.733389>, <1.231061, -0.357526, 0.630169>, <1.188155, -0.320745, 0.488360>, <1.159305, -0.352941, 0.390123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.352941, 0.628927>, <0.000000, -0.356660, 0.577383>, <0.000000, -0.324683, 0.499934>, <0.000000, -0.352941, 0.456665>, 
      <0.184291, -0.352941, 0.628927>, <0.184291, -0.356660, 0.577383>, <0.168170, -0.324683, 0.499934>, <0.168170, -0.352941, 0.456665>, 
      <0.425625, -0.352941, 0.535356>, <0.415842, -0.356134, 0.503847>, <0.402896, -0.329292, 0.481905>, <0.392649, -0.352941, 0.461062>, 
      <0.609286, -0.352941, 0.550581>, <0.599503, -0.356134, 0.519073>, <0.570789, -0.329292, 0.472269>, <0.560543, -0.352941, 0.451425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.609286, -0.352941, 0.550581>, <-0.599503, -0.356134, 0.519073>, <-0.570789, -0.329292, 0.472269>, <-0.560543, -0.352941, 0.451425>, 
      <-0.425625, -0.352941, 0.535356>, <-0.415842, -0.356134, 0.503847>, <-0.402896, -0.329292, 0.481905>, <-0.392649, -0.352941, 0.461062>, 
      <-0.184291, -0.352941, 0.628927>, <-0.184291, -0.356660, 0.577383>, <-0.168170, -0.324683, 0.499934>, <-0.168170, -0.352941, 0.456665>, 
      <0.000000, -0.352941, 0.628927>, <0.000000, -0.356660, 0.577383>, <0.000000, -0.324683, 0.499934>, <0.000000, -0.352941, 0.456665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.260114, -0.352941, 0.733389>, <-1.231061, -0.357526, 0.630169>, <-1.188155, -0.320745, 0.488360>, <-1.159305, -0.352941, 0.390123>, 
      <-1.059411, -0.352941, 0.704272>, <-1.030358, -0.357526, 0.601052>, <-1.008329, -0.320745, 0.504712>, <-0.979479, -0.352941, 0.406475>, 
      <-0.811397, -0.352941, 0.567336>, <-0.801614, -0.356134, 0.535827>, <-0.751060, -0.329292, 0.461921>, <-0.740814, -0.352941, 0.441078>, 
      <-0.609286, -0.352941, 0.550581>, <-0.599503, -0.356134, 0.519073>, <-0.570789, -0.329292, 0.472269>, <-0.560543, -0.352941, 0.451425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.869400, -0.352941, 0.733389>, <-1.824826, -0.357682, 0.617158>, <-1.763153, -0.320365, 0.458177>, <-1.719848, -0.352941, 0.346005>, 
      <-1.688789, -0.352941, 0.761500>, <-1.644215, -0.357682, 0.645269>, <-1.595420, -0.320365, 0.476054>, <-1.552115, -0.352941, 0.363883>, 
      <-1.441006, -0.352941, 0.759631>, <-1.411953, -0.357526, 0.656411>, <-1.356145, -0.320745, 0.473084>, <-1.327295, -0.352941, 0.374847>, 
      <-1.260114, -0.352941, 0.733389>, <-1.231061, -0.357526, 0.630169>, <-1.188155, -0.320745, 0.488360>, <-1.159305, -0.352941, 0.390123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.434642, -0.352941, 0.550581>, <-2.377473, -0.357610, 0.467146>, <-2.295303, -0.320923, 0.353399>, <-2.239870, -0.352941, 0.274954>, 
      <-2.266819, -0.352941, 0.610566>, <-2.209651, -0.357610, 0.527131>, <-2.139891, -0.320923, 0.378688>, <-2.084458, -0.352941, 0.300243>, 
      <-2.045500, -0.352941, 0.705980>, <-2.000926, -0.357682, 0.589749>, <-1.919722, -0.320365, 0.441489>, <-1.876418, -0.352941, 0.329318>, 
      <-1.869400, -0.352941, 0.733389>, <-1.824826, -0.357682, 0.617158>, <-1.763153, -0.320365, 0.458177>, <-1.719848, -0.352941, 0.346005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.038422, -0.352941, 0.315543>, <-2.967320, -0.357594, 0.269491>, <-2.863106, -0.321581, 0.211291>, <-2.795348, -0.352941, 0.170998>, 
      <-2.851210, -0.352941, 0.367821>, <-2.780107, -0.357594, 0.321768>, <-2.696586, -0.321581, 0.243133>, <-2.628829, -0.352941, 0.202840>, 
      <-2.617675, -0.352941, 0.485159>, <-2.560507, -0.357610, 0.401724>, <-2.462639, -0.320923, 0.326170>, <-2.407206, -0.352941, 0.247725>, 
      <-2.434642, -0.352941, 0.550581>, <-2.377473, -0.357610, 0.467146>, <-2.295303, -0.320923, 0.353399>, <-2.239870, -0.352941, 0.274954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.603664, -0.352941, 0.224140>, <-3.516963, -0.357725, 0.178334>, <-3.397160, -0.321024, 0.113226>, <-3.315371, -0.352941, 0.069296>, 
      <-3.434091, -0.352941, 0.251561>, <-3.347390, -0.357725, 0.205756>, <-3.241153, -0.321024, 0.143736>, <-3.159364, -0.352941, 0.099807>, 
      <-3.203868, -0.352941, 0.269344>, <-3.132766, -0.357594, 0.223291>, <-3.019239, -0.321581, 0.181435>, <-2.951482, -0.352941, 0.141142>, 
      <-3.038422, -0.352941, 0.315543>, <-2.967320, -0.357594, 0.269491>, <-2.863106, -0.321581, 0.211291>, <-2.795348, -0.352941, 0.170998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.300400, -0.330882, -0.754385>, <-2.323356, -0.338108, -0.788744>, <-2.346111, -0.397058, -0.821581>, <-2.371547, -0.397058, -0.854938>, 
      <-2.517957, -0.330882, -0.754385>, <-2.540913, -0.338108, -0.788744>, <-2.570396, -0.397058, -0.821581>, <-2.595832, -0.397058, -0.854938>, 
      <-2.808033, -0.330882, -0.754385>, <-2.837856, -0.338019, -0.788323>, <-2.862489, -0.397058, -0.822642>, <-2.894880, -0.397058, -0.854938>, 
      <-3.025591, -0.330882, -0.754385>, <-3.055413, -0.338019, -0.788323>, <-3.086775, -0.397058, -0.822642>, <-3.119165, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.548461, -0.330882, -0.754385>, <-1.564116, -0.338203, -0.789196>, <-1.578604, -0.397058, -0.820361>, <-1.596351, -0.397058, -0.854938>, 
      <-1.774042, -0.330882, -0.754385>, <-1.789698, -0.338203, -0.789196>, <-1.811162, -0.397058, -0.820361>, <-1.828910, -0.397058, -0.854938>, 
      <-2.074818, -0.330882, -0.754385>, <-2.097774, -0.338108, -0.788744>, <-2.113552, -0.397058, -0.821581>, <-2.138988, -0.397058, -0.854938>, 
      <-2.300400, -0.330882, -0.754385>, <-2.323356, -0.338108, -0.788744>, <-2.346111, -0.397058, -0.821581>, <-2.371547, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.778689, -0.330882, -0.754385>, <-0.786647, -0.338282, -0.789573>, <-0.793567, -0.397058, -0.819279>, <-0.802772, -0.397058, -0.854938>, 
      <-1.009620, -0.330882, -0.754385>, <-1.017578, -0.338282, -0.789573>, <-1.031641, -0.397058, -0.819279>, <-1.040846, -0.397058, -0.854938>, 
      <-1.317529, -0.330882, -0.754385>, <-1.333185, -0.338203, -0.789196>, <-1.340530, -0.397058, -0.820361>, <-1.358277, -0.397058, -0.854938>, 
      <-1.548461, -0.330882, -0.754385>, <-1.564116, -0.338203, -0.789196>, <-1.578604, -0.397058, -0.820361>, <-1.596351, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.330882, -0.754385>, <0.000000, -0.338314, -0.789724>, <0.000000, -0.397058, -0.818825>, <0.000000, -0.397058, -0.854938>, 
      <-0.233607, -0.330882, -0.754385>, <-0.233607, -0.338314, -0.789724>, <-0.240832, -0.397058, -0.818825>, <-0.240832, -0.397058, -0.854938>, 
      <-0.545082, -0.330882, -0.754385>, <-0.553040, -0.338282, -0.789573>, <-0.552736, -0.397058, -0.819279>, <-0.561940, -0.397058, -0.854938>, 
      <-0.778689, -0.330882, -0.754385>, <-0.786647, -0.338282, -0.789573>, <-0.793567, -0.397058, -0.819279>, <-0.802772, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.778688, -0.330882, -0.754385>, <0.786647, -0.338282, -0.789573>, <0.793567, -0.397058, -0.819279>, <0.802771, -0.397058, -0.854938>, 
      <0.545082, -0.330882, -0.754385>, <0.553040, -0.338282, -0.789573>, <0.552736, -0.397058, -0.819279>, <0.561940, -0.397058, -0.854938>, 
      <0.233606, -0.330882, -0.754385>, <0.233606, -0.338314, -0.789724>, <0.240832, -0.397058, -0.818825>, <0.240832, -0.397058, -0.854938>, 
      <0.000000, -0.330882, -0.754385>, <0.000000, -0.338314, -0.789724>, <0.000000, -0.397058, -0.818825>, <0.000000, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.548461, -0.330882, -0.754385>, <1.564116, -0.338203, -0.789196>, <1.578604, -0.397058, -0.820361>, <1.596351, -0.397058, -0.854938>, 
      <1.317529, -0.330882, -0.754385>, <1.333185, -0.338203, -0.789196>, <1.340530, -0.397058, -0.820361>, <1.358277, -0.397058, -0.854938>, 
      <1.009620, -0.330882, -0.754385>, <1.017578, -0.338282, -0.789573>, <1.031641, -0.397058, -0.819279>, <1.040845, -0.397058, -0.854938>, 
      <0.778688, -0.330882, -0.754385>, <0.786647, -0.338282, -0.789573>, <0.793567, -0.397058, -0.819279>, <0.802771, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.300400, -0.330882, -0.754385>, <2.323355, -0.338108, -0.788744>, <2.346110, -0.397058, -0.821581>, <2.371546, -0.397058, -0.854938>, 
      <2.074818, -0.330882, -0.754385>, <2.097774, -0.338108, -0.788744>, <2.113552, -0.397058, -0.821581>, <2.138988, -0.397058, -0.854938>, 
      <1.774042, -0.330882, -0.754385>, <1.789698, -0.338203, -0.789196>, <1.811162, -0.397058, -0.820361>, <1.828910, -0.397058, -0.854938>, 
      <1.548461, -0.330882, -0.754385>, <1.564116, -0.338203, -0.789196>, <1.578604, -0.397058, -0.820361>, <1.596351, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.025591, -0.330882, -0.754385>, <3.055414, -0.338019, -0.788323>, <3.086776, -0.397058, -0.822642>, <3.119166, -0.397058, -0.854938>, 
      <2.808034, -0.330882, -0.754385>, <2.837857, -0.338019, -0.788323>, <2.862490, -0.397058, -0.822642>, <2.894880, -0.397058, -0.854938>, 
      <2.517957, -0.330882, -0.754385>, <2.540913, -0.338108, -0.788744>, <2.570396, -0.397058, -0.821581>, <2.595832, -0.397058, -0.854938>, 
      <2.300400, -0.330882, -0.754385>, <2.323355, -0.338108, -0.788744>, <2.346110, -0.397058, -0.821581>, <2.371546, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.715117, -0.330882, -0.754385>, <3.751364, -0.337947, -0.787979>, <3.791262, -0.397058, -0.823468>, <3.830017, -0.397058, -0.854938>, 
      <3.508259, -0.330882, -0.754385>, <3.544506, -0.337947, -0.787979>, <3.578007, -0.397058, -0.823468>, <3.616762, -0.397058, -0.854938>, 
      <3.232449, -0.330882, -0.754385>, <3.262272, -0.338019, -0.788323>, <3.300031, -0.397058, -0.822642>, <3.332421, -0.397058, -0.854938>, 
      <3.025591, -0.330882, -0.754385>, <3.055414, -0.338019, -0.788323>, <3.086776, -0.397058, -0.822642>, <3.119166, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.509940, -0.330882, 0.669110>, <2.486671, -0.324169, 0.634010>, <2.458719, -0.350974, 0.585722>, <2.434642, -0.352941, 0.550581>, 
      <2.699189, -0.330882, 0.590997>, <2.675920, -0.324169, 0.555898>, <2.641753, -0.350974, 0.520300>, <2.617676, -0.352941, 0.485159>, 
      <2.937538, -0.330882, 0.452136>, <2.908936, -0.324270, 0.430540>, <2.881752, -0.350942, 0.387604>, <2.851210, -0.352941, 0.367821>, 
      <3.132394, -0.330882, 0.389302>, <3.103792, -0.324270, 0.367706>, <3.068965, -0.350942, 0.335326>, <3.038422, -0.352941, 0.315543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.927217, -0.330882, 0.886737>, <1.909201, -0.324113, 0.841013>, <1.887151, -0.351053, 0.779675>, <1.869400, -0.352941, 0.733389>, 
      <2.110884, -0.330882, 0.853726>, <2.092869, -0.324113, 0.808002>, <2.063251, -0.351053, 0.752266>, <2.045500, -0.352941, 0.705980>, 
      <2.337445, -0.330882, 0.740306>, <2.314176, -0.324169, 0.705207>, <2.290897, -0.350974, 0.645707>, <2.266819, -0.352941, 0.610566>, 
      <2.509940, -0.330882, 0.669110>, <2.486671, -0.324169, 0.634010>, <2.458719, -0.350974, 0.585722>, <2.434642, -0.352941, 0.550581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.299087, -0.330882, 0.886737>, <1.286909, -0.324094, 0.840884>, <1.273088, -0.350894, 0.779480>, <1.260114, -0.352941, 0.733389>, 
      <1.484936, -0.330882, 0.917871>, <1.472758, -0.324094, 0.872018>, <1.453980, -0.350894, 0.805722>, <1.441006, -0.352941, 0.759631>, 
      <1.741750, -0.330882, 0.920071>, <1.723734, -0.324113, 0.874347>, <1.706540, -0.351053, 0.807786>, <1.688789, -0.352941, 0.761500>, 
      <1.927217, -0.330882, 0.886737>, <1.909201, -0.324113, 0.841013>, <1.887151, -0.351053, 0.779675>, <1.869400, -0.352941, 0.733389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.628130, -0.330882, 0.669110>, <0.622242, -0.324095, 0.633621>, <0.620091, -0.349415, 0.585380>, <0.609286, -0.352941, 0.550581>, 
      <0.838778, -0.330882, 0.689274>, <0.832890, -0.324095, 0.653786>, <0.822202, -0.349415, 0.602135>, <0.811397, -0.352941, 0.567336>, 
      <1.090385, -0.330882, 0.851775>, <1.078207, -0.324094, 0.805921>, <1.072384, -0.350894, 0.750364>, <1.059411, -0.352941, 0.704272>, 
      <1.299087, -0.330882, 0.886737>, <1.286909, -0.324094, 0.840884>, <1.273088, -0.350894, 0.779480>, <1.260114, -0.352941, 0.733389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.330882, 0.762378>, <0.000000, -0.324082, 0.722374>, <0.000000, -0.350021, 0.669401>, <0.000000, -0.352941, 0.628927>, 
      <0.190505, -0.330882, 0.762378>, <0.190505, -0.324082, 0.722374>, <0.184291, -0.350021, 0.669401>, <0.184291, -0.352941, 0.628927>, 
      <0.438492, -0.330882, 0.650956>, <0.432604, -0.324095, 0.615467>, <0.436430, -0.349415, 0.570155>, <0.425625, -0.352941, 0.535356>, 
      <0.628130, -0.330882, 0.669110>, <0.622242, -0.324095, 0.633621>, <0.620091, -0.349415, 0.585380>, <0.609286, -0.352941, 0.550581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.628130, -0.330882, 0.669110>, <-0.622242, -0.324095, 0.633621>, <-0.620090, -0.349415, 0.585380>, <-0.609286, -0.352941, 0.550581>, 
      <-0.438492, -0.330882, 0.650956>, <-0.432604, -0.324095, 0.615467>, <-0.436430, -0.349415, 0.570155>, <-0.425625, -0.352941, 0.535356>, 
      <-0.190505, -0.330882, 0.762378>, <-0.190505, -0.324082, 0.722374>, <-0.184291, -0.350021, 0.669401>, <-0.184291, -0.352941, 0.628927>, 
      <0.000000, -0.330882, 0.762378>, <0.000000, -0.324082, 0.722374>, <0.000000, -0.350021, 0.669401>, <0.000000, -0.352941, 0.628927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.299087, -0.330882, 0.886737>, <-1.286909, -0.324094, 0.840884>, <-1.273087, -0.350894, 0.779480>, <-1.260114, -0.352941, 0.733389>, 
      <-1.090385, -0.330882, 0.851775>, <-1.078206, -0.324094, 0.805921>, <-1.072384, -0.350894, 0.750364>, <-1.059411, -0.352941, 0.704272>, 
      <-0.838778, -0.330882, 0.689274>, <-0.832890, -0.324095, 0.653786>, <-0.822202, -0.349415, 0.602135>, <-0.811397, -0.352941, 0.567336>, 
      <-0.628130, -0.330882, 0.669110>, <-0.622242, -0.324095, 0.633621>, <-0.620090, -0.349415, 0.585380>, <-0.609286, -0.352941, 0.550581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.927217, -0.330882, 0.886737>, <-1.909201, -0.324113, 0.841013>, <-1.887151, -0.351053, 0.779675>, <-1.869400, -0.352941, 0.733389>, 
      <-1.741750, -0.330882, 0.920071>, <-1.723734, -0.324113, 0.874347>, <-1.706540, -0.351053, 0.807786>, <-1.688789, -0.352941, 0.761500>, 
      <-1.484936, -0.330882, 0.917871>, <-1.472758, -0.324094, 0.872018>, <-1.453980, -0.350894, 0.805722>, <-1.441006, -0.352941, 0.759631>, 
      <-1.299087, -0.330882, 0.886737>, <-1.286909, -0.324094, 0.840884>, <-1.273087, -0.350894, 0.779480>, <-1.260114, -0.352941, 0.733389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.509940, -0.330882, 0.669110>, <-2.486671, -0.324169, 0.634010>, <-2.458719, -0.350974, 0.585722>, <-2.434642, -0.352941, 0.550581>, 
      <-2.337445, -0.330882, 0.740306>, <-2.314176, -0.324169, 0.705207>, <-2.290897, -0.350974, 0.645707>, <-2.266819, -0.352941, 0.610566>, 
      <-2.110884, -0.330882, 0.853726>, <-2.092869, -0.324113, 0.808002>, <-2.063251, -0.351053, 0.752266>, <-2.045500, -0.352941, 0.705980>, 
      <-1.927217, -0.330882, 0.886737>, <-1.909201, -0.324113, 0.841013>, <-1.887151, -0.351053, 0.779675>, <-1.869400, -0.352941, 0.733389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.132394, -0.330882, 0.389302>, <-3.103791, -0.324270, 0.367706>, <-3.068964, -0.350942, 0.335326>, <-3.038422, -0.352941, 0.315543>, 
      <-2.937538, -0.330882, 0.452136>, <-2.908936, -0.324270, 0.430539>, <-2.881752, -0.350942, 0.387604>, <-2.851210, -0.352941, 0.367821>, 
      <-2.699189, -0.330882, 0.590997>, <-2.675920, -0.324169, 0.555898>, <-2.641753, -0.350974, 0.520300>, <-2.617675, -0.352941, 0.485159>, 
      <-2.509940, -0.330882, 0.669110>, <-2.486671, -0.324169, 0.634010>, <-2.458719, -0.350974, 0.585722>, <-2.434642, -0.352941, 0.550581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.715117, -0.330882, 0.280488>, <-3.681436, -0.324317, 0.264057>, <-3.637264, -0.351087, 0.241891>, <-3.603664, -0.352941, 0.224140>, 
      <-3.540300, -0.330882, 0.313133>, <-3.506619, -0.324317, 0.296701>, <-3.467691, -0.351087, 0.269312>, <-3.434091, -0.352941, 0.251561>, 
      <-3.301650, -0.330882, 0.334724>, <-3.273048, -0.324270, 0.313128>, <-3.234411, -0.350942, 0.289126>, <-3.203868, -0.352941, 0.269344>, 
      <-3.132394, -0.330882, 0.389302>, <-3.103791, -0.324270, 0.367706>, <-3.068964, -0.350942, 0.335326>, <-3.038422, -0.352941, 0.315543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.371547, -0.397058, -0.854938>, <-2.409592, -0.397058, -0.904832>, <-2.484723, -0.391285, -0.996731>, <-2.495314, -0.330882, -1.010000>, 
      <-2.595832, -0.397058, -0.854938>, <-2.633877, -0.397058, -0.904832>, <-2.720714, -0.391285, -0.996731>, <-2.731305, -0.330882, -1.010000>, 
      <-2.894880, -0.397058, -0.854938>, <-2.944666, -0.397058, -0.904580>, <-3.030511, -0.397873, -0.995284>, <-3.045959, -0.330882, -1.010000>, 
      <-3.119165, -0.397058, -0.854938>, <-3.168952, -0.397058, -0.904580>, <-3.266501, -0.397873, -0.995284>, <-3.281950, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.596351, -0.397058, -0.854938>, <-1.622113, -0.397058, -0.905129>, <-1.673202, -0.385622, -0.997975>, <-1.679662, -0.330882, -1.010000>, 
      <-1.828910, -0.397058, -0.854938>, <-1.854672, -0.397058, -0.905129>, <-1.917897, -0.385622, -0.997975>, <-1.924358, -0.330882, -1.010000>, 
      <-2.138988, -0.397058, -0.854938>, <-2.177033, -0.397058, -0.904832>, <-2.240027, -0.391285, -0.996731>, <-2.250618, -0.330882, -1.010000>, 
      <-2.371547, -0.397058, -0.854938>, <-2.409592, -0.397058, -0.904832>, <-2.484723, -0.391285, -0.996731>, <-2.495314, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.802772, -0.397058, -0.854938>, <-0.815797, -0.397058, -0.905400>, <-0.841651, -0.381699, -0.998837>, <-0.844667, -0.330882, -1.010000>, 
      <-1.040846, -0.397058, -0.854938>, <-1.053871, -0.397058, -0.905400>, <-1.092150, -0.381699, -0.998837>, <-1.095166, -0.330882, -1.010000>, 
      <-1.358277, -0.397058, -0.854938>, <-1.384039, -0.397058, -0.905129>, <-1.422703, -0.385622, -0.997975>, <-1.429164, -0.330882, -1.010000>, 
      <-1.596351, -0.397058, -0.854938>, <-1.622113, -0.397058, -0.905129>, <-1.673202, -0.385622, -0.997975>, <-1.679662, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.397058, -0.854938>, <0.000000, -0.397058, -0.905516>, <0.000000, -0.380282, -0.999148>, <0.000000, -0.330882, -1.010000>, 
      <-0.240832, -0.397058, -0.854938>, <-0.240832, -0.397058, -0.905516>, <-0.253400, -0.380282, -0.999148>, <-0.253400, -0.330882, -1.010000>, 
      <-0.561940, -0.397058, -0.854938>, <-0.574965, -0.397058, -0.905400>, <-0.588251, -0.381699, -0.998837>, <-0.591267, -0.330882, -1.010000>, 
      <-0.802772, -0.397058, -0.854938>, <-0.815797, -0.397058, -0.905400>, <-0.841651, -0.381699, -0.998837>, <-0.844667, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802771, -0.397058, -0.854938>, <0.815797, -0.397058, -0.905400>, <0.841651, -0.381699, -0.998837>, <0.844667, -0.330882, -1.010000>, 
      <0.561940, -0.397058, -0.854938>, <0.574965, -0.397058, -0.905400>, <0.588251, -0.381699, -0.998837>, <0.591267, -0.330882, -1.010000>, 
      <0.240832, -0.397058, -0.854938>, <0.240832, -0.397058, -0.905516>, <0.253400, -0.380282, -0.999148>, <0.253400, -0.330882, -1.010000>, 
      <0.000000, -0.397058, -0.854938>, <0.000000, -0.397058, -0.905516>, <0.000000, -0.380282, -0.999148>, <0.000000, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.596351, -0.397058, -0.854938>, <1.622113, -0.397058, -0.905129>, <1.673202, -0.385622, -0.997975>, <1.679662, -0.330882, -1.010000>, 
      <1.358277, -0.397058, -0.854938>, <1.384039, -0.397058, -0.905129>, <1.422703, -0.385622, -0.997975>, <1.429164, -0.330882, -1.010000>, 
      <1.040845, -0.397058, -0.854938>, <1.053870, -0.397058, -0.905400>, <1.092150, -0.381699, -0.998837>, <1.095166, -0.330882, -1.010000>, 
      <0.802771, -0.397058, -0.854938>, <0.815797, -0.397058, -0.905400>, <0.841651, -0.381699, -0.998837>, <0.844667, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.371546, -0.397058, -0.854938>, <2.409591, -0.397058, -0.904832>, <2.484723, -0.391285, -0.996731>, <2.495314, -0.330882, -1.010000>, 
      <2.138988, -0.397058, -0.854938>, <2.177033, -0.397058, -0.904832>, <2.240027, -0.391285, -0.996731>, <2.250618, -0.330882, -1.010000>, 
      <1.828910, -0.397058, -0.854938>, <1.854671, -0.397058, -0.905129>, <1.917897, -0.385622, -0.997975>, <1.924358, -0.330882, -1.010000>, 
      <1.596351, -0.397058, -0.854938>, <1.622113, -0.397058, -0.905129>, <1.673202, -0.385622, -0.997975>, <1.679662, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.119166, -0.397058, -0.854938>, <3.168952, -0.397058, -0.904580>, <3.266502, -0.397873, -0.995284>, <3.281950, -0.330882, -1.010000>, 
      <2.894880, -0.397058, -0.854938>, <2.944666, -0.397058, -0.904580>, <3.030511, -0.397873, -0.995284>, <3.045959, -0.330882, -1.010000>, 
      <2.595832, -0.397058, -0.854938>, <2.633877, -0.397058, -0.904832>, <2.720714, -0.391285, -0.996731>, <2.731305, -0.330882, -1.010000>, 
      <2.371546, -0.397058, -0.854938>, <2.409591, -0.397058, -0.904832>, <2.484723, -0.391285, -0.996731>, <2.495314, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.830017, -0.397058, -0.854938>, <3.890915, -0.397058, -0.904389>, <4.008989, -0.404730, -0.993778>, <4.029900, -0.330882, -1.010000>, 
      <3.616762, -0.397058, -0.854938>, <3.677659, -0.397058, -0.904389>, <3.784604, -0.404730, -0.993778>, <3.805515, -0.330882, -1.010000>, 
      <3.332421, -0.397058, -0.854938>, <3.382208, -0.397058, -0.904580>, <3.490886, -0.397873, -0.995284>, <3.506335, -0.330882, -1.010000>, 
      <3.119166, -0.397058, -0.854938>, <3.168952, -0.397058, -0.904580>, <3.266502, -0.397873, -0.995284>, <3.281950, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.587567, -0.397058, 0.781262>, <2.563493, -0.397058, 0.742674>, <2.534756, -0.338041, 0.706544>, <2.509940, -0.330882, 0.669110>, 
      <2.783184, -0.397058, 0.691240>, <2.759111, -0.397058, 0.652653>, <2.724005, -0.338041, 0.628432>, <2.699189, -0.330882, 0.590997>, 
      <3.026633, -0.397058, 0.532498>, <2.995250, -0.397058, 0.506054>, <2.969746, -0.338327, 0.476454>, <2.937538, -0.330882, 0.452136>, 
      <3.229272, -0.397058, 0.459644>, <3.197889, -0.397058, 0.433201>, <3.164601, -0.338327, 0.413621>, <3.132394, -0.330882, 0.389302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.986821, -0.397058, 1.031409>, <1.968804, -0.397058, 0.983733>, <1.945725, -0.337836, 0.933712>, <1.927217, -0.330882, 0.886737>, 
      <2.178239, -0.397058, 0.993050>, <2.160222, -0.397058, 0.945375>, <2.129393, -0.337836, 0.900701>, <2.110884, -0.330882, 0.853726>, 
      <2.410221, -0.397058, 0.862875>, <2.386148, -0.397058, 0.824287>, <2.362262, -0.338041, 0.777741>, <2.337445, -0.330882, 0.740306>, 
      <2.587567, -0.397058, 0.781262>, <2.563493, -0.397058, 0.742674>, <2.534756, -0.338041, 0.706544>, <2.509940, -0.330882, 0.669110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.339265, -0.397058, 1.031409>, <1.327113, -0.397058, 0.983707>, <1.311595, -0.337854, 0.933833>, <1.299087, -0.330882, 0.886737>, 
      <1.530229, -0.397058, 1.067077>, <1.518078, -0.397058, 1.019375>, <1.497444, -0.337854, 0.964967>, <1.484936, -0.330882, 0.917871>, 
      <1.796341, -0.397058, 1.069579>, <1.778324, -0.397058, 1.021904>, <1.760258, -0.337836, 0.967046>, <1.741750, -0.330882, 0.920071>, 
      <1.986821, -0.397058, 1.031409>, <1.968804, -0.397058, 0.983733>, <1.945725, -0.337836, 0.933712>, <1.927217, -0.330882, 0.886737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.647557, -0.397058, 0.781262>, <0.641464, -0.397058, 0.742236>, <0.634482, -0.338205, 0.707400>, <0.628130, -0.330882, 0.669110>, 
      <0.866975, -0.397058, 0.804681>, <0.860882, -0.397058, 0.765655>, <0.845130, -0.338205, 0.727565>, <0.838778, -0.330882, 0.689274>, 
      <1.122351, -0.397058, 0.990893>, <1.110199, -0.397058, 0.943192>, <1.102893, -0.337854, 0.898871>, <1.090385, -0.330882, 0.851775>, 
      <1.339265, -0.397058, 1.031409>, <1.327113, -0.397058, 0.983707>, <1.311595, -0.337854, 0.933833>, <1.299087, -0.330882, 0.886737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.397058, 0.888468>, <0.000000, -0.397058, 0.845747>, <0.000000, -0.338041, 0.804494>, <0.000000, -0.330882, 0.762378>, 
      <0.196911, -0.397058, 0.888468>, <0.196911, -0.397058, 0.845747>, <0.190505, -0.338041, 0.804494>, <0.190505, -0.330882, 0.762378>, 
      <0.451757, -0.397058, 0.760364>, <0.445665, -0.397058, 0.721338>, <0.444844, -0.338205, 0.689246>, <0.438492, -0.330882, 0.650956>, 
      <0.647557, -0.397058, 0.781262>, <0.641464, -0.397058, 0.742236>, <0.634482, -0.338205, 0.707400>, <0.628130, -0.330882, 0.669110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.647557, -0.397058, 0.781262>, <-0.641464, -0.397058, 0.742236>, <-0.634482, -0.338205, 0.707400>, <-0.628130, -0.330882, 0.669110>, 
      <-0.451757, -0.397058, 0.760364>, <-0.445665, -0.397058, 0.721338>, <-0.444844, -0.338205, 0.689246>, <-0.438492, -0.330882, 0.650956>, 
      <-0.196911, -0.397058, 0.888468>, <-0.196911, -0.397058, 0.845747>, <-0.190505, -0.338041, 0.804494>, <-0.190505, -0.330882, 0.762378>, 
      <0.000000, -0.397058, 0.888468>, <0.000000, -0.397058, 0.845747>, <0.000000, -0.338041, 0.804494>, <0.000000, -0.330882, 0.762378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.339265, -0.397058, 1.031409>, <-1.327113, -0.397058, 0.983707>, <-1.311595, -0.337854, 0.933833>, <-1.299087, -0.330882, 0.886737>, 
      <-1.122351, -0.397058, 0.990894>, <-1.110199, -0.397058, 0.943192>, <-1.102893, -0.337854, 0.898871>, <-1.090385, -0.330882, 0.851775>, 
      <-0.866975, -0.397058, 0.804681>, <-0.860882, -0.397058, 0.765655>, <-0.845130, -0.338205, 0.727565>, <-0.838778, -0.330882, 0.689274>, 
      <-0.647557, -0.397058, 0.781262>, <-0.641464, -0.397058, 0.742236>, <-0.634482, -0.338205, 0.707400>, <-0.628130, -0.330882, 0.669110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.986821, -0.397058, 1.031409>, <-1.968804, -0.397058, 0.983733>, <-1.945725, -0.337836, 0.933712>, <-1.927217, -0.330882, 0.886737>, 
      <-1.796341, -0.397058, 1.069579>, <-1.778324, -0.397058, 1.021904>, <-1.760258, -0.337836, 0.967046>, <-1.741750, -0.330882, 0.920071>, 
      <-1.530229, -0.397058, 1.067077>, <-1.518077, -0.397058, 1.019375>, <-1.497444, -0.337854, 0.964967>, <-1.484936, -0.330882, 0.917871>, 
      <-1.339265, -0.397058, 1.031409>, <-1.327113, -0.397058, 0.983707>, <-1.311595, -0.337854, 0.933833>, <-1.299087, -0.330882, 0.886737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.587567, -0.397058, 0.781262>, <-2.563493, -0.397058, 0.742674>, <-2.534756, -0.338041, 0.706544>, <-2.509940, -0.330882, 0.669110>, 
      <-2.410221, -0.397058, 0.862875>, <-2.386148, -0.397058, 0.824287>, <-2.362262, -0.338041, 0.777741>, <-2.337445, -0.330882, 0.740306>, 
      <-2.178239, -0.397058, 0.993050>, <-2.160222, -0.397058, 0.945375>, <-2.129393, -0.337836, 0.900701>, <-2.110884, -0.330882, 0.853726>, 
      <-1.986821, -0.397058, 1.031409>, <-1.968804, -0.397058, 0.983733>, <-1.945725, -0.337836, 0.933712>, <-1.927217, -0.330882, 0.886737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.229272, -0.397058, 0.459644>, <-3.197889, -0.397058, 0.433201>, <-3.164601, -0.338327, 0.413621>, <-3.132394, -0.330882, 0.389302>, 
      <-3.026633, -0.397058, 0.532498>, <-2.995250, -0.397058, 0.506054>, <-2.969745, -0.338327, 0.476454>, <-2.937538, -0.330882, 0.452136>, 
      <-2.783184, -0.397058, 0.691240>, <-2.759111, -0.397058, 0.652653>, <-2.724005, -0.338041, 0.628432>, <-2.699189, -0.330882, 0.590997>, 
      <-2.587567, -0.397058, 0.781262>, <-2.563493, -0.397058, 0.742674>, <-2.534756, -0.338041, 0.706544>, <-2.509940, -0.330882, 0.669110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.830017, -0.397058, 0.334571>, <-3.792624, -0.397058, 0.313421>, <-3.753148, -0.338295, 0.299043>, <-3.715117, -0.330882, 0.280488>, 
      <-3.649794, -0.397058, 0.372093>, <-3.612400, -0.397058, 0.350943>, <-3.578331, -0.338295, 0.331687>, <-3.540300, -0.330882, 0.313133>, 
      <-3.402504, -0.397058, 0.397363>, <-3.371122, -0.397058, 0.370920>, <-3.333858, -0.338327, 0.359042>, <-3.301650, -0.330882, 0.334724>, 
      <-3.229272, -0.397058, 0.459644>, <-3.197889, -0.397058, 0.433201>, <-3.164601, -0.338327, 0.413621>, <-3.132394, -0.330882, 0.389302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.495314, -0.330882, -1.010000>, <-2.527708, -0.146129, -1.050585>, <-2.495314, 0.116912, -1.010000>, <-2.495314, 0.308823, -1.010000>, 
      <-2.731305, -0.330882, -1.010000>, <-2.763699, -0.146129, -1.050585>, <-2.731305, 0.116912, -1.010000>, <-2.731305, 0.308823, -1.010000>, 
      <-3.045959, -0.330882, -1.010000>, <-3.088130, -0.148021, -1.050169>, <-3.045959, 0.116912, -1.010000>, <-3.045959, 0.308823, -1.010000>, 
      <-3.281950, -0.330882, -1.010000>, <-3.324120, -0.148021, -1.050169>, <-3.281950, 0.116912, -1.010000>, <-3.281950, 0.308823, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.679662, -0.330882, -1.010000>, <-1.701640, -0.144673, -1.050905>, <-1.679662, 0.116912, -1.010000>, <-1.679662, 0.308823, -1.010000>, 
      <-1.924358, -0.330882, -1.010000>, <-1.946335, -0.144673, -1.050905>, <-1.924358, 0.116912, -1.010000>, <-1.924358, 0.308823, -1.010000>, 
      <-2.250618, -0.330882, -1.010000>, <-2.283013, -0.146129, -1.050585>, <-2.250618, 0.116912, -1.010000>, <-2.250618, 0.308823, -1.010000>, 
      <-2.495314, -0.330882, -1.010000>, <-2.527708, -0.146129, -1.050585>, <-2.495314, 0.116912, -1.010000>, <-2.495314, 0.308823, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.844667, -0.330882, -1.010000>, <-0.855774, -0.143754, -1.051107>, <-0.844667, 0.116912, -1.010000>, <-0.844667, 0.308823, -1.010000>, 
      <-1.095166, -0.330882, -1.010000>, <-1.106272, -0.143754, -1.051107>, <-1.095166, 0.116912, -1.010000>, <-1.095166, 0.308823, -1.010000>, 
      <-1.429164, -0.330882, -1.010000>, <-1.451141, -0.144673, -1.050905>, <-1.429164, 0.116912, -1.010000>, <-1.429164, 0.308823, -1.010000>, 
      <-1.679662, -0.330882, -1.010000>, <-1.701640, -0.144673, -1.050905>, <-1.679662, 0.116912, -1.010000>, <-1.679662, 0.308823, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.330882, -1.010000>, <0.000000, -0.143440, -1.051176>, <0.000000, 0.116912, -1.010000>, <0.000000, 0.308823, -1.010000>, 
      <-0.253400, -0.330882, -1.010000>, <-0.253400, -0.143440, -1.051176>, <-0.253400, 0.116912, -1.010000>, <-0.253400, 0.308823, -1.010000>, 
      <-0.591267, -0.330882, -1.010000>, <-0.602373, -0.143754, -1.051107>, <-0.591267, 0.116912, -1.010000>, <-0.591267, 0.308823, -1.010000>, 
      <-0.844667, -0.330882, -1.010000>, <-0.855774, -0.143754, -1.051107>, <-0.844667, 0.116912, -1.010000>, <-0.844667, 0.308823, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.844667, -0.330882, -1.010000>, <0.855773, -0.143754, -1.051107>, <0.844667, 0.116912, -1.010000>, <0.844667, 0.308823, -1.010000>, 
      <0.591267, -0.330882, -1.010000>, <0.602373, -0.143754, -1.051107>, <0.591267, 0.116912, -1.010000>, <0.591267, 0.308823, -1.010000>, 
      <0.253400, -0.330882, -1.010000>, <0.253400, -0.143440, -1.051176>, <0.253400, 0.116912, -1.010000>, <0.253400, 0.308823, -1.010000>, 
      <0.000000, -0.330882, -1.010000>, <0.000000, -0.143440, -1.051176>, <0.000000, 0.116912, -1.010000>, <0.000000, 0.308823, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.679662, -0.330882, -1.010000>, <1.701640, -0.144673, -1.050905>, <1.679662, 0.116912, -1.010000>, <1.679662, 0.308823, -1.010000>, 
      <1.429164, -0.330882, -1.010000>, <1.451141, -0.144673, -1.050905>, <1.429164, 0.116912, -1.010000>, <1.429164, 0.308823, -1.010000>, 
      <1.095166, -0.330882, -1.010000>, <1.106272, -0.143754, -1.051107>, <1.095166, 0.116912, -1.010000>, <1.095166, 0.308823, -1.010000>, 
      <0.844667, -0.330882, -1.010000>, <0.855773, -0.143754, -1.051107>, <0.844667, 0.116912, -1.010000>, <0.844667, 0.308823, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.495314, -0.330882, -1.010000>, <2.527708, -0.146129, -1.050585>, <2.495314, 0.116912, -1.010000>, <2.495314, 0.308823, -1.010000>, 
      <2.250618, -0.330882, -1.010000>, <2.283013, -0.146129, -1.050585>, <2.250618, 0.116912, -1.010000>, <2.250618, 0.308823, -1.010000>, 
      <1.924358, -0.330882, -1.010000>, <1.946335, -0.144673, -1.050905>, <1.924358, 0.116912, -1.010000>, <1.924358, 0.308823, -1.010000>, 
      <1.679662, -0.330882, -1.010000>, <1.701640, -0.144673, -1.050905>, <1.679662, 0.116912, -1.010000>, <1.679662, 0.308823, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.281950, -0.330882, -1.010000>, <3.324120, -0.148021, -1.050169>, <3.281950, 0.116912, -1.010000>, <3.281950, 0.308823, -1.010000>, 
      <3.045959, -0.330882, -1.010000>, <3.088129, -0.148021, -1.050169>, <3.045959, 0.116912, -1.010000>, <3.045959, 0.308823, -1.010000>, 
      <2.731305, -0.330882, -1.010000>, <2.763699, -0.146129, -1.050585>, <2.731305, 0.116912, -1.010000>, <2.731305, 0.308823, -1.010000>, 
      <2.495314, -0.330882, -1.010000>, <2.527708, -0.146129, -1.050585>, <2.495314, 0.116912, -1.010000>, <2.495314, 0.308823, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.029900, -0.330882, -1.010000>, <4.081057, -0.150222, -1.049686>, <4.029900, 0.116912, -1.010000>, <4.029900, 0.308823, -1.010000>, 
      <3.805515, -0.330882, -1.010000>, <3.856672, -0.150222, -1.049686>, <3.805515, 0.116912, -1.010000>, <3.805515, 0.308823, -1.010000>, 
      <3.506335, -0.330882, -1.010000>, <3.548505, -0.148021, -1.050169>, <3.506335, 0.116912, -1.010000>, <3.506335, 0.308823, -1.010000>, 
      <3.281950, -0.330882, -1.010000>, <3.324120, -0.148021, -1.050169>, <3.281950, 0.116912, -1.010000>, <3.281950, 0.308823, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.722608, -0.330882, 1.010000>, <2.707904, -0.407744, 0.985093>, <2.631035, -0.397058, 0.850938>, <2.587567, -0.397058, 0.781262>, 
      <2.929378, -0.330882, 0.898353>, <2.914674, -0.407744, 0.873446>, <2.826653, -0.397058, 0.760917>, <2.783184, -0.397058, 0.691240>, 
      <3.181292, -0.330882, 0.704275>, <3.165121, -0.398613, 0.689566>, <3.081059, -0.397058, 0.578358>, <3.026633, -0.397058, 0.532498>, 
      <3.397803, -0.330882, 0.612942>, <3.381632, -0.398613, 0.598232>, <3.283698, -0.397058, 0.505505>, <3.229272, -0.397058, 0.459644>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.090511, -0.330882, 1.318823>, <2.077867, -0.416954, 1.283777>, <2.019977, -0.397058, 1.119142>, <1.986821, -0.397058, 1.031409>, 
      <2.295959, -0.330882, 1.270517>, <2.283316, -0.416954, 1.235471>, <2.211395, -0.397058, 1.080784>, <2.178239, -0.397058, 0.993050>, 
      <2.536899, -0.330882, 1.110275>, <2.522195, -0.407744, 1.085368>, <2.453689, -0.397058, 0.932551>, <2.410221, -0.397058, 0.862875>, 
      <2.722608, -0.330882, 1.010000>, <2.707904, -0.407744, 0.985093>, <2.631035, -0.397058, 0.850938>, <2.587567, -0.397058, 0.781262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.409159, -0.330882, 1.318823>, <1.400855, -0.414748, 1.284676>, <1.361712, -0.397058, 1.119525>, <1.339265, -0.397058, 1.031409>, 
      <1.608826, -0.330882, 1.362581>, <1.600522, -0.414748, 1.328433>, <1.552677, -0.397058, 1.155193>, <1.530229, -0.397058, 1.067077>, 
      <1.891531, -0.330882, 1.365608>, <1.878888, -0.416954, 1.330562>, <1.829497, -0.397058, 1.157312>, <1.796341, -0.397058, 1.069579>, 
      <2.090511, -0.330882, 1.318823>, <2.077867, -0.416954, 1.283777>, <2.019977, -0.397058, 1.119142>, <1.986821, -0.397058, 1.031409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.681352, -0.330882, 1.010000>, <0.678069, -0.399449, 0.987781>, <0.658686, -0.397058, 0.852550>, <0.647557, -0.397058, 0.781262>, 
      <0.916699, -0.330882, 1.039473>, <0.913416, -0.399449, 1.017254>, <0.878105, -0.397058, 0.875968>, <0.866975, -0.397058, 0.804681>, 
      <1.177472, -0.330882, 1.268048>, <1.169168, -0.414748, 1.233900>, <1.144799, -0.397058, 1.079010>, <1.122351, -0.397058, 0.990893>, 
      <1.409159, -0.330882, 1.318823>, <1.400855, -0.414748, 1.284676>, <1.361712, -0.397058, 1.119525>, <1.339265, -0.397058, 1.031409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.330882, 1.142353>, <0.000000, -0.404948, 1.115714>, <0.000000, -0.397058, 0.967178>, <0.000000, -0.397058, 0.888468>, 
      <0.208226, -0.330882, 1.142353>, <0.208226, -0.404948, 1.115714>, <0.196911, -0.397058, 0.967178>, <0.196911, -0.397058, 0.888468>, 
      <0.474739, -0.330882, 0.984126>, <0.471457, -0.399449, 0.961907>, <0.462887, -0.397058, 0.831652>, <0.451757, -0.397058, 0.760364>, 
      <0.681352, -0.330882, 1.010000>, <0.678069, -0.399449, 0.987781>, <0.658686, -0.397058, 0.852550>, <0.647557, -0.397058, 0.781262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.681352, -0.330882, 1.010000>, <-0.678069, -0.399449, 0.987781>, <-0.658686, -0.397058, 0.852550>, <-0.647557, -0.397058, 0.781262>, 
      <-0.474739, -0.330882, 0.984126>, <-0.471457, -0.399449, 0.961907>, <-0.462887, -0.397058, 0.831652>, <-0.451757, -0.397058, 0.760364>, 
      <-0.208226, -0.330882, 1.142353>, <-0.208226, -0.404948, 1.115714>, <-0.196911, -0.397058, 0.967178>, <-0.196911, -0.397058, 0.888468>, 
      <0.000000, -0.330882, 1.142353>, <0.000000, -0.404948, 1.115714>, <0.000000, -0.397058, 0.967178>, <0.000000, -0.397058, 0.888468>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.409159, -0.330882, 1.318823>, <-1.400855, -0.414748, 1.284676>, <-1.361712, -0.397058, 1.119525>, <-1.339265, -0.397058, 1.031409>, 
      <-1.177472, -0.330882, 1.268048>, <-1.169168, -0.414748, 1.233901>, <-1.144798, -0.397058, 1.079010>, <-1.122351, -0.397058, 0.990894>, 
      <-0.916698, -0.330882, 1.039473>, <-0.913416, -0.399449, 1.017254>, <-0.878105, -0.397058, 0.875968>, <-0.866975, -0.397058, 0.804681>, 
      <-0.681352, -0.330882, 1.010000>, <-0.678069, -0.399449, 0.987781>, <-0.658686, -0.397058, 0.852550>, <-0.647557, -0.397058, 0.781262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.090511, -0.330882, 1.318823>, <-2.077867, -0.416954, 1.283777>, <-2.019977, -0.397058, 1.119142>, <-1.986821, -0.397058, 1.031409>, 
      <-1.891531, -0.330882, 1.365608>, <-1.878888, -0.416954, 1.330562>, <-1.829497, -0.397058, 1.157312>, <-1.796341, -0.397058, 1.069579>, 
      <-1.608826, -0.330882, 1.362581>, <-1.600522, -0.414748, 1.328433>, <-1.552677, -0.397058, 1.155194>, <-1.530229, -0.397058, 1.067077>, 
      <-1.409159, -0.330882, 1.318823>, <-1.400855, -0.414748, 1.284676>, <-1.361712, -0.397058, 1.119525>, <-1.339265, -0.397058, 1.031409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.722608, -0.330882, 1.010000>, <-2.707904, -0.407744, 0.985093>, <-2.631035, -0.397058, 0.850938>, <-2.587567, -0.397058, 0.781262>, 
      <-2.536899, -0.330882, 1.110275>, <-2.522195, -0.407744, 1.085368>, <-2.453689, -0.397058, 0.932551>, <-2.410221, -0.397058, 0.862875>, 
      <-2.295959, -0.330882, 1.270517>, <-2.283316, -0.416954, 1.235471>, <-2.211395, -0.397058, 1.080784>, <-2.178239, -0.397058, 0.993050>, 
      <-2.090511, -0.330882, 1.318823>, <-2.077867, -0.416954, 1.283777>, <-2.019977, -0.397058, 1.119142>, <-1.986821, -0.397058, 1.031409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.397802, -0.330882, 0.612942>, <-3.381632, -0.398613, 0.598232>, <-3.283698, -0.397058, 0.505505>, <-3.229272, -0.397058, 0.459644>, 
      <-3.181291, -0.330882, 0.704275>, <-3.165120, -0.398613, 0.689566>, <-3.081059, -0.397058, 0.578358>, <-3.026633, -0.397058, 0.532498>, 
      <-2.929378, -0.330882, 0.898353>, <-2.914674, -0.407744, 0.873446>, <-2.826653, -0.397058, 0.760917>, <-2.783184, -0.397058, 0.691240>, 
      <-2.722608, -0.330882, 1.010000>, <-2.707904, -0.407744, 0.985093>, <-2.631035, -0.397058, 0.850938>, <-2.587567, -0.397058, 0.781262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.029900, -0.330882, 0.458530>, <-4.010208, -0.400423, 0.446318>, <-3.893819, -0.397058, 0.370657>, <-3.830017, -0.397058, 0.334571>, 
      <-3.840271, -0.330882, 0.504853>, <-3.820579, -0.400423, 0.492641>, <-3.713595, -0.397058, 0.408179>, <-3.649794, -0.397058, 0.372093>, 
      <-3.577660, -0.330882, 0.537070>, <-3.561489, -0.398613, 0.522361>, <-3.456930, -0.397058, 0.443224>, <-3.402504, -0.397058, 0.397363>, 
      <-3.397802, -0.330882, 0.612942>, <-3.381632, -0.398613, 0.598232>, <-3.283698, -0.397058, 0.505505>, <-3.229272, -0.397058, 0.459644>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.830017, -0.397058, -0.854938>, <-3.616762, -0.397058, -0.854938>, <-3.332421, -0.397058, -0.854938>, <-3.119165, -0.397058, -0.854938>, 
      <-3.890915, -0.397058, -0.904389>, <-3.677659, -0.397058, -0.904389>, <-3.382208, -0.397058, -0.904580>, <-3.168952, -0.397058, -0.904580>, 
      <-4.008989, -0.404730, -0.993778>, <-3.784604, -0.404730, -0.993778>, <-3.490886, -0.397873, -0.995284>, <-3.266501, -0.397873, -0.995284>, 
      <-4.029900, -0.330882, -1.010000>, <-3.805515, -0.330882, -1.010000>, <-3.506335, -0.330882, -1.010000>, <-3.281950, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.715117, -0.330882, -0.754385>, <-3.508259, -0.330882, -0.754385>, <-3.232449, -0.330882, -0.754385>, <-3.025591, -0.330882, -0.754385>, 
      <-3.751364, -0.337947, -0.787979>, <-3.544506, -0.337947, -0.787979>, <-3.262271, -0.338019, -0.788323>, <-3.055413, -0.338019, -0.788323>, 
      <-3.791262, -0.397058, -0.823468>, <-3.578007, -0.397058, -0.823468>, <-3.300031, -0.397058, -0.822642>, <-3.086775, -0.397058, -0.822642>, 
      <-3.830017, -0.397058, -0.854938>, <-3.616762, -0.397058, -0.854938>, <-3.332421, -0.397058, -0.854938>, <-3.119165, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.603664, -0.352941, -0.645154>, <-3.403012, -0.352941, -0.645154>, <-3.135475, -0.352941, -0.645154>, <-2.934823, -0.352941, -0.645154>, 
      <-3.642531, -0.350796, -0.671992>, <-3.441879, -0.350796, -0.671992>, <-3.168319, -0.350715, -0.673001>, <-2.967667, -0.350715, -0.673001>, 
      <-3.680788, -0.324191, -0.722568>, <-3.473930, -0.324191, -0.722568>, <-3.204336, -0.324154, -0.722392>, <-2.997478, -0.324154, -0.722392>, 
      <-3.715117, -0.330882, -0.754385>, <-3.508259, -0.330882, -0.754385>, <-3.232449, -0.330882, -0.754385>, <-3.025591, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.315371, -0.352941, -0.478359>, <-3.130771, -0.352941, -0.478359>, <-2.884637, -0.352941, -0.478359>, <-2.700037, -0.352941, -0.478359>, 
      <-3.397310, -0.320966, -0.525766>, <-3.212711, -0.320966, -0.525766>, <-2.950245, -0.321504, -0.524968>, <-2.765645, -0.321504, -0.524968>, 
      <-3.521525, -0.357473, -0.588437>, <-3.320873, -0.357473, -0.588437>, <-3.069662, -0.357400, -0.589353>, <-2.869009, -0.357400, -0.589353>, 
      <-3.603664, -0.352941, -0.645154>, <-3.403012, -0.352941, -0.645154>, <-3.135475, -0.352941, -0.645154>, <-2.934823, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.315371, -0.465441, -0.478359>, <-3.130771, -0.465441, -0.478359>, <-2.884637, -0.465441, -0.478359>, <-2.700037, -0.465441, -0.478359>, 
      <-3.344309, -0.451413, -0.488597>, <-3.159709, -0.451413, -0.488597>, <-2.911807, -0.449269, -0.490162>, <-2.727207, -0.449269, -0.490162>, 
      <-3.287694, -0.363741, -0.462346>, <-3.103094, -0.363741, -0.462346>, <-2.859010, -0.365221, -0.460152>, <-2.674409, -0.365221, -0.460152>, 
      <-3.315371, -0.352941, -0.478359>, <-3.130771, -0.352941, -0.478359>, <-2.884637, -0.352941, -0.478359>, <-2.700037, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.083295, -0.465441, -0.396248>, <-2.911617, -0.465441, -0.396248>, <-2.682713, -0.465441, -0.396248>, <-2.511035, -0.465441, -0.396248>, 
      <-3.130921, -0.519311, -0.413099>, <-2.959243, -0.519311, -0.413099>, <-2.717725, -0.514068, -0.411459>, <-2.546046, -0.514068, -0.411459>, 
      <-3.252047, -0.496137, -0.455954>, <-3.067447, -0.496137, -0.455954>, <-2.834870, -0.495064, -0.456738>, <-2.650270, -0.495064, -0.456738>, 
      <-3.315371, -0.465441, -0.478359>, <-3.130771, -0.465441, -0.478359>, <-2.884637, -0.465441, -0.478359>, <-2.700037, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.083295, -0.202941, -0.396248>, <-2.911617, -0.202941, -0.396248>, <-2.682713, -0.202941, -0.396248>, <-2.511035, -0.202941, -0.396248>, 
      <-3.083295, -0.281691, -0.396248>, <-2.911617, -0.281691, -0.396248>, <-2.682713, -0.281691, -0.396248>, <-2.511035, -0.281691, -0.396248>, 
      <-3.032510, -0.407998, -0.378280>, <-2.860832, -0.407998, -0.378280>, <-2.638113, -0.403497, -0.376872>, <-2.466435, -0.403497, -0.376872>, 
      <-3.083295, -0.465441, -0.396248>, <-2.911617, -0.465441, -0.396248>, <-2.682713, -0.465441, -0.396248>, <-2.511035, -0.465441, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.830017, -0.397058, -0.854938>, <3.830017, -0.397058, -0.498086>, <3.830017, -0.397058, -0.022282>, <3.830017, -0.397058, 0.334571>, 
      <3.890915, -0.397058, -0.904389>, <3.890915, -0.397058, -0.547536>, <3.893819, -0.397058, 0.013804>, <3.893819, -0.397058, 0.370657>, 
      <4.008989, -0.404730, -0.993778>, <4.008989, -0.404730, -0.553219>, <4.010208, -0.400423, 0.005759>, <4.010208, -0.400423, 0.446318>, 
      <4.029900, -0.330882, -1.010000>, <4.029900, -0.330882, -0.569441>, <4.029900, -0.330882, 0.017971>, <4.029900, -0.330882, 0.458530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.715117, -0.330882, -0.754385>, <3.715117, -0.330882, -0.443923>, <3.715117, -0.330882, -0.029973>, <3.715117, -0.330882, 0.280488>, 
      <3.751364, -0.337947, -0.787979>, <3.751364, -0.337947, -0.477517>, <3.753148, -0.338295, -0.011419>, <3.753148, -0.338295, 0.299043>, 
      <3.791262, -0.397058, -0.823468>, <3.791262, -0.397058, -0.466615>, <3.792624, -0.397058, -0.043431>, <3.792624, -0.397058, 0.313421>, 
      <3.830017, -0.397058, -0.854938>, <3.830017, -0.397058, -0.498086>, <3.830017, -0.397058, -0.022282>, <3.830017, -0.397058, 0.334571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.603664, -0.352941, -0.645154>, <3.603664, -0.352941, -0.384366>, <3.603664, -0.352941, -0.036648>, <3.603664, -0.352941, 0.224140>, 
      <3.642531, -0.350796, -0.671992>, <3.642531, -0.350796, -0.411204>, <3.637264, -0.351087, -0.018897>, <3.637264, -0.351087, 0.241891>, 
      <3.680788, -0.324191, -0.722568>, <3.680788, -0.324191, -0.412106>, <3.681436, -0.324317, -0.046405>, <3.681436, -0.324317, 0.264057>, 
      <3.715117, -0.330882, -0.754385>, <3.715117, -0.330882, -0.443923>, <3.715117, -0.330882, -0.029973>, <3.715117, -0.330882, 0.280488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.315371, -0.352941, -0.478359>, <3.315371, -0.352941, -0.314062>, <3.315371, -0.352941, -0.095000>, <3.315371, -0.352941, 0.069296>, 
      <3.397310, -0.320966, -0.525766>, <3.397310, -0.320966, -0.361469>, <3.397160, -0.321024, -0.051071>, <3.397160, -0.321024, 0.113226>, 
      <3.521525, -0.357473, -0.588437>, <3.521525, -0.357473, -0.327649>, <3.516963, -0.357725, -0.082454>, <3.516963, -0.357725, 0.178334>, 
      <3.603664, -0.352941, -0.645154>, <3.603664, -0.352941, -0.384366>, <3.603664, -0.352941, -0.036648>, <3.603664, -0.352941, 0.224140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.315371, -0.465441, -0.478359>, <3.315371, -0.465441, -0.314062>, <3.315371, -0.465441, -0.095000>, <3.315371, -0.465441, 0.069296>, 
      <3.344309, -0.451413, -0.488597>, <3.344309, -0.451413, -0.324301>, <3.344799, -0.451175, -0.086662>, <3.344799, -0.451175, 0.077634>, 
      <3.287694, -0.363741, -0.462346>, <3.287694, -0.363741, -0.298049>, <3.287253, -0.363913, -0.110102>, <3.287253, -0.363913, 0.054194>, 
      <3.315371, -0.352941, -0.478359>, <3.315371, -0.352941, -0.314062>, <3.315371, -0.352941, -0.095000>, <3.315371, -0.352941, 0.069296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.083295, -0.465441, -0.396248>, <3.083295, -0.465441, -0.276312>, <3.083295, -0.465441, -0.116396>, <3.083295, -0.465441, 0.003540>, 
      <3.130921, -0.519311, -0.413099>, <3.130921, -0.519311, -0.293162>, <3.130403, -0.518725, -0.103049>, <3.130403, -0.518725, 0.016888>, 
      <3.252047, -0.496137, -0.455954>, <3.252047, -0.496137, -0.291658>, <3.252273, -0.496028, -0.112878>, <3.252273, -0.496028, 0.051418>, 
      <3.315371, -0.465441, -0.478359>, <3.315371, -0.465441, -0.314062>, <3.315371, -0.465441, -0.095000>, <3.315371, -0.465441, 0.069296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.083295, -0.202941, -0.396248>, <3.083295, -0.202941, -0.276312>, <3.083295, -0.202941, -0.116396>, <3.083295, -0.202941, 0.003540>, 
      <3.083295, -0.281691, -0.396248>, <3.083295, -0.281691, -0.276312>, <3.083295, -0.281691, -0.116396>, <3.083295, -0.281691, 0.003540>, 
      <3.032510, -0.407998, -0.378280>, <3.032510, -0.407998, -0.258344>, <3.032029, -0.407455, -0.130922>, <3.032029, -0.407455, -0.010986>, 
      <3.083295, -0.465441, -0.396248>, <3.083295, -0.465441, -0.276312>, <3.083295, -0.465441, -0.116396>, <3.083295, -0.465441, 0.003540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.830017, -0.397058, 0.334571>, <3.649794, -0.397058, 0.372093>, <3.402504, -0.397058, 0.397363>, <3.229272, -0.397058, 0.459644>, 
      <3.893819, -0.397058, 0.370657>, <3.713595, -0.397058, 0.408179>, <3.456930, -0.397058, 0.443224>, <3.283698, -0.397058, 0.505505>, 
      <4.010208, -0.400423, 0.446318>, <3.820579, -0.400423, 0.492641>, <3.561489, -0.398613, 0.522361>, <3.381632, -0.398613, 0.598232>, 
      <4.029900, -0.330882, 0.458530>, <3.840271, -0.330882, 0.504853>, <3.577660, -0.330882, 0.537070>, <3.397803, -0.330882, 0.612942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.715117, -0.330882, 0.280488>, <3.540300, -0.330882, 0.313133>, <3.301651, -0.330882, 0.334724>, <3.132394, -0.330882, 0.389302>, 
      <3.753148, -0.338295, 0.299043>, <3.578331, -0.338295, 0.331687>, <3.333858, -0.338327, 0.359042>, <3.164601, -0.338327, 0.413621>, 
      <3.792624, -0.397058, 0.313421>, <3.612400, -0.397058, 0.350943>, <3.371122, -0.397058, 0.370920>, <3.197889, -0.397058, 0.433201>, 
      <3.830017, -0.397058, 0.334571>, <3.649794, -0.397058, 0.372093>, <3.402504, -0.397058, 0.397363>, <3.229272, -0.397058, 0.459644>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.603664, -0.352941, 0.224140>, <3.434091, -0.352941, 0.251561>, <3.203868, -0.352941, 0.269344>, <3.038422, -0.352941, 0.315543>, 
      <3.637264, -0.351087, 0.241891>, <3.467691, -0.351087, 0.269312>, <3.234411, -0.350942, 0.289126>, <3.068965, -0.350942, 0.335326>, 
      <3.681436, -0.324317, 0.264057>, <3.506619, -0.324317, 0.296701>, <3.273048, -0.324270, 0.313128>, <3.103792, -0.324270, 0.367706>, 
      <3.715117, -0.330882, 0.280488>, <3.540300, -0.330882, 0.313133>, <3.301651, -0.330882, 0.334724>, <3.132394, -0.330882, 0.389302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.315371, -0.352941, 0.069296>, <3.159364, -0.352941, 0.099807>, <2.951482, -0.352941, 0.141142>, <2.795348, -0.352941, 0.170998>, 
      <3.397160, -0.321024, 0.113226>, <3.241154, -0.321024, 0.143736>, <3.019239, -0.321581, 0.181435>, <2.863106, -0.321581, 0.211291>, 
      <3.516963, -0.357725, 0.178334>, <3.347390, -0.357725, 0.205756>, <3.132766, -0.357594, 0.223291>, <2.967320, -0.357594, 0.269491>, 
      <3.603664, -0.352941, 0.224140>, <3.434091, -0.352941, 0.251561>, <3.203868, -0.352941, 0.269344>, <3.038422, -0.352941, 0.315543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.315371, -0.465441, 0.069296>, <3.159364, -0.465441, 0.099807>, <2.951482, -0.465441, 0.141142>, <2.795348, -0.465441, 0.170998>, 
      <3.344799, -0.451175, 0.077634>, <3.188792, -0.451175, 0.108145>, <2.978525, -0.449893, 0.154025>, <2.822392, -0.449893, 0.183881>, 
      <3.287253, -0.363913, 0.054194>, <3.131246, -0.363913, 0.084705>, <2.924527, -0.365416, 0.125114>, <2.768394, -0.365416, 0.154970>, 
      <3.315371, -0.352941, 0.069296>, <3.159364, -0.352941, 0.099807>, <2.951482, -0.352941, 0.141142>, <2.795348, -0.352941, 0.170998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.083295, -0.465441, 0.003540>, <2.938208, -0.465441, 0.025813>, <2.744834, -0.465441, 0.055994>, <2.599674, -0.465441, 0.077782>, 
      <3.130403, -0.518725, 0.016888>, <2.985317, -0.518725, 0.039160>, <2.782209, -0.515581, 0.073799>, <2.637050, -0.515581, 0.095588>, 
      <3.252273, -0.496028, 0.051418>, <3.096267, -0.496028, 0.081929>, <2.899379, -0.495396, 0.116322>, <2.743246, -0.495396, 0.146178>, 
      <3.315371, -0.465441, 0.069296>, <3.159364, -0.465441, 0.099807>, <2.951482, -0.465441, 0.141142>, <2.795348, -0.465441, 0.170998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.083295, -0.202941, 0.003540>, <2.938208, -0.202941, 0.025813>, <2.744834, -0.202941, 0.055994>, <2.599674, -0.202941, 0.077782>, 
      <3.083295, -0.281691, 0.003540>, <2.938208, -0.281691, 0.025813>, <2.744834, -0.281691, 0.055994>, <2.599674, -0.281691, 0.077782>, 
      <3.032029, -0.407455, -0.010986>, <2.886943, -0.407455, 0.011287>, <2.699568, -0.404716, 0.034430>, <2.554408, -0.404716, 0.056218>, 
      <3.083295, -0.465441, 0.003540>, <2.938208, -0.465441, 0.025813>, <2.744834, -0.465441, 0.055994>, <2.599674, -0.465441, 0.077782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.830017, -0.397058, 0.334571>, <-3.830017, -0.397058, -0.022282>, <-3.830017, -0.397058, -0.498086>, <-3.830017, -0.397058, -0.854938>, 
      <-3.893819, -0.397058, 0.370657>, <-3.893819, -0.397058, 0.013804>, <-3.890915, -0.397058, -0.547536>, <-3.890915, -0.397058, -0.904389>, 
      <-4.010208, -0.400423, 0.446318>, <-4.010208, -0.400423, 0.005759>, <-4.008989, -0.404730, -0.553219>, <-4.008989, -0.404730, -0.993778>, 
      <-4.029900, -0.330882, 0.458530>, <-4.029900, -0.330882, 0.017971>, <-4.029900, -0.330882, -0.569441>, <-4.029900, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.715117, -0.330882, 0.280488>, <-3.715117, -0.330882, -0.029973>, <-3.715117, -0.330882, -0.443923>, <-3.715117, -0.330882, -0.754385>, 
      <-3.753148, -0.338295, 0.299043>, <-3.753148, -0.338295, -0.011419>, <-3.751364, -0.337947, -0.477517>, <-3.751364, -0.337947, -0.787979>, 
      <-3.792624, -0.397058, 0.313421>, <-3.792624, -0.397058, -0.043431>, <-3.791262, -0.397058, -0.466615>, <-3.791262, -0.397058, -0.823468>, 
      <-3.830017, -0.397058, 0.334571>, <-3.830017, -0.397058, -0.022282>, <-3.830017, -0.397058, -0.498086>, <-3.830017, -0.397058, -0.854938>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.603664, -0.352941, 0.224140>, <-3.603664, -0.352941, -0.036648>, <-3.603664, -0.352941, -0.384366>, <-3.603664, -0.352941, -0.645154>, 
      <-3.637264, -0.351087, 0.241891>, <-3.637264, -0.351087, -0.018897>, <-3.642531, -0.350796, -0.411204>, <-3.642531, -0.350796, -0.671992>, 
      <-3.681436, -0.324317, 0.264057>, <-3.681436, -0.324317, -0.046405>, <-3.680788, -0.324191, -0.412106>, <-3.680788, -0.324191, -0.722568>, 
      <-3.715117, -0.330882, 0.280488>, <-3.715117, -0.330882, -0.029973>, <-3.715117, -0.330882, -0.443923>, <-3.715117, -0.330882, -0.754385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.315371, -0.352941, 0.069296>, <-3.315371, -0.352941, -0.095000>, <-3.315371, -0.352941, -0.314062>, <-3.315371, -0.352941, -0.478359>, 
      <-3.397160, -0.321024, 0.113226>, <-3.397160, -0.321024, -0.051071>, <-3.397310, -0.320966, -0.361469>, <-3.397310, -0.320966, -0.525766>, 
      <-3.516963, -0.357725, 0.178334>, <-3.516963, -0.357725, -0.082454>, <-3.521525, -0.357473, -0.327649>, <-3.521525, -0.357473, -0.588437>, 
      <-3.603664, -0.352941, 0.224140>, <-3.603664, -0.352941, -0.036648>, <-3.603664, -0.352941, -0.384366>, <-3.603664, -0.352941, -0.645154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.315371, -0.465441, 0.069296>, <-3.315371, -0.465441, -0.095000>, <-3.315371, -0.465441, -0.314062>, <-3.315371, -0.465441, -0.478359>, 
      <-3.344799, -0.451175, 0.077634>, <-3.344799, -0.451175, -0.086662>, <-3.344309, -0.451413, -0.324301>, <-3.344309, -0.451413, -0.488597>, 
      <-3.287253, -0.363913, 0.054194>, <-3.287253, -0.363913, -0.110102>, <-3.287694, -0.363741, -0.298049>, <-3.287694, -0.363741, -0.462346>, 
      <-3.315371, -0.352941, 0.069296>, <-3.315371, -0.352941, -0.095000>, <-3.315371, -0.352941, -0.314062>, <-3.315371, -0.352941, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.083295, -0.465441, 0.003540>, <-3.083295, -0.465441, -0.116396>, <-3.083295, -0.465441, -0.276312>, <-3.083295, -0.465441, -0.396248>, 
      <-3.130403, -0.518725, 0.016888>, <-3.130403, -0.518725, -0.103049>, <-3.130921, -0.519311, -0.293162>, <-3.130921, -0.519311, -0.413099>, 
      <-3.252273, -0.496028, 0.051418>, <-3.252273, -0.496028, -0.112878>, <-3.252047, -0.496137, -0.291658>, <-3.252047, -0.496137, -0.455954>, 
      <-3.315371, -0.465441, 0.069296>, <-3.315371, -0.465441, -0.095000>, <-3.315371, -0.465441, -0.314062>, <-3.315371, -0.465441, -0.478359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.083295, -0.202941, 0.003540>, <-3.083295, -0.202941, -0.116396>, <-3.083295, -0.202941, -0.276312>, <-3.083295, -0.202941, -0.396248>, 
      <-3.083295, -0.281691, 0.003540>, <-3.083295, -0.281691, -0.116396>, <-3.083295, -0.281691, -0.276312>, <-3.083295, -0.281691, -0.396248>, 
      <-3.032029, -0.407455, -0.010986>, <-3.032029, -0.407455, -0.130922>, <-3.032510, -0.407998, -0.258344>, <-3.032510, -0.407998, -0.378280>, 
      <-3.083295, -0.465441, 0.003540>, <-3.083295, -0.465441, -0.116396>, <-3.083295, -0.465441, -0.276312>, <-3.083295, -0.465441, -0.396248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.029900, 0.308823, -1.010000>, <-4.029900, 0.116912, -1.010000>, <-4.081057, -0.150222, -1.049686>, <-4.029900, -0.330882, -1.010000>, 
      <-4.029900, 0.308823, -0.569441>, <-4.029900, 0.116912, -0.569441>, <-4.081057, -0.150222, -0.609127>, <-4.029900, -0.330882, -0.569441>, 
      <-4.029900, 0.308823, 0.017971>, <-4.029900, 0.116912, 0.017971>, <-4.081457, -0.148811, 0.049944>, <-4.029900, -0.330882, 0.017971>, 
      <-4.029900, 0.308823, 0.458530>, <-4.029900, 0.116912, 0.458530>, <-4.081457, -0.148811, 0.490503>, <-4.029900, -0.330882, 0.458530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.281950, 0.308823, -1.010000>, <-3.281950, 0.116912, -1.010000>, <-3.324120, -0.148021, -1.050169>, <-3.281950, -0.330882, -1.010000>, 
      <-3.506335, 0.308823, -1.010000>, <-3.506335, 0.116912, -1.010000>, <-3.548505, -0.148021, -1.050169>, <-3.506335, -0.330882, -1.010000>, 
      <-3.805515, 0.308823, -1.010000>, <-3.805515, 0.116912, -1.010000>, <-3.856672, -0.150222, -1.049686>, <-3.805515, -0.330882, -1.010000>, 
      <-4.029900, 0.308823, -1.010000>, <-4.029900, 0.116912, -1.010000>, <-4.081057, -0.150222, -1.049686>, <-4.029900, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.029900, 0.308823, 0.458530>, <4.029900, 0.116912, 0.458530>, <4.081457, -0.148811, 0.490503>, <4.029900, -0.330882, 0.458530>, 
      <4.029900, 0.308823, 0.017971>, <4.029900, 0.116912, 0.017971>, <4.081457, -0.148811, 0.049944>, <4.029900, -0.330882, 0.017971>, 
      <4.029900, 0.308823, -0.569441>, <4.029900, 0.116912, -0.569441>, <4.081057, -0.150222, -0.609127>, <4.029900, -0.330882, -0.569441>, 
      <4.029900, 0.308823, -1.010000>, <4.029900, 0.116912, -1.010000>, <4.081057, -0.150222, -1.049686>, <4.029900, -0.330882, -1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.397803, 0.308823, 0.612942>, <3.397803, 0.116912, 0.612942>, <3.441408, -0.148247, 0.652605>, <3.397803, -0.330882, 0.612942>, 
      <3.577660, 0.308823, 0.537070>, <3.577660, 0.116912, 0.537070>, <3.621265, -0.148247, 0.576733>, <3.577660, -0.330882, 0.537070>, 
      <3.840271, 0.308823, 0.504853>, <3.840271, 0.116912, 0.504853>, <3.891828, -0.148811, 0.536827>, <3.840271, -0.330882, 0.504853>, 
      <4.029900, 0.308823, 0.458530>, <4.029900, 0.116912, 0.458530>, <4.081457, -0.148811, 0.490503>, <4.029900, -0.330882, 0.458530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.722608, 0.308823, 1.010000>, <2.722608, 0.116912, 1.010000>, <2.756970, -0.151267, 1.068204>, <2.722608, -0.330882, 1.010000>, 
      <2.929378, 0.308823, 0.898353>, <2.929378, 0.116912, 0.898353>, <2.963740, -0.151267, 0.956557>, <2.929378, -0.330882, 0.898353>, 
      <3.181292, 0.308823, 0.704275>, <3.181292, 0.116912, 0.704275>, <3.224896, -0.148247, 0.743938>, <3.181292, -0.330882, 0.704275>, 
      <3.397803, 0.308823, 0.612942>, <3.397803, 0.116912, 0.612942>, <3.441408, -0.148247, 0.652605>, <3.397803, -0.330882, 0.612942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.090511, 0.308823, 1.318823>, <2.090511, 0.116912, 1.318823>, <2.116381, -0.154762, 1.390534>, <2.090511, -0.330882, 1.318823>, 
      <2.295959, 0.308823, 1.270517>, <2.295959, 0.116912, 1.270517>, <2.321830, -0.154762, 1.342228>, <2.295959, -0.330882, 1.270517>, 
      <2.536899, 0.308823, 1.110275>, <2.536899, 0.116912, 1.110275>, <2.571261, -0.151267, 1.168478>, <2.536899, -0.330882, 1.110275>, 
      <2.722608, 0.308823, 1.010000>, <2.722608, 0.116912, 1.010000>, <2.756970, -0.151267, 1.068204>, <2.722608, -0.330882, 1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.409159, 0.308823, 1.318823>, <1.409159, 0.116912, 1.318823>, <1.426685, -0.153882, 1.390892>, <1.409159, -0.330882, 1.318823>, 
      <1.608826, 0.308823, 1.362581>, <1.608826, 0.116912, 1.362581>, <1.626352, -0.153882, 1.434650>, <1.608826, -0.330882, 1.362581>, 
      <1.891531, 0.308823, 1.365608>, <1.891531, 0.116912, 1.365608>, <1.917402, -0.154762, 1.437319>, <1.891531, -0.330882, 1.365608>, 
      <2.090511, 0.308823, 1.318823>, <2.090511, 0.116912, 1.318823>, <2.116381, -0.154762, 1.390534>, <2.090511, -0.330882, 1.318823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.681352, 0.308823, 1.010000>, <0.681352, 0.116912, 1.010000>, <0.690083, -0.148506, 1.069098>, <0.681352, -0.330882, 1.010000>, 
      <0.916699, 0.308823, 1.039473>, <0.916699, 0.116912, 1.039473>, <0.925430, -0.148506, 1.098571>, <0.916699, -0.330882, 1.039473>, 
      <1.177472, 0.308823, 1.268048>, <1.177472, 0.116912, 1.268048>, <1.194998, -0.153882, 1.340117>, <1.177472, -0.330882, 1.268048>, 
      <1.409159, 0.308823, 1.318823>, <1.409159, 0.116912, 1.318823>, <1.426685, -0.153882, 1.390892>, <1.409159, -0.330882, 1.318823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.308823, 1.142353>, <0.000000, 0.116912, 1.142353>, <0.000000, -0.150296, 1.207305>, <0.000000, -0.330882, 1.142353>, 
      <0.208226, 0.308823, 1.142353>, <0.208226, 0.116912, 1.142353>, <0.208226, -0.150296, 1.207305>, <0.208226, -0.330882, 1.142353>, 
      <0.474739, 0.308823, 0.984126>, <0.474739, 0.116912, 0.984126>, <0.483471, -0.148506, 1.043224>, <0.474739, -0.330882, 0.984126>, 
      <0.681352, 0.308823, 1.010000>, <0.681352, 0.116912, 1.010000>, <0.690083, -0.148506, 1.069098>, <0.681352, -0.330882, 1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.681352, 0.308823, 1.010000>, <-0.681352, 0.116912, 1.010000>, <-0.690083, -0.148506, 1.069098>, <-0.681352, -0.330882, 1.010000>, 
      <-0.474739, 0.308823, 0.984126>, <-0.474739, 0.116912, 0.984126>, <-0.483471, -0.148506, 1.043224>, <-0.474739, -0.330882, 0.984126>, 
      <-0.208226, 0.308823, 1.142353>, <-0.208226, 0.116912, 1.142353>, <-0.208226, -0.150296, 1.207305>, <-0.208226, -0.330882, 1.142353>, 
      <0.000000, 0.308823, 1.142353>, <0.000000, 0.116912, 1.142353>, <0.000000, -0.150296, 1.207305>, <0.000000, -0.330882, 1.142353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.409159, 0.308823, 1.318823>, <-1.409159, 0.116912, 1.318823>, <-1.426685, -0.153882, 1.390892>, <-1.409159, -0.330882, 1.318823>, 
      <-1.177472, 0.308823, 1.268048>, <-1.177472, 0.116912, 1.268048>, <-1.194998, -0.153882, 1.340117>, <-1.177472, -0.330882, 1.268048>, 
      <-0.916698, 0.308823, 1.039473>, <-0.916698, 0.116912, 1.039473>, <-0.925430, -0.148506, 1.098571>, <-0.916698, -0.330882, 1.039473>, 
      <-0.681352, 0.308823, 1.010000>, <-0.681352, 0.116912, 1.010000>, <-0.690083, -0.148506, 1.069098>, <-0.681352, -0.330882, 1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.090511, 0.308823, 1.318823>, <-2.090511, 0.116912, 1.318823>, <-2.116381, -0.154762, 1.390534>, <-2.090511, -0.330882, 1.318823>, 
      <-1.891531, 0.308823, 1.365608>, <-1.891531, 0.116912, 1.365608>, <-1.917402, -0.154762, 1.437319>, <-1.891531, -0.330882, 1.365608>, 
      <-1.608826, 0.308823, 1.362581>, <-1.608826, 0.116912, 1.362581>, <-1.626352, -0.153882, 1.434650>, <-1.608826, -0.330882, 1.362581>, 
      <-1.409159, 0.308823, 1.318823>, <-1.409159, 0.116912, 1.318823>, <-1.426685, -0.153882, 1.390892>, <-1.409159, -0.330882, 1.318823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.722608, 0.308823, 1.010000>, <-2.722608, 0.116912, 1.010000>, <-2.756970, -0.151267, 1.068204>, <-2.722608, -0.330882, 1.010000>, 
      <-2.536899, 0.308823, 1.110275>, <-2.536899, 0.116912, 1.110275>, <-2.571261, -0.151267, 1.168478>, <-2.536899, -0.330882, 1.110275>, 
      <-2.295959, 0.308823, 1.270517>, <-2.295959, 0.116912, 1.270517>, <-2.321830, -0.154762, 1.342228>, <-2.295959, -0.330882, 1.270517>, 
      <-2.090511, 0.308823, 1.318823>, <-2.090511, 0.116912, 1.318823>, <-2.116381, -0.154762, 1.390534>, <-2.090511, -0.330882, 1.318823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.397802, 0.308823, 0.612942>, <-3.397802, 0.116912, 0.612942>, <-3.441407, -0.148247, 0.652605>, <-3.397802, -0.330882, 0.612942>, 
      <-3.181291, 0.308823, 0.704275>, <-3.181291, 0.116912, 0.704275>, <-3.224896, -0.148247, 0.743938>, <-3.181291, -0.330882, 0.704275>, 
      <-2.929378, 0.308823, 0.898353>, <-2.929378, 0.116912, 0.898353>, <-2.963740, -0.151267, 0.956557>, <-2.929378, -0.330882, 0.898353>, 
      <-2.722608, 0.308823, 1.010000>, <-2.722608, 0.116912, 1.010000>, <-2.756970, -0.151267, 1.068204>, <-2.722608, -0.330882, 1.010000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.029900, 0.308823, 0.458530>, <-4.029900, 0.116912, 0.458530>, <-4.081457, -0.148811, 0.490503>, <-4.029900, -0.330882, 0.458530>, 
      <-3.840271, 0.308823, 0.504853>, <-3.840271, 0.116912, 0.504853>, <-3.891827, -0.148811, 0.536827>, <-3.840271, -0.330882, 0.504853>, 
      <-3.577660, 0.308823, 0.537070>, <-3.577660, 0.116912, 0.537070>, <-3.621264, -0.148247, 0.576733>, <-3.577660, -0.330882, 0.537070>, 
      <-3.397802, 0.308823, 0.612942>, <-3.397802, 0.116912, 0.612942>, <-3.441407, -0.148247, 0.652605>, <-3.397802, -0.330882, 0.612942>
    }
  }
  photons {
    collect off
  }
}
#declare dosel = union {
  object { sPatchObj5 }
  object { sPatchObj6 }
  photons {
    collect off
  }
  scale <0.5, -0.5, -0.5>
  rotate <-180.0, 0.0, -180.0>
  translate  <1.970832, -12.431121, 0.401703>
}
#declare puerta = union {
  object { CSG062 }
  object { // CSG063 -> CSG062
    CSG062
    photons {
      collect off
    }
    translate  3.423702*x
  }
  object { dosel }
  material {
    Stone17
  }
  photons {
    collect off
  }
}
#declare puerta_habitacion_listones = union {
  object { Cube146 }
  object { // Cube147 -> Cube146
    Cube146
    photons {
      collect off
    }
    translate  <-0.42, 0.0, 0.0>
  }
  object { // Cube148 -> Cube146
    Cube146
    photons {
      collect off
    }
    translate  <-0.84, 0.0, 0.0>
  }
  object { // Cube149 -> Cube146
    Cube146
    photons {
      collect off
    }
    translate  <-1.26, 0.0, 0.0>
  }
  object { // Cube150 -> Cube146
    Cube146
    photons {
      collect off
    }
    translate  <-1.68, 0.0, 0.0>
  }
  object { // Cube151 -> Cube146
    Cube146
    photons {
      collect off
    }
    translate  <-2.1, 0.0, 0.0>
  }
  object { // Cube152 -> Cube146
    Cube146
    photons {
      collect off
    }
    translate  <-2.52, 0.0, 0.0>
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood33_2
    }
    photons {
      collect off
    }
    scale <1.42, 0.05, 0.2>
    rotate 0.0*z
    translate  <1.027381, -13.415927, -0.259999>
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood33_2
    }
    photons {
      collect off
    }
    scale <1.42, 0.05, 0.2>
    rotate 0.0*z
    translate  <1.027381, -13.415927, -2.482812>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    material {
      negro
    }
    photons {
      collect off
    }
    scale <1.45, 0.05, 2.4>
    rotate 0.0*z
    translate  <1.033263, -13.550081, -2.212615>
  }
  photons {
    collect off
  }
  rotate 50.0*z
  translate  <-8.587469, -5.747072, 0.0>
}
#declare libros = union {
  object { libro }
  object { libro1 }
  object { // libro2 -> libro
    libro
    photons {
      collect off
    }
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.234147, -0.0, -0.0>
  }
  object { // libro3 -> libro1
    libro1
    photons {
      collect off
    }
    rotate <0.0, 90.0, 0.0>
    translate  <0.956806, 0.539181, -4.251781>
  }
  object { // libro4 -> libro1
    libro1
    photons {
      collect off
    }
    rotate <0.0, 90.0, 0.0>
    translate  <0.956806, 0.005528, -3.621642>
  }
  object { // libro5 -> libro1
    libro1
    photons {
      collect off
    }
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.22019, -0.0, -0.0>
  }
  photons {
    collect off
  }
}
#declare RndCube002 = merge {
  sphere { <7.4000, 14.9000, 0.4000>, 0.1000 }
  sphere { <7.4000, -14.9000, 0.4000>, 0.1000 }
  sphere { <-7.4000, -14.9000, 0.4000>, 0.1000 }
  sphere { <-7.4000, 14.9000, 0.4000>, 0.1000 }
  sphere { <7.4000, 14.9000, -0.4000>, 0.1000 }
  sphere { <7.4000, -14.9000, -0.4000>, 0.1000 }
  sphere { <-7.4000, -14.9000, -0.4000>, 0.1000 }
  sphere { <-7.4000, 14.9000, -0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, 0.4000>, <-7.4000, 14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, -14.9000, 0.4000>, <-7.4000, -14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, -14.9000, -0.4000>, <-7.4000, -14.9000, -0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, -0.4000>, <-7.4000, 14.9000, -0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, -0.4000>, <7.4000, 14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, -14.9000, -0.4000>, <7.4000, -14.9000, 0.4000>, 0.1000 }
  cylinder { <-7.4000, -14.9000, -0.4000>, <-7.4000, -14.9000, 0.4000>, 0.1000 }
  cylinder { <-7.4000, 14.9000, -0.4000>, <-7.4000, 14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, 0.4000>, <7.4000, -14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, -0.4000>, <7.4000, -14.9000, -0.4000>, 0.1000 }
  cylinder { <-7.4000, 14.9000, -0.4000>, <-7.4000, -14.9000, -0.4000>, 0.1000 }
  cylinder { <-7.4000, 14.9000, 0.4000>, <-7.4000, -14.9000, 0.4000>, 0.1000 }
  box { <-7.4000, -14.9000, -0.5000> <7.4000, 14.9000, 0.5000> }
  box { <-7.4000, -15.0000, -0.4000> <7.4000, 15.0000, 0.4000> }
  box { <-7.5000, -14.9000, -0.4000> <7.5000, 14.9000, 0.4000> }
  photons {
    collect off
  }
}
#declare mesa1 = union {
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <5.0, 0.25, 1.0>
    translate  <0.0, 13.5, -1.5>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.25, 13.5, 2.5>
    translate  <-6.0, 0.0, -3.0>
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.0, 0.5, 7.0>
    translate  <-5.5, 13.5, -7.0>
  }
  object { RndCube002 }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.0, 0.5, 7.0>
    translate  <5.5, 13.5, -7.0>
  }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.0, 0.5, 7.0>
    translate  <5.5, -13.5, -7.0>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.0, 0.5, 7.0>
    translate  <-5.5, -13.5, -7.0>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.25, 13.5, 2.5>
    translate  <6.0, 0.0, -3.0>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <5.0, 0.25, 1.0>
    translate  <0.0, -13.5, -1.5>
  }
  material {
    T_Wood3
  }
  photons {
    collect off
  }
  scale 0.12
  rotate -90.0*z
  translate  <-3.016538, -21.45871, -2.895829>
}
union { // habitacion
  object { leo_cuarto }
  object { puerta }
  object { puerta_habitacion_listones }
  object { libros }
  object { mesa1 }
  photons {
    collect off
  }
}

object {   // dirt
  height_field {
    jpeg "leo_dirt hf.jpg"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    leo_dirt_txt
  }
  photons {
    collect off
  }
  scale <0.4, 0.4, 0.1>
  translate  <4.369212, 4.215969, -4.529169>
}


box { // escatering
  <-1, -1, -1>, <1, 1, 1>
  material {
    mediascatering_txt
  }
  hollow
  photons {
    collect off
  }
  scale 30.0
  translate  5.029664*y
}


disc { // hierba
  <0,0,0>, <0,0,1>, 1.0
  material {
    verde
  }
  photons {
    collect off
  }
  scale <150.0, 150.0, 1.0>
  translate  -4.853514*z
}




#declare pared_frontal = difference {
  box { // pared_fronta_base
    <-1, -1, -1>, <1, 1, 1>
    material {
      leoparedfront_txt
      scale <1.2, 1.0, 0.65>
      translate <0.230682, -0.000000, -0.350070>
    }
    photons {
      collect off
    }
    scale <24.0, 0.2, 12.0>
    rotate 180.0*z
    translate  <-17.694427, -50.220685, 7.379934>
  }
  box { // pared_fronta_resta
    <-1, -1, -1>, <1, 1, 1>
    material {
      leoparedfront_txt
    }
    photons {
      collect off
    }
    scale <2.5, 0.5, 4.25>
    rotate 180.0*z
    translate  <-8.514645, -50.220685, -0.470669>
  }
  photons {
    collect off
  }
}
#declare suelo_piedra = union {
  object { sueloHF01 }
  object { // sueloHF02 -> sueloHF01
    sueloHF01
    photons {
      collect off
    }
    scale <-1.0, 1.0, 1.0>
    rotate -0.0*x
    translate  -57.831598*x
  }
  object { // sueloHF03 -> sueloHF01
    sueloHF01
    photons {
      collect off
    }
    scale <-1.0, -1.0, 1.0>
    rotate -0.0*x
    translate  <-57.831599, -69.000121, 0.0>
  }
  object { // sueloHF04 -> sueloHF01
    sueloHF01
    photons {
      collect off
    }
    scale <1.0, -1.0, 1.0>
    rotate -0.0*x
    translate  <-0.000005, -69.000112, 0.0>
  }
  photons {
    collect off
  }
  scale <1.5, 1.5, 1.0>
  translate  <26.643, 24.759134, 0.0>
}
#declare pared_otra = difference {
  box { // pared_otra_base
    <-1, -1, -1>, <1, 1, 1>
    material {
      leoparedotra_txt
      scale <0.4, 1.0, 1.0>
    }
    photons {
      collect off
    }
    scale <18.0, 0.12, 7.2>
    rotate <-0.0, -0.0, -90.0>
    translate  <-16.870403, 1.065868, 2.546684>
  }
  object { ventana }
  object { // ventana1 -> ventana
    ventana
    photons {
      collect off
    }
    translate  <0.0, 2.4, 0.0>
  }
  object { // ventana2 -> ventana
    ventana
    photons {
      collect off
    }
    translate  <0.0, 4.8, 0.0>
  }
  material {
    leoparedotra_txt
  }
  photons {
    collect off
  }
  scale <6.0, 1.666667, 1.666667>
  rotate <0.0, -0.0, -0.0>
  translate  <60.60143, -23.479646, 3.029781>
}
#declare rejas_ventana = union {
  object { rejas04 }
  object { // rejas05 -> rejas04
    rejas04
    photons {
      collect off
    }
    translate  2.37*y
  }
  object { // rejas06 -> rejas04
    rejas04
    photons {
      collect off
    }
    translate  -2.4175*y
  }
  photons {
    collect off
  }
  scale 1.666667
  rotate <-0.0, 0.0, -0.0>
  translate  <-11.837728, -29.375102, 3.029781>
}
#declare pared_atras_base = difference {
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <20.0, 0.2, 12.0>
    translate  <-0.22489, 18.057625, 7.422902>
  }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <4.0, 0.4, 3.5>
    translate  <1.514233, 18.057625, -1.000039>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <4.0, 1.0, 0.8>
    rotate -90.0*x
    translate  <1.510822, 17.658541, 2.522384>
  }
  material {
    blanco
  }
  photons {
    collect off
  }
}
#declare pared_atras = union {
  object { pared_atras_base }
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    material {
      marron
    }
    photons {
      collect off
    }
    scale <2.0, 0.1, 4.0>
    rotate -90.0*z
    translate  <-2.365264, 16.245772, -0.566868>
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    material {
      marron
    }
    photons {
      collect off
    }
    scale <2.0, 0.1, 4.0>
    rotate -90.0*z
    translate  <5.39373, 16.032613, -0.566868>
  }
  photons {
    collect off
  }
  scale 1.666667
  rotate <-0.0, 0.0, -0.0>
  translate  <-11.837728, -23.056337, 3.029781>
}
#declare zocalo = union {
  object { zocalo01 }
  object { // TransSweep002 -> zocalo01
    zocalo01
    photons {
      collect off
    }
    rotate <-0.0, 0.0, 0.0>
    translate  -4.031893*x
  }
  object { // TransSweep003 -> zocalo01
    zocalo01
    photons {
      collect off
    }
    rotate <-0.0, 0.0, 0.0>
    translate  -8.053117*x
  }
  object { // TransSweep006 -> zocalo01
    zocalo01
    photons {
      collect off
    }
    rotate <-0.0, 0.0, 0.0>
    translate  7.994573*x
  }
  object { // TransSweep005 -> zocalo01
    zocalo01
    photons {
      collect off
    }
    rotate <-0.0, 0.0, 0.0>
    translate  -16.098661*x
  }
  object { // TransSweep004 -> zocalo01
    zocalo01
    photons {
      collect off
    }
    rotate <-0.0, 0.0, 0.0>
    translate  -12.072842*x
  }
  object { // TransSweep009 -> zocalo01
    zocalo01
    photons {
      collect off
    }
    rotate <-0.0, 0.0, -90.0>
    translate  <-4.377247, -8.626922, 0.0>
  }
  object { // TransSweep008 -> zocalo01
    zocalo01
    photons {
      collect off
    }
    rotate <-0.0, 0.0, -90.0>
    translate  <-4.380948, -12.648328, 0.0>
  }
  object { // TransSweep007 -> zocalo01
    zocalo01
    photons {
      collect off
    }
    rotate <-0.0, 0.0, 0.0>
    translate  12.010112*x
  }
  object { // TransSweep010 -> zocalo01
    zocalo01
    photons {
      collect off
    }
    rotate <-0.0, 0.0, -90.0>
    translate  <-4.383415, -4.600581, 0.0>
  }
  material {
    RoughStone
    scale 0.1
  }
  photons {
    collect off
  }
  scale 1.666667
  rotate <-0.0, 0.0, -0.0>
  translate  <-11.837728, -29.375102, 3.029781>
}
union { // taller
  object { pared_frontal }
  object { suelo_piedra }
  box { // suelo
    <-1, -1, -1>, <1, 1, 1>
    material {
      marron
    }
    photons {
      collect off
    }
    scale <31.0, 31.0, 0.01>
    translate  <-13.879969, -19.413342, -4.610952>
  }
  object { pared_otra }
  box { // pared_izq
    <-1, -1, -1>, <1, 1, 1>
    material {
      leoparedotra_txt
      scale <0.4, 1.0, 1.0>
    }
    photons {
      collect off
    }
    scale <29.999998, 0.2, 12.0>
    rotate <-0.0, -0.0, -90.0>
    translate  <7.561668, -21.825595, 7.274254>
  }
  box { // techo
    <-1, -1, -1>, <1, 1, 1>
    material {
      leoparedotra_txt
      scale <0.4, 1.0, 0.4>
    }
    photons {
      collect off
    }
    scale <29.999998, 0.2, 29.999998>
    rotate <-90.0, 0.0, -0.0>
    translate  <-11.311801, -22.713758, 18.979089>
  }
  object { rejas_ventana }
  object { pared_atras }
  object { zocalo }
  photons {
    collect off
  }
  scale 0.6
  translate  <7.102637, 17.625062, -1.817869>
}


#declare RndCube001 = merge {
  sphere { <7.4000, 14.9000, 0.4000>, 0.1000 }
  sphere { <7.4000, -14.9000, 0.4000>, 0.1000 }
  sphere { <-7.4000, -14.9000, 0.4000>, 0.1000 }
  sphere { <-7.4000, 14.9000, 0.4000>, 0.1000 }
  sphere { <7.4000, 14.9000, -0.4000>, 0.1000 }
  sphere { <7.4000, -14.9000, -0.4000>, 0.1000 }
  sphere { <-7.4000, -14.9000, -0.4000>, 0.1000 }
  sphere { <-7.4000, 14.9000, -0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, 0.4000>, <-7.4000, 14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, -14.9000, 0.4000>, <-7.4000, -14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, -14.9000, -0.4000>, <-7.4000, -14.9000, -0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, -0.4000>, <-7.4000, 14.9000, -0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, -0.4000>, <7.4000, 14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, -14.9000, -0.4000>, <7.4000, -14.9000, 0.4000>, 0.1000 }
  cylinder { <-7.4000, -14.9000, -0.4000>, <-7.4000, -14.9000, 0.4000>, 0.1000 }
  cylinder { <-7.4000, 14.9000, -0.4000>, <-7.4000, 14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, 0.4000>, <7.4000, -14.9000, 0.4000>, 0.1000 }
  cylinder { <7.4000, 14.9000, -0.4000>, <7.4000, -14.9000, -0.4000>, 0.1000 }
  cylinder { <-7.4000, 14.9000, -0.4000>, <-7.4000, -14.9000, -0.4000>, 0.1000 }
  cylinder { <-7.4000, 14.9000, 0.4000>, <-7.4000, -14.9000, 0.4000>, 0.1000 }
  box { <-7.4000, -14.9000, -0.5000> <7.4000, 14.9000, 0.5000> }
  box { <-7.4000, -15.0000, -0.4000> <7.4000, 15.0000, 0.4000> }
  box { <-7.5000, -14.9000, -0.4000> <7.5000, 14.9000, 0.4000> }
  photons {
    collect off
  }
}
#declare mesa = union {
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <5.0, 0.25, 1.0>
    translate  <0.0, 13.5, -1.5>
  }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.25, 13.5, 2.5>
    translate  <-6.0, 0.0, -3.0>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.0, 0.5, 7.0>
    translate  <-5.5, 13.5, -7.0>
  }
  object { RndCube001 }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.0, 0.5, 7.0>
    translate  <5.5, 13.5, -7.0>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.0, 0.5, 7.0>
    translate  <5.5, -13.5, -7.0>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.0, 0.5, 7.0>
    translate  <-5.5, -13.5, -7.0>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.25, 13.5, 2.5>
    translate  <6.0, 0.0, -3.0>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <5.0, 0.25, 1.0>
    translate  <0.0, -13.5, -1.5>
  }
  material {
    T_Wood3
    scale <0.7, 4.0, 1.0>
  }
  photons {
    collect off
  }
  scale 0.12
  rotate -90.0*z
  translate  <-20.106782, -14.720869, -2.895829>
}
#declare cuerdas = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.054541, 0.043199, 1.706972>, <-0.053222, 0.046977, 1.707316>, <-0.055103, 0.051252, 1.706589>, <-0.058681, 0.052611, 1.705373>, 
      <-0.039630, 0.074530, 1.684956>, <-0.038311, 0.078308, 1.685299>, <-0.039721, 0.082729, 1.683611>, <-0.043299, 0.084089, 1.682395>, 
      <-0.015991, 0.121982, 1.600624>, <-0.013282, 0.126329, 1.598739>, <-0.015537, 0.132039, 1.597125>, <-0.020256, 0.134321, 1.595604>, 
      <0.006057, 0.149198, 1.557123>, <0.008766, 0.153544, 1.555238>, <0.007094, 0.159061, 1.552404>, <0.002375, 0.161342, 1.550882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.073458, -0.043426, 1.708057>, <-0.072307, -0.039665, 1.708872>, <-0.074326, -0.035405, 1.708539>, <-0.077904, -0.034046, 1.707323>, 
      <-0.085352, -0.021324, 1.699241>, <-0.084200, -0.017564, 1.700056>, <-0.086965, -0.013435, 1.700354>, <-0.090543, -0.012075, 1.699138>, 
      <-0.064193, 0.022917, 1.721225>, <-0.062875, 0.026695, 1.721568>, <-0.064881, 0.031241, 1.721197>, <-0.068459, 0.032600, 1.719981>, 
      <-0.054541, 0.043199, 1.706972>, <-0.053222, 0.046977, 1.707316>, <-0.055103, 0.051252, 1.706589>, <-0.058681, 0.052611, 1.705373>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.008238, -0.073463, 1.753507>, <0.007159, -0.069739, 1.754554>, <0.007272, -0.065509, 1.752449>, <0.008488, -0.064150, 1.748871>, 
      <-0.019765, -0.073589, 1.744362>, <-0.020844, -0.069865, 1.745410>, <-0.021756, -0.065350, 1.744327>, <-0.020540, -0.063991, 1.740749>, 
      <-0.060287, -0.067901, 1.717820>, <-0.059136, -0.064140, 1.718635>, <-0.060022, -0.060270, 1.717801>, <-0.063600, -0.058911, 1.716586>, 
      <-0.073458, -0.043426, 1.708057>, <-0.072307, -0.039665, 1.708872>, <-0.074326, -0.035405, 1.708539>, <-0.077904, -0.034046, 1.707323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.065723, -0.042799, 1.753507>, <0.066650, -0.039035, 1.754554>, <0.068863, -0.035429, 1.752449>, <0.070596, -0.034860, 1.748871>, 
      <0.059993, -0.061486, 1.753507>, <0.060920, -0.057722, 1.754554>, <0.061601, -0.054707, 1.752449>, <0.063334, -0.054137, 1.748871>, 
      <0.026818, -0.073379, 1.759574>, <0.025739, -0.069655, 1.760621>, <0.027111, -0.065618, 1.757999>, <0.028327, -0.064259, 1.754421>, 
      <0.008238, -0.073463, 1.753507>, <0.007159, -0.069739, 1.754554>, <0.007272, -0.065509, 1.752449>, <0.008488, -0.064150, 1.748871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051019, 0.066052, 1.753507>, <0.053704, 0.068848, 1.754554>, <0.057424, 0.070865, 1.752449>, <0.059209, 0.070491, 1.748871>, 
      <0.076538, 0.048371, 1.764554>, <0.079223, 0.051168, 1.765602>, <0.082042, 0.053808, 1.763106>, <0.083827, 0.053435, 1.759528>, 
      <0.075383, -0.011295, 1.753507>, <0.076310, -0.007531, 1.754554>, <0.080070, -0.005680, 1.752449>, <0.081803, -0.005111, 1.748871>, 
      <0.065723, -0.042799, 1.753507>, <0.066650, -0.039035, 1.754554>, <0.068863, -0.035429, 1.752449>, <0.070596, -0.034860, 1.748871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.073601, 0.053730, 1.693189>, <-0.072675, 0.057495, 1.694236>, <-0.070461, 0.061101, 1.692131>, <-0.068729, 0.061670, 1.688552>, 
      <-0.043512, 0.080756, 1.703340>, <-0.042585, 0.084521, 1.704388>, <-0.038338, 0.087023, 1.702314>, <-0.036606, 0.087592, 1.698736>, 
      <0.018727, 0.088425, 1.739526>, <0.021412, 0.091222, 1.740574>, <0.024500, 0.093676, 1.738194>, <0.026285, 0.093303, 1.734616>, 
      <0.051019, 0.066052, 1.753507>, <0.053704, 0.068848, 1.754554>, <0.057424, 0.070865, 1.752449>, <0.059209, 0.070491, 1.748871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.072655, -0.045031, 1.711781>, <-0.073734, -0.041307, 1.712829>, <-0.073621, -0.037078, 1.710723>, <-0.072405, -0.035719, 1.707145>, 
      <-0.072939, -0.015403, 1.706203>, <-0.074018, -0.011679, 1.707251>, <-0.072518, -0.007861, 1.705145>, <-0.071302, -0.006502, 1.701567>, 
      <-0.095357, 0.034189, 1.685849>, <-0.094430, 0.037954, 1.686896>, <-0.092950, 0.042953, 1.685001>, <-0.091217, 0.043522, 1.681423>, 
      <-0.073601, 0.053730, 1.693189>, <-0.072675, 0.057495, 1.694236>, <-0.070461, 0.061101, 1.692131>, <-0.068729, 0.061670, 1.688552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.058681, 0.052611, 1.705373>, <-0.062259, 0.053970, 1.704157>, <-0.066333, 0.051958, 1.702860>, <-0.067652, 0.048180, 1.702516>, 
      <-0.043299, 0.084089, 1.682395>, <-0.046877, 0.085448, 1.681179>, <-0.051357, 0.083500, 1.680935>, <-0.052675, 0.079722, 1.680591>, 
      <-0.020256, 0.134321, 1.595604>, <-0.024975, 0.136603, 1.594082>, <-0.030731, 0.134213, 1.593020>, <-0.033441, 0.129866, 1.594904>, 
      <0.002375, 0.161342, 1.550882>, <-0.002344, 0.163624, 1.549361>, <-0.008525, 0.161906, 1.549662>, <-0.011235, 0.157559, 1.551547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.077904, -0.034046, 1.707323>, <-0.081482, -0.032687, 1.706107>, <-0.085418, -0.034685, 1.704416>, <-0.086569, -0.038445, 1.703601>, 
      <-0.090543, -0.012075, 1.699138>, <-0.094121, -0.010716, 1.697922>, <-0.099994, -0.013520, 1.697544>, <-0.101146, -0.017280, 1.696729>, 
      <-0.068459, 0.032600, 1.719981>, <-0.072037, 0.033959, 1.718765>, <-0.075997, 0.031606, 1.717006>, <-0.077315, 0.027828, 1.716662>, 
      <-0.058681, 0.052611, 1.705373>, <-0.062259, 0.053970, 1.704157>, <-0.066333, 0.051958, 1.702860>, <-0.067652, 0.048180, 1.702516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.008488, -0.064150, 1.748871>, <0.009705, -0.062791, 1.745293>, <0.011615, -0.064759, 1.741443>, <0.012694, -0.068482, 1.740395>, 
      <-0.020540, -0.063991, 1.740749>, <-0.019324, -0.062632, 1.737171>, <-0.020541, -0.064299, 1.733985>, <-0.019462, -0.068022, 1.732937>, 
      <-0.063600, -0.058911, 1.716586>, <-0.067178, -0.057552, 1.715370>, <-0.067329, -0.060951, 1.712944>, <-0.068480, -0.064711, 1.712129>, 
      <-0.077904, -0.034046, 1.707323>, <-0.081482, -0.032687, 1.706107>, <-0.085418, -0.034685, 1.704416>, <-0.086569, -0.038445, 1.703601>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.070596, -0.034860, 1.748871>, <0.072329, -0.034291, 1.745293>, <0.072999, -0.036950, 1.741443>, <0.072072, -0.040714, 1.740395>, 
      <0.063334, -0.054137, 1.748871>, <0.065067, -0.053568, 1.745293>, <0.066720, -0.055585, 1.741443>, <0.065793, -0.059350, 1.740395>, 
      <0.028327, -0.064259, 1.754421>, <0.029543, -0.062900, 1.750843>, <0.030769, -0.065033, 1.745886>, <0.031849, -0.068756, 1.744838>, 
      <0.008488, -0.064150, 1.748871>, <0.009705, -0.062791, 1.745293>, <0.011615, -0.064759, 1.741443>, <0.012694, -0.068482, 1.740395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.059209, 0.070491, 1.748871>, <0.060994, 0.070118, 1.745293>, <0.060245, 0.067480, 1.741443>, <0.057560, 0.064683, 1.740395>, 
      <0.083827, 0.053435, 1.759528>, <0.085612, 0.053061, 1.755950>, <0.084963, 0.050354, 1.752144>, <0.082278, 0.047558, 1.751096>, 
      <0.081803, -0.005111, 1.748871>, <0.083535, -0.004542, 1.745293>, <0.083190, -0.006703, 1.741443>, <0.082263, -0.010467, 1.740395>, 
      <0.070596, -0.034860, 1.748871>, <0.072329, -0.034291, 1.745293>, <0.072999, -0.036950, 1.741443>, <0.072072, -0.040714, 1.740395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.068729, 0.061670, 1.688552>, <-0.066996, 0.062239, 1.684974>, <-0.066326, 0.059580, 1.681125>, <-0.067252, 0.055815, 1.680077>, 
      <-0.036606, 0.087592, 1.698736>, <-0.034873, 0.088162, 1.695158>, <-0.035296, 0.085421, 1.691420>, <-0.036223, 0.081657, 1.690373>, 
      <0.026285, 0.093303, 1.734616>, <0.028070, 0.092929, 1.731038>, <0.027974, 0.089838, 1.727472>, <0.025289, 0.087042, 1.726424>, 
      <0.059209, 0.070491, 1.748871>, <0.060994, 0.070118, 1.745293>, <0.060245, 0.067480, 1.741443>, <0.057560, 0.064683, 1.740395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.072405, -0.035719, 1.707145>, <-0.071189, -0.034359, 1.703567>, <-0.069279, -0.036327, 1.699718>, <-0.068199, -0.040051, 1.698670>, 
      <-0.071302, -0.006502, 1.701567>, <-0.070086, -0.005143, 1.697989>, <-0.068995, -0.007567, 1.694140>, <-0.067915, -0.011291, 1.693092>, 
      <-0.091217, 0.043522, 1.681423>, <-0.089485, 0.044091, 1.677845>, <-0.088140, 0.041412, 1.673887>, <-0.089067, 0.037648, 1.672840>, 
      <-0.068729, 0.061670, 1.688552>, <-0.066996, 0.062239, 1.684974>, <-0.066326, 0.059580, 1.681125>, <-0.067252, 0.055815, 1.680077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.067652, 0.048180, 1.702516>, <-0.068970, 0.044402, 1.702173>, <-0.067090, 0.040127, 1.702899>, <-0.063512, 0.038768, 1.704115>, 
      <-0.052675, 0.079722, 1.680591>, <-0.053994, 0.075944, 1.680248>, <-0.052582, 0.071513, 1.681926>, <-0.049004, 0.070154, 1.683142>, 
      <-0.033441, 0.129866, 1.594904>, <-0.036150, 0.125519, 1.596788>, <-0.033895, 0.119809, 1.598403>, <-0.029176, 0.117527, 1.599924>, 
      <-0.011235, 0.157559, 1.551547>, <-0.013945, 0.153212, 1.553431>, <-0.012273, 0.147696, 1.556266>, <-0.007554, 0.145414, 1.557787>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.086569, -0.038445, 1.703601>, <-0.087720, -0.042205, 1.702786>, <-0.085701, -0.046465, 1.703119>, <-0.082123, -0.047824, 1.704335>, 
      <-0.101146, -0.017280, 1.696729>, <-0.102297, -0.021040, 1.695914>, <-0.099618, -0.025108, 1.695623>, <-0.096040, -0.026467, 1.696838>, 
      <-0.077315, 0.027828, 1.716662>, <-0.078633, 0.024051, 1.716319>, <-0.076622, 0.019505, 1.716679>, <-0.073044, 0.018146, 1.717895>, 
      <-0.067652, 0.048180, 1.702516>, <-0.068970, 0.044402, 1.702173>, <-0.067090, 0.040127, 1.702899>, <-0.063512, 0.038768, 1.704115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012694, -0.068482, 1.740395>, <0.013774, -0.072206, 1.739348>, <0.013660, -0.076436, 1.741454>, <0.012444, -0.077795, 1.745032>, 
      <-0.019462, -0.068022, 1.732937>, <-0.018382, -0.071746, 1.731890>, <-0.017375, -0.076263, 1.732995>, <-0.018591, -0.077622, 1.736573>, 
      <-0.068480, -0.064711, 1.712129>, <-0.069631, -0.068471, 1.711314>, <-0.068852, -0.072321, 1.712195>, <-0.065274, -0.073680, 1.713411>, 
      <-0.086569, -0.038445, 1.703601>, <-0.087720, -0.042205, 1.702786>, <-0.085701, -0.046465, 1.703119>, <-0.082123, -0.047824, 1.704335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.072072, -0.040714, 1.740395>, <0.071145, -0.044479, 1.739348>, <0.068932, -0.048085, 1.741454>, <0.067199, -0.048654, 1.745032>, 
      <0.065793, -0.059350, 1.740395>, <0.064866, -0.063114, 1.739348>, <0.064123, -0.066061, 1.741454>, <0.062391, -0.066630, 1.745032>, 
      <0.031849, -0.068756, 1.744838>, <0.032928, -0.072480, 1.743790>, <0.031613, -0.076536, 1.746346>, <0.030397, -0.077895, 1.749925>, 
      <0.012694, -0.068482, 1.740395>, <0.013774, -0.072206, 1.739348>, <0.013660, -0.076436, 1.741454>, <0.012444, -0.077795, 1.745032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.057560, 0.064683, 1.740395>, <0.054875, 0.061886, 1.739348>, <0.051156, 0.059870, 1.741454>, <0.049370, 0.060243, 1.745032>, 
      <0.082278, 0.047558, 1.751096>, <0.079593, 0.044761, 1.750049>, <0.076792, 0.042108, 1.752552>, <0.075007, 0.042481, 1.756130>, 
      <0.082263, -0.010467, 1.740395>, <0.081336, -0.014232, 1.739348>, <0.077487, -0.016105, 1.741454>, <0.075754, -0.016675, 1.745032>, 
      <0.072072, -0.040714, 1.740395>, <0.071145, -0.044479, 1.739348>, <0.068932, -0.048085, 1.741454>, <0.067199, -0.048654, 1.745032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.067252, 0.055815, 1.680077>, <-0.068179, 0.052051, 1.679030>, <-0.070393, 0.048444, 1.681136>, <-0.072125, 0.047875, 1.684714>, 
      <-0.036223, 0.081657, 1.690373>, <-0.037150, 0.077892, 1.689325>, <-0.041432, 0.075386, 1.691392>, <-0.043165, 0.074817, 1.694970>, 
      <0.025289, 0.087042, 1.726424>, <0.022604, 0.084245, 1.725376>, <0.019511, 0.081794, 1.727754>, <0.017726, 0.082167, 1.731332>, 
      <0.057560, 0.064683, 1.740395>, <0.054875, 0.061886, 1.739348>, <0.051156, 0.059870, 1.741454>, <0.049370, 0.060243, 1.745032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.068199, -0.040051, 1.698670>, <-0.067120, -0.043774, 1.697622>, <-0.067233, -0.048004, 1.699728>, <-0.068449, -0.049363, 1.703306>, 
      <-0.067915, -0.011291, 1.693092>, <-0.066836, -0.015014, 1.692044>, <-0.068336, -0.018833, 1.694150>, <-0.069552, -0.020192, 1.697728>, 
      <-0.089067, 0.037648, 1.672840>, <-0.089994, 0.033883, 1.671792>, <-0.091456, 0.028849, 1.673676>, <-0.093189, 0.028280, 1.677254>, 
      <-0.067252, 0.055815, 1.680077>, <-0.068179, 0.052051, 1.679030>, <-0.070393, 0.048444, 1.681136>, <-0.072125, 0.047875, 1.684714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.063512, 0.038768, 1.704115>, <-0.059934, 0.037409, 1.705331>, <-0.055859, 0.039421, 1.706629>, <-0.054541, 0.043199, 1.706972>, 
      <-0.049004, 0.070154, 1.683142>, <-0.045426, 0.068795, 1.684358>, <-0.040948, 0.070752, 1.684612>, <-0.039630, 0.074530, 1.684956>, 
      <-0.029176, 0.117527, 1.599924>, <-0.024457, 0.115245, 1.601446>, <-0.018701, 0.117635, 1.602508>, <-0.015991, 0.121982, 1.600624>, 
      <-0.007554, 0.145414, 1.557787>, <-0.002835, 0.143132, 1.559309>, <0.003347, 0.144850, 1.559007>, <0.006057, 0.149198, 1.557123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.082123, -0.047824, 1.704335>, <-0.078545, -0.049184, 1.705551>, <-0.074609, -0.047186, 1.707242>, <-0.073458, -0.043426, 1.708057>, 
      <-0.096040, -0.026467, 1.696838>, <-0.092462, -0.027826, 1.698055>, <-0.086503, -0.025084, 1.698426>, <-0.085352, -0.021324, 1.699241>, 
      <-0.073044, 0.018146, 1.717895>, <-0.069466, 0.016787, 1.719111>, <-0.065512, 0.019139, 1.720881>, <-0.064193, 0.022917, 1.721225>, 
      <-0.063512, 0.038768, 1.704115>, <-0.059934, 0.037409, 1.705331>, <-0.055859, 0.039421, 1.706629>, <-0.054541, 0.043199, 1.706972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012444, -0.077795, 1.745032>, <0.011228, -0.079154, 1.748610>, <0.009318, -0.077186, 1.752459>, <0.008238, -0.073463, 1.753507>, 
      <-0.018591, -0.077622, 1.736573>, <-0.019807, -0.078982, 1.740151>, <-0.018685, -0.077312, 1.743315>, <-0.019765, -0.073589, 1.744362>, 
      <-0.065274, -0.073680, 1.713411>, <-0.061697, -0.075039, 1.714627>, <-0.061439, -0.071661, 1.717004>, <-0.060287, -0.067901, 1.717820>, 
      <-0.082123, -0.047824, 1.704335>, <-0.078545, -0.049184, 1.705551>, <-0.074609, -0.047186, 1.707242>, <-0.073458, -0.043426, 1.708057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.067199, -0.048654, 1.745032>, <0.065467, -0.049223, 1.748610>, <0.064796, -0.046564, 1.752459>, <0.065723, -0.042799, 1.753507>, 
      <0.062391, -0.066630, 1.745032>, <0.060658, -0.067199, 1.748610>, <0.059066, -0.065251, 1.752459>, <0.059993, -0.061486, 1.753507>, 
      <0.030397, -0.077895, 1.749925>, <0.029181, -0.079254, 1.753503>, <0.027898, -0.077103, 1.758526>, <0.026818, -0.073379, 1.759574>, 
      <0.012444, -0.077795, 1.745032>, <0.011228, -0.079154, 1.748610>, <0.009318, -0.077186, 1.752459>, <0.008238, -0.073463, 1.753507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.049370, 0.060243, 1.745032>, <0.047585, 0.060617, 1.748610>, <0.048334, 0.063255, 1.752459>, <0.051019, 0.066052, 1.753507>, 
      <0.075007, 0.042481, 1.756130>, <0.073222, 0.042855, 1.759709>, <0.073853, 0.045575, 1.763507>, <0.076538, 0.048371, 1.764554>, 
      <0.075754, -0.016675, 1.745032>, <0.074022, -0.017244, 1.748610>, <0.074457, -0.015060, 1.752459>, <0.075383, -0.011295, 1.753507>, 
      <0.067199, -0.048654, 1.745032>, <0.065467, -0.049223, 1.748610>, <0.064796, -0.046564, 1.752459>, <0.065723, -0.042799, 1.753507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.072125, 0.047875, 1.684714>, <-0.073858, 0.047306, 1.688292>, <-0.074528, 0.049966, 1.692141>, <-0.073601, 0.053730, 1.693189>, 
      <-0.043165, 0.074817, 1.694970>, <-0.044898, 0.074248, 1.698548>, <-0.044439, 0.076992, 1.702293>, <-0.043512, 0.080756, 1.703340>, 
      <0.017726, 0.082167, 1.731332>, <0.015941, 0.082541, 1.734910>, <0.016042, 0.085628, 1.738479>, <0.018727, 0.088425, 1.739526>, 
      <0.049370, 0.060243, 1.745032>, <0.047585, 0.060617, 1.748610>, <0.048334, 0.063255, 1.752459>, <0.051019, 0.066052, 1.753507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.068449, -0.049363, 1.703306>, <-0.069665, -0.050722, 1.706884>, <-0.071575, -0.048755, 1.710733>, <-0.072655, -0.045031, 1.711781>, 
      <-0.069552, -0.020192, 1.697728>, <-0.070768, -0.021551, 1.701306>, <-0.071859, -0.019126, 1.705156>, <-0.072939, -0.015403, 1.706203>, 
      <-0.093189, 0.028280, 1.677254>, <-0.094922, 0.027711, 1.680832>, <-0.096284, 0.030425, 1.684801>, <-0.095357, 0.034189, 1.685849>, 
      <-0.072125, 0.047875, 1.684714>, <-0.073858, 0.047306, 1.688292>, <-0.074528, 0.049966, 1.692141>, <-0.073601, 0.053730, 1.693189>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.602589, 0.685500, 0.218595>, <0.605192, 0.689821, 0.216512>, <0.603430, 0.695693, 0.214592>, <0.598712, 0.698426, 0.214367>, 
      <0.581115, 0.628089, 0.077193>, <0.583717, 0.632410, 0.075111>, <0.581959, 0.638287, 0.073204>, <0.577240, 0.641020, 0.072980>, 
      <0.558570, 0.546204, -0.109997>, <0.561177, 0.550535, -0.112055>, <0.559417, 0.556409, -0.113968>, <0.554698, 0.559142, -0.114193>, 
      <0.539705, 0.486506, -0.250822>, <0.542311, 0.490837, -0.252880>, <0.540554, 0.496716, -0.254780>, <0.535835, 0.499449, -0.255004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667431, 0.827980, 0.590215>, <0.670029, 0.832293, 0.588108>, <0.668265, 0.838156, 0.586167>, <0.663546, 0.840890, 0.585943>, 
      <0.654099, 0.803361, 0.472525>, <0.656698, 0.807674, 0.470419>, <0.654980, 0.813573, 0.468480>, <0.650261, 0.816307, 0.468256>, 
      <0.619445, 0.730565, 0.329588>, <0.622048, 0.734887, 0.327506>, <0.620285, 0.740753, 0.325572>, <0.615566, 0.743486, 0.325348>, 
      <0.602589, 0.685500, 0.218595>, <0.605192, 0.689821, 0.216512>, <0.603430, 0.695693, 0.214592>, <0.598712, 0.698426, 0.214367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.696787, 0.859457, 1.050174>, <0.699497, 0.864173, 1.050634>, <0.697825, 0.870371, 1.050829>, <0.693106, 0.873105, 1.050604>, 
      <0.687980, 0.850014, 0.912186>, <0.690690, 0.854730, 0.912646>, <0.688957, 0.860707, 0.911431>, <0.684238, 0.863440, 0.911206>, 
      <0.682704, 0.856185, 0.725043>, <0.685302, 0.860497, 0.722936>, <0.683642, 0.866612, 0.722394>, <0.678923, 0.869346, 0.722170>, 
      <0.667431, 0.827980, 0.590215>, <0.670029, 0.832293, 0.588108>, <0.668265, 0.838156, 0.586167>, <0.663546, 0.840890, 0.585943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.623295, 0.738754, 1.149058>, <0.625087, 0.743019, 1.151955>, <0.622531, 0.748579, 1.153909>, <0.617668, 0.750995, 1.153359>, 
      <0.645366, 0.774059, 1.118338>, <0.647158, 0.778324, 1.121235>, <0.645135, 0.784500, 1.122236>, <0.640272, 0.786917, 1.121686>, 
      <0.674740, 0.823246, 1.079840>, <0.677449, 0.827962, 1.080299>, <0.675194, 0.833738, 1.081655>, <0.670475, 0.836472, 1.081431>, 
      <0.696787, 0.859457, 1.050174>, <0.699497, 0.864173, 1.050634>, <0.697825, 0.870371, 1.050829>, <0.693106, 0.873105, 1.050604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.529456, 0.591798, 1.283075>, <0.531021, 0.595731, 1.286522>, <0.528276, 0.601014, 1.288932>, <0.523413, 0.603431, 1.288382>, 
      <0.559947, 0.635938, 1.244676>, <0.561512, 0.639871, 1.248122>, <0.558908, 0.645362, 1.250266>, <0.554045, 0.647779, 1.249716>, 
      <0.595153, 0.693739, 1.188228>, <0.596945, 0.698003, 1.191125>, <0.594218, 0.703584, 1.193582>, <0.589355, 0.706000, 1.193032>, 
      <0.623295, 0.738754, 1.149058>, <0.625087, 0.743019, 1.151955>, <0.622531, 0.748579, 1.153909>, <0.617668, 0.750995, 1.153359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.386904, 0.396550, 1.446759>, <0.388328, 0.400265, 1.450495>, <0.385466, 0.405367, 1.453147>, <0.380603, 0.407784, 1.452598>, 
      <0.429670, 0.455124, 1.397654>, <0.431094, 0.458839, 1.401390>, <0.428309, 0.464061, 1.403883>, <0.423446, 0.466478, 1.403333>, 
      <0.488976, 0.533199, 1.334053>, <0.490541, 0.537132, 1.337500>, <0.487734, 0.542320, 1.340107>, <0.482871, 0.544736, 1.339557>, 
      <0.529456, 0.591798, 1.283075>, <0.531021, 0.595731, 1.286522>, <0.528276, 0.601014, 1.288932>, <0.523413, 0.603431, 1.288382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.598712, 0.698426, 0.214367>, <0.593993, 0.701159, 0.214143>, <0.587900, 0.699838, 0.215689>, <0.585297, 0.695515, 0.217771>, 
      <0.577240, 0.641020, 0.072980>, <0.572521, 0.643753, 0.072755>, <0.566426, 0.642426, 0.074288>, <0.563823, 0.638104, 0.076370>, 
      <0.554698, 0.559142, -0.114193>, <0.549979, 0.561876, -0.114418>, <0.543885, 0.560551, -0.112878>, <0.541278, 0.556220, -0.110820>, 
      <0.535835, 0.499449, -0.255004>, <0.531116, 0.502183, -0.255229>, <0.525020, 0.500853, -0.253703>, <0.522413, 0.496522, -0.251645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.663546, 0.840890, 0.585943>, <0.658827, 0.843623, 0.585718>, <0.652737, 0.842309, 0.587285>, <0.650139, 0.837996, 0.589391>, 
      <0.650261, 0.816307, 0.468256>, <0.645542, 0.819040, 0.468031>, <0.639406, 0.817690, 0.469595>, <0.636808, 0.813377, 0.471702>, 
      <0.615566, 0.743486, 0.325348>, <0.610847, 0.746220, 0.325123>, <0.604756, 0.744903, 0.326682>, <0.602154, 0.740581, 0.328765>, 
      <0.598712, 0.698426, 0.214367>, <0.593993, 0.701159, 0.214143>, <0.587900, 0.699838, 0.215689>, <0.585297, 0.695515, 0.217771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.693106, 0.873105, 1.050604>, <0.688387, 0.875838, 1.050380>, <0.682205, 0.874189, 1.049811>, <0.679496, 0.869473, 1.049351>, 
      <0.684238, 0.863440, 0.911206>, <0.679519, 0.866174, 0.910981>, <0.673398, 0.864746, 0.911823>, <0.670689, 0.860030, 0.911363>, 
      <0.678923, 0.869346, 0.722170>, <0.674204, 0.872079, 0.721945>, <0.668010, 0.870514, 0.722113>, <0.665412, 0.866201, 0.724220>, 
      <0.663546, 0.840890, 0.585943>, <0.658827, 0.843623, 0.585718>, <0.652737, 0.842309, 0.587285>, <0.650139, 0.837996, 0.589391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.617668, 0.750995, 1.153359>, <0.612806, 0.753412, 1.152809>, <0.607268, 0.751875, 1.149941>, <0.605476, 0.747610, 1.147043>, 
      <0.640272, 0.786917, 1.121686>, <0.635409, 0.789333, 1.121136>, <0.629438, 0.787379, 1.119338>, <0.627646, 0.783114, 1.116440>, 
      <0.670475, 0.836472, 1.081431>, <0.665756, 0.839205, 1.081206>, <0.659999, 0.837630, 1.079118>, <0.657290, 0.832914, 1.078659>, 
      <0.693106, 0.873105, 1.050604>, <0.688387, 0.875838, 1.050380>, <0.682205, 0.874189, 1.049811>, <0.679496, 0.869473, 1.049351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.523413, 0.603431, 1.288382>, <0.518550, 0.605848, 1.287832>, <0.513202, 0.604587, 1.284507>, <0.511637, 0.600654, 1.281060>, 
      <0.554045, 0.647779, 1.249716>, <0.549183, 0.650196, 1.249166>, <0.543693, 0.648727, 1.246107>, <0.542129, 0.644794, 1.242660>, 
      <0.589355, 0.706000, 1.193032>, <0.584492, 0.708417, 1.192482>, <0.579060, 0.706700, 1.188879>, <0.577268, 0.702436, 1.185981>, 
      <0.617668, 0.750995, 1.153359>, <0.612806, 0.753412, 1.152809>, <0.607268, 0.751875, 1.149941>, <0.605476, 0.747610, 1.147043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.380603, 0.407784, 1.452598>, <0.375741, 0.410201, 1.452048>, <0.370509, 0.409121, 1.448480>, <0.369085, 0.405406, 1.444744>, 
      <0.423446, 0.466478, 1.403333>, <0.418584, 0.468895, 1.402783>, <0.413275, 0.467695, 1.399375>, <0.411851, 0.463980, 1.395639>, 
      <0.482871, 0.544736, 1.339557>, <0.478009, 0.547153, 1.339007>, <0.472722, 0.545988, 1.335485>, <0.471158, 0.542055, 1.332038>, 
      <0.523413, 0.603431, 1.288382>, <0.518550, 0.605848, 1.287832>, <0.513202, 0.604587, 1.284507>, <0.511637, 0.600654, 1.281060>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.585297, 0.695515, 0.217771>, <0.582695, 0.691194, 0.219854>, <0.584456, 0.685322, 0.221774>, <0.589175, 0.682589, 0.221999>, 
      <0.563823, 0.638104, 0.076370>, <0.561221, 0.633783, 0.078453>, <0.562979, 0.627906, 0.080360>, <0.567698, 0.625173, 0.080584>, 
      <0.541278, 0.556220, -0.110820>, <0.538671, 0.551889, -0.108762>, <0.540431, 0.546015, -0.106849>, <0.545150, 0.543282, -0.106624>, 
      <0.522413, 0.496522, -0.251645>, <0.519806, 0.492191, -0.249587>, <0.521564, 0.486312, -0.247688>, <0.526283, 0.483579, -0.247463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.650139, 0.837996, 0.589391>, <0.647541, 0.833684, 0.591498>, <0.649305, 0.827820, 0.593438>, <0.654024, 0.825086, 0.593663>, 
      <0.636808, 0.813377, 0.471702>, <0.634209, 0.809064, 0.473809>, <0.635926, 0.803164, 0.475747>, <0.640645, 0.800431, 0.475972>, 
      <0.602154, 0.740581, 0.328765>, <0.599551, 0.736259, 0.330848>, <0.601314, 0.730393, 0.332781>, <0.606033, 0.727659, 0.333006>, 
      <0.585297, 0.695515, 0.217771>, <0.582695, 0.691194, 0.219854>, <0.584456, 0.685322, 0.221774>, <0.589175, 0.682589, 0.221999>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.679496, 0.869473, 1.049351>, <0.676786, 0.864757, 1.048892>, <0.678458, 0.858559, 1.048697>, <0.683177, 0.855825, 1.048921>, 
      <0.670689, 0.860030, 0.911363>, <0.667979, 0.855314, 0.910904>, <0.669712, 0.849337, 0.912119>, <0.674431, 0.846604, 0.912344>, 
      <0.665412, 0.866201, 0.724220>, <0.662814, 0.861888, 0.726327>, <0.664473, 0.855773, 0.726868>, <0.669192, 0.853039, 0.727093>, 
      <0.650139, 0.837996, 0.589391>, <0.647541, 0.833684, 0.591498>, <0.649305, 0.827820, 0.593438>, <0.654024, 0.825086, 0.593663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.605476, 0.747610, 1.147043>, <0.603684, 0.743346, 1.144146>, <0.606240, 0.737786, 1.142193>, <0.611102, 0.735369, 1.142743>, 
      <0.627646, 0.783114, 1.116440>, <0.625854, 0.778850, 1.113543>, <0.627882, 0.772676, 1.112529>, <0.632745, 0.770259, 1.113079>, 
      <0.657290, 0.832914, 1.078659>, <0.654580, 0.828199, 1.078200>, <0.656836, 0.822422, 1.076843>, <0.661555, 0.819689, 1.077068>, 
      <0.679496, 0.869473, 1.049351>, <0.676786, 0.864757, 1.048892>, <0.678458, 0.858559, 1.048697>, <0.683177, 0.855825, 1.048921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511637, 0.600654, 1.281060>, <0.510073, 0.596722, 1.277614>, <0.512817, 0.591438, 1.275203>, <0.517680, 0.589022, 1.275753>, 
      <0.542129, 0.644794, 1.242660>, <0.540564, 0.640862, 1.239214>, <0.543168, 0.635370, 1.237070>, <0.548030, 0.632954, 1.237620>, 
      <0.577268, 0.702436, 1.185981>, <0.575476, 0.698171, 1.183084>, <0.578204, 0.692588, 1.180619>, <0.583067, 0.690172, 1.181168>, 
      <0.605476, 0.747610, 1.147043>, <0.603684, 0.743346, 1.144146>, <0.606240, 0.737786, 1.142193>, <0.611102, 0.735369, 1.142743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.369085, 0.405406, 1.444744>, <0.367661, 0.401691, 1.441007>, <0.370523, 0.396588, 1.438355>, <0.375386, 0.394172, 1.438905>, 
      <0.411851, 0.463980, 1.395639>, <0.410427, 0.460265, 1.391902>, <0.413212, 0.455043, 1.389410>, <0.418074, 0.452627, 1.389960>, 
      <0.471158, 0.542055, 1.332038>, <0.469593, 0.538123, 1.328592>, <0.472400, 0.532935, 1.325985>, <0.477263, 0.530518, 1.326535>, 
      <0.511637, 0.600654, 1.281060>, <0.510073, 0.596722, 1.277614>, <0.512817, 0.591438, 1.275203>, <0.517680, 0.589022, 1.275753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.589175, 0.682589, 0.221999>, <0.593894, 0.679856, 0.222223>, <0.599986, 0.681178, 0.220677>, <0.602589, 0.685500, 0.218595>, 
      <0.567698, 0.625173, 0.080584>, <0.572417, 0.622440, 0.080809>, <0.578512, 0.623767, 0.079276>, <0.581115, 0.628089, 0.077193>, 
      <0.545150, 0.543282, -0.106624>, <0.549869, 0.540548, -0.106400>, <0.555963, 0.541873, -0.107939>, <0.558570, 0.546204, -0.109997>, 
      <0.526283, 0.483579, -0.247463>, <0.531002, 0.480845, -0.247238>, <0.537098, 0.482175, -0.248764>, <0.539705, 0.486506, -0.250822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.654024, 0.825086, 0.593663>, <0.658743, 0.822353, 0.593888>, <0.664832, 0.823667, 0.592321>, <0.667431, 0.827980, 0.590215>, 
      <0.640645, 0.800431, 0.475972>, <0.645364, 0.797697, 0.476197>, <0.651501, 0.799048, 0.474632>, <0.654099, 0.803361, 0.472525>, 
      <0.606033, 0.727659, 0.333006>, <0.610752, 0.724926, 0.333230>, <0.616843, 0.726243, 0.331671>, <0.619445, 0.730565, 0.329588>, 
      <0.589175, 0.682589, 0.221999>, <0.593894, 0.679856, 0.222223>, <0.599986, 0.681178, 0.220677>, <0.602589, 0.685500, 0.218595>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.683177, 0.855825, 1.048921>, <0.687896, 0.853092, 1.049146>, <0.694078, 0.854741, 1.049715>, <0.696787, 0.859457, 1.050174>, 
      <0.674431, 0.846604, 0.912344>, <0.679150, 0.843870, 0.912568>, <0.685271, 0.845298, 0.911727>, <0.687980, 0.850014, 0.912186>, 
      <0.669192, 0.853039, 0.727093>, <0.673911, 0.850306, 0.727318>, <0.680105, 0.851872, 0.727150>, <0.682704, 0.856185, 0.725043>, 
      <0.654024, 0.825086, 0.593663>, <0.658743, 0.822353, 0.593888>, <0.664832, 0.823667, 0.592321>, <0.667431, 0.827980, 0.590215>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.611102, 0.735369, 1.142743>, <0.615965, 0.732952, 1.143292>, <0.621503, 0.734490, 1.146161>, <0.623295, 0.738754, 1.149058>, 
      <0.632745, 0.770259, 1.113079>, <0.637607, 0.767842, 1.113629>, <0.643575, 0.769795, 1.115441>, <0.645366, 0.774059, 1.118338>, 
      <0.661555, 0.819689, 1.077068>, <0.666273, 0.816955, 1.077292>, <0.672030, 0.818531, 1.079380>, <0.674740, 0.823246, 1.079840>, 
      <0.683177, 0.855825, 1.048921>, <0.687896, 0.853092, 1.049146>, <0.694078, 0.854741, 1.049715>, <0.696787, 0.859457, 1.050174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.517680, 0.589022, 1.275753>, <0.522542, 0.586605, 1.276303>, <0.527891, 0.587866, 1.279629>, <0.529456, 0.591798, 1.283075>, 
      <0.548030, 0.632954, 1.237620>, <0.552893, 0.630537, 1.238170>, <0.558383, 0.632006, 1.241229>, <0.559947, 0.635938, 1.244676>, 
      <0.583067, 0.690172, 1.181168>, <0.587930, 0.687755, 1.181718>, <0.593361, 0.689474, 1.185331>, <0.595153, 0.693739, 1.188228>, 
      <0.611102, 0.735369, 1.142743>, <0.615965, 0.732952, 1.143292>, <0.621503, 0.734490, 1.146161>, <0.623295, 0.738754, 1.149058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.375386, 0.394172, 1.438905>, <0.380249, 0.391755, 1.439455>, <0.385480, 0.392835, 1.443022>, <0.386904, 0.396550, 1.446759>, 
      <0.418074, 0.452627, 1.389960>, <0.422937, 0.450210, 1.390510>, <0.428246, 0.451410, 1.393917>, <0.429670, 0.455124, 1.397654>, 
      <0.477263, 0.530518, 1.326535>, <0.482125, 0.528102, 1.327085>, <0.487412, 0.529267, 1.330607>, <0.488976, 0.533199, 1.334053>, 
      <0.517680, 0.589022, 1.275753>, <0.522542, 0.586605, 1.276303>, <0.527891, 0.587866, 1.279629>, <0.529456, 0.591798, 1.283075>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.024525, 0.009355, 0.218595>, <1.029569, 0.009262, 0.216512>, <1.033773, 0.013723, 0.214592>, <1.033781, 0.019176, 0.214367>, 
      <0.949340, 0.003086, 0.075603>, <0.954384, 0.002993, 0.073520>, <0.958594, 0.007454, 0.071613>, <0.958602, 0.012907, 0.071389>, 
      <0.827765, -0.005588, -0.102922>, <0.832819, -0.005680, -0.104980>, <0.837026, -0.001219, -0.106893>, <0.837033, 0.004235, -0.107118>, 
      <0.743439, -0.011992, -0.240715>, <0.748493, -0.012084, -0.242773>, <0.752706, -0.007623, -0.244672>, <0.752713, -0.002169, -0.244897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.180338, 0.024441, 0.590215>, <1.185372, 0.024347, 0.588108>, <1.189567, 0.028807, 0.586167>, <1.189575, 0.034260, 0.585943>, 
      <1.135813, 0.019862, 0.477826>, <1.140847, 0.019768, 0.475719>, <1.145192, 0.024226, 0.473735>, <1.145200, 0.029680, 0.473511>, 
      <1.080782, 0.014047, 0.325589>, <1.085826, 0.013954, 0.323506>, <1.090025, 0.018414, 0.321573>, <1.090032, 0.023867, 0.321348>, 
      <1.024525, 0.009355, 0.218595>, <1.029569, 0.009262, 0.216512>, <1.033773, 0.013723, 0.214592>, <1.033781, 0.019176, 0.214367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.323535, 0.040105, 0.973355>, <1.328973, 0.040116, 0.973815>, <1.333505, 0.044664, 0.974010>, <1.333513, 0.050117, 0.973785>, 
      <1.280576, 0.035406, 0.858413>, <1.286014, 0.035417, 0.858872>, <1.290324, 0.039907, 0.857657>, <1.290332, 0.045360, 0.857433>, 
      <1.225533, 0.029089, 0.704298>, <1.230568, 0.028995, 0.702191>, <1.235131, 0.033510, 0.701610>, <1.235139, 0.038964, 0.701386>, 
      <1.180338, 0.024441, 0.590215>, <1.185372, 0.024347, 0.588108>, <1.189567, 0.028807, 0.586167>, <1.189575, 0.034260, 0.585943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.182257, 0.043400, 1.072239>, <1.186846, 0.043980, 1.075136>, <1.190383, 0.048974, 1.077090>, <1.190045, 0.054393, 1.076540>, 
      <1.223868, 0.041938, 1.041519>, <1.228457, 0.042519, 1.044416>, <1.232793, 0.047359, 1.045417>, <1.232455, 0.052779, 1.044867>, 
      <1.281151, 0.041094, 1.003020>, <1.286590, 0.041105, 1.003480>, <1.290465, 0.045947, 1.004836>, <1.290473, 0.051400, 1.004612>, 
      <1.323535, 0.040105, 0.973355>, <1.328973, 0.040116, 0.973815>, <1.333505, 0.044664, 0.974010>, <1.333513, 0.050117, 0.973785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.008070, 0.051189, 1.206256>, <1.012258, 0.051800, 1.209703>, <1.015461, 0.056819, 1.212113>, <1.015122, 0.062239, 1.211563>, 
      <1.053730, 0.049791, 1.158656>, <1.057918, 0.050402, 1.162103>, <1.061348, 0.055407, 1.164233>, <1.061010, 0.060826, 1.163683>, 
      <1.129201, 0.045264, 1.111409>, <1.133790, 0.045845, 1.114306>, <1.137260, 0.050996, 1.116763>, <1.136921, 0.056416, 1.116213>, 
      <1.182257, 0.043400, 1.072239>, <1.186846, 0.043980, 1.075136>, <1.190383, 0.048974, 1.077090>, <1.190045, 0.054393, 1.076540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.896684, 0.052147, 1.369940>, <0.900613, 0.052771, 1.373676>, <0.903601, 0.057801, 1.376328>, <0.903263, 0.063221, 1.375778>, 
      <0.930100, 0.051860, 1.320835>, <0.934029, 0.052484, 1.324571>, <0.937159, 0.057506, 1.327064>, <0.936821, 0.062926, 1.326514>, 
      <0.966961, 0.052448, 1.249111>, <0.971149, 0.053059, 1.252557>, <0.974226, 0.058088, 1.255139>, <0.973887, 0.063508, 1.254589>, 
      <1.008070, 0.051189, 1.206256>, <1.012258, 0.051800, 1.209703>, <1.015461, 0.056819, 1.212113>, <1.015122, 0.062239, 1.211563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.033781, 0.019176, 0.214367>, <1.033789, 0.024630, 0.214143>, <1.029597, 0.029245, 0.215689>, <1.024553, 0.029338, 0.217771>, 
      <0.958602, 0.012907, 0.071389>, <0.958610, 0.018361, 0.071164>, <0.954413, 0.022976, 0.072697>, <0.949369, 0.023069, 0.074779>, 
      <0.837033, 0.004235, -0.107118>, <0.837041, 0.009688, -0.107342>, <0.832847, 0.014303, -0.105803>, <0.827793, 0.014395, -0.103745>, 
      <0.752713, -0.002169, -0.244897>, <0.752721, 0.003284, -0.245122>, <0.748521, 0.007899, -0.243596>, <0.743467, 0.007991, -0.241538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.189575, 0.034260, 0.585943>, <1.189583, 0.039714, 0.585718>, <1.185400, 0.044330, 0.587285>, <1.180366, 0.044424, 0.589391>, 
      <1.145200, 0.029680, 0.473511>, <1.145207, 0.035133, 0.473286>, <1.140876, 0.039751, 0.474896>, <1.135842, 0.039845, 0.477003>, 
      <1.090032, 0.023867, 0.321348>, <1.090040, 0.029321, 0.321123>, <1.085854, 0.033937, 0.322683>, <1.080810, 0.034030, 0.324765>, 
      <1.033781, 0.019176, 0.214367>, <1.033789, 0.024630, 0.214143>, <1.029597, 0.029245, 0.215689>, <1.024553, 0.029338, 0.217771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.333513, 0.050117, 0.973785>, <1.333521, 0.055571, 0.973561>, <1.329002, 0.060099, 0.972991>, <1.323563, 0.060088, 0.972532>, 
      <1.290332, 0.045360, 0.857433>, <1.290340, 0.050813, 0.857208>, <1.286043, 0.055400, 0.858049>, <1.280604, 0.055389, 0.857590>, 
      <1.235139, 0.038964, 0.701386>, <1.235146, 0.044417, 0.701161>, <1.230596, 0.048978, 0.701368>, <1.225562, 0.049072, 0.703475>, 
      <1.189575, 0.034260, 0.585943>, <1.189583, 0.039714, 0.585718>, <1.185400, 0.044330, 0.587285>, <1.180366, 0.044424, 0.589391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.190045, 0.054393, 1.076540>, <1.189706, 0.059813, 1.075990>, <1.185606, 0.063840, 1.073121>, <1.181017, 0.063260, 1.070224>, 
      <1.232455, 0.052779, 1.044867>, <1.232117, 0.058198, 1.044317>, <1.227438, 0.062392, 1.042518>, <1.222849, 0.061812, 1.039621>, 
      <1.290473, 0.051400, 1.004612>, <1.290480, 0.056853, 1.004387>, <1.286238, 0.061051, 1.002299>, <1.280799, 0.061040, 1.001840>, 
      <1.333513, 0.050117, 0.973785>, <1.333521, 0.055571, 0.973561>, <1.329002, 0.060099, 0.972991>, <1.323563, 0.060088, 0.972532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.015122, 0.062239, 1.211563>, <1.014784, 0.067658, 1.211013>, <1.011018, 0.071660, 1.207688>, <1.006830, 0.071049, 1.204241>, 
      <1.061010, 0.060826, 1.163683>, <1.060671, 0.066246, 1.163133>, <1.056678, 0.070261, 1.160088>, <1.052491, 0.069650, 1.156641>, 
      <1.136921, 0.056416, 1.116213>, <1.136583, 0.061835, 1.115663>, <1.132380, 0.065682, 1.112060>, <1.127791, 0.065102, 1.109162>, 
      <1.190045, 0.054393, 1.076540>, <1.189706, 0.059813, 1.075990>, <1.185606, 0.063840, 1.073121>, <1.181017, 0.063260, 1.070224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.903263, 0.063221, 1.375778>, <0.902925, 0.068640, 1.375228>, <0.899373, 0.072631, 1.371661>, <0.895444, 0.072007, 1.367925>, 
      <0.936821, 0.062926, 1.326514>, <0.936483, 0.068346, 1.325964>, <0.932789, 0.072344, 1.322556>, <0.928860, 0.071719, 1.318820>, 
      <0.973887, 0.063508, 1.254589>, <0.973549, 0.068928, 1.254040>, <0.969909, 0.072919, 1.250542>, <0.965721, 0.072308, 1.247095>, 
      <1.015122, 0.062239, 1.211563>, <1.014784, 0.067658, 1.211013>, <1.011018, 0.071660, 1.207688>, <1.006830, 0.071049, 1.204241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.024553, 0.029338, 0.217771>, <1.019509, 0.029431, 0.219854>, <1.015305, 0.024970, 0.221774>, <1.015297, 0.019517, 0.221999>, 
      <0.949369, 0.023069, 0.074779>, <0.944325, 0.023162, 0.076862>, <0.940115, 0.018700, 0.078769>, <0.940107, 0.013247, 0.078993>, 
      <0.827793, 0.014395, -0.103745>, <0.822739, 0.014487, -0.101687>, <0.818532, 0.010026, -0.099774>, <0.818524, 0.004573, -0.099549>, 
      <0.743467, 0.007991, -0.241538>, <0.738413, 0.008083, -0.239480>, <0.734200, 0.003621, -0.237580>, <0.734193, -0.001832, -0.237356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.180366, 0.044424, 0.589391>, <1.175332, 0.044518, 0.591498>, <1.171136, 0.040058, 0.593438>, <1.171128, 0.034605, 0.593663>, 
      <1.135842, 0.039845, 0.477003>, <1.130808, 0.039939, 0.479110>, <1.126461, 0.035481, 0.481094>, <1.126453, 0.030028, 0.481319>, 
      <1.080810, 0.034030, 0.324765>, <1.075766, 0.034123, 0.326848>, <1.071568, 0.029662, 0.328782>, <1.071560, 0.024209, 0.329006>, 
      <1.024553, 0.029338, 0.217771>, <1.019509, 0.029431, 0.219854>, <1.015305, 0.024970, 0.221774>, <1.015297, 0.019517, 0.221999>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.323563, 0.060088, 0.972532>, <1.318124, 0.060077, 0.972073>, <1.313592, 0.055530, 0.971877>, <1.313584, 0.050076, 0.972102>, 
      <1.280604, 0.055389, 0.857590>, <1.275165, 0.055378, 0.857131>, <1.270855, 0.050888, 0.858346>, <1.270848, 0.045435, 0.858570>, 
      <1.225562, 0.049072, 0.703475>, <1.220528, 0.049166, 0.705582>, <1.215962, 0.044650, 0.706164>, <1.215955, 0.039197, 0.706388>, 
      <1.180366, 0.044424, 0.589391>, <1.175332, 0.044518, 0.591498>, <1.171136, 0.040058, 0.593438>, <1.171128, 0.034605, 0.593663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.181017, 0.063260, 1.070224>, <1.176428, 0.062679, 1.067327>, <1.172891, 0.057686, 1.065373>, <1.173229, 0.052266, 1.065923>, 
      <1.222849, 0.061812, 1.039621>, <1.218260, 0.061232, 1.036724>, <1.213928, 0.056388, 1.035710>, <1.214266, 0.050969, 1.036260>, 
      <1.280799, 0.061040, 1.001840>, <1.275361, 0.061028, 1.001380>, <1.271486, 0.056187, 1.000024>, <1.271478, 0.050733, 1.000248>, 
      <1.323563, 0.060088, 0.972532>, <1.318124, 0.060077, 0.972073>, <1.313592, 0.055530, 0.971877>, <1.313584, 0.050076, 0.972102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.006830, 0.071049, 1.204241>, <1.002642, 0.070438, 1.200795>, <0.999439, 0.065419, 1.198384>, <0.999777, 0.059999, 1.198934>, 
      <1.052491, 0.069650, 1.156641>, <1.048303, 0.069039, 1.153195>, <1.044873, 0.064034, 1.151064>, <1.045211, 0.058615, 1.151614>, 
      <1.127791, 0.065102, 1.109162>, <1.123202, 0.064521, 1.106265>, <1.119731, 0.059367, 1.103799>, <1.120069, 0.053947, 1.104349>, 
      <1.181017, 0.063260, 1.070224>, <1.176428, 0.062679, 1.067327>, <1.172891, 0.057686, 1.065373>, <1.173229, 0.052266, 1.065923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.895444, 0.072007, 1.367925>, <0.891515, 0.071382, 1.364188>, <0.888527, 0.066352, 1.361536>, <0.888865, 0.060933, 1.362086>, 
      <0.928860, 0.071719, 1.318820>, <0.924931, 0.071095, 1.315083>, <0.921801, 0.066072, 1.312591>, <0.922139, 0.060653, 1.313140>, 
      <0.965721, 0.072308, 1.247095>, <0.961534, 0.071697, 1.243649>, <0.958457, 0.066668, 1.241067>, <0.958795, 0.061248, 1.241616>, 
      <1.006830, 0.071049, 1.204241>, <1.002642, 0.070438, 1.200795>, <0.999439, 0.065419, 1.198384>, <0.999777, 0.059999, 1.198934>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.015297, 0.019517, 0.221999>, <1.015290, 0.014064, 0.222223>, <1.019481, 0.009448, 0.220677>, <1.024525, 0.009355, 0.218595>, 
      <0.940107, 0.013247, 0.078993>, <0.940100, 0.007794, 0.079218>, <0.944296, 0.003179, 0.077685>, <0.949340, 0.003086, 0.075603>, 
      <0.818524, 0.004573, -0.099549>, <0.818516, -0.000881, -0.099325>, <0.822710, -0.005496, -0.100864>, <0.827765, -0.005588, -0.102922>, 
      <0.734193, -0.001832, -0.237356>, <0.734185, -0.007286, -0.237131>, <0.738384, -0.011900, -0.238657>, <0.743439, -0.011992, -0.240715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.171128, 0.034605, 0.593663>, <1.171121, 0.029151, 0.593888>, <1.175304, 0.024535, 0.592321>, <1.180338, 0.024441, 0.590215>, 
      <1.126453, 0.030028, 0.481319>, <1.126445, 0.024574, 0.481543>, <1.130779, 0.019956, 0.479933>, <1.135813, 0.019862, 0.477826>, 
      <1.071560, 0.024209, 0.329006>, <1.071552, 0.018756, 0.329231>, <1.075738, 0.014140, 0.327671>, <1.080782, 0.014047, 0.325589>, 
      <1.015297, 0.019517, 0.221999>, <1.015290, 0.014064, 0.222223>, <1.019481, 0.009448, 0.220677>, <1.024525, 0.009355, 0.218595>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313584, 0.050076, 0.972102>, <1.313577, 0.044623, 0.972327>, <1.318096, 0.040094, 0.972896>, <1.323535, 0.040105, 0.973355>, 
      <1.270848, 0.045435, 0.858570>, <1.270840, 0.039981, 0.858795>, <1.275137, 0.035395, 0.857954>, <1.280576, 0.035406, 0.858413>, 
      <1.215955, 0.039197, 0.706388>, <1.215947, 0.033744, 0.706613>, <1.220499, 0.029183, 0.706405>, <1.225533, 0.029089, 0.704298>, 
      <1.171128, 0.034605, 0.593663>, <1.171121, 0.029151, 0.593888>, <1.175304, 0.024535, 0.592321>, <1.180338, 0.024441, 0.590215>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.173229, 0.052266, 1.065923>, <1.173567, 0.046847, 1.066473>, <1.177668, 0.042820, 1.069342>, <1.182257, 0.043400, 1.072239>, 
      <1.214266, 0.050969, 1.036260>, <1.214604, 0.045549, 1.036810>, <1.219279, 0.041358, 1.038621>, <1.223868, 0.041938, 1.041519>, 
      <1.271478, 0.050733, 1.000248>, <1.271470, 0.045280, 1.000473>, <1.275713, 0.041083, 1.002561>, <1.281151, 0.041094, 1.003020>, 
      <1.313584, 0.050076, 0.972102>, <1.313577, 0.044623, 0.972327>, <1.318096, 0.040094, 0.972896>, <1.323535, 0.040105, 0.973355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.999777, 0.059999, 1.198934>, <1.000115, 0.054580, 1.199484>, <1.003882, 0.050578, 1.202810>, <1.008070, 0.051189, 1.206256>, 
      <1.045211, 0.058615, 1.151614>, <1.045550, 0.053195, 1.152164>, <1.049543, 0.049180, 1.155210>, <1.053730, 0.049791, 1.158656>, 
      <1.120069, 0.053947, 1.104349>, <1.120407, 0.048528, 1.104899>, <1.124612, 0.044684, 1.108512>, <1.129201, 0.045264, 1.111409>, 
      <1.173229, 0.052266, 1.065923>, <1.173567, 0.046847, 1.066473>, <1.177668, 0.042820, 1.069342>, <1.182257, 0.043400, 1.072239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.888865, 0.060933, 1.362086>, <0.889204, 0.055513, 1.362636>, <0.892755, 0.051522, 1.366203>, <0.896684, 0.052147, 1.369940>, 
      <0.922139, 0.060653, 1.313140>, <0.922477, 0.055233, 1.313690>, <0.926171, 0.051235, 1.317098>, <0.930100, 0.051860, 1.320835>, 
      <0.958795, 0.061248, 1.241616>, <0.959133, 0.055829, 1.242166>, <0.962773, 0.051837, 1.245664>, <0.966961, 0.052448, 1.249111>, 
      <0.999777, 0.059999, 1.198934>, <1.000115, 0.054580, 1.199484>, <1.003882, 0.050578, 1.202810>, <1.008070, 0.051189, 1.206256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.542298, -0.840504, 0.156085>, <0.544740, -0.844919, 0.154002>, <0.550705, -0.846329, 0.152082>, <0.555432, -0.843609, 0.151858>, 
      <0.503095, -0.785442, 0.029395>, <0.505536, -0.789857, 0.027312>, <0.511505, -0.791272, 0.025406>, <0.516231, -0.788552, 0.025181>, 
      <0.438030, -0.693797, -0.126519>, <0.440477, -0.698220, -0.128577>, <0.446444, -0.699633, -0.130490>, <0.451171, -0.696913, -0.130714>, 
      <0.393343, -0.630922, -0.247634>, <0.395791, -0.635346, -0.249692>, <0.401761, -0.636763, -0.251592>, <0.406488, -0.634043, -0.251817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.633269, -0.967899, 0.527705>, <0.635705, -0.972305, 0.525598>, <0.641665, -0.973709, 0.523658>, <0.646392, -0.970989, 0.523433>, 
      <0.607042, -0.931629, 0.415316>, <0.609477, -0.936035, 0.413210>, <0.615510, -0.937569, 0.411226>, <0.620237, -0.934849, 0.411001>, 
      <0.575326, -0.886892, 0.262818>, <0.577768, -0.891307, 0.260735>, <0.583730, -0.892713, 0.258802>, <0.588457, -0.889992, 0.258577>, 
      <0.542298, -0.840504, 0.156085>, <0.544740, -0.844919, 0.154002>, <0.550705, -0.846329, 0.152082>, <0.555432, -0.843609, 0.151858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.718433, -1.084079, 0.910845>, <0.721163, -1.088783, 0.911305>, <0.727367, -1.090434, 0.911500>, <0.732093, -1.087715, 0.911276>, 
      <0.692884, -1.049225, 0.795903>, <0.695613, -1.053929, 0.796363>, <0.701656, -1.055417, 0.795147>, <0.706383, -1.052697, 0.794923>, 
      <0.659892, -1.004715, 0.641788>, <0.662328, -1.009122, 0.639681>, <0.668520, -1.010816, 0.639101>, <0.673247, -1.008097, 0.638876>, 
      <0.633269, -0.967899, 0.527705>, <0.635705, -0.972305, 0.525598>, <0.641665, -0.973709, 0.523658>, <0.646392, -0.970989, 0.523433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.650648, -0.960081, 1.009729>, <0.653445, -0.963765, 1.012627>, <0.659538, -0.964332, 1.014580>, <0.664062, -0.961329, 1.014030>, 
      <0.670187, -0.996848, 0.979009>, <0.672984, -1.000532, 0.981906>, <0.679345, -1.001868, 0.982907>, <0.683869, -0.998865, 0.982357>, 
      <0.698098, -1.046880, 0.940511>, <0.700827, -1.051584, 0.940970>, <0.706957, -1.052519, 0.942326>, <0.711684, -1.049799, 0.942102>, 
      <0.718433, -1.084079, 0.910845>, <0.721163, -1.088783, 0.911305>, <0.727367, -1.090434, 0.911500>, <0.732093, -1.087715, 0.911276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.570300, -0.805336, 1.143747>, <0.572923, -0.808658, 1.147193>, <0.578871, -0.808922, 1.149603>, <0.583395, -0.805920, 1.149053>, 
      <0.593263, -0.848511, 1.099460>, <0.595886, -0.851832, 1.102906>, <0.601937, -0.852303, 1.105036>, <0.606461, -0.849300, 1.104486>, 
      <0.625735, -0.913202, 1.048899>, <0.628532, -0.916886, 1.051796>, <0.634728, -0.917315, 1.054253>, <0.639252, -0.914312, 1.053703>, 
      <0.650648, -0.960081, 1.009729>, <0.653445, -0.963765, 1.012627>, <0.659538, -0.964332, 1.014580>, <0.664062, -0.961329, 1.014030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.509391, -0.694491, 1.282162>, <0.511896, -0.697582, 1.285898>, <0.517746, -0.697655, 1.288550>, <0.522271, -0.694652, 1.288000>, 
      <0.527664, -0.727745, 1.240637>, <0.530169, -0.730835, 1.244374>, <0.536084, -0.731035, 1.246866>, <0.540608, -0.728032, 1.246316>, 
      <0.550722, -0.768526, 1.181505>, <0.553345, -0.771847, 1.184951>, <0.559238, -0.771997, 1.187539>, <0.563762, -0.768994, 1.186989>, 
      <0.570300, -0.805336, 1.143747>, <0.572923, -0.808658, 1.147193>, <0.578871, -0.808922, 1.149603>, <0.583395, -0.805920, 1.149053>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.555432, -0.843609, 0.151858>, <0.560158, -0.840889, 0.151633>, <0.562060, -0.834952, 0.153179>, <0.559618, -0.830537, 0.155262>, 
      <0.516231, -0.788552, 0.025181>, <0.520958, -0.785832, 0.024956>, <0.522856, -0.779890, 0.026489>, <0.520415, -0.775475, 0.028572>, 
      <0.451171, -0.696913, -0.130714>, <0.455898, -0.694193, -0.130939>, <0.457797, -0.688253, -0.129400>, <0.455350, -0.683830, -0.127342>, 
      <0.406488, -0.634043, -0.251817>, <0.411214, -0.631323, -0.252041>, <0.413111, -0.625378, -0.250516>, <0.410663, -0.620955, -0.248457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.646392, -0.970989, 0.523433>, <0.651119, -0.968269, 0.523209>, <0.653025, -0.962338, 0.524775>, <0.650589, -0.957932, 0.526882>, 
      <0.620237, -0.934849, 0.411001>, <0.624964, -0.932129, 0.410777>, <0.626797, -0.926068, 0.412386>, <0.624362, -0.921662, 0.414493>, 
      <0.588457, -0.889992, 0.258577>, <0.593183, -0.887273, 0.258352>, <0.595088, -0.881340, 0.259912>, <0.592646, -0.876925, 0.261995>, 
      <0.555432, -0.843609, 0.151858>, <0.560158, -0.840889, 0.151633>, <0.562060, -0.834952, 0.153179>, <0.559618, -0.830537, 0.155262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.732093, -1.087715, 0.911276>, <0.736820, -1.084995, 0.911051>, <0.738482, -1.078816, 0.910482>, <0.735753, -1.074112, 0.910022>, 
      <0.706383, -1.052697, 0.794923>, <0.711109, -1.049977, 0.794698>, <0.712933, -1.043962, 0.795540>, <0.710204, -1.039258, 0.795080>, 
      <0.673247, -1.008097, 0.638876>, <0.677974, -1.005377, 0.638652>, <0.679648, -0.999155, 0.638858>, <0.677212, -0.994749, 0.640965>, 
      <0.646392, -0.970989, 0.523433>, <0.651119, -0.968269, 0.523209>, <0.653025, -0.962338, 0.524775>, <0.650589, -0.957932, 0.526882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.664062, -0.961329, 1.014030>, <0.668587, -0.958326, 1.013480>, <0.670024, -0.952762, 1.010612>, <0.667227, -0.949078, 1.007714>, 
      <0.683869, -0.998865, 0.982357>, <0.688394, -0.995862, 0.981808>, <0.689687, -0.989713, 0.980009>, <0.686889, -0.986029, 0.977112>, 
      <0.711684, -1.049799, 0.942102>, <0.716411, -1.047079, 0.941877>, <0.717924, -1.041306, 0.939789>, <0.715195, -1.036602, 0.939330>, 
      <0.732093, -1.087715, 0.911276>, <0.736820, -1.084995, 0.911051>, <0.738482, -1.078816, 0.910482>, <0.735753, -1.074112, 0.910022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583395, -0.805920, 1.149053>, <0.587920, -0.802917, 1.148503>, <0.589502, -0.797654, 1.145178>, <0.586879, -0.794333, 1.141731>, 
      <0.606461, -0.849300, 1.104486>, <0.610985, -0.846298, 1.103936>, <0.612465, -0.840828, 1.100891>, <0.609842, -0.837507, 1.097445>, 
      <0.639252, -0.914312, 1.053703>, <0.643776, -0.911309, 1.053153>, <0.645006, -0.905745, 1.049550>, <0.642209, -0.902061, 1.046653>, 
      <0.664062, -0.961329, 1.014030>, <0.668587, -0.958326, 1.013480>, <0.670024, -0.952762, 1.010612>, <0.667227, -0.949078, 1.007714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.522271, -0.694652, 1.288000>, <0.526795, -0.691649, 1.287450>, <0.528475, -0.686578, 1.283883>, <0.525970, -0.683488, 1.280147>, 
      <0.540608, -0.728032, 1.246316>, <0.545133, -0.725029, 1.245766>, <0.546748, -0.719832, 1.242359>, <0.544243, -0.716741, 1.238622>, 
      <0.563762, -0.768994, 1.186989>, <0.568287, -0.765991, 1.186439>, <0.569924, -0.760844, 1.182936>, <0.567301, -0.757523, 1.179490>, 
      <0.583395, -0.805920, 1.149053>, <0.587920, -0.802917, 1.148503>, <0.589502, -0.797654, 1.145178>, <0.586879, -0.794333, 1.141731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.559618, -0.830537, 0.155262>, <0.557177, -0.826122, 0.157344>, <0.551212, -0.824712, 0.159264>, <0.546485, -0.827432, 0.159489>, 
      <0.520415, -0.775475, 0.028572>, <0.517973, -0.771060, 0.030654>, <0.512005, -0.769645, 0.032561>, <0.507278, -0.772365, 0.032786>, 
      <0.455350, -0.683830, -0.127342>, <0.452902, -0.679407, -0.125284>, <0.446935, -0.677994, -0.123370>, <0.442209, -0.680714, -0.123146>, 
      <0.410663, -0.620955, -0.248457>, <0.408216, -0.616532, -0.246399>, <0.402246, -0.615115, -0.244500>, <0.397519, -0.617835, -0.244275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.650589, -0.957932, 0.526882>, <0.648154, -0.953525, 0.528989>, <0.642193, -0.952121, 0.530929>, <0.637467, -0.954841, 0.531153>, 
      <0.624362, -0.921662, 0.414493>, <0.621926, -0.917255, 0.416600>, <0.615892, -0.915720, 0.418584>, <0.611165, -0.918440, 0.418809>, 
      <0.592646, -0.876925, 0.261995>, <0.590205, -0.872510, 0.264077>, <0.584243, -0.871104, 0.266011>, <0.579516, -0.873824, 0.266235>, 
      <0.559618, -0.830537, 0.155262>, <0.557177, -0.826122, 0.157344>, <0.551212, -0.824712, 0.159264>, <0.546485, -0.827432, 0.159489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.735753, -1.074112, 0.910022>, <0.733024, -1.069408, 0.909563>, <0.726820, -1.067756, 0.909368>, <0.722094, -1.070476, 0.909592>, 
      <0.710204, -1.039258, 0.795080>, <0.707475, -1.034554, 0.794621>, <0.701432, -1.033066, 0.795836>, <0.696705, -1.035786, 0.796061>, 
      <0.677212, -0.994749, 0.640965>, <0.674777, -0.990342, 0.643072>, <0.668584, -0.988646, 0.643654>, <0.663857, -0.991366, 0.643879>, 
      <0.650589, -0.957932, 0.526882>, <0.648154, -0.953525, 0.528989>, <0.642193, -0.952121, 0.530929>, <0.637467, -0.954841, 0.531153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667227, -0.949078, 1.007714>, <0.664430, -0.945394, 1.004817>, <0.658337, -0.944827, 1.002864>, <0.653812, -0.947830, 1.003414>, 
      <0.686889, -0.986029, 0.977112>, <0.684092, -0.982345, 0.974214>, <0.677732, -0.981015, 0.973201>, <0.673207, -0.984018, 0.973751>, 
      <0.715195, -1.036602, 0.939330>, <0.712466, -1.031897, 0.938871>, <0.706336, -1.030962, 0.937514>, <0.701609, -1.033682, 0.937739>, 
      <0.735753, -1.074112, 0.910022>, <0.733024, -1.069408, 0.909563>, <0.726820, -1.067756, 0.909368>, <0.722094, -1.070476, 0.909592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.586879, -0.794333, 1.141731>, <0.584256, -0.791012, 1.138285>, <0.578308, -0.790747, 1.135874>, <0.573783, -0.793750, 1.136424>, 
      <0.609842, -0.837507, 1.097445>, <0.607218, -0.834186, 1.093998>, <0.601168, -0.833715, 1.091868>, <0.596643, -0.836717, 1.092418>, 
      <0.642209, -0.902061, 1.046653>, <0.639412, -0.898377, 1.043755>, <0.633213, -0.897949, 1.041290>, <0.628688, -0.900951, 1.041840>, 
      <0.667227, -0.949078, 1.007714>, <0.664430, -0.945394, 1.004817>, <0.658337, -0.944827, 1.002864>, <0.653812, -0.947830, 1.003414>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.525970, -0.683488, 1.280147>, <0.523465, -0.680397, 1.276410>, <0.517615, -0.680324, 1.273758>, <0.513091, -0.683327, 1.274308>, 
      <0.544243, -0.716741, 1.238622>, <0.541737, -0.713651, 1.234886>, <0.535823, -0.713451, 1.232393>, <0.531298, -0.716454, 1.232943>, 
      <0.567301, -0.757523, 1.179490>, <0.564678, -0.754201, 1.176043>, <0.558785, -0.754052, 1.173456>, <0.554261, -0.757055, 1.174006>, 
      <0.586879, -0.794333, 1.141731>, <0.584256, -0.791012, 1.138285>, <0.578308, -0.790747, 1.135874>, <0.573783, -0.793750, 1.136424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.546485, -0.827432, 0.159489>, <0.541758, -0.830152, 0.159714>, <0.539857, -0.836089, 0.158167>, <0.542298, -0.840504, 0.156085>, 
      <0.507278, -0.772365, 0.032786>, <0.502552, -0.775085, 0.033010>, <0.500653, -0.781027, 0.031477>, <0.503095, -0.785442, 0.029395>, 
      <0.442209, -0.680714, -0.123146>, <0.437482, -0.683434, -0.122921>, <0.435582, -0.689374, -0.124461>, <0.438030, -0.693797, -0.126519>, 
      <0.397519, -0.617835, -0.244275>, <0.392792, -0.620555, -0.244051>, <0.390896, -0.626499, -0.245576>, <0.393343, -0.630922, -0.247634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.637467, -0.954841, 0.531153>, <0.632740, -0.957561, 0.531378>, <0.630834, -0.963492, 0.529812>, <0.633269, -0.967899, 0.527705>, 
      <0.611165, -0.918440, 0.418809>, <0.606439, -0.921160, 0.419034>, <0.604606, -0.927222, 0.417423>, <0.607042, -0.931629, 0.415316>, 
      <0.579516, -0.873824, 0.266235>, <0.574790, -0.876544, 0.266460>, <0.572885, -0.882477, 0.264900>, <0.575326, -0.886892, 0.262818>, 
      <0.546485, -0.827432, 0.159489>, <0.541758, -0.830152, 0.159714>, <0.539857, -0.836089, 0.158167>, <0.542298, -0.840504, 0.156085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.722094, -1.070476, 0.909592>, <0.717367, -1.073196, 0.909817>, <0.715704, -1.079375, 0.910386>, <0.718433, -1.084079, 0.910845>, 
      <0.696705, -1.035786, 0.796061>, <0.691979, -1.038506, 0.796285>, <0.690155, -1.044521, 0.795444>, <0.692884, -1.049225, 0.795903>, 
      <0.663857, -0.991366, 0.643879>, <0.659130, -0.994086, 0.644103>, <0.657457, -1.000309, 0.643895>, <0.659892, -1.004715, 0.641788>, 
      <0.637467, -0.954841, 0.531153>, <0.632740, -0.957561, 0.531378>, <0.630834, -0.963492, 0.529812>, <0.633269, -0.967899, 0.527705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.653812, -0.947830, 1.003414>, <0.649288, -0.950832, 1.003964>, <0.647851, -0.956397, 1.006832>, <0.650648, -0.960081, 1.009729>, 
      <0.673207, -0.984018, 0.973751>, <0.668683, -0.987020, 0.974301>, <0.667390, -0.993164, 0.976112>, <0.670187, -0.996848, 0.979009>, 
      <0.701609, -1.033682, 0.937739>, <0.696883, -1.036402, 0.937963>, <0.695369, -1.042175, 0.940051>, <0.698098, -1.046880, 0.940511>, 
      <0.722094, -1.070476, 0.909592>, <0.717367, -1.073196, 0.909817>, <0.715704, -1.079375, 0.910386>, <0.718433, -1.084079, 0.910845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.573783, -0.793750, 1.136424>, <0.569259, -0.796752, 1.136974>, <0.567677, -0.802015, 1.140300>, <0.570300, -0.805336, 1.143747>, 
      <0.596643, -0.836717, 1.092418>, <0.592119, -0.839720, 1.092968>, <0.590639, -0.845189, 1.096013>, <0.593263, -0.848511, 1.099460>, 
      <0.628688, -0.900951, 1.041840>, <0.624164, -0.903954, 1.042390>, <0.622937, -0.909518, 1.046002>, <0.625735, -0.913202, 1.048899>, 
      <0.653812, -0.947830, 1.003414>, <0.649288, -0.950832, 1.003964>, <0.647851, -0.956397, 1.006832>, <0.650648, -0.960081, 1.009729>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.513091, -0.683327, 1.274308>, <0.508566, -0.686330, 1.274858>, <0.506886, -0.691401, 1.278425>, <0.509391, -0.694491, 1.282162>, 
      <0.531298, -0.716454, 1.232943>, <0.526774, -0.719457, 1.233493>, <0.525158, -0.724654, 1.236901>, <0.527664, -0.727745, 1.240637>, 
      <0.554261, -0.757055, 1.174006>, <0.549736, -0.760058, 1.174556>, <0.548099, -0.765205, 1.178058>, <0.550722, -0.768526, 1.181505>, 
      <0.573783, -0.793750, 1.136424>, <0.569259, -0.796752, 1.136974>, <0.567677, -0.802015, 1.140300>, <0.570300, -0.805336, 1.143747>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.429510, -0.813089, 0.100319>, <-0.431941, -0.817312, 0.097859>, <-0.430030, -0.823097, 0.095824>, <-0.425303, -0.825825, 0.095837>, 
      <-0.402378, -0.766611, -0.006296>, <-0.404809, -0.770833, -0.008755>, <-0.402902, -0.776624, -0.010778>, <-0.398175, -0.779353, -0.010765>, 
      <-0.366809, -0.705692, -0.149058>, <-0.369246, -0.709925, -0.151494>, <-0.367337, -0.715713, -0.153523>, <-0.362610, -0.718442, -0.153509>, 
      <-0.339937, -0.659664, -0.255934>, <-0.342374, -0.663898, -0.258369>, <-0.340468, -0.669691, -0.260385>, <-0.335742, -0.672420, -0.260372>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521981, -0.971522, 0.459422>, <-0.524406, -0.975734, 0.456939>, <-0.522490, -0.981510, 0.454884>, <-0.517764, -0.984239, 0.454897>, 
      <-0.495321, -0.925844, 0.350622>, <-0.497746, -0.930057, 0.348139>, <-0.495903, -0.935959, 0.346029>, <-0.491176, -0.938688, 0.346042>, 
      <-0.456992, -0.860169, 0.208313>, <-0.459423, -0.864392, 0.205854>, <-0.457509, -0.870171, 0.203805>, <-0.452782, -0.872900, 0.203819>, 
      <-0.429510, -0.813089, 0.100319>, <-0.431941, -0.817312, 0.097859>, <-0.430030, -0.823097, 0.095824>, <-0.425303, -0.825825, 0.095837>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608550, -1.119841, 0.830978>, <-0.611279, -1.124568, 0.831026>, <-0.609616, -1.130772, 0.831077>, <-0.604889, -1.133501, 0.831090>, 
      <-0.582580, -1.075346, 0.719511>, <-0.585308, -1.080072, 0.719559>, <-0.583479, -1.085994, 0.718219>, <-0.578752, -1.088723, 0.718232>, 
      <-0.549044, -1.017888, 0.569862>, <-0.551468, -1.022100, 0.567379>, <-0.549790, -1.028282, 0.566653>, <-0.545063, -1.031011, 0.566666>, 
      <-0.521981, -0.971522, 0.459422>, <-0.524406, -0.975734, 0.456939>, <-0.522490, -0.981510, 0.454884>, <-0.517764, -0.984239, 0.454897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.542930, -1.003684, 0.940293>, <-0.544929, -1.008067, 0.942858>, <-0.542519, -1.013711, 0.944755>, <-0.537624, -1.016110, 0.944469>, 
      <-0.562562, -1.037580, 0.906485>, <-0.564560, -1.041964, 0.909050>, <-0.562608, -1.048181, 0.909931>, <-0.557713, -1.050579, 0.909645>, 
      <-0.588864, -1.084994, 0.863773>, <-0.591593, -1.089721, 0.863820>, <-0.589437, -1.095555, 0.865090>, <-0.584710, -1.098284, 0.865104>, 
      <-0.608550, -1.119841, 0.830978>, <-0.611279, -1.124568, 0.831026>, <-0.609616, -1.130772, 0.831077>, <-0.604889, -1.133501, 0.831090>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.459717, -0.862862, 1.087287>, <-0.461531, -0.866939, 1.090431>, <-0.458967, -0.872327, 1.092809>, <-0.454073, -0.874725, 1.092523>, 
      <-0.482893, -0.903052, 1.040380>, <-0.484707, -0.907128, 1.043524>, <-0.482249, -0.912695, 1.045602>, <-0.477354, -0.915093, 1.045316>, 
      <-0.517899, -0.960465, 0.983400>, <-0.519897, -0.964848, 0.985965>, <-0.517355, -0.970535, 0.988375>, <-0.512460, -0.972933, 0.988089>, 
      <-0.542930, -1.003684, 0.940293>, <-0.544929, -1.008067, 0.942858>, <-0.542519, -1.013711, 0.944755>, <-0.537624, -1.016110, 0.944469>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.407708, -0.769198, 1.213977>, <-0.409403, -0.773070, 1.217430>, <-0.406741, -0.778288, 1.220066>, <-0.401847, -0.780686, 1.219780>, 
      <-0.423310, -0.797297, 1.175970>, <-0.425006, -0.801169, 1.179423>, <-0.422409, -0.806499, 1.181889>, <-0.417515, -0.808898, 1.181603>, 
      <-0.442231, -0.832541, 1.122677>, <-0.444045, -0.836617, 1.125821>, <-0.441422, -0.841906, 1.128384>, <-0.436528, -0.844304, 1.128098>, 
      <-0.459717, -0.862862, 1.087287>, <-0.461531, -0.866939, 1.090431>, <-0.458967, -0.872327, 1.092809>, <-0.454073, -0.874725, 1.092523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.425303, -0.825825, 0.095837>, <-0.420576, -0.828554, 0.095850>, <-0.414620, -0.827311, 0.097908>, <-0.412189, -0.823088, 0.100368>, 
      <-0.398175, -0.779353, -0.010765>, <-0.393448, -0.782082, -0.010751>, <-0.387488, -0.780833, -0.008707>, <-0.385057, -0.776610, -0.006247>, 
      <-0.362610, -0.718442, -0.153509>, <-0.357883, -0.721170, -0.153496>, <-0.351925, -0.719924, -0.151445>, <-0.349488, -0.715691, -0.149009>, 
      <-0.335742, -0.672420, -0.260372>, <-0.331015, -0.675149, -0.260359>, <-0.325053, -0.673897, -0.258321>, <-0.322616, -0.669664, -0.255885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.517764, -0.984239, 0.454897>, <-0.513037, -0.986968, 0.454910>, <-0.507085, -0.985733, 0.456987>, <-0.504660, -0.981521, 0.459470>, 
      <-0.491176, -0.938688, 0.346042>, <-0.486449, -0.941417, 0.346056>, <-0.480425, -0.940056, 0.348188>, <-0.478000, -0.935844, 0.350671>, 
      <-0.452782, -0.872900, 0.203819>, <-0.448055, -0.875629, 0.203832>, <-0.442102, -0.874391, 0.205902>, <-0.439671, -0.870168, 0.208362>, 
      <-0.425303, -0.825825, 0.095837>, <-0.420576, -0.828554, 0.095850>, <-0.414620, -0.827311, 0.097908>, <-0.412189, -0.823088, 0.100368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.604889, -1.133501, 0.831090>, <-0.600163, -1.136230, 0.831103>, <-0.593958, -1.134567, 0.831075>, <-0.591229, -1.129841, 0.831027>, 
      <-0.578752, -1.088723, 0.718232>, <-0.574025, -1.091451, 0.718245>, <-0.567987, -1.090071, 0.719608>, <-0.565259, -1.085345, 0.719560>, 
      <-0.545063, -1.031011, 0.566666>, <-0.540337, -1.033739, 0.566679>, <-0.534148, -1.032099, 0.567428>, <-0.531723, -1.027887, 0.569911>, 
      <-0.517764, -0.984239, 0.454897>, <-0.513037, -0.986968, 0.454910>, <-0.507085, -0.985733, 0.456987>, <-0.504660, -0.981521, 0.459470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.537624, -1.016110, 0.944469>, <-0.532730, -1.018509, 0.944183>, <-0.526994, -1.016857, 0.941810>, <-0.524995, -1.012473, 0.939245>, 
      <-0.557713, -1.050579, 0.909645>, <-0.552819, -1.052978, 0.909359>, <-0.546732, -1.050957, 0.908103>, <-0.544734, -1.046573, 0.905538>, 
      <-0.584710, -1.098284, 0.865104>, <-0.579983, -1.101012, 0.865117>, <-0.574088, -1.099357, 0.863540>, <-0.571359, -1.094630, 0.863493>, 
      <-0.604889, -1.133501, 0.831090>, <-0.600163, -1.136230, 0.831103>, <-0.593958, -1.134567, 0.831075>, <-0.591229, -1.129841, 0.831027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454073, -0.874725, 1.092523>, <-0.449178, -0.877124, 1.092237>, <-0.443596, -0.875728, 1.089383>, <-0.441782, -0.871652, 1.086239>, 
      <-0.477354, -0.915093, 1.045316>, <-0.472460, -0.917492, 1.045030>, <-0.466772, -0.915917, 1.042475>, <-0.464958, -0.911841, 1.039331>, 
      <-0.512460, -0.972933, 0.988089>, <-0.507566, -0.975332, 0.987803>, <-0.501880, -0.973468, 0.984698>, <-0.499881, -0.969085, 0.982133>, 
      <-0.537624, -1.016110, 0.944469>, <-0.532730, -1.018509, 0.944183>, <-0.526994, -1.016857, 0.941810>, <-0.524995, -1.012473, 0.939245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.401847, -0.780686, 1.219780>, <-0.396952, -0.783085, 1.219494>, <-0.391469, -0.781859, 1.216382>, <-0.389773, -0.777987, 1.212929>, 
      <-0.417515, -0.808898, 1.181603>, <-0.412620, -0.811296, 1.181317>, <-0.407071, -0.809958, 1.178375>, <-0.405376, -0.806086, 1.174922>, 
      <-0.436528, -0.844304, 1.128098>, <-0.431633, -0.846703, 1.127812>, <-0.426110, -0.845407, 1.124773>, <-0.424297, -0.841330, 1.121629>, 
      <-0.454073, -0.874725, 1.092523>, <-0.449178, -0.877124, 1.092237>, <-0.443596, -0.875728, 1.089383>, <-0.441782, -0.871652, 1.086239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.412189, -0.823088, 0.100368>, <-0.409758, -0.818866, 0.102827>, <-0.411669, -0.813081, 0.104863>, <-0.416395, -0.810352, 0.104849>, 
      <-0.385057, -0.776610, -0.006247>, <-0.382627, -0.772387, -0.003788>, <-0.384534, -0.766597, -0.001765>, <-0.389261, -0.763868, -0.001778>, 
      <-0.349488, -0.715691, -0.149009>, <-0.347051, -0.711458, -0.146574>, <-0.348960, -0.705670, -0.144544>, <-0.353687, -0.702941, -0.144558>, 
      <-0.322616, -0.669664, -0.255885>, <-0.320180, -0.665431, -0.253449>, <-0.322085, -0.659637, -0.251433>, <-0.326812, -0.656908, -0.251447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.504660, -0.981521, 0.459470>, <-0.502235, -0.977308, 0.461953>, <-0.504151, -0.971532, 0.464008>, <-0.508878, -0.968803, 0.463995>, 
      <-0.478000, -0.935844, 0.350671>, <-0.475575, -0.931631, 0.353153>, <-0.477417, -0.925727, 0.355264>, <-0.482144, -0.922998, 0.355251>, 
      <-0.439671, -0.870168, 0.208362>, <-0.437240, -0.865945, 0.210822>, <-0.439154, -0.860166, 0.212870>, <-0.443881, -0.857437, 0.212857>, 
      <-0.412189, -0.823088, 0.100368>, <-0.409758, -0.818866, 0.102827>, <-0.411669, -0.813081, 0.104863>, <-0.416395, -0.810352, 0.104849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.591229, -1.129841, 0.831027>, <-0.588501, -1.125114, 0.830980>, <-0.590163, -1.118910, 0.830929>, <-0.594890, -1.116181, 0.830916>, 
      <-0.565259, -1.085345, 0.719560>, <-0.562530, -1.080618, 0.719513>, <-0.564360, -1.074696, 0.720853>, <-0.569087, -1.071968, 0.720839>, 
      <-0.531723, -1.027887, 0.569911>, <-0.529298, -1.023675, 0.572394>, <-0.530975, -1.017492, 0.573121>, <-0.535702, -1.014763, 0.573108>, 
      <-0.504660, -0.981521, 0.459470>, <-0.502235, -0.977308, 0.461953>, <-0.504151, -0.971532, 0.464008>, <-0.508878, -0.968803, 0.463995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.524995, -1.012473, 0.939245>, <-0.522997, -1.008089, 0.936680>, <-0.525407, -1.002445, 0.934783>, <-0.530302, -1.000047, 0.935069>, 
      <-0.544734, -1.046573, 0.905538>, <-0.542735, -1.042190, 0.902973>, <-0.544691, -1.035974, 0.902079>, <-0.549586, -1.033575, 0.902365>, 
      <-0.571359, -1.094630, 0.863493>, <-0.568631, -1.089904, 0.863445>, <-0.570787, -1.084070, 0.862175>, <-0.575514, -1.081341, 0.862162>, 
      <-0.591229, -1.129841, 0.831027>, <-0.588501, -1.125114, 0.830980>, <-0.590163, -1.118910, 0.830929>, <-0.594890, -1.116181, 0.830916>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.441782, -0.871652, 1.086239>, <-0.439968, -0.867575, 1.083095>, <-0.442532, -0.862187, 1.080717>, <-0.447426, -0.859789, 1.081003>, 
      <-0.464958, -0.911841, 1.039331>, <-0.463144, -0.907765, 1.036188>, <-0.465602, -0.902198, 1.034109>, <-0.470497, -0.899799, 1.034395>, 
      <-0.499881, -0.969085, 0.982133>, <-0.497883, -0.964701, 0.979568>, <-0.500426, -0.959012, 0.977149>, <-0.505321, -0.956613, 0.977435>, 
      <-0.524995, -1.012473, 0.939245>, <-0.522997, -1.008089, 0.936680>, <-0.525407, -1.002445, 0.934783>, <-0.530302, -1.000047, 0.935069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389773, -0.777987, 1.212929>, <-0.388077, -0.774115, 1.209476>, <-0.390739, -0.768897, 1.206840>, <-0.395633, -0.766498, 1.207127>, 
      <-0.405376, -0.806086, 1.174922>, <-0.403680, -0.802215, 1.171469>, <-0.406277, -0.796884, 1.169003>, <-0.411171, -0.794485, 1.169289>, 
      <-0.424297, -0.841330, 1.121629>, <-0.422483, -0.837254, 1.118485>, <-0.425106, -0.831966, 1.115921>, <-0.430000, -0.829568, 1.116207>, 
      <-0.441782, -0.871652, 1.086239>, <-0.439968, -0.867575, 1.083095>, <-0.442532, -0.862187, 1.080717>, <-0.447426, -0.859789, 1.081003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.416395, -0.810352, 0.104849>, <-0.421122, -0.807623, 0.104836>, <-0.427079, -0.808866, 0.102778>, <-0.429510, -0.813089, 0.100319>, 
      <-0.389261, -0.763868, -0.001778>, <-0.393988, -0.761139, -0.001792>, <-0.399947, -0.762388, -0.003836>, <-0.402378, -0.766611, -0.006296>, 
      <-0.353687, -0.702941, -0.144558>, <-0.358414, -0.700213, -0.144571>, <-0.364372, -0.701459, -0.146622>, <-0.366809, -0.705692, -0.149058>, 
      <-0.326812, -0.656908, -0.251447>, <-0.331539, -0.654180, -0.251460>, <-0.337500, -0.655431, -0.253498>, <-0.339937, -0.659664, -0.255934>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.508878, -0.968803, 0.463995>, <-0.513605, -0.966074, 0.463982>, <-0.519556, -0.967309, 0.461905>, <-0.521981, -0.971522, 0.459422>, 
      <-0.482144, -0.922998, 0.355251>, <-0.486871, -0.920270, 0.355237>, <-0.492896, -0.921632, 0.353105>, <-0.495321, -0.925844, 0.350622>, 
      <-0.443881, -0.857437, 0.212857>, <-0.448608, -0.854709, 0.212843>, <-0.454561, -0.855946, 0.210773>, <-0.456992, -0.860169, 0.208313>, 
      <-0.416395, -0.810352, 0.104849>, <-0.421122, -0.807623, 0.104836>, <-0.427079, -0.808866, 0.102778>, <-0.429510, -0.813089, 0.100319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.594890, -1.116181, 0.830916>, <-0.599617, -1.113452, 0.830902>, <-0.605822, -1.115115, 0.830931>, <-0.608550, -1.119841, 0.830978>, 
      <-0.569087, -1.071968, 0.720839>, <-0.573813, -1.069239, 0.720826>, <-0.579851, -1.070619, 0.719464>, <-0.582580, -1.075346, 0.719511>, 
      <-0.535702, -1.014763, 0.573108>, <-0.540429, -1.012034, 0.573095>, <-0.546619, -1.013675, 0.572345>, <-0.549044, -1.017888, 0.569862>, 
      <-0.508878, -0.968803, 0.463995>, <-0.513605, -0.966074, 0.463982>, <-0.519556, -0.967309, 0.461905>, <-0.521981, -0.971522, 0.459422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530302, -1.000047, 0.935069>, <-0.535196, -0.997648, 0.935355>, <-0.540932, -0.999300, 0.937728>, <-0.542930, -1.003684, 0.940293>, 
      <-0.549586, -1.033575, 0.902365>, <-0.554480, -1.031177, 0.902651>, <-0.560563, -1.033196, 0.903920>, <-0.562562, -1.037580, 0.906485>, 
      <-0.575514, -1.081341, 0.862162>, <-0.580241, -1.078612, 0.862148>, <-0.586136, -1.080267, 0.863725>, <-0.588864, -1.084994, 0.863773>, 
      <-0.594890, -1.116181, 0.830916>, <-0.599617, -1.113452, 0.830902>, <-0.605822, -1.115115, 0.830931>, <-0.608550, -1.119841, 0.830978>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447426, -0.859789, 1.081003>, <-0.452320, -0.857390, 1.081289>, <-0.457903, -0.858786, 1.084143>, <-0.459717, -0.862862, 1.087287>, 
      <-0.470497, -0.899799, 1.034395>, <-0.475391, -0.897401, 1.034681>, <-0.481079, -0.898975, 1.037236>, <-0.482893, -0.903052, 1.040380>, 
      <-0.505321, -0.956613, 0.977435>, <-0.510215, -0.954214, 0.977721>, <-0.515901, -0.956081, 0.980835>, <-0.517899, -0.960465, 0.983400>, 
      <-0.530302, -1.000047, 0.935069>, <-0.535196, -0.997648, 0.935355>, <-0.540932, -0.999300, 0.937728>, <-0.542930, -1.003684, 0.940293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.395633, -0.766498, 1.207127>, <-0.400528, -0.764100, 1.207413>, <-0.406012, -0.765326, 1.210524>, <-0.407708, -0.769198, 1.213977>, 
      <-0.411171, -0.794485, 1.169289>, <-0.416066, -0.792087, 1.169576>, <-0.421615, -0.793425, 1.172517>, <-0.423310, -0.797297, 1.175970>, 
      <-0.430000, -0.829568, 1.116207>, <-0.434894, -0.827169, 1.116493>, <-0.440417, -0.828465, 1.119533>, <-0.442231, -0.832541, 1.122677>, 
      <-0.447426, -0.859789, 1.081003>, <-0.452320, -0.857390, 1.081289>, <-0.457903, -0.858786, 1.084143>, <-0.459717, -0.862862, 1.087287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.145078, 0.897548, 0.098382>, <-0.147470, 0.901691, 0.095754>, <-0.153393, 0.902868, 0.093568>, <-0.158120, 0.900139, 0.093568>, 
      <-0.116330, 0.847755, -0.006295>, <-0.118721, 0.851898, -0.008922>, <-0.124649, 0.853081, -0.011096>, <-0.129376, 0.850352, -0.011096>, 
      <-0.078595, 0.782397, -0.146515>, <-0.080993, 0.786551, -0.149119>, <-0.086919, 0.787731, -0.151299>, <-0.091646, 0.785002, -0.151299>, 
      <-0.050102, 0.733046, -0.251470>, <-0.052500, 0.737200, -0.254075>, <-0.058430, 0.738386, -0.256242>, <-0.063157, 0.735657, -0.256242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.242994, 1.067145, 0.450882>, <-0.245380, 1.071277, 0.448231>, <-0.251298, 1.072444, 0.446025>, <-0.256025, 1.069715, 0.446025>, 
      <-0.211691, 1.012926, 0.347369>, <-0.214076, 1.017058, 0.344718>, <-0.220090, 1.018390, 0.342414>, <-0.224817, 1.015661, 0.342414>, 
      <-0.174198, 0.947986, 0.204414>, <-0.176590, 0.952129, 0.201786>, <-0.182510, 0.953299, 0.199587>, <-0.187237, 0.950570, 0.199587>, 
      <-0.145078, 0.897548, 0.098382>, <-0.147470, 0.901691, 0.095754>, <-0.153393, 0.902868, 0.093568>, <-0.158120, 0.900139, 0.093568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334661, 1.225916, 0.725291>, <-0.337389, 1.230641, 0.725149>, <-0.343593, 1.232302, 0.725030>, <-0.348319, 1.229573, 0.725030>, 
      <-0.307161, 1.178285, 0.642968>, <-0.309889, 1.183010, 0.642826>, <-0.315904, 1.184345, 0.641329>, <-0.320631, 1.181616, 0.641329>, 
      <-0.268613, 1.111518, 0.535597>, <-0.270999, 1.115650, 0.532947>, <-0.277192, 1.117294, 0.531993>, <-0.281919, 1.114565, 0.531993>, 
      <-0.242994, 1.067145, 0.450882>, <-0.245380, 1.071277, 0.448231>, <-0.251298, 1.072444, 0.446025>, <-0.256025, 1.069715, 0.446025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.269054, 1.114238, 0.839187>, <-0.271900, 1.118233, 0.841582>, <-0.278028, 1.119021, 0.843338>, <-0.282547, 1.115973, 0.843051>, 
      <-0.287920, 1.147190, 0.804036>, <-0.290766, 1.151185, 0.806431>, <-0.297142, 1.152625, 0.807147>, <-0.301661, 1.149578, 0.806860>, 
      <-0.314979, 1.192413, 0.759460>, <-0.317707, 1.197138, 0.759317>, <-0.323861, 1.198222, 0.760437>, <-0.328588, 1.195493, 0.760437>, 
      <-0.334661, 1.225916, 0.725291>, <-0.337389, 1.230641, 0.725149>, <-0.343593, 1.232302, 0.725030>, <-0.348319, 1.229573, 0.725030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.191630, 0.976098, 0.991782>, <-0.194313, 0.979796, 0.994768>, <-0.200306, 0.980337, 0.997015>, <-0.204825, 0.977289, 0.996729>, 
      <-0.214665, 1.012185, 0.941584>, <-0.217348, 1.015882, 0.944571>, <-0.223433, 1.016589, 0.946507>, <-0.227952, 1.013542, 0.946221>, 
      <-0.244999, 1.072224, 0.884006>, <-0.247844, 1.076218, 0.886401>, <-0.254086, 1.076927, 0.888670>, <-0.258605, 1.073879, 0.888384>, 
      <-0.269054, 1.114238, 0.839187>, <-0.271900, 1.118233, 0.841582>, <-0.278028, 1.119021, 0.843338>, <-0.282547, 1.115973, 0.843051>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.151131, 0.929498, 1.096164>, <-0.153702, 0.933000, 1.099467>, <-0.159602, 0.933379, 1.101978>, <-0.164121, 0.930331, 1.101692>, 
      <-0.163281, 0.943478, 1.064849>, <-0.165852, 0.946980, 1.068153>, <-0.171814, 0.947466, 1.070489>, <-0.176332, 0.944418, 1.070203>, 
      <-0.178927, 0.956198, 1.019463>, <-0.181611, 0.959895, 1.022450>, <-0.187548, 0.960337, 1.024879>, <-0.192067, 0.957290, 1.024592>, 
      <-0.191630, 0.976098, 0.991782>, <-0.194313, 0.979796, 0.994768>, <-0.200306, 0.980337, 0.997015>, <-0.204825, 0.977289, 0.996729>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.158120, 0.900139, 0.093568>, <-0.162847, 0.897410, 0.093568>, <-0.164790, 0.891691, 0.095754>, <-0.162398, 0.887548, 0.098382>, 
      <-0.129376, 0.850352, -0.011096>, <-0.134103, 0.847623, -0.011096>, <-0.136042, 0.841898, -0.008922>, <-0.133650, 0.837755, -0.006295>, 
      <-0.091646, 0.785002, -0.151299>, <-0.096372, 0.782273, -0.151299>, <-0.098314, 0.776551, -0.149119>, <-0.095915, 0.772397, -0.146515>, 
      <-0.063157, 0.735657, -0.256242>, <-0.067883, 0.732928, -0.256242>, <-0.069821, 0.727200, -0.254075>, <-0.067423, 0.723046, -0.251470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.256025, 1.069715, 0.446025>, <-0.260752, 1.066986, 0.446025>, <-0.262700, 1.061277, 0.448231>, <-0.260315, 1.057145, 0.450882>, 
      <-0.224817, 1.015661, 0.342414>, <-0.229544, 1.012932, 0.342414>, <-0.231397, 1.007058, 0.344718>, <-0.229011, 1.002926, 0.347369>, 
      <-0.187237, 0.950570, 0.199587>, <-0.191964, 0.947841, 0.199587>, <-0.193910, 0.942129, 0.201786>, <-0.191518, 0.937986, 0.204414>, 
      <-0.158120, 0.900139, 0.093568>, <-0.162847, 0.897410, 0.093568>, <-0.164790, 0.891691, 0.095754>, <-0.162398, 0.887548, 0.098382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.348319, 1.229573, 0.725030>, <-0.353046, 1.226844, 0.725030>, <-0.354709, 1.220641, 0.725149>, <-0.351981, 1.215916, 0.725291>, 
      <-0.320631, 1.181616, 0.641329>, <-0.325358, 1.178887, 0.641329>, <-0.327209, 1.173010, 0.642826>, <-0.324481, 1.168284, 0.642968>, 
      <-0.281919, 1.114565, 0.531993>, <-0.286646, 1.111836, 0.531993>, <-0.288319, 1.105650, 0.532947>, <-0.285934, 1.101518, 0.535597>, 
      <-0.256025, 1.069715, 0.446025>, <-0.260752, 1.066986, 0.446025>, <-0.262700, 1.061277, 0.448231>, <-0.260315, 1.057145, 0.450882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.282547, 1.115973, 0.843051>, <-0.287066, 1.112925, 0.842765>, <-0.288458, 1.107065, 0.840533>, <-0.285612, 1.103071, 0.838138>, 
      <-0.301661, 1.149578, 0.806860>, <-0.306179, 1.146530, 0.806574>, <-0.307449, 1.140214, 0.805475>, <-0.304604, 1.136220, 0.803080>, 
      <-0.328588, 1.195493, 0.760437>, <-0.333314, 1.192764, 0.760437>, <-0.334799, 1.186788, 0.759003>, <-0.332071, 1.182062, 0.759145>, 
      <-0.348319, 1.229573, 0.725030>, <-0.353046, 1.226844, 0.725030>, <-0.354709, 1.220641, 0.725149>, <-0.351981, 1.215916, 0.725291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.204825, 0.977289, 0.996729>, <-0.209344, 0.974241, 0.996442>, <-0.210872, 0.968628, 0.993719>, <-0.208189, 0.964931, 0.990733>, 
      <-0.227952, 1.013542, 0.946221>, <-0.232471, 1.010494, 0.945934>, <-0.233906, 1.004715, 0.943522>, <-0.231224, 1.001017, 0.940535>, 
      <-0.258605, 1.073879, 0.888384>, <-0.263124, 1.070832, 0.888098>, <-0.264294, 1.064888, 0.885140>, <-0.261448, 1.060893, 0.882745>, 
      <-0.282547, 1.115973, 0.843051>, <-0.287066, 1.112925, 0.842765>, <-0.288458, 1.107065, 0.840533>, <-0.285612, 1.103071, 0.838138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164121, 0.930331, 1.101692>, <-0.168640, 0.927283, 1.101406>, <-0.170261, 0.921833, 1.098418>, <-0.167689, 0.918331, 1.095115>, 
      <-0.176332, 0.944418, 1.070203>, <-0.180851, 0.941371, 1.069917>, <-0.182411, 0.935813, 1.067104>, <-0.179839, 0.932311, 1.063800>, 
      <-0.192067, 0.957290, 1.024592>, <-0.196586, 0.954242, 1.024306>, <-0.198169, 0.948728, 1.021401>, <-0.195486, 0.945030, 1.018414>, 
      <-0.204825, 0.977289, 0.996729>, <-0.209344, 0.974241, 0.996442>, <-0.210872, 0.968628, 0.993719>, <-0.208189, 0.964931, 0.990733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.162398, 0.887548, 0.098382>, <-0.160006, 0.883405, 0.101010>, <-0.154082, 0.882229, 0.103196>, <-0.149355, 0.884958, 0.103196>, 
      <-0.133650, 0.837755, -0.006295>, <-0.131258, 0.833612, -0.003667>, <-0.125331, 0.832429, -0.001493>, <-0.120604, 0.835158, -0.001493>, 
      <-0.095915, 0.772397, -0.146515>, <-0.093517, 0.768243, -0.143910>, <-0.087591, 0.767063, -0.141730>, <-0.082864, 0.769792, -0.141730>, 
      <-0.067423, 0.723046, -0.251470>, <-0.065024, 0.718892, -0.248866>, <-0.059095, 0.717706, -0.246699>, <-0.054368, 0.720435, -0.246699>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.260315, 1.057145, 0.450882>, <-0.257929, 1.053013, 0.453532>, <-0.252010, 1.051845, 0.455738>, <-0.247284, 1.054574, 0.455738>, 
      <-0.229011, 1.002926, 0.347369>, <-0.226626, 0.998794, 0.350019>, <-0.220611, 0.997459, 0.352325>, <-0.215884, 1.000188, 0.352325>, 
      <-0.191518, 0.937986, 0.204414>, <-0.189126, 0.933843, 0.207041>, <-0.183206, 0.932672, 0.209241>, <-0.178479, 0.935401, 0.209241>, 
      <-0.162398, 0.887548, 0.098382>, <-0.160006, 0.883405, 0.101010>, <-0.154082, 0.882229, 0.103196>, <-0.149355, 0.884958, 0.103196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.351981, 1.215916, 0.725291>, <-0.349253, 1.211191, 0.725434>, <-0.343050, 1.209530, 0.725552>, <-0.338323, 1.212259, 0.725552>, 
      <-0.324481, 1.168284, 0.642968>, <-0.321753, 1.163559, 0.643111>, <-0.315738, 1.162224, 0.644608>, <-0.311011, 1.164953, 0.644608>, 
      <-0.285934, 1.101518, 0.535597>, <-0.283548, 1.097386, 0.538248>, <-0.277353, 1.095741, 0.539204>, <-0.272627, 1.098470, 0.539204>, 
      <-0.260315, 1.057145, 0.450882>, <-0.257929, 1.053013, 0.453532>, <-0.252010, 1.051845, 0.455738>, <-0.247284, 1.054574, 0.455738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.285612, 1.103071, 0.838138>, <-0.282767, 1.099077, 0.835742>, <-0.276639, 1.098289, 0.833987>, <-0.272120, 1.101337, 0.834273>, 
      <-0.304604, 1.136220, 0.803080>, <-0.301758, 1.132226, 0.800684>, <-0.295382, 1.130788, 0.799956>, <-0.290863, 1.133836, 0.800242>, 
      <-0.332071, 1.182062, 0.759145>, <-0.329343, 1.177337, 0.759288>, <-0.323189, 1.176253, 0.758169>, <-0.318462, 1.178982, 0.758169>, 
      <-0.351981, 1.215916, 0.725291>, <-0.349253, 1.211191, 0.725434>, <-0.343050, 1.209530, 0.725552>, <-0.338323, 1.212259, 0.725552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.208189, 0.964931, 0.990733>, <-0.205506, 0.961233, 0.987746>, <-0.199513, 0.960692, 0.985499>, <-0.194994, 0.963739, 0.985785>, 
      <-0.231224, 1.001017, 0.940535>, <-0.228541, 0.997320, 0.937549>, <-0.222456, 0.996613, 0.935613>, <-0.217937, 0.999660, 0.935899>, 
      <-0.261448, 1.060893, 0.882745>, <-0.258603, 1.056899, 0.880349>, <-0.252358, 1.056189, 0.878071>, <-0.247839, 1.059237, 0.878358>, 
      <-0.285612, 1.103071, 0.838138>, <-0.282767, 1.099077, 0.835742>, <-0.276639, 1.098289, 0.833987>, <-0.272120, 1.101337, 0.834273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.167689, 0.918331, 1.095115>, <-0.165118, 0.914829, 1.091811>, <-0.159218, 0.914450, 1.089300>, <-0.154699, 0.917498, 1.089587>, 
      <-0.179839, 0.932311, 1.063800>, <-0.177268, 0.928809, 1.060497>, <-0.171306, 0.928323, 1.058160>, <-0.166788, 0.931370, 1.058446>, 
      <-0.195486, 0.945030, 1.018414>, <-0.192803, 0.941333, 1.015428>, <-0.186865, 0.940890, 1.012999>, <-0.182346, 0.943938, 1.013285>, 
      <-0.208189, 0.964931, 0.990733>, <-0.205506, 0.961233, 0.987746>, <-0.199513, 0.960692, 0.985499>, <-0.194994, 0.963739, 0.985785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.149355, 0.884958, 0.103196>, <-0.144629, 0.887687, 0.103196>, <-0.142686, 0.893405, 0.101010>, <-0.145078, 0.897548, 0.098382>, 
      <-0.120604, 0.835158, -0.001493>, <-0.115877, 0.837887, -0.001493>, <-0.113938, 0.843612, -0.003667>, <-0.116330, 0.847755, -0.006295>, 
      <-0.082864, 0.769792, -0.141730>, <-0.078138, 0.772521, -0.141730>, <-0.076197, 0.778243, -0.143910>, <-0.078595, 0.782397, -0.146515>, 
      <-0.054368, 0.720435, -0.246699>, <-0.049642, 0.723164, -0.246699>, <-0.047704, 0.728892, -0.248866>, <-0.050102, 0.733046, -0.251470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247284, 1.054574, 0.455738>, <-0.242557, 1.057303, 0.455738>, <-0.240609, 1.063013, 0.453532>, <-0.242994, 1.067145, 0.450882>, 
      <-0.215884, 1.000188, 0.352325>, <-0.211157, 1.002917, 0.352325>, <-0.209305, 1.008794, 0.350019>, <-0.211691, 1.012926, 0.347369>, 
      <-0.178479, 0.935401, 0.209241>, <-0.173752, 0.938130, 0.209241>, <-0.171806, 0.943843, 0.207041>, <-0.174198, 0.947986, 0.204414>, 
      <-0.149355, 0.884958, 0.103196>, <-0.144629, 0.887687, 0.103196>, <-0.142686, 0.893405, 0.101010>, <-0.145078, 0.897548, 0.098382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.338323, 1.212259, 0.725552>, <-0.333596, 1.214988, 0.725552>, <-0.331933, 1.221191, 0.725434>, <-0.334661, 1.225916, 0.725291>, 
      <-0.311011, 1.164953, 0.644608>, <-0.306284, 1.167682, 0.644608>, <-0.304433, 1.173559, 0.643111>, <-0.307161, 1.178285, 0.642968>, 
      <-0.272627, 1.098470, 0.539204>, <-0.267900, 1.101199, 0.539204>, <-0.266227, 1.107386, 0.538248>, <-0.268613, 1.111518, 0.535597>, 
      <-0.247284, 1.054574, 0.455738>, <-0.242557, 1.057303, 0.455738>, <-0.240609, 1.063013, 0.453532>, <-0.242994, 1.067145, 0.450882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.272120, 1.101337, 0.834273>, <-0.267601, 1.104384, 0.834560>, <-0.266208, 1.110244, 0.836791>, <-0.269054, 1.114238, 0.839187>, 
      <-0.290863, 1.133836, 0.800242>, <-0.286344, 1.136883, 0.800529>, <-0.285075, 1.143196, 0.801640>, <-0.287920, 1.147190, 0.804036>, 
      <-0.318462, 1.178982, 0.758169>, <-0.313735, 1.181711, 0.758169>, <-0.312251, 1.187688, 0.759602>, <-0.314979, 1.192413, 0.759460>, 
      <-0.338323, 1.212259, 0.725552>, <-0.333596, 1.214988, 0.725552>, <-0.331933, 1.221191, 0.725434>, <-0.334661, 1.225916, 0.725291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.194994, 0.963739, 0.985785>, <-0.190475, 0.966787, 0.986072>, <-0.188947, 0.972400, 0.988795>, <-0.191630, 0.976098, 0.991782>, 
      <-0.217937, 0.999660, 0.935899>, <-0.213418, 1.002708, 0.936185>, <-0.211982, 1.008487, 0.938598>, <-0.214665, 1.012185, 0.941584>, 
      <-0.247839, 1.059237, 0.878358>, <-0.243321, 1.062284, 0.878644>, <-0.242153, 1.068230, 0.881610>, <-0.244999, 1.072224, 0.884006>, 
      <-0.272120, 1.101337, 0.834273>, <-0.267601, 1.104384, 0.834560>, <-0.266208, 1.110244, 0.836791>, <-0.269054, 1.114238, 0.839187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.154699, 0.917498, 1.089587>, <-0.150180, 0.920546, 1.089873>, <-0.148560, 0.925996, 1.092860>, <-0.151131, 0.929498, 1.096164>, 
      <-0.166788, 0.931370, 1.058446>, <-0.162269, 0.934418, 1.058733>, <-0.160710, 0.939976, 1.061546>, <-0.163281, 0.943478, 1.064849>, 
      <-0.182346, 0.943938, 1.013285>, <-0.177828, 0.946986, 1.013572>, <-0.176245, 0.952500, 1.016477>, <-0.178927, 0.956198, 1.019463>, 
      <-0.194994, 0.963739, 0.985785>, <-0.190475, 0.966787, 0.986072>, <-0.188947, 0.972400, 0.988795>, <-0.191630, 0.976098, 0.991782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.937744, 0.010000, 0.098382>, <-0.942528, 0.010000, 0.095754>, <-0.946509, 0.005458, 0.093568>, <-0.946509, 0.000000, 0.093568>, 
      <-0.880248, 0.010000, -0.006295>, <-0.885032, 0.010000, -0.008922>, <-0.889020, 0.005458, -0.011096>, <-0.889020, 0.000000, -0.011096>, 
      <-0.804779, 0.010000, -0.146515>, <-0.809575, 0.010000, -0.149119>, <-0.813560, 0.005458, -0.151299>, <-0.813560, 0.000000, -0.151299>, 
      <-0.747793, 0.010000, -0.251470>, <-0.752590, 0.010000, -0.254075>, <-0.756582, 0.005458, -0.256242>, <-0.756582, 0.000000, -0.256242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.133577, 0.010000, 0.450882>, <-1.138349, 0.010000, 0.448231>, <-1.142319, 0.005458, 0.446025>, <-1.142319, 0.000000, 0.446025>, 
      <-1.074827, 0.010000, 0.345132>, <-1.079598, 0.010000, 0.342481>, <-1.083729, 0.005458, 0.340203>, <-1.083729, 0.000000, 0.340203>, 
      <-0.995985, 0.010000, 0.204414>, <-1.000768, 0.010000, 0.201786>, <-1.004742, 0.005458, 0.199587>, <-1.004742, 0.000000, 0.199587>, 
      <-0.937744, 0.010000, 0.098382>, <-0.942528, 0.010000, 0.095754>, <-0.946509, 0.005458, 0.093568>, <-0.946509, 0.000000, 0.093568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.316911, 0.010000, 0.780881>, <-1.322367, 0.010000, 0.780739>, <-1.326907, 0.005458, 0.780620>, <-1.326907, 0.000000, 0.780620>, 
      <-1.261911, 0.010000, 0.681882>, <-1.267367, 0.010000, 0.681739>, <-1.271531, 0.005458, 0.680242>, <-1.271531, 0.000000, 0.680242>, 
      <-1.188577, 0.010000, 0.549882>, <-1.193348, 0.010000, 0.547231>, <-1.197848, 0.005458, 0.546319>, <-1.197848, 0.000000, 0.546319>, 
      <-1.133577, 0.010000, 0.450882>, <-1.138349, 0.010000, 0.448231>, <-1.142319, 0.005458, 0.446025>, <-1.142319, 0.000000, 0.446025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.187392, 0.010978, 0.894777>, <-1.192274, 0.010511, 0.897173>, <-1.196020, 0.005598, 0.898928>, <-1.195640, 0.000160, 0.898641>, 
      <-1.225362, 0.011116, 0.859626>, <-1.230244, 0.010649, 0.862022>, <-1.234680, 0.005847, 0.862737>, <-1.234300, 0.000410, 0.862451>, 
      <-1.278055, 0.010294, 0.815050>, <-1.283511, 0.010294, 0.814908>, <-1.287527, 0.005506, 0.816027>, <-1.287527, 0.000048, 0.816027>, 
      <-1.316911, 0.010000, 0.780881>, <-1.322367, 0.010000, 0.780739>, <-1.326907, 0.005458, 0.780620>, <-1.326907, 0.000000, 0.780620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.029047, 0.008959, 1.047372>, <-1.033590, 0.008484, 1.050358>, <-1.037055, 0.003565, 1.052605>, <-1.036676, -0.001873, 1.052319>, 
      <-1.073281, 0.009310, 0.998424>, <-1.077824, 0.008835, 1.001411>, <-1.081483, 0.003918, 1.003348>, <-1.081103, -0.001519, 1.003062>, 
      <-1.138978, 0.010803, 0.939596>, <-1.143860, 0.010336, 0.941991>, <-1.147595, 0.005285, 0.944261>, <-1.147215, -0.000152, 0.943974>, 
      <-1.187392, 0.010978, 0.894777>, <-1.192274, 0.010511, 0.897173>, <-1.196020, 0.005598, 0.898928>, <-1.195640, 0.000160, 0.898641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.946027, 0.009065, 1.161861>, <-0.950346, 0.008589, 1.165165>, <-0.953623, 0.003669, 1.167676>, <-0.953243, -0.001768, 1.167389>, 
      <-0.970933, 0.009033, 1.127514>, <-0.975252, 0.008558, 1.130818>, <-0.978653, 0.003638, 1.133155>, <-0.978273, -0.001800, 1.132868>, 
      <-1.000601, 0.008734, 1.078849>, <-1.005145, 0.008259, 1.081835>, <-1.008497, 0.003337, 1.084268>, <-1.008117, -0.002100, 1.083982>, 
      <-1.029047, 0.008959, 1.047372>, <-1.033590, 0.008484, 1.050358>, <-1.037055, 0.003565, 1.052605>, <-1.036676, -0.001873, 1.052319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.946509, 0.000000, 0.093568>, <-0.946509, -0.005458, 0.093568>, <-0.942528, -0.010000, 0.095754>, <-0.937744, -0.010000, 0.098382>, 
      <-0.889020, 0.000000, -0.011096>, <-0.889020, -0.005458, -0.011096>, <-0.885032, -0.010000, -0.008922>, <-0.880248, -0.010000, -0.006295>, 
      <-0.813560, 0.000000, -0.151299>, <-0.813560, -0.005458, -0.151299>, <-0.809575, -0.010000, -0.149119>, <-0.804779, -0.010000, -0.146515>, 
      <-0.756582, 0.000000, -0.256242>, <-0.756582, -0.005458, -0.256242>, <-0.752590, -0.010000, -0.254075>, <-0.747793, -0.010000, -0.251470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.142319, 0.000000, 0.446025>, <-1.142319, -0.005458, 0.446025>, <-1.138349, -0.010000, 0.448231>, <-1.133577, -0.010000, 0.450882>, 
      <-1.083729, 0.000000, 0.340203>, <-1.083729, -0.005458, 0.340203>, <-1.079598, -0.010000, 0.342481>, <-1.074827, -0.010000, 0.345132>, 
      <-1.004742, 0.000000, 0.199587>, <-1.004742, -0.005458, 0.199587>, <-1.000768, -0.010000, 0.201786>, <-0.995985, -0.010000, 0.204414>, 
      <-0.946509, 0.000000, 0.093568>, <-0.946509, -0.005458, 0.093568>, <-0.942528, -0.010000, 0.095754>, <-0.937744, -0.010000, 0.098382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.326907, 0.000000, 0.780620>, <-1.326907, -0.005458, 0.780620>, <-1.322367, -0.010000, 0.780739>, <-1.316911, -0.010000, 0.780881>, 
      <-1.271531, 0.000000, 0.680242>, <-1.271531, -0.005458, 0.680242>, <-1.267367, -0.010000, 0.681739>, <-1.261911, -0.010000, 0.681882>, 
      <-1.197848, 0.000000, 0.546319>, <-1.197848, -0.005458, 0.546319>, <-1.193348, -0.010000, 0.547231>, <-1.188577, -0.010000, 0.549882>, 
      <-1.142319, 0.000000, 0.446025>, <-1.142319, -0.005458, 0.446025>, <-1.138349, -0.010000, 0.448231>, <-1.133577, -0.010000, 0.450882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.195640, 0.000160, 0.898641>, <-1.195260, -0.005277, 0.898355>, <-1.190881, -0.009413, 0.896123>, <-1.186000, -0.008946, 0.893728>, 
      <-1.234300, 0.000410, 0.862451>, <-1.233920, -0.005027, 0.862164>, <-1.229085, -0.009285, 0.861065>, <-1.224203, -0.008818, 0.858670>, 
      <-1.287527, 0.000048, 0.816027>, <-1.287527, -0.005410, 0.816027>, <-1.283093, -0.009684, 0.814593>, <-1.277637, -0.009684, 0.814735>, 
      <-1.326907, 0.000000, 0.780620>, <-1.326907, -0.005458, 0.780620>, <-1.322367, -0.010000, 0.780739>, <-1.316911, -0.010000, 0.780881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.036676, -0.001873, 1.052319>, <-1.036296, -0.007310, 1.052032>, <-1.032198, -0.011439, 1.049309>, <-1.027654, -0.010965, 1.046323>, 
      <-1.081103, -0.001519, 1.003062>, <-1.080723, -0.006956, 1.002776>, <-1.076432, -0.011089, 1.000362>, <-1.071888, -0.010614, 0.997375>, 
      <-1.147215, -0.000152, 0.943974>, <-1.146835, -0.005589, 0.943688>, <-1.142273, -0.009575, 0.940730>, <-1.137391, -0.009108, 0.938335>, 
      <-1.195640, 0.000160, 0.898641>, <-1.195260, -0.005277, 0.898355>, <-1.190881, -0.009413, 0.896123>, <-1.186000, -0.008946, 0.893728>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.953243, -0.001768, 1.167389>, <-0.952863, -0.007206, 1.167103>, <-0.948954, -0.011335, 1.164116>, <-0.944635, -0.010859, 1.160812>, 
      <-0.978273, -0.001800, 1.132868>, <-0.977893, -0.007237, 1.132582>, <-0.973859, -0.011366, 1.129769>, <-0.969541, -0.010891, 1.126465>, 
      <-1.008117, -0.002100, 1.083982>, <-1.007737, -0.007537, 1.083696>, <-1.003753, -0.011665, 1.080786>, <-0.999209, -0.011190, 1.077800>, 
      <-1.036676, -0.001873, 1.052319>, <-1.036296, -0.007310, 1.052032>, <-1.032198, -0.011439, 1.049309>, <-1.027654, -0.010965, 1.046323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.937744, -0.010000, 0.098382>, <-0.932960, -0.010000, 0.101010>, <-0.928979, -0.005458, 0.103196>, <-0.928979, 0.000000, 0.103196>, 
      <-0.880248, -0.010000, -0.006295>, <-0.875464, -0.010000, -0.003667>, <-0.871476, -0.005458, -0.001493>, <-0.871476, 0.000000, -0.001493>, 
      <-0.804779, -0.010000, -0.146515>, <-0.799982, -0.010000, -0.143910>, <-0.795997, -0.005458, -0.141730>, <-0.795997, 0.000000, -0.141730>, 
      <-0.747793, -0.010000, -0.251470>, <-0.742997, -0.010000, -0.248866>, <-0.739005, -0.005458, -0.246699>, <-0.739005, 0.000000, -0.246699>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.133577, -0.010000, 0.450882>, <-1.128806, -0.010000, 0.453532>, <-1.124836, -0.005458, 0.455738>, <-1.124836, 0.000000, 0.455738>, 
      <-1.074827, -0.010000, 0.345132>, <-1.070056, -0.010000, 0.347782>, <-1.065924, -0.005458, 0.350062>, <-1.065924, 0.000000, 0.350062>, 
      <-0.995985, -0.010000, 0.204414>, <-0.991201, -0.010000, 0.207041>, <-0.987227, -0.005458, 0.209241>, <-0.987227, 0.000000, 0.209241>, 
      <-0.937744, -0.010000, 0.098382>, <-0.932960, -0.010000, 0.101010>, <-0.928979, -0.005458, 0.103196>, <-0.928979, 0.000000, 0.103196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.316911, -0.010000, 0.780881>, <-1.311454, -0.010000, 0.781024>, <-1.306914, -0.005458, 0.781142>, <-1.306914, 0.000000, 0.781142>, 
      <-1.261911, -0.010000, 0.681882>, <-1.256455, -0.010000, 0.682024>, <-1.252291, -0.005458, 0.683521>, <-1.252291, 0.000000, 0.683521>, 
      <-1.188577, -0.010000, 0.549882>, <-1.183806, -0.010000, 0.552532>, <-1.179305, -0.005458, 0.553446>, <-1.179305, 0.000000, 0.553446>, 
      <-1.133577, -0.010000, 0.450882>, <-1.128806, -0.010000, 0.453532>, <-1.124836, -0.005458, 0.455738>, <-1.124836, 0.000000, 0.455738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.186000, -0.008946, 0.893728>, <-1.181118, -0.008478, 0.891332>, <-1.177371, -0.003565, 0.889577>, <-1.177751, 0.001873, 0.889864>, 
      <-1.224203, -0.008818, 0.858670>, <-1.219321, -0.008351, 0.856274>, <-1.214888, -0.003547, 0.855546>, <-1.215268, 0.001890, 0.855833>, 
      <-1.277637, -0.009684, 0.814735>, <-1.272181, -0.009684, 0.814878>, <-1.268165, -0.004896, 0.813759>, <-1.268165, 0.000562, 0.813759>, 
      <-1.316911, -0.010000, 0.780881>, <-1.311454, -0.010000, 0.781024>, <-1.306914, -0.005458, 0.781142>, <-1.306914, 0.000000, 0.781142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.027654, -0.010965, 1.046323>, <-1.023111, -0.010490, 1.043336>, <-1.019646, -0.005570, 1.041089>, <-1.020026, -0.000133, 1.041376>, 
      <-1.071888, -0.010614, 0.997375>, <-1.067345, -0.010139, 0.994389>, <-1.063686, -0.005222, 0.992451>, <-1.064066, 0.000215, 0.992738>, 
      <-1.137391, -0.009108, 0.938335>, <-1.132509, -0.008640, 0.935939>, <-1.128771, -0.003587, 0.933662>, <-1.129151, 0.001850, 0.933948>, 
      <-1.186000, -0.008946, 0.893728>, <-1.181118, -0.008478, 0.891332>, <-1.177371, -0.003565, 0.889577>, <-1.177751, 0.001873, 0.889864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.944635, -0.010859, 1.160812>, <-0.940316, -0.010383, 1.157509>, <-0.937039, -0.005463, 1.154998>, <-0.937419, -0.000025, 1.155284>, 
      <-0.969541, -0.010891, 1.126465>, <-0.965222, -0.010415, 1.123162>, <-0.961821, -0.005495, 1.120825>, <-0.962201, -0.000058, 1.121111>, 
      <-0.999209, -0.011190, 1.077800>, <-0.994665, -0.010715, 1.074813>, <-0.991313, -0.005794, 1.072380>, <-0.991693, -0.000357, 1.072666>, 
      <-1.027654, -0.010965, 1.046323>, <-1.023111, -0.010490, 1.043336>, <-1.019646, -0.005570, 1.041089>, <-1.020026, -0.000133, 1.041376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.928979, 0.000000, 0.103196>, <-0.928979, 0.005458, 0.103196>, <-0.932960, 0.010000, 0.101010>, <-0.937744, 0.010000, 0.098382>, 
      <-0.871476, 0.000000, -0.001493>, <-0.871476, 0.005458, -0.001493>, <-0.875464, 0.010000, -0.003667>, <-0.880248, 0.010000, -0.006295>, 
      <-0.795997, 0.000000, -0.141730>, <-0.795997, 0.005458, -0.141730>, <-0.799982, 0.010000, -0.143910>, <-0.804779, 0.010000, -0.146515>, 
      <-0.739005, 0.000000, -0.246699>, <-0.739005, 0.005458, -0.246699>, <-0.742997, 0.010000, -0.248866>, <-0.747793, 0.010000, -0.251470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.124836, 0.000000, 0.455738>, <-1.124836, 0.005458, 0.455738>, <-1.128806, 0.010000, 0.453532>, <-1.133577, 0.010000, 0.450882>, 
      <-1.065924, 0.000000, 0.350062>, <-1.065924, 0.005458, 0.350062>, <-1.070056, 0.010000, 0.347782>, <-1.074827, 0.010000, 0.345132>, 
      <-0.987227, 0.000000, 0.209241>, <-0.987227, 0.005458, 0.209241>, <-0.991201, 0.010000, 0.207041>, <-0.995985, 0.010000, 0.204414>, 
      <-0.928979, 0.000000, 0.103196>, <-0.928979, 0.005458, 0.103196>, <-0.932960, 0.010000, 0.101010>, <-0.937744, 0.010000, 0.098382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.306914, 0.000000, 0.781142>, <-1.306914, 0.005458, 0.781142>, <-1.311454, 0.010000, 0.781024>, <-1.316911, 0.010000, 0.780881>, 
      <-1.252291, 0.000000, 0.683521>, <-1.252291, 0.005458, 0.683521>, <-1.256455, 0.010000, 0.682024>, <-1.261911, 0.010000, 0.681882>, 
      <-1.179305, 0.000000, 0.553446>, <-1.179305, 0.005458, 0.553446>, <-1.183806, 0.010000, 0.552532>, <-1.188577, 0.010000, 0.549882>, 
      <-1.124836, 0.000000, 0.455738>, <-1.124836, 0.005458, 0.455738>, <-1.128806, 0.010000, 0.453532>, <-1.133577, 0.010000, 0.450882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.177751, 0.001873, 0.889864>, <-1.178131, 0.007310, 0.890150>, <-1.182510, 0.011446, 0.892382>, <-1.187392, 0.010978, 0.894777>, 
      <-1.215268, 0.001890, 0.855833>, <-1.215648, 0.007327, 0.856119>, <-1.220480, 0.011583, 0.857231>, <-1.225362, 0.011116, 0.859626>, 
      <-1.268165, 0.000562, 0.813759>, <-1.268165, 0.006020, 0.813759>, <-1.272599, 0.010294, 0.815193>, <-1.278055, 0.010294, 0.815050>, 
      <-1.306914, 0.000000, 0.781142>, <-1.306914, 0.005458, 0.781142>, <-1.311454, 0.010000, 0.781024>, <-1.316911, 0.010000, 0.780881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.020026, -0.000133, 1.041376>, <-1.020406, 0.005304, 1.041662>, <-1.024503, 0.009434, 1.044385>, <-1.029047, 0.008959, 1.047372>, 
      <-1.064066, 0.000215, 0.992738>, <-1.064446, 0.005652, 0.993024>, <-1.068737, 0.009784, 0.995438>, <-1.073281, 0.009310, 0.998424>, 
      <-1.129151, 0.001850, 0.933948>, <-1.129531, 0.007287, 0.934234>, <-1.134096, 0.011271, 0.937200>, <-1.138978, 0.010803, 0.939596>, 
      <-1.177751, 0.001873, 0.889864>, <-1.178131, 0.007310, 0.890150>, <-1.182510, 0.011446, 0.892382>, <-1.187392, 0.010978, 0.894777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.937419, -0.000025, 1.155284>, <-0.937799, 0.005412, 1.155570>, <-0.941708, 0.009541, 1.158558>, <-0.946027, 0.009065, 1.161861>, 
      <-0.962201, -0.000058, 1.121111>, <-0.962581, 0.005380, 1.121398>, <-0.966614, 0.009509, 1.124211>, <-0.970933, 0.009033, 1.127514>, 
      <-0.991693, -0.000357, 1.072666>, <-0.992073, 0.005080, 1.072953>, <-0.996057, 0.009208, 1.075862>, <-1.000601, 0.008734, 1.078849>, 
      <-1.020026, -0.000133, 1.041376>, <-1.020406, 0.005304, 1.041662>, <-1.024503, 0.009434, 1.044385>, <-1.029047, 0.008959, 1.047372>
    }
  }
  material {
    cuerdas_txt
  }
  photons {
    collect off
  }
}
#declare bordes = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.994216, 0.859355, 0.750519>, <-0.994348, 0.859196, 0.745065>, <-0.990959, 0.856167, 0.740526>, <-0.986755, 0.852686, 0.740526>, 
      <-0.843987, 1.041270, 0.741610>, <-0.844119, 1.041110, 0.736156>, <-0.841209, 1.037147, 0.731600>, <-0.837004, 1.033667, 0.731600>, 
      <-0.519501, 1.138201, 0.731294>, <-0.519666, 1.138104, 0.725839>, <-0.516694, 1.134746, 0.721300>, <-0.513934, 1.130038, 0.721300>, 
      <-0.316052, 1.257706, 0.723055>, <-0.316217, 1.257609, 0.717600>, <-0.314057, 1.253611, 0.713061>, <-0.311296, 1.248902, 0.713061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.354994, -0.000362, 0.784665>, <-1.354986, -0.000559, 0.779210>, <-1.350441, -0.000559, 0.774671>, <-1.344987, -0.000361, 0.774671>, 
      <-1.368079, 0.359238, 0.771755>, <-1.368071, 0.359041, 0.766301>, <-1.363487, 0.356288, 0.761764>, <-1.358033, 0.356485, 0.761764>, 
      <-1.172313, 0.643695, 0.761080>, <-1.172446, 0.643535, 0.755626>, <-1.167899, 0.642326, 0.751072>, <-1.163695, 0.638846, 0.751072>, 
      <-0.994216, 0.859355, 0.750519>, <-0.994348, 0.859196, 0.745065>, <-0.990959, 0.856167, 0.740526>, <-0.986755, 0.852686, 0.740526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.928356, -0.950588, 0.815495>, <-0.928203, -0.950739, 0.810041>, <-0.924898, -0.947617, 0.805502>, <-0.921080, -0.943717, 0.805502>, 
      <-1.151626, -0.732111, 0.803282>, <-1.151472, -0.732261, 0.797829>, <-1.146642, -0.730750, 0.793286>, <-1.142824, -0.726849, 0.793286>, 
      <-1.340378, -0.402010, 0.799084>, <-1.340371, -0.402208, 0.793629>, <-1.335862, -0.399355, 0.789096>, <-1.330407, -0.399157, 0.789096>, 
      <-1.354994, -0.000362, 0.784665>, <-1.354986, -0.000559, 0.779210>, <-1.350441, -0.000559, 0.774671>, <-1.344987, -0.000361, 0.774671>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000056, -1.326324, 0.858782>, <0.000363, -1.326322, 0.853333>, <0.000594, -1.321778, 0.848798>, <0.000564, -1.316321, 0.848798>, 
      <-0.386234, -1.328454, 0.837128>, <-0.385926, -1.328453, 0.831678>, <-0.382818, -1.324051, 0.827143>, <-0.382848, -1.318593, 0.827143>, 
      <-0.713564, -1.160770, 0.827243>, <-0.713410, -1.160920, 0.821789>, <-0.711646, -1.156179, 0.817250>, <-0.707829, -1.152278, 0.817250>, 
      <-0.928356, -0.950588, 0.815495>, <-0.928203, -0.950739, 0.810041>, <-0.924898, -0.947617, 0.805502>, <-0.921080, -0.943717, 0.805502>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.949749, -0.940228, 0.920778>, <0.949979, -0.940002, 0.915330>, <0.946995, -0.936568, 0.910796>, <0.943177, -0.932667, 0.910796>, 
      <0.729923, -1.155364, 0.902666>, <0.730154, -1.155137, 0.897217>, <0.728871, -1.150236, 0.892682>, <0.725054, -1.146335, 0.892682>, 
      <0.395805, -1.324140, 0.880967>, <0.396113, -1.324139, 0.875518>, <0.393458, -1.319450, 0.870987>, <0.393427, -1.313992, 0.870987>, 
      <0.000056, -1.326324, 0.858782>, <0.000363, -1.326322, 0.853333>, <0.000594, -1.321778, 0.848798>, <0.000564, -1.316321, 0.848798>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.354996, -0.000294, 0.970422>, <1.355007, 0.000072, 0.964976>, <1.350475, 0.000509, 0.960445>, <1.345020, 0.000670, 0.960445>, 
      <1.343707, -0.394759, 0.944146>, <1.343718, -0.394393, 0.938700>, <1.339174, -0.391089, 0.934122>, <1.333718, -0.390929, 0.934122>, 
      <1.169088, -0.725569, 0.938851>, <1.169319, -0.725343, 0.933402>, <1.164646, -0.723363, 0.928870>, <1.160829, -0.719462, 0.928870>, 
      <0.949749, -0.940228, 0.920778>, <0.949979, -0.940002, 0.915330>, <0.946995, -0.936568, 0.910796>, <0.943177, -0.932667, 0.910796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.997855, 0.740760, 1.032753>, <0.997574, 0.740976, 1.027307>, <0.994576, 0.737551, 1.022774>, <0.991253, 0.733221, 1.022774>, 
      <1.193665, 0.590230, 1.016849>, <1.193384, 0.590446, 1.011402>, <1.188440, 0.588975, 1.006907>, <1.185118, 0.584645, 1.006907>, 
      <1.364084, 0.317265, 0.991575>, <1.364094, 0.317630, 0.986130>, <1.359538, 0.314551, 0.981554>, <1.354083, 0.314712, 0.981554>, 
      <1.354996, -0.000294, 0.970422>, <1.355007, 0.000072, 0.964976>, <1.350475, 0.000509, 0.960445>, <1.345020, 0.000670, 0.960445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.020460, 1.025638, 1.078819>, <0.020149, 1.025613, 1.073370>, <0.020253, 1.021065, 1.068835>, <0.020688, 1.015624, 1.068835>, 
      <0.411885, 1.056988, 1.056510>, <0.411574, 1.056963, 1.051061>, <0.408871, 1.052383, 1.046511>, <0.409307, 1.046942, 1.046511>, 
      <0.755970, 0.926711, 1.052400>, <0.755689, 0.926926, 1.046954>, <0.754144, 0.921816, 1.042453>, <0.750821, 0.917486, 1.042453>, 
      <0.997855, 0.740760, 1.032753>, <0.997574, 0.740976, 1.027307>, <0.994576, 0.737551, 1.022774>, <0.991253, 0.733221, 1.022774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.714894, 0.603585, 1.130371>, <-0.715121, 0.603345, 1.124923>, <-0.712006, 0.600028, 1.120390>, <-0.708038, 0.596280, 1.120390>, 
      <-0.540332, 0.788609, 1.115135>, <-0.540558, 0.788369, 1.109687>, <-0.538921, 0.783516, 1.105130>, <-0.534953, 0.779769, 1.105130>, 
      <-0.305795, 0.999508, 1.097414>, <-0.306106, 0.999483, 1.091965>, <-0.303261, 0.994994, 1.087419>, <-0.302825, 0.989553, 1.087419>, 
      <0.020460, 1.025638, 1.078819>, <0.020149, 1.025613, 1.073370>, <0.020253, 1.021065, 1.068835>, <0.020688, 1.015624, 1.068835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961373, -0.015037, 1.164517>, <-0.961353, -0.015316, 1.159067>, <-0.956806, -0.015231, 1.154530>, <-0.951361, -0.014850, 1.154530>, 
      <-0.979350, 0.241343, 1.151463>, <-0.979331, 0.241063, 1.146012>, <-0.974707, 0.238009, 1.141484>, <-0.969263, 0.238390, 1.141484>, 
      <-0.851923, 0.458344, 1.142332>, <-0.852149, 0.458104, 1.136884>, <-0.847351, 0.456548, 1.132322>, <-0.843383, 0.452801, 1.132322>, 
      <-0.714894, 0.603585, 1.130371>, <-0.715121, 0.603345, 1.124923>, <-0.712006, 0.600028, 1.120390>, <-0.708038, 0.596280, 1.120390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.625414, -0.672503, 1.195347>, <-0.625171, -0.672689, 1.189898>, <-0.622205, -0.669239, 1.185363>, <-0.618885, -0.664908, 1.185363>, 
      <-0.801005, -0.537730, 1.183046>, <-0.800762, -0.537917, 1.177596>, <-0.796025, -0.536192, 1.173067>, <-0.792704, -0.531860, 1.173067>, 
      <-0.941449, -0.299169, 1.178985>, <-0.941429, -0.299449, 1.173534>, <-0.936944, -0.296201, 1.169005>, <-0.931500, -0.295820, 1.169005>, 
      <-0.961373, -0.015037, 1.164517>, <-0.961353, -0.015316, 1.159067>, <-0.956806, -0.015231, 1.154530>, <-0.951361, -0.014850, 1.154530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.096588, -0.827059, 1.238635>, <0.097030, -0.827025, 1.233195>, <0.097054, -0.822468, 1.228668>, <0.096641, -0.817026, 1.228668>, 
      <-0.187124, -0.848557, 1.215676>, <-0.186682, -0.848523, 1.210236>, <-0.183999, -0.844034, 1.205688>, <-0.184412, -0.838592, 1.205688>, 
      <-0.449667, -0.807395, 1.207660>, <-0.449424, -0.807581, 1.202210>, <-0.447910, -0.802651, 1.197693>, <-0.444590, -0.798319, 1.197693>, 
      <-0.625414, -0.672503, 1.195347>, <-0.625171, -0.672689, 1.189898>, <-0.622205, -0.669239, 1.185363>, <-0.618885, -0.664908, 1.185363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.675625, -0.573918, 1.300631>, <0.676056, -0.573488, 1.295207>, <0.673202, -0.569918, 1.290693>, <0.669343, -0.566058, 1.290693>, 
      <0.541903, -0.707957, 1.279639>, <0.542333, -0.707526, 1.274215>, <0.540919, -0.702554, 1.269662>, <0.537060, -0.698695, 1.269662>, 
      <0.340161, -0.808602, 1.258346>, <0.340603, -0.808569, 1.252906>, <0.338047, -0.803976, 1.248372>, <0.337634, -0.798534, 1.248372>, 
      <0.096588, -0.827059, 1.238635>, <0.097030, -0.827025, 1.233195>, <0.097054, -0.822468, 1.228668>, <0.096641, -0.817026, 1.228668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.922851, 0.001159, 1.368341>, <0.922770, 0.001859, 1.362928>, <0.918190, 0.001915, 1.358424>, <0.912769, 0.001282, 1.358424>, 
      <0.950905, -0.238226, 1.337460>, <0.950823, -0.237526, 1.332047>, <0.946220, -0.234112, 1.327478>, <0.940798, -0.234745, 1.327478>, 
      <0.808217, -0.441012, 1.321445>, <0.808648, -0.440582, 1.316021>, <0.803952, -0.438818, 1.311481>, <0.800093, -0.434959, 1.311481>, 
      <0.675625, -0.573918, 1.300631>, <0.676056, -0.573488, 1.295207>, <0.673202, -0.569918, 1.290693>, <0.669343, -0.566058, 1.290693>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.557492, 0.434139, 1.430672>, <0.556832, 0.434496, 1.425266>, <0.554124, 0.430796, 1.420767>, <0.551532, 0.425993, 1.420767>, 
      <0.706340, 0.353233, 1.407554>, <0.705680, 0.353590, 1.402148>, <0.701013, 0.351951, 1.397627>, <0.698420, 0.347148, 1.397627>, 
      <0.897456, 0.217859, 1.396295>, <0.897375, 0.218558, 1.390883>, <0.892870, 0.215128, 1.386380>, <0.887449, 0.214496, 1.386380>, 
      <0.922851, 0.001159, 1.368341>, <0.922770, 0.001859, 1.362928>, <0.918190, 0.001915, 1.358424>, <0.912769, 0.001282, 1.358424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.207035, 0.390239, 1.479517>, <0.206282, 0.390140, 1.474112>, <0.206243, 0.385555, 1.469615>, <0.206950, 0.380143, 1.469615>, 
      <0.342290, 0.407182, 1.460666>, <0.341536, 0.407083, 1.455261>, <0.339230, 0.403250, 1.450762>, <0.339937, 0.397838, 1.450762>, 
      <0.464374, 0.484753, 1.445135>, <0.463713, 0.485110, 1.439728>, <0.462217, 0.480128, 1.435245>, <0.459625, 0.475325, 1.435245>, 
      <0.557492, 0.434139, 1.430672>, <0.556832, 0.434496, 1.425266>, <0.554124, 0.430796, 1.420767>, <0.551532, 0.425993, 1.420767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.986755, 0.852686, 0.740526>, <-0.982551, 0.849206, 0.740526>, <-0.978942, 0.846442, 0.745065>, <-0.978810, 0.846602, 0.750519>, 
      <-0.837004, 1.033667, 0.731600>, <-0.832800, 1.030186, 0.731600>, <-0.829591, 1.026418, 0.736123>, <-0.829459, 1.026578, 0.741577>, 
      <-0.513934, 1.130038, 0.721300>, <-0.511173, 1.125329, 0.721300>, <-0.507963, 1.122201, 0.725839>, <-0.507798, 1.122298, 0.731294>, 
      <-0.311296, 1.248902, 0.713061>, <-0.308535, 1.244194, 0.713061>, <-0.306100, 1.240357, 0.717600>, <-0.305935, 1.240453, 0.723055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.344987, -0.000361, 0.774671>, <-1.339533, -0.000163, 0.774671>, <-1.334999, 0.000165, 0.779210>, <-1.335007, 0.000362, 0.784665>, 
      <-1.358033, 0.356485, 0.761764>, <-1.352578, 0.356683, 0.761764>, <-1.347799, 0.354293, 0.766305>, <-1.347807, 0.354490, 0.771759>, 
      <-1.163695, 0.638846, 0.751072>, <-1.159491, 0.635365, 0.751072>, <-1.154832, 0.634484, 0.755595>, <-1.154700, 0.634644, 0.761049>, 
      <-0.986755, 0.852686, 0.740526>, <-0.982551, 0.849206, 0.740526>, <-0.978942, 0.846442, 0.745065>, <-0.978810, 0.846602, 0.750519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.921080, -0.943717, 0.805502>, <-0.917263, -0.939816, 0.805502>, <-0.914214, -0.936445, 0.810041>, <-0.914367, -0.936295, 0.815495>, 
      <-1.142824, -0.726849, 0.793286>, <-1.139007, -0.722949, 0.793286>, <-1.134269, -0.721048, 0.797823>, <-1.134423, -0.720898, 0.803277>, 
      <-1.330407, -0.399157, 0.789096>, <-1.324953, -0.398959, 0.789096>, <-1.320689, -0.395763, 0.793640>, <-1.320696, -0.395566, 0.799094>, 
      <-1.344987, -0.000361, 0.774671>, <-1.339533, -0.000163, 0.774671>, <-1.334999, 0.000165, 0.779210>, <-1.335007, 0.000362, 0.784665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000564, -1.316321, 0.848798>, <0.000534, -1.310863, 0.848798>, <0.000252, -1.306322, 0.853333>, <-0.000056, -1.306324, 0.858782>, 
      <-0.382848, -1.318593, 0.827143>, <-0.382879, -1.313135, 0.827143>, <-0.380163, -1.308452, 0.831685>, <-0.380471, -1.308454, 0.837134>, 
      <-0.707829, -1.152278, 0.817250>, <-0.704011, -1.148378, 0.817250>, <-0.702713, -1.143467, 0.821784>, <-0.702867, -1.143317, 0.827237>, 
      <-0.921080, -0.943717, 0.805502>, <-0.917263, -0.939816, 0.805502>, <-0.914214, -0.936445, 0.810041>, <-0.914367, -0.936295, 0.815495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.943177, -0.932667, 0.910796>, <0.939360, -0.928767, 0.910796>, <0.935990, -0.925709, 0.915330>, <0.935759, -0.925935, 0.920778>, 
      <0.725054, -1.146335, 0.892682>, <0.721236, -1.142434, 0.892682>, <0.719385, -1.137699, 0.897217>, <0.719154, -1.137925, 0.902665>, 
      <0.393427, -1.313992, 0.870987>, <0.393397, -1.308534, 0.870987>, <0.390212, -1.304138, 0.875524>, <0.389904, -1.304140, 0.880973>, 
      <0.000564, -1.316321, 0.848798>, <0.000534, -1.310863, 0.848798>, <0.000252, -1.306322, 0.853333>, <-0.000056, -1.306324, 0.858782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.345020, 0.000670, 0.960445>, <1.339564, 0.000831, 0.960445>, <1.335015, 0.000660, 0.964976>, <1.335004, 0.000294, 0.970422>, 
      <1.333718, -0.390929, 0.934122>, <1.328263, -0.390768, 0.934122>, <1.323262, -0.388002, 0.938613>, <1.323251, -0.388368, 0.944059>, 
      <1.160829, -0.719462, 0.928870>, <1.157011, -0.715561, 0.928870>, <1.152116, -0.714187, 0.933403>, <1.151885, -0.714413, 0.938851>, 
      <0.943177, -0.932667, 0.910796>, <0.939360, -0.928767, 0.910796>, <0.935990, -0.925709, 0.915330>, <0.935759, -0.925935, 0.920778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.991253, 0.733221, 1.022774>, <0.987931, 0.728891, 1.022774>, <0.985399, 0.725108, 1.027307>, <0.985680, 0.724893, 1.032753>, 
      <1.185118, 0.584645, 1.006907>, <1.181795, 0.580315, 1.006907>, <1.177161, 0.578264, 1.011475>, <1.177441, 0.578049, 1.016921>, 
      <1.354083, 0.314712, 0.981554>, <1.348627, 0.314872, 0.981554>, <1.344405, 0.311186, 0.986039>, <1.344395, 0.310821, 0.991485>, 
      <1.345020, 0.000670, 0.960445>, <1.339564, 0.000831, 0.960445>, <1.335015, 0.000660, 0.964976>, <1.335004, 0.000294, 0.970422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.020688, 1.015624, 1.068835>, <0.021124, 1.010184, 1.068835>, <0.021746, 1.005677, 1.073370>, <0.022057, 1.005702, 1.078819>, 
      <0.409307, 1.046942, 1.046511>, <0.409743, 1.041501, 1.046511>, <0.407641, 1.036585, 1.051027>, <0.407953, 1.036610, 1.056476>, 
      <0.750821, 0.917486, 1.042453>, <0.747499, 0.913156, 1.042453>, <0.746592, 0.907978, 1.047023>, <0.746873, 0.907763, 1.052469>, 
      <0.991253, 0.733221, 1.022774>, <0.987931, 0.728891, 1.022774>, <0.985399, 0.725108, 1.027307>, <0.985680, 0.724893, 1.032753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.708038, 0.596280, 1.120390>, <-0.704070, 0.592533, 1.120390>, <-0.700579, 0.589614, 1.124923>, <-0.700353, 0.589854, 1.130371>, 
      <-0.534953, 0.779769, 1.105130>, <-0.530984, 0.776022, 1.105130>, <-0.528799, 0.771355, 1.109644>, <-0.528573, 0.771594, 1.115092>, 
      <-0.302825, 0.989553, 1.087419>, <-0.302389, 0.984113, 1.087419>, <-0.299005, 0.979987, 1.091941>, <-0.298694, 0.980012, 1.097390>, 
      <0.020688, 1.015624, 1.068835>, <0.021124, 1.010184, 1.068835>, <0.021746, 1.005677, 1.073370>, <0.022057, 1.005702, 1.078819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.951361, -0.014850, 1.154530>, <-0.945917, -0.014469, 1.154530>, <-0.941402, -0.013919, 1.159067>, <-0.941421, -0.013640, 1.164517>, 
      <-0.969263, 0.238390, 1.141484>, <-0.963818, 0.238772, 1.141484>, <-0.958887, 0.236283, 1.146024>, <-0.958906, 0.236563, 1.151475>, 
      <-0.843383, 0.452801, 1.132322>, <-0.839414, 0.449054, 1.132322>, <-0.834434, 0.447999, 1.136829>, <-0.834207, 0.448238, 1.142277>, 
      <-0.708038, 0.596280, 1.120390>, <-0.704070, 0.592533, 1.120390>, <-0.700579, 0.589614, 1.124923>, <-0.700353, 0.589854, 1.130371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.618885, -0.664908, 1.185363>, <-0.615564, -0.660576, 1.185363>, <-0.613003, -0.656816, 1.189898>, <-0.613246, -0.656630, 1.195347>, 
      <-0.792704, -0.531860, 1.173067>, <-0.789384, -0.527529, 1.173067>, <-0.784848, -0.525263, 1.177610>, <-0.785091, -0.525077, 1.183059>, 
      <-0.931500, -0.295820, 1.169005>, <-0.926055, -0.295439, 1.169005>, <-0.921988, -0.291727, 1.173548>, <-0.922008, -0.291448, 1.178999>, 
      <-0.951361, -0.014850, 1.154530>, <-0.945917, -0.014469, 1.154530>, <-0.941402, -0.013919, 1.159067>, <-0.941421, -0.013640, 1.164517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.096641, -0.817026, 1.228668>, <0.096228, -0.811584, 1.228668>, <0.095517, -0.807083, 1.233195>, <0.095075, -0.807116, 1.238635>, 
      <-0.184412, -0.838592, 1.205688>, <-0.184825, -0.833150, 1.205688>, <-0.182705, -0.828222, 1.210216>, <-0.183147, -0.828256, 1.215656>, 
      <-0.444590, -0.798319, 1.197693>, <-0.441269, -0.793987, 1.197693>, <-0.440477, -0.788891, 1.202235>, <-0.440720, -0.788705, 1.207684>, 
      <-0.618885, -0.664908, 1.185363>, <-0.615564, -0.660576, 1.185363>, <-0.613003, -0.656816, 1.189898>, <-0.613246, -0.656630, 1.195347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669343, -0.566058, 1.290693>, <0.665484, -0.562199, 1.290693>, <0.661914, -0.559345, 1.295207>, <0.661483, -0.559776, 1.300631>, 
      <0.537060, -0.698695, 1.269662>, <0.533200, -0.694836, 1.269662>, <0.530830, -0.690112, 1.274162>, <0.530400, -0.690542, 1.279586>, 
      <0.337634, -0.798534, 1.248372>, <0.337221, -0.793092, 1.248372>, <0.333750, -0.788982, 1.252871>, <0.333308, -0.789015, 1.258311>, 
      <0.096641, -0.817026, 1.228668>, <0.096228, -0.811584, 1.228668>, <0.095517, -0.807083, 1.233195>, <0.095075, -0.807116, 1.238635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.912769, 0.001282, 1.358424>, <0.907348, 0.000649, 1.358424>, <0.902905, -0.000460, 1.362928>, <0.902986, -0.001159, 1.368341>, 
      <0.940798, -0.234745, 1.327478>, <0.935377, -0.235378, 1.327478>, <0.929956, -0.233176, 1.331932>, <0.930038, -0.233876, 1.337344>, 
      <0.800093, -0.434959, 1.311481>, <0.796234, -0.431100, 1.311481>, <0.791136, -0.430436, 1.315953>, <0.790705, -0.430866, 1.321377>, 
      <0.669343, -0.566058, 1.290693>, <0.665484, -0.562199, 1.290693>, <0.661914, -0.559345, 1.295207>, <0.661483, -0.559776, 1.300631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.551532, 0.425993, 1.420767>, <0.548939, 0.421190, 1.420767>, <0.547331, 0.416896, 1.425266>, <0.547992, 0.416539, 1.430672>, 
      <0.698420, 0.347148, 1.397627>, <0.695828, 0.342345, 1.397627>, <0.691780, 0.339487, 1.402104>, <0.692441, 0.339130, 1.407510>, 
      <0.887449, 0.214496, 1.386380>, <0.882028, 0.213863, 1.386380>, <0.878531, 0.209213, 1.390856>, <0.878613, 0.208513, 1.396268>, 
      <0.912769, 0.001282, 1.358424>, <0.907348, 0.000649, 1.358424>, <0.902905, -0.000460, 1.362928>, <0.902986, -0.001159, 1.368341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.206950, 0.380143, 1.469615>, <0.207658, 0.374731, 1.469615>, <0.208873, 0.370309, 1.474112>, <0.209627, 0.370408, 1.479517>, 
      <0.339937, 0.397838, 1.450762>, <0.340645, 0.392426, 1.450762>, <0.339461, 0.388113, 1.455261>, <0.340215, 0.388212, 1.460666>, 
      <0.459625, 0.475325, 1.435245>, <0.457032, 0.470522, 1.435245>, <0.457010, 0.465298, 1.439748>, <0.457671, 0.464942, 1.445154>, 
      <0.551532, 0.425993, 1.420767>, <0.548939, 0.421190, 1.420767>, <0.547331, 0.416896, 1.425266>, <0.547992, 0.416539, 1.430672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.978810, 0.846602, 0.750519>, <-0.978678, 0.846761, 0.755973>, <-0.982066, 0.849791, 0.760512>, <-0.986271, 0.853271, 0.760512>, 
      <-0.829459, 1.026578, 0.741577>, <-0.829327, 1.026738, 0.747031>, <-0.832238, 1.030701, 0.751587>, <-0.836442, 1.034182, 0.751587>, 
      <-0.507798, 1.122298, 0.731294>, <-0.507633, 1.122395, 0.736748>, <-0.510604, 1.125753, 0.741287>, <-0.513365, 1.130461, 0.741287>, 
      <-0.305935, 1.240453, 0.723055>, <-0.305770, 1.240550, 0.728509>, <-0.307931, 1.244549, 0.733048>, <-0.310691, 1.249257, 0.733048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.335007, 0.000362, 0.784665>, <-1.335014, 0.000559, 0.790119>, <-1.339559, 0.000559, 0.794658>, <-1.345013, 0.000361, 0.794658>, 
      <-1.347807, 0.354490, 0.771759>, <-1.347814, 0.354687, 0.777213>, <-1.352398, 0.357440, 0.781750>, <-1.357852, 0.357243, 0.781750>, 
      <-1.154700, 0.634644, 0.761049>, <-1.154568, 0.634803, 0.766503>, <-1.159115, 0.636012, 0.771057>, <-1.163320, 0.639493, 0.771057>, 
      <-0.978810, 0.846602, 0.750519>, <-0.978678, 0.846761, 0.755973>, <-0.982066, 0.849791, 0.760512>, <-0.986271, 0.853271, 0.760512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.914367, -0.936295, 0.815495>, <-0.914521, -0.936144, 0.820948>, <-0.917825, -0.939265, 0.825487>, <-0.921643, -0.943166, 0.825487>, 
      <-1.134423, -0.720898, 0.803277>, <-1.134576, -0.720748, 0.808731>, <-1.139407, -0.722259, 0.813273>, <-1.143225, -0.726160, 0.813273>, 
      <-1.320696, -0.395566, 0.799094>, <-1.320703, -0.395369, 0.804548>, <-1.325212, -0.398221, 0.809082>, <-1.330667, -0.398419, 0.809082>, 
      <-1.335007, 0.000362, 0.784665>, <-1.335014, 0.000559, 0.790119>, <-1.339559, 0.000559, 0.794658>, <-1.345013, 0.000361, 0.794658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000056, -1.306324, 0.858782>, <-0.000363, -1.306325, 0.864232>, <-0.000594, -1.310869, 0.868766>, <-0.000564, -1.316327, 0.868766>, 
      <-0.380471, -1.308454, 0.837134>, <-0.380778, -1.308456, 0.842584>, <-0.383886, -1.312857, 0.847119>, <-0.383856, -1.318315, 0.847119>, 
      <-0.702867, -1.143317, 0.827237>, <-0.703020, -1.143167, 0.832691>, <-0.704784, -1.147907, 0.837230>, <-0.708602, -1.151808, 0.837230>, 
      <-0.914367, -0.936295, 0.815495>, <-0.914521, -0.936144, 0.820948>, <-0.917825, -0.939265, 0.825487>, <-0.921643, -0.943166, 0.825487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.935759, -0.925935, 0.920778>, <0.935528, -0.926161, 0.926227>, <0.938513, -0.929595, 0.930761>, <0.942331, -0.933496, 0.930761>, 
      <0.719154, -1.137925, 0.902665>, <0.718923, -1.138151, 0.908114>, <0.720206, -1.143053, 0.912649>, <0.724023, -1.146954, 0.912649>, 
      <0.389904, -1.304140, 0.880973>, <0.389597, -1.304142, 0.886423>, <0.392252, -1.308831, 0.890953>, <0.392282, -1.314289, 0.890953>, 
      <-0.000056, -1.306324, 0.858782>, <-0.000363, -1.306325, 0.864232>, <-0.000594, -1.310869, 0.868766>, <-0.000564, -1.316327, 0.868766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.335004, 0.000294, 0.970422>, <1.334994, -0.000072, 0.975868>, <1.339525, -0.000509, 0.980399>, <1.344980, -0.000670, 0.980399>, 
      <1.323251, -0.388368, 0.944059>, <1.323241, -0.388734, 0.949505>, <1.327785, -0.392038, 0.954084>, <1.333241, -0.392198, 0.954084>, 
      <1.151885, -0.714413, 0.938851>, <1.151655, -0.714639, 0.944299>, <1.156327, -0.716619, 0.948832>, <1.160144, -0.720520, 0.948832>, 
      <0.935759, -0.925935, 0.920778>, <0.935528, -0.926161, 0.926227>, <0.938513, -0.929595, 0.930761>, <0.942331, -0.933496, 0.930761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.985680, 0.724893, 1.032753>, <0.985961, 0.724677, 1.038200>, <0.988959, 0.728102, 1.042732>, <0.992282, 0.732432, 1.042732>, 
      <1.177441, 0.578049, 1.016921>, <1.177722, 0.577834, 1.022368>, <1.182667, 0.579305, 1.026862>, <1.185989, 0.583635, 1.026862>, 
      <1.344395, 0.310821, 0.991485>, <1.344384, 0.310455, 0.996931>, <1.348941, 0.313534, 1.001507>, <1.354397, 0.313374, 1.001507>, 
      <1.335004, 0.000294, 0.970422>, <1.334994, -0.000072, 0.975868>, <1.339525, -0.000509, 0.980399>, <1.344980, -0.000670, 0.980399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.022057, 1.005702, 1.078819>, <0.022368, 1.005727, 1.084268>, <0.022264, 1.010275, 1.088803>, <0.021828, 1.015716, 1.088803>, 
      <0.407953, 1.036610, 1.056476>, <0.408264, 1.036634, 1.061925>, <0.410967, 1.041215, 1.066475>, <0.410531, 1.046655, 1.066475>, 
      <0.746873, 0.907763, 1.052469>, <0.747154, 0.907547, 1.057916>, <0.748699, 0.912659, 1.062416>, <0.752022, 0.916989, 1.062416>, 
      <0.985680, 0.724893, 1.032753>, <0.985961, 0.724677, 1.038200>, <0.988959, 0.728102, 1.042732>, <0.992282, 0.732432, 1.042732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700353, 0.589854, 1.130371>, <-0.700127, 0.590093, 1.135819>, <-0.703241, 0.593411, 1.140353>, <-0.707209, 0.597158, 1.140353>, 
      <-0.528573, 0.771594, 1.115092>, <-0.528346, 0.771834, 1.120540>, <-0.529984, 0.776687, 1.125097>, <-0.533952, 0.780434, 1.125097>, 
      <-0.298694, 0.980012, 1.097390>, <-0.298383, 0.980037, 1.102839>, <-0.301228, 0.984526, 1.107384>, <-0.301664, 0.989967, 1.107384>, 
      <0.022057, 1.005702, 1.078819>, <0.022368, 1.005727, 1.084268>, <0.022264, 1.010275, 1.088803>, <0.021828, 1.015716, 1.088803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.941421, -0.013640, 1.164517>, <-0.941441, -0.013361, 1.169968>, <-0.945988, -0.013445, 1.174504>, <-0.951433, -0.013826, 1.174504>, 
      <-0.958906, 0.236563, 1.151475>, <-0.958926, 0.236842, 1.156926>, <-0.963549, 0.239896, 1.161454>, <-0.968993, 0.239515, 1.161454>, 
      <-0.834207, 0.448238, 1.142277>, <-0.833981, 0.448478, 1.147725>, <-0.838780, 0.450034, 1.152288>, <-0.842748, 0.453781, 1.152288>, 
      <-0.700353, 0.589854, 1.130371>, <-0.700127, 0.590093, 1.135819>, <-0.703241, 0.593411, 1.140353>, <-0.707209, 0.597158, 1.140353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.613246, -0.656630, 1.195347>, <-0.613489, -0.656444, 1.200797>, <-0.616455, -0.659894, 1.205332>, <-0.619775, -0.664225, 1.205332>, 
      <-0.785091, -0.525077, 1.183059>, <-0.785334, -0.524891, 1.188509>, <-0.790071, -0.526615, 1.193038>, <-0.793392, -0.530947, 1.193038>, 
      <-0.922008, -0.291448, 1.178999>, <-0.922027, -0.291168, 1.184450>, <-0.926512, -0.294416, 1.188978>, <-0.931957, -0.294797, 1.188978>, 
      <-0.941421, -0.013640, 1.164517>, <-0.941441, -0.013361, 1.169968>, <-0.945988, -0.013445, 1.174504>, <-0.951433, -0.013826, 1.174504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.095075, -0.807116, 1.238635>, <0.094632, -0.807150, 1.244075>, <0.094608, -0.811707, 1.248602>, <0.095021, -0.817149, 1.248602>, 
      <-0.183147, -0.828256, 1.215656>, <-0.183589, -0.828289, 1.221096>, <-0.186272, -0.832778, 1.225644>, <-0.185859, -0.838220, 1.225644>, 
      <-0.440720, -0.788705, 1.207684>, <-0.440963, -0.788519, 1.213134>, <-0.442477, -0.793450, 1.217651>, <-0.445797, -0.797781, 1.217651>, 
      <-0.613246, -0.656630, 1.195347>, <-0.613489, -0.656444, 1.200797>, <-0.616455, -0.659894, 1.205332>, <-0.619775, -0.664225, 1.205332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.661483, -0.559776, 1.300631>, <0.661053, -0.560206, 1.306055>, <0.663906, -0.563776, 1.310569>, <0.667766, -0.567636, 1.310569>, 
      <0.530400, -0.690542, 1.279586>, <0.529969, -0.690973, 1.285010>, <0.531384, -0.695945, 1.289565>, <0.535243, -0.699805, 1.289565>, 
      <0.333308, -0.789015, 1.258311>, <0.332866, -0.789049, 1.263751>, <0.335423, -0.793641, 1.268285>, <0.335836, -0.799083, 1.268285>, 
      <0.095075, -0.807116, 1.238635>, <0.094632, -0.807150, 1.244075>, <0.094608, -0.811707, 1.248602>, <0.095021, -0.817149, 1.248602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.902986, -0.001159, 1.368341>, <0.903068, -0.001859, 1.373753>, <0.907647, -0.001915, 1.378257>, <0.913068, -0.001282, 1.378257>, 
      <0.930038, -0.233876, 1.337344>, <0.930120, -0.234576, 1.342756>, <0.934724, -0.237990, 1.347328>, <0.940145, -0.237357, 1.347328>, 
      <0.790705, -0.430866, 1.321377>, <0.790275, -0.431297, 1.326801>, <0.794971, -0.433061, 1.331342>, <0.798830, -0.436920, 1.331342>, 
      <0.661483, -0.559776, 1.300631>, <0.661053, -0.560206, 1.306055>, <0.663906, -0.563776, 1.310569>, <0.667766, -0.567636, 1.310569>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.547992, 0.416539, 1.430672>, <0.548653, 0.416183, 1.436078>, <0.551360, 0.419883, 1.440577>, <0.553952, 0.424686, 1.440577>, 
      <0.692441, 0.339130, 1.407510>, <0.693101, 0.338774, 1.412916>, <0.697769, 0.340411, 1.417438>, <0.700361, 0.345214, 1.417438>, 
      <0.878613, 0.208513, 1.396268>, <0.878695, 0.207813, 1.401681>, <0.883199, 0.211243, 1.406184>, <0.888621, 0.211876, 1.406184>, 
      <0.902986, -0.001159, 1.368341>, <0.903068, -0.001859, 1.373753>, <0.907647, -0.001915, 1.378257>, <0.913068, -0.001282, 1.378257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.209627, 0.370408, 1.479517>, <0.210381, 0.370506, 1.484922>, <0.210419, 0.375092, 1.489420>, <0.209712, 0.380504, 1.489420>, 
      <0.340215, 0.388212, 1.460666>, <0.340969, 0.388310, 1.466071>, <0.343275, 0.392143, 1.470569>, <0.342567, 0.397555, 1.470569>, 
      <0.457671, 0.464942, 1.445154>, <0.458332, 0.464585, 1.450561>, <0.459829, 0.469566, 1.455043>, <0.462422, 0.474369, 1.455043>, 
      <0.547992, 0.416539, 1.430672>, <0.548653, 0.416183, 1.436078>, <0.551360, 0.419883, 1.440577>, <0.553952, 0.424686, 1.440577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.986271, 0.853271, 0.760512>, <-0.990475, 0.856751, 0.760512>, <-0.994084, 0.859515, 0.755973>, <-0.994216, 0.859355, 0.750519>, 
      <-0.836442, 1.034182, 0.751587>, <-0.840647, 1.037662, 0.751587>, <-0.843855, 1.041429, 0.747064>, <-0.843987, 1.041270, 0.741610>, 
      <-0.513365, 1.130461, 0.741287>, <-0.516126, 1.135169, 0.741287>, <-0.519336, 1.138298, 0.736748>, <-0.519501, 1.138201, 0.731294>, 
      <-0.310691, 1.249257, 0.733048>, <-0.313452, 1.253965, 0.733048>, <-0.315887, 1.257803, 0.728509>, <-0.316052, 1.257706, 0.723055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.345013, 0.000361, 0.794658>, <-1.350468, 0.000163, 0.794658>, <-1.355001, -0.000165, 0.790119>, <-1.354994, -0.000362, 0.784665>, 
      <-1.357852, 0.357243, 0.781750>, <-1.363307, 0.357045, 0.781750>, <-1.368086, 0.359435, 0.777210>, <-1.368079, 0.359238, 0.771755>, 
      <-1.163320, 0.639493, 0.771057>, <-1.167524, 0.642973, 0.771057>, <-1.172181, 0.643854, 0.766534>, <-1.172313, 0.643695, 0.761080>, 
      <-0.986271, 0.853271, 0.760512>, <-0.990475, 0.856751, 0.760512>, <-0.994084, 0.859515, 0.755973>, <-0.994216, 0.859355, 0.750519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.921643, -0.943166, 0.825487>, <-0.925460, -0.947067, 0.825487>, <-0.928509, -0.950438, 0.820948>, <-0.928356, -0.950588, 0.815495>, 
      <-1.143225, -0.726160, 0.813273>, <-1.147042, -0.730061, 0.813273>, <-1.151780, -0.731961, 0.808736>, <-1.151626, -0.732111, 0.803282>, 
      <-1.330667, -0.398419, 0.809082>, <-1.336121, -0.398617, 0.809082>, <-1.340386, -0.401813, 0.804538>, <-1.340378, -0.402010, 0.799084>, 
      <-1.345013, 0.000361, 0.794658>, <-1.350468, 0.000163, 0.794658>, <-1.355001, -0.000165, 0.790119>, <-1.354994, -0.000362, 0.784665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000564, -1.316327, 0.868766>, <-0.000534, -1.321785, 0.868766>, <-0.000252, -1.326325, 0.864232>, <0.000056, -1.326324, 0.858782>, 
      <-0.383856, -1.318315, 0.847119>, <-0.383826, -1.323773, 0.847119>, <-0.386541, -1.328456, 0.842577>, <-0.386234, -1.328454, 0.837128>, 
      <-0.708602, -1.151808, 0.837230>, <-0.712419, -1.155709, 0.837230>, <-0.713717, -1.160619, 0.832697>, <-0.713564, -1.160770, 0.827243>, 
      <-0.921643, -0.943166, 0.825487>, <-0.925460, -0.947067, 0.825487>, <-0.928509, -0.950438, 0.820948>, <-0.928356, -0.950588, 0.815495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.942331, -0.933496, 0.930761>, <0.946148, -0.937396, 0.930761>, <0.949518, -0.940454, 0.926227>, <0.949749, -0.940228, 0.920778>, 
      <0.724023, -1.146954, 0.912649>, <0.727841, -1.150855, 0.912649>, <0.729692, -1.155590, 0.908114>, <0.729923, -1.155364, 0.902666>, 
      <0.392282, -1.314289, 0.890953>, <0.392313, -1.319746, 0.890953>, <0.395498, -1.324142, 0.886417>, <0.395805, -1.324140, 0.880967>, 
      <-0.000564, -1.316327, 0.868766>, <-0.000534, -1.321785, 0.868766>, <-0.000252, -1.326325, 0.864232>, <0.000056, -1.326324, 0.858782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.344980, -0.000670, 0.980399>, <1.350436, -0.000831, 0.980399>, <1.354985, -0.000660, 0.975868>, <1.354996, -0.000294, 0.970422>, 
      <1.333241, -0.392198, 0.954084>, <1.338696, -0.392359, 0.954084>, <1.343696, -0.395124, 0.949591>, <1.343707, -0.394759, 0.944146>, 
      <1.160144, -0.720520, 0.948832>, <1.163962, -0.724421, 0.948832>, <1.168857, -0.725795, 0.944299>, <1.169088, -0.725569, 0.938851>, 
      <0.942331, -0.933496, 0.930761>, <0.946148, -0.937396, 0.930761>, <0.949518, -0.940454, 0.926227>, <0.949749, -0.940228, 0.920778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.992282, 0.732432, 1.042732>, <0.995605, 0.736762, 1.042732>, <0.998136, 0.740545, 1.038200>, <0.997855, 0.740760, 1.032753>, 
      <1.185989, 0.583635, 1.026862>, <1.189312, 0.587965, 1.026862>, <1.193946, 0.590015, 1.022295>, <1.193665, 0.590230, 1.016849>, 
      <1.354397, 0.313374, 1.001507>, <1.359852, 0.313213, 1.001507>, <1.364073, 0.316899, 0.997021>, <1.364084, 0.317265, 0.991575>, 
      <1.344980, -0.000670, 0.980399>, <1.350436, -0.000831, 0.980399>, <1.354985, -0.000660, 0.975868>, <1.354996, -0.000294, 0.970422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.021828, 1.015716, 1.088803>, <0.021392, 1.021156, 1.088803>, <0.020771, 1.025663, 1.084268>, <0.020460, 1.025638, 1.078819>, 
      <0.410531, 1.046655, 1.066475>, <0.410095, 1.052096, 1.066475>, <0.412196, 1.057013, 1.061959>, <0.411885, 1.056988, 1.056510>, 
      <0.752022, 0.916989, 1.062416>, <0.755344, 0.921319, 1.062416>, <0.756251, 0.926496, 1.057847>, <0.755970, 0.926711, 1.052400>, 
      <0.992282, 0.732432, 1.042732>, <0.995605, 0.736762, 1.042732>, <0.998136, 0.740545, 1.038200>, <0.997855, 0.740760, 1.032753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.707209, 0.597158, 1.140353>, <-0.711177, 0.600906, 1.140353>, <-0.714668, 0.603825, 1.135819>, <-0.714894, 0.603585, 1.130371>, 
      <-0.533952, 0.780434, 1.125097>, <-0.537920, 0.784182, 1.125097>, <-0.540106, 0.788848, 1.120583>, <-0.540332, 0.788609, 1.115135>, 
      <-0.301664, 0.989967, 1.107384>, <-0.302100, 0.995408, 1.107384>, <-0.305484, 0.999533, 1.102863>, <-0.305795, 0.999508, 1.097414>, 
      <0.021828, 1.015716, 1.088803>, <0.021392, 1.021156, 1.088803>, <0.020771, 1.025663, 1.084268>, <0.020460, 1.025638, 1.078819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.951433, -0.013826, 1.174504>, <-0.956878, -0.014207, 1.174504>, <-0.961392, -0.014757, 1.169968>, <-0.961373, -0.015037, 1.164517>, 
      <-0.968993, 0.239515, 1.161454>, <-0.974438, 0.239134, 1.161454>, <-0.979370, 0.241622, 1.156914>, <-0.979350, 0.241343, 1.151463>, 
      <-0.842748, 0.453781, 1.152288>, <-0.846716, 0.457529, 1.152288>, <-0.851697, 0.458583, 1.147780>, <-0.851923, 0.458344, 1.142332>, 
      <-0.707209, 0.597158, 1.140353>, <-0.711177, 0.600906, 1.140353>, <-0.714668, 0.603825, 1.135819>, <-0.714894, 0.603585, 1.130371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.619775, -0.664225, 1.205332>, <-0.623096, -0.668557, 1.205332>, <-0.625657, -0.672317, 1.200797>, <-0.625414, -0.672503, 1.195347>, 
      <-0.793392, -0.530947, 1.193038>, <-0.796712, -0.535278, 1.193038>, <-0.801248, -0.537544, 1.188495>, <-0.801005, -0.537730, 1.183046>, 
      <-0.931957, -0.294797, 1.188978>, <-0.937402, -0.295178, 1.188978>, <-0.941469, -0.298890, 1.184436>, <-0.941449, -0.299169, 1.178985>, 
      <-0.951433, -0.013826, 1.174504>, <-0.956878, -0.014207, 1.174504>, <-0.961392, -0.014757, 1.169968>, <-0.961373, -0.015037, 1.164517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.095021, -0.817149, 1.248602>, <0.095434, -0.822591, 1.248602>, <0.096146, -0.827092, 1.244075>, <0.096588, -0.827059, 1.238635>, 
      <-0.185859, -0.838220, 1.225644>, <-0.185446, -0.843663, 1.225644>, <-0.187566, -0.848590, 1.221116>, <-0.187124, -0.848557, 1.215676>, 
      <-0.445797, -0.797781, 1.217651>, <-0.449118, -0.802113, 1.217651>, <-0.449910, -0.807209, 1.213109>, <-0.449667, -0.807395, 1.207660>, 
      <-0.619775, -0.664225, 1.205332>, <-0.623096, -0.668557, 1.205332>, <-0.625657, -0.672317, 1.200797>, <-0.625414, -0.672503, 1.195347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667766, -0.567636, 1.310569>, <0.671625, -0.571495, 1.310569>, <0.675195, -0.574349, 1.306055>, <0.675625, -0.573918, 1.300631>, 
      <0.535243, -0.699805, 1.289565>, <0.539103, -0.703664, 1.289565>, <0.541472, -0.708387, 1.285063>, <0.541903, -0.707957, 1.279639>, 
      <0.335836, -0.799083, 1.268285>, <0.336249, -0.804526, 1.268285>, <0.339719, -0.808636, 1.263786>, <0.340161, -0.808602, 1.258346>, 
      <0.095021, -0.817149, 1.248602>, <0.095434, -0.822591, 1.248602>, <0.096146, -0.827092, 1.244075>, <0.096588, -0.827059, 1.238635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.913068, -0.001282, 1.378257>, <0.918490, -0.000649, 1.378257>, <0.922933, 0.000460, 1.373753>, <0.922851, 0.001159, 1.368341>, 
      <0.940145, -0.237357, 1.347328>, <0.945566, -0.236725, 1.347328>, <0.950986, -0.238926, 1.342872>, <0.950905, -0.238226, 1.337460>, 
      <0.798830, -0.436920, 1.331342>, <0.802690, -0.440780, 1.331342>, <0.807787, -0.441443, 1.326869>, <0.808217, -0.441012, 1.321445>, 
      <0.667766, -0.567636, 1.310569>, <0.671625, -0.571495, 1.310569>, <0.675195, -0.574349, 1.306055>, <0.675625, -0.573918, 1.300631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553952, 0.424686, 1.440577>, <0.556545, 0.429489, 1.440577>, <0.558153, 0.433783, 1.436078>, <0.557492, 0.434139, 1.430672>, 
      <0.700361, 0.345214, 1.417438>, <0.702954, 0.350017, 1.417438>, <0.707001, 0.352877, 1.412960>, <0.706340, 0.353233, 1.407554>, 
      <0.888621, 0.211876, 1.406184>, <0.894042, 0.212509, 1.406184>, <0.897538, 0.217159, 1.401708>, <0.897456, 0.217859, 1.396295>, 
      <0.913068, -0.001282, 1.378257>, <0.918490, -0.000649, 1.378257>, <0.922933, 0.000460, 1.373753>, <0.922851, 0.001159, 1.368341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.209712, 0.380504, 1.489420>, <0.209005, 0.385916, 1.489420>, <0.207789, 0.390337, 1.484922>, <0.207035, 0.390239, 1.479517>, 
      <0.342567, 0.397555, 1.470569>, <0.341860, 0.402967, 1.470569>, <0.343043, 0.407280, 1.466071>, <0.342290, 0.407182, 1.460666>, 
      <0.462422, 0.474369, 1.455043>, <0.465014, 0.479172, 1.455043>, <0.465034, 0.484397, 1.450541>, <0.464374, 0.484753, 1.445135>, 
      <0.553952, 0.424686, 1.440577>, <0.556545, 0.429489, 1.440577>, <0.558153, 0.433783, 1.436078>, <0.557492, 0.434139, 1.430672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.012510, 0.275171, 1.551208>, <0.011668, 0.274260, 1.545893>, <0.014301, 0.270418, 1.541470>, <0.018308, 0.266712, 1.541470>, 
      <0.058662, 0.325465, 1.535680>, <0.057819, 0.324553, 1.530365>, <0.059703, 0.319810, 1.525753>, <0.063710, 0.316105, 1.525753>, 
      <0.146010, 0.354796, 1.501024>, <0.144552, 0.353930, 1.495837>, <0.146667, 0.349822, 1.491450>, <0.149454, 0.345129, 1.491450>, 
      <0.203225, 0.388921, 1.479517>, <0.201766, 0.388055, 1.474330>, <0.202872, 0.383429, 1.470012>, <0.205659, 0.378736, 1.470012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.009850, 0.156725, 1.551208>, <-0.009850, 0.156725, 1.545750>, <-0.005376, 0.155941, 1.541208>, <0.000000, 0.155000, 1.541208>, 
      <-0.003142, 0.192259, 1.551208>, <-0.003142, 0.192259, 1.545750>, <0.000116, 0.189455, 1.541287>, <0.005493, 0.188514, 1.541287>, 
      <-0.011330, 0.249192, 1.559230>, <-0.012173, 0.248280, 1.553915>, <-0.008076, 0.246074, 1.549217>, <-0.004068, 0.242369, 1.549217>, 
      <0.012510, 0.275171, 1.551208>, <0.011668, 0.274260, 1.545893>, <0.014301, 0.270418, 1.541470>, <0.018308, 0.266712, 1.541470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.018308, 0.266712, 1.541470>, <0.022316, 0.263007, 1.541470>, <0.026353, 0.260682, 1.545893>, <0.027195, 0.261594, 1.551208>, 
      <0.063710, 0.316105, 1.525753>, <0.067718, 0.312400, 1.525753>, <0.071685, 0.309324, 1.529930>, <0.072528, 0.310236, 1.535245>, 
      <0.149454, 0.345129, 1.491450>, <0.152241, 0.340436, 1.491450>, <0.156106, 0.337819, 1.495837>, <0.157565, 0.338686, 1.501024>, 
      <0.205659, 0.378736, 1.470012>, <0.208446, 0.374043, 1.470012>, <0.211979, 0.370859, 1.474330>, <0.213438, 0.371725, 1.479517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.155000, 1.541208>, <0.005376, 0.154059, 1.541208>, <0.009850, 0.153275, 1.545750>, <0.009850, 0.153275, 1.551208>, 
      <0.005493, 0.188514, 1.541287>, <0.010869, 0.187572, 1.541287>, <0.015054, 0.185771, 1.545750>, <0.015054, 0.185771, 1.551208>, 
      <-0.004068, 0.242369, 1.549217>, <-0.000061, 0.238663, 1.549217>, <0.004535, 0.237272, 1.553576>, <0.005378, 0.238184, 1.558891>, 
      <0.018308, 0.266712, 1.541470>, <0.022316, 0.263007, 1.541470>, <0.026353, 0.260682, 1.545893>, <0.027195, 0.261594, 1.551208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.027195, 0.261594, 1.551208>, <0.028038, 0.262506, 1.556523>, <0.025405, 0.266348, 1.560946>, <0.021397, 0.270053, 1.560946>, 
      <0.072528, 0.310236, 1.535245>, <0.073371, 0.311148, 1.540560>, <0.071484, 0.315900, 1.545182>, <0.067476, 0.319605, 1.545182>, 
      <0.157565, 0.338686, 1.501024>, <0.159024, 0.339552, 1.506212>, <0.156909, 0.343660, 1.510599>, <0.154122, 0.348353, 1.510599>, 
      <0.213438, 0.371725, 1.479517>, <0.214896, 0.372592, 1.484705>, <0.213791, 0.377218, 1.489022>, <0.211004, 0.381910, 1.489022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.009850, 0.153275, 1.551208>, <0.009850, 0.153275, 1.556666>, <0.005376, 0.154059, 1.561208>, <0.000000, 0.155000, 1.561208>, 
      <0.015054, 0.185771, 1.551208>, <0.015054, 0.185771, 1.556666>, <0.011795, 0.188575, 1.561130>, <0.006419, 0.189516, 1.561130>, 
      <0.005378, 0.238184, 1.558891>, <0.006221, 0.239096, 1.564206>, <0.002121, 0.241308, 1.568912>, <-0.001887, 0.245014, 1.568912>, 
      <0.027195, 0.261594, 1.551208>, <0.028038, 0.262506, 1.556523>, <0.025405, 0.266348, 1.560946>, <0.021397, 0.270053, 1.560946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.021397, 0.270053, 1.560946>, <0.017390, 0.273758, 1.560946>, <0.013353, 0.276083, 1.556523>, <0.012510, 0.275171, 1.551208>, 
      <0.067476, 0.319605, 1.545182>, <0.063469, 0.323311, 1.545182>, <0.059505, 0.326377, 1.540995>, <0.058662, 0.325465, 1.535680>, 
      <0.154122, 0.348353, 1.510599>, <0.151335, 0.353046, 1.510599>, <0.147469, 0.355662, 1.506212>, <0.146010, 0.354796, 1.501024>, 
      <0.211004, 0.381910, 1.489022>, <0.208217, 0.386603, 1.489022>, <0.204683, 0.389787, 1.484705>, <0.203225, 0.388921, 1.479517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.155000, 1.561208>, <-0.005376, 0.155941, 1.561208>, <-0.009850, 0.156725, 1.556666>, <-0.009850, 0.156725, 1.551208>, 
      <0.006419, 0.189516, 1.561130>, <0.001043, 0.190457, 1.561130>, <-0.003142, 0.192259, 1.556666>, <-0.003142, 0.192259, 1.551208>, 
      <-0.001887, 0.245014, 1.568912>, <-0.005894, 0.248719, 1.568912>, <-0.010487, 0.250103, 1.564544>, <-0.011330, 0.249192, 1.559230>, 
      <0.021397, 0.270053, 1.560946>, <0.017390, 0.273758, 1.560946>, <0.013353, 0.276083, 1.556523>, <0.012510, 0.275171, 1.551208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013299, 0.493601, 0.794746>, <-0.013206, 0.493271, 0.789298>, <-0.008758, 0.494232, 0.784765>, <-0.003506, 0.495718, 0.784765>, 
      <-0.079797, 0.728414, 0.779323>, <-0.079704, 0.728084, 0.773876>, <-0.075245, 0.729318, 0.769374>, <-0.069993, 0.730804, 0.769374>, 
      <-0.228166, 1.019790, 0.744562>, <-0.227985, 1.019346, 0.739125>, <-0.223568, 1.020439, 0.734595>, <-0.218515, 1.022502, 0.734595>, 
      <-0.320252, 1.245300, 0.723055>, <-0.320071, 1.244856, 0.717618>, <-0.315715, 1.246204, 0.713093>, <-0.310662, 1.248267, 0.713093>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.011140, 0.153786, 0.794746>, <-0.011140, 0.153786, 0.789288>, <-0.006598, 0.153820, 0.784746>, <-0.001140, 0.153860, 0.784746>, 
      <-0.011787, 0.255731, 0.794746>, <-0.011787, 0.255731, 0.789288>, <-0.007307, 0.256377, 0.784752>, <-0.001850, 0.256418, 0.784752>, 
      <0.014424, 0.395707, 0.801175>, <0.014517, 0.395377, 0.795728>, <0.019099, 0.395739, 0.791214>, <0.024350, 0.397225, 0.791214>, 
      <-0.013299, 0.493601, 0.794746>, <-0.013206, 0.493271, 0.789298>, <-0.008758, 0.494232, 0.784765>, <-0.003506, 0.495718, 0.784765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.003506, 0.495718, 0.784765>, <0.001746, 0.497204, 0.784765>, <0.006039, 0.498715, 0.789298>, <0.005945, 0.499045, 0.794746>, 
      <-0.069993, 0.730804, 0.769374>, <-0.064741, 0.732290, 0.769374>, <-0.060520, 0.734210, 0.773935>, <-0.060614, 0.734540, 0.779383>, 
      <-0.218515, 1.022502, 0.734595>, <-0.213462, 1.024565, 0.734595>, <-0.209250, 1.026271, 0.739125>, <-0.209431, 1.026715, 0.744562>, 
      <-0.310662, 1.248267, 0.713093>, <-0.305609, 1.250330, 0.713093>, <-0.301554, 1.252415, 0.717618>, <-0.301735, 1.252859, 0.723055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001140, 0.153860, 0.784746>, <0.004318, 0.153901, 0.784746>, <0.008860, 0.153934, 0.789288>, <0.008860, 0.153934, 0.794746>, 
      <-0.001850, 0.256418, 0.784752>, <0.003608, 0.256458, 0.784752>, <0.007985, 0.257468, 0.789288>, <0.007985, 0.257468, 0.794746>, 
      <0.024350, 0.397225, 0.791214>, <0.029602, 0.398711, 0.791214>, <0.034144, 0.399277, 0.795786>, <0.034050, 0.399607, 0.801233>, 
      <-0.003506, 0.495718, 0.784765>, <0.001746, 0.497204, 0.784765>, <0.006039, 0.498715, 0.789298>, <0.005945, 0.499045, 0.794746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005945, 0.499045, 0.794746>, <0.005852, 0.499376, 0.800193>, <0.001404, 0.498414, 0.804726>, <-0.003848, 0.496928, 0.804726>, 
      <-0.060614, 0.734540, 0.779383>, <-0.060707, 0.734870, 0.784830>, <-0.065166, 0.733635, 0.789332>, <-0.070418, 0.732150, 0.789332>, 
      <-0.209431, 1.026715, 0.744562>, <-0.209612, 1.027159, 0.749999>, <-0.214029, 1.026066, 0.754529>, <-0.219082, 1.024003, 0.754529>, 
      <-0.301735, 1.252859, 0.723055>, <-0.301917, 1.253303, 0.728491>, <-0.306273, 1.251956, 0.733016>, <-0.311326, 1.249893, 0.733016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.008860, 0.153934, 0.794746>, <0.008860, 0.153934, 0.800204>, <0.004318, 0.153901, 0.804746>, <-0.001140, 0.153860, 0.804746>, 
      <0.007985, 0.257468, 0.794746>, <0.007985, 0.257468, 0.800204>, <0.003505, 0.256821, 0.804740>, <-0.001952, 0.256781, 0.804740>, 
      <0.034050, 0.399607, 0.801233>, <0.033957, 0.399937, 0.806680>, <0.029376, 0.399576, 0.811194>, <0.024124, 0.398090, 0.811194>, 
      <0.005945, 0.499045, 0.794746>, <0.005852, 0.499376, 0.800193>, <0.001404, 0.498414, 0.804726>, <-0.003848, 0.496928, 0.804726>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.003848, 0.496928, 0.804726>, <-0.009100, 0.495442, 0.804726>, <-0.013393, 0.493931, 0.800193>, <-0.013299, 0.493601, 0.794746>, 
      <-0.070418, 0.732150, 0.789332>, <-0.075669, 0.730664, 0.789332>, <-0.079891, 0.728744, 0.784770>, <-0.079797, 0.728414, 0.779323>, 
      <-0.219082, 1.024003, 0.754529>, <-0.224135, 1.021940, 0.754529>, <-0.228347, 1.020234, 0.749999>, <-0.228166, 1.019790, 0.744562>, 
      <-0.311326, 1.249893, 0.733016>, <-0.316379, 1.247830, 0.733016>, <-0.320433, 1.245744, 0.728491>, <-0.320252, 1.245300, 0.723055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001140, 0.153860, 0.804746>, <-0.006598, 0.153820, 0.804746>, <-0.011140, 0.153786, 0.800204>, <-0.011140, 0.153786, 0.794746>, 
      <-0.001952, 0.256781, 0.804740>, <-0.007410, 0.256740, 0.804740>, <-0.011787, 0.255731, 0.800204>, <-0.011787, 0.255731, 0.794746>, 
      <0.024124, 0.398090, 0.811194>, <0.018872, 0.396604, 0.811194>, <0.014330, 0.396037, 0.806623>, <0.014424, 0.395707, 0.801175>, 
      <-0.003848, 0.496928, 0.804726>, <-0.009100, 0.495442, 0.804726>, <-0.013393, 0.493931, 0.800193>, <-0.013299, 0.493601, 0.794746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.115801, 0.098760, 0.822210>, <-0.116853, 0.097709, 0.816958>, <-0.114516, 0.093622, 0.812588>, <-0.110657, 0.089763, 0.812588>, 
      <-0.089543, 0.125645, 0.812026>, <-0.090595, 0.124594, 0.806774>, <-0.088781, 0.120020, 0.802111>, <-0.084921, 0.116161, 0.802111>, 
      <-0.039041, 0.143391, 0.802985>, <-0.040060, 0.142802, 0.797655>, <-0.038034, 0.138601, 0.793263>, <-0.035303, 0.133875, 0.793263>, 
      <-0.006143, 0.162519, 0.794746>, <-0.007163, 0.161929, 0.789416>, <-0.005739, 0.157506, 0.784981>, <-0.003008, 0.152780, 0.784981>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164999, -0.000127, 0.856356>, <-0.164978, -0.001810, 0.851164>, <-0.160418, -0.003153, 0.846843>, <-0.154961, -0.003084, 0.846843>, 
      <-0.165507, 0.042572, 0.843425>, <-0.165486, 0.040889, 0.838233>, <-0.161755, 0.036631, 0.833937>, <-0.156297, 0.036701, 0.833937>, 
      <-0.139191, 0.074813, 0.831281>, <-0.140242, 0.073761, 0.826030>, <-0.136358, 0.071218, 0.821480>, <-0.132499, 0.067358, 0.821480>, 
      <-0.115801, 0.098760, 0.822210>, <-0.116853, 0.097709, 0.816958>, <-0.114516, 0.093622, 0.812588>, <-0.110657, 0.089763, 0.812588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.113250, -0.115795, 0.887186>, <-0.112014, -0.117031, 0.882015>, <-0.107774, -0.114848, 0.877713>, <-0.103914, -0.110989, 0.877713>, 
      <-0.139631, -0.089443, 0.875340>, <-0.138395, -0.090679, 0.870169>, <-0.133131, -0.090679, 0.865834>, <-0.129271, -0.086820, 0.865834>, 
      <-0.164427, -0.048295, 0.870943>, <-0.164405, -0.049978, 0.865751>, <-0.158899, -0.048393, 0.861519>, <-0.153441, -0.048323, 0.861519>, 
      <-0.164999, -0.000127, 0.856356>, <-0.164978, -0.001810, 0.851164>, <-0.160418, -0.003153, 0.846843>, <-0.154961, -0.003084, 0.846843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000056, -0.165000, 0.930473>, <0.002458, -0.164987, 0.925572>, <0.004431, -0.160434, 0.921494>, <0.004401, -0.154976, 0.921494>, 
      <-0.045841, -0.165239, 0.909369>, <-0.043439, -0.165226, 0.904468>, <-0.038807, -0.161770, 0.900283>, <-0.038837, -0.156312, 0.900283>, 
      <-0.086772, -0.142243, 0.899076>, <-0.085536, -0.143480, 0.893905>, <-0.082100, -0.139318, 0.889739>, <-0.078241, -0.135459, 0.889739>, 
      <-0.113250, -0.115795, 0.887186>, <-0.112014, -0.117031, 0.882015>, <-0.107774, -0.114848, 0.877713>, <-0.103914, -0.110989, 0.877713>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.115716, -0.114601, 0.992469>, <0.117467, -0.112849, 0.987606>, <0.115713, -0.108180, 0.983558>, <0.111854, -0.104321, 0.983558>, 
      <0.088802, -0.141476, 0.974253>, <0.090553, -0.139725, 0.969389>, <0.091144, -0.134258, 0.965308>, <0.087285, -0.130399, 0.965308>, 
      <0.049346, -0.164743, 0.953138>, <0.051748, -0.164730, 0.948237>, <0.050854, -0.158999, 0.944267>, <0.050823, -0.153541, 0.944267>, 
      <0.000056, -0.165000, 0.930473>, <0.002458, -0.164987, 0.925572>, <0.004431, -0.160434, 0.921494>, <0.004401, -0.154976, 0.921494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.164996, -0.000294, 1.042113>, <0.165076, 0.002454, 1.037398>, <0.160604, 0.004874, 1.033474>, <0.155148, 0.005034, 1.033474>, 
      <0.163762, -0.045731, 1.017436>, <0.163843, -0.042983, 1.012721>, <0.160763, -0.037720, 1.008630>, <0.155307, -0.037560, 1.008630>, 
      <0.141373, -0.088980, 1.009836>, <0.143124, -0.087229, 1.004972>, <0.139134, -0.083320, 1.000956>, <0.135274, -0.079461, 1.000956>, 
      <0.115716, -0.114601, 0.992469>, <0.117467, -0.112849, 0.987606>, <0.115713, -0.108180, 0.983558>, <0.111854, -0.104321, 0.983558>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.121312, 0.091575, 1.104444>, <0.119589, 0.093273, 1.099552>, <0.114967, 0.091451, 1.095480>, <0.111136, 0.087563, 1.095480>, 
      <0.144379, 0.068739, 1.089364>, <0.142656, 0.070437, 1.084472>, <0.137086, 0.070896, 1.080594>, <0.133255, 0.067008, 1.080594>, 
      <0.166094, 0.040156, 1.064082>, <0.166174, 0.042904, 1.059367>, <0.160464, 0.042284, 1.055295>, <0.155008, 0.042445, 1.055295>, 
      <0.164996, -0.000294, 1.042113>, <0.165076, 0.002454, 1.037398>, <0.160604, 0.004874, 1.033474>, <0.155148, 0.005034, 1.033474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000816, 0.163855, 1.150510>, <-0.003002, 0.163926, 1.145510>, <-0.004969, 0.159445, 1.141348>, <-0.005146, 0.153990, 1.141348>, 
      <0.052411, 0.162242, 1.128597>, <0.050224, 0.162313, 1.123597>, <0.045085, 0.159100, 1.119460>, <0.044908, 0.153645, 1.119460>, 
      <0.092463, 0.120134, 1.123303>, <0.090740, 0.121832, 1.118411>, <0.087065, 0.117379, 1.114258>, <0.083234, 0.113492, 1.114258>, 
      <0.121312, 0.091575, 1.104444>, <0.119589, 0.093273, 1.099552>, <0.114967, 0.091451, 1.095480>, <0.111136, 0.087563, 1.095480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.115801, 0.098760, 1.202062>, <-0.117216, 0.097346, 1.196984>, <-0.115181, 0.092957, 1.192758>, <-0.111322, 0.089098, 1.192758>, 
      <-0.087560, 0.126967, 1.187321>, <-0.088974, 0.125553, 1.182243>, <-0.089237, 0.120159, 1.177978>, <-0.085377, 0.116299, 1.177978>, 
      <-0.051413, 0.165388, 1.171341>, <-0.053599, 0.165459, 1.166340>, <-0.052577, 0.159774, 1.162167>, <-0.052754, 0.154319, 1.162167>, 
      <-0.000816, 0.163855, 1.150510>, <-0.003002, 0.163926, 1.145510>, <-0.004969, 0.159445, 1.141348>, <-0.005146, 0.153990, 1.141348>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.164999, -0.000127, 1.236208>, <-0.164978, -0.001810, 1.231016>, <-0.160418, -0.003153, 1.226696>, <-0.154961, -0.003084, 1.226696>, 
      <-0.165507, 0.042572, 1.223277>, <-0.165486, 0.040889, 1.218085>, <-0.161878, 0.036288, 1.213921>, <-0.156421, 0.036357, 1.213921>, 
      <-0.138821, 0.075769, 1.214078>, <-0.140235, 0.074355, 1.209000>, <-0.135893, 0.071241, 1.204557>, <-0.132034, 0.067382, 1.204557>, 
      <-0.115801, 0.098760, 1.202062>, <-0.117216, 0.097346, 1.196984>, <-0.115181, 0.092957, 1.192758>, <-0.111322, 0.089098, 1.192758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.113250, -0.115795, 1.267038>, <-0.112014, -0.117031, 1.261868>, <-0.107774, -0.114848, 1.257565>, <-0.103914, -0.110989, 1.257565>, 
      <-0.139631, -0.089443, 1.255192>, <-0.138395, -0.090679, 1.250022>, <-0.133131, -0.090679, 1.245687>, <-0.129271, -0.086820, 1.245687>, 
      <-0.164427, -0.048295, 1.250795>, <-0.164405, -0.049978, 1.245603>, <-0.158744, -0.048395, 1.241349>, <-0.153286, -0.048325, 1.241349>, 
      <-0.164999, -0.000127, 1.236208>, <-0.164978, -0.001810, 1.231016>, <-0.160418, -0.003153, 1.226696>, <-0.154961, -0.003084, 1.226696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000056, -0.165000, 1.310326>, <0.002458, -0.164987, 1.305425>, <0.004431, -0.160433, 1.301346>, <0.004401, -0.154976, 1.301346>, 
      <-0.045841, -0.165239, 1.289222>, <-0.043439, -0.165226, 1.284321>, <-0.038796, -0.161845, 1.280119>, <-0.038826, -0.156387, 1.280119>, 
      <-0.086772, -0.142243, 1.278928>, <-0.085536, -0.143480, 1.273758>, <-0.082100, -0.139318, 1.269592>, <-0.078241, -0.135459, 1.269592>, 
      <-0.113250, -0.115795, 1.267038>, <-0.112014, -0.117031, 1.261868>, <-0.107774, -0.114848, 1.257565>, <-0.103914, -0.110989, 1.257565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.115716, -0.114601, 1.372322>, <0.117681, -0.112636, 1.367625>, <0.116105, -0.107788, 1.363716>, <0.112245, -0.103929, 1.363716>, 
      <0.089640, -0.140640, 1.351816>, <0.091605, -0.138675, 1.347119>, <0.092315, -0.133126, 1.343139>, <0.088456, -0.129267, 1.343139>, 
      <0.049346, -0.164743, 1.332991>, <0.051748, -0.164730, 1.328090>, <0.051051, -0.158911, 1.324240>, <0.051021, -0.153453, 1.324240>, 
      <0.000056, -0.165000, 1.310326>, <0.002458, -0.164987, 1.305425>, <0.004431, -0.160433, 1.301346>, <0.004401, -0.154976, 1.301346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.164996, -0.000294, 1.440032>, <0.165086, 0.002765, 1.435512>, <0.160621, 0.005444, 1.431751>, <0.155165, 0.005604, 1.431751>, 
      <0.163729, -0.046534, 1.410860>, <0.163819, -0.043475, 1.406340>, <0.160881, -0.037984, 1.402344>, <0.155426, -0.037824, 1.402344>, 
      <0.142001, -0.088353, 1.392992>, <0.143966, -0.086388, 1.388295>, <0.140118, -0.082212, 1.384486>, <0.136258, -0.078353, 1.384486>, 
      <0.115716, -0.114601, 1.372322>, <0.117681, -0.112636, 1.367625>, <0.116105, -0.107788, 1.363716>, <0.112245, -0.103929, 1.363716>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.121364, 0.091523, 1.502363>, <0.119618, 0.093269, 1.497495>, <0.114954, 0.091510, 1.493444>, <0.111095, 0.087651, 1.493444>, 
      <0.143829, 0.068488, 1.486728>, <0.142083, 0.070233, 1.481861>, <0.136589, 0.070817, 1.478381>, <0.132730, 0.066958, 1.478381>, 
      <0.166062, 0.038618, 1.464581>, <0.166152, 0.041677, 1.460061>, <0.160406, 0.041143, 1.455925>, <0.154950, 0.041303, 1.455925>, 
      <0.164996, -0.000294, 1.440032>, <0.165086, 0.002765, 1.435512>, <0.160621, 0.005444, 1.431751>, <0.155165, 0.005604, 1.431751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005253, 0.163510, 1.551208>, <0.003665, 0.164489, 1.546079>, <-0.000041, 0.161440, 1.541810>, <-0.002908, 0.156795, 1.541810>, 
      <0.050064, 0.135727, 1.532357>, <0.048477, 0.136707, 1.527228>, <0.043957, 0.134754, 1.523144>, <0.041090, 0.130110, 1.523144>, 
      <0.094031, 0.119551, 1.521386>, <0.092286, 0.121296, 1.516518>, <0.087485, 0.117783, 1.512569>, <0.083626, 0.113923, 1.512569>, 
      <0.121364, 0.091523, 1.502363>, <0.119618, 0.093269, 1.497495>, <0.114954, 0.091510, 1.493444>, <0.111095, 0.087651, 1.493444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.110657, 0.089763, 0.812588>, <-0.106797, 0.085903, 0.812588>, <-0.102711, 0.083567, 0.816958>, <-0.101659, 0.084618, 0.822210>, 
      <-0.084921, 0.116161, 0.802111>, <-0.081062, 0.112301, 0.802111>, <-0.077016, 0.108608, 0.806324>, <-0.075964, 0.109659, 0.811576>, 
      <-0.035303, 0.133875, 0.793263>, <-0.032572, 0.129149, 0.793263>, <-0.028813, 0.126437, 0.797655>, <-0.027793, 0.127027, 0.802985>, 
      <-0.003008, 0.152780, 0.784981>, <-0.000278, 0.148055, 0.784981>, <0.002844, 0.144613, 0.789416>, <0.003863, 0.145202, 0.794746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.154961, -0.003084, 0.846843>, <-0.149503, -0.003014, 0.846843>, <-0.144979, -0.001556, 0.851164>, <-0.145001, 0.000127, 0.856356>, 
      <-0.156297, 0.036701, 0.833937>, <-0.150839, 0.036770, 0.833937>, <-0.145483, 0.035214, 0.838338>, <-0.145504, 0.036897, 0.843530>, 
      <-0.132499, 0.067358, 0.821480>, <-0.128639, 0.063499, 0.821480>, <-0.123498, 0.063309, 0.825561>, <-0.122446, 0.064360, 0.830813>, 
      <-0.110657, 0.089763, 0.812588>, <-0.106797, 0.085903, 0.812588>, <-0.102711, 0.083567, 0.816958>, <-0.101659, 0.084618, 0.822210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.103914, -0.110989, 0.877713>, <-0.100055, -0.107129, 0.877713>, <-0.097872, -0.102889, 0.882015>, <-0.099108, -0.101653, 0.887186>, 
      <-0.129271, -0.086820, 0.865834>, <-0.125412, -0.082961, 0.865834>, <-0.120966, -0.079766, 0.870206>, <-0.122202, -0.078530, 0.875377>, 
      <-0.153441, -0.048323, 0.861519>, <-0.147984, -0.048254, 0.861519>, <-0.144401, -0.043760, 0.865886>, <-0.144423, -0.042077, 0.871078>, 
      <-0.154961, -0.003084, 0.846843>, <-0.149503, -0.003014, 0.846843>, <-0.144979, -0.001556, 0.851164>, <-0.145001, 0.000127, 0.856356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004401, -0.154976, 0.921494>, <0.004370, -0.149518, 0.921494>, <0.002346, -0.144987, 0.925572>, <-0.000056, -0.145000, 0.930473>, 
      <-0.038837, -0.156312, 0.900283>, <-0.038867, -0.150854, 0.900283>, <-0.037456, -0.145224, 0.904691>, <-0.039858, -0.145237, 0.909592>, 
      <-0.078241, -0.135459, 0.889739>, <-0.074382, -0.131599, 0.889739>, <-0.074651, -0.126139, 0.893889>, <-0.075887, -0.124903, 0.899060>, 
      <-0.103914, -0.110989, 0.877713>, <-0.100055, -0.107129, 0.877713>, <-0.097872, -0.102889, 0.882015>, <-0.099108, -0.101653, 0.887186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.111854, -0.104321, 0.983558>, <0.107994, -0.100461, 0.983558>, <0.103325, -0.098707, 0.987606>, <0.101573, -0.100459, 0.992469>, 
      <0.087285, -0.130399, 0.965308>, <0.083426, -0.126540, 0.965308>, <0.079656, -0.122414, 0.969390>, <0.077905, -0.124166, 0.974254>, 
      <0.050823, -0.153541, 0.944267>, <0.050793, -0.148083, 0.944267>, <0.045786, -0.144728, 0.948362>, <0.043384, -0.144742, 0.953263>, 
      <0.004401, -0.154976, 0.921494>, <0.004370, -0.149518, 0.921494>, <0.002346, -0.144987, 0.925572>, <-0.000056, -0.145000, 0.930473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.155148, 0.005034, 1.033474>, <0.149693, 0.005195, 1.033474>, <0.145085, 0.003042, 1.037398>, <0.145004, 0.000294, 1.042113>, 
      <0.155307, -0.037560, 1.008630>, <0.149852, -0.037399, 1.008630>, <0.143825, -0.036270, 1.012638>, <0.143744, -0.039018, 1.017354>, 
      <0.135274, -0.079461, 1.000956>, <0.131415, -0.075602, 1.000956>, <0.125749, -0.076247, 1.004864>, <0.123998, -0.077998, 1.009727>, 
      <0.111854, -0.104321, 0.983558>, <0.107994, -0.100461, 0.983558>, <0.103325, -0.098707, 0.987606>, <0.101573, -0.100459, 0.992469>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.111136, 0.087563, 1.095480>, <0.107305, 0.083676, 1.095480>, <0.105551, 0.079027, 1.099552>, <0.107274, 0.077329, 1.104444>, 
      <0.133255, 0.067008, 1.080594>, <0.129424, 0.063121, 1.080594>, <0.125635, 0.059340, 1.084688>, <0.127358, 0.057642, 1.089580>, 
      <0.155008, 0.042445, 1.055295>, <0.149553, 0.042605, 1.055295>, <0.146195, 0.037656, 1.059199>, <0.146114, 0.034908, 1.063914>, 
      <0.155148, 0.005034, 1.033474>, <0.149693, 0.005195, 1.033474>, <0.145085, 0.003042, 1.037398>, <0.145004, 0.000294, 1.042113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005146, 0.153990, 1.141348>, <-0.005323, 0.148535, 1.141348>, <-0.003651, 0.143936, 1.145510>, <-0.001464, 0.143865, 1.150510>, 
      <0.044908, 0.153645, 1.119460>, <0.044731, 0.148190, 1.119460>, <0.043721, 0.142284, 1.123377>, <0.045907, 0.142213, 1.128377>, 
      <0.083234, 0.113492, 1.114258>, <0.079403, 0.109604, 1.114258>, <0.079876, 0.104194, 1.118553>, <0.081600, 0.102496, 1.123445>, 
      <0.111136, 0.087563, 1.095480>, <0.107305, 0.083676, 1.095480>, <0.105551, 0.079027, 1.099552>, <0.107274, 0.077329, 1.104444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.111322, 0.089098, 1.192758>, <-0.107462, 0.085239, 1.192758>, <-0.103074, 0.083204, 1.196984>, <-0.101659, 0.084618, 1.202062>, 
      <-0.085377, 0.116299, 1.177978>, <-0.081518, 0.112440, 1.177978>, <-0.078209, 0.108103, 1.182139>, <-0.076795, 0.109518, 1.187217>, 
      <-0.052754, 0.154319, 1.162167>, <-0.052931, 0.148864, 1.162167>, <-0.048142, 0.145488, 1.166297>, <-0.045955, 0.145418, 1.171297>, 
      <-0.005146, 0.153990, 1.141348>, <-0.005323, 0.148535, 1.141348>, <-0.003651, 0.143936, 1.145510>, <-0.001464, 0.143865, 1.150510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.154961, -0.003084, 1.226696>, <-0.149503, -0.003014, 1.226696>, <-0.144979, -0.001556, 1.231016>, <-0.145001, 0.000127, 1.236208>, 
      <-0.156421, 0.036357, 1.213921>, <-0.150963, 0.036427, 1.213921>, <-0.145483, 0.035214, 1.218190>, <-0.145504, 0.036897, 1.223382>, 
      <-0.132034, 0.067382, 1.204557>, <-0.128175, 0.063523, 1.204557>, <-0.122783, 0.063467, 1.208752>, <-0.121369, 0.064881, 1.213830>, 
      <-0.111322, 0.089098, 1.192758>, <-0.107462, 0.085239, 1.192758>, <-0.103074, 0.083204, 1.196984>, <-0.101659, 0.084618, 1.202062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.103914, -0.110989, 1.257565>, <-0.100055, -0.107129, 1.257565>, <-0.097872, -0.102889, 1.261868>, <-0.099108, -0.101653, 1.267038>, 
      <-0.129271, -0.086820, 1.245687>, <-0.125412, -0.082961, 1.245687>, <-0.120966, -0.079766, 1.250059>, <-0.122202, -0.078530, 1.255230>, 
      <-0.153286, -0.048325, 1.241349>, <-0.147828, -0.048256, 1.241349>, <-0.144401, -0.043760, 1.245738>, <-0.144423, -0.042077, 1.250930>, 
      <-0.154961, -0.003084, 1.226696>, <-0.149503, -0.003014, 1.226696>, <-0.144979, -0.001556, 1.231016>, <-0.145001, 0.000127, 1.236208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004401, -0.154976, 1.301346>, <0.004370, -0.149518, 1.301346>, <0.002346, -0.144987, 1.305425>, <-0.000056, -0.145000, 1.310326>, 
      <-0.038826, -0.156387, 1.280119>, <-0.038857, -0.150929, 1.280119>, <-0.037456, -0.145224, 1.284543>, <-0.039858, -0.145237, 1.289444>, 
      <-0.078241, -0.135459, 1.269592>, <-0.074382, -0.131599, 1.269592>, <-0.074651, -0.126139, 1.273742>, <-0.075887, -0.124903, 1.278912>, 
      <-0.103914, -0.110989, 1.257565>, <-0.100055, -0.107129, 1.257565>, <-0.097872, -0.102889, 1.261868>, <-0.099108, -0.101653, 1.267038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.112245, -0.103929, 1.363716>, <0.108386, -0.100070, 1.363716>, <0.103539, -0.098493, 1.367625>, <0.101573, -0.100459, 1.372322>, 
      <0.088456, -0.129267, 1.343139>, <0.084597, -0.125408, 1.343139>, <0.080762, -0.121307, 1.347259>, <0.078797, -0.123272, 1.351956>, 
      <0.051021, -0.153453, 1.324240>, <0.050990, -0.147995, 1.324240>, <0.045786, -0.144728, 1.328214>, <0.043384, -0.144742, 1.333115>, 
      <0.004401, -0.154976, 1.301346>, <0.004370, -0.149518, 1.301346>, <0.002346, -0.144987, 1.305425>, <-0.000056, -0.145000, 1.310326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.155165, 0.005604, 1.431751>, <0.149709, 0.005765, 1.431751>, <0.145094, 0.003353, 1.435512>, <0.145004, 0.000294, 1.440032>, 
      <0.155426, -0.037824, 1.402344>, <0.149970, -0.037663, 1.402344>, <0.143819, -0.036799, 1.406152>, <0.143729, -0.039858, 1.410672>, 
      <0.136258, -0.078353, 1.384486>, <0.132399, -0.074493, 1.384486>, <0.126642, -0.075353, 1.388283>, <0.124677, -0.077318, 1.392980>, 
      <0.112245, -0.103929, 1.363716>, <0.108386, -0.100070, 1.363716>, <0.103539, -0.098493, 1.367625>, <0.101573, -0.100459, 1.372322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.111095, 0.087651, 1.493444>, <0.107235, 0.083791, 1.493444>, <0.105476, 0.079127, 1.497495>, <0.107222, 0.077381, 1.502363>, 
      <0.132730, 0.066958, 1.478381>, <0.128870, 0.063098, 1.478381>, <0.125629, 0.059519, 1.482584>, <0.127375, 0.057773, 1.487452>, 
      <0.154950, 0.041303, 1.455925>, <0.149495, 0.041464, 1.455925>, <0.146144, 0.036393, 1.459672>, <0.146054, 0.033334, 1.464191>, 
      <0.155165, 0.005604, 1.431751>, <0.149709, 0.005765, 1.431751>, <0.145094, 0.003353, 1.435512>, <0.145004, 0.000294, 1.440032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.002908, 0.156795, 1.541810>, <-0.005775, 0.152151, 1.541810>, <-0.006840, 0.147470, 1.546079>, <-0.005253, 0.146491, 1.551208>, 
      <0.041090, 0.130110, 1.523144>, <0.038223, 0.125465, 1.523144>, <0.036568, 0.120798, 1.527228>, <0.038156, 0.119819, 1.532357>, 
      <0.083626, 0.113923, 1.512569>, <0.079767, 0.110064, 1.512569>, <0.078738, 0.105142, 1.517279>, <0.080484, 0.103397, 1.522147>, 
      <0.111095, 0.087651, 1.493444>, <0.107235, 0.083791, 1.493444>, <0.105476, 0.079127, 1.497495>, <0.107222, 0.077381, 1.502363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101659, 0.084618, 0.822210>, <-0.100608, 0.085670, 0.827461>, <-0.102944, 0.089756, 0.831832>, <-0.106804, 0.093616, 0.831832>, 
      <-0.075964, 0.109659, 0.811576>, <-0.074913, 0.110711, 0.816827>, <-0.076735, 0.115307, 0.821508>, <-0.080595, 0.119166, 0.821508>, 
      <-0.027793, 0.127027, 0.802985>, <-0.026773, 0.127616, 0.808314>, <-0.028800, 0.131817, 0.812707>, <-0.031531, 0.136543, 0.812707>, 
      <0.003863, 0.145202, 0.794746>, <0.004883, 0.145791, 0.800075>, <0.003459, 0.150214, 0.804510>, <0.000729, 0.154940, 0.804510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.145001, 0.000127, 0.856356>, <-0.145022, 0.001810, 0.861548>, <-0.149582, 0.003153, 0.865868>, <-0.155039, 0.003084, 0.865868>, 
      <-0.145504, 0.036897, 0.843530>, <-0.145526, 0.038580, 0.848722>, <-0.149256, 0.042833, 0.853012>, <-0.154714, 0.042763, 0.853012>, 
      <-0.122446, 0.064360, 0.830813>, <-0.121395, 0.065412, 0.836064>, <-0.125290, 0.067972, 0.840634>, <-0.129149, 0.071832, 0.840634>, 
      <-0.101659, 0.084618, 0.822210>, <-0.100608, 0.085670, 0.827461>, <-0.102944, 0.089756, 0.831832>, <-0.106804, 0.093616, 0.831832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.099108, -0.101653, 0.887186>, <-0.100344, -0.100417, 0.892356>, <-0.104585, -0.102599, 0.896659>, <-0.108444, -0.106459, 0.896659>, 
      <-0.122202, -0.078530, 0.875377>, <-0.123438, -0.077294, 0.880547>, <-0.128697, -0.077291, 0.884880>, <-0.132557, -0.081150, 0.884880>, 
      <-0.144423, -0.042077, 0.871078>, <-0.144444, -0.040394, 0.876270>, <-0.149952, -0.041989, 0.880495>, <-0.155409, -0.042059, 0.880495>, 
      <-0.145001, 0.000127, 0.856356>, <-0.145022, 0.001810, 0.861548>, <-0.149582, 0.003153, 0.865868>, <-0.155039, 0.003084, 0.865868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000056, -0.145000, 0.930473>, <-0.002458, -0.145013, 0.935374>, <-0.004431, -0.149567, 0.939453>, <-0.004401, -0.155025, 0.939453>, 
      <-0.039858, -0.145237, 0.909592>, <-0.042260, -0.145250, 0.914493>, <-0.046897, -0.148717, 0.918660>, <-0.046867, -0.154175, 0.918660>, 
      <-0.075887, -0.124903, 0.899060>, <-0.077123, -0.123667, 0.904230>, <-0.080555, -0.127821, 0.908397>, <-0.084414, -0.131680, 0.908397>, 
      <-0.099108, -0.101653, 0.887186>, <-0.100344, -0.100417, 0.892356>, <-0.104585, -0.102599, 0.896659>, <-0.108444, -0.106459, 0.896659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.101573, -0.100459, 0.992469>, <0.099822, -0.102210, 0.997333>, <0.101576, -0.106880, 1.001380>, <0.105436, -0.110739, 1.001380>, 
      <0.077905, -0.124166, 0.974254>, <0.076153, -0.125917, 0.979117>, <0.075563, -0.131379, 0.983200>, <0.079423, -0.135239, 0.983200>, 
      <0.043384, -0.144742, 0.953263>, <0.040982, -0.144755, 0.958164>, <0.041884, -0.150493, 0.962130>, <0.041915, -0.155951, 0.962130>, 
      <-0.000056, -0.145000, 0.930473>, <-0.002458, -0.145013, 0.935374>, <-0.004431, -0.149567, 0.939453>, <-0.004401, -0.155025, 0.939453>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145004, 0.000294, 1.042113>, <0.144924, -0.002454, 1.046828>, <0.149396, -0.004874, 1.050752>, <0.154852, -0.005034, 1.050752>, 
      <0.143744, -0.039018, 1.017354>, <0.143663, -0.041765, 1.022069>, <0.146758, -0.047052, 1.026153>, <0.152214, -0.047212, 1.026153>, 
      <0.123998, -0.077998, 1.009727>, <0.122246, -0.079750, 1.014591>, <0.126238, -0.083652, 1.018616>, <0.130097, -0.087512, 1.018616>, 
      <0.101573, -0.100459, 0.992469>, <0.099822, -0.102210, 0.997333>, <0.101576, -0.106880, 1.001380>, <0.105436, -0.110739, 1.001380>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107274, 0.077329, 1.104444>, <0.108997, 0.075631, 1.109337>, <0.113619, 0.077453, 1.113408>, <0.117450, 0.081341, 1.113408>, 
      <0.127358, 0.057642, 1.089580>, <0.129081, 0.055944, 1.094473>, <0.134637, 0.055498, 1.098346>, <0.138468, 0.059385, 1.098346>, 
      <0.146114, 0.034908, 1.063914>, <0.146033, 0.032161, 1.068629>, <0.151751, 0.032767, 1.072706>, <0.157206, 0.032607, 1.072706>, 
      <0.145004, 0.000294, 1.042113>, <0.144924, -0.002454, 1.046828>, <0.149396, -0.004874, 1.050752>, <0.154852, -0.005034, 1.050752>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001464, 0.143865, 1.150510>, <0.000722, 0.143794, 1.155510>, <0.002689, 0.148275, 1.159672>, <0.002866, 0.153730, 1.159672>, 
      <0.045907, 0.142213, 1.128377>, <0.048094, 0.142142, 1.133377>, <0.053244, 0.145349, 1.137523>, <0.053421, 0.150805, 1.137523>, 
      <0.081600, 0.102496, 1.123445>, <0.083323, 0.100798, 1.128338>, <0.086999, 0.105261, 1.132486>, <0.090829, 0.109149, 1.132486>, 
      <0.107274, 0.077329, 1.104444>, <0.108997, 0.075631, 1.109337>, <0.113619, 0.077453, 1.113408>, <0.117450, 0.081341, 1.113408>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101659, 0.084618, 1.202062>, <-0.100245, 0.086032, 1.207141>, <-0.102280, 0.090421, 1.211367>, <-0.106139, 0.094280, 1.211367>, 
      <-0.076795, 0.109518, 1.187217>, <-0.075380, 0.110932, 1.192295>, <-0.075121, 0.116331, 1.196567>, <-0.078980, 0.120191, 1.196567>, 
      <-0.045955, 0.145418, 1.171297>, <-0.043769, 0.145347, 1.176298>, <-0.044788, 0.151023, 1.180472>, <-0.044611, 0.156478, 1.180472>, 
      <-0.001464, 0.143865, 1.150510>, <0.000722, 0.143794, 1.155510>, <0.002689, 0.148275, 1.159672>, <0.002866, 0.153730, 1.159672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.145001, 0.000127, 1.236208>, <-0.145022, 0.001810, 1.241400>, <-0.149582, 0.003153, 1.245721>, <-0.155039, 0.003084, 1.245721>, 
      <-0.145504, 0.036897, 1.223382>, <-0.145526, 0.038580, 1.228574>, <-0.149122, 0.043176, 1.232733>, <-0.154580, 0.043106, 1.232733>, 
      <-0.121369, 0.064881, 1.213830>, <-0.119954, 0.066295, 1.218908>, <-0.124297, 0.069416, 1.223365>, <-0.128157, 0.073275, 1.223365>, 
      <-0.101659, 0.084618, 1.202062>, <-0.100245, 0.086032, 1.207141>, <-0.102280, 0.090421, 1.211367>, <-0.106139, 0.094280, 1.211367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.099108, -0.101653, 1.267038>, <-0.100344, -0.100417, 1.272209>, <-0.104585, -0.102599, 1.276511>, <-0.108444, -0.106459, 1.276511>, 
      <-0.122202, -0.078530, 1.255230>, <-0.123438, -0.077294, 1.260400>, <-0.128698, -0.077291, 1.264733>, <-0.132557, -0.081150, 1.264733>, 
      <-0.144423, -0.042077, 1.250930>, <-0.144444, -0.040394, 1.256122>, <-0.150100, -0.041981, 1.260368>, <-0.155557, -0.042051, 1.260368>, 
      <-0.145001, 0.000127, 1.236208>, <-0.145022, 0.001810, 1.241400>, <-0.149582, 0.003153, 1.245721>, <-0.155039, 0.003084, 1.245721>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000056, -0.145000, 1.310326>, <-0.002458, -0.145013, 1.315227>, <-0.004431, -0.149567, 1.319306>, <-0.004401, -0.155025, 1.319306>, 
      <-0.039858, -0.145237, 1.289444>, <-0.042260, -0.145250, 1.294345>, <-0.046905, -0.148637, 1.298531>, <-0.046875, -0.154095, 1.298531>, 
      <-0.075887, -0.124903, 1.278912>, <-0.077123, -0.123667, 1.284083>, <-0.080555, -0.127821, 1.288250>, <-0.084414, -0.131680, 1.288250>, 
      <-0.099108, -0.101653, 1.267038>, <-0.100344, -0.100417, 1.272209>, <-0.104585, -0.102599, 1.276511>, <-0.108444, -0.106459, 1.276511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.101573, -0.100459, 1.372322>, <0.099608, -0.102424, 1.377019>, <0.101184, -0.107271, 1.380928>, <0.105044, -0.111131, 1.380928>, 
      <0.078797, -0.123272, 1.351956>, <0.076831, -0.125238, 1.356653>, <0.076124, -0.130787, 1.360625>, <0.079983, -0.134646, 1.360625>, 
      <0.043384, -0.144742, 1.333115>, <0.040982, -0.144755, 1.338016>, <0.041687, -0.150576, 1.341862>, <0.041717, -0.156034, 1.341862>, 
      <-0.000056, -0.145000, 1.310326>, <-0.002458, -0.145013, 1.315227>, <-0.004431, -0.149567, 1.319306>, <-0.004401, -0.155025, 1.319306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145004, 0.000294, 1.440032>, <0.144914, -0.002765, 1.444551>, <0.149380, -0.005444, 1.448312>, <0.154835, -0.005604, 1.448312>, 
      <0.143729, -0.039858, 1.410672>, <0.143639, -0.042917, 1.415191>, <0.146598, -0.048433, 1.419184>, <0.152054, -0.048593, 1.419184>, 
      <0.124677, -0.077318, 1.392980>, <0.122711, -0.079284, 1.397677>, <0.126563, -0.083457, 1.401489>, <0.130423, -0.087316, 1.401489>, 
      <0.101573, -0.100459, 1.372322>, <0.099608, -0.102424, 1.377019>, <0.101184, -0.107271, 1.380928>, <0.105044, -0.111131, 1.380928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107222, 0.077381, 1.502363>, <0.108968, 0.075635, 1.507231>, <0.113632, 0.077394, 1.511281>, <0.117491, 0.081254, 1.511281>, 
      <0.127375, 0.057773, 1.487452>, <0.129120, 0.056027, 1.492320>, <0.134610, 0.055466, 1.495776>, <0.138470, 0.059325, 1.495776>, 
      <0.146054, 0.033334, 1.464191>, <0.145964, 0.030275, 1.468711>, <0.151725, 0.030799, 1.472869>, <0.157180, 0.030638, 1.472869>, 
      <0.145004, 0.000294, 1.440032>, <0.144914, -0.002765, 1.444551>, <0.149380, -0.005444, 1.448312>, <0.154835, -0.005604, 1.448312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.005253, 0.146491, 1.551208>, <-0.003665, 0.145511, 1.556337>, <0.000041, 0.148560, 1.560606>, <0.002908, 0.153205, 1.560606>, 
      <0.038156, 0.119819, 1.532357>, <0.039743, 0.118839, 1.537486>, <0.044263, 0.120792, 1.541570>, <0.047130, 0.125436, 1.541570>, 
      <0.080484, 0.103397, 1.522147>, <0.082230, 0.101651, 1.527014>, <0.087037, 0.105194, 1.530939>, <0.090896, 0.109053, 1.530939>, 
      <0.107222, 0.077381, 1.502363>, <0.108968, 0.075635, 1.507231>, <0.113632, 0.077394, 1.511281>, <0.117491, 0.081254, 1.511281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.106804, 0.093616, 0.831832>, <-0.110663, 0.097475, 0.831832>, <-0.114750, 0.099812, 0.827461>, <-0.115801, 0.098760, 0.822210>, 
      <-0.080595, 0.119166, 0.821508>, <-0.084454, 0.123026, 0.821508>, <-0.088492, 0.126696, 0.817277>, <-0.089543, 0.125645, 0.812026>, 
      <-0.031531, 0.136543, 0.812707>, <-0.034262, 0.141268, 0.812707>, <-0.038021, 0.143980, 0.808314>, <-0.039041, 0.143391, 0.802985>, 
      <0.000729, 0.154940, 0.804510>, <-0.002002, 0.159666, 0.804510>, <-0.005123, 0.163108, 0.800075>, <-0.006143, 0.162519, 0.794746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155039, 0.003084, 0.865868>, <-0.160497, 0.003014, 0.865868>, <-0.165021, 0.001556, 0.861548>, <-0.164999, -0.000127, 0.856356>, 
      <-0.154714, 0.042763, 0.853012>, <-0.160171, 0.042694, 0.853012>, <-0.165528, 0.044255, 0.848617>, <-0.165507, 0.042572, 0.843425>, 
      <-0.129149, 0.071832, 0.840634>, <-0.133008, 0.075691, 0.840634>, <-0.138140, 0.075864, 0.836533>, <-0.139191, 0.074813, 0.831281>, 
      <-0.106804, 0.093616, 0.831832>, <-0.110663, 0.097475, 0.831832>, <-0.114750, 0.099812, 0.827461>, <-0.115801, 0.098760, 0.822210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.108444, -0.106459, 0.896659>, <-0.112304, -0.110318, 0.896659>, <-0.114487, -0.114559, 0.892356>, <-0.113250, -0.115795, 0.887186>, 
      <-0.132557, -0.081150, 0.884880>, <-0.136416, -0.085010, 0.884880>, <-0.140867, -0.088207, 0.880510>, <-0.139631, -0.089443, 0.875340>, 
      <-0.155409, -0.042059, 0.880495>, <-0.160867, -0.042128, 0.880495>, <-0.164448, -0.046612, 0.876135>, <-0.164427, -0.048295, 0.870943>, 
      <-0.155039, 0.003084, 0.865868>, <-0.160497, 0.003014, 0.865868>, <-0.165021, 0.001556, 0.861548>, <-0.164999, -0.000127, 0.856356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.004401, -0.155025, 0.939453>, <-0.004370, -0.160482, 0.939453>, <-0.002346, -0.165013, 0.935374>, <0.000056, -0.165000, 0.930473>, 
      <-0.046867, -0.154175, 0.918660>, <-0.046837, -0.159633, 0.918660>, <-0.048243, -0.165253, 0.914270>, <-0.045841, -0.165239, 0.909369>, 
      <-0.084414, -0.131680, 0.908397>, <-0.088274, -0.135540, 0.908397>, <-0.088009, -0.141007, 0.904246>, <-0.086772, -0.142243, 0.899076>, 
      <-0.108444, -0.106459, 0.896659>, <-0.112304, -0.110318, 0.896659>, <-0.114487, -0.114559, 0.892356>, <-0.113250, -0.115795, 0.887186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105436, -0.110739, 1.001380>, <0.109295, -0.114598, 1.001380>, <0.113964, -0.116352, 0.997333>, <0.115716, -0.114601, 0.992469>, 
      <0.079423, -0.135239, 0.983200>, <0.083282, -0.139098, 0.983200>, <0.087050, -0.143228, 0.979116>, <0.088802, -0.141476, 0.974253>, 
      <0.041915, -0.155951, 0.962130>, <0.041945, -0.161409, 0.962130>, <0.046944, -0.164756, 0.958039>, <0.049346, -0.164743, 0.953138>, 
      <-0.004401, -0.155025, 0.939453>, <-0.004370, -0.160482, 0.939453>, <-0.002346, -0.165013, 0.935374>, <0.000056, -0.165000, 0.930473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.154852, -0.005034, 1.050752>, <0.160307, -0.005195, 1.050752>, <0.164915, -0.003042, 1.046828>, <0.164996, -0.000294, 1.042113>, 
      <0.152214, -0.047212, 1.026153>, <0.157669, -0.047373, 1.026153>, <0.163682, -0.048479, 1.022151>, <0.163762, -0.045731, 1.017436>, 
      <0.130097, -0.087512, 1.018616>, <0.133957, -0.091371, 1.018616>, <0.139621, -0.090732, 1.014699>, <0.141373, -0.088980, 1.009836>, 
      <0.105436, -0.110739, 1.001380>, <0.109295, -0.114598, 1.001380>, <0.113964, -0.116352, 0.997333>, <0.115716, -0.114601, 0.992469>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117450, 0.081341, 1.113408>, <0.121281, 0.085229, 1.113408>, <0.123035, 0.089877, 1.109337>, <0.121312, 0.091575, 1.104444>, 
      <0.138468, 0.059385, 1.098346>, <0.142299, 0.063273, 1.098346>, <0.146103, 0.067041, 1.094257>, <0.144379, 0.068739, 1.089364>, 
      <0.157206, 0.032607, 1.072706>, <0.162662, 0.032446, 1.072706>, <0.166013, 0.037408, 1.068797>, <0.166094, 0.040156, 1.064082>, 
      <0.154852, -0.005034, 1.050752>, <0.160307, -0.005195, 1.050752>, <0.164915, -0.003042, 1.046828>, <0.164996, -0.000294, 1.042113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.002866, 0.153730, 1.159672>, <0.003043, 0.159185, 1.159672>, <0.001371, 0.163784, 1.155510>, <-0.000816, 0.163855, 1.150510>, 
      <0.053421, 0.150805, 1.137523>, <0.053598, 0.156260, 1.137523>, <0.054597, 0.162171, 1.133598>, <0.052411, 0.162242, 1.128597>, 
      <0.090829, 0.109149, 1.132486>, <0.094660, 0.113037, 1.132486>, <0.094187, 0.118436, 1.128196>, <0.092463, 0.120134, 1.123303>, 
      <0.117450, 0.081341, 1.113408>, <0.121281, 0.085229, 1.113408>, <0.123035, 0.089877, 1.109337>, <0.121312, 0.091575, 1.104444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.106139, 0.094280, 1.211367>, <-0.109998, 0.098140, 1.211367>, <-0.114387, 0.100175, 1.207141>, <-0.115801, 0.098760, 1.202062>, 
      <-0.078980, 0.120191, 1.196567>, <-0.082840, 0.124050, 1.196567>, <-0.086146, 0.128381, 1.192400>, <-0.087560, 0.126967, 1.187321>, 
      <-0.044611, 0.156478, 1.180472>, <-0.044434, 0.161933, 1.180472>, <-0.049226, 0.165317, 1.176341>, <-0.051413, 0.165388, 1.171341>, 
      <0.002866, 0.153730, 1.159672>, <0.003043, 0.159185, 1.159672>, <0.001371, 0.163784, 1.155510>, <-0.000816, 0.163855, 1.150510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155039, 0.003084, 1.245721>, <-0.160497, 0.003014, 1.245721>, <-0.165021, 0.001556, 1.241400>, <-0.164999, -0.000127, 1.236208>, 
      <-0.154580, 0.043106, 1.232733>, <-0.160037, 0.043037, 1.232733>, <-0.165528, 0.044255, 1.228469>, <-0.165507, 0.042572, 1.223277>, 
      <-0.128157, 0.073275, 1.223365>, <-0.132016, 0.077134, 1.223365>, <-0.137406, 0.077183, 1.219156>, <-0.138821, 0.075769, 1.214078>, 
      <-0.106139, 0.094280, 1.211367>, <-0.109998, 0.098140, 1.211367>, <-0.114387, 0.100175, 1.207141>, <-0.115801, 0.098760, 1.202062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.108444, -0.106459, 1.276511>, <-0.112304, -0.110318, 1.276511>, <-0.114487, -0.114559, 1.272209>, <-0.113250, -0.115795, 1.267038>, 
      <-0.132557, -0.081150, 1.264733>, <-0.136416, -0.085010, 1.264733>, <-0.140867, -0.088207, 1.260363>, <-0.139631, -0.089443, 1.255192>, 
      <-0.155557, -0.042051, 1.260368>, <-0.161015, -0.042120, 1.260368>, <-0.164448, -0.046612, 1.255988>, <-0.164427, -0.048295, 1.250795>, 
      <-0.155039, 0.003084, 1.245721>, <-0.160497, 0.003014, 1.245721>, <-0.165021, 0.001556, 1.241400>, <-0.164999, -0.000127, 1.236208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.004401, -0.155025, 1.319306>, <-0.004370, -0.160482, 1.319306>, <-0.002346, -0.165013, 1.315227>, <0.000056, -0.165000, 1.310326>, 
      <-0.046875, -0.154095, 1.298531>, <-0.046844, -0.159553, 1.298531>, <-0.048243, -0.165253, 1.294123>, <-0.045841, -0.165239, 1.289222>, 
      <-0.084414, -0.131680, 1.288250>, <-0.088274, -0.135540, 1.288250>, <-0.088009, -0.141007, 1.284099>, <-0.086772, -0.142243, 1.278928>, 
      <-0.108444, -0.106459, 1.276511>, <-0.112304, -0.110318, 1.276511>, <-0.114487, -0.114559, 1.272209>, <-0.113250, -0.115795, 1.267038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105044, -0.111131, 1.380928>, <0.108903, -0.114990, 1.380928>, <0.113750, -0.116566, 1.377019>, <0.115716, -0.114601, 1.372322>, 
      <0.079983, -0.134646, 1.360625>, <0.083843, -0.138506, 1.360625>, <0.087674, -0.142605, 1.356513>, <0.089640, -0.140640, 1.351816>, 
      <0.041717, -0.156034, 1.341862>, <0.041748, -0.161492, 1.341862>, <0.046944, -0.164756, 1.337892>, <0.049346, -0.164743, 1.332991>, 
      <-0.004401, -0.155025, 1.319306>, <-0.004370, -0.160482, 1.319306>, <-0.002346, -0.165013, 1.315227>, <0.000056, -0.165000, 1.310326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.154835, -0.005604, 1.448312>, <0.160291, -0.005765, 1.448312>, <0.164906, -0.003353, 1.444551>, <0.164996, -0.000294, 1.440032>, 
      <0.152054, -0.048593, 1.419184>, <0.157509, -0.048754, 1.419184>, <0.163639, -0.049593, 1.415379>, <0.163729, -0.046534, 1.410860>, 
      <0.130423, -0.087316, 1.401489>, <0.134282, -0.091175, 1.401489>, <0.140036, -0.090318, 1.397690>, <0.142001, -0.088353, 1.392992>, 
      <0.105044, -0.111131, 1.380928>, <0.108903, -0.114990, 1.380928>, <0.113750, -0.116566, 1.377019>, <0.115716, -0.114601, 1.372322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117491, 0.081254, 1.511281>, <0.121351, 0.085113, 1.511281>, <0.123110, 0.089777, 1.507231>, <0.121364, 0.091523, 1.502363>, 
      <0.138470, 0.059325, 1.495776>, <0.142329, 0.063185, 1.495776>, <0.145574, 0.066742, 1.491596>, <0.143829, 0.068488, 1.486728>, 
      <0.157180, 0.030638, 1.472869>, <0.162636, 0.030478, 1.472869>, <0.165972, 0.035559, 1.469100>, <0.166062, 0.038618, 1.464581>, 
      <0.154835, -0.005604, 1.448312>, <0.160291, -0.005765, 1.448312>, <0.164906, -0.003353, 1.444551>, <0.164996, -0.000294, 1.440032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.002908, 0.153205, 1.560606>, <0.005775, 0.157849, 1.560606>, <0.006840, 0.162530, 1.556337>, <0.005253, 0.163510, 1.551208>, 
      <0.047130, 0.125436, 1.541570>, <0.049997, 0.130081, 1.541570>, <0.051652, 0.134747, 1.537486>, <0.050064, 0.135727, 1.532357>, 
      <0.090896, 0.109053, 1.530939>, <0.094756, 0.112913, 1.530939>, <0.095777, 0.117805, 1.526253>, <0.094031, 0.119551, 1.521386>, 
      <0.117491, 0.081254, 1.511281>, <0.121351, 0.085113, 1.511281>, <0.123110, 0.089777, 1.507231>, <0.121364, 0.091523, 1.502363>
    }
  }
  material {
    cuerdas_txt
  }
  photons {
    collect off
  }
}
#declare tela = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.986513, 0.852978, 0.750519>, <-0.795782, 0.685816, 0.772026>, <-0.542662, 0.462221, 0.806535>, <-0.350743, 0.295772, 0.822210>, 
      <-0.836723, 1.033924, 0.741594>, <-0.645992, 0.866762, 0.763101>, <-0.457757, 0.547126, 0.795996>, <-0.265838, 0.380676, 0.811670>, 
      <-0.513649, 1.130249, 0.731294>, <-0.421454, 0.904422, 0.752801>, <-0.174325, 0.671311, 0.787592>, <-0.107797, 0.436158, 0.802985>, 
      <-0.310994, 1.249080, 0.723055>, <-0.218799, 1.023253, 0.744562>, <-0.070205, 0.731477, 0.779353>, <-0.003677, 0.496323, 0.794746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.345000, 0.000000, 0.784665>, <-1.091500, 0.000000, 0.806172>, <-0.753950, 0.000000, 0.841057>, <-0.500000, 0.000000, 0.856356>, 
      <-1.357943, 0.356864, 0.771757>, <-1.104443, 0.356864, 0.793264>, <-0.755578, 0.127883, 0.828204>, <-0.501628, 0.127883, 0.843503>, 
      <-1.163507, 0.639169, 0.761065>, <-0.972776, 0.472007, 0.782572>, <-0.613043, 0.391840, 0.815272>, <-0.421123, 0.225391, 0.830947>, 
      <-0.986513, 0.852978, 0.750519>, <-0.795782, 0.685816, 0.772026>, <-0.542662, 0.462221, 0.806535>, <-0.350743, 0.295772, 0.822210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.921362, -0.943442, 0.815495>, <-0.747707, -0.765626, 0.837002>, <-0.516489, -0.528866, 0.871885>, <-0.342514, -0.350722, 0.887186>, 
      <-1.143024, -0.726505, 0.803280>, <-0.969370, -0.548689, 0.824787>, <-0.597861, -0.447494, 0.859823>, <-0.423885, -0.269350, 0.875124>, 
      <-1.330537, -0.398788, 0.799089>, <-1.077037, -0.398788, 0.820596>, <-0.752065, -0.148095, 0.855941>, <-0.498115, -0.148095, 0.871240>, 
      <-1.345000, 0.000000, 0.784665>, <-1.091500, 0.000000, 0.806172>, <-0.753950, 0.000000, 0.841057>, <-0.500000, 0.000000, 0.856356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.316324, 0.858782>, <0.000000, -1.071427, 0.880290>, <0.000000, -0.745373, 0.915326>, <0.000000, -0.500000, 0.930473>, 
      <-0.383352, -1.318454, 0.837131>, <-0.383352, -1.073557, 0.858638>, <-0.143514, -0.746170, 0.893522>, <-0.143514, -0.500798, 0.908670>, 
      <-0.708215, -1.152043, 0.827240>, <-0.534561, -0.974227, 0.848748>, <-0.437134, -0.608221, 0.883649>, <-0.263159, -0.430076, 0.898949>, 
      <-0.921362, -0.943442, 0.815495>, <-0.747707, -0.765626, 0.837002>, <-0.516489, -0.528866, 0.871885>, <-0.342514, -0.350722, 0.887186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.942754, -0.933081, 0.920778>, <0.765068, -0.757218, 0.942286>, <0.528477, -0.523055, 0.977169>, <0.350466, -0.346870, 0.992469>, 
      <0.724538, -1.146645, 0.902666>, <0.546852, -0.970781, 0.924173>, <0.447292, -0.604240, 0.959042>, <0.269281, -0.428056, 0.974342>, 
      <0.392855, -1.314140, 0.880970>, <0.392855, -1.069243, 0.902478>, <0.147834, -0.744551, 0.937786>, <0.147834, -0.499178, 0.952933>, 
      <0.000000, -1.316324, 0.858782>, <0.000000, -1.071427, 0.880290>, <0.000000, -0.745373, 0.915326>, <0.000000, -0.500000, 0.930473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.345000, 0.000000, 0.970422>, <1.091500, 0.000000, 0.991929>, <0.753950, 0.000000, 1.026814>, <0.500000, 0.000000, 1.042113>, 
      <1.333480, -0.391564, 0.944103>, <1.079980, -0.391564, 0.965610>, <0.749695, -0.144627, 1.000664>, <0.495745, -0.144627, 1.015963>, 
      <1.160487, -0.719991, 0.938851>, <0.982800, -0.544128, 0.960358>, <0.608306, -0.443226, 0.994993>, <0.430295, -0.267042, 1.010293>, 
      <0.942754, -0.933081, 0.920778>, <0.765068, -0.757218, 0.942286>, <0.528477, -0.523055, 0.977169>, <0.350466, -0.346870, 0.992469>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.991768, 0.732827, 1.032753>, <0.804844, 0.594706, 1.054260>, <0.556006, 0.410838, 1.089140>, <0.368687, 0.272426, 1.104444>, 
      <1.185553, 0.584140, 1.016885>, <0.998629, 0.446020, 1.038392>, <0.621226, 0.346570, 1.075104>, <0.433907, 0.208159, 1.090408>, 
      <1.354240, 0.314043, 0.991530>, <1.100740, 0.314043, 1.013038>, <0.757399, 0.117219, 1.048008>, <0.503449, 0.117219, 1.063307>, 
      <1.345000, 0.000000, 0.970422>, <1.091500, 0.000000, 0.991929>, <0.753950, 0.000000, 1.026814>, <0.500000, 0.000000, 1.042113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.021258, 1.015670, 1.078819>, <0.013778, 0.859866, 1.100326>, <0.000400, 0.653188, 1.137461>, <-0.003677, 0.496323, 1.150510>, 
      <0.409919, 1.046799, 1.056493>, <0.402438, 0.890995, 1.078000>, <0.167410, 0.647768, 1.114800>, <0.163333, 0.490904, 1.127849>, 
      <0.751421, 0.917237, 1.052434>, <0.564497, 0.779117, 1.073942>, <0.463718, 0.501778, 1.109001>, <0.276399, 0.363366, 1.124306>, 
      <0.991768, 0.732827, 1.032753>, <0.804844, 0.594706, 1.054260>, <0.556006, 0.410838, 1.089140>, <0.368687, 0.272426, 1.104444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.707624, 0.596719, 1.130371>, <-0.600559, 0.506435, 1.151879>, <-0.458612, 0.386734, 1.189150>, <-0.350743, 0.295772, 1.202062>, 
      <-0.534453, 0.780102, 1.115114>, <-0.427388, 0.689817, 1.136621>, <-0.373511, 0.471834, 1.174456>, <-0.265643, 0.380872, 1.187368>, 
      <-0.302245, 0.989760, 1.097402>, <-0.309725, 0.833956, 1.118909>, <-0.154079, 0.658201, 1.158422>, <-0.158156, 0.501336, 1.171471>, 
      <0.021258, 1.015670, 1.078819>, <0.013778, 0.859866, 1.100326>, <0.000400, 0.653188, 1.137461>, <-0.003677, 0.496323, 1.150510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.951397, -0.014338, 1.164517>, <-0.815978, -0.010037, 1.186025>, <-0.636610, -0.002459, 1.223911>, <-0.500000, 0.000000, 1.236208>, 
      <-0.969128, 0.238953, 1.151469>, <-0.833709, 0.243254, 1.172976>, <-0.638237, 0.125424, 1.211058>, <-0.501628, 0.127883, 1.223356>, 
      <-0.843065, 0.453291, 1.142305>, <-0.736001, 0.363007, 1.163812>, <-0.528742, 0.316604, 1.201259>, <-0.420873, 0.225641, 1.214172>, 
      <-0.707624, 0.596719, 1.130371>, <-0.600559, 0.506435, 1.151879>, <-0.458612, 0.386734, 1.189150>, <-0.350743, 0.295772, 1.202062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.619330, -0.664566, 1.195347>, <-0.536285, -0.570413, 1.216855>, <-0.428529, -0.443893, 1.255021>, <-0.342514, -0.350722, 1.267038>, 
      <-0.793048, -0.531404, 1.183052>, <-0.710003, -0.437250, 1.204560>, <-0.509901, -0.362521, 1.242959>, <-0.423885, -0.269350, 1.254976>, 
      <-0.931728, -0.295308, 1.178992>, <-0.796309, -0.291007, 1.200499>, <-0.634724, -0.150555, 1.238795>, <-0.498115, -0.148095, 1.251093>, 
      <-0.951397, -0.014338, 1.164517>, <-0.815978, -0.010037, 1.186025>, <-0.636610, -0.002459, 1.223911>, <-0.500000, 0.000000, 1.236208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.095831, -0.817087, 1.238635>, <0.067082, -0.721961, 1.260142>, <0.014482, -0.600055, 1.299492>, <0.000000, -0.500000, 1.310326>, 
      <-0.185136, -0.838406, 1.215666>, <-0.213885, -0.743280, 1.237173>, <-0.129031, -0.600853, 1.277688>, <-0.143514, -0.500798, 1.288522>, 
      <-0.445194, -0.798050, 1.207672>, <-0.362149, -0.703897, 1.229179>, <-0.349174, -0.523247, 1.266784>, <-0.263159, -0.430076, 1.278801>, 
      <-0.619330, -0.664566, 1.195347>, <-0.536285, -0.570413, 1.216855>, <-0.428529, -0.443893, 1.255021>, <-0.342514, -0.350722, 1.267038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.668554, -0.566847, 1.300631>, <0.573128, -0.500854, 1.322138>, <0.441252, -0.421346, 1.360698>, <0.350466, -0.346870, 1.372322>, 
      <0.536151, -0.699250, 1.279613>, <0.440725, -0.633257, 1.301120>, <0.360410, -0.502188, 1.339726>, <0.269624, -0.427713, 1.351350>, 
      <0.336735, -0.798809, 1.258329>, <0.307985, -0.703682, 1.279836>, <0.162316, -0.599233, 1.321952>, <0.147834, -0.499178, 1.332786>, 
      <0.095831, -0.817087, 1.238635>, <0.067082, -0.721961, 1.260142>, <0.014482, -0.600055, 1.299492>, <0.000000, -0.500000, 1.310326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.912919, 0.000000, 1.368341>, <0.789043, 0.000000, 1.389848>, <0.625170, 0.000000, 1.428192>, <0.500000, 0.000000, 1.440032>, 
      <0.940472, -0.236051, 1.337403>, <0.816596, -0.236051, 1.358910>, <0.620907, -0.144883, 1.397769>, <0.495737, -0.144883, 1.409609>, 
      <0.799462, -0.435940, 1.321411>, <0.704035, -0.369947, 1.342919>, <0.521322, -0.341276, 1.381469>, <0.430536, -0.266801, 1.393093>, 
      <0.668554, -0.566847, 1.300631>, <0.573128, -0.500854, 1.322138>, <0.441252, -0.421346, 1.360698>, <0.350466, -0.346870, 1.372322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.552742, 0.425339, 1.430672>, <0.497526, 0.379465, 1.452179>, <0.427362, 0.318045, 1.492769>, <0.368687, 0.272426, 1.502363>, 
      <0.699391, 0.346181, 1.407532>, <0.644174, 0.300307, 1.429040>, <0.506618, 0.273744, 1.474417>, <0.447943, 0.228125, 1.484011>, 
      <0.888035, 0.213186, 1.396282>, <0.764159, 0.213186, 1.417789>, <0.628600, 0.116578, 1.452671>, <0.503430, 0.116578, 1.464511>, 
      <0.912919, 0.000000, 1.368341>, <0.789043, 0.000000, 1.389848>, <0.625170, 0.000000, 1.428192>, <0.500000, 0.000000, 1.440032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208331, 0.380323, 1.479517>, <0.151788, 0.346741, 1.501024>, <0.065594, 0.317854, 1.535468>, <0.019853, 0.268383, 1.551208>, 
      <0.341252, 0.397697, 1.460666>, <0.284709, 0.364114, 1.482173>, <0.200222, 0.319415, 1.516617>, <0.154481, 0.269943, 1.532357>, 
      <0.461023, 0.474847, 1.445144>, <0.405807, 0.428973, 1.466651>, <0.336944, 0.368585, 1.513705>, <0.278270, 0.322966, 1.523299>, 
      <0.552742, 0.425339, 1.430672>, <0.497526, 0.379465, 1.452179>, <0.427362, 0.318045, 1.492769>, <0.368687, 0.272426, 1.502363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.350743, 0.295772, 0.822210>, <-0.279131, 0.233664, 0.828059>, <-0.181334, 0.152914, 0.822210>, <-0.108730, 0.091689, 0.822210>, 
      <-0.265838, 0.380676, 0.811670>, <-0.194227, 0.318569, 0.817519>, <-0.155359, 0.178889, 0.811809>, <-0.082755, 0.117664, 0.811809>, 
      <-0.107797, 0.436158, 0.802985>, <-0.079883, 0.337492, 0.809443>, <-0.034178, 0.237948, 0.802985>, <-0.033417, 0.135209, 0.802985>, 
      <-0.003677, 0.496323, 0.794746>, <0.024237, 0.397657, 0.801204>, <-0.001901, 0.256599, 0.794746>, <-0.001140, 0.153860, 0.794746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.856356>, <-0.396687, 0.000000, 0.862580>, <-0.258500, 0.000000, 0.856356>, <-0.155000, 0.000000, 0.856356>, 
      <-0.501628, 0.127883, 0.843503>, <-0.398315, 0.127883, 0.849727>, <-0.259006, 0.039731, 0.843475>, <-0.155506, 0.039731, 0.843475>, 
      <-0.421123, 0.225391, 0.830947>, <-0.349512, 0.163283, 0.836795>, <-0.203425, 0.130823, 0.831056>, <-0.130821, 0.069599, 0.831056>, 
      <-0.350743, 0.295772, 0.822210>, <-0.279131, 0.233664, 0.828059>, <-0.181334, 0.152914, 0.822210>, <-0.108730, 0.091689, 0.822210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342514, -0.350722, 0.887186>, <-0.271747, -0.278259, 0.893409>, <-0.177080, -0.181323, 0.887186>, <-0.106179, -0.108724, 0.887186>, 
      <-0.423885, -0.269350, 0.875124>, <-0.353119, -0.196887, 0.881347>, <-0.201818, -0.156584, 0.875356>, <-0.130918, -0.083985, 0.875356>, 
      <-0.498115, -0.148095, 0.871240>, <-0.394802, -0.148095, 0.877464>, <-0.257925, -0.045192, 0.871007>, <-0.154425, -0.045192, 0.871007>, 
      <-0.500000, 0.000000, 0.856356>, <-0.396687, 0.000000, 0.862580>, <-0.258500, 0.000000, 0.856356>, <-0.155000, 0.000000, 0.856356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.500000, 0.930473>, <0.000000, -0.396697, 0.936851>, <0.000000, -0.258500, 0.930473>, <0.000000, -0.155000, 0.930473>, 
      <-0.143514, -0.500798, 0.908670>, <-0.143514, -0.397494, 0.915047>, <-0.042851, -0.258738, 0.909472>, <-0.042851, -0.155238, 0.909472>, 
      <-0.263159, -0.430076, 0.898949>, <-0.192392, -0.357613, 0.905172>, <-0.152231, -0.206171, 0.899068>, <-0.081331, -0.133572, 0.899068>, 
      <-0.342514, -0.350722, 0.887186>, <-0.271747, -0.278259, 0.893409>, <-0.177080, -0.181323, 0.887186>, <-0.106179, -0.108724, 0.887186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.350466, -0.346870, 0.992469>, <0.278055, -0.275202, 0.998693>, <0.181191, -0.179332, 0.992469>, <0.108645, -0.107530, 0.992469>, 
      <0.269281, -0.428056, 0.974342>, <0.196869, -0.356387, 0.980566>, <0.155900, -0.204623, 0.974253>, <0.083354, -0.132821, 0.974253>, 
      <0.147834, -0.499178, 0.952933>, <0.147834, -0.395875, 0.959311>, <0.046366, -0.258242, 0.953197>, <0.046366, -0.154742, 0.953197>, 
      <0.000000, -0.500000, 0.930473>, <0.000000, -0.396697, 0.936851>, <0.000000, -0.258500, 0.930473>, <0.000000, -0.155000, 0.930473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 1.042113>, <0.396687, 0.000000, 1.048337>, <0.258500, 0.000000, 1.042113>, <0.155000, 0.000000, 1.042113>, 
      <0.495745, -0.144627, 1.015963>, <0.392432, -0.144627, 1.022187>, <0.257253, -0.042387, 1.017391>, <0.153753, -0.042387, 1.017391>, 
      <0.430295, -0.267042, 1.010293>, <0.357883, -0.195373, 1.016517>, <0.205233, -0.155290, 1.009785>, <0.132686, -0.083488, 1.009785>, 
      <0.350466, -0.346870, 0.992469>, <0.278055, -0.275202, 0.998693>, <0.181191, -0.179332, 0.992469>, <0.108645, -0.107530, 0.992469>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.368687, 0.272426, 1.104444>, <0.292533, 0.216155, 1.110666>, <0.190611, 0.140844, 1.104444>, <0.114293, 0.084452, 1.104444>, 
      <0.433907, 0.208159, 1.090408>, <0.357753, 0.151888, 1.096630>, <0.212176, 0.119595, 1.089474>, <0.135857, 0.063202, 1.089474>, 
      <0.503449, 0.117219, 1.063307>, <0.400136, 0.117219, 1.069531>, <0.259604, 0.037520, 1.063997>, <0.156104, 0.037520, 1.063997>, 
      <0.500000, 0.000000, 1.042113>, <0.396687, 0.000000, 1.048337>, <0.258500, 0.000000, 1.042113>, <0.155000, 0.000000, 1.042113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.003677, 0.496323, 1.150510>, <-0.006337, 0.393969, 1.159024>, <-0.001901, 0.256599, 1.150510>, <-0.001140, 0.153860, 1.150510>, 
      <0.163333, 0.490904, 1.127849>, <0.160673, 0.388550, 1.136363>, <0.048406, 0.254967, 1.128490>, <0.049167, 0.152228, 1.128490>, 
      <0.276399, 0.363366, 1.124306>, <0.200245, 0.307096, 1.130527>, <0.163344, 0.167713, 1.123374>, <0.087026, 0.111321, 1.123374>, 
      <0.368687, 0.272426, 1.104444>, <0.292533, 0.216155, 1.110666>, <0.190611, 0.140844, 1.104444>, <0.114293, 0.084452, 1.104444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.350743, 0.295772, 1.202062>, <-0.278441, 0.234802, 1.210717>, <-0.181334, 0.152914, 1.202062>, <-0.108730, 0.091689, 1.202062>, 
      <-0.265643, 0.380872, 1.187368>, <-0.193341, 0.319902, 1.196023>, <-0.154781, 0.179467, 1.187273>, <-0.082177, 0.118242, 1.187273>, 
      <-0.158156, 0.501336, 1.171471>, <-0.160816, 0.398982, 1.179985>, <-0.049444, 0.258142, 1.171320>, <-0.048683, 0.155403, 1.171320>, 
      <-0.003677, 0.496323, 1.150510>, <-0.006337, 0.393969, 1.159024>, <-0.001901, 0.256599, 1.150510>, <-0.001140, 0.153860, 1.150510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 1.236208>, <-0.396933, 0.001856, 1.245486>, <-0.258500, 0.000000, 1.236208>, <-0.155000, 0.000000, 1.236208>, 
      <-0.501628, 0.127883, 1.223356>, <-0.398561, 0.129739, 1.232633>, <-0.259006, 0.039731, 1.223327>, <-0.155506, 0.039731, 1.223327>, 
      <-0.420873, 0.225641, 1.214172>, <-0.348572, 0.164671, 1.222827>, <-0.202696, 0.131552, 1.213961>, <-0.130092, 0.070327, 1.213961>, 
      <-0.350743, 0.295772, 1.202062>, <-0.278441, 0.234802, 1.210717>, <-0.181334, 0.152914, 1.202062>, <-0.108730, 0.091689, 1.202062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342514, -0.350722, 1.267038>, <-0.273986, -0.276493, 1.276612>, <-0.177080, -0.181323, 1.267038>, <-0.106179, -0.108724, 1.267038>, 
      <-0.423885, -0.269350, 1.254976>, <-0.355358, -0.195121, 1.264550>, <-0.201818, -0.156584, 1.255209>, <-0.130918, -0.083985, 1.255209>, 
      <-0.498115, -0.148095, 1.251093>, <-0.395048, -0.146239, 1.260371>, <-0.257925, -0.045192, 1.250860>, <-0.154425, -0.045192, 1.250860>, 
      <-0.500000, 0.000000, 1.236208>, <-0.396933, 0.001856, 1.245486>, <-0.258500, 0.000000, 1.236208>, <-0.155000, 0.000000, 1.236208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.500000, 1.310326>, <-0.014742, -0.398151, 1.321354>, <0.000000, -0.258500, 1.310326>, <0.000000, -0.155000, 1.310326>, 
      <-0.143514, -0.500798, 1.288522>, <-0.158255, -0.398948, 1.299550>, <-0.042851, -0.258738, 1.289325>, <-0.042851, -0.155238, 1.289325>, 
      <-0.263159, -0.430076, 1.278801>, <-0.194632, -0.355848, 1.288375>, <-0.152231, -0.206171, 1.278920>, <-0.081331, -0.133572, 1.278920>, 
      <-0.342514, -0.350722, 1.267038>, <-0.273986, -0.276493, 1.276612>, <-0.177080, -0.181323, 1.267038>, <-0.106179, -0.108724, 1.267038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.350466, -0.346870, 1.372322>, <0.271935, -0.282448, 1.382377>, <0.181191, -0.179332, 1.372322>, <0.108645, -0.107530, 1.372322>, 
      <0.269624, -0.427713, 1.351350>, <0.191093, -0.363290, 1.361406>, <0.156765, -0.203758, 1.351882>, <0.084219, -0.131956, 1.351882>, 
      <0.147834, -0.499178, 1.332786>, <0.133092, -0.397329, 1.343814>, <0.046366, -0.258242, 1.333050>, <0.046366, -0.154742, 1.333050>, 
      <0.000000, -0.500000, 1.310326>, <-0.014742, -0.398151, 1.321354>, <0.000000, -0.258500, 1.310326>, <0.000000, -0.155000, 1.310326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 1.440032>, <0.396960, 0.000000, 1.449778>, <0.258500, 0.000000, 1.440032>, <0.155000, 0.000000, 1.440032>, 
      <0.495737, -0.144883, 1.409609>, <0.392697, -0.144883, 1.419356>, <0.257229, -0.043208, 1.410764>, <0.153729, -0.043208, 1.410764>, 
      <0.430536, -0.266801, 1.393093>, <0.352005, -0.202378, 1.403148>, <0.205885, -0.154638, 1.392986>, <0.133339, -0.082835, 1.392986>, 
      <0.350466, -0.346870, 1.372322>, <0.271935, -0.282448, 1.382377>, <0.181191, -0.179332, 1.372322>, <0.108645, -0.107530, 1.372322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.368687, 0.272426, 1.502363>, <0.294389, 0.214661, 1.514512>, <0.190611, 0.140844, 1.502363>, <0.114293, 0.084452, 1.502363>, 
      <0.447943, 0.228125, 1.484011>, <0.373646, 0.170360, 1.496160>, <0.211910, 0.119545, 1.487086>, <0.135592, 0.063153, 1.487086>, 
      <0.503430, 0.116578, 1.464511>, <0.400390, 0.116578, 1.474258>, <0.259558, 0.035963, 1.464392>, <0.156058, 0.035963, 1.464392>, 
      <0.500000, 0.000000, 1.440032>, <0.396960, 0.000000, 1.449778>, <0.258500, 0.000000, 1.440032>, <0.155000, 0.000000, 1.440032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.019853, 0.268383, 1.551208>, <-0.002976, 0.243692, 1.559064>, <0.005956, 0.189015, 1.551208>, <0.000000, 0.155000, 1.551208>, 
      <0.154481, 0.269943, 1.532357>, <0.131653, 0.245253, 1.540213>, <0.050066, 0.161788, 1.532357>, <0.044110, 0.127773, 1.532357>, 
      <0.278270, 0.322966, 1.523299>, <0.203972, 0.265201, 1.535447>, <0.163572, 0.167883, 1.521757>, <0.087254, 0.111491, 1.521757>, 
      <0.368687, 0.272426, 1.502363>, <0.294389, 0.214661, 1.514512>, <0.190611, 0.140844, 1.502363>, <0.114293, 0.084452, 1.502363>
    }
  }
  material {
    tela_txt
  }
  photons {
    collect off
  }
}
#declare screw = union {
  object { cuerdas }
  object { bordes }
  object { tela }
  photons {
    collect off
  }
}
#declare hole_up = difference {
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 0.1>
    translate  0.639729*z
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.095, 0.095, 0.2>
    translate  0.604872*z
  }
  photons {
    collect off
  }
}
#declare palos = union {
  object { Cube041 }
  object { // Cube042 -> Cube041
    Cube041
    photons {
      collect off
    }
    rotate -120.0*z
  }
  object { // Cube043 -> Cube041
    Cube041
    photons {
      collect off
    }
    rotate 120.0*z
  }
  object { Cube044 }
  object { // Cube045 -> Cube044
    Cube044
    photons {
      collect off
    }
    rotate -120.0*z
    translate  -0.0*z
  }
  object { // Cube046 -> Cube044
    Cube044
    photons {
      collect off
    }
    rotate 120.0*z
    translate  -0.0*z
  }
  object { hole_up }
  material {
    T_Wood33_2
  }
  photons {
    collect off
  }
}
#declare hole_up1 = difference {
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.125, 0.125, 0.1>
    translate  0.704476*z
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.095, 0.095, 0.2>
    translate  0.655231*z
  }
  photons {
    collect off
  }
  translate  -0.776965*z
}
#declare eje = union {
  object { CSG008 }
  object { // CSG009 -> CSG008
    CSG008
    photons {
      collect off
    }
    rotate 90.0*z
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.095, 0.095, 0.2>
    translate  -0.215258*z
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.07, 0.07, 2.1>
    translate  -0.2*z
  }
  sphere { // Sphere029
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.07
    translate  1.9*z
  }
  object { hole_up1 }
  torus { // Torus006
    1.5, 0.4  rotate -x*90
    material {
      negro
    }
    photons {
      collect off
    }
    scale 0.01
    rotate -90.0*x
    translate  <0.077411, 0.000276, 1.823639>
  }
  material {
    T_Wood33_2
  }
  photons {
    collect off
  }
  translate  -0.071542*z
}
#declare base2 = difference {
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.775, 0.775, 0.1>
    translate  -0.319352*z
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.5, 0.5, 0.1>
    translate  -0.263842*z
  }
  photons {
    collect off
  }
  scale <1.0, 1.0, 0.5>
  translate  -0.148413*z
}
#declare base3 = difference {
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.775, 0.775, 0.12>
    translate  -0.218635*z
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.725, 0.725, 0.2>
    translate  -0.263842*z
  }
  photons {
    collect off
  }
  scale <1.0, 1.0, 0.5>
  translate  -0.172659*z
}
#declare bases = union {
  object { base2 }
  object { base3 }
  material {
    T_Wood33_2
  }
  photons {
    collect off
  }
}
#declare leocopter = union {
  object { screw }
  object { palos }
  object { eje }
  object { bases }
  photons {
    collect off
  }
  scale 0.75
  rotate -140.0*z
  translate  <-19.181782, -14.664764, -2.595272>
}
#declare hojas2 = union {
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.0, 1.5>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.0, -1.000629, -1.5>
  }
  material {
    hojas_txt
  }
  photons {
    collect off
  }
}
#declare CSG014 = union {
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.0, 1.5>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.0, -1.000629, -1.5>
  }
  photons {
    collect off
  }
  scale <1.2, 1.05, 1.05>
}
#declare CSG015 = union {
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 1.1, 1.7>
    translate  0.10039*y
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 3.4>
    translate  <0.0, -1.000629, -1.7>
  }
  photons {
    collect off
  }
}
#declare tapas2 = difference {
  object { CSG014 }
  object { CSG015 }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 3.3>
    translate  <-0.241385, -0.964297, -1.661704>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 3.3>
    translate  <0.24138, -0.964297, -1.661704>
  }
  material {
    tapas_libro_txt
  }
  photons {
    collect off
  }
}
#declare libro6 = union {
  object { hojas2 }
  object { tapas2 }
  photons {
    collect off
  }
  scale 0.2
  rotate <76.621788, -90.0, 0.0>
  translate  <-21.386964, -14.484204, -2.783066>
}
#declare rollos = union {
  object { rollo1 }
  object { // rollo2 -> rollo1
    rollo1
    photons {
      collect off
    }
    rotate <0.0, -0.0, 16.726791>
    translate  <2.400343, -0.404406, 0.0>
  }
  photons {
    collect off
  }
  translate  <-22.772967, -24.142984, 0.0>
}
union { // mesa_1er_plano
  object { mesa }
  object { leocopter }
  object { libro6 }
  object { rollos }
  photons {
    collect off
  }
  translate  <22.772967, 24.142984, 0.0>
}


#declare ruedas2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.449607, -0.164336, -22.790472>, <-1.400243, -0.128472, -22.643165>, <-1.301937, -0.057048, -22.461307>, <-1.210726, 0.009221, -22.348565>, 
      <-1.179471, 0.091234, -22.943221>, <-1.130108, 0.127099, -22.795914>, <-1.101801, 0.147665, -22.743547>, <-1.010590, 0.213934, -22.630805>, 
      <-0.748475, 0.345066, -23.149448>, <-0.747676, 0.345646, -23.147062>, <-0.675580, 0.398027, -23.013691>, <-0.674103, 0.399100, -23.011866>, 
      <-0.447991, 0.563380, -23.303294>, <-0.447191, 0.563961, -23.300909>, <-0.445599, 0.565118, -23.297965>, <-0.444122, 0.566191, -23.296139>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.838623, -0.752273, -22.516966>, <-1.763360, -0.697591, -22.292368>, <-1.613472, -0.588691, -22.015093>, <-1.474403, -0.487651, -21.843194>, 
      <-1.622929, -0.771423, -22.584584>, <-1.547666, -0.716741, -22.359986>, <-1.428766, -0.630355, -22.140034>, <-1.289696, -0.529315, -21.968134>, 
      <-1.602040, -0.308551, -22.704278>, <-1.552677, -0.272686, -22.556973>, <-1.414870, -0.172564, -22.302043>, <-1.323659, -0.106295, -22.189301>, 
      <-1.449607, -0.164336, -22.790472>, <-1.400243, -0.128472, -22.643165>, <-1.301937, -0.057048, -22.461307>, <-1.210726, 0.009221, -22.348565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.842751, -0.129431, -22.667226>, <-1.781716, -0.085087, -22.485090>, <-1.660167, 0.003224, -22.260235>, <-1.547389, 0.085162, -22.120834>, 
      <-1.801942, -0.314621, -22.635813>, <-1.740907, -0.270277, -22.453678>, <-1.604962, -0.171507, -22.202192>, <-1.492185, -0.089569, -22.062792>, 
      <-2.021384, -0.736046, -22.459670>, <-1.946120, -0.681364, -22.235074>, <-1.769977, -0.553388, -21.909227>, <-1.630908, -0.452348, -21.737328>, 
      <-1.838623, -0.752273, -22.516966>, <-1.763360, -0.697591, -22.292368>, <-1.613472, -0.588691, -22.015093>, <-1.474403, -0.487651, -21.843194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.037665, 0.150981, -22.670179>, <-1.976910, 0.195122, -22.488878>, <-1.855918, 0.283028, -22.265054>, <-1.743658, 0.364590, -22.126293>, 
      <-1.949989, 0.100832, -22.687349>, <-1.889235, 0.144973, -22.506048>, <-1.776111, 0.227162, -22.296781>, <-1.663851, 0.308724, -22.158021>, 
      <-1.864502, -0.030722, -22.683968>, <-1.803468, 0.013622, -22.501834>, <-1.689591, 0.096358, -22.291173>, <-1.576814, 0.178296, -22.151771>, 
      <-1.842751, -0.129431, -22.667226>, <-1.781716, -0.085087, -22.485090>, <-1.660167, 0.003224, -22.260235>, <-1.547389, 0.085162, -22.120834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.603520, 0.305719, -22.518232>, <-2.528376, 0.360314, -22.293994>, <-2.378728, 0.469040, -22.017157>, <-2.239880, 0.569919, -21.845531>, 
      <-2.640290, 0.135956, -22.464579>, <-2.565146, 0.190551, -22.240339>, <-2.390910, 0.317142, -21.918016>, <-2.252062, 0.418021, -21.746392>, 
      <-2.193239, 0.239967, -22.639712>, <-2.132484, 0.284108, -22.458410>, <-1.997529, 0.382159, -22.208757>, <-1.885269, 0.463721, -22.069995>, 
      <-2.037665, 0.150981, -22.670179>, <-1.976910, 0.195122, -22.488878>, <-1.855918, 0.283028, -22.265054>, <-1.743658, 0.364590, -22.126293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.956673, 0.524913, -22.788360>, <-1.907110, 0.560923, -22.640459>, <-1.808406, 0.632636, -22.457864>, <-1.716825, 0.699173, -22.344666>, 
      <-2.133189, 0.423187, -22.704442>, <-2.083626, 0.459197, -22.556539>, <-1.946464, 0.558851, -22.302803>, <-1.854884, 0.625388, -22.189603>, 
      <-2.558955, 0.511470, -22.583259>, <-2.483811, 0.566066, -22.359021>, <-2.363964, 0.653140, -22.137314>, <-2.225116, 0.754019, -21.965688>, 
      <-2.603520, 0.305719, -22.518232>, <-2.528376, 0.360314, -22.293994>, <-2.378728, 0.469040, -22.017157>, <-2.239880, 0.569919, -21.845531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-1.241116, 1.044796, -23.154725>, <-1.241116, 1.044796, -23.154725>, <-1.169161, 1.097074, -23.021616>, <-1.169161, 1.097074, -23.021616>, 
      <-1.627979, 0.714339, -22.944627>, <-1.578416, 0.750349, -22.796726>, <-1.551324, 0.770032, -22.746606>, <-1.459744, 0.836569, -22.633408>, 
      <-1.956673, 0.524913, -22.788360>, <-1.907110, 0.560923, -22.640459>, <-1.808406, 0.632636, -22.457864>, <-1.716825, 0.699173, -22.344666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.210726, 0.009221, -22.348565>, <-1.119515, 0.075490, -22.235821>, <-0.972389, 0.182383, -22.114307>, <-0.853216, 0.268967, -22.053291>, 
      <-1.010590, 0.213934, -22.630805>, <-0.919378, 0.280203, -22.518061>, <-0.877015, 0.310982, -22.483072>, <-0.757842, 0.397566, -22.422056>, 
      <-0.674103, 0.399100, -23.011866>, <-0.672626, 0.400173, -23.010040>, <-0.564727, 0.478566, -22.920925>, <-0.562797, 0.479969, -22.919938>, 
      <-0.444122, 0.566191, -23.296139>, <-0.442645, 0.567264, -23.294314>, <-0.440262, 0.568995, -23.292346>, <-0.438332, 0.570398, -23.291357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.474403, -0.487651, -21.843194>, <-1.335333, -0.386611, -21.671293>, <-1.111011, -0.223632, -21.486021>, <-0.929308, -0.091617, -21.392990>, 
      <-1.289696, -0.529315, -21.968134>, <-1.150627, -0.428275, -21.796234>, <-0.972680, -0.298990, -21.649266>, <-0.790977, -0.166975, -21.556234>, 
      <-1.323659, -0.106295, -22.189301>, <-1.232448, -0.040026, -22.076557>, <-1.026207, 0.109817, -21.906219>, <-0.907033, 0.196401, -21.845203>, 
      <-1.210726, 0.009221, -22.348565>, <-1.119515, 0.075490, -22.235821>, <-0.972389, 0.182383, -22.114307>, <-0.853216, 0.268967, -22.053291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.547389, 0.085162, -22.120834>, <-1.434612, 0.167099, -21.981434>, <-1.252701, 0.299266, -21.831192>, <-1.105350, 0.406322, -21.755749>, 
      <-1.492185, -0.089569, -22.062792>, <-1.379408, -0.007632, -21.923392>, <-1.175952, 0.140188, -21.755354>, <-1.028602, 0.247244, -21.679910>, 
      <-1.630908, -0.452348, -21.737328>, <-1.491838, -0.351309, -21.565427>, <-1.228221, -0.159779, -21.347702>, <-1.046518, -0.027764, -21.254670>, 
      <-1.474403, -0.487651, -21.843194>, <-1.335333, -0.386611, -21.671293>, <-1.111011, -0.223632, -21.486021>, <-0.929308, -0.091617, -21.392990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.743658, 0.364590, -22.126293>, <-1.631398, 0.446152, -21.987531>, <-1.450320, 0.577713, -21.837978>, <-1.303645, 0.684278, -21.762882>, 
      <-1.663851, 0.308724, -22.158021>, <-1.551591, 0.390285, -22.019259>, <-1.382290, 0.513290, -21.879432>, <-1.235615, 0.619855, -21.804336>, 
      <-1.576814, 0.178296, -22.151771>, <-1.464037, 0.260233, -22.012371>, <-1.293608, 0.384056, -21.871614>, <-1.146258, 0.491112, -21.796171>, 
      <-1.547389, 0.085162, -22.120834>, <-1.434612, 0.167099, -21.981434>, <-1.252701, 0.299266, -21.831192>, <-1.105350, 0.406322, -21.755749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.239880, 0.569919, -21.845531>, <-2.101032, 0.670798, -21.673906>, <-1.877067, 0.833518, -21.488930>, <-1.695654, 0.965322, -21.396048>, 
      <-2.252062, 0.418021, -21.746392>, <-2.113214, 0.518899, -21.574766>, <-1.852450, 0.708355, -21.359398>, <-1.671037, 0.840159, -21.266515>, 
      <-1.885269, 0.463721, -22.069995>, <-1.773009, 0.545282, -21.931234>, <-1.571034, 0.692026, -21.764421>, <-1.424360, 0.798591, -21.689325>, 
      <-1.743658, 0.364590, -22.126293>, <-1.631398, 0.446152, -21.987531>, <-1.450320, 0.577713, -21.837978>, <-1.303645, 0.684278, -21.762882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.716825, 0.699173, -22.344666>, <-1.625245, 0.765710, -22.231466>, <-1.477523, 0.873036, -22.109461>, <-1.357868, 0.959971, -22.048197>, 
      <-1.854884, 0.625388, -22.189603>, <-1.763303, 0.691925, -22.076405>, <-1.558026, 0.841068, -21.906864>, <-1.438370, 0.928003, -21.845600>, 
      <-2.225116, 0.754019, -21.965688>, <-2.086268, 0.854898, -21.794064>, <-1.906902, 0.985215, -21.645922>, <-1.725489, 1.117019, -21.553040>, 
      <-2.239880, 0.569919, -21.845531>, <-2.101032, 0.670798, -21.673906>, <-1.877067, 0.833518, -21.488930>, <-1.695654, 0.965322, -21.396048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-1.169161, 1.097074, -23.021616>, <-1.169161, 1.097074, -23.021616>, <-1.061474, 1.175314, -22.932675>, <-1.061474, 1.175314, -22.932675>, 
      <-1.459744, 0.836569, -22.633408>, <-1.368163, 0.903107, -22.520208>, <-1.327618, 0.932565, -22.486722>, <-1.207962, 1.019500, -22.425458>, 
      <-1.716825, 0.699173, -22.344666>, <-1.625245, 0.765710, -22.231466>, <-1.477523, 0.873036, -22.109461>, <-1.357868, 0.959971, -22.048197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.853216, 0.268967, -22.053291>, <-0.734042, 0.355552, -21.992275>, <-0.560496, 0.481641, -21.949606>, <-0.431503, 0.575359, -21.949606>, 
      <-0.757842, 0.397566, -22.422056>, <-0.638668, 0.484151, -22.361040>, <-0.588697, 0.520457, -22.348754>, <-0.459705, 0.614175, -22.348754>, 
      <-0.562797, 0.479969, -22.919938>, <-0.560867, 0.481371, -22.918949>, <-0.433592, 0.573842, -22.887656>, <-0.431503, 0.575359, -22.887656>, 
      <-0.438332, 0.570398, -23.291357>, <-0.436402, 0.571800, -23.290370>, <-0.433592, 0.573842, -23.289677>, <-0.431503, 0.575359, -23.289677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.929308, -0.091617, -21.392990>, <-0.747605, 0.040398, -21.299958>, <-0.482999, 0.232646, -21.234899>, <-0.286325, 0.375538, -21.234899>, 
      <-0.790977, -0.166975, -21.556234>, <-0.609274, -0.034960, -21.463203>, <-0.399372, 0.117543, -21.411592>, <-0.202698, 0.260435, -21.411592>, 
      <-0.907033, 0.196401, -21.845203>, <-0.787860, 0.282986, -21.784187>, <-0.544582, 0.459738, -21.724373>, <-0.415590, 0.553456, -21.724373>, 
      <-0.853216, 0.268967, -22.053291>, <-0.734042, 0.355552, -21.992275>, <-0.560496, 0.481641, -21.949606>, <-0.431503, 0.575359, -21.949606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.105350, 0.406322, -21.755749>, <-0.958000, 0.513378, -21.680306>, <-0.743420, 0.669279, -21.627549>, <-0.583930, 0.785156, -21.627549>, 
      <-1.028602, 0.247244, -21.679910>, <-0.881251, 0.354300, -21.604467>, <-0.641258, 0.528665, -21.545462>, <-0.481767, 0.644542, -21.545462>, 
      <-1.046518, -0.027764, -21.254670>, <-0.864815, 0.104251, -21.161640>, <-0.553858, 0.330175, -21.085184>, <-0.357184, 0.473067, -21.085184>, 
      <-0.929308, -0.091617, -21.392990>, <-0.747605, 0.040398, -21.299958>, <-0.482999, 0.232646, -21.234899>, <-0.286325, 0.375538, -21.234899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.303645, 0.684278, -21.762882>, <-1.156970, 0.790844, -21.687786>, <-0.943375, 0.946030, -21.635267>, <-0.784615, 1.061376, -21.635267>, 
      <-1.235615, 0.619855, -21.804336>, <-1.088940, 0.726421, -21.729240>, <-0.889236, 0.871515, -21.680138>, <-0.730476, 0.986860, -21.680138>, 
      <-1.146258, 0.491112, -21.796171>, <-0.998908, 0.598169, -21.720728>, <-0.797874, 0.744228, -21.671301>, <-0.638383, 0.860105, -21.671301>, 
      <-1.105350, 0.406322, -21.755749>, <-0.958000, 0.513378, -21.680306>, <-0.743420, 0.669279, -21.627549>, <-0.583930, 0.785156, -21.627549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.695654, 0.965322, -21.396048>, <-1.514240, 1.097127, -21.303163>, <-1.250056, 1.289068, -21.238208>, <-1.053695, 1.431733, -21.238208>, 
      <-1.671037, 0.840159, -21.266515>, <-1.489623, 0.971964, -21.173632>, <-1.182032, 1.195442, -21.098005>, <-0.985672, 1.338107, -21.098005>, 
      <-1.424360, 0.798591, -21.689325>, <-1.277685, 0.905157, -21.614229>, <-1.039439, 1.078252, -21.555650>, <-0.880680, 1.193598, -21.555650>, 
      <-1.303645, 0.684278, -21.762882>, <-1.156970, 0.790844, -21.687786>, <-0.943375, 0.946030, -21.635267>, <-0.784615, 1.061376, -21.635267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.357868, 0.959971, -22.048197>, <-1.238212, 1.046906, -21.986933>, <-1.063962, 1.173506, -21.944091>, <-0.934448, 1.267603, -21.944091>, 
      <-1.438370, 0.928003, -21.845600>, <-1.318715, 1.014938, -21.784336>, <-1.076574, 1.190864, -21.724802>, <-0.947059, 1.284961, -21.724802>, 
      <-1.725489, 1.117019, -21.553040>, <-1.544075, 1.248824, -21.460155>, <-1.332499, 1.402543, -21.408136>, <-1.136139, 1.545207, -21.408136>, 
      <-1.695654, 0.965322, -21.396048>, <-1.514240, 1.097127, -21.303163>, <-1.250056, 1.289068, -21.238208>, <-1.053695, 1.431733, -21.238208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-1.061474, 1.175314, -22.932675>, <-1.061474, 1.175314, -22.932675>, <-0.934448, 1.267604, -22.901443>, <-0.934448, 1.267604, -22.901443>, 
      <-1.207962, 1.019500, -22.425458>, <-1.088306, 1.106435, -22.364194>, <-1.040479, 1.141183, -22.352437>, <-0.910964, 1.235281, -22.352437>, 
      <-1.357868, 0.959971, -22.048197>, <-1.238212, 1.046906, -21.986933>, <-1.063962, 1.173506, -21.944091>, <-0.934448, 1.267603, -21.944091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.431503, 0.575359, -21.949606>, <-0.302511, 0.669078, -21.949606>, <-0.128964, 0.795167, -21.992275>, <-0.009791, 0.881751, -22.053291>, 
      <-0.459705, 0.614175, -22.348754>, <-0.330712, 0.707894, -22.348754>, <-0.280741, 0.744200, -22.361040>, <-0.161568, 0.830785, -22.422056>, 
      <-0.431503, 0.575359, -22.887656>, <-0.429414, 0.576877, -22.887656>, <-0.302139, 0.669348, -22.918949>, <-0.300209, 0.670750, -22.919938>, 
      <-0.431503, 0.575359, -23.289677>, <-0.429414, 0.576877, -23.289677>, <-0.426604, 0.578919, -23.290370>, <-0.424674, 0.580321, -23.291357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.286325, 0.375538, -21.234899>, <-0.089651, 0.518430, -21.234899>, <0.174955, 0.710678, -21.299958>, <0.356658, 0.842693, -21.392990>, 
      <-0.202698, 0.260435, -21.411592>, <-0.006024, 0.403327, -21.411592>, <0.203878, 0.555830, -21.463203>, <0.385582, 0.687845, -21.556234>, 
      <-0.415590, 0.553456, -21.724373>, <-0.286597, 0.647174, -21.724373>, <-0.043319, 0.823926, -21.784187>, <0.075854, 0.910511, -21.845203>, 
      <-0.431503, 0.575359, -21.949606>, <-0.302511, 0.669078, -21.949606>, <-0.128964, 0.795167, -21.992275>, <-0.009791, 0.881751, -22.053291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.583930, 0.785156, -21.627549>, <-0.424439, 0.901033, -21.627549>, <-0.209859, 1.056934, -21.680306>, <-0.062509, 1.163990, -21.755749>, 
      <-0.481767, 0.644542, -21.545462>, <-0.322277, 0.760419, -21.545462>, <-0.082284, 0.934784, -21.604467>, <0.065067, 1.041840, -21.679910>, 
      <-0.357184, 0.473067, -21.085184>, <-0.160510, 0.615959, -21.085184>, <0.150448, 0.841883, -21.161640>, <0.332151, 0.973898, -21.254670>, 
      <-0.286325, 0.375538, -21.234899>, <-0.089651, 0.518430, -21.234899>, <0.174955, 0.710678, -21.299958>, <0.356658, 0.842693, -21.392990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.784615, 1.061376, -21.635267>, <-0.625855, 1.176722, -21.635267>, <-0.412259, 1.331908, -21.687786>, <-0.265584, 1.438473, -21.762882>, 
      <-0.730476, 0.986860, -21.680138>, <-0.571716, 1.102206, -21.680138>, <-0.372012, 1.247300, -21.729240>, <-0.225337, 1.353865, -21.804336>, 
      <-0.638383, 0.860105, -21.671301>, <-0.478893, 0.975982, -21.671301>, <-0.277858, 1.122042, -21.720728>, <-0.130508, 1.229098, -21.796171>, 
      <-0.583930, 0.785156, -21.627549>, <-0.424439, 0.901033, -21.627549>, <-0.209859, 1.056934, -21.680306>, <-0.062509, 1.163990, -21.755749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.053695, 1.431733, -21.238208>, <-0.857334, 1.574397, -21.238208>, <-0.593150, 1.766338, -21.303163>, <-0.411736, 1.898143, -21.396046>, 
      <-0.985672, 1.338107, -21.098005>, <-0.789311, 1.480771, -21.098005>, <-0.481719, 1.704249, -21.173632>, <-0.300306, 1.836053, -21.266514>, 
      <-0.880680, 1.193598, -21.555650>, <-0.721920, 1.308943, -21.555650>, <-0.483675, 1.482039, -21.614229>, <-0.337000, 1.588605, -21.689325>, 
      <-0.784615, 1.061376, -21.635267>, <-0.625855, 1.176722, -21.635267>, <-0.412259, 1.331908, -21.687786>, <-0.265584, 1.438473, -21.762882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267603, -21.944091>, <-0.804934, 1.361701, -21.944091>, <-0.630684, 1.488301, -21.986933>, <-0.511028, 1.575236, -22.048197>, 
      <-0.947059, 1.284961, -21.724802>, <-0.817545, 1.379059, -21.724802>, <-0.575404, 1.554985, -21.784334>, <-0.455748, 1.641920, -21.845598>, 
      <-1.136139, 1.545207, -21.408136>, <-0.939778, 1.687871, -21.408136>, <-0.728203, 1.841590, -21.460155>, <-0.546789, 1.973395, -21.553038>, 
      <-1.053695, 1.431733, -21.238208>, <-0.857334, 1.574397, -21.238208>, <-0.593150, 1.766338, -21.303163>, <-0.411736, 1.898143, -21.396046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-0.934448, 1.267604, -22.901443>, <-0.934448, 1.267604, -22.901443>, <-0.807422, 1.359893, -22.932675>, <-0.807422, 1.359893, -22.932675>, 
      <-0.910964, 1.235281, -22.352437>, <-0.781450, 1.329379, -22.352437>, <-0.733623, 1.364127, -22.364194>, <-0.613967, 1.451062, -22.425458>, 
      <-0.934448, 1.267603, -21.944091>, <-0.804934, 1.361701, -21.944091>, <-0.630684, 1.488301, -21.986933>, <-0.511028, 1.575236, -22.048197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.009791, 0.881751, -22.053291>, <0.109382, 0.968336, -22.114307>, <0.256508, 1.075229, -22.235821>, <0.347720, 1.141498, -22.348565>, 
      <-0.161568, 0.830785, -22.422056>, <-0.042394, 0.917369, -22.483072>, <-0.000030, 0.948148, -22.518061>, <0.091181, 1.014417, -22.630805>, 
      <-0.300209, 0.670750, -22.919938>, <-0.298279, 0.672152, -22.920925>, <-0.190380, 0.750545, -23.010040>, <-0.188903, 0.751619, -23.011866>, 
      <-0.424674, 0.580321, -23.291357>, <-0.422744, 0.581723, -23.292346>, <-0.420361, 0.583454, -23.294314>, <-0.418884, 0.584528, -23.296139>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356658, 0.842693, -21.392990>, <0.538362, 0.974708, -21.486021>, <0.762684, 1.137688, -21.671291>, <0.901753, 1.238728, -21.843190>, 
      <0.385582, 0.687845, -21.556234>, <0.567285, 0.819860, -21.649266>, <0.745231, 0.949146, -21.796232>, <0.884301, 1.050186, -21.968133>, 
      <0.075854, 0.910511, -21.845203>, <0.195027, 0.997095, -21.906219>, <0.401269, 1.146938, -22.076557>, <0.492480, 1.213207, -22.189301>, 
      <-0.009791, 0.881751, -22.053291>, <0.109382, 0.968336, -22.114307>, <0.256508, 1.075229, -22.235821>, <0.347720, 1.141498, -22.348565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.062509, 1.163990, -21.755749>, <0.084841, 1.271047, -21.831192>, <0.266753, 1.403213, -21.981434>, <0.379530, 1.485151, -22.120834>, 
      <0.065067, 1.041840, -21.679910>, <0.212417, 1.148897, -21.755354>, <0.415873, 1.296716, -21.923392>, <0.528650, 1.378654, -22.062792>, 
      <0.332151, 0.973898, -21.254670>, <0.513854, 1.105913, -21.347702>, <0.777472, 1.297442, -21.565426>, <0.916541, 1.398482, -21.737326>, 
      <0.356658, 0.842693, -21.392990>, <0.538362, 0.974708, -21.486021>, <0.762684, 1.137688, -21.671291>, <0.901753, 1.238728, -21.843190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265584, 1.438473, -21.762882>, <-0.118910, 1.545039, -21.837978>, <0.062169, 1.676600, -21.987531>, <0.174429, 1.758161, -22.126293>, 
      <-0.225337, 1.353865, -21.804336>, <-0.078663, 1.460431, -21.879432>, <0.090639, 1.583435, -22.019259>, <0.202899, 1.664997, -22.158021>, 
      <-0.130508, 1.229098, -21.796171>, <0.016842, 1.336154, -21.871614>, <0.187271, 1.459978, -22.012371>, <0.300048, 1.541915, -22.151771>, 
      <-0.062509, 1.163990, -21.755749>, <0.084841, 1.271047, -21.831192>, <0.266753, 1.403213, -21.981434>, <0.379530, 1.485151, -22.120834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.411736, 1.898143, -21.396046>, <-0.230323, 2.029948, -21.488930>, <-0.006358, 2.192667, -21.673906>, <0.132490, 2.293546, -21.845531>, 
      <-0.300306, 1.836053, -21.266514>, <-0.118892, 1.967858, -21.359398>, <0.141870, 2.157314, -21.574766>, <0.280718, 2.258193, -21.746392>, 
      <-0.337000, 1.588605, -21.689325>, <-0.190325, 1.695170, -21.764421>, <0.011650, 1.841913, -21.931234>, <0.123910, 1.923475, -22.069995>, 
      <-0.265584, 1.438473, -21.762882>, <-0.118910, 1.545039, -21.837978>, <0.062169, 1.676600, -21.987531>, <0.174429, 1.758161, -22.126293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.511028, 1.575236, -22.048197>, <-0.391373, 1.662171, -22.109461>, <-0.243651, 1.769497, -22.231466>, <-0.152071, 1.836034, -22.344666>, 
      <-0.455748, 1.641920, -21.845598>, <-0.336092, 1.728855, -21.906862>, <-0.130815, 1.877997, -22.076405>, <-0.039234, 1.944535, -22.189603>, 
      <-0.546789, 1.973395, -21.553038>, <-0.365376, 2.105200, -21.645922>, <-0.186010, 2.235516, -21.794064>, <-0.047162, 2.336395, -21.965688>, 
      <-0.411736, 1.898143, -21.396046>, <-0.230323, 2.029948, -21.488930>, <-0.006358, 2.192667, -21.673906>, <0.132490, 2.293546, -21.845531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-0.807422, 1.359893, -22.932675>, <-0.807422, 1.359893, -22.932675>, <-0.699735, 1.438133, -23.021616>, <-0.699735, 1.438133, -23.021616>, 
      <-0.613967, 1.451062, -22.425458>, <-0.494311, 1.537997, -22.486722>, <-0.453765, 1.567456, -22.520208>, <-0.362185, 1.633993, -22.633408>, 
      <-0.511028, 1.575236, -22.048197>, <-0.391373, 1.662171, -22.109461>, <-0.243651, 1.769497, -22.231466>, <-0.152071, 1.836034, -22.344666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.347720, 1.141498, -22.348565>, <0.438931, 1.207767, -22.461307>, <0.537237, 1.279190, -22.643165>, <0.586600, 1.315055, -22.790472>, 
      <0.091181, 1.014417, -22.630805>, <0.182392, 1.080686, -22.743547>, <0.210699, 1.101252, -22.795914>, <0.260062, 1.137116, -22.943221>, 
      <-0.188903, 0.751619, -23.011866>, <-0.187426, 0.752692, -23.013691>, <-0.115330, 0.805072, -23.147062>, <-0.114531, 0.805653, -23.149448>, 
      <-0.418884, 0.584528, -23.296139>, <-0.417407, 0.585601, -23.297965>, <-0.415815, 0.586757, -23.300909>, <-0.415015, 0.587338, -23.303294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.901753, 1.238728, -21.843190>, <1.040823, 1.339768, -22.015091>, <1.190710, 1.448667, -22.292368>, <1.265974, 1.503349, -22.516966>, 
      <0.884301, 1.050186, -21.968133>, <1.023370, 1.151226, -22.140032>, <1.142270, 1.237612, -22.359986>, <1.217534, 1.292294, -22.584584>, 
      <0.492480, 1.213207, -22.189301>, <0.583692, 1.279476, -22.302043>, <0.721498, 1.379598, -22.556973>, <0.770861, 1.415463, -22.704278>, 
      <0.347720, 1.141498, -22.348565>, <0.438931, 1.207767, -22.461307>, <0.537237, 1.279190, -22.643165>, <0.586600, 1.315055, -22.790472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.379530, 1.485151, -22.120834>, <0.492307, 1.567088, -22.260235>, <0.613857, 1.655399, -22.485090>, <0.674891, 1.699743, -22.667226>, 
      <0.528650, 1.378654, -22.062792>, <0.641428, 1.460591, -22.202192>, <0.777373, 1.559361, -22.453678>, <0.838407, 1.603705, -22.635813>, 
      <0.916541, 1.398482, -21.737326>, <1.055611, 1.499522, -21.909226>, <1.231754, 1.627497, -22.235074>, <1.307018, 1.682179, -22.459670>, 
      <0.901753, 1.238728, -21.843190>, <1.040823, 1.339768, -22.015091>, <1.190710, 1.448667, -22.292368>, <1.265974, 1.503349, -22.516966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.174429, 1.758161, -22.126293>, <0.286689, 1.839723, -22.265054>, <0.407681, 1.927629, -22.488878>, <0.468436, 1.971770, -22.670179>, 
      <0.202899, 1.664997, -22.158021>, <0.315159, 1.746559, -22.296781>, <0.428283, 1.828748, -22.506048>, <0.489037, 1.872888, -22.687349>, 
      <0.300048, 1.541915, -22.151771>, <0.412825, 1.623852, -22.291173>, <0.526701, 1.706589, -22.501834>, <0.587736, 1.750933, -22.683968>, 
      <0.379530, 1.485151, -22.120834>, <0.492307, 1.567088, -22.260235>, <0.613857, 1.655399, -22.485090>, <0.674891, 1.699743, -22.667226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.132490, 2.293546, -21.845531>, <0.271338, 2.394425, -22.017157>, <0.420987, 2.503151, -22.293994>, <0.496131, 2.557747, -22.518232>, 
      <0.280718, 2.258193, -21.746392>, <0.419566, 2.359072, -21.918016>, <0.593803, 2.485662, -22.240339>, <0.668947, 2.540257, -22.464579>, 
      <0.123910, 1.923475, -22.069995>, <0.236170, 2.005036, -22.208757>, <0.371125, 2.103087, -22.458410>, <0.431880, 2.147228, -22.639712>, 
      <0.174429, 1.758161, -22.126293>, <0.286689, 1.839723, -22.265054>, <0.407681, 1.927629, -22.488878>, <0.468436, 1.971770, -22.670179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.152071, 1.836034, -22.344666>, <-0.060490, 1.902571, -22.457864>, <0.038215, 1.974284, -22.640459>, <0.087778, 2.010294, -22.788360>, 
      <-0.039234, 1.944535, -22.189603>, <0.052346, 2.011072, -22.302803>, <0.189508, 2.110726, -22.556539>, <0.239071, 2.146735, -22.704442>, 
      <-0.047162, 2.336395, -21.965688>, <0.091686, 2.437274, -22.137314>, <0.211534, 2.524349, -22.359021>, <0.286678, 2.578944, -22.583259>, 
      <0.132490, 2.293546, -21.845531>, <0.271338, 2.394425, -22.017157>, <0.420987, 2.503151, -22.293994>, <0.496131, 2.557747, -22.518232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-0.699735, 1.438133, -23.021616>, <-0.699735, 1.438133, -23.021616>, <-0.627780, 1.490411, -23.154725>, <-0.627780, 1.490411, -23.154725>, 
      <-0.362185, 1.633993, -22.633408>, <-0.270604, 1.700530, -22.746606>, <-0.243512, 1.720214, -22.796726>, <-0.193949, 1.756223, -22.944627>, 
      <-0.152071, 1.836034, -22.344666>, <-0.060490, 1.902571, -22.457864>, <0.038215, 1.974284, -22.640459>, <0.087778, 2.010294, -22.788360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.586600, 1.315055, -22.790472>, <0.635964, 1.350919, -22.937779>, <0.670484, 1.376000, -23.152294>, <0.670484, 1.376000, -23.311738>, 
      <0.260062, 1.137116, -22.943221>, <0.309425, 1.172981, -23.090526>, <0.319365, 1.180202, -23.152294>, <0.319365, 1.180202, -23.311738>, 
      <-0.114531, 0.805653, -23.149448>, <-0.113731, 0.806234, -23.151835>, <-0.088415, 0.824628, -23.309155>, <-0.088415, 0.824628, -23.311738>, 
      <-0.415015, 0.587338, -23.303294>, <-0.414216, 0.587919, -23.305682>, <-0.413657, 0.588325, -23.309155>, <-0.413657, 0.588325, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.265974, 1.503349, -22.516966>, <1.341238, 1.558032, -22.741563>, <1.393871, 1.596272, -23.068634>, <1.393871, 1.596272, -23.311738>, 
      <1.217534, 1.292294, -22.584584>, <1.292798, 1.346977, -22.809181>, <1.334550, 1.377311, -23.068634>, <1.334550, 1.377311, -23.311738>, 
      <0.770861, 1.415463, -22.704278>, <0.820224, 1.451327, -22.851586>, <0.868615, 1.486485, -23.152294>, <0.868615, 1.486485, -23.311738>, 
      <0.586600, 1.315055, -22.790472>, <0.635964, 1.350919, -22.937779>, <0.670484, 1.376000, -23.152294>, <0.670484, 1.376000, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.674891, 1.699743, -22.667226>, <0.735926, 1.744087, -22.849360>, <0.778609, 1.775098, -23.114595>, <0.778609, 1.775098, -23.311738>, 
      <0.838407, 1.603705, -22.635813>, <0.899442, 1.648049, -22.817947>, <0.947179, 1.682733, -23.114595>, <0.947179, 1.682733, -23.311738>, 
      <1.307018, 1.682179, -22.459670>, <1.382282, 1.736862, -22.684269>, <1.444135, 1.781801, -23.068634>, <1.444135, 1.781801, -23.311738>, 
      <1.265974, 1.503349, -22.516966>, <1.341238, 1.558032, -22.741563>, <1.393871, 1.596272, -23.068634>, <1.393871, 1.596272, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.468436, 1.971770, -22.670179>, <0.529191, 2.015911, -22.851480>, <0.571677, 2.046779, -23.115499>, <0.571677, 2.046779, -23.311738>, 
      <0.489037, 1.872888, -22.687349>, <0.549792, 1.917029, -22.868651>, <0.589516, 1.945890, -23.115499>, <0.589516, 1.945890, -23.311738>, 
      <0.587736, 1.750933, -22.683968>, <0.648770, 1.795277, -22.866102>, <0.688759, 1.824330, -23.114595>, <0.688759, 1.824330, -23.311738>, 
      <0.674891, 1.699743, -22.667226>, <0.735926, 1.744087, -22.849360>, <0.778609, 1.775098, -23.114595>, <0.778609, 1.775098, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.496131, 2.557747, -22.518232>, <0.571275, 2.612342, -22.742472>, <0.623824, 2.650522, -23.069021>, <0.623824, 2.650522, -23.311738>, 
      <0.668947, 2.540257, -22.464579>, <0.744091, 2.594852, -22.688818>, <0.805275, 2.639305, -23.069021>, <0.805275, 2.639305, -23.311738>, 
      <0.431880, 2.147228, -22.639712>, <0.492635, 2.191369, -22.821013>, <0.540025, 2.225800, -23.115499>, <0.540025, 2.225800, -23.311738>, 
      <0.468436, 1.971770, -22.670179>, <0.529191, 2.015911, -22.851480>, <0.571677, 2.046779, -23.115499>, <0.571677, 2.046779, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.087778, 2.010294, -22.788360>, <0.137341, 2.046304, -22.936264>, <0.172001, 2.071486, -23.151648>, <0.172001, 2.071486, -23.311738>, 
      <0.239071, 2.146735, -22.704442>, <0.288634, 2.182745, -22.852344>, <0.336799, 2.217739, -23.151648>, <0.336799, 2.217739, -23.311738>, 
      <0.286678, 2.578944, -22.583259>, <0.361822, 2.633539, -22.807499>, <0.403907, 2.664116, -23.069021>, <0.403907, 2.664116, -23.311738>, 
      <0.496131, 2.557747, -22.518232>, <0.571275, 2.612342, -22.742472>, <0.623824, 2.650522, -23.069021>, <0.623824, 2.650522, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-0.627780, 1.490411, -23.154725>, <-0.627780, 1.490411, -23.154725>, <-0.602513, 1.508768, -23.311738>, <-0.602513, 1.508768, -23.311738>, 
      <-0.193949, 1.756223, -22.944627>, <-0.144386, 1.792233, -23.092531>, <-0.134873, 1.799145, -23.151648>, <-0.134873, 1.799145, -23.311738>, 
      <0.087778, 2.010294, -22.788360>, <0.137341, 2.046304, -22.936264>, <0.172001, 2.071486, -23.151648>, <0.172001, 2.071486, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.670484, 1.376000, -23.311738>, <0.670484, 1.376000, -23.471179>, <0.635964, 1.350919, -23.685694>, <0.586601, 1.315055, -23.833000>, 
      <0.319365, 1.180202, -23.311738>, <0.319365, 1.180202, -23.471179>, <0.309425, 1.172981, -23.532947>, <0.260062, 1.137116, -23.680254>, 
      <-0.088415, 0.824628, -23.311738>, <-0.088415, 0.824628, -23.314320>, <-0.113731, 0.806234, -23.471640>, <-0.114531, 0.805653, -23.474026>, 
      <-0.413657, 0.588325, -23.311738>, <-0.413657, 0.588325, -23.314320>, <-0.414216, 0.587919, -23.317794>, <-0.415015, 0.587338, -23.320179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.393871, 1.596272, -23.311738>, <1.393871, 1.596272, -23.554838>, <1.341238, 1.558032, -23.881910>, <1.265974, 1.503349, -24.106506>, 
      <1.334550, 1.377311, -23.311738>, <1.334550, 1.377311, -23.554838>, <1.292798, 1.346977, -23.814291>, <1.217534, 1.292295, -24.038886>, 
      <0.868615, 1.486485, -23.311738>, <0.868615, 1.486485, -23.471179>, <0.820224, 1.451327, -23.771886>, <0.770861, 1.415463, -23.919194>, 
      <0.670484, 1.376000, -23.311738>, <0.670484, 1.376000, -23.471179>, <0.635964, 1.350919, -23.685694>, <0.586601, 1.315055, -23.833000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.778609, 1.775098, -23.311738>, <0.778609, 1.775098, -23.508878>, <0.735926, 1.744087, -23.774115>, <0.674892, 1.699743, -23.956250>, 
      <0.947179, 1.682733, -23.311738>, <0.947179, 1.682733, -23.508878>, <0.899442, 1.648049, -23.805526>, <0.838407, 1.603705, -23.987661>, 
      <1.444135, 1.781801, -23.311738>, <1.444135, 1.781801, -23.554838>, <1.382282, 1.736862, -23.939205>, <1.307018, 1.682179, -24.163802>, 
      <1.393871, 1.596272, -23.311738>, <1.393871, 1.596272, -23.554838>, <1.341238, 1.558032, -23.881910>, <1.265974, 1.503349, -24.106506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.571677, 2.046779, -23.311738>, <0.571677, 2.046779, -23.507974>, <0.529191, 2.015911, -23.771994>, <0.468436, 1.971770, -23.953293>, 
      <0.589516, 1.945890, -23.311738>, <0.589516, 1.945890, -23.507974>, <0.549792, 1.917029, -23.754824>, <0.489038, 1.872888, -23.936123>, 
      <0.688759, 1.824330, -23.311738>, <0.688759, 1.824330, -23.508878>, <0.648771, 1.795277, -23.757371>, <0.587736, 1.750933, -23.939507>, 
      <0.778609, 1.775098, -23.311738>, <0.778609, 1.775098, -23.508878>, <0.735926, 1.744087, -23.774115>, <0.674892, 1.699743, -23.956250>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.623824, 2.650522, -23.311738>, <0.623824, 2.650522, -23.554451>, <0.571275, 2.612342, -23.881000>, <0.496131, 2.557747, -24.105240>, 
      <0.805275, 2.639305, -23.311738>, <0.805275, 2.639305, -23.554451>, <0.744091, 2.594853, -23.934654>, <0.668947, 2.540257, -24.158893>, 
      <0.540025, 2.225800, -23.311738>, <0.540025, 2.225800, -23.507974>, <0.492635, 2.191369, -23.802462>, <0.431880, 2.147228, -23.983762>, 
      <0.571677, 2.046779, -23.311738>, <0.571677, 2.046779, -23.507974>, <0.529191, 2.015911, -23.771994>, <0.468436, 1.971770, -23.953293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.172001, 2.071486, -23.311738>, <0.172001, 2.071486, -23.471824>, <0.137341, 2.046303, -23.687210>, <0.087778, 2.010294, -23.835112>, 
      <0.336799, 2.217739, -23.311738>, <0.336799, 2.217739, -23.471824>, <0.288634, 2.182745, -23.771128>, <0.239071, 2.146735, -23.919029>, 
      <0.403907, 2.664116, -23.311738>, <0.403907, 2.664116, -23.554451>, <0.361822, 2.633539, -23.815973>, <0.286678, 2.578944, -24.040213>, 
      <0.623824, 2.650522, -23.311738>, <0.623824, 2.650522, -23.554451>, <0.571275, 2.612342, -23.881000>, <0.496131, 2.557747, -24.105240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-0.602513, 1.508768, -23.311738>, <-0.602513, 1.508768, -23.311738>, <-0.627780, 1.490411, -23.468750>, <-0.627780, 1.490411, -23.468750>, 
      <-0.134873, 1.799145, -23.311738>, <-0.134873, 1.799145, -23.471824>, <-0.144386, 1.792233, -23.530946>, <-0.193949, 1.756223, -23.678846>, 
      <0.172001, 2.071486, -23.311738>, <0.172001, 2.071486, -23.471824>, <0.137341, 2.046303, -23.687210>, <0.087778, 2.010294, -23.835112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.586601, 1.315055, -23.833000>, <0.537237, 1.279190, -23.980307>, <0.438931, 1.207767, -24.162165>, <0.347720, 1.141498, -24.274909>, 
      <0.260062, 1.137116, -23.680254>, <0.210699, 1.101252, -23.827560>, <0.182392, 1.080686, -23.879925>, <0.091181, 1.014417, -23.992669>, 
      <-0.114531, 0.805653, -23.474026>, <-0.115330, 0.805072, -23.476411>, <-0.187426, 0.752692, -23.609781>, <-0.188903, 0.751619, -23.611606>, 
      <-0.415015, 0.587338, -23.320179>, <-0.415815, 0.586757, -23.322565>, <-0.417407, 0.585601, -23.325510>, <-0.418884, 0.584528, -23.327336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.265974, 1.503349, -24.106506>, <1.190710, 1.448667, -24.331104>, <1.040823, 1.339768, -24.608381>, <0.901754, 1.238728, -24.780282>, 
      <1.217534, 1.292295, -24.038886>, <1.142270, 1.237612, -24.263485>, <1.023371, 1.151226, -24.483440>, <0.884301, 1.050186, -24.655341>, 
      <0.770861, 1.415463, -23.919194>, <0.721498, 1.379598, -24.066499>, <0.583692, 1.279476, -24.321429>, <0.492480, 1.213207, -24.434171>, 
      <0.586601, 1.315055, -23.833000>, <0.537237, 1.279190, -23.980307>, <0.438931, 1.207767, -24.162165>, <0.347720, 1.141498, -24.274909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.674892, 1.699743, -23.956250>, <0.613857, 1.655399, -24.138384>, <0.492307, 1.567088, -24.363237>, <0.379531, 1.485151, -24.502638>, 
      <0.838407, 1.603705, -23.987661>, <0.777373, 1.559361, -24.169795>, <0.641427, 1.460591, -24.421280>, <0.528651, 1.378654, -24.560680>, 
      <1.307018, 1.682179, -24.163802>, <1.231754, 1.627497, -24.388398>, <1.055611, 1.499522, -24.714246>, <0.916542, 1.398482, -24.886147>, 
      <1.265974, 1.503349, -24.106506>, <1.190710, 1.448667, -24.331104>, <1.040823, 1.339768, -24.608381>, <0.901754, 1.238728, -24.780282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.468436, 1.971770, -23.953293>, <0.407681, 1.927629, -24.134592>, <0.286689, 1.839723, -24.358418>, <0.174429, 1.758161, -24.497179>, 
      <0.489038, 1.872888, -23.936123>, <0.428283, 1.828748, -24.117422>, <0.315159, 1.746559, -24.326691>, <0.202899, 1.664997, -24.465453>, 
      <0.587736, 1.750933, -23.939507>, <0.526702, 1.706589, -24.121642>, <0.412825, 1.623852, -24.332301>, <0.300048, 1.541915, -24.471701>, 
      <0.674892, 1.699743, -23.956250>, <0.613857, 1.655399, -24.138384>, <0.492307, 1.567088, -24.363237>, <0.379531, 1.485151, -24.502638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.496131, 2.557747, -24.105240>, <0.420987, 2.503151, -24.329480>, <0.271338, 2.394426, -24.606317>, <0.132490, 2.293547, -24.777942>, 
      <0.668947, 2.540257, -24.158893>, <0.593803, 2.485662, -24.383133>, <0.419567, 2.359072, -24.705456>, <0.280719, 2.258193, -24.877082>, 
      <0.431880, 2.147228, -23.983762>, <0.371125, 2.103087, -24.165061>, <0.236170, 2.005036, -24.414717>, <0.123910, 1.923475, -24.553478>, 
      <0.468436, 1.971770, -23.953293>, <0.407681, 1.927629, -24.134592>, <0.286689, 1.839723, -24.358418>, <0.174429, 1.758161, -24.497179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.087778, 2.010294, -23.835112>, <0.038214, 1.974284, -23.983014>, <-0.060490, 1.902571, -24.165610>, <-0.152070, 1.836034, -24.278808>, 
      <0.239071, 2.146735, -23.919029>, <0.189508, 2.110726, -24.066933>, <0.052346, 2.011072, -24.320670>, <-0.039234, 1.944535, -24.433870>, 
      <0.286678, 2.578944, -24.040213>, <0.211534, 2.524348, -24.264451>, <0.091686, 2.437274, -24.486162>, <-0.047162, 2.336395, -24.657787>, 
      <0.496131, 2.557747, -24.105240>, <0.420987, 2.503151, -24.329480>, <0.271338, 2.394426, -24.606317>, <0.132490, 2.293547, -24.777942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-0.627780, 1.490411, -23.468750>, <-0.627780, 1.490411, -23.468750>, <-0.699735, 1.438133, -23.601858>, <-0.699735, 1.438133, -23.601858>, 
      <-0.193949, 1.756223, -23.678846>, <-0.243512, 1.720214, -23.826750>, <-0.270604, 1.700530, -23.876867>, <-0.362185, 1.633993, -23.990067>, 
      <0.087778, 2.010294, -23.835112>, <0.038214, 1.974284, -23.983014>, <-0.060490, 1.902571, -24.165610>, <-0.152070, 1.836034, -24.278808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.347720, 1.141498, -24.274909>, <0.256508, 1.075229, -24.387651>, <0.109382, 0.968336, -24.509165>, <-0.009791, 0.881751, -24.570181>, 
      <0.091181, 1.014417, -23.992669>, <-0.000030, 0.948148, -24.105411>, <-0.042394, 0.917369, -24.140400>, <-0.161567, 0.830785, -24.201416>, 
      <-0.188903, 0.751619, -23.611606>, <-0.190380, 0.750545, -23.613432>, <-0.298279, 0.672152, -23.702547>, <-0.300209, 0.670750, -23.703534>, 
      <-0.418884, 0.584528, -23.327336>, <-0.420361, 0.583454, -23.329160>, <-0.422744, 0.581723, -23.331126>, <-0.424674, 0.580321, -23.332115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.901754, 1.238728, -24.780282>, <0.762684, 1.137688, -24.952181>, <0.538362, 0.974708, -25.137453>, <0.356659, 0.842693, -25.230485>, 
      <0.884301, 1.050186, -24.655341>, <0.745232, 0.949146, -24.827240>, <0.567285, 0.819861, -24.974210>, <0.385582, 0.687846, -25.067240>, 
      <0.492480, 1.213207, -24.434171>, <0.401269, 1.146939, -24.546915>, <0.195028, 0.997095, -24.717253>, <0.075855, 0.910511, -24.778269>, 
      <0.347720, 1.141498, -24.274909>, <0.256508, 1.075229, -24.387651>, <0.109382, 0.968336, -24.509165>, <-0.009791, 0.881751, -24.570181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.379531, 1.485151, -24.502638>, <0.266753, 1.403213, -24.642038>, <0.084842, 1.271047, -24.792282>, <-0.062509, 1.163991, -24.867725>, 
      <0.528651, 1.378654, -24.560680>, <0.415874, 1.296716, -24.700082>, <0.212417, 1.148897, -24.868120>, <0.065067, 1.041841, -24.943563>, 
      <0.916542, 1.398482, -24.886147>, <0.777472, 1.297442, -25.058046>, <0.513855, 1.105913, -25.275773>, <0.332152, 0.973897, -25.368803>, 
      <0.901754, 1.238728, -24.780282>, <0.762684, 1.137688, -24.952181>, <0.538362, 0.974708, -25.137453>, <0.356659, 0.842693, -25.230485>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.174429, 1.758161, -24.497179>, <0.062169, 1.676600, -24.635941>, <-0.118909, 1.545039, -24.785496>, <-0.265584, 1.438473, -24.860592>, 
      <0.202899, 1.664997, -24.465453>, <0.090639, 1.583435, -24.604214>, <-0.078662, 1.460431, -24.744042>, <-0.225337, 1.353865, -24.819138>, 
      <0.300048, 1.541915, -24.471701>, <0.187271, 1.459978, -24.611101>, <0.016843, 1.336154, -24.751859>, <-0.130508, 1.229098, -24.827302>, 
      <0.379531, 1.485151, -24.502638>, <0.266753, 1.403213, -24.642038>, <0.084842, 1.271047, -24.792282>, <-0.062509, 1.163991, -24.867725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.132490, 2.293547, -24.777942>, <-0.006357, 2.192668, -24.949568>, <-0.230322, 2.029948, -25.134544>, <-0.411736, 1.898143, -25.227427>, 
      <0.280719, 2.258193, -24.877082>, <0.141871, 2.157314, -25.048706>, <-0.118892, 1.967858, -25.264077>, <-0.300306, 1.836054, -25.356958>, 
      <0.123910, 1.923475, -24.553478>, <0.011650, 1.841913, -24.692240>, <-0.190325, 1.695170, -24.859053>, <-0.336999, 1.588605, -24.934149>, 
      <0.174429, 1.758161, -24.497179>, <0.062169, 1.676600, -24.635941>, <-0.118909, 1.545039, -24.785496>, <-0.265584, 1.438473, -24.860592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.152070, 1.836034, -24.278808>, <-0.243651, 1.769497, -24.392008>, <-0.391372, 1.662171, -24.514013>, <-0.511028, 1.575236, -24.575277>, 
      <-0.039234, 1.944535, -24.433870>, <-0.130815, 1.877998, -24.547069>, <-0.336092, 1.728855, -24.716610>, <-0.455748, 1.641920, -24.777874>, 
      <-0.047162, 2.336395, -24.657787>, <-0.186010, 2.235516, -24.829413>, <-0.365375, 2.105200, -24.977552>, <-0.546789, 1.973395, -25.070435>, 
      <0.132490, 2.293547, -24.777942>, <-0.006357, 2.192668, -24.949568>, <-0.230322, 2.029948, -25.134544>, <-0.411736, 1.898143, -25.227427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-0.699735, 1.438133, -23.601858>, <-0.699735, 1.438133, -23.601858>, <-0.807422, 1.359893, -23.690800>, <-0.807422, 1.359893, -23.690800>, 
      <-0.362185, 1.633993, -23.990067>, <-0.453765, 1.567456, -24.103266>, <-0.494311, 1.537997, -24.136754>, <-0.613967, 1.451062, -24.198018>, 
      <-0.152070, 1.836034, -24.278808>, <-0.243651, 1.769497, -24.392008>, <-0.391372, 1.662171, -24.514013>, <-0.511028, 1.575236, -24.575277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.009791, 0.881751, -24.570181>, <-0.128964, 0.795167, -24.631197>, <-0.302511, 0.669078, -24.673869>, <-0.431503, 0.575359, -24.673869>, 
      <-0.161567, 0.830785, -24.201416>, <-0.280741, 0.744200, -24.262432>, <-0.330712, 0.707894, -24.274720>, <-0.459705, 0.614175, -24.274720>, 
      <-0.300209, 0.670750, -23.703534>, <-0.302139, 0.669348, -23.704523>, <-0.429414, 0.576877, -23.735818>, <-0.431503, 0.575359, -23.735818>, 
      <-0.424674, 0.580321, -23.332115>, <-0.426604, 0.578919, -23.333102>, <-0.429414, 0.576877, -23.333795>, <-0.431503, 0.575359, -23.333795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356659, 0.842693, -25.230485>, <0.174956, 0.710678, -25.323515>, <-0.089650, 0.518430, -25.388573>, <-0.286324, 0.375538, -25.388573>, 
      <0.385582, 0.687846, -25.067240>, <0.203879, 0.555831, -25.160270>, <-0.006023, 0.403327, -25.211880>, <-0.202697, 0.260435, -25.211880>, 
      <0.075855, 0.910511, -24.778269>, <-0.043319, 0.823927, -24.839285>, <-0.286597, 0.647175, -24.899101>, <-0.415589, 0.553456, -24.899101>, 
      <-0.009791, 0.881751, -24.570181>, <-0.128964, 0.795167, -24.631197>, <-0.302511, 0.669078, -24.673869>, <-0.431503, 0.575359, -24.673869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.062509, 1.163991, -24.867725>, <-0.209859, 1.056934, -24.943168>, <-0.424439, 0.901033, -24.995926>, <-0.583929, 0.785156, -24.995926>, 
      <0.065067, 1.041841, -24.943563>, <-0.082283, 0.934784, -25.019006>, <-0.322277, 0.760419, -25.078011>, <-0.481767, 0.644542, -25.078011>, 
      <0.332152, 0.973897, -25.368803>, <0.150449, 0.841882, -25.461834>, <-0.160509, 0.615959, -25.538288>, <-0.357183, 0.473067, -25.538288>, 
      <0.356659, 0.842693, -25.230485>, <0.174956, 0.710678, -25.323515>, <-0.089650, 0.518430, -25.388573>, <-0.286324, 0.375538, -25.388573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265584, 1.438473, -24.860592>, <-0.412259, 1.331908, -24.935688>, <-0.625855, 1.176721, -24.988205>, <-0.784614, 1.061376, -24.988205>, 
      <-0.225337, 1.353865, -24.819138>, <-0.372012, 1.247300, -24.894234>, <-0.571716, 1.102206, -24.943334>, <-0.730476, 0.986860, -24.943334>, 
      <-0.130508, 1.229098, -24.827302>, <-0.277858, 1.122042, -24.902746>, <-0.478892, 0.975982, -24.952173>, <-0.638383, 0.860105, -24.952173>, 
      <-0.062509, 1.163991, -24.867725>, <-0.209859, 1.056934, -24.943168>, <-0.424439, 0.901033, -24.995926>, <-0.583929, 0.785156, -24.995926>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.411736, 1.898143, -25.227427>, <-0.593150, 1.766338, -25.320309>, <-0.857334, 1.574397, -25.385264>, <-1.053695, 1.431733, -25.385264>, 
      <-0.300306, 1.836054, -25.356958>, <-0.481719, 1.704249, -25.449840>, <-0.789311, 1.480771, -25.525467>, <-0.985671, 1.338107, -25.525467>, 
      <-0.336999, 1.588605, -24.934149>, <-0.483674, 1.482039, -25.009245>, <-0.721920, 1.308943, -25.067824>, <-0.880679, 1.193598, -25.067824>, 
      <-0.265584, 1.438473, -24.860592>, <-0.412259, 1.331908, -24.935688>, <-0.625855, 1.176721, -24.988205>, <-0.784614, 1.061376, -24.988205>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.511028, 1.575236, -24.575277>, <-0.630684, 1.488301, -24.636541>, <-0.804933, 1.361701, -24.679382>, <-0.934448, 1.267604, -24.679382>, 
      <-0.455748, 1.641920, -24.777874>, <-0.575403, 1.554985, -24.839138>, <-0.817545, 1.379059, -24.898672>, <-0.947059, 1.284961, -24.898672>, 
      <-0.546789, 1.973395, -25.070435>, <-0.728202, 1.841590, -25.163317>, <-0.939778, 1.687872, -25.215338>, <-1.136139, 1.545207, -25.215338>, 
      <-0.411736, 1.898143, -25.227427>, <-0.593150, 1.766338, -25.320309>, <-0.857334, 1.574397, -25.385264>, <-1.053695, 1.431733, -25.385264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-0.807422, 1.359893, -23.690800>, <-0.807422, 1.359893, -23.690800>, <-0.934448, 1.267604, -23.722030>, <-0.934448, 1.267604, -23.722030>, 
      <-0.613967, 1.451062, -24.198018>, <-0.733623, 1.364127, -24.259282>, <-0.781450, 1.329379, -24.271038>, <-0.910964, 1.235281, -24.271038>, 
      <-0.511028, 1.575236, -24.575277>, <-0.630684, 1.488301, -24.636541>, <-0.804933, 1.361701, -24.679382>, <-0.934448, 1.267604, -24.679382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.431503, 0.575359, -24.673869>, <-0.560495, 0.481641, -24.673869>, <-0.734042, 0.355552, -24.631197>, <-0.853215, 0.268968, -24.570181>, 
      <-0.459705, 0.614175, -24.274720>, <-0.588697, 0.520457, -24.274720>, <-0.638668, 0.484151, -24.262432>, <-0.757841, 0.397566, -24.201416>, 
      <-0.431503, 0.575359, -23.735818>, <-0.433592, 0.573842, -23.735818>, <-0.560867, 0.481371, -23.704523>, <-0.562797, 0.479969, -23.703534>, 
      <-0.431503, 0.575359, -23.333795>, <-0.433592, 0.573842, -23.333795>, <-0.436402, 0.571800, -23.333102>, <-0.438332, 0.570398, -23.332115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.286324, 0.375538, -25.388573>, <-0.482998, 0.232646, -25.388573>, <-0.747605, 0.040399, -25.323515>, <-0.929308, -0.091616, -25.230485>, 
      <-0.202697, 0.260435, -25.211880>, <-0.399371, 0.117543, -25.211880>, <-0.609274, -0.034959, -25.160270>, <-0.790977, -0.166974, -25.067240>, 
      <-0.415589, 0.553456, -24.899101>, <-0.544582, 0.459738, -24.899101>, <-0.787860, 0.282986, -24.839285>, <-0.907033, 0.196401, -24.778269>, 
      <-0.431503, 0.575359, -24.673869>, <-0.560495, 0.481641, -24.673869>, <-0.734042, 0.355552, -24.631197>, <-0.853215, 0.268968, -24.570181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.583929, 0.785156, -24.995926>, <-0.743420, 0.669280, -24.995926>, <-0.958000, 0.513378, -24.943168>, <-1.105350, 0.406322, -24.867725>, 
      <-0.481767, 0.644542, -25.078011>, <-0.641258, 0.528666, -25.078011>, <-0.881251, 0.354300, -25.019006>, <-1.028601, 0.247244, -24.943563>, 
      <-0.357183, 0.473067, -25.538288>, <-0.553857, 0.330175, -25.538288>, <-0.864814, 0.104251, -25.461834>, <-1.046518, -0.027764, -25.368803>, 
      <-0.286324, 0.375538, -25.388573>, <-0.482998, 0.232646, -25.388573>, <-0.747605, 0.040399, -25.323515>, <-0.929308, -0.091616, -25.230485>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.784614, 1.061376, -24.988205>, <-0.943374, 0.946030, -24.988205>, <-1.156970, 0.790844, -24.935688>, <-1.303645, 0.684278, -24.860592>, 
      <-0.730476, 0.986860, -24.943334>, <-0.889235, 0.871515, -24.943334>, <-1.088940, 0.726421, -24.894234>, <-1.235615, 0.619855, -24.819138>, 
      <-0.638383, 0.860105, -24.952173>, <-0.797874, 0.744228, -24.952173>, <-0.998908, 0.598169, -24.902746>, <-1.146258, 0.491112, -24.827302>, 
      <-0.583929, 0.785156, -24.995926>, <-0.743420, 0.669280, -24.995926>, <-0.958000, 0.513378, -24.943168>, <-1.105350, 0.406322, -24.867725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.053695, 1.431733, -25.385264>, <-1.250055, 1.289069, -25.385264>, <-1.514240, 1.097127, -25.320309>, <-1.695653, 0.965322, -25.227427>, 
      <-0.985671, 1.338107, -25.525467>, <-1.182032, 1.195442, -25.525467>, <-1.489623, 0.971964, -25.449840>, <-1.671037, 0.840159, -25.356958>, 
      <-0.880679, 1.193598, -25.067824>, <-1.039439, 1.078252, -25.067824>, <-1.277685, 0.905157, -25.009245>, <-1.424359, 0.798591, -24.934149>, 
      <-0.784614, 1.061376, -24.988205>, <-0.943374, 0.946030, -24.988205>, <-1.156970, 0.790844, -24.935688>, <-1.303645, 0.684278, -24.860592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -24.679382>, <-1.063962, 1.173506, -24.679382>, <-1.238212, 1.046906, -24.636541>, <-1.357867, 0.959971, -24.575277>, 
      <-0.947059, 1.284961, -24.898672>, <-1.076573, 1.190864, -24.898672>, <-1.318714, 1.014938, -24.839138>, <-1.438370, 0.928003, -24.777874>, 
      <-1.136139, 1.545207, -25.215338>, <-1.332499, 1.402543, -25.215338>, <-1.544075, 1.248824, -25.163317>, <-1.725489, 1.117020, -25.070435>, 
      <-1.053695, 1.431733, -25.385264>, <-1.250055, 1.289069, -25.385264>, <-1.514240, 1.097127, -25.320309>, <-1.695653, 0.965322, -25.227427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-0.934448, 1.267604, -23.722030>, <-0.934448, 1.267604, -23.722030>, <-1.061474, 1.175314, -23.690800>, <-1.061474, 1.175314, -23.690800>, 
      <-0.910964, 1.235281, -24.271038>, <-1.040479, 1.141183, -24.271038>, <-1.088306, 1.106435, -24.259282>, <-1.207962, 1.019500, -24.198018>, 
      <-0.934448, 1.267604, -24.679382>, <-1.063962, 1.173506, -24.679382>, <-1.238212, 1.046906, -24.636541>, <-1.357867, 0.959971, -24.575277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.853215, 0.268968, -24.570181>, <-0.972388, 0.182383, -24.509165>, <-1.119514, 0.075490, -24.387651>, <-1.210726, 0.009221, -24.274909>, 
      <-0.757841, 0.397566, -24.201416>, <-0.877015, 0.310982, -24.140400>, <-0.919378, 0.280203, -24.105411>, <-1.010590, 0.213934, -23.992669>, 
      <-0.562797, 0.479969, -23.703534>, <-0.564727, 0.478567, -23.702547>, <-0.672626, 0.400173, -23.613432>, <-0.674103, 0.399100, -23.611606>, 
      <-0.438332, 0.570398, -23.332115>, <-0.440262, 0.568995, -23.331126>, <-0.442645, 0.567264, -23.329160>, <-0.444122, 0.566191, -23.327336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.929308, -0.091616, -25.230485>, <-1.111011, -0.223632, -25.137453>, <-1.335333, -0.386611, -24.952181>, <-1.474403, -0.487651, -24.780282>, 
      <-0.790977, -0.166974, -25.067240>, <-0.972680, -0.298990, -24.974210>, <-1.150626, -0.428275, -24.827240>, <-1.289696, -0.529315, -24.655341>, 
      <-0.907033, 0.196401, -24.778269>, <-1.026206, 0.109817, -24.717253>, <-1.232448, -0.040026, -24.546915>, <-1.323659, -0.106295, -24.434171>, 
      <-0.853215, 0.268968, -24.570181>, <-0.972388, 0.182383, -24.509165>, <-1.119514, 0.075490, -24.387651>, <-1.210726, 0.009221, -24.274909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.105350, 0.406322, -24.867725>, <-1.252701, 0.299266, -24.792282>, <-1.434612, 0.167099, -24.642038>, <-1.547389, 0.085162, -24.502638>, 
      <-1.028601, 0.247244, -24.943563>, <-1.175952, 0.140188, -24.868120>, <-1.379408, -0.007632, -24.700082>, <-1.492185, -0.089569, -24.560680>, 
      <-1.046518, -0.027764, -25.368803>, <-1.228221, -0.159779, -25.275773>, <-1.491838, -0.351308, -25.058046>, <-1.630908, -0.452348, -24.886147>, 
      <-0.929308, -0.091616, -25.230485>, <-1.111011, -0.223632, -25.137453>, <-1.335333, -0.386611, -24.952181>, <-1.474403, -0.487651, -24.780282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.303645, 0.684278, -24.860592>, <-1.450320, 0.577712, -24.785496>, <-1.631398, 0.446152, -24.635941>, <-1.743658, 0.364590, -24.497179>, 
      <-1.235615, 0.619855, -24.819138>, <-1.382290, 0.513290, -24.744042>, <-1.551591, 0.390285, -24.604214>, <-1.663851, 0.308724, -24.465453>, 
      <-1.146258, 0.491112, -24.827302>, <-1.293608, 0.384056, -24.751859>, <-1.464037, 0.260233, -24.611101>, <-1.576814, 0.178295, -24.471701>, 
      <-1.105350, 0.406322, -24.867725>, <-1.252701, 0.299266, -24.792282>, <-1.434612, 0.167099, -24.642038>, <-1.547389, 0.085162, -24.502638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.695653, 0.965322, -25.227427>, <-1.877067, 0.833518, -25.134544>, <-2.101032, 0.670798, -24.949568>, <-2.239880, 0.569919, -24.777942>, 
      <-1.671037, 0.840159, -25.356958>, <-1.852450, 0.708355, -25.264077>, <-2.113214, 0.518899, -25.048706>, <-2.252061, 0.418020, -24.877082>, 
      <-1.424359, 0.798591, -24.934149>, <-1.571034, 0.692026, -24.859053>, <-1.773009, 0.545282, -24.692240>, <-1.885269, 0.463721, -24.553478>, 
      <-1.303645, 0.684278, -24.860592>, <-1.450320, 0.577712, -24.785496>, <-1.631398, 0.446152, -24.635941>, <-1.743658, 0.364590, -24.497179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.357867, 0.959971, -24.575277>, <-1.477523, 0.873036, -24.514013>, <-1.625245, 0.765710, -24.392008>, <-1.716825, 0.699173, -24.278808>, 
      <-1.438370, 0.928003, -24.777874>, <-1.558026, 0.841068, -24.716610>, <-1.763303, 0.691925, -24.547069>, <-1.854884, 0.625388, -24.433870>, 
      <-1.725489, 1.117020, -25.070435>, <-1.906902, 0.985215, -24.977552>, <-2.086267, 0.854899, -24.829413>, <-2.225115, 0.754020, -24.657787>, 
      <-1.695653, 0.965322, -25.227427>, <-1.877067, 0.833518, -25.134544>, <-2.101032, 0.670798, -24.949568>, <-2.239880, 0.569919, -24.777942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-1.061474, 1.175314, -23.690800>, <-1.061474, 1.175314, -23.690800>, <-1.169161, 1.097074, -23.601858>, <-1.169161, 1.097074, -23.601858>, 
      <-1.207962, 1.019500, -24.198018>, <-1.327617, 0.932565, -24.136754>, <-1.368163, 0.903107, -24.103266>, <-1.459744, 0.836569, -23.990067>, 
      <-1.357867, 0.959971, -24.575277>, <-1.477523, 0.873036, -24.514013>, <-1.625245, 0.765710, -24.392008>, <-1.716825, 0.699173, -24.278808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.210726, 0.009221, -24.274909>, <-1.301937, -0.057048, -24.162165>, <-1.400243, -0.128472, -23.980309>, <-1.449606, -0.164336, -23.833002>, 
      <-1.010590, 0.213934, -23.992669>, <-1.101801, 0.147665, -23.879925>, <-1.130108, 0.127099, -23.827562>, <-1.179471, 0.091235, -23.680256>, 
      <-0.674103, 0.399100, -23.611606>, <-0.675580, 0.398027, -23.609781>, <-0.747676, 0.345646, -23.476411>, <-0.748475, 0.345066, -23.474026>, 
      <-0.444122, 0.566191, -23.327336>, <-0.445599, 0.565118, -23.325510>, <-0.447191, 0.563961, -23.322565>, <-0.447991, 0.563380, -23.320179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.474403, -0.487651, -24.780282>, <-1.613472, -0.588691, -24.608381>, <-1.763359, -0.697590, -24.331104>, <-1.838623, -0.752273, -24.106506>, 
      <-1.289696, -0.529315, -24.655341>, <-1.428765, -0.630355, -24.483440>, <-1.547665, -0.716741, -24.263486>, <-1.622929, -0.771423, -24.038890>, 
      <-1.323659, -0.106295, -24.434171>, <-1.414870, -0.172564, -24.321429>, <-1.552676, -0.272686, -24.066502>, <-1.602040, -0.308550, -23.919195>, 
      <-1.210726, 0.009221, -24.274909>, <-1.301937, -0.057048, -24.162165>, <-1.400243, -0.128472, -23.980309>, <-1.449606, -0.164336, -23.833002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.547389, 0.085162, -24.502638>, <-1.660166, 0.003225, -24.363237>, <-1.781716, -0.085086, -24.138384>, <-1.842750, -0.129431, -23.956250>, 
      <-1.492185, -0.089569, -24.560680>, <-1.604962, -0.171507, -24.421280>, <-1.740907, -0.270276, -24.169795>, <-1.801942, -0.314621, -23.987661>, 
      <-1.630908, -0.452348, -24.886147>, <-1.769977, -0.553388, -24.714246>, <-1.946120, -0.681364, -24.388398>, <-2.021384, -0.736046, -24.163802>, 
      <-1.474403, -0.487651, -24.780282>, <-1.613472, -0.588691, -24.608381>, <-1.763359, -0.697590, -24.331104>, <-1.838623, -0.752273, -24.106506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.743658, 0.364590, -24.497179>, <-1.855918, 0.283028, -24.358418>, <-1.976910, 0.195122, -24.134592>, <-2.037665, 0.150981, -23.953293>, 
      <-1.663851, 0.308724, -24.465453>, <-1.776111, 0.227162, -24.326691>, <-1.889234, 0.144973, -24.117422>, <-1.949989, 0.100832, -23.936123>, 
      <-1.576814, 0.178295, -24.471701>, <-1.689590, 0.096358, -24.332301>, <-1.803467, 0.013622, -24.121642>, <-1.864502, -0.030722, -23.939507>, 
      <-1.547389, 0.085162, -24.502638>, <-1.660166, 0.003225, -24.363237>, <-1.781716, -0.085086, -24.138384>, <-1.842750, -0.129431, -23.956250>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.239880, 0.569919, -24.777942>, <-2.378728, 0.469040, -24.606317>, <-2.528376, 0.360314, -24.329482>, <-2.603520, 0.305719, -24.105242>, 
      <-2.252061, 0.418020, -24.877082>, <-2.390909, 0.317141, -24.705456>, <-2.565146, 0.190551, -24.383134>, <-2.640290, 0.135956, -24.158896>, 
      <-1.885269, 0.463721, -24.553478>, <-1.997529, 0.382159, -24.414717>, <-2.132484, 0.284108, -24.165061>, <-2.193239, 0.239967, -23.983762>, 
      <-1.743658, 0.364590, -24.497179>, <-1.855918, 0.283028, -24.358418>, <-1.976910, 0.195122, -24.134592>, <-2.037665, 0.150981, -23.953293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.716825, 0.699173, -24.278808>, <-1.808406, 0.632636, -24.165610>, <-1.907110, 0.560923, -23.983014>, <-1.956673, 0.524913, -23.835114>, 
      <-1.854884, 0.625388, -24.433870>, <-1.946464, 0.558851, -24.320670>, <-2.083626, 0.459197, -24.066934>, <-2.133189, 0.423187, -23.919034>, 
      <-2.225115, 0.754020, -24.657787>, <-2.363963, 0.653141, -24.486162>, <-2.483811, 0.566066, -24.264454>, <-2.558955, 0.511471, -24.040214>, 
      <-2.239880, 0.569919, -24.777942>, <-2.378728, 0.469040, -24.606317>, <-2.528376, 0.360314, -24.329482>, <-2.603520, 0.305719, -24.105242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-1.169161, 1.097074, -23.601858>, <-1.169161, 1.097074, -23.601858>, <-1.241116, 1.044796, -23.468750>, <-1.241116, 1.044796, -23.468750>, 
      <-1.459744, 0.836569, -23.990067>, <-1.551324, 0.770032, -23.876867>, <-1.578416, 0.750349, -23.826747>, <-1.627979, 0.714339, -23.678846>, 
      <-1.716825, 0.699173, -24.278808>, <-1.808406, 0.632636, -24.165610>, <-1.907110, 0.560923, -23.983014>, <-1.956673, 0.524913, -23.835114>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.449606, -0.164336, -23.833002>, <-1.498970, -0.200201, -23.685696>, <-1.533490, -0.225281, -23.471179>, <-1.533490, -0.225281, -23.311738>, 
      <-1.179471, 0.091235, -23.680256>, <-1.228834, 0.055370, -23.532949>, <-1.238774, 0.048148, -23.471179>, <-1.238774, 0.048148, -23.311738>, 
      <-0.748475, 0.345066, -23.474026>, <-0.749275, 0.344485, -23.471640>, <-0.774591, 0.326091, -23.314320>, <-0.774591, 0.326091, -23.311738>, 
      <-0.447991, 0.563380, -23.320179>, <-0.448790, 0.562800, -23.317794>, <-0.449349, 0.562393, -23.314320>, <-0.449349, 0.562393, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.838623, -0.752273, -24.106506>, <-1.913887, -0.806955, -23.881910>, <-1.966521, -0.845196, -23.554838>, <-1.966521, -0.845196, -23.311738>, 
      <-1.622929, -0.771423, -24.038890>, <-1.698193, -0.826106, -23.814293>, <-1.739945, -0.856440, -23.554838>, <-1.739945, -0.856440, -23.311738>, 
      <-1.602040, -0.308550, -23.919195>, <-1.651403, -0.344415, -23.771888>, <-1.699794, -0.379573, -23.471179>, <-1.699794, -0.379573, -23.311738>, 
      <-1.449606, -0.164336, -23.833002>, <-1.498970, -0.200201, -23.685696>, <-1.533490, -0.225281, -23.471179>, <-1.533490, -0.225281, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.842750, -0.129431, -23.956250>, <-1.903785, -0.173775, -23.774115>, <-1.946467, -0.204786, -23.508878>, <-1.946467, -0.204786, -23.311738>, 
      <-1.801942, -0.314621, -23.987661>, <-1.862976, -0.358965, -23.805526>, <-1.910714, -0.393648, -23.508878>, <-1.910714, -0.393648, -23.311738>, 
      <-2.021384, -0.736046, -24.163802>, <-2.096648, -0.790729, -23.939205>, <-2.158502, -0.835668, -23.554838>, <-2.158502, -0.835668, -23.311738>, 
      <-1.838623, -0.752273, -24.106506>, <-1.913887, -0.806955, -23.881910>, <-1.966521, -0.845196, -23.554838>, <-1.966521, -0.845196, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.037665, 0.150981, -23.953293>, <-2.098419, 0.106840, -23.771994>, <-2.140907, 0.075972, -23.507974>, <-2.140907, 0.075972, -23.311738>, 
      <-1.949989, 0.100832, -23.936123>, <-2.010744, 0.056691, -23.754824>, <-2.050468, 0.027830, -23.507974>, <-2.050468, 0.027830, -23.311738>, 
      <-1.864502, -0.030722, -23.939507>, <-1.925536, -0.075066, -23.757371>, <-1.965524, -0.104120, -23.508878>, <-1.965524, -0.104120, -23.311738>, 
      <-1.842750, -0.129431, -23.956250>, <-1.903785, -0.173775, -23.774115>, <-1.946467, -0.204786, -23.508878>, <-1.946467, -0.204786, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.603520, 0.305719, -24.105242>, <-2.678664, 0.251124, -23.881003>, <-2.731214, 0.212944, -23.554453>, <-2.731214, 0.212944, -23.311738>, 
      <-2.640290, 0.135956, -24.158896>, <-2.715434, 0.081360, -23.934656>, <-2.776618, 0.036908, -23.554453>, <-2.776618, 0.036908, -23.311738>, 
      <-2.193239, 0.239967, -23.983762>, <-2.253994, 0.195827, -23.802462>, <-2.301384, 0.161396, -23.507974>, <-2.301384, 0.161396, -23.311738>, 
      <-2.037665, 0.150981, -23.953293>, <-2.098419, 0.106840, -23.771994>, <-2.140907, 0.075972, -23.507974>, <-2.140907, 0.075972, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.956673, 0.524913, -23.835114>, <-2.006236, 0.488904, -23.687210>, <-2.040897, 0.463721, -23.471827>, <-2.040897, 0.463721, -23.311738>, 
      <-2.133189, 0.423187, -23.919034>, <-2.182752, 0.387178, -23.771130>, <-2.230917, 0.352184, -23.471827>, <-2.230917, 0.352184, -23.311738>, 
      <-2.558955, 0.511471, -24.040214>, <-2.634099, 0.456875, -23.815974>, <-2.676184, 0.426299, -23.554453>, <-2.676184, 0.426299, -23.311738>, 
      <-2.603520, 0.305719, -24.105242>, <-2.678664, 0.251124, -23.881003>, <-2.731214, 0.212944, -23.554453>, <-2.731214, 0.212944, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-1.241116, 1.044796, -23.468750>, <-1.241116, 1.044796, -23.468750>, <-1.266383, 1.026439, -23.311738>, <-1.266383, 1.026439, -23.311738>, 
      <-1.627979, 0.714339, -23.678846>, <-1.677542, 0.678330, -23.530942>, <-1.687056, 0.671418, -23.471827>, <-1.687056, 0.671418, -23.311738>, 
      <-1.956673, 0.524913, -23.835114>, <-2.006236, 0.488904, -23.687210>, <-2.040897, 0.463721, -23.471827>, <-2.040897, 0.463721, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.533490, -0.225281, -23.311738>, <-1.533490, -0.225281, -23.152294>, <-1.498970, -0.200201, -22.937779>, <-1.449607, -0.164336, -22.790472>, 
      <-1.238774, 0.048148, -23.311738>, <-1.238774, 0.048148, -23.152294>, <-1.228834, 0.055370, -23.090526>, <-1.179471, 0.091234, -22.943221>, 
      <-0.774591, 0.326091, -23.311738>, <-0.774591, 0.326091, -23.309155>, <-0.749275, 0.344485, -23.151835>, <-0.748475, 0.345066, -23.149448>, 
      <-0.449349, 0.562393, -23.311738>, <-0.449349, 0.562393, -23.309155>, <-0.448790, 0.562800, -23.305682>, <-0.447991, 0.563380, -23.303294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.966521, -0.845196, -23.311738>, <-1.966521, -0.845196, -23.068634>, <-1.913887, -0.806955, -22.741563>, <-1.838623, -0.752273, -22.516966>, 
      <-1.739945, -0.856440, -23.311738>, <-1.739945, -0.856440, -23.068634>, <-1.698193, -0.826106, -22.809181>, <-1.622929, -0.771423, -22.584584>, 
      <-1.699794, -0.379573, -23.311738>, <-1.699794, -0.379573, -23.152294>, <-1.651403, -0.344415, -22.851586>, <-1.602040, -0.308551, -22.704278>, 
      <-1.533490, -0.225281, -23.311738>, <-1.533490, -0.225281, -23.152294>, <-1.498970, -0.200201, -22.937779>, <-1.449607, -0.164336, -22.790472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.946467, -0.204786, -23.311738>, <-1.946467, -0.204786, -23.114595>, <-1.903785, -0.173775, -22.849360>, <-1.842751, -0.129431, -22.667226>, 
      <-1.910714, -0.393648, -23.311738>, <-1.910714, -0.393648, -23.114595>, <-1.862976, -0.358965, -22.817947>, <-1.801942, -0.314621, -22.635813>, 
      <-2.158502, -0.835668, -23.311738>, <-2.158502, -0.835668, -23.068634>, <-2.096648, -0.790729, -22.684269>, <-2.021384, -0.736046, -22.459670>, 
      <-1.966521, -0.845196, -23.311738>, <-1.966521, -0.845196, -23.068634>, <-1.913887, -0.806955, -22.741563>, <-1.838623, -0.752273, -22.516966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.140907, 0.075972, -23.311738>, <-2.140907, 0.075972, -23.115499>, <-2.098420, 0.106840, -22.851480>, <-2.037665, 0.150981, -22.670179>, 
      <-2.050468, 0.027830, -23.311738>, <-2.050468, 0.027830, -23.115499>, <-2.010744, 0.056691, -22.868651>, <-1.949989, 0.100832, -22.687349>, 
      <-1.965524, -0.104120, -23.311738>, <-1.965524, -0.104120, -23.114595>, <-1.925536, -0.075066, -22.866102>, <-1.864502, -0.030722, -22.683968>, 
      <-1.946467, -0.204786, -23.311738>, <-1.946467, -0.204786, -23.114595>, <-1.903785, -0.173775, -22.849360>, <-1.842751, -0.129431, -22.667226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.731214, 0.212944, -23.311738>, <-2.731214, 0.212944, -23.069021>, <-2.678664, 0.251123, -22.742472>, <-2.603520, 0.305719, -22.518232>, 
      <-2.776618, 0.036908, -23.311738>, <-2.776618, 0.036908, -23.069021>, <-2.715434, 0.081361, -22.688818>, <-2.640290, 0.135956, -22.464579>, 
      <-2.301384, 0.161396, -23.311738>, <-2.301384, 0.161396, -23.115499>, <-2.253994, 0.195826, -22.821013>, <-2.193239, 0.239967, -22.639712>, 
      <-2.140907, 0.075972, -23.311738>, <-2.140907, 0.075972, -23.115499>, <-2.098420, 0.106840, -22.851480>, <-2.037665, 0.150981, -22.670179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.040897, 0.463721, -23.311738>, <-2.040897, 0.463721, -23.151648>, <-2.006236, 0.488903, -22.936264>, <-1.956673, 0.524913, -22.788360>, 
      <-2.230917, 0.352184, -23.311738>, <-2.230917, 0.352184, -23.151648>, <-2.182752, 0.387178, -22.852344>, <-2.133189, 0.423187, -22.704442>, 
      <-2.676184, 0.426299, -23.311738>, <-2.676184, 0.426299, -23.069021>, <-2.634099, 0.456875, -22.807499>, <-2.558955, 0.511470, -22.583259>, 
      <-2.731214, 0.212944, -23.311738>, <-2.731214, 0.212944, -23.069021>, <-2.678664, 0.251123, -22.742472>, <-2.603520, 0.305719, -22.518232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, <-0.934448, 1.267604, -23.311738>, 
      <-1.266383, 1.026439, -23.311738>, <-1.266383, 1.026439, -23.311738>, <-1.241116, 1.044796, -23.154725>, <-1.241116, 1.044796, -23.154725>, 
      <-1.687056, 0.671418, -23.311738>, <-1.687056, 0.671418, -23.151648>, <-1.677542, 0.678330, -23.092531>, <-1.627979, 0.714339, -22.944627>, 
      <-2.040897, 0.463721, -23.311738>, <-2.040897, 0.463721, -23.151648>, <-2.006236, 0.488903, -22.936264>, <-1.956673, 0.524913, -22.788360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143298, -1.962315, -22.790472>, <-0.093935, -1.926451, -22.643165>, <0.004371, -1.855027, -22.461307>, <0.095582, -1.788758, -22.348565>, 
      <0.126837, -1.706745, -22.943221>, <0.176201, -1.670880, -22.795914>, <0.204507, -1.650314, -22.743547>, <0.295719, -1.584045, -22.630805>, 
      <0.557833, -1.452914, -23.149448>, <0.558632, -1.452333, -23.147062>, <0.630728, -1.399952, -23.013691>, <0.632205, -1.398879, -23.011866>, 
      <0.858318, -1.234599, -23.303294>, <0.859117, -1.234018, -23.300909>, <0.860709, -1.232861, -23.297965>, <0.862186, -1.231788, -23.296139>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.532315, -2.550252, -22.516966>, <-0.457052, -2.495569, -22.292368>, <-0.307164, -2.386670, -22.015093>, <-0.168095, -2.285630, -21.843194>, 
      <-0.316621, -2.569402, -22.584584>, <-0.241358, -2.514720, -22.359986>, <-0.122458, -2.428334, -22.140034>, <0.016612, -2.327294, -21.968134>, 
      <-0.295731, -2.106529, -22.704278>, <-0.246368, -2.070665, -22.556973>, <-0.108562, -1.970543, -22.302043>, <-0.017351, -1.904274, -22.189301>, 
      <-0.143298, -1.962315, -22.790472>, <-0.093935, -1.926451, -22.643165>, <0.004371, -1.855027, -22.461307>, <0.095582, -1.788758, -22.348565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.536442, -1.927410, -22.667226>, <-0.475408, -1.883066, -22.485090>, <-0.353858, -1.794755, -22.260235>, <-0.241081, -1.712817, -22.120834>, 
      <-0.495634, -2.112600, -22.635813>, <-0.434599, -2.068256, -22.453678>, <-0.298654, -1.969486, -22.202192>, <-0.185877, -1.887548, -22.062792>, 
      <-0.715076, -2.534025, -22.459670>, <-0.639812, -2.479343, -22.235074>, <-0.463669, -2.351367, -21.909227>, <-0.324599, -2.250327, -21.737328>, 
      <-0.532315, -2.550252, -22.516966>, <-0.457052, -2.495569, -22.292368>, <-0.307164, -2.386670, -22.015093>, <-0.168095, -2.285630, -21.843194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.731357, -1.646998, -22.670179>, <-0.670602, -1.602857, -22.488878>, <-0.549610, -1.514951, -22.265054>, <-0.437350, -1.433389, -22.126293>, 
      <-0.643681, -1.697147, -22.687349>, <-0.582927, -1.653006, -22.506048>, <-0.469803, -1.570817, -22.296781>, <-0.357543, -1.489255, -22.158021>, 
      <-0.558194, -1.828701, -22.683968>, <-0.497159, -1.784357, -22.501834>, <-0.383283, -1.701621, -22.291173>, <-0.270506, -1.619684, -22.151771>, 
      <-0.536442, -1.927410, -22.667226>, <-0.475408, -1.883066, -22.485090>, <-0.353858, -1.794755, -22.260235>, <-0.241081, -1.712817, -22.120834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.297212, -1.492260, -22.518232>, <-1.222068, -1.437665, -22.293994>, <-1.072420, -1.328939, -22.017157>, <-0.933572, -1.228060, -21.845531>, 
      <-1.333982, -1.662023, -22.464579>, <-1.258838, -1.607428, -22.240339>, <-1.084601, -1.480837, -21.918016>, <-0.945754, -1.379958, -21.746392>, 
      <-0.886931, -1.558012, -22.639712>, <-0.826176, -1.513871, -22.458410>, <-0.691221, -1.415820, -22.208757>, <-0.578961, -1.334258, -22.069995>, 
      <-0.731357, -1.646998, -22.670179>, <-0.670602, -1.602857, -22.488878>, <-0.549610, -1.514951, -22.265054>, <-0.437350, -1.433389, -22.126293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.650365, -1.273066, -22.788360>, <-0.600802, -1.237056, -22.640459>, <-0.502098, -1.165343, -22.457864>, <-0.410517, -1.098806, -22.344666>, 
      <-0.826881, -1.374792, -22.704442>, <-0.777318, -1.338782, -22.556539>, <-0.640156, -1.239128, -22.302803>, <-0.548576, -1.172591, -22.189603>, 
      <-1.252647, -1.286509, -22.583259>, <-1.177504, -1.231913, -22.359021>, <-1.057655, -1.144839, -22.137314>, <-0.918807, -1.043960, -21.965688>, 
      <-1.297212, -1.492260, -22.518232>, <-1.222068, -1.437665, -22.293994>, <-1.072420, -1.328939, -22.017157>, <-0.933572, -1.228060, -21.845531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.065193, -0.753183, -23.154725>, <0.065193, -0.753183, -23.154725>, <0.137147, -0.700905, -23.021616>, <0.137147, -0.700905, -23.021616>, 
      <-0.321671, -1.083640, -22.944627>, <-0.272108, -1.047630, -22.796726>, <-0.245016, -1.027947, -22.746606>, <-0.153436, -0.961410, -22.633408>, 
      <-0.650365, -1.273066, -22.788360>, <-0.600802, -1.237056, -22.640459>, <-0.502098, -1.165343, -22.457864>, <-0.410517, -1.098806, -22.344666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.095582, -1.788758, -22.348565>, <0.186794, -1.722489, -22.235821>, <0.333919, -1.615596, -22.114307>, <0.453093, -1.529012, -22.053291>, 
      <0.295719, -1.584045, -22.630805>, <0.386930, -1.517776, -22.518061>, <0.429293, -1.486997, -22.483072>, <0.548467, -1.400413, -22.422056>, 
      <0.632205, -1.398879, -23.011866>, <0.633682, -1.397806, -23.010040>, <0.741581, -1.319413, -22.920925>, <0.743511, -1.318011, -22.919938>, 
      <0.862186, -1.231788, -23.296139>, <0.863663, -1.230715, -23.294314>, <0.866046, -1.228984, -23.292346>, <0.867976, -1.227582, -23.291357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.168095, -2.285630, -21.843194>, <-0.029025, -2.184590, -21.671293>, <0.195297, -2.021610, -21.486021>, <0.377000, -1.889596, -21.392990>, 
      <0.016612, -2.327294, -21.968134>, <0.155682, -2.226254, -21.796234>, <0.333628, -2.096969, -21.649266>, <0.515331, -1.964954, -21.556234>, 
      <-0.017351, -1.904274, -22.189301>, <0.073860, -1.838005, -22.076557>, <0.280102, -1.688162, -21.906219>, <0.399275, -1.601578, -21.845203>, 
      <0.095582, -1.788758, -22.348565>, <0.186794, -1.722489, -22.235821>, <0.333919, -1.615596, -22.114307>, <0.453093, -1.529012, -22.053291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.241081, -1.712817, -22.120834>, <-0.128304, -1.630880, -21.981434>, <0.053608, -1.498713, -21.831192>, <0.200958, -1.391657, -21.755749>, 
      <-0.185877, -1.887548, -22.062792>, <-0.073100, -1.805611, -21.923392>, <0.130356, -1.657792, -21.755354>, <0.277707, -1.550735, -21.679910>, 
      <-0.324599, -2.250327, -21.737328>, <-0.185530, -2.149287, -21.565427>, <0.078087, -1.957758, -21.347702>, <0.259790, -1.825743, -21.254670>, 
      <-0.168095, -2.285630, -21.843194>, <-0.029025, -2.184590, -21.671293>, <0.195297, -2.021610, -21.486021>, <0.377000, -1.889596, -21.392990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.437350, -1.433389, -22.126293>, <-0.325090, -1.351827, -21.987531>, <-0.144012, -1.220266, -21.837978>, <0.002663, -1.113701, -21.762882>, 
      <-0.357543, -1.489255, -22.158021>, <-0.245283, -1.407694, -22.019259>, <-0.075981, -1.284689, -21.879432>, <0.070693, -1.178124, -21.804336>, 
      <-0.270506, -1.619684, -22.151771>, <-0.157729, -1.537746, -22.012371>, <0.012700, -1.413923, -21.871614>, <0.160050, -1.306867, -21.796171>, 
      <-0.241081, -1.712817, -22.120834>, <-0.128304, -1.630880, -21.981434>, <0.053608, -1.498713, -21.831192>, <0.200958, -1.391657, -21.755749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.933572, -1.228060, -21.845531>, <-0.794724, -1.127181, -21.673906>, <-0.570759, -0.964461, -21.488930>, <-0.389345, -0.832657, -21.396048>, 
      <-0.945754, -1.379958, -21.746392>, <-0.806906, -1.279080, -21.574766>, <-0.546142, -1.089625, -21.359398>, <-0.364729, -0.957820, -21.266515>, 
      <-0.578961, -1.334258, -22.069995>, <-0.466701, -1.252697, -21.931234>, <-0.264726, -1.105953, -21.764421>, <-0.118052, -0.999388, -21.689325>, 
      <-0.437350, -1.433389, -22.126293>, <-0.325090, -1.351827, -21.987531>, <-0.144012, -1.220266, -21.837978>, <0.002663, -1.113701, -21.762882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.410517, -1.098806, -22.344666>, <-0.318937, -1.032269, -22.231466>, <-0.171215, -0.924943, -22.109461>, <-0.051560, -0.838008, -22.048197>, 
      <-0.548576, -1.172591, -22.189603>, <-0.456995, -1.106054, -22.076405>, <-0.251718, -0.956911, -21.906864>, <-0.132062, -0.869976, -21.845600>, 
      <-0.918807, -1.043960, -21.965688>, <-0.779960, -0.943081, -21.794064>, <-0.600594, -0.812764, -21.645922>, <-0.419181, -0.680960, -21.553040>, 
      <-0.933572, -1.228060, -21.845531>, <-0.794724, -1.127181, -21.673906>, <-0.570759, -0.964461, -21.488930>, <-0.389345, -0.832657, -21.396048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.137147, -0.700905, -23.021616>, <0.137147, -0.700905, -23.021616>, <0.244834, -0.622665, -22.932675>, <0.244834, -0.622665, -22.932675>, 
      <-0.153436, -0.961410, -22.633408>, <-0.061855, -0.894872, -22.520208>, <-0.021309, -0.865414, -22.486722>, <0.098346, -0.778479, -22.425458>, 
      <-0.410517, -1.098806, -22.344666>, <-0.318937, -1.032269, -22.231466>, <-0.171215, -0.924943, -22.109461>, <-0.051560, -0.838008, -22.048197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.453093, -1.529012, -22.053291>, <0.572266, -1.442427, -21.992275>, <0.745813, -1.316338, -21.949606>, <0.874805, -1.222620, -21.949606>, 
      <0.548467, -1.400413, -22.422056>, <0.667640, -1.313828, -22.361040>, <0.717611, -1.277522, -22.348754>, <0.846604, -1.183804, -22.348754>, 
      <0.743511, -1.318011, -22.919938>, <0.745441, -1.316608, -22.918949>, <0.872716, -1.224138, -22.887656>, <0.874805, -1.222620, -22.887656>, 
      <0.867976, -1.227582, -23.291357>, <0.869906, -1.226180, -23.290370>, <0.872716, -1.224138, -23.289677>, <0.874805, -1.222620, -23.289677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.377000, -1.889596, -21.392990>, <0.558703, -1.757581, -21.299958>, <0.823309, -1.565333, -21.234899>, <1.019983, -1.422441, -21.234899>, 
      <0.515331, -1.964954, -21.556234>, <0.697034, -1.832939, -21.463203>, <0.906937, -1.680436, -21.411592>, <1.103611, -1.537544, -21.411592>, 
      <0.399275, -1.601578, -21.845203>, <0.518448, -1.514993, -21.784187>, <0.761726, -1.338241, -21.724373>, <0.890719, -1.244523, -21.724373>, 
      <0.453093, -1.529012, -22.053291>, <0.572266, -1.442427, -21.992275>, <0.745813, -1.316338, -21.949606>, <0.874805, -1.222620, -21.949606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.200958, -1.391657, -21.755749>, <0.348308, -1.284601, -21.680306>, <0.562888, -1.128700, -21.627549>, <0.722379, -1.012823, -21.627549>, 
      <0.277707, -1.550735, -21.679910>, <0.425057, -1.443679, -21.604467>, <0.665050, -1.269314, -21.545462>, <0.824541, -1.153437, -21.545462>, 
      <0.259790, -1.825743, -21.254670>, <0.441493, -1.693728, -21.161640>, <0.752451, -1.467804, -21.085184>, <0.949125, -1.324912, -21.085184>, 
      <0.377000, -1.889596, -21.392990>, <0.558703, -1.757581, -21.299958>, <0.823309, -1.565333, -21.234899>, <1.019983, -1.422441, -21.234899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.002663, -1.113701, -21.762882>, <0.149338, -1.007135, -21.687786>, <0.362934, -0.851949, -21.635267>, <0.521693, -0.736603, -21.635267>, 
      <0.070693, -1.178124, -21.804336>, <0.217368, -1.071558, -21.729240>, <0.417072, -0.926464, -21.680138>, <0.575832, -0.811119, -21.680138>, 
      <0.160050, -1.306867, -21.796171>, <0.307400, -1.199810, -21.720728>, <0.508434, -1.053751, -21.671301>, <0.667925, -0.937874, -21.671301>, 
      <0.200958, -1.391657, -21.755749>, <0.348308, -1.284601, -21.680306>, <0.562888, -1.128700, -21.627549>, <0.722379, -1.012823, -21.627549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389345, -0.832657, -21.396048>, <-0.207932, -0.700852, -21.303163>, <0.056252, -0.508911, -21.238208>, <0.252613, -0.366246, -21.238208>, 
      <-0.364729, -0.957820, -21.266515>, <-0.183315, -0.826015, -21.173632>, <0.124276, -0.602537, -21.098005>, <0.320636, -0.459872, -21.098005>, 
      <-0.118052, -0.999388, -21.689325>, <0.028623, -0.892822, -21.614229>, <0.266869, -0.719727, -21.555650>, <0.425629, -0.604381, -21.555650>, 
      <0.002663, -1.113701, -21.762882>, <0.149338, -1.007135, -21.687786>, <0.362934, -0.851949, -21.635267>, <0.521693, -0.736603, -21.635267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.051560, -0.838008, -22.048197>, <0.068096, -0.751073, -21.986933>, <0.242346, -0.624473, -21.944091>, <0.371860, -0.530376, -21.944091>, 
      <-0.132062, -0.869976, -21.845600>, <-0.012407, -0.783041, -21.784336>, <0.229735, -0.607115, -21.724802>, <0.359249, -0.513018, -21.724802>, 
      <-0.419181, -0.680960, -21.553040>, <-0.237767, -0.549155, -21.460155>, <-0.026191, -0.395436, -21.408136>, <0.170169, -0.252772, -21.408136>, 
      <-0.389345, -0.832657, -21.396048>, <-0.207932, -0.700852, -21.303163>, <0.056252, -0.508911, -21.238208>, <0.252613, -0.366246, -21.238208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.244834, -0.622665, -22.932675>, <0.244834, -0.622665, -22.932675>, <0.371860, -0.530376, -22.901443>, <0.371860, -0.530376, -22.901443>, 
      <0.098346, -0.778479, -22.425458>, <0.218002, -0.691544, -22.364194>, <0.265829, -0.656795, -22.352437>, <0.395344, -0.562698, -22.352437>, 
      <-0.051560, -0.838008, -22.048197>, <0.068096, -0.751073, -21.986933>, <0.242346, -0.624473, -21.944091>, <0.371860, -0.530376, -21.944091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.874805, -1.222620, -21.949606>, <1.003797, -1.128902, -21.949606>, <1.177344, -1.002812, -21.992275>, <1.296517, -0.916228, -22.053291>, 
      <0.846604, -1.183804, -22.348754>, <0.975596, -1.090086, -22.348754>, <1.025567, -1.053779, -22.361040>, <1.144740, -0.967195, -22.422056>, 
      <0.874805, -1.222620, -22.887656>, <0.876894, -1.221102, -22.887656>, <1.004169, -1.128631, -22.918949>, <1.006099, -1.127229, -22.919938>, 
      <0.874805, -1.222620, -23.289677>, <0.876894, -1.221102, -23.289677>, <0.879705, -1.219060, -23.290370>, <0.881635, -1.217658, -23.291357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.019983, -1.422441, -21.234899>, <1.216657, -1.279549, -21.234899>, <1.481264, -1.087301, -21.299958>, <1.662967, -0.955286, -21.392990>, 
      <1.103611, -1.537544, -21.411592>, <1.300285, -1.394652, -21.411592>, <1.510187, -1.242149, -21.463203>, <1.691890, -1.110134, -21.556234>, 
      <0.890719, -1.244523, -21.724373>, <1.019711, -1.150805, -21.724373>, <1.262989, -0.974053, -21.784187>, <1.382162, -0.887468, -21.845203>, 
      <0.874805, -1.222620, -21.949606>, <1.003797, -1.128902, -21.949606>, <1.177344, -1.002812, -21.992275>, <1.296517, -0.916228, -22.053291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.722379, -1.012823, -21.627549>, <0.881869, -0.896946, -21.627549>, <1.096449, -0.741045, -21.680306>, <1.243799, -0.633988, -21.755749>, 
      <0.824541, -1.153437, -21.545462>, <0.984032, -1.037560, -21.545462>, <1.224024, -0.863195, -21.604467>, <1.371375, -0.756139, -21.679910>, 
      <0.949125, -1.324912, -21.085184>, <1.145799, -1.182020, -21.085184>, <1.456757, -0.956096, -21.161640>, <1.638460, -0.824081, -21.254670>, 
      <1.019983, -1.422441, -21.234899>, <1.216657, -1.279549, -21.234899>, <1.481264, -1.087301, -21.299958>, <1.662967, -0.955286, -21.392990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.521693, -0.736603, -21.635267>, <0.680453, -0.621258, -21.635267>, <0.894049, -0.466071, -21.687786>, <1.040724, -0.359506, -21.762882>, 
      <0.575832, -0.811119, -21.680138>, <0.734592, -0.695773, -21.680138>, <0.934296, -0.550679, -21.729240>, <1.080971, -0.444114, -21.804336>, 
      <0.667925, -0.937874, -21.671301>, <0.827416, -0.821997, -21.671301>, <1.028450, -0.675937, -21.720728>, <1.175800, -0.568881, -21.796171>, 
      <0.722379, -1.012823, -21.627549>, <0.881869, -0.896946, -21.627549>, <1.096449, -0.741045, -21.680306>, <1.243799, -0.633988, -21.755749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.252613, -0.366246, -21.238208>, <0.448974, -0.223582, -21.238208>, <0.713158, -0.031641, -21.303163>, <0.894572, 0.100164, -21.396046>, 
      <0.320636, -0.459872, -21.098005>, <0.516997, -0.317208, -21.098005>, <0.824589, -0.093730, -21.173632>, <1.006002, 0.038074, -21.266514>, 
      <0.425629, -0.604381, -21.555650>, <0.584388, -0.489036, -21.555650>, <0.822634, -0.315940, -21.614229>, <0.969308, -0.209374, -21.689325>, 
      <0.521693, -0.736603, -21.635267>, <0.680453, -0.621258, -21.635267>, <0.894049, -0.466071, -21.687786>, <1.040724, -0.359506, -21.762882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -21.944091>, <0.501375, -0.436278, -21.944091>, <0.675624, -0.309678, -21.986933>, <0.795280, -0.222743, -22.048197>, 
      <0.359249, -0.513018, -21.724802>, <0.488763, -0.418920, -21.724802>, <0.730904, -0.242994, -21.784334>, <0.850560, -0.156059, -21.845598>, 
      <0.170169, -0.252772, -21.408136>, <0.366530, -0.110108, -21.408136>, <0.578105, 0.043611, -21.460155>, <0.759519, 0.175416, -21.553038>, 
      <0.252613, -0.366246, -21.238208>, <0.448974, -0.223582, -21.238208>, <0.713158, -0.031641, -21.303163>, <0.894572, 0.100164, -21.396046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.371860, -0.530376, -22.901443>, <0.371860, -0.530376, -22.901443>, <0.498886, -0.438086, -22.932675>, <0.498886, -0.438086, -22.932675>, 
      <0.395344, -0.562698, -22.352437>, <0.524858, -0.468600, -22.352437>, <0.572685, -0.433851, -22.364194>, <0.692341, -0.346917, -22.425458>, 
      <0.371860, -0.530376, -21.944091>, <0.501375, -0.436278, -21.944091>, <0.675624, -0.309678, -21.986933>, <0.795280, -0.222743, -22.048197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.296517, -0.916228, -22.053291>, <1.415691, -0.829643, -22.114307>, <1.562817, -0.722750, -22.235821>, <1.654028, -0.656481, -22.348565>, 
      <1.144740, -0.967195, -22.422056>, <1.263914, -0.880610, -22.483072>, <1.306278, -0.849831, -22.518061>, <1.397489, -0.783562, -22.630805>, 
      <1.006099, -1.127229, -22.919938>, <1.008029, -1.125827, -22.920925>, <1.115928, -1.047434, -23.010040>, <1.117405, -1.046361, -23.011866>, 
      <0.881635, -1.217658, -23.291357>, <0.883564, -1.216256, -23.292346>, <0.885947, -1.214525, -23.294314>, <0.887424, -1.213451, -23.296139>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.662967, -0.955286, -21.392990>, <1.844670, -0.823271, -21.486021>, <2.068992, -0.660292, -21.671291>, <2.208061, -0.559252, -21.843190>, 
      <1.691890, -1.110134, -21.556234>, <1.873593, -0.978119, -21.649266>, <2.051539, -0.848833, -21.796232>, <2.190609, -0.747793, -21.968133>, 
      <1.382162, -0.887468, -21.845203>, <1.501336, -0.800884, -21.906219>, <1.707577, -0.651041, -22.076557>, <1.798788, -0.584772, -22.189301>, 
      <1.296517, -0.916228, -22.053291>, <1.415691, -0.829643, -22.114307>, <1.562817, -0.722750, -22.235821>, <1.654028, -0.656481, -22.348565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.243799, -0.633988, -21.755749>, <1.391150, -0.526932, -21.831192>, <1.573062, -0.394766, -21.981434>, <1.685839, -0.312828, -22.120834>, 
      <1.371375, -0.756139, -21.679910>, <1.518725, -0.649082, -21.755354>, <1.722182, -0.501263, -21.923392>, <1.834959, -0.419325, -22.062792>, 
      <1.638460, -0.824081, -21.254670>, <1.820163, -0.692066, -21.347702>, <2.083780, -0.500537, -21.565426>, <2.222849, -0.399498, -21.737326>, 
      <1.662967, -0.955286, -21.392990>, <1.844670, -0.823271, -21.486021>, <2.068992, -0.660292, -21.671291>, <2.208061, -0.559252, -21.843190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.040724, -0.359506, -21.762882>, <1.187399, -0.252940, -21.837978>, <1.368477, -0.121379, -21.987531>, <1.480737, -0.039818, -22.126293>, 
      <1.080971, -0.444114, -21.804336>, <1.227646, -0.337548, -21.879432>, <1.396947, -0.214544, -22.019259>, <1.509207, -0.132982, -22.158021>, 
      <1.175800, -0.568881, -21.796171>, <1.323150, -0.461825, -21.871614>, <1.493579, -0.338001, -22.012371>, <1.606356, -0.256064, -22.151771>, 
      <1.243799, -0.633988, -21.755749>, <1.391150, -0.526932, -21.831192>, <1.573062, -0.394766, -21.981434>, <1.685839, -0.312828, -22.120834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.894572, 0.100164, -21.396046>, <1.075986, 0.231969, -21.488930>, <1.299950, 0.394689, -21.673906>, <1.438798, 0.495567, -21.845531>, 
      <1.006002, 0.038074, -21.266514>, <1.187416, 0.169879, -21.359398>, <1.448179, 0.359335, -21.574766>, <1.587026, 0.460214, -21.746392>, 
      <0.969308, -0.209374, -21.689325>, <1.115983, -0.102809, -21.764421>, <1.317958, 0.043934, -21.931234>, <1.430218, 0.125496, -22.069995>, 
      <1.040724, -0.359506, -21.762882>, <1.187399, -0.252940, -21.837978>, <1.368477, -0.121379, -21.987531>, <1.480737, -0.039818, -22.126293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.795280, -0.222743, -22.048197>, <0.914936, -0.135808, -22.109461>, <1.062657, -0.028482, -22.231466>, <1.154238, 0.038055, -22.344666>, 
      <0.850560, -0.156059, -21.845598>, <0.970216, -0.069124, -21.906862>, <1.175493, 0.080018, -22.076405>, <1.267074, 0.146556, -22.189603>, 
      <0.759519, 0.175416, -21.553038>, <0.940932, 0.307221, -21.645922>, <1.120298, 0.437537, -21.794064>, <1.259146, 0.538416, -21.965688>, 
      <0.894572, 0.100164, -21.396046>, <1.075986, 0.231969, -21.488930>, <1.299950, 0.394689, -21.673906>, <1.438798, 0.495567, -21.845531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.498886, -0.438086, -22.932675>, <0.498886, -0.438086, -22.932675>, <0.606573, -0.359846, -23.021616>, <0.606573, -0.359846, -23.021616>, 
      <0.692341, -0.346917, -22.425458>, <0.811997, -0.259981, -22.486722>, <0.852543, -0.230523, -22.520208>, <0.944123, -0.163986, -22.633408>, 
      <0.795280, -0.222743, -22.048197>, <0.914936, -0.135808, -22.109461>, <1.062657, -0.028482, -22.231466>, <1.154238, 0.038055, -22.344666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.654028, -0.656481, -22.348565>, <1.745239, -0.590212, -22.461307>, <1.843545, -0.518789, -22.643165>, <1.892909, -0.482924, -22.790472>, 
      <1.397489, -0.783562, -22.630805>, <1.488700, -0.717293, -22.743547>, <1.517007, -0.696727, -22.795914>, <1.566370, -0.660863, -22.943221>, 
      <1.117405, -1.046361, -23.011866>, <1.118882, -1.045287, -23.013691>, <1.190978, -0.992907, -23.147062>, <1.191777, -0.992326, -23.149448>, 
      <0.887424, -1.213451, -23.296139>, <0.888901, -1.212378, -23.297965>, <0.890493, -1.211222, -23.300909>, <0.891293, -1.210641, -23.303294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.208061, -0.559252, -21.843190>, <2.347131, -0.458212, -22.015091>, <2.497018, -0.349312, -22.292368>, <2.572282, -0.294630, -22.516966>, 
      <2.190609, -0.747793, -21.968133>, <2.329678, -0.646753, -22.140032>, <2.448578, -0.560367, -22.359986>, <2.523842, -0.505685, -22.584584>, 
      <1.798788, -0.584772, -22.189301>, <1.890000, -0.518503, -22.302043>, <2.027806, -0.418381, -22.556973>, <2.077169, -0.382516, -22.704278>, 
      <1.654028, -0.656481, -22.348565>, <1.745239, -0.590212, -22.461307>, <1.843545, -0.518789, -22.643165>, <1.892909, -0.482924, -22.790472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.685839, -0.312828, -22.120834>, <1.798616, -0.230891, -22.260235>, <1.920165, -0.142580, -22.485090>, <1.981200, -0.098236, -22.667226>, 
      <1.834959, -0.419325, -22.062792>, <1.947736, -0.337388, -22.202192>, <2.083681, -0.238618, -22.453678>, <2.144715, -0.194274, -22.635813>, 
      <2.222849, -0.399498, -21.737326>, <2.361919, -0.298457, -21.909226>, <2.538062, -0.170482, -22.235074>, <2.613326, -0.115800, -22.459670>, 
      <2.208061, -0.559252, -21.843190>, <2.347131, -0.458212, -22.015091>, <2.497018, -0.349312, -22.292368>, <2.572282, -0.294630, -22.516966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.480737, -0.039818, -22.126293>, <1.592997, 0.041744, -22.265054>, <1.713989, 0.129650, -22.488878>, <1.774744, 0.173791, -22.670179>, 
      <1.509207, -0.132982, -22.158021>, <1.621467, -0.051420, -22.296781>, <1.734591, 0.030769, -22.506048>, <1.795345, 0.074910, -22.687349>, 
      <1.606356, -0.256064, -22.151771>, <1.719133, -0.174127, -22.291173>, <1.833009, -0.091391, -22.501834>, <1.894044, -0.047046, -22.683968>, 
      <1.685839, -0.312828, -22.120834>, <1.798616, -0.230891, -22.260235>, <1.920165, -0.142580, -22.485090>, <1.981200, -0.098236, -22.667226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.438798, 0.495567, -21.845531>, <1.577646, 0.596446, -22.017157>, <1.727295, 0.705172, -22.293994>, <1.802439, 0.759768, -22.518232>, 
      <1.587026, 0.460214, -21.746392>, <1.725874, 0.561093, -21.918016>, <1.900111, 0.687683, -22.240339>, <1.975255, 0.742278, -22.464579>, 
      <1.430218, 0.125496, -22.069995>, <1.542478, 0.207058, -22.208757>, <1.677434, 0.305108, -22.458410>, <1.738188, 0.349249, -22.639712>, 
      <1.480737, -0.039818, -22.126293>, <1.592997, 0.041744, -22.265054>, <1.713989, 0.129650, -22.488878>, <1.774744, 0.173791, -22.670179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.154238, 0.038055, -22.344666>, <1.245818, 0.104592, -22.457864>, <1.344523, 0.176305, -22.640459>, <1.394086, 0.212315, -22.788360>, 
      <1.267074, 0.146556, -22.189603>, <1.358654, 0.213093, -22.302803>, <1.495816, 0.312747, -22.556539>, <1.545379, 0.348756, -22.704442>, 
      <1.259146, 0.538416, -21.965688>, <1.397994, 0.639295, -22.137314>, <1.517842, 0.726370, -22.359021>, <1.592986, 0.780965, -22.583259>, 
      <1.438798, 0.495567, -21.845531>, <1.577646, 0.596446, -22.017157>, <1.727295, 0.705172, -22.293994>, <1.802439, 0.759768, -22.518232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.606573, -0.359846, -23.021616>, <0.606573, -0.359846, -23.021616>, <0.678528, -0.307568, -23.154725>, <0.678528, -0.307568, -23.154725>, 
      <0.944123, -0.163986, -22.633408>, <1.035704, -0.097449, -22.746606>, <1.062796, -0.077765, -22.796726>, <1.112359, -0.041756, -22.944627>, 
      <1.154238, 0.038055, -22.344666>, <1.245818, 0.104592, -22.457864>, <1.344523, 0.176305, -22.640459>, <1.394086, 0.212315, -22.788360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.892909, -0.482924, -22.790472>, <1.942272, -0.447060, -22.937779>, <1.976792, -0.421979, -23.152294>, <1.976792, -0.421979, -23.311738>, 
      <1.566370, -0.660863, -22.943221>, <1.615733, -0.624999, -23.090526>, <1.625673, -0.617777, -23.152294>, <1.625673, -0.617777, -23.311738>, 
      <1.191777, -0.992326, -23.149448>, <1.192577, -0.991745, -23.151835>, <1.217894, -0.973352, -23.309155>, <1.217894, -0.973352, -23.311738>, 
      <0.891293, -1.210641, -23.303294>, <0.892092, -1.210060, -23.305682>, <0.892651, -1.209654, -23.309155>, <0.892651, -1.209654, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.572282, -0.294630, -22.516966>, <2.647546, -0.239947, -22.741563>, <2.700180, -0.201707, -23.068634>, <2.700180, -0.201707, -23.311738>, 
      <2.523842, -0.505685, -22.584584>, <2.599106, -0.451002, -22.809181>, <2.640859, -0.420668, -23.068634>, <2.640859, -0.420668, -23.311738>, 
      <2.077169, -0.382516, -22.704278>, <2.126532, -0.346652, -22.851586>, <2.174923, -0.311494, -23.152294>, <2.174923, -0.311494, -23.311738>, 
      <1.892909, -0.482924, -22.790472>, <1.942272, -0.447060, -22.937779>, <1.976792, -0.421979, -23.152294>, <1.976792, -0.421979, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.981200, -0.098236, -22.667226>, <2.042234, -0.053892, -22.849360>, <2.084917, -0.022881, -23.114595>, <2.084917, -0.022881, -23.311738>, 
      <2.144715, -0.194274, -22.635813>, <2.205750, -0.149930, -22.817947>, <2.253488, -0.115247, -23.114595>, <2.253488, -0.115247, -23.311738>, 
      <2.613326, -0.115800, -22.459670>, <2.688590, -0.061117, -22.684269>, <2.750444, -0.016178, -23.068634>, <2.750444, -0.016178, -23.311738>, 
      <2.572282, -0.294630, -22.516966>, <2.647546, -0.239947, -22.741563>, <2.700180, -0.201707, -23.068634>, <2.700180, -0.201707, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.774744, 0.173791, -22.670179>, <1.835499, 0.217932, -22.851480>, <1.877986, 0.248801, -23.115499>, <1.877986, 0.248801, -23.311738>, 
      <1.795345, 0.074910, -22.687349>, <1.856100, 0.119050, -22.868651>, <1.895824, 0.147911, -23.115499>, <1.895824, 0.147911, -23.311738>, 
      <1.894044, -0.047046, -22.683968>, <1.955078, -0.002702, -22.866102>, <1.995067, 0.026351, -23.114595>, <1.995067, 0.026351, -23.311738>, 
      <1.981200, -0.098236, -22.667226>, <2.042234, -0.053892, -22.849360>, <2.084917, -0.022881, -23.114595>, <2.084917, -0.022881, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.802439, 0.759768, -22.518232>, <1.877583, 0.814363, -22.742472>, <1.930132, 0.852542, -23.069021>, <1.930132, 0.852542, -23.311738>, 
      <1.975255, 0.742278, -22.464579>, <2.050399, 0.796874, -22.688818>, <2.111583, 0.841326, -23.069021>, <2.111583, 0.841326, -23.311738>, 
      <1.738188, 0.349249, -22.639712>, <1.798943, 0.393390, -22.821013>, <1.846333, 0.427821, -23.115499>, <1.846333, 0.427821, -23.311738>, 
      <1.774744, 0.173791, -22.670179>, <1.835499, 0.217932, -22.851480>, <1.877986, 0.248801, -23.115499>, <1.877986, 0.248801, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.394086, 0.212315, -22.788360>, <1.443649, 0.248325, -22.936264>, <1.478309, 0.273507, -23.151648>, <1.478309, 0.273507, -23.311738>, 
      <1.545379, 0.348756, -22.704442>, <1.594942, 0.384766, -22.852344>, <1.643107, 0.419760, -23.151648>, <1.643107, 0.419760, -23.311738>, 
      <1.592986, 0.780965, -22.583259>, <1.668130, 0.835560, -22.807499>, <1.710215, 0.866137, -23.069021>, <1.710215, 0.866137, -23.311738>, 
      <1.802439, 0.759768, -22.518232>, <1.877583, 0.814363, -22.742472>, <1.930132, 0.852542, -23.069021>, <1.930132, 0.852542, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.678528, -0.307568, -23.154725>, <0.678528, -0.307568, -23.154725>, <0.703795, -0.289211, -23.311738>, <0.703795, -0.289211, -23.311738>, 
      <1.112359, -0.041756, -22.944627>, <1.161922, -0.005746, -23.092531>, <1.171436, 0.001166, -23.151648>, <1.171436, 0.001166, -23.311738>, 
      <1.394086, 0.212315, -22.788360>, <1.443649, 0.248325, -22.936264>, <1.478309, 0.273507, -23.151648>, <1.478309, 0.273507, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.976792, -0.421979, -23.311738>, <1.976792, -0.421979, -23.471179>, <1.942272, -0.447060, -23.685694>, <1.892909, -0.482924, -23.833000>, 
      <1.625673, -0.617777, -23.311738>, <1.625673, -0.617777, -23.471179>, <1.615733, -0.624999, -23.532947>, <1.566370, -0.660863, -23.680254>, 
      <1.217894, -0.973352, -23.311738>, <1.217894, -0.973352, -23.314320>, <1.192577, -0.991745, -23.471640>, <1.191778, -0.992326, -23.474026>, 
      <0.892651, -1.209654, -23.311738>, <0.892651, -1.209654, -23.314320>, <0.892092, -1.210060, -23.317794>, <0.891293, -1.210641, -23.320179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.700180, -0.201707, -23.311738>, <2.700180, -0.201707, -23.554838>, <2.647546, -0.239948, -23.881910>, <2.572283, -0.294630, -24.106506>, 
      <2.640859, -0.420668, -23.311738>, <2.640859, -0.420668, -23.554838>, <2.599107, -0.451002, -23.814291>, <2.523843, -0.505684, -24.038886>, 
      <2.174923, -0.311494, -23.311738>, <2.174923, -0.311494, -23.471179>, <2.126532, -0.346652, -23.771886>, <2.077169, -0.382516, -23.919194>, 
      <1.976792, -0.421979, -23.311738>, <1.976792, -0.421979, -23.471179>, <1.942272, -0.447060, -23.685694>, <1.892909, -0.482924, -23.833000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.084917, -0.022881, -23.311738>, <2.084917, -0.022881, -23.508878>, <2.042234, -0.053892, -23.774115>, <1.981200, -0.098236, -23.956250>, 
      <2.253488, -0.115247, -23.311738>, <2.253488, -0.115246, -23.508878>, <2.205750, -0.149930, -23.805526>, <2.144715, -0.194274, -23.987661>, 
      <2.750444, -0.016178, -23.311738>, <2.750444, -0.016178, -23.554838>, <2.688590, -0.061118, -23.939205>, <2.613326, -0.115800, -24.163802>, 
      <2.700180, -0.201707, -23.311738>, <2.700180, -0.201707, -23.554838>, <2.647546, -0.239948, -23.881910>, <2.572283, -0.294630, -24.106506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.877986, 0.248801, -23.311738>, <1.877986, 0.248801, -23.507974>, <1.835499, 0.217932, -23.771994>, <1.774744, 0.173791, -23.953293>, 
      <1.895824, 0.147911, -23.311738>, <1.895824, 0.147911, -23.507974>, <1.856100, 0.119050, -23.754824>, <1.795346, 0.074910, -23.936123>, 
      <1.995067, 0.026351, -23.311738>, <1.995067, 0.026351, -23.508878>, <1.955079, -0.002702, -23.757371>, <1.894044, -0.047046, -23.939507>, 
      <2.084917, -0.022881, -23.311738>, <2.084917, -0.022881, -23.508878>, <2.042234, -0.053892, -23.774115>, <1.981200, -0.098236, -23.956250>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.930132, 0.852542, -23.311738>, <1.930132, 0.852542, -23.554451>, <1.877583, 0.814363, -23.881000>, <1.802439, 0.759768, -24.105240>, 
      <2.111583, 0.841326, -23.311738>, <2.111583, 0.841326, -23.554451>, <2.050399, 0.796874, -23.934654>, <1.975255, 0.742278, -24.158893>, 
      <1.846333, 0.427821, -23.311738>, <1.846333, 0.427821, -23.507974>, <1.798943, 0.393390, -23.802462>, <1.738188, 0.349249, -23.983762>, 
      <1.877986, 0.248801, -23.311738>, <1.877986, 0.248801, -23.507974>, <1.835499, 0.217932, -23.771994>, <1.774744, 0.173791, -23.953293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.478309, 0.273507, -23.311738>, <1.478309, 0.273507, -23.471824>, <1.443649, 0.248324, -23.687210>, <1.394086, 0.212315, -23.835112>, 
      <1.643107, 0.419760, -23.311738>, <1.643107, 0.419760, -23.471824>, <1.594942, 0.384766, -23.771128>, <1.545379, 0.348756, -23.919029>, 
      <1.710215, 0.866137, -23.311738>, <1.710215, 0.866137, -23.554451>, <1.668130, 0.835560, -23.815973>, <1.592986, 0.780965, -24.040213>, 
      <1.930132, 0.852542, -23.311738>, <1.930132, 0.852542, -23.554451>, <1.877583, 0.814363, -23.881000>, <1.802439, 0.759768, -24.105240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.703795, -0.289211, -23.311738>, <0.703795, -0.289211, -23.311738>, <0.678528, -0.307568, -23.468750>, <0.678528, -0.307568, -23.468750>, 
      <1.171436, 0.001166, -23.311738>, <1.171436, 0.001166, -23.471824>, <1.161922, -0.005746, -23.530946>, <1.112359, -0.041756, -23.678846>, 
      <1.478309, 0.273507, -23.311738>, <1.478309, 0.273507, -23.471824>, <1.443649, 0.248324, -23.687210>, <1.394086, 0.212315, -23.835112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.892909, -0.482924, -23.833000>, <1.843546, -0.518789, -23.980307>, <1.745239, -0.590213, -24.162165>, <1.654028, -0.656481, -24.274909>, 
      <1.566370, -0.660863, -23.680254>, <1.517007, -0.696728, -23.827560>, <1.488700, -0.717293, -23.879925>, <1.397489, -0.783562, -23.992669>, 
      <1.191778, -0.992326, -23.474026>, <1.190978, -0.992907, -23.476411>, <1.118883, -1.045287, -23.609781>, <1.117405, -1.046361, -23.611606>, 
      <0.891293, -1.210641, -23.320179>, <0.890493, -1.211222, -23.322565>, <0.888902, -1.212378, -23.325510>, <0.887424, -1.213451, -23.327336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.572283, -0.294630, -24.106506>, <2.497019, -0.349312, -24.331104>, <2.347131, -0.458212, -24.608381>, <2.208062, -0.559252, -24.780282>, 
      <2.523843, -0.505684, -24.038886>, <2.448579, -0.560367, -24.263485>, <2.329679, -0.646753, -24.483440>, <2.190609, -0.747793, -24.655341>, 
      <2.077169, -0.382516, -23.919194>, <2.027806, -0.418381, -24.066499>, <1.890000, -0.518503, -24.321429>, <1.798789, -0.584772, -24.434171>, 
      <1.892909, -0.482924, -23.833000>, <1.843546, -0.518789, -23.980307>, <1.745239, -0.590213, -24.162165>, <1.654028, -0.656481, -24.274909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.981200, -0.098236, -23.956250>, <1.920165, -0.142580, -24.138384>, <1.798616, -0.230891, -24.363237>, <1.685839, -0.312828, -24.502638>, 
      <2.144715, -0.194274, -23.987661>, <2.083681, -0.238618, -24.169795>, <1.947736, -0.337388, -24.421280>, <1.834959, -0.419325, -24.560680>, 
      <2.613326, -0.115800, -24.163802>, <2.538062, -0.170482, -24.388398>, <2.361919, -0.298457, -24.714246>, <2.222850, -0.399497, -24.886147>, 
      <2.572283, -0.294630, -24.106506>, <2.497019, -0.349312, -24.331104>, <2.347131, -0.458212, -24.608381>, <2.208062, -0.559252, -24.780282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.774744, 0.173791, -23.953293>, <1.713989, 0.129650, -24.134592>, <1.592997, 0.041744, -24.358418>, <1.480737, -0.039818, -24.497179>, 
      <1.795346, 0.074910, -23.936123>, <1.734591, 0.030769, -24.117422>, <1.621468, -0.051420, -24.326691>, <1.509207, -0.132982, -24.465453>, 
      <1.894044, -0.047046, -23.939507>, <1.833010, -0.091390, -24.121642>, <1.719133, -0.174127, -24.332301>, <1.606356, -0.256064, -24.471701>, 
      <1.981200, -0.098236, -23.956250>, <1.920165, -0.142580, -24.138384>, <1.798616, -0.230891, -24.363237>, <1.685839, -0.312828, -24.502638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.802439, 0.759768, -24.105240>, <1.727295, 0.705172, -24.329480>, <1.577647, 0.596447, -24.606317>, <1.438799, 0.495568, -24.777942>, 
      <1.975255, 0.742278, -24.158893>, <1.900111, 0.687683, -24.383133>, <1.725875, 0.561093, -24.705456>, <1.587027, 0.460214, -24.877082>, 
      <1.738188, 0.349249, -23.983762>, <1.677434, 0.305108, -24.165061>, <1.542478, 0.207058, -24.414717>, <1.430218, 0.125496, -24.553478>, 
      <1.774744, 0.173791, -23.953293>, <1.713989, 0.129650, -24.134592>, <1.592997, 0.041744, -24.358418>, <1.480737, -0.039818, -24.497179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.394086, 0.212315, -23.835112>, <1.344523, 0.176305, -23.983014>, <1.245818, 0.104592, -24.165610>, <1.154238, 0.038055, -24.278808>, 
      <1.545379, 0.348756, -23.919029>, <1.495816, 0.312747, -24.066933>, <1.358655, 0.213093, -24.320670>, <1.267074, 0.146556, -24.433870>, 
      <1.592986, 0.780965, -24.040213>, <1.517842, 0.726370, -24.264451>, <1.397994, 0.639295, -24.486162>, <1.259146, 0.538416, -24.657787>, 
      <1.802439, 0.759768, -24.105240>, <1.727295, 0.705172, -24.329480>, <1.577647, 0.596447, -24.606317>, <1.438799, 0.495568, -24.777942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.678528, -0.307568, -23.468750>, <0.678528, -0.307568, -23.468750>, <0.606574, -0.359846, -23.601858>, <0.606574, -0.359846, -23.601858>, 
      <1.112359, -0.041756, -23.678846>, <1.062796, -0.077766, -23.826750>, <1.035704, -0.097449, -23.876867>, <0.944124, -0.163986, -23.990067>, 
      <1.394086, 0.212315, -23.835112>, <1.344523, 0.176305, -23.983014>, <1.245818, 0.104592, -24.165610>, <1.154238, 0.038055, -24.278808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.654028, -0.656481, -24.274909>, <1.562817, -0.722750, -24.387651>, <1.415691, -0.829643, -24.509165>, <1.296518, -0.916228, -24.570181>, 
      <1.397489, -0.783562, -23.992669>, <1.306278, -0.849831, -24.105411>, <1.263914, -0.880610, -24.140400>, <1.144741, -0.967194, -24.201416>, 
      <1.117405, -1.046361, -23.611606>, <1.115928, -1.047434, -23.613432>, <1.008029, -1.125827, -23.702547>, <1.006099, -1.127229, -23.703534>, 
      <0.887424, -1.213451, -23.327336>, <0.885947, -1.214525, -23.329160>, <0.883564, -1.216256, -23.331126>, <0.881635, -1.217658, -23.332115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.208062, -0.559252, -24.780282>, <2.068992, -0.660292, -24.952181>, <1.844670, -0.823271, -25.137453>, <1.662967, -0.955286, -25.230485>, 
      <2.190609, -0.747793, -24.655341>, <2.051540, -0.848833, -24.827240>, <1.873593, -0.978118, -24.974210>, <1.691890, -1.110134, -25.067240>, 
      <1.798789, -0.584772, -24.434171>, <1.707577, -0.651041, -24.546915>, <1.501336, -0.800884, -24.717253>, <1.382163, -0.887468, -24.778269>, 
      <1.654028, -0.656481, -24.274909>, <1.562817, -0.722750, -24.387651>, <1.415691, -0.829643, -24.509165>, <1.296518, -0.916228, -24.570181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.685839, -0.312828, -24.502638>, <1.573062, -0.394766, -24.642038>, <1.391150, -0.526932, -24.792282>, <1.243800, -0.633988, -24.867725>, 
      <1.834959, -0.419325, -24.560680>, <1.722182, -0.501263, -24.700082>, <1.518726, -0.649082, -24.868120>, <1.371375, -0.756139, -24.943563>, 
      <2.222850, -0.399497, -24.886147>, <2.083780, -0.500537, -25.058046>, <1.820163, -0.692067, -25.275773>, <1.638460, -0.824082, -25.368803>, 
      <2.208062, -0.559252, -24.780282>, <2.068992, -0.660292, -24.952181>, <1.844670, -0.823271, -25.137453>, <1.662967, -0.955286, -25.230485>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.480737, -0.039818, -24.497179>, <1.368477, -0.121379, -24.635941>, <1.187399, -0.252940, -24.785496>, <1.040724, -0.359506, -24.860592>, 
      <1.509207, -0.132982, -24.465453>, <1.396947, -0.214544, -24.604214>, <1.227646, -0.337548, -24.744042>, <1.080971, -0.444114, -24.819138>, 
      <1.606356, -0.256064, -24.471701>, <1.493579, -0.338001, -24.611101>, <1.323151, -0.461825, -24.751859>, <1.175800, -0.568881, -24.827302>, 
      <1.685839, -0.312828, -24.502638>, <1.573062, -0.394766, -24.642038>, <1.391150, -0.526932, -24.792282>, <1.243800, -0.633988, -24.867725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.438799, 0.495568, -24.777942>, <1.299951, 0.394689, -24.949568>, <1.075986, 0.231969, -25.134544>, <0.894572, 0.100164, -25.227427>, 
      <1.587027, 0.460214, -24.877082>, <1.448180, 0.359335, -25.048706>, <1.187416, 0.169879, -25.264077>, <1.006002, 0.038075, -25.356958>, 
      <1.430218, 0.125496, -24.553478>, <1.317958, 0.043934, -24.692240>, <1.115984, -0.102809, -24.859053>, <0.969309, -0.209375, -24.934149>, 
      <1.480737, -0.039818, -24.497179>, <1.368477, -0.121379, -24.635941>, <1.187399, -0.252940, -24.785496>, <1.040724, -0.359506, -24.860592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.154238, 0.038055, -24.278808>, <1.062657, -0.028482, -24.392008>, <0.914936, -0.135808, -24.514013>, <0.795280, -0.222743, -24.575277>, 
      <1.267074, 0.146556, -24.433870>, <1.175494, 0.080019, -24.547069>, <0.970216, -0.069124, -24.716610>, <0.850560, -0.156059, -24.777874>, 
      <1.259146, 0.538416, -24.657787>, <1.120298, 0.437537, -24.829413>, <0.940933, 0.307221, -24.977552>, <0.759519, 0.175416, -25.070435>, 
      <1.438799, 0.495568, -24.777942>, <1.299951, 0.394689, -24.949568>, <1.075986, 0.231969, -25.134544>, <0.894572, 0.100164, -25.227427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.606574, -0.359846, -23.601858>, <0.606574, -0.359846, -23.601858>, <0.498886, -0.438086, -23.690800>, <0.498886, -0.438086, -23.690800>, 
      <0.944124, -0.163986, -23.990067>, <0.852543, -0.230523, -24.103266>, <0.811997, -0.259981, -24.136754>, <0.692341, -0.346917, -24.198018>, 
      <1.154238, 0.038055, -24.278808>, <1.062657, -0.028482, -24.392008>, <0.914936, -0.135808, -24.514013>, <0.795280, -0.222743, -24.575277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.296518, -0.916228, -24.570181>, <1.177344, -1.002812, -24.631197>, <1.003797, -1.128901, -24.673869>, <0.874805, -1.222620, -24.673869>, 
      <1.144741, -0.967194, -24.201416>, <1.025568, -1.053779, -24.262432>, <0.975596, -1.090085, -24.274720>, <0.846604, -1.183804, -24.274720>, 
      <1.006099, -1.127229, -23.703534>, <1.004169, -1.128631, -23.704523>, <0.876894, -1.221102, -23.735818>, <0.874805, -1.222620, -23.735818>, 
      <0.881635, -1.217658, -23.332115>, <0.879705, -1.219060, -23.333102>, <0.876894, -1.221102, -23.333795>, <0.874805, -1.222620, -23.333795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.662967, -0.955286, -25.230485>, <1.481264, -1.087301, -25.323515>, <1.216658, -1.279549, -25.388573>, <1.019984, -1.422441, -25.388573>, 
      <1.691890, -1.110134, -25.067240>, <1.510187, -1.242149, -25.160270>, <1.300285, -1.394651, -25.211880>, <1.103611, -1.537544, -25.211880>, 
      <1.382163, -0.887468, -24.778269>, <1.262990, -0.974052, -24.839285>, <1.019711, -1.150805, -24.899101>, <0.890719, -1.244523, -24.899101>, 
      <1.296518, -0.916228, -24.570181>, <1.177344, -1.002812, -24.631197>, <1.003797, -1.128901, -24.673869>, <0.874805, -1.222620, -24.673869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.243800, -0.633988, -24.867725>, <1.096450, -0.741045, -24.943168>, <0.881870, -0.896946, -24.995926>, <0.722379, -1.012823, -24.995926>, 
      <1.371375, -0.756139, -24.943563>, <1.224025, -0.863195, -25.019006>, <0.984032, -1.037560, -25.078011>, <0.824541, -1.153437, -25.078011>, 
      <1.638460, -0.824082, -25.368803>, <1.456757, -0.956097, -25.461834>, <1.145799, -1.182020, -25.538288>, <0.949125, -1.324912, -25.538288>, 
      <1.662967, -0.955286, -25.230485>, <1.481264, -1.087301, -25.323515>, <1.216658, -1.279549, -25.388573>, <1.019984, -1.422441, -25.388573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.040724, -0.359506, -24.860592>, <0.894049, -0.466071, -24.935688>, <0.680453, -0.621258, -24.988205>, <0.521694, -0.736603, -24.988205>, 
      <1.080971, -0.444114, -24.819138>, <0.934296, -0.550679, -24.894234>, <0.734592, -0.695773, -24.943334>, <0.575832, -0.811119, -24.943334>, 
      <1.175800, -0.568881, -24.827302>, <1.028450, -0.675937, -24.902746>, <0.827416, -0.821997, -24.952173>, <0.667925, -0.937874, -24.952173>, 
      <1.243800, -0.633988, -24.867725>, <1.096450, -0.741045, -24.943168>, <0.881870, -0.896946, -24.995926>, <0.722379, -1.012823, -24.995926>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.894572, 0.100164, -25.227427>, <0.713159, -0.031641, -25.320309>, <0.448974, -0.223582, -25.385264>, <0.252614, -0.366246, -25.385264>, 
      <1.006002, 0.038075, -25.356958>, <0.824589, -0.093730, -25.449840>, <0.516998, -0.317208, -25.525467>, <0.320637, -0.459873, -25.525467>, 
      <0.969309, -0.209375, -24.934149>, <0.822634, -0.315940, -25.009245>, <0.584388, -0.489036, -25.067824>, <0.425629, -0.604381, -25.067824>, 
      <1.040724, -0.359506, -24.860592>, <0.894049, -0.466071, -24.935688>, <0.680453, -0.621258, -24.988205>, <0.521694, -0.736603, -24.988205>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.795280, -0.222743, -24.575277>, <0.675624, -0.309678, -24.636541>, <0.501375, -0.436278, -24.679382>, <0.371860, -0.530376, -24.679382>, 
      <0.850560, -0.156059, -24.777874>, <0.730905, -0.242994, -24.839138>, <0.488764, -0.418920, -24.898672>, <0.359249, -0.513018, -24.898672>, 
      <0.759519, 0.175416, -25.070435>, <0.578106, 0.043611, -25.163317>, <0.366530, -0.110108, -25.215338>, <0.170170, -0.252772, -25.215338>, 
      <0.894572, 0.100164, -25.227427>, <0.713159, -0.031641, -25.320309>, <0.448974, -0.223582, -25.385264>, <0.252614, -0.366246, -25.385264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.498886, -0.438086, -23.690800>, <0.498886, -0.438086, -23.690800>, <0.371860, -0.530376, -23.722030>, <0.371860, -0.530376, -23.722030>, 
      <0.692341, -0.346917, -24.198018>, <0.572686, -0.433852, -24.259282>, <0.524858, -0.468600, -24.271038>, <0.395344, -0.562698, -24.271038>, 
      <0.795280, -0.222743, -24.575277>, <0.675624, -0.309678, -24.636541>, <0.501375, -0.436278, -24.679382>, <0.371860, -0.530376, -24.679382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.874805, -1.222620, -24.673869>, <0.745813, -1.316338, -24.673869>, <0.572266, -1.442427, -24.631197>, <0.453093, -1.529012, -24.570181>, 
      <0.846604, -1.183804, -24.274720>, <0.717611, -1.277522, -24.274720>, <0.667640, -1.313829, -24.262432>, <0.548467, -1.400413, -24.201416>, 
      <0.874805, -1.222620, -23.735818>, <0.872716, -1.224138, -23.735818>, <0.745441, -1.316608, -23.704523>, <0.743511, -1.318011, -23.703534>, 
      <0.874805, -1.222620, -23.333795>, <0.872716, -1.224138, -23.333795>, <0.869906, -1.226179, -23.333102>, <0.867976, -1.227582, -23.332115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.019984, -1.422441, -25.388573>, <0.823310, -1.565333, -25.388573>, <0.558704, -1.757581, -25.323515>, <0.377001, -1.889596, -25.230485>, 
      <1.103611, -1.537544, -25.211880>, <0.906937, -1.680436, -25.211880>, <0.697035, -1.832939, -25.160270>, <0.515332, -1.964954, -25.067240>, 
      <0.890719, -1.244523, -24.899101>, <0.761727, -1.338241, -24.899101>, <0.518448, -1.514993, -24.839285>, <0.399275, -1.601578, -24.778269>, 
      <0.874805, -1.222620, -24.673869>, <0.745813, -1.316338, -24.673869>, <0.572266, -1.442427, -24.631197>, <0.453093, -1.529012, -24.570181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.722379, -1.012823, -24.995926>, <0.562888, -1.128700, -24.995926>, <0.348309, -1.284601, -24.943168>, <0.200958, -1.391657, -24.867725>, 
      <0.824541, -1.153437, -25.078011>, <0.665050, -1.269314, -25.078011>, <0.425057, -1.443679, -25.019006>, <0.277707, -1.550735, -24.943563>, 
      <0.949125, -1.324912, -25.538288>, <0.752451, -1.467804, -25.538288>, <0.441494, -1.693729, -25.461834>, <0.259791, -1.825744, -25.368803>, 
      <1.019984, -1.422441, -25.388573>, <0.823310, -1.565333, -25.388573>, <0.558704, -1.757581, -25.323515>, <0.377001, -1.889596, -25.230485>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.521694, -0.736603, -24.988205>, <0.362934, -0.851949, -24.988205>, <0.149338, -1.007136, -24.935688>, <0.002663, -1.113701, -24.860592>, 
      <0.575832, -0.811119, -24.943334>, <0.417073, -0.926464, -24.943334>, <0.217368, -1.071558, -24.894234>, <0.070693, -1.178124, -24.819138>, 
      <0.667925, -0.937874, -24.952173>, <0.508435, -1.053751, -24.952173>, <0.307401, -1.199810, -24.902746>, <0.160050, -1.306867, -24.827302>, 
      <0.722379, -1.012823, -24.995926>, <0.562888, -1.128700, -24.995926>, <0.348309, -1.284601, -24.943168>, <0.200958, -1.391657, -24.867725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.252614, -0.366246, -25.385264>, <0.056253, -0.508911, -25.385264>, <-0.207931, -0.700852, -25.320309>, <-0.389345, -0.832657, -25.227427>, 
      <0.320637, -0.459873, -25.525467>, <0.124277, -0.602537, -25.525467>, <-0.183315, -0.826015, -25.449840>, <-0.364728, -0.957820, -25.356958>, 
      <0.425629, -0.604381, -25.067824>, <0.266869, -0.719727, -25.067824>, <0.028624, -0.892822, -25.009245>, <-0.118051, -0.999388, -24.934149>, 
      <0.521694, -0.736603, -24.988205>, <0.362934, -0.851949, -24.988205>, <0.149338, -1.007136, -24.935688>, <0.002663, -1.113701, -24.860592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -24.679382>, <0.242346, -0.624473, -24.679382>, <0.068097, -0.751073, -24.636541>, <-0.051559, -0.838008, -24.575277>, 
      <0.359249, -0.513018, -24.898672>, <0.229735, -0.607115, -24.898672>, <-0.012406, -0.783041, -24.839138>, <-0.132062, -0.869976, -24.777874>, 
      <0.170170, -0.252772, -25.215338>, <-0.026191, -0.395436, -25.215338>, <-0.237767, -0.549155, -25.163317>, <-0.419180, -0.680960, -25.070435>, 
      <0.252614, -0.366246, -25.385264>, <0.056253, -0.508911, -25.385264>, <-0.207931, -0.700852, -25.320309>, <-0.389345, -0.832657, -25.227427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.371860, -0.530376, -23.722030>, <0.371860, -0.530376, -23.722030>, <0.244835, -0.622665, -23.690800>, <0.244835, -0.622665, -23.690800>, 
      <0.395344, -0.562698, -24.271038>, <0.265830, -0.656795, -24.271038>, <0.218002, -0.691544, -24.259282>, <0.098347, -0.778479, -24.198018>, 
      <0.371860, -0.530376, -24.679382>, <0.242346, -0.624473, -24.679382>, <0.068097, -0.751073, -24.636541>, <-0.051559, -0.838008, -24.575277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.453093, -1.529012, -24.570181>, <0.333920, -1.615596, -24.509165>, <0.186794, -1.722489, -24.387651>, <0.095583, -1.788758, -24.274909>, 
      <0.548467, -1.400413, -24.201416>, <0.429294, -1.486997, -24.140400>, <0.386930, -1.517777, -24.105411>, <0.295718, -1.584045, -23.992669>, 
      <0.743511, -1.318011, -23.703534>, <0.741581, -1.319413, -23.702547>, <0.633682, -1.397806, -23.613432>, <0.632205, -1.398879, -23.611606>, 
      <0.867976, -1.227582, -23.332115>, <0.866046, -1.228984, -23.331126>, <0.863663, -1.230715, -23.329160>, <0.862186, -1.231788, -23.327336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.377001, -1.889596, -25.230485>, <0.195297, -2.021611, -25.137453>, <-0.029025, -2.184590, -24.952181>, <-0.168094, -2.285630, -24.780282>, 
      <0.515332, -1.964954, -25.067240>, <0.333628, -2.096969, -24.974210>, <0.155682, -2.226254, -24.827240>, <0.016612, -2.327294, -24.655341>, 
      <0.399275, -1.601578, -24.778269>, <0.280102, -1.688162, -24.717253>, <0.073860, -1.838005, -24.546915>, <-0.017351, -1.904274, -24.434171>, 
      <0.453093, -1.529012, -24.570181>, <0.333920, -1.615596, -24.509165>, <0.186794, -1.722489, -24.387651>, <0.095583, -1.788758, -24.274909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.200958, -1.391657, -24.867725>, <0.053608, -1.498714, -24.792282>, <-0.128304, -1.630880, -24.642038>, <-0.241081, -1.712817, -24.502638>, 
      <0.277707, -1.550735, -24.943563>, <0.130356, -1.657792, -24.868120>, <-0.073100, -1.805611, -24.700082>, <-0.185877, -1.887548, -24.560680>, 
      <0.259791, -1.825744, -25.368803>, <0.078088, -1.957759, -25.275773>, <-0.185530, -2.149287, -25.058046>, <-0.324599, -2.250327, -24.886147>, 
      <0.377001, -1.889596, -25.230485>, <0.195297, -2.021611, -25.137453>, <-0.029025, -2.184590, -24.952181>, <-0.168094, -2.285630, -24.780282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.002663, -1.113701, -24.860592>, <-0.144012, -1.220266, -24.785496>, <-0.325090, -1.351827, -24.635941>, <-0.437350, -1.433389, -24.497179>, 
      <0.070693, -1.178124, -24.819138>, <-0.075981, -1.284689, -24.744042>, <-0.245283, -1.407694, -24.604214>, <-0.357543, -1.489255, -24.465453>, 
      <0.160050, -1.306867, -24.827302>, <0.012700, -1.413923, -24.751859>, <-0.157728, -1.537746, -24.611101>, <-0.270506, -1.619684, -24.471701>, 
      <0.200958, -1.391657, -24.867725>, <0.053608, -1.498714, -24.792282>, <-0.128304, -1.630880, -24.642038>, <-0.241081, -1.712817, -24.502638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389345, -0.832657, -25.227427>, <-0.570759, -0.964461, -25.134544>, <-0.794724, -1.127181, -24.949568>, <-0.933572, -1.228060, -24.777942>, 
      <-0.364728, -0.957820, -25.356958>, <-0.546142, -1.089625, -25.264077>, <-0.806905, -1.279080, -25.048706>, <-0.945753, -1.379959, -24.877082>, 
      <-0.118051, -0.999388, -24.934149>, <-0.264726, -1.105953, -24.859053>, <-0.466701, -1.252697, -24.692240>, <-0.578961, -1.334258, -24.553478>, 
      <0.002663, -1.113701, -24.860592>, <-0.144012, -1.220266, -24.785496>, <-0.325090, -1.351827, -24.635941>, <-0.437350, -1.433389, -24.497179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.051559, -0.838008, -24.575277>, <-0.171215, -0.924943, -24.514013>, <-0.318936, -1.032269, -24.392008>, <-0.410517, -1.098806, -24.278808>, 
      <-0.132062, -0.869976, -24.777874>, <-0.251718, -0.956911, -24.716610>, <-0.456995, -1.106054, -24.547069>, <-0.548576, -1.172591, -24.433870>, 
      <-0.419180, -0.680960, -25.070435>, <-0.600594, -0.812764, -24.977552>, <-0.779959, -0.943080, -24.829413>, <-0.918807, -1.043959, -24.657787>, 
      <-0.389345, -0.832657, -25.227427>, <-0.570759, -0.964461, -25.134544>, <-0.794724, -1.127181, -24.949568>, <-0.933572, -1.228060, -24.777942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.244835, -0.622665, -23.690800>, <0.244835, -0.622665, -23.690800>, <0.137147, -0.700905, -23.601858>, <0.137147, -0.700905, -23.601858>, 
      <0.098347, -0.778479, -24.198018>, <-0.021309, -0.865414, -24.136754>, <-0.061855, -0.894872, -24.103266>, <-0.153436, -0.961409, -23.990067>, 
      <-0.051559, -0.838008, -24.575277>, <-0.171215, -0.924943, -24.514013>, <-0.318936, -1.032269, -24.392008>, <-0.410517, -1.098806, -24.278808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.095583, -1.788758, -24.274909>, <0.004371, -1.855027, -24.162165>, <-0.093935, -1.926451, -23.980309>, <-0.143298, -1.962315, -23.833002>, 
      <0.295718, -1.584045, -23.992669>, <0.204507, -1.650314, -23.879925>, <0.176201, -1.670880, -23.827562>, <0.126838, -1.706744, -23.680256>, 
      <0.632205, -1.398879, -23.611606>, <0.630728, -1.399952, -23.609781>, <0.558632, -1.452333, -23.476411>, <0.557833, -1.452914, -23.474026>, 
      <0.862186, -1.231788, -23.327336>, <0.860709, -1.232861, -23.325510>, <0.859117, -1.234018, -23.322565>, <0.858318, -1.234599, -23.320179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.168094, -2.285630, -24.780282>, <-0.307164, -2.386670, -24.608381>, <-0.457051, -2.495569, -24.331104>, <-0.532315, -2.550252, -24.106506>, 
      <0.016612, -2.327294, -24.655341>, <-0.122457, -2.428334, -24.483440>, <-0.241357, -2.514720, -24.263486>, <-0.316621, -2.569402, -24.038890>, 
      <-0.017351, -1.904274, -24.434171>, <-0.108562, -1.970543, -24.321429>, <-0.246368, -2.070665, -24.066502>, <-0.295731, -2.106529, -23.919195>, 
      <0.095583, -1.788758, -24.274909>, <0.004371, -1.855027, -24.162165>, <-0.093935, -1.926451, -23.980309>, <-0.143298, -1.962315, -23.833002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.241081, -1.712817, -24.502638>, <-0.353858, -1.794754, -24.363237>, <-0.475408, -1.883066, -24.138384>, <-0.536442, -1.927410, -23.956250>, 
      <-0.185877, -1.887548, -24.560680>, <-0.298654, -1.969485, -24.421280>, <-0.434599, -2.068255, -24.169795>, <-0.495634, -2.112600, -23.987661>, 
      <-0.324599, -2.250327, -24.886147>, <-0.463669, -2.351367, -24.714246>, <-0.639812, -2.479343, -24.388398>, <-0.715076, -2.534025, -24.163802>, 
      <-0.168094, -2.285630, -24.780282>, <-0.307164, -2.386670, -24.608381>, <-0.457051, -2.495569, -24.331104>, <-0.532315, -2.550252, -24.106506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.437350, -1.433389, -24.497179>, <-0.549610, -1.514951, -24.358418>, <-0.670602, -1.602857, -24.134592>, <-0.731357, -1.646998, -23.953293>, 
      <-0.357543, -1.489255, -24.465453>, <-0.469803, -1.570817, -24.326691>, <-0.582926, -1.653006, -24.117422>, <-0.643681, -1.697147, -23.936123>, 
      <-0.270506, -1.619684, -24.471701>, <-0.383282, -1.701621, -24.332301>, <-0.497159, -1.784357, -24.121642>, <-0.558194, -1.828701, -23.939507>, 
      <-0.241081, -1.712817, -24.502638>, <-0.353858, -1.794754, -24.363237>, <-0.475408, -1.883066, -24.138384>, <-0.536442, -1.927410, -23.956250>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.933572, -1.228060, -24.777942>, <-1.072419, -1.328939, -24.606317>, <-1.222068, -1.437665, -24.329482>, <-1.297212, -1.492260, -24.105242>, 
      <-0.945753, -1.379959, -24.877082>, <-1.084601, -1.480838, -24.705456>, <-1.258838, -1.607428, -24.383134>, <-1.333982, -1.662023, -24.158896>, 
      <-0.578961, -1.334258, -24.553478>, <-0.691221, -1.415820, -24.414717>, <-0.826176, -1.513871, -24.165061>, <-0.886931, -1.558012, -23.983762>, 
      <-0.437350, -1.433389, -24.497179>, <-0.549610, -1.514951, -24.358418>, <-0.670602, -1.602857, -24.134592>, <-0.731357, -1.646998, -23.953293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.410517, -1.098806, -24.278808>, <-0.502097, -1.165343, -24.165610>, <-0.600802, -1.237056, -23.983014>, <-0.650365, -1.273066, -23.835114>, 
      <-0.548576, -1.172591, -24.433870>, <-0.640156, -1.239128, -24.320670>, <-0.777318, -1.338782, -24.066934>, <-0.826881, -1.374792, -23.919034>, 
      <-0.918807, -1.043959, -24.657787>, <-1.057655, -1.144839, -24.486162>, <-1.177503, -1.231913, -24.264454>, <-1.252647, -1.286508, -24.040214>, 
      <-0.933572, -1.228060, -24.777942>, <-1.072419, -1.328939, -24.606317>, <-1.222068, -1.437665, -24.329482>, <-1.297212, -1.492260, -24.105242>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.137147, -0.700905, -23.601858>, <0.137147, -0.700905, -23.601858>, <0.065193, -0.753183, -23.468750>, <0.065193, -0.753183, -23.468750>, 
      <-0.153436, -0.961409, -23.990067>, <-0.245016, -1.027947, -23.876867>, <-0.272108, -1.047630, -23.826747>, <-0.321671, -1.083640, -23.678846>, 
      <-0.410517, -1.098806, -24.278808>, <-0.502097, -1.165343, -24.165610>, <-0.600802, -1.237056, -23.983014>, <-0.650365, -1.273066, -23.835114>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143298, -1.962315, -23.833002>, <-0.192661, -1.998180, -23.685696>, <-0.227182, -2.023260, -23.471179>, <-0.227182, -2.023260, -23.311738>, 
      <0.126838, -1.706744, -23.680256>, <0.077474, -1.742609, -23.532949>, <0.067534, -1.749831, -23.471179>, <0.067534, -1.749831, -23.311738>, 
      <0.557833, -1.452914, -23.474026>, <0.557034, -1.453494, -23.471640>, <0.531717, -1.471888, -23.314320>, <0.531717, -1.471888, -23.311738>, 
      <0.858318, -1.234599, -23.320179>, <0.857518, -1.235179, -23.317794>, <0.856959, -1.235586, -23.314320>, <0.856959, -1.235586, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.532315, -2.550252, -24.106506>, <-0.607579, -2.604934, -23.881910>, <-0.660212, -2.643175, -23.554838>, <-0.660212, -2.643175, -23.311738>, 
      <-0.316621, -2.569402, -24.038890>, <-0.391885, -2.624085, -23.814293>, <-0.433637, -2.654419, -23.554838>, <-0.433637, -2.654419, -23.311738>, 
      <-0.295731, -2.106529, -23.919195>, <-0.345095, -2.142394, -23.771888>, <-0.393485, -2.177552, -23.471179>, <-0.393486, -2.177552, -23.311738>, 
      <-0.143298, -1.962315, -23.833002>, <-0.192661, -1.998180, -23.685696>, <-0.227182, -2.023260, -23.471179>, <-0.227182, -2.023260, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.536442, -1.927410, -23.956250>, <-0.597477, -1.971754, -23.774115>, <-0.640159, -2.002764, -23.508878>, <-0.640159, -2.002764, -23.311738>, 
      <-0.495634, -2.112600, -23.987661>, <-0.556668, -2.156944, -23.805526>, <-0.604406, -2.191627, -23.508878>, <-0.604406, -2.191627, -23.311738>, 
      <-0.715076, -2.534025, -24.163802>, <-0.790340, -2.588708, -23.939205>, <-0.852193, -2.633647, -23.554838>, <-0.852193, -2.633647, -23.311738>, 
      <-0.532315, -2.550252, -24.106506>, <-0.607579, -2.604934, -23.881910>, <-0.660212, -2.643175, -23.554838>, <-0.660212, -2.643175, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.731357, -1.646998, -23.953293>, <-0.792111, -1.691139, -23.771994>, <-0.834598, -1.722007, -23.507974>, <-0.834598, -1.722007, -23.311738>, 
      <-0.643681, -1.697147, -23.936123>, <-0.704436, -1.741288, -23.754824>, <-0.744159, -1.770149, -23.507974>, <-0.744159, -1.770149, -23.311738>, 
      <-0.558194, -1.828701, -23.939507>, <-0.619228, -1.873045, -23.757371>, <-0.659216, -1.902098, -23.508878>, <-0.659216, -1.902098, -23.311738>, 
      <-0.536442, -1.927410, -23.956250>, <-0.597477, -1.971754, -23.774115>, <-0.640159, -2.002764, -23.508878>, <-0.640159, -2.002764, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.297212, -1.492260, -24.105242>, <-1.372356, -1.546855, -23.881003>, <-1.424905, -1.585035, -23.554453>, <-1.424905, -1.585035, -23.311738>, 
      <-1.333982, -1.662023, -24.158896>, <-1.409126, -1.716619, -23.934656>, <-1.470309, -1.761071, -23.554453>, <-1.470309, -1.761071, -23.311738>, 
      <-0.886931, -1.558012, -23.983762>, <-0.947685, -1.602152, -23.802462>, <-0.995076, -1.636583, -23.507974>, <-0.995076, -1.636583, -23.311738>, 
      <-0.731357, -1.646998, -23.953293>, <-0.792111, -1.691139, -23.771994>, <-0.834598, -1.722007, -23.507974>, <-0.834598, -1.722007, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.650365, -1.273066, -23.835114>, <-0.699928, -1.309075, -23.687210>, <-0.734588, -1.334258, -23.471827>, <-0.734588, -1.334258, -23.311738>, 
      <-0.826881, -1.374792, -23.919034>, <-0.876444, -1.410801, -23.771130>, <-0.924609, -1.445795, -23.471827>, <-0.924609, -1.445795, -23.311738>, 
      <-1.252647, -1.286508, -24.040214>, <-1.327791, -1.341104, -23.815974>, <-1.369876, -1.371680, -23.554453>, <-1.369876, -1.371680, -23.311738>, 
      <-1.297212, -1.492260, -24.105242>, <-1.372356, -1.546855, -23.881003>, <-1.424905, -1.585035, -23.554453>, <-1.424905, -1.585035, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.065193, -0.753183, -23.468750>, <0.065193, -0.753183, -23.468750>, <0.039926, -0.771540, -23.311738>, <0.039926, -0.771540, -23.311738>, 
      <-0.321671, -1.083640, -23.678846>, <-0.371234, -1.119649, -23.530942>, <-0.380748, -1.126561, -23.471827>, <-0.380748, -1.126561, -23.311738>, 
      <-0.650365, -1.273066, -23.835114>, <-0.699928, -1.309075, -23.687210>, <-0.734588, -1.334258, -23.471827>, <-0.734588, -1.334258, -23.311738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.227182, -2.023260, -23.311738>, <-0.227182, -2.023260, -23.152294>, <-0.192662, -1.998180, -22.937779>, <-0.143298, -1.962315, -22.790472>, 
      <0.067534, -1.749831, -23.311738>, <0.067534, -1.749831, -23.152294>, <0.077474, -1.742609, -23.090526>, <0.126837, -1.706745, -22.943221>, 
      <0.531717, -1.471888, -23.311738>, <0.531717, -1.471888, -23.309155>, <0.557033, -1.453494, -23.151835>, <0.557833, -1.452914, -23.149448>, 
      <0.856959, -1.235586, -23.311738>, <0.856959, -1.235586, -23.309155>, <0.857518, -1.235179, -23.305682>, <0.858318, -1.234599, -23.303294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.660212, -2.643175, -23.311738>, <-0.660212, -2.643175, -23.068634>, <-0.607579, -2.604934, -22.741563>, <-0.532315, -2.550252, -22.516966>, 
      <-0.433637, -2.654419, -23.311738>, <-0.433637, -2.654419, -23.068634>, <-0.391885, -2.624085, -22.809181>, <-0.316621, -2.569402, -22.584584>, 
      <-0.393486, -2.177552, -23.311738>, <-0.393486, -2.177552, -23.152294>, <-0.345095, -2.142394, -22.851586>, <-0.295731, -2.106529, -22.704278>, 
      <-0.227182, -2.023260, -23.311738>, <-0.227182, -2.023260, -23.152294>, <-0.192662, -1.998180, -22.937779>, <-0.143298, -1.962315, -22.790472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.640159, -2.002764, -23.311738>, <-0.640159, -2.002764, -23.114595>, <-0.597477, -1.971754, -22.849360>, <-0.536442, -1.927410, -22.667226>, 
      <-0.604406, -2.191627, -23.311738>, <-0.604406, -2.191627, -23.114595>, <-0.556668, -2.156944, -22.817947>, <-0.495634, -2.112600, -22.635813>, 
      <-0.852193, -2.633647, -23.311738>, <-0.852193, -2.633647, -23.068634>, <-0.790340, -2.588708, -22.684269>, <-0.715076, -2.534025, -22.459670>, 
      <-0.660212, -2.643175, -23.311738>, <-0.660212, -2.643175, -23.068634>, <-0.607579, -2.604934, -22.741563>, <-0.532315, -2.550252, -22.516966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.834598, -1.722007, -23.311738>, <-0.834599, -1.722007, -23.115499>, <-0.792112, -1.691139, -22.851480>, <-0.731357, -1.646998, -22.670179>, 
      <-0.744159, -1.770149, -23.311738>, <-0.744159, -1.770149, -23.115499>, <-0.704436, -1.741288, -22.868651>, <-0.643681, -1.697147, -22.687349>, 
      <-0.659216, -1.902098, -23.311738>, <-0.659216, -1.902098, -23.114595>, <-0.619228, -1.873046, -22.866102>, <-0.558194, -1.828701, -22.683968>, 
      <-0.640159, -2.002764, -23.311738>, <-0.640159, -2.002764, -23.114595>, <-0.597477, -1.971754, -22.849360>, <-0.536442, -1.927410, -22.667226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.424905, -1.585035, -23.311738>, <-1.424905, -1.585035, -23.069021>, <-1.372356, -1.546856, -22.742472>, <-1.297212, -1.492260, -22.518232>, 
      <-1.470309, -1.761071, -23.311738>, <-1.470309, -1.761071, -23.069021>, <-1.409126, -1.716618, -22.688818>, <-1.333982, -1.662023, -22.464579>, 
      <-0.995076, -1.636583, -23.311738>, <-0.995076, -1.636583, -23.115499>, <-0.947686, -1.602153, -22.821013>, <-0.886931, -1.558012, -22.639712>, 
      <-0.834598, -1.722007, -23.311738>, <-0.834599, -1.722007, -23.115499>, <-0.792112, -1.691139, -22.851480>, <-0.731357, -1.646998, -22.670179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.734588, -1.334258, -23.311738>, <-0.734588, -1.334258, -23.151648>, <-0.699928, -1.309075, -22.936264>, <-0.650365, -1.273066, -22.788360>, 
      <-0.924609, -1.445795, -23.311738>, <-0.924609, -1.445795, -23.151648>, <-0.876444, -1.410801, -22.852344>, <-0.826881, -1.374792, -22.704442>, 
      <-1.369876, -1.371680, -23.311738>, <-1.369876, -1.371680, -23.069021>, <-1.327791, -1.341104, -22.807499>, <-1.252647, -1.286509, -22.583259>, 
      <-1.424905, -1.585035, -23.311738>, <-1.424905, -1.585035, -23.069021>, <-1.372356, -1.546856, -22.742472>, <-1.297212, -1.492260, -22.518232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, <0.371860, -0.530376, -23.311738>, 
      <0.039926, -0.771540, -23.311738>, <0.039926, -0.771540, -23.311738>, <0.065193, -0.753183, -23.154725>, <0.065193, -0.753183, -23.154725>, 
      <-0.380748, -1.126561, -23.311738>, <-0.380748, -1.126561, -23.151648>, <-0.371234, -1.119649, -23.092531>, <-0.321671, -1.083640, -22.944627>, 
      <-0.734588, -1.334258, -23.311738>, <-0.734588, -1.334258, -23.151648>, <-0.699928, -1.309075, -22.936264>, <-0.650365, -1.273066, -22.788360>
    }
  }
  photons {
    collect off
  }
}
#declare carcasa2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.013154, 1.007126, -22.454560>, <-2.942332, 1.058581, -22.219736>, <-2.800496, 1.161631, -21.924947>, <-2.664865, 1.260172, -21.738670>, 
      <-2.639041, 1.300175, -22.673131>, <-2.568219, 1.351629, -22.438309>, <-2.516521, 1.389191, -22.328832>, <-2.380890, 1.487733, -22.142555>, 
      <-2.116173, 1.658821, -22.964838>, <-2.106488, 1.665857, -22.932726>, <-1.996894, 1.745482, -22.707016>, <-1.978346, 1.758958, -22.681541>, 
      <-1.731753, 1.938118, -23.183530>, <-1.722068, 1.945155, -23.151416>, <-1.702672, 1.959247, -23.111102>, <-1.684124, 1.972723, -23.085629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.513146, 0.542727, -22.142763>, <-3.416175, 0.613180, -21.821235>, <-3.221969, 0.754279, -21.417603>, <-3.036259, 0.889205, -21.162546>, 
      <-3.395934, 0.712692, -22.232386>, <-3.298963, 0.783145, -21.910858>, <-3.141478, 0.897821, -21.583702>, <-2.955768, 1.032747, -21.328646>, 
      <-3.174130, 0.881031, -22.360510>, <-3.103309, 0.932486, -22.125686>, <-2.922634, 1.063757, -21.751238>, <-2.787003, 1.162299, -21.564960>, 
      <-3.013154, 1.007126, -22.454560>, <-2.942332, 1.058581, -22.219736>, <-2.800496, 1.161631, -21.924947>, <-2.664865, 1.260172, -21.738670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.624830, 0.120158, -21.986866>, <-3.514785, 0.200111, -21.621989>, <-3.294394, 0.360234, -21.163930>, <-3.083644, 0.513353, -20.874485>, 
      <-3.625652, 0.254617, -22.022934>, <-3.515607, 0.334570, -21.658056>, <-3.310251, 0.485137, -21.231250>, <-3.099501, 0.638255, -20.941805>, 
      <-3.585645, 0.437599, -22.087330>, <-3.488674, 0.508053, -21.765802>, <-3.271117, 0.666632, -21.316181>, <-3.085407, 0.801558, -21.061125>, 
      <-3.513146, 0.542727, -22.142763>, <-3.416175, 0.613180, -21.821235>, <-3.221969, 0.754279, -21.417603>, <-3.036259, 0.889205, -21.162546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.509670, -0.025897, -21.990234>, <-3.399907, 0.053851, -21.626291>, <-3.180081, 0.213563, -21.169408>, <-2.969873, 0.366289, -20.880707>, 
      <-3.561423, -0.011877, -21.974758>, <-3.451660, 0.067871, -21.610814>, <-3.224675, 0.231902, -21.141301>, <-3.014466, 0.384627, -20.852598>, 
      <-3.624501, 0.066257, -21.972408>, <-3.514455, 0.146210, -21.607531>, <-3.288195, 0.311408, -21.137613>, <-3.077446, 0.464527, -20.848170>, 
      <-3.624830, 0.120158, -21.986866>, <-3.514785, 0.200111, -21.621989>, <-3.294394, 0.360234, -21.163930>, <-3.083644, 0.513353, -20.874485>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.098702, -0.022370, -22.144206>, <-3.001852, 0.047995, -21.823082>, <-2.807888, 0.188918, -21.419952>, <-2.622410, 0.323676, -21.165214>, 
      <-3.208042, -0.071892, -22.090099>, <-3.111192, -0.001527, -21.768974>, <-2.894059, 0.155937, -21.320954>, <-2.708581, 0.290694, -21.066216>, 
      <-3.387572, -0.058973, -22.026749>, <-3.277808, 0.020774, -21.662805>, <-3.071954, 0.169097, -21.237566>, <-2.861745, 0.321822, -20.948864>, 
      <-3.509670, -0.025897, -21.990234>, <-3.399907, 0.053851, -21.626291>, <-3.180081, 0.213563, -21.169408>, <-2.969873, 0.366289, -20.880707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.576238, 0.396870, -22.452154>, <-2.505214, 0.448471, -22.216664>, <-2.362974, 0.551814, -21.921034>, <-2.226957, 0.650637, -21.734226>, 
      <-2.737924, 0.277590, -22.359683>, <-2.666901, 0.329192, -22.124194>, <-2.486514, 0.460251, -21.750182>, <-2.350497, 0.559073, -21.563376>, 
      <-2.915023, 0.060821, -22.235102>, <-2.818173, 0.131186, -21.913976>, <-2.661525, 0.244938, -21.588104>, <-2.476048, 0.379695, -21.333366>, 
      <-3.098702, -0.022370, -22.144206>, <-3.001852, 0.047995, -21.823082>, <-2.807888, 0.188918, -21.419952>, <-2.622410, 0.323676, -21.165214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.281413, 1.318279, -23.183530>, <-1.271729, 1.325316, -23.151416>, <-1.252332, 1.339408, -23.111102>, <-1.233784, 1.352884, -23.085630>, 
      <-1.669861, 1.041856, -22.964117>, <-1.660176, 1.048893, -22.932005>, <-1.550284, 1.128734, -22.705682>, <-1.531736, 1.142210, -22.680208>, 
      <-2.192581, 0.679901, -22.671570>, <-2.121558, 0.731502, -22.436078>, <-2.069815, 0.769095, -22.326462>, <-1.933798, 0.867918, -22.139654>, 
      <-2.576238, 0.396870, -22.452154>, <-2.505214, 0.448471, -22.216664>, <-2.362974, 0.551814, -21.921034>, <-2.226957, 0.650637, -21.734226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.664865, 1.260172, -21.738670>, <-2.534578, 1.354832, -21.559733>, <-2.320537, 1.510342, -21.360976>, <-2.143615, 1.638883, -21.260328>, 
      <-2.380890, 1.487733, -22.142555>, <-2.250602, 1.582392, -21.963618>, <-2.171480, 1.639879, -21.888696>, <-1.994558, 1.768420, -21.788050>, 
      <-1.978346, 1.758958, -22.681541>, <-1.960529, 1.771903, -22.657072>, <-1.796268, 1.891245, -22.506014>, <-1.772074, 1.908824, -22.492251>, 
      <-1.684124, 1.972723, -23.085629>, <-1.666307, 1.985668, -23.061158>, <-1.637036, 2.006934, -23.033979>, <-1.612842, 2.024513, -23.020216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.036259, 0.889205, -21.162546>, <-2.857865, 1.018816, -20.917538>, <-2.564794, 1.231745, -20.645394>, <-2.322547, 1.407747, -20.507584>, 
      <-2.955768, 1.032747, -21.328646>, <-2.777374, 1.162358, -21.083637>, <-2.539726, 1.335243, -20.862984>, <-2.297479, 1.511246, -20.725174>, 
      <-2.787003, 1.162299, -21.564960>, <-2.656715, 1.256959, -21.386022>, <-2.384622, 1.454649, -21.134088>, <-2.207700, 1.583190, -21.033442>, 
      <-2.664865, 1.260172, -21.738670>, <-2.534578, 1.354832, -21.559733>, <-2.320537, 1.510342, -21.360976>, <-2.143615, 1.638883, -21.260328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.083644, 0.513353, -20.874485>, <-2.881197, 0.660439, -20.596443>, <-2.548611, 0.902077, -20.287605>, <-2.273702, 1.101810, -20.131214>, 
      <-3.099501, 0.638255, -20.941805>, <-2.897054, 0.785342, -20.663763>, <-2.587315, 1.011656, -20.376384>, <-2.312406, 1.211389, -20.219994>, 
      <-3.085407, 0.801558, -21.061125>, <-2.907013, 0.931168, -20.816117>, <-2.579928, 1.169264, -20.514037>, <-2.337681, 1.345267, -20.376227>, 
      <-3.036259, 0.889205, -21.162546>, <-2.857865, 1.018816, -20.917538>, <-2.564794, 1.231745, -20.645394>, <-2.322547, 1.407747, -20.507584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.969873, 0.366289, -20.880707>, <-2.767946, 0.512997, -20.603378>, <-2.436213, 0.754015, -20.295334>, <-2.162009, 0.953236, -20.139344>, 
      <-3.014466, 0.384627, -20.852598>, <-2.812539, 0.531336, -20.575270>, <-2.470834, 0.778760, -20.259216>, <-2.196630, 0.977980, -20.103226>, 
      <-3.077446, 0.464527, -20.848170>, <-2.874999, 0.611613, -20.570128>, <-2.533839, 0.860255, -20.253722>, <-2.258930, 1.059988, -20.097330>, 
      <-3.083644, 0.513353, -20.874485>, <-2.881197, 0.660439, -20.596443>, <-2.548611, 0.902077, -20.287605>, <-2.273702, 1.101810, -20.131214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.622410, 0.323676, -21.165214>, <-2.444239, 0.453125, -20.920514>, <-2.151534, 0.665787, -20.648709>, <-1.909590, 0.841570, -20.511070>, 
      <-2.708581, 0.290694, -21.066216>, <-2.530410, 0.420143, -20.821514>, <-2.204174, 0.656911, -20.520477>, <-1.962229, 0.832694, -20.382840>, 
      <-2.861745, 0.321822, -20.948864>, <-2.659818, 0.468531, -20.671536>, <-2.350058, 0.692438, -20.385214>, <-2.075854, 0.891659, -20.229224>, 
      <-2.969873, 0.366289, -20.880707>, <-2.767946, 0.512997, -20.603378>, <-2.436213, 0.754015, -20.295334>, <-2.162009, 0.953236, -20.139344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.226957, 0.650637, -21.734226>, <-2.096298, 0.745566, -21.554779>, <-1.881648, 0.901519, -21.355456>, <-1.704222, 1.030426, -21.254520>, 
      <-2.350497, 0.559073, -21.563376>, <-2.219838, 0.654002, -21.383928>, <-1.948109, 0.851425, -21.132242>, <-1.770683, 0.980332, -21.031307>, 
      <-2.476048, 0.379695, -21.333366>, <-2.297877, 0.509144, -21.088666>, <-2.061253, 0.681010, -20.868635>, <-1.819308, 0.856793, -20.730997>, 
      <-2.622410, 0.323676, -21.165214>, <-2.444239, 0.453125, -20.920514>, <-2.151534, 0.665787, -20.648709>, <-1.909590, 0.841570, -20.511070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.233784, 1.352884, -23.085630>, <-1.215967, 1.365829, -23.061162>, <-1.186697, 1.387095, -23.033979>, <-1.162502, 1.404673, -23.020216>, 
      <-1.531736, 1.142210, -22.680208>, <-1.513919, 1.155155, -22.655739>, <-1.349213, 1.274821, -22.504270>, <-1.325018, 1.292399, -22.490507>, 
      <-1.933798, 0.867918, -22.139654>, <-1.803139, 0.962847, -21.960206>, <-1.723927, 1.020398, -21.885171>, <-1.546501, 1.149305, -21.784237>, 
      <-2.226957, 0.650637, -21.734226>, <-2.096298, 0.745566, -21.554779>, <-1.881648, 0.901519, -21.355456>, <-1.704222, 1.030426, -21.254520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.143615, 1.638883, -21.260328>, <-1.972010, 1.763562, -21.162704>, <-1.717667, 1.948352, -21.092358>, <-1.528759, 2.085602, -21.092358>, 
      <-1.994558, 1.768420, -21.788050>, <-1.822952, 1.893099, -21.690426>, <-1.727768, 1.962255, -21.663566>, <-1.538860, 2.099505, -21.663566>, 
      <-1.772074, 1.908824, -22.492251>, <-1.748606, 1.925874, -22.478901>, <-1.554593, 2.066833, -22.425779>, <-1.528759, 2.085602, -22.425779>, 
      <-1.612842, 2.024513, -23.020216>, <-1.589374, 2.041563, -23.006867>, <-1.554592, 2.066833, -22.997246>, <-1.528759, 2.085602, -22.997246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.322547, 1.407747, -20.507584>, <-2.087579, 1.578462, -20.373915>, <-1.739326, 1.831482, -20.277594>, <-1.480667, 2.019409, -20.277594>, 
      <-2.297479, 1.511246, -20.725174>, <-2.062511, 1.681960, -20.591506>, <-1.779921, 1.887357, -20.513344>, <-1.521262, 2.075284, -20.513344>, 
      <-2.207700, 1.583190, -21.033442>, <-2.036095, 1.707869, -20.935818>, <-1.713325, 1.942376, -20.846810>, <-1.524417, 2.079626, -20.846810>, 
      <-2.143615, 1.638883, -21.260328>, <-1.972010, 1.763562, -21.162704>, <-1.717667, 1.948352, -21.092358>, <-1.528759, 2.085602, -21.092358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.273702, 1.101810, -20.131214>, <-2.007053, 1.295542, -19.979520>, <-1.611844, 1.582678, -19.870211>, <-1.318310, 1.795943, -19.870211>, 
      <-2.312406, 1.211389, -20.219994>, <-2.045757, 1.405121, -20.068301>, <-1.677564, 1.673134, -19.966658>, <-1.384029, 1.886399, -19.966658>, 
      <-2.337681, 1.345267, -20.376227>, <-2.102713, 1.515981, -20.242557>, <-1.714925, 1.797898, -20.135891>, <-1.456266, 1.985824, -20.135891>, 
      <-2.322547, 1.407747, -20.507584>, <-2.087579, 1.578462, -20.373915>, <-1.739326, 1.831482, -20.277594>, <-1.480667, 2.019409, -20.277594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.162009, 0.953236, -20.139344>, <-1.896044, 1.146470, -19.988042>, <-1.501850, 1.432869, -19.879013>, <-1.209069, 1.645587, -19.879013>, 
      <-2.196630, 0.977980, -20.103226>, <-1.930665, 1.171215, -19.951923>, <-1.525419, 1.465308, -19.840181>, <-1.232638, 1.678026, -19.840181>, 
      <-2.258930, 1.059988, -20.097330>, <-1.992281, 1.253720, -19.945637>, <-1.587001, 1.548484, -19.833752>, <-1.293466, 1.761750, -19.833752>, 
      <-2.273702, 1.101810, -20.131214>, <-2.007053, 1.295542, -19.979520>, <-1.611844, 1.582678, -19.870211>, <-1.318310, 1.795943, -19.870211>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.909590, 0.841570, -20.511070>, <-1.674915, 1.012071, -20.377568>, <-1.327097, 1.264776, -20.281365>, <-1.068761, 1.452468, -20.281365>, 
      <-1.962229, 0.832694, -20.382840>, <-1.727555, 1.003195, -20.249336>, <-1.341017, 1.283935, -20.143026>, <-1.082680, 1.471627, -20.143026>, 
      <-2.075854, 0.891659, -20.229224>, <-1.809890, 1.084893, -20.077922>, <-1.442589, 1.351303, -19.976650>, <-1.149808, 1.564021, -19.976650>, 
      <-2.162009, 0.953236, -20.139344>, <-1.896044, 1.146470, -19.988042>, <-1.501850, 1.432869, -19.879013>, <-1.209069, 1.645587, -19.879013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.704222, 1.030426, -21.254520>, <-1.532127, 1.155460, -21.156618>, <-1.277060, 1.340777, -21.086070>, <-1.087614, 1.478418, -21.086070>, 
      <-1.770683, 0.980332, -21.031307>, <-1.598588, 1.105367, -20.933405>, <-1.276201, 1.339594, -20.844470>, <-1.086755, 1.477235, -20.844470>, 
      <-1.819308, 0.856793, -20.730997>, <-1.584634, 1.027294, -20.597494>, <-1.303135, 1.231795, -20.519504>, <-1.044799, 1.419488, -20.519504>, 
      <-1.909590, 0.841570, -20.511070>, <-1.674915, 1.012071, -20.377568>, <-1.327097, 1.264776, -20.281365>, <-1.068761, 1.452468, -20.281365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.162502, 1.404673, -23.020216>, <-1.139035, 1.421723, -23.006867>, <-1.104253, 1.446994, -22.997246>, <-1.078419, 1.465763, -22.997246>, 
      <-1.325018, 1.292399, -22.490507>, <-1.301551, 1.309449, -22.477157>, <-1.107011, 1.450790, -22.423893>, <-1.081178, 1.469560, -22.423893>, 
      <-1.546501, 1.149305, -21.784237>, <-1.374406, 1.274339, -21.686334>, <-1.279099, 1.343584, -21.659432>, <-1.089653, 1.481225, -21.659432>, 
      <-1.704222, 1.030426, -21.254520>, <-1.532127, 1.155460, -21.156618>, <-1.277060, 1.340777, -21.086070>, <-1.087614, 1.478418, -21.086070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.528759, 2.085602, -21.092358>, <-1.339851, 2.222852, -21.092358>, <-1.085509, 2.407642, -21.162704>, <-0.913902, 2.532321, -21.260328>, 
      <-1.538860, 2.099505, -21.663566>, <-1.349951, 2.236755, -21.663566>, <-1.254767, 2.305910, -21.690424>, <-1.083161, 2.430589, -21.788048>, 
      <-1.528759, 2.085602, -22.425779>, <-1.502925, 2.104372, -22.425779>, <-1.308911, 2.245331, -22.478899>, <-1.285444, 2.262381, -22.492248>, 
      <-1.528759, 2.085602, -22.997246>, <-1.502925, 2.104372, -22.997246>, <-1.468143, 2.129642, -23.006864>, <-1.444676, 2.146692, -23.020214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.480667, 2.019409, -20.277594>, <-1.222008, 2.207336, -20.277594>, <-0.873755, 2.460357, -20.373915>, <-0.638787, 2.631071, -20.507584>, 
      <-1.521262, 2.075284, -20.513344>, <-1.262603, 2.263211, -20.513344>, <-0.979934, 2.468498, -20.591506>, <-0.744966, 2.639212, -20.725174>, 
      <-1.524417, 2.079626, -20.846810>, <-1.335509, 2.216876, -20.846810>, <-1.012738, 2.451381, -20.935818>, <-0.841132, 2.576060, -21.033442>, 
      <-1.528759, 2.085602, -21.092358>, <-1.339851, 2.222852, -21.092358>, <-1.085509, 2.407642, -21.162704>, <-0.913902, 2.532321, -21.260328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.318310, 1.795943, -19.870211>, <-1.024775, 2.009209, -19.870211>, <-0.629567, 2.296345, -19.979518>, <-0.362917, 2.490077, -20.131213>, 
      <-1.384029, 1.886399, -19.966658>, <-1.090495, 2.099664, -19.966658>, <-0.721822, 2.367017, -20.068298>, <-0.455173, 2.560749, -20.219992>, 
      <-1.456266, 1.985824, -20.135891>, <-1.197607, 2.173751, -20.135891>, <-0.809655, 2.455442, -20.242557>, <-0.574687, 2.626157, -20.376227>, 
      <-1.480667, 2.019409, -20.277594>, <-1.222008, 2.207336, -20.277594>, <-0.873755, 2.460357, -20.373915>, <-0.638787, 2.631071, -20.507584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.209069, 1.645587, -19.879013>, <-0.916288, 1.858305, -19.879013>, <-0.522094, 2.144704, -19.988042>, <-0.256130, 2.337938, -20.139344>, 
      <-1.232638, 1.678026, -19.840181>, <-0.939857, 1.890744, -19.840181>, <-0.534929, 2.185277, -19.951923>, <-0.268965, 2.378511, -20.103226>, 
      <-1.293466, 1.761750, -19.833752>, <-0.999932, 1.975015, -19.833752>, <-0.594356, 2.269372, -19.945635>, <-0.327707, 2.463104, -20.097328>, 
      <-1.318310, 1.795943, -19.870211>, <-1.024775, 2.009209, -19.870211>, <-0.629567, 2.296345, -19.979518>, <-0.362917, 2.490077, -20.131213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.068761, 1.452468, -20.281365>, <-0.810424, 1.640161, -20.281365>, <-0.462606, 1.892865, -20.377568>, <-0.227931, 2.063367, -20.511070>, 
      <-1.082680, 1.471627, -20.143026>, <-0.824344, 1.659320, -20.143026>, <-0.437898, 1.940186, -20.249336>, <-0.203223, 2.110687, -20.382840>, 
      <-1.149808, 1.564021, -19.976650>, <-0.857027, 1.776739, -19.976650>, <-0.490154, 2.043737, -20.077922>, <-0.224190, 2.236972, -20.229224>, 
      <-1.209069, 1.645587, -19.879013>, <-0.916288, 1.858305, -19.879013>, <-0.522094, 2.144704, -19.988042>, <-0.256130, 2.337938, -20.139344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.087614, 1.478418, -21.086070>, <-0.898167, 1.616059, -21.086070>, <-0.643100, 1.801376, -21.156618>, <-0.471006, 1.926410, -21.254520>, 
      <-1.086755, 1.477235, -20.844470>, <-0.897308, 1.614876, -20.844470>, <-0.574921, 1.849104, -20.933405>, <-0.402826, 1.974138, -21.031307>, 
      <-1.044799, 1.419488, -20.519504>, <-0.786462, 1.607180, -20.519504>, <-0.504982, 1.811707, -20.597494>, <-0.270307, 1.982208, -20.730997>, 
      <-1.068761, 1.452468, -20.281365>, <-0.810424, 1.640161, -20.281365>, <-0.462606, 1.892865, -20.377568>, <-0.227931, 2.063367, -20.511070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.078419, 1.465763, -22.997246>, <-1.052586, 1.484533, -22.997246>, <-1.017804, 1.509803, -23.006867>, <-0.994336, 1.526853, -23.020216>, 
      <-1.081178, 1.469560, -22.423893>, <-1.055344, 1.488329, -22.423893>, <-0.860805, 1.629670, -22.477157>, <-0.837337, 1.646720, -22.490507>, 
      <-1.089653, 1.481225, -21.659432>, <-0.900206, 1.618866, -21.659432>, <-0.804900, 1.688110, -21.686334>, <-0.632805, 1.813144, -21.784237>, 
      <-1.087614, 1.478418, -21.086070>, <-0.898167, 1.616059, -21.086070>, <-0.643100, 1.801376, -21.156618>, <-0.471006, 1.926410, -21.254520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.913902, 2.532321, -21.260328>, <-0.736981, 2.660863, -21.360976>, <-0.522940, 2.816372, -21.559733>, <-0.392652, 2.911032, -21.738670>, 
      <-1.083161, 2.430589, -21.788048>, <-0.906239, 2.559130, -21.888694>, <-0.827116, 2.616616, -21.963618>, <-0.696828, 2.711276, -22.142555>, 
      <-1.285444, 2.262381, -22.492248>, <-1.261249, 2.279959, -22.506011>, <-1.096988, 2.399302, -22.657072>, <-1.079171, 2.412247, -22.681541>, 
      <-1.444676, 2.146692, -23.020214>, <-1.420481, 2.164271, -23.033978>, <-1.391211, 2.185537, -23.061158>, <-1.373394, 2.198482, -23.085629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.638787, 2.631071, -20.507584>, <-0.396540, 2.807074, -20.645394>, <-0.103468, 3.020003, -20.917536>, <0.074925, 3.149613, -21.162544>, 
      <-0.744966, 2.639212, -20.725174>, <-0.502719, 2.815215, -20.862984>, <-0.264858, 2.987808, -21.083637>, <-0.086464, 3.117419, -21.328646>, 
      <-0.841132, 2.576060, -21.033442>, <-0.664211, 2.704601, -21.134088>, <-0.392114, 2.902287, -21.386021>, <-0.261827, 2.996947, -21.564958>, 
      <-0.913902, 2.532321, -21.260328>, <-0.736981, 2.660863, -21.360976>, <-0.522940, 2.816372, -21.559733>, <-0.392652, 2.911032, -21.738670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.362917, 2.490077, -20.131213>, <-0.088008, 2.689810, -20.287603>, <0.244579, 2.931448, -20.596440>, <0.447025, 3.078534, -20.874482>, 
      <-0.455173, 2.560749, -20.219992>, <-0.180264, 2.760482, -20.376382>, <0.130689, 2.985126, -20.663760>, <0.333135, 3.132212, -20.941802>, 
      <-0.574687, 2.626157, -20.376227>, <-0.332441, 2.802159, -20.514037>, <-0.004923, 3.039661, -20.816112>, <0.173471, 3.169271, -21.061122>, 
      <-0.638787, 2.631071, -20.507584>, <-0.396540, 2.807074, -20.645394>, <-0.103468, 3.020003, -20.917536>, <0.074925, 3.149613, -21.162544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.256130, 2.337938, -20.139344>, <0.018074, 2.537159, -20.295334>, <0.349807, 2.778177, -20.603378>, <0.551734, 2.924886, -20.880707>, 
      <-0.268965, 2.378511, -20.103226>, <0.005239, 2.577732, -20.259216>, <0.346146, 2.826255, -20.575270>, <0.548073, 2.972963, -20.852598>, 
      <-0.327707, 2.463104, -20.097328>, <-0.052798, 2.662837, -20.253720>, <0.289100, 2.910465, -20.570123>, <0.491546, 3.057551, -20.848165>, 
      <-0.362917, 2.490077, -20.131213>, <-0.088008, 2.689810, -20.287603>, <0.244579, 2.931448, -20.596440>, <0.447025, 3.078534, -20.874482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.227931, 2.063367, -20.511070>, <0.014013, 2.239149, -20.648709>, <0.306719, 2.451812, -20.920512>, <0.484890, 2.581261, -21.165213>, 
      <-0.203223, 2.110687, -20.382840>, <0.038721, 2.286470, -20.520477>, <0.364714, 2.523574, -20.821512>, <0.542885, 2.653023, -21.066214>, 
      <-0.224190, 2.236972, -20.229224>, <0.050014, 2.436193, -20.385214>, <0.358683, 2.661601, -20.671536>, <0.560611, 2.808310, -20.948864>, 
      <-0.256130, 2.337938, -20.139344>, <0.018074, 2.537159, -20.295334>, <0.349807, 2.778177, -20.603378>, <0.551734, 2.924886, -20.880707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.471006, 1.926410, -21.254520>, <-0.293580, 2.055317, -21.355456>, <-0.078929, 2.211271, -21.554778>, <0.051730, 2.306200, -21.734224>, 
      <-0.402826, 1.974138, -21.031307>, <-0.225401, 2.103045, -21.132242>, <0.046329, 2.300469, -21.383926>, <0.176987, 2.395398, -21.563373>, 
      <-0.270307, 1.982208, -20.730997>, <-0.028363, 2.157991, -20.868635>, <0.208212, 2.329924, -21.088662>, <0.386383, 2.459373, -21.333365>, 
      <-0.227931, 2.063367, -20.511070>, <0.014013, 2.239149, -20.648709>, <0.306719, 2.451812, -20.920512>, <0.484890, 2.581261, -21.165213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.994336, 1.526853, -23.020216>, <-0.970142, 1.544431, -23.033979>, <-0.940871, 1.565698, -23.061158>, <-0.923054, 1.578642, -23.085629>, 
      <-0.837337, 1.646720, -22.490507>, <-0.813143, 1.664298, -22.504270>, <-0.648436, 1.783965, -22.655738>, <-0.630619, 1.796910, -22.680206>, 
      <-0.632805, 1.813144, -21.784237>, <-0.455379, 1.942052, -21.885171>, <-0.376167, 1.999603, -21.960205>, <-0.245508, 2.094532, -22.139653>, 
      <-0.471006, 1.926410, -21.254520>, <-0.293580, 2.055317, -21.355456>, <-0.078929, 2.211271, -21.554778>, <0.051730, 2.306200, -21.734224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.392652, 2.911032, -21.738670>, <-0.257022, 3.009573, -21.924947>, <-0.115186, 3.112623, -22.219736>, <-0.044364, 3.164078, -22.454560>, 
      <-0.696828, 2.711276, -22.142555>, <-0.561197, 2.809817, -22.328832>, <-0.509498, 2.847378, -22.438309>, <-0.438677, 2.898833, -22.673131>, 
      <-1.079171, 2.412247, -22.681541>, <-1.060623, 2.425723, -22.707016>, <-0.951029, 2.505347, -22.932726>, <-0.941345, 2.512384, -22.964838>, 
      <-1.373394, 2.198482, -23.085629>, <-1.354846, 2.211957, -23.111102>, <-1.335450, 2.226049, -23.151416>, <-1.325765, 2.233086, -23.183530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074925, 3.149613, -21.162544>, <0.260635, 3.284539, -21.417600>, <0.454841, 3.425638, -21.821235>, <0.551812, 3.496092, -22.142763>, 
      <-0.086464, 3.117419, -21.328646>, <0.099246, 3.252345, -21.583702>, <0.256974, 3.366684, -21.910856>, <0.353945, 3.437138, -22.232384>, 
      <-0.261827, 2.996947, -21.564958>, <-0.126196, 3.095489, -21.751235>, <0.054483, 3.226756, -22.125686>, <0.125304, 3.278211, -22.360510>, 
      <-0.392652, 2.911032, -21.738670>, <-0.257022, 3.009573, -21.924947>, <-0.115186, 3.112623, -22.219736>, <-0.044364, 3.164078, -22.454560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.447025, 3.078534, -20.874482>, <0.657775, 3.231653, -21.163926>, <0.878166, 3.391776, -21.621986>, <0.988212, 3.471729, -21.986866>, 
      <0.333135, 3.132212, -20.941802>, <0.543885, 3.285331, -21.231246>, <0.750542, 3.434108, -21.658054>, <0.860587, 3.514061, -22.022934>, 
      <0.173471, 3.169271, -21.061122>, <0.359181, 3.304198, -21.316178>, <0.577227, 3.462102, -21.765802>, <0.674198, 3.532556, -22.087330>, 
      <0.074925, 3.149613, -21.162544>, <0.260635, 3.284539, -21.417600>, <0.454841, 3.425638, -21.821235>, <0.551812, 3.496092, -22.142763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.551734, 2.924886, -20.880707>, <0.761943, 3.077611, -21.169408>, <0.981768, 3.237324, -21.626291>, <1.091531, 3.317071, -21.990234>, 
      <0.548073, 2.972963, -20.852598>, <0.758282, 3.125689, -21.141301>, <0.984427, 3.290876, -21.610814>, <1.094190, 3.370624, -21.974758>, 
      <0.491546, 3.057551, -20.848165>, <0.702296, 3.210669, -21.137611>, <0.929327, 3.374806, -21.607528>, <1.039373, 3.454759, -21.972408>, 
      <0.447025, 3.078534, -20.874482>, <0.657775, 3.231653, -21.163926>, <0.878166, 3.391776, -21.621986>, <0.988212, 3.471729, -21.986866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.484890, 2.581261, -21.165213>, <0.670368, 2.716019, -21.419950>, <0.864332, 2.856942, -21.823082>, <0.961181, 2.927307, -22.144206>, 
      <0.542885, 2.653023, -21.066214>, <0.728363, 2.787780, -21.320952>, <0.945217, 2.945627, -21.768974>, <1.042067, 3.015993, -22.090099>, 
      <0.560611, 2.808310, -20.948864>, <0.770819, 2.961035, -21.237566>, <0.975495, 3.110980, -21.662805>, <1.085258, 3.190728, -22.026749>, 
      <0.551734, 2.924886, -20.880707>, <0.761943, 3.077611, -21.169408>, <0.981768, 3.237324, -21.626291>, <1.091531, 3.317071, -21.990234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051730, 2.306200, -21.734224>, <0.187747, 2.405022, -21.921032>, <0.329987, 2.508365, -22.216661>, <0.401010, 2.559967, -22.452154>, 
      <0.176987, 2.395398, -21.563373>, <0.313005, 2.494220, -21.750181>, <0.493392, 2.625279, -22.124192>, <0.564415, 2.676880, -22.359683>, 
      <0.386383, 2.459373, -21.333365>, <0.571861, 2.594131, -21.588102>, <0.728452, 2.707960, -21.913976>, <0.825302, 2.778326, -22.235102>, 
      <0.484890, 2.581261, -21.165213>, <0.670368, 2.716019, -21.419950>, <0.864332, 2.856942, -21.823082>, <0.961181, 2.927307, -22.144206>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.923054, 1.578642, -23.085629>, <-0.904506, 1.592118, -23.111102>, <-0.885110, 1.606211, -23.151416>, <-0.875425, 1.613247, -23.183530>, 
      <-0.630619, 1.796910, -22.680206>, <-0.612071, 1.810385, -22.705682>, <-0.502180, 1.890226, -22.932005>, <-0.492495, 1.897263, -22.964117>, 
      <-0.245508, 2.094532, -22.139653>, <-0.109491, 2.193354, -22.326459>, <-0.057748, 2.230947, -22.436077>, <0.013275, 2.282549, -22.671570>, 
      <0.051730, 2.306200, -21.734224>, <0.187747, 2.405022, -21.921032>, <0.329987, 2.508365, -22.216661>, <0.401010, 2.559967, -22.452154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.044364, 3.164078, -22.454560>, <0.028366, 3.216920, -22.695709>, <0.077938, 3.252936, -23.041646>, <0.077938, 3.252936, -23.299010>, 
      <-0.438677, 2.898833, -22.673131>, <-0.365947, 2.951674, -22.914282>, <-0.348022, 2.964697, -23.041646>, <-0.348022, 2.964697, -23.299010>, 
      <-0.941345, 2.512384, -22.964838>, <-0.931399, 2.519610, -22.997816>, <-0.892946, 2.547547, -23.263814>, <-0.892946, 2.547547, -23.299010>, 
      <-1.325765, 2.233086, -23.183530>, <-1.315819, 2.240312, -23.216507>, <-1.309039, 2.245238, -23.263814>, <-1.309039, 2.245238, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.551812, 3.496092, -22.142763>, <0.651396, 3.568444, -22.472954>, <0.719273, 3.617759, -22.946621>, <0.719273, 3.617759, -23.299010>, 
      <0.353945, 3.437138, -22.232384>, <0.453529, 3.509490, -22.562574>, <0.508719, 3.549470, -22.946621>, <0.508719, 3.549470, -23.299010>, 
      <0.125304, 3.278211, -22.360510>, <0.198034, 3.331052, -22.601659>, <0.261262, 3.376988, -23.041646>, <0.261262, 3.376988, -23.299010>, 
      <-0.044364, 3.164078, -22.454560>, <0.028366, 3.216920, -22.695709>, <0.077938, 3.252936, -23.041646>, <0.077938, 3.252936, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988212, 3.471729, -21.986866>, <1.101222, 3.553836, -22.361576>, <1.178251, 3.609801, -22.899109>, <1.178251, 3.609801, -23.299010>, 
      <0.860587, 3.514061, -22.022934>, <0.973598, 3.596168, -22.397645>, <1.045989, 3.648168, -22.899109>, <1.045989, 3.648168, -23.299010>, 
      <0.674198, 3.532556, -22.087330>, <0.773782, 3.604908, -22.417520>, <0.850269, 3.660245, -22.946621>, <0.850269, 3.660245, -23.299010>, 
      <0.551812, 3.496092, -22.142763>, <0.651396, 3.568444, -22.472954>, <0.719273, 3.617759, -22.946621>, <0.719273, 3.617759, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.091531, 3.317071, -21.990234>, <1.204252, 3.398968, -22.363982>, <1.281083, 3.454789, -22.900134>, <1.281083, 3.454789, -23.299010>, 
      <1.094190, 3.370624, -21.974758>, <1.206911, 3.452520, -22.348507>, <1.286019, 3.510376, -22.900134>, <1.286019, 3.510376, -23.299010>, 
      <1.039373, 3.454759, -21.972408>, <1.152384, 3.536867, -22.347118>, <1.231847, 3.594254, -22.899109>, <1.231847, 3.594254, -23.299010>, 
      <0.988212, 3.471729, -21.986866>, <1.101222, 3.553836, -22.361576>, <1.178251, 3.609801, -22.899109>, <1.178251, 3.609801, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.961181, 2.927307, -22.144206>, <1.060641, 2.999569, -22.473986>, <1.128432, 3.048823, -22.947061>, <1.128432, 3.048823, -23.299010>, 
      <1.042067, 3.015993, -22.090099>, <1.141527, 3.088254, -22.419878>, <1.217553, 3.143625, -22.947061>, <1.217553, 3.143625, -23.299010>, 
      <1.085258, 3.190728, -22.026749>, <1.197979, 3.272624, -22.400498>, <1.269573, 3.325184, -22.900134>, <1.269573, 3.325184, -23.299010>, 
      <1.091531, 3.317071, -21.990234>, <1.204252, 3.398968, -22.363982>, <1.281083, 3.454789, -22.900134>, <1.281083, 3.454789, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401010, 2.559967, -22.452154>, <0.473947, 2.612958, -22.693990>, <0.523661, 2.649078, -23.040915>, <0.523661, 2.649078, -23.299010>, 
      <0.564415, 2.676880, -22.359683>, <0.637352, 2.729872, -22.601520>, <0.700464, 2.775726, -23.040915>, <0.700464, 2.775726, -23.299010>, 
      <0.825302, 2.778326, -22.235102>, <0.924762, 2.850588, -22.564880>, <0.979470, 2.890364, -22.947061>, <0.979470, 2.890364, -23.299010>, 
      <0.961181, 2.927307, -22.144206>, <1.060641, 2.999569, -22.473986>, <1.128432, 3.048823, -22.947061>, <1.128432, 3.048823, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.875425, 1.613247, -23.183530>, <-0.865479, 1.620473, -23.216507>, <-0.858700, 1.625399, -23.263814>, <-0.858700, 1.625399, -23.299010>, 
      <-0.492495, 1.897263, -22.964117>, <-0.482549, 1.904489, -22.997094>, <-0.443992, 1.932502, -23.263814>, <-0.443992, 1.932502, -23.299010>, 
      <0.013275, 2.282549, -22.671570>, <0.086212, 2.335541, -22.913406>, <0.104148, 2.348572, -23.040915>, <0.104148, 2.348572, -23.299010>, 
      <0.401010, 2.559967, -22.452154>, <0.473947, 2.612958, -22.693990>, <0.523661, 2.649078, -23.040915>, <0.523661, 2.649078, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.077938, 3.252936, -23.299010>, <0.077939, 3.252936, -23.556371>, <0.028366, 3.216920, -23.902309>, <-0.044364, 3.164078, -24.143459>, 
      <-0.348022, 2.964697, -23.299010>, <-0.348022, 2.964697, -23.556371>, <-0.365947, 2.951674, -23.683738>, <-0.438677, 2.898833, -23.924886>, 
      <-0.892946, 2.547547, -23.299010>, <-0.892946, 2.547547, -23.334203>, <-0.931399, 2.519610, -23.600203>, <-0.941344, 2.512384, -23.633181>, 
      <-1.309039, 2.245238, -23.299010>, <-1.309039, 2.245238, -23.334203>, <-1.315819, 2.240312, -23.381512>, <-1.325765, 2.233086, -23.414490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.719273, 3.617759, -23.299010>, <0.719273, 3.617759, -23.651398>, <0.651396, 3.568444, -24.125066>, <0.551812, 3.496092, -24.455256>, 
      <0.508719, 3.549470, -23.299010>, <0.508719, 3.549470, -23.651398>, <0.453529, 3.509490, -24.035442>, <0.353946, 3.437138, -24.365634>, 
      <0.261262, 3.376988, -23.299010>, <0.261262, 3.376988, -23.556371>, <0.198034, 3.331052, -23.996358>, <0.125305, 3.278211, -24.237509>, 
      <0.077938, 3.252936, -23.299010>, <0.077939, 3.252936, -23.556371>, <0.028366, 3.216920, -23.902309>, <-0.044364, 3.164078, -24.143459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.178251, 3.609801, -23.299010>, <1.178251, 3.609801, -23.698910>, <1.101222, 3.553836, -24.236443>, <0.988211, 3.471730, -24.611152>, 
      <1.045989, 3.648168, -23.299010>, <1.045989, 3.648168, -23.698910>, <0.973598, 3.596168, -24.200374>, <0.860587, 3.514062, -24.575085>, 
      <0.850269, 3.660245, -23.299010>, <0.850269, 3.660245, -23.651398>, <0.773782, 3.604908, -24.180498>, <0.674198, 3.532556, -24.510688>, 
      <0.719273, 3.617759, -23.299010>, <0.719273, 3.617759, -23.651398>, <0.651396, 3.568444, -24.125066>, <0.551812, 3.496092, -24.455256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281083, 3.454789, -23.299010>, <1.281083, 3.454789, -23.697883>, <1.204252, 3.398968, -24.234035>, <1.091532, 3.317071, -24.607784>, 
      <1.286019, 3.510376, -23.299010>, <1.286019, 3.510376, -23.697883>, <1.206911, 3.452520, -24.249512>, <1.094190, 3.370624, -24.623261>, 
      <1.231847, 3.594254, -23.299010>, <1.231847, 3.594254, -23.698910>, <1.152383, 3.536867, -24.250901>, <1.039373, 3.454760, -24.625610>, 
      <1.178251, 3.609801, -23.299010>, <1.178251, 3.609801, -23.698910>, <1.101222, 3.553836, -24.236443>, <0.988211, 3.471730, -24.611152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.128432, 3.048823, -23.299010>, <1.128432, 3.048823, -23.650957>, <1.060641, 2.999569, -24.124034>, <0.961181, 2.927308, -24.453811>, 
      <1.217553, 3.143625, -23.299010>, <1.217553, 3.143625, -23.650957>, <1.141527, 3.088254, -24.178141>, <1.042067, 3.015993, -24.507920>, 
      <1.269573, 3.325184, -23.299010>, <1.269573, 3.325184, -23.697883>, <1.197979, 3.272624, -24.197522>, <1.085259, 3.190728, -24.571270>, 
      <1.281083, 3.454789, -23.299010>, <1.281083, 3.454789, -23.697883>, <1.204252, 3.398968, -24.234035>, <1.091532, 3.317071, -24.607784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.523661, 2.649078, -23.299010>, <0.523661, 2.649078, -23.557104>, <0.473947, 2.612959, -23.904027>, <0.401010, 2.559967, -24.145864>, 
      <0.700464, 2.775726, -23.299010>, <0.700464, 2.775726, -23.557104>, <0.637352, 2.729872, -23.996498>, <0.564415, 2.676881, -24.238334>, 
      <0.979470, 2.890364, -23.299010>, <0.979470, 2.890364, -23.650957>, <0.924762, 2.850588, -24.033138>, <0.825302, 2.778326, -24.362917>, 
      <1.128432, 3.048823, -23.299010>, <1.128432, 3.048823, -23.650957>, <1.060641, 2.999569, -24.124034>, <0.961181, 2.927308, -24.453811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.858700, 1.625399, -23.299010>, <-0.858700, 1.625399, -23.334203>, <-0.865479, 1.620473, -23.381512>, <-0.875425, 1.613247, -23.414490>, 
      <-0.443992, 1.932502, -23.299010>, <-0.443992, 1.932502, -23.334203>, <-0.482549, 1.904489, -23.600923>, <-0.492495, 1.897263, -23.633901>, 
      <0.104148, 2.348572, -23.299010>, <0.104148, 2.348572, -23.557104>, <0.086212, 2.335541, -23.684613>, <0.013275, 2.282549, -23.926450>, 
      <0.523661, 2.649078, -23.299010>, <0.523661, 2.649078, -23.557104>, <0.473947, 2.612959, -23.904027>, <0.401010, 2.559967, -24.145864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.044364, 3.164078, -24.143459>, <-0.115185, 3.112623, -24.378283>, <-0.257021, 3.009574, -24.673070>, <-0.392652, 2.911032, -24.859349>, 
      <-0.438677, 2.898833, -23.924886>, <-0.509498, 2.847378, -24.159710>, <-0.561197, 2.809817, -24.269186>, <-0.696828, 2.711276, -24.455464>, 
      <-0.941344, 2.512384, -23.633181>, <-0.951029, 2.505347, -23.665293>, <-1.060623, 2.425723, -23.891003>, <-1.079171, 2.412247, -23.916477>, 
      <-1.325765, 2.233086, -23.414490>, <-1.335450, 2.226049, -23.446602>, <-1.354846, 2.211957, -23.486915>, <-1.373394, 2.198482, -23.512390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.551812, 3.496092, -24.455256>, <0.454841, 3.425638, -24.776782>, <0.216431, 3.252423, -25.140258>, <0.074926, 3.149613, -25.435474>, 
      <0.353946, 3.437138, -24.365634>, <0.256974, 3.366685, -24.687160>, <0.055042, 3.220228, -24.974157>, <-0.086464, 3.117419, -25.269374>, 
      <0.125305, 3.278211, -24.237509>, <0.054483, 3.226756, -24.472333>, <-0.126195, 3.095489, -24.846782>, <-0.261826, 2.996947, -25.033061>, 
      <-0.044364, 3.164078, -24.143459>, <-0.115185, 3.112623, -24.378283>, <-0.257021, 3.009574, -24.673070>, <-0.392652, 2.911032, -24.859349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988211, 3.471730, -24.611152>, <0.878166, 3.391776, -24.976032>, <0.612557, 3.198801, -25.392214>, <0.447025, 3.078535, -25.723536>, 
      <0.860587, 3.514062, -24.575085>, <0.750542, 3.434108, -24.939965>, <0.498668, 3.252479, -25.324894>, <0.333136, 3.132213, -25.656216>, 
      <0.674198, 3.532556, -24.510688>, <0.577227, 3.462102, -24.832216>, <0.314977, 3.272081, -25.241678>, <0.173471, 3.169271, -25.536896>, 
      <0.551812, 3.496092, -24.455256>, <0.454841, 3.425638, -24.776782>, <0.216431, 3.252423, -25.140258>, <0.074926, 3.149613, -25.435474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.091532, 3.317071, -24.607784>, <0.981768, 3.237324, -24.971728>, <0.716745, 3.044773, -25.386766>, <0.551735, 2.924886, -25.717312>, 
      <1.094190, 3.370624, -24.623261>, <0.984427, 3.290876, -24.987203>, <0.713084, 3.092851, -25.414875>, <0.548074, 2.972964, -25.745421>, 
      <1.039373, 3.454760, -24.625610>, <0.929327, 3.374807, -24.990490>, <0.657079, 3.177817, -25.418530>, <0.491547, 3.057551, -25.749851>, 
      <0.988211, 3.471730, -24.611152>, <0.878166, 3.391776, -24.976032>, <0.612557, 3.198801, -25.392214>, <0.447025, 3.078535, -25.723536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.961181, 2.927308, -24.453811>, <0.864331, 2.856942, -24.774936>, <0.626174, 2.683911, -25.137925>, <0.484890, 2.581262, -25.432806>, 
      <1.042067, 3.015993, -24.507920>, <0.945217, 2.945627, -24.829045>, <0.684170, 2.755672, -25.236923>, <0.542885, 2.653023, -25.531805>, 
      <1.085259, 3.190728, -24.571270>, <0.975495, 3.110980, -24.935213>, <0.725622, 2.928197, -25.318611>, <0.560611, 2.808310, -25.649157>, 
      <1.091532, 3.317071, -24.607784>, <0.981768, 3.237324, -24.971728>, <0.716745, 3.044773, -25.386766>, <0.551735, 2.924886, -25.717312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401010, 2.559967, -24.145864>, <0.329987, 2.508366, -24.381357>, <0.187747, 2.405022, -24.676987>, <0.051730, 2.306200, -24.863794>, 
      <0.564415, 2.676881, -24.238334>, <0.493392, 2.625279, -24.473827>, <0.313005, 2.494220, -24.847837>, <0.176987, 2.395398, -25.034645>, 
      <0.825302, 2.778326, -24.362917>, <0.728452, 2.707961, -24.684042>, <0.527668, 2.562022, -24.969773>, <0.386383, 2.459373, -25.264654>, 
      <0.961181, 2.927308, -24.453811>, <0.864331, 2.856942, -24.774936>, <0.626174, 2.683911, -25.137925>, <0.484890, 2.581262, -25.432806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.875425, 1.613247, -23.414490>, <-0.885110, 1.606211, -23.446602>, <-0.904506, 1.592118, -23.486915>, <-0.923054, 1.578642, -23.512390>, 
      <-0.492495, 1.897263, -23.633901>, <-0.502180, 1.890226, -23.666014>, <-0.612071, 1.810385, -23.892338>, <-0.630619, 1.796910, -23.917813>, 
      <0.013275, 2.282549, -23.926450>, <-0.057748, 2.230948, -24.161941>, <-0.109491, 2.193355, -24.271558>, <-0.245508, 2.094532, -24.458366>, 
      <0.401010, 2.559967, -24.145864>, <0.329987, 2.508366, -24.381357>, <0.187747, 2.405022, -24.676987>, <0.051730, 2.306200, -24.863794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.392652, 2.911032, -24.859349>, <-0.522940, 2.816373, -25.038286>, <-0.736981, 2.660863, -25.237043>, <-0.913902, 2.532322, -25.337690>, 
      <-0.696828, 2.711276, -24.455464>, <-0.827115, 2.616616, -24.634402>, <-0.867077, 2.582668, -24.694414>, <-1.043999, 2.454127, -24.795061>, 
      <-1.079171, 2.412247, -23.916477>, <-1.096988, 2.399302, -23.940947>, <-1.261249, 2.279959, -24.092006>, <-1.285444, 2.262381, -24.105770>, 
      <-1.373394, 2.198482, -23.512390>, <-1.391211, 2.185537, -23.536859>, <-1.420481, 2.164271, -23.564042>, <-1.444676, 2.146692, -23.577805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074926, 3.149613, -25.435474>, <-0.140753, 2.992913, -25.885435>, <-0.340723, 2.847627, -26.567934>, <-0.638786, 2.631071, -26.939146>, 
      <-0.086464, 3.117419, -25.269374>, <-0.302143, 2.960719, -25.719336>, <-0.471756, 2.857674, -26.097574>, <-0.769820, 2.641118, -26.468786>, 
      <-0.261826, 2.996947, -25.033061>, <-0.392114, 2.902288, -25.211998>, <-0.624220, 2.728637, -25.707363>, <-0.801142, 2.600096, -25.808010>, 
      <-0.392652, 2.911032, -24.859349>, <-0.522940, 2.816373, -25.038286>, <-0.736981, 2.660863, -25.237043>, <-0.913902, 2.532322, -25.337690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.447025, 3.078535, -25.723536>, <0.207199, 2.904291, -26.203562>, <-0.030767, 2.731398, -26.928550>, <-0.362917, 2.490077, -27.315517>, 
      <0.333136, 3.132213, -25.656216>, <0.093310, 2.957969, -26.136242>, <-0.123023, 2.802070, -26.839771>, <-0.455173, 2.560749, -27.226739>, 
      <0.173471, 3.169271, -25.536896>, <-0.042208, 3.012572, -25.986856>, <-0.301484, 2.844619, -26.708784>, <-0.599548, 2.628063, -27.079997>, 
      <0.074926, 3.149613, -25.435474>, <-0.140753, 2.992913, -25.885435>, <-0.340723, 2.847627, -26.567934>, <-0.638786, 2.631071, -26.939146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.551735, 2.924886, -25.717312>, <0.312429, 2.751020, -26.196683>, <0.075289, 2.578728, -26.920768>, <-0.256129, 2.337939, -27.307389>, 
      <0.548074, 2.972964, -25.745421>, <0.308768, 2.799098, -26.224792>, <0.062454, 2.619301, -26.956883>, <-0.268964, 2.378512, -27.343507>, 
      <0.491547, 3.057551, -25.749851>, <0.251720, 2.883307, -26.229877>, <0.004443, 2.704426, -26.962435>, <-0.327707, 2.463104, -27.349402>, 
      <0.447025, 3.078535, -25.723536>, <0.207199, 2.904291, -26.203562>, <-0.030767, 2.731398, -26.928550>, <-0.362917, 2.490077, -27.315517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.484890, 2.581262, -25.432806>, <0.269435, 2.424725, -25.882493>, <0.069815, 2.279692, -26.564592>, <-0.227931, 2.063367, -26.935661>, 
      <0.542885, 2.653023, -25.531805>, <0.327431, 2.496486, -25.981491>, <0.084605, 2.308018, -26.699766>, <-0.213141, 2.091693, -27.070835>, 
      <0.560611, 2.808310, -25.649157>, <0.321305, 2.634444, -26.128528>, <0.107229, 2.477762, -26.830886>, <-0.224189, 2.236972, -27.217507>, 
      <0.551735, 2.924886, -25.717312>, <0.312429, 2.751020, -26.196683>, <0.075289, 2.578728, -26.920768>, <-0.256129, 2.337939, -27.307389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051730, 2.306200, -24.863794>, <-0.078929, 2.211271, -25.043242>, <-0.293580, 2.055318, -25.242563>, <-0.471006, 1.926410, -25.343498>, 
      <0.176987, 2.395398, -25.034645>, <0.046329, 2.300469, -25.214093>, <-0.186960, 2.129956, -25.709699>, <-0.364385, 2.001049, -25.810635>, 
      <0.386383, 2.459373, -25.264654>, <0.170929, 2.302837, -25.714341>, <0.018180, 2.180803, -26.092672>, <-0.279566, 1.964478, -26.463741>, 
      <0.484890, 2.581262, -25.432806>, <0.269435, 2.424725, -25.882493>, <0.069815, 2.279692, -26.564592>, <-0.227931, 2.063367, -26.935661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.923054, 1.578642, -23.512390>, <-0.940871, 1.565698, -23.536859>, <-0.970142, 1.544431, -23.564042>, <-0.994336, 1.526853, -23.577805>, 
      <-0.630619, 1.796910, -23.917813>, <-0.648436, 1.783965, -23.942282>, <-0.813143, 1.664298, -24.093750>, <-0.837337, 1.646720, -24.107514>, 
      <-0.245508, 2.094532, -24.458366>, <-0.376167, 1.999603, -24.637813>, <-0.417880, 1.968303, -24.697966>, <-0.595306, 1.839395, -24.798901>, 
      <0.051730, 2.306200, -24.863794>, <-0.078929, 2.211271, -25.043242>, <-0.293580, 2.055318, -25.242563>, <-0.471006, 1.926410, -25.343498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.913902, 2.532322, -25.337690>, <-1.085508, 2.407643, -25.435314>, <-1.339850, 2.222852, -25.505661>, <-1.528759, 2.085603, -25.505661>, 
      <-1.043999, 2.454127, -24.795061>, <-1.215605, 2.329448, -24.892685>, <-1.347135, 2.232878, -24.934328>, <-1.536043, 2.095628, -24.934328>, 
      <-1.285444, 2.262381, -24.105770>, <-1.308911, 2.245331, -24.119120>, <-1.502925, 2.104372, -24.172240>, <-1.528759, 2.085602, -24.172240>, 
      <-1.444676, 2.146692, -23.577805>, <-1.468143, 2.129642, -23.591154>, <-1.502925, 2.104372, -23.600773>, <-1.528759, 2.085602, -23.600773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.638786, 2.631071, -26.939146>, <-0.831535, 2.491031, -27.179197>, <-1.207047, 2.218206, -27.372829>, <-1.480667, 2.019409, -27.372829>, 
      <-0.769820, 2.641118, -26.468786>, <-0.962568, 2.501078, -26.708837>, <-1.258293, 2.288739, -26.818962>, <-1.531912, 2.089943, -26.818962>, 
      <-0.801142, 2.600096, -25.808010>, <-0.972748, 2.475417, -25.905634>, <-1.332704, 2.213016, -26.066218>, <-1.521612, 2.075766, -26.066218>, 
      <-0.913902, 2.532322, -25.337690>, <-1.085508, 2.407643, -25.435314>, <-1.339850, 2.222852, -25.505661>, <-1.528759, 2.085603, -25.505661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.362917, 2.490077, -27.315517>, <-0.587058, 2.327229, -27.576650>, <-1.010300, 2.019726, -27.780211>, <-1.318310, 1.795944, -27.780211>, 
      <-0.455173, 2.560749, -27.226739>, <-0.679313, 2.397901, -27.487869>, <-1.076020, 2.110181, -27.683766>, <-1.384029, 1.886399, -27.683766>, 
      <-0.599548, 2.628063, -27.079997>, <-0.792296, 2.488023, -27.320048>, <-1.193551, 2.199630, -27.518691>, <-1.467171, 2.000834, -27.518691>, 
      <-0.638786, 2.631071, -26.939146>, <-0.831535, 2.491031, -27.179197>, <-1.207047, 2.218206, -27.372829>, <-1.480667, 2.019409, -27.372829>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.256129, 2.337939, -27.307389>, <-0.479590, 2.175585, -27.568070>, <-0.901804, 1.868829, -27.771411>, <-1.209069, 1.645587, -27.771411>, 
      <-0.268964, 2.378512, -27.343507>, <-0.492425, 2.216158, -27.604189>, <-0.925372, 1.901268, -27.810243>, <-1.232637, 1.678026, -27.810243>, 
      <-0.327707, 2.463104, -27.349402>, <-0.551848, 2.300257, -27.610531>, <-0.985457, 1.985532, -27.816672>, <-1.293466, 1.761750, -27.816672>, 
      <-0.362917, 2.490077, -27.315517>, <-0.587058, 2.327229, -27.576650>, <-1.010300, 2.019726, -27.780211>, <-1.318310, 1.795944, -27.780211>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.227931, 2.063367, -26.935661>, <-0.420390, 1.923538, -27.175514>, <-0.795459, 1.651035, -27.369056>, <-1.068760, 1.452469, -27.369056>, 
      <-0.213141, 2.091693, -27.070835>, <-0.405600, 1.951864, -27.310688>, <-0.802972, 1.661375, -27.508822>, <-1.076273, 1.462810, -27.508822>, 
      <-0.224189, 2.236972, -27.217507>, <-0.447650, 2.074618, -27.478192>, <-0.842542, 1.787262, -27.673770>, <-1.149808, 1.564021, -27.673770>, 
      <-0.256129, 2.337939, -27.307389>, <-0.479590, 2.175585, -27.568070>, <-0.901804, 1.868829, -27.771411>, <-1.209069, 1.645587, -27.771411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.471006, 1.926410, -25.343498>, <-0.643100, 1.801376, -25.441400>, <-0.898167, 1.616059, -25.511947>, <-1.087614, 1.478418, -25.511947>, 
      <-0.364385, 2.001049, -25.810635>, <-0.536480, 1.876015, -25.908538>, <-0.896739, 1.614094, -26.069158>, <-1.086186, 1.476453, -26.069158>, 
      <-0.279566, 1.964478, -26.463741>, <-0.472024, 1.824648, -26.703594>, <-0.765630, 1.609979, -26.814155>, <-1.038932, 1.411414, -26.814155>, 
      <-0.227931, 2.063367, -26.935661>, <-0.420390, 1.923538, -27.175514>, <-0.795459, 1.651035, -27.369056>, <-1.068760, 1.452469, -27.369056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.994336, 1.526853, -23.577805>, <-1.017804, 1.509803, -23.591154>, <-1.052586, 1.484532, -23.600773>, <-1.078419, 1.465763, -23.600773>, 
      <-0.837337, 1.646720, -24.107514>, <-0.860805, 1.629670, -24.120862>, <-1.055344, 1.488329, -24.174126>, <-1.081178, 1.469560, -24.174126>, 
      <-0.595306, 1.839395, -24.798901>, <-0.767401, 1.714361, -24.896803>, <-0.899637, 1.618082, -24.938581>, <-1.089083, 1.480441, -24.938581>, 
      <-0.471006, 1.926410, -25.343498>, <-0.643100, 1.801376, -25.441400>, <-0.898167, 1.616059, -25.511947>, <-1.087614, 1.478418, -25.511947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.528759, 2.085603, -25.505661>, <-1.717667, 1.948353, -25.505661>, <-1.972009, 1.763562, -25.435314>, <-2.143615, 1.638883, -25.337690>, 
      <-1.536043, 2.095628, -24.934328>, <-1.724951, 1.958378, -24.934328>, <-1.857440, 1.863128, -24.892685>, <-2.029046, 1.738449, -24.795061>, 
      <-1.528759, 2.085602, -24.172240>, <-1.554592, 2.066833, -24.172240>, <-1.748606, 1.925874, -24.119120>, <-1.772074, 1.908824, -24.105770>, 
      <-1.528759, 2.085602, -23.600773>, <-1.554592, 2.066833, -23.600773>, <-1.589374, 2.041563, -23.591154>, <-1.612842, 2.024513, -23.577805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.480667, 2.019409, -27.372829>, <-1.754286, 1.820613, -27.372829>, <-2.129799, 1.547787, -27.179197>, <-2.322547, 1.407748, -26.939146>, 
      <-1.531912, 2.089943, -26.818962>, <-1.805532, 1.891147, -26.818962>, <-2.098862, 1.675512, -26.708837>, <-2.291610, 1.535472, -26.468786>, 
      <-1.521612, 2.075766, -26.066218>, <-1.710520, 1.938516, -26.066218>, <-2.071311, 1.677264, -25.905634>, <-2.242917, 1.552585, -25.808010>, 
      <-1.528759, 2.085603, -25.505661>, <-1.717667, 1.948353, -25.505661>, <-1.972009, 1.763562, -25.435314>, <-2.143615, 1.638883, -25.337690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.318310, 1.795944, -27.780211>, <-1.626319, 1.572162, -27.780211>, <-2.049561, 1.264659, -27.576650>, <-2.273702, 1.101811, -27.315517>, 
      <-1.384029, 1.886399, -27.683766>, <-1.692039, 1.662617, -27.683766>, <-2.088265, 1.374238, -27.487869>, <-2.312406, 1.211390, -27.226739>, 
      <-1.467171, 2.000834, -27.518691>, <-1.740791, 1.802038, -27.518691>, <-2.139063, 1.509540, -27.320048>, <-2.331811, 1.369500, -27.079997>, 
      <-1.480667, 2.019409, -27.372829>, <-1.754286, 1.820613, -27.372829>, <-2.129799, 1.547787, -27.179197>, <-2.322547, 1.407748, -26.939146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.209069, 1.645587, -27.771411>, <-1.516334, 1.422346, -27.771411>, <-1.938548, 1.115590, -27.568070>, <-2.162009, 0.953236, -27.307389>, 
      <-1.232637, 1.678026, -27.810243>, <-1.539903, 1.454785, -27.810243>, <-1.973169, 1.140334, -27.604189>, <-2.196630, 0.977980, -27.343507>, 
      <-1.293466, 1.761750, -27.816672>, <-1.601476, 1.537968, -27.816672>, <-2.034789, 1.222836, -27.610531>, <-2.258930, 1.059989, -27.349402>, 
      <-1.318310, 1.795944, -27.780211>, <-1.626319, 1.572162, -27.780211>, <-2.049561, 1.264659, -27.576650>, <-2.273702, 1.101811, -27.315517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.068760, 1.452469, -27.369056>, <-1.342062, 1.253904, -27.369056>, <-1.717131, 0.981400, -27.175514>, <-1.909590, 0.841571, -26.935661>, 
      <-1.076273, 1.462810, -27.508822>, <-1.349575, 1.264245, -27.508822>, <-1.748640, 0.976087, -27.310688>, <-1.941099, 0.836258, -27.070835>, 
      <-1.149808, 1.564021, -27.673770>, <-1.457073, 1.340780, -27.673770>, <-1.852394, 1.054012, -27.478192>, <-2.075854, 0.891659, -27.217507>, 
      <-1.209069, 1.645587, -27.771411>, <-1.516334, 1.422346, -27.771411>, <-1.938548, 1.115590, -27.568070>, <-2.162009, 0.953236, -27.307389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.087614, 1.478418, -25.511947>, <-1.277060, 1.340777, -25.511947>, <-1.532127, 1.155461, -25.441400>, <-1.704222, 1.030426, -25.343498>, 
      <-1.086186, 1.476453, -26.069158>, <-1.275632, 1.338812, -26.069158>, <-1.636060, 1.077123, -25.908538>, <-1.808155, 0.952089, -25.810635>, 
      <-1.038932, 1.411414, -26.814155>, <-1.312234, 1.212849, -26.814155>, <-1.607125, 0.999949, -26.703594>, <-1.799584, 0.860120, -26.463741>, 
      <-1.068760, 1.452469, -27.369056>, <-1.342062, 1.253904, -27.369056>, <-1.717131, 0.981400, -27.175514>, <-1.909590, 0.841571, -26.935661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.078419, 1.465763, -23.600773>, <-1.104253, 1.446994, -23.600773>, <-1.139035, 1.421723, -23.591154>, <-1.162502, 1.404673, -23.577805>, 
      <-1.081178, 1.469560, -24.174126>, <-1.107011, 1.450791, -24.174126>, <-1.301551, 1.309449, -24.120862>, <-1.325018, 1.292399, -24.107514>, 
      <-1.089083, 1.480441, -24.938581>, <-1.278530, 1.342800, -24.938581>, <-1.410960, 1.246788, -24.896803>, <-1.583055, 1.121754, -24.798901>, 
      <-1.087614, 1.478418, -25.511947>, <-1.277060, 1.340777, -25.511947>, <-1.532127, 1.155461, -25.441400>, <-1.704222, 1.030426, -25.343498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.143615, 1.638883, -25.337690>, <-2.320537, 1.510342, -25.237043>, <-2.534578, 1.354832, -25.038286>, <-2.664865, 1.260173, -24.859349>, 
      <-2.029046, 1.738449, -24.795061>, <-2.205967, 1.609908, -24.694414>, <-2.250602, 1.582392, -24.634402>, <-2.380890, 1.487733, -24.455464>, 
      <-1.772074, 1.908824, -24.105770>, <-1.796268, 1.891245, -24.092006>, <-1.960529, 1.771903, -23.940947>, <-1.978346, 1.758958, -23.916477>, 
      <-1.612842, 2.024513, -23.577805>, <-1.637036, 2.006934, -23.564042>, <-1.666307, 1.985668, -23.536859>, <-1.684124, 1.972723, -23.512390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.322547, 1.407748, -26.939146>, <-2.620610, 1.191192, -26.567934>, <-2.820580, 1.045905, -25.885435>, <-3.036259, 0.889205, -25.435474>, 
      <-2.291610, 1.535472, -26.468786>, <-2.589674, 1.318916, -26.097574>, <-2.740089, 1.189447, -25.719336>, <-2.955768, 1.032747, -25.269374>, 
      <-2.242917, 1.552585, -25.808010>, <-2.419839, 1.424044, -25.707363>, <-2.656715, 1.256959, -25.211998>, <-2.787003, 1.162299, -25.033061>, 
      <-2.143615, 1.638883, -25.337690>, <-2.320537, 1.510342, -25.237043>, <-2.534578, 1.354832, -25.038286>, <-2.664865, 1.260173, -24.859349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.273702, 1.101811, -27.315517>, <-2.605852, 0.860490, -26.928550>, <-2.843818, 0.687597, -26.203562>, <-3.083644, 0.513353, -25.723536>, 
      <-2.312406, 1.211390, -27.226739>, <-2.644556, 0.970069, -26.839771>, <-2.859675, 0.812500, -26.136242>, <-3.099501, 0.638256, -25.656216>, 
      <-2.331811, 1.369500, -27.079997>, <-2.629874, 1.152944, -26.708784>, <-2.869728, 0.958258, -25.986856>, <-3.085407, 0.801558, -25.536896>, 
      <-2.322547, 1.407748, -26.939146>, <-2.620610, 1.191192, -26.567934>, <-2.820580, 1.045905, -25.885435>, <-3.036259, 0.889205, -25.435474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.162009, 0.953236, -27.307389>, <-2.493427, 0.712446, -26.920768>, <-2.730566, 0.540155, -26.196683>, <-2.969872, 0.366289, -25.717312>, 
      <-2.196630, 0.977980, -27.343507>, <-2.528048, 0.737191, -26.956883>, <-2.775160, 0.558493, -26.224792>, <-3.014466, 0.384627, -25.745421>, 
      <-2.258930, 1.059989, -27.349402>, <-2.591080, 0.818667, -26.962435>, <-2.837620, 0.638771, -26.229877>, <-3.077446, 0.464527, -25.749851>, 
      <-2.273702, 1.101811, -27.315517>, <-2.605852, 0.860490, -26.928550>, <-2.843818, 0.687597, -26.203562>, <-3.083644, 0.513353, -25.723536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.909590, 0.841571, -26.935661>, <-2.207336, 0.625246, -26.564592>, <-2.406956, 0.480213, -25.882493>, <-2.622410, 0.323676, -25.432806>, 
      <-1.941099, 0.836258, -27.070835>, <-2.238845, 0.619933, -26.699766>, <-2.493126, 0.447232, -25.981491>, <-2.708581, 0.290695, -25.531805>, 
      <-2.075854, 0.891659, -27.217507>, <-2.407272, 0.650869, -26.830886>, <-2.622439, 0.495689, -26.128528>, <-2.861745, 0.321823, -25.649157>, 
      <-2.162009, 0.953236, -27.307389>, <-2.493427, 0.712446, -26.920768>, <-2.730566, 0.540155, -26.196683>, <-2.969872, 0.366289, -25.717312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.704222, 1.030426, -25.343498>, <-1.881648, 0.901519, -25.242563>, <-2.096298, 0.745566, -25.043242>, <-2.226957, 0.650637, -24.863794>, 
      <-1.808155, 0.952089, -25.810635>, <-1.985580, 0.823182, -25.709699>, <-2.219838, 0.654003, -25.214093>, <-2.350496, 0.559074, -25.034645>, 
      <-1.799584, 0.860120, -26.463741>, <-2.097330, 0.643795, -26.092672>, <-2.260593, 0.536233, -25.714341>, <-2.476048, 0.379696, -25.264654>, 
      <-1.909590, 0.841571, -26.935661>, <-2.207336, 0.625246, -26.564592>, <-2.406956, 0.480213, -25.882493>, <-2.622410, 0.323676, -25.432806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.162502, 1.404673, -23.577805>, <-1.186697, 1.387095, -23.564042>, <-1.215967, 1.365829, -23.536859>, <-1.233784, 1.352884, -23.512390>, 
      <-1.325018, 1.292399, -24.107514>, <-1.349213, 1.274821, -24.093750>, <-1.513919, 1.155155, -23.942282>, <-1.531736, 1.142210, -23.917813>, 
      <-1.583055, 1.121754, -24.798901>, <-1.760481, 0.992846, -24.697966>, <-1.803139, 0.962847, -24.637813>, <-1.933798, 0.867918, -24.458366>, 
      <-1.704222, 1.030426, -25.343498>, <-1.881648, 0.901519, -25.242563>, <-2.096298, 0.745566, -25.043242>, <-2.226957, 0.650637, -24.863794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.664865, 1.260173, -24.859349>, <-2.800496, 1.161631, -24.673070>, <-2.942332, 1.058581, -24.378283>, <-3.013153, 1.007127, -24.143459>, 
      <-2.380890, 1.487733, -24.455464>, <-2.516521, 1.389191, -24.269186>, <-2.568219, 1.351630, -24.159710>, <-2.639040, 1.300175, -23.924886>, 
      <-1.978346, 1.758958, -23.916477>, <-1.996894, 1.745482, -23.891003>, <-2.106488, 1.665857, -23.665293>, <-2.116173, 1.658821, -23.633181>, 
      <-1.684124, 1.972723, -23.512390>, <-1.702672, 1.959247, -23.486915>, <-1.722068, 1.945155, -23.446602>, <-1.731753, 1.938118, -23.414490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.036259, 0.889205, -25.435474>, <-3.177765, 0.786396, -25.140258>, <-3.416175, 0.613181, -24.776782>, <-3.513146, 0.542727, -24.455256>, 
      <-2.955768, 1.032747, -25.269374>, <-3.097274, 0.929937, -24.974157>, <-3.298962, 0.783145, -24.687160>, <-3.395933, 0.712692, -24.365634>, 
      <-2.787003, 1.162299, -25.033061>, <-2.922634, 1.063757, -24.846782>, <-3.103308, 0.932486, -24.472333>, <-3.174130, 0.881031, -24.237509>, 
      <-2.664865, 1.260173, -24.859349>, <-2.800496, 1.161631, -24.673070>, <-2.942332, 1.058581, -24.378283>, <-3.013153, 1.007127, -24.143459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.083644, 0.513353, -25.723536>, <-3.249176, 0.393087, -25.392214>, <-3.514785, 0.200111, -24.976032>, <-3.624831, 0.120158, -24.611155>, 
      <-3.099501, 0.638256, -25.656216>, <-3.265033, 0.517990, -25.324894>, <-3.515607, 0.334570, -24.939965>, <-3.625653, 0.254617, -24.575086>, 
      <-3.085407, 0.801558, -25.536896>, <-3.226913, 0.698748, -25.241678>, <-3.488674, 0.508053, -24.832216>, <-3.585645, 0.437599, -24.510688>, 
      <-3.036259, 0.889205, -25.435474>, <-3.177765, 0.786396, -25.140258>, <-3.416175, 0.613181, -24.776782>, <-3.513146, 0.542727, -24.455256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.969872, 0.366289, -25.717312>, <-3.134883, 0.246402, -25.386766>, <-3.399906, 0.053851, -24.971728>, <-3.509670, -0.025897, -24.607786>, 
      <-3.014466, 0.384627, -25.745421>, <-3.179476, 0.264740, -25.414875>, <-3.451660, 0.067871, -24.987205>, <-3.561423, -0.011877, -24.623264>, 
      <-3.077446, 0.464527, -25.749851>, <-3.242978, 0.344261, -25.418530>, <-3.514456, 0.146210, -24.990491>, <-3.624501, 0.066257, -24.625614>, 
      <-3.083644, 0.513353, -25.723536>, <-3.249176, 0.393087, -25.392214>, <-3.514785, 0.200111, -24.976032>, <-3.624831, 0.120158, -24.611155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.622410, 0.323676, -25.432806>, <-2.763695, 0.221027, -25.137925>, <-3.001852, 0.047996, -24.774936>, <-3.098702, -0.022370, -24.453811>, 
      <-2.708581, 0.290695, -25.531805>, <-2.849865, 0.188045, -25.236923>, <-3.111192, -0.001526, -24.829045>, <-3.208042, -0.071892, -24.507920>, 
      <-2.861745, 0.321823, -25.649157>, <-3.026755, 0.201936, -25.318611>, <-3.277808, 0.020774, -24.935213>, <-3.387571, -0.058973, -24.571272>, 
      <-2.969872, 0.366289, -25.717312>, <-3.134883, 0.246402, -25.386766>, <-3.399906, 0.053851, -24.971728>, <-3.509670, -0.025897, -24.607786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.226957, 0.650637, -24.863794>, <-2.362974, 0.551815, -24.676987>, <-2.505214, 0.448471, -24.381357>, <-2.576238, 0.396870, -24.145864>, 
      <-2.350496, 0.559074, -25.034645>, <-2.486514, 0.460251, -24.847837>, <-2.666901, 0.329192, -24.473827>, <-2.737924, 0.277591, -24.238334>, 
      <-2.476048, 0.379696, -25.264654>, <-2.617332, 0.277047, -24.969773>, <-2.818173, 0.131187, -24.684040>, <-2.915023, 0.060821, -24.362915>, 
      <-2.622410, 0.323676, -25.432806>, <-2.763695, 0.221027, -25.137925>, <-3.001852, 0.047996, -24.774936>, <-3.098702, -0.022370, -24.453811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.233784, 1.352884, -23.512390>, <-1.252332, 1.339408, -23.486915>, <-1.271728, 1.325316, -23.446602>, <-1.281413, 1.318279, -23.414490>, 
      <-1.531736, 1.142210, -23.917813>, <-1.550284, 1.128734, -23.892338>, <-1.660176, 1.048893, -23.666014>, <-1.669861, 1.041856, -23.633901>, 
      <-1.933798, 0.867918, -24.458366>, <-2.069815, 0.769096, -24.271558>, <-2.121558, 0.731503, -24.161941>, <-2.192581, 0.679901, -23.926450>, 
      <-2.226957, 0.650637, -24.863794>, <-2.362974, 0.551815, -24.676987>, <-2.505214, 0.448471, -24.381357>, <-2.576238, 0.396870, -24.145864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.013153, 1.007127, -24.143459>, <-3.085883, 0.954285, -23.902309>, <-3.135456, 0.918269, -23.556371>, <-3.135456, 0.918268, -23.299010>, 
      <-2.639040, 1.300175, -23.924886>, <-2.711770, 1.247333, -23.683738>, <-2.729695, 1.234310, -23.556371>, <-2.729695, 1.234310, -23.299010>, 
      <-2.116173, 1.658821, -23.633181>, <-2.126119, 1.651595, -23.600203>, <-2.164572, 1.623658, -23.334203>, <-2.164572, 1.623658, -23.299010>, 
      <-1.731753, 1.938118, -23.414490>, <-1.741699, 1.930892, -23.381512>, <-1.748478, 1.925967, -23.334203>, <-1.748478, 1.925967, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.513146, 0.542727, -24.455256>, <-3.612730, 0.470375, -24.125066>, <-3.680606, 0.421060, -23.651398>, <-3.680606, 0.421060, -23.299010>, 
      <-3.395933, 0.712692, -24.365634>, <-3.495517, 0.640340, -24.035442>, <-3.550594, 0.600206, -23.651398>, <-3.550594, 0.600206, -23.299010>, 
      <-3.174130, 0.881031, -24.237509>, <-3.246860, 0.828190, -23.996358>, <-3.310086, 0.782251, -23.556371>, <-3.310086, 0.782251, -23.299010>, 
      <-3.013153, 1.007127, -24.143459>, <-3.085883, 0.954285, -23.902309>, <-3.135456, 0.918269, -23.556371>, <-3.135456, 0.918268, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.624831, 0.120158, -24.611155>, <-3.737842, 0.038051, -24.236445>, <-3.814870, -0.017913, -23.698912>, <-3.814870, -0.017913, -23.299010>, 
      <-3.625653, 0.254617, -24.575086>, <-3.738664, 0.172510, -24.200376>, <-3.810488, 0.119731, -23.698912>, <-3.810488, 0.119731, -23.299010>, 
      <-3.585645, 0.437599, -24.510688>, <-3.685228, 0.365247, -24.180498>, <-3.761493, 0.309604, -23.651398>, <-3.761493, 0.309604, -23.299010>, 
      <-3.513146, 0.542727, -24.455256>, <-3.612730, 0.470375, -24.125066>, <-3.680606, 0.421060, -23.651398>, <-3.680606, 0.421060, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.509670, -0.025897, -24.607786>, <-3.622390, -0.107793, -24.234037>, <-3.699221, -0.163614, -23.697883>, <-3.699221, -0.163614, -23.299010>, 
      <-3.561423, -0.011877, -24.623264>, <-3.674144, -0.093773, -24.249515>, <-3.753613, -0.151132, -23.697883>, <-3.753613, -0.151132, -23.299010>, 
      <-3.624501, 0.066257, -24.625614>, <-3.737512, -0.015850, -24.250904>, <-3.816646, -0.073691, -23.698912>, <-3.816646, -0.073691, -23.299010>, 
      <-3.624831, 0.120158, -24.611155>, <-3.737842, 0.038051, -24.236445>, <-3.814870, -0.017913, -23.698912>, <-3.814870, -0.017913, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.098702, -0.022370, -24.453811>, <-3.198162, -0.094632, -24.124034>, <-3.265953, -0.143885, -23.650957>, <-3.265953, -0.143885, -23.299010>, 
      <-3.208042, -0.071892, -24.507920>, <-3.307502, -0.144153, -24.178141>, <-3.383655, -0.199348, -23.650957>, <-3.383655, -0.199348, -23.299010>, 
      <-3.387571, -0.058973, -24.571272>, <-3.500292, -0.140870, -24.197523>, <-3.572403, -0.192718, -23.697883>, <-3.572403, -0.192718, -23.299010>, 
      <-3.509670, -0.025897, -24.607786>, <-3.622390, -0.107793, -24.234037>, <-3.699221, -0.163614, -23.697883>, <-3.699221, -0.163614, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.576238, 0.396870, -24.145864>, <-2.649175, 0.343878, -23.904027>, <-2.698889, 0.307759, -23.557104>, <-2.698889, 0.307759, -23.299010>, 
      <-2.737924, 0.277591, -24.238334>, <-2.810861, 0.224599, -23.996498>, <-2.873973, 0.178745, -23.557104>, <-2.873973, 0.178745, -23.299010>, 
      <-2.915023, 0.060821, -24.362915>, <-3.014483, -0.011441, -24.033136>, <-3.069218, -0.051180, -23.650957>, <-3.069218, -0.051180, -23.299010>, 
      <-3.098702, -0.022370, -24.453811>, <-3.198162, -0.094632, -24.124034>, <-3.265953, -0.143885, -23.650957>, <-3.265953, -0.143885, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.281413, 1.318279, -23.414490>, <-1.291359, 1.311053, -23.381512>, <-1.298139, 1.306128, -23.334203>, <-1.298139, 1.306128, -23.299010>, 
      <-1.669861, 1.041856, -23.633901>, <-1.679807, 1.034630, -23.600923>, <-1.718364, 1.006617, -23.334203>, <-1.718364, 1.006617, -23.299010>, 
      <-2.192581, 0.679901, -23.926450>, <-2.265518, 0.626909, -23.684613>, <-2.283453, 0.613878, -23.557104>, <-2.283453, 0.613878, -23.299010>, 
      <-2.576238, 0.396870, -24.145864>, <-2.649175, 0.343878, -23.904027>, <-2.698889, 0.307759, -23.557104>, <-2.698889, 0.307759, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.135456, 0.918268, -23.299010>, <-3.135456, 0.918268, -23.041646>, <-3.085884, 0.954285, -22.695709>, <-3.013154, 1.007126, -22.454560>, 
      <-2.729695, 1.234310, -23.299010>, <-2.729695, 1.234310, -23.041646>, <-2.711771, 1.247333, -22.914282>, <-2.639041, 1.300175, -22.673131>, 
      <-2.164572, 1.623658, -23.299010>, <-2.164572, 1.623658, -23.263814>, <-2.126119, 1.651595, -22.997816>, <-2.116173, 1.658821, -22.964838>, 
      <-1.748478, 1.925967, -23.299010>, <-1.748478, 1.925967, -23.263814>, <-1.741699, 1.930892, -23.216507>, <-1.731753, 1.938118, -23.183530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.680606, 0.421060, -23.299010>, <-3.680606, 0.421060, -22.946621>, <-3.612730, 0.470375, -22.472954>, <-3.513146, 0.542727, -22.142763>, 
      <-3.550594, 0.600206, -23.299010>, <-3.550594, 0.600206, -22.946621>, <-3.495518, 0.640340, -22.562576>, <-3.395934, 0.712692, -22.232386>, 
      <-3.310086, 0.782251, -23.299010>, <-3.310086, 0.782251, -23.041646>, <-3.246860, 0.828190, -22.601659>, <-3.174130, 0.881031, -22.360510>, 
      <-3.135456, 0.918268, -23.299010>, <-3.135456, 0.918268, -23.041646>, <-3.085884, 0.954285, -22.695709>, <-3.013154, 1.007126, -22.454560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.814870, -0.017913, -23.299010>, <-3.814870, -0.017913, -22.899109>, <-3.737841, 0.038051, -22.361576>, <-3.624830, 0.120158, -21.986866>, 
      <-3.810488, 0.119731, -23.299010>, <-3.810488, 0.119731, -22.899109>, <-3.738664, 0.172510, -22.397645>, <-3.625652, 0.254617, -22.022934>, 
      <-3.761493, 0.309604, -23.299010>, <-3.761493, 0.309604, -22.946621>, <-3.685229, 0.365247, -22.417520>, <-3.585645, 0.437599, -22.087330>, 
      <-3.680606, 0.421060, -23.299010>, <-3.680606, 0.421060, -22.946621>, <-3.612730, 0.470375, -22.472954>, <-3.513146, 0.542727, -22.142763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.699221, -0.163614, -23.299010>, <-3.699221, -0.163614, -22.900134>, <-3.622391, -0.107793, -22.363982>, <-3.509670, -0.025897, -21.990234>, 
      <-3.753613, -0.151132, -23.299010>, <-3.753613, -0.151132, -22.900134>, <-3.674144, -0.093773, -22.348507>, <-3.561423, -0.011877, -21.974758>, 
      <-3.816646, -0.073691, -23.299010>, <-3.816646, -0.073691, -22.899109>, <-3.737512, -0.015850, -22.347118>, <-3.624501, 0.066257, -21.972408>, 
      <-3.814870, -0.017913, -23.299010>, <-3.814870, -0.017913, -22.899109>, <-3.737841, 0.038051, -22.361576>, <-3.624830, 0.120158, -21.986866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.265953, -0.143885, -23.299010>, <-3.265953, -0.143885, -22.947061>, <-3.198162, -0.094632, -22.473986>, <-3.098702, -0.022370, -22.144206>, 
      <-3.383655, -0.199348, -23.299010>, <-3.383655, -0.199348, -22.947061>, <-3.307502, -0.144154, -22.419878>, <-3.208042, -0.071892, -22.090099>, 
      <-3.572403, -0.192718, -23.299010>, <-3.572403, -0.192718, -22.900134>, <-3.500292, -0.140870, -22.400498>, <-3.387572, -0.058973, -22.026749>, 
      <-3.699221, -0.163614, -23.299010>, <-3.699221, -0.163614, -22.900134>, <-3.622391, -0.107793, -22.363982>, <-3.509670, -0.025897, -21.990234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.698889, 0.307759, -23.299010>, <-2.698889, 0.307759, -23.040915>, <-2.649175, 0.343878, -22.693990>, <-2.576238, 0.396870, -22.452154>, 
      <-2.873973, 0.178745, -23.299010>, <-2.873973, 0.178745, -23.040915>, <-2.810861, 0.224599, -22.601520>, <-2.737924, 0.277590, -22.359683>, 
      <-3.069218, -0.051180, -23.299010>, <-3.069218, -0.051180, -22.947061>, <-3.014483, -0.011441, -22.564880>, <-2.915023, 0.060821, -22.235102>, 
      <-3.265953, -0.143885, -23.299010>, <-3.265953, -0.143885, -22.947061>, <-3.198162, -0.094632, -22.473986>, <-3.098702, -0.022370, -22.144206>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.298139, 1.306128, -23.299010>, <-1.298139, 1.306128, -23.263814>, <-1.291359, 1.311053, -23.216507>, <-1.281413, 1.318279, -23.183530>, 
      <-1.718364, 1.006617, -23.299010>, <-1.718364, 1.006617, -23.263814>, <-1.679807, 1.034630, -22.997094>, <-1.669861, 1.041856, -22.964117>, 
      <-2.283453, 0.613878, -23.299010>, <-2.283453, 0.613878, -23.040915>, <-2.265518, 0.626909, -22.913406>, <-2.192581, 0.679901, -22.671570>, 
      <-2.698889, 0.307759, -23.299010>, <-2.698889, 0.307759, -23.040915>, <-2.649175, 0.343878, -22.693990>, <-2.576238, 0.396870, -22.452154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.273614, -1.387145, -22.454560>, <-1.202792, -1.335690, -22.219736>, <-1.060957, -1.232640, -21.924947>, <-0.925326, -1.134099, -21.738670>, 
      <-0.879301, -1.121899, -22.673131>, <-0.808480, -1.070445, -22.438309>, <-0.756781, -1.032884, -22.328832>, <-0.621150, -0.934342, -22.142555>, 
      <-0.376633, -0.735451, -22.964838>, <-0.366948, -0.728414, -22.932726>, <-0.257354, -0.648789, -22.707016>, <-0.238806, -0.635313, -22.681541>, 
      <0.007787, -0.456153, -23.183530>, <0.017472, -0.449116, -23.151416>, <0.036868, -0.435024, -23.111102>, <0.055416, -0.421548, -23.085629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.869790, -1.719159, -22.142763>, <-1.772819, -1.648705, -21.821235>, <-1.578613, -1.507606, -21.417603>, <-1.392903, -1.372680, -21.162546>, 
      <-1.671923, -1.660205, -22.232386>, <-1.574953, -1.589752, -21.910858>, <-1.417224, -1.475411, -21.583702>, <-1.231514, -1.340485, -21.328646>, 
      <-1.443282, -1.501277, -22.360510>, <-1.372461, -1.449823, -22.125686>, <-1.191782, -1.318555, -21.751238>, <-1.056151, -1.220014, -21.564960>, 
      <-1.273614, -1.387145, -22.454560>, <-1.202792, -1.335690, -22.219736>, <-1.060957, -1.232640, -21.924947>, <-0.925326, -1.134099, -21.738670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.306190, -1.694796, -21.986866>, <-2.196144, -1.614843, -21.621989>, <-1.975753, -1.454719, -21.163930>, <-1.765003, -1.301601, -20.874485>, 
      <-2.178566, -1.737128, -22.022934>, <-2.068520, -1.657175, -21.658056>, <-1.861863, -1.508398, -21.231250>, <-1.651114, -1.355279, -20.941805>, 
      <-1.992176, -1.755623, -22.087330>, <-1.895205, -1.685169, -21.765802>, <-1.677159, -1.527264, -21.316181>, <-1.491449, -1.392338, -21.061125>, 
      <-1.869790, -1.719159, -22.142763>, <-1.772819, -1.648705, -21.821235>, <-1.578613, -1.507606, -21.417603>, <-1.392903, -1.372680, -21.162546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.409509, -1.540138, -21.990234>, <-2.299746, -1.460390, -21.626291>, <-2.079921, -1.300678, -21.169408>, <-1.869712, -1.147953, -20.880707>, 
      <-2.412168, -1.593691, -21.974758>, <-2.302405, -1.513943, -21.610814>, <-2.076260, -1.348756, -21.141301>, <-1.866052, -1.196030, -20.852598>, 
      <-2.357351, -1.677826, -21.972408>, <-2.247305, -1.597873, -21.607531>, <-2.020274, -1.433736, -21.137613>, <-1.809524, -1.280618, -20.848170>, 
      <-2.306190, -1.694796, -21.986866>, <-2.196144, -1.614843, -21.621989>, <-1.975753, -1.454719, -21.163930>, <-1.765003, -1.301601, -20.874485>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.279159, -1.150374, -22.144206>, <-2.182309, -1.080009, -21.823082>, <-1.988345, -0.939086, -21.419952>, <-1.802868, -0.804328, -21.165214>, 
      <-2.360045, -1.239060, -22.090099>, <-2.263195, -1.168694, -21.768974>, <-2.046341, -1.010847, -21.320954>, <-1.860863, -0.876090, -21.066216>, 
      <-2.403236, -1.413795, -22.026749>, <-2.293473, -1.334047, -21.662805>, <-2.088797, -1.184101, -21.237565>, <-1.878589, -1.031376, -20.948862>, 
      <-2.409509, -1.540138, -21.990234>, <-2.299746, -1.460390, -21.626291>, <-2.079921, -1.300678, -21.169408>, <-1.869712, -1.147953, -20.880707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.718988, -0.783034, -22.452154>, <-1.647965, -0.731432, -22.216661>, <-1.505724, -0.628089, -21.921034>, <-1.369708, -0.529266, -21.734226>, 
      <-1.882393, -0.899947, -22.359683>, <-1.811370, -0.848346, -22.124192>, <-1.630982, -0.717287, -21.750182>, <-1.494965, -0.618465, -21.563376>, 
      <-2.143280, -1.001393, -22.235102>, <-2.046430, -0.931028, -21.913976>, <-1.889839, -0.817198, -21.588104>, <-1.704361, -0.682440, -21.333366>, 
      <-2.279159, -1.150374, -22.144206>, <-2.182309, -1.080009, -21.823082>, <-1.988345, -0.939086, -21.419952>, <-1.802868, -0.804328, -21.165214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.442553, 0.163686, -23.183530>, <-0.432868, 0.170723, -23.151416>, <-0.413471, 0.184815, -23.111102>, <-0.394923, 0.198291, -23.085630>, 
      <-0.825483, -0.120330, -22.964117>, <-0.815798, -0.113293, -22.932005>, <-0.705906, -0.033452, -22.705682>, <-0.687359, -0.019976, -22.680208>, 
      <-1.331253, -0.505616, -22.671570>, <-1.260230, -0.454014, -22.436077>, <-1.208487, -0.416421, -22.326462>, <-1.072470, -0.317599, -22.139654>, 
      <-1.718988, -0.783034, -22.452154>, <-1.647965, -0.731432, -22.216661>, <-1.505724, -0.628089, -21.921034>, <-1.369708, -0.529266, -21.734226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.925326, -1.134099, -21.738670>, <-0.795038, -1.039439, -21.559733>, <-0.580997, -0.883930, -21.360976>, <-0.404076, -0.755388, -21.260328>, 
      <-0.621150, -0.934342, -22.142555>, <-0.490862, -0.839683, -21.963618>, <-0.411739, -0.782197, -21.888696>, <-0.234817, -0.653656, -21.788050>, 
      <-0.238806, -0.635313, -22.681541>, <-0.220989, -0.622369, -22.657072>, <-0.056728, -0.503026, -22.506014>, <-0.032534, -0.485448, -22.492251>, 
      <0.055416, -0.421548, -23.085629>, <0.073233, -0.408604, -23.061158>, <0.102504, -0.387337, -23.033979>, <0.126698, -0.369759, -23.020216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.392903, -1.372680, -21.162546>, <-1.214509, -1.243069, -20.917538>, <-0.921439, -1.030140, -20.645394>, <-0.679192, -0.854138, -20.507584>, 
      <-1.231514, -1.340485, -21.328646>, <-1.053120, -1.210874, -21.083637>, <-0.815259, -1.038281, -20.862984>, <-0.573012, -0.862279, -20.725174>, 
      <-1.056151, -1.220014, -21.564960>, <-0.925864, -1.125354, -21.386022>, <-0.653768, -0.927668, -21.134088>, <-0.476846, -0.799127, -21.033442>, 
      <-0.925326, -1.134099, -21.738670>, <-0.795038, -1.039439, -21.559733>, <-0.580997, -0.883930, -21.360976>, <-0.404076, -0.755388, -21.260328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.765003, -1.301601, -20.874485>, <-1.562556, -1.154515, -20.596443>, <-1.229970, -0.912877, -20.287605>, <-0.955061, -0.713144, -20.131214>, 
      <-1.651114, -1.355279, -20.941805>, <-1.448667, -1.208193, -20.663763>, <-1.137715, -0.983549, -20.376384>, <-0.862806, -0.783815, -20.219994>, 
      <-1.491449, -1.392338, -21.061125>, <-1.313055, -1.262727, -20.816117>, <-0.985538, -1.025226, -20.514037>, <-0.743291, -0.849223, -20.376227>, 
      <-1.392903, -1.372680, -21.162546>, <-1.214509, -1.243069, -20.917538>, <-0.921439, -1.030140, -20.645394>, <-0.679192, -0.854138, -20.507584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.869712, -1.147953, -20.880707>, <-1.667785, -1.001244, -20.603378>, <-1.336052, -0.760226, -20.295334>, <-1.061849, -0.561005, -20.139344>, 
      <-1.866052, -1.196030, -20.852598>, <-1.664124, -1.049322, -20.575270>, <-1.323217, -0.800799, -20.259216>, <-1.049014, -0.601578, -20.103226>, 
      <-1.809524, -1.280618, -20.848170>, <-1.607077, -1.133532, -20.570128>, <-1.265180, -0.885904, -20.253722>, <-0.990271, -0.686171, -20.097330>, 
      <-1.765003, -1.301601, -20.874485>, <-1.562556, -1.154515, -20.596443>, <-1.229970, -0.912877, -20.287605>, <-0.955061, -0.713144, -20.131214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.802868, -0.804328, -21.165214>, <-1.624697, -0.674879, -20.920514>, <-1.331991, -0.462216, -20.648709>, <-1.090047, -0.286434, -20.511070>, 
      <-1.860863, -0.876090, -21.066216>, <-1.682692, -0.746641, -20.821514>, <-1.356699, -0.509537, -20.520477>, <-1.114755, -0.333754, -20.382840>, 
      <-1.878589, -1.031376, -20.948862>, <-1.676662, -0.884667, -20.671533>, <-1.367992, -0.659259, -20.385214>, <-1.093789, -0.460039, -20.229224>, 
      <-1.869712, -1.147953, -20.880707>, <-1.667785, -1.001244, -20.603378>, <-1.336052, -0.760226, -20.295334>, <-1.061849, -0.561005, -20.139344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.369708, -0.529266, -21.734226>, <-1.239049, -0.434337, -21.554779>, <-1.024398, -0.278384, -21.355456>, <-0.846972, -0.149477, -21.254520>, 
      <-1.494965, -0.618465, -21.563376>, <-1.364306, -0.523535, -21.383928>, <-1.092578, -0.326113, -21.132242>, <-0.915152, -0.197205, -21.031307>, 
      <-1.704361, -0.682440, -21.333366>, <-1.526190, -0.552991, -21.088666>, <-1.289615, -0.381058, -20.868635>, <-1.047671, -0.205275, -20.730997>, 
      <-1.802868, -0.804328, -21.165214>, <-1.624697, -0.674879, -20.920514>, <-1.331991, -0.462216, -20.648709>, <-1.090047, -0.286434, -20.511070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.394923, 0.198291, -23.085630>, <-0.377106, 0.211236, -23.061162>, <-0.347836, 0.232502, -23.033979>, <-0.323641, 0.250080, -23.020216>, 
      <-0.687359, -0.019976, -22.680208>, <-0.669542, -0.007031, -22.655739>, <-0.504835, 0.112635, -22.504270>, <-0.480641, 0.130213, -22.490507>, 
      <-1.072470, -0.317599, -22.139654>, <-0.941811, -0.222670, -21.960206>, <-0.862599, -0.165119, -21.885171>, <-0.685173, -0.036211, -21.784237>, 
      <-1.369708, -0.529266, -21.734226>, <-1.239049, -0.434337, -21.554779>, <-1.024398, -0.278384, -21.355456>, <-0.846972, -0.149477, -21.254520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.404076, -0.755388, -21.260328>, <-0.232470, -0.630709, -21.162704>, <0.021873, -0.445919, -21.092358>, <0.210781, -0.308669, -21.092358>, 
      <-0.234817, -0.653656, -21.788050>, <-0.063211, -0.528977, -21.690426>, <0.031973, -0.459821, -21.663566>, <0.220882, -0.322572, -21.663566>, 
      <-0.032534, -0.485448, -22.492251>, <-0.009066, -0.468398, -22.478901>, <0.184947, -0.327438, -22.425779>, <0.210781, -0.308669, -22.425779>, 
      <0.126698, -0.369759, -23.020216>, <0.150166, -0.352709, -23.006867>, <0.184948, -0.327438, -22.997246>, <0.210781, -0.308669, -22.997246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.679192, -0.854138, -20.507584>, <-0.444224, -0.683424, -20.373915>, <-0.095970, -0.430403, -20.277594>, <0.162689, -0.242476, -20.277594>, 
      <-0.573012, -0.862279, -20.725174>, <-0.338044, -0.691565, -20.591506>, <-0.055375, -0.486277, -20.513344>, <0.203284, -0.298351, -20.513344>, 
      <-0.476846, -0.799127, -21.033442>, <-0.305240, -0.674448, -20.935818>, <0.017531, -0.439943, -20.846810>, <0.206439, -0.302693, -20.846810>, 
      <-0.404076, -0.755388, -21.260328>, <-0.232470, -0.630709, -21.162704>, <0.021873, -0.445919, -21.092358>, <0.210781, -0.308669, -21.092358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.955061, -0.713144, -20.131214>, <-0.688412, -0.519412, -19.979520>, <-0.293203, -0.232276, -19.870211>, <0.000331, -0.019011, -19.870211>, 
      <-0.862806, -0.783815, -20.219994>, <-0.596156, -0.590083, -20.068301>, <-0.227483, -0.322731, -19.966658>, <0.066051, -0.109466, -19.966658>, 
      <-0.743291, -0.849223, -20.376227>, <-0.508323, -0.678509, -20.242557>, <-0.120371, -0.396818, -20.135891>, <0.138288, -0.208891, -20.135891>, 
      <-0.679192, -0.854138, -20.507584>, <-0.444224, -0.683424, -20.373915>, <-0.095970, -0.430403, -20.277594>, <0.162689, -0.242476, -20.277594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.061849, -0.561005, -20.139344>, <-0.795884, -0.367771, -19.988042>, <-0.401690, -0.081372, -19.879013>, <-0.108909, 0.131346, -19.879013>, 
      <-1.049014, -0.601578, -20.103226>, <-0.783049, -0.408344, -19.951923>, <-0.378122, -0.113811, -19.840181>, <-0.085341, 0.098907, -19.840181>, 
      <-0.990271, -0.686171, -20.097330>, <-0.723622, -0.492439, -19.945637>, <-0.318046, -0.198082, -19.833752>, <-0.024512, 0.015183, -19.833752>, 
      <-0.955061, -0.713144, -20.131214>, <-0.688412, -0.519412, -19.979520>, <-0.293203, -0.232276, -19.870211>, <0.000331, -0.019011, -19.870211>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.090047, -0.286434, -20.511070>, <-0.855372, -0.115933, -20.377568>, <-0.507554, 0.136772, -20.281365>, <-0.249218, 0.324464, -20.281365>, 
      <-1.114755, -0.333754, -20.382840>, <-0.880080, -0.163253, -20.249336>, <-0.493634, 0.117613, -20.143026>, <-0.235298, 0.305306, -20.143026>, 
      <-1.093789, -0.460039, -20.229224>, <-0.827824, -0.266804, -20.077922>, <-0.460951, 0.000195, -19.976650>, <-0.168170, 0.212912, -19.976650>, 
      <-1.061849, -0.561005, -20.139344>, <-0.795884, -0.367771, -19.988042>, <-0.401690, -0.081372, -19.879013>, <-0.108909, 0.131346, -19.879013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.846972, -0.149477, -21.254520>, <-0.674878, -0.024443, -21.156618>, <-0.419811, 0.160874, -21.086070>, <-0.230364, 0.298515, -21.086070>, 
      <-0.915152, -0.197205, -21.031307>, <-0.743057, -0.072171, -20.933405>, <-0.420670, 0.162057, -20.844470>, <-0.231223, 0.299698, -20.844470>, 
      <-1.047671, -0.205275, -20.730997>, <-0.812996, -0.034774, -20.597494>, <-0.531516, 0.169753, -20.519504>, <-0.273180, 0.357445, -20.519504>, 
      <-1.090047, -0.286434, -20.511070>, <-0.855372, -0.115933, -20.377568>, <-0.507554, 0.136772, -20.281365>, <-0.249218, 0.324464, -20.281365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.323641, 0.250080, -23.020216>, <-0.300174, 0.267130, -23.006867>, <-0.265392, 0.292401, -22.997246>, <-0.239558, 0.311170, -22.997246>, 
      <-0.480641, 0.130213, -22.490507>, <-0.457173, 0.147263, -22.477157>, <-0.262634, 0.288604, -22.423893>, <-0.236800, 0.307374, -22.423893>, 
      <-0.685173, -0.036211, -21.784237>, <-0.513078, 0.088823, -21.686334>, <-0.417771, 0.158068, -21.659432>, <-0.228325, 0.295708, -21.659432>, 
      <-0.846972, -0.149477, -21.254520>, <-0.674878, -0.024443, -21.156618>, <-0.419811, 0.160874, -21.086070>, <-0.230364, 0.298515, -21.086070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.210781, -0.308669, -21.092358>, <0.399689, -0.171419, -21.092358>, <0.654031, 0.013371, -21.162704>, <0.825637, 0.138050, -21.260328>, 
      <0.220882, -0.322572, -21.663566>, <0.409790, -0.185322, -21.663566>, <0.504974, -0.116166, -21.690424>, <0.676580, 0.008513, -21.788048>, 
      <0.210781, -0.308669, -22.425779>, <0.236615, -0.289900, -22.425779>, <0.430629, -0.148941, -22.478899>, <0.454096, -0.131890, -22.492248>, 
      <0.210781, -0.308669, -22.997246>, <0.236615, -0.289900, -22.997246>, <0.271397, -0.264629, -23.006864>, <0.294864, -0.247579, -23.020214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.162689, -0.242476, -20.277594>, <0.421348, -0.054549, -20.277594>, <0.769601, 0.198472, -20.373915>, <1.004569, 0.369186, -20.507584>, 
      <0.203284, -0.298351, -20.513344>, <0.461943, -0.110424, -20.513344>, <0.744532, 0.094973, -20.591506>, <0.979500, 0.265688, -20.725174>, 
      <0.206439, -0.302693, -20.846810>, <0.395347, -0.165443, -20.846810>, <0.718116, 0.069064, -20.935818>, <0.889722, 0.193743, -21.033442>, 
      <0.210781, -0.308669, -21.092358>, <0.399689, -0.171419, -21.092358>, <0.654031, 0.013371, -21.162704>, <0.825637, 0.138050, -21.260328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000331, -0.019011, -19.870211>, <0.293866, 0.194255, -19.870211>, <0.689075, 0.481391, -19.979518>, <0.955724, 0.675123, -20.131213>, 
      <0.066051, -0.109466, -19.966658>, <0.359586, 0.103799, -19.966658>, <0.727779, 0.371812, -20.068298>, <0.994428, 0.565544, -20.219992>, 
      <0.138288, -0.208891, -20.135891>, <0.396947, -0.020964, -20.135891>, <0.784735, 0.260952, -20.242557>, <1.019703, 0.431667, -20.376227>, 
      <0.162689, -0.242476, -20.277594>, <0.421348, -0.054549, -20.277594>, <0.769601, 0.198472, -20.373915>, <1.004569, 0.369186, -20.507584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.108909, 0.131346, -19.879013>, <0.183872, 0.344064, -19.879013>, <0.578066, 0.630463, -19.988042>, <0.844031, 0.823697, -20.139344>, 
      <-0.085341, 0.098907, -19.840181>, <0.207440, 0.311625, -19.840181>, <0.612687, 0.605718, -19.951923>, <0.878652, 0.798953, -20.103226>, 
      <-0.024512, 0.015183, -19.833752>, <0.269023, 0.228449, -19.833752>, <0.674303, 0.523213, -19.945635>, <0.940952, 0.716945, -20.097328>, 
      <0.000331, -0.019011, -19.870211>, <0.293866, 0.194255, -19.870211>, <0.689075, 0.481391, -19.979518>, <0.955724, 0.675123, -20.131213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.249218, 0.324464, -20.281365>, <0.009119, 0.512157, -20.281365>, <0.356937, 0.764862, -20.377568>, <0.591612, 0.935363, -20.511070>, 
      <-0.235298, 0.305306, -20.143026>, <0.023038, 0.492998, -20.143026>, <0.409577, 0.773737, -20.249336>, <0.644251, 0.944239, -20.382840>, 
      <-0.168170, 0.212912, -19.976650>, <0.124611, 0.425630, -19.976650>, <0.491911, 0.692040, -20.077922>, <0.757876, 0.885274, -20.229224>, 
      <-0.108909, 0.131346, -19.879013>, <0.183872, 0.344064, -19.879013>, <0.578066, 0.630463, -19.988042>, <0.844031, 0.823697, -20.139344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.230364, 0.298515, -21.086070>, <-0.040918, 0.436156, -21.086070>, <0.214149, 0.621473, -21.156618>, <0.386244, 0.746507, -21.254520>, 
      <-0.231223, 0.299698, -20.844470>, <-0.041777, 0.437339, -20.844470>, <0.280610, 0.671566, -20.933405>, <0.452705, 0.796601, -21.031307>, 
      <-0.273180, 0.357445, -20.519504>, <-0.014843, 0.545137, -20.519504>, <0.266655, 0.749639, -20.597494>, <0.501330, 0.920140, -20.730997>, 
      <-0.249218, 0.324464, -20.281365>, <0.009119, 0.512157, -20.281365>, <0.356937, 0.764862, -20.377568>, <0.591612, 0.935363, -20.511070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.239558, 0.311170, -22.997246>, <-0.213725, 0.329939, -22.997246>, <-0.178943, 0.355210, -23.006867>, <-0.155475, 0.372260, -23.020216>, 
      <-0.236800, 0.307374, -22.423893>, <-0.210967, 0.326143, -22.423893>, <-0.016427, 0.467484, -22.477157>, <0.007040, 0.484534, -22.490507>, 
      <-0.228325, 0.295708, -21.659432>, <-0.038878, 0.433349, -21.659432>, <0.056428, 0.502594, -21.686334>, <0.228523, 0.627628, -21.784237>, 
      <-0.230364, 0.298515, -21.086070>, <-0.040918, 0.436156, -21.086070>, <0.214149, 0.621473, -21.156618>, <0.386244, 0.746507, -21.254520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.825637, 0.138050, -21.260328>, <1.002559, 0.266591, -21.360976>, <1.216600, 0.422101, -21.559733>, <1.346888, 0.516761, -21.738670>, 
      <0.676580, 0.008513, -21.788048>, <0.853502, 0.137054, -21.888694>, <0.932625, 0.194541, -21.963618>, <1.062912, 0.289201, -22.142555>, 
      <0.454096, -0.131890, -22.492248>, <0.478291, -0.114312, -22.506011>, <0.642552, 0.005031, -22.657072>, <0.660369, 0.017975, -22.681541>, 
      <0.294864, -0.247579, -23.020214>, <0.319059, -0.230001, -23.033978>, <0.348329, -0.208735, -23.061158>, <0.366146, -0.195790, -23.085629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.004569, 0.369186, -20.507584>, <1.246816, 0.545188, -20.645394>, <1.539887, 0.758117, -20.917536>, <1.718281, 0.887728, -21.162544>, 
      <0.979500, 0.265688, -20.725174>, <1.221747, 0.441690, -20.862984>, <1.459396, 0.614576, -21.083637>, <1.637790, 0.744186, -21.328646>, 
      <0.889722, 0.193743, -21.033442>, <1.066644, 0.322284, -21.134088>, <1.338737, 0.519975, -21.386021>, <1.469025, 0.614634, -21.564958>, 
      <0.825637, 0.138050, -21.260328>, <1.002559, 0.266591, -21.360976>, <1.216600, 0.422101, -21.559733>, <1.346888, 0.516761, -21.738670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.955724, 0.675123, -20.131213>, <1.230633, 0.874856, -20.287603>, <1.563220, 1.116494, -20.596440>, <1.765666, 1.263580, -20.874482>, 
      <0.994428, 0.565544, -20.219992>, <1.269337, 0.765277, -20.376382>, <1.579077, 0.991591, -20.663760>, <1.781523, 1.138677, -20.941802>, 
      <1.019703, 0.431667, -20.376227>, <1.261950, 0.607669, -20.514037>, <1.589036, 0.845765, -20.816112>, <1.767429, 0.975376, -21.061122>, 
      <1.004569, 0.369186, -20.507584>, <1.246816, 0.545188, -20.645394>, <1.539887, 0.758117, -20.917536>, <1.718281, 0.887728, -21.162544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.844031, 0.823697, -20.139344>, <1.118235, 1.022918, -20.295334>, <1.449967, 1.263936, -20.603378>, <1.651895, 1.410645, -20.880707>, 
      <0.878652, 0.798953, -20.103226>, <1.152856, 0.998173, -20.259216>, <1.494561, 1.245597, -20.575270>, <1.696488, 1.392306, -20.852598>, 
      <0.940952, 0.716945, -20.097328>, <1.215861, 0.916678, -20.253720>, <1.557021, 1.165321, -20.570123>, <1.759468, 1.312407, -20.848165>, 
      <0.955724, 0.675123, -20.131213>, <1.230633, 0.874856, -20.287603>, <1.563220, 1.116494, -20.596440>, <1.765666, 1.263580, -20.874482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.591612, 0.935363, -20.511070>, <0.833556, 1.111145, -20.648709>, <1.126261, 1.323809, -20.920512>, <1.304432, 1.453257, -21.165213>, 
      <0.644251, 0.944239, -20.382840>, <0.886195, 1.120021, -20.520477>, <1.212432, 1.356790, -20.821512>, <1.390603, 1.486239, -21.066214>, 
      <0.757876, 0.885274, -20.229224>, <1.032080, 1.084495, -20.385214>, <1.341840, 1.308402, -20.671536>, <1.543767, 1.455111, -20.948864>, 
      <0.844031, 0.823697, -20.139344>, <1.118235, 1.022918, -20.295334>, <1.449967, 1.263936, -20.603378>, <1.651895, 1.410645, -20.880707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.386244, 0.746507, -21.254520>, <0.563670, 0.875414, -21.355456>, <0.778321, 1.031367, -21.554778>, <0.908979, 1.126296, -21.734224>, 
      <0.452705, 0.796601, -21.031307>, <0.630130, 0.925508, -21.132242>, <0.901860, 1.122931, -21.383926>, <1.032518, 1.217860, -21.563373>, 
      <0.501330, 0.920140, -20.730997>, <0.743274, 1.095922, -20.868635>, <0.979899, 1.267789, -21.088662>, <1.158070, 1.397237, -21.333365>, 
      <0.591612, 0.935363, -20.511070>, <0.833556, 1.111145, -20.648709>, <1.126261, 1.323809, -20.920512>, <1.304432, 1.453257, -21.165213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155475, 0.372260, -23.020216>, <-0.131281, 0.389838, -23.033979>, <-0.102010, 0.411105, -23.061158>, <-0.084193, 0.424049, -23.085629>, 
      <0.007040, 0.484534, -22.490507>, <0.031235, 0.502112, -22.504270>, <0.195941, 0.621779, -22.655738>, <0.213758, 0.634724, -22.680206>, 
      <0.228523, 0.627628, -21.784237>, <0.405949, 0.756535, -21.885171>, <0.485161, 0.814086, -21.960205>, <0.615820, 0.909015, -22.139653>, 
      <0.386244, 0.746507, -21.254520>, <0.563670, 0.875414, -21.355456>, <0.778321, 1.031367, -21.554778>, <0.908979, 1.126296, -21.734224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.346888, 0.516761, -21.738670>, <1.482518, 0.615302, -21.924947>, <1.624354, 0.718352, -22.219736>, <1.695176, 0.769807, -22.454560>, 
      <1.062912, 0.289201, -22.142555>, <1.198543, 0.387742, -22.328832>, <1.250241, 0.425304, -22.438309>, <1.321063, 0.476759, -22.673131>, 
      <0.660369, 0.017975, -22.681541>, <0.678917, 0.031451, -22.707016>, <0.788511, 0.111076, -22.932726>, <0.798195, 0.118113, -22.964838>, 
      <0.366146, -0.195790, -23.085629>, <0.384694, -0.182314, -23.111102>, <0.404090, -0.168222, -23.151416>, <0.413775, -0.161185, -23.183530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.718281, 0.887728, -21.162544>, <1.903991, 1.022654, -21.417600>, <2.098197, 1.163753, -21.821235>, <2.195168, 1.234207, -22.142763>, 
      <1.637790, 0.744186, -21.328646>, <1.823500, 0.879112, -21.583702>, <1.980985, 0.993788, -21.910858>, <2.077956, 1.064242, -22.232386>, 
      <1.469025, 0.614634, -21.564958>, <1.604656, 0.713176, -21.751235>, <1.785331, 0.844448, -22.125686>, <1.856152, 0.895902, -22.360510>, 
      <1.346888, 0.516761, -21.738670>, <1.482518, 0.615302, -21.924947>, <1.624354, 0.718352, -22.219736>, <1.695176, 0.769807, -22.454560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.765666, 1.263580, -20.874482>, <1.976416, 1.416699, -21.163926>, <2.196807, 1.576822, -21.621986>, <2.306853, 1.656775, -21.986866>, 
      <1.781523, 1.138677, -20.941802>, <1.992273, 1.291796, -21.231246>, <2.197629, 1.442363, -21.658054>, <2.307675, 1.522316, -22.022934>, 
      <1.767429, 0.975376, -21.061122>, <1.953140, 1.110302, -21.316178>, <2.170696, 1.268881, -21.765802>, <2.267667, 1.339334, -22.087330>, 
      <1.718281, 0.887728, -21.162544>, <1.903991, 1.022654, -21.417600>, <2.098197, 1.163753, -21.821235>, <2.195168, 1.234207, -22.142763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.651895, 1.410645, -20.880707>, <1.862103, 1.563370, -21.169408>, <2.081928, 1.723082, -21.626291>, <2.191692, 1.802830, -21.990234>, 
      <1.696488, 1.392306, -20.852598>, <1.906696, 1.545032, -21.141301>, <2.133682, 1.709062, -21.610814>, <2.243445, 1.788810, -21.974758>, 
      <1.759468, 1.312407, -20.848165>, <1.970217, 1.465525, -21.137611>, <2.196477, 1.630724, -21.607528>, <2.306523, 1.710676, -21.972408>, 
      <1.765666, 1.263580, -20.874482>, <1.976416, 1.416699, -21.163926>, <2.196807, 1.576822, -21.621986>, <2.306853, 1.656775, -21.986866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.304432, 1.453257, -21.165213>, <1.489911, 1.588015, -21.419950>, <1.683874, 1.728938, -21.823082>, <1.780724, 1.799303, -22.144206>, 
      <1.390603, 1.486239, -21.066214>, <1.576081, 1.620997, -21.320952>, <1.793214, 1.778460, -21.768974>, <1.890064, 1.848825, -22.090099>, 
      <1.543767, 1.455111, -20.948864>, <1.753976, 1.607836, -21.237566>, <1.959830, 1.756159, -21.662805>, <2.069594, 1.835907, -22.026749>, 
      <1.651895, 1.410645, -20.880707>, <1.862103, 1.563370, -21.169408>, <2.081928, 1.723082, -21.626291>, <2.191692, 1.802830, -21.990234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.908979, 1.126296, -21.734224>, <1.044997, 1.225119, -21.921032>, <1.187237, 1.328462, -22.216661>, <1.258260, 1.380064, -22.452154>, 
      <1.032518, 1.217860, -21.563373>, <1.168536, 1.316682, -21.750181>, <1.348923, 1.447741, -22.124192>, <1.419946, 1.499343, -22.359683>, 
      <1.158070, 1.397237, -21.333365>, <1.343548, 1.531995, -21.588102>, <1.500196, 1.645747, -21.913976>, <1.597045, 1.716112, -22.235102>, 
      <1.304432, 1.453257, -21.165213>, <1.489911, 1.588015, -21.419950>, <1.683874, 1.728938, -21.823082>, <1.780724, 1.799303, -22.144206>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.084193, 0.424049, -23.085629>, <-0.065645, 0.437525, -23.111102>, <-0.046249, 0.451618, -23.151416>, <-0.036564, 0.458654, -23.183530>, 
      <0.213758, 0.634724, -22.680206>, <0.232307, 0.648200, -22.705682>, <0.342198, 0.728040, -22.932005>, <0.351883, 0.735077, -22.964117>, 
      <0.615820, 0.909015, -22.139653>, <0.751838, 1.007838, -22.326459>, <0.803580, 1.045431, -22.436077>, <0.874603, 1.097032, -22.671570>, 
      <0.908979, 1.126296, -21.734224>, <1.044997, 1.225119, -21.921032>, <1.187237, 1.328462, -22.216661>, <1.258260, 1.380064, -22.452154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695176, 0.769807, -22.454560>, <1.767906, 0.822648, -22.695709>, <1.817478, 0.858665, -23.041646>, <1.817478, 0.858665, -23.299010>, 
      <1.321063, 0.476759, -22.673131>, <1.393793, 0.529600, -22.914282>, <1.411717, 0.542623, -23.041646>, <1.411717, 0.542623, -23.299010>, 
      <0.798195, 0.118113, -22.964838>, <0.808141, 0.125339, -22.997816>, <0.846594, 0.153276, -23.263814>, <0.846594, 0.153276, -23.299010>, 
      <0.413775, -0.161185, -23.183530>, <0.423721, -0.153959, -23.216507>, <0.430501, -0.149034, -23.263814>, <0.430501, -0.149034, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.195168, 1.234207, -22.142763>, <2.294752, 1.306559, -22.472954>, <2.362629, 1.355874, -22.946621>, <2.362629, 1.355874, -23.299010>, 
      <2.077956, 1.064242, -22.232386>, <2.177540, 1.136594, -22.562576>, <2.232617, 1.176727, -22.946621>, <2.232617, 1.176727, -23.299010>, 
      <1.856152, 0.895902, -22.360510>, <1.928882, 0.948744, -22.601659>, <1.992109, 0.994682, -23.041646>, <1.992109, 0.994682, -23.299010>, 
      <1.695176, 0.769807, -22.454560>, <1.767906, 0.822648, -22.695709>, <1.817478, 0.858665, -23.041646>, <1.817478, 0.858665, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.306853, 1.656775, -21.986866>, <2.419864, 1.738883, -22.361576>, <2.496892, 1.794847, -22.899109>, <2.496892, 1.794847, -23.299010>, 
      <2.307675, 1.522316, -22.022934>, <2.420686, 1.604424, -22.397645>, <2.492510, 1.657202, -22.899109>, <2.492510, 1.657202, -23.299010>, 
      <2.267667, 1.339334, -22.087330>, <2.367251, 1.411686, -22.417520>, <2.443516, 1.467330, -22.946621>, <2.443516, 1.467330, -23.299010>, 
      <2.195168, 1.234207, -22.142763>, <2.294752, 1.306559, -22.472954>, <2.362629, 1.355874, -22.946621>, <2.362629, 1.355874, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.191692, 1.802830, -21.990234>, <2.304413, 1.884727, -22.363982>, <2.381243, 1.940548, -22.900134>, <2.381243, 1.940548, -23.299010>, 
      <2.243445, 1.788810, -21.974758>, <2.356166, 1.870707, -22.348507>, <2.435635, 1.928065, -22.900134>, <2.435635, 1.928065, -23.299010>, 
      <2.306523, 1.710676, -21.972408>, <2.419534, 1.792784, -22.347118>, <2.498668, 1.850625, -22.899109>, <2.498668, 1.850625, -23.299010>, 
      <2.306853, 1.656775, -21.986866>, <2.419864, 1.738883, -22.361576>, <2.496892, 1.794847, -22.899109>, <2.496892, 1.794847, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.780724, 1.799303, -22.144206>, <1.880184, 1.871565, -22.473986>, <1.947976, 1.920819, -22.947061>, <1.947976, 1.920819, -23.299010>, 
      <1.890064, 1.848825, -22.090099>, <1.989524, 1.921087, -22.419878>, <2.065678, 1.976282, -22.947061>, <2.065678, 1.976282, -23.299010>, 
      <2.069594, 1.835907, -22.026749>, <2.182314, 1.917803, -22.400498>, <2.254425, 1.969651, -22.900134>, <2.254425, 1.969651, -23.299010>, 
      <2.191692, 1.802830, -21.990234>, <2.304413, 1.884727, -22.363982>, <2.381243, 1.940548, -22.900134>, <2.381243, 1.940548, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.258260, 1.380064, -22.452154>, <1.331197, 1.433055, -22.693990>, <1.380911, 1.469175, -23.040915>, <1.380911, 1.469175, -23.299010>, 
      <1.419946, 1.499343, -22.359683>, <1.492883, 1.552335, -22.601520>, <1.555996, 1.598188, -23.040915>, <1.555996, 1.598188, -23.299010>, 
      <1.597045, 1.716112, -22.235102>, <1.696505, 1.788374, -22.564880>, <1.751240, 1.828114, -22.947061>, <1.751240, 1.828114, -23.299010>, 
      <1.780724, 1.799303, -22.144206>, <1.880184, 1.871565, -22.473986>, <1.947976, 1.920819, -22.947061>, <1.947976, 1.920819, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036564, 0.458654, -23.183530>, <-0.026618, 0.465880, -23.216507>, <-0.019839, 0.470806, -23.263814>, <-0.019839, 0.470806, -23.299010>, 
      <0.351883, 0.735077, -22.964117>, <0.361829, 0.742303, -22.997094>, <0.400386, 0.770316, -23.263814>, <0.400386, 0.770316, -23.299010>, 
      <0.874603, 1.097032, -22.671570>, <0.947540, 1.150024, -22.913406>, <0.965476, 1.163055, -23.040915>, <0.965476, 1.163055, -23.299010>, 
      <1.258260, 1.380064, -22.452154>, <1.331197, 1.433055, -22.693990>, <1.380911, 1.469175, -23.040915>, <1.380911, 1.469175, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.817478, 0.858665, -23.299010>, <1.817478, 0.858665, -23.556371>, <1.767906, 0.822648, -23.902309>, <1.695176, 0.769807, -24.143459>, 
      <1.411717, 0.542623, -23.299010>, <1.411717, 0.542623, -23.556371>, <1.393793, 0.529600, -23.683738>, <1.321063, 0.476759, -23.924886>, 
      <0.846594, 0.153276, -23.299010>, <0.846594, 0.153276, -23.334203>, <0.808141, 0.125339, -23.600203>, <0.798195, 0.118113, -23.633181>, 
      <0.430501, -0.149034, -23.299010>, <0.430501, -0.149034, -23.334203>, <0.423721, -0.153959, -23.381512>, <0.413775, -0.161185, -23.414490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.362629, 1.355874, -23.299010>, <2.362629, 1.355874, -23.651398>, <2.294752, 1.306558, -24.125066>, <2.195168, 1.234206, -24.455256>, 
      <2.232617, 1.176727, -23.299010>, <2.232617, 1.176727, -23.651398>, <2.177540, 1.136593, -24.035442>, <2.077956, 1.064241, -24.365634>, 
      <1.992109, 0.994682, -23.299010>, <1.992109, 0.994682, -23.556371>, <1.928882, 0.948744, -23.996358>, <1.856153, 0.895902, -24.237509>, 
      <1.817478, 0.858665, -23.299010>, <1.817478, 0.858665, -23.556371>, <1.767906, 0.822648, -23.902309>, <1.695176, 0.769807, -24.143459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.496892, 1.794847, -23.299010>, <2.496892, 1.794847, -23.698910>, <2.419864, 1.738882, -24.236443>, <2.306853, 1.656775, -24.611152>, 
      <2.492510, 1.657202, -23.299010>, <2.492510, 1.657202, -23.698910>, <2.420686, 1.604423, -24.200374>, <2.307675, 1.522316, -24.575085>, 
      <2.443516, 1.467330, -23.299010>, <2.443516, 1.467330, -23.651398>, <2.367251, 1.411686, -24.180498>, <2.267667, 1.339334, -24.510688>, 
      <2.362629, 1.355874, -23.299010>, <2.362629, 1.355874, -23.651398>, <2.294752, 1.306558, -24.125066>, <2.195168, 1.234206, -24.455256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.381243, 1.940548, -23.299010>, <2.381243, 1.940548, -23.697883>, <2.304413, 1.884727, -24.234035>, <2.191692, 1.802830, -24.607784>, 
      <2.435635, 1.928065, -23.299010>, <2.435635, 1.928065, -23.697883>, <2.356166, 1.870707, -24.249512>, <2.243445, 1.788810, -24.623261>, 
      <2.498668, 1.850625, -23.299010>, <2.498668, 1.850625, -23.698910>, <2.419534, 1.792783, -24.250901>, <2.306523, 1.710676, -24.625610>, 
      <2.496892, 1.794847, -23.299010>, <2.496892, 1.794847, -23.698910>, <2.419864, 1.738882, -24.236443>, <2.306853, 1.656775, -24.611152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.947976, 1.920819, -23.299010>, <1.947976, 1.920819, -23.650957>, <1.880184, 1.871565, -24.124034>, <1.780724, 1.799303, -24.453811>, 
      <2.065678, 1.976282, -23.299010>, <2.065678, 1.976282, -23.650957>, <1.989524, 1.921087, -24.178141>, <1.890064, 1.848825, -24.507920>, 
      <2.254425, 1.969651, -23.299010>, <2.254425, 1.969651, -23.697883>, <2.182315, 1.917803, -24.197522>, <2.069594, 1.835907, -24.571270>, 
      <2.381243, 1.940548, -23.299010>, <2.381243, 1.940548, -23.697883>, <2.304413, 1.884727, -24.234035>, <2.191692, 1.802830, -24.607784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.380911, 1.469175, -23.299010>, <1.380911, 1.469175, -23.557104>, <1.331197, 1.433056, -23.904027>, <1.258260, 1.380064, -24.145864>, 
      <1.555996, 1.598188, -23.299010>, <1.555996, 1.598188, -23.557104>, <1.492884, 1.552335, -23.996498>, <1.419947, 1.499343, -24.238334>, 
      <1.751240, 1.828114, -23.299010>, <1.751240, 1.828114, -23.650957>, <1.696505, 1.788374, -24.033138>, <1.597046, 1.716112, -24.362917>, 
      <1.947976, 1.920819, -23.299010>, <1.947976, 1.920819, -23.650957>, <1.880184, 1.871565, -24.124034>, <1.780724, 1.799303, -24.453811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.019839, 0.470806, -23.299010>, <-0.019839, 0.470806, -23.334203>, <-0.026618, 0.465880, -23.381512>, <-0.036564, 0.458654, -23.414490>, 
      <0.400386, 0.770316, -23.299010>, <0.400386, 0.770316, -23.334203>, <0.361829, 0.742303, -23.600923>, <0.351883, 0.735077, -23.633901>, 
      <0.965476, 1.163055, -23.299010>, <0.965476, 1.163055, -23.557104>, <0.947540, 1.150024, -23.684613>, <0.874603, 1.097033, -23.926450>, 
      <1.380911, 1.469175, -23.299010>, <1.380911, 1.469175, -23.557104>, <1.331197, 1.433056, -23.904027>, <1.258260, 1.380064, -24.145864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695176, 0.769807, -24.143459>, <1.624354, 0.718352, -24.378283>, <1.482519, 0.615302, -24.673070>, <1.346888, 0.516761, -24.859349>, 
      <1.321063, 0.476759, -23.924886>, <1.250242, 0.425304, -24.159710>, <1.198543, 0.387742, -24.269186>, <1.062913, 0.289201, -24.455464>, 
      <0.798195, 0.118113, -23.633181>, <0.788511, 0.111076, -23.665293>, <0.678917, 0.031451, -23.891003>, <0.660369, 0.017975, -23.916477>, 
      <0.413775, -0.161185, -23.414490>, <0.404090, -0.168222, -23.446602>, <0.384694, -0.182314, -23.486915>, <0.366146, -0.195790, -23.512390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.195168, 1.234206, -24.455256>, <2.098197, 1.163753, -24.776782>, <1.859787, 0.990538, -25.140258>, <1.718281, 0.887728, -25.435474>, 
      <2.077956, 1.064241, -24.365634>, <1.980985, 0.993788, -24.687160>, <1.779296, 0.846996, -24.974157>, <1.637790, 0.744186, -25.269374>, 
      <1.856153, 0.895902, -24.237509>, <1.785331, 0.844448, -24.472333>, <1.604656, 0.713176, -24.846782>, <1.469026, 0.614634, -25.033061>, 
      <1.695176, 0.769807, -24.143459>, <1.624354, 0.718352, -24.378283>, <1.482519, 0.615302, -24.673070>, <1.346888, 0.516761, -24.859349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.306853, 1.656775, -24.611152>, <2.196807, 1.576822, -24.976032>, <1.931199, 1.383847, -25.392214>, <1.765667, 1.263581, -25.723536>, 
      <2.307675, 1.522316, -24.575085>, <2.197629, 1.442363, -24.939965>, <1.947056, 1.258944, -25.324894>, <1.781524, 1.138678, -25.656216>, 
      <2.267667, 1.339334, -24.510688>, <2.170696, 1.268881, -24.832216>, <1.908936, 1.078185, -25.241678>, <1.767430, 0.975375, -25.536896>, 
      <2.195168, 1.234206, -24.455256>, <2.098197, 1.163753, -24.776782>, <1.859787, 0.990538, -25.140258>, <1.718281, 0.887728, -25.435474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.191692, 1.802830, -24.607784>, <2.081929, 1.723083, -24.971728>, <1.816906, 1.530532, -25.386766>, <1.651895, 1.410645, -25.717312>, 
      <2.243445, 1.788810, -24.623261>, <2.133682, 1.709063, -24.987203>, <1.861499, 1.512194, -25.414875>, <1.696488, 1.392306, -25.745421>, 
      <2.306523, 1.710676, -24.625610>, <2.196478, 1.630723, -24.990490>, <1.925000, 1.432673, -25.418530>, <1.759468, 1.312407, -25.749851>, 
      <2.306853, 1.656775, -24.611152>, <2.196807, 1.576822, -24.976032>, <1.931199, 1.383847, -25.392214>, <1.765667, 1.263581, -25.723536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.780724, 1.799303, -24.453811>, <1.683874, 1.728938, -24.774936>, <1.445717, 1.555907, -25.137925>, <1.304433, 1.453257, -25.432806>, 
      <1.890064, 1.848825, -24.507920>, <1.793214, 1.778460, -24.829045>, <1.531888, 1.588888, -25.236923>, <1.390604, 1.486239, -25.531805>, 
      <2.069594, 1.835907, -24.571270>, <1.959831, 1.756159, -24.935213>, <1.708778, 1.574998, -25.318611>, <1.543768, 1.455111, -25.649157>, 
      <2.191692, 1.802830, -24.607784>, <2.081929, 1.723083, -24.971728>, <1.816906, 1.530532, -25.386766>, <1.651895, 1.410645, -25.717312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.258260, 1.380064, -24.145864>, <1.187237, 1.328462, -24.381357>, <1.044997, 1.225119, -24.676987>, <0.908980, 1.126296, -24.863794>, 
      <1.419947, 1.499343, -24.238334>, <1.348923, 1.447741, -24.473827>, <1.168536, 1.316683, -24.847837>, <1.032519, 1.217860, -25.034645>, 
      <1.597046, 1.716112, -24.362917>, <1.500196, 1.645747, -24.684042>, <1.299355, 1.499887, -24.969773>, <1.158070, 1.397238, -25.264654>, 
      <1.780724, 1.799303, -24.453811>, <1.683874, 1.728938, -24.774936>, <1.445717, 1.555907, -25.137925>, <1.304433, 1.453257, -25.432806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036564, 0.458654, -23.414490>, <-0.046249, 0.451618, -23.446602>, <-0.065645, 0.437525, -23.486915>, <-0.084193, 0.424050, -23.512390>, 
      <0.351883, 0.735077, -23.633901>, <0.342198, 0.728040, -23.666014>, <0.232306, 0.648199, -23.892338>, <0.213759, 0.634724, -23.917813>, 
      <0.874603, 1.097033, -23.926450>, <0.803580, 1.045431, -24.161941>, <0.751838, 1.007838, -24.271558>, <0.615820, 0.909015, -24.458366>, 
      <1.258260, 1.380064, -24.145864>, <1.187237, 1.328462, -24.381357>, <1.044997, 1.225119, -24.676987>, <0.908980, 1.126296, -24.863794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.346888, 0.516761, -24.859349>, <1.216600, 0.422101, -25.038286>, <1.002559, 0.266591, -25.237043>, <0.825638, 0.138050, -25.337690>, 
      <1.062913, 0.289201, -24.455464>, <0.932625, 0.194541, -24.634402>, <0.887990, 0.167026, -24.694414>, <0.711068, 0.038484, -24.795061>, 
      <0.660369, 0.017975, -23.916477>, <0.642552, 0.005031, -23.940947>, <0.478291, -0.114312, -24.092006>, <0.454096, -0.131890, -24.105770>, 
      <0.366146, -0.195790, -23.512390>, <0.348329, -0.208735, -23.536859>, <0.319059, -0.230001, -23.564042>, <0.294864, -0.247579, -23.577805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.718281, 0.887728, -25.435474>, <1.502603, 0.731028, -25.885435>, <1.302633, 0.585742, -26.567934>, <1.004569, 0.369186, -26.939146>, 
      <1.637790, 0.744186, -25.269374>, <1.422111, 0.587486, -25.719336>, <1.271696, 0.458017, -26.097574>, <0.973633, 0.241461, -26.468786>, 
      <1.469026, 0.614634, -25.033061>, <1.338738, 0.519975, -25.211998>, <1.101862, 0.352890, -25.707363>, <0.924940, 0.224348, -25.808010>, 
      <1.346888, 0.516761, -24.859349>, <1.216600, 0.422101, -25.038286>, <1.002559, 0.266591, -25.237043>, <0.825638, 0.138050, -25.337690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.765667, 1.263581, -25.723536>, <1.525841, 1.089337, -26.203562>, <1.287875, 0.916444, -26.928550>, <0.955724, 0.675123, -27.315517>, 
      <1.781524, 1.138678, -25.656216>, <1.541698, 0.964434, -26.136242>, <1.326579, 0.806865, -26.839771>, <0.994429, 0.565544, -27.226739>, 
      <1.767430, 0.975375, -25.536896>, <1.551751, 0.818676, -25.986856>, <1.311897, 0.623989, -26.708784>, <1.013834, 0.407433, -27.079997>, 
      <1.718281, 0.887728, -25.435474>, <1.502603, 0.731028, -25.885435>, <1.302633, 0.585742, -26.567934>, <1.004569, 0.369186, -26.939146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.651895, 1.410645, -25.717312>, <1.412589, 1.236779, -26.196683>, <1.175450, 1.064487, -26.920768>, <0.844032, 0.823698, -27.307389>, 
      <1.696488, 1.392306, -25.745421>, <1.457183, 1.218440, -26.224792>, <1.210071, 1.039743, -26.956883>, <0.878653, 0.798953, -27.343507>, 
      <1.759468, 1.312407, -25.749851>, <1.519642, 1.138163, -26.229877>, <1.273103, 0.958266, -26.962435>, <0.940952, 0.716945, -27.349402>, 
      <1.765667, 1.263581, -25.723536>, <1.525841, 1.089337, -26.203562>, <1.287875, 0.916444, -26.928550>, <0.955724, 0.675123, -27.315517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.304433, 1.453257, -25.432806>, <1.088978, 1.296720, -25.882493>, <0.889358, 1.151688, -26.564592>, <0.591612, 0.935363, -26.935661>, 
      <1.390604, 1.486239, -25.531805>, <1.175149, 1.329702, -25.981491>, <0.920867, 1.157001, -26.699766>, <0.623121, 0.940676, -27.070835>, 
      <1.543768, 1.455111, -25.649157>, <1.304462, 1.281245, -26.128528>, <1.089295, 1.126064, -26.830886>, <0.757877, 0.885275, -27.217507>, 
      <1.651895, 1.410645, -25.717312>, <1.412589, 1.236779, -26.196683>, <1.175450, 1.064487, -26.920768>, <0.844032, 0.823698, -27.307389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.908980, 1.126296, -24.863794>, <0.778321, 1.031367, -25.043242>, <0.563670, 0.875414, -25.242563>, <0.386244, 0.746507, -25.343498>, 
      <1.032519, 1.217860, -25.034645>, <0.901860, 1.122931, -25.214093>, <0.667603, 0.953752, -25.709699>, <0.490177, 0.824844, -25.810635>, 
      <1.158070, 1.397238, -25.264654>, <0.942616, 1.240701, -25.714341>, <0.779353, 1.133139, -26.092672>, <0.481606, 0.916814, -26.463741>, 
      <1.304433, 1.453257, -25.432806>, <1.088978, 1.296720, -25.882493>, <0.889358, 1.151688, -26.564592>, <0.591612, 0.935363, -26.935661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.084193, 0.424050, -23.512390>, <-0.102010, 0.411105, -23.536859>, <-0.131281, 0.389838, -23.564042>, <-0.155475, 0.372260, -23.577805>, 
      <0.213759, 0.634724, -23.917813>, <0.195941, 0.621779, -23.942282>, <0.031235, 0.502112, -24.093750>, <0.007041, 0.484534, -24.107514>, 
      <0.615820, 0.909015, -24.458366>, <0.485162, 0.814086, -24.637813>, <0.442503, 0.784087, -24.697966>, <0.265078, 0.655180, -24.798901>, 
      <0.908980, 1.126296, -24.863794>, <0.778321, 1.031367, -25.043242>, <0.563670, 0.875414, -25.242563>, <0.386244, 0.746507, -25.343498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.825638, 0.138050, -25.337690>, <0.654032, 0.013371, -25.435314>, <0.399690, -0.171419, -25.505661>, <0.210781, -0.308669, -25.505661>, 
      <0.711068, 0.038484, -24.795061>, <0.539462, -0.086194, -24.892685>, <0.406974, -0.181445, -24.934328>, <0.218066, -0.318695, -24.934328>, 
      <0.454096, -0.131890, -24.105770>, <0.430629, -0.148940, -24.119120>, <0.236615, -0.289900, -24.172240>, <0.210781, -0.308669, -24.172240>, 
      <0.294864, -0.247579, -23.577805>, <0.271397, -0.264629, -23.591154>, <0.236615, -0.289900, -23.600773>, <0.210781, -0.308669, -23.600773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.004569, 0.369186, -26.939146>, <0.811821, 0.229146, -27.179197>, <0.436309, -0.043680, -27.372829>, <0.162689, -0.242476, -27.372829>, 
      <0.973633, 0.241461, -26.468786>, <0.780885, 0.101421, -26.708837>, <0.487555, -0.114213, -26.818962>, <0.213935, -0.313010, -26.818962>, 
      <0.924940, 0.224348, -25.808010>, <0.753334, 0.099669, -25.905634>, <0.392543, -0.161582, -26.066218>, <0.203634, -0.298832, -26.066218>, 
      <0.825638, 0.138050, -25.337690>, <0.654032, 0.013371, -25.435314>, <0.399690, -0.171419, -25.505661>, <0.210781, -0.308669, -25.505661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.955724, 0.675123, -27.315517>, <0.731584, 0.512275, -27.576650>, <0.308342, 0.204772, -27.780211>, <0.000332, -0.019011, -27.780211>, 
      <0.994429, 0.565544, -27.226739>, <0.770288, 0.402696, -27.487869>, <0.374061, 0.114316, -27.683766>, <0.066052, -0.109466, -27.683766>, 
      <1.013834, 0.407433, -27.079997>, <0.821085, 0.267394, -27.320048>, <0.422813, -0.025104, -27.518691>, <0.149194, -0.223901, -27.518691>, 
      <1.004569, 0.369186, -26.939146>, <0.811821, 0.229146, -27.179197>, <0.436309, -0.043680, -27.372829>, <0.162689, -0.242476, -27.372829>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.844032, 0.823698, -27.307389>, <0.620571, 0.661344, -27.568070>, <0.198357, 0.354587, -27.771411>, <-0.108908, 0.131346, -27.771411>, 
      <0.878653, 0.798953, -27.343507>, <0.655192, 0.636599, -27.604189>, <0.221925, 0.322148, -27.810243>, <-0.085340, 0.098907, -27.810243>, 
      <0.940952, 0.716945, -27.349402>, <0.716812, 0.554097, -27.610531>, <0.283498, 0.238965, -27.816672>, <-0.024511, 0.015183, -27.816672>, 
      <0.955724, 0.675123, -27.315517>, <0.731584, 0.512275, -27.576650>, <0.308342, 0.204772, -27.780211>, <0.000332, -0.019011, -27.780211>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.591612, 0.935363, -26.935661>, <0.399154, 0.795533, -27.175514>, <0.024085, 0.523030, -27.369056>, <-0.249217, 0.324464, -27.369056>, 
      <0.623121, 0.940676, -27.070835>, <0.430663, 0.800846, -27.310688>, <0.031598, 0.512689, -27.508822>, <-0.241704, 0.314124, -27.508822>, 
      <0.757877, 0.885275, -27.217507>, <0.534416, 0.722921, -27.478192>, <0.139095, 0.436154, -27.673770>, <-0.168170, 0.212912, -27.673770>, 
      <0.844032, 0.823698, -27.307389>, <0.620571, 0.661344, -27.568070>, <0.198357, 0.354587, -27.771411>, <-0.108908, 0.131346, -27.771411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.386244, 0.746507, -25.343498>, <0.214149, 0.621473, -25.441400>, <-0.040917, 0.436156, -25.511947>, <-0.230364, 0.298515, -25.511947>, 
      <0.490177, 0.824844, -25.810635>, <0.318082, 0.699810, -25.908538>, <-0.042346, 0.438122, -26.069158>, <-0.231792, 0.300481, -26.069158>, 
      <0.481606, 0.916814, -26.463741>, <0.289148, 0.776985, -26.703594>, <-0.005744, 0.564085, -26.814155>, <-0.279045, 0.365519, -26.814155>, 
      <0.591612, 0.935363, -26.935661>, <0.399154, 0.795533, -27.175514>, <0.024085, 0.523030, -27.369056>, <-0.249217, 0.324464, -27.369056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.155475, 0.372260, -23.577805>, <-0.178943, 0.355210, -23.591154>, <-0.213725, 0.329939, -23.600773>, <-0.239558, 0.311170, -23.600773>, 
      <0.007041, 0.484534, -24.107514>, <-0.016427, 0.467484, -24.120862>, <-0.210967, 0.326143, -24.174126>, <-0.236800, 0.307374, -24.174126>, 
      <0.265078, 0.655180, -24.798901>, <0.092983, 0.530146, -24.896803>, <-0.039448, 0.434133, -24.938581>, <-0.228894, 0.296492, -24.938581>, 
      <0.386244, 0.746507, -25.343498>, <0.214149, 0.621473, -25.441400>, <-0.040917, 0.436156, -25.511947>, <-0.230364, 0.298515, -25.511947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.210781, -0.308669, -25.505661>, <0.021873, -0.445919, -25.505661>, <-0.232469, -0.630709, -25.435314>, <-0.404075, -0.755388, -25.337690>, 
      <0.218066, -0.318695, -24.934328>, <0.029157, -0.455945, -24.934328>, <-0.102373, -0.552515, -24.892685>, <-0.273979, -0.677194, -24.795061>, 
      <0.210781, -0.308669, -24.172240>, <0.184948, -0.327438, -24.172240>, <-0.009066, -0.468398, -24.119120>, <-0.032534, -0.485448, -24.105770>, 
      <0.210781, -0.308669, -23.600773>, <0.184948, -0.327438, -23.600773>, <0.150166, -0.352709, -23.591154>, <0.126698, -0.369759, -23.577805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.162689, -0.242476, -27.372829>, <-0.110930, -0.441272, -27.372829>, <-0.486443, -0.714098, -27.179197>, <-0.679191, -0.854138, -26.939146>, 
      <0.213935, -0.313010, -26.818962>, <-0.059685, -0.511806, -26.818962>, <-0.355409, -0.724144, -26.708837>, <-0.548158, -0.864184, -26.468786>, 
      <0.203634, -0.298832, -26.066218>, <0.014726, -0.436082, -26.066218>, <-0.345230, -0.698484, -25.905634>, <-0.516836, -0.823163, -25.808010>, 
      <0.210781, -0.308669, -25.505661>, <0.021873, -0.445919, -25.505661>, <-0.232469, -0.630709, -25.435314>, <-0.404075, -0.755388, -25.337690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000332, -0.019011, -27.780211>, <-0.307677, -0.242792, -27.780211>, <-0.730920, -0.550296, -27.576650>, <-0.955060, -0.713144, -27.315517>, 
      <0.066052, -0.109466, -27.683766>, <-0.241958, -0.333248, -27.683766>, <-0.638664, -0.620968, -27.487869>, <-0.862805, -0.783815, -27.226739>, 
      <0.149194, -0.223901, -27.518691>, <-0.124426, -0.422697, -27.518691>, <-0.525681, -0.711090, -27.320048>, <-0.718429, -0.851129, -27.079997>, 
      <0.162689, -0.242476, -27.372829>, <-0.110930, -0.441272, -27.372829>, <-0.486443, -0.714098, -27.179197>, <-0.679191, -0.854138, -26.939146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.108908, 0.131346, -27.771411>, <-0.416173, -0.091895, -27.771411>, <-0.838388, -0.398652, -27.568070>, <-1.061848, -0.561005, -27.307389>, 
      <-0.085340, 0.098907, -27.810243>, <-0.392605, -0.124334, -27.810243>, <-0.825553, -0.439225, -27.604189>, <-1.049014, -0.601578, -27.343507>, 
      <-0.024511, 0.015183, -27.816672>, <-0.332521, -0.208599, -27.816672>, <-0.766130, -0.523323, -27.610531>, <-0.990271, -0.686171, -27.349402>, 
      <0.000332, -0.019011, -27.780211>, <-0.307677, -0.242792, -27.780211>, <-0.730920, -0.550296, -27.576650>, <-0.955060, -0.713144, -27.315517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.249217, 0.324464, -27.369056>, <-0.522519, 0.125899, -27.369056>, <-0.897588, -0.146605, -27.175514>, <-1.090046, -0.286434, -26.935661>, 
      <-0.241704, 0.314124, -27.508822>, <-0.515006, 0.115558, -27.508822>, <-0.912378, -0.174930, -27.310688>, <-1.104836, -0.314759, -27.070835>, 
      <-0.168170, 0.212912, -27.673770>, <-0.475435, -0.010329, -27.673770>, <-0.870328, -0.297685, -27.478192>, <-1.093788, -0.460039, -27.217507>, 
      <-0.108908, 0.131346, -27.771411>, <-0.416173, -0.091895, -27.771411>, <-0.838388, -0.398652, -27.568070>, <-1.061848, -0.561005, -27.307389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.230364, 0.298515, -25.511947>, <-0.419810, 0.160874, -25.511947>, <-0.674877, -0.024443, -25.441400>, <-0.846972, -0.149477, -25.343498>, 
      <-0.231792, 0.300481, -26.069158>, <-0.421239, 0.162840, -26.069158>, <-0.781497, -0.099081, -25.908538>, <-0.953592, -0.224115, -25.810635>, 
      <-0.279045, 0.365519, -26.814155>, <-0.552347, 0.166954, -26.814155>, <-0.845953, -0.047715, -26.703594>, <-1.038412, -0.187544, -26.463741>, 
      <-0.249217, 0.324464, -27.369056>, <-0.522519, 0.125899, -27.369056>, <-0.897588, -0.146605, -27.175514>, <-1.090046, -0.286434, -26.935661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.239558, 0.311170, -23.600773>, <-0.265392, 0.292401, -23.600773>, <-0.300174, 0.267130, -23.591154>, <-0.323641, 0.250080, -23.577805>, 
      <-0.236800, 0.307374, -24.174126>, <-0.262634, 0.288604, -24.174126>, <-0.457173, 0.147263, -24.120862>, <-0.480641, 0.130213, -24.107514>, 
      <-0.228894, 0.296492, -24.938581>, <-0.418341, 0.158851, -24.938581>, <-0.550577, 0.062572, -24.896803>, <-0.722672, -0.062462, -24.798901>, 
      <-0.230364, 0.298515, -25.511947>, <-0.419810, 0.160874, -25.511947>, <-0.674877, -0.024443, -25.441400>, <-0.846972, -0.149477, -25.343498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.404075, -0.755388, -25.337690>, <-0.580997, -0.883930, -25.237043>, <-0.795038, -1.039439, -25.038286>, <-0.925325, -1.134099, -24.859349>, 
      <-0.273979, -0.677194, -24.795061>, <-0.450900, -0.805735, -24.694414>, <-0.490862, -0.839683, -24.634402>, <-0.621150, -0.934342, -24.455464>, 
      <-0.032534, -0.485448, -24.105770>, <-0.056728, -0.503026, -24.092006>, <-0.220989, -0.622369, -23.940947>, <-0.238806, -0.635313, -23.916477>, 
      <0.126698, -0.369759, -23.577805>, <0.102504, -0.387337, -23.564042>, <0.073233, -0.408604, -23.536859>, <0.055416, -0.421548, -23.512390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.679191, -0.854138, -26.939146>, <-0.977255, -1.070694, -26.567934>, <-1.177224, -1.215980, -25.885435>, <-1.392903, -1.372680, -25.435474>, 
      <-0.548158, -0.864184, -26.468786>, <-0.846221, -1.080740, -26.097574>, <-1.015835, -1.183785, -25.719336>, <-1.231513, -1.340485, -25.269374>, 
      <-0.516836, -0.823163, -25.808010>, <-0.693757, -0.951704, -25.707363>, <-0.925864, -1.125355, -25.211998>, <-1.056151, -1.220014, -25.033061>, 
      <-0.404075, -0.755388, -25.337690>, <-0.580997, -0.883930, -25.237043>, <-0.795038, -1.039439, -25.038286>, <-0.925325, -1.134099, -24.859349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.955060, -0.713144, -27.315517>, <-1.287211, -0.954465, -26.928550>, <-1.525177, -1.127357, -26.203562>, <-1.765003, -1.301601, -25.723536>, 
      <-0.862805, -0.783815, -27.226739>, <-1.194955, -1.025136, -26.839771>, <-1.411287, -1.181035, -26.136242>, <-1.651113, -1.355279, -25.656216>, 
      <-0.718429, -0.851129, -27.079997>, <-1.016493, -1.067685, -26.708784>, <-1.275770, -1.235638, -25.986856>, <-1.491449, -1.392338, -25.536896>, 
      <-0.679191, -0.854138, -26.939146>, <-0.977255, -1.070694, -26.567934>, <-1.177224, -1.215980, -25.885435>, <-1.392903, -1.372680, -25.435474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.061848, -0.561005, -27.307389>, <-1.393267, -0.801795, -26.920768>, <-1.630406, -0.974086, -26.196683>, <-1.869712, -1.147952, -25.717312>, 
      <-1.049014, -0.601578, -27.343507>, <-1.380432, -0.842368, -26.956883>, <-1.626745, -1.022164, -26.224792>, <-1.866051, -1.196030, -25.745421>, 
      <-0.990271, -0.686171, -27.349402>, <-1.322421, -0.927492, -26.962435>, <-1.569698, -1.106374, -26.229877>, <-1.809524, -1.280618, -25.749851>, 
      <-0.955060, -0.713144, -27.315517>, <-1.287211, -0.954465, -26.928550>, <-1.525177, -1.127357, -26.203562>, <-1.765003, -1.301601, -25.723536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.090046, -0.286434, -26.935661>, <-1.387793, -0.502759, -26.564592>, <-1.587412, -0.647791, -25.882493>, <-1.802867, -0.804328, -25.432806>, 
      <-1.104836, -0.314759, -27.070835>, <-1.402582, -0.531084, -26.699766>, <-1.645408, -0.719553, -25.981491>, <-1.860863, -0.876089, -25.531805>, 
      <-1.093788, -0.460039, -27.217507>, <-1.425207, -0.700828, -26.830886>, <-1.639282, -0.857510, -26.128528>, <-1.878588, -1.031376, -25.649157>, 
      <-1.061848, -0.561005, -27.307389>, <-1.393267, -0.801795, -26.920768>, <-1.630406, -0.974086, -26.196683>, <-1.869712, -1.147952, -25.717312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.846972, -0.149477, -25.343498>, <-1.024398, -0.278384, -25.242563>, <-1.239049, -0.434337, -25.043242>, <-1.369707, -0.529266, -24.863794>, 
      <-0.953592, -0.224115, -25.810635>, <-1.131018, -0.353023, -25.709699>, <-1.364306, -0.523535, -25.214093>, <-1.494965, -0.618464, -25.034645>, 
      <-1.038412, -0.187544, -26.463741>, <-1.336158, -0.403869, -26.092672>, <-1.488906, -0.525903, -25.714341>, <-1.704361, -0.682440, -25.264654>, 
      <-1.090046, -0.286434, -26.935661>, <-1.387793, -0.502759, -26.564592>, <-1.587412, -0.647791, -25.882493>, <-1.802867, -0.804328, -25.432806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.323641, 0.250080, -23.577805>, <-0.347836, 0.232502, -23.564042>, <-0.377106, 0.211236, -23.536859>, <-0.394923, 0.198291, -23.512390>, 
      <-0.480641, 0.130213, -24.107514>, <-0.504835, 0.112635, -24.093750>, <-0.669541, -0.007032, -23.942282>, <-0.687358, -0.019976, -23.917813>, 
      <-0.722672, -0.062462, -24.798901>, <-0.900098, -0.191369, -24.697966>, <-0.941811, -0.222670, -24.637813>, <-1.072470, -0.317599, -24.458366>, 
      <-0.846972, -0.149477, -25.343498>, <-1.024398, -0.278384, -25.242563>, <-1.239049, -0.434337, -25.043242>, <-1.369707, -0.529266, -24.863794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.925325, -1.134099, -24.859349>, <-1.060956, -1.232640, -24.673070>, <-1.202792, -1.335690, -24.378283>, <-1.273614, -1.387145, -24.143459>, 
      <-0.621150, -0.934342, -24.455464>, <-0.756781, -1.032884, -24.269186>, <-0.808480, -1.070444, -24.159710>, <-0.879301, -1.121899, -23.924886>, 
      <-0.238806, -0.635313, -23.916477>, <-0.257354, -0.648789, -23.891003>, <-0.366948, -0.728414, -23.665293>, <-0.376633, -0.735450, -23.633181>, 
      <0.055416, -0.421548, -23.512390>, <0.036868, -0.435024, -23.486915>, <0.017472, -0.449116, -23.446602>, <0.007787, -0.456153, -23.414490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.392903, -1.372680, -25.435474>, <-1.534409, -1.475490, -25.140258>, <-1.772819, -1.648705, -24.776782>, <-1.869790, -1.719158, -24.455256>, 
      <-1.231513, -1.340485, -25.269374>, <-1.373019, -1.443295, -24.974157>, <-1.574952, -1.589751, -24.687160>, <-1.671923, -1.660205, -24.365634>, 
      <-1.056151, -1.220014, -25.033061>, <-1.191782, -1.318556, -24.846782>, <-1.372461, -1.449822, -24.472333>, <-1.443282, -1.501277, -24.237509>, 
      <-0.925325, -1.134099, -24.859349>, <-1.060956, -1.232640, -24.673070>, <-1.202792, -1.335690, -24.378283>, <-1.273614, -1.387145, -24.143459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.765003, -1.301601, -25.723536>, <-1.930535, -1.421867, -25.392214>, <-2.196143, -1.614843, -24.976032>, <-2.306189, -1.694796, -24.611155>, 
      <-1.651113, -1.355279, -25.656216>, <-1.816645, -1.475545, -25.324894>, <-2.068519, -1.657175, -24.939965>, <-2.178565, -1.737128, -24.575086>, 
      <-1.491449, -1.392338, -25.536896>, <-1.632954, -1.495148, -25.241678>, <-1.895205, -1.685169, -24.832216>, <-1.992176, -1.755623, -24.510688>, 
      <-1.392903, -1.372680, -25.435474>, <-1.534409, -1.475490, -25.140258>, <-1.772819, -1.648705, -24.776782>, <-1.869790, -1.719158, -24.455256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.869712, -1.147952, -25.717312>, <-2.034722, -1.267839, -25.386766>, <-2.299746, -1.460390, -24.971728>, <-2.409509, -1.540138, -24.607786>, 
      <-1.866051, -1.196030, -25.745421>, <-2.031061, -1.315917, -25.414875>, <-2.302405, -1.513943, -24.987205>, <-2.412168, -1.593690, -24.623264>, 
      <-1.809524, -1.280618, -25.749851>, <-1.975056, -1.400884, -25.418530>, <-2.247304, -1.597873, -24.990491>, <-2.357350, -1.677826, -24.625614>, 
      <-1.765003, -1.301601, -25.723536>, <-1.930535, -1.421867, -25.392214>, <-2.196143, -1.614843, -24.976032>, <-2.306189, -1.694796, -24.611155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.802867, -0.804328, -25.432806>, <-1.944152, -0.906977, -25.137925>, <-2.182309, -1.080009, -24.774936>, <-2.279159, -1.150374, -24.453811>, 
      <-1.860863, -0.876089, -25.531805>, <-2.002147, -0.978739, -25.236923>, <-2.263195, -1.168694, -24.829045>, <-2.360045, -1.239060, -24.507920>, 
      <-1.878588, -1.031376, -25.649157>, <-2.043599, -1.151263, -25.318611>, <-2.293473, -1.334047, -24.935213>, <-2.403236, -1.413794, -24.571272>, 
      <-1.869712, -1.147952, -25.717312>, <-2.034722, -1.267839, -25.386766>, <-2.299746, -1.460390, -24.971728>, <-2.409509, -1.540138, -24.607786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.369707, -0.529266, -24.863794>, <-1.505724, -0.628089, -24.676987>, <-1.647964, -0.731432, -24.381357>, <-1.718988, -0.783034, -24.145864>, 
      <-1.494965, -0.618464, -25.034645>, <-1.630982, -0.717287, -24.847837>, <-1.811369, -0.848346, -24.473827>, <-1.882393, -0.899947, -24.238334>, 
      <-1.704361, -0.682440, -25.264654>, <-1.845645, -0.785089, -24.969773>, <-2.046430, -0.931028, -24.684040>, <-2.143280, -1.001393, -24.362915>, 
      <-1.802867, -0.804328, -25.432806>, <-1.944152, -0.906977, -25.137925>, <-2.182309, -1.080009, -24.774936>, <-2.279159, -1.150374, -24.453811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.394923, 0.198291, -23.512390>, <-0.413471, 0.184815, -23.486915>, <-0.432868, 0.170723, -23.446602>, <-0.442553, 0.163686, -23.414490>, 
      <-0.687358, -0.019976, -23.917813>, <-0.705906, -0.033452, -23.892338>, <-0.815798, -0.113293, -23.666014>, <-0.825483, -0.120330, -23.633901>, 
      <-1.072470, -0.317599, -24.458366>, <-1.208487, -0.416421, -24.271558>, <-1.260229, -0.454014, -24.161941>, <-1.331253, -0.505616, -23.926450>, 
      <-1.369707, -0.529266, -24.863794>, <-1.505724, -0.628089, -24.676987>, <-1.647964, -0.731432, -24.381357>, <-1.718988, -0.783034, -24.145864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.273614, -1.387145, -24.143459>, <-1.346343, -1.439986, -23.902309>, <-1.395916, -1.476003, -23.556371>, <-1.395916, -1.476003, -23.299010>, 
      <-0.879301, -1.121899, -23.924886>, <-0.952031, -1.174740, -23.683738>, <-0.969955, -1.187763, -23.556371>, <-0.969955, -1.187763, -23.299010>, 
      <-0.376633, -0.735450, -23.633181>, <-0.386579, -0.742676, -23.600203>, <-0.425032, -0.770614, -23.334203>, <-0.425032, -0.770614, -23.299010>, 
      <0.007787, -0.456153, -23.414490>, <-0.002159, -0.463379, -23.381512>, <-0.008938, -0.468305, -23.334203>, <-0.008938, -0.468305, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.869790, -1.719158, -24.455256>, <-1.969374, -1.791510, -24.125066>, <-2.037251, -1.840826, -23.651398>, <-2.037251, -1.840826, -23.299010>, 
      <-1.671923, -1.660205, -24.365634>, <-1.771507, -1.732557, -24.035442>, <-1.826696, -1.772536, -23.651398>, <-1.826696, -1.772536, -23.299010>, 
      <-1.443282, -1.501277, -24.237509>, <-1.516012, -1.554118, -23.996358>, <-1.579240, -1.600055, -23.556371>, <-1.579240, -1.600055, -23.299010>, 
      <-1.273614, -1.387145, -24.143459>, <-1.346343, -1.439986, -23.902309>, <-1.395916, -1.476003, -23.556371>, <-1.395916, -1.476003, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.306189, -1.694796, -24.611155>, <-2.419200, -1.776903, -24.236445>, <-2.496228, -1.832868, -23.698912>, <-2.496228, -1.832868, -23.299010>, 
      <-2.178565, -1.737128, -24.575086>, <-2.291576, -1.819235, -24.200376>, <-2.363967, -1.871234, -23.698912>, <-2.363967, -1.871234, -23.299010>, 
      <-1.992176, -1.755623, -24.510688>, <-2.091760, -1.827975, -24.180498>, <-2.168247, -1.883312, -23.651398>, <-2.168247, -1.883312, -23.299010>, 
      <-1.869790, -1.719158, -24.455256>, <-1.969374, -1.791510, -24.125066>, <-2.037251, -1.840826, -23.651398>, <-2.037251, -1.840826, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.409509, -1.540138, -24.607786>, <-2.522230, -1.622034, -24.234037>, <-2.599061, -1.677855, -23.697883>, <-2.599061, -1.677855, -23.299010>, 
      <-2.412168, -1.593690, -24.623264>, <-2.524889, -1.675587, -24.249515>, <-2.603997, -1.733442, -23.697883>, <-2.603997, -1.733442, -23.299010>, 
      <-2.357350, -1.677826, -24.625614>, <-2.470361, -1.759933, -24.250904>, <-2.549825, -1.817320, -23.698912>, <-2.549825, -1.817320, -23.299010>, 
      <-2.306189, -1.694796, -24.611155>, <-2.419200, -1.776903, -24.236445>, <-2.496228, -1.832868, -23.698912>, <-2.496228, -1.832868, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.279159, -1.150374, -24.453811>, <-2.378618, -1.222636, -24.124034>, <-2.446410, -1.271889, -23.650957>, <-2.446410, -1.271889, -23.299010>, 
      <-2.360045, -1.239060, -24.507920>, <-2.459504, -1.311321, -24.178141>, <-2.535531, -1.366692, -23.650957>, <-2.535531, -1.366692, -23.299010>, 
      <-2.403236, -1.413794, -24.571272>, <-2.515957, -1.495691, -24.197523>, <-2.587551, -1.548250, -23.697883>, <-2.587551, -1.548250, -23.299010>, 
      <-2.409509, -1.540138, -24.607786>, <-2.522230, -1.622034, -24.234037>, <-2.599061, -1.677855, -23.697883>, <-2.599061, -1.677855, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.718988, -0.783034, -24.145864>, <-1.791925, -0.836025, -23.904027>, <-1.841639, -0.872145, -23.557104>, <-1.841639, -0.872145, -23.299010>, 
      <-1.882393, -0.899947, -24.238334>, <-1.955330, -0.952939, -23.996498>, <-2.018442, -0.998792, -23.557104>, <-2.018442, -0.998792, -23.299010>, 
      <-2.143280, -1.001393, -24.362915>, <-2.242739, -1.073655, -24.033136>, <-2.297448, -1.113430, -23.650957>, <-2.297448, -1.113430, -23.299010>, 
      <-2.279159, -1.150374, -24.453811>, <-2.378618, -1.222636, -24.124034>, <-2.446410, -1.271889, -23.650957>, <-2.446410, -1.271889, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.442553, 0.163686, -23.414490>, <-0.452498, 0.156460, -23.381512>, <-0.459278, 0.151535, -23.334203>, <-0.459278, 0.151535, -23.299010>, 
      <-0.825483, -0.120330, -23.633901>, <-0.835429, -0.127556, -23.600923>, <-0.873986, -0.155569, -23.334203>, <-0.873986, -0.155569, -23.299010>, 
      <-1.331253, -0.505616, -23.926450>, <-1.404190, -0.558608, -23.684613>, <-1.422125, -0.571638, -23.557104>, <-1.422125, -0.571638, -23.299010>, 
      <-1.718988, -0.783034, -24.145864>, <-1.791925, -0.836025, -23.904027>, <-1.841639, -0.872145, -23.557104>, <-1.841639, -0.872145, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.395916, -1.476003, -23.299010>, <-1.395916, -1.476003, -23.041646>, <-1.346344, -1.439986, -22.695709>, <-1.273614, -1.387145, -22.454560>, 
      <-0.969955, -1.187763, -23.299010>, <-0.969955, -1.187763, -23.041646>, <-0.952031, -1.174741, -22.914282>, <-0.879301, -1.121899, -22.673131>, 
      <-0.425032, -0.770614, -23.299010>, <-0.425032, -0.770614, -23.263814>, <-0.386579, -0.742677, -22.997816>, <-0.376633, -0.735451, -22.964838>, 
      <-0.008938, -0.468305, -23.299010>, <-0.008938, -0.468305, -23.263814>, <-0.002159, -0.463379, -23.216507>, <0.007787, -0.456153, -23.183530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.037251, -1.840826, -23.299010>, <-2.037251, -1.840826, -22.946621>, <-1.969374, -1.791510, -22.472954>, <-1.869790, -1.719159, -22.142763>, 
      <-1.826696, -1.772536, -23.299010>, <-1.826696, -1.772536, -22.946621>, <-1.771507, -1.732557, -22.562576>, <-1.671923, -1.660205, -22.232386>, 
      <-1.579240, -1.600055, -23.299010>, <-1.579240, -1.600055, -23.041646>, <-1.516012, -1.554119, -22.601659>, <-1.443282, -1.501277, -22.360510>, 
      <-1.395916, -1.476003, -23.299010>, <-1.395916, -1.476003, -23.041646>, <-1.346344, -1.439986, -22.695709>, <-1.273614, -1.387145, -22.454560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.496228, -1.832868, -23.299010>, <-2.496228, -1.832868, -22.899109>, <-2.419200, -1.776903, -22.361576>, <-2.306190, -1.694796, -21.986866>, 
      <-2.363967, -1.871234, -23.299010>, <-2.363967, -1.871234, -22.899109>, <-2.291576, -1.819235, -22.397645>, <-2.178566, -1.737128, -22.022934>, 
      <-2.168247, -1.883312, -23.299010>, <-2.168247, -1.883312, -22.946621>, <-2.091760, -1.827975, -22.417520>, <-1.992176, -1.755623, -22.087330>, 
      <-2.037251, -1.840826, -23.299010>, <-2.037251, -1.840826, -22.946621>, <-1.969374, -1.791510, -22.472954>, <-1.869790, -1.719159, -22.142763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.599061, -1.677855, -23.299010>, <-2.599061, -1.677855, -22.900134>, <-2.522230, -1.622034, -22.363982>, <-2.409509, -1.540138, -21.990234>, 
      <-2.603997, -1.733442, -23.299010>, <-2.603997, -1.733442, -22.900134>, <-2.524889, -1.675587, -22.348507>, <-2.412168, -1.593691, -21.974758>, 
      <-2.549825, -1.817320, -23.299010>, <-2.549825, -1.817320, -22.899109>, <-2.470362, -1.759933, -22.347118>, <-2.357351, -1.677826, -21.972408>, 
      <-2.496228, -1.832868, -23.299010>, <-2.496228, -1.832868, -22.899109>, <-2.419200, -1.776903, -22.361576>, <-2.306190, -1.694796, -21.986866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.446410, -1.271889, -23.299010>, <-2.446410, -1.271889, -22.947061>, <-2.378619, -1.222636, -22.473986>, <-2.279159, -1.150374, -22.144206>, 
      <-2.535531, -1.366692, -23.299010>, <-2.535531, -1.366692, -22.947061>, <-2.459505, -1.311321, -22.419878>, <-2.360045, -1.239060, -22.090099>, 
      <-2.587551, -1.548250, -23.299010>, <-2.587551, -1.548250, -22.900134>, <-2.515957, -1.495691, -22.400498>, <-2.403236, -1.413795, -22.026749>, 
      <-2.599061, -1.677855, -23.299010>, <-2.599061, -1.677855, -22.900134>, <-2.522230, -1.622034, -22.363982>, <-2.409509, -1.540138, -21.990234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.841639, -0.872145, -23.299010>, <-1.841639, -0.872145, -23.040915>, <-1.791925, -0.836025, -22.693990>, <-1.718988, -0.783034, -22.452154>, 
      <-2.018442, -0.998792, -23.299010>, <-2.018442, -0.998792, -23.040915>, <-1.955330, -0.952939, -22.601520>, <-1.882393, -0.899947, -22.359683>, 
      <-2.297448, -1.113430, -23.299010>, <-2.297448, -1.113430, -22.947061>, <-2.242739, -1.073655, -22.564880>, <-2.143280, -1.001393, -22.235102>, 
      <-2.446410, -1.271889, -23.299010>, <-2.446410, -1.271889, -22.947061>, <-2.378619, -1.222636, -22.473986>, <-2.279159, -1.150374, -22.144206>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.459278, 0.151535, -23.299010>, <-0.459278, 0.151535, -23.263814>, <-0.452499, 0.156460, -23.216507>, <-0.442553, 0.163686, -23.183530>, 
      <-0.873986, -0.155569, -23.299010>, <-0.873986, -0.155569, -23.263814>, <-0.835429, -0.127556, -22.997094>, <-0.825483, -0.120330, -22.964117>, 
      <-1.422125, -0.571638, -23.299010>, <-1.422125, -0.571638, -23.040915>, <-1.404190, -0.558608, -22.913406>, <-1.331253, -0.505616, -22.671570>, 
      <-1.841639, -0.872145, -23.299010>, <-1.841639, -0.872145, -23.040915>, <-1.791925, -0.836025, -22.693990>, <-1.718988, -0.783034, -22.452154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.039177, -3.194047, -22.454560>, <0.109999, -3.142592, -22.219736>, <0.251835, -3.039542, -21.924947>, <0.387466, -2.941001, -21.738670>, 
      <0.433490, -2.928802, -22.673131>, <0.504312, -2.877347, -22.438309>, <0.556011, -2.839786, -22.328832>, <0.691642, -2.741244, -22.142555>, 
      <0.936158, -2.542353, -22.964838>, <0.945843, -2.535316, -22.932726>, <1.055437, -2.455691, -22.707016>, <1.073985, -2.442215, -22.681541>, 
      <1.320578, -2.263055, -23.183530>, <1.330263, -2.256018, -23.151416>, <1.349659, -2.241926, -23.111102>, <1.368207, -2.228450, -23.085629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.556999, -3.526061, -22.142763>, <-0.460028, -3.455608, -21.821235>, <-0.265822, -3.314508, -21.417603>, <-0.080112, -3.179582, -21.162546>, 
      <-0.359132, -3.467107, -22.232386>, <-0.262161, -3.396654, -21.910858>, <-0.104432, -3.282314, -21.583702>, <0.081277, -3.147388, -21.328646>, 
      <-0.130491, -3.308180, -22.360510>, <-0.059670, -3.256725, -22.125686>, <0.121009, -3.125458, -21.751238>, <0.256640, -3.026916, -21.564960>, 
      <0.039177, -3.194047, -22.454560>, <0.109999, -3.142592, -22.219736>, <0.251835, -3.039542, -21.924947>, <0.387466, -2.941001, -21.738670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.993398, -3.501698, -21.986866>, <-0.883353, -3.421745, -21.621989>, <-0.662961, -3.261622, -21.163930>, <-0.452212, -3.108503, -20.874485>, 
      <-0.865774, -3.544030, -22.022934>, <-0.755729, -3.464077, -21.658056>, <-0.549072, -3.315300, -21.231250>, <-0.338323, -3.162181, -20.941805>, 
      <-0.679385, -3.562525, -22.087330>, <-0.582414, -3.492072, -21.765802>, <-0.364367, -3.334167, -21.316181>, <-0.178658, -3.199240, -21.061125>, 
      <-0.556999, -3.526061, -22.142763>, <-0.460028, -3.455608, -21.821235>, <-0.265822, -3.314508, -21.417603>, <-0.080112, -3.179582, -21.162546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.096718, -3.347040, -21.990234>, <-0.986955, -3.267293, -21.626291>, <-0.767130, -3.107580, -21.169408>, <-0.556921, -2.954855, -20.880707>, 
      <-1.099377, -3.400593, -21.974758>, <-0.989614, -3.320845, -21.610814>, <-0.763469, -3.155658, -21.141301>, <-0.553260, -3.002932, -20.852598>, 
      <-1.044559, -3.484728, -21.972408>, <-0.934514, -3.404775, -21.607531>, <-0.707482, -3.240638, -21.137613>, <-0.496733, -3.087520, -20.848170>, 
      <-0.993398, -3.501698, -21.986866>, <-0.883353, -3.421745, -21.621989>, <-0.662961, -3.261622, -21.163930>, <-0.452212, -3.108503, -20.874485>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.966368, -2.957277, -22.144206>, <-0.869518, -2.886911, -21.823082>, <-0.675554, -2.745988, -21.419952>, <-0.490076, -2.611230, -21.165214>, 
      <-1.047254, -3.045962, -22.090099>, <-0.950404, -2.975596, -21.768974>, <-0.733550, -2.817749, -21.320954>, <-0.548072, -2.682992, -21.066216>, 
      <-1.090445, -3.220697, -22.026749>, <-0.980682, -3.140949, -21.662805>, <-0.776006, -2.991004, -21.237565>, <-0.565798, -2.838278, -20.948862>, 
      <-1.096718, -3.347040, -21.990234>, <-0.986955, -3.267293, -21.626291>, <-0.767130, -3.107580, -21.169408>, <-0.556921, -2.954855, -20.880707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.406197, -2.589936, -22.452154>, <-0.335173, -2.538334, -22.216664>, <-0.192933, -2.434991, -21.921034>, <-0.056916, -2.336169, -21.734226>, 
      <-0.569602, -2.706849, -22.359683>, <-0.498578, -2.655248, -22.124194>, <-0.318191, -2.524189, -21.750182>, <-0.182174, -2.425367, -21.563376>, 
      <-0.830488, -2.808295, -22.235102>, <-0.733639, -2.737930, -21.913976>, <-0.577048, -2.624100, -21.588104>, <-0.391570, -2.489342, -21.333366>, 
      <-0.966368, -2.957277, -22.144206>, <-0.869518, -2.886911, -21.823082>, <-0.675554, -2.745988, -21.419952>, <-0.490076, -2.611230, -21.165214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.870239, -1.643216, -23.183530>, <0.879924, -1.636179, -23.151416>, <0.899320, -1.622087, -23.111102>, <0.917868, -1.608612, -23.085630>, 
      <0.487308, -1.927232, -22.964117>, <0.496993, -1.920195, -22.932005>, <0.606885, -1.840354, -22.705682>, <0.625433, -1.826879, -22.680208>, 
      <-0.018461, -2.312518, -22.671570>, <0.052562, -2.260916, -22.436078>, <0.104304, -2.223323, -22.326462>, <0.240322, -2.124501, -22.139654>, 
      <-0.406197, -2.589936, -22.452154>, <-0.335173, -2.538334, -22.216664>, <-0.192933, -2.434991, -21.921034>, <-0.056916, -2.336169, -21.734226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.387466, -2.941001, -21.738670>, <0.517753, -2.846341, -21.559733>, <0.731794, -2.690832, -21.360976>, <0.908716, -2.562291, -21.260328>, 
      <0.691642, -2.741244, -22.142555>, <0.821929, -2.646585, -21.963618>, <0.901053, -2.589099, -21.888696>, <1.077974, -2.460558, -21.788050>, 
      <1.073985, -2.442215, -22.681541>, <1.091802, -2.429271, -22.657072>, <1.256063, -2.309928, -22.506014>, <1.280257, -2.292350, -22.492251>, 
      <1.368207, -2.228450, -23.085629>, <1.386024, -2.215506, -23.061158>, <1.415295, -2.194239, -23.033979>, <1.439489, -2.176661, -23.020216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.080112, -3.179582, -21.162546>, <0.098282, -3.049971, -20.917538>, <0.391353, -2.837043, -20.645394>, <0.633600, -2.661040, -20.507584>, 
      <0.081277, -3.147388, -21.328646>, <0.259671, -3.017777, -21.083637>, <0.497533, -2.845184, -20.862984>, <0.739779, -2.669181, -20.725174>, 
      <0.256640, -3.026916, -21.564960>, <0.386927, -2.932256, -21.386022>, <0.659024, -2.734570, -21.134088>, <0.835945, -2.606029, -21.033442>, 
      <0.387466, -2.941001, -21.738670>, <0.517753, -2.846341, -21.559733>, <0.731794, -2.690832, -21.360976>, <0.908716, -2.562291, -21.260328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.452212, -3.108503, -20.874485>, <-0.249765, -2.961417, -20.596443>, <0.082821, -2.719779, -20.287605>, <0.357730, -2.520046, -20.131214>, 
      <-0.338323, -3.162181, -20.941805>, <-0.135876, -3.015095, -20.663763>, <0.175077, -2.790451, -20.376384>, <0.449986, -2.590718, -20.219994>, 
      <-0.178658, -3.199240, -21.061125>, <-0.000264, -3.069630, -20.816117>, <0.327254, -2.832128, -20.514037>, <0.569500, -2.656126, -20.376227>, 
      <-0.080112, -3.179582, -21.162546>, <0.098282, -3.049971, -20.917538>, <0.391353, -2.837043, -20.645394>, <0.633600, -2.661040, -20.507584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.556921, -2.954855, -20.880707>, <-0.354994, -2.808146, -20.603378>, <-0.023261, -2.567128, -20.295334>, <0.250943, -2.367908, -20.139344>, 
      <-0.553260, -3.002932, -20.852598>, <-0.351333, -2.856224, -20.575270>, <-0.010426, -2.607701, -20.259216>, <0.263777, -2.408481, -20.103226>, 
      <-0.496733, -3.087520, -20.848170>, <-0.294286, -2.940434, -20.570128>, <0.047611, -2.692806, -20.253722>, <0.322520, -2.493073, -20.097330>, 
      <-0.452212, -3.108503, -20.874485>, <-0.249765, -2.961417, -20.596443>, <0.082821, -2.719779, -20.287605>, <0.357730, -2.520046, -20.131214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.490076, -2.611230, -21.165214>, <-0.311905, -2.481781, -20.920514>, <-0.019200, -2.269119, -20.648709>, <0.222744, -2.093336, -20.511070>, 
      <-0.548072, -2.682992, -21.066216>, <-0.369901, -2.553543, -20.821514>, <-0.043908, -2.316439, -20.520477>, <0.198036, -2.140656, -20.382840>, 
      <-0.565798, -2.838278, -20.948862>, <-0.363870, -2.691570, -20.671533>, <-0.055201, -2.466161, -20.385214>, <0.219002, -2.266941, -20.229224>, 
      <-0.556921, -2.954855, -20.880707>, <-0.354994, -2.808146, -20.603378>, <-0.023261, -2.567128, -20.295334>, <0.250943, -2.367908, -20.139344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056916, -2.336169, -21.734226>, <0.073743, -2.241240, -21.554779>, <0.288393, -2.085287, -21.355456>, <0.465819, -1.956379, -21.254520>, 
      <-0.182174, -2.425367, -21.563376>, <-0.051515, -2.330438, -21.383928>, <0.220214, -2.133015, -21.132242>, <0.397640, -2.004107, -21.031307>, 
      <-0.391570, -2.489342, -21.333366>, <-0.213399, -2.359894, -21.088666>, <0.023176, -2.187960, -20.868635>, <0.265121, -2.012177, -20.730997>, 
      <-0.490076, -2.611230, -21.165214>, <-0.311905, -2.481781, -20.920514>, <-0.019200, -2.269119, -20.648709>, <0.222744, -2.093336, -20.511070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.917868, -1.608612, -23.085630>, <0.935685, -1.595667, -23.061162>, <0.964956, -1.574400, -23.033979>, <0.989150, -1.556822, -23.020216>, 
      <0.625433, -1.826879, -22.680208>, <0.643250, -1.813934, -22.655739>, <0.807956, -1.694267, -22.504270>, <0.832151, -1.676689, -22.490507>, 
      <0.240322, -2.124501, -22.139654>, <0.370980, -2.029572, -21.960206>, <0.450193, -1.972021, -21.885171>, <0.627618, -1.843113, -21.784237>, 
      <-0.056916, -2.336169, -21.734226>, <0.073743, -2.241240, -21.554779>, <0.288393, -2.085287, -21.355456>, <0.465819, -1.956379, -21.254520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.908716, -2.562291, -21.260328>, <1.080322, -2.437612, -21.162704>, <1.334664, -2.252821, -21.092358>, <1.523572, -2.115571, -21.092358>, 
      <1.077974, -2.460558, -21.788050>, <1.249580, -2.335879, -21.690426>, <1.344765, -2.266724, -21.663566>, <1.533673, -2.129474, -21.663566>, 
      <1.280257, -2.292350, -22.492251>, <1.303725, -2.275300, -22.478901>, <1.497739, -2.134340, -22.425779>, <1.523572, -2.115571, -22.425779>, 
      <1.439489, -2.176661, -23.020216>, <1.462957, -2.159611, -23.006867>, <1.497739, -2.134340, -22.997246>, <1.523572, -2.115571, -22.997246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.633600, -2.661040, -20.507584>, <0.868568, -2.490326, -20.373915>, <1.216821, -2.237305, -20.277594>, <1.475480, -2.049378, -20.277594>, 
      <0.739779, -2.669181, -20.725174>, <0.974747, -2.498467, -20.591506>, <1.257416, -2.293180, -20.513344>, <1.516075, -2.105253, -20.513344>, 
      <0.835945, -2.606029, -21.033442>, <1.007551, -2.481350, -20.935818>, <1.330322, -2.246845, -20.846810>, <1.519230, -2.109595, -20.846810>, 
      <0.908716, -2.562291, -21.260328>, <1.080322, -2.437612, -21.162704>, <1.334664, -2.252821, -21.092358>, <1.523572, -2.115571, -21.092358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.357730, -2.520046, -20.131214>, <0.624379, -2.326314, -19.979520>, <1.019588, -2.039178, -19.870211>, <1.313123, -1.825913, -19.870211>, 
      <0.449986, -2.590718, -20.219994>, <0.716635, -2.396986, -20.068301>, <1.085308, -2.129633, -19.966658>, <1.378843, -1.916368, -19.966658>, 
      <0.569500, -2.656126, -20.376227>, <0.804468, -2.485411, -20.242557>, <1.192420, -2.203720, -20.135891>, <1.451079, -2.015794, -20.135891>, 
      <0.633600, -2.661040, -20.507584>, <0.868568, -2.490326, -20.373915>, <1.216821, -2.237305, -20.277594>, <1.475480, -2.049378, -20.277594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.250943, -2.367908, -20.139344>, <0.516907, -2.174673, -19.988042>, <0.911101, -1.888274, -19.879013>, <1.203882, -1.675556, -19.879013>, 
      <0.263777, -2.408481, -20.103226>, <0.529742, -2.215246, -19.951923>, <0.934670, -1.920713, -19.840181>, <1.227451, -1.707995, -19.840181>, 
      <0.322520, -2.493073, -20.097330>, <0.589169, -2.299341, -19.945637>, <0.994745, -2.004984, -19.833752>, <1.288279, -1.791719, -19.833752>, 
      <0.357730, -2.520046, -20.131214>, <0.624379, -2.326314, -19.979520>, <1.019588, -2.039178, -19.870211>, <1.313123, -1.825913, -19.870211>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.222744, -2.093336, -20.511070>, <0.457419, -1.922835, -20.377568>, <0.805237, -1.670130, -20.281365>, <1.063574, -1.482438, -20.281365>, 
      <0.198036, -2.140656, -20.382840>, <0.432711, -1.970155, -20.249336>, <0.819157, -1.689289, -20.143026>, <1.077493, -1.501597, -20.143026>, 
      <0.219002, -2.266941, -20.229224>, <0.484967, -2.073706, -20.077922>, <0.851840, -1.806708, -19.976650>, <1.144621, -1.593990, -19.976650>, 
      <0.250943, -2.367908, -20.139344>, <0.516907, -2.174673, -19.988042>, <0.911101, -1.888274, -19.879013>, <1.203882, -1.675556, -19.879013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465819, -1.956379, -21.254520>, <0.637914, -1.831345, -21.156618>, <0.892981, -1.646028, -21.086070>, <1.082427, -1.508387, -21.086070>, 
      <0.397640, -2.004107, -21.031307>, <0.569735, -1.879073, -20.933405>, <0.892121, -1.644846, -20.844470>, <1.081568, -1.507205, -20.844470>, 
      <0.265121, -2.012177, -20.730997>, <0.499795, -1.841676, -20.597494>, <0.781276, -1.637150, -20.519504>, <1.039612, -1.449457, -20.519504>, 
      <0.222744, -2.093336, -20.511070>, <0.457419, -1.922835, -20.377568>, <0.805237, -1.670130, -20.281365>, <1.063574, -1.482438, -20.281365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.989150, -1.556822, -23.020216>, <1.012617, -1.539772, -23.006867>, <1.047399, -1.514501, -22.997246>, <1.073233, -1.495732, -22.997246>, 
      <0.832151, -1.676689, -22.490507>, <0.855618, -1.659639, -22.477157>, <1.050158, -1.518298, -22.423893>, <1.075991, -1.499529, -22.423893>, 
      <0.627618, -1.843113, -21.784237>, <0.799713, -1.718079, -21.686334>, <0.895020, -1.648835, -21.659432>, <1.084466, -1.511194, -21.659432>, 
      <0.465819, -1.956379, -21.254520>, <0.637914, -1.831345, -21.156618>, <0.892981, -1.646028, -21.086070>, <1.082427, -1.508387, -21.086070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.523572, -2.115571, -21.092358>, <1.712481, -1.978321, -21.092358>, <1.966823, -1.793531, -21.162704>, <2.138429, -1.668852, -21.260328>, 
      <1.533673, -2.129474, -21.663566>, <1.722581, -1.992224, -21.663566>, <1.817765, -1.923068, -21.690424>, <1.989371, -1.798389, -21.788048>, 
      <1.523572, -2.115571, -22.425779>, <1.549406, -2.096802, -22.425779>, <1.743420, -1.955842, -22.478899>, <1.766887, -1.938792, -22.492248>, 
      <1.523572, -2.115571, -22.997246>, <1.549406, -2.096802, -22.997246>, <1.584188, -2.071531, -23.006864>, <1.607655, -2.054481, -23.020214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.475480, -2.049378, -20.277594>, <1.734139, -1.861452, -20.277594>, <2.082392, -1.608431, -20.373915>, <2.317361, -1.437716, -20.507584>, 
      <1.516075, -2.105253, -20.513344>, <1.774735, -1.917326, -20.513344>, <2.057324, -1.711929, -20.591506>, <2.292292, -1.541215, -20.725174>, 
      <1.519230, -2.109595, -20.846810>, <1.708138, -1.972345, -20.846810>, <2.030908, -1.737838, -20.935818>, <2.202514, -1.613159, -21.033442>, 
      <1.523572, -2.115571, -21.092358>, <1.712481, -1.978321, -21.092358>, <1.966823, -1.793531, -21.162704>, <2.138429, -1.668852, -21.260328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313123, -1.825913, -19.870211>, <1.606657, -1.612647, -19.870211>, <2.001866, -1.325512, -19.979518>, <2.268515, -1.131779, -20.131213>, 
      <1.378843, -1.916368, -19.966658>, <1.672377, -1.703103, -19.966658>, <2.040570, -1.435091, -20.068298>, <2.307220, -1.241359, -20.219992>, 
      <1.451079, -2.015794, -20.135891>, <1.709738, -1.827867, -20.135891>, <2.097526, -1.545950, -20.242557>, <2.332494, -1.375236, -20.376227>, 
      <1.475480, -2.049378, -20.277594>, <1.734139, -1.861452, -20.277594>, <2.082392, -1.608431, -20.373915>, <2.317361, -1.437716, -20.507584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.203882, -1.675556, -19.879013>, <1.496663, -1.462838, -19.879013>, <1.890857, -1.176440, -19.988042>, <2.156822, -0.983205, -20.139344>, 
      <1.227451, -1.707995, -19.840181>, <1.520232, -1.495278, -19.840181>, <1.925478, -1.201184, -19.951923>, <2.191443, -1.007949, -20.103226>, 
      <1.288279, -1.791719, -19.833752>, <1.581814, -1.578454, -19.833752>, <1.987094, -1.283689, -19.945635>, <2.253743, -1.089957, -20.097328>, 
      <1.313123, -1.825913, -19.870211>, <1.606657, -1.612647, -19.870211>, <2.001866, -1.325512, -19.979518>, <2.268515, -1.131779, -20.131213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.063574, -1.482438, -20.281365>, <1.321910, -1.294745, -20.281365>, <1.669728, -1.042041, -20.377568>, <1.904403, -0.871540, -20.511070>, 
      <1.077493, -1.501597, -20.143026>, <1.335830, -1.313904, -20.143026>, <1.722368, -1.033165, -20.249336>, <1.957043, -0.862664, -20.382840>, 
      <1.144621, -1.593990, -19.976650>, <1.437402, -1.381272, -19.976650>, <1.804703, -1.114862, -20.077922>, <2.070667, -0.921628, -20.229224>, 
      <1.203882, -1.675556, -19.879013>, <1.496663, -1.462838, -19.879013>, <1.890857, -1.176440, -19.988042>, <2.156822, -0.983205, -20.139344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.082427, -1.508387, -21.086070>, <1.271874, -1.370746, -21.086070>, <1.526941, -1.185429, -21.156618>, <1.699035, -1.060395, -21.254520>, 
      <1.081568, -1.507205, -20.844470>, <1.271014, -1.369564, -20.844470>, <1.593401, -1.135336, -20.933405>, <1.765496, -1.010302, -21.031307>, 
      <1.039612, -1.449457, -20.519504>, <1.297948, -1.261765, -20.519504>, <1.579447, -1.057264, -20.597494>, <1.814122, -0.886762, -20.730997>, 
      <1.063574, -1.482438, -20.281365>, <1.321910, -1.294745, -20.281365>, <1.669728, -1.042041, -20.377568>, <1.904403, -0.871540, -20.511070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.073233, -1.495732, -22.997246>, <1.099067, -1.476963, -22.997246>, <1.133848, -1.451693, -23.006867>, <1.157316, -1.434642, -23.020216>, 
      <1.075991, -1.499529, -22.423893>, <1.101825, -1.480759, -22.423893>, <1.296364, -1.339418, -22.477157>, <1.319832, -1.322368, -22.490507>, 
      <1.084466, -1.511194, -21.659432>, <1.273913, -1.373553, -21.659432>, <1.369220, -1.304309, -21.686334>, <1.541314, -1.179274, -21.784237>, 
      <1.082427, -1.508387, -21.086070>, <1.271874, -1.370746, -21.086070>, <1.526941, -1.185429, -21.156618>, <1.699035, -1.060395, -21.254520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.138429, -1.668852, -21.260328>, <2.315350, -1.540311, -21.360976>, <2.529391, -1.384801, -21.559733>, <2.659679, -1.290142, -21.738670>, 
      <1.989371, -1.798389, -21.788048>, <2.166293, -1.669848, -21.888694>, <2.245416, -1.612361, -21.963618>, <2.375704, -1.517702, -22.142555>, 
      <1.766887, -1.938792, -22.492248>, <1.791082, -1.921214, -22.506011>, <1.955343, -1.801872, -22.657072>, <1.973160, -1.788927, -22.681541>, 
      <1.607655, -2.054481, -23.020214>, <1.631850, -2.036903, -23.033978>, <1.661120, -2.015637, -23.061158>, <1.678937, -2.002692, -23.085629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.317361, -1.437716, -20.507584>, <2.559607, -1.261714, -20.645394>, <2.852679, -1.048785, -20.917536>, <3.031072, -0.919174, -21.162544>, 
      <2.292292, -1.541215, -20.725174>, <2.534539, -1.365212, -20.862984>, <2.772188, -1.192327, -21.083637>, <2.950582, -1.062716, -21.328646>, 
      <2.202514, -1.613159, -21.033442>, <2.379435, -1.484618, -21.134088>, <2.651529, -1.286927, -21.386021>, <2.781816, -1.192268, -21.564958>, 
      <2.138429, -1.668852, -21.260328>, <2.315350, -1.540311, -21.360976>, <2.529391, -1.384801, -21.559733>, <2.659679, -1.290142, -21.738670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.268515, -1.131779, -20.131213>, <2.543424, -0.932046, -20.287603>, <2.876011, -0.690408, -20.596440>, <3.078458, -0.543322, -20.874482>, 
      <2.307220, -1.241359, -20.219992>, <2.582129, -1.041626, -20.376382>, <2.891868, -0.815311, -20.663760>, <3.094315, -0.668225, -20.941802>, 
      <2.332494, -1.375236, -20.376227>, <2.574741, -1.199233, -20.514037>, <2.901827, -0.961137, -20.816112>, <3.080221, -0.831527, -21.061122>, 
      <2.317361, -1.437716, -20.507584>, <2.559607, -1.261714, -20.645394>, <2.852679, -1.048785, -20.917536>, <3.031072, -0.919174, -21.162544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.156822, -0.983205, -20.139344>, <2.431026, -0.783984, -20.295334>, <2.762759, -0.542966, -20.603378>, <2.964686, -0.396258, -20.880707>, 
      <2.191443, -1.007949, -20.103226>, <2.465647, -0.808729, -20.259216>, <2.807352, -0.561305, -20.575270>, <3.009279, -0.414596, -20.852598>, 
      <2.253743, -1.089957, -20.097328>, <2.528652, -0.890224, -20.253720>, <2.869812, -0.641582, -20.570123>, <3.072259, -0.494495, -20.848165>, 
      <2.268515, -1.131779, -20.131213>, <2.543424, -0.932046, -20.287603>, <2.876011, -0.690408, -20.596440>, <3.078458, -0.543322, -20.874482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904403, -0.871540, -20.511070>, <2.146347, -0.695757, -20.648709>, <2.439053, -0.483094, -20.920512>, <2.617224, -0.353645, -21.165213>, 
      <1.957043, -0.862664, -20.382840>, <2.198987, -0.686881, -20.520477>, <2.525223, -0.450112, -20.821512>, <2.703394, -0.320663, -21.066214>, 
      <2.070667, -0.921628, -20.229224>, <2.344871, -0.722407, -20.385214>, <2.654631, -0.498500, -20.671536>, <2.856559, -0.351792, -20.948864>, 
      <2.156822, -0.983205, -20.139344>, <2.431026, -0.783984, -20.295334>, <2.762759, -0.542966, -20.603378>, <2.964686, -0.396258, -20.880707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699035, -1.060395, -21.254520>, <1.876461, -0.931488, -21.355456>, <2.091112, -0.775535, -21.554778>, <2.221771, -0.680606, -21.734224>, 
      <1.765496, -1.010302, -21.031307>, <1.942922, -0.881394, -21.132242>, <2.214651, -0.683971, -21.383926>, <2.345310, -0.589042, -21.563373>, 
      <1.814122, -0.886762, -20.730997>, <2.056066, -0.710980, -20.868635>, <2.292690, -0.539114, -21.088662>, <2.470861, -0.409665, -21.333365>, 
      <1.904403, -0.871540, -20.511070>, <2.146347, -0.695757, -20.648709>, <2.439053, -0.483094, -20.920512>, <2.617224, -0.353645, -21.165213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.157316, -1.434642, -23.020216>, <1.181510, -1.417064, -23.033979>, <1.210781, -1.395798, -23.061158>, <1.228598, -1.382853, -23.085629>, 
      <1.319832, -1.322368, -22.490507>, <1.344026, -1.304790, -22.504270>, <1.508733, -1.185124, -22.655738>, <1.526550, -1.172179, -22.680206>, 
      <1.541314, -1.179274, -21.784237>, <1.718740, -1.050367, -21.885171>, <1.797953, -0.992816, -21.960205>, <1.928611, -0.897887, -22.139653>, 
      <1.699035, -1.060395, -21.254520>, <1.876461, -0.931488, -21.355456>, <2.091112, -0.775535, -21.554778>, <2.221771, -0.680606, -21.734224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.659679, -1.290142, -21.738670>, <2.795310, -1.191600, -21.924947>, <2.937145, -1.088550, -22.219736>, <3.007967, -1.037095, -22.454560>, 
      <2.375704, -1.517702, -22.142555>, <2.511334, -1.419160, -22.328832>, <2.563033, -1.381598, -22.438309>, <2.633854, -1.330143, -22.673131>, 
      <1.973160, -1.788927, -22.681541>, <1.991708, -1.775451, -22.707016>, <2.101302, -1.695826, -22.932726>, <2.110987, -1.688790, -22.964838>, 
      <1.678937, -2.002692, -23.085629>, <1.697485, -1.989216, -23.111102>, <1.716881, -1.975124, -23.151416>, <1.726566, -1.968087, -23.183530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.031072, -0.919174, -21.162544>, <3.216782, -0.784248, -21.417600>, <3.410988, -0.643149, -21.821235>, <3.507959, -0.572696, -22.142763>, 
      <2.950582, -1.062716, -21.328646>, <3.136292, -0.927790, -21.583702>, <3.293776, -0.813114, -21.910858>, <3.390747, -0.742661, -22.232386>, 
      <2.781816, -1.192268, -21.564958>, <2.917447, -1.093726, -21.751235>, <3.098122, -0.962455, -22.125686>, <3.168944, -0.911000, -22.360510>, 
      <2.659679, -1.290142, -21.738670>, <2.795310, -1.191600, -21.924947>, <2.937145, -1.088550, -22.219736>, <3.007967, -1.037095, -22.454560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.078458, -0.543322, -20.874482>, <3.289207, -0.390203, -21.163926>, <3.509598, -0.230080, -21.621986>, <3.619644, -0.150127, -21.986866>, 
      <3.094315, -0.668225, -20.941802>, <3.305064, -0.515106, -21.231246>, <3.510420, -0.364539, -21.658054>, <3.620466, -0.284586, -22.022934>, 
      <3.080221, -0.831527, -21.061122>, <3.265931, -0.696600, -21.316178>, <3.483487, -0.538022, -21.765802>, <3.580458, -0.467568, -22.087330>, 
      <3.031072, -0.919174, -21.162544>, <3.216782, -0.784248, -21.417600>, <3.410988, -0.643149, -21.821235>, <3.507959, -0.572696, -22.142763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.964686, -0.396258, -20.880707>, <3.174894, -0.243532, -21.169408>, <3.394720, -0.083820, -21.626291>, <3.504483, -0.004072, -21.990234>, 
      <3.009279, -0.414596, -20.852598>, <3.219488, -0.261871, -21.141301>, <3.446473, -0.097840, -21.610814>, <3.556236, -0.018092, -21.974758>, 
      <3.072259, -0.494495, -20.848165>, <3.283009, -0.341377, -21.137611>, <3.509268, -0.176179, -21.607528>, <3.619314, -0.096226, -21.972408>, 
      <3.078458, -0.543322, -20.874482>, <3.289207, -0.390203, -21.163926>, <3.509598, -0.230080, -21.621986>, <3.619644, -0.150127, -21.986866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.617224, -0.353645, -21.165213>, <2.802702, -0.218887, -21.419950>, <2.996666, -0.077964, -21.823082>, <3.093516, -0.007599, -22.144206>, 
      <2.703394, -0.320663, -21.066214>, <2.888873, -0.185906, -21.320952>, <3.106005, -0.028443, -21.768974>, <3.202855, 0.041923, -22.090099>, 
      <2.856559, -0.351792, -20.948864>, <3.066767, -0.199066, -21.237566>, <3.272622, -0.050743, -21.662805>, <3.382385, 0.029004, -22.026749>, 
      <2.964686, -0.396258, -20.880707>, <3.174894, -0.243532, -21.169408>, <3.394720, -0.083820, -21.626291>, <3.504483, -0.004072, -21.990234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.221771, -0.680606, -21.734224>, <2.357788, -0.581783, -21.921032>, <2.500028, -0.478440, -22.216661>, <2.571051, -0.426839, -22.452154>, 
      <2.345310, -0.589042, -21.563373>, <2.481327, -0.490220, -21.750181>, <2.661714, -0.359161, -22.124192>, <2.732738, -0.307560, -22.359683>, 
      <2.470861, -0.409665, -21.333365>, <2.656339, -0.274907, -21.588102>, <2.812987, -0.161156, -21.913976>, <2.909837, -0.090790, -22.235102>, 
      <2.617224, -0.353645, -21.165213>, <2.802702, -0.218887, -21.419950>, <2.996666, -0.077964, -21.823082>, <3.093516, -0.007599, -22.144206>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.228598, -1.382853, -23.085629>, <1.247146, -1.369377, -23.111102>, <1.266542, -1.355285, -23.151416>, <1.276227, -1.348248, -23.183530>, 
      <1.526550, -1.172179, -22.680206>, <1.545098, -1.158703, -22.705682>, <1.654989, -1.078862, -22.932005>, <1.664674, -1.071825, -22.964117>, 
      <1.928611, -0.897887, -22.139653>, <2.064629, -0.799064, -22.326459>, <2.116371, -0.761471, -22.436077>, <2.187395, -0.709870, -22.671570>, 
      <2.221771, -0.680606, -21.734224>, <2.357788, -0.581783, -21.921032>, <2.500028, -0.478440, -22.216661>, <2.571051, -0.426839, -22.452154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.007967, -1.037095, -22.454560>, <3.080697, -0.984254, -22.695709>, <3.130270, -0.948237, -23.041646>, <3.130270, -0.948237, -23.299010>, 
      <2.633854, -1.330143, -22.673131>, <2.706584, -1.277302, -22.914282>, <2.724508, -1.264279, -23.041646>, <2.724508, -1.264279, -23.299010>, 
      <2.110987, -1.688790, -22.964838>, <2.120933, -1.681563, -22.997816>, <2.159385, -1.653626, -23.263814>, <2.159385, -1.653626, -23.299010>, 
      <1.726566, -1.968087, -23.183530>, <1.736512, -1.960861, -23.216507>, <1.743292, -1.955936, -23.263814>, <1.743292, -1.955936, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.507959, -0.572696, -22.142763>, <3.607543, -0.500344, -22.472954>, <3.675420, -0.451029, -22.946621>, <3.675420, -0.451029, -23.299010>, 
      <3.390747, -0.742661, -22.232386>, <3.490331, -0.670309, -22.562576>, <3.545408, -0.630175, -22.946621>, <3.545408, -0.630175, -23.299010>, 
      <3.168944, -0.911000, -22.360510>, <3.241673, -0.858159, -22.601659>, <3.304900, -0.812220, -23.041646>, <3.304900, -0.812220, -23.299010>, 
      <3.007967, -1.037095, -22.454560>, <3.080697, -0.984254, -22.695709>, <3.130270, -0.948237, -23.041646>, <3.130270, -0.948237, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.619644, -0.150127, -21.986866>, <3.732655, -0.068020, -22.361576>, <3.809683, -0.012055, -22.899109>, <3.809683, -0.012055, -23.299010>, 
      <3.620466, -0.284586, -22.022934>, <3.733477, -0.202479, -22.397645>, <3.805301, -0.149700, -22.899109>, <3.805301, -0.149700, -23.299010>, 
      <3.580458, -0.467568, -22.087330>, <3.680042, -0.395216, -22.417520>, <3.756307, -0.339572, -22.946621>, <3.756307, -0.339572, -23.299010>, 
      <3.507959, -0.572696, -22.142763>, <3.607543, -0.500344, -22.472954>, <3.675420, -0.451029, -22.946621>, <3.675420, -0.451029, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.504483, -0.004072, -21.990234>, <3.617204, 0.077825, -22.363982>, <3.694035, 0.133645, -22.900134>, <3.694035, 0.133645, -23.299010>, 
      <3.556236, -0.018092, -21.974758>, <3.668957, 0.063805, -22.348507>, <3.748427, 0.121163, -22.900134>, <3.748427, 0.121163, -23.299010>, 
      <3.619314, -0.096226, -21.972408>, <3.732325, -0.014119, -22.347118>, <3.811459, 0.043722, -22.899109>, <3.811459, 0.043722, -23.299010>, 
      <3.619644, -0.150127, -21.986866>, <3.732655, -0.068020, -22.361576>, <3.809683, -0.012055, -22.899109>, <3.809683, -0.012055, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.093516, -0.007599, -22.144206>, <3.192975, 0.064663, -22.473986>, <3.260767, 0.113916, -22.947061>, <3.260767, 0.113916, -23.299010>, 
      <3.202855, 0.041923, -22.090099>, <3.302315, 0.114185, -22.419878>, <3.378469, 0.169379, -22.947061>, <3.378469, 0.169379, -23.299010>, 
      <3.382385, 0.029004, -22.026749>, <3.495106, 0.110901, -22.400498>, <3.567216, 0.162749, -22.900134>, <3.567216, 0.162749, -23.299010>, 
      <3.504483, -0.004072, -21.990234>, <3.617204, 0.077825, -22.363982>, <3.694035, 0.133645, -22.900134>, <3.694035, 0.133645, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.571051, -0.426839, -22.452154>, <2.643988, -0.373847, -22.693990>, <2.693702, -0.337728, -23.040915>, <2.693702, -0.337728, -23.299010>, 
      <2.732738, -0.307560, -22.359683>, <2.805675, -0.254568, -22.601520>, <2.868787, -0.208714, -23.040915>, <2.868787, -0.208714, -23.299010>, 
      <2.909837, -0.090790, -22.235102>, <3.009297, -0.018528, -22.564880>, <3.064032, 0.021211, -22.947061>, <3.064032, 0.021211, -23.299010>, 
      <3.093516, -0.007599, -22.144206>, <3.192975, 0.064663, -22.473986>, <3.260767, 0.113916, -22.947061>, <3.260767, 0.113916, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.276227, -1.348248, -23.183530>, <1.286173, -1.341022, -23.216507>, <1.292952, -1.336097, -23.263814>, <1.292952, -1.336097, -23.299010>, 
      <1.664674, -1.071825, -22.964117>, <1.674620, -1.064599, -22.997094>, <1.713177, -1.036586, -23.263814>, <1.713177, -1.036586, -23.299010>, 
      <2.187395, -0.709870, -22.671570>, <2.260332, -0.656878, -22.913406>, <2.278267, -0.643847, -23.040915>, <2.278267, -0.643847, -23.299010>, 
      <2.571051, -0.426839, -22.452154>, <2.643988, -0.373847, -22.693990>, <2.693702, -0.337728, -23.040915>, <2.693702, -0.337728, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.130270, -0.948237, -23.299010>, <3.130270, -0.948237, -23.556371>, <3.080697, -0.984254, -23.902309>, <3.007967, -1.037095, -24.143459>, 
      <2.724508, -1.264279, -23.299010>, <2.724508, -1.264279, -23.556371>, <2.706584, -1.277302, -23.683738>, <2.633854, -1.330143, -23.924886>, 
      <2.159385, -1.653626, -23.299010>, <2.159385, -1.653626, -23.334203>, <2.120933, -1.681563, -23.600203>, <2.110987, -1.688790, -23.633181>, 
      <1.743292, -1.955936, -23.299010>, <1.743292, -1.955936, -23.334203>, <1.736512, -1.960861, -23.381512>, <1.726566, -1.968087, -23.414490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.675420, -0.451029, -23.299010>, <3.675420, -0.451029, -23.651398>, <3.607543, -0.500344, -24.125066>, <3.507959, -0.572696, -24.455256>, 
      <3.545408, -0.630175, -23.299010>, <3.545408, -0.630175, -23.651398>, <3.490331, -0.670309, -24.035442>, <3.390747, -0.742660, -24.365634>, 
      <3.304900, -0.812220, -23.299010>, <3.304900, -0.812220, -23.556371>, <3.241674, -0.858159, -23.996358>, <3.168944, -0.911000, -24.237509>, 
      <3.130270, -0.948237, -23.299010>, <3.130270, -0.948237, -23.556371>, <3.080697, -0.984254, -23.902309>, <3.007967, -1.037095, -24.143459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.809683, -0.012055, -23.299010>, <3.809683, -0.012055, -23.698910>, <3.732655, -0.068020, -24.236443>, <3.619644, -0.150127, -24.611152>, 
      <3.805301, -0.149700, -23.299010>, <3.805301, -0.149700, -23.698910>, <3.733477, -0.202479, -24.200374>, <3.620466, -0.284586, -24.575085>, 
      <3.756307, -0.339572, -23.299010>, <3.756307, -0.339572, -23.651398>, <3.680042, -0.395216, -24.180498>, <3.580458, -0.467568, -24.510688>, 
      <3.675420, -0.451029, -23.299010>, <3.675420, -0.451029, -23.651398>, <3.607543, -0.500344, -24.125066>, <3.507959, -0.572696, -24.455256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.694035, 0.133645, -23.299010>, <3.694035, 0.133645, -23.697883>, <3.617204, 0.077825, -24.234035>, <3.504483, -0.004072, -24.607784>, 
      <3.748427, 0.121163, -23.299010>, <3.748427, 0.121163, -23.697883>, <3.668957, 0.063805, -24.249512>, <3.556236, -0.018092, -24.623261>, 
      <3.811459, 0.043722, -23.299010>, <3.811459, 0.043722, -23.698910>, <3.732326, -0.014119, -24.250901>, <3.619315, -0.096226, -24.625610>, 
      <3.809683, -0.012055, -23.299010>, <3.809683, -0.012055, -23.698910>, <3.732655, -0.068020, -24.236443>, <3.619644, -0.150127, -24.611152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.260767, 0.113916, -23.299010>, <3.260767, 0.113916, -23.650957>, <3.192975, 0.064663, -24.124034>, <3.093516, -0.007599, -24.453811>, 
      <3.378469, 0.169379, -23.299010>, <3.378469, 0.169379, -23.650957>, <3.302315, 0.114184, -24.178141>, <3.202855, 0.041923, -24.507920>, 
      <3.567216, 0.162749, -23.299010>, <3.567216, 0.162749, -23.697883>, <3.495106, 0.110901, -24.197522>, <3.382385, 0.029004, -24.571270>, 
      <3.694035, 0.133645, -23.299010>, <3.694035, 0.133645, -23.697883>, <3.617204, 0.077825, -24.234035>, <3.504483, -0.004072, -24.607784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.693702, -0.337728, -23.299010>, <2.693702, -0.337728, -23.557104>, <2.643989, -0.373847, -23.904027>, <2.571052, -0.426839, -24.145864>, 
      <2.868787, -0.208714, -23.299010>, <2.868787, -0.208714, -23.557104>, <2.805675, -0.254568, -23.996498>, <2.732738, -0.307560, -24.238334>, 
      <3.064032, 0.021211, -23.299010>, <3.064032, 0.021211, -23.650957>, <3.009297, -0.018528, -24.033138>, <2.909837, -0.090790, -24.362917>, 
      <3.260767, 0.113916, -23.299010>, <3.260767, 0.113916, -23.650957>, <3.192975, 0.064663, -24.124034>, <3.093516, -0.007599, -24.453811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.292952, -1.336097, -23.299010>, <1.292952, -1.336097, -23.334203>, <1.286173, -1.341022, -23.381512>, <1.276227, -1.348248, -23.414490>, 
      <1.713177, -1.036586, -23.299010>, <1.713177, -1.036586, -23.334203>, <1.674620, -1.064599, -23.600923>, <1.664675, -1.071825, -23.633901>, 
      <2.278267, -0.643847, -23.299010>, <2.278267, -0.643847, -23.557104>, <2.260332, -0.656878, -23.684613>, <2.187395, -0.709870, -23.926450>, 
      <2.693702, -0.337728, -23.299010>, <2.693702, -0.337728, -23.557104>, <2.643989, -0.373847, -23.904027>, <2.571052, -0.426839, -24.145864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.007967, -1.037095, -24.143459>, <2.937146, -1.088550, -24.378283>, <2.795310, -1.191600, -24.673070>, <2.659679, -1.290141, -24.859349>, 
      <2.633854, -1.330143, -23.924886>, <2.563033, -1.381598, -24.159710>, <2.511335, -1.419160, -24.269186>, <2.375704, -1.517701, -24.455464>, 
      <2.110987, -1.688790, -23.633181>, <2.101302, -1.695826, -23.665293>, <1.991708, -1.775451, -23.891003>, <1.973160, -1.788927, -23.916477>, 
      <1.726566, -1.968087, -23.414490>, <1.716881, -1.975124, -23.446602>, <1.697485, -1.989216, -23.486915>, <1.678937, -2.002692, -23.512390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.507959, -0.572696, -24.455256>, <3.410988, -0.643149, -24.776782>, <3.172578, -0.816364, -25.140258>, <3.031073, -0.919174, -25.435474>, 
      <3.390747, -0.742660, -24.365634>, <3.293776, -0.813114, -24.687160>, <3.092087, -0.959906, -24.974157>, <2.950582, -1.062716, -25.269374>, 
      <3.168944, -0.911000, -24.237509>, <3.098122, -0.962455, -24.472333>, <2.917447, -1.093726, -24.846782>, <2.781816, -1.192268, -25.033061>, 
      <3.007967, -1.037095, -24.143459>, <2.937146, -1.088550, -24.378283>, <2.795310, -1.191600, -24.673070>, <2.659679, -1.290141, -24.859349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.619644, -0.150127, -24.611152>, <3.509598, -0.230080, -24.976032>, <3.243990, -0.423056, -25.392214>, <3.078458, -0.543322, -25.723536>, 
      <3.620466, -0.284586, -24.575085>, <3.510420, -0.364539, -24.939965>, <3.259847, -0.547959, -25.324894>, <3.094315, -0.668225, -25.656216>, 
      <3.580458, -0.467568, -24.510688>, <3.483487, -0.538022, -24.832216>, <3.221727, -0.728717, -25.241678>, <3.080221, -0.831527, -25.536896>, 
      <3.507959, -0.572696, -24.455256>, <3.410988, -0.643149, -24.776782>, <3.172578, -0.816364, -25.140258>, <3.031073, -0.919174, -25.435474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.504483, -0.004072, -24.607784>, <3.394720, -0.083820, -24.971728>, <3.129697, -0.276370, -25.386766>, <2.964686, -0.396257, -25.717312>, 
      <3.556236, -0.018092, -24.623261>, <3.446473, -0.097839, -24.987203>, <3.174290, -0.294709, -25.414875>, <3.009280, -0.414596, -25.745421>, 
      <3.619315, -0.096226, -24.625610>, <3.509269, -0.176179, -24.990490>, <3.237792, -0.374229, -25.418530>, <3.072260, -0.494495, -25.749851>, 
      <3.619644, -0.150127, -24.611152>, <3.509598, -0.230080, -24.976032>, <3.243990, -0.423056, -25.392214>, <3.078458, -0.543322, -25.723536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.093516, -0.007599, -24.453811>, <2.996666, -0.077965, -24.774936>, <2.758508, -0.250996, -25.137925>, <2.617224, -0.353645, -25.432806>, 
      <3.202855, 0.041923, -24.507920>, <3.106005, -0.028443, -24.829045>, <2.844679, -0.218014, -25.236923>, <2.703395, -0.320663, -25.531805>, 
      <3.382385, 0.029004, -24.571270>, <3.272622, -0.050743, -24.935213>, <3.021569, -0.231904, -25.318611>, <2.856559, -0.351791, -25.649157>, 
      <3.504483, -0.004072, -24.607784>, <3.394720, -0.083820, -24.971728>, <3.129697, -0.276370, -25.386766>, <2.964686, -0.396257, -25.717312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.571052, -0.426839, -24.145864>, <2.500028, -0.478440, -24.381357>, <2.357788, -0.581784, -24.676987>, <2.221771, -0.680606, -24.863794>, 
      <2.732738, -0.307560, -24.238334>, <2.661715, -0.359161, -24.473827>, <2.481328, -0.490220, -24.847837>, <2.345310, -0.589042, -25.034645>, 
      <2.909837, -0.090790, -24.362917>, <2.812987, -0.161156, -24.684042>, <2.612146, -0.307016, -24.969773>, <2.470862, -0.409665, -25.264654>, 
      <3.093516, -0.007599, -24.453811>, <2.996666, -0.077965, -24.774936>, <2.758508, -0.250996, -25.137925>, <2.617224, -0.353645, -25.432806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.276227, -1.348248, -23.414490>, <1.266542, -1.355285, -23.446602>, <1.247146, -1.369377, -23.486915>, <1.228598, -1.382853, -23.512390>, 
      <1.664675, -1.071825, -23.633901>, <1.654989, -1.078862, -23.666014>, <1.545098, -1.158703, -23.892338>, <1.526550, -1.172179, -23.917813>, 
      <2.187395, -0.709870, -23.926450>, <2.116372, -0.761471, -24.161941>, <2.064629, -0.799064, -24.271558>, <1.928612, -0.897887, -24.458366>, 
      <2.571052, -0.426839, -24.145864>, <2.500028, -0.478440, -24.381357>, <2.357788, -0.581784, -24.676987>, <2.221771, -0.680606, -24.863794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.659679, -1.290141, -24.859349>, <2.529391, -1.384801, -25.038286>, <2.315351, -1.540311, -25.237043>, <2.138429, -1.668852, -25.337690>, 
      <2.375704, -1.517701, -24.455464>, <2.245416, -1.612361, -24.634402>, <2.200781, -1.639877, -24.694414>, <2.023860, -1.768418, -24.795061>, 
      <1.973160, -1.788927, -23.916477>, <1.955343, -1.801872, -23.940947>, <1.791082, -1.921214, -24.092006>, <1.766887, -1.938792, -24.105770>, 
      <1.678937, -2.002692, -23.512390>, <1.661120, -2.015637, -23.536859>, <1.631850, -2.036903, -23.564042>, <1.607655, -2.054481, -23.577805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.031073, -0.919174, -25.435474>, <2.815394, -1.075874, -25.885435>, <2.615424, -1.221160, -26.567934>, <2.317361, -1.437716, -26.939146>, 
      <2.950582, -1.062716, -25.269374>, <2.734903, -1.219416, -25.719336>, <2.584487, -1.348885, -26.097574>, <2.286424, -1.565441, -26.468786>, 
      <2.781816, -1.192268, -25.033061>, <2.651529, -1.286927, -25.211998>, <2.414653, -1.454013, -25.707363>, <2.237731, -1.582554, -25.808010>, 
      <2.659679, -1.290141, -24.859349>, <2.529391, -1.384801, -25.038286>, <2.315351, -1.540311, -25.237043>, <2.138429, -1.668852, -25.337690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.078458, -0.543322, -25.723536>, <2.838632, -0.717566, -26.203562>, <2.600666, -0.890458, -26.928550>, <2.268516, -1.131779, -27.315517>, 
      <3.094315, -0.668225, -25.656216>, <2.854489, -0.842469, -26.136242>, <2.639370, -1.000037, -26.839771>, <2.307220, -1.241358, -27.226739>, 
      <3.080221, -0.831527, -25.536896>, <2.864542, -0.988227, -25.986856>, <2.624688, -1.182913, -26.708784>, <2.326625, -1.399469, -27.079997>, 
      <3.031073, -0.919174, -25.435474>, <2.815394, -1.075874, -25.885435>, <2.615424, -1.221160, -26.567934>, <2.317361, -1.437716, -26.939146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.964686, -0.396257, -25.717312>, <2.725380, -0.570123, -26.196683>, <2.488241, -0.742415, -26.920768>, <2.156823, -0.983205, -27.307389>, 
      <3.009280, -0.414596, -25.745421>, <2.769974, -0.588462, -26.224792>, <2.522862, -0.767159, -26.956883>, <2.191444, -1.007949, -27.343507>, 
      <3.072260, -0.494495, -25.749851>, <2.832433, -0.668739, -26.229877>, <2.585894, -0.848636, -26.962435>, <2.253744, -1.089957, -27.349402>, 
      <3.078458, -0.543322, -25.723536>, <2.838632, -0.717566, -26.203562>, <2.600666, -0.890458, -26.928550>, <2.268516, -1.131779, -27.315517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.617224, -0.353645, -25.432806>, <2.401770, -0.510182, -25.882493>, <2.202149, -0.655214, -26.564592>, <1.904403, -0.871540, -26.935661>, 
      <2.703395, -0.320663, -25.531805>, <2.487940, -0.477200, -25.981491>, <2.233659, -0.649901, -26.699766>, <1.935913, -0.866227, -27.070835>, 
      <2.856559, -0.351791, -25.649157>, <2.617253, -0.525657, -26.128528>, <2.402086, -0.680838, -26.830886>, <2.070668, -0.921627, -27.217507>, 
      <2.964686, -0.396257, -25.717312>, <2.725380, -0.570123, -26.196683>, <2.488241, -0.742415, -26.920768>, <2.156823, -0.983205, -27.307389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.221771, -0.680606, -24.863794>, <2.091112, -0.775535, -25.043242>, <1.876461, -0.931488, -25.242563>, <1.699036, -1.060395, -25.343498>, 
      <2.345310, -0.589042, -25.034645>, <2.214652, -0.683971, -25.214093>, <1.980394, -0.853151, -25.709699>, <1.802969, -0.982058, -25.810635>, 
      <2.470862, -0.409665, -25.264654>, <2.255407, -0.566202, -25.714341>, <2.092144, -0.673763, -26.092672>, <1.794398, -0.890088, -26.463741>, 
      <2.617224, -0.353645, -25.432806>, <2.401770, -0.510182, -25.882493>, <2.202149, -0.655214, -26.564592>, <1.904403, -0.871540, -26.935661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.228598, -1.382853, -23.512390>, <1.210781, -1.395798, -23.536859>, <1.181510, -1.417064, -23.564042>, <1.157316, -1.434642, -23.577805>, 
      <1.526550, -1.172179, -23.917813>, <1.508733, -1.185124, -23.942282>, <1.344026, -1.304790, -24.093750>, <1.319832, -1.322368, -24.107514>, 
      <1.928612, -0.897887, -24.458366>, <1.797953, -0.992816, -24.637813>, <1.755294, -1.022815, -24.697966>, <1.577869, -1.151723, -24.798901>, 
      <2.221771, -0.680606, -24.863794>, <2.091112, -0.775535, -25.043242>, <1.876461, -0.931488, -25.242563>, <1.699036, -1.060395, -25.343498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.138429, -1.668852, -25.337690>, <1.966823, -1.793531, -25.435314>, <1.712481, -1.978321, -25.505661>, <1.523572, -2.115571, -25.505661>, 
      <2.023860, -1.768418, -24.795061>, <1.852254, -1.893097, -24.892685>, <1.719765, -1.988347, -24.934328>, <1.530857, -2.125597, -24.934328>, 
      <1.766887, -1.938792, -24.105770>, <1.743420, -1.955842, -24.119120>, <1.549406, -2.096802, -24.172240>, <1.523572, -2.115571, -24.172240>, 
      <1.607655, -2.054481, -23.577805>, <1.584188, -2.071531, -23.591154>, <1.549406, -2.096802, -23.600773>, <1.523572, -2.115571, -23.600773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.317361, -1.437716, -26.939146>, <2.124612, -1.577756, -27.179197>, <1.749100, -1.850582, -27.372829>, <1.475480, -2.049378, -27.372829>, 
      <2.286424, -1.565441, -26.468786>, <2.093676, -1.705481, -26.708837>, <1.800346, -1.921116, -26.818962>, <1.526726, -2.119912, -26.818962>, 
      <2.237731, -1.582554, -25.808010>, <2.066125, -1.707233, -25.905634>, <1.705334, -1.968484, -26.066218>, <1.516426, -2.105734, -26.066218>, 
      <2.138429, -1.668852, -25.337690>, <1.966823, -1.793531, -25.435314>, <1.712481, -1.978321, -25.505661>, <1.523572, -2.115571, -25.505661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.268516, -1.131779, -27.315517>, <2.044375, -1.294627, -27.576650>, <1.621133, -1.602130, -27.780211>, <1.313123, -1.825913, -27.780211>, 
      <2.307220, -1.241358, -27.226739>, <2.083079, -1.404206, -27.487869>, <1.686853, -1.692586, -27.683766>, <1.378843, -1.916368, -27.683766>, 
      <2.326625, -1.399469, -27.079997>, <2.133876, -1.539509, -27.320048>, <1.735604, -1.832007, -27.518691>, <1.461985, -2.030803, -27.518691>, 
      <2.317361, -1.437716, -26.939146>, <2.124612, -1.577756, -27.179197>, <1.749100, -1.850582, -27.372829>, <1.475480, -2.049378, -27.372829>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.156823, -0.983205, -27.307389>, <1.933362, -1.145558, -27.568070>, <1.511148, -1.452315, -27.771411>, <1.203883, -1.675556, -27.771411>, 
      <2.191444, -1.007949, -27.343507>, <1.967983, -1.170303, -27.604189>, <1.534716, -1.484754, -27.810243>, <1.227451, -1.707995, -27.810243>, 
      <2.253744, -1.089957, -27.349402>, <2.029603, -1.252805, -27.610531>, <1.596290, -1.567937, -27.816672>, <1.288280, -1.791719, -27.816672>, 
      <2.268516, -1.131779, -27.315517>, <2.044375, -1.294627, -27.576650>, <1.621133, -1.602130, -27.780211>, <1.313123, -1.825913, -27.780211>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.904403, -0.871540, -26.935661>, <1.711945, -1.011369, -27.175514>, <1.336876, -1.283872, -27.369056>, <1.063574, -1.482438, -27.369056>, 
      <1.935913, -0.866227, -27.070835>, <1.743454, -1.006056, -27.310688>, <1.344389, -1.294213, -27.508822>, <1.071087, -1.492779, -27.508822>, 
      <2.070668, -0.921627, -27.217507>, <1.847207, -1.083981, -27.478192>, <1.451887, -1.370748, -27.673770>, <1.144622, -1.593990, -27.673770>, 
      <2.156823, -0.983205, -27.307389>, <1.933362, -1.145558, -27.568070>, <1.511148, -1.452315, -27.771411>, <1.203883, -1.675556, -27.771411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699036, -1.060395, -25.343498>, <1.526941, -1.185429, -25.441400>, <1.271874, -1.370746, -25.511947>, <1.082428, -1.508387, -25.511947>, 
      <1.802969, -0.982058, -25.810635>, <1.630874, -1.107092, -25.908538>, <1.270446, -1.368781, -26.069158>, <1.080999, -1.506421, -26.069158>, 
      <1.794398, -0.890088, -26.463741>, <1.601939, -1.029918, -26.703594>, <1.307048, -1.242817, -26.814155>, <1.033746, -1.441383, -26.814155>, 
      <1.904403, -0.871540, -26.935661>, <1.711945, -1.011369, -27.175514>, <1.336876, -1.283872, -27.369056>, <1.063574, -1.482438, -27.369056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.157316, -1.434642, -23.577805>, <1.133849, -1.451693, -23.591154>, <1.099066, -1.476963, -23.600773>, <1.073233, -1.495732, -23.600773>, 
      <1.319832, -1.322368, -24.107514>, <1.296364, -1.339418, -24.120862>, <1.101825, -1.480760, -24.174126>, <1.075991, -1.499529, -24.174126>, 
      <1.577869, -1.151723, -24.798901>, <1.405774, -1.276757, -24.896803>, <1.273344, -1.372769, -24.938581>, <1.083897, -1.510410, -24.938581>, 
      <1.699036, -1.060395, -25.343498>, <1.526941, -1.185429, -25.441400>, <1.271874, -1.370746, -25.511947>, <1.082428, -1.508387, -25.511947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.523572, -2.115571, -25.505661>, <1.334664, -2.252821, -25.505661>, <1.080322, -2.437611, -25.435314>, <0.908716, -2.562290, -25.337690>, 
      <1.530857, -2.125597, -24.934328>, <1.341948, -2.262847, -24.934328>, <1.210419, -2.359417, -24.892685>, <1.038813, -2.484096, -24.795061>, 
      <1.523572, -2.115571, -24.172240>, <1.497739, -2.134340, -24.172240>, <1.303725, -2.275300, -24.119120>, <1.280258, -2.292350, -24.105770>, 
      <1.523572, -2.115571, -23.600773>, <1.497739, -2.134340, -23.600773>, <1.462957, -2.159611, -23.591154>, <1.439490, -2.176661, -23.577805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.475480, -2.049378, -27.372829>, <1.201861, -2.248174, -27.372829>, <0.826348, -2.521000, -27.179197>, <0.633600, -2.661040, -26.939146>, 
      <1.526726, -2.119912, -26.818962>, <1.253106, -2.318708, -26.818962>, <0.957382, -2.531046, -26.708837>, <0.764633, -2.671086, -26.468786>, 
      <1.516426, -2.105734, -26.066218>, <1.327517, -2.242984, -26.066218>, <0.967562, -2.505386, -25.905634>, <0.795956, -2.630065, -25.808010>, 
      <1.523572, -2.115571, -25.505661>, <1.334664, -2.252821, -25.505661>, <1.080322, -2.437611, -25.435314>, <0.908716, -2.562290, -25.337690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313123, -1.825913, -27.780211>, <1.005114, -2.049695, -27.780211>, <0.581872, -2.357198, -27.576650>, <0.357731, -2.520046, -27.315517>, 
      <1.378843, -1.916368, -27.683766>, <1.070833, -2.140150, -27.683766>, <0.674127, -2.427870, -27.487869>, <0.449986, -2.590718, -27.226739>, 
      <1.461985, -2.030803, -27.518691>, <1.188365, -2.229599, -27.518691>, <0.787110, -2.517992, -27.320048>, <0.594362, -2.658031, -27.079997>, 
      <1.475480, -2.049378, -27.372829>, <1.201861, -2.248174, -27.372829>, <0.826348, -2.521000, -27.179197>, <0.633600, -2.661040, -26.939146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.203883, -1.675556, -27.771411>, <0.896618, -1.898797, -27.771411>, <0.474403, -2.205554, -27.568070>, <0.250943, -2.367907, -27.307389>, 
      <1.227451, -1.707995, -27.810243>, <0.920186, -1.931236, -27.810243>, <0.487238, -2.246127, -27.604189>, <0.263778, -2.408480, -27.343507>, 
      <1.288280, -1.791719, -27.816672>, <0.980271, -2.015501, -27.816672>, <0.546661, -2.330225, -27.610531>, <0.322520, -2.493073, -27.349402>, 
      <1.313123, -1.825913, -27.780211>, <1.005114, -2.049695, -27.780211>, <0.581872, -2.357198, -27.576650>, <0.357731, -2.520046, -27.315517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.063574, -1.482438, -27.369056>, <0.790273, -1.681003, -27.369056>, <0.415203, -1.953507, -27.175514>, <0.222745, -2.093336, -26.935661>, 
      <1.071087, -1.492779, -27.508822>, <0.797786, -1.691344, -27.508822>, <0.400414, -1.981832, -27.310688>, <0.207955, -2.121661, -27.070835>, 
      <1.144622, -1.593990, -27.673770>, <0.837356, -1.817231, -27.673770>, <0.442463, -2.104587, -27.478192>, <0.219003, -2.266941, -27.217507>, 
      <1.203883, -1.675556, -27.771411>, <0.896618, -1.898797, -27.771411>, <0.474403, -2.205554, -27.568070>, <0.250943, -2.367907, -27.307389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.082428, -1.508387, -25.511947>, <0.892981, -1.646028, -25.511947>, <0.637914, -1.831345, -25.441400>, <0.465819, -1.956379, -25.343498>, 
      <1.080999, -1.506421, -26.069158>, <0.891553, -1.644062, -26.069158>, <0.531294, -1.905983, -25.908538>, <0.359199, -2.031018, -25.810635>, 
      <1.033746, -1.441383, -26.814155>, <0.760444, -1.639948, -26.814155>, <0.466838, -1.854617, -26.703594>, <0.274380, -1.994446, -26.463741>, 
      <1.063574, -1.482438, -27.369056>, <0.790273, -1.681003, -27.369056>, <0.415203, -1.953507, -27.175514>, <0.222745, -2.093336, -26.935661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.073233, -1.495732, -23.600773>, <1.047400, -1.514501, -23.600773>, <1.012618, -1.539772, -23.591154>, <0.989150, -1.556822, -23.577805>, 
      <1.075991, -1.499529, -24.174126>, <1.050158, -1.518298, -24.174126>, <0.855618, -1.659639, -24.120862>, <0.832151, -1.676689, -24.107514>, 
      <1.083897, -1.510410, -24.938581>, <0.894451, -1.648051, -24.938581>, <0.762214, -1.744330, -24.896803>, <0.590119, -1.869364, -24.798901>, 
      <1.082428, -1.508387, -25.511947>, <0.892981, -1.646028, -25.511947>, <0.637914, -1.831345, -25.441400>, <0.465819, -1.956379, -25.343498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.908716, -2.562290, -25.337690>, <0.731794, -2.690832, -25.237043>, <0.517753, -2.846341, -25.038286>, <0.387466, -2.941001, -24.859349>, 
      <1.038813, -2.484096, -24.795061>, <0.861891, -2.612637, -24.694414>, <0.821929, -2.646585, -24.634402>, <0.691642, -2.741245, -24.455464>, 
      <1.280258, -2.292350, -24.105770>, <1.256063, -2.309928, -24.092006>, <1.091802, -2.429271, -23.940947>, <1.073985, -2.442215, -23.916477>, 
      <1.439490, -2.176661, -23.577805>, <1.415295, -2.194239, -23.564042>, <1.386024, -2.215505, -23.536859>, <1.368207, -2.228450, -23.512390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.633600, -2.661040, -26.939146>, <0.335537, -2.877596, -26.567934>, <0.135567, -3.022882, -25.885435>, <-0.080112, -3.179582, -25.435474>, 
      <0.764633, -2.671086, -26.468786>, <0.466570, -2.887642, -26.097574>, <0.296956, -2.990687, -25.719336>, <0.081278, -3.147387, -25.269374>, 
      <0.795956, -2.630065, -25.808010>, <0.619034, -2.758606, -25.707363>, <0.386927, -2.932256, -25.211998>, <0.256640, -3.026916, -25.033061>, 
      <0.908716, -2.562290, -25.337690>, <0.731794, -2.690832, -25.237043>, <0.517753, -2.846341, -25.038286>, <0.387466, -2.941001, -24.859349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.357731, -2.520046, -27.315517>, <0.025581, -2.761367, -26.928550>, <-0.212385, -2.934260, -26.203562>, <-0.452212, -3.108504, -25.723536>, 
      <0.449986, -2.590718, -27.226739>, <0.117836, -2.832039, -26.839771>, <-0.098496, -2.987938, -26.136242>, <-0.338322, -3.162182, -25.656216>, 
      <0.594362, -2.658031, -27.079997>, <0.296298, -2.874587, -26.708784>, <0.037021, -3.042540, -25.986856>, <-0.178657, -3.199240, -25.536896>, 
      <0.633600, -2.661040, -26.939146>, <0.335537, -2.877596, -26.567934>, <0.135567, -3.022882, -25.885435>, <-0.080112, -3.179582, -25.435474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.250943, -2.367907, -27.307389>, <-0.080476, -2.608697, -26.920768>, <-0.317615, -2.780988, -26.196683>, <-0.556921, -2.954854, -25.717312>, 
      <0.263778, -2.408480, -27.343507>, <-0.067641, -2.649270, -26.956883>, <-0.313954, -2.829066, -26.224792>, <-0.553260, -3.002932, -25.745421>, 
      <0.322520, -2.493073, -27.349402>, <-0.009630, -2.734394, -26.962435>, <-0.256906, -2.913276, -26.229877>, <-0.496733, -3.087520, -25.749851>, 
      <0.357731, -2.520046, -27.315517>, <0.025581, -2.761367, -26.928550>, <-0.212385, -2.934260, -26.203562>, <-0.452212, -3.108504, -25.723536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.222745, -2.093336, -26.935661>, <-0.075001, -2.309661, -26.564592>, <-0.274621, -2.454694, -25.882493>, <-0.490076, -2.611231, -25.432806>, 
      <0.207955, -2.121661, -27.070835>, <-0.089791, -2.337986, -26.699766>, <-0.332617, -2.526455, -25.981491>, <-0.548071, -2.682992, -25.531805>, 
      <0.219003, -2.266941, -27.217507>, <-0.112416, -2.507730, -26.830886>, <-0.326491, -2.664412, -26.128528>, <-0.565797, -2.838278, -25.649157>, 
      <0.250943, -2.367907, -27.307389>, <-0.080476, -2.608697, -26.920768>, <-0.317615, -2.780988, -26.196683>, <-0.556921, -2.954854, -25.717312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465819, -1.956379, -25.343498>, <0.288394, -2.085287, -25.242563>, <0.073743, -2.241240, -25.043242>, <-0.056916, -2.336169, -24.863794>, 
      <0.359199, -2.031018, -25.810635>, <0.181774, -2.159925, -25.709699>, <-0.051515, -2.330438, -25.214093>, <-0.182174, -2.425367, -25.034645>, 
      <0.274380, -1.994446, -26.463741>, <-0.023366, -2.210772, -26.092672>, <-0.176115, -2.332805, -25.714341>, <-0.391569, -2.489342, -25.264654>, 
      <0.222745, -2.093336, -26.935661>, <-0.075001, -2.309661, -26.564592>, <-0.274621, -2.454694, -25.882493>, <-0.490076, -2.611231, -25.432806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.989150, -1.556822, -23.577805>, <0.964955, -1.574400, -23.564042>, <0.935685, -1.595667, -23.536859>, <0.917868, -1.608611, -23.512390>, 
      <0.832151, -1.676689, -24.107514>, <0.807956, -1.694268, -24.093750>, <0.643250, -1.813934, -23.942282>, <0.625433, -1.826879, -23.917813>, 
      <0.590119, -1.869364, -24.798901>, <0.412694, -1.998272, -24.697966>, <0.370980, -2.029572, -24.637813>, <0.240322, -2.124501, -24.458366>, 
      <0.465819, -1.956379, -25.343498>, <0.288394, -2.085287, -25.242563>, <0.073743, -2.241240, -25.043242>, <-0.056916, -2.336169, -24.863794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.387466, -2.941001, -24.859349>, <0.251835, -3.039542, -24.673070>, <0.109999, -3.142592, -24.378283>, <0.039178, -3.194047, -24.143459>, 
      <0.691642, -2.741245, -24.455464>, <0.556011, -2.839786, -24.269186>, <0.504312, -2.877347, -24.159710>, <0.433490, -2.928801, -23.924886>, 
      <1.073985, -2.442215, -23.916477>, <1.055437, -2.455691, -23.891003>, <0.945843, -2.535316, -23.665293>, <0.936158, -2.542353, -23.633181>, 
      <1.368207, -2.228450, -23.512390>, <1.349659, -2.241926, -23.486915>, <1.330263, -2.256018, -23.446602>, <1.320578, -2.263055, -23.414490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.080112, -3.179582, -25.435474>, <-0.221618, -3.282392, -25.140258>, <-0.460028, -3.455607, -24.776782>, <-0.556999, -3.526060, -24.455256>, 
      <0.081278, -3.147387, -25.269374>, <-0.060228, -3.250197, -24.974157>, <-0.262161, -3.396654, -24.687160>, <-0.359132, -3.467107, -24.365634>, 
      <0.256640, -3.026916, -25.033061>, <0.121009, -3.125458, -24.846782>, <-0.059669, -3.256725, -24.472333>, <-0.130491, -3.308179, -24.237509>, 
      <0.387466, -2.941001, -24.859349>, <0.251835, -3.039542, -24.673070>, <0.109999, -3.142592, -24.378283>, <0.039178, -3.194047, -24.143459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.452212, -3.108504, -25.723536>, <-0.617744, -3.228770, -25.392214>, <-0.883352, -3.421746, -24.976032>, <-0.993398, -3.501698, -24.611155>, 
      <-0.338322, -3.162182, -25.656216>, <-0.503854, -3.282448, -25.324894>, <-0.755728, -3.464078, -24.939965>, <-0.865774, -3.544030, -24.575086>, 
      <-0.178657, -3.199240, -25.536896>, <-0.320163, -3.302050, -25.241678>, <-0.582414, -3.492071, -24.832216>, <-0.679384, -3.562525, -24.510688>, 
      <-0.080112, -3.179582, -25.435474>, <-0.221618, -3.282392, -25.140258>, <-0.460028, -3.455607, -24.776782>, <-0.556999, -3.526060, -24.455256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.556921, -2.954854, -25.717312>, <-0.721931, -3.074742, -25.386766>, <-0.986954, -3.267292, -24.971728>, <-1.096718, -3.347040, -24.607786>, 
      <-0.553260, -3.002932, -25.745421>, <-0.718270, -3.122819, -25.414875>, <-0.989613, -3.320845, -24.987205>, <-1.099377, -3.400592, -24.623264>, 
      <-0.496733, -3.087520, -25.749851>, <-0.662265, -3.207786, -25.418530>, <-0.934513, -3.404776, -24.990491>, <-1.044559, -3.484728, -24.625614>, 
      <-0.452212, -3.108504, -25.723536>, <-0.617744, -3.228770, -25.392214>, <-0.883352, -3.421746, -24.976032>, <-0.993398, -3.501698, -24.611155>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.490076, -2.611231, -25.432806>, <-0.631360, -2.713880, -25.137925>, <-0.869518, -2.886911, -24.774936>, <-0.966368, -2.957277, -24.453811>, 
      <-0.548071, -2.682992, -25.531805>, <-0.689356, -2.785641, -25.236923>, <-0.950404, -2.975596, -24.829045>, <-1.047254, -3.045962, -24.507920>, 
      <-0.565797, -2.838278, -25.649157>, <-0.730808, -2.958165, -25.318611>, <-0.980682, -3.140949, -24.935213>, <-1.090445, -3.220696, -24.571272>, 
      <-0.556921, -2.954854, -25.717312>, <-0.721931, -3.074742, -25.386766>, <-0.986954, -3.267292, -24.971728>, <-1.096718, -3.347040, -24.607786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056916, -2.336169, -24.863794>, <-0.192933, -2.434991, -24.676987>, <-0.335173, -2.538334, -24.381357>, <-0.406196, -2.589936, -24.145864>, 
      <-0.182174, -2.425367, -25.034645>, <-0.318191, -2.524189, -24.847837>, <-0.498578, -2.655248, -24.473827>, <-0.569601, -2.706849, -24.238334>, 
      <-0.391569, -2.489342, -25.264654>, <-0.532854, -2.591991, -24.969773>, <-0.733638, -2.737930, -24.684040>, <-0.830488, -2.808295, -24.362915>, 
      <-0.490076, -2.611231, -25.432806>, <-0.631360, -2.713880, -25.137925>, <-0.869518, -2.886911, -24.774936>, <-0.966368, -2.957277, -24.453811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.917868, -1.608611, -23.512390>, <0.899320, -1.622087, -23.486915>, <0.879924, -1.636179, -23.446602>, <0.870239, -1.643216, -23.414490>, 
      <0.625433, -1.826879, -23.917813>, <0.606885, -1.840354, -23.892338>, <0.496993, -1.920195, -23.666014>, <0.487308, -1.927232, -23.633901>, 
      <0.240322, -2.124501, -24.458366>, <0.104304, -2.223323, -24.271558>, <0.052562, -2.260916, -24.161941>, <-0.018461, -2.312518, -23.926450>, 
      <-0.056916, -2.336169, -24.863794>, <-0.192933, -2.434991, -24.676987>, <-0.335173, -2.538334, -24.381357>, <-0.406196, -2.589936, -24.145864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.039178, -3.194047, -24.143459>, <-0.033552, -3.246888, -23.902309>, <-0.083125, -3.282905, -23.556371>, <-0.083125, -3.282905, -23.299010>, 
      <0.433490, -2.928801, -23.924886>, <0.360760, -2.981643, -23.683738>, <0.342836, -2.994665, -23.556371>, <0.342836, -2.994665, -23.299010>, 
      <0.936158, -2.542353, -23.633181>, <0.926212, -2.549579, -23.600203>, <0.887760, -2.577516, -23.334203>, <0.887760, -2.577516, -23.299010>, 
      <1.320578, -2.263055, -23.414490>, <1.310632, -2.270281, -23.381512>, <1.303853, -2.275207, -23.334203>, <1.303853, -2.275207, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.556999, -3.526060, -24.455256>, <-0.656582, -3.598412, -24.125066>, <-0.724459, -3.647728, -23.651398>, <-0.724459, -3.647728, -23.299010>, 
      <-0.359132, -3.467107, -24.365634>, <-0.458716, -3.539459, -24.035442>, <-0.513905, -3.579439, -23.651398>, <-0.513905, -3.579439, -23.299010>, 
      <-0.130491, -3.308179, -24.237509>, <-0.203221, -3.361021, -23.996358>, <-0.266449, -3.406957, -23.556371>, <-0.266449, -3.406957, -23.299010>, 
      <0.039178, -3.194047, -24.143459>, <-0.033552, -3.246888, -23.902309>, <-0.083125, -3.282905, -23.556371>, <-0.083125, -3.282905, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.993398, -3.501698, -24.611155>, <-1.106409, -3.583806, -24.236445>, <-1.183437, -3.639770, -23.698912>, <-1.183437, -3.639770, -23.299010>, 
      <-0.865774, -3.544030, -24.575086>, <-0.978785, -3.626138, -24.200376>, <-1.051175, -3.678136, -23.698912>, <-1.051176, -3.678136, -23.299010>, 
      <-0.679384, -3.562525, -24.510688>, <-0.778968, -3.634877, -24.180498>, <-0.855456, -3.690214, -23.651398>, <-0.855456, -3.690214, -23.299010>, 
      <-0.556999, -3.526060, -24.455256>, <-0.656582, -3.598412, -24.125066>, <-0.724459, -3.647728, -23.651398>, <-0.724459, -3.647728, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.096718, -3.347040, -24.607786>, <-1.209439, -3.428936, -24.234037>, <-1.286269, -3.484758, -23.697883>, <-1.286269, -3.484758, -23.299010>, 
      <-1.099377, -3.400592, -24.623264>, <-1.212098, -3.482489, -24.249515>, <-1.291206, -3.540344, -23.697883>, <-1.291206, -3.540344, -23.299010>, 
      <-1.044559, -3.484728, -24.625614>, <-1.157570, -3.566836, -24.250904>, <-1.237034, -3.624222, -23.698912>, <-1.237034, -3.624222, -23.299010>, 
      <-0.993398, -3.501698, -24.611155>, <-1.106409, -3.583806, -24.236445>, <-1.183437, -3.639770, -23.698912>, <-1.183437, -3.639770, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.966368, -2.957277, -24.453811>, <-1.065827, -3.029538, -24.124034>, <-1.133619, -3.078792, -23.650957>, <-1.133619, -3.078792, -23.299010>, 
      <-1.047254, -3.045962, -24.507920>, <-1.146713, -3.118223, -24.178141>, <-1.222739, -3.173594, -23.650957>, <-1.222739, -3.173594, -23.299010>, 
      <-1.090445, -3.220696, -24.571272>, <-1.203166, -3.302593, -24.197523>, <-1.274760, -3.355152, -23.697883>, <-1.274760, -3.355152, -23.299010>, 
      <-1.096718, -3.347040, -24.607786>, <-1.209439, -3.428936, -24.234037>, <-1.286269, -3.484758, -23.697883>, <-1.286269, -3.484758, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.406196, -2.589936, -24.145864>, <-0.479133, -2.642928, -23.904027>, <-0.528847, -2.679047, -23.557104>, <-0.528848, -2.679047, -23.299010>, 
      <-0.569601, -2.706849, -24.238334>, <-0.642538, -2.759841, -23.996498>, <-0.705650, -2.805695, -23.557104>, <-0.705651, -2.805695, -23.299010>, 
      <-0.830488, -2.808295, -24.362915>, <-0.929948, -2.880557, -24.033136>, <-0.984657, -2.920333, -23.650957>, <-0.984657, -2.920333, -23.299010>, 
      <-0.966368, -2.957277, -24.453811>, <-1.065827, -3.029538, -24.124034>, <-1.133619, -3.078792, -23.650957>, <-1.133619, -3.078792, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.870239, -1.643216, -23.414490>, <0.860293, -1.650442, -23.381512>, <0.853514, -1.655368, -23.334203>, <0.853514, -1.655368, -23.299010>, 
      <0.487308, -1.927232, -23.633901>, <0.477362, -1.934458, -23.600923>, <0.438805, -1.962471, -23.334203>, <0.438805, -1.962471, -23.299010>, 
      <-0.018461, -2.312518, -23.926450>, <-0.091398, -2.365510, -23.684613>, <-0.109334, -2.378541, -23.557104>, <-0.109334, -2.378541, -23.299010>, 
      <-0.406196, -2.589936, -24.145864>, <-0.479133, -2.642928, -23.904027>, <-0.528847, -2.679047, -23.557104>, <-0.528848, -2.679047, -23.299010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.083125, -3.282905, -23.299010>, <-0.083125, -3.282905, -23.041646>, <-0.033552, -3.246889, -22.695709>, <0.039177, -3.194047, -22.454560>, 
      <0.342836, -2.994665, -23.299010>, <0.342836, -2.994665, -23.041646>, <0.360760, -2.981643, -22.914282>, <0.433490, -2.928802, -22.673131>, 
      <0.887760, -2.577516, -23.299010>, <0.887760, -2.577516, -23.263814>, <0.926212, -2.549579, -22.997816>, <0.936158, -2.542353, -22.964838>, 
      <1.303853, -2.275207, -23.299010>, <1.303853, -2.275207, -23.263814>, <1.310632, -2.270281, -23.216507>, <1.320578, -2.263055, -23.183530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.724459, -3.647728, -23.299010>, <-0.724459, -3.647728, -22.946621>, <-0.656583, -3.598413, -22.472954>, <-0.556999, -3.526061, -22.142763>, 
      <-0.513905, -3.579439, -23.299010>, <-0.513905, -3.579439, -22.946621>, <-0.458716, -3.539459, -22.562576>, <-0.359132, -3.467107, -22.232386>, 
      <-0.266449, -3.406957, -23.299010>, <-0.266449, -3.406957, -23.041646>, <-0.203221, -3.361021, -22.601659>, <-0.130491, -3.308180, -22.360510>, 
      <-0.083125, -3.282905, -23.299010>, <-0.083125, -3.282905, -23.041646>, <-0.033552, -3.246889, -22.695709>, <0.039177, -3.194047, -22.454560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.183437, -3.639770, -23.299010>, <-1.183437, -3.639770, -22.899109>, <-1.106409, -3.583805, -22.361576>, <-0.993398, -3.501698, -21.986866>, 
      <-1.051176, -3.678136, -23.299010>, <-1.051176, -3.678136, -22.899109>, <-0.978785, -3.626137, -22.397645>, <-0.865774, -3.544030, -22.022934>, 
      <-0.855456, -3.690214, -23.299010>, <-0.855456, -3.690214, -22.946621>, <-0.778969, -3.634877, -22.417520>, <-0.679385, -3.562525, -22.087330>, 
      <-0.724459, -3.647728, -23.299010>, <-0.724459, -3.647728, -22.946621>, <-0.656583, -3.598413, -22.472954>, <-0.556999, -3.526061, -22.142763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.286269, -3.484758, -23.299010>, <-1.286270, -3.484758, -22.900134>, <-1.209439, -3.428937, -22.363982>, <-1.096718, -3.347040, -21.990234>, 
      <-1.291206, -3.540344, -23.299010>, <-1.291206, -3.540344, -22.900134>, <-1.212098, -3.482490, -22.348507>, <-1.099377, -3.400593, -21.974758>, 
      <-1.237034, -3.624222, -23.299010>, <-1.237034, -3.624222, -22.899109>, <-1.157570, -3.566836, -22.347118>, <-1.044559, -3.484728, -21.972408>, 
      <-1.183437, -3.639770, -23.299010>, <-1.183437, -3.639770, -22.899109>, <-1.106409, -3.583805, -22.361576>, <-0.993398, -3.501698, -21.986866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.133619, -3.078792, -23.299010>, <-1.133619, -3.078792, -22.947061>, <-1.065827, -3.029538, -22.473986>, <-0.966368, -2.957277, -22.144206>, 
      <-1.222739, -3.173594, -23.299010>, <-1.222739, -3.173594, -22.947061>, <-1.146713, -3.118223, -22.419878>, <-1.047254, -3.045962, -22.090099>, 
      <-1.274760, -3.355152, -23.299010>, <-1.274760, -3.355152, -22.900134>, <-1.203166, -3.302593, -22.400498>, <-1.090445, -3.220697, -22.026749>, 
      <-1.286269, -3.484758, -23.299010>, <-1.286270, -3.484758, -22.900134>, <-1.209439, -3.428937, -22.363982>, <-1.096718, -3.347040, -21.990234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.528848, -2.679047, -23.299010>, <-0.528848, -2.679047, -23.040915>, <-0.479134, -2.642928, -22.693990>, <-0.406197, -2.589936, -22.452154>, 
      <-0.705651, -2.805695, -23.299010>, <-0.705651, -2.805695, -23.040915>, <-0.642539, -2.759841, -22.601520>, <-0.569602, -2.706849, -22.359683>, 
      <-0.984657, -2.920333, -23.299010>, <-0.984657, -2.920333, -22.947061>, <-0.929948, -2.880557, -22.564880>, <-0.830488, -2.808295, -22.235102>, 
      <-1.133619, -3.078792, -23.299010>, <-1.133619, -3.078792, -22.947061>, <-1.065827, -3.029538, -22.473986>, <-0.966368, -2.957277, -22.144206>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.853514, -1.655368, -23.299010>, <0.853514, -1.655368, -23.263814>, <0.860293, -1.650442, -23.216507>, <0.870239, -1.643216, -23.183530>, 
      <0.438805, -1.962471, -23.299010>, <0.438805, -1.962471, -23.263814>, <0.477362, -1.934458, -22.997094>, <0.487308, -1.927232, -22.964117>, 
      <-0.109334, -2.378541, -23.299010>, <-0.109334, -2.378541, -23.040915>, <-0.091398, -2.365510, -22.913406>, <-0.018461, -2.312518, -22.671570>, 
      <-0.528848, -2.679047, -23.299010>, <-0.528848, -2.679047, -23.040915>, <-0.479134, -2.642928, -22.693990>, <-0.406197, -2.589936, -22.452154>
    }
  }
  material {
    caracasa_poleas_txt
  }
  photons {
    collect off
  }
}
#declare gancho_nudo = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <29.006416, -3.335291, -32.999286>, <29.344550, -3.335291, -32.999286>, <29.795398, -3.335291, -32.999286>, <30.133533, -3.335291, -32.999286>, 
      <29.006416, -3.221907, -32.999286>, <29.344550, -3.221907, -32.999286>, <29.795398, -3.221907, -32.999286>, <30.133533, -3.221907, -32.999286>, 
      <29.006416, -3.127551, -32.904931>, <29.344550, -3.127551, -32.904931>, <29.795398, -3.127551, -32.904931>, <30.133533, -3.127551, -32.904931>, 
      <29.006416, -3.127551, -32.791546>, <29.344550, -3.127551, -32.791546>, <29.795398, -3.127551, -32.791546>, <30.133533, -3.127551, -32.791546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <30.133533, -3.543031, -32.791546>, <29.795398, -3.543031, -32.791546>, <29.344550, -3.543031, -32.791546>, <29.006416, -3.543031, -32.791546>, 
      <30.133533, -3.543031, -32.904931>, <29.795398, -3.543031, -32.904931>, <29.344550, -3.543031, -32.904931>, <29.006416, -3.543031, -32.904931>, 
      <30.133533, -3.448675, -32.999286>, <29.795398, -3.448675, -32.999286>, <29.344550, -3.448675, -32.999286>, <29.006416, -3.448675, -32.999286>, 
      <30.133533, -3.335291, -32.999286>, <29.795398, -3.335291, -32.999286>, <29.344550, -3.335291, -32.999286>, <29.006416, -3.335291, -32.999286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <30.133533, -3.335291, -32.583808>, <29.795398, -3.335291, -32.583808>, <29.344550, -3.335291, -32.583808>, <29.006416, -3.335291, -32.583808>, 
      <30.133533, -3.448674, -32.583808>, <29.795398, -3.448674, -32.583808>, <29.344550, -3.448674, -32.583808>, <29.006416, -3.448674, -32.583808>, 
      <30.133533, -3.543031, -32.678163>, <29.795398, -3.543031, -32.678163>, <29.344550, -3.543031, -32.678163>, <29.006416, -3.543031, -32.678163>, 
      <30.133533, -3.543031, -32.791546>, <29.795398, -3.543031, -32.791546>, <29.344550, -3.543031, -32.791546>, <29.006416, -3.543031, -32.791546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <30.133533, -3.127551, -32.791546>, <29.795398, -3.127551, -32.791546>, <29.344550, -3.127551, -32.791546>, <29.006416, -3.127551, -32.791546>, 
      <30.133533, -3.127551, -32.678163>, <29.795398, -3.127551, -32.678163>, <29.344550, -3.127551, -32.678163>, <29.006416, -3.127551, -32.678163>, 
      <30.133533, -3.221908, -32.583808>, <29.795398, -3.221908, -32.583808>, <29.344550, -3.221908, -32.583808>, <29.006416, -3.221908, -32.583808>, 
      <30.133533, -3.335291, -32.583808>, <29.795398, -3.335291, -32.583808>, <29.344550, -3.335291, -32.583808>, <29.006416, -3.335291, -32.583808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.202698, -3.703470, -33.016445>, <27.245795, -3.807515, -33.016445>, <27.331622, -3.935964, -33.016445>, <27.411254, -4.015597, -33.016445>, 
      <27.086973, -3.751405, -33.016445>, <27.130070, -3.855450, -33.016445>, <27.243050, -4.024537, -33.016445>, <27.322682, -4.104170, -33.016445>, 
      <26.990669, -3.791296, -32.912205>, <27.044048, -3.920160, -32.912205>, <27.150346, -4.079250, -32.912205>, <27.248973, -4.177878, -32.912205>, 
      <26.990669, -3.791296, -32.786944>, <27.044048, -3.920160, -32.786944>, <27.150346, -4.079250, -32.786944>, <27.248973, -4.177878, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.414730, -3.615644, -32.786944>, <27.447546, -3.694870, -32.786944>, <27.512899, -3.792680, -32.786944>, <27.573536, -3.853316, -32.786944>, 
      <27.414730, -3.615644, -32.912205>, <27.447546, -3.694870, -32.912205>, <27.512899, -3.792680, -32.912205>, <27.573536, -3.853316, -32.912205>, 
      <27.318426, -3.655535, -33.016445>, <27.361520, -3.759580, -33.016445>, <27.420195, -3.847392, -33.016445>, <27.499827, -3.927025, -33.016445>, 
      <27.202698, -3.703470, -33.016445>, <27.245795, -3.807515, -33.016445>, <27.331622, -3.935964, -33.016445>, <27.411254, -4.015597, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.202698, -3.703470, -32.557446>, <27.245795, -3.807515, -32.557446>, <27.331622, -3.935964, -32.557446>, <27.411254, -4.015597, -32.557446>, 
      <27.318426, -3.655535, -32.557446>, <27.361520, -3.759580, -32.557446>, <27.420195, -3.847392, -32.557446>, <27.499827, -3.927025, -32.557446>, 
      <27.414730, -3.615644, -32.661686>, <27.447546, -3.694870, -32.661686>, <27.512899, -3.792680, -32.661686>, <27.573536, -3.853316, -32.661686>, 
      <27.414730, -3.615644, -32.786944>, <27.447546, -3.694870, -32.786944>, <27.512899, -3.792680, -32.786944>, <27.573536, -3.853316, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <26.990669, -3.791296, -32.786944>, <27.044048, -3.920160, -32.786944>, <27.150346, -4.079250, -32.786944>, <27.248973, -4.177878, -32.786944>, 
      <26.990669, -3.791296, -32.661686>, <27.044048, -3.920160, -32.661686>, <27.150346, -4.079250, -32.661686>, <27.248973, -4.177878, -32.661686>, 
      <27.086973, -3.751405, -32.557446>, <27.130070, -3.855450, -32.557446>, <27.243050, -4.024537, -32.557446>, <27.322682, -4.104170, -32.557446>, 
      <27.202698, -3.703470, -32.557446>, <27.245795, -3.807515, -32.557446>, <27.331622, -3.935964, -32.557446>, <27.411254, -4.015597, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.411254, -4.015597, -33.016445>, <27.490886, -4.095230, -33.016445>, <27.619334, -4.181058, -33.016445>, <27.723382, -4.224154, -33.016445>, 
      <27.322682, -4.104170, -33.016445>, <27.402314, -4.183803, -33.016445>, <27.571398, -4.296784, -33.016445>, <27.675446, -4.339880, -33.016445>, 
      <27.248973, -4.177878, -32.912205>, <27.347603, -4.276507, -32.912205>, <27.506691, -4.382808, -32.912205>, <27.635555, -4.436185, -32.912205>, 
      <27.248973, -4.177878, -32.786944>, <27.347603, -4.276507, -32.786944>, <27.506691, -4.382808, -32.786944>, <27.635555, -4.436185, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.573536, -3.853316, -32.786944>, <27.634173, -3.913954, -32.786944>, <27.731981, -3.979308, -32.786944>, <27.811206, -4.012124, -32.786944>, 
      <27.573536, -3.853316, -32.912205>, <27.634173, -3.913954, -32.912205>, <27.731981, -3.979308, -32.912205>, <27.811206, -4.012124, -32.912205>, 
      <27.499827, -3.927025, -33.016445>, <27.579459, -4.006658, -33.016445>, <27.667270, -4.065332, -33.016445>, <27.771315, -4.108428, -33.016445>, 
      <27.411254, -4.015597, -33.016445>, <27.490886, -4.095230, -33.016445>, <27.619334, -4.181058, -33.016445>, <27.723382, -4.224154, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.411254, -4.015597, -32.557446>, <27.490886, -4.095230, -32.557446>, <27.619334, -4.181058, -32.557446>, <27.723382, -4.224154, -32.557446>, 
      <27.499827, -3.927025, -32.557446>, <27.579459, -4.006658, -32.557446>, <27.667270, -4.065332, -32.557446>, <27.771315, -4.108428, -32.557446>, 
      <27.573536, -3.853316, -32.661686>, <27.634173, -3.913954, -32.661686>, <27.731981, -3.979308, -32.661686>, <27.811206, -4.012124, -32.661686>, 
      <27.573536, -3.853316, -32.786944>, <27.634173, -3.913954, -32.786944>, <27.731981, -3.979308, -32.786944>, <27.811206, -4.012124, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.248973, -4.177878, -32.786944>, <27.347603, -4.276507, -32.786944>, <27.506691, -4.382808, -32.786944>, <27.635555, -4.436185, -32.786944>, 
      <27.248973, -4.177878, -32.661686>, <27.347603, -4.276507, -32.661686>, <27.506691, -4.382808, -32.661686>, <27.635555, -4.436185, -32.661686>, 
      <27.322682, -4.104170, -32.557446>, <27.402314, -4.183803, -32.557446>, <27.571398, -4.296784, -32.557446>, <27.675446, -4.339880, -32.557446>, 
      <27.411254, -4.015597, -32.557446>, <27.490886, -4.095230, -32.557446>, <27.619334, -4.181058, -32.557446>, <27.723382, -4.224154, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.723382, -4.224154, -33.016445>, <27.827427, -4.267252, -33.016445>, <27.978944, -4.297390, -33.016445>, <28.091562, -4.297390, -33.016445>, 
      <27.675446, -4.339880, -33.016445>, <27.779491, -4.382978, -33.016445>, <27.978944, -4.422651, -33.016445>, <28.091562, -4.422651, -33.016445>, 
      <27.635555, -4.436185, -32.912205>, <27.764419, -4.489562, -32.912205>, <27.952077, -4.526890, -32.912205>, <28.091562, -4.526890, -32.912205>, 
      <27.635555, -4.436185, -32.786944>, <27.764419, -4.489562, -32.786944>, <27.952077, -4.526890, -32.786944>, <28.091562, -4.526890, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.811206, -4.012124, -32.786944>, <27.890432, -4.044941, -32.786944>, <28.005805, -4.067890, -32.786944>, <28.091562, -4.067890, -32.786944>, 
      <27.811206, -4.012124, -32.912205>, <27.890432, -4.044941, -32.912205>, <28.005805, -4.067890, -32.912205>, <28.091562, -4.067890, -32.912205>, 
      <27.771315, -4.108428, -33.016445>, <27.875363, -4.151526, -33.016445>, <27.978944, -4.172129, -33.016445>, <28.091562, -4.172129, -33.016445>, 
      <27.723382, -4.224154, -33.016445>, <27.827427, -4.267252, -33.016445>, <27.978944, -4.297390, -33.016445>, <28.091562, -4.297390, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.723382, -4.224154, -32.557446>, <27.827427, -4.267252, -32.557446>, <27.978944, -4.297390, -32.557446>, <28.091562, -4.297390, -32.557446>, 
      <27.771315, -4.108428, -32.557446>, <27.875363, -4.151526, -32.557446>, <27.978944, -4.172129, -32.557446>, <28.091562, -4.172129, -32.557446>, 
      <27.811206, -4.012124, -32.661686>, <27.890432, -4.044941, -32.661686>, <28.005805, -4.067890, -32.661686>, <28.091562, -4.067890, -32.661686>, 
      <27.811206, -4.012124, -32.786944>, <27.890432, -4.044941, -32.786944>, <28.005805, -4.067890, -32.786944>, <28.091562, -4.067890, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.635555, -4.436185, -32.786944>, <27.764419, -4.489562, -32.786944>, <27.952077, -4.526890, -32.786944>, <28.091562, -4.526890, -32.786944>, 
      <27.635555, -4.436185, -32.661686>, <27.764419, -4.489562, -32.661686>, <27.952077, -4.526890, -32.661686>, <28.091562, -4.526890, -32.661686>, 
      <27.675446, -4.339880, -32.557446>, <27.779491, -4.382978, -32.557446>, <27.978944, -4.422651, -32.557446>, <28.091562, -4.422651, -32.557446>, 
      <27.723382, -4.224154, -32.557446>, <27.827427, -4.267252, -32.557446>, <27.978944, -4.297390, -32.557446>, <28.091562, -4.297390, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.091562, -4.297390, -33.016445>, <28.204179, -4.297390, -33.016445>, <28.355693, -4.267251, -33.016445>, <28.459741, -4.224154, -33.016445>, 
      <28.091562, -4.422651, -33.016445>, <28.204179, -4.422651, -33.016445>, <28.403629, -4.382977, -33.016445>, <28.507674, -4.339880, -33.016445>, 
      <28.091562, -4.526890, -32.912205>, <28.231043, -4.526890, -32.912205>, <28.418701, -4.489562, -32.912205>, <28.547565, -4.436185, -32.912205>, 
      <28.091562, -4.526890, -32.786944>, <28.231043, -4.526890, -32.786944>, <28.418701, -4.489562, -32.786944>, <28.547565, -4.436185, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.091562, -4.067890, -32.786944>, <28.177315, -4.067890, -32.786944>, <28.292688, -4.044940, -32.786944>, <28.371914, -4.012124, -32.786944>, 
      <28.091562, -4.067890, -32.912205>, <28.177315, -4.067890, -32.912205>, <28.292688, -4.044940, -32.912205>, <28.371914, -4.012124, -32.912205>, 
      <28.091562, -4.172129, -33.016445>, <28.204179, -4.172129, -33.016445>, <28.307757, -4.151525, -33.016445>, <28.411805, -4.108428, -33.016445>, 
      <28.091562, -4.297390, -33.016445>, <28.204179, -4.297390, -33.016445>, <28.355693, -4.267251, -33.016445>, <28.459741, -4.224154, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.091562, -4.297390, -32.557446>, <28.204179, -4.297390, -32.557446>, <28.355693, -4.267251, -32.557446>, <28.459741, -4.224154, -32.557446>, 
      <28.091562, -4.172129, -32.557446>, <28.204179, -4.172129, -32.557446>, <28.307757, -4.151525, -32.557446>, <28.411805, -4.108428, -32.557446>, 
      <28.091562, -4.067890, -32.661686>, <28.177315, -4.067890, -32.661686>, <28.292688, -4.044940, -32.661686>, <28.371914, -4.012124, -32.661686>, 
      <28.091562, -4.067890, -32.786944>, <28.177315, -4.067890, -32.786944>, <28.292688, -4.044940, -32.786944>, <28.371914, -4.012124, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.091562, -4.526890, -32.786944>, <28.231043, -4.526890, -32.786944>, <28.418701, -4.489562, -32.786944>, <28.547565, -4.436185, -32.786944>, 
      <28.091562, -4.526890, -32.661686>, <28.231043, -4.526890, -32.661686>, <28.418701, -4.489562, -32.661686>, <28.547565, -4.436185, -32.661686>, 
      <28.091562, -4.422651, -32.557446>, <28.204179, -4.422651, -32.557446>, <28.403629, -4.382977, -32.557446>, <28.507674, -4.339880, -32.557446>, 
      <28.091562, -4.297390, -32.557446>, <28.204179, -4.297390, -32.557446>, <28.355693, -4.267251, -32.557446>, <28.459741, -4.224154, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.459741, -4.224154, -33.016445>, <28.563786, -4.181058, -33.016445>, <28.692237, -4.095230, -33.016445>, <28.771869, -4.015598, -33.016445>, 
      <28.507674, -4.339880, -33.016445>, <28.611722, -4.296784, -33.016445>, <28.780810, -4.183804, -33.016445>, <28.860442, -4.104171, -33.016445>, 
      <28.547565, -4.436185, -32.912205>, <28.676429, -4.382808, -32.912205>, <28.835523, -4.276508, -32.912205>, <28.934150, -4.177879, -32.912205>, 
      <28.547565, -4.436185, -32.786944>, <28.676429, -4.382808, -32.786944>, <28.835523, -4.276508, -32.786944>, <28.934150, -4.177879, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.371914, -4.012124, -32.786944>, <28.451142, -3.979308, -32.786944>, <28.548950, -3.913954, -32.786944>, <28.609587, -3.853317, -32.786944>, 
      <28.371914, -4.012124, -32.912205>, <28.451142, -3.979308, -32.912205>, <28.548950, -3.913954, -32.912205>, <28.609587, -3.853317, -32.912205>, 
      <28.411805, -4.108428, -33.016445>, <28.515850, -4.065332, -33.016445>, <28.603664, -4.006658, -33.016445>, <28.683296, -3.927025, -33.016445>, 
      <28.459741, -4.224154, -33.016445>, <28.563786, -4.181058, -33.016445>, <28.692237, -4.095230, -33.016445>, <28.771869, -4.015598, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.459741, -4.224154, -32.557446>, <28.563786, -4.181058, -32.557446>, <28.692237, -4.095230, -32.557446>, <28.771869, -4.015598, -32.557446>, 
      <28.411805, -4.108428, -32.557446>, <28.515850, -4.065332, -32.557446>, <28.603664, -4.006658, -32.557446>, <28.683296, -3.927025, -32.557446>, 
      <28.371914, -4.012124, -32.661686>, <28.451142, -3.979308, -32.661686>, <28.548950, -3.913954, -32.661686>, <28.609587, -3.853317, -32.661686>, 
      <28.371914, -4.012124, -32.786944>, <28.451142, -3.979308, -32.786944>, <28.548950, -3.913954, -32.786944>, <28.609587, -3.853317, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.547565, -4.436185, -32.786944>, <28.676429, -4.382808, -32.786944>, <28.835523, -4.276508, -32.786944>, <28.934150, -4.177879, -32.786944>, 
      <28.547565, -4.436185, -32.661686>, <28.676429, -4.382808, -32.661686>, <28.835523, -4.276508, -32.661686>, <28.934150, -4.177879, -32.661686>, 
      <28.507674, -4.339880, -32.557446>, <28.611722, -4.296784, -32.557446>, <28.780810, -4.183804, -32.557446>, <28.860442, -4.104171, -32.557446>, 
      <28.459741, -4.224154, -32.557446>, <28.563786, -4.181058, -32.557446>, <28.692237, -4.095230, -32.557446>, <28.771869, -4.015598, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.771869, -4.015598, -33.016445>, <28.851504, -3.935965, -33.016445>, <28.937331, -3.807516, -33.016445>, <28.980426, -3.703470, -33.016445>, 
      <28.860442, -4.104171, -33.016445>, <28.940077, -4.024538, -33.016445>, <29.053056, -3.855451, -33.016445>, <29.096150, -3.751405, -33.016445>, 
      <28.934150, -4.177879, -32.912205>, <29.032781, -4.079251, -32.912205>, <29.139078, -3.920160, -32.912205>, <29.192454, -3.791296, -32.912205>, 
      <28.934150, -4.177879, -32.786944>, <29.032781, -4.079251, -32.786944>, <29.139078, -3.920160, -32.786944>, <29.192454, -3.791296, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.609587, -3.853317, -32.786944>, <28.670224, -3.792680, -32.786944>, <28.735578, -3.694870, -32.786944>, <28.768394, -3.615644, -32.786944>, 
      <28.609587, -3.853317, -32.912205>, <28.670224, -3.792680, -32.912205>, <28.735578, -3.694870, -32.912205>, <28.768394, -3.615644, -32.912205>, 
      <28.683296, -3.927025, -33.016445>, <28.762931, -3.847392, -33.016445>, <28.821603, -3.759580, -33.016445>, <28.864701, -3.655535, -33.016445>, 
      <28.771869, -4.015598, -33.016445>, <28.851504, -3.935965, -33.016445>, <28.937331, -3.807516, -33.016445>, <28.980426, -3.703470, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.771869, -4.015598, -32.557446>, <28.851504, -3.935965, -32.557446>, <28.937331, -3.807516, -32.557446>, <28.980426, -3.703470, -32.557446>, 
      <28.683296, -3.927025, -32.557446>, <28.762931, -3.847392, -32.557446>, <28.821603, -3.759580, -32.557446>, <28.864701, -3.655535, -32.557446>, 
      <28.609587, -3.853317, -32.661686>, <28.670224, -3.792680, -32.661686>, <28.735578, -3.694870, -32.661686>, <28.768394, -3.615644, -32.661686>, 
      <28.609587, -3.853317, -32.786944>, <28.670224, -3.792680, -32.786944>, <28.735578, -3.694870, -32.786944>, <28.768394, -3.615644, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.934150, -4.177879, -32.786944>, <29.032781, -4.079251, -32.786944>, <29.139078, -3.920160, -32.786944>, <29.192454, -3.791296, -32.786944>, 
      <28.934150, -4.177879, -32.661686>, <29.032781, -4.079251, -32.661686>, <29.139078, -3.920160, -32.661686>, <29.192454, -3.791296, -32.661686>, 
      <28.860442, -4.104171, -32.557446>, <28.940077, -4.024538, -32.557446>, <29.053056, -3.855451, -32.557446>, <29.096150, -3.751405, -32.557446>, 
      <28.771869, -4.015598, -32.557446>, <28.851504, -3.935965, -32.557446>, <28.937331, -3.807516, -32.557446>, <28.980426, -3.703470, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.980426, -3.703470, -33.016445>, <29.023523, -3.599425, -33.016445>, <29.053661, -3.447909, -33.016445>, <29.053661, -3.335291, -33.016445>, 
      <29.096150, -3.751405, -33.016445>, <29.139248, -3.647360, -33.016445>, <29.178922, -3.447909, -33.016445>, <29.178922, -3.335291, -33.016445>, 
      <29.192454, -3.791296, -32.912205>, <29.245834, -3.662432, -32.912205>, <29.283162, -3.474773, -32.912205>, <29.283162, -3.335291, -32.912205>, 
      <29.192454, -3.791296, -32.786944>, <29.245834, -3.662432, -32.786944>, <29.283162, -3.474773, -32.786944>, <29.283162, -3.335291, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.768394, -3.615644, -32.786944>, <28.801210, -3.536418, -32.786944>, <28.824160, -3.421045, -32.786944>, <28.824160, -3.335291, -32.786944>, 
      <28.768394, -3.615644, -32.912205>, <28.801210, -3.536418, -32.912205>, <28.824160, -3.421045, -32.912205>, <28.824160, -3.335291, -32.912205>, 
      <28.864701, -3.655535, -33.016445>, <28.907798, -3.551490, -33.016445>, <28.928400, -3.447909, -33.016445>, <28.928400, -3.335291, -33.016445>, 
      <28.980426, -3.703470, -33.016445>, <29.023523, -3.599425, -33.016445>, <29.053661, -3.447909, -33.016445>, <29.053661, -3.335291, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.980426, -3.703470, -32.557446>, <29.023523, -3.599425, -32.557446>, <29.053661, -3.447909, -32.557446>, <29.053661, -3.335291, -32.557446>, 
      <28.864701, -3.655535, -32.557446>, <28.907798, -3.551490, -32.557446>, <28.928400, -3.447909, -32.557446>, <28.928400, -3.335291, -32.557446>, 
      <28.768394, -3.615644, -32.661686>, <28.801210, -3.536418, -32.661686>, <28.824160, -3.421045, -32.661686>, <28.824160, -3.335291, -32.661686>, 
      <28.768394, -3.615644, -32.786944>, <28.801210, -3.536418, -32.786944>, <28.824160, -3.421045, -32.786944>, <28.824160, -3.335291, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <29.192454, -3.791296, -32.786944>, <29.245834, -3.662432, -32.786944>, <29.283162, -3.474773, -32.786944>, <29.283162, -3.335291, -32.786944>, 
      <29.192454, -3.791296, -32.661686>, <29.245834, -3.662432, -32.661686>, <29.283162, -3.474773, -32.661686>, <29.283162, -3.335291, -32.661686>, 
      <29.096150, -3.751405, -32.557446>, <29.139248, -3.647360, -32.557446>, <29.178922, -3.447909, -32.557446>, <29.178922, -3.335291, -32.557446>, 
      <28.980426, -3.703470, -32.557446>, <29.023523, -3.599425, -32.557446>, <29.053661, -3.447909, -32.557446>, <29.053661, -3.335291, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <29.053661, -3.335291, -33.016445>, <29.053661, -3.222673, -33.016445>, <29.023523, -3.071157, -33.016445>, <28.980426, -2.967112, -33.016445>, 
      <29.178922, -3.335291, -33.016445>, <29.178922, -3.222673, -33.016445>, <29.139248, -3.023222, -33.016445>, <29.096150, -2.919177, -33.016445>, 
      <29.283162, -3.335291, -32.912205>, <29.283162, -3.195809, -32.912205>, <29.245834, -3.008150, -32.912205>, <29.192454, -2.879286, -32.912205>, 
      <29.283162, -3.335291, -32.786944>, <29.283162, -3.195809, -32.786944>, <29.245834, -3.008150, -32.786944>, <29.192454, -2.879286, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.824160, -3.335291, -32.786944>, <28.824160, -3.249537, -32.786944>, <28.801210, -3.134164, -32.786944>, <28.768394, -3.054938, -32.786944>, 
      <28.824160, -3.335291, -32.912205>, <28.824160, -3.249537, -32.912205>, <28.801210, -3.134164, -32.912205>, <28.768394, -3.054938, -32.912205>, 
      <28.928400, -3.335291, -33.016445>, <28.928400, -3.222673, -33.016445>, <28.907798, -3.119092, -33.016445>, <28.864701, -3.015047, -33.016445>, 
      <29.053661, -3.335291, -33.016445>, <29.053661, -3.222673, -33.016445>, <29.023523, -3.071157, -33.016445>, <28.980426, -2.967112, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <29.053661, -3.335291, -32.557446>, <29.053661, -3.222673, -32.557446>, <29.023523, -3.071157, -32.557446>, <28.980426, -2.967112, -32.557446>, 
      <28.928400, -3.335291, -32.557446>, <28.928400, -3.222673, -32.557446>, <28.907798, -3.119092, -32.557446>, <28.864701, -3.015047, -32.557446>, 
      <28.824160, -3.335291, -32.661686>, <28.824160, -3.249537, -32.661686>, <28.801210, -3.134164, -32.661686>, <28.768394, -3.054938, -32.661686>, 
      <28.824160, -3.335291, -32.786944>, <28.824160, -3.249537, -32.786944>, <28.801210, -3.134164, -32.786944>, <28.768394, -3.054938, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <29.283162, -3.335291, -32.786944>, <29.283162, -3.195809, -32.786944>, <29.245834, -3.008150, -32.786944>, <29.192454, -2.879286, -32.786944>, 
      <29.283162, -3.335291, -32.661686>, <29.283162, -3.195809, -32.661686>, <29.245834, -3.008150, -32.661686>, <29.192454, -2.879286, -32.661686>, 
      <29.178922, -3.335291, -32.557446>, <29.178922, -3.222673, -32.557446>, <29.139248, -3.023222, -32.557446>, <29.096150, -2.919177, -32.557446>, 
      <29.053661, -3.335291, -32.557446>, <29.053661, -3.222673, -32.557446>, <29.023523, -3.071157, -32.557446>, <28.980426, -2.967112, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.980426, -2.967112, -33.016445>, <28.937331, -2.863066, -33.016445>, <28.851504, -2.734617, -33.016445>, <28.771869, -2.654984, -33.016445>, 
      <29.096150, -2.919177, -33.016445>, <29.053056, -2.815131, -33.016445>, <28.940077, -2.646044, -33.016445>, <28.860442, -2.566411, -33.016445>, 
      <29.192454, -2.879286, -32.912205>, <29.139078, -2.750422, -32.912205>, <29.032781, -2.591331, -32.912205>, <28.934150, -2.492703, -32.912205>, 
      <29.192454, -2.879286, -32.786944>, <29.139078, -2.750422, -32.786944>, <29.032781, -2.591331, -32.786944>, <28.934150, -2.492703, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.768394, -3.054938, -32.786944>, <28.735578, -2.975712, -32.786944>, <28.670224, -2.877902, -32.786944>, <28.609587, -2.817265, -32.786944>, 
      <28.768394, -3.054938, -32.912205>, <28.735578, -2.975712, -32.912205>, <28.670224, -2.877902, -32.912205>, <28.609587, -2.817265, -32.912205>, 
      <28.864701, -3.015047, -33.016445>, <28.821603, -2.911002, -33.016445>, <28.762931, -2.823189, -33.016445>, <28.683296, -2.743557, -33.016445>, 
      <28.980426, -2.967112, -33.016445>, <28.937331, -2.863066, -33.016445>, <28.851504, -2.734617, -33.016445>, <28.771869, -2.654984, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.980426, -2.967112, -32.557446>, <28.937331, -2.863066, -32.557446>, <28.851504, -2.734617, -32.557446>, <28.771869, -2.654984, -32.557446>, 
      <28.864701, -3.015047, -32.557446>, <28.821603, -2.911002, -32.557446>, <28.762931, -2.823189, -32.557446>, <28.683296, -2.743557, -32.557446>, 
      <28.768394, -3.054938, -32.661686>, <28.735578, -2.975712, -32.661686>, <28.670224, -2.877902, -32.661686>, <28.609587, -2.817265, -32.661686>, 
      <28.768394, -3.054938, -32.786944>, <28.735578, -2.975712, -32.786944>, <28.670224, -2.877902, -32.786944>, <28.609587, -2.817265, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <29.192454, -2.879286, -32.786944>, <29.139078, -2.750422, -32.786944>, <29.032781, -2.591331, -32.786944>, <28.934150, -2.492703, -32.786944>, 
      <29.192454, -2.879286, -32.661686>, <29.139078, -2.750422, -32.661686>, <29.032781, -2.591331, -32.661686>, <28.934150, -2.492703, -32.661686>, 
      <29.096150, -2.919177, -32.557446>, <29.053056, -2.815131, -32.557446>, <28.940077, -2.646044, -32.557446>, <28.860442, -2.566411, -32.557446>, 
      <28.980426, -2.967112, -32.557446>, <28.937331, -2.863066, -32.557446>, <28.851504, -2.734617, -32.557446>, <28.771869, -2.654984, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.771869, -2.654984, -33.016445>, <28.692237, -2.575351, -33.016445>, <28.563786, -2.489524, -33.016445>, <28.459741, -2.446427, -33.016445>, 
      <28.860442, -2.566411, -33.016445>, <28.780810, -2.486778, -33.016445>, <28.611722, -2.373798, -33.016445>, <28.507674, -2.330701, -33.016445>, 
      <28.934150, -2.492703, -32.912205>, <28.835523, -2.394074, -32.912205>, <28.676429, -2.287774, -32.912205>, <28.547565, -2.234397, -32.912205>, 
      <28.934150, -2.492703, -32.786944>, <28.835523, -2.394074, -32.786944>, <28.676429, -2.287774, -32.786944>, <28.547565, -2.234397, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.609587, -2.817265, -32.786944>, <28.548950, -2.756628, -32.786944>, <28.451142, -2.691274, -32.786944>, <28.371914, -2.658458, -32.786944>, 
      <28.609587, -2.817265, -32.912205>, <28.548950, -2.756628, -32.912205>, <28.451142, -2.691274, -32.912205>, <28.371914, -2.658458, -32.912205>, 
      <28.683296, -2.743557, -33.016445>, <28.603664, -2.663924, -33.016445>, <28.515850, -2.605250, -33.016445>, <28.411805, -2.562153, -33.016445>, 
      <28.771869, -2.654984, -33.016445>, <28.692237, -2.575351, -33.016445>, <28.563786, -2.489524, -33.016445>, <28.459741, -2.446427, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.771869, -2.654984, -32.557446>, <28.692237, -2.575351, -32.557446>, <28.563786, -2.489524, -32.557446>, <28.459741, -2.446427, -32.557446>, 
      <28.683296, -2.743557, -32.557446>, <28.603664, -2.663924, -32.557446>, <28.515850, -2.605250, -32.557446>, <28.411805, -2.562153, -32.557446>, 
      <28.609587, -2.817265, -32.661686>, <28.548950, -2.756628, -32.661686>, <28.451142, -2.691274, -32.661686>, <28.371914, -2.658458, -32.661686>, 
      <28.609587, -2.817265, -32.786944>, <28.548950, -2.756628, -32.786944>, <28.451142, -2.691274, -32.786944>, <28.371914, -2.658458, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.934150, -2.492703, -32.786944>, <28.835523, -2.394074, -32.786944>, <28.676429, -2.287774, -32.786944>, <28.547565, -2.234397, -32.786944>, 
      <28.934150, -2.492703, -32.661686>, <28.835523, -2.394074, -32.661686>, <28.676429, -2.287774, -32.661686>, <28.547565, -2.234397, -32.661686>, 
      <28.860442, -2.566411, -32.557446>, <28.780810, -2.486778, -32.557446>, <28.611722, -2.373798, -32.557446>, <28.507674, -2.330701, -32.557446>, 
      <28.771869, -2.654984, -32.557446>, <28.692237, -2.575351, -32.557446>, <28.563786, -2.489524, -32.557446>, <28.459741, -2.446427, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.459741, -2.446427, -33.016445>, <28.355693, -2.403331, -33.016445>, <28.204179, -2.373192, -33.016445>, <28.091562, -2.373192, -33.016445>, 
      <28.507674, -2.330701, -33.016445>, <28.403629, -2.287605, -33.016445>, <28.204179, -2.247931, -33.016445>, <28.091562, -2.247931, -33.016445>, 
      <28.547565, -2.234397, -32.912205>, <28.418701, -2.181020, -32.912205>, <28.231043, -2.143692, -32.912205>, <28.091562, -2.143692, -32.912205>, 
      <28.547565, -2.234397, -32.786944>, <28.418701, -2.181020, -32.786944>, <28.231043, -2.143692, -32.786944>, <28.091562, -2.143692, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.371914, -2.658458, -32.786944>, <28.292688, -2.625641, -32.786944>, <28.177315, -2.602692, -32.786944>, <28.091562, -2.602692, -32.786944>, 
      <28.371914, -2.658458, -32.912205>, <28.292688, -2.625641, -32.912205>, <28.177315, -2.602692, -32.912205>, <28.091562, -2.602692, -32.912205>, 
      <28.411805, -2.562153, -33.016445>, <28.307757, -2.519057, -33.016445>, <28.204179, -2.498453, -33.016445>, <28.091562, -2.498453, -33.016445>, 
      <28.459741, -2.446427, -33.016445>, <28.355693, -2.403331, -33.016445>, <28.204179, -2.373192, -33.016445>, <28.091562, -2.373192, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.459741, -2.446427, -32.557446>, <28.355693, -2.403331, -32.557446>, <28.204179, -2.373192, -32.557446>, <28.091562, -2.373192, -32.557446>, 
      <28.411805, -2.562153, -32.557446>, <28.307757, -2.519057, -32.557446>, <28.204179, -2.498453, -32.557446>, <28.091562, -2.498453, -32.557446>, 
      <28.371914, -2.658458, -32.661686>, <28.292688, -2.625641, -32.661686>, <28.177315, -2.602692, -32.661686>, <28.091562, -2.602692, -32.661686>, 
      <28.371914, -2.658458, -32.786944>, <28.292688, -2.625641, -32.786944>, <28.177315, -2.602692, -32.786944>, <28.091562, -2.602692, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.547565, -2.234397, -32.786944>, <28.418701, -2.181020, -32.786944>, <28.231043, -2.143692, -32.786944>, <28.091562, -2.143692, -32.786944>, 
      <28.547565, -2.234397, -32.661686>, <28.418701, -2.181020, -32.661686>, <28.231043, -2.143692, -32.661686>, <28.091562, -2.143692, -32.661686>, 
      <28.507674, -2.330701, -32.557446>, <28.403629, -2.287605, -32.557446>, <28.204179, -2.247931, -32.557446>, <28.091562, -2.247931, -32.557446>, 
      <28.459741, -2.446427, -32.557446>, <28.355693, -2.403331, -32.557446>, <28.204179, -2.373192, -32.557446>, <28.091562, -2.373192, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.091562, -2.373192, -33.016445>, <27.978944, -2.373192, -33.016445>, <27.827427, -2.403330, -33.016445>, <27.723382, -2.446427, -33.016445>, 
      <28.091562, -2.247931, -33.016445>, <27.978944, -2.247931, -33.016445>, <27.779491, -2.287604, -33.016445>, <27.675446, -2.330701, -33.016445>, 
      <28.091562, -2.143692, -32.912205>, <27.952077, -2.143692, -32.912205>, <27.764419, -2.181020, -32.912205>, <27.635555, -2.234397, -32.912205>, 
      <28.091562, -2.143692, -32.786944>, <27.952077, -2.143692, -32.786944>, <27.764419, -2.181020, -32.786944>, <27.635555, -2.234397, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.091562, -2.602692, -32.786944>, <28.005805, -2.602692, -32.786944>, <27.890432, -2.625641, -32.786944>, <27.811206, -2.658458, -32.786944>, 
      <28.091562, -2.602692, -32.912205>, <28.005805, -2.602692, -32.912205>, <27.890432, -2.625641, -32.912205>, <27.811206, -2.658458, -32.912205>, 
      <28.091562, -2.498453, -33.016445>, <27.978944, -2.498453, -33.016445>, <27.875363, -2.519056, -33.016445>, <27.771315, -2.562153, -33.016445>, 
      <28.091562, -2.373192, -33.016445>, <27.978944, -2.373192, -33.016445>, <27.827427, -2.403330, -33.016445>, <27.723382, -2.446427, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.091562, -2.373192, -32.557446>, <27.978944, -2.373192, -32.557446>, <27.827427, -2.403330, -32.557446>, <27.723382, -2.446427, -32.557446>, 
      <28.091562, -2.498453, -32.557446>, <27.978944, -2.498453, -32.557446>, <27.875363, -2.519056, -32.557446>, <27.771315, -2.562153, -32.557446>, 
      <28.091562, -2.602692, -32.661686>, <28.005805, -2.602692, -32.661686>, <27.890432, -2.625641, -32.661686>, <27.811206, -2.658458, -32.661686>, 
      <28.091562, -2.602692, -32.786944>, <28.005805, -2.602692, -32.786944>, <27.890432, -2.625641, -32.786944>, <27.811206, -2.658458, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <28.091562, -2.143692, -32.786944>, <27.952077, -2.143692, -32.786944>, <27.764419, -2.181020, -32.786944>, <27.635555, -2.234397, -32.786944>, 
      <28.091562, -2.143692, -32.661686>, <27.952077, -2.143692, -32.661686>, <27.764419, -2.181020, -32.661686>, <27.635555, -2.234397, -32.661686>, 
      <28.091562, -2.247931, -32.557446>, <27.978944, -2.247931, -32.557446>, <27.779491, -2.287604, -32.557446>, <27.675446, -2.330701, -32.557446>, 
      <28.091562, -2.373192, -32.557446>, <27.978944, -2.373192, -32.557446>, <27.827427, -2.403330, -32.557446>, <27.723382, -2.446427, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.723382, -2.446427, -33.016445>, <27.619338, -2.489524, -33.016445>, <27.490886, -2.575352, -33.016445>, <27.411254, -2.654984, -33.016445>, 
      <27.675446, -2.330701, -33.016445>, <27.571402, -2.373798, -33.016445>, <27.402314, -2.486779, -33.016445>, <27.322682, -2.566411, -33.016445>, 
      <27.635555, -2.234397, -32.912205>, <27.506691, -2.287774, -32.912205>, <27.347600, -2.394075, -32.912205>, <27.248973, -2.492703, -32.912205>, 
      <27.635555, -2.234397, -32.786944>, <27.506691, -2.287774, -32.786944>, <27.347600, -2.394075, -32.786944>, <27.248973, -2.492703, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.811206, -2.658458, -32.786944>, <27.731981, -2.691274, -32.786944>, <27.634173, -2.756628, -32.786944>, <27.573536, -2.817265, -32.786944>, 
      <27.811206, -2.658458, -32.912205>, <27.731981, -2.691274, -32.912205>, <27.634173, -2.756628, -32.912205>, <27.573536, -2.817265, -32.912205>, 
      <27.771315, -2.562153, -33.016445>, <27.667274, -2.605250, -33.016445>, <27.579459, -2.663924, -33.016445>, <27.499827, -2.743557, -33.016445>, 
      <27.723382, -2.446427, -33.016445>, <27.619338, -2.489524, -33.016445>, <27.490886, -2.575352, -33.016445>, <27.411254, -2.654984, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.723382, -2.446427, -32.557446>, <27.619338, -2.489524, -32.557446>, <27.490886, -2.575352, -32.557446>, <27.411254, -2.654984, -32.557446>, 
      <27.771315, -2.562153, -32.557446>, <27.667274, -2.605250, -32.557446>, <27.579459, -2.663924, -32.557446>, <27.499827, -2.743557, -32.557446>, 
      <27.811206, -2.658458, -32.661686>, <27.731981, -2.691274, -32.661686>, <27.634173, -2.756628, -32.661686>, <27.573536, -2.817265, -32.661686>, 
      <27.811206, -2.658458, -32.786944>, <27.731981, -2.691274, -32.786944>, <27.634173, -2.756628, -32.786944>, <27.573536, -2.817265, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.635555, -2.234397, -32.786944>, <27.506691, -2.287774, -32.786944>, <27.347600, -2.394075, -32.786944>, <27.248973, -2.492703, -32.786944>, 
      <27.635555, -2.234397, -32.661686>, <27.506691, -2.287774, -32.661686>, <27.347600, -2.394075, -32.661686>, <27.248973, -2.492703, -32.661686>, 
      <27.675446, -2.330701, -32.557446>, <27.571402, -2.373798, -32.557446>, <27.402314, -2.486779, -32.557446>, <27.322682, -2.566411, -32.557446>, 
      <27.723382, -2.446427, -32.557446>, <27.619338, -2.489524, -32.557446>, <27.490886, -2.575352, -32.557446>, <27.411254, -2.654984, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.411254, -2.654984, -33.016445>, <27.331622, -2.734617, -33.016445>, <27.245795, -2.863066, -33.016445>, <27.202698, -2.967112, -33.016445>, 
      <27.322682, -2.566411, -33.016445>, <27.243050, -2.646044, -33.016445>, <27.130070, -2.815131, -33.016445>, <27.086973, -2.919177, -33.016445>, 
      <27.248973, -2.492703, -32.912205>, <27.150346, -2.591332, -32.912205>, <27.044048, -2.750422, -32.912205>, <26.990669, -2.879286, -32.912205>, 
      <27.248973, -2.492703, -32.786944>, <27.150346, -2.591332, -32.786944>, <27.044048, -2.750422, -32.786944>, <26.990669, -2.879286, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.573536, -2.817265, -32.786944>, <27.512899, -2.877902, -32.786944>, <27.447546, -2.975711, -32.786944>, <27.414730, -3.054937, -32.786944>, 
      <27.573536, -2.817265, -32.912205>, <27.512899, -2.877902, -32.912205>, <27.447546, -2.975711, -32.912205>, <27.414730, -3.054937, -32.912205>, 
      <27.499827, -2.743557, -33.016445>, <27.420195, -2.823190, -33.016445>, <27.361520, -2.911001, -33.016445>, <27.318426, -3.015047, -33.016445>, 
      <27.411254, -2.654984, -33.016445>, <27.331622, -2.734617, -33.016445>, <27.245795, -2.863066, -33.016445>, <27.202698, -2.967112, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.411254, -2.654984, -32.557446>, <27.331622, -2.734617, -32.557446>, <27.245795, -2.863066, -32.557446>, <27.202698, -2.967112, -32.557446>, 
      <27.499827, -2.743557, -32.557446>, <27.420195, -2.823190, -32.557446>, <27.361520, -2.911001, -32.557446>, <27.318426, -3.015047, -32.557446>, 
      <27.573536, -2.817265, -32.661686>, <27.512899, -2.877902, -32.661686>, <27.447546, -2.975711, -32.661686>, <27.414730, -3.054937, -32.661686>, 
      <27.573536, -2.817265, -32.786944>, <27.512899, -2.877902, -32.786944>, <27.447546, -2.975711, -32.786944>, <27.414730, -3.054937, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.248973, -2.492703, -32.786944>, <27.150346, -2.591332, -32.786944>, <27.044048, -2.750422, -32.786944>, <26.990669, -2.879286, -32.786944>, 
      <27.248973, -2.492703, -32.661686>, <27.150346, -2.591332, -32.661686>, <27.044048, -2.750422, -32.661686>, <26.990669, -2.879286, -32.661686>, 
      <27.322682, -2.566411, -32.557446>, <27.243050, -2.646044, -32.557446>, <27.130070, -2.815131, -32.557446>, <27.086973, -2.919177, -32.557446>, 
      <27.411254, -2.654984, -32.557446>, <27.331622, -2.734617, -32.557446>, <27.245795, -2.863066, -32.557446>, <27.202698, -2.967112, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.202698, -2.967112, -33.016445>, <27.159600, -3.071157, -33.016445>, <27.129462, -3.222673, -33.016445>, <27.129462, -3.335291, -33.016445>, 
      <27.086973, -2.919177, -33.016445>, <27.043875, -3.023222, -33.016445>, <27.004202, -3.222673, -33.016445>, <27.004202, -3.335291, -33.016445>, 
      <26.990669, -2.879286, -32.912205>, <26.937293, -3.008150, -32.912205>, <26.899965, -3.195809, -32.912205>, <26.899965, -3.335291, -32.912205>, 
      <26.990669, -2.879286, -32.786944>, <26.937293, -3.008150, -32.786944>, <26.899965, -3.195809, -32.786944>, <26.899965, -3.335291, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.414730, -3.054937, -32.786944>, <27.381914, -3.134164, -32.786944>, <27.358963, -3.249537, -32.786944>, <27.358963, -3.335291, -32.786944>, 
      <27.414730, -3.054937, -32.912205>, <27.381914, -3.134164, -32.912205>, <27.358963, -3.249537, -32.912205>, <27.358963, -3.335291, -32.912205>, 
      <27.318426, -3.015047, -33.016445>, <27.275328, -3.119092, -33.016445>, <27.254723, -3.222673, -33.016445>, <27.254723, -3.335291, -33.016445>, 
      <27.202698, -2.967112, -33.016445>, <27.159600, -3.071157, -33.016445>, <27.129462, -3.222673, -33.016445>, <27.129462, -3.335291, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.202698, -2.967112, -32.557446>, <27.159600, -3.071157, -32.557446>, <27.129462, -3.222673, -32.557446>, <27.129462, -3.335291, -32.557446>, 
      <27.318426, -3.015047, -32.557446>, <27.275328, -3.119092, -32.557446>, <27.254723, -3.222673, -32.557446>, <27.254723, -3.335291, -32.557446>, 
      <27.414730, -3.054937, -32.661686>, <27.381914, -3.134164, -32.661686>, <27.358963, -3.249537, -32.661686>, <27.358963, -3.335291, -32.661686>, 
      <27.414730, -3.054937, -32.786944>, <27.381914, -3.134164, -32.786944>, <27.358963, -3.249537, -32.786944>, <27.358963, -3.335291, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <26.990669, -2.879286, -32.786944>, <26.937293, -3.008150, -32.786944>, <26.899965, -3.195809, -32.786944>, <26.899965, -3.335291, -32.786944>, 
      <26.990669, -2.879286, -32.661686>, <26.937293, -3.008150, -32.661686>, <26.899965, -3.195809, -32.661686>, <26.899965, -3.335291, -32.661686>, 
      <27.086973, -2.919177, -32.557446>, <27.043875, -3.023222, -32.557446>, <27.004202, -3.222673, -32.557446>, <27.004202, -3.335291, -32.557446>, 
      <27.202698, -2.967112, -32.557446>, <27.159600, -3.071157, -32.557446>, <27.129462, -3.222673, -32.557446>, <27.129462, -3.335291, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.129462, -3.335291, -33.016445>, <27.129462, -3.447909, -33.016445>, <27.159600, -3.599425, -33.016445>, <27.202698, -3.703470, -33.016445>, 
      <27.004202, -3.335291, -33.016445>, <27.004202, -3.447909, -33.016445>, <27.043875, -3.647360, -33.016445>, <27.086973, -3.751405, -33.016445>, 
      <26.899965, -3.335291, -32.912205>, <26.899965, -3.474773, -32.912205>, <26.937293, -3.662432, -32.912205>, <26.990669, -3.791296, -32.912205>, 
      <26.899965, -3.335291, -32.786944>, <26.899965, -3.474773, -32.786944>, <26.937293, -3.662432, -32.786944>, <26.990669, -3.791296, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.358963, -3.335291, -32.786944>, <27.358963, -3.421045, -32.786944>, <27.381914, -3.536418, -32.786944>, <27.414730, -3.615644, -32.786944>, 
      <27.358963, -3.335291, -32.912205>, <27.358963, -3.421045, -32.912205>, <27.381914, -3.536418, -32.912205>, <27.414730, -3.615644, -32.912205>, 
      <27.254723, -3.335291, -33.016445>, <27.254723, -3.447909, -33.016445>, <27.275328, -3.551490, -33.016445>, <27.318426, -3.655535, -33.016445>, 
      <27.129462, -3.335291, -33.016445>, <27.129462, -3.447909, -33.016445>, <27.159600, -3.599425, -33.016445>, <27.202698, -3.703470, -33.016445>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <27.129462, -3.335291, -32.557446>, <27.129462, -3.447909, -32.557446>, <27.159600, -3.599425, -32.557446>, <27.202698, -3.703470, -32.557446>, 
      <27.254723, -3.335291, -32.557446>, <27.254723, -3.447909, -32.557446>, <27.275328, -3.551490, -32.557446>, <27.318426, -3.655535, -32.557446>, 
      <27.358963, -3.335291, -32.661686>, <27.358963, -3.421045, -32.661686>, <27.381914, -3.536418, -32.661686>, <27.414730, -3.615644, -32.661686>, 
      <27.358963, -3.335291, -32.786944>, <27.358963, -3.421045, -32.786944>, <27.381914, -3.536418, -32.786944>, <27.414730, -3.615644, -32.786944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <26.899965, -3.335291, -32.786944>, <26.899965, -3.474773, -32.786944>, <26.937293, -3.662432, -32.786944>, <26.990669, -3.791296, -32.786944>, 
      <26.899965, -3.335291, -32.661686>, <26.899965, -3.474773, -32.661686>, <26.937293, -3.662432, -32.661686>, <26.990669, -3.791296, -32.661686>, 
      <27.004202, -3.335291, -32.557446>, <27.004202, -3.447909, -32.557446>, <27.043875, -3.647360, -32.557446>, <27.086973, -3.751405, -32.557446>, 
      <27.129462, -3.335291, -32.557446>, <27.129462, -3.447909, -32.557446>, <27.159600, -3.599425, -32.557446>, <27.202698, -3.703470, -32.557446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <29.006416, -3.127551, -32.791546>, <29.006416, -3.252195, -32.791546>, <29.006416, -3.418387, -32.791546>, <29.006416, -3.543031, -32.791546>, 
      <29.006416, -3.127551, -32.678163>, <29.006416, -3.252195, -32.678163>, <29.006416, -3.418387, -32.678163>, <29.006416, -3.543031, -32.791546>, 
      <29.006416, -3.221908, -32.583808>, <29.006416, -3.335291, -32.583808>, <29.006416, -3.418387, -32.678163>, <29.006416, -3.543031, -32.791546>, 
      <29.006416, -3.335291, -32.583808>, <29.006416, -3.448674, -32.583808>, <29.006416, -3.543031, -32.678163>, <29.006416, -3.543031, -32.791546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <29.006416, -3.335291, -32.999286>, <29.006416, -3.448675, -32.999286>, <29.006416, -3.543031, -32.904931>, <29.006416, -3.543031, -32.791546>, 
      <29.006416, -3.221907, -32.999286>, <29.006416, -3.335291, -32.999286>, <29.006416, -3.418387, -32.904931>, <29.006416, -3.543031, -32.791546>, 
      <29.006416, -3.127551, -32.904931>, <29.006416, -3.252195, -32.904931>, <29.006416, -3.418387, -32.904931>, <29.006416, -3.543031, -32.791546>, 
      <29.006416, -3.127551, -32.791546>, <29.006416, -3.252195, -32.791546>, <29.006416, -3.418387, -32.791546>, <29.006416, -3.543031, -32.791546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <30.133533, -3.127551, -32.791546>, <30.133533, -3.252195, -32.791546>, <30.133533, -3.418387, -32.791546>, <30.133533, -3.543031, -32.791546>, 
      <30.133533, -3.127551, -32.678163>, <30.133533, -3.252195, -32.678163>, <30.133533, -3.418387, -32.678163>, <30.133533, -3.543031, -32.791546>, 
      <30.133533, -3.221908, -32.583808>, <30.133533, -3.335291, -32.583808>, <30.133533, -3.418387, -32.678163>, <30.133533, -3.543031, -32.791546>, 
      <30.133533, -3.335291, -32.583808>, <30.133533, -3.448674, -32.583808>, <30.133533, -3.543031, -32.678163>, <30.133533, -3.543031, -32.791546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <30.133533, -3.335291, -32.999286>, <30.133533, -3.448675, -32.999286>, <30.133533, -3.543031, -32.904931>, <30.133533, -3.543031, -32.791546>, 
      <30.133533, -3.221907, -32.999286>, <30.133533, -3.335291, -32.999286>, <30.133533, -3.418387, -32.904931>, <30.133533, -3.543031, -32.791546>, 
      <30.133533, -3.127551, -32.904931>, <30.133533, -3.252195, -32.904931>, <30.133533, -3.418387, -32.904931>, <30.133533, -3.543031, -32.791546>, 
      <30.133533, -3.127551, -32.791546>, <30.133533, -3.252195, -32.791546>, <30.133533, -3.418387, -32.791546>, <30.133533, -3.543031, -32.791546>
    }
  }
  photons {
    collect off
  }
}
#declare gancho_doble = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.311177, 0.444516, -29.958627>, <1.468242, 0.554494, -29.983472>, <1.506662, 0.777813, -30.004150>, <1.395764, 0.936191, -30.004150>, 
      <1.237550, 0.341957, -30.431734>, <1.394615, 0.451935, -30.456579>, <1.443758, 0.705382, -30.537997>, <1.332861, 0.863760, -30.537997>, 
      <0.871887, -0.136723, -30.847306>, <1.026124, -0.028726, -30.971395>, <1.065681, 0.227223, -31.044694>, <0.929906, 0.406577, -31.060451>, 
      <0.626760, -0.308363, -31.234890>, <0.780997, -0.200366, -31.358979>, <0.794153, 0.037097, -31.474022>, <0.658378, 0.216451, -31.489779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.995241, 0.204915, -28.867136>, <1.098456, 0.291326, -28.769526>, <1.095408, 0.469235, -28.688093>, <0.988530, 0.596611, -28.687837>, 
      <1.183240, 0.352627, -29.120534>, <1.286455, 0.439038, -29.022925>, <1.324163, 0.665204, -28.988944>, <1.217285, 0.792580, -28.988688>, 
      <1.363561, 0.517485, -29.622022>, <1.520626, 0.627463, -29.646867>, <1.556034, 0.834665, -29.585133>, <1.445137, 0.993043, -29.585133>, 
      <1.311177, 0.444516, -29.958627>, <1.468242, 0.554494, -29.983472>, <1.506662, 0.777813, -30.004150>, <1.395764, 0.936191, -30.004150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.191598, -0.435148, -28.449587>, <0.187045, -0.439247, -28.308736>, <0.107841, -0.352780, -28.191341>, <0.017218, -0.244776, -28.191126>, 
      <0.455547, -0.233298, -28.432982>, <0.450994, -0.237398, -28.292128>, <0.423443, -0.086756, -28.169990>, <0.332820, 0.021248, -28.169776>, 
      <0.815707, 0.063853, -28.625149>, <0.918922, 0.150265, -28.527539>, <0.873323, 0.278980, -28.396013>, <0.766445, 0.406356, -28.395757>, 
      <0.995241, 0.204915, -28.867136>, <1.098456, 0.291326, -28.769526>, <1.095408, 0.469235, -28.688093>, <0.988530, 0.596611, -28.687837>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.542423, -0.970984, -28.963882>, <-0.602471, -1.021538, -28.879005>, <-0.714283, -0.989908, -28.808221>, <-0.788594, -0.901344, -28.808045>, 
      <-0.366706, -0.858687, -28.730109>, <-0.426755, -0.909241, -28.645232>, <-0.534928, -0.845772, -28.527958>, <-0.609240, -0.757209, -28.527782>, 
      <-0.056935, -0.625208, -28.465226>, <-0.061488, -0.629308, -28.324371>, <-0.169048, -0.586173, -28.210070>, <-0.259672, -0.478169, -28.209856>, 
      <0.191598, -0.435148, -28.449587>, <0.187045, -0.439247, -28.308736>, <0.107841, -0.352780, -28.191341>, <0.017218, -0.244776, -28.191126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.826000, -1.085476, -29.803395>, <-0.880175, -1.130943, -29.798550>, <-0.963179, -1.123587, -29.794429>, <-1.008747, -1.069280, -29.794320>, 
      <-0.699695, -1.109166, -29.568163>, <-0.753871, -1.154633, -29.563318>, <-0.956559, -1.123180, -29.487178>, <-1.002127, -1.068873, -29.487069>, 
      <-0.692773, -1.067070, -29.163907>, <-0.752821, -1.117624, -29.079030>, <-0.866288, -1.112065, -29.045747>, <-0.940600, -1.023501, -29.045571>, 
      <-0.542423, -0.970984, -28.963882>, <-0.602471, -1.021538, -28.879005>, <-0.714283, -0.989908, -28.808221>, <-0.788594, -0.901344, -28.808045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.814726, -0.646457, -28.963235>, <-0.754678, -0.595903, -29.048112>, <-0.642867, -0.627534, -29.118893>, <-0.568555, -0.716097, -29.119069>, 
      <-0.940639, -0.771571, -29.163248>, <-0.880590, -0.721018, -29.248125>, <-0.767019, -0.726505, -29.281382>, <-0.692707, -0.815068, -29.281558>, 
      <-0.989796, -0.762636, -29.566006>, <-0.935621, -0.717169, -29.570851>, <-0.742161, -0.757191, -29.637648>, <-0.696594, -0.811498, -29.637754>, 
      <-0.992976, -0.886476, -29.802998>, <-0.938801, -0.841009, -29.807843>, <-0.855797, -0.848365, -29.811965>, <-0.810230, -0.902672, -29.812070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.140479, -0.039382, -28.448803>, <-0.135926, -0.035282, -28.589658>, <-0.056722, -0.121749, -28.707053>, <0.033901, -0.229753, -28.707267>, 
      <-0.369388, -0.252118, -28.464461>, <-0.364835, -0.248018, -28.605315>, <-0.257454, -0.291354, -28.719578>, <-0.166831, -0.399358, -28.719792>, 
      <-0.667403, -0.500068, -28.729213>, <-0.607355, -0.449514, -28.814090>, <-0.499093, -0.512921, -28.930720>, <-0.424781, -0.601484, -28.930896>, 
      <-0.814726, -0.646457, -28.963235>, <-0.754678, -0.595903, -29.048112>, <-0.642867, -0.627534, -29.118893>, <-0.568555, -0.716097, -29.119069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.603601, 0.671664, -28.866208>, <0.500386, 0.585253, -28.963818>, <0.503435, 0.407344, -29.045254>, <0.610313, 0.279968, -29.045507>, 
      <0.439511, 0.504598, -28.629197>, <0.336296, 0.418186, -28.726803>, <0.381737, 0.289264, -28.858627>, <0.488615, 0.161888, -28.858880>, 
      <0.103276, 0.187152, -28.432128>, <0.107829, 0.191252, -28.572982>, <0.135668, 0.040808, -28.695046>, <0.226291, -0.067196, -28.695261>, 
      <-0.140479, -0.039382, -28.448803>, <-0.135926, -0.035282, -28.589658>, <-0.056722, -0.121749, -28.707053>, <0.033901, -0.229753, -28.707267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.904810, 1.024869, -29.958627>, <0.747745, 0.914891, -29.933782>, <0.709325, 0.691571, -29.913107>, <0.820223, 0.533193, -29.913107>, 
      <0.972027, 1.071698, -29.612093>, <0.814962, 0.961720, -29.587248>, <0.777054, 0.751827, -29.649926>, <0.887951, 0.593449, -29.649926>, 
      <0.778970, 0.850214, -29.119514>, <0.675755, 0.763803, -29.217120>, <0.637778, 0.537693, -29.251274>, <0.744656, 0.410318, -29.251526>, 
      <0.603601, 0.671664, -28.866208>, <0.500386, 0.585253, -28.963818>, <0.503435, 0.407344, -29.045254>, <0.610313, 0.279968, -29.045507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.133037, 0.343829, -31.292186>, <-0.020021, 0.236657, -31.169043>, <-0.037305, 0.001655, -31.054109>, <0.097432, -0.176328, -31.038474>, 
      <0.386031, 0.520977, -30.892163>, <0.232973, 0.413805, -30.769021>, <0.190075, 0.160868, -30.694589>, <0.324812, -0.017115, -30.678950>, 
      <0.809412, 0.958406, -30.450448>, <0.652347, 0.848428, -30.425603>, <0.598809, 0.593247, -30.342554>, <0.709706, 0.434870, -30.342554>, 
      <0.904810, 1.024869, -29.958627>, <0.747745, 0.914891, -29.933782>, <0.709325, 0.691571, -29.913107>, <0.820223, 0.533193, -29.913107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.255562, -0.220080, -32.615146>, <-0.366459, -0.061702, -32.615146>, <-0.589452, -0.021424, -32.594470>, <-0.746517, -0.131402, -32.569626>, 
      <-0.125369, -0.149857, -32.185699>, <-0.236267, 0.008521, -32.185699>, <-0.500461, 0.041219, -32.120157>, <-0.657526, -0.068759, -32.095309>, 
      <0.430998, 0.057237, -31.849299>, <0.297257, 0.233905, -31.864819>, <0.041350, 0.279629, -31.799610>, <-0.110577, 0.173248, -31.677376>, 
      <0.658378, 0.216451, -31.489779>, <0.524637, 0.393119, -31.505299>, <0.284965, 0.450209, -31.414416>, <0.133037, 0.343829, -31.292186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.820223, 0.533193, -29.913107>, <0.931120, 0.374815, -29.913107>, <1.154112, 0.334538, -29.933782>, <1.311177, 0.444516, -29.958627>, 
      <0.709706, 0.434870, -30.342554>, <0.820604, 0.276492, -30.342554>, <1.080485, 0.231979, -30.406890>, <1.237550, 0.341957, -30.431734>, 
      <0.324812, -0.017115, -30.678950>, <0.459549, -0.195098, -30.663315>, <0.718830, -0.243895, -30.724163>, <0.871887, -0.136723, -30.847306>, 
      <0.097432, -0.176328, -31.038474>, <0.232169, -0.354311, -31.022835>, <0.473702, -0.415535, -31.111747>, <0.626760, -0.308363, -31.234890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.610313, 0.279968, -29.045507>, <0.717191, 0.152593, -29.045760>, <0.892026, 0.118503, -28.964746>, <0.995241, 0.204915, -28.867136>, 
      <0.744656, 0.410318, -29.251526>, <0.851534, 0.282942, -29.251779>, <1.080024, 0.266215, -29.218141>, <1.183240, 0.352627, -29.120534>, 
      <0.887951, 0.593449, -29.649926>, <0.998849, 0.435071, -29.649926>, <1.206496, 0.407507, -29.597178>, <1.363561, 0.517485, -29.622022>, 
      <0.820223, 0.533193, -29.913107>, <0.931120, 0.374815, -29.913107>, <1.154112, 0.334538, -29.933782>, <1.311177, 0.444516, -29.958627>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.033901, -0.229753, -28.707267>, <0.124525, -0.337757, -28.707478>, <0.196151, -0.431047, -28.590442>, <0.191598, -0.435148, -28.449587>, 
      <0.226291, -0.067196, -28.695261>, <0.316914, -0.175200, -28.695475>, <0.460099, -0.229198, -28.573837>, <0.455547, -0.233298, -28.432982>, 
      <0.488615, 0.161888, -28.858880>, <0.595494, 0.034513, -28.859136>, <0.712492, -0.022558, -28.722758>, <0.815707, 0.063853, -28.625149>, 
      <0.610313, 0.279968, -29.045507>, <0.717191, 0.152593, -29.045760>, <0.892026, 0.118503, -28.964746>, <0.995241, 0.204915, -28.867136>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.568555, -0.716097, -29.119069>, <-0.494244, -0.804660, -29.119245>, <-0.482374, -0.920431, -29.048758>, <-0.542423, -0.970984, -28.963882>, 
      <-0.424781, -0.601484, -28.930896>, <-0.350470, -0.690047, -28.931069>, <-0.306658, -0.808133, -28.814986>, <-0.366706, -0.858687, -28.730109>, 
      <-0.166831, -0.399358, -28.719792>, <-0.076207, -0.507362, -28.720006>, <-0.052382, -0.621108, -28.606080>, <-0.056935, -0.625208, -28.465226>, 
      <0.033901, -0.229753, -28.707267>, <0.124525, -0.337757, -28.707478>, <0.196151, -0.431047, -28.590442>, <0.191598, -0.435148, -28.449587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.810230, -0.902672, -29.812070>, <-0.764662, -0.956979, -29.812179>, <-0.771824, -1.040009, -29.808240>, <-0.826000, -1.085476, -29.803395>, 
      <-0.696594, -0.811498, -29.637754>, <-0.651026, -0.865805, -29.637862>, <-0.645520, -1.063699, -29.573008>, <-0.699695, -1.109166, -29.568163>, 
      <-0.692707, -0.815068, -29.281558>, <-0.618396, -0.903631, -29.281734>, <-0.632724, -1.016517, -29.248784>, <-0.692773, -1.067070, -29.163907>, 
      <-0.568555, -0.716097, -29.119069>, <-0.494244, -0.804660, -29.119245>, <-0.482374, -0.920431, -29.048758>, <-0.542423, -0.970984, -28.963882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.788594, -0.901344, -28.808045>, <-0.862906, -0.812781, -28.807872>, <-0.874775, -0.697011, -28.878358>, <-0.814726, -0.646457, -28.963235>, 
      <-0.940600, -1.023501, -29.045571>, <-1.014911, -0.934938, -29.045398>, <-1.000687, -0.822125, -29.078371>, <-0.940639, -0.771571, -29.163248>, 
      <-1.002127, -1.068873, -29.487069>, <-1.047694, -1.014566, -29.486963>, <-1.043972, -0.808103, -29.561162>, <-0.989796, -0.762636, -29.566006>, 
      <-1.008747, -1.069280, -29.794320>, <-1.054315, -1.014973, -29.794214>, <-1.047152, -0.931943, -29.798154>, <-0.992976, -0.886476, -29.802998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.017218, -0.244776, -28.191126>, <-0.073406, -0.136772, -28.190912>, <-0.145032, -0.043482, -28.307949>, <-0.140479, -0.039382, -28.448803>, 
      <-0.259672, -0.478169, -28.209856>, <-0.350295, -0.370165, -28.209642>, <-0.373941, -0.256218, -28.323610>, <-0.369388, -0.252118, -28.464461>, 
      <-0.609240, -0.757209, -28.527782>, <-0.683552, -0.668645, -28.527606>, <-0.727452, -0.550621, -28.644336>, <-0.667403, -0.500068, -28.729213>, 
      <-0.788594, -0.901344, -28.808045>, <-0.862906, -0.812781, -28.807872>, <-0.874775, -0.697011, -28.878358>, <-0.814726, -0.646457, -28.963235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988530, 0.596611, -28.687837>, <0.881652, 0.723987, -28.687584>, <0.706817, 0.758076, -28.768602>, <0.603601, 0.671664, -28.866208>, 
      <0.766445, 0.406356, -28.395757>, <0.659566, 0.533732, -28.395504>, <0.542726, 0.591009, -28.531587>, <0.439511, 0.504598, -28.629197>, 
      <0.332820, 0.021248, -28.169776>, <0.242196, 0.129252, -28.169565>, <0.098723, 0.183052, -28.291274>, <0.103276, 0.187152, -28.432128>, 
      <0.017218, -0.244776, -28.191126>, <-0.073406, -0.136772, -28.190912>, <-0.145032, -0.043482, -28.307949>, <-0.140479, -0.039382, -28.448803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.395764, 0.936191, -30.004150>, <1.284867, 1.094569, -30.004150>, <1.061875, 1.134847, -29.983472>, <0.904810, 1.024869, -29.958627>, 
      <1.445137, 0.993043, -29.585133>, <1.334239, 1.151421, -29.585133>, <1.129091, 1.181676, -29.636938>, <0.972027, 1.071698, -29.612093>, 
      <1.217285, 0.792580, -28.988688>, <1.110407, 0.919956, -28.988435>, <0.882185, 0.936626, -29.021904>, <0.778970, 0.850214, -29.119514>, 
      <0.988530, 0.596611, -28.687837>, <0.881652, 0.723987, -28.687584>, <0.706817, 0.758076, -28.768602>, <0.603601, 0.671664, -28.866208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.658378, 0.216451, -31.489779>, <0.524637, 0.393119, -31.505299>, <0.284965, 0.450209, -31.414416>, <0.133037, 0.343829, -31.292186>, 
      <0.929906, 0.406577, -31.060451>, <0.796165, 0.583245, -31.075971>, <0.537958, 0.627357, -31.014397>, <0.386031, 0.520977, -30.892163>, 
      <1.332861, 0.863760, -30.537997>, <1.221964, 1.022138, -30.537997>, <0.966477, 1.068384, -30.475293>, <0.809412, 0.958406, -30.450448>, 
      <1.395764, 0.936191, -30.004150>, <1.284867, 1.094569, -30.004150>, <1.061875, 1.134847, -29.983472>, <0.904810, 1.024869, -29.958627>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.698641, 0.998215, -32.725254>, <1.581181, 1.037582, -32.962250>, <1.572765, 0.988334, -33.365008>, <1.412131, 0.912806, -33.565021>, 
      <1.759894, 1.033572, -32.730099>, <1.642435, 1.072940, -32.967094>, <1.640808, 1.027470, -33.449885>, <1.480174, 0.951942, -33.649898>, 
      <1.840367, 1.011905, -32.734038>, <1.837720, 1.005823, -33.041290>, <1.751681, 1.002250, -33.482858>, <1.584902, 0.901192, -33.720384>, 
      <1.875813, 0.950512, -32.733933>, <1.873167, 0.944429, -33.041184>, <1.809487, 0.902130, -33.482682>, <1.642708, 0.801072, -33.720208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875813, 0.950512, -32.733933>, <1.873167, 0.944429, -33.041184>, <1.809487, 0.902130, -33.482682>, <1.642708, 0.801072, -33.720208>, 
      <1.911260, 0.889118, -32.733827>, <1.908613, 0.883035, -33.041075>, <1.867294, 0.802010, -33.482506>, <1.700515, 0.700952, -33.720032>, 
      <1.889784, 0.808604, -32.729706>, <1.868847, 0.681814, -32.964934>, <1.833712, 0.693485, -33.449226>, <1.691998, 0.585066, -33.649251>, 
      <1.828530, 0.773246, -32.724861>, <1.807593, 0.646457, -32.960090>, <1.765669, 0.654349, -33.364349>, <1.623955, 0.545929, -33.564374>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.412131, 0.912806, -33.565021>, <1.224183, 0.824436, -33.799046>, <0.889259, 0.629196, -34.063792>, <0.611062, 0.486853, -34.079453>, 
      <1.480174, 0.951942, -33.649898>, <1.292225, 0.863572, -33.883923>, <0.894669, 0.632073, -34.204646>, <0.616472, 0.489729, -34.220307>, 
      <1.584902, 0.901192, -33.720384>, <1.388116, 0.781952, -34.000643>, <0.993657, 0.570881, -34.318614>, <0.679638, 0.390515, -34.337344>, 
      <1.642708, 0.801072, -33.720208>, <1.445923, 0.681832, -34.000470>, <1.064153, 0.448783, -34.318400>, <0.750133, 0.268417, -34.337133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.393376, 0.657662, -33.409187>, <1.528841, 0.740477, -33.246698>, <1.526816, 0.745350, -32.890499>, <1.651357, 0.820949, -32.716182>, 
      <1.335570, 0.757783, -33.409363>, <1.471034, 0.840598, -33.246870>, <1.491369, 0.806743, -32.890605>, <1.615911, 0.882343, -32.716288>, 
      <1.344088, 0.873669, -33.480144>, <1.504722, 0.949197, -33.280131>, <1.519927, 1.002225, -32.957405>, <1.637387, 0.962857, -32.720410>, 
      <1.412131, 0.912806, -33.565021>, <1.572765, 0.988334, -33.365008>, <1.581181, 1.037582, -32.962250>, <1.698641, 0.998215, -32.725254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.623955, 0.545929, -33.564374>, <1.765669, 0.654349, -33.364349>, <1.807593, 0.646457, -32.960090>, <1.828530, 0.773246, -32.724861>, 
      <1.555912, 0.506793, -33.479498>, <1.697626, 0.615212, -33.279472>, <1.746339, 0.611099, -32.955245>, <1.767276, 0.737888, -32.720016>, 
      <1.451182, 0.557542, -33.409011>, <1.586647, 0.640357, -33.246522>, <1.562262, 0.683956, -32.890394>, <1.686804, 0.759555, -32.716077>, 
      <1.393376, 0.657662, -33.409187>, <1.528841, 0.740477, -33.246698>, <1.526816, 0.745350, -32.890499>, <1.651357, 0.820949, -32.716182>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.642708, 0.801072, -33.720208>, <1.445923, 0.681832, -34.000470>, <1.064153, 0.448783, -34.318400>, <0.750133, 0.268417, -34.337133>, 
      <1.700515, 0.700952, -33.720032>, <1.503729, 0.581712, -34.000294>, <1.134648, 0.326684, -34.318189>, <0.820629, 0.146318, -34.336918>, 
      <1.691998, 0.585066, -33.649251>, <1.526374, 0.458354, -33.883021>, <1.138394, 0.210858, -34.203885>, <0.874791, 0.042318, -34.219520>, 
      <1.623955, 0.545929, -33.564374>, <1.458331, 0.419218, -33.798144>, <1.132984, 0.207982, -34.063030>, <0.869382, 0.039442, -34.078666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.611062, 0.486853, -34.079453>, <0.314820, 0.335276, -34.096128>, <-0.098480, 0.127892, -33.899059>, <-0.311594, 0.030837, -33.662045>, 
      <0.616472, 0.489729, -34.220307>, <0.320230, 0.338153, -34.236979>, <-0.214983, 0.060456, -33.996666>, <-0.428097, -0.036599, -33.759651>, 
      <0.679638, 0.390515, -34.337344>, <0.321715, 0.184932, -34.358691>, <-0.201122, -0.068928, -34.132752>, <-0.455860, -0.212548, -33.840672>, 
      <0.750133, 0.268417, -34.337133>, <0.392210, 0.062834, -34.358480>, <-0.117982, -0.212926, -34.132499>, <-0.372720, -0.356546, -33.840419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.730310, 0.257878, -33.820989>, <0.958341, 0.388495, -33.808461>, <1.236502, 0.561759, -33.597360>, <1.393376, 0.657662, -33.409187>, 
      <0.659815, 0.379976, -33.821200>, <0.887845, 0.510594, -33.808675>, <1.178695, 0.661880, -33.597533>, <1.335570, 0.757783, -33.409363>, 
      <0.605652, 0.483977, -33.938598>, <0.883850, 0.626320, -33.922941>, <1.156140, 0.785299, -33.714170>, <1.344088, 0.873669, -33.480144>, 
      <0.611062, 0.486853, -34.079453>, <0.889259, 0.629196, -34.063792>, <1.224183, 0.824436, -33.799046>, <1.412131, 0.912806, -33.565021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.869382, 0.039442, -34.078666>, <1.132984, 0.207982, -34.063030>, <1.458331, 0.419218, -33.798144>, <1.623955, 0.545929, -33.564374>, 
      <0.863972, 0.036566, -33.937814>, <1.127575, 0.205106, -33.922176>, <1.390288, 0.380081, -33.713267>, <1.555912, 0.506793, -33.479498>, 
      <0.800806, 0.135779, -33.820774>, <1.028836, 0.266397, -33.808246>, <1.294308, 0.461639, -33.597184>, <1.451182, 0.557542, -33.409011>, 
      <0.730310, 0.257878, -33.820989>, <0.958341, 0.388495, -33.808461>, <1.236502, 0.561759, -33.597360>, <1.393376, 0.657662, -33.409187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.750133, 0.268417, -34.337133>, <0.392210, 0.062834, -34.358480>, <-0.117982, -0.212926, -34.132499>, <-0.372720, -0.356546, -33.840419>, 
      <0.820629, 0.146318, -34.336918>, <0.462706, -0.059265, -34.358266>, <-0.034842, -0.356924, -34.132246>, <-0.289580, -0.500544, -33.840166>, 
      <0.874791, 0.042318, -34.219520>, <0.594839, -0.136676, -34.236131>, <0.070515, -0.443797, -34.000714>, <-0.123443, -0.564257, -33.758730>, 
      <0.869382, 0.039442, -34.078666>, <0.589430, -0.139552, -34.095277>, <0.187017, -0.376361, -33.903107>, <-0.006941, -0.496821, -33.661120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.311594, 0.030837, -33.662045>, <-0.539356, -0.072887, -33.408742>, <-0.811633, -0.177240, -32.916694>, <-0.746517, -0.131402, -32.569626>, 
      <-0.428097, -0.036599, -33.759651>, <-0.655858, -0.140324, -33.506349>, <-0.968698, -0.287218, -32.891850>, <-0.903581, -0.241380, -32.544781>, 
      <-0.455860, -0.212548, -33.840672>, <-0.718250, -0.360482, -33.539818>, <-1.012310, -0.491651, -32.943123>, <-0.942001, -0.464700, -32.524106>, 
      <-0.372720, -0.356546, -33.840419>, <-0.635110, -0.504481, -33.539565>, <-0.901412, -0.650029, -32.943123>, <-0.831104, -0.623078, -32.524106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.054185, -0.109437, -33.482749>, <0.206766, -0.035465, -33.669376>, <0.511756, 0.132688, -33.832992>, <0.730310, 0.257878, -33.820989>, 
      <-0.028955, 0.034560, -33.483002>, <0.123627, 0.108532, -33.669629>, <0.441261, 0.254787, -33.833206>, <0.659815, 0.379976, -33.821200>, 
      <-0.195093, 0.098273, -33.564438>, <0.018021, 0.195327, -33.801453>, <0.309410, 0.332400, -33.955274>, <0.605652, 0.483977, -33.938598>, 
      <-0.311594, 0.030837, -33.662045>, <-0.098480, 0.127892, -33.899059>, <0.314820, 0.335276, -34.096128>, <0.611062, 0.486853, -34.079453>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.006941, -0.496821, -33.661120>, <0.187017, -0.376361, -33.903107>, <0.589430, -0.139552, -34.095277>, <0.869382, 0.039442, -34.078666>, 
      <0.109561, -0.429385, -33.563514>, <0.303519, -0.308925, -33.805501>, <0.584020, -0.142428, -33.954422>, <0.863972, 0.036566, -33.937814>, 
      <0.137324, -0.253435, -33.482499>, <0.289906, -0.179463, -33.669123>, <0.582252, 0.010590, -33.832778>, <0.800806, 0.135779, -33.820774>, 
      <0.054185, -0.109437, -33.482749>, <0.206766, -0.035465, -33.669376>, <0.511756, 0.132688, -33.832992>, <0.730310, 0.257878, -33.820989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.372720, -0.356546, -33.840419>, <-0.635110, -0.504481, -33.539565>, <-0.901412, -0.650029, -32.943123>, <-0.831104, -0.623078, -32.524106>, 
      <-0.289580, -0.500544, -33.840166>, <-0.551970, -0.648478, -33.539315>, <-0.790515, -0.808407, -32.943123>, <-0.720206, -0.781456, -32.524106>, 
      <-0.123443, -0.564257, -33.758730>, <-0.326547, -0.690398, -33.505328>, <-0.585007, -0.847842, -32.880912>, <-0.497214, -0.821733, -32.544781>, 
      <-0.006941, -0.496821, -33.661120>, <-0.210045, -0.622962, -33.407722>, <-0.427942, -0.737864, -32.905757>, <-0.340149, -0.711755, -32.569626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.746517, -0.131402, -32.569626>, <-0.657526, -0.068759, -32.095309>, <-0.110577, 0.173248, -31.677376>, <0.133037, 0.343829, -31.292186>, 
      <-0.903581, -0.241380, -32.544781>, <-0.814591, -0.178737, -32.070464>, <-0.263635, 0.066076, -31.554234>, <-0.020021, 0.236657, -31.169043>, 
      <-0.942001, -0.464700, -32.524106>, <-0.852424, -0.430363, -31.990256>, <-0.308833, -0.188471, -31.483437>, <-0.037305, 0.001655, -31.054109>, 
      <-0.831104, -0.623078, -32.524106>, <-0.741526, -0.588741, -31.990256>, <-0.174096, -0.366454, -31.467802>, <0.097432, -0.176328, -31.038474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.255562, -0.220080, -32.615146>, <-0.335349, -0.263115, -32.878330>, <-0.114252, -0.191097, -33.276730>, <0.054185, -0.109437, -33.482749>, 
      <-0.366459, -0.061702, -32.615146>, <-0.446246, -0.104737, -32.878330>, <-0.197391, -0.047100, -33.276982>, <-0.028955, 0.034560, -33.483002>, 
      <-0.589452, -0.021424, -32.594470>, <-0.654568, -0.067262, -32.941539>, <-0.422854, -0.005452, -33.311133>, <-0.195093, 0.098273, -33.564438>, 
      <-0.746517, -0.131402, -32.569626>, <-0.811633, -0.177240, -32.916694>, <-0.539356, -0.072887, -33.408742>, <-0.311594, 0.030837, -33.662045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.340149, -0.711755, -32.569626>, <-0.211871, -0.673606, -32.078493>, <0.371931, -0.486797, -31.637811>, <0.626760, -0.308363, -31.234890>, 
      <-0.183084, -0.601777, -32.594470>, <-0.054806, -0.563628, -32.103338>, <0.526167, -0.378799, -31.761901>, <0.780997, -0.200366, -31.358979>, 
      <-0.144665, -0.378458, -32.615146>, <-0.014472, -0.308235, -32.185699>, <0.566773, -0.122116, -31.833542>, <0.794153, 0.037097, -31.474022>, 
      <-0.255562, -0.220080, -32.615146>, <-0.125369, -0.149857, -32.185699>, <0.430998, 0.057237, -31.849299>, <0.658378, 0.216451, -31.489779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.340149, -0.711755, -32.569626>, <-0.427942, -0.737864, -32.905757>, <-0.210045, -0.622962, -33.407722>, <-0.006941, -0.496821, -33.661120>, 
      <-0.183084, -0.601777, -32.594470>, <-0.270877, -0.627886, -32.930602>, <-0.093543, -0.555526, -33.310115>, <0.109561, -0.429385, -33.563514>, 
      <-0.144665, -0.378458, -32.615146>, <-0.224452, -0.421493, -32.878330>, <-0.031112, -0.335094, -33.276477>, <0.137324, -0.253435, -33.482499>, 
      <-0.255562, -0.220080, -32.615146>, <-0.335349, -0.263115, -32.878330>, <-0.114252, -0.191097, -33.276730>, <0.054185, -0.109437, -33.482749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.831104, -0.623078, -32.524106>, <-0.741526, -0.588741, -31.990256>, <-0.174096, -0.366454, -31.467802>, <0.097432, -0.176328, -31.038474>, 
      <-0.720206, -0.781456, -32.524106>, <-0.630629, -0.747119, -31.990256>, <-0.039360, -0.544437, -31.452163>, <0.232169, -0.354311, -31.022835>, 
      <-0.497214, -0.821733, -32.544781>, <-0.368936, -0.783584, -32.053645>, <0.218873, -0.593969, -31.514669>, <0.473702, -0.415535, -31.111747>, 
      <-0.340149, -0.711755, -32.569626>, <-0.211871, -0.673606, -32.078493>, <0.371931, -0.486797, -31.637811>, <0.626760, -0.308363, -31.234890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.992976, -0.886476, -29.802998>, <-0.938801, -0.841009, -29.807843>, <-0.855797, -0.848365, -29.811965>, <-0.810230, -0.902672, -29.812070>, 
      <-0.993903, -0.922566, -29.872064>, <-0.939728, -0.877099, -29.876909>, <-0.810230, -0.902672, -29.812070>, <-0.810230, -0.902672, -29.812070>, 
      <-0.862722, -1.078588, -29.871786>, <-0.808546, -1.033121, -29.876630>, <-0.810230, -0.902672, -29.812070>, <-0.810230, -0.902672, -29.812070>, 
      <-0.826000, -1.085476, -29.803395>, <-0.771824, -1.040009, -29.808240>, <-0.764662, -0.956979, -29.812179>, <-0.810230, -0.902672, -29.812070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.992976, -0.886476, -29.802998>, <-1.047152, -0.931943, -29.798154>, <-1.054315, -1.014973, -29.794214>, <-1.008747, -1.069280, -29.794320>, 
      <-0.993903, -0.922566, -29.872064>, <-1.048079, -0.968033, -29.867219>, <-1.008747, -1.069280, -29.794320>, <-1.008747, -1.069280, -29.794320>, 
      <-0.862722, -1.078588, -29.871786>, <-0.916897, -1.124055, -29.866941>, <-1.008747, -1.069280, -29.794320>, <-1.008747, -1.069280, -29.794320>, 
      <-0.826000, -1.085476, -29.803395>, <-0.880175, -1.130943, -29.798550>, <-0.963179, -1.123587, -29.794429>, <-1.008747, -1.069280, -29.794320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.008747, -1.069280, -29.794320>, <-1.054315, -1.014973, -29.794214>, <-1.047152, -0.931943, -29.798154>, <-0.992976, -0.886476, -29.802998>, 
      <-1.010426, -1.069383, -29.872234>, <-1.055994, -1.015076, -29.872128>, <-0.992977, -0.886476, -29.802998>, <-0.992976, -0.886476, -29.802998>, 
      <-0.849211, -0.933948, -29.871869>, <-0.894779, -0.879641, -29.871760>, <-0.992977, -0.886476, -29.802998>, <-0.992976, -0.886476, -29.802998>, 
      <-0.810230, -0.902672, -29.812070>, <-0.855797, -0.848365, -29.811965>, <-0.938801, -0.841009, -29.807843>, <-0.992976, -0.886476, -29.802998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.008747, -1.069280, -29.794320>, <-0.963179, -1.123587, -29.794429>, <-0.880175, -1.130943, -29.798550>, <-0.826000, -1.085476, -29.803395>, 
      <-1.010426, -1.069383, -29.872234>, <-0.964858, -1.123690, -29.872342>, <-0.826000, -1.085476, -29.803395>, <-0.826000, -1.085476, -29.803395>, 
      <-0.849211, -0.933948, -29.871869>, <-0.803643, -0.988255, -29.871974>, <-0.826000, -1.085476, -29.803395>, <-0.826000, -1.085476, -29.803395>, 
      <-0.810230, -0.902672, -29.812070>, <-0.764662, -0.956979, -29.812179>, <-0.771824, -1.040009, -29.808240>, <-0.826000, -1.085476, -29.803395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.651357, 0.820949, -32.716182>, <1.694079, 0.846882, -32.656387>, <1.876484, 0.952054, -32.656016>, <1.875813, 0.950512, -32.733933>, 
      <1.615911, 0.882343, -32.716288>, <1.658633, 0.908276, -32.656493>, <1.841038, 1.013448, -32.656125>, <1.875813, 0.950512, -32.733933>, 
      <1.637387, 0.962857, -32.720410>, <1.698640, 0.998215, -32.725254>, <1.841038, 1.013448, -32.656125>, <1.875813, 0.950512, -32.733933>, 
      <1.698641, 0.998215, -32.725254>, <1.759894, 1.033572, -32.730099>, <1.840367, 1.011905, -32.734038>, <1.875813, 0.950512, -32.733933>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.828530, 0.773246, -32.724861>, <1.834617, 0.810109, -32.656467>, <1.732871, 0.986742, -32.656189>, <1.698641, 0.998215, -32.725254>, 
      <1.767276, 0.737888, -32.720016>, <1.773363, 0.774752, -32.651622>, <1.671617, 0.951384, -32.651344>, <1.698641, 0.998215, -32.725254>, 
      <1.686804, 0.759555, -32.716077>, <1.651357, 0.820949, -32.716182>, <1.671617, 0.951384, -32.651344>, <1.698641, 0.998215, -32.725254>, 
      <1.651357, 0.820949, -32.716182>, <1.615911, 0.882343, -32.716288>, <1.637387, 0.962857, -32.720410>, <1.698641, 0.998215, -32.725254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875813, 0.950512, -32.733933>, <1.876484, 0.952054, -32.656016>, <1.694079, 0.846882, -32.656387>, <1.651357, 0.820949, -32.716182>, 
      <1.911260, 0.889118, -32.733827>, <1.911931, 0.890660, -32.655910>, <1.729526, 0.785489, -32.656282>, <1.651357, 0.820949, -32.716182>, 
      <1.889784, 0.808604, -32.729706>, <1.828530, 0.773246, -32.724861>, <1.729526, 0.785489, -32.656282>, <1.651357, 0.820949, -32.716182>, 
      <1.828530, 0.773246, -32.724861>, <1.767276, 0.737888, -32.720016>, <1.686804, 0.759555, -32.716077>, <1.651357, 0.820949, -32.716182>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875813, 0.950512, -32.733933>, <1.840367, 1.011905, -32.734038>, <1.759894, 1.033572, -32.730099>, <1.698641, 0.998215, -32.725254>, 
      <1.911260, 0.889118, -32.733827>, <1.875813, 0.950512, -32.733933>, <1.794125, 1.022100, -32.661034>, <1.698641, 0.998215, -32.725254>, 
      <1.889784, 0.808604, -32.729706>, <1.895871, 0.845467, -32.661312>, <1.794125, 1.022100, -32.661034>, <1.698641, 0.998215, -32.725254>, 
      <1.828530, 0.773246, -32.724861>, <1.834617, 0.810109, -32.656467>, <1.732871, 0.986742, -32.656189>, <1.698641, 0.998215, -32.725254>
    }
  }
  photons {
    collect off
  }
}
#declare gancho_simple = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.687596, -1.093166, 9.658742>, <0.754995, -1.093168, 9.651085>, <0.882999, -1.093172, 9.694416>, <0.912259, -1.093173, 9.633218>, 
      <0.687611, -0.704138, 9.659334>, <0.755010, -0.704140, 9.651676>, <0.883019, -0.581292, 9.695195>, <0.912279, -0.581293, 9.633998>, 
      <0.249963, -0.105301, 9.663557>, <0.249841, -0.037775, 9.656514>, <0.487394, -0.185557, 9.698642>, <0.486333, -0.155307, 9.637870>, 
      <-0.025125, -0.380377, 9.665222>, <-0.025247, -0.312852, 9.658178>, <-0.024472, -0.185543, 9.702517>, <-0.025532, -0.155293, 9.641746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.025182, -1.805915, 9.663054>, <-0.025309, -1.873440, 9.655805>, <-0.024545, -2.000777, 9.699700>, <-0.025607, -2.031000, 9.638892>, 
      <0.249884, -2.081007, 9.660553>, <0.249757, -2.148532, 9.653304>, <0.487320, -2.000791, 9.695826>, <0.486259, -2.031014, 9.635018>, 
      <0.687580, -1.482195, 9.658150>, <0.754979, -1.482196, 9.650494>, <0.882978, -1.605051, 9.693637>, <0.912238, -1.605052, 9.632440>, 
      <0.687596, -1.093166, 9.658742>, <0.754995, -1.093168, 9.651085>, <0.882999, -1.093172, 9.694416>, <0.912259, -1.093173, 9.633218>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.912259, -1.093173, 9.633218>, <0.945549, -1.093174, 9.563594>, <0.866456, -1.093171, 9.451737>, <0.813340, -1.093170, 9.395749>, 
      <0.912279, -0.581293, 9.633998>, <0.945569, -0.581294, 9.564373>, <0.866474, -0.633014, 9.452437>, <0.813359, -0.633012, 9.396449>, 
      <0.486333, -0.155307, 9.637870>, <0.485132, -0.121019, 9.568989>, <0.431439, -0.197869, 9.456466>, <0.430452, -0.250069, 9.399932>, 
      <-0.025532, -0.155293, 9.641746>, <-0.026734, -0.121004, 9.572863>, <-0.028706, -0.197856, 9.459950>, <-0.029693, -0.250056, 9.403414>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.025607, -2.031000, 9.638892>, <-0.026809, -2.065210, 9.570061>, <-0.028777, -1.988461, 9.457251>, <-0.029761, -1.936236, 9.400850>, 
      <0.486259, -2.031014, 9.635018>, <0.485057, -2.065225, 9.566186>, <0.431368, -1.988474, 9.453769>, <0.430385, -1.936249, 9.397366>, 
      <0.912238, -1.605052, 9.632440>, <0.945528, -1.605053, 9.562814>, <0.866438, -1.553329, 9.451037>, <0.813322, -1.553328, 9.395049>, 
      <0.912259, -1.093173, 9.633218>, <0.945549, -1.093174, 9.563594>, <0.866456, -1.093171, 9.451737>, <0.813340, -1.093170, 9.395749>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.029693, -0.250056, 9.403414>, <-0.028706, -0.197856, 9.459950>, <-0.026734, -0.121004, 9.572863>, <-0.025532, -0.155293, 9.641746>, 
      <-0.489838, -0.250043, 9.406898>, <-0.488851, -0.197843, 9.463432>, <-0.538599, -0.120990, 9.576738>, <-0.537397, -0.155278, 9.645620>, 
      <-0.872776, -0.632965, 9.409213>, <-0.924080, -0.632963, 9.466164>, <-0.936196, -0.581241, 9.576525>, <-0.963377, -0.581240, 9.648195>, 
      <-0.872794, -1.093122, 9.408513>, <-0.924098, -1.093121, 9.465464>, <-0.936216, -1.093120, 9.575746>, <-0.963397, -1.093120, 9.647416>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.813340, -1.093170, 9.395749>, <0.752257, -1.093168, 9.331362>, <0.629689, -1.093165, 9.299874>, <0.553242, -1.093163, 9.254788>, 
      <0.813359, -0.633012, 9.396449>, <0.752275, -0.633011, 9.332062>, <0.629702, -0.773611, 9.300360>, <0.553255, -0.773609, 9.255274>, 
      <0.430452, -0.250069, 9.399932>, <0.429317, -0.310059, 9.334960>, <0.288147, -0.432012, 9.303471>, <0.287347, -0.507676, 9.257691>, 
      <-0.029693, -0.250056, 9.403414>, <-0.030828, -0.310046, 9.338443>, <-0.031398, -0.432003, 9.305890>, <-0.032198, -0.507667, 9.260110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.029761, -1.936236, 9.400850>, <-0.030891, -1.876232, 9.336046>, <-0.031451, -1.754293, 9.303882>, <-0.032245, -1.678625, 9.258330>, 
      <0.430385, -1.936249, 9.397366>, <0.429254, -1.876245, 9.332562>, <0.288095, -1.754302, 9.301464>, <0.287301, -1.678634, 9.255912>, 
      <0.813322, -1.553328, 9.395049>, <0.752238, -1.553326, 9.330662>, <0.629677, -1.412719, 9.299389>, <0.553229, -1.412717, 9.254303>, 
      <0.813340, -1.093170, 9.395749>, <0.752257, -1.093168, 9.331362>, <0.629689, -1.093165, 9.299874>, <0.553242, -1.093163, 9.254788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.872794, -1.093122, 9.408513>, <-0.924098, -1.093121, 9.465464>, <-0.936216, -1.093120, 9.575746>, <-0.963397, -1.093120, 9.647416>, 
      <-0.872812, -1.553280, 9.407813>, <-0.924117, -1.553278, 9.464764>, <-0.936237, -1.605000, 9.574966>, <-0.963418, -1.604999, 9.646637>, 
      <-0.489905, -1.936223, 9.404332>, <-0.488922, -1.988448, 9.460734>, <-0.538674, -2.065196, 9.573935>, <-0.537472, -2.030985, 9.642767>, 
      <-0.029761, -1.936236, 9.400850>, <-0.028777, -1.988461, 9.457251>, <-0.026809, -2.065210, 9.570061>, <-0.025607, -2.031000, 9.638892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.032198, -0.507667, 9.260110>, <-0.031398, -0.432003, 9.305890>, <-0.030828, -0.310046, 9.338443>, <-0.029693, -0.250056, 9.403414>, 
      <-0.351743, -0.507658, 9.262529>, <-0.350943, -0.431994, 9.308309>, <-0.490973, -0.310033, 9.341926>, <-0.489838, -0.250043, 9.406898>, 
      <-0.617672, -0.773576, 9.264138>, <-0.692552, -0.773574, 9.310385>, <-0.813869, -0.632966, 9.343822>, <-0.872776, -0.632965, 9.409213>, 
      <-0.617685, -1.093130, 9.263652>, <-0.692565, -1.093127, 9.309899>, <-0.813887, -1.093124, 9.343122>, <-0.872794, -1.093122, 9.408513>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553242, -1.093163, 9.254788>, <0.521840, -1.093162, 9.236269>, <0.465493, -1.093160, 9.218803>, <0.454418, -1.093160, 9.184070>, 
      <0.553255, -0.773609, 9.255274>, <0.521853, -0.773608, 9.236754>, <0.465504, -0.826865, 9.219209>, <0.454428, -0.826865, 9.184476>, 
      <0.287347, -0.507676, 9.257691>, <0.287019, -0.538742, 9.238894>, <0.233446, -0.594803, 9.221260>, <0.232839, -0.605254, 9.186490>, 
      <-0.032198, -0.507667, 9.260110>, <-0.032527, -0.538733, 9.241313>, <-0.032842, -0.594796, 9.223276>, <-0.033449, -0.605247, 9.188506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.032245, -1.678625, 9.258330>, <-0.032571, -1.647562, 9.239630>, <-0.032882, -1.591490, 9.221740>, <-0.033488, -1.581045, 9.187022>, 
      <0.287301, -1.678634, 9.255912>, <0.286975, -1.647571, 9.237211>, <0.233405, -1.591497, 9.219724>, <0.232799, -1.581053, 9.185006>, 
      <0.553229, -1.412717, 9.254303>, <0.521827, -1.412716, 9.235783>, <0.465483, -1.359455, 9.218398>, <0.454407, -1.359455, 9.183666>, 
      <0.553242, -1.093163, 9.254788>, <0.521840, -1.093162, 9.236269>, <0.465493, -1.093160, 9.218803>, <0.454418, -1.093160, 9.184070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.617685, -1.093130, 9.263652>, <-0.692565, -1.093127, 9.309899>, <-0.813887, -1.093124, 9.343122>, <-0.872794, -1.093122, 9.408513>, 
      <-0.617697, -1.412683, 9.263166>, <-0.692578, -1.412681, 9.309414>, <-0.813906, -1.553282, 9.342422>, <-0.872812, -1.553280, 9.407813>, 
      <-0.351790, -1.678616, 9.260749>, <-0.350996, -1.754284, 9.306301>, <-0.491036, -1.876219, 9.339528>, <-0.489905, -1.936223, 9.404332>, 
      <-0.032245, -1.678625, 9.258330>, <-0.031451, -1.754293, 9.303882>, <-0.030891, -1.876232, 9.336046>, <-0.029761, -1.936236, 9.400850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033449, -0.605247, 9.188506>, <-0.032842, -0.594796, 9.223276>, <-0.032527, -0.538733, 9.241313>, <-0.032198, -0.507667, 9.260110>, 
      <-0.299737, -0.605239, 9.190522>, <-0.299130, -0.594788, 9.225292>, <-0.352072, -0.538724, 9.243731>, <-0.351743, -0.507658, 9.262529>, 
      <-0.521344, -0.826837, 9.191862>, <-0.531165, -0.826837, 9.226615>, <-0.586946, -0.773577, 9.245160>, <-0.617672, -0.773576, 9.264138>, 
      <-0.521355, -1.093132, 9.191457>, <-0.531176, -1.093132, 9.226210>, <-0.586958, -1.093130, 9.244674>, <-0.617685, -1.093130, 9.263652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.454418, -1.093160, 9.184070>, <0.407130, -1.093159, 9.035779>, <0.401824, -1.094249, 8.824391>, <0.367581, -1.093158, 8.672560>, 
      <0.454428, -0.826865, 9.184476>, <0.407141, -0.826864, 9.036184>, <0.401832, -0.870472, 8.824732>, <0.367590, -0.869380, 8.672900>, 
      <0.232839, -0.605254, 9.186490>, <0.230240, -0.649996, 9.037635>, <0.202983, -0.674169, 8.828278>, <0.181380, -0.683153, 8.674593>, 
      <-0.033449, -0.605247, 9.188506>, <-0.036048, -0.649988, 9.039651>, <-0.020788, -0.674163, 8.829972>, <-0.042391, -0.683146, 8.676286>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033488, -1.581045, 9.187022>, <-0.036084, -1.536287, 9.038246>, <-0.018213, -1.513509, 8.828178>, <-0.042424, -1.503146, 8.675040>, 
      <0.232799, -1.581053, 9.185006>, <0.230203, -1.536294, 9.036229>, <0.205558, -1.513516, 8.826484>, <0.181347, -1.503152, 8.673346>, 
      <0.454407, -1.359455, 9.183666>, <0.407120, -1.359454, 9.035374>, <0.401815, -1.318026, 8.824051>, <0.367572, -1.316935, 8.672219>, 
      <0.454418, -1.093160, 9.184070>, <0.407130, -1.093159, 9.035779>, <0.401824, -1.094249, 8.824391>, <0.367581, -1.093158, 8.672560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.521355, -1.093132, 9.191457>, <-0.531176, -1.093132, 9.226210>, <-0.586958, -1.093130, 9.244674>, <-0.617685, -1.093130, 9.263652>, 
      <-0.521365, -1.359427, 9.191051>, <-0.531187, -1.359427, 9.225804>, <-0.586971, -1.412684, 9.244190>, <-0.617697, -1.412683, 9.263166>, 
      <-0.299776, -1.581038, 9.189038>, <-0.299170, -1.591482, 9.223756>, <-0.352116, -1.647553, 9.242048>, <-0.351790, -1.678616, 9.260749>, 
      <-0.033488, -1.581045, 9.187022>, <-0.032882, -1.591490, 9.221740>, <-0.032571, -1.647562, 9.239630>, <-0.032245, -1.678625, 9.258330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.422325, -1.038843, 6.473722>, <1.348688, -0.939224, 6.236727>, <1.313546, -0.974738, 5.833970>, <1.138641, -0.944471, 5.633958>, 
      <1.492781, -1.045014, 6.468878>, <1.419145, -0.945394, 6.231884>, <1.391731, -0.981707, 5.749093>, <1.216827, -0.951440, 5.549080>, 
      <1.546273, -1.108919, 6.464936>, <1.540616, -1.112384, 6.157686>, <1.468088, -1.065960, 5.716120>, <1.273507, -1.053081, 5.478593>, 
      <1.540095, -1.179541, 6.465044>, <1.534439, -1.183006, 6.157794>, <1.458014, -1.181130, 5.716296>, <1.263432, -1.168252, 5.478769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.540095, -1.179541, 6.465044>, <1.534439, -1.183006, 6.157794>, <1.458014, -1.181130, 5.716296>, <1.263432, -1.168252, 5.478769>, 
      <1.533917, -1.250164, 6.465152>, <1.528261, -1.253628, 6.157902>, <1.447939, -1.296300, 5.716472>, <1.253358, -1.283422, 5.478945>, 
      <1.470144, -1.303799, 6.469273>, <1.380270, -1.395650, 6.234041>, <1.358182, -1.365936, 5.749750>, <1.179910, -1.373464, 5.549725>, 
      <1.399687, -1.297628, 6.474116>, <1.309813, -1.389480, 6.238885>, <1.279997, -1.358967, 5.834628>, <1.101725, -1.366495, 5.634602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.138641, -0.944471, 5.633958>, <0.933996, -0.909057, 5.399934>, <0.547658, -0.876883, 5.135184>, <0.238127, -0.833917, 5.119525>, 
      <1.216827, -0.951440, 5.549080>, <1.012181, -0.916026, 5.315057>, <0.553740, -0.877630, 4.994330>, <0.244208, -0.834664, 4.978670>, 
      <1.273507, -1.053081, 5.478593>, <1.043916, -1.037886, 5.198330>, <0.599727, -0.984533, 4.880363>, <0.239044, -0.952166, 4.861633>, 
      <1.263432, -1.168252, 5.478769>, <1.033841, -1.153056, 5.198506>, <0.587441, -1.124984, 4.880578>, <0.226759, -1.092617, 4.861848>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.976934, -1.142715, 5.789790>, <1.135401, -1.152577, 5.952282>, <1.136536, -1.147423, 6.308476>, <1.281917, -1.156930, 6.482794>, 
      <0.987008, -1.027545, 5.789614>, <1.145475, -1.037407, 5.952106>, <1.142714, -1.076801, 6.308369>, <1.288094, -1.086308, 6.482686>, 
      <1.060456, -0.937502, 5.718835>, <1.235360, -0.967770, 5.918848>, <1.278231, -0.933053, 6.241571>, <1.351868, -1.032673, 6.478565>, 
      <1.138641, -0.944471, 5.633958>, <1.313546, -0.974738, 5.833970>, <1.348688, -0.939224, 6.236727>, <1.422325, -1.038843, 6.473722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.101725, -1.366495, 5.634602>, <1.279997, -1.358967, 5.834628>, <1.309813, -1.389480, 6.238885>, <1.399687, -1.297628, 6.474116>, 
      <1.023540, -1.359527, 5.719480>, <1.201812, -1.351998, 5.919505>, <1.239356, -1.383309, 6.243729>, <1.329231, -1.291458, 6.478960>, 
      <0.966859, -1.257885, 5.789966>, <1.125326, -1.267746, 5.952458>, <1.130359, -1.218046, 6.308584>, <1.275739, -1.227552, 6.482902>, 
      <0.976934, -1.142715, 5.789790>, <1.135401, -1.152577, 5.952282>, <1.136536, -1.147423, 6.308476>, <1.281917, -1.156930, 6.482794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.263432, -1.168252, 5.478769>, <1.033841, -1.153056, 5.198506>, <0.587441, -1.124984, 4.880578>, <0.226759, -1.092617, 4.861848>, 
      <1.253358, -1.283422, 5.478945>, <1.023767, -1.268226, 5.198682>, <0.575155, -1.265435, 4.880792>, <0.214473, -1.233069, 4.862062>, 
      <1.179910, -1.373464, 5.549725>, <0.971560, -1.382263, 5.315953>, <0.511788, -1.362464, 4.995093>, <0.199188, -1.349328, 4.979456>, 
      <1.101725, -1.366495, 5.634602>, <0.893375, -1.375294, 5.400831>, <0.505707, -1.361717, 5.135948>, <0.193106, -1.348581, 5.120311>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238127, -0.833917, 5.119525>, <-0.091481, -0.788164, 5.102850>, <-0.548988, -0.720984, 5.299917>, <-0.779228, -0.678249, 5.536931>, 
      <0.244208, -0.834664, 4.978670>, <-0.085399, -0.788911, 4.961996>, <-0.683100, -0.709402, 5.202309>, <-0.913341, -0.666667, 5.439323>, 
      <0.239044, -0.952166, 4.861633>, <-0.172066, -0.915274, 4.840285>, <-0.745957, -0.823337, 5.066226>, <-1.037003, -0.794872, 5.358306>, 
      <0.226759, -1.092617, 4.861848>, <-0.184352, -1.055725, 4.840500>, <-0.760446, -0.988980, 5.066479>, <-1.051493, -0.960515, 5.358559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.204475, -1.089880, 5.377989>, <0.466186, -1.113677, 5.390514>, <0.793422, -1.131295, 5.601618>, <0.976934, -1.142715, 5.789790>, 
      <0.216761, -0.949429, 5.377774>, <0.478472, -0.973226, 5.390300>, <0.803497, -1.016125, 5.601442>, <0.987008, -1.027545, 5.789614>, 
      <0.232046, -0.833170, 5.260380>, <0.541577, -0.876136, 5.276039>, <0.855811, -0.902088, 5.484812>, <1.060456, -0.937502, 5.718835>, 
      <0.238127, -0.833917, 5.119525>, <0.547658, -0.876883, 5.135184>, <0.933996, -0.909057, 5.399934>, <1.138641, -0.944471, 5.633958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.193106, -1.348581, 5.120311>, <0.505707, -1.361717, 5.135948>, <0.893375, -1.375294, 5.400831>, <1.101725, -1.366495, 5.634602>, 
      <0.187025, -1.347834, 5.261166>, <0.499626, -1.360970, 5.276802>, <0.815190, -1.368325, 5.485708>, <1.023540, -1.359527, 5.719480>, 
      <0.192189, -1.230331, 5.378203>, <0.453900, -1.254129, 5.390729>, <0.783348, -1.246465, 5.601794>, <0.966859, -1.257885, 5.789966>, 
      <0.204475, -1.089880, 5.377989>, <0.466186, -1.113677, 5.390514>, <0.793422, -1.131295, 5.601618>, <0.976934, -1.142715, 5.789790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.226759, -1.092617, 4.861848>, <-0.184352, -1.055725, 4.840500>, <-0.760446, -0.988980, 5.066479>, <-1.051493, -0.960515, 5.358559>, 
      <0.214473, -1.233069, 4.862062>, <-0.196638, -1.196176, 4.840714>, <-0.774936, -1.154623, 5.066732>, <-1.065983, -1.126158, 5.358812>, 
      <0.199188, -1.349328, 4.979456>, <-0.132803, -1.335377, 4.962850>, <-0.738461, -1.286215, 5.198263>, <-0.966436, -1.273641, 5.440250>, 
      <0.193106, -1.348581, 5.120311>, <-0.138884, -1.334630, 5.103704>, <-0.604349, -1.297798, 5.295871>, <-0.832324, -1.285223, 5.537858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.779228, -0.678249, 5.536931>, <-1.025294, -0.632577, 5.790236>, <-1.310474, -0.561881, 6.282816>, <-1.228553, -0.561687, 6.629351>, 
      <-0.913341, -0.666667, 5.439323>, <-1.159406, -0.620994, 5.692628>, <-1.502214, -0.561881, 6.307662>, <-1.420293, -0.561687, 6.654196>, 
      <-1.037003, -0.794872, 5.358306>, <-1.336792, -0.765552, 5.659158>, <-1.652844, -0.703413, 6.255885>, <-1.579855, -0.722583, 6.674872>, 
      <-1.051493, -0.960515, 5.358559>, <-1.351282, -0.931195, 5.659412>, <-1.652844, -0.896757, 6.255885>, <-1.579855, -0.915927, 6.674872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560059, -1.002957, 5.716228>, <-0.392642, -1.029880, 5.529602>, <-0.046360, -1.067072, 5.365984>, <0.204475, -1.089880, 5.377989>, 
      <-0.545569, -0.837315, 5.715975>, <-0.378152, -0.864237, 5.529349>, <-0.034074, -0.926620, 5.365769>, <0.216761, -0.949429, 5.377774>, 
      <-0.645116, -0.689832, 5.634539>, <-0.414876, -0.732566, 5.397525>, <-0.097562, -0.787417, 5.243705>, <0.232046, -0.833170, 5.260380>, 
      <-0.779228, -0.678249, 5.536931>, <-0.548988, -0.720984, 5.299917>, <-0.091481, -0.788164, 5.102850>, <0.238127, -0.833917, 5.119525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.832324, -1.285223, 5.537858>, <-0.604349, -1.297798, 5.295871>, <-0.138884, -1.334630, 5.103704>, <0.193106, -1.348581, 5.120311>, 
      <-0.698211, -1.296806, 5.635466>, <-0.470237, -1.309380, 5.393479>, <-0.144965, -1.333883, 5.244559>, <0.187025, -1.347834, 5.261166>, 
      <-0.574548, -1.168600, 5.716482>, <-0.407131, -1.195522, 5.529855>, <-0.058646, -1.207523, 5.366198>, <0.192189, -1.230331, 5.378203>, 
      <-0.560059, -1.002957, 5.716228>, <-0.392642, -1.029880, 5.529602>, <-0.046360, -1.067072, 5.365984>, <0.204475, -1.089880, 5.377989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.051493, -0.960515, 5.358559>, <-1.351282, -0.931195, 5.659412>, <-1.652844, -0.896757, 6.255885>, <-1.579855, -0.915927, 6.674872>, 
      <-1.065983, -1.126158, 5.358812>, <-1.365771, -1.096838, 5.659665>, <-1.652844, -1.090100, 6.255885>, <-1.579855, -1.109271, 6.674872>, 
      <-0.966436, -1.273641, 5.440250>, <-1.205160, -1.260474, 5.693646>, <-1.505057, -1.240440, 6.317590>, <-1.420293, -1.270167, 6.654196>, 
      <-0.832324, -1.285223, 5.537858>, <-1.071047, -1.272056, 5.791254>, <-1.313317, -1.240440, 6.292745>, <-1.228553, -1.270167, 6.629351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.228553, -0.561687, 6.629351>, <-1.112286, -0.561412, 7.121170>, <-0.458778, -0.650980, 7.526218>, <-0.205725, -0.676892, 7.962907>, 
      <-1.420293, -0.561687, 6.654196>, <-1.304027, -0.561412, 7.146015>, <-0.645819, -0.652645, 7.649058>, <-0.392766, -0.678557, 8.085746>, 
      <-1.579855, -0.722583, 6.674872>, <-1.486902, -0.746997, 7.208466>, <-0.820382, -0.823920, 7.703830>, <-0.555310, -0.865582, 8.174956>, 
      <-1.579855, -0.915927, 6.674872>, <-1.486902, -0.940340, 7.208466>, <-0.828665, -1.046996, 7.688194>, <-0.563593, -1.088659, 8.159320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.877250, -0.915927, 6.583830>, <-0.967291, -0.905415, 6.320648>, <-0.744872, -0.973237, 5.922246>, <-0.560059, -1.002957, 5.716228>, 
      <-0.877250, -0.722583, 6.583830>, <-0.967291, -0.712072, 6.320648>, <-0.730382, -0.807595, 5.921993>, <-0.545569, -0.837315, 5.715975>, 
      <-1.036812, -0.561687, 6.604505>, <-1.118733, -0.561881, 6.257970>, <-0.891182, -0.644159, 5.887844>, <-0.645116, -0.689832, 5.634539>, 
      <-1.228553, -0.561687, 6.629351>, <-1.310474, -0.561881, 6.282816>, <-1.025294, -0.632577, 5.790236>, <-0.779228, -0.678249, 5.536931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.228553, -1.270167, 6.629351>, <-1.313317, -1.240440, 6.292745>, <-1.071047, -1.272056, 5.791254>, <-0.832324, -1.285223, 5.537858>, 
      <-1.036812, -1.270167, 6.604505>, <-1.121576, -1.240440, 6.267899>, <-0.936935, -1.283639, 5.888862>, <-0.698211, -1.296806, 5.635466>, 
      <-0.877250, -1.109271, 6.583830>, <-0.967291, -1.098759, 6.320648>, <-0.759361, -1.138880, 5.922500>, <-0.574548, -1.168600, 5.716482>, 
      <-0.877250, -0.915927, 6.583830>, <-0.967291, -0.905415, 6.320648>, <-0.744872, -0.973237, 5.922246>, <-0.560059, -1.002957, 5.716228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.579855, -0.915927, 6.674872>, <-1.486902, -0.940340, 7.208466>, <-0.828665, -1.046996, 7.688194>, <-0.563593, -1.088659, 8.159320>, 
      <-1.579855, -1.109271, 6.674872>, <-1.486902, -1.133684, 7.208466>, <-0.836948, -1.270073, 7.672558>, <-0.571876, -1.311735, 8.143683>, 
      <-1.420293, -1.270167, 6.654196>, <-1.301156, -1.311948, 7.127302>, <-0.667549, -1.447978, 7.606884>, <-0.423119, -1.495989, 8.028448>, 
      <-1.228553, -1.270167, 6.629351>, <-1.109416, -1.311948, 7.102456>, <-0.480509, -1.446313, 7.484045>, <-0.236078, -1.494324, 7.905609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.205725, -0.676892, 7.962907>, <-0.095787, -0.688149, 8.152626>, <-0.072902, -0.695835, 8.459227>, <-0.042391, -0.683146, 8.676286>, 
      <-0.392766, -0.678557, 8.085746>, <-0.282827, -0.689814, 8.275465>, <-0.296673, -0.695829, 8.460922>, <-0.266162, -0.683140, 8.677981>, 
      <-0.555310, -0.865582, 8.174956>, <-0.477394, -0.877829, 8.313442>, <-0.458903, -0.868667, 8.519872>, <-0.452387, -0.869357, 8.679106>, 
      <-0.563593, -1.088659, 8.159320>, <-0.485677, -1.100905, 8.297805>, <-0.458912, -1.092444, 8.519531>, <-0.452396, -1.093134, 8.678766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.121790, -1.082557, 7.709195>, <-0.110128, -1.049538, 7.320055>, <-0.730324, -0.933079, 7.013277>, <-0.877250, -0.915927, 6.583830>, 
      <0.130073, -0.859480, 7.724831>, <-0.101845, -0.826461, 7.335691>, <-0.730324, -0.739735, 7.013277>, <-0.877250, -0.722583, 6.583830>, 
      <-0.018685, -0.675226, 7.840068>, <-0.271737, -0.649315, 7.403379>, <-0.920545, -0.561412, 7.096324>, <-1.036812, -0.561687, 6.604505>, 
      <-0.205725, -0.676892, 7.962907>, <-0.458778, -0.650980, 7.526218>, <-1.112286, -0.561412, 7.121170>, <-1.228553, -0.561687, 6.629351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236078, -1.494324, 7.905609>, <-0.480509, -1.446313, 7.484045>, <-1.109416, -1.311948, 7.102456>, <-1.228553, -1.270167, 6.629351>, 
      <-0.049037, -1.492659, 7.782770>, <-0.293468, -1.444648, 7.361206>, <-0.917675, -1.311948, 7.077610>, <-1.036812, -1.270167, 6.604505>, 
      <0.113507, -1.305634, 7.693558>, <-0.118411, -1.272615, 7.304418>, <-0.730324, -1.126423, 7.013277>, <-0.877250, -1.109271, 6.583830>, 
      <0.121790, -1.082557, 7.709195>, <-0.110128, -1.049538, 7.320055>, <-0.730324, -0.933079, 7.013277>, <-0.877250, -0.915927, 6.583830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.563593, -1.088659, 8.159320>, <-0.485677, -1.100905, 8.297805>, <-0.458912, -1.092444, 8.519531>, <-0.452396, -1.093134, 8.678766>, 
      <-0.571876, -1.311735, 8.143683>, <-0.493960, -1.323982, 8.282168>, <-0.458921, -1.316221, 8.519190>, <-0.452405, -1.316912, 8.678426>, 
      <-0.423119, -1.495989, 8.028448>, <-0.304291, -1.519329, 8.233386>, <-0.303285, -1.487262, 8.442135>, <-0.266195, -1.503139, 8.676734>, 
      <-0.236078, -1.494324, 7.905609>, <-0.117251, -1.517664, 8.110547>, <-0.079514, -1.487269, 8.440441>, <-0.042424, -1.503146, 8.675040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.042391, -0.683146, 8.676286>, <-0.020788, -0.674163, 8.829972>, <-0.036048, -0.649988, 9.039651>, <-0.033449, -0.605247, 9.188506>, 
      <-0.266162, -0.683140, 8.677981>, <-0.244559, -0.674156, 8.831666>, <-0.302336, -0.649981, 9.041667>, <-0.299737, -0.605239, 9.190522>, 
      <-0.452387, -0.869357, 8.679106>, <-0.446041, -0.870029, 8.834167>, <-0.479140, -0.826839, 9.042518>, <-0.521344, -0.826837, 9.191862>, 
      <-0.452396, -1.093134, 8.678766>, <-0.446050, -1.093806, 8.833827>, <-0.479150, -1.093133, 9.042114>, <-0.521355, -1.093132, 9.191457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.367581, -1.093158, 8.672560>, <0.301959, -1.091066, 8.381591>, <0.274093, -1.104241, 7.964748>, <0.121790, -1.082557, 7.709195>, 
      <0.367590, -0.869380, 8.672900>, <0.301968, -0.867289, 8.381931>, <0.282376, -0.881164, 7.980384>, <0.130073, -0.859480, 7.724831>, 
      <0.181380, -0.683153, 8.674593>, <0.150869, -0.695842, 8.457534>, <0.091254, -0.686484, 8.029787>, <-0.018685, -0.675226, 7.840068>, 
      <-0.042391, -0.683146, 8.676286>, <-0.072902, -0.695835, 8.459227>, <-0.095787, -0.688149, 8.152626>, <-0.205725, -0.676892, 7.962907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.042424, -1.503146, 8.675040>, <-0.079514, -1.487269, 8.440441>, <-0.117251, -1.517664, 8.110547>, <-0.236078, -1.494324, 7.905609>, 
      <0.181347, -1.503152, 8.673346>, <0.144258, -1.487275, 8.438747>, <0.069790, -1.515999, 7.987708>, <-0.049037, -1.492659, 7.782770>, 
      <0.367572, -1.316935, 8.672219>, <0.301950, -1.314843, 8.381250>, <0.265810, -1.327318, 7.949111>, <0.113507, -1.305634, 7.693558>, 
      <0.367581, -1.093158, 8.672560>, <0.301959, -1.091066, 8.381591>, <0.274093, -1.104241, 7.964748>, <0.121790, -1.082557, 7.709195>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.452396, -1.093134, 8.678766>, <-0.446050, -1.093806, 8.833827>, <-0.479150, -1.093133, 9.042114>, <-0.521355, -1.093132, 9.191457>, 
      <-0.452405, -1.316912, 8.678426>, <-0.446059, -1.317584, 8.833486>, <-0.479161, -1.359428, 9.041708>, <-0.521365, -1.359427, 9.191051>, 
      <-0.266195, -1.503139, 8.676734>, <-0.241984, -1.513503, 8.829871>, <-0.302372, -1.536279, 9.040262>, <-0.299776, -1.581038, 9.189038>, 
      <-0.042424, -1.503146, 8.675040>, <-0.018213, -1.513509, 8.828178>, <-0.036084, -1.536287, 9.038246>, <-0.033488, -1.581045, 9.187022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.687596, -1.093166, 9.658742>, <0.687580, -1.482195, 9.658150>, <0.249884, -2.081007, 9.660553>, <-0.025182, -1.805915, 9.663054>, 
      <0.687611, -0.704138, 9.659334>, <0.687596, -1.093166, 9.658742>, <0.250009, -1.653400, 9.667374>, <-0.025182, -1.805915, 9.663054>, 
      <0.249963, -0.105301, 9.663557>, <0.250054, -0.532927, 9.669077>, <0.250009, -1.653400, 9.667374>, <-0.025182, -1.805915, 9.663054>, 
      <-0.025125, -0.380377, 9.665222>, <-0.025035, -0.808003, 9.670741>, <-0.025057, -1.378307, 9.669874>, <-0.025182, -1.805915, 9.663054>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281917, -1.156930, 6.482794>, <1.331788, -1.160191, 6.542591>, <1.541530, -1.178663, 6.542958>, <1.540095, -1.179541, 6.465044>, 
      <1.288094, -1.086308, 6.482686>, <1.337965, -1.089569, 6.542483>, <1.547707, -1.108041, 6.542850>, <1.540095, -1.179541, 6.465044>, 
      <1.351868, -1.032673, 6.478565>, <1.422325, -1.038843, 6.473722>, <1.547707, -1.108041, 6.542850>, <1.540095, -1.179541, 6.465044>, 
      <1.422325, -1.038843, 6.473722>, <1.492781, -1.045014, 6.468878>, <1.546273, -1.108919, 6.464936>, <1.540095, -1.179541, 6.465044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.399687, -1.297628, 6.474116>, <1.425818, -1.270923, 6.542508>, <1.443784, -1.067875, 6.542787>, <1.422325, -1.038843, 6.473722>, 
      <1.329231, -1.291458, 6.478960>, <1.355361, -1.264753, 6.547352>, <1.373327, -1.061704, 6.547631>, <1.422325, -1.038843, 6.473722>, 
      <1.275739, -1.227552, 6.482902>, <1.281917, -1.156930, 6.482794>, <1.373327, -1.061704, 6.547631>, <1.422325, -1.038843, 6.473722>, 
      <1.281917, -1.156930, 6.482794>, <1.288094, -1.086308, 6.482686>, <1.351868, -1.032673, 6.478565>, <1.422325, -1.038843, 6.473722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.540095, -1.179541, 6.465044>, <1.541530, -1.178663, 6.542958>, <1.331788, -1.160191, 6.542591>, <1.281917, -1.156930, 6.482794>, 
      <1.533917, -1.250164, 6.465152>, <1.535352, -1.249285, 6.543066>, <1.325610, -1.230814, 6.542699>, <1.281917, -1.156930, 6.482794>, 
      <1.470144, -1.303799, 6.469273>, <1.399687, -1.297628, 6.474116>, <1.325610, -1.230814, 6.542699>, <1.281917, -1.156930, 6.482794>, 
      <1.399687, -1.297628, 6.474116>, <1.329231, -1.291458, 6.478960>, <1.275739, -1.227552, 6.482902>, <1.281917, -1.156930, 6.482794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.540095, -1.179541, 6.465044>, <1.546273, -1.108919, 6.464936>, <1.492781, -1.045014, 6.468878>, <1.422325, -1.038843, 6.473722>, 
      <1.533917, -1.250164, 6.465152>, <1.540095, -1.179541, 6.465044>, <1.514241, -1.074045, 6.537943>, <1.422325, -1.038843, 6.473722>, 
      <1.470144, -1.303799, 6.469273>, <1.496274, -1.277094, 6.537664>, <1.514241, -1.074045, 6.537943>, <1.422325, -1.038843, 6.473722>, 
      <1.399687, -1.297628, 6.474116>, <1.425818, -1.270923, 6.542508>, <1.443784, -1.067875, 6.542787>, <1.422325, -1.038843, 6.473722>
    }
  }
  photons {
    collect off
  }
}
#declare ruedas1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.258445, -3.755182, -0.509133>, <-1.197429, -3.755182, -0.656439>, <-1.075916, -3.755182, -0.838296>, <-0.963172, -3.755182, -0.951040>, 
      <-0.889680, -3.707203, -0.356385>, <-0.828664, -3.707203, -0.503691>, <-0.793675, -3.707203, -0.556056>, <-0.680932, -3.707203, -0.668799>, 
      <-0.391799, -3.755182, -0.150156>, <-0.390811, -3.755182, -0.152542>, <-0.301696, -3.755182, -0.285912>, <-0.299870, -3.755182, -0.287738>, 
      <-0.020380, -3.755182, 0.003691>, <-0.019391, -3.755182, 0.001305>, <-0.017424, -3.755182, -0.001640>, <-0.015598, -3.755182, -0.003466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.918747, -4.002174, -0.782639>, <-1.825716, -4.002174, -1.007236>, <-1.640445, -4.002174, -1.284513>, <-1.468545, -4.002174, -1.456412>, 
      <-1.755503, -4.144449, -0.715021>, <-1.662472, -4.144449, -0.939618>, <-1.515503, -4.144449, -1.159572>, <-1.343604, -4.144449, -1.331471>, 
      <-1.466533, -3.782256, -0.595326>, <-1.405517, -3.782256, -0.742632>, <-1.235179, -3.782256, -0.997560>, <-1.122436, -3.782256, -1.110303>, 
      <-1.258445, -3.755182, -0.509133>, <-1.197429, -3.755182, -0.656439>, <-1.075916, -3.755182, -0.838296>, <-0.963172, -3.755182, -0.951040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.555988, -3.495858, -0.632379>, <-1.480546, -3.495858, -0.814514>, <-1.330302, -3.495858, -1.039369>, <-1.190902, -3.495858, -1.178769>, 
      <-1.631826, -3.669667, -0.663792>, <-1.556383, -3.669667, -0.845927>, <-1.388345, -3.669667, -1.097412>, <-1.248945, -3.669667, -1.236812>, 
      <-2.057066, -3.881622, -0.839932>, <-1.964035, -3.881622, -1.064529>, <-1.746310, -3.881622, -1.390378>, <-1.574410, -3.881622, -1.562277>, 
      <-1.918747, -4.002174, -0.782639>, <-1.825716, -4.002174, -1.007236>, <-1.640445, -4.002174, -1.284513>, <-1.468545, -4.002174, -1.456412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.548856, -3.154432, -0.629425>, <-1.473759, -3.154432, -0.810725>, <-1.324204, -3.154432, -1.034549>, <-1.185443, -3.154432, -1.173310>, 
      <-1.507402, -3.246538, -0.612254>, <-1.432305, -3.246538, -0.793554>, <-1.292476, -3.246538, -1.002821>, <-1.153715, -3.246538, -1.141582>, 
      <-1.515566, -3.403216, -0.615636>, <-1.440124, -3.403216, -0.797771>, <-1.299364, -3.403216, -1.008431>, <-1.159964, -3.403216, -1.147831>, 
      <-1.555988, -3.495858, -0.632379>, <-1.480546, -3.495858, -0.814514>, <-1.330302, -3.495858, -1.039369>, <-1.190902, -3.495858, -1.178769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.915690, -2.696646, -0.781372>, <-1.822807, -2.696646, -1.005612>, <-1.637831, -2.696646, -1.282447>, <-1.466206, -2.696646, -1.454073>, 
      <-2.045221, -2.812374, -0.835026>, <-1.952338, -2.812374, -1.059265>, <-1.736970, -2.812374, -1.381586>, <-1.565345, -2.812374, -1.553212>, 
      <-1.622413, -2.990997, -0.659893>, <-1.547316, -2.990997, -0.841193>, <-1.380502, -2.990997, -1.090847>, <-1.241741, -2.990997, -1.229608>, 
      <-1.548856, -3.154432, -0.629425>, <-1.473759, -3.154432, -0.810725>, <-1.324204, -3.154432, -1.034549>, <-1.185443, -3.154432, -1.173310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.263540, -2.899521, -0.511243>, <-1.202277, -2.899521, -0.659146>, <-1.080272, -2.899521, -0.841739>, <-0.967072, -2.899521, -0.954939>, 
      <-1.466138, -2.878065, -0.595162>, <-1.404874, -2.878065, -0.743064>, <-1.235333, -2.878065, -0.996801>, <-1.122133, -2.878065, -1.110000>, 
      <-1.758698, -2.556384, -0.716344>, <-1.665815, -2.556384, -0.940584>, <-1.517675, -2.556384, -1.162291>, <-1.346049, -2.556384, -1.333916>, 
      <-1.915690, -2.696646, -0.781372>, <-1.822807, -2.696646, -1.005612>, <-1.637831, -2.696646, -1.282447>, <-1.466206, -2.696646, -1.454073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.899521, 0.012132>, <0.000000, -2.899521, 0.012132>, <0.000000, -2.899521, 0.012132>, <0.000000, -2.899521, 0.012132>, 
      <-0.379062, -2.899521, -0.144880>, <-0.379062, -2.899521, -0.144880>, <-0.290122, -2.899521, -0.277989>, <-0.290122, -2.899521, -0.277989>, 
      <-0.886280, -2.939473, -0.354977>, <-0.825016, -2.939473, -0.502879>, <-0.791529, -2.939473, -0.552997>, <-0.678329, -2.939473, -0.666196>, 
      <-1.263540, -2.899521, -0.511243>, <-1.202277, -2.899521, -0.659146>, <-1.080272, -2.899521, -0.841739>, <-0.967072, -2.899521, -0.954939>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.963172, -3.755182, -0.951040>, <-0.850429, -3.755182, -1.063783>, <-0.668571, -3.755182, -1.185296>, <-0.521265, -3.755182, -1.246313>, 
      <-0.680932, -3.707203, -0.668799>, <-0.568188, -3.707203, -0.781542>, <-0.515824, -3.707203, -0.816531>, <-0.368518, -3.707203, -0.877548>, 
      <-0.299870, -3.755182, -0.287738>, <-0.298044, -3.755182, -0.289564>, <-0.164674, -3.755182, -0.378679>, <-0.162289, -3.755182, -0.379667>, 
      <-0.015598, -3.755182, -0.003466>, <-0.013772, -3.755182, -0.005291>, <-0.010827, -3.755182, -0.007259>, <-0.008441, -3.755182, -0.008247>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.468545, -4.002174, -1.456412>, <-1.296646, -4.002174, -1.628312>, <-1.019369, -4.002174, -1.813583>, <-0.794771, -4.002174, -1.906614>, 
      <-1.343604, -4.144449, -1.331471>, <-1.171705, -4.144449, -1.503370>, <-0.951751, -4.144449, -1.650339>, <-0.727154, -4.144449, -1.743371>, 
      <-1.122436, -3.782256, -1.110303>, <-1.009693, -3.782256, -1.223046>, <-0.754764, -3.782256, -1.393384>, <-0.607458, -3.782256, -1.454401>, 
      <-0.963172, -3.755182, -0.951040>, <-0.850429, -3.755182, -1.063783>, <-0.668571, -3.755182, -1.185296>, <-0.521265, -3.755182, -1.246313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.190902, -3.495858, -1.178769>, <-1.051502, -3.495858, -1.318169>, <-0.826647, -3.495858, -1.468413>, <-0.644512, -3.495858, -1.543856>, 
      <-1.248945, -3.669667, -1.236812>, <-1.109545, -3.669667, -1.376212>, <-0.858059, -3.669667, -1.544250>, <-0.675925, -3.669667, -1.619693>, 
      <-1.574410, -3.881622, -1.562277>, <-1.402511, -3.881622, -1.734177>, <-1.076662, -3.881622, -1.951902>, <-0.852065, -3.881622, -2.044933>, 
      <-1.468545, -4.002174, -1.456412>, <-1.296646, -4.002174, -1.628312>, <-1.019369, -4.002174, -1.813583>, <-0.794771, -4.002174, -1.906614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.185443, -3.154432, -1.173310>, <-1.046682, -3.154432, -1.312071>, <-0.822857, -3.154432, -1.461626>, <-0.641557, -3.154432, -1.536723>, 
      <-1.153715, -3.246538, -1.141582>, <-1.014954, -3.246538, -1.280343>, <-0.805686, -3.246538, -1.420172>, <-0.624386, -3.246538, -1.495269>, 
      <-1.159964, -3.403216, -1.147831>, <-1.020564, -3.403216, -1.287231>, <-0.809903, -3.403216, -1.427991>, <-0.627768, -3.403216, -1.503434>, 
      <-1.190902, -3.495858, -1.178769>, <-1.051502, -3.495858, -1.318169>, <-0.826647, -3.495858, -1.468413>, <-0.644512, -3.495858, -1.543856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.466206, -2.696646, -1.454073>, <-1.294580, -2.696646, -1.625698>, <-1.017744, -2.696646, -1.810674>, <-0.793505, -2.696646, -1.903557>, 
      <-1.565345, -2.812374, -1.553212>, <-1.393719, -2.812374, -1.724837>, <-1.071398, -2.812374, -1.940205>, <-0.847159, -2.812374, -2.033088>, 
      <-1.241741, -2.990997, -1.229608>, <-1.102980, -2.990997, -1.368369>, <-0.853326, -2.990997, -1.535183>, <-0.672026, -2.990997, -1.610280>, 
      <-1.185443, -3.154432, -1.173310>, <-1.046682, -3.154432, -1.312071>, <-0.822857, -3.154432, -1.461626>, <-0.641557, -3.154432, -1.536723>
 