#include "rand.inc"
#include "glass.inc"

#local MetalTex =
texture
{
    pigment { color rgb <0.55, 0.55, 0.5>*0.75 }
    finish
    {
        specular 0.2 roughness 0.4 metallic
        reflection { 0.8 metallic }
    }

    normal
    {
        average
        normal_map
        {
            [1.0 bozo 1.4 scale 0.15]
            [1.0 wrinkles 1.5 scale 0.01]
        }
    }
}


#local Bell =
union
{
    sphere
    {
        <0, 1, 0>, 0.2
    }
    
    intersection
    {
        difference
        {
            sphere { <0, 0, 0>, 1 }
            sphere { <0, 0, 0>, 0.95 }
        }
        
        box
        {
            <-1, 0, -1>, <1, 1, 1>
        }
    }

    scale <1, 1/2, 1>*0.33
}

#local Hammer =
union
{
    cylinder { 0, 0.65*y, 0.02 }
    cylinder { <-0.1, 0.65, 0>, <0.1, 0.65, 0>, 0.05 }
}

#local Body =
union
{
    difference
    {
        cylinder
        {
            <0, 0, -0.3>, <0, 0, 0.3>, 0.5
    
            texture { MetalTex }
        }
        
        cylinder
        {
            <0, 0, -0.35>, <0, 0, -0.25>, 0.45
            
            texture
            {
                pigment {
                    image_map
                    {
                        png "clock.png"
                    }
                    
                    translate <-0.5, -0.5, 0>
                    scale 0.9
                }
            }
        }
        
        torus
        {
            0.5, 0.01
            rotate 90*x
            translate <0, 0, -0.285>
    
            texture { MetalTex }
        }
    
        torus
        {
            0.5, 0.01
            rotate 90*x
            translate <0, 0, -0.245>
    
            texture { MetalTex }
        }
    }
    
    // Glass
    intersection
    {
        sphere
        {
            <0, 0, 0.4>, 0.8
        }
        
        cylinder
        {
            <0, 0, -0.5>, <0, 0, 0>, 0.45
        }
        
        texture
        {
            pigment { color <0.97, 0.99, 0.98, 0.97> }
            normal { bozo 0.05 scale 0.05 }
            finish { F_Glass5 }
        }
    }
}

#local HalfHand =
height_field
{
    png "hand.png"
    water_level 0.5
    translate <-1, 0, 0>
    scale <1/8, 0.01, 1>
    rotate -90*x
}

#local Hand =
union
{
    object { HalfHand rotate 15*y }
    object { HalfHand scale <-1, 1, 1> rotate -15*y }
    scale 0.35
    translate <0, -0.05, -0.28>
}


#declare Clock =
union
{
    object { Body }

    object { Hammer texture { MetalTex } }
    
    union
    {
        object { Hand rotate 18*z }
        object { Hand scale <1, 0.7, 1> rotate -100*z }
        pigment { color rgb <0, 0, 0.1> }
    }
    
    union
    {
        cylinder
        {
            <0, 0.4, 0>, <0, 0.6, 0>, 0.05
        }
        
        object
        {
            Bell
            rotate 30*z
            translate <-0.4, 0.45, 0>
        }

        texture { MetalTex }
    }

    union
    {    
        cylinder
        {
            <-0.4, 0.45, 0>, <0, 0, 0>, 0.05
        }
        
        object
        {
            Bell
            rotate -30*z
            translate <0.4, 0.45, 0>
        }

        texture { MetalTex }
    }
    
    // Legs
    union
    {
        cylinder
        {
            <0.4, 0.45, 0>, <0, 0, 0>, 0.05
        }
        
        cylinder
        {
            <-0.4, -0.6, 0>, <0, 0, 0>, 0.05
        }
        
        cylinder
        {
            <0, -0.55, 0.5>, <0, 0, 0>, 0.05
        }
    
        cylinder
        {
            <0.4, -0.6, 0>, <0, 0, 0>, 0.05
        }
    
        sphere
        {
            <-0.4, -0.6, 0>, 0.1
        }
    
        sphere
        {
            <0, -0.55, 0.5>, 0.1
        }
    
        sphere
        {
            <0.4, -0.6, 0>, 0.1
        }
    
        texture { MetalTex }
    }
}


/////////////////////////////////////////////////////////////////////////

/*
camera
{
    location <1, 1.5, -2>
    look_at <0, 1, 0>
}

light_source
{
    <-10, 20, -30>
    color rgb 1
}

light_source
{
    <10, 5, -30>
    color rgb 0.3
}

plane
{
    y, 0
    pigment { color rgb 0.7 }
}

object
{
    Clock
    translate 0.55*y
    rotate 10*x
}
*/
