#local WoodPigment =
pigment
{
    // If you change anything here, change SpottedWoodTexture too
    wood
    warp { turbulence 0.05 }
    color_map
    {
        [0.5 color rgb <0.67, 0.39, 0.15>]
        [1.0 color rgb <0.39, 0.28, 0.15>]
    }
    rotate 87*x
    rotate -92*y
    scale 0.3
}

#local SpottedWoodTexture =
texture
{
    pigment
    {
        bozo
        pigment_map
        {
            [0.7 WoodPigment]
            [0.75 color rgb <0.28, 0.17, 0.1>]
        }
    }
    
    normal
    {
        wood 1.3
        warp { turbulence 0.05 }
        rotate 87*x
        rotate -92*y
        scale 0.3
    }
    
    scale <0.1, 1.5, 0.1>
}

#macro Frame (start_x, start_z)
    union
    {
        union
        {
            box
            {
                <- 0.3, -1, -0.1>, <0.1, DoorHeight, 1 + 0.1>
            }

            cylinder
            {
                <- 0.3, -1, 0>, <- 0.3, DoorHeight, 0>, 0.1
            }

            texture
            {    
                SpottedWoodTexture
                rotate (-1*y + 3*z)
                translate <start_x, 0, start_z>
            }
            
            texture
            {
                pigment
                {
                    gradient y
                    color_map
                    {
                        [0.0 color rgbt <0, 0, 0, 0.3>]
                        [0.05 color rgbt <0, 0, 0, 1>]
                    }
                }
                
                scale <1, DoorHeight, 1>
            }
        }

        union
        {
            box
            {
                <4 - 0.1, -1, -0.1>, <4 + 0.3, DoorHeight, 1 + 0.1>
            }

            cylinder
            {
                <4 + 0.3, -1, 0>, <4 + 0.3, DoorHeight, 0>, 0.1
            }

            texture
            {
                SpottedWoodTexture
                rotate (2*y + 4*z)
                translate <start_x, 0, start_z>
            }
            
            texture
            {
                pigment
                {
                    gradient y
                    color_map
                    {
                        [0.0 color rgbt <0, 0, 0, 0.3>]
                        [0.05 color rgbt <0, 0, 0, 1>]
                    }
                }
                
                scale <1, DoorHeight, 1>
            }
        }

        object
        {        
            box
            {
                <-0.3 - 0.1, DoorHeight - 0.03, -0.1>,
                <4 + 0.3 + 0.1, DoorHeight + 0.3 + 0.1, 1 + 0.1>
            }
            
            texture
            {
                SpottedWoodTexture
                rotate 89*z
                translate <start_x, 0, start_z>
            }
        }
        
        translate <start_x, 0, start_z>
    }
#end

object { Frame (-1, 11) }
object { Frame (-1, 22) }

// The Window Frame

box
{
    <-5 - 0.1, 2.5 - 0.3, 5 - 0.3>, <-4 + 0.2, 2.5 + 0.1, 9 + 0.3>
    texture
    {
        SpottedWoodTexture
        rotate -1*z
        rotate 2*x
    }
}

box
{
    <-5 - 0.1, 2.5 + 0.1, 9 - 0.1>, <-4 + 0.2, 8 + 0.3, 9 + 0.3>
    texture
    {
        SpottedWoodTexture
        rotate 3*z
        rotate 1*x
    }
}

box
{
    <-5 - 0.1, 2.5 + 0.1, 5 - 0.3>, <-4 + 0.2, 8 + 0.3, 6 + 0.1>
    texture
    {
        SpottedWoodTexture
        rotate 3*z
        rotate 1*x
    }
}

// The Window

#local WindowGlass =
texture
{
    pigment { color <0.97, 0.99, 0.98, 0.8> }
    normal { bozo 0.05 scale 0.05 }
    finish { F_Glass5 }
}

#local WindowThickness = 0.3;

#local LockTexture =
texture
{
    pigment { color rgb <0.1, 0.1, 0.15> * 4 }
    finish { specular 0.4 roughness 0.3 metallic reflection { 0.3 metallic } }
    normal { wrinkles 0.2 scale 0.2 }
}

#include "handle.inc"
    
#local Window =
union
{
    box
    {
        < -0.1, 2.5 + 0.05, -WindowThickness/2>,
        <2.793, 2.5 + 0.3 ,  WindowThickness/2>
        texture
        {
            SpottedWoodTexture
            rotate 89*z
            rotate -4*x
        }
    }
    
    box
    {
        <2.793, 2.5 + 0.05, -WindowThickness/2>,
        < 2.80, 2.5 + 0.3 ,  WindowThickness/2>
        pigment { color rgb 0 }
    }

    box
    {
        <-0.1, 2.5 + 0.05, -WindowThickness/2>,
        < 0.1, 8.0,         WindowThickness/2>

        texture
        {
            SpottedWoodTexture
            rotate 3*z
            rotate -2*x
        }
    }
    
    cylinder
    {
        <-0.1, 5.0, 0>,
        < 2.8, 5.0, 0>, WindowThickness/3
        texture
        {
            SpottedWoodTexture
            rotate 92*z
            rotate 4*x
        }
    }

    difference
    {
        box
        {
            <2.8, 2.5 + 0.065, -WindowThickness/2>,
            <  3, 8.0,          WindowThickness/2>

            texture
            {
                SpottedWoodTexture
                rotate -2*z
                rotate 2*x
            }
        }

        // Hole for the lock            
        box
        {
            <2.9, 4.9, -WindowThickness/3>
            <3.1, 5.1, WindowThickness/3>
        }
        
        cutaway_textures
    }

    // The lock
    union
    {
        difference
        {
            box
            {
                <2.9, 4.9, -WindowThickness/3>
                <2.98, 5.1, WindowThickness/3>
                texture { LockTexture }
            }

            box
            {
                <2.975, 4.92, -WindowThickness/6>
                <3.0, 5.08, WindowThickness/6>
                pigment { color rgb 0 }
            }
        }
        
        box
        {
            <0, -0.5, -0.5>, <1, 0.5, 0.5>
            scale <0.075, 0.08, WindowThickness/3 * 0.9>
            rotate 1*z
            translate <2.9, 5, 0>            
            
            texture { LockTexture }
        }
    }
    
    // The handle
    object
    {
        Handle
        scale 0.2
        rotate 180 * y
        rotate 32*z
        translate <2.9, 5, WindowThickness/2>
        
        texture { LockTexture }
    }        

    // The window glasses
    union
    {
        box
        {
            <-0.1, 2.5 + 0.3, -WindowThickness/4>
            < 2.8, 5.0,        WindowThickness/4>
        }

        box
        {
            <-0.1, 5.0 + 0.1, -WindowThickness/4>
            < 2.8, 8.0 - 0.1,  WindowThickness/4>
        }
        texture { WindowGlass }
        interior { I_Glass1 }
    }
}

// Visible windows
object
{
    Window
    scale <2/3 - 0.05, 1.0, 1.0>
    rotate 8*y
    translate <-4.5, 0.05, 9 - 0.2>
}

object
{
    Window
    scale <2/3 - 0.05, 1.0, 1.0>
    rotate 5*y
    translate <-4.5, 0.05, 5 + 0.2>
}

// Invisible windows (in the other room)

object
{
    Window
    scale <1 - 0.05, 1.0, 1.0>
    rotate 90*y
    translate <-4.5, 0.05, 19>
}

object
{
    Window
    scale <1 - 0.05, 1.0, 1.0>
    rotate -90*y
    translate <-4.5, 0.05, 14>
}

///////////////////////////////////////////////////////////////////////
    
#declare DoorWindowHF =
height_field
{
    png "door_win.png"
    water_level 0.01
    smooth
    
    rotate -90*x
}

#declare DoorWindow =
union
{
    union
    {
        object { DoorWindowHF }
        object { DoorWindowHF rotate 180*y  scale <-1, 1, 1> }
        
        pigment
        {    
            WoodPigment
            rotate 2*y
            rotate 5*x
            scale 0.1
        }
    }
    
    box
    {
        <0, 0, -0.1>, <1, 1, 0.1>
        
        texture { WindowGlass }
        interior { I_Glass1 }
    }
    
    scale <2, DoorHeight, 0.2>
}

object
{
    DoorWindow
    rotate 120*y
    translate <-1, 0.05, 22>
}

object
{
    DoorWindow
    translate <-2, 0, 0>
    rotate -110*y
    translate <3, 0.05, 22>
}
