#include "colors.inc"
#include "functions.inc"

// ----------------------------------------

camera {
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.7,0.5,0.3> }
}



isosurface
{
    function { y - 1 + pow(z,6) + 0.05*f_agate (x*5, y*5, z*5) }
    contained_by { box { <0, 0, -1>, <1, 1, 1> } }
    max_gradient 10
    
    scale <1, 0.1, 0.5>
    
    pigment { color rgb 0.6 }
}
