#ifndef (STRAW_INC)
#declare STRAW_INC = 1;

#include "rand.inc"

// These colors are used outside of this file as well
#declare StrawCol1 = <0.7, 0.7, 0.4>; // Bright yellow
#declare StrawCol2 = <0.3, 0.4, 0.25>; // Pale dark green

// Create straw around the box specified by Pt1, Pt2. The straw faces the -z direction

#macro CreateStraw (Pt1, Pt2, Radius, Length, Num, SeedNum)

    union
    {
        #local Count = 0;
        #local Seed = seed (SeedNum);
        
        #while (Count < Num)
            #local Start = VRand_In_Box (Pt1, Pt2, Seed);
            #local Dir = VRand_In_Sphere (Seed);
            #local End = Start + Length * Dir * RRand (0.8, 1.2, Seed);
            
            cylinder
            {
                Start, End, Radius
                pigment
                {
                    color rgb StrawCol1 + rand (Seed) * (StrawCol2 - StrawCol1)
                }
            }
            
            #declare Count = Count + 1;
        #end
        
        pigment { color rgb <0, 0.8, 0> }
    }

#end // CreateStraw

#end // STRAW_INC
