/********************************** papillon.inc ********************************/
/* This file is part of the source code for the openbridge project                                                   */
/* Copyright (c) 2003 Cyrille Berger (cberger.net) *************************************/

//*PMRawBegin
#include "colors.inc"
#include "woods.inc"
//*PMRawEnd


#declare fumee = material {
   texture {
      pigment {
         color rgbt <1, 1, 1, 1>
      }
   }
   
   interior {
      media {
         density {
            cylindrical
            turbulence <5, 5, 5>
            
            color_map {
               [ 0 color rgb <0, 0, 0>
               ]
               [ 0.15 color rgb <1, 1, 1>
               ]
               [ 0.85 color rgb <1, 1, 1>
               ]
               [ 1 color rgb <0, 0, 0>
               ]
            }
         }
         intervals 30
         samples 5,10
         confidence 0.9999
         variance 0.001
         absorption rgb <0.5, 0.5, 0.5>
         emission rgbft <1, 1, 1, 1, 1>
      }
   }
}

#declare porte = union {
   box {
      <-0.5, 0, -0.001>, <0.5, 2, 0.1>
      //*PMRawBegin
      texture { T_Wood35 }
      //*PMRawEnd
   }
   
   union {
      box {
         <0.45, -0.1, -0.1>, <0.65, 2, 0.1>
      }
      
      box {
         <-0.45, -0.1, -0.1>, <-0.65, 2, 0.1>
      }
      
      box {
         <0.55, 2.1, -0.1>, <-0.55, 1.9, 0.1>
      }
      
      cylinder {
         <0.55, 2, -0.1>, <0.55, 2, 0.1>, 0.1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-0.55, 2, -0.1>, <-0.55, 2, 0.1>, 0.1
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      pigment {
         color rgb <0.39, 0.41, 0.43>
      }
   }
}

#declare fenetre = union {
   box {
      <-1.5, 1, -0.05>, <1.5, 2, 0.05>
      
      pigment {
         color rgb <0.0823529, 0.647059, 0.952941>
      }
   }
   
   union {
      box {
         <1.4, 1, -0.1>, <1.6, 2, 0.1>
      }
      
      box {
         <-1.4, 1, -0.1>, <-1.6, 2, 0.1>
      }
      
      box {
         <1.5, 2.1, -0.1>, <-1.5, 1.9, 0.1>
      }
      
      box {
         <1.5, 1.1, -0.1>, <-1.5, 0.9, 0.1>
      }
      
      cylinder {
         <1.5, 2, -0.1>, <1.5, 2, 0.1>, 0.1
      }
      
      cylinder {
         <-1.5, 2, -0.1>, <-1.5, 2, 0.1>, 0.1
      }
      
      cylinder {
         <1.5, 1, -0.1>, <1.5, 1, 0.1>, 0.1
      }
      
      cylinder {
         <-1.5, 1, -0.1>, <-1.5, 1, 0.1>, 0.1
      }
      
      pigment {
         color rgb <0.39, 0.41, 0.43>
      }
   }
}

#declare poteau = union {
   cylinder {
      <0, 0, 0>, <0, 1.5, 0>, 0.1
   }
   
   sphere {
      <0, 1.5, 0>, 0.1
   }
}

#declare bateau = union {
   //*PMName bateau
   
   union {
      //*PMName pont
      
      cylinder {
         <0, 0, 0>, <0, 0.1, 0>, 8
         scale <1, 1, 0.5>
      }
      
      box {
         <-8, 0, -0.001>, <8, 0.1, 20>
      }
      
      cylinder {
         <0, 0, 0>, <0, 0.1, 0>, 8
         scale <1, 1, 3>
         translate z*20
      }
      scale <0.999, 1, 0.999>
      translate z*0.0001
      
      texture {
         brick
         
         texture {
            pigment {
               color rgb <0, 0, 0>
            }
         }
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         brick_size <8, 6, 2>
         mortar 0.1
      }
   }
   
   difference {
      //*PMName rembarde
      
      union {
         cylinder {
            <0, 0, 0>, <0, 1.5, 0>, 8
            scale <1, 1, 0.5>
         }
         
         box {
            <-8, 0, -0.001>, <8, 1.5, 20>
         }
         
         cylinder {
            <0, 0, 0>, <0, 1.5, 0>, 8
            scale <1, 1, 3>
            translate z*20
         }
      }
      
      union {
         cylinder {
            <0, 3, 0>, <0, -1, 0>, 7.9
            scale <1, 1, 0.5>
         }
         
         box {
            <-7.9, 3, -0.001>, <7.9, -1, 20>
         }
         
         cylinder {
            <0, 3, 0>, <0, -1, 0>, 7.9
            scale <1, 1, 3>
            translate z*20
         }
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
      
      pigment {
         color rgb <0, 0, 0>
      }
   }
   
   difference {
      //*PMName coque
      
      union {
         sphere {
            <0, 0, 0>, 8
            scale <1, 1, 3>
            translate z*20
         }
         
         sphere {
            <0, 0, 0>, 8
            scale <1, 1, 0.5>
         }
         
         cylinder {
            <0, 0, 20>, <0, 0, 0>, 8
         }
         scale <1, 0.5, 1>
      }
      
      box {
         <-10, 0, -10>, <10, 10, 50>
      }
      
      pigment {
         color rgb <0.631373, 0.631373, 0.631373>
      }
   }
   
   union {
      //*PMName batiment
      
      union {
         //*PMName poteauxhaut
         
         cylinder {
            //*PMName poteauhaut
            <3.4, 2.999, 0>, <3.4, 6.001, 0>, 0.05
         }
         
         cylinder {
            //*PMName poteauhaut
            <3.4, 2.999, 0>, <3.4, 6.001, 0>, 0.05
            rotate y*45
         }
         
         cylinder {
            //*PMName poteauhaut
            <3.4, 2.999, 0>, <3.4, 6.001, 0>, 0.05
            rotate y*90
         }
         
         cylinder {
            //*PMName poteauhaut
            <3.4, 2.999, 0>, <3.4, 6.001, 0>, 0.05
            rotate y*135
         }
         
         cylinder {
            //*PMName poteauhaut
            <3.4, 2.999, 0>, <3.4, 6.001, 0>, 0.05
            rotate y*180
         }
         translate z*7.5
      }
      
      union {
         cylinder {
            //*PMName poteaubas
            <0, -0.5, 0.1>, <0, 2.999, 0.1>, 0.05
         }
         
         cylinder {
            //*PMName poteaubas
            <2.5, -0.5, 0.1>, <2.5, 2.999, 0.1>, 0.05
         }
         
         cylinder {
            //*PMName poteaubas
            <-2.5, -0.5, 0.1>, <-2.5, 2.999, 0.1>, 0.05
         }
         
         cylinder {
            //*PMName poteaubas
            <-4.9, -0.5, 0.1>, <-4.9, 2.999, 0.1>, 0.05
         }
         
         cylinder {
            //*PMName poteaubas
            <-4.9, -0.5, 2.5>, <-4.9, 2.999, 2.5>, 0.05
         }
         
         cylinder {
            //*PMName poteaubas
            <4.9, -0.5, 0.1>, <4.9, 2.999, 0.1>, 0.05
         }
         
         cylinder {
            //*PMName poteaubas
            <4.9, -0.5, 2.5>, <4.9, 2.999, 2.5>, 0.05
         }
      }
      
      box {
         //*PMName terrasse
         <-5, 2.9, 5.001>, <5, 3, 0>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName bas
         <-5, -1, 5>, <5, 3, 20.001>
      }
      
      box {
         //*PMName haut
         <-3.5, 2, 10>, <3.5, 6.001, 20.001>
      }
      
      intersection {
         //*PMName toit
         
         union {
            cylinder {
               <0, 0, 7.5>, <0, 0, 20.001>, 5
               scale <1, 0.3, 1>
            }
            
            sphere {
               <0, 0, 7.5>, 5
               scale <1, 0.3, 1>
            }
            translate y*5
         }
         
         box {
            <-3.5, 6, 0>, <3.5, 10, 20.001>
         }
      }
      
      difference {
         //*PMName avant
         
         union {
            cylinder {
               <0, 5, 0>, <0, -0.5, 0>, 5
            }
            
            sphere {
               //*PMName toit
               <0, 0, 0>, 5
               scale <1, 0.3, 1>
               translate y*5
            }
            scale <1, 1, 3>
         }
         
         box {
            <-10, -1, -20>, <10, 9, 0>
         }
         translate z*20
      }
      
      union {
         //*PMName barrieregauche
         //*PMRawBegin
         #local zp=0.05;
         #while(zp < 20)
         	object { poteau translate <4.9, 3, zp> }
         	#declare zp = zp + 2;
         #end
         //*PMRawEnd
         
         box {
            <4.85, 3.8, 20.001>, <4.95, 3.4, 0.05>
         }
         
         box {
            <4.85, 4, 20.001>, <4.95, 4.4, 0.05>
         }
      }
      
      union {
         //*PMName barrieredroite
         //*PMRawBegin
         #local zp=0.05;
         #while(zp < 20)
         	object { poteau translate <-4.9, 3, zp> }
         	#declare zp = zp + 2;
         #end
         //*PMRawEnd
         
         box {
            <-4.85, 3.8, 20.001>, <-4.95, 3.4, 0.05>
         }
         
         box {
            <-4.85, 4, 20.001>, <-4.95, 4.4, 0.05>
         }
      }
      
      union {
         //*PMName barrierearriere
         //*PMRawBegin
         #local xp=-3;
         #while(xp < 4)
         	object { poteau translate <xp, 3, 0.05> }
         	#declare xp = xp + 2;
         #end
         //*PMRawEnd
         
         box {
            <4.9, 3.8, 0.15>, <-4.9, 3.4, 0.05>
         }
         
         box {
            <4.9, 4, 0.15>, <-4.9, 4.4, 0.05>
         }
      }
      
      pigment {
         spotted
         
         color_map {
            [ 0 color rgb <1, 0.0352941, 0>
            ]
            [ 0.35 color rgb <1, 1, 1>
            ]
            [ 1 color rgb <1, 1, 1>
            ]
         }
      }
      
      normal {
         //*PMRawBegin
         bumps 10
         //*PMRawEnd
         bump_size 0.1
      }
      
      finish {
         phong 0.2
         phong_size 40
         roughness 0.05
         reflection rgb <0, 0, 0>
      }
   }
   
   intersection {
      //*PMName cheminee
      
      difference {
         cylinder {
            <0, 5, 0>, <0, 0, 0>, 2
            rotate x*(-20)
         }
         
         cylinder {
            <0, 5.2, 0>, <0, 0, 0>, 1.8
            rotate x*(-20)
         }
      }
      
      box {
         <-2.1, 0, -4>, <2.1, 4, 4>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      pigment {
         gradient <0, 1, 0>
         
         color_map {
            [ 0 color rgb <1, 0, 0>
            ]
            [ 0.2 color rgb <1, 0, 0>
            ]
            [ 0.2 color rgb <0, 0, 0>
            ]
            [ 0.5 color rgb <0, 0, 0>
            ]
            [ 0.5 color rgb <1, 0, 0>
            ]
            [ 0.8 color rgb <1, 0, 0>
            ]
            [ 0.8 color rgb <0, 0, 0>
            ]
            [ 0.9 color rgb <0, 0, 0>
            ]
            [ 0.95 color rgb <1, 0, 0>
            ]
            [ 1 color rgb <1, 0, 0>
            ]
         }
         scale <1, 4, 1>
      }
      translate <0, 5.8, 18>
   }
   
   union {
      //*PMName portes
      
      object {
         //*PMName portearrierebas
         porte
         translate z*5
      }
      
      object {
         //*PMName portearrierehaut
         porte
         translate <0, 3, 10>
      }
      
      object {
         //*PMName porteavantgauchehaut
         porte
         translate <-4.25, 3, 20>
      }
      
      object {
         //*PMName porteavantdroitehaut
         porte
         translate <4.25, 3, 20>
      }
      
      object {
         //*PMName portelateralgauchebas
         porte
         rotate y*90
         translate <-5, 0, 10>
      }
      
      object {
         //*PMName portelateralgauchebas
         porte
         rotate y*90
         translate <-5, 0, 20>
      }
      
      object {
         //*PMName portelateralgauchehaut
         porte
         rotate y*90
         translate <-3.5, 3, 15>
      }
      
      object {
         //*PMName portelateraldroitebas
         porte
         rotate y*(-90)
         translate <5, 0, 10>
      }
      
      object {
         //*PMName portelateralgauchebas
         porte
         rotate y*(-90)
         translate <5, 0, 20>
      }
      
      object {
         //*PMName portelateralgauchehaut
         porte
         rotate y*(-90)
         translate <3.5, 3, 15>
      }
   }
   
   object {
      //*PMName fenetrearrieredroitbas
      fenetre
      translate <2.5, 0, 5>
   }
   
   object {
      //*PMName fenetrearrieredroitbas
      fenetre
      translate <-2.5, 0, 5>
   }
   
   object {
      //*PMName fenetrelatteralgauchebas
      fenetre
      rotate y*90
      translate <-5, 0, 7.5>
   }
   
   object {
      //*PMName fenetrelatteralgauchebas
      fenetre
      rotate y*90
      translate <-5, 0, 13>
   }
   
   object {
      //*PMName fenetrelatteralgauchebas
      fenetre
      rotate y*90
      translate <-5, 0, 17>
   }
   
   object {
      //*PMName fenetrelatteraldroitbas
      fenetre
      rotate y*(-90)
      translate <5, 0, 7.5>
   }
   
   object {
      //*PMName fenetrelatteraldroitbas
      fenetre
      rotate y*(-90)
      translate <5, 0, 13>
   }
   
   object {
      //*PMName fenetrelatteraldroitbas
      fenetre
      rotate y*(-90)
      translate <5, 0, 17>
   }
   
   object {
      //*PMName fenetrelatteraldroithaut
      fenetre
      rotate y*(-90)
      translate <3.5, 3, 12.5>
   }
   
   object {
      //*PMName fenetrelatteraldroithaut
      fenetre
      rotate y*(-90)
      translate <3.5, 3, 17.5>
   }
   
   object {
      //*PMName fenetrelatteralgauchehaut
      fenetre
      rotate y*90
      translate <-3.5, 3, 12.5>
   }
   
   object {
      //*PMName fenetrelatteralgauchehaut
      fenetre
      rotate y*90
      translate <-3.5, 3, 17.5>
   }
   
   sphere {
      <0, 0, 0>, 6
      
      material {
         fumee
      }
      scale <0.6, 1.2, 0.6>
      rotate x*(-60)
      translate <0, 14.708, 11.0767>
      hollow
   }
}
