/********************************** papillon.inc ********************************/
/* This file is part of the source code for the openbridge project                                                   */
/* Copyright (c) 2003 Cyrille Berger (cberger.net) *************************************/

//*PMRawBegin
#include "colors.inc"
#include "woods.inc"
//*PMRawEnd


#declare ponthoriz = union {
   //*PMRawBegin
   #local i = 0;
   #while(i<36)
     union {
       box { <-7, -0.5, -0.95>, < 7, 0, 0.95>
         texture { T_Wood34 } }
       cylinder { < 0, 0,-0.01>, < 0, 0, 2>, 0.1
         rotate -x*90
         texture { T_Wood34 }
         translate x*6.9 }
       cylinder { < 0, 0,-0.01>, < 0, 0, 2>, 0.1
         rotate -x*90
         texture { T_Wood34 }
         translate x*-6.9 }
       difference {
         torus { 1, 0.05 translate 0.3*x }
         box { <0,-2,-2>, <2,2,2> }
         rotate z*90
         translate <6.9, 1.9,1>
         pigment { color Yellow}
       }
       difference {
         torus { 1, 0.05 translate 0.3*x }
         box { <0,-2,-2>, <2,2,2> }
         rotate z*90
         translate <-6.9, 1.9,1>
         pigment { color Yellow}
       }
       translate z*(-31+2*i) }
     #local i = i + 1;
   #end
   //*PMRawEnd
}

#declare pontouv = union {
   box {
      <4.5, -0.1, 0>, <3.5, 0.9, 21.5>
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
   }
   
   box {
      <-4.5, -0.1, 0>, <-3.5, 0.9, 21.5>
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
   }
   
   cylinder {
      <0, 0, 6>, <0, 0, -6>, 1
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
      rotate y*90
      translate <0, 0, 0>
   }
   //*PMRawBegin
   #local i = 1;
   #while(i<12)
     union {
       box { <-5, -0.5, -0.95>, < 5, 0, 0.95>
         texture { T_Wood34 } }
       cylinder { < 0, 0,-0.01>, < 0, 0, 2>, 0.1
         rotate -x*90
         texture { T_Wood34 }
         translate x*4.9 }
       cylinder { < 0, 0,-0.01>, < 0, 0, 2>, 0.1
         rotate -x*90
         texture { T_Wood34 }
         translate x*-4.9 }
       #if(i != 1)
       difference {
         torus { 1, 0.05 translate 0.3*x }
         box { <0,-2,-2>, <2,2,2> }
         rotate z*90
         translate <4.9, 1.9,-1>
         pigment { color Yellow}
       }
       difference {
         torus { 1, 0.05 translate 0.3*x }
         box { <0,-2,-2>, <2,2,2> }
         rotate z*90
         translate <-4.9, 1.9,-1>
         pigment { color Yellow}
       }
       #end
       translate z*(2*i-.5)+y }
     #local i = i + 1;
   #end
   //*PMRawEnd
}

#declare tourcentrale = union {
   //*PMName tourcentrale
   
   union {
      //*PMName echelle
      
      cylinder {
         <0, 0, 0>, <0, 0, 27>, 0.1
         //*PMRawBegin
         texture { T_Wood35 }
         //*PMRawEnd
         translate x*0.6
      }
      
      cylinder {
         <0, 0, 0>, <0, 0, 27>, 0.1
         //*PMRawBegin
         texture { T_Wood35 }
         //*PMRawEnd
         translate x*(-0.6)
      }
      //*PMRawBegin
      #local i = 1;
      #while(i<88)
      cylinder { 
      	-0.6*z, 0.6*z, 0.1
      	texture { T_Wood35 }
      	rotate y*90
      	translate 0.3*i*z
      }
      #local i = i + 1;
      #end
      //*PMRawEnd
      rotate y*90
      rotate z*75
      translate <-1.85, 3.5, -1>
   }
   
   union {
      //*PMName plancher
      
      box {
         //*PMName rembarde
         <-4, 4.5, -4>, <-3.9, 3, 4>
      }
      
      box {
         //*PMName rembarde
         <-4, 4.5, -4>, <-3.9, 3, 4>
         rotate y*90
      }
      
      box {
         //*PMName rembarde
         <-4, 4.5, -4>, <-3.9, 3, 4>
         rotate y*180
      }
      
      box {
         //*PMName rembarde
         <-4, 4.5, -4>, <-3.9, 3, 4>
         rotate y*(-90)
      }
      
      box {
         //*PMName plancher
         <4, 4.5, 4>, <-4, 5, 0>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName plancher
         <4, 4.5, 4>, <1.7, 5, -4>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName plancher
         <-1.7, 4.5, 4>, <-4, 5, -4>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName plancher
         <4, 4.5, -2>, <-4, 5, -4>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      //*PMRawBegin
      texture { T_Wood35 }
      //*PMRawEnd
   }
   
   union {
      //*PMName manivelle
      
      box {
         <3.8, 1, 2>, <1.8, 4.5, 3.999>
         //*PMRawBegin
         texture { T_Wood33 }
         //*PMRawEnd
      }
      
      box {
         <-3.8, 1, 2>, <-1.8, 4.5, 3.999>
         //*PMRawBegin
         texture { T_Wood33 }
         //*PMRawEnd
      }
      
      cylinder {
         <2, 2, 3>, <-2, 2, 3>, 1
         
         pigment {
            checker 
            color rgb <0.662745, 0.560784, 0.0431373>
            color rgb <0.933333, 0.670588, 0>
            scale <0.01, 1, 1>
         }
      }
   }
   
   cylinder {
      //*PMName grandepoutre
      <0, 0, 0>, <0, 0, 50>, 1
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
      rotate x*(-80)
      translate z*4
      rotate y*45
   }
   
   cylinder {
      //*PMName grandepoutre
      <0, 0, 0>, <0, 0, 50>, 1
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
      rotate x*(-80)
      translate z*4
      rotate y*135
   }
   
   cylinder {
      //*PMName grandepoutre
      <0, 0, 0>, <0, 0, 50>, 1
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
      rotate x*(-80)
      translate z*4
      rotate y*225
   }
   
   cylinder {
      //*PMName grandepoutre
      <0, 0, 0>, <0, 0, 50>, 1
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
      rotate x*(-80)
      translate z*4
      rotate y*(-45)
   }
   
   union {
      //*PMName poutrelles
      
      box {
         <-0.5, -0.5, -9>, <0.5, 0.5, 9>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <8.5, 45, 0>
      }
      
      box {
         <-0.5, -0.5, -8.5>, <0.5, 0.5, 8.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7.8, 40, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -7.6>, <0.5, 0.5, 7.6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7, 35, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -46.8>, <0.5, 0.5, 6.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <6.5, 30, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6>, <0.5, 0.5, 6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <5.8, 25, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -5.5>, <0.5, 0.5, 5.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <5.2, 20, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4.8>, <0.5, 0.5, 4.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4.6, 15, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4, 10, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <3.4, 5, 0>
         hollow
      }
   }
   
   union {
      //*PMName poutrelles
      
      box {
         <-0.5, -0.5, -9>, <0.5, 0.5, 9>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <8.5, 45, 0>
      }
      
      box {
         <-0.5, -0.5, -8.5>, <0.5, 0.5, 8.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7.8, 40, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -7.6>, <0.5, 0.5, 7.6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7, 35, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6.8>, <0.5, 0.5, 6.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <6.5, 30, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4.8>, <0.5, 0.5, 4.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4.6, 15, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4, 10, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <3.4, 5, 0>
         hollow
      }
      rotate y*90
   }
   
   union {
      //*PMName poutrelles
      
      box {
         <-0.5, -0.5, -9>, <0.5, 0.5, 9>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <8.5, 45, 0>
      }
      
      box {
         <-0.5, -0.5, -8.5>, <0.5, 0.5, 8.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7.8, 40, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -7.6>, <0.5, 0.5, 7.6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7, 35, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6.8>, <0.5, 0.5, 46.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <6.5, 30, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6>, <0.5, 0.5, 6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <5.8, 25, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -5.5>, <0.5, 0.5, 5.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <5.2, 20, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4.8>, <0.5, 0.5, 4.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4.6, 15, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4, 10, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <3.4, 5, 0>
         hollow
      }
      rotate y*180
   }
   
   union {
      //*PMName poutrelles
      
      box {
         <-0.5, -0.5, -9>, <0.5, 0.5, 9>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <8.5, 45, 0>
      }
      
      box {
         <-0.5, -0.5, -8.5>, <0.5, 0.5, 8.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7.8, 40, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -7.6>, <0.5, 0.5, 7.6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7, 35, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6.8>, <0.5, 0.5, 6.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <6.5, 30, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4.8>, <0.5, 0.5, 4.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4.6, 15, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4, 10, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <3.4, 5, 0>
         hollow
      }
      rotate y*(-90)
   }
   rotate x*180
   translate y*48
}

#declare tourext = union {
   //*PMName tourext
   
   cylinder {
      //*PMName grandepoutre
      <0, 0, 0>, <0, 0, 50>, 1
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
      rotate x*(-80)
      translate z*4
      rotate y*45
   }
   
   cylinder {
      //*PMName grandepoutre
      <0, 0, 0>, <0, 0, 50>, 1
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
      rotate x*(-80)
      translate z*4
      rotate y*135
   }
   
   cylinder {
      //*PMName grandepoutre
      <0, 0, 0>, <0, 0, 50>, 1
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
      rotate x*(-80)
      translate z*4
      rotate y*225
   }
   
   cylinder {
      //*PMName grandepoutre
      <0, 0, 0>, <0, 0, 50>, 1
      //*PMRawBegin
      texture { T_Wood34 }
      //*PMRawEnd
      rotate x*(-80)
      translate z*4
      rotate y*(-45)
   }
   
   union {
      //*PMName poutrelles
      
      box {
         <-0.5, -0.5, -9>, <0.5, 0.5, 9>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <8.5, 45, 0>
      }
      
      box {
         <-0.5, -0.5, -8.5>, <0.5, 0.5, 8.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7.8, 40, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -7.6>, <0.5, 0.5, 7.6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7, 35, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6.8>, <0.5, 0.5, 6.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <6.5, 30, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6>, <0.5, 0.5, 6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <5.8, 25, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -5.5>, <0.5, 0.5, 5.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <5.2, 20, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4.8>, <0.5, 0.5, 4.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4.6, 15, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4, 10, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <3.4, 5, 0>
         hollow
      }
   }
   
   union {
      //*PMName poutrelles
      
      box {
         <-0.5, -0.5, -9>, <0.5, 0.5, 9>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <8.5, 45, 0>
      }
      
      box {
         <-0.5, -0.5, -8.5>, <0.5, 0.5, 8.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7.8, 40, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -7.6>, <0.5, 0.5, 7.6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7, 35, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6.8>, <0.5, 0.5, 6.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <6.5, 30, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4.8>, <0.5, 0.5, 4.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4.6, 15, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4, 10, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <3.4, 5, 0>
         hollow
      }
      rotate y*90
   }
   
   union {
      //*PMName poutrelles
      
      box {
         <-0.5, -0.5, -9>, <0.5, 0.5, 9>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <8.5, 45, 0>
      }
      
      box {
         <-0.5, -0.5, -8.5>, <0.5, 0.5, 8.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7.8, 40, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -7.6>, <0.5, 0.5, 7.6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7, 35, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6.8>, <0.5, 0.5, 6.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <6.5, 30, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6>, <0.5, 0.5, 6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <5.8, 25, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -5.5>, <0.5, 0.5, 5.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <5.2, 20, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4.8>, <0.5, 0.5, 4.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4.6, 15, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4, 10, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <3.4, 5, 0>
         hollow
      }
      rotate y*180
   }
   
   union {
      //*PMName poutrelles
      
      box {
         <-0.5, -0.5, -9>, <0.5, 0.5, 9>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <8.5, 45, 0>
      }
      
      box {
         <-0.5, -0.5, -8.5>, <0.5, 0.5, 8.5>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7.8, 40, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -7.6>, <0.5, 0.5, 7.6>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <7, 35, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -6.8>, <0.5, 0.5, 6.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <6.5, 30, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4.8>, <0.5, 0.5, 4.8>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4.6, 15, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <4, 10, 0>
         hollow
      }
      
      box {
         <-0.5, -0.5, -4>, <0.5, 0.5, 4>
         //*PMRawBegin
         texture { T_Wood34 }
         //*PMRawEnd
         translate <3.4, 5, 0>
         hollow
      }
      rotate y*(-90)
   }
   rotate x*180
   translate y*48
}

#declare pontouvrable = union {
   object {
      //*PMName pont12
      ponthoriz
      translate <0, 19, 55>
   }
   
   object {
      //*PMName pont2m
      pontouv
      rotate x*(-60)
      rotate y*180
      translate <0, 18, 22.5>
   }
   
   cylinder {
      //*PMName cable2m1
      <-1.9, 46.75, 26.44>, <-4, 36.5, 12.5>, 0.05
      
      pigment {
         color rgb <0.984314, 1, 0>
      }
   }
   
   cylinder {
      //*PMName cable2m2
      <1.9, 46.75, 26.44>, <4, 36.5, 12.5>, 0.05
      
      pigment {
         color rgb <0.984314, 1, 0>
      }
   }
   
   cylinder {
      <0, 0, 7>, <0, 0, 5.5>, 1.2
      //*PMRawBegin
      texture { T_Wood35 }
      //*PMRawEnd
      rotate y*90
      translate <0, 18, 22.5>
   }
   
   cylinder {
      <0, 0, -7>, <0, 0, -5.5>, 1.2
      //*PMRawBegin
      texture { T_Wood35 }
      //*PMRawEnd
      rotate y*90
      translate <0, 18, 22.5>
   }
   
   object {
      //*PMName pont3m
      pontouv
      rotate x*(-60)
      translate <0, 18, -22.5>
   }
   
   cylinder {
      //*PMName cable3m1
      <-1.9, 46.75, -26.44>, <-4, 36.5, -12.5>, 0.05
      
      pigment {
         color rgb <0.984314, 1, 0>
      }
   }
   
   cylinder {
      //*PMName cable2m2
      <1.9, 46.75, -26.44>, <4, 36.5, -12.5>, 0.05
      
      pigment {
         color rgb <0.984314, 1, 0>
      }
   }
   
   cylinder {
      <0, 0, 7>, <0, 0, 5.5>, 1.2
      //*PMRawBegin
      texture { T_Wood35 }
      //*PMRawEnd
      rotate y*90
      translate <0, 18, -22.5>
   }
   
   cylinder {
      <0, 0, -7>, <0, 0, -5.5>, 1.2
      //*PMRawBegin
      texture { T_Wood35 }
      //*PMRawEnd
      rotate y*90
      translate <0, 18, -22.5>
   }
   
   object {
      //*PMName pont34
      ponthoriz
      rotate y*180
      translate <0, 19, -55>
   }
   
   object {
      //*PMName tour1
      tourext
      translate z*80
   }
   
   object {
      //*PMName tour2
      tourcentrale
      translate z*30
   }
   
   object {
      //*PMName tour3
      tourcentrale
      rotate y*180
      translate z*(-30)
   }
   
   object {
      //*PMName tour4
      tourext
      translate z*(-80)
   }
}


