//*PMRawBegin
#include "glass.inc"

#declare Debug=0;
//*PMRawEnd

global_settings {
   adc_bailout 0.0039216
   
   radiosity {
      count 100
      recursion_limit 5
   }
}

#declare Media = media {
   density {
      bozo
      
      color_map {
         [ 0.3 color rgb <0, 0, 0>
         ]
         [ 1 color rgb <0.0784314, 0.0784314, 0.0784314>
         ]
      }
      scale <0.05, 0.05, 0.05>
   }
   
   scattering {
      4, rgb <0.145098, 0.145098, 0.0862745>
   }
}

media {
   Media
}

#declare texBlackPlastic = texture {
   pigment {
      color rgb <0, 0, 0>
   }
   
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.6
      phong 0.8
      phong_size 25
      reflection rgb <0.12549, 0.12549, 0.12549>
   }
   
   normal {
      granite
      0.1
   }
}

#declare LightWood = pigment {
   granite
   
   color_map {
      [ 0.2 color rgb <0.376471, 0.196078, 0.0235294>
      ]
      [ 0.25 color rgb <0.745098, 0.384314, 0.0509804>
      ]
   }
   scale <0.3, 1, 20>
   rotate <0, 0, 0>
}

#declare DarkWood = pigment {
   granite
   
   color_map {
      [ 0.2 color rgb <0.486275, 0.113725, 0.0666667>
      ]
      [ 0.25 color rgb <0.670588, 0.254902, 0.117647>
      ]
   }
   scale <0.3, 1, 20>
   rotate <0, 0, 0>
}

#declare texTableRedWood = texture {
   pigment {
      wood
      
      pigment_map {
         [ 0.4 LightWood
         ]
         [ 0.6 DarkWood
         ]
      }
      scale <1, 1, 1>
      rotate <2, 0, 0>
      translate <0, -10, 0>
      scale <0.2, 0.2, 0.2>
      
      warp {
         repeat
         <1, 0, 0>
         offset <0, 0, 0>
         flip <1, 0, 0>
      }
      
      warp {
         turbulence <0.05, 0.05, 0.05>
         omega 0.1
      }
   }
   
   finish {
      //*PMRawBegin
      reflection {0.01 0.3}
      //*PMRawEnd
   }
}

#declare texGreenPlastic = texture {
   pigment {
      color rgbf <0.019608, 0.61961, 0.031373, 0.2>
   }
   
   finish {
      ambient rgb <0, 0, 0>
      phong 0.8
      phong_size 25
      reflection rgb <0, 0, 0>
   }
}

#declare texRedPlastic = texture {
   pigment {
      color rgbf <1, 0, 0, 0.2>
   }
   
   finish {
      ambient rgb <0, 0, 0>
      phong 0.8
      phong_size 25
      reflection rgb <0, 0, 0>
   }
}

#declare texWhitePlastic = texture {
   pigment {
      color rgbt <1, 1, 1, 0.3>
   }
   
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.6
      phong 0.8
      phong_size 25
      reflection rgb <0.231373, 0.231373, 0.231373>
   }
}

#declare texWall = texture {
   pigment {
      image_map {
         png
         "wall.png"
         map_type 0
      }
   }
   
   finish {
      ambient rgb <0.027451, 0.027451, 0.027451>
   }
}

#declare texCrome = texture {
   pigment {
      color rgb <0.784314, 0.784314, 0.784314>
   }
   
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.2
      phong 0.2
      phong_size 2
      metallic 1
      reflection rgb <0.603922, 0.603922, 0.603922>
   }
}

#declare matDefault = material {
   texture {
      pigment {
         color rgb <0.721569, 0.756863, 0.482353>
      }
      
      finish {
         ambient rgb <0, 0, 0>
      }
   }
}

#declare matOldGlass = material {
   texture {
      pigment {
         leopard
         
         color_map {
            [ 0.45 color rgbt <0.44706, 0.56471, 0.45882, 0.8>
            ]
            [ 0.55 color rgbt <0.26667, 0.33726, 0.27451, 0.8>
            ]
         }
      }
      
      finish {
         ambient rgb <0, 0, 0>
         specular 0
         roughness 0.05
         reflection rgb <0.0784314, 0.0784314, 0.0784314>
      }
      scale <0.01, 0.01, 0.01>
   }
}

#declare matOldGlass_Inner = material {
   texture {
      pigment {
         leopard
         
         color_map {
            [ 0.45 color rgb <0.44706, 0.56471, 0.45882>
            ]
            [ 0.55 color rgb <0.26667, 0.33726, 0.27451>
            ]
         }
      }
      
      finish {
         ambient rgb <0, 0, 0>
         phong 0.8
         phong_size 10
         reflection rgb <0.145098, 0.145098, 0.145098>
      }
      scale <0.01, 0.01, 0.01>
   }
}

#declare texFrontPanel = texture {
   pigment {
      wood
      turbulence <0.07, 0.07, 0.07>
      
      color_map {
         [ 0.4 color rgb <0.490196, 0.196078, 0.137255>
         ]
         [ 0.5 color rgb <0.709804, 0.443137, 0.196078>
         ]
      }
      
      warp {
         repeat
         <0, 2, 0>
         offset <0, 0, 0>
         flip <0, 0, 0>
      }
   }
   
   finish {
      ambient rgb <0, 0, 0>
      phong 0.7
      phong_size 10
      reflection rgb <0.0980392, 0.0980392, 0.0980392>
   }
}

#declare texTableWood = texture {
   pigment {
      wood
      turbulence <0.8, 0.8, 0.8>
      omega 0.8
      
      color_map {
         [ 0.1 color rgb <0.364706, 0.184314, 0.0862745>
         ]
         [ 0.4 color rgb <0.545098, 0.270588, 0.12549>
         ]
         [ 0.5 color rgb <0.709804, 0.462745, 0.196078>
         ]
         [ 0.55 color rgb <0.709804, 0.462745, 0.196078>
         ]
         [ 0.6 color rgb <0.364706, 0.184314, 0.0862745>
         ]
         [ 0.65 color rgb <0.709804, 0.462745, 0.196078>
         ]
         [ 0.75 color rgb <0.709804, 0.462745, 0.196078>
         ]
         [ 0.85 color rgb <0.364706, 0.184314, 0.0862745>
         ]
         [ 0.95 color rgb <0.709804, 0.462745, 0.196078>
         ]
         [ 1 color rgb <0.364706, 0.184314, 0.0862745>
         ]
      }
      scale <0.03, 0.05, 0.05>
      rotate <1, 0, 0>
   }
   
   finish {
      ambient rgb <0, 0, 0>
      phong 0.7
      phong_size 10
      reflection rgb <0.0980392, 0.0980392, 0.0980392>
   }
}

#declare matTable = material {
   texture {
      bozo
      turbulence <0.1, 0, 0.1>
      
      texture_map {
         [ 0.6 pigment {
            wood
            turbulence <0.08, 0.01, 0.08>
            omega 0.8
            
            color_map {
               [ 0.1 color rgb <0.364706, 0.184314, 0.0862745>
               ]
               [ 0.4 color rgb <0.545098, 0.270588, 0.12549>
               ]
               [ 0.5 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 0.55 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 0.6 color rgb <0.364706, 0.184314, 0.0862745>
               ]
               [ 0.65 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 0.75 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 0.85 color rgb <0.364706, 0.184314, 0.0862745>
               ]
               [ 0.95 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 1 color rgb <0.364706, 0.184314, 0.0862745>
               ]
            }
            scale <0.03, 0.05, 0.05>
            rotate <1, 0, 0>
            
            warp {
               repeat
               <4, 0, 0>
               offset <0.6, 0, 0>
               flip <0.6, 0, 0>
            }
         }
         
         finish {
            ambient rgb <0, 0, 0>
            phong 0.7
            phong_size 10
            reflection rgb <0.0980392, 0.0980392, 0.0980392>
         }
         ]
         [ 0.65 pigment {
            wood
            turbulence <0.08, 0.01, 0.08>
            omega 0.8
            
            color_map {
               [ 0.1 color rgb <0.364706, 0.184314, 0.0862745>
               ]
               [ 0.4 color rgb <0.545098, 0.270588, 0.12549>
               ]
               [ 0.5 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 0.55 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 0.6 color rgb <0.364706, 0.184314, 0.0862745>
               ]
               [ 0.65 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 0.75 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 0.85 color rgb <0.364706, 0.184314, 0.0862745>
               ]
               [ 0.95 color rgb <0.709804, 0.462745, 0.196078>
               ]
               [ 1 color rgb <0.364706, 0.184314, 0.0862745>
               ]
            }
            scale <0.03, 0.05, 0.05>
            rotate <1, 0, 0>
            
            warp {
               repeat
               <4, 0, 0>
               offset <0.6, 0, 0>
               flip <0.6, 0, 0>
            }
         }
         
         finish {
            ambient rgb <0, 0, 0>
            diffuse 0.6
            phong 0.7
            phong_size 10
            reflection rgb <0.0392157, 0.0392157, 0.0392157>
         }
         ]
      }
   }
}

#declare PenBlue = intersection {
   prism {
      linear_spline
      linear_sweep
      0, 30,
      7,
      <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
      
      texture {
         pigment {
            color rgb <0.0156863, 0.0156863, 1>
         }
         
         finish {
            phong 0.3
            phong_size 40
         }
      }
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cone {
      <0, 30, 0>, 0,
      <0, 0, 0>, 7.5
      
      texture {
         pigment {
            gradient <0, 1, 0>
            
            color_map {
               [ 0.6 color rgb <1, 0.772549, 0.345098>
               ]
               [ 0.6 color rgb <0, 0, 0>
               ]
            }
            scale <1, 5, 1>
            translate <0, 30, 0>
         }
      }
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   scale <0.1, 0.1, 0.1>
   translate <0, -3.71548, -0.285806>
}

#declare PenRed = intersection {
   prism {
      linear_spline
      linear_sweep
      0, 30,
      7,
      <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
      
      texture {
         pigment {
            color rgb <0.909804, 0.176471, 0.0313725>
         }
         
         finish {
            phong 0.3
            phong_size 40
         }
      }
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cone {
      <0, 30, 0>, 0,
      <0, 0, 0>, 7.5
      
      texture {
         pigment {
            gradient <0, 1, 0>
            
            color_map {
               [ 0.6 color rgb <1, 0.772549, 0.345098>
               ]
               [ 0.6 color rgb <0, 0, 0>
               ]
            }
            scale <1, 5, 1>
            translate <0, 30, 0>
         }
      }
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   scale <0.1, 0.1, 0.1>
   translate <0, -3.71548, -0.285806>
}

#declare PenGreen = intersection {
   prism {
      linear_spline
      linear_sweep
      0, 30,
      7,
      <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
      
      texture {
         pigment {
            color rgb <0.113725, 0.858824, 0.0117647>
         }
         
         finish {
            phong 0.3
            phong_size 40
         }
      }
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cone {
      <0, 30, 0>, 0,
      <0, 0, 0>, 7.5
      
      texture {
         pigment {
            gradient <0, 1, 0>
            
            color_map {
               [ 0.6 color rgb <1, 0.772549, 0.345098>
               ]
               [ 0.6 color rgb <0, 0, 0>
               ]
            }
            scale <1, 5, 1>
            translate <0, 30, 0>
         }
      }
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   scale <0.1, 0.1, 0.1>
   translate <0, -3.71548, -0.285806>
}

#declare PenYellow = intersection {
   prism {
      linear_spline
      linear_sweep
      0, 30,
      7,
      <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
      
      texture {
         pigment {
            color rgb <1, 0.482353, 0>
         }
         
         finish {
            phong 0.3
            phong_size 40
         }
      }
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cone {
      <0, 30, 0>, 0,
      <0, 0, 0>, 7.5
      
      texture {
         pigment {
            gradient <0, 1, 0>
            
            color_map {
               [ 0.6 color rgb <1, 0.772549, 0.345098>
               ]
               [ 0.6 color rgb <0, 0, 0>
               ]
            }
            scale <1, 5, 1>
            translate <0, 30, 0>
         }
      }
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   scale <0.1, 0.1, 0.1>
   translate <0, -3.71548, -0.285806>
}

#declare simpleStakan = difference {
   cone {
      <0, 2, 0>, 0.7,
      <0, 0, 0>, 0.5
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cone {
      <0, 2.01, 0>, 0.68,
      <0, 0.1, 0>, 0.48
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      texWhitePlastic
   }
   translate <4.38401, -4, 1.5316>
}
//*PMRawBegin
#declare s_height = 2.0;
#declare s_r_top = 0.7;
#declare s_r_bottom = 0.5;
#declare s_glass_thick = 0.05;
#declare s_num_gran = 20;
#declare s_space_top = 0.15;
#declare s_space_bottom = 0.1;

#declare complexStakan=difference
{ cone { <0,0,0>,s_r_bottom,<0,s_height,0>,s_r_top }
  cone { <0,s_glass_thick,0>, (s_r_bottom-s_glass_thick), <0,(s_height+s_glass_thick),0>, (s_r_top-s_glass_thick) }

      
#declare i = s_num_gran;      
#declare DAngle = 360/s_num_gran;

#while(i > 0)
	superellipsoid {
		<1/4, 1/4>
		//pigment {Red}
		      
		translate y	
		scale .5
		
		scale <s_glass_thick*2, sqrt((s_height-s_space_top-s_space_bottom)*(s_height-s_space_top-s_space_bottom) + (s_r_top-s_r_bottom)*(s_r_top-s_r_bottom)), s_r_bottom>
		translate y*s_space_bottom
		                 
		rotate z*degrees( -atan2((s_r_top-s_r_bottom), s_height) )
		translate x*s_r_bottom + s_glass_thick/2 
		
		rotate y*i*DAngle		
	}
	#declare i = i - 1;
#end

	//pigment { color rgb <.75, .75, .75> }
	texture {
		pigment { Col_Glass_Old }
		finish { F_Glass6 }
	}
	interior { I_Glass1 }
  //pigment { color rgbt <1, 1, 1, 0.75> }
  //pigment { color rgb <.75, .75, .75> }

  translate <4.38401, -4, 1.5316>
}
//*PMRawEnd

#declare Karandashi = union {
   //*PMRawBegin
   #if(Debug=1)
   	object {simpleStakan}
   #else
   	object {complexStakan}
   #end
   //*PMRawEnd
   
   object {
      PenBlue
      scale <1, 1, 1>
      rotate <-5.3, 30.4, -10.3>
      translate <5.19665, -0.29929, 1.57486>
   }
   
   object {
      PenRed
      scale <1, 1, 1>
      rotate <56.3, 69.1, 55.7>
      translate <4.50796, -0.464435, 2.61876>
   }
   
   object {
      PenGreen
      scale <1, 1, 1>
      rotate <-15.9, -46.5, 23.9>
      translate <3.6083, -0.303669, 1.21468>
   }
}

#declare Lamp = union {
   union {
      sphere {
         <0, 0, 0>, 0.5
         
         texture {
            texRedPlastic
         }
         scale <1, 0.3, 1>
         rotate <0, 0, 0>
         translate <0, 0.6, 0>
      }
      
      cylinder {
         <0, 0.6, 0>, <0, 0.3, 0>, 0.5
         
         texture {
            texRedPlastic
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      torus {
         0.6, 0.1
         
         texture {
            texCrome
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0.3, 0>
      }
      
      cylinder {
         <0, 0.3, 0>, <0, -0.5, 0>, 0.65
         
         texture {
            texCrome
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      scale <0.4, 0.4, 0.4>
      translate <0.0667611, 0.61577, -1.02787>
   }
   
   union {
      cylinder {
         <0, 0.5, 0>, <0, 0, 0>, 1.5
         
         texture {
            texCrome
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cone {
         <0, 0.8, 0>, 0.5,
         <0, 0.5, 0>, 1.4
         
         texture {
            texGreenPlastic
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.82, 0>, <0, 0.7, 0>, 0.5
         
         texture {
            texCrome
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 1, 0>, <0, 0.7, 0>, 0.35
         
         texture {
            texCrome
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   union {
      difference {
         union {
            sphere {
               <0, 0, 0>, 0.2
               scale <1, 1, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 4, 0>, <0, 0, 0>, 0.2
               scale <1, 1, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 4, 0>, 0.2
               scale <1, 1, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
         }
         
         box {
            <-0.04, -0.25, -0.25>, <0.04, 4.25, 0.25>
            scale <1, 1, 1>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            texCrome
         }
      }
      
      union {
         intersection {
            union {
               sphere {
                  <0, 0, 0>, 0.2
                  scale <1, 1, 1>
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 4, 0>, <0, 0, 0>, 0.2
                  scale <1, 1, 1>
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 4, 0>, 0.2
                  scale <1, 1, 1>
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
            }
            
            box {
               <-0.04, -0.25, -0.25>, <0.04, 4.25, 0.25>
               scale <1, 1, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            texture {
               texCrome
            }
         }
         
         union {
            light_source {
               <0, 0, 0>, rgb <0.870588, 0.784314, 0.435294>
               spotlight
               radius 10
               falloff 70
               point_at <0, -8, 1>
               fade_distance 6
               fade_power 1
            }
            
            light_source {
               <0, 0, 0>, rgb <1, 0.866667, 0.670588>
               area_light <0.2, 0, 0>, <0, 0.1, 0>, 6, 6
               jitter
               fade_distance 4
               fade_power 1
            }
            
            sphere {
               <0, 0, 0>, 0.5
               
               texture {
                  pigment {
                     color rgb <1, 0.992157, 0.811765>
                  }
                  
                  finish {
                     ambient rgb <10, 10, 10>
                     diffuse 0
                  }
               }
               scale <0.4, 0.4, 0.4>
               rotate <0, 0, 0>
               translate <0, -0.3, 0>
               no_shadow
            }
            
            cone {
               <0, 0.5, 0>, 0,
               <0, -0.5, 0>, 0.8
               open
               
               texture {
                  texGreenPlastic
               }
               scale <1, 1, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
               hollow false
            }
            
            intersection {
               difference {
                  cylinder {
                     <0, 0.2, 0>, <0, -0.2, 0>, 0.2
                     scale <1, 1, 1>
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0.05, 0>, <0, -0.05, 0>, 0.2
                     scale <1, 1, 1>
                     rotate <0, 0, 90>
                     translate <0, 0.1, 0>
                  }
               }
               
               union {
                  sphere {
                     <0, 0, 0>, 0.22
                     scale <1, 1, 1>
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  box {
                     <-0.25, 0, -0.25>, <0.25, -0.25, 0.25>
                     scale <1, 1, 1>
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
               }
               translate <0, 0.5, 0>
            }
            
            texture {
               texCrome
            }
            translate <0, -0.6, 0>
            rotate <90, 0, 0>
            translate <0, 4, 0>
            hollow
         }
         rotate <-90, 0, 0>
         translate <0, 4, 0>
      }
      rotate <45, 0, 0>
      translate <0, 1, 0>
   }
   rotate <0, 62, 0>
   scale <1.5, 1.5, 1.5>
   translate <8.64124, -4.05408, 4.76521>
}

#declare Antenna = union {
   union {
      cylinder {
         <0, 0.3, 0>, <0, 0, 0>, 2
         
         texture {
            texCrome
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cone {
         <0, 0.5, 0>, 1.1,
         <0, 0.3, 0>, 1.8
         
         texture {
            texGreenPlastic
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.55, 0>, <0, 0.5, 0>, 1
         
         texture {
            texCrome
         }
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      scale <0.75, 1, 1>
   }
   
   union {
      sphere {
         <0, 0, 0>, 0.4
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 4, 0>, <0, 0, 0>, 0.15
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 4, 0>, <0, 0, 0>, 0.1
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 4, 0>
      }
      
      cylinder {
         <0, 4, 0>, <0, 0, 0>, 0.05
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 8, 0>
      }
      
      texture {
         texCrome
      }
      rotate <-30, -0, 0>
      translate <0, 0.6, -0.5>
   }
   
   union {
      sphere {
         <0, 0, 0>, 0.4
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 4, 0>, <0, 0, 0>, 0.15
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 4, 0>, <0, 0, 0>, 0.1
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 4, 0>
      }
      
      union {
         cylinder {
            <0, 4, 0>, <0, 0, 0>, 0.05
            scale <1, 1, 1>
         }
         
         cylinder {
            <0, 0.1, 0>, <0, -0.1, 0>, 0.1
            scale <1, 1, 1>
            rotate <0, 0, 0>
            translate <0, 4, 0>
         }
         rotate <30, 0, 0>
         translate <0, 8, 0>
      }
      
      texture {
         texCrome
      }
      rotate <75, 0, 0>
      translate <0, 0.6, 0.5>
   }
}

#declare Room = union {
   box {
      <-33.563, -11.357, -9.5949>, <19.472, 31, -7.9308>
      
      texture {
         texWall
         scale <10, 10, 10>
      }
      hollow false
   }
   
   box {
      <-33.563, -11.357, -9.5949>, <19.472, 31, -7.9308>
      
      texture {
         texWall
         scale <10, 10, 10>
      }
      translate <0.533333, 0, 51.2>
      hollow false
   }
   
   box {
      <-33.563, -11.357, -9.5949>, <19.472, 31, -7.9308>
      
      texture {
         texWall
         scale <10, 10, 10>
      }
      rotate <0, 90, 0>
      translate <27.5776, 0, 9.91003>
      hollow false
   }
   
   box {
      <-33.563, -11.357, -9.5949>, <19.472, 31, -7.9308>
      
      texture {
         texWall
         scale <10, 10, 10>
      }
      rotate <0, 90, 0>
      translate <-23.6224, 0, 9.64336>
      hollow false
   }
   
   box {
      <-33.0297, 28.643, -9.5949>, <19.7387, 31, 43.5359>
      
      texture {
         texWall
         scale <10, 10, 10>
      }
      hollow false
   }
   
   box {
      <-33.0297, 28.643, -9.5949>, <19.7387, 31, 43.5359>
      
      texture {
         texWall
         scale <10, 10, 10>
      }
      translate <-0.266667, -39.7333, 0>
      hollow false
   }
}

#declare Table = box {
   <-18.3163, -4.79472, -9.35999>, <13.8058, -4.00003, 14.5045>
   
   texture {
      texTableRedWood
      scale <3, 3, 3>
   }
   scale <1, 1, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

#declare Ecran = superellipsoid {
   <0.4, 0.6>
   scale <4, 3, 1>
   rotate <0, 0, 0>
   translate <1, 0, 0>
}

#declare Kineskop = merge {
   object {
      Ecran
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   lathe {
      quadratic_spline
      4,
      <0.166667, 1.43333>, <2.66667, 1.50003>, <0.8, 0.133333>, <0, -2.1>
      scale <1, 1, 1>
      rotate <90, 0, 0>
      translate <1, -0.0333333, -1.93333>
   }
}

#declare BigRuchka = difference {
   union {
      cone {
         <0, 0.1, 0>, 0.4,
         <0, -0.1, 0>, 0.5
         scale <1, 1, 1>
         rotate <90, 0, 0>
         translate <0, 0, 0>
      }
      
      cone {
         <0, 0.1, 0>, 0.25,
         <0, -0.1, 0>, 0.3
         scale <1, 1, 1>
         rotate <90, 0, 0>
         translate <0, 0, 0.2>
      }
      
      texture {
         texBlackPlastic
      }
   }
   
   cone {
      <0, 0.04, 0>, 0.23,
      <0, -0.04, 0>, 0.22
      
      texture {
         texCrome
      }
      scale <1, 1, 1>
      rotate <90, 0, 0>
      translate <0, 0, 0.3>
   }
}

#declare FrontCover = difference {
   difference {
      box {
         <-1, -1, -1>, <1, 1, 1>
         scale <5.4, 3.6, 0.4>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      superellipsoid {
         <0.1, 0.1>
         scale <5.2, 3.4, 0.4>
         rotate <0, 0, 0>
         translate <0, 0, 0.7>
      }
      
      texture {
         texFrontPanel
         scale <0.1, 0.2, 0.2>
         rotate <70, 0, 0>
      }
   }
   
   object {
      Ecran
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   text {
      //*PMName Rubin
      ttf "luximbi.ttf"
      "Py6uH"
      0.5, <0, 0>
      scale <0.3, 0.3, 0.3>
      rotate <0, 180, 0>
      translate <-3.86157, 2.86996, 0.329877>
   }
   
   texture {
      texCrome
   }
}

#declare DinamicEllipse = cylinder {
   <0, 0.5, 0>, <0, -0.5, 0>, 0.5
   scale <1.6, 1, 3>
   rotate <90, 0, 0>
   translate <-4, 1.25, 0>
}

#declare GridBox = box {
   <-4.99663, -0.434967, 0.287655>, <-2.98615, 2.98795, 0.308288>
   scale <1, 1, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
}
//*PMRawBegin
#declare i = 0;
#declare num = 40;
#declare min_grid = min_extent(GridBox);
#declare max_grid = max_extent(GridBox);
#declare w = (max_grid.y-min_grid.y)/(2*num);

#declare coner1 = <min_grid.x, min_grid.y, min_grid.z-0.1>;
#declare coner2 = <max_grid.x, min_grid.y+w, max_grid.z+0.1>;

#declare Grid=difference {
  object{ GridBox }
  #while(i < num)
    box {
      coner1, coner2
    }
    #declare coner1 = coner1+<0, 2*w, 0>;
    #declare coner2 = coner2+<0, 2*w, 0>;
    #declare i = i+1;
  #end
}
//*PMRawEnd

#declare FrontPanel = union {
   difference {
      object {
         FrontCover
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         DinamicEllipse
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   union {
      //*PMName Reshetka
      //*PMRawBegin
      object {
        Grid
      }
      //*PMRawEnd
      
      texture {
         texWhitePlastic
      }
      
      clipped_by {
         object {
            DinamicEllipse
            scale <1, 1, 1>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
   }
   
   object {
      //*PMName BigRuchka
      BigRuchka
      
      material {
         matDefault
      }
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <-4, -2.2, 0.3>
   }
   
   object {
      //*PMName Ruchka1
      BigRuchka
      
      material {
         matDefault
      }
      scale <0.5, 0.5, 0.8>
      rotate <0, 0, 0>
      translate <-4, -1, 0.3>
   }
   
   object {
      //*PMName Ruchka2
      BigRuchka
      
      material {
         matDefault
      }
      scale <0.5, 0.5, 0.8>
      rotate <0, 0, 0>
      translate <-4.6, -1, 0.3>
   }
   
   object {
      //*PMName Ruchka3
      BigRuchka
      
      material {
         matDefault
      }
      scale <0.5, 0.5, 0.8>
      rotate <0, 0, 0>
      translate <-3.4, -1, 0.3>
   }
}

#declare TVBox = union {
   box {
      //*PMName TopCover
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <10.8, 0.2, 6>
      rotate <0, 0, 0>
      translate <0, 3.5, -3.4>
      
      texture {
         texFrontPanel
         scale <0.1, 0.2, 0.2>
         rotate <30, 0, 0>
         translate <0, 0, 4>
      }
   }
   
   box {
      //*PMName BottomCover
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <10.8, 0.2, 6>
      rotate <0, 0, 0>
      translate <0, -3.5, -3.4>
      
      texture {
         texFrontPanel
         scale <0.1, 0.2, 0.2>
         rotate <30, 0, 0>
         translate <0, 0, 4>
      }
   }
   
   box {
      //*PMName LeftCover
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <0.2, 6.8, 6>
      rotate <0, 0, 0>
      translate <5.3, 0, -3.4>
      
      texture {
         texFrontPanel
         scale <0.1, 0.2, 0.2>
         rotate <0, 30, 0>
         translate <0, 0, 0>
      }
   }
   
   box {
      //*PMName RightCover
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <0.2, 6.8, 6>
      rotate <0, 0, 0>
      translate <-5.3, 0, -3.4>
      
      texture {
         texFrontPanel
         scale <0.1, 0.2, 0.2>
         rotate <0, 30, 0>
         translate <0, 0, 0>
      }
   }
   
   box {
      //*PMName BackCover
      <-1, -1, -1>, <1, 1, 1>
      scale <5.4, 3.6, 0.1>
      rotate <0, 0, 0>
      translate <0, 0, -6.5>
      
      texture {
         texFrontPanel
         scale <0.1, 0.2, 0.2>
         rotate <70, 0, 0>
      }
   }
}

#declare Kruzhka = union {
   lathe {
      quadratic_spline
      8,
      <-0.840321, 0.256215>, <0.224453, 0.262567>, <0.563118, 0.0298015>, <0.620219, 1.7389>, <0.713937, 2.19846>, <0.755831, 2.01957>, <0.973581, 0.112731>, <-0.00153862, 0.224267>
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   difference {
      torus {
         0.6, 0.15
         scale <1, 1, 1>
         rotate <90, 0, 0>
         translate <0.80383, 1.1075, 0>
      }
      
      box {
         <-0.0143482, 0.285967, -0.253344>, <0.728864, 1.96476, 0.253344>
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   pigment {
      color rgb <1, 1, 1>
   }
   
   finish {
      ambient rgb <0, 0, 0>
      phong 0.8
      phong_size 40
      reflection rgb <0.164706, 0.164706, 0.164706>
   }
}

camera {
   //*PMName NaRuchki
   perspective
   location <-7.8836, 0.70547, 4.9532>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <-4.244, -1.9704, 0>
   angle 45
}

camera {
   //*PMName NaAntennu
   perspective
   location <-3.11782, 7.01995, 1.45396>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0.026056, 3.33378, -2.87668>
}

camera {
   //*PMName NaReshetku
   perspective
   location <-3.76228, 3.79023, 4.74776>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <-1.49802, 1.49821, 0.382899>
   angle 45
}

camera {
   //*PMName ObschiVid
   perspective
   location <-18.6001, 16.2482, 15.2595>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <2.75958, 0.560586, -1.07599>
}

camera {
   //*PMName NaStol
   perspective
   location <-1.26297, 3.7911, 7.6232>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <7.4254, -3.8851, 4.56275>
   angle 45
}

camera {
   //*PMName NaKarandashi
   perspective
   location <-5.871, 0.204452, 7.30258>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <-2.49805, -2.80397, 2.62065>
}

camera {
   //*PMName ObschiVid2
   perspective
   location <-7.18415, 9.7924, 11.4983>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0.922753, 0.90943, -3.23359>
}

#declare TV = union {
   object {
      //*PMName FrontPanel
      FrontPanel
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      //*PMName TVBox
      TVBox
      scale <1, 1, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   difference {
      object {
         //*PMName Kineskop
         Kineskop
         scale <1, 1, 1>
         rotate <0, 0, 0>
         translate <0, 0, -0.5>
      }
      
      object {
         //*PMName Kineskop
         Kineskop
         
         material {
            matOldGlass_Inner
         }
         scale <0.85, 0.85, 0.75>
         rotate <0, 0, 0>
         translate <0.166667, 0, -0.5>
      }
      
      material {
         matOldGlass
      }
   }
}

object {
   Table
   scale <1, 1, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

object {
   Room
   scale <1, 1, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

object {
   //*PMName link Antenna
   Antenna
   scale <1, 1, 1>
   rotate <0, 70, 0>
   translate <0, 3.59925, -2.83346>
}

object {
   //*PMName link TV
   TV
   scale <1, 1, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

object {
   //*PMName link Kruzhka
   Kruzhka
   scale <1, 1, 1>
   rotate <-0, -43.1, 0>
   translate <-2.44212, -3.82853, 2.3901>
}

object {
   //*PMName link Karandashi
   Karandashi
   scale <1, 1, 1>
   rotate <0, 0, 0>
   translate <0.943877, 0, 0.943877>
}

object {
   //*PMName link Lamp
   Lamp
   scale <1, 1, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

object {
   PenYellow
   rotate <90, 0, 0>
   rotate <180, 77.5, 180>
   translate <3.88786, -4.17992, 3.13956>
}

#declare Sketch = bicubic_patch {
   type 0
   u_steps 3
   v_steps 3
   <-2.43061, 1.35366, -2.53832>, <-1, 0, -3>, <1, 0, -3>, <3, 0, -3>,
   <-3, 0, -1>, <-1, 0, -1>, <1, 0, -1>, <3, 0, -1>,
   <-3, 0, 1>, <-1, 0, 1>, <1, 0, 1>, <3, 0, 1>,
   <-3, 0, 3>, <-1, 0, 3>, <1, 0, 3>, <2.4641, 1.38437, 2.48702>
   scale <1.3333, 1, 1>
   scale <0.8, 0.8, 0.8>
   rotate <0, 0, 0>
   translate <1.96983, -3.9807, 3.93966>
}
//*PMRawBegin
object {
  Sketch
  texture {
    pigment {
      uv_mapping
      image_map {
        tiff "1.tif"
      }
      scale <-1, 1, 1>
    }
    normal {
       crackle 1
       scale 0.5
    }
  }
}
//*PMRawEnd