// Persistence of Vision Ray Tracer Scene Description File
// File: pencil.pov
// Vers: 3.5
// Desc: A pencil and the POV-Ray Logo fighting
// Date: 15 Feb 2003
// Auth: Gustavo Reyes

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "logo.inc"
#include "axis.inc"
#include "spline.mcr"

global_settings { assumed_gamma 1.0 }

#default { finish { phong .4 phong_size 40 ambient 0.2} }

#declare ColorPen = union {
        difference  {
                union {
                        intersection {
                                box { <-1, -4, -1>, <1, 8, 1> pigment {color Brass } }
                                box { <-1, -4, -1>, <1, 8, 1> rotate 45*y pigment {color Red} }
                                rotate 23*y
                                }
 
                                #declare Line = 0;
                                #while (Line < 360)
                                  cylinder { <0, -4, 0>, <0, 8, 0>, .1
                                                translate -1*z
                                                #declare Line = Line+45;
                                                rotate Line*y
                                                pigment {color Yellow}
                                                }
                                #end
                                }
        #declare Corner = 0;
                #while (Corner < 360)
                    cone { <0, -8, 0>, 0.2, <0, 2, 0>, 1.0
                        translate 2.2*x
                        rotate -18*z
                        #declare Corner = Corner+45;
                        rotate Corner*y
                        texture { P_WoodGrain1B scale 2 rotate 90*x}
                        }
                #end
        }
        cylinder { <0, 8.05, 0>, <0, -4, 0>, .5 pigment { color Red} }
        sphere { <0, 0, 0> 0.5 translate -4*y pigment {color Red} }
        }

#declare pupil_g = sphere { 0, .5 scale <2, 2, .3> pigment { color White } };
#declare iris_g = sphere { 0, .5 scale <1, 1, .8> pigment { color Black }
                rotate -25*x
                translate -.5*y };

#declare eyelid_r_g = difference {
        sphere { 0, .5 scale <2, 2, .6> pigment { color Gray30 } }
        sphere { 0, .5 scale <3, 4, 1> pigment { color Black } translate -1.2*y }
        };
#declare eyelid_l_g = difference {
        sphere { 0, .5 scale <2, 2, .6> pigment { color Gray30 } }
        sphere { 0, .5 scale <3, 4, 1> pigment { color Black } translate -1.2*y }
        };

#declare eyebrow_r_g = difference {
                cylinder { 0*x,  -.2*z,  1 }
                sphere { 0, .6 scale <3, 1.5, 3>
                translate <-.8, -.27, 0>
                rotate 25*z }
                pigment { color Gray20 }
                translate .3*z
                };

#declare eyebrow_l_g = difference {
                cylinder { 0*x,  -.2*z,  1 }
                sphere { 0, .6 scale <3, 1.5, 3>
                translate <.8, -.27, 0>
                rotate -25*z }
                pigment { color Gray20 }
                translate .3*z
                };

#declare eye_r_g = union {
        object { pupil_g }
        object { iris_g translate -.2*x }
        object { eyelid_r_g }
        object { eyebrow_r_g translate <0, .7, 0> }
        };

#declare eye_l_g = union {
        object { pupil_g }
        object { iris_g translate -.2*x }
        object { eyelid_l_g }
        object { eyebrow_l_g rotate -10*z translate <0, .7, 0> }
        };

#declare eyes = union {
        object { eye_r_g rotate 30*y
                      rotate -8*x
                      translate <-1, 5, -3> }
        object { eye_l_g rotate -30*y
                      rotate -8*x
                      translate <1, 5, -3> }
        };

#declare mouth = create_spline ( array[6] {
  < 0.0,  0.0, 0>,
  <-1.0,  1.0, 0>,
  <-1.0, -1.0, 0>,
  < 1.0, -1.0, 0>,
  < 1.0,  1.0, 0>,
  < 0.0,  0.0, 0>
  },
  create_default_spline )

 
#declare Lips = object { blob_spline (mouth, spline_radius (<.5, .2>)
                        + blob_stretch_factor (2) )
                        pigment { color Red }
                        };

#declare Boca = prism { linear_sweep
                          cubic_spline
                          -.5, 0
                          8
                          < 0.0,  0.0>,
                          <-1.0,  1.0>,
                          <-1.0, -1.0>,
                          < 1.0, -1.0>,
                          < 1.0,  1.0>,
                          < 0.0,  0.0>,
                          <-1.0,  1.0>,
                          <-1.0, -1.0>
                          rotate -x*90
                          pigment { color Orange }
                          };

#declare BocaEnojada = union {
                                object { Lips }
                                object { Boca }
                                translate <0, 2, -3>
                                };
#declare PenHat = union {
                        lathe {
                          cubic_spline 6
                          <2.6,-1.0>,
                          <0.9,-1.9>,
                          <1.7, 0.0>,
                          <1.2, 0.6>,
                          <0.1, 0.0>,
                          <-.7, 0.8>
                          pigment {color Red}
                          }
                        torus { 1.1, 0.2 translate -1.5*y }
                        torus { 1.1, 0.2 translate -1.7*y }
                        pigment {color Yellow}
                        finish { phong .1 phong_size 20 }
                        };

#declare ElLapizJapones = union {
        object { PenHat translate 9.5*y }
        object { BocaEnojada }
        object { ColorPen rotate 15*y }
        object { eyes }
        rotate 15*y
        //translate <7, 0, -1>
        };

//object { ElLapizJapones}
//BEND OPTIONS
   #declare bend_object = ElLapizJapones;
   #declare object_axis1 = y * 2;
   #declare object_axis2 = 10;
   #declare bend_smoothness = 100;
   #declare bend_direction = <1, 0, -.5>;
   #declare bend_angle = 70;
   #declare bend_start = 0;
   #declare bend_finish = 1;

// CREATE BENT OBJECT
   #include "Bend.inc"

object { Povray_Logo
        scale <11, 11, 2>
        rotate -45*y
        translate <-15.5, 5, 10>
        texture { Cork }
        no_shadow
        }

plane { x, 0 rotate 35*y translate -24.4*x texture { Cork } }
plane { y, -4.4 texture { Cork } }
plane { z, 700 texture { Cork } }

light_source { 0*x color rgb 1 area_light
        <8, 5, 0> <0, 5, 8>
        4, 4
        adaptive 2
        jitter
        circular
        orient
        translate <40, 60, -40>
        }

fog { fog_type 2 distance 55 color rgb 0.6
       fog_offset 0.1
       fog_alt    0.2
       turbulence 0.8
       }

camera { location  <-6, 6,  -18> look_at   <-6, 4, -3> }
