
#include "c:\Progs\Graphics\POV\POV-Ray for Windows v3.5\include\colors.inc"  
#include "c:\Progs\Graphics\POV\POV-Ray for Windows v3.5\include\metals.inc"

global_settings{ assumed_gamma 1 ambient_light rgb<1,1,1>*0.2  }

// ----------------------------------------
camera{location<-1.5,0,-14> direction 1.5*z right 4/3*x  look_at<-1.5,0,0>} 
//camera{location<3,-2,-4> direction 1.5*z right 4/3*x  look_at<3,-2,0>}  
//camera{location<-6,0,-10> direction 1.5*z right 4/3*x  look_at<-6,0,0>}

//light_source{<-15,30,-30> color rgb<1,1,1>*0.3}  
//light_source{<-30,30,-30> color rgb<1,1,1>}


light_source {<-8,10,-7> color rgb <1,1,1>*0.2 spotlight point_at <-4,3,0> radius 5 tightness 5 falloff 30} 

// ----------------------------------------

#declare Hammerite01=  
        //texture{pigment{rgb<1,1,1>*0.5}}
        texture{pigment{wrinkles color_map{[0.0 rgb<1,1,1>*0.4][1.0 rgb<1,1,1>*0.1]}scale 0.02}}

//PPI SURROUND
lathe {linear_spline  7,<2.1,0>,<2.6,0>,<2.6,0.5>,<2.54,0.56>,<2.14,0.56>,<2.1,0.5>,<2.1,0> 
        rotate<-90,0,0> translate<0,0,0.4> texture{Hammerite01}}
disc { <0, 0, 0.0001>, z, 2.2 pigment{rgb<0,0,0>}}
object{
sphere{<0,0,5.6>,6 
        //pigment{rgbt<1,0,0,0.95>} 
        pigment{wrinkles color_map{[0.0 rgbt<1,0,0,0.95>*0.8][1.0 rgbt<1,0,0,0.95>*1]}scale 0.02}
        finish{phong 0.2}}
clipped_by{cylinder{<0,0,10>,<0,0,-10>,2.5}} 
        }
        
//Bearing marker
cylinder {<0,0,-0.01>,<0,2,-0.01>, 0.01 rotate<0,0,-30> pigment{rgb<1,0.2,0>*1.5}}   

//A-scope surround
disc {<-6,2,0.48> <0,0,1>,0.9,0.8 texture{T_Silver_3C}}   
disc {<-6,2,0.45> <0,0,1>,0.9,0.8 texture{T_Silver_3C}} 
disc {<-6,2,0.48> <0,0,1>,0.8, 
        pigment{wrinkles color_map{[0.0 rgb<1,1,0.6>*0.8][1.0 rgb<1,1,0.4>*1]}scale 0.02} 
        //pigment{rgb<0,0,0>}
        }
cylinder { <0,0,-0.01>,<0,2,-0.01>, 0.01 rotate<0,0,-30> pigment{rgb<1,0.2,0>*1.5}}
//sphere{<-6,2,0>,0.8 scale<1,1,0.1> translate<0,0,0.48> pigment{rgbt<1,1,0.4,0.9>}finish{phong 1 phong_size 80}}            


//Handle
#declare Handle=union{  
torus{0.5,0.07 rotate<90,0,0> translate<0,0,-0.5> pigment{rgb<0.4,0.4,0.6>}} 
cylinder{<0,0,0>, <0,0,-0.3>, 0.1 pigment{rgb<0.4,0.4,0.6>}}
sphere{<0,0,-0.3>,0.1 pigment{rgb<0.4,0.4,0.6>}}
cylinder{<0.5,0,-0.5>, <0,0,-0.3>, 0.05 pigment{rgb<0.4,0.4,0.6>}}
cylinder{<0.5,0,-0.5>, <0,0,-0.3>, 0.05 pigment{rgb<0.4,0.4,0.6>} rotate<0,0,120>}
cylinder{<0.5,0,-0.5>, <0,0,-0.3>, 0.05 pigment{rgb<0.4,0.4,0.6>} rotate<0,0,240>}
                      }//end of union
               
object{Handle rotate<0,0,10> translate<3,-2.5,0>}   
object{Handle rotate<0,0,30> translate<-3,-2.5,0> } 

//Bolts
#declare Bolt=difference{
cylinder { <0,0,0>, <0,0,-0.05>,0.15 texture{T_Silver_3C}}
box{<-1,0.02,-0.04>,<1,-0.02,-1.2> pigment{rgb<0.7,0.7,0.7>}}
                     }

object{Bolt rotate<0,0,40 > translate<3.5,3.5,0>} 
object{Bolt rotate<0,0,80 > translate<-3.5,3.5,0>}  
object{Bolt rotate<0,0,120> translate<3.5,-3.5,0>}  
object{Bolt rotate<0,0,160> translate<-3.5,-3.5,0>}
object{Bolt rotate<0,0,200> translate<4.5,3.5,0>} 
object{Bolt rotate<0,0,240> translate<-4.5,3.5,0>}  
object{Bolt rotate<0,0,280> translate<4.5,-3.5,0>}  
object{Bolt rotate<0,0,10 > translate<-4.5,-3.5,0>}        
     

//Knobs
#declare Knob=union{
cone{<0,0,0>,0.3 <0,0,-0.5>,0.2 pigment{rgb<0.03,0.03,0.03>} finish{phong 0.5}}
cylinder {<0,0.3,0>,<0,0.2,-0.5>,0.02 pigment{rgb<1,1,1>} finish{phong 0.5}}
cylinder {<0,0,-0.5>,<0,0.2,-0.5>,0.02 pigment{rgb<1,1,1>} finish{phong 0.5}}
sphere   {<0,0.2,-0.5>,0.02 pigment{rgb<1,1,1>} finish{phong 0.5}}
                    }
                                        
object{Knob rotate<0,0,30> translate<3.25,-0.7,0>} 
object{Knob rotate<0,0,30> translate<-5.5,0,0.5>}
object{Knob rotate<0,0,0> translate<-6.5,0,0.5>}                         

//Switch
#declare Switch1 = union{
prism {linear_sweep linear_spline 0,-0.1,7,<-1,1.5>,<1,1.5>,<1.7,0>,<1,-1.5>,<-1,-1.5><-1.7,0>,<-1,1.5> 
        scale<0.2,1,0.2> 
        //pigment{rgb<1,0,0> }
        //texture {T_Silver_3C} 
        rotate<90,0,0> texture{T_Silver_3C} }
sphere{<0,0,-0.1>0.25 scale<1,1,0.5> texture{T_Silver_1C}}        
cone{<0,0,0>,0.05<0,0,-0.7>,0.08 rotate<15,0,0> texture{T_Silver_3C}}
sphere{<0,0,-0.7>0.08 rotate<15,0,0> texture{T_Silver_3C}} 
}//end of Switch union  

object{Switch1 scale 0.4 translate<-6,-0.8,0.5>}  
object{Switch1 scale 0.4 translate<-6.5,-0.8,0.5>}
object{Switch1 rotate<0,0,180> scale 0.4 translate<-5.5,-0.8,0.5>} 

//object{Switch1 scale 0.6 translate<-3.0,2.5,0>}

//BNC Socket
#declare BNC1 = union{
prism {linear_sweep linear_spline 0,-0.1,7,<-1,1.5>,<1,1.5>,<1.7,0>,<1,-1.5>,<-1,-1.5><-1.7,0>,<-1,1.5> 
        scale<0.2,1,0.2> 
        //pigment{rgb<1,0,0>}
        //texture {T_Silver_3C} 
        rotate<90,0,0> texture{T_Silver_3C}}
    difference{
    cylinder{<0,0,0>,<0,0,-0.7>,0.25 texture{T_Silver_3C}} 
    cylinder{<0,0,0.1>,<0,0,-0.8>,0.23 texture{T_Silver_3C}}
              }
    difference{
    cylinder{<0,0,0>,<0,0,-0.65>,0.15 pigment{rgb<1,1,0.8>}} 
    cylinder{<0,0,0.1>,<0,0,-0.655>,0.04 pigment{rgb<1,1,0.8>}}
              } 
    difference{          
    cylinder{<0.29,0,-0.5>,<-0.29,0,-0.5>,0.04 texture{T_Silver_3C}} 
    cylinder{<0,0,0.1>,<0,0,-0.8>,0.23 texture{T_Silver_3C}}
              }                            
}//end of BNC union 

object{BNC1 scale 0.5 translate<-6,0.8,0.5>} 

//Photo
box {<0,0,-0.01>,<1,1,0.01> pigment{image_map{jpeg "betty5.jpg"}} translate<-0.5,-0.5,0> 
        rotate<0,0,2> scale<0.419,0.52,1>*3 translate<2.2,2.5,-0.01> finish{ambient 0.3}}

//PANEL
difference{
box{<-9,-4,0.001>,<9,4,3> texture{Hammerite01}}  

//hole for bearing display
#declare J = -13;
#while (J < 13) 
box{<-0.05,2.7,-1>,<0.05,3.1,5> pigment{rgb<0,0,0>} rotate<0,0,J>}
#declare J=J+0.5;
#end
      
//hole for range display
#declare J = -17;
#while (J < 17) 
box{<-0.05,0.7,-1>,<0.05,1.1,5> pigment{rgb<0,0,0>} rotate<0,0,J> translate<3,-2.5,0>}
#declare J=J+0.5;
#end 

//Hole for A-scope
box{<-5,3,-1>,<-7,-3,0.5> pigment{rgb<0.4,0.4,0.6>}}
cylinder {<-5,-0.2,0>,<-5,0.2,0>,0.05 pigment{rgb<0.4,0.4,0.6>}}

//Hole deviders
box {<-3.95,-6,-1>,<-4.05,6,0.1>}    
box {< 3.95,-6,-1>,< 4.05,6,0.1>}
        texture{Hammerite01}}  //End of difference for holes

//box{<-5,3,1>,<-7,-3,0.49999> pigment{rgb<0,1,0>}} //For testing 
box{<0.0.0>,<1,1,1> pigment{image_map{jpeg "Radar4AScope.jpg"}} translate<-0.5,-0.5,0> 
        scale<2,6,1> translate<-6,0,0.499>} //A-Scope background


//A-Scope cover
box{<-2,3,-0.001>,<0,-3,-0.002> rotate<0,-10,0> translate<-7,0,0> texture{Hammerite01} finish{ambient 0.05}}
cylinder {<-7,1,0>,<-7,2,0>,0.03 pigment{rgb<0.4,0.4,0.6>}} 
cylinder {<-7,-1,0>,<-7,-2,0>,0.03 pigment{rgb<0.4,0.4,0.6>}}
torus { 0.03, 0.01 pigment{rgb<0,0,0>} translate<-7,1.33,0>}  
torus { 0.03, 0.01 pigment{rgb<0,0,0>} translate<-7,1.66,0>}       
torus { 0.03, 0.01 pigment{rgb<0,0,0>} translate<-7,-1.33,0>}  
torus { 0.03, 0.01 pigment{rgb<0,0,0>} translate<-7,-1.66,0>}

//PANEL To REAR
difference{
box{<-9,-8,0.001>,<9,8,3> texture{Hammerite01}}  
//Hole deviders
box {<-3.95,-6,-1>,<-4.05,6,0.1>}    
box {< 3.95,-6,-1>,< 4.05,6,0.1>}
     rotate<0,0,0>   translate<0,0,2> texture{Hammerite01}}  //End of difference for holes

//Bearing major divisions
#declare J = -50;
#while (J < 50)    
cylinder {<0,2.75,0>,<0,2.93,0>,0.01 pigment{rgb<0,0,0>} translate<0,0,0.05> rotate<0,0,J>}

// create a TrueType text shape
text {
  ttf             // font type (only TrueType format for now)
  "crystal.ttf",  // Microsoft Windows-format TrueType font file name
  str(30+J,2,0),       // the string to create
  2,              // the extrusion depth
  0               // inter-character spacing
pigment{rgb<0,0,0>} scale 0.15 translate<-0.06,2.95,0.05> rotate<0,0,J>}

#declare J=J+10;
#end  

//Bearing half divisions
#declare J = -50;
#while (J < 50)    
cylinder {<0,2.75,0>,<0,2.87,0>,0.01 pigment{rgb<0,0,0>} translate<0,0,0.05> rotate<0,0,J>}
#declare J=J+5;
#end

//Bearing Minor divisions
#declare J = -50;
#while (J < 50)    
cylinder {<0,2.75,0>,<0,2.85,0>,0.01 pigment{rgb<0,0,0>} translate<0,0,0.05> rotate<0,0,J>}
#declare J=J+1;
#end

//Cursor
cylinder {<0,2.6,0>,<0,3.1,0>,0.007 pigment{rgb<0,0,0>} translate<0,0,0.05>}
           
//Bearing display Red background
box{<-1,2.6,0.051>,<1,3.1,1> pigment {onion color_map{[0 rgb<1,0.01,0>*2] [1 rgb<0.7,0,0>*0.1]}
    frequency 1 scale 1.2 rotate<0,90,0> translate<0,3,0>} finish{ambient 1.5}}


//box{<-2,-2,-2>,<2,2,2> pigment{spherical color_map{[0.5 color Red] [0.5 color White]} 
  //      frequency 3  translate<0,0,0>} rotate<0,0,0> }
                              
//Range major divisions
#declare J = -50;
#while (J < 50)    
cylinder {<0,0.75,0>,<0,0.95,0>,0.01 pigment{rgb<0,0,0>}  rotate<0,0,J> translate<3,-2.5,0.05>}

// create a TrueType text shape
text {
  ttf             // font type (only TrueType format for now)
  "crystal.ttf",  // Microsoft Windows-format TrueType font file name
  str(30-J,2,0),       // the string to create
  2,              // the extrusion depth
  0               // inter-character spacing
pigment{rgb<0,0,0>} scale 0.1 translate<-0.05,0.97,0.05> rotate<0,0,J> translate<3,-2.5,0>}

#declare J=J+10;
#end  

//Range half divisions
#declare J = -50;
#while (J < 50)    
cylinder {<0,0.75,0>,<0,0.9,0>,0.01 pigment{rgb<0,0,0>} rotate<0,0,J> translate<3,-2.5,0.05> }
#declare J=J+5;
#end

//Range Minor divisions
#declare J = -50;
#while (J < 50)    
cylinder {<0,0.75,0>,<0,0.85,0>,0.01 pigment{rgb<0,0,0>} rotate<0,0,J> translate<3,-2,0.05> }
#declare J=J+2.5;
#end

//Cursor
cylinder {<0,0.5,0>,<0,2,0>,0.007 pigment{rgb<0,0,0>} translate<3,-2.5,0.05>}
           
//Range display Red background
box{<-1,0.5,0.051>,<0.5,1.2,5> pigment {onion color_map{[0 rgb<1,0.01,0>*2] [1 rgb<0.7,0,0>*0.1]}
    frequency 1 scale 0.5 rotate<0,90,0> translate<0,0.75,0>} finish{ambient 1.5} translate<3,-2.5,0>}                                

//PPI and A-scope moving parts
//Setup picture to read
#declare xPixels = 400;
#declare yPixels = 400;
#declare MeterDeflect = 0;



#if(clock_on=0)   
#declare Rotation = 10*2*pi/360;  //rotate for single frames
#else 
#declare Rotation = 2*pi*(1-clock);  
#end

#declare MyTesti = function    // In order to get the HF_ macros to read
{ pigment                      // imported pictures they have to be
  { image_map                  // declared this way.
    { jpeg "radar03.jpg" map_type 0 // <----
      once
    }
    scale <1,1,1>
  }                                                                                                   
} 
#declare MyTest = function {MyTesti(x,y,z).grey}  

#declare TempB = 5;
               
#declare FaderTotal = 3;
#declare Fader = FaderTotal; 
#while (Fader > 0)                                      //Step back through fader

// Create balls along X axis 
#declare TotalBalls = 60;                               //No of points on trace
#declare BallCount = 0;   
#while (BallCount < TotalBalls)     
#declare Brightness =  0.2+(10*MyTest(0.5+(0.5*cos(Rotation+Fader)*BallCount/TotalBalls),
                                      0.5+(0.5*sin(Rotation+Fader)*BallCount/TotalBalls),0));  

#if (Fader < 0.5) 
#declare MeterDeflect = MeterDeflect + Brightness;
#end

#if (Fader < (pi/200)+0.001) 
#declare Brightness = (0.5*Brightness) + 5;  

//A Scope trace
cylinder{<(1.3*(BallCount-1)/TotalBalls),4+(TempB*0.07),0>,
         <(1.3*BallCount/TotalBalls),4+(Brightness*0.07),0>,0.007 
         pigment{rgb<0,1,0>} finish{ambient 50} translate<-6.6,-2.4,0.48>}

#declare TempB = Brightness;

#end
//PPI
  sphere{<(BallCount/TotalBalls)*2*cos(Rotation+(Fader)),
          (BallCount/TotalBalls)*2*sin(Rotation+(Fader)),0>,
          0.001*Brightness*(FaderTotal-Fader)
          pigment{rgb<1,0.6,0>*0.004*Brightness*(FaderTotal-Fader)} finish{ambient 10*Brightness}
          } 


    
  #declare BallCount = BallCount+1;
#end      

  #declare Fader = Fader-(pi/200);     //0.01;
#end    //end of moving part

//Meter 
disc {<-6,-2,0.48> <0,0,1>,0.8,0.65 pigment{rgb<0.03,0.03,0.03>} finish{phong 0.5}} 
disc {<-6,-2,0.45> <0,0,1>,0.8,0.65 pigment{rgb<0.03,0.03,0.03>} finish{phong 0.5}} 
disc {<-6,-2,0.48> <0,0,1>,0.65,    pigment{wrinkles 
        color_map{[0.0 rgb<1,1,1>*0.8][1.0 rgb<1,1,1>*1]}scale 0.02}} 

//Meter needle 
cone {<0,0,0>,0.03,<0,0.8,0>,0.005 rotate<0,0,30-(MeterDeflect/100)> scale<1,1,0.1> 
        translate<-6,-2.5,0.45> pigment{rgb<0,0,0>}}
disc {<0,0,0>, z, 0.3, translate<-6,-2.5,0.45> pigment{rgb<0,0,0>} }

//Meter scale
#declare J = -30;
#while (J < 40)    
cylinder {<0,0.81,0>,<0,0.87,0>,0.007 pigment{rgb<0,0,0>} rotate<0,0,J> translate<-6,-2.5,0.48> }
cylinder {<-0.07,0.81,0>,<0.07,0.81,0>,0.007 pigment{rgb<0,0,0>} rotate<0,0,J> translate<-6,-2.5,0.479> }
// create a TrueType text shape
text {
  ttf             // font type (only TrueType format for now)
  "crystal.ttf",  // Microsoft Windows-format TrueType font file name
  str(3-(J/10),2,0),       // the string to create
  2,              // the extrusion depth
  0               // inter-character spacing
pigment{rgb<0,0,0>} scale 0.08 translate<-0.07,0.9,0> rotate<0,0,J> translate<-6,-2.5,0.475>}

#declare J=J+10;
#end 

text {
  ttf             // font type (only TrueType format for now)
  "crystal.ttf",  // Microsoft Windows-format TrueType font file name
  "2003",      // the string to create
  2,              // the extrusion depth
  0               // inter-character spacing
pigment{rgb<0,0,0>} scale 0.1 translate<-0.35,0.5,0> translate<-5.75,-2.4,0.479>}

text {
  ttf             // font type (only TrueType format for now)
  "crystal.ttf",  // Microsoft Windows-format TrueType font file name
  "Matthew Bradwell",      // the string to create
  2,              // the extrusion depth
  0               // inter-character spacing
pigment{rgb<0,0,0>} scale 0.1 translate<-0.35,0.5,0> translate<-6.04,-2.5,0.479>}

//Plane to reflect in chrome                        
plane{z, -25 pigment{wrinkles color_map{[0.0 rgb<1,1,1>*0.4][1.0 rgb<1,1,1>*0.1]}scale 2}finish{ambient 1.5}}                        
                        
#debug "Deflection = "
#debug str(MeterDeflect,0,3)   

#debug "    Clock = "
#debug str(clock,0,3) 

