// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "mgrass.inc"

//
//--------------------------------------------------------------------------------
//
#declare Green1=rgb<0.85,0.55,0.25>*0.65;
#declare Green2=rgb<1.6,1.1,0.6>*0.65;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.2]
        [0.2, 0.3   color Tan*0.2 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.15]
        [0.6 color Tan*0.15]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}
#declare txtGrass=texture {                  
  pigment {
    gradient y
    turbulence 0.2
      pigment_map {                                
        [0.0 pigEarth]
        [0.3 pigGreen]
        [0.9 pigSpotted]
        [1.00 pigEarth]
      }
    }
  finish{diffuse 0.7 specular 0.15 roughness 0.05}
  scale <0.001,1,0.001>
} 
// --------------------------------------
// Patch parameters
// --------------------------------------
// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
// --------------------------------------
#declare lPatch=40;               // size of patch
#declare nBlade=30;               // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;             // initial y rotation of blade
#declare segBlade= 10;            // number of blade segments
#declare lBlade = 8;             // length of blade
#declare wBlade = 0.2;            // width of blade at start
#declare wBladeEnd = 0;         // width of blade at the end
#declare doSmooth=true;          // true makes smooth triangles
#declare startBend = <0,1,1>;     // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,1,-1>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 8;              // bending power (how slowly the curve bends)
#declare rd = 234;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.6;          // standard deviation of blade scale
#declare stdBend = 3;             // standard deviation of blade bending
#declare dofold = false;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;           // true creates a mesh file
#declare fname = "dgrass.inc"    // name of the mesh file to create

// --------------------------------------
// Prairie parameters
// --------------------------------------
#declare nxPrairie=180;           // number of patches for the first line
#declare addPatches=0;            // number of patches to add at each line
#declare nzPrairie=150;           // number of lines of patches
#declare rd=seed(523);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

// --------------------------------------
// Create the patch and the prairie
// --------------------------------------
#if (dofile=true) // if the patch is already created, turn off the next line
        //MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end        

#declare DeadCemGrass = object {
  MakePrairie(lPatch,nxPrairie,0,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
  texture{txtGrass scale 40}
  scale 0.08
  translate <50,0,-70>
}
#declare nxPrairie=60;           // number of patches for the first line
#declare nzPrairie=180;           // number of lines of patches
#declare DeadRoadStrip = object {
  MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
  texture{txtGrass scale 40}
  scale 0.08
  scale <1,2.5,1>
  translate <430,0,-50>
}
