// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"

#declare rFenceSeed = seed(234);

#declare fpWing =
 prism {
    cubic_spline
    -0.125, // sweep the following shape from here ...
     0.125, // ... up through here
    10, // the number of points making up the shape ...
    <0,0>, // control point
    <0,0>,
    <1,0>,
    <1.5,-1>,
    <0,-2>, 
    <-1,-1>, 
    <0,-1.25>,
    <0.5,-0.75>
    <0,0>  
    <0,0> // control point
    rotate <90,0,90>
  }

#declare Spike = 
  union {
    union {
      object { fpWing translate x*-1/3}
      object { fpWing translate x*-1/3 rotate y*180}
      scale 3
      translate y*9
    }
    lathe {
      cubic_spline
      15,
      <1.00,0.00>,
      <1.00,0.00>,
      <1.00,5.00>,
      <2.00,6.00>,
      <1.00,7.00>, 
      <2.00,8.00>,
      <1.00,9.00>, 
      <3.00,10.00>,
      <1.00,11.00>,
      <2.00,12.00>,
      <1.00,14.00>,
      <2.00,15.00>,
      <2.00,16.00>,
      <0.00,20.00>,
      <0.00,21.00> 
    }  
  }
  
  
#declare fpSpiralSmall =
sphere_sweep {
    cubic_spline
    8,
    <-2,6>, 0.25,
    <-1,2>, 0.25,
    <2,0>, 0.25,
    <3.5,0.15>, 0.25,
    <4,1>, 0.25, 
    <3,2>, 0.25, 
    <2,1.5>, 0.25,
    <2,0>, 0.25
    tolerance 0.1
    scale 1.5
 }

#declare fpSpiralBig =
sphere_sweep {
    cubic_spline
    11,
    <-2,6>, 0.25,
    <-1,2>, 0.25,
    <2,0>, 0.25,
    <4.5,0.7>, 0.25,
    <5,3>, 0.25, 
    <3,4>, 0.25, 
    <2,3>, 0.25,
    <2,2>, 0.25,
    <3,1.5>, 0.25,
    <3.5,2.5>, 0.25,
    <0,4>, 0.25
    tolerance 0.1
    scale 1.5
 }

#macro mIronFencePost(l, w, tex, showSpike, spikeScale)
  #local p1 = <-w/2,-l/2,-w/2>;
  #local p2 = <w/2,l/2,w/2>;
  #local r = rand(rFenceSeed);
  #if (showSpike)
    union {
      box { p1, p2 }
      object { 
        Spike 
        scale spikeScale
        translate <0,l/2,0> 
      }
      texture { 
        tex
        translate <r,r,r>
      }
    }
  #else
    box { p1, p2 }
    texture { 
      tex
      translate <r,r,r>
    }
  #end
#end // mIronFencePost

#macro mIronFence(bl,bw,numPosts,gap,tex,doConnect)
  #local i = 0;
  union {
    #while (i < numPosts)
      object {
        #if (mod(i,8) < 4)
          #local ofs = bl/20*mod(i,4); // ascending 
        #else
          #local ofs = bl/20*4 - bl/20*mod(i,4); // descending 
        #end
        mIronFencePost(bl+ofs,bw,tex,yes,0.4)
        translate <(bw+gap)*i,0,0>
      }
      // add the horizontal bars
      #if (doConnect + i != 0) // #gaps = #posts-1
        object { 
          mIronFencePost(gap+bw,bw,tex,no,0)
          rotate z*90
          translate <(bw+gap)*i-(bw+gap)/2,(bl)-(bl/2),0>
        }
        object { 
          mIronFencePost(gap+bw,bw,tex,no,0)
          rotate z*90
          translate <(bw+gap)*i-(bw+gap)/2,(bl*1/10)-(bl/2),0>
        }
        // add the middle spikes
        object {
          mIronFencePost(0,bw,tex,yes,0.4)
          translate <(bw+gap)*i-(bw+gap)/2,bl/10-(bl/2),0>
        }
      #end
      // add the decorative spirals
      #if (mod(i,8) = 4)
        union {
          union {
            object {
              fpSpiralBig 
              rotate y*180+z*-90
            }
            object {
              fpSpiralSmall 
              rotate z*-90
            }
            translate <(bw+gap)*i,0,0>
          }
          union {
            object {
              fpSpiralBig 
              rotate y*180+z*-90
            }
            object {
              fpSpiralSmall 
              rotate z*-90
            }
            rotate y*180
            translate <(bw+gap)*i,0,0>
          }
          texture {tex}
        }
      #end
      #if ((mod(i,8) = 7) | (mod(i,8) = 1))
        union {
          union {
            object {
              fpSpiralSmall 
              rotate y*180+z*-90
            }
            object {
              fpSpiralSmall 
              rotate z*-90
            }
            translate <(bw+gap)*i,0,0>
          }
          union {
            object {
              fpSpiralSmall 
              rotate y*180+z*-90
            }
            object {
              fpSpiralSmall 
              rotate z*-90
            }
            rotate y*180
            translate <(bw+gap)*i,0,0>
          }
          texture {tex}
        }
      #end
      #local i = i + 1;
    #end
    translate <-(bw+gap)*(numPosts-1)/2,bl/2,0>
  }
#end // mIronFence

