#include "colors.inc" 
#include "woods.inc"
#include "varnish.inc"

// Speaker texture
#declare T_Speaker = texture {
  pigment { 
    image_map {
      png "grille_num51_s.png"
    }
    scale 2
    rotate z*90
  }
  //normal { bumps 0.2 }
}


 
// Darker texture
#declare T_RadWood2A = 
 texture {
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.02,0.04,0.04>
      rotate z*5
      warp {repeat 6*x flip <1,0,0> }
    }
  }
 texture {
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf <0,0,0,0>]
      }
      scale <1,3,3>
      rotate z*5
      warp {repeat 6*x flip <1,0,0> }
    }
  }
 texture {
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.06,0.015,0,1>]
        [0.3 rgbf <0.04,0.005,0.0,1>]
        [1.0 rgbf <0.02 0.005,0,1>]
      }
      scale <0.15,4,4>
      rotate z*5
      warp {repeat 6*x flip <1,0,0> }
    }
  }

#declare T_RadWood2 = 
  texture {
    T_RadWood2A
    scale 9
    finish { F_Varnish }
    normal { N_Varnish }
  }
  

#declare T_Cracks =
  texture {
    pigment {
      Black
    }
    finish { F_Varnish }  
  }
  
#declare T_RadWood2Face =
  texture {
    gradient z
    texture_map {
      [0 T_Cracks]
      [0.800 T_Cracks]
      [0.801 T_RadWood2]
      [1 T_RadWood2]
    }
  }
#declare Screw =
  union {
    difference {
      sphere {0, 1 }
      box { <-0.5,-0.1,-0.8>,<0.5,0.1,-1.2> }
      box { <-0.5,-0.1,-0.801>,<0.5,0.1,-1.2> rotate z*90 }
    }
    cylinder { 0, <0,0,-0.05>, 1.3 }
    scale 0.12
    texture { 
      pigment { White*0.05 }
      finish {diffuse 0.6 specular 0.8 roughness 0.01} 
    }
  }

#declare Knob =
union {
  lathe {
    cubic_spline // linear_spline | quadratic_spline | cubic_spline
    8, // number of points
    <0, 0>, <2.6, 0>, <3, 1>, <3,2.5>, <2.2,3>, <1.5,3.4>, <0,3.7>, <0,3.2>
  }
  #declare i=0;
  #while (i < 12)
    sphere { <2.7,2.65,0>, 0.6 rotate y*i*30 }
    #declare i=i+1;
  #end
  texture {
    pigment {rgb <8,9,7>/255}
    finish{diffuse 0.6 specular 0.8 roughness 0.01 reflection 0.01}
  }
  scale 1/3
  rotate x*-90
}


#declare bh=25; // box height
#declare bw=30; // box width
#declare bd=8;  // box depth
#declare co1=-5;  // offset of the cylinder 1 center
#declare hfs=39.7; // height field scale

#declare Philco357 = 
  union {
    difference {
      intersection {
        box { <-bw/2,0,0>,<bw/2,bh,bd> }
        cylinder { <0,co1,-1>,<0,co1,bd+1>, bh-co1 }
        texture {T_RadWood2}
      }
      box { <-7,5,-1>, <7,bh-3,1> } // cut out for speaker
      box { <-bw/2+3,8,-1>, <bw/2-3,bh-8,0.1> } // cut out for dials
    }
    box { <-7,5,-0.05>, <7,bh-3,1> // grille cloth
      texture {T_Speaker}
    }
    box { <-bw/2+3,8,0>, <bw/2-3,bh-8,0.05> // dial area
      texture { 
        pigment { rgbf <0.3,0,0,1> } 
        finish{diffuse 0.3 specular 0.5 roughness 0.001 reflection 0.1}
      }
    } 
    height_field {
      sys "Philco357FaceHF.bmp"
      smooth
      water_level 0.05
      scale <hfs, 0.25, hfs>
      rotate x*-90
      translate <-hfs/2,-3.9,0>
      texture { T_RadWood2Face translate z*-0.2 }
    }
    // knobs
    object {Knob translate <-9.3,11,0>}
    object {Knob translate < 9.3,11,0>}
  }
