#include "colors.inc" 
#include "woods.inc"
#include "varnish.inc"
#include "metals.inc"   

// Speaker texture               
#declare T_Speaker = texture {
  pigment { 
    image_map {
      jpeg "grillecloth5a.jpg"
    }
    scale 2
    rotate z*180
  }
  normal { bumps 0.5 }
}


 
// Lighter texture
#declare T_RadWood1A = 
 texture { // small long dots
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0.3]
      }
      scale <0.02,0.04,0.04>
      rotate z*5
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture { // broad color change
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf <0.3,0.1,0,1>]
      }
      scale <1,2,2>
      rotate z*5
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture { // the grain texture and color
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.25,0.05,0,1>]
        [0.3 rgbf <0.2,0.04,0.0,1>]
        [1.0 rgbf <0.1 0.02,0,1>]
      }
      scale <0.15,4,4>
      rotate z*5
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }

#declare T_RadWood1 = 
  texture {
    T_RadWood1A
    scale 3
    finish { F_Varnish }
    normal { N_Varnish }
  }
  
// Darker texture
#declare T_RadWood2A = 
 texture {
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.02,0.04,0.04>
      rotate z*10
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture {
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf <0,0,0,0>]
      }
      scale <1,3,3>
      rotate z*10
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture {
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.06,0.015,0,1>]
        [0.3 rgbf <0.04,0.005,0.0,1>]
        [1.0 rgbf <0.02 0.005,0,1>]
      }
      scale <0.15,4,4>
      rotate z*10
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }

#declare T_RadWood2 =
  texture { 
    T_RadWood2A
    scale 3
    finish { F_Varnish }
    normal { N_Varnish }
  }
  
#declare T_Cracks =
  texture {
    pigment {
      Black
    }
    finish { F_Varnish }  
  }
  
#declare T_RadWood1Face =
  texture {
    gradient z
    texture_map {
      [0 T_Cracks]
      [0.800 T_Cracks]
      [0.801 T_RadWood1]
      [1 T_RadWood1]
    }
  }
  
#declare T_RadWood2Face =
  texture {
    gradient z
    texture_map {
      [0 T_Cracks]
      [0.800 T_Cracks]
      [0.801 T_RadWood2]
      [1 T_RadWood2]
    }
  }
  
#declare Screw = 
  object {
    difference {
      sphere {0, 1 }
      box { <-1,-0.1,-0.6>,<1,0.1,-1.2> }
      box { <-1,-0.1,-0.601>,<1,0.1,-1.2> rotate z*90 }
    }
    scale <1,1,0.3>
    scale 0.15
    texture { 
      pigment { White*0.07 }
      finish {F_MetalA}
      finish {diffuse 0.4 specular 0.6 roughness 0.01 reflection 0.01 } 
    }
  }
  
  
#declare SmallScrew = 
  object {
    difference {
      sphere {0, 1 }
      box { <-1,-0.1,-0.6>,<1,0.1,-1.2> }
      box { <-1,-0.1,-0.601>,<1,0.1,-1.2> rotate z*90 }
    }
    scale <1,1,0.3>
    scale 0.1
    texture { 
      pigment { White*0.02 }
      finish {diffuse 0.6 specular 0.8 roughness 0.01 reflection 0.01 } 
    }
  }
  
#declare Knob =
  object {
    difference {
      intersection {
        cylinder { <-0.5,0,0>, <0.5,0,0>, 0.4 }
        cylinder { <-0.5,0,0>, <0.5,0,0>, 0.4 rotate z*60}
        cylinder { <-0.5,0,0>, <0.5,0,0>, 0.4 rotate z*120}
        scale <1,1,1.5>
      }
      plane {-z, 0}
    }
    texture {
      pigment {rgb <1,1,1>/255} //almost black
      finish { diffuse 0.6 specular 0.9 roughness 0.01 reflection 0.08 }
    }
  }
  
//
//--------------------------------------------------------------------------------
//
#declare bh=9.15; // box height
#declare bw=11.5; // box width
#declare bd=5;  // box depth
#declare cs=1.2;  // scale of the cylinder

#declare Philco60b = 
union {
  union {
    difference {
      union {
        object {
          difference {
            cylinder { <0, 0, 0.25>, <0, 0, bd>, bw/2  }
            plane { y, 0 }
          }
          scale <1,cs,1>
          translate y*bh
        }
        box { <-bw/2,0,0.25>, <bw/2,bh,bd> }
        texture { T_RadWood2 scale <0.5,1,1> rotate y*90 }  
      } // union
      // Cut out a hole for the speaker
      cylinder { <0, 0, 0.249>, <0, 0, 1>, bw/2*0.9  
        scale <1,cs,1>
        translate y*bh
      }
    } // difference
    height_field {
      sys "Philco60BFaceLightHF.bmp"
      smooth
      water_level 0.05
      scale <17.2, 0.1, 17.2>
      rotate x*-90
      translate <-17.2/2,-0.05,0.25>
      texture { T_RadWood1Face translate z*-0.82}
    }
    height_field {
      sys "Philco60BFaceDarkHF.bmp"
      smooth
      water_level 0.05
      scale <17.2, 0.1, 17.2>
      rotate x*-90
      translate <-17.2/2,-0.05,0.25>
      texture { T_RadWood2Face translate z*-0.82}
    }
    height_field {
      sys "Philco60BDialHF.bmp"
      smooth
      water_level 0.05
      scale <2, 0.1, 2>
      rotate x*-90
      translate <-1,5.62,0.15>
      texture {
        pigment {rgb <1,1,1>/255} //almost black
        finish { diffuse 0.6 specular 0.9 roughness 0.01 reflection 0.03 }
      }
    }
    box { <-0.9,6,0.25>,<0.9,7.25,0.26> // the dial
      texture {
        pigment { 
          image_map {
            png "Philco60bDialImg.png"
          }
          scale 2
          translate <1,-0.5,0>
        }
        finish { diffuse 0.5 specular 0.99 roughness 0.0001 reflection 0.05 }
      }
    }
    // the speaker
    cylinder { <0, 0, 0.3>, <0, 0, 1>, bw/2*0.9  
      scale <1,cs,1>
      translate y*bh
      texture { T_Speaker }
    }
  }
  
  // bottom trim
  box { <-(bw/2+0.25),0,0>, <bw/2+0.25,0.5,bd> 
    texture { T_RadWood2 rotate z*90 scale 0.5 translate x*20 }
  }
  box { <-(bw/2+0.25*2/3),0.5,0.08>, <bw/2+0.25*2/3,0.75,bd> 
    texture { T_RadWood2 rotate z*90 scale 0.5  translate x*44 } 
  }
  box { <-(bw/2+0.25*1/3),0.75,0.16>, <bw/2+0.25*1/3,1,bd> 
    texture { T_RadWood2 rotate z*90 scale 0.5  translate x*-20 } 
  }
  
  // Knobs
  object {Knob translate <0,2.5,0.15> }
  object {Knob translate <-2,2.5,0.15> }
  object {Knob translate <2,2.5,0.15> }
  object {Knob translate <0,5,0.15> }
  
  // Screws
  object {Screw translate <-3.2,13.9,0.15> }
  object {Screw translate < 3.2,13.9,0.15> }
  object {Screw translate <-2.83,7.8,0.15> }
  object {Screw translate < 2.83,7.8,0.15> }
  
  // Small Screws (near dial)
  object {SmallScrew translate <0,6,0.05>}
  object {SmallScrew translate <0,7.35,0.05>}

}  
