#include "colors.inc" 
#include "woods.inc"
#include "varnish.inc"

// Speaker texture
#declare T_Speaker = texture {
  pigment { 
    image_map {
      png "grille_num43_s.png"
    }
    scale 2
    rotate z*180
  }
  normal { bumps 0.5 }
}


 
// Lighter texture
#declare T_RadWood1A = 
 texture { // small long dots
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.02,0.04,0.04>
      rotate z*5
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture { // broad color change
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf <0.3,0.3,0.3,1>]
      }
      scale <1,3,3>
      rotate z*5
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture { // the grain texture and color
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.4,0.2,0,1>]
        [0.3 rgbf <0.35,0.1,0.0,1>]
        [1.0 rgbf <0.2 0.05,0,1>]
      }
      scale <0.15,4,4>
      rotate z*5
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }

#declare T_RadWood1 = 
  texture {
    T_RadWood1A
    scale 3
    finish { F_Varnish }
    normal { N_Varnish }
  }
  
// Darker texture
#declare T_RadWood2A = 
 texture {
    pigment {                 
      bozo
      color_map {
        [0.0 rgb 1]
        [0.4 rgb 1]
        [1.0 rgb 0]
      }
      scale <0.02,0.04,0.04>
      rotate z*2
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture {
    pigment {                 
      agate
      color_map {
        [0.0 rgbf 1]
        [1.0 rgbf <0,0,0,0>]
      }
      scale <1,3,3>
      rotate z*2
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
 texture {
    pigment {                 
      granite
      color_map {
        [0.0 rgbf <0.12,0.03,0,1>]
        [0.3 rgbf <0.08,0.015,0.0,1>]
        [1.0 rgbf <0.02 0.01,0,1>]
      }
      scale <0.15,4,4>
      rotate z*2
      warp {repeat 2*x flip <1,0,0> }
      translate x*2 
    }
  }
  
#declare T_RadWood2 = 
  texture {
    T_RadWood2A
    scale 3
    finish { F_Varnish }
    normal { N_Varnish }
  }
  

#declare T_Cracks =
  texture {
    pigment {
      Black
    }
    finish { F_Varnish }  
  }
  
#declare T_RadWood1Face =
  texture {
    gradient z
    texture_map {
      [0 T_Cracks]
      [0.800 T_Cracks]
      [0.801 T_RadWood1]
      [1 T_RadWood1]
    }
  }
  
#declare T_RadWood2Face =
  texture {
    gradient z
    texture_map {
      [0 T_Cracks]
      [0.800 T_Cracks]
      [0.801 T_RadWood2]
      [1 T_RadWood2]
    }
  }
  
#declare Screw =
  union {
    difference {
      sphere {0, 1 }
      box { <-0.5,-0.1,-0.8>,<0.5,0.1,-1.2> }
      box { <-0.5,-0.1,-0.801>,<0.5,0.1,-1.2> rotate z*90 }
    }
    cylinder { 0, <0,0,-0.05>, 1.3 }
    scale 0.12
    texture { 
      pigment { White*0.05 }
      finish {diffuse 0.6 specular 0.8 roughness 0.01} 
    }
  }

#declare Knob =
  lathe {
    cubic_spline // linear_spline | quadratic_spline | cubic_spline
    7, // number of points
    <0, 0>, <2.6, 0>, <3, 1>, <3,2.5>, <2.2,3>, <0,3.3>, <0,3.3> // the list of <u,v> points
    scale 1/7
    rotate x*-90
    texture {
      pigment {rgb <1,0,0>/255} //almost black
      finish { F_Varnish }
    }
  }


#declare bh=9.15;  // box height
#declare bw=11.5;  // box width
#declare bd=5;   // box depth
#declare cs=1;     // y scale of the cylinder
#declare hfs=17.2; // height field scale

#declare Philco841 = 
union {
  union {
    difference { // for cutting out the dial
      union { // for adding the grille cloth
        difference { // for cutting out the speaker hole
          union {
            object {
              difference {
                cylinder { <0, 0, 0.25>, <0, 0, bd>, bw/2  }
                plane { y, 0 }
              }
              scale <1,cs,1>
              translate y*bh
            }
            box { <-bw/2,0,0.3>, <bw/2,bh,bd> }
            texture { T_RadWood2 scale <0.5,1,1> rotate y*90 }  
          } // union
          // Cut out a hole for the speaker
          cylinder { <0, 0, 0.249>, <0, 0, 1>, bw/2*0.9  
            scale <1,cs,1>
            translate y*bh
          }
        }
        // the grille cloth
        cylinder { <0, 0, 0.5>, <0, 0, 1>, bw/2*0.9  
          scale <1,cs,1>
          translate y*bh
          texture { T_Speaker }
        }
      }
      // cut out the dial 
      box { <-1.2,2.8,-1>,<1.2,6.5,1> }
    } // difference
    
    // the dial
    box { <-1.2,2.8,0.5>,<1.2,6.5,1>
      texture { T_RadWood1 }
    }
    box { <-1.2,5.2,0.49>,<1.2,6.5,1>
      texture {
        pigment { 
          image_map {
            png "Philco841DialImg.png"
          }
          scale 3.5
          translate <1.75,0.5,0>
        }
        finish { diffuse 0.5 specular 0.99 roughness 0.0001 reflection 0.05 }
      }
    }
    
    height_field {
      sys "Philco841FaceDarkHF.bmp"
      smooth
      water_level 0.05
      scale <hfs, 1, hfs>
      rotate x*-90
      translate <-hfs/2,-1.7,0.749>
      texture { T_RadWood2Face translate z*-0.1}
    }
    height_field {
      sys "Philco841FaceLightHF.bmp"
      smooth
      water_level 0.05
      scale <hfs, 0.25, hfs>
      rotate x*-90
      translate <-hfs/2,-1.7,0.5>
      texture { T_RadWood1Face translate z*0.3}
    }
  }
  
  // bottom trim
  box { <-(bw/2+0.25),0,-0.5>, <bw/2+0.25,0.5,bd> 
    texture { T_RadWood2 rotate z*90 scale 0.5 translate x*20 }
  }
  
  // knobs
  object {Knob translate <0,2,0.25>}
  object {Knob translate <0,4,0.5>}
  
  // screws
  object {Screw translate <-3,13.5,0>}
  object {Screw translate < 3,13.5,0>}
  object {Screw translate <-2.7,6.4,0.25>}
  object {Screw translate < 2.7,6.4,0.25>}

}
