// Persistence of Vision Ray Tracer Scene Description File
// File: RadioGrv.pov
// Vers: 3.5
// Desc: Radio Graves
// Date: 02/28/2003
// Auth: Jeremy M. Praay
//

#version 3.5;

#declare Radiosity=on;
#declare MedRadiosity=off;
#declare HiRadiosity=off;
#declare Blur=on;
#declare HiBlur=off;
#declare AreaLight=on;

#declare BirdsEyeView=off;
#declare ShowCameraPos=off;
#declare ShowTestTrees=off;

#declare ShowRadios=on;
#declare ShowGrass=on;
#declare ShowWeeds=on;
#declare ShowCorn=on;
#declare ShowIronFence=on;
#declare ShowTrees=on;
#declare ShowFarm=on;
#declare ShowRoad=on;
#declare ShowTerrain=on;
#declare ShowClouds=on;

#declare INCH = 1/12; 
#declare FOOT = 1; // one unit (default unit of scale)
#declare YARD = 3;

#default {
  texture {
    pigment {rgb 1}
    #if (Radiosity)
      finish {
        ambient 0.0
      }
    #else
      finish {
        ambient 0.06
      }
    #end
  }
}

global_settings {
  assumed_gamma 1.0
  max_trace_level 20 // for the clouds
  #if (Radiosity)
    ambient_light off
    radiosity {
      //pretrace_start 0.08           // start pretrace at this size
      //pretrace_end   0.04           // end pretrace at this size
      //nearest_count 5               // higher -> higher quality (1..10) [5]
      #if (HiRadiosity)
        count 100                   // higher -> higher quality (1..1600) [35]
        error_bound 0.2             // higher -> smoother, less accurate [1.8]
      #else #if (MedRadiosity)
        count 35
        error_bound 1.8
      #else  
        count 15                     // higher -> higher quality (1..1600) [35]
        error_bound 1.8              // higher -> smoother, less accurate [1.8]
      #end
      #end
      //recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      //low_error_factor .5           // reduce error_bound during last pretrace step
      //gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      //minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 0.3                  // brightness of radiosity effects (0..1) [1]

      //adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}


#include "colors.inc" 
#include "woods.inc"
#include "iso_csg.inc"
#if (ShowGrass)
  #include "DeadGrass.inc"
  #include "GreenGrass.inc"
#end
#if (ShowWeeds)
  #include "Weeds.inc"
#end
#if (ShowIronFence)
  #include "IronFence.inc"
#end

#if (ShowRadios)
  #include "Philco60B.inc" 
  #include "Philco357.inc"
  #include "Philco841.inc"
  #include "AtKent82.inc" 
  #include "Philco60.inc"
  #include "Philco116.inc"
  #include "Crosley7H3.inc"
#end

#if (ShowCorn)
  #include "Corn.inc"
#end

#if (ShowTrees)
  #if (ShowTestTrees)
    #declare Spruce = cylinder { 0, y*1, 0.2 pigment {Red} }
    #declare Olive = Spruce;
    #declare Birch = Olive;
  #else
    #include "olive2.inc"
    #include "tomtree.inc"
    #declare Olive=TREE;
    #include "spruce.inc"
    #include "tomtree.inc"
    #declare Spruce=TREE;
    #include "birch.inc"
    #include "tomtree.inc"
    #declare Birch=TREE;
  #end
  
#end

#if (ShowFarm)
  #include "farm.inc"
#end

// ----------------------------------------

camera {
  
// Normal View
  
  #if (Blur)
    aperture 0.15*INCH
    blur_samples 50
    #if (HiBlur) 
      blur_samples 300
      confidence 0.9999
      variance 1/1000000
    #end
    focal_point <2,6,0>*INCH
  #end
  //location  <-20, 16, -30>
  //look_at   <2, 4, 0>
  location  <-24, 17, -35>*INCH
  look_at   <-2, 6, 0>*INCH
  angle 56
  
  // look at a section of fence
  //location <20*FOOT,3*FOOT,15*FOOT>
  //look_at <24*FOOT,1*FOOT,24*FOOT>
    
  // look at the road
  //location <20*YARD,10*FOOT,0>
  //look_at <20*YARD,0,24*FOOT>
    
  // look behind
  //location  <0, 0, 0>
  //look_at   <0, 40, -1000>

  // Bird's Eye View
  #if (BirdsEyeView)
    location  <-50, 80, -100>
    look_at   <30, 40.0,  0.0>
    //location <110*YARD,10,80*YARD>
    //look_at <500*YARD,0,300*YARD>
  #end
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.8,0.8,1.0>]
      [0.7 rgb <0.3,0.35,1>]
    }
  }
  pigment {
    gradient z
    color_map {
      [0.0 rgb  <0.9,0.7,0.2>]
      [0.4 rgbf <1,1,1,1>]
    }
    scale 2
    translate 1            
    rotate y*-30+x*25
  }
}

light_source {
  <0, 1000, 0> 
  color rgb <1.2, 1.1, 1>*1.2  // light's color
  parallel
  #if (AreaLight)
    area_light <0,1000,0>, <3,1000,3>, 2, 2
    adaptive 1 
  #end
  point_at <0,0,0>
  rotate <-65,-30,0> // needs to be in relation to yellow part of sky_sphere
  //<3, 2.5, -4>
}

#declare T_IronFence =
  texture {
    pigment { White*0.05 }
    finish {diffuse 0.5 specular 0.6 roughness 0.01 reflection 0.003}
    normal {bumps 0.1 scale 0.2}
  }
  
#declare T_Road =
  texture {
    pigment {
      bozo
      color_map {                                
        [0.00 White*0.4 ]
        [1.00 White*0.2 ]
      }
      scale 0.1
    }
  }
#declare T_Terrain =
  texture {
    pigment {
      image_map {
        png "plants12.png"
      }
    }
    rotate x*90
    scale 200
  }
  texture {
    pigment {
      rgbf <1,1,1,0.92>
    }
  } 



// the dirt ground      
plane { y, 0 
  pigment { rgb <5,4.3,3> // most of the ground has to be bright for radiosity in clouds
    //rgb <0.9,0.8,0.6>*0.10
  }
}
box { <-500*YARD,0,-500*YARD>,<800*YARD,0.01*INCH,800*YARD> 
  pigment {
    rgb <0.9,0.8,0.6>*0.10
  }
}

#if (ShowTerrain)
  // the grass background
  difference {
    box { <23*YARD,0,30*YARD>,<800*YARD,2*INCH,800*YARD> }
    // cut out for the road
    box { <-1*YARD,-1,0>, <8*YARD,3*INCH,800*YARD> 
      rotate y*45
      translate <15*YARD,0,20*YARD>
    }                          
    // cut out for the corn
    box { <0,-1,0>, <50*YARD,3*INCH,230*YARD> 
      rotate y*45
      translate <15*YARD,0,10*YARD>
    }
    texture { T_Terrain }
    cutaway_textures
  }
  // far background hilly terrain
  #declare fn_cylinder = IC_Cylinder(<0,-500*YARD,0>,<0,-500*YARD,800*YARD>,500*YARD)
  isosurface {
    function{fn_cylinder(x,y,z)-(f_bumps(x/200,y/100,z/200)*100)}
    threshold 0
    contained_by {box {<-300*YARD,0,0>,<500*YARD,100*FOOT,800*YARD>}}
    texture {T_Terrain}
    texture { pigment {rgbf <1,1,1,0.8>} } // lighten up far away hills
    //pigment {White} // for testing
    //finish{specular 0.05}
    translate <600*YARD,0,50*YARD>
  }
  #undef fn_cylinder
#end  
    
#if (ShowGrass)
  object {GreenCemGrass scale INCH}
  object {DeadCemGrass scale INCH}
  object {GreenRoadStrip scale INCH}
  object {DeadRoadStrip scale INCH}
#end

#if (ShowWeeds)
  union {
    /*
      WeedPatch format
      makeWeedPatch(patchLength,patchWidth,numWeeds,devBend,numBladeRangeStart,numBladeRangeEnd,stalkHeight,devStalkHeight,devBladeRot, randSeed)
    */
    // around the cemetary
    #declare WeedStrip = 
      object {
        makeWeedPatch(300,8,200,0.2,3,10,35,0.6,0.6,seed(11))
      }
    object { WeedStrip
      rotate y*-90
      scale 1.4*FOOT // make the tallest blades 1.4 foot high
      translate <23.7*FOOT,0,11*FOOT>
    }
    object { WeedStrip 
      scale 1.4*FOOT
      translate <10*FOOT,0,21.7*FOOT>
    }
    object { WeedStrip 
      scale 1.4*FOOT
      translate <-1*FOOT,0,21.7*FOOT>
    }
    object { WeedStrip 
      scale 1.4*FOOT
      translate <-12*FOOT,0,21.7*FOOT>
    }
    // around the farm fence
    union {
      #declare WeedStrip = 
        object {
          makeWeedPatch(1200,8,400,0.2,3,10,35,0.6,0.6,seed(12))
        }
      object { WeedStrip 
        scale 2.5*FOOT
      }
      object { WeedStrip 
        scale 2.5*FOOT
        translate x*24*YARD
      }
      object { WeedStrip 
        scale 2.5*FOOT
        translate x*48*YARD
      }
      rotate y*-45
      translate <35*YARD,0,53*YARD>
    }
    // around the radios
    // AtKent82
    object {
      makeWeedPatch(20,1,13,0.2,2,5,20,0.5,0.4,seed(23))
      scale 5*INCH
      rotate y*-90
      rotate z*10
      translate <-6*INCH,0,0>
    }
    object {
      makeWeedPatch(45,1.1,10,0.2,2,5,15,0.5,0.4,seed(23))
      scale 4*INCH
      rotate x*-10
      translate <-6*INCH,0,-1*INCH>
    }
    // Philco841 (mostly hidden)
    object {
      makeWeedPatch(20,1,13,0.2,2,5,20,0.5,0.4,seed(123))
      scale 5*INCH
      rotate y*-90
      rotate z*10
      translate <-6*INCH+4*FOOT,0,0>
    }
    // Philco60b
    object {
      makeWeedPatch(20,1,13,0.2,2,5,20,0.5,0.4,seed(236))
      scale 5*INCH
      rotate y*-90
      rotate z*10
      translate <-6*INCH,0,6*FOOT>
    }
    object {
      makeWeedPatch(45,1.1,10,0.2,2,5,15,0.5,0.4,seed(236))
      scale 4*INCH
      rotate x*-10
      translate <-6*INCH,0,-1*INCH+6*FOOT>
    }
    // Philco60
    object {
      makeWeedPatch(20,1,13,0.2,2,5,20,0.5,0.4,seed(345))
      scale 5*INCH
      rotate y*-90
      rotate z*10
      translate <-6*INCH+8*FOOT,0,6*FOOT>
    }
    object {
      makeWeedPatch(45,1.1,10,0.2,2,5,15,0.5,0.4,seed(345))
      scale 4*INCH
      rotate x*-10
      translate <-6*INCH+8*FOOT,0,-1*INCH+6*FOOT>
    }
    // Crosley7H3
    object {
      makeWeedPatch(20,1,13,0.2,2,5,20,0.5,0.4,seed(347))
      scale 5*INCH
      rotate y*-90
      rotate z*10
      translate <-10*INCH+12*FOOT,0,6*FOOT>
    }
    object {
      makeWeedPatch(75,1.1,14,0.2,2,5,15,0.5,0.4,seed(348))
      scale 4*INCH
      rotate x*-10
      translate <-10*INCH+12*FOOT,0,-1.5*INCH+6*FOOT>
    }
    // Philco841
    object {
      makeWeedPatch(20,1,13,0.2,2,5,20,0.5,0.4,seed(456))
      scale 5*INCH
      rotate y*-90
      rotate z*10
      translate <-6*INCH,0,12*FOOT>
    }
    object {
      makeWeedPatch(45,1.1,10,0.2,2,5,15,0.5,0.4,seed(456))
      scale 4*INCH
      rotate x*-10
      translate <-6*INCH,0,-1*INCH+12*FOOT>
    }
    // Philco116  
    object {
      makeWeedPatch(20,1,13,0.2,2,5,20,0.5,0.4,seed(567))
      scale 5*INCH
      rotate y*-90
      rotate z*10
      translate <-8.75*INCH+4*FOOT,0,12*FOOT>
    }
    object {
      makeWeedPatch(65,1.1,15,0.2,2,5,15,0.5,0.4,seed(567))
      scale 4*INCH
      rotate x*-10
      translate <-8.75*INCH+4*FOOT,0,-1*INCH+12*FOOT>
    }
    // Philco357  
    object {
      makeWeedPatch(20,1,13,0.2,2,5,20,0.5,0.4,seed(678))
      scale 5*INCH
      rotate y*-90
      rotate z*10
      translate <-15.5*INCH+12*FOOT,0,12*FOOT>
    }
    object {
      makeWeedPatch(110,1.1,25,0.2,2,5,15,0.5,0.4,seed(678))
      scale 4*INCH
      rotate x*-10
      translate <-15.5*INCH+12*FOOT,0,-1*INCH+12*FOOT>
    }
  }
  
#end

#if (ShowRadios)
  // row 1
  object {AtKent82 scale INCH translate <0,0,0>} // 1931
  object {Philco841  scale INCH translate <4*FOOT,0,0>} // mostly hidden
  object {Philco357  scale INCH translate <8*FOOT,0,0>} // hidden
  object {AtKent82   scale INCH translate <12*FOOT,0,0>} // hidden
  // row 2
  object {Philco60b  scale INCH translate <0,0,6*FOOT>} // 1936 
  object {Philco60b  scale INCH translate <4*FOOT,0,6*FOOT>} // hidden
  object {Philco60   scale INCH translate <8*FOOT,0,6*FOOT>} // 1935
  object {Crosley7H3 scale INCH translate <12*FOOT,0,6*FOOT>} // 1934 
  // row 3
  object {Philco841  scale INCH translate <0,0,12*FOOT>} // 1934 (model 80 Jr?)
  object {Philco116  scale INCH translate <4*FOOT,0,12*FOOT>} // 1936 (model 630B? 650B?)
  object {Philco841  scale INCH translate <8*FOOT,0,12*FOOT>} // hidden
  object {Philco357  scale INCH translate <12*FOOT,0,12*FOOT>} // 1930s? 
#end

#if (ShowTrees)
  object {Spruce scale 40*FOOT translate <140*YARD, 0, 160*YARD>} // by the farm
  object {Birch scale 12*FOOT rotate 0 translate <112*YARD, 0, 143*YARD>}
  object {Olive scale 50*FOOT translate <60*YARD, 0, 120*YARD>} // by the farm
  object {Olive scale 60*FOOT rotate y*120 translate <130*YARD, 0, 190*YARD>} // by the farm

  object {Olive scale 20*FOOT translate <40*FOOT, 0, -15*FOOT>}
  object {Birch scale 15*FOOT translate <-15*FOOT, 0, 20*FOOT>}
  object {Birch scale 10*FOOT rotate 0 translate <2*FOOT, 0, -12*FOOT>} // just behind camera
#end

#if (ShowCorn)
  // corn field
  object {
    MakeCornField(40, 40)
    scale 3.5*FOOT
    rotate y*-90
    translate <0*YARD, 0, 70*FOOT>
  }
  // make 200 rows of corn where each row gets longer than the last (right side of road)
  union {
    #declare i=0;
    #while (i < 200)
      object {
          MakeCornField(1, 60+i)
          scale 3.5*FOOT
          rotate y*-90
          translate <(26+i)*YARD, 0, 8*YARD+i*2.65*FOOT>
      }
      #declare i=i+1;
    #end
    rotate y*1
  }
#end
  
#if (ShowIronFence)
  union {
    object { mIronFence(38,0.7,56,8 T_IronFence,no) scale INCH rotate y*90 translate <24*FOOT,0,4*FOOT> } // right
    object { mIronFence(38,0.7,56,8 T_IronFence,yes) scale INCH rotate y*180 translate <3.4*FOOT,0,24*FOOT> } // back
    translate <0,0,-2*FOOT>
  }
#end

#if (ShowFarm)
  object {Farm1 scale FOOT translate <100*YARD, 0, 150*YARD> } 
  object {
    mWhiteFence(4*FOOT,5*INCH,100,6*FOOT,T_WhiteFence)
    rotate y*90
    translate <35*YARD,0,160*YARD>
  }
  object {
    mWhiteFence(4*FOOT,5*INCH,40,6*FOOT,T_WhiteFence)
    rotate y*-45
    translate <65*YARD,0,84*YARD>
  }
#end

#if (ShowRoad)
  box { 0, <7*YARD,4*INCH,800*YARD> 
    texture { T_Road }
    translate <15*YARD,0,-20*YARD>
  }
  box { 0, <7*YARD,4.0001*INCH,800*YARD> 
    texture { T_Road }
    rotate y*45
    translate <15*YARD,0,20*YARD>
  }
#end

#if (ShowCameraPos)
  sphere {
    <-24, 17, -35>*INCH, 1
    pigment {Blue}
  }
#end

#if (ShowClouds) 
  // fast_clouds2
  #declare fcloud_count = 400;
  #declare fcloud_min_xtnt = <-50,0,-50>;
  #declare fcloud_max_xtnt = <50,50,50>;
  #declare fcloud_scale_min = <6,3,6>;
  #declare fcloud_scale_max = <10,5,10>;
  #declare fcloud_turb = .5;
  #declare fcloud_lambda = .1;
  #declare fcloud_highlight_angle = 25; // in relation to light_source
  #declare fcloud_rotate = <0,-30,0>;
  #declare fcloud_color =  <1,.8,.8>*3;
  
  #include "clouds.inc"
  
  object{ Nuage
    scale <1000,400,1000>
    translate <0,2000*FOOT,5000*FOOT>
  }
#end

