// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

// unit of measure is "Feet"

#version 3.5;

#include "colors.inc"

#declare T_BarnWood =
  texture {
    pigment {Red}
  }
  texture {
    pigment { 
      granite
      color_map {
        [0 rgbf <0.01,0.01,0,1>]
        [1 rgbf <0.5,0.5,0.45,0.5>]
      }
      scale <1,100,1>
    }
  }
  
#declare T_BarnRoof =
  texture {
    pigment {Green*0.15}
  }
  texture {
    pigment { 
      granite
      color_map {
        [0 rgbf <0.1,0.1,0.1,1>]
        [1 rgbf <0.3,0.3,0.3,0.5>]
      }
      scale <1,1,10>
    }
  }

#declare T_SiloTop =
  texture {
    pigment {
      radial
      frequency 12
      color_map {
        [0.00 White ]
        [0.8 White ]
        [1.00 Black ]
      }
    }
  }
  texture {
    pigment { 
      agate
      color_map {
        [0.02 rgbf <0.3,0.2,0.1,1>]
        [0.1 rgbf <0.6,0.34,0.22,1>]
        [0.15 rgbf <0.8,0.40,0.33,1>]
        [0.4 rgbf <1,1,1,1>]
      }
    }
    scale 20
  }

#declare T_Silo =
  texture { 
    pigment { 
      gradient y
      color_map {
        [0.00 White ]
        [0.95 White ]
        [1.00 Black ]
      }
      scale 3
    }
  }
  texture { 
    pigment { 
      radial
      frequency 16
      color_map {
        [0.00 rgbf <1,1,1,1> ]
        [0.95 rgbf <1,1,1,1> ]
        [1.00 rgbf <0,0,0,1> ]
      }
      scale 3
    }
  }
  texture {
    pigment { 
      agate
      color_map {
        [0.0 rgbf <0.3,0.2,0.15,1>]
        [0.1 rgbf <0.6,0.45,0.4,1>]
        //[0.1 rgbf <0.3,0.07,0.01,1>]
        //[0.15 rgbf <0.6,0.14,0.02,1>]
        [1 rgbf <1,1,1,1>]
      }
    }
    scale <40,80,40>
  }

#declare T_WindMill =
  texture {
    pigment {
      bozo
      color_map {
        [0.0 rgb <0.3,0.2,0.15>]
        [0.1 rgb <0.6,0.45,0.4>]
        [1 rgb <1,1,1>]
      }
      scale 3
    }
  }
  texture {
    pigment { 
      agate
      color_map {
        [0.02 rgbf <0.1,0.01,0,1>]
        [0.1 rgbf <0.3,0.07,0.01,1>]
        [0.15 rgbf <0.6,0.14,0.02,1>]
        [0.4 rgbf <1,1,1,1>]
      }
    }
    scale 20
  }
  
#declare T_WindMillRed =
  texture {
    pigment {
      bozo
      color_map {
        [0.0 rgb <0.3,0.2,0.15>]
        [0.1 rgb <0.6,0.45,0.4>]
        [1 Red]
      }
      scale 3
    }
  }
  texture {
    pigment { 
      agate
      color_map {
        [0.02 rgbf <0.1,0.01,0,1>]
        [0.1 rgbf <0.3,0.07,0.01,1>]
        [0.15 rgbf <0.6,0.14,0.02,1>]
        [0.4 rgbf <1,1,1,1>]
      }
    }
    scale 20
  }
  
#declare T_HouseSiding =
  texture {
    pigment {White}
  }
  texture {
    pigment { 
      granite
      color_map {
        [0 rgbf <0.4,0.4,0.4,1>]
        [1 rgbf <1,1,1,1>]
      }
      scale <300,1,300>
    }
  }
  

// ----------------------------------------


#declare LightningRod = 
  union {
    lathe {
      cubic_spline
      15,
      <1.00,0.00>,
      <1.00,0.00>,
      <1.00,5.00>,
      <2.00,6.00>,
      <1.00,7.00>, 
      <2.00,8.00>,
      <1.00,9.00>, 
      <3.00,10.00>,
      <1.00,11.00>,
      <2.00,12.00>,
      <1.00,14.00>,
      <2.00,15.00>,
      <2.00,16.00>,
      <0.00,20.00>,
      <0.00,21.00> 
      scale 1/20
      translate y*8  
    }
    cylinder { 0, <0,8,0>, 0.05 }
    pigment { Black }
  }
  
#declare Barn1Roof =
  union {
    box { <-32,-0.1,-11>, <32,0.1,0>
      texture {T_BarnRoof}
      rotate x*-30
      translate y*30
    }
    box { <-32,-0.1,-11>, <32,0.1,0>
      texture {T_BarnRoof}
      rotate x*210
      translate y*30
    }
    box { <-32,-0.1,-13>, <32,0.1,0>
      texture {T_BarnRoof}
      rotate x*-60
      translate y*24.5+z*-9.5
    }
    box { <-32,-0.1,-13>, <32,0.1,0>
      texture {T_BarnRoof}
      rotate x*240
      translate y*24.5+z*9.5
    }
    object { LightningRod translate <0,30,0> }
    object { LightningRod translate <-25,30,0> }
    object { LightningRod translate <25,30,0> }
  }
                               
#declare Barn1 =
  union {
    difference {
      box { <-30,0,-15>, <30,30,15>
        texture { T_BarnWood }
      }
      plane {-y, 0 rotate x*30 translate y*30 }
      plane {-y, 0 rotate x*-30 translate y*30 }
      plane {-y, 0 rotate x*60 translate y*24.5+z*9.5 }
      plane {-y, 0 rotate x*-60 translate y*24.5+z*-9.5 }
    }
    object {Barn1Roof } 
  }

#declare HouseRoof =
  union {
    box { <-21,-0.1,-19>, <21,0.1,0>
      texture {T_BarnRoof}
      rotate x*-30
      translate y*30
    }
    box { <-21,-0.1,-19>, <21,0.1,0>
      texture {T_BarnRoof}
      rotate x*210
      translate y*30
    }
  }

#declare HouseWindow =
  union {
    // window
    box { <-1,-2,-0.01>, <1,2,0.01> 
      texture {
        pigment { Black }
        finish { diffuse 0.5 specular 0.99 roughness 0.0001 reflection 0.05 }
        normal { bumps 0.01 }  
      }
    }
    // frame, etc
    box { <-1.1,-2.2,-0.1>, <-1,2.2,0.1>
      texture { T_HouseSiding }
    }
    box { < 1.1,-2.2,-0.1>, < 1,2.2,0.1>
      texture { T_HouseSiding }
    }
    box { <-1,-2,-0.1>, < 1,-2.2,0.1>
      texture { T_HouseSiding }
    }
    box { <-1,2,-0.1>, < 1,2.2,0.1>
      texture { T_HouseSiding }
    }
    box { <-0.025,-2,-0.05>, <0.025,2,0.05>
      texture { T_HouseSiding }
    }
    box { <-1,-0.025,-0.05>, <1,0.025,0.05>
      texture { T_HouseSiding }
    }
    // shutters
    box { <-1.1,-2,-0.1>, <-2,2,0.1>
      texture {T_BarnRoof scale <2,0.3,2>}
    }
    box { <1.1,-2,-0.1>, <2,2,0.1>
      texture {T_BarnRoof scale <2,0.3,2>}
    }
  }
  
#declare HouseChimney =
  box { <20,0,-1.5>,<21.5,35,1.5>
    texture { 
      pigment { 
        agate
        color_map {
          [0.0 rgb <0.4,0.15,0.1>]
          [1 rgb <0.7,0.35,0.3>]
        }
      }
    }
  }
  
#declare House1 =
  union {
    difference {
      box { <-20,0,-15>, <20,30,15>
        texture { T_HouseSiding }
      }
      plane {-y, 0 rotate x*30 translate y*30 }
      plane {-y, 0 rotate x*-30 translate y*30 }
    }
    object { HouseRoof }
    object { HouseChimney }
    
    object { HouseWindow translate <-10,15,-15> }
    object { HouseWindow translate <0,15,-15> }
    object { HouseWindow translate <10,15,-15> }
    object { HouseWindow translate <-10,5,-15> }
    object { HouseWindow translate <0,5,-15> }
    object { HouseWindow translate <10,5,-15> }

    object { HouseWindow rotate y*90 translate <20,15,-8> }
    object { HouseWindow rotate y*90 translate <20,15,8> }
  }
  
#declare Silo1 =
  union {
    cylinder { 0, <0,45,0>, 8 
      texture { T_Silo }
    }
    sphere { <0,45,0>, 8 
      texture { T_SiloTop }
    }
  }
  
#declare WindMill =
  union {
    // the windmill part
    #local i=0;
    #while (i < 18)
      object {
        difference {
          cone { 0, 2, <0,2.5,0>,1.25 rotate x*-19 }
          cone { <0,-0.001>, 1.99, <0,2.501,0>,1.24 rotate x*-19 }
          plane { -z, 1.88}
        }
        translate <0,-1.25,1.88>
        rotate y*150
        translate y*4
        rotate z*360/18*i
        translate y*40
        texture { T_WindMill scale 0.2 translate i }
      }
      #local i=i+1;
    #end
    // inner ring
    difference {
      cylinder { <0,0,-0.05>,<0,0,0.05>, 2.3 }
      cylinder { <0,0,-0.051>,<0,0,0.051>, 2.25 }
      texture { T_WindMillRed }
      translate y*40
    }            
    // outer ring
    difference {
      cylinder { <0,0,-0.05>,<0,0,0.05>, 4.1 }
      cylinder { <0,0,-0.051>,<0,0,0.051>, 4.05 }
      texture { T_WindMillRed }
      translate y*40
    }
    // spindle
    cylinder { <0,0,-0.5>,<0,0,1.1>, 0.3 
      translate y*40
      texture { T_WindMillRed }
    }
    // spindle rings
    torus { 0.4, 0.04
      rotate x*90 
      translate <0,40,-0.3>
      texture { T_WindMillRed }
    }
    torus { 0.4, 0.04
      rotate x*90 
      translate <0,40,0.3>
      texture { T_WindMillRed }
    }
    // wires
    #local i=0;
    #while (i < 6)
      cylinder { 0, 3.7*y, 0.02 
        rotate x*-5.5
        translate z*0.3
        translate y*0.4
        rotate z*(360/18/2 + 360/6*i)
        translate y*40
        texture { T_WindMillRed }
      }
      cylinder { 0, 3.7*y, 0.02 
        rotate x*5.5
        translate z*-0.3
        translate y*0.4
        rotate z*(360/18/2 + 360/6*i)
        translate y*40
        texture { T_WindMillRed }
      }
      #local i=i+1;
    #end
    // tail
    prism {
      linear_spline
      -0.02, 0.02, 7
      <1,0>
      <1,3>
      <0.25, 3.5>
      <-0.25, 3.5>
      <-1,3>
      <-1,0>
      <1,0>
      rotate <0,180,90>
      translate <0,40,8>
      pigment {White}
    }
    prism {
      linear_spline
      -0.02, 0.02, 6
      <1,0>
      <1,2>
      <0, 2>
      <-0.5,1.5>
      <-0.5,0>
      <1,0>
      rotate <0,180,90>
      translate <0,41,2.5>
      pigment {White}
    }
    cylinder { 0, <0,0,5>, 0.05
      rotate y*-3
      translate x*0.3
      texture { T_WindMillRed }
      translate y*40
      translate z*1
    }
    cylinder { 0, <0,0,5>, 0.05
      rotate y*3
      translate x*-0.3
      texture { T_WindMillRed }
      translate y*40
      translate z*1
    }
    // scaffold/legs
    union {
      #local i = 0;
      #while (i < 4)
        union {
          box { 0, <0.2,-39,0.05> }
          box { 0, <0.05,-39,0.2> }
          rotate y*225
          rotate z*8
          rotate y*360/4*i
          translate <0,39,0>
          texture { T_WindMill translate i }
        }
        #local i=i+1;
      #end
      translate 1*z
    }
    cylinder { 0, <0,1.1,0>, 0.2
      translate <0,39,1>
      texture { T_WindMillRed }
    }
    #local j = 0;
    #while (j < 4)
      union {
        #local i = 0;
        #while (i < 4)
          union {
            #local barLen = 6.3/(j*j*0.34+1);
            box { 0, <barLen,0.2,0.05> }
            box { 0, <barLen,0.05,0.2> }
            rotate x*180
            translate <-barLen/2,8*(j+1),barLen/2>
            rotate y*(360/4*i + 360/4/2)
            texture { T_WindMill translate i }
          }
          #local i=i+1;
        #end
        translate 1*z
      }
      #local j=j+1;
    #end
  }
  
//---------------------------
#declare T_WhiteFence =
  texture {
    pigment {White}
  }


#macro mWhiteFencePost(l, w, th, tex)
  #local rSeed = seed(234);
  #local p1 = <-w/2,-l/2,-th/2>;
  #local p2 = <w/2,l/2,th/2>;
  #local r = rand(rSeed);
  box { p1, p2 }
  texture { 
    tex
    translate <r,r,r>
  }
#end // mWhiteFencePost

#macro mWhiteFence(bl,bw,numPosts,gap,tex)
  #local i = 0;
  #local boardThick = bw/6;
  union {
    #while (i < numPosts)
      object {
        mWhiteFencePost(bl,bw,bw,tex) // a post
        translate <(bw+gap)*i,0,0>
      }
      // add the horizontal bars
      #if (i != 0) // #gaps = #posts-1
        object { 
          mWhiteFencePost(gap+bw,bw,boardThick,tex) // top board
          rotate z*90
          translate <(bw+gap)*i-(bw+gap)/2,(bl*3/4)-(bl/2),-bw/2-boardThick/2>
        }
        object { 
          mWhiteFencePost(gap+bw,bw,boardThick,tex) // bottom board
          rotate z*90
          translate <(bw+gap)*i-(bw+gap)/2,(bl*1/3)-(bl/2),-bw/2-boardThick/2>
        }
      #end
      #local i = i + 1;
    #end
    translate <-(bw+gap)*(numPosts-1)/2,bl/2,0>
  }
#end // mWhiteFence


#declare Farm1 =
  union {
    object {Barn1} 
    object {Silo1 translate <-40,0,20>}
    object {Silo1 rotate y*180 scale 1.1 translate <-25,0,35>}
    object {WindMill scale 1.2 translate <60,0,0>}
    object {House1 rotate y*90 translate <150,0,100> }
  }


