//kettingwiel moet uitgediept worden
// 20030109 Roef Mahlmann. Uurwerk tandwielen ed voor een klok
// poging irtc jan-feb 2003 Old Technology
//
//           +y
//           | /+Z
//           |/                  maten ongeveer in mililmeter !!!!!!!
//           |---> +X

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"

global_settings{ assumed_gamma 2.0}
#declare Mooi=true;		//gewelvde (=true) stangen of rechte (=false)
#declare Wortel2=sqrt(2);
#declare R0=seed(0);

//--- camera(s) ------------------------------------------
camera {
  angle 30
  up<0,1.33,0>		//default <0,1,0>
  right<1,0,0>		//default <1.33,0,0>
  aperture 10
  focal_point <60,60,40>
  blur_samples 100
//  blur_samples 10
  variance 1/10000
  location <260,104,105> look_at  <60, 60,40>		//inzending itrc
//location<300,110,-90> look_at<60,70,50>		//hoog vooropzij
//location <190,90,95> look_at  <60, 90,95> }		//pilaar
//location<250,1,-40> look_at<60,70,50>			//laag vooropzij
//location <150,150,-300> look_at  <60,40,50> 		//hoog rechtsvoor 
//location <-90,80,-50> look_at  <60,121,45> 		//vooraanzicht spijkerwiel
//location <150,90,-120> look_at  <70,70,10> 		//uren/minuten wiel
//location <90,105,-50> look_at  <77,70,20> 		//bouw
}

//--- lampje ---------------------------------------------
light_source { <2000,4000,-3000> color White}
light_source { <2000,40,300> color White}
light_source { <2000,40,900> color White}
//light_source { <200,40,-450> color White}

//--- textures -------------------------------------------
//--- uit metals.inc -----
#if (Mooi=true) //--- mooie of simpele stangen ---
#declare Brons =texture{T_Brass_3B normal{bumps 0.1 scale 0.1}}
#declare Brons1=texture{T_Brass_3C}
#declare Brons2=texture{pigment{color P_Gold1}   finish{F_MetalA}}
#declare Staal =texture{T_Chrome_3B normal{bumps 0.20 scale 0.1}}
#declare Staal2=texture{T_Chrome_3D normal{bumps 0.10 scale 0.1}}
#declare Gordijn= texture{ pigment{ color rgb<0.05,0.4,0.2> }}//normal{bumps 0.5 scale 1} }
//#declare Gordijn= texture{ pigment{ color rgb<0.4,0.6,0.2> }}//normal{bumps 0.5 scale 1} }
#declare Tafel= texture{ pigment { granite
      color_map{ [0.00 rgb<0.73,0.33,0.17>] [1.00 rgb<0.63,0.18,0.09>] }
      scale 100
    }
    normal{bumps 0.05 scale 0.1}
  }
#declare Muur= texture{ pigment { granite
      color_map{ [0.00 rgb<0.73,0.63,0.17>] [1.00 rgb<0.63,0.68,0.09>] }
      scale 100
    }
    normal{bumps 0.05 scale 0.1}
  }
#else
#declare Brons =texture{pigment{color P_Brass3}}
#declare Brons1=texture{pigment{color P_Brass3}}
#declare Brons2=texture{pigment{color P_Gold1}}
#declare Staal =texture{pigment{color P_Chrome3}}
#declare Gordijn= texture{pigment{color rgb<0.05,0.4,0.2>}}
#declare Tafel =texture{pigment{color rgb<0.63,0.18,0.09>}}
#declare Muur  =texture{pigment{color rgb<0.63,0.68,0.09>}}
#end

//--- omgeving -------------------------------------------
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 color Blue]
      [0.5 color rgb<0.1,0.3,0.9>]
      [1.0 color White]
    }
    scale 2
    translate -0.8
  }
}

//--- Vloer ----------------------------------------------
plane{y,-200 texture{pigment{color rgb<0.7,0.6,0.3>}}}

//--- oplegstaaf (H-bint) onder klok ---------------------
#declare Di=1;
#declare La=150;
union{
  box{<   0,     0,0><1*Di,8.0*Di,La>}
  box{<7*Di,     0,0><8*Di,8.0*Di,La>}
  box{<1*Di,3.5*Di,0><7*Di,4.5*Di,La>}
  translate<10,-8*Di,-20>
  texture{Brons1}
}
union{
  box{<   0,     0,0><1*Di,8.0*Di,La>}
  box{<7*Di,     0,0><8*Di,8.0*Di,La>}
  box{<1*Di,3.5*Di,0><7*Di,4.5*Di,La>}
  translate<110-8*Di,-8*Di,-20>
  texture{Brons1}
}

//--- tafelblad ------------------------------------------
union{
  box{<-150,-8*Di-20,-200><200,-8*Di,300>}
  cylinder{<-130,-200,-180><-80,-8*Di,-180>,10}
  cylinder{<-130,-200, 180><-80,-8*Di, 180>,10}
  cylinder{< 180,-200,-180><180,-8*Di,-180>,10}
  cylinder{< 180,-200, 180><180,-8*Di, 180>,10}
  texture{Tafel}
}

//--- muur -----------------------------------------------
box{<-200,-100, 300>< 400,400,310> texture{Muur} }
box{<-200,-100,-300><-210,400,310> texture{Muur} }

//--- gordijn --------------------------------------------
union{
  #declare Breed=600;
  #declare Hoog=500;
  #declare Diep=20;
  #declare Diep2=50;
  #declare X0=0;
  #while (X0<Breed-Diep/2)
    #declare Z0=rand(R0)*Diep;
    cone{<X0,-0.02,Z0>,Diep<X0,-Hoog,Z0>Diep2
      texture {Gordijn }
    }
    #declare X0=X0+rand(R0)*Diep;
  #end
  #declare X0=Breed;                            //laatste maken
  #declare Z0=rand(R0)*Diep;
  cone{<X0,-0.02,Z0>,Diep<X0,-Hoog,Z0>Diep2
    texture {Gordijn}
  }
  rotate<0,90,0>
  translate<-220,300,200>
}


//--- macro tandwiel -------------------------------------
//Tanden=aantal tanden
//Straal0 = buitenste straal, tandpunten
//Straal1 = binnenste straal, tussen de tanden
//Dik = dikte van het tandwiel
#macro Tandwiel(Tanden,Straal0,Straal1,Dik)
#declare ScaleB=pi*Straal1/(2*Tanden);
#declare ScaleH=(Straal0-Straal1)/2;
#declare Radia2=sqrt(ScaleB*ScaleB*4+Straal1*Straal1);
#declare Tand=0;
union{
  #while (Tand<Tanden)
  difference{
    box{<-Wortel2,-Wortel2,0><Wortel2,Wortel2,Dik>
      rotate <0,0,45>
    }
    box{<-3,-3,-0.1><3,0,Dik+0.1>}
      scale <ScaleB,ScaleH,1>
      translate <0,Straal1,0>
      rotate <0,0,360*Tand/Tanden>
    }
    #declare Tand=Tand+1;
    #end
  cylinder{<0,0,0><0,0,Dik>,Radia2}
  }
#end

//--- tandwiel na de slinger -----------------------------
// asymetrische tanden
#declare Tandwiel_spike=
difference{
  #declare Tanden=32;
  #declare Straal0=20;			//binnenstraal tanden
  #declare Straal1=24;			//buitenstraal tanden
  #declare Straal2=16;			//straal van gat in wiel
  #declare Straal3=12;			//straal van gat in wiel
  #declare Straal3_off=18;		//offset van knipgat
  #declare Dik=2;			//dikte tandwiel

  #declare Tand=0;
  union{
    #while (Tand<Tanden)
    difference{
      cylinder{<Straal1  ,  0    ,Straal1-18>
               <Straal1  ,Dik    ,Straal1-18>,Straal1}
      cylinder{<Straal1+6,   -0.1,Straal1-6 >
               <Straal1+6,Dik+0.1,Straal1-6 >,Straal1}
      cylinder{<Straal1+7,   -0.1,Straal1-38>
               <Straal1+7,Dik+0.1,Straal1-38>,Straal1}
      rotate <0,360*Tand/Tanden,0>
    }
    #declare Tand=Tand+1;
    #end
    cylinder{<0,0,0><0,Dik,0>,Straal0}
  }
  intersection{					//gat in tandwiel
    cylinder{<0,-0.1,0><0,Dik+0.1,0>Straal2}
    cylinder{<Straal3_off,-0.1,0><Straal3_off,Dik+0.1,0>Straal3}
  }
  intersection{					//gat in tandwiel
    cylinder{<0,-0.1,0><0,Dik+0.1,0>Straal2}
    cylinder{<Straal3_off,-0.1,0><Straal3_off,Dik+0.1,0>Straal3}
    rotate<0, 90,0>
  }
  intersection{					//gat in tandwiel
    cylinder{<0,-0.1,0><0,Dik+0.1,0>Straal2}
    cylinder{<Straal3_off,-0.1,0><Straal3_off,Dik+0.1,0>Straal3}
    rotate<0,180,0>
  }
  intersection{					//gat in tandwiel
    cylinder{<0,-0.1,0><0,Dik+0.1,0>Straal2}
    cylinder{<Straal3_off,-0.1,0><Straal3_off,Dik+0.1,0>Straal3}
    rotate<0,270,0>
  }
texture{Brons}
}

//--- pendule as -----------------------------------------
#declare Asp=
  cylinder{<0,0,30><0,0,108>,1.5
  texture{Staal2}
}
//--- pendule tandwiel -----------------------------------
#declare Spikes=
union{
#declare Dik=4;
  difference{
    union{
      box{<0,0,0>< 21,-10,Dik>rotate<0,0,-25>}
      box{<0,0,0><-21,-10,Dik>rotate<0,0, 25>}
      translate<0,3,0>
    }
    cylinder{<0,-33,-1><0,-33,Dik+1>,29}
  }
  box{<-1,-1,0><1,1,Dik>
    rotate<0,0,45>
    scale<1,3.5,1>
    rotate<0,0,-35>
    translate<16,-10,0>
  }
  box{<-1,-1,0><1,1,Dik>
    rotate<0,0,45>
    scale<1,3.5,1>
    rotate<0,0, 35>
    translate<-16,-10,0>
  }
  texture{Brons}
}

//--- ketting tandwiel -----------------------------------
#declare Kettingwiel=
union{
#declare Tanden=12;
#declare Straal0=11.9;			//binnenstraal tanden
#declare Straal1=21.5;			//buitenstraal tanden
#declare Dik=5;				//dikte tandwiel
  difference{
    union{
      torus{Straal1-Dik,Dik/2 translate<0, Dik/2+1,0>}
      torus{Straal1-Dik,Dik/2 translate<0,-Dik/2-1,0>}
    }
    cylinder{<0, Dik/2+0.3,0><0, Dik+1.1,0>,Straal1}
    cylinder{<0,-Dik/2-0.3,0><0,-Dik-1.1,0>,Straal1}
    translate<0,Dik/2,0>
  }
  union{				//randje buitenkant
    cylinder{<0, Dik/2+0.3,0><0, Dik/2+1.3,0>,Straal1+2}
    cylinder{<0,-Dik/2-0.3,0><0,-Dik/2-1.3,0>,Straal1+2}
    translate<0,Dik/2,0>
  }
  #declare Tand=0;
    union{
      #while (Tand<Tanden)
      difference{
        box{<-Wortel2,Dik*0.4,-Wortel2><Wortel2,Dik*0.6,Wortel2>
          rotate <0,45,0>
        }
        box{<-3,-0.1,-3><3,Dik+0.1,0>}
        scale <Straal0*0.25,1,Straal0*0.5>		//x bepaald breedte tand
        translate <0,0,Straal1-Straal0>
        rotate <0,360*Tand/Tanden,0>
      }
      #declare Tand=Tand+1;
      #end
    }
  rotate<90,0,0>
  texture{Staal}
}
//--- ketting --------------------------------------------
#declare KettingSchakel=union{
#declare Len=1.2;
  intersection{
    torus{2.0,0.5}
    box{<-3.6,-1.1,-3.6>< 0.0,1.1,3.6>}
    translate<-Len,0,0>
  }
  intersection{
    torus{2.0,0.5}
    box{<0.0,-1.1,-3.6>< 3.6,1.1,3.6>}
    translate<Len,0,0>
  }
  cylinder{<-Len,0,-2.0><Len,0,-2.0>,0.5}
  cylinder{<-Len,0, 2.0><Len,0, 2.0>,0.5}
}

#declare Ketting1=union{
#declare X1=0;
  #while (X1<100)
    object{KettingSchakel rotate< 0, 0, 0> translate <0,0,X1+0>}
    object{KettingSchakel rotate< 0, 0,90> translate <0,0,X1+6>}
    #declare X1=X1+12;
  #end
}

#declare Ketting=
#declare Straal0=20;
#declare Incr=5.4;   //(=Len+2-0.5+2-0.5
union{
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0,-90> translate<0,-8*Incr,0>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0,-90> translate<0,-7*Incr,0>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0,-90> translate<0,-6*Incr,0>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0,-90> translate<0,-5*Incr,0>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0,-90> translate<0,-4*Incr,0>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0,-90> translate<0,-3*Incr,0>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0,-90> translate<0,-2*Incr,0>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0,-90> translate<0,-1*Incr,0>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0,-90>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0,-75>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0,-60>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0,-45>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0,-30>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0,-15>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0,  0>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0, 15>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0, 30>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0, 45>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0, 60>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0, 75>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0, 90>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0, 90> translate<0,-1*Incr,0>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0, 90> translate<0,-2*Incr,0>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0, 90> translate<0,-3*Incr,0>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0, 90> translate<0,-4*Incr,0>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0, 90> translate<0,-5*Incr,0>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0, 90> translate<0,-6*Incr,0>}
  object{KettingSchakel rotate<90,0,0>translate<0,Straal0,0>rotate<0,0, 90> translate<0,-7*Incr,0>}
  object{KettingSchakel               translate<0,Straal0,0>rotate<0,0, 90> translate<0,-8*Incr,0>}
  texture{Brons2}
}

//--- as 0 -----------------------------------------------
#declare As0=
  cylinder{<0,0,0><0,0,18>,1.5
  texture{Staal2}
}
#declare Tandwiel_0_0=
  #declare Tanden=33;
  #declare Straal0=14;			//binnenstraal tanden
  #declare Straal1=12;			//buitenstraal tanden
  #declare Dik=2;			//dikte tandwiel
  object{Tandwiel(Tanden,Straal0,Straal1,Dik)
  texture{Brons}
}
#declare Tandwiel_0_1=
union{
  #declare Tanden=54;
  #declare Straal0=31;			//buitenstraal tanden
  #declare Straal1=29;			//binnenstraal tanden
  #declare Dik=2;			//dikte tandwiel
  object{Tandwiel(Tanden,Straal0,Straal1-1,Dik)}
  cylinder{<0,0,0><0,0,Dik>,Straal1}
  sphere{<0,0,0>,Straal0/2 scale<1,1,0.1>}
  texture{Brons}
}
//--- as 1 -----------------------------------------------
#declare As1=				//voor kettingwiel
union{
  cylinder{<0,0,18><0,0,57>,3.5}
  cylinder{<0,0, 2><0,0,58.3>,2}
  cylinder{<0,0,-1><0,0,2>,0.5}
  texture{Staal2}
}
//--------------------
#declare Tandwiel_1_1=
difference{
#declare Tanden=79;
#declare Straal0=29;			//buitenstraal tanden
#declare Straal1=27;			//binnenstraal tanden
  #declare Rgat2=23;			//straal van gat in wiel
  #declare Rgat3=38;			//straal van gat in wiel
  #declare Rgat3_off=47;		//offset van knipgat
#declare Dik=3;				//dikte tandwiel

  object{Tandwiel(Tanden,Straal0,Straal1,Dik)}
  intersection{					//gat in tandwiel
    cylinder{<0,0,-0.1><0,0,Dik+0.1>Rgat2}
    cylinder{<Rgat3_off,0,-0.1><Rgat3_off,0,Dik+0.1>Rgat3}
  }
  intersection{					//gat in tandwiel
    cylinder{<0,0,-0.1><0,0,Dik+0.1>Rgat2}
    cylinder{<Rgat3_off,0,-0.1><Rgat3_off,0,Dik+0.1>Rgat3}
    rotate<0,0,120>
  }
  intersection{					//gat in tandwiel
    cylinder{<0,0,-0.1><0,0,Dik+0.1>Rgat2}
    cylinder{<Rgat3_off,0,-0.1><Rgat3_off,0,Dik+0.1>Rgat3}
    rotate<0,0,-120>
  }
  texture{Brons}
}
//--------------------
#declare Tandwiel_1_2=
  #declare Tanden=44;
  #declare Straal0=21;			//binnenstraal tanden
  #declare Straal1=19;			//buitenstraal tanden
  #declare Dik=2;			//dikte tandwiel
  object{Tandwiel(Tanden,Straal0,Straal1,Dik)
  texture{Brons}
}
//--------------------
#declare Tandwiel_1_3=
  #declare Tanden=6;
  #declare Straal0=4;			//binnenstraal tanden
  #declare Straal1=2;			//buitenstraal tanden
  #declare Dik=4;			//dikte tandwiel
union{
  object{Tandwiel(Tanden,Straal0,Straal1,Dik)}
  cylinder{<0,0,0><0,0,-0.1>,6}
  texture{Brons}
}
//--- as 2 -----------------------------------------------
#declare As2=				//vertraging
union{
  cylinder{<0,0,18><0,0,57>,1.5}
  cylinder{<0,0,14.7><0,0,58.3>,0.5}
  texture{Staal2}
}
//--------------------
#declare Tandwiel_2_0=
  #declare Tanden=10;
  #declare Straal0=4;			//binnenstraal tanden
  #declare Straal1=2;			//buitenstraal tanden
  #declare Dik=5;			//dikte tandwiel
  object{Tandwiel(Tanden,Straal0,Straal1,Dik)
  texture{Staal}
}
//--------------------
#declare Tandwiel_2_1=
  #declare Tanden=66;
  #declare Straal0=25;			//binnenstraal tanden
  #declare Straal1=23;			//buitenstraal tanden
  #declare Straal2=19;
  #declare Straal3=22;
  #declare Straal3_off=27;		//offset van knipgat
  #declare Dik=3;			//dikte tandwiel
difference{
  object{Tandwiel(Tanden,Straal0,Straal1,Dik)}
  intersection{					//gat in tandwiel
    cylinder{<0,0,-0.1><0,0,Dik+0.1>Straal2}
    cylinder{<Straal3_off,0,-0.1><Straal3_off,0,Dik+0.1>Straal3}
  }
  intersection{					//gat in tandwiel
    cylinder{<0,0,-0.1><0,0,Dik+0.1>Straal2}
    cylinder{<Straal3_off,0,-0.1><Straal3_off,0,Dik+0.1>Straal3}
    rotate<0,0,120>
  }
  intersection{					//gat in tandwiel
    cylinder{<0,0,-0.1><0,0,Dik+0.1>Straal2}
    cylinder{<Straal3_off,0,-0.1><Straal3_off,0,Dik+0.1>Straal3}
    rotate<0,0,-120>
  }
  
  texture{Brons}
}
//--- as 3 -----------------------------------------------
#declare As3=				//as met spike tandwiel
union{
  cylinder{<0,0,14.7><0,0,18>,0.5}
  cylinder{<0,0,18><0,0,26>,1.0}
  cone{<0,0,26>,1<0,0,37>,1.5}
  cylinder{<0,0,37><0,0,46>,1.5}
  cylinder{<0,0,46><0,0,55>,1.0}
  cylinder{<0,0,14.7><0,0,58.3>,0.5}
  texture{Staal2}
}
//--------------------
#declare Tandwiel_3_1=
  #declare Tanden=10;
  #declare Straal0=4;			//binnenstraal tanden
  #declare Straal1=2;			//buitenstraal tanden
  #declare Dik=5;			//dikte tandwiel
  object{Tandwiel(Tanden,Straal0,Straal1,Dik)
  texture{Staal}
}
//--- as 4 -----------------------------------------------
// voor de slinger 

//--- as 5 -----------------------------------------------
#declare As5=				//Kettingwiel voor slagwerk
union{
  cylinder{<0,0,56><0,0,89>,2.5}
  cylinder{<0,0,54.7><0,0,92>,0.5}
  texture{Staal2}
}
//--------------------
#declare Tandwiel_5_1=
union{
#declare Tanden=79;
#declare Straal0=28;			//binnenstraal tanden
#declare Straal1=26;			//buitenstraal tanden
#declare Rgat1=21;			//Straal rand gat
#declare Dik=3;				//dikte tandwiel
  difference{
    object{Tandwiel(Tanden,Straal0,Straal1,Dik)}
    cylinder{<0,0,-0.1><0,0,Dik+0.1>,Rgat1}
  }
  cylinder{<0,0,0><0,0,Dik>,5}
  box{<-2,-Rgat1,0><2,Rgat1,Dik>}
  box{<-Rgat1,-2,0><Rgat1,2,Dik>}

  texture{Brons}
}
//--- as 6 -----------------------------------------------
#declare As6=				//vertraging
union{
  cylinder{<0,0,56><0,0,89>,1.5}
  cylinder{<0,0,54.7><0,0,92>,0.5}
  texture{Staal2}
}
//--------------------
#declare Tandwiel_6_0=
  #declare Tanden=10;
  #declare Straal0=4;			//binnenstraal tanden
  #declare Straal1=2;			//buitenstraal tanden
  #declare Dik=5;			//dikte tandwiel
  object{Tandwiel(Tanden,Straal0,Straal1,Dik)
  texture{Staal}
}
//--------------------
#declare Tandwiel_6_1=
union{
  #declare Tanden=60;
  #declare Straal0=21;			//binnenstraal tanden
  #declare Straal1=19;			//buitenstraal tanden
  #declare Rgat1=17;			//Straal rand gat
  #declare Dik=3;			//dikte tandwiel
  difference{
    object{Tandwiel(Tanden,Straal0,Straal1,Dik)}
    cylinder{<0,0,-0.1><0,0,Dik+0.1>,Rgat1}
  }
  cylinder{<0,0,0><0,0,Dik>,4}
  box{<-1.5,-Rgat1,0><1.5,Rgat1,Dik>}
  box{<-Rgat1,-1.5,0><Rgat1,1.5,Dik>}
  texture{Brons}
}
//--- as 7 -----------------------------------------------
#declare As7=				//vertraging
union{
  cylinder{<0,0,56><0,0,89>,1.5}
  cylinder{<0,0,54.7><0,0,92>,0.5}
  texture{Staal2}
}
//--------------------
#declare Tandwiel_7_0=
union{
  #declare Tanden=60;
  #declare Straal0=20;			//binnenstraal tanden
  #declare Straal1=18;			//buitenstraal tanden
  #declare Rgat1=16;			//Straal rand gat
  #declare Dik=2;			//dikte tandwiel
  difference{
    object{Tandwiel(Tanden,Straal0,Straal1,Dik)}
    cylinder{<0,0,-0.1><0,0,Dik+0.1>,Rgat1}
  }
  cylinder{<0,0,0><0,0,Dik>,4}
  box{<-1.5,-Rgat1,0><1.5,Rgat1,Dik>}
  box{<-Rgat1,-1.5,0><Rgat1,1.5,Dik>}
  texture{Brons}
}
//--------------------
#declare Tandwiel_7_1=
  #declare Tanden=10;
  #declare Straal0=4;			//binnenstraal tanden
  #declare Straal1=2;			//buitenstraal tanden
  #declare Dik=5;			//dikte tandwiel
  object{Tandwiel(Tanden,Straal0,Straal1,Dik)
  texture{Staal}
}
//--- as 8 -----------------------------------------------
#declare As8=				//as met vlinder
union{
  cylinder{<0,0,56><0,0,89>,0.5}
  cylinder{<0,0,54.7><0,0,92>,0.2}
  texture{Staal2}
}
//--------------------
#declare Tandwiel_8_0=
  #declare Tanden=10;
  #declare Straal0=4;			//binnenstraal tanden
  #declare Straal1=2;			//buitenstraal tanden
  #declare Dik=5;			//dikte tandwiel
object{Tandwiel(Tanden,Straal0,Straal1,Dik)
  texture{Staal}
}
//--------------------
#declare Vlinder=
union{
  box{<-0.10,-14,2><0.10,14,16>}
  sphere{<0,0,2>,2}
  cylinder{<0,0,2><0,0,16>,2}
  box{<-Wortel2,-Wortel2,16><Wortel2,Wortel2,16.1>
    rotate <0,0,45>
    scale<2,7,1>
  }
  texture{Brons}
}


//--- stangen en platen ----------------------------------
#if (Mooi=true) //--- mooie of simpele stangen ---
//--- horizontale stang ---
#declare Pilaar= sphere_sweep{
  b_spline
  6
  <0,0,-1>,0
  <0,0, 0>,2
  <0,0, 5>,5
  <0,0,24>,1
  <0,0,36>,3
  <0,0,41>,2
}

#declare Stang=
union{
  sphere{<0,0,-39>,3}
  object{Pilaar                 translate <0,0, 3>}
  sphere{<0,0,0>,4}
  object{Pilaar rotate<0,180,0> translate <0,0,-3>}
  sphere{<0,0, 39>,3}
}

#declare Staander=
union{
  box{<-6,0,-6><6,4,6>}
  sphere{<0,  5,0>,6}
  sphere{<0, 10,0>,3}
  sphere{<0, 14,0>,3}
  sphere{<0,0,0>,5 scale<1,0.5,1> translate <0, 16,0>}
  intersection{
    box{<-5,18,-5><5,38,5>}
    sphere{<0,0,0>,4 scale<1,5,1> translate<0,28,0>}
  }
  sphere{<0,0,0>,5 scale<1,0.5,1> translate <0, 40,0>}
  sphere{<0,0,0>,4 scale<1,1  ,1> translate <0, 42,0>}
  sphere{<0,0,0>,5 scale<1,0.5,1> translate <0, 47,0>}
  sphere{<0,0,0>,4 scale<1,1  ,1> translate <0, 49,0>}
  sphere{<0,0,0>,5 scale<1,0.5,1> translate <0, 54,0>}
  sphere{<0,0,0>,4 scale<1,1  ,1> translate <0, 56,0>}
  sphere{<0,0,0>,4 scale<1,0.5,1> translate <0, 61,0>}
  sphere_sweep{
    b_spline
    7
    <0, 62,0>,2
    <0, 64,0>,4
    <0, 67,0>,4
    <0, 98,0>,2
    <0,102,0>,2
    <0,110,0>,4
    <0,113,0>,2
   }

  sphere{<0,116,0>,6}
  box{<-6,119,-6><6,122,6>}
}
  
#else //--- mooie of simpele stangen ---
  #declare Stang=
    cylinder{<0,0,-43><0,0,43>,3}			//hor. steun
  #declare Staander=
    cylinder{<0,0,0><0,122,0>,3}			//vertikaal
#end //--- mooie of simpele stangen ---

//--- platen ---
union{
  difference{						//bodemplaat
    box{<0,0,0><120,2,100>}
    cylinder{<32,-0.1,25><32,2.1,25>,8}			//ketting gat
    cylinder{<88,-0.1,25><88,2.1,25>,8}
    cylinder{<40,-0.1,47><40,2.1,47>,8}
    cylinder{<80,-0.1,47><80,2.1,47>,8}
    cylinder{<40,-0.1,80><40,2.1,80>,8}
    cylinder{<80,-0.1,80><80,2.1,80>,8}
  }
  box{<0,2,0><14,122,3> translate<60-7,0,15>}		//assen-drager
  box{<0,2,0><14,122,3> translate<60-7,0,55>}
  box{<0,2,0><14,122,3> translate<60-7,0,88>}
  object{Staander translate<16,0,7>}			//steunstaaf
//  difference{
//    object{Staander}
  object{Staander translate<104,0,7>}
//    box{<-10,48,-4><10,68,0>}
//    translate<104,0,7>
//  }
  object{Staander translate<16,0,93>}
  object{Staander translate<104,0,93>}
  object{Stang translate<16,25,50>}			//hor. steun
  object{Stang translate<104,80,50>}
  difference{
    box{<0,122,0><120,124,100>}				//bovenplaat
    box{<60-25,121,43><60+25,125,53>}			//met gat
  }
  texture{Brons}
}
union{							//assen tandwielen
  object{As0             translate<57,72, 0>}
  object{Tandwiel_0_0    translate<57,72,10>}
  object{Tandwiel_0_1    translate<57,72, 1>}

  object{As1             translate<60,39, 0>}
  object{Kettingwiel     translate<60,39,45>}
  object{Ketting         translate<60,39,47.5>}
  object{Tandwiel_1_1    translate<60,39,40>}
  object{Tandwiel_1_2    translate<60,39,10>}
  object{Tandwiel_1_3    rotate<0,0,20>  translate<60,39, 0>}

  object{As2             translate<60,70, 0>}
  object{Tandwiel_2_0    translate<60,70,40>}
  object{Tandwiel_2_1    translate<60,70,22>}

  object{As3             translate<60,97, 0>}
  object{Tandwiel_spike  rotate<90,0,0> rotate<0,0,8> translate <60,97,45>}
  object{Tandwiel_3_1    translate<60,97,21>}

  object{Asp             translate<60,126,0>}
  object{Spikes          translate<60,126,45>}

  object{As5             translate<56,32,0>}
  object{Kettingwiel     translate<56,32,79>}
  object{Ketting         translate<60,32,81.5>}
  object{Tandwiel_5_1    translate<56,32,72>}

  object{As6             translate<56,62,0>}
  object{Tandwiel_6_0    translate<56,62,71.5>}
  object{Tandwiel_6_1    translate<56,62,63>}

  object{As7             translate<56,85,0>}
  object{Tandwiel_7_0    translate<56,85,79>}
  object{Tandwiel_7_1    translate<56,85,62.5>}

  object{As8             translate<56,107,0>}
  object{Tandwiel_8_0    translate<56,107,78>}
  object{Vlinder         rotate<0,0,20> translate<56,107,59>}
}
union{					//trigger voor slagwerk
  difference{
    box{<-7,0,0><20,15,3>}
    box{<-10,0,-1><25,15,4> rotate<0,0,15> translate<0,5,0>}
  }
  cylinder{<0,0,0><0,0,3>,2}
  difference{
    cylinder{<0,0,0><0,0,-2>,2}
    box{<-3,-0.5,-3><3,0.5,-2>rotate<0,0,45>}
  }
  intersection{
    torus{5,1.5}
    box{<-7,-2,-7><0,2,0>}
    translate<-7,1.5,7>
  }
  cylinder{<-12,1.5,7><-12,1.5,17>,1.5}
  cylinder{<-12,1.5,7><-12,1.5,8>,10}
  cylinder{<-12,1.5,8><-12,1.5,15>,3}
  cylinder{<-12,1.5,15><-12,1.5,16>,10}
  rotate<0,0,-35>
  translate<58,104,12>
  texture{Brons}
}
//box{<0,0,0><55,4,3>			//trigger voor slagwerk
//  rotate<0,13,0>
//  rotate<0,0,-20>
//  translate<55,95,12>
//  texture{Brons}
//}
//union{					// liggende ketting
//  object{KettingSchakel translate<0,0,0>rotate<0,0,0> translate<0,-8*Incr,0>}
//  texture{Brons2}
//}
