// the diving bell guy.




#ifdef (INCLUDAGE)
#local RenderThisFileAlone = no;
#else
#local RenderThisFileAlone = yes;
// change if working on file:
#local BELL_WORKING_CAMERA = yes;
#end

#ifndef (HARD_EDGES)
#local HARD_EDGES = no;
#end

#ifndef (BUBBLY)
#local BUBBLY = yes;
#end

#ifndef (RAD)
#local RAD = no;
#end

#local heads =  2.8 / 8.5 ; // to measure in heads.

#local YARDSTICK = no;
#local YARDSTICK_POS = 
transform {	
	rotate <0, 180 , 0>
//	translate <-1.8,.6,0>
//translate <-1.9, 1.25, .3> // neck
//translate <-1.9, 1.25, .0> // neck
		translate <0, 1.44, 0>

}


#declare INCLUDAGE = 1; 

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "woods.inc"
#include "right_stuff_textures.inc"
#include "bubbleblast.inc"

#include "bellboy.inc"




#declare bell_wood=
material {texture {T_Wood5 scale 1.5   rotate x *90} } //T_Wood5 7 23 15


#macro riviteer (height) // a macro to make rivets in bell.
	// assuming the radii below
	#local theDist = ((1.5 - height)/2) * .35 + .65;   // 1 .65
	#local counter = 0;
	union {
	#while (counter < 360)
		sphere {<0, height, 0>, .02 translate z*theDist rotate y*counter }
	#local counter = counter + 20;
	#end
		material {crusty_rusty}
	}
#end

#declare bellboy=
union {
	mesh {Figure material {Skin} 
			translate y* ( - .00787) // place on origin
			scale 1.8/.420300 // comparable to others
			translate y * -1.127820 // place to ground.
			} 
	
	union { 
		difference { // the simple bell.
			union {
			#local aSeed = seed (23);
			#local counter = 0;
			#while (counter < 360)
				box {<-.15, -.5, -.05>, <.15, 1.5, .05>
				material {bell_wood rotate <rand(aSeed) * 5, rand(aSeed) * 80, rand (aSeed) *5>
					translate <rand(aSeed) * 20, rand(aSeed) * 20, rand (aSeed) *10>}
					translate y* ((rand(aSeed) - 1) * .05) // mess 'em up a bit.
					rotate x * 10
					translate z*-.82
					rotate y * counter
				}
				#local counter = counter  + 20;
			#end
			}
			
//			cone {
//				<0.0, -0.5, 0.0>, 1, <0.0, 1.5, 0.0>, 0.6
//			}
//			cone { // inside
//				<0.0, -0.6, 0.0>, .95, <0.0, 1.4, 0.0>, 0.55
//			}
		
			cylinder { // eye holes
				<0, 1, -2>, <0, 1, 0>, .1
				rotate y * -25
			}
				cylinder { // eye hole 2
				<0, 1, -2>, <0, 1, 0>, .1
				rotate y * 25
			}
			
//			material {castIron}
			
	
		}
		
		union { // the rivets
			difference {
				cone { // metal band
					<0.0, -0.5, 0.0>, 1, <0.0, 1.5, 0.0>, 0.65
				}		
				box {<-2, -1, -2> <2, -.25, 2>}
				box {<-2, 1.8, -2> <2, -.1, 2>}
			}
			riviteer(-.175)
			difference {
				cone { // metal band (top
					<0.0, -0.5, 0.0>, 1, <0.0, 1.5, 0.0>, 0.65
				}		
				box {<-2, -1, -2> <2, 1.4, 2>}
//				box {<-2, 1.8, -2> <2, 1.75, 2>}
			}
			riviteer(1.45)

			difference {
				cone { // metal band
					<0.0, -0.5, 0.0>, 1, <0.0, 1.5, 0.0>, 0.65
				}		
				box {<-2, -1, -2> <2, .35, 2>}
				box {<-2, 1.8, -2> <2, .50, 2>}
			}
				riviteer(.425)
		
			material {castIron}
		}
		
		// eye hole glass
		union {
			cylinder { // eye holes
				<0, 1, -1.2>, <0, 1, -1.1>, .1
				rotate x*2
				translate <0, -.04, .48 >
				rotate y * -25
			}
			cylinder { // eye hole 2
				<0, 1, -1.2>, <0, 1, -1.1>, .1
				rotate x*2
				translate <0, -.04, .48 >
				rotate y * 25
			}
	
			material {
			texture 
				{Yellow_Glass		
						normal {
							bumps .2
							scale .1 
						}
				}			
			}	
		}
	
		// eye hole gaskets
			torus { .09, .03 rotate x * 92
				translate <0,1, -1.18>
				rotate x*2
				translate <0, -.04, .48 >
				rotate y * -25
				material {castIron}				
			}
			torus { .09, .03 rotate x * 96
				translate <0,.98, -1.18>
				rotate x*2
				translate <0, -.04, .48 >
				rotate y * 25
				material {castIron}				
			}
				// rotate to make more natural
		rotate <-8, -5,6>
//			translate < 2.2, .3, -.8>
	}

	translate z*1.5
} // whew! end of bellboy union




#if (RenderThisFileAlone)

global_settings
{
  assumed_gamma 1.0
	#if (RAD)
	radiosity {}
	ambient_light 0.005
	#end
}


camera
{
  location  <-.6, 0.6, -8.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-.6, 0.3,  0.0>
}

#ifdef (BELL_WORKING_CAMERA)
#if (BELL_WORKING_CAMERA)
camera // working camera
{
	location <0, .5, -5.0>  
  direction 1.5*z
  right     4/3*x
  look_at   <0, .5,  0>
}
#end
#end

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-60, 60, -60>
}

plane { y, -1 pigment {color rgb <0.3,0.5,0.7>}}


object {bellboy}
#end



