// the copyright gel.

#ifdef (INCLUDAGE)
#local RenderThisFileAlone = no;
#else
#local RenderThisFileAlone = yes;
#end


#macro copyrightLight(Color, Size)
union {
//sphere {0, .02 pigment {Blue}}
	light_source {
		<0.0, .0001, 0>
		rgb Color
		cylinder
	 	point_at <0.0, 0,0>
		radius Size / 2
		falloff  Size/2
		tightness 0
		media_interaction off
	}

	difference { // the gel
			cylinder {
				z * -.01, z * .01, .5
			}
		//	box {<-.1, -.1, .05>, <1, 1, .06> translate y * -.5}
			text {
				ttf "sfcomic.ttf",
				"(c)2003 Jeremy Harris"
				1, <0.0, 0.0, 0.0>
				translate z * -.5
				scale .09
				translate x * -.5
				bounded_by {box {<-.5, -.1, -.05>, <.5, .1, .05>}} // speed render
			}
				scale Size
			rotate x *90
			 pigment {rgb Red}
			}
			rotate x * -90
	}


#end // macro

#if (RenderThisFileAlone)

#version 3.1;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

//light_source
//{
//  0*x // light's position (translated below)
//  color red 1.0  green 1.0  blue 1.0  // light's color
//  translate <-30, 30, -30>
//}

// ----------------------------------------
plane
{
  y, -1
  texture
  {
    pigment {checker color rgb 1 color blue 1 scale 0.5}
    finish {reflection 0.2}
  }
}

object {copyrightLight(Blue, 1) rotate x * 90}


#end // render this file alone


