// instantiate davinci suit
// and take some liberties in the way it looks!


// are you rendering just this file? simply render. (changes camera, landscape, etc.)
// are you including it instead?
// make a #declare INCLUDAGE in the main file to suppress camera definitions, etc..

#ifdef (INCLUDAGE)
#local RenderThisFileAlone = no;
#else
#local RenderThisFileAlone = yes;
// change if working on file:
#local LEO_WORKING_CAMERA = yes;
#end

#ifndef (HARD_EDGES)
#local HARD_EDGES = no;
#end

#ifndef (BUBBLY)
#local BUBBLY = yes;
#end

#ifndef (RAD)
#local RAD = no;
#end

#local heads =  2.8 / 8.5 ; // to measure in heads.

#local YARDSTICK = no;
#local YARDSTICK_POS = 
transform {	
	rotate <0, 180 , 0>
//	translate <-1.8,.6,0>
//translate <-1.9, 1.25, .3> // neck
//translate <-1.9, 1.25, .0> // neck
		translate <0, 1.44, 0>

}


#declare INCLUDAGE = 1; 

#include "metals.inc"
#include "textures.inc"
#include "right_stuff_textures.inc"
#include "bubbleblast.inc"

#include "leoHelmet.inc"
#include "davinci.inc"

#local mySeed = seed(32034923);

#declare gloveLeather=
material {
		texture{
		pigment {
			dents
			color_map {
				[ 0.000000 rgb <0.229999, 0.148165, 0.089708> ]
				[ 0.300000 rgb <0.179995, 0.179995, 0.179995> ]
			}
			scale <.2, .2, .2>
		}
		normal {
			bumps .2
			scale <.02, .02, .02>
		}
		finish {
			diffuse 1
			specular .2
			roughness 0.064
		}
	}
}

#declare bagMaterial = 
	gloveLeather
#declare strapMaterial = 
	helmetLeather

#if (RenderThisFileAlone)

global_settings
{
  assumed_gamma 1.0
	#if (RAD)
	radiosity {}
	ambient_light 0.005
	#end
}


camera
{
  location  <-.6, 0.6, -8.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-.6, 0.3,  0.0>
}

#ifdef (LEO_WORKING_CAMERA)
#if (LEO_WORKING_CAMERA)
camera // working camera
{
	location <0, .5, -5.0>  
  direction 1.5*z
  right     4/3*x
  look_at   <0, .5,  0>
}
#end
#end

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-60, 60, -60>
}

plane { y, -1 pigment {color rgb <0.3,0.5,0.7>}}

#if (YARDSTICK)
	#local yardstick =  // a 1- unit yardstick
	union {
	#local counter = 0;
	#while (counter < 11)
	#local dist = counter * .1;
	#local sizer = 
		#if (mod(counter,5) = 0) 
			.03;
		#else
			.02;
		#end
	
		sphere {<0, dist, 0> sizer}
		sphere {<dist, 0, 0> sizer}
		sphere {<0, 0, dist> sizer}

//		sphere {<0, dist, 0> * -1 sizer}
//		sphere {<dist, 0, 0> * -1 sizer}
//		sphere {<0, 0, dist> * -1 sizer}

		#local counter = counter+1;
	#end
	texture {pigment {color Yellow * 1.5}}
	transform {YARDSTICK_POS}
	}
	
	object {yardstick}

#end // yardstick

#declare davinciTransform = 
transform {
		translate <0,0,0>
}


#else // position for scene
#declare davinciTransform = 
transform {
	translate x * .75}

#end // render this file alone

#declare davinci =
union {
	object {leoHelmet scale 2.8/8 // he's 8.5 heads high.
		rotate y * 16 // look with the head.
		translate y*1.44
		translate z * -.39
		translate x * .09
	} 
	
	union { // all exterior objects
		mesh {head_1 material {Skin}}
	
		
		union {
		
			mesh {shirt_breast}
			mesh {sleeve_right }
			mesh {sleeve_left }
			mesh {pants_right }
			mesh {pants_left}
	
			
			material {helmetLeather}
			
		}
		union {
			mesh {lHand_1 }
			mesh {rHand_1}
			material {gloveLeather}
		
		}
		union {
			mesh {strap_right }
			mesh {belt }
			mesh {belt_loop}
			mesh {strap_left}
			material {strapMaterial}
		}
		union {
		
		mesh {bag_left}
		mesh {clasp_left}
		mesh {clasp_right}
		mesh {bag_right}
		material {bagMaterial}
		}
	
		scale 2.8 / 6.577870 // comparable to others
		translate y*-1 // place to ground.
	
	}
#if (BUBBLY)	
	union {// right bag
		object { BubbleBlast(.3, 2, 1.65, 20, .001, mySeed) 
					rotate x * 40 translate < -.5 * heads, 2 * heads, 0>}
			// left bag
		object { BubbleBlast(.3, 2, 1.65, 15, .002, mySeed) 
					rotate x * 60 translate < 1.5 * heads, 2 * heads, -.8 * heads>}

			// bubble trail
		object { BubbleBlast(4 * heads, 2, .65, 130, .010, mySeed) 
					rotate x * 80 translate < 0 * heads, 3 * heads, 1 * heads>}
	
		// helmet
		object { BubbleBlast(2 * heads, 2, .65, 120, .006, mySeed) 
					rotate <30, 0, -60> translate < 0 * heads, 5 * heads, -1.8 * heads>}
			// front fizzle
		object { BubbleBlast(1 * heads, 2, .1, 120, .002, mySeed) 
					rotate x * -90  translate < 0 * heads, 4.5 * heads, -2.5 * heads>}
	


	
	material {air_bubble_mat}  
	}
#end

	
	transform {davinciTransform}

}

#if (RenderThisFileAlone)
object {davinci}
#end
//sphere {y*-1, 1 pigment {Red}}

