
// this is a helmet that is .5 units wide (not including gating),
// a collar that is beneath the helmet: 
// 1.16 units tall. the bottom center is at 0,0,0
#version 3.1;

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
// Don't have all of the following included at once, it'll cost memory and time
// to parse!
#include "skies.inc"

#include "METALS.INC"   // Metallic pigments, finishes, and textures

// set to "yes" to see the helmet in a render:

#ifdef (INCLUDAGE)
#local renderThisFile = no;
#else
#local renderThisFile = yes;
#end


#ifndef (RAD)
#declare RAD = no;  // radiosity?
#else
#declare Rad_defined = 1 ;
#end

#declare shell_material=
material {
texture { pigment { 
	#if (RAD)
		P_Copper3 
	#else
		P_Copper3 
	
	#end
	} 

	normal {
		dents 1.8
		scale .2
//		translate <.2, .1, 0>
	}
finish {
	#if (RAD)
	    ambient 0.08
		diffuse .8 
	#else
		ambient 0.30
		diffuse .4
	#end    
	brilliance 3 //3
    metallic
    specular 0.90
    roughness 1/60
    reflection 0.15
}
	//finish { F_MetalB  } 
	}
}


#declare gate_material=
material {texture { pigment { P_Copper1 * .75 }  // a bit more contrast

	normal {
		dents 2
		scale .2
	}

finish {
	#if (RAD)
		ambient 0
		diffuse .6
	#else
    	ambient 0
   		diffuse 0.2
	#end
    brilliance 2
    metallic
    specular 0.80
    roughness 1/20
    reflection 0.1
}

//	finish { 	F_MetalA  } 
	}
}

#declare helmetShell = 
difference {
// outer shell
	difference {
		union {
			sphere { <0,0.5,0>, .5}
			cylinder {
				<0.0, -.1, 0.0>, <0.0, .5, 0.0>, .5
			}
		}
		union {
			sphere { <0,0.5,0>, .45}
			cylinder {
				<0.0, -1.08, 0.0>, <0.0, .5, 0.0>, .45
			}

		}
	}
// side holes
	cylinder {
		<0, .25, 0>, <.6, .25, 0.0>, .2
		rotate y*20
	}
		cylinder {
		<-.6, .25, 0>, <0, .25, 0.0>, .2
		rotate y*-20
	}
// front hole
	cylinder {
		<0, .25, 0>, <0, .25, -.6>, .25
	}
	material {shell_material}
// texture {T_Brass_3A}
}

// the cage in front of port hole on helmet:
#declare unitBox = 
box { <-.5, -.5, -.5>, <.5, .5, .5>}
//superellipsoid {
//	< 0.8, 0.8 >
//	scale .5
//}


#declare thickener = .05;
#declare thickenerZ = 1;
#declare tic_tac_toe =
intersection {
	difference {
		union {
		box { unitBox scale <1,thickener,thickenerZ> translate y/6}
		box { unitBox scale <1,thickener,thickenerZ> translate -y/6}
	
		box { unitBox scale <thickener,1,thickenerZ> translate x/6}
		box { unitBox scale <thickener,1,thickenerZ> translate -x/6}
		
		}
//	box {unitBox scale <1.1,.18, 1.1>} // cut so guy can see thru it.
	sphere {<0,0,.5>, .1} // inner curve
	}
	sphere {<0,0,.5>, .5} // outer curve
}

#declare portOuterRing = 
// porthole front:
intersection {
difference {
	cylinder { // outer
			<0, .25, 0>, <0, .25, -.6>, .25
		}
	cylinder { // inner
			<0, .25, 0>, <0, .25, -.65>, .18
		}
	}
	
	/// follow the curve of the shell:
				cylinder {
				<0.0, -.1, 0.0>, <0.0, .5, 0.0>, .53
			}

material {gate_material}
}

#declare portRivets = 
// rivets:
union {
#declare portRadius = .21;

#declare aCount = 0;
#while (aCount < 360)
sphere {<0, 0, 0>, .02 translate x*portRadius rotate z*aCount 
		// account for curvature:
		translate .035 * abs(cos(radians(aCount))) * z }
#declare aCount = aCount + 45;
#end
material {gate_material}
//	texture {T_Brass_2B}
	translate <0,.25, -.52>
}
#declare portGlass = 
	cylinder {
		<0, .25, -.4>, <0, .25, -.48>, .2
		texture {NBoldglass}
//		texture {NBglass}
	}

#declare portHole = 
union {
	object {portRivets}
	object {portOuterRing}
	object {portGlass}
object {tic_tac_toe material {gate_material} scale <.5,.57,.25>*.85 translate <0, .25, -.58>}
}

#declare portHoles = 
union {
// front port:
object {portHole}
// sides:
object {portHole scale <.8, .8, 1>  rotate y*70 translate y*.05}
object {portHole scale <.8, .8, 1>     rotate y*-70 translate y*.05}
}

#declare gaskets = 
// gasket around neck:
union {
	torus {
		0.5, 0.005
		sturm
		scale <1,4,1>
		translate y*-.1
	}
	// beneath:
	torus {
		0.5, 0.004
		sturm
		scale <1,4,1>
		translate y*-.14
	}
material {gate_material}
//		texture {T_Brass_4A}
}
//object {tic_tac_toe texture {T_Brass_1A} scale <.6,.57,.25>*.85 translate <0, .25, -.58>}

#declare galeaCollar = 
union{
	intersection {
		difference { // curve of saddle.
			cylinder {
				<-.5, 0, 0.0>, <.5, 0, 0>, 0.5
			}
			cylinder {
				<-.5, 0, 0.0>, <.5, 0, 0>, 0.49
			}
			box { // cut bottom half
				<-.6, -.6, -.6>, <.6, 0, .6>
			}
//			scale <1, 2, 1> // more slope for breastplate
//			translate y*-1
		}
		cylinder { // cut of saddle
			<0, 1, 0.0>, <0, -1, 0>, 0.5
			scale <1, 1, .8>
		}
		scale <2,1,2>
	}
	difference { // the neck
sor {
	4, 
	<0.34416, -0.06536>,
	<0.70130, 0.35948>,
	<0.50000, 0.54248>,  // top
	<1.03247, 1.15686>
	sturm
}


			cylinder { // bottom limit
			<-.5, 0, 0.0>, <.5, 0, 0>, 0.49
		}
	}
	
material {shell_material}
//		texture {T_Brass_3A}
	translate y* (-.14 - 0.62 + .085 ) // line up with gasket
}



#declare galeaHelmet = 
union {
	object{helmetShell}
	object {portHoles}
	object {gaskets}
	object {galeaCollar}
	translate y*.1 + .06 // zero it up.
}

// for rendering quickly:
#declare galeaHelmetShell =
union {
	object {helmetShell}
	object {gaskets}
	object {galeaCollar}
	translate y*.1 + .06 // zero it up.
}	
	
	
	
	
#if (renderThisFile)
#if (RAD)
#ifndef (Rad_defined)
#include "rad_def.inc"
#end
#end	

global_settings
{
  assumed_gamma 1.0
	#if (RAD)
	#ifndef (Rad_defined) // assume they're set up elswhere
		radiosity { Rad_Settings(Radiosity_Normal, on, off)}
	#end
	#end
}


#if (RAD) // show a card to illustrate radiosity
	box {
		<-1.5, 0, .6> <4, .2, .7>
		texture {pigment {White}}
		rotate y * -89
	}

#else
	box {
		<-1.5, 0, .6> <4, .2, .7>
		texture {pigment {White} } 
		rotate y * -89
	}
#end
	
// ----------------------------------------
camera
{
  location  <0, 0.2, -4.0>
 // direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.3,  0.0>
	angle 33
}

sky_sphere
{ S_Cloud1
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane { y, -.5 pigment {color rgb <0.7,0.5,0.3>}}
	
object {galeaHelmet}
//	object {galeaHelmetShell}
#end
