

#ifndef (__right_stuff_texturesH)
#declare __right_stuff_texturesH = 1;

#include "colors.inc"
#ifndef (RAD)
#local RAD = no;
#end


#if (RAD)
#local coef = 1; // lower for more contrast in some textures.
#else
#local coef = 1;
#end


#ifndef (BUBBLE_REFLECTION)
#declare BUBBLE_REFLECTION = yes;
#end

#declare Rubber_Mat=
//material {
//		texture{
//		pigment {
//			rgb <0.237049, 0.223987, 0.279988>
//		}
//		finish {
//			ambient rgb <.149981, .149981, .149981>
//			reflection {
//				rgb <.02, .02, .02>,
//				rgb <0.0, 0.0, 0.0>
//			}
//			diffuse 0.2
//			specular .5
//		}
//	}
//}
material {
		texture{
		pigment {
			rgb <0.285832, 0.280003, 0.349996> *.5
		}
		normal {
			wrinkles .1
			scale <.03, .2, .03>
		}
		finish {
			#if (RAD)
				ambient 0
			#else
				ambient rgb <.149981, .149981, .149981>
			#end
			reflection {
				rgb <.02, .02, .02>,
				rgb <0.0, 0.0, 0.0>
			}
			diffuse 0.3
			specular .3
		}
	}
	scale .5
}

#declare Skin =
material {
	//Layer: splotch
//
	texture{
		pigment {
			bumps 
			color_map {
				[ 0.000000 rgb <1.000000, .55, 0.370001> ]
//				[ 0.500000 rgb <0.7, 0.350019, 0.000000> ]
				[ 1.000000 rgb <0.930014, 0.440009, 0.1> ]
			}
//			turbulence 3
			scale .065
					}
			finish {
			specular .02
			roughness 0.02 
			diffuse .2 // .8
		}	
	}
	//Layer: color
	texture{
		pigment {
			dents
			color_map {
				[ 0.000000 rgbf <.90, 0.67, 0.50, 0.200000> ]
				[ 1.000000 rgbf <0.85, .60, .50 , 0.200000> ]
			}
			scale .1 //<.03, .03, .03>
		}
		normal {
			bumps .07
			scale  .01 //<.01, .01, .01>
		}
		finish {
			specular .15
			roughness 0.02
			diffuse .4 // .6
		}
	}
}



#declare air_bubble_mat2=  // basically clear; just warps light behind it.
material {
	
	texture {pigment {Clear}
//	pigment { rgb <.8, 1, .8>  filter .3 transmit 1 /* .2 */  quick_color <.8,.8,.8>} 
	    finish {
//	 brilliance 6
	    diffuse 0
	ambient 0
//	    metallic
	    specular .01
//	    roughness  1/120
	    reflection .05
	conserve_energy
		 }
		}
	interior {ior 1.33  caustics .2 }
	}
	
#declare air_bubble_mat= // slick mercury looking
material {
	
	texture {pigment {Clear}
	pigment { 
	#if (BUBBLE_REFLECTION)

	rgb <1, 1, 1>  filter .1 transmit .2 /* 1 */  quick_color <.8,.8,.8>} 
	#else
	rgb <1, 1, 1>  filter .1 transmit .4 /* 1 */  quick_color <.8,.8,.8>} 
	#end		
	    finish {
	 brilliance 6
	    metallic
	    specular .8 // .5 
	#if (BUBBLE_REFLECTION)
	    diffuse 0.6 // .7
		reflection .8 //.05
	    roughness  1/120
	#else
		diffuse .9
	    roughness  1/60
	#end
	conserve_energy
		 }
		}
	interior {ior 1.33  caustics .1 }
	}
#declare ropetex = 
material {
		texture{
		pigment {
			granite

			
			color_map {
				[ 0.000000 rgb <0.745098, 0.517647, 0.290196>  * 1.1 *coef ]
				[ 0.200000 rgb <0.789395, 0.699657, 0.430594>  * 1.1 * coef ]
				[ 1.000000 rgb <0.915999, 0.911192, 0.843977>   * 1.1 * coef]
			}
			scale <.05, .05, .05>
		}
		normal {
			gradient <1.0, 0.0, 0.0>
			.18 //amount
			scallop_wave
			turbulence .4
			scale <.04 // distance between clumps
				, .1, .1>
			rotate <0.0, 0.0, 40 >
		}
		finish {
			diffuse .3 / coef
			#if (RAD)
			diffuse .3 / coef
			ambient 0
			#end
		}
	}
}



	
#local lightness =1;
#declare seafloor_tex = 
material {
		texture{
		pigment {
			bozo
			color_map {
				[ 0.000000 rgb <0.935500, 0.889876, 0.764477> * lightness ]
				[ 0.300000 rgb <0.696391, 0.534768, 0.383581> * lightness]
				[ 0.500000 rgb <0.396002, 0.403998, 0.401724> * lightness]
				[ 1.025000 rgb <0.475181, 0.271672, 0.244800> * lightness]
				[ 1.200000 rgb <0.214466, 0.005509, 0.009018> * lightness]
			}
			scale <.3, .3, .3>
		}
		normal {
			bumps .5
		}
		finish {
			irid {
				.3
				thickness 0.02
				turbulence <0.0, 1.0, 0.0>
			}
			diffuse 0.8
			ambient 0
			specular .1
			roughness 0.064
		}
	}
}

#declare crusty_rusty=
material {
		texture{
		pigment {
			granite
			color_map {
				[ 0.000000 rgb <0.534279, 0.351492, 0.245701> ]
				[ 0.200000 rgb <0.214176, 0.110292, 0.065797> ]
				[ 1.000000 rgb <0.203037, 0.103800, 0.106178> ]
			}
			scale <.04, .02, .04>
		}
		normal {
			wrinkles 2
			scale <.01, .01, .01>
		}
		finish {
			specular .35  // .15
			roughness 0.064
			metallic .5
			diffuse .4
		}
	}
}


#declare castIron = 
material {
		texture{
		pigment {
			bozo
			color_map {
				[ 0.000000 rgb <0.181704, 0.189761, 0.229999> * .75]
				[ 1.00000 rgb <0.110000, 0.110000, 0.100000> ]
			}
			scale .2
		}
		normal {
			granite 0.1
			scale .1
		}
		finish {
			diffuse .6
			ambient 0
			specular .4
			roughness 0.014
			metallic .2
			brilliance 2
		}
	}
}

#end
