// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @                                     @
// @         Now in Technicolor!         @
// @                                     @
// @     IRTC topic: Old Technology      @
// @                                     @
// @     Kees-Jan Backhuys (c) 2003      @
// @                                     @
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

// +sr0.76 +ec0.49  emmer & slaklogo
// +sr0.86 +ec0.32  slaklogo
// +sr0.77 +ec0.49 +sc0.41  verfblik

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
# version unofficial megapov 1.0;
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare test_spot = on;
# declare test_spot = off;

# declare area_on = off;
# declare area_on = on;

# declare media_on = off;
# declare media_on = on;

# declare eigen_map = on;
//# declare eigen_map = off;

# declare normal_on = 2;
# declare normal_on = 1;
# declare normal_on = 0;

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare wavetype = frame_number;

# declare ElfPos = < 2, -1, -3.0>;

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare bzaad = seed (321);   // this controls the randomness of the blocks
                                // change it for different block-placement

# switch (wavetype)
  # case (1) # declare tzaad = seed (111); # break
  # case (2) # declare tzaad = seed (222); # break
  # case (3) # declare tzaad = seed (333); # break
  # case (4) # declare tzaad = seed (444); # break
  # case (5) # declare tzaad = seed (555); # break
  # case (6) # declare tzaad = seed (666); # break
  # case (7) # declare tzaad = seed (777); # break
# end

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# include "colors.inc"

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@




// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# macro WT (nummer)
  # switch (nummer)
    # case (1) ramp_wave     # break
    # case (2) triangle_wave # break
    # case (3) sine_wave     # break
    # case (4) scallop_wave  # break
    # case (5) cubic_wave    # break
    # case (6) poly_wave 0.5 # break
    # case (7) poly_wave 2   # break
  # end
# end

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//            blokkenmuur
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare Br = 11;
# declare Ho = 11;

# declare Blokken = union {     // ----------- tellers initieren ------------
                                # declare j = -Ho; # while (j < Ho)
                                  # local i = -Br; # while (i < Br)
                                  
                                    box {<-.5, -.5, -2.5*rand(bzaad)>, <.5, .5, 10> translate <i, j, 0>}
                                
                                // ----------- tellers ophogen -------------------
                                  # local i = i+1; # end // # while i ...
                                # declare j = j+1; # end // # while j ....
                                }


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//         Displacement Pigments
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

// === black & white color_map ========

# declare ZWmap = color_map {[0 color rgb 0][1 color rgb 1]}

// === rainbow color_map in mijnmacroos.inc==============
// 1 for non-repetative pigments like bozo, leopard, wrinkles, etc
// 2 for repetative pigments like gradients, marble, radial, wood, etc
# declare RainBowMap1d = color_map {[0/4 Red][1/4 Yellow][2/4 Green][3/4 Blue][4/4 Med_Purple]}


# declare DisplacePigment = pigment {   quilted control0 -1 control1 1 scale 2/3.5
                                        WT (wavetype)
                                        color_map {ZWmap}
                                        }

# declare Box1Tex = texture {   pigment { // --- zwart-wit ---
                                        onion frequency 5
                                        color_map {[0 rgb 0][1 rgb 1]}
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        }
                                # if (normal_on = 2)
                                normal {onion 0.3 frequency 5 WT (wavetype)
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        }
                                # end
                                finish {brilliance 2}
                                translate <-Br, -Ho, 0>
                                }

# declare Box3Tex = texture {   pigment { // --- customized ---
                                        onion frequency 5
                                        color_map {RainBowMap1d}
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        }
                                # if (normal_on > 0)
                                normal {onion 0.3 frequency 5
                                        warp {displace {DisplacePigment}}
                                        WT (wavetype)
                                        }
                                # end
                                finish {phong 1 phong_size 250 brilliance 2} // reflection 0.1}
                                translate <-Br, -Ho, 0>
                                }


# declare texobjtrans = transform {scale <1.2, 1, 1> rotate -z*15}

# declare TexObj = cylinder   { -z*30, z*30, 3.5
                                transform texobjtrans
                                translate ElfPos + <0, 1.0, 0>
                                }

# declare BxTrb = 0.55;
# declare BoxTex = texture {    pigment_pattern {object {TexObj White, Black}
                                                turbulence <BxTrb, BxTrb, 0>
                                                octaves 2 lambda 6 
                                                }
                                # if (eigen_map)                
                                  texture_map {[0 Box3Tex][1 Box1Tex]}
                                # else
                                  texture_map {[0 Box2Tex][1 Box1Tex]}
                                # end
                                }


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//              the scene
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# declare SpotlightPointAt  = ElfPos + <0, 1.0, 0>;

# declare ScAsL = 35;   // sceneaslengte
# declare SpAsL = 18;   // spotaslengte

# declare SpotTrans  = transform {rotate -y*33 rotate x*60 translate SpotlightPointAt}
# declare SceneTrans = transform {rotate -x*15 rotate y*20 rotate -z*5 translate -y*1}

# declare LichtKleur = color White;

# declare SpotKleur = color Black;
# declare SpotKleur = color LichtKleur*0.15;


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# camera {      location -z*ScAsL
        	up y*image_height right x*image_width
        	angle 25
                }

# declare ABr =  4; // ArealightBreedte 8   4
# declare LAa =  3; // LichtpuntAantal  3
# declare Ada =  1; // adaptive

# light_source {<0, 200, -300> color rgb 0.1 media_interaction off shadowless}

# declare Spot = light_source { -z*SpAsL color LichtKleur*3.5 //6
                
                                # if (media_on)
                                  spotlight radius 35 falloff 5 // this only works when the spotlight is 'inside out
                                # else                          // so with the radius bigger than the falloff
                                  spotlight radius 5 falloff 25
                                # end
                
                                # if (area_on)
                                  area_light x*ABr, y*ABr, LAa, LAa
                                  adaptive Ada jitter
                                  orient circular
                                # end 
                
                                point_at 0
                                transform SpotTrans
                                }

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# if (media_on) // ------------------------

  # declare MyDens = density {  bumps scale <1, 1, 5>*0.3
                                color_map {[0 LichtKleur][0.7 SpotKleur][1 SpotKleur]}
                                turbulence 0.5
                                }

  # media {     scattering {4, rgb 0.05}
                intervals 1
                samples 5
                method 3
                density {MyDens transform SpotTrans transform SceneTrans}
                }
                
  # sphere {0, 100 pigment {Clear} hollow}
  
  # if (test_spot)
     cone {     -z*SpAsL, 0, 0, 1
                pigment {bozo scale <1, 1, 5>*0.2
                        color_map {[0 Red][1 Blue]}
                        translate -z*SpAsL
                        }
                transform SpotTrans
                transform SceneTrans
                no_shadow
                }
  # end

# end // # if (media_on) // ---------------


// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

# union {object {Blokken}
         object {Spot}

         texture {BoxTex}
         transform SceneTrans
         }
