#declare ExitPipeRandom=seed(8080);
#declare NumBlobs=3000;
#declare CompRadius=60;

union {
	#if (ExitWater)
	
	#declare temp=0;

	difference {
		blob {
			threshold 0.85
		#while (temp<NumBlobs)
			sphere {
				VRand_In_Box(
				(HalfChannelWidth*3)*x-(2*HalfChannelWidth+1000)*z,
				(HalfChannelWidth)*x-(2*HalfChannelWidth)*z+y*200, ExitPipeRandom)
				CompRadius, CompStrength
				}
		#declare temp=temp+1;
		#end	
			material { WaterText }
		}
			plane {
				x, HalfChannelWidth
			}
	}
	
	#end
	box {
		(HalfChannelWidth)*x-(2*HalfChannelWidth+3000)*z,
		(HalfChannelWidth+30)*x-(2*HalfChannelWidth)*z+y*270
	}
	box {
		(HalfChannelWidth*3)*x-(2*HalfChannelWidth+3000)*z,
		(HalfChannelWidth*3+30)*x-(2*HalfChannelWidth)*z+y*270
	}
	box {
		(HalfChannelWidth*3)*x-(2*HalfChannelWidth+3000)*z,
		(HalfChannelWidth)*x-(2*HalfChannelWidth)*z+y*5
	}
	translate (WheelRad*-1.3-300)*y+1480*x+5*z
	material { EntryText rotate y*90}
}

		

#declare HalfChannelWidth=HalfChannelWidth/1.414;

union {//Turn corner (forget tilting it)
#declare NumBlobs=3000;

#declare CompRadius=30;
#declare CompStrength=1;

	

	#if (ExitWater)
	
	#declare temp=0;

	difference {
		blob {
			threshold 0.85
		#while (temp<NumBlobs)
			sphere {VRand_In_Box(-x*3*HalfChannelWidth+z*HalfChannelWidth, x*3*HalfChannelWidth+z*-HalfChannelWidth+y*220, ExitPipeRandom), CompRadius, CompStrength}
		#declare temp=temp+1;
		#end	
			material { WaterText }
		}
		union {
			plane {
				-z, -HalfChannelWidth
			}
			plane {
				z, -HalfChannelWidth
			}
			
		}
		#if(Anim)
		translate x*WaterTrans*RealClock
		#end
	}
	
	#end
	
	box {
		-x*3*HalfChannelWidth+z*HalfChannelWidth,
		x*3*HalfChannelWidth+z*(HalfChannelWidth-30)+y*270
	}
	box {
		-x*HalfChannelWidth+z*-HalfChannelWidth,
		x*HalfChannelWidth+z*-(HalfChannelWidth-30)+y*270
	}
	box {
		-x*3*HalfChannelWidth+z*HalfChannelWidth
		x*3*HalfChannelWidth+z*-HalfChannelWidth+y*5
	}
	
	
	translate x*2*HalfChannelWidth
	material { EntryText}
	rotate y*45
	translate (WheelRad*-1.3-300)*y+1500*x
}	

