#declare QWallText=texture {
	pigment {
		colour rgb <.1,.09.09>
	}
}

#if (QuickTexts)
#declare WallText=texture {QWallText}
#end

#declare QFloorText=texture {
	pigment {
		colour rgb <.6, .6, .4>
	}
}

#declare SkirtText=texture {
	pigment {
		bozo 
		colour_map {
			[0.0 colour FloorColour]
			[0.4 colour FloorColour]
			[0.5 colour FloorColour*.2]
			[0.6 colour FloorColour]
			[1.0 colour FloorColour]
		}
	}
	scale 10
}

#declare RoomZ = 1500;
#declare RoomMinX = -1000;
#declare RoomMaxX = 3500;

#declare DoorPosX=1200;
#declare DoorWidth=300;

union{
difference {
	union {
		box {
			x*RoomMaxX+y*-500+z*RoomZ
			x*RoomMinX+y*9000+z*(RoomZ+100)
		}
		box {
			x*(DoorPosX-DoorWidth/2)+y*-1000+z*RoomZ
			x*(DoorPosX+DoorWidth/2)+y*-100+z*(RoomZ+1000)
		}
		texture {WallText}
	}
	union {
		box {
			x*-1100+y*WEH+z*1000
			x*-800+y*WSH+z*2000
		}
		box {
			x*(DoorPosX-DoorWidth/2.2)+y*-1000
			x*(DoorPosX+DoorWidth/2.2)+y*-120+z*(RoomZ+900)
			texture {WallText rotate y*90} texture {pigment {colour rgb 0 transmit .4}}
		}
	}
			
}
	difference {
		box {		// Skirting
		x*RoomMaxX+y*-450+z*(RoomZ-10)
		x*RoomMinX+y*-550+z*(RoomZ+100)
		}
				box {
			x*(DoorPosX-DoorWidth/2)+y*-600
			x*(DoorPosX+DoorWidth/2)+y*-100+z*(RoomZ+1000)
			texture {WallText finish {ambient 0} rotate y*90}

		}	

		texture {SkirtText}
	}
	box {
		x*(DoorPosX-DoorWidth/1.8)+y*-120+z*(RoomZ-30)
		x*(DoorPosX+DoorWidth/1.8)+y*-70+z*(RoomZ+30)
		texture {SkirtText}
	}
		
difference {
	box {
		x*RoomMinX+y*-500+z*RoomZ
		x*(RoomMinX-100)+y*9000+z*400
	}
	box {
		x*-1200+y*WEH+z*1000
		x*-800+y*WSH+z*2000
	}		
	texture {QWallText rotate y*90}
}

box {
	x*RoomMinX+y*-500+z*-RoomZ
	x*(RoomMinX-100)+y*9000+z*-400
	texture {QWallText rotate y*90}
}
box {
	x*1500+y*-500+z*-RoomZ
	x*RoomMinX+y*9000+z*-(RoomZ+100)
	texture {QWallText}
}
box {
	x*RoomMaxX+y*-500+z*-RoomZ
	x*2500+y*9000+z*-(RoomZ+100)
	texture {QWallText}
}
	
box {
	x*RoomMaxX+y*-500
	x*(RoomMaxX-100)+y*9000+z*-RoomZ
	texture {WallText rotate y*90}
}

box {
	x*RoomMaxX+y*-500
	x*2000+y*9000
	texture {WallText}
}
box {		// Skirting
	x*RoomMaxX+y*-450+z*-10
	x*2000+y*-550
	texture {SkirtText}
}

box {
	x*2000+y*-500
	x*2100+y*9000+z*RoomZ
	texture {WallText rotate y*90}
}
box {		// Skirting
	x*2000+y*-450
	x*2100+y*-550+z*(RoomZ-10)
	texture {SkirtText rotate y*90}
}

texture {WallText}
}

 union {
	box {
		RoomMaxX*x-RoomZ*z-500*y
		2200*x+RoomZ*z-750*y
	}
	box {
		500*x-499.999*y-200*z,
		-500*x-749.999*y+200*z
		rotate y*45
		translate x*2050
	}
	box {
		2300*x-500*y+(RoomZ+1000)*z,
		RoomMinX*x-750*y+225*z
	}
	intersection {
		box {
			1625*x-500*y-RoomZ*z,
			-1000*x-750*y-230*z
		}
		plane {
			x+z
			830
		}
	}
box {
	RoomMaxX*x+2000*y+RoomZ*z,
	RoomMinX*x+2005*y-RoomZ*z
}
	
	
	texture {
		FloorText
	}
 }
 
 
 #declare Plank=box {
 	<-350,0,-50>
 	<350,40,50>
 	material {
// 		texture {pigment{colour Green}}
 		YeOldeWoode
 	}
 }
 
 
 object {
 	Plank
 	rotate y*217
 	translate y*-500+z*-790+x*750
 }
 object {
 	Plank
 	rotate y*47
 	translate y*-500+z*-930+x*580
 }
 object {
 	Plank
 	rotate y*67
 	translate y*-460+z*-850+x*700
 }
 