/****************************************************************************
 * Project: This Strange Engine 
 * File:    brickwall.inc
 * Author:  Alcibiade <alcibiade@alcibiade.org>
 * Date:    Feb. 2003
 *
 * Description:
 *   This file contains the macro BrickWall used to draw the background
 *   of the scene
 *
 ****************************************************************************/

#include "functions.inc"

#macro BrickWall ( p_width, p_height )
#local rand1 = seed(1323);
union {
	BrickWall_Bricks(p_width, p_height)
	BrickWall_Mortar(p_width, p_height)
}
#end

#macro BrickWall_Bricks ( p_width, p_height )
union {
#local pos_y = 0;

#while ( pos_y < p_height )
	#local pos_x = -1;

	#while ( pos_x < p_width )
		#local xsize = 1 + rand(rand1) * 2;

		isosurface {
			function {
				f_rounded_box(x,y,z, 0.11, xsize/2, 0.5, 0.5)
				- 0.04 + 0.10 * f_noise3d((pos_x + x) * 15, (pos_y + y) * 15, z * 15) }
			contained_by { box { <-xsize/2, -0.5, -0.5>, <xsize/2, 0.5, 0.5> } }
			max_gradient xsize * 3.0
			translate <pos_x + xsize/2, pos_y + 0.5, 0>
		}

		#local pos_x = pos_x + xsize;

	#end

	#local pos_y = pos_y + 1;
#end

	texture {
		pigment {
			color rgb <0.60, 0.30, 0.20>
		}

		finish {
			ambient 0.03
		}

		normal {
			bumps 0.4
			scale 0.05
		}
	}
}

#end

#macro BrickWall_Mortar ( p_width, p_height )
#local field_sz = 9;

difference {
	box { <-1, 0, -0.47>, <p_width + 1, p_height + 1, -0.52> }

	#local pos_y = 0;
	#while ( pos_y < p_height )
		#local pos_x = -1;

		#while ( pos_x < p_width )
			height_field {
				png "wall_hfield.png"
				rotate 90 * x

				scale <field_sz, field_sz, 0.3>
				translate <pos_x, pos_y + field_sz, -0.65>
			}

			#local pos_x = pos_x + field_sz;

		#end

		#local pos_y = pos_y + field_sz;
	#end


	texture {
		pigment {
			color rgb 0.7
		}

		finish {
			ambient 0.03
		}

		normal {
			agate 0.4
			scale 0.05
		}
	}
}

#end
