/****************************************************************************
 * Project: This Strange Engine 
 * File:    cloth.inc
 * Author:  Alcibiade <alcibiade@alcibiade.org>
 * Date:    Feb. 2003
 *
 * Description:
 *   This file contains the macros used to build the cloth laying on the
 *   crates on the left of the scene
 *
 ****************************************************************************/

#version unofficial MegaPov 1.000000;

#macro WriteClothFile(filename, base1, base2, n1, n2, nlng, ks, ht)
  #debug "\nWriting new cth file\n"
  #fopen file filename write
  #write(file, n1, ", ", n2, ", ", nlng, ", ", ks, ",\n")
  #local l1 = nlng*(n1-1);
  #local l2 = nlng*(n2-1);
  #local st = seed(1234);
  #local i=0;
  #while (i < n1)
    #local j=0;
    #while (j < n2)
      #local tempx = -l1/2 + i*nlng + base1;
      #local tempy = ht + (-1+2*rand(st))*nlng*0.1 + (n1 - j) / 3;
      #local tempz = -l2/2 + j*nlng + base2;
      #write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0,\n")
      #set j=j+1;
    #end
    #set i=i+1;
  #end
  #fclose file
#end


#macro Cloth_01 ( p_environ, p_position, p_size )
#local nb_x = 100;
#local nb_z = nb_x;
#if ( cloth_rebuild )

WriteClothFile("cloth_01.cth", p_position.x, p_position.z, nb_x, nb_z, p_size.x/nb_x , 10, p_position.y)

simcloth {
	environment p_environ
	friction 0
	gravity -0.4 * y
	damping 0.9
	intervals 0.04
	iterations 10000
	input "cloth_01.cth"
	output "cloth_01.cth"
	mesh_output "cloth_01.msh"
	uv_mesh on
	smooth_mesh on
}

#end

mesh {
	#include "cloth_01.msh"
	uv_mapping

	texture {
		pigment { color rgb <0.85, 0.96, 0.92> }
		finish {
			ambient 0.1
			diffuse 1.0
		}
		normal {
			quilted 0.5
		}
	}

	translate 0.2 * y
}

#end
