/****************************************************************************
 * Project: This Strange Engine 
 * File:    cloth.pov
 * Author:  Alcibiade <alcibiade@alcibiade.org>
 * Date:    Feb. 2003
 *
 * Description:
 *   Scene used to display only a cloth for design purposes
 *
 ****************************************************************************/

#include "cloth.inc"

camera {
	location <12, 18, -14>
	look_at  <0,  6,   2>
}

light_source { <20, 20, -40> color rgb 1.0 }

plane {
	y, 0

	texture {
		pigment { color rgb 1.0 }
		finish {
			ambient 0
			diffuse 1
			brilliance 1
		}
	}
}

#local clothenv = sphere { 0, 2 translate 3 * y }

Cloth_01 ( clothenv, <0,6,0>, <10, 0, 10> )


//object { clothenv texture { pigment { color rgb 1. } } }
