/****************************************************************************
 * Project: This Strange Engine 
 * File:    crate.inc
 * Author:  Alcibiade <alcibiade@alcibiade.org>
 * Date:    Feb. 2003
 *
 * Description:
 *   Crate(): Macro building a fully detailled crate used for display
 *   SimpleCrate(): This one builds a simplified crate only used to compute
 *                  cloth interaction
 *
 ****************************************************************************/

#include "colors.inc"
#include "woods.inc"
#include "metals.inc"

#macro Crate()
#local rand1 = seed(12334);
#local T_wood  = texture { T_Wood7 finish { ambient 0.0 } }
#local T_metal = texture { T_Chrome_3C normal { crackle 0.5 scale 0.2 } }

union {
	object { Panneau(<6, 3, 0.20>) }
	object { Panneau(<6, 3, 0.20>) rotate 180 * y translate < 6, 0.2, 3.4>}
	object { Panneau(<3, 3, 0.20>) rotate  90 * y translate < 0, 0.2, 3.2>}
	object { Panneau(<3, 3, 0.20>) rotate -90 * y translate < 6, 0.2, 0.2>}
	object { Panneau(<6, 3, 0.20>) rotate  90 * x translate < 0, 3.2, 0.1>}
	translate <-3, 0, 0>
	scale 3
}


#end

#macro SimpleCrate()
#local rand1 = seed(12334);
#local T_wood  = texture { T_Wood7 }
#local T_metal = texture { T_Chrome_3C }

union {
	object { SimplePanneau(<6, 3, 0.20>) }
	object { SimplePanneau(<6, 3, 0.20>) rotate 180 * y translate < 6, 0.2, 3.4>}
	object { SimplePanneau(<3, 3, 0.20>) rotate  90 * y translate < 0, 0.2, 3.2>}
	object { SimplePanneau(<3, 3, 0.20>) rotate -90 * y translate < 6, 0.2, 0.2>}
	object { SimplePanneau(<6, 3, 0.20>) rotate  90 * x translate < 0, 3.2, 0.1>}
	translate <-3, 0, 0>
	scale 3
}


#end



#macro Panneau ( p_dim )
union {
	#local vy = 0;
	#while ( vy < p_dim.y )
		object { Planche(<p_dim.x, 1, p_dim.z>) translate <0, vy, 0> }
		#local vy = vy + 1;
	#end

	object {
		Planche(<p_dim.y, 0.8, p_dim.z>)
		rotate 90 * z
		translate <0.4 + p_dim.x * 0.25, 0, -p_dim.z>
	}

	object {
		Planche(<p_dim.y, 0.8, p_dim.z>)
		rotate 90 * z
		translate <0.4 + p_dim.x * 0.75, 0, -p_dim.z>
	}
}
#end

#macro SimplePanneau ( p_dim )
union {
	object { SimplePlanche(<p_dim.x, p_dim.y, p_dim.z>) }

	object {
		SimplePlanche(<p_dim.y, 0.8, p_dim.z>)
		rotate 90 * z
		translate <0.4 + p_dim.x * 0.25, 0, -p_dim.z>
	}

	object {
		SimplePlanche(<p_dim.y, 0.8, p_dim.z>)
		rotate 90 * z
		translate <0.4 + p_dim.x * 0.75, 0, -p_dim.z>
	}
}
#end



#macro Planche ( p_dim )
#local nail = cone { -0.04 * z, 0.05, 0.10 * z, 0 }

union {
	superellipsoid {
		<0.12, 0.12>
		translate 1
		scale 0.5 * p_dim
		texture {
			T_wood
			rotate rand(rand1) * 100
			translate rand(rand1) * 100
			scale <1.00, 0.50, 0.50>
		}
	}

	union {
		object { nail translate <p_dim.x * 0.05, p_dim.y * 0.15, 0> }
		object { nail translate <p_dim.x * 0.05, p_dim.y * 0.85, 0> }
		object { nail translate <p_dim.x * 0.95, p_dim.y * 0.15, 0> }
		object { nail translate <p_dim.x * 0.95, p_dim.y * 0.85, 0> }
		texture { T_metal }
	}
}
#end

#macro SimplePlanche ( p_dim )
//superellipsoid {
//	<0.10, 0.10>
//	translate 1
//	scale 0.5 * p_dim
box {
	-0.1, p_dim + 0.1

	texture {
		T_wood
		rotate rand(rand1) * 100
		translate rand(rand1) * 100
		scale <1.00, 0.50, 0.50>
	}
}
#end
